function NEW_CALL( new_fnc: pro_ptr ): lgt_ptr;
{ To generate a dynamic allocation.
}
const
  mdnam = 'NEWC';

var
  idpa:                                ide_ptr;
  newproc:                             pro_ptr;
  ty, target_ty:                       typ_ptr;
  target, lgth1, lgth2, lgtl1, lgtl2,
  lgta,   lgtc,  lgte,   lgtp,  lgtv:  lgt_ptr;
  ish, jsh: integer;

begin
  lgth1 := nil;
  lgth2 := nil;
  lgta  := nil;
  ty    := nil;
  with sy_sym do
  begin
    if sy = lparen then INSYMBOL
                   else SRC_ERROR( mdnam, 22, e_error );
    { Get a pointer expression }
    target := EXPRESSION_TYPE( typ_std[form_pointer] );
    if target <> nil then
    with target^ do
      if lgt_out in lgt_status then            { Pointer object with write access }
        target_ty := lgt_typ;                  { Get the related pointer type }
      if target_ty <> nil then
        with target_ty^ do
          if typ_form = form_pointer then ty := typ_eltype
                                     else ty := nil;

    if ty <> nil then                           { Legal pointer of known type }
    with ty^ do
    begin                                       { Ok for a full allocation }
      if (typ_parmlst <> nil) or typ_hasidsc then      { Management for type with parameter(s) }
      begin                                     { Allocation for a type with formal parameter }
        if typ_subtype then
        begin
          lgtp := typ_actual;
          idpa := typ_parent^.typ_parmlst
        end
        else idpa := typ_parmlst;

        while idpa <> nil do
        with idpa^ do
        begin
          if typ_subtype then                   { When we have a subtype, ... }
          begin
            lgtv := lgtp;                       { ... we take directly the cte. value of each arguments. }
            lgtp := lgtp^.lgt_nxt

(*
;with typ_ide^.ide_name^ do
WRITELN( ' for type id = "', s:l, '" : NEW object with parm = ', typ_parmlst <> nil, ' hasidsc = ', typ_hasidsc );

WRITELN( ' **** ACTUAL LIST **' );
LGT_WRITE_TREE( 2, ty^.typ_actual );
*)


          end
          else
          begin                                 { When we use a schema, we must atke the expression values ... }
            if sy = comma then INSYMBOL;        { ... of each argument. }
            lgte := EXPRESSION_TYPE( ide_typ );
            if lgte^.lgt_kind = lgt_empty then
            with lgte^ do                       { Type parameter is not present }
            begin                               { We must use a default value (cte) }
              lgt_kind := lgt_const;
              lgt_cte  := ide_cteval;
              if lgt_cte = nil then             { Undefined default value for a type parameter }
                SRC_ERROR( mdnam, 126, e_severe );
              VAL_NEW( lgt_cte, nil {unused} );
              lgt_lide := nil;
              lgt_typ := ide_typ
            end;
            if lgte^.lgt_kind <> lgt_const then
            begin { Argument is an expression }
              LGT_NEW( lgtv, ide_typ, lgt_varbl, nil );         { Create a tempoary variable to keep ... }
              ALL_NEW( lgtv^.lgt_alloc, ide_typ, nil, var_tmp );{ ... the expression value ... }
              lgtv^.lgt_nxt := lgte;                            { ... link it with this expression ... }
              LGT_NEW( lgtc, ide_typ, lgt_codep, lgte );        { ... and make a store instruction of expr. in temp. }
              lgtc^.lgt_pcode := pcod_istore;
              { Put all these value/expression in the queue lgth1/lgtl1. }
              if lgth1 = nil then lgth1 := lgtc                 { If the queue is empty, we put as the first ... }
                             else lgtl1^.lgt_nxt := lgtc;       { ... else we attach it to the last. }
              lgtl1 := lgtc                                     { We update the last pointer. }
            end
            else lgtv := lgte                                   { But for cte, we can use it directly. }
          end;

          { Set the dynamic link for the type parameter identifier }
          ide_tlink2 := lgtv;
          ide_tkind  := tpa_dycte;                              (* tpa_eval;  /// *)
          { We prepare the descriptor filling }
          LGT_NEW( lgta, ide_typ, lgt_indir, LGT_LINK( target ) );
          lgta^.lgt_disp := ide_toffset;                        { Set tparam offset }
          if lgtv^.lgt_kind = lgt_const then lgta^.lgt_nxt := lgtv
                                        else lgta^.lgt_nxt := LGT_LINK( lgtv );
          LGT_NEW( lgtv, ide_typ, lgt_codep, lgta );
          lgtv^.lgt_pcode := pcod_istore;

          if lgth2 = nil then lgth2 := lgtv
                         else lgtl2^.lgt_nxt := lgtv;
          lgtl2 := lgtv;

          if typ_subtype then
            if (sy <> comma) and (sy <> rparen) then
              SRC_ERROR( mdnam, 34, e_error );

          idpa := ide_nxt
        end; { While idpa <> nil }


        lgtc := LGT_TYPE_COMPUTE( typ_sizesrv, typ_comp_size, typ_size, nil );

        { We Must generate all parametrized type sub-object of the new allocated object }
        if typ_hasidsc then INIT_D_DYN( ty, target, lgth2, lgtl2, true );

        idpa := typ_parmlst;                    { Do nothing when there is not parametrized object creation }
        { Loop on all type parameter to reset to tpa_sub state }
        while idpa <> nil do
        with idpa^ do
        begin
          ide_tkind  := tpa_sub;
          ide_tlink2 :=     nil;
          idpa       := ide_nxt
        end;

        { New/Newh_entry_proc should be defined by pas$basicdef and pas_*.std file }
        lgta := LGT_NEW_CALL( target_ty, new_fnc, lgtc );

        { We must set the type descriptor }
        target^.lgt_nxt := lgta;                { Link target with the call of NEW }
        { Generate the istore Optional }
        LGT_NEW( lgta, target_ty, lgt_codep, target );
        lgta^.lgt_pcode := pcod_istore;

        { Attach the istore: malloc(n) -> pv }
        if lgth1 = nil then lgth1 := lgta
                       else lgtl1^.lgt_nxt := lgta;
        lgtc^.lgt_nxt := lgth2;                 { Attach it to the descriptor set list }
        LGT_NEW( lgth2, nil, lgt_ctlflow, lgth1 );
        lgth2^.lgt_stm := stm_sequence
      end

{ -------------------------------------------------------------------------------------------------}

      else                                      { Into with ty^ => the object to allocate }

      { Zurich Standard call of new }
      begin                                     { For type without parameters (Standard Pascal NEW call) }
        ish := typ_size;
        if ish <= 0 then SRC_ERROR( mdnam, 130, e_severe );
        if typ_form = form_record then
        begin                                   { Compute the size to allocate }
          lgtc := typ_recvar;                   { Get info. for the first variant }
          if lgtc <> nil then                   { Skip any LINK for derived type definition }
            if lgtc^.lgt_kind = lgt_null then lgtc := lgtc^.lgt_parmlst;
          while (sy = comma) and (lgtc <> nil) do
          begin
            lgta := lgtc^.lgt_parmlst;          { Get the case table pointer }
            lgte := lgta^.lgt_nxt;              { Get the other node }
            INSYMBOL;                           { Gobble up the comma }
            { Get the selector value }
            lgtv := EXPRESSION_TYPE( lgte^.lgt_nxt^.lgt_typ );
            jsh := -1;
            with lgtv^ do
            begin
              if lgt_kind = lgt_const then      { Get the selector value }
                jsh := lgt_cte^.val_ival
              else
                SRC_ERROR( mdnam, 181, e_error );
              LGT_FREE_TREE( lgtv )
            end;
            with lgta^, lgt_cte^ do
            begin                               { With the case table }
              jsh := jsh - lgt_disp;
              if (jsh >= 0) and (jsh < val_size) then
              begin
                jsh := ORD( lgta^.lgt_cte^.val_tab^.lw[jsh] );
                if jsh >= 0 then
                  lgte := lgte^.lgt_nxt^.lgt_nxt;       { Get the first variant ref. }
                while (jsh > 0) and (lgte <> nil) do
                begin
                  jsh := jsh - 1;
                  lgte := lgte^.lgt_nxt
                end;
                if lgte = nil then lgte := lgta^.lgt_nxt
              end
            end;
            with lgte^.lgt_typ^ do
            begin
              lgtc := typ_recvar;
              ish  := typ_size
            end
          end
        end;
        { Generate the istore }
        LGT_NEW( lgth2, target_ty, lgt_codep, target );
        lgth2^.lgt_pcode := pcod_istore;
        lgtc := LGT_NEW_ECONST( typ_std[form_int], ish );
        { new/newh_entry_proc should be defined by pas$basicdef and pas_*.std file }
        lgta := LGT_NEW_CALL( target_ty, new_fnc, lgtc );
        target^.lgt_nxt := lgta
      end
    end
    else                                        { if ty^ = nil then }
    begin                                       { No allocation to do one previous error }
      LGT_FREE_TREE( target );
      SRC_ERROR( mdnam, 180, e_severe )
    end;                                        { if ty^ = nil then };

    if sy = rparen then
      INSYMBOL                                  { Gobble up ")" }
    else
    begin
      SRC_ERROR( mdnam, 23, e_error );
      SKIP_SYMBOL( rparen )
    end
  end;                                          { with sy_sym do };
  NEW_CALL := lgth2
end NEW_CALL;


