/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 264 ) = {{
  9,   9, 116, 114,  97, 110, 115, 112, 111, 115, 101,  64,  64,  47, 104, 111,
109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,
 95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47, 116, 101,
115, 116,  95, 115,  99, 104, 101, 109,  97,  46, 112,  97, 115,  10,  10,  79,
 95,  36, 111, 112, 101,  95,  97, 115, 115,  11,  11,  79,  95,  36, 111, 112,
101,  95, 109, 117, 108, 116,  12,  12, 119, 114, 105, 116, 101,  36, 111,  98,
106, 101,  99, 116,   2,   2,  44,  32,   4,   4,  32,  32,  32, 124,  11,  11,
116, 101, 115, 116,  95, 115,  99, 104, 101, 109,  97,   6,   6,  10,  32,  77,
 49,  91,  32,   2,   2,  44,  32,   5,   5,  32,  93,  32,  61,  32,   6,   6,
 10,  32,  77,  50,  91,  32,   2,   2,  44,  32,   5,   5,  32,  93,  32,  61,
 32,   6,   6,  10,  32,  77,  51,  91,  32,   2,   2,  44,  32,   5,   5,  32,
 93,  32,  61,  32,   6,   6,  10,  32,  77,  49,  91,  32,   2,   2,  44,  32,
  5,   5,  32,  93,  32,  61,  32,   6,   6,  10,  32,  77,  52,  91,  32,   2,
  2,  44,  32,   5,   5,  32,  93,  32,  61,  32,  17,  17,  10,  32,  77,  53,
 32,  61,  32,  77,  49,  42,  77,  52,  32,  61,  32,  91,  32,   2,   2,  44,
 32,   5,   5,  32,  93,  32,  61,  32
}};

/* Define the local static Initialized section. */
static Blk( Ri, 176 ) = {{
  2,   0,   0,   0,   2,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0, 255, 255, 255, 255,   3,   0,   0,   0,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   3,   0,   0,   0,   4,   0,   0,   0,   1,   0,   0,   0,
  1,   0,   0,   0,   2,   0,   0,   0,   3,   0,   0,   0,   5,   0,   0,   0,
  8,   0,   0,   0,  13,   0,   0,   0,  21,   0,   0,   0,  34,   0,   0,   0,
 55,   0,   0,   0,  89,   0,   0,   0, 144,   0,   0,   0,   2,   0,   0,   0,
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   2,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 56 );

/* Declaration of external variables. */
extern V PAS__f_output;




/* Procedure/Function : " transpose "  */
V TEST_SCHEMA_transpose(V Ret, V F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  ((SL *)Ret)[0]=2;
  ((SL *)Ret)[1]=2;
  Rv0=0;
  for( Rf1=((SL *)Ret)[0];Rf1>0;Rf1-- )
  Rv0++;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+11;
  Ra.sl[6]=31; /* line # 31 */
  if (((SL *)F_m)[0]<((SL *)F_m)[1]) Rv1=((SL *)F_m)[0];
  else Rv1=((SL *)F_m)[1];
  Rv2=1;
  for( Rf1=Rv1;Rf1>0;Rf1-- ) {
    Rv3=1;
    for( Rf0=Rv1;Rf0>0;Rf0-- ) {
      ((SL *)Ret)[Rv3*2+Rv2-1]=((SL *)F_m)[Rv2*2+Rv3-1];
      Rv3++;
    }
    Rv2++;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function :  TEST_SCHEMA_PRC_00000000*/
void TEST_SCHEMA_PRC_00000000(V F_d, V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+11;
  Ra.sl[6]=41; /* line # 41 */
  if (((SL *)F_d)[0]!=((SL *)F_s)[0]||((SL *)F_d)[1]!=((SL *)F_s)[1]) {
    Rv0=1;
    for( Rf1=((SL *)F_d)[0];Rf1>0;Rf1-- ) {
      Rv1=1;
      for( Rf0=((SL *)F_d)[1];Rf0>0;Rf0-- ) {
        ((SL *)F_d)[(Rv0-1)*((SL *)F_d)[1]+Rv1+1]=0;
        Rv1++;
      }
      Rv0++;
    }
  }
  else {
    Ra.sl[6]=47; /* line # 47 */
    Rv2=1;
    for( Rf1=((SL *)F_d)[0];Rf1>0;Rf1-- ) {
      Rv3=1;
      for( Rf0=((SL *)F_d)[1];Rf0>0;Rf0-- ) {
        ((SL *)F_d)[(Rv2-1)*((SL *)F_d)[1]+Rv3+1]=((SL *)F_s)[(Rv2-1)*((SL *)F_s)
        [1]+Rv3+1];
        Rv3++;
      }
      Rv2++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function :  TEST_SCHEMA_PRC_00000001*/
V TEST_SCHEMA_PRC_00000001(V Ret, V F_a, V F_b){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register SL Rv0;
  register SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.sl[0]=2;
  Ra.sl[1]=2;
  Rv0=0;
  for( Rf2=Ra.sl[0];Rf2>0;Rf2-- )
  Rv0++;
  ((SL *)Ret)[0]=2;
  ((SL *)Ret)[1]=2;
  Rv1=0;
  for( Rf2=((SL *)Ret)[0];Rf2>0;Rf2-- )
  Rv1++;
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+89;
  Ra.v[5]=Rd.s+11;
  Ra.sl[12]=61; /* line # 61 */
  Rv2=1;
  for( Rf2=((SL *)F_a)[0];Rf2>0;Rf2-- ) {
    Rv3=1;
    for( Rf1=((SL *)F_a)[1];Rf1>0;Rf1-- ) {
      Rv4=0;
      Rv5=1;
      for( Rf0=((SL *)F_a)[1];Rf0>0;Rf0-- ) {
        Ra.sl[12]=66; /* line # 66 */
        Rv4=Rv4+((SL *)F_a)[Rv2*2+Rv5-1]*((SL *)F_b)[Rv5*2+Rv3-1];
        Rv5++;
      }
      Ra.sl[Rv2*2+Rv3-1]=Rv4;
      Rv3++;
    }
    Rv2++;
  }
  TEST_SCHEMA_PRC_00000000(Ret,Ra.s);
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[3];
  return(Ret);
}


/* Procedure/Function : " write_Object "  */
void TEST_SCHEMA_PRC_00000002(V F_m, SL F_p, SL F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+102;
  Ra.v[2]=Rd.s+11;
  Ra.sl[6]=78; /* line # 78 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Rv0=1;
  for( Rf1=((SL *)F_m)[0];Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32, F_s,-1,1,32);
    PAS__WRITE_CHAR(124);
    Rv1=1;
    for( Rf0=((SL *)F_m)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=84; /* line # 84 */
      if (Rv1>1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+116,-1,-1,32);
      }
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_INT(((SL *)F_m)[(Rv0-1)*((SL *)F_m)[1]+Rv1+1],F_p,0);
      Rv1++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+120,-1,-1,32);
    PAS__WRITE_EOLN();
    Rv0++;
  }
  Ra.sl[6]=89; /* line # 89 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_schema "  */
int main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+126;
  Rs.v[2]=Rd.s+11;
  Rs.sl[6]=95; /* line # 95 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+139,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[0],2,0);
  PAS__WRITE_STR(Rd.s+147,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[1],2,0);
  PAS__WRITE_STR(Rd.s+151,-1,-1,32);
  TEST_SCHEMA_PRC_00000002(Ri.s,5,8);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+158,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[6],2,0);
  PAS__WRITE_STR(Rd.s+166,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[7],2,0);
  PAS__WRITE_STR(Rd.s+170,-1,-1,32);
  TEST_SCHEMA_PRC_00000002(Ri.s+24,5,8);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+177,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[17],2,0);
  PAS__WRITE_STR(Rd.s+185,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[18],2,0);
  PAS__WRITE_STR(Rd.s+189,-1,-1,32);
  TEST_SCHEMA_PRC_00000002(Ri.s+68,5,8);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  TEST_SCHEMA_PRC_00000000(Ri.s+124,TEST_SCHEMA_PRC_00000001(Rs.s+28,Ri.s,Ri.s+148));
  Rs.sl[6]=101; /* line # 101 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+196,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[0],2,0);
  PAS__WRITE_STR(Rd.s+204,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[1],2,0);
  PAS__WRITE_STR(Rd.s+208,-1,-1,32);
  TEST_SCHEMA_PRC_00000002(Ri.s,5,8);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+215,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[37],2,0);
  PAS__WRITE_STR(Rd.s+223,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[38],2,0);
  PAS__WRITE_STR(Rd.s+227,-1,-1,32);
  TEST_SCHEMA_PRC_00000002(Ri.s+148,5,8);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+234,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[31],2,0);
  PAS__WRITE_STR(Rd.s+253,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[32],2,0);
  PAS__WRITE_STR(Rd.s+257,-1,-1,32);
  TEST_SCHEMA_PRC_00000002(Ri.s+124,5,8);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
