program TEST_FNC1;

type
    matrix( n, m: integer ) = array[1..m, 1..n] of integer;

    mat33 = matrix( 3, 3 );
    mat22 = matrix( 2, 2 );


    mptr22 = ^mat22;


const
{   gn33 = matrix[ 3, 3, [ 11, 12, 13 ],
                         [ 21, 22, 23 ],
                         [ 31, 32, 33 ]
                 ];
}
    gn33 = mat33[ [ 11, 12, 13 ],
                  [ 21, 22, 23 ],
                  [ 31, 32, 33 ]
                ];

var
    gm33: mat33;
{   gm33: matrix( 3, 3 ); }

    m1, m2, m3: mat22 := [ [  1,  -1 ],
                           [ -1,   1 ]
                         ];

    p22: mptr22 := nil;


function * ( mb, mc: mat22 ): mat22;
var
    s:        integer;
{   m: mat22; }

begin
    for i := 1 to 2 do
    for j := 1 to 2 do
    begin
        s := 0;
        for k := 1 to 2 do
            s := s + mb[i,k]*mc[k,j];
{       m[i,j] := s; }
        function[i,j] := s
    end
end * ;



procedure := ( out_var tg: matrix; in_var sr: matrix );
begin
    if tg.m = sr.m and tg.n = sr.n then
        for i := 1 to tg.m do
        for j := 1 to tg.n do
            tg[i,j] := sr[i,j]
end := ;


(*
procedure := ( out_var tg: matrix( 2, 2 ); in_var sr: matrix( 2, 2 ) );
begin
    for i := 1 to 2 do
        for j := 1 to 2 do
            tg[i,j] := sr[i,j]
end := ;
*)




procedure WRITE$OBJECT( in_var ma: matrix; f: integer := 6 );
var
    mm, mn: integer;

begin
    mm := ma.m; mn := ma.n;
    for i := 1 to mm do
    begin
        WRITE( ' ':8 );
        for j := 1 to ma.n do
        begin
            if j = 1 then WRITE( '| ' ) else WRITE( ', ' );
            WRITE( ma[i,j]:f );
        end;
        WRITELN( ' |' )
    end;
    WRITELN
end WRITE$OBJECT;




begin { MAIN }
    m2 := matrix[ 2, 2, [  0,  1 ],
                        [  1,  0 ]];
    m3 := matrix[ 2, 2, [  1,  0 ],
                        [  0, -1 ]];

    m1 := m2*m3;

    gm33 := matrix[ 3, 3, [ 1, 2, 3 ],
                          [ 4, 5, 6 ],
                          [ 7, 8, 9 ]
                  ];

    NEW( p22 );
    p22^ := m3;

    WRITELN( "\n   p22^ (=m3) =\n", p22^:4, "\n\n" );

    WRITELN( "\n   gn33 =\n", gn33:4, "\n\n" );

    WRITELN( "\n   gm33 =\n", gm33:4, "\n\n" );

    WRITELN( "\n     m2 =\n", m2:4, "\n\n" );

    WRITELN( "\n     m3 =\n", m3:4, "\n\n" );

    WRITELN( "\n     m1 = m2*m3 = \n", m1:4, "\n\n" );


end TEST_FNC1.
