/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 3832 ) = {{
  7,   7, 116,  97,  98,  95, 110, 101, 119,  63,  63,  47, 104, 111, 109, 101,
 50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  78, 101,
119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95, 115,
114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47, 112,  99, 109, 112,
 95, 105, 100, 101, 110, 116,  46, 112,  97, 115,   8,   8, 116,  97,  98,  95,
102, 114, 101, 101,   8,   8, 115, 116, 114,  95,  99, 111, 112, 121,  11,  11,
115, 114,  99,  95, 101, 114, 114, 111, 114,  95, 115,   7,   7, 118,  97, 108,
 95, 110, 101, 119,   8,   8, 118,  97, 108,  95, 102, 114, 101, 101,   4,   4,
 86,  70,  82,  69,  13,  13, 118,  97, 108,  95, 102, 114, 101, 101,  95, 116,
114, 101, 101,   8,   8, 118,  97, 108,  95,  99, 111, 112, 121,   7,   7,  97,
108, 108,  95, 110, 101, 119,   8,   8,  97, 108, 108,  95, 102, 114, 101, 101,
  7,   7, 108, 103, 116,  95, 110, 101, 119,  11,  11,  97, 108, 108,  95, 110,
101, 119,  95, 116, 109, 112,  12,  12, 108, 103, 116,  95, 110, 101, 119,  95,
 99, 111, 112, 121,  13,  13, 108, 103, 116,  95,  99, 111, 112, 121,  95, 116,
114, 101, 101,   8,   8, 108, 103, 116,  95, 102, 114, 101, 101,  13,  13, 108,
103, 116,  95, 102, 114, 101, 101,  95, 116, 114, 101, 101,  14,  14, 108, 103,
116,  95, 110, 101, 119,  95, 101,  99, 111, 110, 115, 116,  15,  15, 108, 103,
116,  95, 110, 101, 119,  95, 101,  99, 111, 110, 115, 116, 114,  14,  14, 108,
103, 116,  95, 103, 101, 116,  95, 101,  99, 111, 110, 115, 116,  11,  11, 108,
103, 116,  95, 105, 109,  97, 115, 107, 112,  50,  12,  12, 108, 103, 116,  95,
110, 101, 119,  95,  99, 111, 100, 101,  12,  12, 108, 103, 116,  95, 110, 101,
119,  95,  99,  97, 108, 108,   8,   8, 108, 103, 116,  95, 108, 105, 110, 107,
 13,  13, 108, 103, 116,  95, 110, 101, 119,  95, 105, 100, 114, 101, 102,  10,
 10, 108, 103, 116,  95, 116, 109, 112, 114, 101, 102,  14,  14, 108, 103, 116,
 95, 110, 101, 119,  95,  97, 100, 100, 115, 117,  98,  14,  14, 110, 101, 119,
 95, 100, 105, 115, 112,  95, 108, 101, 118, 101, 108,   4,   4,  78,  68,  76,
 86,  16,  16, 105, 100, 101,  95, 114, 101, 115, 101, 114, 118, 101,  95, 100,
105, 115, 112,   5,   5, 109,  97, 116,  99, 104,  12,  12, 110, 101, 119,  95,
105, 110, 116,  95, 110,  97, 109, 101,  12,  12, 108, 101, 118, 101, 108,  95,
115, 101,  97, 114,  99, 104,  10,  10, 108, 101, 120,  95, 115, 101,  97, 114,
 99, 104,   9,   9,  97, 110, 121,  95,  99, 108,  97, 115, 115,   7,   7, 105,
100, 101,  95, 110, 101, 119,   4,   4,  78,  69,  87,  73, 107,  29,  10,  10,
105, 100, 101,  95, 115, 101,  97, 114,  99, 104,   4,   4,  83,  82,  67,  73,
 11,  11, 103, 101, 110,  95,  99, 110, 116, 120, 118,  97, 114,  12,  12, 108,
103, 116,  95, 110, 101, 119,  95, 108, 105, 110, 101,  13,  13, 103, 101, 110,
 95, 108, 105, 110, 101, 116, 114,  97,  99, 101,  11,  11, 108,  97,  98, 101,
108,  95, 112, 117, 114, 103, 101,   4,   4,  76,  65,  66,  80,  14,  14, 116,
121, 112,  95,  97, 108, 105, 103, 110, 101, 109, 101, 110, 116,  13,  13, 105,
100, 101,  95, 116, 121, 112,  95,  97, 108, 105, 103, 110,  16,  16,  97, 108,
108,  95, 116, 121, 112,  95,  97, 108, 108, 111,  99,  97, 116, 101,  12,  12,
 99, 116, 101,  95,  97, 108, 108, 111,  99,  97, 116, 101,  11,  11, 105, 100,
101,  95, 110, 101, 119,  95, 116, 121, 112,  17,  17, 105, 100, 101,  95, 110,
101, 119,  95, 116, 121, 112,  95, 114,  97, 110, 103, 101,  15,  15, 116, 109,
112, 115, 116, 107,  95,  97, 108, 108, 111,  99,  97, 116, 101,  11,  11, 116,
109, 112, 115, 116, 107,  95, 102, 114, 101, 101,  13,  13, 102, 114, 101, 101,
 95, 105, 100, 101,  95, 108, 105, 115, 116,  13,  13, 102, 114, 101, 101,  95,
116, 121, 112,  95, 108, 105, 115, 116,  13,  13, 102, 114, 101, 101,  95, 111,
112, 101,  95, 108, 105, 115, 116,  17,  17, 102, 114, 101, 101,  95, 103, 101,
110, 101, 114, 105,  99,  95, 108, 105, 115, 116,  12,  12, 105, 100, 101,  95,
102, 114, 101, 101,  95, 108, 101, 120,  15,  15, 105, 100, 101,  95,  99, 114,
101,  97, 116, 101,  95, 110,  97, 109, 101,  13,  13, 105, 100, 101,  95, 105,
110, 116,  95, 108,  97,  98, 101, 108,   4,   4,  73,  76,  65,  66,  22,  22,
105, 100, 101,  95, 115, 101,  97, 114,  99, 104,  95, 102, 114, 111, 109,  95,
110,  97, 109, 101, 105, 100,  15,  15, 115, 101, 116,  95, 103,  98, 108,  95,
100, 101, 102,  95, 110,  97, 109,  18,  18, 115, 101, 116,  95, 102, 105, 108,
101,  95, 101, 120, 116, 101, 110, 116, 105, 111, 110,  16,  16, 115, 101, 116,
 95, 101, 110, 118,  95, 102, 105, 108, 101,  95, 115, 112,  99,   9,   9, 110,
101, 119,  95, 111, 112,  97, 114, 103,   8,   8, 110, 101, 119,  95, 111, 112,
101, 114,  11,  11, 119, 114, 105, 116, 101,  95, 111, 112,  97, 114, 103,   3,
  3,  32,  91,  32,  30,   0,   0,   0,  17,   0,   9, 102, 111, 114, 109,  95,
 99, 104,  97, 114,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114,
109,  95, 108, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102,
111, 114, 109,  95, 105, 110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 11, 102, 111, 114, 109,  95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,
  0,   0,  11, 102, 111, 114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,
  0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101,
114,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 102, 101, 110, 116,
114, 121,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 105,
108, 101,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
 97, 114, 114,  97, 121,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95,  99, 111, 110, 102,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102,
111, 114, 109,  95, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   0,
  8, 102, 111, 114, 109,  95, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 108, 115, 101, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,
  0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110,
110, 117, 109,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
119, 102, 105, 108, 101,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102,
111, 114, 109,  95, 119, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
 10, 102, 111, 114, 109,  95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,
  0,   0,  12, 102, 111, 114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103,
101,   0,   0,   0,   0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97,
114, 105,  97, 110, 116,   0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95,
111, 114, 103,  97, 110, 105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114,
109,  95,  99, 111, 110, 115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102,
111, 114, 109,  95, 112, 114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,
 12, 102, 111, 114, 109,  95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 110, 117, 108, 108,   0,   0,   0,   0,
  0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 115, 116, 114, 105, 110, 103,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 114, 101, 101,
  0,   0,   0,   0,   0,   0,   0,   0,   3,   3, 110, 105, 108,   2,   2,  44,
 32,   0,   0,   0,   6,   0,   0,   0,   6,   0,   6,  99, 118,  95, 110, 111,
112,   6,  99, 118,  95,  99, 105, 102,   6,  99, 118,  95,  99, 102, 105,   6,
 99, 118,  95,  99, 105, 103,   6,  99, 118,  95,  99, 103, 105,   6,  99, 118,
 95,  99, 102, 103,   6,  99, 118,  95,  99, 103, 102,   3,   3,  44,  32,  91,
  8,   0,   0,   0,   5,   0,   5,  97,  95, 111, 117, 116,   5,  97,  95, 105,
 97, 111,   5,  97,  95, 105, 110, 100,   5,  97,  95, 100, 105, 114,   5,  97,
 95, 115, 116, 121,   5,  97,  95, 101, 116, 121,   5,  97,  95, 114, 116, 121,
  5,  97,  95, 110, 105, 108,   5,  97,  95, 110, 111, 102,   2,   2,  93,  93,
 13,  13, 119, 105, 101, 119,  95, 111, 112, 101, 114,  95, 100, 101, 102,  15,
 15,  32,  42,  32,  72, 101, 114, 101,  32, 105, 115,  32, 116, 104, 101,  32,
 23,  23,  32, 101, 110, 116, 114, 121,  32, 100, 101, 102, 105, 110, 105, 116,
105, 111, 110,  32, 108, 105, 115, 116,  58,   5,   5,  32, 112,  99, 100,  58,
127,   0,   0,   0,  15,   0,   9, 112,  99, 111, 100,  95, 110, 111, 111, 112,
  0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 115, 116, 111, 114,
101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 114,  97, 110, 103,
101,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 105, 115, 116, 111,
114, 101,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 102, 115, 116, 111,
114, 101,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 103, 115, 116, 111,
114, 101,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 110, 111, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  97, 110, 100,   0,
  0,   0,   0,   0,   0,   0,   7, 112,  99, 111, 100,  95, 111, 114,   0,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 120, 111, 114,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 109,   0,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  98,  97, 110, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  98, 120, 111, 114,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  98, 105,  99,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 115,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 116,   0,
  0,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 115, 101, 116, 103,
101, 110,   0,   0,   0,   0,  12, 112,  99, 111, 100,  95, 108, 115, 101, 116,
103, 101, 110,   0,   0,   0,  14, 112,  99, 111, 100,  95, 108, 115, 101, 116,
 97, 100, 100, 101, 108,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108,
116,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108,
101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103,
101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103,
116,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 101,
113,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 110,
101,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 105, 110, 115, 101,
116,   0,   0,   0,   0,   0,   7, 112,  99, 111, 100,  95, 101, 113,   0,   0,
  0,   0,   0,   0,   0,   0,   7, 112,  99, 111, 100,  95, 110, 101,   0,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  95, 101, 113,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  95, 110, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 105, 110,  99,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 100, 101,  99,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  97, 115, 104,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 108, 115, 104,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 114, 111, 116,   0,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 115, 117,  99,  99,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 112, 114, 101, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 111, 100, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 110, 101, 103,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105,  97,  98, 115,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 113, 114,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105,  97, 100, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 117,  98,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 117, 108,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 100, 105, 118,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 111, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 114, 101, 109,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 102, 101, 113,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 102, 110, 101,   0,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 110, 101, 103,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102,  97,  98, 115,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 113, 114,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 102,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 105,
  0,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 102, 116, 114, 117,
110,  99,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102,  97, 100, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 117,  98,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 109, 117, 108,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 100, 105, 118,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 101,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 116,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 103, 101, 113,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 103, 110, 101,   0,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 110, 101, 103,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103,  97,  98, 115,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 113, 114,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 103,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 105,
  0,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 103, 116, 114, 117,
110,  99,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 103,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 102,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103,  97, 100, 100,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 117,  98,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 109, 117, 108,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 100, 105, 118,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 105, 112, 111, 119,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 112, 111, 119,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 102, 105, 112, 119,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 115, 113, 114, 116,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 115, 105, 110,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 115,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 116,  97, 110,   0,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  97, 115, 105, 110,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  97,  99, 111, 115,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  97, 116,  97, 110,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 112, 104,  97, 115,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 101, 120, 112,   0,
  0,   0,   0,   0,   0,   0,   8, 112,  99, 111, 100,  95, 108, 111, 103,   0,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 115, 105, 110, 104,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95,  99, 111, 115, 104,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 116,  97, 110, 104,
  0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,  97, 115, 105, 110,
104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,  97,  99, 111, 115,
104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95,  97, 116,  97, 110,
104,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 112, 111, 119,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 105, 112, 119,
  0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 113, 114,
116,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 105, 110,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103,  99, 111, 115,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 116,  97, 110,
  0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 115, 105,
110,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103,  97,  99, 111,
115,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 116,  97,
110,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103, 112, 104,  97,
115,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 101, 120, 112,
  0,   0,   0,   0,   0,   0,   9, 112,  99, 111, 100,  95, 103, 108, 111, 103,
  0,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 105, 110,
104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103,  99, 111, 115,
104,   0,   0,   0,   0,   0,  10, 112,  99, 111, 100,  95, 103, 116,  97, 110,
104,   0,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 115, 105,
110, 104,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 103,  97,  99, 111,
115, 104,   0,   0,   0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 116,  97,
110, 104,   0,   0,   0,   0,  14, 112,  99, 111, 100,  95,  95, 103, 101, 110,
115, 116, 114, 108,  49,   0,  15, 112,  99, 111, 100,  95,  95, 103, 101, 110,
112, 114, 109, 116, 121, 112,   2,   2,  44,  32,   2,   2,  32,  41,   2,   2,
 58,  32,   3,   3,  32,  41,  59,  10,  10,  80, 114, 111,  99, 101, 100, 117,
114, 101,  32,   9,   9,  70, 117, 110,  99, 116, 105, 111, 110,  32,   2,   2,
 58,  32,   5,   5,  60,  70,  82,  77,  61,   2,   2,  44,  32,   2,   2,  58,
 32,   5,   5,  60,  70,  82,  77,  61
}};

/* Define the local static Initialized section. */
static Blk( Ri, 264 ) = {{
  0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 16 );

/* Declaration of external variables. */
extern V V_val_free_list;
extern SL V_curr_lex;
extern V V_all_free_list;
extern V V_pro_current;
extern UB V_cmp_genenv;
extern V V_lgt_free_list;
extern V V_int_typ;
extern SL V_curr_disp;
extern Blk(V_lex_ident_tree, 4160 );
extern V V_curr_ident;
extern Blk(V_sy_ident, 32 );
extern SL V_ident_disp;
extern Blk(V_lex_ident_level, 128 );
extern SL V_cprc_disp;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern UB V_sy_var_init_mod;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_std_err_file;
extern Blk(V_sy_string, 264 );
extern UB V_err_prt;
extern Blk(V_ide_udptr, 120 );
extern V V_cntx_varbl;
extern V V_cntx_typ;
extern SL V_cmp_trace;
extern V V_src_control;
extern SL V_cmp_tracecount;
extern UB V_cntx_srinf;
extern Blk(V_typ_std, 248 );
extern V V_srf_list;
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_all_fdata;
extern V V_all_ldata;
extern SL V_inte_size;
extern V V_wildtmp_stk;
extern V V_wildtmp_typ;
extern Blk(V_wildtmp_pal, 8 );
extern SL V_wildtmp_psz;
extern Blk(V_ope_table, 240 );
extern SL V_sy_ival;
extern Blk(V_sy_sym, 8 );
extern V V_env_first;
extern V V_env_last;
extern V PAS__f_output;
extern Blk(V_opname, 960 );


/* Function/procedure prototypes. */
void P_err_put_symbol(V F_symb, SL F_len);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_val_free_tree(V *F_p);
void P_free_typ_list(V *F_p);
void P_free_generic_list(V *F_f, V *F_l);


/* Procedure/Function : " tab_new "  */
V P_tab_new(SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=88; /* line # 88 */
  Ret=PAS__NEW(F_sz*4);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " tab_free "  */
void P_tab_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+74;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=97; /* line # 97 */
  PAS__DISPOSE(F_p);
  Ra.sl[6]=98; /* line # 98 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_copy "  */
void P_str_copy(V *F_target, V *F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+84;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=110; /* line # 110 */
  if ((*F_target)!=(*F_src)) {
    Ra.sl[6]=111; /* line # 111 */
    if ((*F_src)==NULL) {
      Ra.sl[6]=113; /* line # 113 */
      if ((*F_target)!=NULL) ((UB *)(*F_target))[1]=0;
    }
    else {
      Ra.sl[6]=118; /* line # 118 */
      if (((UB *)(*F_src))[1]>0&&(*F_target)==NULL) {
        Rv0=((UB *)(*F_src))[1];
        (*F_target)=PAS__NEW((SL)Rv0+2);
        ((UB *)(*F_target))[0]=Rv0;
      }
      Ra.sl[6]=119; /* line # 119 */
      PAS__STR_TO_STR((*F_target),(*F_src));
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error_s "  */
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+68,F_modulesy,4);
  Ra.ub[0]=32;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+94;
  Ra.v[7]=Rd.s+9;
  Ra.sl[16]=134; /* line # 134 */
  if (F_id1!=NULL) {
    Ra.sl[16]=135; /* line # 135 */
    Ra.sl[16]=137; /* line # 137 */
    Ra.ub[1]=((UB *)F_id1)[0];
    Ra.sl[16]=138; /* line # 138 */
    Rv0=1;
    for( Rf0=((UB *)F_id1)[0];Rf0>0;Rf0-- ) {
      Ra.c[Rv0+1]=((C *)F_id1)[Rv0];
      Rv0++;
    }
    Ra.sl[16]=139; /* line # 139 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  Ra.sl[16]=141; /* line # 141 */
  if (F_id2!=NULL) {
    Ra.sl[16]=142; /* line # 142 */
    Ra.sl[16]=144; /* line # 144 */
    Ra.ub[1]=((UB *)F_id2)[0];
    Ra.sl[16]=145; /* line # 145 */
    Rv1=1;
    for( Rf0=((UB *)F_id2)[0];Rf0>0;Rf0-- ) {
      Ra.c[Rv1+1]=((C *)F_id2)[Rv1];
      Rv1++;
    }
    Ra.sl[16]=146; /* line # 146 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  Ra.sl[16]=148; /* line # 148 */
  P_src_error(Ra.s+68,F_number, F_severity);
  PAS__curr_cntx=Ra.v[5];
}


/* Procedure/Function : " val_new "  */
void P_val_new(V *F_p, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=157; /* line # 157 */
  if ((*F_p)==NULL) {
    Ra.sl[6]=159; /* line # 159 */
    if (V_val_free_list==NULL) {
      Ra.sl[6]=160; /* line # 160 */
      (*F_p)=PAS__NEW(64);
    }
    else {
      Ra.sl[6]=163; /* line # 163 */
      (*F_p)=V_val_free_list;
      Ra.sl[6]=164; /* line # 164 */
      V_val_free_list=((V *)(*F_p))[0];
    }
    Ra.sl[6]=166; /* line # 166 */
    Rv0=(*F_p);
    Ra.sl[6]=168; /* line # 168 */
    ((V *)Rv0)[0]=NULL;
    Ra.sl[6]=169; /* line # 169 */
    ((SL *)Rv0)[2]=0;
    Ra.sl[6]=170; /* line # 170 */
    ((SL *)Rv0)[3]=1;
    Ra.sl[6]=171; /* line # 171 */
    ((UW *)Rv0)[8]=16416;
    Ra.sl[6]=172; /* line # 172 */
    ((SL *)Rv0)[5]=-1;
    Ra.sl[6]=173; /* line # 173 */
    ((SL *)Rv0)[6]=0;
    Ra.sl[6]=174; /* line # 174 */
    ((SL *)Rv0)[7]=V_curr_lex;
    Ra.sl[6]=175; /* line # 175 */
    ((V *)Rv0)[4]=F_ty;
    Ra.sl[6]=176; /* line # 176 */
    ((V *)Rv0)[5]=NULL;
    Ra.sl[6]=177; /* line # 177 */
    if (F_ty==NULL) ((UB *)Rv0)[48]=28;
    else {
      Ra.sl[6]=180; /* line # 180 */
      ((UB *)Rv0)[48]=((UB *)F_ty)[93];
      Ra.sl[6]=181; /* line # 181 */
      switch (((UB *)Rv0)[48]) {
        case 0:
        case 1:
        case 2:
        case 14:
        case 15:
        case 22:Ra.sl[6]=184; /* line # 184 */
        ((SL *)Rv0)[13]=0;
        break;
        case 3:
        case 4:Ra.sl[6]=186; /* line # 186 */
        ((G *)Rv0)[7]=0.000000000000000E-001;
        break;
        case 29:Ra.sl[6]=188; /* line # 188 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=190; /* line # 190 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 12:
        case 18:Ra.sl[6]=192; /* line # 192 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 6:Ra.sl[6]=194; /* line # 194 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 5:
        case 13:Ra.sl[6]=196; /* line # 196 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 21:Ra.sl[6]=198; /* line # 198 */
        ((V *)Rv0)[7]=NULL;
        break;
        default:break;
      }
    }
  }
  else {
    Ra.sl[6]=205; /* line # 205 */
    Rv1=(*F_p);
    Ra.sl[6]=206; /* line # 206 */
    ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_free "  */
void P_val_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+116;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=215; /* line # 215 */
  Rv0=(*F_p);
  Ra.sl[6]=216; /* line # 216 */
  if (((SL *)Rv0)[3]==1&&((UB *)Rv0)[48]!=30) {
    Ra.sl[6]=218; /* line # 218 */
    switch (((UB *)Rv0)[48]) {
      case 29:Ra.sl[6]=219; /* line # 219 */
      if (((V *)Rv0)[7]!=NULL) PAS__DISPOSE(((V *)Rv0)+7);
      break;
      case 8:
      case 9:
      case 10:Ra.sl[6]=221; /* line # 221 */
      P_val_free_tree(((V *)Rv0)+7);
      break;
      case 21:Ra.sl[6]=222; /* line # 222 */
      if (((V *)Rv0)[7]!=NULL) P_tab_free(((V *)Rv0)+7);
      break;
      case 12:Ra.sl[6]=223; /* line # 223 */
      if (((V *)Rv0)[7]!=NULL) PAS__DISPOSE(((V *)Rv0)+7);
      break;
      default:break;
    }
    Ra.sl[6]=226; /* line # 226 */
    ((SL *)Rv0)[3]=0;
    Ra.sl[6]=227; /* line # 227 */
    ((UB *)Rv0)[48]=30;
    Ra.sl[6]=228; /* line # 228 */
    ((V *)Rv0)[0]=V_val_free_list;
    Ra.sl[6]=229; /* line # 229 */
    ((SL *)Rv0)[2]=0;
    Ra.sl[6]=230; /* line # 230 */
    V_val_free_list=(*F_p);
  }
  else {
    Ra.sl[6]=233; /* line # 233 */
    if (((SL *)Rv0)[3]>1) ((SL *)Rv0)[3]=((SL *)Rv0)[3]-1;
    else {
      Ra.sl[6]=234; /* line # 234 */
      P_src_error(Rd.s+128,998,1);
    }
  }
  Ra.sl[6]=235; /* line # 235 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_free_tree "  */
void P_val_free_tree(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+132;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=247; /* line # 247 */
  Rv0=(*F_p);
  Ra.sl[6]=248; /* line # 248 */
  (*F_p)=NULL;
  Ra.sl[6]=249; /* line # 249 */
  while (Rv0!=NULL){
    Ra.sl[6]=251; /* line # 251 */
    Rv1=Rv0;
    Ra.sl[6]=252; /* line # 252 */
    if (((SL *)Rv0)[3]>1) Rv0=NULL;
    else {
      Ra.sl[6]=253; /* line # 253 */
      Rv0=((V *)Rv0)[0];
    }
    Ra.sl[6]=254; /* line # 254 */
    P_val_free(&Rv1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_copy "  */
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+147;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=270; /* line # 270 */
  if ((*F_v2)!=NULL) P_val_free(F_v2);
  Ra.sl[6]=271; /* line # 271 */
  if ((*F_v1)==NULL) (*F_v2)=NULL;
  else {
    Ra.sl[6]=273; /* line # 273 */
    if (F_bfree&&((SL *)(*F_v1))[3]==1) {
      Ra.sl[6]=275; /* line # 275 */
      (*F_v2)=(*F_v1);
      (*F_v1)=NULL;
    }
    else {
      Ra.sl[6]=279; /* line # 279 */
      P_val_new(F_v2,((V *)(*F_v1))[4]);
      Ra.sl[6]=280; /* line # 280 */
      memcpy((*F_v2),(*F_v1),64);
      Ra.sl[6]=281; /* line # 281 */
      Rv0=(*F_v2);
      Ra.sl[6]=283; /* line # 283 */
      ((V *)Rv0)[0]=NULL;
      Ra.sl[6]=284; /* line # 284 */
      ((SL *)Rv0)[3]=1;
      Ra.sl[6]=285; /* line # 285 */
      ((SL *)Rv0)[7]=V_curr_lex;
      Ra.sl[6]=286; /* line # 286 */
      switch (((UB *)Rv0)[48]) {
        case 29:Ra.sl[6]=288; /* line # 288 */
        if (((V *)Rv0)[7]!=NULL) {
          Ra.sl[6]=290; /* line # 290 */
          ((V *)Rv0)[7]=NULL;
          Ra.sl[6]=291; /* line # 291 */
          P_str_copy(((V *)Rv0)+7,((V *)(*F_v1))+7);
        }
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=295; /* line # 295 */
        if (((V *)Rv0)[7]!=NULL) {
          Ra.sl[6]=296; /* line # 296 */
          Rv1=((V *)Rv0)[7];
          Ra.sl[6]=297; /* line # 297 */
          ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
        }
        break;
        case 21:Ra.sl[6]=301; /* line # 301 */
        ((V *)Rv0)[7]=P_tab_new(((SL *)Rv0)[6]);
        Ra.sl[6]=302; /* line # 302 */
        Rv2=((V *)(*F_v1))[7];
        Ra.sl[6]=303; /* line # 303 */
        Rv3=0;
        for( Rf0=(((SL *)Rv0)[6]-1)+1;Rf0>0;Rf0-- ) {
          Ra.sl[6]=304; /* line # 304 */
          ((SL *)((V *)Rv0)[7])[Rv3]=((SL *)Rv2)[Rv3];
          Rv3++;
        }
        break;
        default:break;
      }
      Ra.sl[6]=310; /* line # 310 */
      if (F_bfree) P_val_free(F_v1);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_new "  */
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+157;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=325; /* line # 325 */
  if (V_all_free_list==NULL) (*F_p)=PAS__NEW(112);
  else {
    Ra.sl[6]=328; /* line # 328 */
    (*F_p)=V_all_free_list;
    V_all_free_list=((V *)(*F_p))[0];
  }
  Ra.sl[6]=330; /* line # 330 */
  Rv0=(*F_p);
  Rv1=F_ty;
  Ra.sl[6]=332; /* line # 332 */
  ((V *)Rv0)[0]=NULL;
  Ra.sl[6]=333; /* line # 333 */
  ((V *)Rv0)[1]=NULL;
  Ra.sl[6]=334; /* line # 334 */
  memcpy(Rv0+16,Rv1+48,1);
  Ra.sl[6]=335; /* line # 335 */
  ((V *)Rv0)[3]=F_ty;
  Ra.sl[6]=336; /* line # 336 */
  ((UW *)Rv0)[16]=0;
  Ra.sl[6]=337; /* line # 337 */
  ((UB *)Rv0)[34]=F_kind;
  Ra.sl[6]=338; /* line # 338 */
  ((V *)Rv0)[5]=V_pro_current;
  Ra.sl[6]=339; /* line # 339 */
  ((SL *)Rv0)[12]=-1;
  Ra.sl[6]=340; /* line # 340 */
  ((SL *)Rv0)[13]=abs(((SL *)Rv1)[11]);
  Ra.sl[6]=341; /* line # 341 */
  ((SL *)Rv0)[14]=-1;
  Ra.sl[6]=342; /* line # 342 */
  ((SL *)Rv0)[15]=V_curr_lex;
  Ra.sl[6]=343; /* line # 343 */
  ((SL *)Rv0)[16]=-1;
  Ra.sl[6]=344; /* line # 344 */
  ((SL *)Rv0)[17]=-1;
  Ra.sl[6]=345; /* line # 345 */
  ((V *)Rv0)[9]=NULL;
  Ra.sl[6]=346; /* line # 346 */
  ((V *)Rv0)[10]=NULL;
  Ra.sl[6]=347; /* line # 347 */
  ((V *)Rv0)[11]=NULL;
  Ra.sl[6]=348; /* line # 348 */
  ((V *)Rv0)[12]=F_id;
  Ra.sl[6]=349; /* line # 349 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=351; /* line # 351 */
  if (F_id!=NULL&&((SL *)Rv1)[11]>0) {
    Ra.sl[6]=352; /* line # 352 */
    Rv2=F_id;
    Ra.sl[6]=354; /* line # 354 */
    ((SL *)Rv0)[15]=((SL *)Rv2)[12];
    Ra.sl[6]=355; /* line # 355 */
    ((V *)Rv0)[5]=((V *)Rv2)[4];
    Ra.sl[6]=356; /* line # 356 */
    switch (((UB *)Rv2)[53]) {
      case 7:Ra.sl[6]=359; /* line # 359 */
      ((UW *)Rv0)[16]=16384;
      Ra.sl[6]=360; /* line # 360 */
      if (((V *)Rv2)[8]!=NULL) {
        Ra.sl[6]=361; /* line # 361 */
        if (1024&((UW *)((V *)Rv2)[8])[8]) ((UW *)Rv0)[16]=((UW *)Rv0)[16]|4;
      }
      break;
      case 5:Ra.sl[6]=366; /* line # 366 */
      ((SL *)Rv0)[12]=((SL *)Rv2)[20];
      Ra.sl[6]=367; /* line # 367 */
      ((UW *)Rv0)[16]=((UW *)Rv2)[42];
      break;
      case 4:Ra.sl[6]=372; /* line # 372 */
      if (((V *)Rv2)[7]!=NULL) {
        Ra.sl[6]=373; /* line # 373 */
        Rv3=((V *)Rv2)[7];
        Ra.sl[6]=375; /* line # 375 */
        ((SL *)Rv0)[12]=((SL *)Rv3)[5];
        Ra.sl[6]=376; /* line # 376 */
        ((UW *)Rv0)[16]=((UW *)Rv3)[8]|1;
      }
      else {
        Ra.sl[6]=379; /* line # 379 */
        ((UW *)Rv0)[16]=16417;
      }
      Ra.sl[6]=381; /* line # 381 */
      if (V_curr_lex!=((SL *)Rv0)[15]) {
        Ra.sl[6]=382; /* line # 382 */
        ((UW *)Rv0)[16]=((UW *)Rv0)[16]|4;
      }
      break;
      default:break;
    }
  }
  else {
    Ra.sl[6]=390; /* line # 390 */
    ((UW *)Rv0)[16]=97;
    Ra.sl[6]=391; /* line # 391 */
    if (V_curr_lex>1||!V_cmp_genenv) {
      Ra.sl[6]=392; /* line # 392 */
      ((UW *)Rv0)[16]=((UW *)Rv0)[16]|16384;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_free "  */
void P_all_free(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+166;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=404; /* line # 404 */
  Rv0=F_p;
  Rv1=((V *)Rv0)[5];
  Ra.sl[6]=406; /* line # 406 */
  if (((V *)Rv0)[1]!=NULL) {
    Ra.sl[6]=407; /* line # 407 */
    ((V *)((V *)Rv0)[1])[0]=((V *)Rv0)[0];
  }
  else {
    Ra.sl[6]=409; /* line # 409 */
    switch (((UB *)Rv0)[34]) {
      case 2:
      case 4:break;
      default:Ra.sl[6]=414; /* line # 414 */
      if (((V *)Rv1)[25]==F_p) ((V *)Rv1)[25]=((V *)Rv0)[0];
      Ra.sl[6]=416; /* line # 416 */
      if (((V *)Rv1)[26]==F_p) ((V *)Rv1)[26]=((V *)Rv0)[1];
      break;
    }
  }
  Ra.sl[6]=419; /* line # 419 */
  if (((V *)Rv0)[13]!=NULL) P_val_free(((V *)Rv0)+13);
  Ra.sl[6]=422; /* line # 422 */
  if (F_p!=NULL) {
    Ra.sl[6]=424; /* line # 424 */
    ((V *)F_p)[0]=V_all_free_list;
    V_all_free_list=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new "  */
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+176;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=438; /* line # 438 */
  (*F_p)=NULL;
  Ra.sl[6]=439; /* line # 439 */
  if (V_lgt_free_list==NULL) (*F_p)=PAS__NEW(64);
  else {
    Ra.sl[6]=442; /* line # 442 */
    (*F_p)=V_lgt_free_list;
    V_lgt_free_list=((V *)V_lgt_free_list)[0];
  }
  Ra.sl[6]=444; /* line # 444 */
  Rv0=(*F_p);
  Ra.sl[6]=446; /* line # 446 */
  ((V *)Rv0)[0]=NULL;
  Ra.sl[6]=447; /* line # 447 */
  ((V *)Rv0)[1]=F_prm;
  Ra.sl[6]=448; /* line # 448 */
  ((SL *)Rv0)[4]=0;
  Ra.sl[6]=449; /* line # 449 */
  ((UW *)Rv0)[10]=3;
  Ra.sl[6]=450; /* line # 450 */
  ((V *)Rv0)[3]=F_ty;
  Ra.sl[6]=451; /* line # 451 */
  ((V *)Rv0)[4]=NULL;
  Ra.sl[6]=452; /* line # 452 */
  ((UB *)Rv0)[40]=F_knd;
  Ra.sl[6]=453; /* line # 453 */
  switch (F_knd) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 16:
    case 24:
    case 25:Ra.sl[6]=460; /* line # 460 */
    if (F_prm!=NULL) ((UW *)Rv0)[10]=((UW *)F_prm)[10]|4;
    else {
      Ra.sl[6]=461; /* line # 461 */
      ((UW *)Rv0)[10]=5;
    }
    Ra.sl[6]=462; /* line # 462 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 18:Ra.sl[6]=467; /* line # 467 */
    ((V *)Rv0)[6]=NULL;
    Ra.sl[6]=468; /* line # 468 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 15:Ra.sl[6]=472; /* line # 472 */
    ((SL *)Rv0)[11]=0;
    break;
    case 0:Ra.sl[6]=476; /* line # 476 */
    ((UB *)Rv0)[41]=0;
    Ra.sl[6]=477; /* line # 477 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 6:Ra.sl[6]=481; /* line # 481 */
    ((UB *)Rv0)[41]=0;
    break;
    case 20:Ra.sl[6]=484; /* line # 484 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 17:
    case 19:
    case 21:
    case 22:
    case 23:Ra.sl[6]=488; /* line # 488 */
    ((SL *)Rv0)[11]=0;
    break;
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:Ra.sl[6]=492; /* line # 492 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 13:Ra.sl[6]=496; /* line # 496 */
    ((V *)Rv0)[6]=NULL;
    Ra.sl[6]=497; /* line # 497 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 14:Ra.sl[6]=502; /* line # 502 */
    ((V *)Rv0)[6]=NULL;
    Ra.sl[6]=503; /* line # 503 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=504; /* line # 504 */
    ((UW *)Rv0)[10]=1;
    Ra.sl[6]=505; /* line # 505 */
    if (F_ty!=NULL) {
      Ra.sl[6]=506; /* line # 506 */
      if (!((UB *)F_ty)[92]) ((UW *)Rv0)[10]=5;
    }
    break;
    default:Ra.sl[6]=511; /* line # 511 */
    ((V *)Rv0)[6]=NULL;
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_new_tmp "  */
V P_all_new_tmp(V F_ty, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+185;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=527; /* line # 527 */
  if (V_all_free_list==NULL) Rv0=PAS__NEW(112);
  else {
    Ra.sl[6]=530; /* line # 530 */
    Rv0=V_all_free_list;
    V_all_free_list=((V *)Rv0)[0];
  }
  Ra.sl[6]=532; /* line # 532 */
  P_lgt_new(&Rv1, F_ty,13,NULL);
  Ra.sl[6]=533; /* line # 533 */
  ((V *)Rv1)[7]=Rv0;
  Ra.sl[6]=534; /* line # 534 */
  Rv2=Rv0;
  Rv3=F_ty;
  Ra.sl[6]=536; /* line # 536 */
  ((V *)Rv2)[0]=NULL;
  Ra.sl[6]=537; /* line # 537 */
  ((V *)Rv2)[1]=NULL;
  Ra.sl[6]=538; /* line # 538 */
  memcpy(Rv2+16,Rv3+48,1);
  Ra.sl[6]=539; /* line # 539 */
  ((V *)Rv2)[3]=F_ty;
  Ra.sl[6]=540; /* line # 540 */
  ((UW *)Rv2)[16]=16481;
  Ra.sl[6]=541; /* line # 541 */
  ((UB *)Rv2)[34]=0;
  Ra.sl[6]=542; /* line # 542 */
  if (F_id==NULL) {
    Ra.sl[6]=544; /* line # 544 */
    ((V *)Rv2)[5]=V_pro_current;
    Ra.sl[6]=545; /* line # 545 */
    ((SL *)Rv2)[15]=V_curr_lex;
  }
  else {
    Ra.sl[6]=549; /* line # 549 */
    ((V *)Rv2)[5]=((V *)F_id)[4];
    Ra.sl[6]=550; /* line # 550 */
    ((SL *)Rv2)[15]=((SL *)F_id)[12];
  }
  Ra.sl[6]=552; /* line # 552 */
  ((SL *)Rv2)[12]=-1;
  Ra.sl[6]=553; /* line # 553 */
  ((SL *)Rv2)[13]=abs(((SL *)Rv3)[11]);
  Ra.sl[6]=554; /* line # 554 */
  ((SL *)Rv2)[14]=-1;
  Ra.sl[6]=555; /* line # 555 */
  ((SL *)Rv2)[16]=-1;
  Ra.sl[6]=556; /* line # 556 */
  ((SL *)Rv2)[17]=-1;
  Ra.sl[6]=557; /* line # 557 */
  ((V *)Rv2)[9]=NULL;
  Ra.sl[6]=558; /* line # 558 */
  ((V *)Rv2)[10]=NULL;
  Ra.sl[6]=559; /* line # 559 */
  ((V *)Rv2)[11]=NULL;
  Ra.sl[6]=560; /* line # 560 */
  ((V *)Rv2)[12]=NULL;
  Ra.sl[6]=561; /* line # 561 */
  ((V *)Rv2)[13]=NULL;
  Ra.sl[6]=563; /* line # 563 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_copy "  */
void P_lgt_new_copy(V F_model, V *F_copy){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+198;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=572; /* line # 572 */
  (*F_copy)=NULL;
  Ra.sl[6]=573; /* line # 573 */
  if (V_lgt_free_list==NULL) (*F_copy)=PAS__NEW(64);
  else {
    Ra.sl[6]=576; /* line # 576 */
    (*F_copy)=V_lgt_free_list;
    V_lgt_free_list=((V *)V_lgt_free_list)[0];
  }
  Ra.sl[6]=578; /* line # 578 */
  memcpy((*F_copy),F_model,64);
  Ra.sl[6]=579; /* line # 579 */
  Rv0=(*F_copy);
  Ra.sl[6]=580; /* line # 580 */
  if (((UB *)Rv0)[40]==14) {
    Ra.sl[6]=581; /* line # 581 */
    if (((V *)Rv0)[7]!=NULL) {
      Rv1=((V *)Rv0)[7];
      ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
    }
  }
  Ra.sl[6]=582; /* line # 582 */
  ((V *)(*F_copy))[0]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_copy_tree "  */
void P_lgt_copy_tree(V F_src, V *F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+212;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=593; /* line # 593 */
  if (F_src!=NULL) {
    Ra.sl[6]=594; /* line # 594 */
    if (((UB *)F_src)[40]==16) P_lgt_copy_tree(((V *)F_src)[1],F_dst);
    else {
      Ra.sl[6]=597; /* line # 597 */
      Rv0=((V *)F_src)[1];
      Ra.sl[6]=598; /* line # 598 */
      Rv1=NULL;
      Ra.sl[6]=599; /* line # 599 */
      while (Rv0!=NULL){
        Ra.sl[6]=601; /* line # 601 */
        P_lgt_copy_tree(Rv0, &Rv2);
        Ra.sl[6]=602; /* line # 602 */
        if (Rv1==NULL) Rv1=Rv2;
        else {
          Ra.sl[6]=603; /* line # 603 */
          ((V *)Rv3)[0]=Rv2;
        }
        Ra.sl[6]=604; /* line # 604 */
        Rv3=Rv2;
        Ra.sl[6]=605; /* line # 605 */
        Rv0=((V *)Rv0)[0];
      }
      Ra.sl[6]=607; /* line # 607 */
      P_lgt_new_copy(F_src, F_dst);
      Ra.sl[6]=608; /* line # 608 */
      ((V *)(*F_dst))[1]=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_free "  */
void P_lgt_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+227;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=618; /* line # 618 */
  Rv0=(*F_p);
  Ra.sl[6]=619; /* line # 619 */
  if (((UB *)Rv0)[40]!=25) {
    Ra.sl[6]=621; /* line # 621 */
    if (((UB *)Rv0)[40]==14) {
      Ra.sl[6]=622; /* line # 622 */
      if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    }
    Ra.sl[6]=623; /* line # 623 */
    ((V *)Rv0)[0]=V_lgt_free_list;
    Ra.sl[6]=624; /* line # 624 */
    ((UB *)Rv0)[40]=25;
    Ra.sl[6]=625; /* line # 625 */
    V_lgt_free_list=(*F_p);
  }
  Ra.sl[6]=627; /* line # 627 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_free_tree "  */
void P_lgt_free_tree(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+237;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=639; /* line # 639 */
  Rv0=(*F_p);
  Ra.sl[6]=640; /* line # 640 */
  while (Rv0!=NULL){
    Ra.sl[6]=641; /* line # 641 */
    if (((UB *)Rv0)[40]==25) Rv0=NULL;
    else {
      Ra.sl[6]=643; /* line # 643 */
      if (((UB *)Rv0)[40]!=16) {
        Ra.sl[6]=644; /* line # 644 */
        P_lgt_free_tree(((V *)Rv0)+1);
      }
      Ra.sl[6]=645; /* line # 645 */
      Rv1=((V *)Rv0)[0];
      Ra.sl[6]=646; /* line # 646 */
      P_lgt_free(&Rv0);
      Ra.sl[6]=647; /* line # 647 */
      Rv0=Rv1;
    }
  }
  Ra.sl[6]=649; /* line # 649 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new_econst "  */
V P_lgt_new_econst(V F_ty, SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+252;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=661; /* line # 661 */
  P_lgt_new(&Rv0, F_ty,14,NULL);
  Ra.sl[6]=662; /* line # 662 */
  Rv1=Rv0;
  Ra.sl[6]=664; /* line # 664 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=665; /* line # 665 */
  P_val_new(((V *)Rv1)+7,F_ty);
  Ra.sl[6]=666; /* line # 666 */
  ((SL *)((V *)Rv1)[7])[13]=F_iv;
  Ra.sl[6]=668; /* line # 668 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_econstr "  */
V P_lgt_new_econstr(V F_ty, G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+268;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=680; /* line # 680 */
  P_lgt_new(&Rv0, F_ty,14,NULL);
  Ra.sl[6]=681; /* line # 681 */
  Rv1=Rv0;
  Ra.sl[6]=683; /* line # 683 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=684; /* line # 684 */
  P_val_new(((V *)Rv1)+7,F_ty);
  Ra.sl[6]=685; /* line # 685 */
  ((G *)((V *)Rv1)[7])[7]=F_rv;
  Ra.sl[6]=687; /* line # 687 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_get_econst "  */
SL P_lgt_get_econst(V F_lgt, SL F_idf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+285;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=699; /* line # 699 */
  Rv0=F_idf;
  Ra.sl[6]=700; /* line # 700 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=701; /* line # 701 */
    Rv1=F_lgt;
    Ra.sl[6]=702; /* line # 702 */
    if (((UB *)Rv1)[40]==14&&((V *)Rv1)[7]!=NULL) {
      Ra.sl[6]=703; /* line # 703 */
      Rv2=((V *)Rv1)[7];
      Ra.sl[6]=704; /* line # 704 */
      switch (((UB *)Rv2)[48]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=705; /* line # 705 */
        Rv0=((SL *)Rv2)[13];
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=708; /* line # 708 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_imaskp2 "  */
SL P_lgt_imaskp2(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+301;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=722; /* line # 722 */
  Rv0=-1;
  Ra.sl[6]=723; /* line # 723 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=724; /* line # 724 */
    Rv1=F_lgt;
    Ra.sl[6]=725; /* line # 725 */
    if (((UB *)Rv1)[40]==14&&((V *)Rv1)[7]!=NULL) {
      Ra.sl[6]=726; /* line # 726 */
      Rv2=((V *)Rv1)[7];
      Ra.sl[6]=728; /* line # 728 */
      switch (((UB *)Rv2)[48]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=731; /* line # 731 */
        Rv3=((SL *)Rv2)[13];
        Ra.sl[6]=732; /* line # 732 */
        if (Rv3!=0) {
          Ra.sl[6]=734; /* line # 734 */
          Rv0=0;
          Ra.sl[6]=735; /* line # 735 */
          while (!(Rv3&1)){
            Ra.sl[6]=736; /* line # 736 */
            Rv3=Rv3/2;
            Rv0=Rv0+1;
          }
          Ra.sl[6]=737; /* line # 737 */
          if (Rv3==1) {
            Ra.sl[6]=739; /* line # 739 */
            Rv3=((SL *)Rv2)[13]-1;
            ((SL *)Rv2)[13]=Rv3;
          }
          else {
            Ra.sl[6]=742; /* line # 742 */
            Rv0=-1;
          }
        }
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=748; /* line # 748 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_code "  */
V P_lgt_new_code(UB F_pcd, V F_par){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+314;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=760; /* line # 760 */
  P_lgt_new(&Rv0, V_int_typ,6, F_par);
  Ra.sl[6]=761; /* line # 761 */
  ((UB *)Rv0)[41]=F_pcd;
  Ra.sl[6]=762; /* line # 762 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_call "  */
V P_lgt_new_call(V F_pty, V F_pro, V F_par){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+328;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=774; /* line # 774 */
  P_lgt_new(&Rv0, F_pty,8, F_par);
  Ra.sl[6]=775; /* line # 775 */
  if (F_pty!=NULL) {
    Ra.sl[6]=776; /* line # 776 */
    if (!((UB *)F_pty)[92]) {
      Ra.sl[6]=777; /* line # 777 */
      Rv1=Rv0;
      Ra.sl[6]=778; /* line # 778 */
      ((UW *)Rv1)[10]=((UW *)Rv1)[10]|4;
    }
  }
  Ra.sl[6]=779; /* line # 779 */
  ((V *)Rv0)[6]=F_pro;
  Ra.sl[6]=780; /* line # 780 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_link "  */
V P_lgt_link(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+342;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=792; /* line # 792 */
  P_lgt_new(&Rv0,((V *)F_lgt)[3],16, F_lgt);
  Ra.sl[6]=793; /* line # 793 */
  ((UW *)Rv0)[10]=((UW *)F_lgt)[10];
  Ra.sl[6]=794; /* line # 794 */
  ((UW *)F_lgt)[10]=((UW *)F_lgt)[10]|256;
  Ra.sl[6]=795; /* line # 795 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_idref "  */
V P_lgt_new_idref(V F_id, V F_lnk){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+352;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=807; /* line # 807 */
  Rv0=NULL;
  Ra.sl[6]=808; /* line # 808 */
  Rv1=F_id;
  Ra.sl[6]=810; /* line # 810 */
  switch (((UB *)Rv1)[53]) {
    case 5:Ra.sl[6]=813; /* line # 813 */
    P_lgt_new(&Rv0,((V *)Rv1)[5],13,NULL);
    Ra.sl[6]=814; /* line # 814 */
    Rv2=Rv0;
    Ra.sl[6]=816; /* line # 816 */
    ((V *)Rv2)[0]=F_lnk;
    Ra.sl[6]=817; /* line # 817 */
    ((V *)Rv2)[4]=F_id;
    Ra.sl[6]=818; /* line # 818 */
    ((V *)Rv2)[6]=F_id;
    Ra.sl[6]=819; /* line # 819 */
    ((UW *)Rv1)[42]=((UW *)Rv1)[42]|1;
    Ra.sl[6]=820; /* line # 820 */
    ((V *)Rv2)[7]=((V *)F_id)[9];
    Ra.sl[6]=821; /* line # 821 */
    ((UW *)Rv2)[10]=4;
    Ra.sl[6]=822; /* line # 822 */
    if (32&((UW *)Rv1)[42]) ((UW *)Rv2)[10]=((UW *)Rv2)[10]|1;
    Ra.sl[6]=823; /* line # 823 */
    if (64&((UW *)Rv1)[42]) ((UW *)Rv2)[10]=((UW *)Rv2)[10]|2;
    break;
    case 4:Ra.sl[6]=829; /* line # 829 */
    P_lgt_new(&Rv0,((V *)Rv1)[5],14,NULL);
    Ra.sl[6]=830; /* line # 830 */
    Rv3=Rv0;
    Ra.sl[6]=832; /* line # 832 */
    ((V *)Rv3)[0]=F_lnk;
    Ra.sl[6]=833; /* line # 833 */
    ((V *)Rv3)[4]=F_id;
    Ra.sl[6]=834; /* line # 834 */
    if (((V *)Rv3)[3]!=NULL) {
      Ra.sl[6]=835; /* line # 835 */
      if (((UB *)((V *)Rv3)[3])[92]) {
        Ra.sl[6]=837; /* line # 837 */
        P_val_copy(((V *)Rv1)+7,((V *)Rv3)+7,0);
        Ra.sl[6]=838; /* line # 838 */
        Rv4=((V *)Rv3)[7];
        Ra.sl[6]=840; /* line # 840 */
        ((V *)Rv4)[4]=((V *)Rv3)[3];
        Ra.sl[6]=841; /* line # 841 */
        ((UB *)Rv4)[48]=((UB *)((V *)Rv3)[3])[93];
      }
    }
    Ra.sl[6]=844; /* line # 844 */
    if (((V *)Rv3)[7]==NULL) {
      Ra.sl[6]=846; /* line # 846 */
      ((V *)Rv3)[7]=((V *)Rv1)[7];
      Ra.sl[6]=847; /* line # 847 */
      P_val_new(((V *)Rv3)+7,NULL);
    }
    break;
    default:break;
  }
  Ra.sl[6]=867; /* line # 867 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_tmpref "  */
V P_lgt_tmpref(V F_ty, UB F_nwt, UB F_frt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+367;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=878; /* line # 878 */
  P_lgt_new(&Rv0, F_ty,18,NULL);
  Ra.sl[6]=879; /* line # 879 */
  Rv1=Rv0;
  Ra.sl[6]=881; /* line # 881 */
  ((V *)Rv1)[6]=NULL;
  Ra.sl[6]=882; /* line # 882 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=883; /* line # 883 */
  if (F_nwt) ((UW *)Rv1)[10]=((UW *)Rv1)[10]|512;
  Ra.sl[6]=884; /* line # 884 */
  if (F_frt) ((UW *)Rv1)[10]=((UW *)Rv1)[10]|1024;
  Ra.sl[6]=886; /* line # 886 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_addsub "  */
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+379;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=899; /* line # 899 */
  Rv0=NULL;
  Ra.sl[6]=900; /* line # 900 */
  Rv1=((V *)F_lgt1)[3];
  Ra.sl[6]=901; /* line # 901 */
  if (((UB *)F_lgt1)[40]==14) {
    Ra.sl[6]=903; /* line # 903 */
    Rv2=((SL *)((V *)F_lgt1)[7])[13];
    Ra.sl[6]=904; /* line # 904 */
    if (((UB *)F_lgt2)[40]==14) {
      Ra.sl[6]=906; /* line # 906 */
      Rv3=((SL *)((V *)F_lgt2)[7])[13];
      Ra.sl[6]=907; /* line # 907 */
      if (F_bsub) Rv0=P_lgt_new_econst(Rv1, Rv2-Rv3);
      else {
        Ra.sl[6]=908; /* line # 908 */
        Rv0=P_lgt_new_econst(Rv1, Rv2+Rv3);
      }
      Ra.sl[6]=909; /* line # 909 */
      if (F_bfree) {
        Ra.sl[6]=911; /* line # 911 */
        P_lgt_free(&F_lgt1);
        P_lgt_free(&F_lgt2);
      }
    }
    else {
      Ra.sl[6]=915; /* line # 915 */
      if (Rv2==0) {
        Ra.sl[6]=917; /* line # 917 */
        if (F_bfree) P_lgt_free(&F_lgt1);
        Ra.sl[6]=918; /* line # 918 */
        if (F_bsub) Rv0=P_lgt_new_code(46, F_lgt2);
        else {
          Ra.sl[6]=919; /* line # 919 */
          Rv0=F_lgt2;
        }
      }
    }
  }
  else {
    Ra.sl[6]=923; /* line # 923 */
    if (((UB *)F_lgt2)[40]==14) {
      Ra.sl[6]=924; /* line # 924 */
      if (((SL *)((V *)F_lgt2)[7])[13]==0) {
        Ra.sl[6]=926; /* line # 926 */
        Rv0=F_lgt1;
        Ra.sl[6]=927; /* line # 927 */
        if (F_bfree) P_lgt_free(&F_lgt2);
      }
    }
  }
  Ra.sl[6]=930; /* line # 930 */
  if (Rv0==NULL) {
    Ra.sl[6]=932; /* line # 932 */
    ((V *)F_lgt1)[0]=F_lgt2;
    Ra.sl[6]=933; /* line # 933 */
    if (F_bsub) Rv0=P_lgt_new_code(50, F_lgt1);
    else {
      Ra.sl[6]=934; /* line # 934 */
      Rv0=P_lgt_new_code(49, F_lgt1);
    }
  }
  Ra.sl[6]=936; /* line # 936 */
  ((V *)Rv0)[3]=Rv1;
  Ra.sl[6]=937; /* line # 937 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_disp_level "  */
void P_new_disp_level(V F_ow, UB F_kind){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+395;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=949; /* line # 949 */
  if (V_curr_disp<64) {
    Ra.sl[6]=951; /* line # 951 */
    V_curr_disp=V_curr_disp+1;
    Ra.sl[6]=952; /* line # 952 */
    if (V_curr_disp>0) {
      Ra.sl[6]=953; /* line # 953 */
      memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
    }
    Ra.sl[6]=954; /* line # 954 */
    Rv0=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=956; /* line # 956 */
    ((SL *)Rv0)[12]=V_curr_lex;
    Ra.sl[6]=957; /* line # 957 */
    if (F_ow!=NULL) {
      Ra.sl[6]=958; /* line # 958 */
      ((V *)Rv0)[0]=F_ow;
    }
    Ra.sl[6]=959; /* line # 959 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=960; /* line # 960 */
    ((V *)Rv0)[2]=NULL;
    Ra.sl[6]=961; /* line # 961 */
    ((UB *)Rv0)[24]=F_kind;
    Ra.sl[6]=962; /* line # 962 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=963; /* line # 963 */
    ((V *)Rv0)[5]=NULL;
    Ra.sl[6]=964; /* line # 964 */
    ((SL *)Rv0)[14]=0;
  }
  else {
    Ra.sl[6]=966; /* line # 966 */
    P_src_error(Rd.s+413,1001,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_reserve_disp "  */
void P_ide_reserve_disp(SL F_prv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+417;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=978; /* line # 978 */
  Rv0=V_lex_ident_tree.v[V_curr_disp*8];
  Ra.sl[6]=982; /* line # 982 */
  if (Rv0!=NULL) {
    Ra.sl[6]=983; /* line # 983 */
    Rv1=(V_lex_ident_tree.s+V_curr_disp*64);
    Rv2=Rv0;
    Ra.sl[6]=984; /* line # 984 */
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=986; /* line # 986 */
      ((V *)((V *)Rv1)[4])[3]=((V *)Rv2)[21];
      Ra.sl[6]=987; /* line # 987 */
      ((V *)Rv2)[21]=((V *)Rv1)[1];
    }
  }
  Ra.sl[6]=989; /* line # 989 */
  V_curr_disp=F_prv;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " match "  */
SL P_match(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+435;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1005; /* line # 1005 */
  if (((UB *)F_s1)[0]<((UB *)F_s2)[0]) Rv0=((UB *)F_s1)[0];
  else {
    Ra.sl[6]=1006; /* line # 1006 */
    Rv0=((UB *)F_s2)[0];
  }
  Ra.sl[6]=1007; /* line # 1007 */
  Rv1=1;
  Ra.sl[6]=1008; /* line # 1008 */
  Rv2=0;
  Ra.sl[6]=1009; /* line # 1009 */
  while (Rv1<=Rv0&&Rv2==0){
    Ra.sl[6]=1011; /* line # 1011 */
    Rv2=(SL)((C *)F_s1)[Rv1]-(SL)((C *)F_s2)[Rv1];
    Rv1=Rv1+1;
  }
  Ra.sl[6]=1013; /* line # 1013 */
  if (Rv1>Rv0&&Rv2==0) Rv2=((UB *)F_s1)[0]-((UB *)F_s2)[0];
  Ra.sl[6]=1014; /* line # 1014 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_int_name "  */
V P_new_int_name(V F_head, SL *F_nbs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_head,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+442;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1031; /* line # 1031 */
  Rv0=NULL;
  Ra.sl[6]=1032; /* line # 1032 */
  Rv0=PAS__NEW(32);
  Ra.sl[6]=1033; /* line # 1033 */
  Rv1=Rv0;
  Ra.sl[6]=1035; /* line # 1035 */
  Rv2=1;
  for( Rf0=4;Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=Ra.c[Rv2+27];
    Rv2++;
  }
  Ra.sl[6]=1036; /* line # 1036 */
  Rv3=12;
  ((UB *)Rv1)[0]=Rv3;
  Ra.sl[6]=1037; /* line # 1037 */
  Rv4=(*F_nbs);
  Ra.sl[6]=1038; /* line # 1038 */
  while (Rv3>4){
    Ra.sl[6]=1040; /* line # 1040 */
    ((C *)Rv1)[Rv3]=(C)(48+PAS__I_MOD(Rv4,10));
    Ra.sl[6]=1041; /* line # 1041 */
    Rv4=Rv4/10;
    Ra.sl[6]=1042; /* line # 1042 */
    Rv3=Rv3-1;
  }
  Ra.sl[6]=1045; /* line # 1045 */
  (*F_nbs)=(*F_nbs)+1;
  Ra.sl[6]=1046; /* line # 1046 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " level_search "  */
V P_level_search(V F_fp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+456;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1060; /* line # 1060 */
  Rv0=F_fp;
  Ra.sl[6]=1061; /* line # 1061 */
  Rv1=0;
  Ra.sl[6]=1062; /* line # 1062 */
  Rs.v[0]=NULL;
  Ra.sl[6]=1063; /* line # 1063 */
  while (!Rv1&&Rv0!=NULL){
    Ra.sl[6]=1064; /* line # 1064 */
    Rv2=Rv0;
    Ra.sl[6]=1066; /* line # 1066 */
    Rs.v[0]=Rv0;
    Ra.sl[6]=1067; /* line # 1067 */
    if (V_curr_ident==NULL) Rv3=P_match(((V *)Rv2)[0],V_sy_ident.s);
    else {
      Ra.sl[6]=1068; /* line # 1068 */
      Rv3=P_match(((V *)Rv2)[0],V_curr_ident);
    }
    Ra.sl[6]=1069; /* line # 1069 */
    if (Rv3==0) Rv1=1;
    else {
      Ra.sl[6]=1070; /* line # 1070 */
      if (Rv3>0) {
        Ra.sl[6]=1071; /* line # 1071 */
        Rs.ub[8]=1;
        Ra.sl[6]=1072; /* line # 1072 */
        Rv0=((V *)Rv0)[1];
      }
      else {
        Ra.sl[6]=1075; /* line # 1075 */
        Rs.ub[8]=0;
        Ra.sl[6]=1076; /* line # 1076 */
        Rv0=((V *)Rv0)[2];
      }
    }
  }
  Ra.sl[6]=1079; /* line # 1079 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lex_search "  */
V P_lex_search(SL F_disp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+470;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1096; /* line # 1096 */
  V_ident_disp=F_disp;
  Ra.sl[6]=1097; /* line # 1097 */
  if (V_lex_ident_tree.ub[V_ident_disp*64+24]==4) Rv0=4;
  else {
    Ra.sl[6]=1098; /* line # 1098 */
    Rv0=6;
  }
  while (1){
    Ra.sl[6]=1100; /* line # 1100 */
    Rv1=P_level_search(V_lex_ident_tree.v[V_ident_disp*8+1]);
    Ra.sl[6]=1101; /* line # 1101 */
    if (V_ident_disp==F_disp) {
      Ra.sl[6]=1102; /* line # 1102 */
      Rv2=Rs.v[0];
      Ra.sl[6]=1103; /* line # 1103 */
      Rv3=Rs.ub[8];
    }
    Ra.sl[6]=1105; /* line # 1105 */
    V_ident_disp=V_ident_disp-1;
    if (((Rv1!=NULL||V_ident_disp<V_lex_ident_level.sl[V_curr_lex])||Rv0!=V_lex_ident_tree
    .ub[V_ident_disp*64+24])||V_ident_disp<0)  break;
  }
  Ra.sl[6]=1109; /* line # 1109 */
  Rs.v[0]=Rv2;
  Rs.ub[8]=Rv3;
  Ra.sl[6]=1110; /* line # 1110 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " any_class "  */
UB P_any_class(UW F_fs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+482;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1122; /* line # 1122 */
  Rv0=0;
  Ra.sl[6]=1123; /* line # 1123 */
  if (F_fs!=0) {
    Ra.sl[6]=1124; /* line # 1124 */
    while (!(1<<Rv0&F_fs))
    Rv0=Rv0+1;
  }
  Ra.sl[6]=1125; /* line # 1125 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_new "  */
void P_ide_new(UB F_fc, V F_ty, V *F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  SL Rv13;
  register V Rv14;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+493;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1147; /* line # 1147 */
  if (F_fc==3) Rv0=V_cprc_disp;
  else {
    Ra.sl[6]=1148; /* line # 1148 */
    Rv0=V_curr_disp;
  }
  Ra.sl[6]=1150; /* line # 1150 */
  Rv1=P_lex_search(Rv0);
  Ra.sl[6]=1156; /* line # 1156 */
  if (Rv1!=NULL) {
    Ra.sl[6]=1158; /* line # 1158 */
    Rv2=Rv1;
    Ra.sl[6]=1159; /* line # 1159 */
    switch (((UB *)Rv2)[53]) {
      case 5:Ra.sl[6]=1160; /* line # 1160 */
      Rv3=((UB *)Rv2)[86]==5;
      break;
      case 4:Ra.sl[6]=1161; /* line # 1161 */
      Rv3=((UB *)Rv2)[72]==5;
      break;
      default:Ra.sl[6]=1163; /* line # 1163 */
      Rv3=0;
      break;
    }
    Ra.sl[6]=1166; /* line # 1166 */
    if (!(Rv3&&V_cmp_twicedclon)) {
      Ra.sl[6]=1168; /* line # 1168 */
      V_cmp_twicedcl=1;
      Ra.sl[6]=1169; /* line # 1169 */
      P_src_error_s(Rd.s+504,101,2, V_sy_ident.s,NULL);
    }
    else {
      Ra.sl[6]=1172; /* line # 1172 */
      ((V *)Rv1)[3]=NULL;
    }
  }
  else {
    Ra.sl[6]=1176; /* line # 1176 */
    Rv1=NULL;
    Ra.sl[6]=1177; /* line # 1177 */
    switch (F_fc) {
      case 3:Ra.sl[6]=1179; /* line # 1179 */
      Rv1=PAS__NEW(96);
      Ra.sl[6]=1180; /* line # 1180 */
      Rv4=Rv1;
      Ra.sl[6]=1182; /* line # 1182 */
      ((UB *)Rv4)[54]=0;
      Ra.sl[6]=1183; /* line # 1183 */
      ((V *)Rv4)[7]=NULL;
      Ra.sl[6]=1184; /* line # 1184 */
      ((V *)Rv4)[8]=NULL;
      Ra.sl[6]=1185; /* line # 1185 */
      ((V *)Rv4)[9]=NULL;
      Ra.sl[6]=1186; /* line # 1186 */
      ((V *)Rv4)[10]=NULL;
      Ra.sl[6]=1187; /* line # 1187 */
      ((SL *)Rv4)[22]=0;
      Ra.sl[6]=1188; /* line # 1188 */
      ((SL *)Rv4)[23]=-1;
      break;
      case 10:Ra.sl[6]=1194; /* line # 1194 */
      Rv1=PAS__NEW(72);
      Ra.sl[6]=1195; /* line # 1195 */
      Rv5=Rv1;
      Ra.sl[6]=1197; /* line # 1197 */
      ((V *)Rv5)[7]=NULL;
      Ra.sl[6]=1198; /* line # 1198 */
      ((V *)Rv5)[8]=NULL;
      break;
      case 7:Ra.sl[6]=1204; /* line # 1204 */
      Rv1=PAS__NEW(80);
      Ra.sl[6]=1205; /* line # 1205 */
      Rv6=Rv1;
      Ra.sl[6]=1207; /* line # 1207 */
      ((V *)Rv6)[7]=NULL;
      Ra.sl[6]=1208; /* line # 1208 */
      ((V *)Rv6)[8]=NULL;
      Ra.sl[6]=1209; /* line # 1209 */
      ((V *)Rv6)[9]=NULL;
      break;
      case 1:
      case 8:
      case 9:Ra.sl[6]=1216; /* line # 1216 */
      Rv1=PAS__NEW(96);
      Ra.sl[6]=1217; /* line # 1217 */
      Rv7=Rv1;
      Ra.sl[6]=1219; /* line # 1219 */
      ((V *)Rv7)[7]=NULL;
      Ra.sl[6]=1220; /* line # 1220 */
      ((V *)Rv7)[8]=NULL;
      Ra.sl[6]=1221; /* line # 1221 */
      ((V *)Rv7)[9]=NULL;
      Ra.sl[6]=1222; /* line # 1222 */
      ((V *)Rv7)[10]=NULL;
      Ra.sl[6]=1223; /* line # 1223 */
      ((V *)Rv7)[11]=NULL;
      break;
      case 4:Ra.sl[6]=1228; /* line # 1228 */
      Rv1=PAS__NEW(73);
      Ra.sl[6]=1229; /* line # 1229 */
      Rv8=Rv1;
      Ra.sl[6]=1231; /* line # 1231 */
      ((V *)Rv8)[7]=NULL;
      Ra.sl[6]=1232; /* line # 1232 */
      ((V *)Rv8)[8]=NULL;
      Ra.sl[6]=1233; /* line # 1233 */
      ((UB *)Rv8)[72]=12;
      break;
      case 2:Ra.sl[6]=1238; /* line # 1238 */
      Rv1=PAS__NEW(88);
      Ra.sl[6]=1239; /* line # 1239 */
      Rv9=Rv1;
      Ra.sl[6]=1241; /* line # 1241 */
      ((SL *)Rv9)[14]=0;
      Ra.sl[6]=1242; /* line # 1242 */
      ((UB *)Rv9)[60]=0;
      Ra.sl[6]=1243; /* line # 1243 */
      ((V *)Rv9)[8]=NULL;
      Ra.sl[6]=1244; /* line # 1244 */
      ((V *)Rv9)[9]=NULL;
      Ra.sl[6]=1245; /* line # 1245 */
      ((V *)Rv9)[10]=NULL;
      break;
      case 5:Ra.sl[6]=1250; /* line # 1250 */
      Rv1=PAS__NEW(90);
      Ra.sl[6]=1251; /* line # 1251 */
      Rv10=Rv1;
      Ra.sl[6]=1253; /* line # 1253 */
      if (V_curr_lex>1) {
        Ra.sl[6]=1255; /* line # 1255 */
        ((SL *)Rv10)[20]=-1;
        Ra.sl[6]=1256; /* line # 1256 */
        ((UW *)Rv10)[42]=16384;
      }
      else {
        Ra.sl[6]=1260; /* line # 1260 */
        ((SL *)Rv10)[20]=V_cmp_igenv;
        Ra.sl[6]=1261; /* line # 1261 */
        ((UW *)Rv10)[42]=0;
      }
      Ra.sl[6]=1263; /* line # 1263 */
      ((V *)Rv10)[7]=NULL;
      Ra.sl[6]=1264; /* line # 1264 */
      ((V *)Rv10)[8]=NULL;
      Ra.sl[6]=1265; /* line # 1265 */
      ((V *)Rv10)[9]=NULL;
      Ra.sl[6]=1266; /* line # 1266 */
      ((UB *)Rv10)[86]=0;
      Ra.sl[6]=1267; /* line # 1267 */
      ((UW *)Rv10)[44]=0;
      Ra.sl[6]=1269; /* line # 1269 */
      if (V_sy_var_init_mod) {
        Ra.sl[6]=1270; /* line # 1270 */
        if (V_std_inp_file==NULL) V_std_inp_file=Rv1;
        else {
          Ra.sl[6]=1272; /* line # 1272 */
          if (V_std_out_file==NULL) V_std_out_file=Rv1;
          else {
            Ra.sl[6]=1274; /* line # 1274 */
            if (V_std_err_file==NULL) V_std_err_file=Rv1;
          }
        }
      }
      break;
      case 6:Ra.sl[6]=1278; /* line # 1278 */
      Rv1=PAS__NEW(60);
      Ra.sl[6]=1279; /* line # 1279 */
      ((SL *)Rv1)[14]=0;
      break;
      case 12:Ra.sl[6]=1283; /* line # 1283 */
      Rv1=PAS__NEW(55);
      Ra.sl[6]=1284; /* line # 1284 */
      ((UB *)Rv1)[54]=0;
      break;
      case 0:Ra.sl[6]=1288; /* line # 1288 */
      Rv1=PAS__NEW(56);
      Ra.sl[6]=1289; /* line # 1289 */
      memcpy(Rv1+54,Rd.s+508,2);
      break;
    }
    Ra.sl[6]=1295; /* line # 1295 */
    Rv11=Rv1;
    Ra.sl[6]=1297; /* line # 1297 */
    ((UB *)Rv11)[53]=F_fc;
    Ra.sl[6]=1298; /* line # 1298 */
    ((V *)Rv11)[0]=PAS__NEW(32);
    Ra.sl[6]=1299; /* line # 1299 */
    Rv12=((V *)Rv11)[0];
    Ra.sl[6]=1301; /* line # 1301 */
    ((UB *)Rv12)[0]=V_sy_ident.ub[0];
    Ra.sl[6]=1302; /* line # 1302 */
    Rv13=1;
    for( Rf0=((UB *)Rv12)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv12)[Rv13]=V_sy_ident.c[Rv13];
      Rv13++;
    }
    Ra.sl[6]=1304; /* line # 1304 */
    ((V *)Rv11)[1]=NULL;
    Ra.sl[6]=1305; /* line # 1305 */
    ((V *)Rv11)[2]=NULL;
    Ra.sl[6]=1306; /* line # 1306 */
    ((V *)Rv11)[3]=NULL;
    Ra.sl[6]=1307; /* line # 1307 */
    ((V *)Rv11)[5]=F_ty;
    Ra.sl[6]=1308; /* line # 1308 */
    ((SL *)Rv11)[12]=V_curr_lex;
    Ra.sl[6]=1309; /* line # 1309 */
    ((V *)Rv11)[4]=V_lex_ident_tree.v[Rv0*8];
    Ra.sl[6]=1313; /* line # 1313 */
    if (Rs.v[0]==NULL) V_lex_ident_tree.v[Rv0*8+1]=Rv1;
    else {
      Ra.sl[6]=1314; /* line # 1314 */
      if (Rs.ub[8]) ((V *)Rs.v[0])[1]=Rv1;
      else {
        Ra.sl[6]=1315; /* line # 1315 */
        ((V *)Rs.v[0])[2]=Rv1;
      }
    }
    Ra.sl[6]=1317; /* line # 1317 */
    Rv14=(V_lex_ident_tree.s+Rv0*64);
    Ra.sl[6]=1319; /* line # 1319 */
    if (((V *)Rv14)[4]!=NULL) ((V *)((V *)Rv14)[4])[3]=Rv1;
    Ra.sl[6]=1320; /* line # 1320 */
    ((V *)Rv14)[4]=Rv1;
    Ra.sl[6]=1323; /* line # 1323 */
    V_cmp_twicedcl=0;
  }
  Ra.sl[6]=1325; /* line # 1325 */
  if (Ri.ub[0]) {
    Ra.sl[6]=1327; /* line # 1327 */
    PAS__STR_TO_STR(V_sy_string.s,Ri.s+1);
    Ra.sl[6]=1328; /* line # 1328 */
    Ri.ub[0]=0;
  }
  Ra.sl[6]=1330; /* line # 1330 */
  (*F_ip)=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search "  */
V P_ide_search(UW F_fs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+510;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1354; /* line # 1354 */
  V_ident_disp=V_curr_disp;
  while (1){
    Ra.sl[6]=1356; /* line # 1356 */
    Rv0=P_level_search(V_lex_ident_tree.v[V_ident_disp*8+1]);
    Ra.sl[6]=1357; /* line # 1357 */
    if (Rv0!=NULL) {
      Ra.sl[6]=1359; /* line # 1359 */
      if (!(1<<((UB *)Rv0)[53]&F_fs)) {
        Ra.sl[6]=1361; /* line # 1361 */
        if (V_err_prt) P_src_error_s(Rd.s+524,103,2, V_sy_ident.s,NULL);
        Ra.sl[6]=1362; /* line # 1362 */
        Rv0=NULL;
        Ra.sl[6]=1363; /* line # 1363 */
        V_ident_disp=V_ident_disp -1;
      }
    }
    else {
      Ra.sl[6]=1366; /* line # 1366 */
      V_ident_disp=V_ident_disp -1;
    }
    if (Rv0!=NULL||V_ident_disp<0)  break;
  }
  Ra.sl[6]=1368; /* line # 1368 */
  if (Rv0==NULL&&V_err_prt) {
    Ra.sl[6]=1370; /* line # 1370 */
    P_src_error_s(Rd.s+524,104,3, V_sy_ident.s,NULL);
    Ra.sl[6]=1372; /* line # 1372 */
    Rv0=V_ide_udptr.v[P_any_class(F_fs)];
  }
  Ra.sl[6]=1374; /* line # 1374 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_cntxvar "  */
void P_gen_cntxvar(V F_pr, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+528;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1384; /* line # 1384 */
  Rv0=F_pr;
  Ra.sl[6]=1386; /* line # 1386 */
  ((V *)Rv0)[22]=PAS__NEW(90);
  Ra.sl[6]=1387; /* line # 1387 */
  V_cntx_varbl=((V *)Rv0)[22];
  Ra.sl[6]=1388; /* line # 1388 */
  Rv1=((V *)Rv0)[22];
  Ra.sl[6]=1390; /* line # 1390 */
  ((V *)Rv1)[0]=F_id;
  Ra.sl[6]=1391; /* line # 1391 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=1392; /* line # 1392 */
  ((V *)Rv1)[2]=NULL;
  Ra.sl[6]=1393; /* line # 1393 */
  ((V *)Rv1)[3]=NULL;
  Ra.sl[6]=1394; /* line # 1394 */
  ((V *)Rv1)[5]=V_cntx_typ;
  Ra.sl[6]=1395; /* line # 1395 */
  ((SL *)Rv1)[12]=V_curr_lex;
  Ra.sl[6]=1396; /* line # 1396 */
  ((V *)Rv1)[4]=F_pr;
  Ra.sl[6]=1397; /* line # 1397 */
  ((UB *)Rv1)[53]=5;
  Ra.sl[6]=1398; /* line # 1398 */
  ((SL *)Rv1)[20]=-1;
  Ra.sl[6]=1399; /* line # 1399 */
  ((UW *)Rv1)[42]=16385;
  Ra.sl[6]=1400; /* line # 1400 */
  if (V_curr_lex<=1) ((UB *)Rv1)[86]=2;
  else {
    Ra.sl[6]=1401; /* line # 1401 */
    ((UB *)Rv1)[86]=1;
  }
  Ra.sl[6]=1402; /* line # 1402 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=1403; /* line # 1403 */
  ((V *)Rv1)[8]=((V *)Rv0)[3];
  Ra.sl[6]=1404; /* line # 1404 */
  ((V *)Rv1)[9]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new_line "  */
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  UB Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register UB Rv16;
  register V Rv17;
  register V Rv18;
  SL Rv19;
  register V Rv20;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+541;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1429; /* line # 1429 */
  Rv0=NULL;
  Ra.sl[6]=1430; /* line # 1430 */
  Rv1=0;
  Ra.sl[6]=1431; /* line # 1431 */
  Rv2=0;
  Ra.sl[6]=1432; /* line # 1432 */
  if (V_cmp_trace>0) {
    Ra.sl[6]=1433; /* line # 1433 */
    Rv3=V_src_control;
    Rv4=F_pr;
    Ra.sl[6]=1435; /* line # 1435 */
    if (V_cmp_tracecount<=((SL *)Rv3)[10]||F_icd!=0) {
      Ra.sl[6]=1438; /* line # 1438 */
      if (V_cntx_srinf&&F_icd==0) F_icd=1;
      Ra.sl[6]=1439; /* line # 1439 */
      switch (F_icd) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=1442; /* line # 1442 */
        if (F_lgp==((V *)Rv4)[15]&&F_lgp!=NULL) {
          Ra.sl[6]=1443; /* line # 1443 */
          switch (((SL *)F_lgp)[11]) {
            case 0:
            case 1:
            case 2:
            case 4:Ra.sl[6]=1444; /* line # 1444 */
            Rv1=1;
            break;
            default:break;
          }
        }
        Ra.sl[6]=1447; /* line # 1447 */
        Rv2=V_cntx_srinf;
        break;
        case 3:
        case 5:Ra.sl[6]=1450; /* line # 1450 */
        Rv2=1;
        break;
        default:break;
      }
      Ra.sl[6]=1455; /* line # 1455 */
      V_cntx_srinf=0;
      Ra.sl[6]=1457; /* line # 1457 */
      if (Rv2) {
        Ra.sl[6]=1459; /* line # 1459 */
        P_lgt_new(&Rv0, V_typ_std.v[10],14,NULL);
        Ra.sl[6]=1460; /* line # 1460 */
        Rv5=Rv0;
        Rv6=V_srf_list;
        Ra.sl[6]=1462; /* line # 1462 */
        ((V *)Rv5)[7]=((V *)Rv6)[1];
        Ra.sl[6]=1463; /* line # 1463 */
        P_val_new(((V *)Rv5)+7,V_typ_std.v[10]);
        Ra.sl[6]=1464; /* line # 1464 */
        Rv7=((V *)Rv5)[7];
        Ra.sl[6]=1465; /* line # 1465 */
        if (((SL *)Rv7)[3]<=2) {
          Ra.sl[6]=1467; /* line # 1467 */
          ((V *)Rv7)[4]=((V *)Rv5)[3];
          Ra.sl[6]=1468; /* line # 1468 */
          ((UB *)Rv7)[48]=29;
          Ra.sl[6]=1469; /* line # 1469 */
          ((SL *)Rv7)[6]=((UB *)((V *)Rv7)[7])[1];
        }
      }
      Ra.sl[6]=1474; /* line # 1474 */
      if (Rv1) {
        Ra.sl[6]=1476; /* line # 1476 */
        Rv8=F_lgp;
        Ra.sl[6]=1477; /* line # 1477 */
        if (((V *)Rv8)[1]!=NULL) {
          Ra.sl[6]=1479; /* line # 1479 */
          ((SL *)Rv8)[4]=((SL *)Rv3)[10];
          Ra.sl[6]=1480; /* line # 1480 */
          if (Rv2) {
            Ra.sl[6]=1481; /* line # 1481 */
            if (((SL *)Rv8)[11]<2) {
              Ra.sl[6]=1482; /* line # 1482 */
              Rv9=((V *)Rv8)[1];
              Ra.sl[6]=1484; /* line # 1484 */
              if (((V *)Rv9)[1]!=NULL) P_lgt_free_tree(((V *)Rv9)+1);
              Ra.sl[6]=1485; /* line # 1485 */
              ((V *)Rv9)[1]=Rv0;
            }
            else {
              Ra.sl[6]=1488; /* line # 1488 */
              Rv10=((V *)Rv8)[1];
              Ra.sl[6]=1489; /* line # 1489 */
              if (((V *)Rv10)[1]!=NULL) {
                Ra.sl[6]=1490; /* line # 1490 */
                Rv11=((V *)Rv10)[1];
                Ra.sl[6]=1492; /* line # 1492 */
                if (((V *)Rv11)[1]!=NULL) P_lgt_free_tree(((V *)Rv11)+1);
                Ra.sl[6]=1493; /* line # 1493 */
                ((V *)Rv11)[1]=Rv0;
              }
            }
          }
        }
      }
      else {
        Ra.sl[6]=1499; /* line # 1499 */
        if (F_icd==3||F_icd==5) {
          Ra.sl[6]=1501; /* line # 1501 */
          P_lgt_new(&Rv12, V_typ_std.v[10],14,NULL);
          Ra.sl[6]=1502; /* line # 1502 */
          Rv13=Rv12;
          Ra.sl[6]=1504; /* line # 1504 */
          ((V *)Rv13)[7]=NULL;
          Ra.sl[6]=1505; /* line # 1505 */
          P_val_new(((V *)Rv13)+7,V_typ_std.v[10]);
          Ra.sl[6]=1506; /* line # 1506 */
          Rv14=((V *)Rv13)[7];
          Rv15=V_cntx_varbl;
          Ra.sl[6]=1508; /* line # 1508 */
          ((UB *)Rv14)[48]=29;
          Ra.sl[6]=1509; /* line # 1509 */
          Rv16=((UB *)((V *)Rv15)[0])[0];
          ((V *)Rv14)[7]=PAS__NEW((SL)Rv16+2);
          ((UB *)((V *)Rv14)[7])[0]=Rv16;
          Ra.sl[6]=1510; /* line # 1510 */
          Rv17=((V *)Rv14)[7];
          Rv18=((V *)Rv15)[0];
          Ra.sl[6]=1512; /* line # 1512 */
          ((UB *)Rv17)[1]=((UB *)Rv17)[0];
          Ra.sl[6]=1513; /* line # 1513 */
          Rv19=1;
          for( Rf0=((UB *)Rv17)[0];Rf0>0;Rf0-- ) {
            ((C *)Rv17)[Rv19+1]=((C *)Rv18)[Rv19];
            Rv19++;
          }
          Ra.sl[6]=1514; /* line # 1514 */
          ((SL *)Rv14)[6]=((UB *)Rv17)[0];
          Ra.sl[6]=1518; /* line # 1518 */
          ((V *)Rv12)[0]=Rv0;
          Ra.sl[6]=1519; /* line # 1519 */
          Rv0=Rv12;
        }
        Ra.sl[6]=1521; /* line # 1521 */
        Rv0=P_lgt_new_idref(V_cntx_varbl, Rv0);
        Ra.sl[6]=1522; /* line # 1522 */
        P_lgt_new(&Rv0,NULL,23, Rv0);
        Ra.sl[6]=1523; /* line # 1523 */
        Rv20=Rv0;
        Ra.sl[6]=1525; /* line # 1525 */
        ((SL *)Rv20)[4]=((SL *)Rv3)[10];
        Ra.sl[6]=1526; /* line # 1526 */
        ((SL *)Rv20)[11]=F_icd;
        Ra.sl[6]=1528; /* line # 1528 */
        ((V *)F_pr)[15]=Rv0;
      }
      Ra.sl[6]=1530; /* line # 1530 */
      V_cmp_tracecount=((SL *)Rv3)[10]+V_cmp_trace;
    }
  }
  Ra.sl[6]=1533; /* line # 1533 */
  if (Rv1) Ret=NULL;
  else {
    Ra.sl[6]=1534; /* line # 1534 */
    Ret=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_linetrace "  */
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+555;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1707; /* line # 1707 */
  if ((*F_lgh)==NULL) (*F_lgl)=NULL;
  Ra.sl[6]=1708; /* line # 1708 */
  Rv0=P_lgt_new_line(F_pr, (*F_lgl),F_icd);
  Ra.sl[6]=1709; /* line # 1709 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1711; /* line # 1711 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv0;
    else {
      Ra.sl[6]=1712; /* line # 1712 */
      ((V *)(*F_lgl))[0]=Rv0;
    }
    Ra.sl[6]=1713; /* line # 1713 */
    (*F_lgl)=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " label_purge "  */
void P_label_purge(V *F_prv_cntx){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+570;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1729; /* line # 1729 */
  Rv0=V_cntx_label;
  Ra.sl[6]=1730; /* line # 1730 */
  V_cntx_label=(*F_prv_cntx);
  Ra.sl[6]=1731; /* line # 1731 */
  while (Rv0!=(*F_prv_cntx)&&Rv0!=NULL){
    Ra.sl[6]=1733; /* line # 1733 */
    Rv1=Rv0;
    Ra.sl[6]=1735; /* line # 1735 */
    Rv2=((V *)Rv1)[8];
    Ra.sl[6]=1738; /* line # 1738 */
    if (16&((UB *)Rv1)[54]) {
      Ra.sl[6]=1740; /* line # 1740 */
      ((UB *)Rv1)[54]=((UB *)Rv1)[54]|32;
      Ra.sl[6]=1741; /* line # 1741 */
      ((V *)Rv1)[8]=NULL;
    }
    else {
      Ra.sl[6]=1745; /* line # 1745 */
      if (8&((UB *)Rv1)[54]) {
        Ra.sl[6]=1747; /* line # 1747 */
        P_src_error_s(Rd.s+585,67,3,((V *)Rv1)[0],NULL);
      }
      Ra.sl[6]=1748; /* line # 1748 */
      ((V *)Rv1)[8]=V_cntx_label;
      Ra.sl[6]=1749; /* line # 1749 */
      V_cntx_label=Rv0;
    }
    Ra.sl[6]=1752; /* line # 1752 */
    Rv0=Rv2;
  }
  Ra.sl[6]=1754; /* line # 1754 */
  V_cntx_lblvl=V_cntx_lblvl-1;
  Ra.sl[6]=1755; /* line # 1755 */
  (*F_prv_cntx)=V_cntx_label;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " typ_alignement "  */
SL P_typ_alignement(SL F_iaddr, V F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register SL Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+36,F_aln,1);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+589;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1767; /* line # 1767 */
  Ra.sl[6]=1769; /* line # 1769 */
  Ra.sl[7]=F_iaddr+Ra.ub[36];
  Ra.sl[8]=Ra.ub[36];
  Ra.sl[6]=1770; /* line # 1770 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=1771; /* line # 1771 */
  Ret=Ra.sl[7];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_typ_align "  */
SL P_ide_typ_align(SL F_iaddr, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+605;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1784; /* line # 1784 */
  Rv0=F_ty;
  Ra.sl[6]=1786; /* line # 1786 */
  Ra.sl[7]=F_iaddr+((UB *)Rv0)[48];
  Ra.sl[8]=((UB *)Rv0)[48];
  Ra.sl[6]=1787; /* line # 1787 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=1788; /* line # 1788 */
  Ret=Ra.sl[7];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " all_typ_allocate "  */
void P_all_typ_allocate(SL *F_iaddr, V F_al){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+620;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1801; /* line # 1801 */
  Rv0=F_al;
  Ra.sl[6]=1803; /* line # 1803 */
  Ra.sl[7]=(*F_iaddr)+((UB *)Rv0)[16];
  Ra.sl[6]=1804; /* line # 1804 */
  Ra.sl[8]=((UB *)Rv0)[16];
  Ra.sl[6]=1805; /* line # 1805 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=1806; /* line # 1806 */
  ((SL *)Rv0)[17]=Ra.sl[7];
  Ra.sl[6]=1807; /* line # 1807 */
  (*F_iaddr)=Ra.sl[7]+abs(((SL *)Rv0)[13]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cte_allocate "  */
void P_cte_allocate(V F_vp, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+638;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1821; /* line # 1821 */
  if (F_id==NULL) Rv0=((V *)F_vp)[4];
  else {
    Ra.sl[6]=1822; /* line # 1822 */
    Rv0=((V *)F_id)[5];
  }
  Ra.sl[6]=1823; /* line # 1823 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1824; /* line # 1824 */
    Rv1=Rv0;
    Rv2=F_vp;
    Ra.sl[6]=1825; /* line # 1825 */
    if (!((UB *)Rv1)[92]&&((UB *)Rv2)[48]!=21) {
      Ra.sl[6]=1827; /* line # 1827 */
      Rv3=((SL *)Rv1)[11];
      Ra.sl[6]=1828; /* line # 1828 */
      if (((SL *)Rv2)[6]>0) {
        Ra.sl[6]=1829; /* line # 1829 */
        if (Rv0==V_typ_std.v[10]) {
          Ra.sl[6]=1830; /* line # 1830 */
          ((SL *)Rv1)[11]=((SL *)Rv2)[6]+((SL *)Rv1)[10];
        }
        else {
          Ra.sl[6]=1832; /* line # 1832 */
          ((SL *)Rv1)[11]=((SL *)Rv2)[6];
        }
      }
      else {
        Ra.sl[6]=1833; /* line # 1833 */
        ((SL *)Rv1)[11]=0;
      }
      Ra.sl[6]=1834; /* line # 1834 */
      P_all_new(((V *)Rv2)+5,Rv0, F_id,12);
      Ra.sl[6]=1835; /* line # 1835 */
      if (F_id!=NULL) ((V *)F_id)[8]=((V *)Rv2)[5];
      Ra.sl[6]=1836; /* line # 1836 */
      ((SL *)Rv1)[11]=Rv3;
      Ra.sl[6]=1837; /* line # 1837 */
      if (V_all_fdata==NULL) V_all_fdata=((V *)Rv2)[5];
      else {
        Ra.sl[6]=1838; /* line # 1838 */
        ((V *)V_all_ldata)[0]=((V *)Rv2)[5];
      }
      Ra.sl[6]=1839; /* line # 1839 */
      ((V *)((V *)Rv2)[5])[1]=V_all_ldata;
      Ra.sl[6]=1840; /* line # 1840 */
      V_all_ldata=((V *)Rv2)[5];
      Ra.sl[6]=1841; /* line # 1841 */
      Rv4=((V *)Rv2)[5];
      Ra.sl[6]=1843; /* line # 1843 */
      ((V *)Rv4)[13]=F_vp;
      Ra.sl[6]=1844; /* line # 1844 */
      Rv5=((V *)Rv4)[13];
      ((SL *)Rv5)[3]=((SL *)Rv5)[3]+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_new_typ "  */
void P_ide_new_typ(UB F_frm, V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+652;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1855; /* line # 1855 */
  (*F_p)=PAS__NEW(128);
  Ra.sl[6]=1856; /* line # 1856 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=1857; /* line # 1857 */
    Rv0=(*F_p);
    Ra.sl[6]=1859; /* line # 1859 */
    ((V *)Rv0)[0]=NULL;
    Ra.sl[6]=1860; /* line # 1860 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=1861; /* line # 1861 */
    Rv1=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=1863; /* line # 1863 */
    ((V *)Rv0)[2]=((V *)Rv1)[5];
    Ra.sl[6]=1864; /* line # 1864 */
    ((V *)Rv1)[5]=(*F_p);
    Ra.sl[6]=1866; /* line # 1866 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[6]=1867; /* line # 1867 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=1868; /* line # 1868 */
    ((SL *)Rv0)[10]=0;
    Ra.sl[6]=1869; /* line # 1869 */
    ((SL *)Rv0)[11]=V_inte_size;
    Ra.sl[6]=1870; /* line # 1870 */
    ((UB *)Rv0)[48]=0;
    Ra.sl[6]=1871; /* line # 1871 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=1872; /* line # 1872 */
    ((V *)Rv0)[8]=NULL;
    Ra.sl[6]=1873; /* line # 1873 */
    ((V *)Rv0)[9]=NULL;
    Ra.sl[6]=1874; /* line # 1874 */
    ((V *)Rv0)[10]=NULL;
    Ra.sl[6]=1875; /* line # 1875 */
    ((UB *)Rv0)[89]=0;
    Ra.sl[6]=1876; /* line # 1876 */
    ((UB *)Rv0)[90]=0;
    Ra.sl[6]=1877; /* line # 1877 */
    ((UB *)Rv0)[91]=0;
    Ra.sl[6]=1878; /* line # 1878 */
    switch (F_frm) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 11:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 19:
      case 22:Ra.sl[6]=1883; /* line # 1883 */
      ((UB *)Rv0)[92]=1;
      break;
      default:Ra.sl[6]=1885; /* line # 1885 */
      ((UB *)Rv0)[92]=0;
      break;
    }
    Ra.sl[6]=1887; /* line # 1887 */
    ((UB *)Rv0)[93]=F_frm;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_new_typ_range "  */
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+665;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1899; /* line # 1899 */
  P_ide_new_typ(2, F_typ);
  Ra.sl[6]=1900; /* line # 1900 */
  Rv0=(*F_typ);
  Ra.sl[6]=1902; /* line # 1902 */
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=1903; /* line # 1903 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=1904; /* line # 1904 */
  if (F_parent!=NULL) {
    Ra.sl[6]=1906; /* line # 1906 */
    ((V *)Rv0)[0]=F_parent;
    Ra.sl[6]=1907; /* line # 1907 */
    ((UB *)Rv0)[93]=((UB *)F_parent)[93];
    Ra.sl[6]=1908; /* line # 1908 */
    ((SL *)Rv0)[11]=((SL *)F_parent)[11];
    Ra.sl[6]=1909; /* line # 1909 */
    memcpy(Rv0+48,F_parent+48,1);
    Ra.sl[6]=1910; /* line # 1910 */
    ((UB *)Rv0)[112]=((UB *)F_parent)[112];
  }
  else {
    Ra.sl[6]=1914; /* line # 1914 */
    ((UB *)Rv0)[48]=0;
    Ra.sl[6]=1915; /* line # 1915 */
    ((UB *)Rv0)[112]=F_min>=0;
    Ra.sl[6]=1916; /* line # 1916 */
    ((SL *)Rv0)[11]=4;
  }
  Ra.sl[6]=1918; /* line # 1918 */
  ((UB *)Rv0)[89]=1;
  Ra.sl[6]=1919; /* line # 1919 */
  ((SL *)Rv0)[29]=F_min;
  ((SL *)Rv0)[30]=F_max;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tmpstk_allocate "  */
void P_tmpstk_allocate(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+684;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1931; /* line # 1931 */
  Rv0=PAS__NEW(24);
  Ra.sl[6]=1932; /* line # 1932 */
  ((V *)Rv0)[0]=V_wildtmp_stk;
  Ra.sl[6]=1933; /* line # 1933 */
  ((V *)Rv0)[1]=F_lgt;
  Ra.sl[6]=1934; /* line # 1934 */
  if (V_wildtmp_stk!=NULL) {
    Ra.sl[6]=1935; /* line # 1935 */
    ((SL *)Rv0)[5]=((SL *)V_wildtmp_stk)[4];
  }
  else {
    Ra.sl[6]=1937; /* line # 1937 */
    ((SL *)Rv0)[5]=0;
  }
  Ra.sl[6]=1939; /* line # 1939 */
  ((SL *)Rv0)[4]=P_typ_alignement(((SL *)Rv0)[5],F_ty+48);
  Ra.sl[6]=1940; /* line # 1940 */
  ((SL *)F_lgt)[4]=((SL *)Rv0)[4];
  Ra.sl[6]=1945; /* line # 1945 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[4]+abs(((SL *)F_ty)[11]);
  Ra.sl[6]=1947; /* line # 1947 */
  if (((UB *)V_wildtmp_typ)[48]<((UB *)F_ty)[48]) {
    Ra.sl[6]=1949; /* line # 1949 */
    memcpy(V_wildtmp_pal.s,V_wildtmp_typ+48,1);
    Ra.sl[6]=1950; /* line # 1950 */
    memcpy(V_wildtmp_typ+48,F_ty+48,1);
  }
  Ra.sl[6]=1953; /* line # 1953 */
  if (((SL *)V_wildtmp_typ)[11]<((SL *)Rv0)[4]) {
    Ra.sl[6]=1955; /* line # 1955 */
    V_wildtmp_psz=((SL *)V_wildtmp_typ)[11];
    Ra.sl[6]=1956; /* line # 1956 */
    ((SL *)V_wildtmp_typ)[11]=((SL *)Rv0)[4];
  }
  Ra.sl[6]=1958; /* line # 1958 */
  V_wildtmp_stk=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tmpstk_free "  */
void P_tmpstk_free(V F_stkp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+701;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1969; /* line # 1969 */
  while (F_stkp!=V_wildtmp_stk&&V_wildtmp_stk!=NULL){
    Ra.sl[6]=1971; /* line # 1971 */
    Rv0=V_wildtmp_stk;
    Ra.sl[6]=1972; /* line # 1972 */
    V_wildtmp_stk=((V *)V_wildtmp_stk)[0];
    Ra.sl[6]=1973; /* line # 1973 */
    PAS__DISPOSE(&Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_ide_list "  */
void P_free_ide_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+714;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1988; /* line # 1988 */
  while ((*F_p)!=NULL){
    Ra.sl[6]=1990; /* line # 1990 */
    Rv0=(*F_p);
    Ra.sl[6]=1992; /* line # 1992 */
    Rv1=((V *)(*F_p))[3];
    Ra.sl[6]=1993; /* line # 1993 */
    switch (((UB *)Rv0)[53]) {
      case 3:
      case 13:Ra.sl[6]=1995; /* line # 1995 */
      PAS__DISPOSE(F_p);
      break;
      case 4:Ra.sl[6]=1999; /* line # 1999 */
      P_val_free(((V *)Rv0)+7);
      PAS__DISPOSE(F_p);
      break;
      case 2:Ra.sl[6]=2004; /* line # 2004 */
      if (((V *)Rv0)[10]!=NULL) {
        Ra.sl[6]=2005; /* line # 2005 */
        P_val_free(((V *)Rv0)+10);
      }
      Ra.sl[6]=2006; /* line # 2006 */
      PAS__DISPOSE(F_p);
      break;
      case 5:Ra.sl[6]=2011; /* line # 2011 */
      if (((V *)Rv0)[7]!=NULL) {
        Ra.sl[6]=2012; /* line # 2012 */
        P_val_free(((V *)Rv0)+7);
      }
      Ra.sl[6]=2013; /* line # 2013 */
      PAS__DISPOSE(F_p);
      break;
      case 6:Ra.sl[6]=2016; /* line # 2016 */
      PAS__DISPOSE(F_p);
      break;
      case 10:Ra.sl[6]=2020; /* line # 2020 */
      Rv2=((V *)Rv0)[7];
      Ra.sl[6]=2021; /* line # 2021 */
      while (Rv2!=NULL){
        Ra.sl[6]=2023; /* line # 2023 */
        Rv2=((V *)((V *)Rv0)[7])[0];
        Ra.sl[6]=2025; /* line # 2025 */
        PAS__DISPOSE(((V *)Rv0)+7);
        Ra.sl[6]=2026; /* line # 2026 */
        ((V *)Rv0)[7]=Rv2;
      }
      Ra.sl[6]=2028; /* line # 2028 */
      PAS__DISPOSE(F_p);
      break;
      case 7:Ra.sl[6]=2033; /* line # 2033 */
      Rv3=((V *)Rv0)[8];
      Ra.sl[6]=2035; /* line # 2035 */
      P_free_ide_list(((V *)Rv3)+8);
      Ra.sl[6]=2036; /* line # 2036 */
      P_free_typ_list(((V *)Rv3)+12);
      Ra.sl[6]=2038; /* line # 2038 */
      PAS__DISPOSE(((V *)Rv0)+8);
      Ra.sl[6]=2039; /* line # 2039 */
      PAS__DISPOSE(F_p);
      break;
      case 0:Ra.sl[6]=2042; /* line # 2042 */
      PAS__DISPOSE(F_p);
      break;
      case 1:
      case 8:
      case 9:Ra.sl[6]=2048; /* line # 2048 */
      P_free_generic_list(((V *)Rv0)+10,((V *)Rv0)+11);
      Ra.sl[6]=2049; /* line # 2049 */
      PAS__DISPOSE(F_p);
      break;
      default:break;
    }
    Ra.sl[6]=2054; /* line # 2054 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_typ_list "  */
void P_free_typ_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+729;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2067; /* line # 2067 */
  while ((*F_p)!=NULL){
    Ra.sl[6]=2069; /* line # 2069 */
    Rv0=(*F_p);
    Ra.sl[6]=2071; /* line # 2071 */
    if (((V *)Rv0)[10]!=NULL) {
      Ra.sl[6]=2072; /* line # 2072 */
      P_val_free(((V *)Rv0)+10);
    }
    Ra.sl[6]=2073; /* line # 2073 */
    P_free_ide_list(((V *)Rv0)+4);
    Ra.sl[6]=2074; /* line # 2074 */
    P_lgt_free_tree(((V *)Rv0)+9);
    Ra.sl[6]=2075; /* line # 2075 */
    Rv1=((V *)Rv0)[2];
    Ra.sl[6]=2076; /* line # 2076 */
    switch (((UB *)Rv0)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=2080; /* line # 2080 */
      P_free_ide_list(((V *)Rv0)+12);
      Ra.sl[6]=2081; /* line # 2081 */
      P_lgt_free(((V *)Rv0)+13);
      break;
      case 8:Ra.sl[6]=2083; /* line # 2083 */
      P_lgt_free_tree(((V *)Rv0)+13);
      break;
      case 10:
      case 23:Ra.sl[6]=2086; /* line # 2086 */
      if (((UB *)Rv0)[93]==10) {
        Ra.sl[6]=2087; /* line # 2087 */
        P_free_ide_list(((V *)Rv0)+12);
      }
      Ra.sl[6]=2088; /* line # 2088 */
      P_lgt_free_tree(((V *)Rv0)+14);
      break;
      case 22:Ra.sl[6]=2091; /* line # 2091 */
      if (((V *)Rv0)[12]!=NULL) P_lgt_free_tree(((V *)Rv0)+12);
      Ra.sl[6]=2092; /* line # 2092 */
      if (((V *)Rv0)[13]!=NULL) P_lgt_free_tree(((V *)Rv0)+13);
      Ra.sl[6]=2093; /* line # 2093 */
      if (((V *)Rv0)[14]!=NULL) P_lgt_free_tree(((V *)Rv0)+14);
      break;
      case 6:Ra.sl[6]=2096; /* line # 2096 */
      Rv2=((V *)Rv0)[13];
      Ra.sl[6]=2098; /* line # 2098 */
      P_free_ide_list(((V *)Rv2)+8);
      Ra.sl[6]=2099; /* line # 2099 */
      P_free_typ_list(((V *)Rv2)+12);
      Ra.sl[6]=2101; /* line # 2101 */
      PAS__DISPOSE(((V *)Rv0)+13);
      break;
      default:break;
    }
    Ra.sl[6]=2105; /* line # 2105 */
    P_lgt_free_tree(((V *)Rv0)+7);
    Ra.sl[6]=2106; /* line # 2106 */
    PAS__DISPOSE(F_p);
    Ra.sl[6]=2108; /* line # 2108 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_ope_list "  */
void PAS_IDENT_free_ope_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+744;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2121; /* line # 2121 */
  while ((*F_p)!=NULL){
    Ra.sl[6]=2123; /* line # 2123 */
    Rv0=(*F_p);
    Ra.sl[6]=2125; /* line # 2125 */
    V_ope_table.v[((UB *)Rv0)[0]]=((V *)Rv0)[2];
    Ra.sl[6]=2126; /* line # 2126 */
    P_free_generic_list(((V *)Rv0)+3,((V *)Rv0)+4);
    Ra.sl[6]=2127; /* line # 2127 */
    Rv1=((V *)Rv0)[1];
    Ra.sl[6]=2129; /* line # 2129 */
    PAS__DISPOSE(F_p);
    Ra.sl[6]=2130; /* line # 2130 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_generic_list "  */
void P_free_generic_list(V *F_f, V *F_l){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+759;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2143; /* line # 2143 */
  if ((*F_f)!=NULL) while (1){
    Ra.sl[6]=2145; /* line # 2145 */
    Rv0=(*F_f);
    Ra.sl[6]=2146; /* line # 2146 */
    Rv1=Rv0;
    Ra.sl[6]=2147; /* line # 2147 */
    if (!((UB *)Rv1)[8]) {
      Ra.sl[6]=2149; /* line # 2149 */
      Rv2=((V *)Rv1)[2];
      Ra.sl[6]=2151; /* line # 2151 */
      if (((UB *)Rv2)[104]==11) {
        Ra.sl[6]=2153; /* line # 2153 */
        P_free_ide_list(((V *)Rv2)+23);
        Ra.sl[6]=2154; /* line # 2154 */
        P_free_ide_list(((V *)Rv2)+21);
        Ra.sl[6]=2155; /* line # 2155 */
        P_free_typ_list(((V *)Rv2)+24);
        Ra.sl[6]=2156; /* line # 2156 */
        PAS_IDENT_free_ope_list(((V *)Rv2)+19);
      }
      Ra.sl[6]=2158; /* line # 2158 */
      P_free_ide_list(((V *)Rv2)+8);
      Ra.sl[6]=2159; /* line # 2159 */
      P_free_typ_list(((V *)Rv2)+12);
      Ra.sl[6]=2162; /* line # 2162 */
      if (((UB *)Rv2)[104]==10) {
        Ra.sl[6]=2164; /* line # 2164 */
        if (((V *)Rv2)[25]!=NULL) {
          Ra.sl[6]=2166; /* line # 2166 */
          ((V *)((V *)Rv2)[26])[0]=V_all_free_list;
          Ra.sl[6]=2167; /* line # 2167 */
          V_all_free_list=((V *)Rv2)[25];
        }
      }
      Ra.sl[6]=2171; /* line # 2171 */
      PAS__DISPOSE(((V *)Rv1)+2);
    }
    Ra.sl[6]=2173; /* line # 2173 */
    if ((*F_f)!=(*F_l)) (*F_f)=((V *)(*F_f))[0];
    Ra.sl[6]=2174; /* line # 2174 */
    PAS__DISPOSE(&Rv0);
    if ((*F_f)==(*F_l))  break;
  }
  Ra.sl[6]=2176; /* line # 2176 */
  (*F_f)=NULL;
  (*F_l)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_free_lex "  */
void P_ide_free_lex(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+778;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2188; /* line # 2188 */
  if (F_p!=NULL) {
    Ra.sl[6]=2189; /* line # 2189 */
    Rv0=F_p;
    Ra.sl[6]=2190; /* line # 2190 */
    if (((UB *)Rv0)[104]!=11) {
      Ra.sl[6]=2193; /* line # 2193 */
      P_free_ide_list(((V *)Rv0)+23);
      Ra.sl[6]=2194; /* line # 2194 */
      P_free_ide_list(((V *)Rv0)+21);
      Ra.sl[6]=2195; /* line # 2195 */
      P_free_typ_list(((V *)Rv0)+24);
      Ra.sl[6]=2196; /* line # 2196 */
      PAS_IDENT_free_ope_list(((V *)Rv0)+19);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_create_name "  */
void P_ide_create_name(V F_name){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+792;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2209; /* line # 2209 */
  PAS__STR_TO_STR(Ri.s+1,V_sy_string.s);
  Ra.sl[6]=2210; /* line # 2210 */
  Ri.ub[0]=1;
  Ra.sl[6]=2211; /* line # 2211 */
  Rv0=PAS__LENGTH_STR(F_name);
  Ra.sl[6]=2212; /* line # 2212 */
  if (Rv0>31) Rv0=31;
  Ra.sl[6]=2213; /* line # 2213 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.sl[6]=2214; /* line # 2214 */
    V_sy_ident.c[Rv1]=((C *)F_name)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=2215; /* line # 2215 */
  V_sy_ident.ub[0]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_int_label "  */
void P_ide_int_label(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+809;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2230; /* line # 2230 */
  Rv0=V_sy_ival;
  Ra.sl[6]=2231; /* line # 2231 */
  if (Rv0<=0||Rv0>9999) {
    Ra.sl[6]=2233; /* line # 2233 */
    P_src_error(Rd.s+826,68,3);
    Ra.sl[6]=2234; /* line # 2234 */
    Rv0=0;
  }
  Ra.sl[6]=2236; /* line # 2236 */
  Rv1=5;
  Ra.sl[6]=2237; /* line # 2237 */
  while (Rv1>1){
    Ra.sl[6]=2239; /* line # 2239 */
    V_sy_ident.c[Rv1]=(C)(PAS__I_MOD(Rv0,10)+48);
    Ra.sl[6]=2240; /* line # 2240 */
    Rv1=Rv1-1;
    Ra.sl[6]=2241; /* line # 2241 */
    Rv0=Rv0/10;
  }
  Ra.sl[6]=2243; /* line # 2243 */
  V_sy_ident.c[1]=46;
  Ra.sl[6]=2244; /* line # 2244 */
  V_sy_ident.ub[0]=5;
  Ra.sl[6]=2245; /* line # 2245 */
  V_sy_sym.ub[0]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search_from_nameid "  */
V P_ide_search_from_nameid(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+830;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2260; /* line # 2260 */
  Rv0=NULL;
  Ra.sl[6]=2261; /* line # 2261 */
  if (F_ip!=NULL) {
    Ra.sl[6]=2262; /* line # 2262 */
    Rv1=F_ip;
    Ra.sl[6]=2263; /* line # 2263 */
    if (((V *)Rv1)[0]!=NULL) {
      Ra.sl[6]=2265; /* line # 2265 */
      V_curr_ident=((V *)F_ip)[0];
      Ra.sl[6]=2266; /* line # 2266 */
      Rv0=P_ide_search(1<<((UB *)Rv1)[53]);
      Ra.sl[6]=2267; /* line # 2267 */
      V_curr_ident=NULL;
    }
  }
  Ra.sl[6]=2269; /* line # 2269 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " set_gbl_def_nam "  */
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+854;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2281; /* line # 2281 */
  (*F_trg)=PAS__NEW(32);
  Ra.sl[6]=2282; /* line # 2282 */
  Rv0=(*F_trg);
  Ra.sl[6]=2284; /* line # 2284 */
  ((C *)Rv0)[1]=F_ach;
  ((C *)Rv0)[2]=95;
  Ra.sl[6]=2285; /* line # 2285 */
  if (((UB *)F_src)[0]<=29) {
    Ra.sl[6]=2287; /* line # 2287 */
    Rv1=1;
    for( Rf0=((UB *)F_src)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv1+2)]=((C *)F_src)[Rv1];
      Rv1++;
    }
    Ra.sl[6]=2288; /* line # 2288 */
    ((UB *)Rv0)[0]=((UB *)F_src)[0]+2;
  }
  else {
    Ra.sl[6]=2292; /* line # 2292 */
    Rv2=1;
    for( Rf0=27;Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv2+2)]=((C *)F_src)[Rv2];
      Rv2++;
    }
    Ra.sl[6]=2293; /* line # 2293 */
    Rv3=((UB *)F_src)[0]-3;
    for( Rf0=(((UB *)F_src)[0]+1)-(((UB *)F_src)[0]-3);Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv3+2)]=((C *)F_src)[Rv3];
      Rv3++;
    }
    Ra.sl[6]=2294; /* line # 2294 */
    ((UB *)Rv0)[0]=31;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_file_extention "  */
V P_set_file_extention(V F_pf, V F_ex){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  V Rv2;
  register UB Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+871;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2307; /* line # 2307 */
  Rv0=((UB *)F_pf)[1];
  Ra.sl[6]=2308; /* line # 2308 */
  if (PAS__NINDEX_CHA(F_pf+2,(SL)((UB *)F_pf)[1],46,-1,-1,1)<=0) {
    Ra.sl[6]=2310; /* line # 2310 */
    Rv1=Rv0+((UB *)F_ex)[1];
    Rv2=PAS__NEW((SL)Rv1+2);
    ((UB *)Rv2)[0]=Rv1;
    Ra.sl[6]=2311; /* line # 2311 */
    PAS__STR_TO_STR(Rv2,PAS__CON_STR_STR(Ra.s+28,F_pf,F_ex));
  }
  else {
    Ra.sl[6]=2313; /* line # 2313 */
    Rv3=Rv0;
    Rv2=PAS__NEW((SL)Rv3+2);
    ((UB *)Rv2)[0]=Rv3;
    Ra.sl[6]=2314; /* line # 2314 */
    PAS__STR_TO_STR(Rv2,F_pf);
  }
  Ra.sl[6]=2316; /* line # 2316 */
  Ret=Rv2;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " set_env_file_spc "  */
void P_set_env_file_spc(V F_pcur){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+891;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2331; /* line # 2331 */
  Rv0=0;
  Ra.sl[6]=2332; /* line # 2332 */
  Rv1=V_env_first;
  Ra.sl[6]=2333; /* line # 2333 */
  Rv2=NULL;
  Ra.sl[6]=2334; /* line # 2334 */
  Rv3=NULL;
  Ra.sl[6]=2336; /* line # 2336 */
  if (PAS__NINDEX_CHA(V_sy_string.s+2,(SL)V_sy_string.ub[1],46,-1,-1,1)==0) {
    Ra.sl[6]=2337; /* line # 2337 */
    Rv4=V_sy_string.ub[1];
    Rv3=PAS__NEW((SL)Rv4+2);
    ((UB *)Rv3)[0]=Rv4;
  }
  Ra.sl[6]=2338; /* line # 2338 */
  PAS__STR_TO_STR(Rv3,V_sy_string.s);
  Ra.sl[6]=2339; /* line # 2339 */
  while (!Rv0&&Rv1!=NULL){
    Ra.sl[6]=2341; /* line # 2341 */
    if (PAS__MATCH_STR(Rv3,((V *)Rv1)[1])==0) Rv0=1;
    else {
      Ra.sl[6]=2344; /* line # 2344 */
      Rv2=Rv1;
      Ra.sl[6]=2345; /* line # 2345 */
      Rv1=((V *)Rv1)[0];
    }
  }
  Ra.sl[6]=2349; /* line # 2349 */
  if (Rv0) PAS__DISPOSE(&Rv3);
  else {
    Ra.sl[6]=2352; /* line # 2352 */
    Rv1=PAS__NEW(28);
    Ra.sl[6]=2353; /* line # 2353 */
    Rv5=Rv1;
    Ra.sl[6]=2355; /* line # 2355 */
    ((V *)Rv5)[0]=F_pcur;
    Ra.sl[6]=2356; /* line # 2356 */
    ((V *)Rv5)[1]=Rv3;
    Ra.sl[6]=2357; /* line # 2357 */
    ((SL *)Rv5)[6]=0;
    Ra.sl[6]=2359; /* line # 2359 */
    if (F_pcur!=NULL) {
      Ra.sl[6]=2361; /* line # 2361 */
      if (F_pcur==V_env_first) V_env_first=Rv1;
    }
    else {
      Ra.sl[6]=2365; /* line # 2365 */
      if (V_env_first==NULL) V_env_first=Rv1;
      else {
        Ra.sl[6]=2366; /* line # 2366 */
        ((V *)V_env_last)[0]=Rv1;
      }
      Ra.sl[6]=2367; /* line # 2367 */
      V_env_last=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " new_oparg "  */
void P_new_oparg(V F_ty, UB F_cv, UW F_pr, V F_tb, UB F_bini){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+909;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2380; /* line # 2380 */
  if (F_bini) Ri.sl[65]=1;
  else {
    Ra.sl[6]=2381; /* line # 2381 */
    if (Ri.sl[65]<((SL *)F_tb)[0]) Ri.sl[65]=Ri.sl[65]+1;
  }
  Ra.sl[6]=2382; /* line # 2382 */
  Rv0=(((S *)F_tb)+Ri.sl[65]*16-8);
  Ra.sl[6]=2384; /* line # 2384 */
  ((V *)Rv0)[0]=F_ty;
  Ra.sl[6]=2385; /* line # 2385 */
  ((UB *)Rv0)[8]=F_cv;
  Ra.sl[6]=2386; /* line # 2386 */
  ((UW *)Rv0)[5]=F_pr;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " new_oper "  */
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register SL Rv3;
  register SL Rv4;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+920;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2407; /* line # 2407 */
  if (F_it2!=NULL) Rv0=2;
  else {
    Ra.sl[6]=2408; /* line # 2408 */
    Rv0=1;
  }
  Ra.sl[6]=2409; /* line # 2409 */
  Rv1=PAS__NEW(32);
  Ra.sl[6]=2410; /* line # 2410 */
  Rv2=Rv1;
  Ra.sl[6]=2412; /* line # 2412 */
  ((V *)Rv2)[0]=NULL;
  Ra.sl[6]=2413; /* line # 2413 */
  ((UB *)Rv2)[8]=1;
  Ra.sl[6]=2414; /* line # 2414 */
  ((UB *)Rv2)[9]=F_pcd;
  Ra.sl[6]=2415; /* line # 2415 */
  ((V *)Rv2)[2]=F_rty;
  Ra.sl[6]=2416; /* line # 2416 */
  Rv3=Rv0;
  ((V *)Rv2)[3]=PAS__NEW(Rv3*16+8);
  ((SL *)((V *)Rv2)[3])[0]=Rv3;
  Rv4=0;
  for( Rf0=Rv3;Rf0>0;Rf0-- )
  Rv4++;
  Ra.sl[6]=2417; /* line # 2417 */
  P_new_oparg(F_it1, F_cv1, F_ip1,((V *)Rv2)[3],1);
  Ra.sl[6]=2418; /* line # 2418 */
  if (F_it2!=NULL) P_new_oparg(F_it2, F_cv2, F_ip2,((V *)Rv2)[3],0);
  Ra.sl[6]=2420; /* line # 2420 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " write_oparg "  */
void PAS_IDENT_PRC_00000000(V F_arg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+930;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2437; /* line # 2437 */
  Ra.sl[6]=2439; /* line # 2439 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+943,-1,-1,32);
  Ra.sl[6]=2440; /* line # 2440 */
  if (((V *)F_arg)[0]!=NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_ENM(((UB *)((V *)F_arg)[0])[93],Rd.s+948,0,-1,32);
  }
  else {
    Ra.sl[6]=2441; /* line # 2441 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1512,-1,-1,32);
  }
  Ra.sl[6]=2442; /* line # 2442 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1517,-1,-1,32);
  PAS__WRITE_ENM(((UB *)F_arg)[8],Rd.s+1524,0,-1,32);
  PAS__WRITE_STR(Rd.s+1579,-1,-1,32);
  Ra.sl[6]=2443; /* line # 2443 */
  Rv1=0;
  for( Rf0=9;Rf0>0;Rf0-- ) {
    Ra.sl[6]=2445; /* line # 2445 */
    if (Rv0) Rv0=0;
    else {
      Ra.sl[6]=2446; /* line # 2446 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(44);
    }
    Ra.sl[6]=2447; /* line # 2447 */
    if (1<<Rv1&((UW *)F_arg)[5]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_ENM(Rv1, Rd.s+1584,0,-1,32);
    }
    Rv1++;
  }
  Ra.sl[6]=2449; /* line # 2449 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1644,-1,-1,32);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wiew_oper_def "  */
void P_wiew_oper_def(UB F_op){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1648;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2455; /* line # 2455 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1663,-1,-1,32);
  PAS__WRITE_CHT((V_opname.s+F_op*32+1),31, V_opname.ub[F_op*32],-1,32);
  PAS__WRITE_STR(Rd.s+1680,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=2456; /* line # 2456 */
  Rv1=((V *)V_ope_table.v[F_op])[3];
  Ra.sl[6]=2457; /* line # 2457 */
  while (Rv1!=NULL){
    Ra.sl[6]=2458; /* line # 2458 */
    Rv2=Rv1;
    Ra.sl[6]=2460; /* line # 2460 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    Ra.sl[6]=2461; /* line # 2461 */
    if (((UB *)Rv2)[8]) {
      Ra.sl[6]=2463; /* line # 2463 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1705,-1,-1,32);
      PAS__WRITE_ENM(((UB *)Rv2)[9],Rd.s+1712,0,-1,32);
      PAS__WRITE_CHAR(40);
      Ra.sl[6]=2464; /* line # 2464 */
      Rv3=1;
      for( Rf0=((SL *)((V *)Rv2)[3])[0];Rf0>0;Rf0-- ) {
        Ra.sl[6]=2466; /* line # 2466 */
        if (Rv0) Rv0=0;
        else {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+3766,-1,-1,32);
        }
        Ra.sl[6]=2467; /* line # 2467 */
        PAS_IDENT_PRC_00000000((((S *)((V *)Rv2)[3])+Rv3*16-8));
        Rv3++;
      }
      Ra.sl[6]=2469; /* line # 2469 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+3770,-1,-1,32);
      Ra.sl[6]=2470; /* line # 2470 */
      if (((V *)Rv2)[2]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3774,-1,-1,32);
        PAS__WRITE_ENM(((UB *)((V *)Rv2)[2])[93],Rd.s+948,0,-1,32);
        PAS__WRITE_CHAR(59);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[6]=2471; /* line # 2471 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3778,-1,-1,32);
        PAS__WRITE_EOLN();
      }
    }
    else {
      Ra.sl[6]=2474; /* line # 2474 */
      Rv4=((V *)Rv2)[2];
      Ra.sl[6]=2476; /* line # 2476 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      Ra.sl[6]=2477; /* line # 2477 */
      if (((V *)Rv4)[11]==NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3783,-1,-1,32);
      }
      else {
        Ra.sl[6]=2478; /* line # 2478 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3795,-1,-1,32);
      }
      Ra.sl[6]=2479; /* line # 2479 */
      Rv5=((V *)Rv4)[3];
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHT(Rv5+1,31,((UB *)Rv5)[0],-1,32);
      PAS__WRITE_CHAR(40);
      Ra.sl[6]=2480; /* line # 2480 */
      Rv6=((V *)Rv4)[8];
      Ra.sl[6]=2481; /* line # 2481 */
      while (Rv6!=NULL){
        Ra.sl[6]=2482; /* line # 2482 */
        Rv7=Rv6;
        Ra.sl[6]=2484; /* line # 2484 */
        if (((UB *)Rv7)[86]!=7) {
          Ra.sl[6]=2486; /* line # 2486 */
          Rv8=((V *)Rv7)[0];
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(Rv8+1,31,((UB *)Rv8)[0],-1,32);
          PAS__WRITE_STR(Rd.s+3806,-1,-1,32);
          Ra.sl[6]=2487; /* line # 2487 */
          Rv9=((V *)Rv7)[5];
          Ra.sl[6]=2488; /* line # 2488 */
          if (((V *)Rv9)[3]!=NULL) {
            Ra.sl[6]=2489; /* line # 2489 */
            Rv10=((V *)((V *)Rv9)[3])[0];
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_CHT(Rv10+1,31,((UB *)Rv10)[0],-1,32);
          }
          else {
            Ra.sl[6]=2491; /* line # 2491 */
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_STR(Rd.s+3810,-1,-1,32);
            PAS__WRITE_ENM(((UB *)Rv9)[93],Rd.s+948,0,-1,32);
            PAS__WRITE_CHAR(62);
          }
          Ra.sl[6]=2492; /* line # 2492 */
          if (((V *)Rv7)[3]!=NULL) {
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_STR(Rd.s+3817,-1,-1,32);
          }
        }
        Ra.sl[6]=2494; /* line # 2494 */
        Rv6=((V *)Rv7)[3];
      }
      Ra.sl[6]=2496; /* line # 2496 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(41);
      Ra.sl[6]=2497; /* line # 2497 */
      if (((V *)Rv4)[11]!=NULL) {
        Ra.sl[6]=2498; /* line # 2498 */
        Rv11=((V *)Rv4)[11];
        Ra.sl[6]=2500; /* line # 2500 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+3821,-1,-1,32);
        Ra.sl[6]=2501; /* line # 2501 */
        if (((V *)Rv11)[3]!=NULL) {
          Ra.sl[6]=2502; /* line # 2502 */
          Rv12=((V *)((V *)Rv11)[3])[0];
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHT(Rv12+1,31,((UB *)Rv12)[0],-1,32);
        }
        else {
          Ra.sl[6]=2504; /* line # 2504 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+3825,-1,-1,32);
          PAS__WRITE_ENM(((UB *)Rv11)[93],Rd.s+948,0,-1,32);
          PAS__WRITE_CHAR(62);
        }
      }
      Ra.sl[6]=2506; /* line # 2506 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(59);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=2508; /* line # 2508 */
    Rv1=((V *)Rv2)[0];
  }
  Ra.sl[6]=2510; /* line # 2510 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}
