/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 1168 ) = {{
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  62,  62,  47,
104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  51,  47,
112,  99, 109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115,
101, 116,  95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,
  9,   9, 115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109,
112,  97, 114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,
 97, 114, 101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,
 99, 111, 109, 112,  95, 115,  99,  97, 108,  97, 114,  13,  13,  99, 104, 105,
108, 100, 114, 101, 110,  95, 116, 121, 112, 101,  13,  13, 115, 117,  98,  95,
 99, 111, 109, 112,  95, 116, 121, 112, 101,   1,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   3,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   4,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,
  0,   0,   0,   0,   4,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   1,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   0,   0,   4,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   4,   4,   4,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   4,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,
  0,   0,   4,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,
  4,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   4,   4,   4,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   9,   9,  99,
111, 109, 112,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112,
114, 111,  99,  95,  97, 114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97,
114, 109,  95,  99, 116, 101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,
 49,  21,  21, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,
 95, 114, 101, 108, 101,  97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,
 95, 105, 110,  95,  97, 114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110,
103,  95, 105, 110,  95, 115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16,
105, 110, 105, 116, 105,  97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,
 15,  15, 116, 121, 112, 101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114,
109,   4,   4,  84,  89,  67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,
 95, 115, 101, 116,  95, 118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,
 95, 112,  97, 114, 109,  95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,
 12, 105, 110, 105, 116,  95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100,
121, 110,  95, 114, 101,  99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,
 95, 100, 121, 110,  95, 114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100,
121, 110,  95, 100,   4,   4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,
 95, 100,  95, 100, 121, 110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110,
105, 116,  95, 100,  95, 116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10,
105, 110, 105, 116,  95, 100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,
 13,  13, 105, 110, 105, 116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,
  4,  73,  68,  83,  84,  12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97,
114,  98, 108,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,
  4,   4,  69,  88,  80,  85,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,
 98, 105, 110,   4,   4,  69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95,
102, 111, 114,  95, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,
 99,  97, 108, 108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,
 76,  76,  14,  14, 103, 101, 110, 101, 114, 105,  99,  95, 115, 101,  97, 114,
 99, 104,   4,   4,  71,  69,  78,  83,  11,  11, 101, 120, 112,  95, 103, 101,
110, 111, 112, 101, 114,  13,  13, 103, 101, 110, 101, 114,  97, 116, 101,  95,
 99,  97, 108, 108,   9,   9, 101, 120, 112,  95, 103, 101, 110, 111, 112,  13,
 13, 108, 103, 116,  95, 103, 101, 110,  95, 115, 116, 111, 114, 101,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {{
 29,   0,   0,   0,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 248 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern Blk(V_oparg_cvtab, 56 );
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=97; /* line # 97 */
  if (V_sy_sym.ub[0]==5) {
    Ra.sl[6]=99; /* line # 99 */
    (*F_nam)=PAS__NEW(32);
    Ra.sl[6]=100; /* line # 100 */
    Rv0=(*F_nam);
    Ra.sl[6]=102; /* line # 102 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else {
      Ra.sl[6]=103; /* line # 103 */
      ((UB *)Rv0)[0]=V_sy_string.ub[1];
    }
    Ra.sl[6]=104; /* line # 104 */
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[6]=105; /* line # 105 */
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=107; /* line # 107 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=122; /* line # 122 */
  Rv0=F_pr;
  Ra.sl[6]=124; /* line # 124 */
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+92,129,1);
  Ra.sl[6]=125; /* line # 125 */
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=128; /* line # 128 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[6]=129; /* line # 129 */
    P_src_error(Rd.s+92,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+96;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=143; /* line # 143 */
  V_enm_range=0;
  Ra.sl[6]=144; /* line # 144 */
  Rv0=F_ty1==F_ty2;
  Ra.sl[6]=146; /* line # 146 */
  if (!Rv0) {
    Ra.sl[6]=147; /* line # 147 */
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=148; /* line # 148 */
      if (((((UB *)F_ty1)[93]==((UB *)F_ty2)[93]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) {
        Ra.sl[6]=152; /* line # 152 */
        switch (((UB *)F_ty1)[93]) {
          case 0:
          case 1:
          case 2:Ra.sl[6]=154; /* line # 154 */
          if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)
          F_ty2)[29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) {
            Ra.sl[6]=156; /* line # 156 */
            Rv0=1;
          }
          break;
          case 3:
          case 4:Ra.sl[6]=157; /* line # 157 */
          Rv0=1;
          break;
          case 5:
          case 7:
          case 13:Ra.sl[6]=159; /* line # 159 */
          Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
          break;
          case 11:
          case 12:Ra.sl[6]=161; /* line # 161 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) {
            Ra.sl[6]=162; /* line # 162 */
            Rv0=P_same_type(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          }
          break;
          case 8:
          case 9:Ra.sl[6]=164; /* line # 164 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
          [25]) {
            Ra.sl[6]=166; /* line # 166 */
            if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
            F_ty1)[14],((V *)F_ty2)[14])) {
              Ra.sl[6]=168; /* line # 168 */
              Rv0=1;
            }
          }
          break;
          case 22:Ra.sl[6]=170; /* line # 170 */
          Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
          break;
          case 6:Ra.sl[6]=172; /* line # 172 */
          Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          break;
          default:break;
        }
      }
    }
  }
  Ra.sl[6]=175; /* line # 175 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=188; /* line # 188 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Ra.sl[6]=191; /* line # 191 */
    Rv0=0;
    Ra.sl[6]=192; /* line # 192 */
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=194; /* line # 194 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else {
        Ra.sl[6]=195; /* line # 195 */
        Rv0=1;
      }
      Ra.sl[6]=196; /* line # 196 */
      if (Rv0) {
        Ra.sl[6]=198; /* line # 198 */
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=202; /* line # 202 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Ra.sl[6]=205; /* line # 205 */
          Rv0=P_same_type(((V *)Rv1)[5],((V *)Rv2)[5]);
          Ra.sl[6]=206; /* line # 206 */
          if (Rv0) {
            Ra.sl[6]=208; /* line # 208 */
            if (((UB *)Rv1)[53]==7) {
              Ra.sl[6]=209; /* line # 209 */
              if (((UB *)Rv2)[53]==7) {
                Ra.sl[6]=210; /* line # 210 */
                if (((UB *)((V *)Rv1)[8])[104]==4&&((UB *)((V *)Rv2)[8])[104]==4)
                 {
                  Ra.sl[6]=211; /* line # 211 */
                  Rv0=P_compare_entry(((V *)Rv1)[8],((V *)Rv2)[8]);
                }
                else {
                  Ra.sl[6]=212; /* line # 212 */
                  Rv0=0;
                }
              }
              else {
                Ra.sl[6]=213; /* line # 213 */
                Rv0=0;
              }
            }
            Ra.sl[6]=214; /* line # 214 */
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        Ra.sl[6]=217; /* line # 217 */
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=221; /* line # 221 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+122;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=235; /* line # 235 */
  Rv0=0;
  Ra.sl[6]=236; /* line # 236 */
  if (F_pgc!=NULL&&F_ent!=NULL) {
    Ra.sl[6]=239; /* line # 239 */
    while (F_pgc!=NULL&&!Rv0){
      Ra.sl[6]=240; /* line # 240 */
      Rv1=F_pgc;
      Ra.sl[6]=242; /* line # 242 */
      if (!((UB *)Rv1)[8]) {
        Ra.sl[6]=244; /* line # 244 */
        Rv2=((V *)Rv1)[2];
        Ra.sl[6]=245; /* line # 245 */
        Rv0=P_compare_entry(Rv2, F_ent);
      }
      Ra.sl[6]=247; /* line # 247 */
      if (!Rv0) {
        Ra.sl[6]=248; /* line # 248 */
        if (F_pgc==F_pgl) F_pgc=NULL;
        else {
          Ra.sl[6]=249; /* line # 249 */
          F_pgc=((V *)F_pgc)[0];
        }
      }
    }
  }
  Ra.sl[6]=252; /* line # 252 */
  if (!Rv0) F_pgc=NULL;
  Ra.sl[6]=253; /* line # 253 */
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+142;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=272; /* line # 272 */
  Rv0=4;
  Ra.sl[6]=273; /* line # 273 */
  if (F_te==F_tf) Rv0=0;
  else {
    Ra.sl[6]=274; /* line # 274 */
    if (F_te!=NULL&&F_tf!=NULL) {
      Ra.sl[6]=275; /* line # 275 */
      Rv1=F_te;
      Ra.sl[6]=276; /* line # 276 */
      if (((UB *)Rv1)[93]==((UB *)F_tf)[93]) {
        Ra.sl[6]=277; /* line # 277 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          Ra.sl[6]=280; /* line # 280 */
          if (((UB *)Rv1)[112]) {
            Ra.sl[6]=281; /* line # 281 */
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=283; /* line # 283 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Ra.sl[6]=284; /* line # 284 */
          Rv4=F_tf;
          Ra.sl[6]=285; /* line # 285 */
          if (((UB *)Rv4)[112]) {
            Ra.sl[6]=286; /* line # 286 */
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=288; /* line # 288 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          Ra.sl[6]=290; /* line # 290 */
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          Ra.sl[6]=292; /* line # 292 */
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=294; /* line # 294 */
            if (Rv2==Rv5) {
              Ra.sl[6]=295; /* line # 295 */
              if (Rv3==Rv6) Rv0=0;
              else {
                Ra.sl[6]=296; /* line # 296 */
                Rv0=1;
              }
            }
            else {
              Ra.sl[6]=297; /* line # 297 */
              Rv0=2;
            }
          }
          else {
            Ra.sl[6]=298; /* line # 298 */
            Rv0=3;
          }
        }
        else {
          Ra.sl[6]=300; /* line # 300 */
          V_enm_range=1;
        }
      }
    }
  }
  Ra.sl[6]=301; /* line # 301 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " children_type "  */
UB P_children_type(V F_eff, V F_frm, UB F_bpar, UB F_bsym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=315; /* line # 315 */
  if (F_frm!=NULL) {
    Ra.sl[6]=317; /* line # 317 */
    F_bpar=1;
    Ra.sl[6]=318; /* line # 318 */
    if (F_bpar) {
      Ra.sl[6]=320; /* line # 320 */
      Rv1=F_eff;
      Ra.sl[6]=321; /* line # 321 */
      while (Rv1!=NULL&&Rv1!=F_frm)
      Rv1=((V *)Rv1)[0];
      Ra.sl[6]=322; /* line # 322 */
      Rv0=Rv1==F_frm;
      Ra.sl[6]=323; /* line # 323 */
      if (!Rv0&&F_bsym) Rv0=P_children_type(F_frm, F_eff, F_bpar,0);
    }
    else {
      Ra.sl[6]=325; /* line # 325 */
      Rv0=F_eff==F_frm;
    }
  }
  Ra.sl[6]=327; /* line # 327 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sub_comp_type "  */
UB PAS_EXPSION_PRC_00000000(V F_eff, V F_frm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=383; /* line # 383 */
  Rv0=0;
  Ra.sl[6]=384; /* line # 384 */
  Rv1=F_frm;
  Ra.sl[6]=385; /* line # 385 */
  switch (Rd.ub[((UB *)F_eff)[93]*22+((UB *)Rv1)[93]+185]) {
    case 4:Ra.sl[6]=386; /* line # 386 */
    Rv0=1;
    break;
    case 1:Ra.sl[6]=389; /* line # 389 */
    switch (((UB *)Rv1)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=393; /* line # 393 */
      if (((UB *)Rv1)[89]) {
        Ra.sl[6]=394; /* line # 394 */
        if (!Lx[0].ub[28]) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
        else {
          Ra.sl[6]=395; /* line # 395 */
          Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv1)[11]==((SL *)
          F_eff)[11];
        }
      }
      break;
      case 11:
      case 12:Ra.sl[6]=399; /* line # 399 */
      Rv0=P_comp_type(((V *)F_eff)[13],((V *)Rv1)[13],Lx[0].ub[28],0);
      break;
      case 8:Ra.sl[6]=402; /* line # 402 */
      Rv0=((V *)F_eff)[14]==((V *)Rv1)[14]&&P_comp_type(((V *)F_eff)[15],((V *)Rv1)
      [15],1,1);
      break;
      case 9:Ra.sl[6]=406; /* line # 406 */
      Rv0=P_comp_type(((V *)F_eff)[14],((V *)Rv1)[14],1,0)&&P_comp_type(((V *)F_eff)
      [15],((V *)((V *)Rv1)[15])[0],1,1);
      break;
      case 5:Ra.sl[6]=410; /* line # 410 */
      if (((V *)Rv1)[12]==NULL) Rv0=1;
      else {
        Ra.sl[6]=411; /* line # 411 */
        Rv0=P_comp_type(((V *)F_eff)[12],((V *)Rv1)[12],1,1);
      }
      break;
      case 6:Ra.sl[6]=414; /* line # 414 */
      if (((V *)Rv1)[13]==NULL) Rv0=1;
      else {
        Ra.sl[6]=415; /* line # 415 */
        Rv0=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv1)[13]);
      }
      break;
      default:break;
    }
    break;
    case 3:Ra.sl[6]=421; /* line # 421 */
    Rv0=P_comp_type(F_frm, V_typ_std.v[10],0,0);
    break;
    case 2:Ra.sl[6]=424; /* line # 424 */
    if (P_comp_type(F_eff, V_typ_std.v[10],0,0)) {
      Ra.sl[6]=426; /* line # 426 */
      Rv0=P_comp_type(((V *)((V *)F_eff)[13])[5],F_frm,0,0);
    }
    break;
    default:break;
  }
  Ra.sl[6]=431; /* line # 431 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_exact;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+669;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=436; /* line # 436 */
  V_enm_range=0;
  Ra.sl[6]=438; /* line # 438 */
  Rv0=0;
  Ra.sl[6]=439; /* line # 439 */
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=441; /* line # 441 */
    Rv0=P_children_type(F_eff, F_frm,!Ra.ub[28],F_sym);
    Ra.sl[6]=442; /* line # 442 */
    if (!Rv0) {
      Ra.sl[6]=443; /* line # 443 */
      Rv1=F_frm;
      Ra.sl[6]=445; /* line # 445 */
      if (((UB *)Rv1)[93]==22) {
        Ra.sl[6]=446; /* line # 446 */
        Rv0=P_comp_type(((V *)Rv1)[0],F_eff, Ra.ub[28],0);
      }
      Ra.sl[6]=448; /* line # 448 */
      if (!Rv0) {
        Ra.sl[6]=449; /* line # 449 */
        if (((UB *)F_eff)[93]<=21&&((UB *)Rv1)[93]<=21) {
          Ra.sl[6]=451; /* line # 451 */
          Rv0=PAS_EXPSION_PRC_00000000(F_eff, F_frm);
          Ra.sl[6]=452; /* line # 452 */
          if (!Rv0&&F_sym) Rv0=PAS_EXPSION_PRC_00000000(F_frm, F_eff);
        }
      }
    }
  }
  Ra.sl[6]=456; /* line # 456 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+680;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=470; /* line # 470 */
  Rv0=1;
  Ra.sl[6]=471; /* line # 471 */
  if (F_epr!=F_fpr) {
    Ra.sl[6]=472; /* line # 472 */
    if (F_epr!=NULL&&F_fpr!=NULL) {
      Ra.sl[6]=474; /* line # 474 */
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=475; /* line # 475 */
        Rv0=0;
      }
      else {
        Ra.sl[6]=478; /* line # 478 */
        Rv1=((V *)F_epr)[8];
        Ra.sl[6]=479; /* line # 479 */
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=480; /* line # 480 */
        if (((V *)F_epr)[11]!=NULL) {
          Ra.sl[6]=481; /* line # 481 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        Ra.sl[6]=482; /* line # 482 */
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          Ra.sl[6]=484; /* line # 484 */
          if (((UB *)Rv2)[53]!=((UB *)Rv1)[53]) Rv0=0;
          else {
            Ra.sl[6]=486; /* line # 486 */
            switch (((UB *)Rv2)[53]) {
              case 5:Ra.sl[6]=488; /* line # 488 */
              Rv0=P_comp_type(((V *)Rv1)[5],((V *)Rv2)[5],((UB *)Rv2)[86]!=9,0);
              break;
              case 7:Ra.sl[6]=491; /* line # 491 */
              if (P_comp_type(((V *)Rv1)[5],((V *)Rv2)[5],1,0)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[8],((V *)Rv2)[8]);
              else {
                Ra.sl[6]=492; /* line # 492 */
                Rv0=0;
              }
              break;
              default:break;
            }
          }
          Ra.sl[6]=497; /* line # 497 */
          Rv1=((V *)Rv1)[3];
          Ra.sl[6]=498; /* line # 498 */
          Rv2=((V *)Rv2)[3];
        }
      }
      Ra.sl[6]=501; /* line # 501 */
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=503; /* line # 503 */
      Rv0=0;
    }
  }
  Ra.sl[6]=504; /* line # 504 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+695;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=522; /* line # 522 */
  if (F_ty!=NULL) {
    Ra.sl[6]=523; /* line # 523 */
    Rv0=F_ty;
    Ra.sl[6]=525; /* line # 525 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=526; /* line # 526 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=527; /* line # 527 */
    while (Rv1!=NULL){
      Ra.sl[6]=528; /* line # 528 */
      Rv3=Rv1;
      Ra.sl[6]=530; /* line # 530 */
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Ra.sl[6]=531; /* line # 531 */
      Rv5=Rv4;
      Ra.sl[6]=533; /* line # 533 */
      ((V *)Rv5)[3]=((V *)Rv3)[5];
      Ra.sl[6]=534; /* line # 534 */
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+717,132,3);
      else {
        Ra.sl[6]=536; /* line # 536 */
        Rv6=((V *)Rv5)[7];
        Ra.sl[6]=537; /* line # 537 */
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[5])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[5];
      }
      Ra.sl[6]=538; /* line # 538 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[14];
      Ra.sl[6]=540; /* line # 540 */
      ((V *)Rv3)[9]=Rv4;
      Ra.sl[6]=541; /* line # 541 */
      ((UB *)Rv3)[60]=1;
      Ra.sl[6]=542; /* line # 542 */
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=543; /* line # 543 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      Ra.sl[6]=544; /* line # 544 */
      (*F_lghl)=Rv4;
      Ra.sl[6]=545; /* line # 545 */
      (*F_count)=(*F_count)+1;
      Ra.sl[6]=546; /* line # 546 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=547; /* line # 547 */
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+721;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=562; /* line # 562 */
  Rv0=((V *)F_ty)[4];
  Ra.sl[6]=563; /* line # 563 */
  while (Rv0!=NULL){
    Ra.sl[6]=564; /* line # 564 */
    Rv1=Rv0;
    Ra.sl[6]=566; /* line # 566 */
    ((UB *)Rv1)[60]=0;
    Ra.sl[6]=567; /* line # 567 */
    ((V *)Rv1)[9]=NULL;
    Ra.sl[6]=568; /* line # 568 */
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+744;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=585; /* line # 585 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=586; /* line # 586 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=588; /* line # 588 */
    Rv2=NULL;
    Ra.sl[6]=589; /* line # 589 */
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=590; /* line # 590 */
    Rv4=NULL;
    Ra.sl[6]=591; /* line # 591 */
    Rv5=NULL;
    Ra.sl[6]=592; /* line # 592 */
    Rv6=0;
    Ra.sl[6]=593; /* line # 593 */
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=600; /* line # 600 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      Ra.sl[6]=601; /* line # 601 */
      while (Rv4!=NULL){
        Ra.sl[6]=603; /* line # 603 */
        Rv5=Rv4;
        Ra.sl[6]=604; /* line # 604 */
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=605; /* line # 605 */
        Rv7=Rv5;
        Ra.sl[6]=607; /* line # 607 */
        Rv8=NULL;
        Ra.sl[6]=608; /* line # 608 */
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        Ra.sl[6]=609; /* line # 609 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=610; /* line # 610 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=611; /* line # 611 */
        Rv2=Rv8;
        Ra.sl[6]=613; /* line # 613 */
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=615; /* line # 615 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    Ra.sl[6]=618; /* line # 618 */
    if (Rv3<=0) {
      Ra.sl[6]=619; /* line # 619 */
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=620; /* line # 620 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    Ra.sl[6]=622; /* line # 622 */
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=625; /* line # 625 */
      if (Rv3<=0) Rv3=1;
      Ra.sl[6]=626; /* line # 626 */
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else {
        Ra.sl[6]=627; /* line # 627 */
        ((V *)Rv2)[0]=((V *)Rv0)[7];
      }
      Ra.sl[6]=628; /* line # 628 */
      Rv2=((V *)Rv0)[7];
      Ra.sl[6]=629; /* line # 629 */
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=630; /* line # 630 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Ra.sl[6]=632; /* line # 632 */
        Rv8=NULL;
        Ra.sl[6]=633; /* line # 633 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=634; /* line # 634 */
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=635; /* line # 635 */
        ((V *)Rv2)[0]=Rv8;
        Ra.sl[6]=636; /* line # 636 */
        Rv2=Rv8;
      }
      break;
      case 29:Ra.sl[6]=642; /* line # 642 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      Ra.sl[6]=643; /* line # 643 */
      if (Rv10==NULL) Rv11=0;
      else {
        Ra.sl[6]=644; /* line # 644 */
        Rv11=((UB *)Rv10)[1];
      }
      Ra.sl[6]=645; /* line # 645 */
      if (Rv3<=0) {
        Ra.sl[6]=646; /* line # 646 */
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=648; /* line # 648 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          Ra.sl[6]=649; /* line # 649 */
          if (Rv12!=NULL) {
            Ra.sl[6]=650; /* line # 650 */
            Rv13=Rv12;
            Ra.sl[6]=651; /* line # 651 */
            if (((UB *)Rv13)[40]==14) {
              Ra.sl[6]=652; /* line # 652 */
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=655; /* line # 655 */
      if (Rv3<=0) Rv3=Rv11;
      Ra.sl[6]=656; /* line # 656 */
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Ra.sl[6]=658; /* line # 658 */
        Rv8=NULL;
        Ra.sl[6]=659; /* line # 659 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=660; /* line # 660 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else {
          Ra.sl[6]=661; /* line # 661 */
          ((SL *)Rv8)[13]=32;
        }
        Ra.sl[6]=662; /* line # 662 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=663; /* line # 663 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=664; /* line # 664 */
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=669; /* line # 669 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    Ra.sl[6]=670; /* line # 670 */
    P_val_new(((V *)Rv0)+7,F_ty);
    Ra.sl[6]=671; /* line # 671 */
    Rv15=((V *)Rv0)[7];
    Ra.sl[6]=673; /* line # 673 */
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=674; /* line # 674 */
    ((SL *)Rv15)[6]=Rv3;
    Ra.sl[6]=675; /* line # 675 */
    ((SL *)Rv15)[2]=Rv6;
    Ra.sl[6]=678; /* line # 678 */
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=680; /* line # 680 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+761;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=694; /* line # 694 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=695; /* line # 695 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=697; /* line # 697 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=698; /* line # 698 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=699; /* line # 699 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Ra.sl[6]=700; /* line # 700 */
    Rv3=((V *)Rv0)[7];
    Ra.sl[6]=702; /* line # 702 */
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    Ra.sl[6]=703; /* line # 703 */
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=706; /* line # 706 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+782;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=718; /* line # 718 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[4];
  Ra.sl[6]=720; /* line # 720 */
  ((UW *)Rv0)[42]=((UW *)Rv0)[42]|8;
  Ra.sl[6]=722; /* line # 722 */
  P_lgt_new(&Rv2,((V *)Rv0)[5],14,NULL);
  Ra.sl[6]=723; /* line # 723 */
  Rv3=Rv2;
  Ra.sl[6]=725; /* line # 725 */
  ((V *)Rv3)[7]=((V *)Rv0)[7];
  Ra.sl[6]=726; /* line # 726 */
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=728; /* line # 728 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  Ra.sl[6]=731; /* line # 731 */
  if (((UB *)((V *)Rv0)[5])[93]==7||((UB *)((V *)Rv0)[5])[93]==16) {
    Ra.sl[6]=732; /* line # 732 */
    Rv2=P_lgt_new_code(3, Rv2);
  }
  else {
    Ra.sl[6]=734; /* line # 734 */
    Rv2=P_exp_genop(28, Rv2);
  }
  Ra.sl[6]=737; /* line # 737 */
  switch (((UB *)Rv1)[104]) {
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:Ra.sl[6]=740; /* line # 740 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else {
      Ra.sl[6]=741; /* line # 741 */
      ((V *)((V *)Rv1)[17])[0]=Rv2;
    }
    Ra.sl[6]=742; /* line # 742 */
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+800;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=762; /* line # 762 */
  Rv0=F_lgt;
  Ra.sl[6]=763; /* line # 763 */
  switch (((UB *)Rv0)[40]) {
    case 13:Ra.sl[6]=765; /* line # 765 */
    Rv1=((V *)Rv0)[6];
    Ra.sl[6]=766; /* line # 766 */
    if (((UB *)Rv1)[53]!=2) {
      Ra.sl[6]=768; /* line # 768 */
      P_src_error_s(Rd.s+819,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=774; /* line # 774 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[6]=775; /* line # 775 */
    while (Rv2!=NULL){
      Ra.sl[6]=777; /* line # 777 */
      P_type_check_parm(Rv2);
      Ra.sl[6]=778; /* line # 778 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=780; /* line # 780 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=788; /* line # 788 */
      P_src_error(Rd.s+819,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=794; /* line # 794 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+819,203,3);
    break;
    default:Ra.sl[6]=798; /* line # 798 */
    P_src_error(Rd.s+819,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000001(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+823;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=827; /* line # 827 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    Ra.sl[6]=830; /* line # 830 */
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    Ra.sl[6]=831; /* line # 831 */
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=833; /* line # 833 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        Ra.sl[6]=835; /* line # 835 */
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        Ra.sl[6]=836; /* line # 836 */
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+842;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=844; /* line # 844 */
  Rv0=0;
  Ra.sl[6]=845; /* line # 845 */
  Rv1=F_lgt;
  Ra.sl[6]=846; /* line # 846 */
  Rv2=F_ip;
  Ra.sl[6]=848; /* line # 848 */
  Rv3=((V *)((V *)Rv2)[5])[4];
  Ra.sl[6]=849; /* line # 849 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Ra.sl[6]=852; /* line # 852 */
    Rv4=Rv3;
    Rv5=Rv1;
    Ra.sl[6]=853; /* line # 853 */
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[5],0,0)) {
      Ra.sl[6]=856; /* line # 856 */
      P_type_check_parm(Rv1);
      Ra.sl[6]=857; /* line # 857 */
      ((UB *)Rv4)[60]=2;
      Ra.sl[6]=858; /* line # 858 */
      ((V *)Rv4)[9]=Rv1;
    }
    else {
      Ra.sl[6]=861; /* line # 861 */
      P_src_error_s(Rd.s+859,201,3,((V *)Rv4)[0],NULL);
    }
    Ra.sl[6]=863; /* line # 863 */
    Rv1=((V *)Rv1)[0];
    Ra.sl[6]=864; /* line # 864 */
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=867; /* line # 867 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+859,998,3);
  Ra.sl[6]=869; /* line # 869 */
  if (((UB *)((V *)Rv2)[5])[93]==27) {
    Ra.sl[6]=871; /* line # 871 */
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[5])[9],NULL,NULL,0);
    Ra.sl[6]=873; /* line # 873 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else {
      Ra.sl[6]=874; /* line # 874 */
      P_src_error(Rd.s+859,222,3);
    }
  }
  else {
    Ra.sl[6]=878; /* line # 878 */
    P_ide_new_typ(((UB *)((V *)Rv2)[5])[93],&Rv6);
    Ra.sl[6]=879; /* line # 879 */
    Rv7=Rv6;
    Ra.sl[6]=881; /* line # 881 */
    ((UB *)Rv7)[90]=1;
    Ra.sl[6]=882; /* line # 882 */
    ((V *)Rv7)[0]=((V *)Rv2)[5];
    Ra.sl[6]=883; /* line # 883 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[5])[4];
    Ra.sl[6]=884; /* line # 884 */
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[5])[11];
    Ra.sl[6]=885; /* line # 885 */
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[5])[10];
    Ra.sl[6]=886; /* line # 886 */
    memcpy(Rv7+48,((V *)Rv2)[5]+48,1);
    Ra.sl[6]=887; /* line # 887 */
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[5])[10];
    Ra.sl[6]=888; /* line # 888 */
    ((UB *)Rv7)[91]=((UB *)((V *)Rv2)[5])[91];
    Ra.sl[6]=890; /* line # 890 */
    V_sy_type_gfirst=((V *)Rv2)[10];
    Ra.sl[6]=891; /* line # 891 */
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=893; /* line # 893 */
    PAS_EXPSION_PRC_00000001(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[5])[9]
    );
    Ra.sl[6]=895; /* line # 895 */
    switch (((UB *)Rv7)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=898; /* line # 898 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      Ra.sl[6]=899; /* line # 899 */
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      Ra.sl[6]=900; /* line # 900 */
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      Ra.sl[6]=901; /* line # 901 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=906; /* line # 906 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[5])[12]);
      Ra.sl[6]=907; /* line # 907 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[5])[14]);
      Ra.sl[6]=908; /* line # 908 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[5])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=914; /* line # 914 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:Ra.sl[6]=917; /* line # 917 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=928; /* line # 928 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      Ra.sl[6]=929; /* line # 929 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[5])
      [13]);
      Ra.sl[6]=931; /* line # 931 */
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      Ra.sl[6]=932; /* line # 932 */
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=941; /* line # 941 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      Ra.sl[6]=942; /* line # 942 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      Ra.sl[6]=943; /* line # 943 */
      if (((V *)((V *)Rv7)[0])[14]!=NULL) {
        Ra.sl[6]=944; /* line # 944 */
        ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)Rv7)[0])[14]);
      }
      else {
        Ra.sl[6]=946; /* line # 946 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=951; /* line # 951 */
      P_src_error(Rd.s+859,998,3);
      break;
    }
  }
  Ra.sl[6]=957; /* line # 957 */
  Rv3=((V *)((V *)Rv2)[5])[4];
  Ra.sl[6]=959; /* line # 959 */
  while (Rv3!=NULL){
    Ra.sl[6]=960; /* line # 960 */
    Rv8=Rv3;
    Ra.sl[6]=962; /* line # 962 */
    ((V *)Rv8)[9]=NULL;
    Ra.sl[6]=963; /* line # 963 */
    ((UB *)Rv8)[60]=0;
    Ra.sl[6]=964; /* line # 964 */
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=968; /* line # 968 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+863;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1002; /* line # 1002 */
  Rv0=F_ty;
  Ra.sl[6]=1003; /* line # 1003 */
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=1006; /* line # 1006 */
    Rv1=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
    Ra.sl[6]=1009; /* line # 1009 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Ra.sl[6]=1010; /* line # 1010 */
    Rv2=P_lgt_new_code(3, Rv1);
    Ra.sl[6]=1013; /* line # 1013 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[6]=1014; /* line # 1014 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    Ra.sl[6]=1015; /* line # 1015 */
    (*F_lgl)=Rv2;
    Ra.sl[6]=1018; /* line # 1018 */
    Rv3=1;
    Ra.sl[6]=1019; /* line # 1019 */
    if (((V *)Rv0)[13]!=NULL) {
      Ra.sl[6]=1021; /* line # 1021 */
      Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
      Ra.sl[6]=1022; /* line # 1022 */
      if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
        Ra.sl[6]=1025; /* line # 1025 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
        Ra.sl[6]=1028; /* line # 1028 */
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Ra.sl[6]=1029; /* line # 1029 */
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[6]=1031; /* line # 1031 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else {
          Ra.sl[6]=1032; /* line # 1032 */
          ((V *)(*F_lgl))[0]=Rv2;
        }
        Ra.sl[6]=1033; /* line # 1033 */
        (*F_lgl)=Rv2;
        Ra.sl[6]=1034; /* line # 1034 */
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1037; /* line # 1037 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
    }
    Ra.sl[6]=1040; /* line # 1040 */
    if (Lx[2].ub[28]) {
      Ra.sl[6]=1042; /* line # 1042 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      Ra.sl[6]=1043; /* line # 1043 */
      ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
    }
    else {
      Ra.sl[6]=1045; /* line # 1045 */
      P_lgt_new_copy(F_trg, &Rv2);
    }
    Ra.sl[6]=1047; /* line # 1047 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=1050; /* line # 1050 */
    Rv6=Rv2;
    ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
    Ra.sl[6]=1051; /* line # 1051 */
    P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
    Ra.sl[6]=1052; /* line # 1052 */
    Rv7=((V *)Rv0)[14];
    Rv8=Rv2;
    Ra.sl[6]=1054; /* line # 1054 */
    ((V *)Rv8)[6]=F_ty;
    Ra.sl[6]=1055; /* line # 1055 */
    if (((UB *)Rv7)[93]!=10&&((UB *)Rv7)[93]!=23) {
      Ra.sl[6]=1056; /* line # 1056 */
      ((SL *)Rv8)[4]=((SL *)Rv8)[4]+((SL *)Rv7)[10];
    }
    Ra.sl[6]=1057; /* line # 1057 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=1066; /* line # 1066 */
    Rv9=((V *)Rv0)[15];
    Ra.sl[6]=1067; /* line # 1067 */
    if (((UB *)Rv9)[93]!=22) {
      Ra.sl[6]=1069; /* line # 1069 */
      if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
      else {
        Ra.sl[6]=1070; /* line # 1070 */
        Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
      }
      Ra.sl[6]=1071; /* line # 1071 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
    }
    else {
      Ra.sl[6]=1073; /* line # 1073 */
      Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
    }
    Ra.sl[6]=1075; /* line # 1075 */
    Rv12=Rv11;
    Ra.sl[6]=1076; /* line # 1076 */
    PAS_EXPSION_PRC_00000002(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
    Ra.sl[6]=1079; /* line # 1079 */
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[6]=1087; /* line # 1087 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    Ra.sl[6]=1088; /* line # 1088 */
    ((UB *)Rv5)[41]=5;
    Ra.sl[6]=1091; /* line # 1091 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[6]=1092; /* line # 1092 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    Ra.sl[6]=1093; /* line # 1093 */
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000005(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+877;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1117; /* line # 1117 */
  Rv0=NULL;
  Ra.sl[6]=1118; /* line # 1118 */
  Rv1=NULL;
  Ra.sl[6]=1119; /* line # 1119 */
  PAS_EXPSION_PRC_00000004(F_ty, Lx[1].v[4],&Rv0, &Rv1);
  Ra.sl[6]=1120; /* line # 1120 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1122; /* line # 1122 */
    if (Rv1!=Rv0) {
      Ra.sl[6]=1124; /* line # 1124 */
      P_lgt_new(&Rv0,NULL,0, Rv0);
      Ra.sl[6]=1125; /* line # 1125 */
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1128; /* line # 1128 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+890;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1134; /* line # 1134 */
  Rv0=F_ty;
  Ra.sl[6]=1136; /* line # 1136 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1138; /* line # 1138 */
  while (Rv1!=NULL){
    Ra.sl[6]=1139; /* line # 1139 */
    Rv2=Rv1;
    Ra.sl[6]=1141; /* line # 1141 */
    if (((V *)Rv2)[5]!=NULL) {
      Ra.sl[6]=1142; /* line # 1142 */
      Rv3=((V *)Rv2)[5];
      Ra.sl[6]=1144; /* line # 1144 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[91]) {
        Ra.sl[6]=1147; /* line # 1147 */
        if (Lx[2].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[5],2, P_lgt_link(Ra.v[4]));
        else {
          Ra.sl[6]=1148; /* line # 1148 */
          P_lgt_new_copy(Ra.v[4],&Rv4);
        }
        Ra.sl[6]=1149; /* line # 1149 */
        Rv5=Rv4;
        Ra.sl[6]=1151; /* line # 1151 */
        ((V *)Rv5)[4]=Rv1;
        Ra.sl[6]=1153; /* line # 1153 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[14];
        Ra.sl[6]=1156; /* line # 1156 */
        if (((UB *)Rv3)[93]!=10&&((UB *)Rv3)[93]!=23) {
          Ra.sl[6]=1157; /* line # 1157 */
          ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)((V *)Rv2)[5])[10];
        }
        Ra.sl[6]=1159; /* line # 1159 */
        PAS_EXPSION_PRC_00000002(((V *)Rv2)[5],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1161; /* line # 1161 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1162; /* line # 1162 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1166; /* line # 1166 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1169; /* line # 1169 */
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1171; /* line # 1171 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else {
      Ra.sl[6]=1172; /* line # 1172 */
      ((V *)(*F_lgl))[0]=Rv6;
    }
    Ra.sl[6]=1173; /* line # 1173 */
    (*F_lgl)=Rv6;
    Ra.sl[6]=1174; /* line # 1174 */
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1177; /* line # 1177 */
    P_lgt_new_copy(Rv7, &Rv4);
    Ra.sl[6]=1178; /* line # 1178 */
    ((V *)Rv6)[1]=Rv4;
    Ra.sl[6]=1179; /* line # 1179 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1182; /* line # 1182 */
    Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
    Ra.sl[6]=1183; /* line # 1183 */
    ((V *)Rv4)[0]=Rv6;
    Ra.sl[6]=1184; /* line # 1184 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1187; /* line # 1187 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1188; /* line # 1188 */
    ((V *)Rv6)[0]=Rv4;
    Ra.sl[6]=1189; /* line # 1189 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1190; /* line # 1190 */
    while (Rv7!=NULL){
      Ra.sl[6]=1192; /* line # 1192 */
      Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
      Ra.sl[6]=1193; /* line # 1193 */
      ((V *)Rv4)[0]=Rv6;
      Ra.sl[6]=1194; /* line # 1194 */
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+904;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1221; /* line # 1221 */
  Rv0=F_ty;
  Ra.sl[6]=1223; /* line # 1223 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1225; /* line # 1225 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1226; /* line # 1226 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=1227; /* line # 1227 */
    while (Rv1!=NULL&&Rv2!=NULL){
      Ra.sl[6]=1228; /* line # 1228 */
      Rv3=Rv1;
      Ra.sl[6]=1231; /* line # 1231 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[5],2, P_lgt_link(F_trg));
      else {
        Ra.sl[6]=1232; /* line # 1232 */
        P_lgt_new_copy(F_trg, &Rv4);
      }
      Ra.sl[6]=1235; /* line # 1235 */
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1237; /* line # 1237 */
      ((V *)Rv5)[3]=((V *)Rv3)[5];
      Ra.sl[6]=1238; /* line # 1238 */
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[14];
      Ra.sl[6]=1239; /* line # 1239 */
      if (((UB *)Rv6)[93]!=10&&((UB *)Rv6)[93]!=23) {
        Ra.sl[6]=1240; /* line # 1240 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]-((SL *)Rv6)[10];
      }
      Ra.sl[6]=1241; /* line # 1241 */
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[5],0);
      Ra.sl[6]=1242; /* line # 1242 */
      ((V *)Rv3)[9]=((V *)Rv5)[0];
      Ra.sl[6]=1244; /* line # 1244 */
      ((UB *)Rv3)[60]=1;
      Ra.sl[6]=1246; /* line # 1246 */
      P_lgt_new(&Rv4,((V *)Rv3)[5],6, Rv4);
      Ra.sl[6]=1247; /* line # 1247 */
      ((UB *)Rv4)[41]=3;
      Ra.sl[6]=1250; /* line # 1250 */
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else {
        Ra.sl[6]=1251; /* line # 1251 */
        ((V *)(*F_lgl))[0]=Rv4;
      }
      Ra.sl[6]=1252; /* line # 1252 */
      (*F_lgl)=Rv4;
      Ra.sl[6]=1253; /* line # 1253 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=1254; /* line # 1254 */
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1258; /* line # 1258 */
  if (((UB *)Rv0)[91]) {
    Ra.sl[6]=1259; /* line # 1259 */
    switch (((UB *)Rv0)[93]) {
      case 10:
      case 23:Ra.sl[6]=1261; /* line # 1261 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgh,F_lgl);
      break;
      case 8:
      case 9:Ra.sl[6]=1264; /* line # 1264 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
      break;
      default:Ra.sl[6]=1267; /* line # 1267 */
      P_src_error(Rd.s+918,131,3);
      break;
    }
  }
  Ra.sl[6]=1270; /* line # 1270 */
  Rv1=((V *)F_ty)[4];
  Ra.sl[6]=1271; /* line # 1271 */
  while (Rv1!=NULL){
    Ra.sl[6]=1272; /* line # 1272 */
    Rv7=Rv1;
    Ra.sl[6]=1274; /* line # 1274 */
    ((V *)Rv7)[9]=NULL;
    Ra.sl[6]=1275; /* line # 1275 */
    ((UB *)Rv7)[60]=0;
    Ra.sl[6]=1276; /* line # 1276 */
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+922;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1283; /* line # 1283 */
  if (((UB *)F_ty)[91]) {
    Ra.sl[6]=1285; /* line # 1285 */
    switch (((UB *)F_ty)[93]) {
      case 10:
      case 23:Ra.sl[6]=1287; /* line # 1287 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      case 8:
      case 9:Ra.sl[6]=1290; /* line # 1290 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      default:Ra.sl[6]=1293; /* line # 1293 */
      P_src_error(Rd.s+936,131,3);
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+940;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1323; /* line # 1323 */
  Rv0=F_ty;
  Ra.sl[6]=1325; /* line # 1325 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=1326; /* line # 1326 */
    Rv1=((V *)Rv0)[15];
    Ra.sl[6]=1327; /* line # 1327 */
    if (((UB *)Rv1)[93]!=22) {
      Ra.sl[6]=1328; /* line # 1328 */
      if (((UB *)Rv1)[112]) {
        Ra.sl[6]=1329; /* line # 1329 */
        Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      }
      else {
        Ra.sl[6]=1331; /* line # 1331 */
        Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1334; /* line # 1334 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      Ra.sl[6]=1335; /* line # 1335 */
      if (((UB *)Rv3)[40]==14) {
        Ra.sl[6]=1337; /* line # 1337 */
        Rv2=((SL *)((V *)Rv3)[7])[13];
        Ra.sl[6]=1338; /* line # 1338 */
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1340; /* line # 1340 */
        P_src_error(Rd.s+954,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1342; /* line # 1342 */
    Rv2=0;
  }
  Ra.sl[6]=1344; /* line # 1344 */
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1346; /* line # 1346 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    Ra.sl[6]=1347; /* line # 1347 */
    if (((UB *)Rv3)[40]==14) {
      Ra.sl[6]=1349; /* line # 1349 */
      Rv4=((SL *)((V *)Rv3)[7])[13];
      Ra.sl[6]=1350; /* line # 1350 */
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1352; /* line # 1352 */
      P_src_error(Rd.s+954,142,4);
    }
  }
  else {
    Ra.sl[6]=1354; /* line # 1354 */
    Rv4=((SL *)Rv0)[25];
  }
  Ra.sl[6]=1356; /* line # 1356 */
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1358; /* line # 1358 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Ra.sl[6]=1360; /* line # 1360 */
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=1362; /* line # 1362 */
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1363; /* line # 1363 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    Ra.sl[6]=1364; /* line # 1364 */
    if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv7;
    else {
      Ra.sl[6]=1365; /* line # 1365 */
      ((V *)Lx[3].v[1])[0]=Rv7;
    }
    Ra.sl[6]=1366; /* line # 1366 */
    Lx[3].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1368; /* line # 1368 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000007(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+958;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1387; /* line # 1387 */
  Rv0=F_ty;
  Ra.sl[6]=1389; /* line # 1389 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1391; /* line # 1391 */
  while (Rv1!=NULL){
    Ra.sl[6]=1392; /* line # 1392 */
    Rv2=Rv1;
    Ra.sl[6]=1394; /* line # 1394 */
    if (((V *)Rv2)[5]!=NULL) {
      Ra.sl[6]=1395; /* line # 1395 */
      Rv3=((V *)Rv2)[5];
      Ra.sl[6]=1397; /* line # 1397 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[91]) {
        Ra.sl[6]=1399; /* line # 1399 */
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[5],0);
        Ra.sl[6]=1400; /* line # 1400 */
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1403; /* line # 1403 */
        if (((SL *)Rv3)[11]>0) {
          Ra.sl[6]=1405; /* line # 1405 */
          Rv4=NULL;
          Ra.sl[6]=1406; /* line # 1406 */
          P_val_new(&Rv4, V_typ_std.v[0]);
          Ra.sl[6]=1407; /* line # 1407 */
          Rv6=Rv4;
          Ra.sl[6]=1409; /* line # 1409 */
          Rv5=((SL *)Rv3)[11];
          Ra.sl[6]=1410; /* line # 1410 */
          ((UB *)Rv6)[48]=28;
          Ra.sl[6]=1411; /* line # 1411 */
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          Ra.sl[6]=1412; /* line # 1412 */
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1415; /* line # 1415 */
          Rv5=0;
        }
      }
      Ra.sl[6]=1416; /* line # 1416 */
      if (Rv5>0) {
        Ra.sl[6]=1418; /* line # 1418 */
        (*F_iadr)=(*F_iadr)+Rv5;
        Ra.sl[6]=1419; /* line # 1419 */
        if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv4;
        else {
          Ra.sl[6]=1420; /* line # 1420 */
          ((V *)Lx[3].v[1])[0]=Rv4;
        }
        Ra.sl[6]=1421; /* line # 1421 */
        Lx[3].v[1]=Rv4;
      }
      Ra.sl[6]=1423; /* line # 1423 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1424; /* line # 1424 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1428; /* line # 1428 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1429; /* line # 1429 */
    Rv7=((V *)Rv0)[14];
    Ra.sl[6]=1431; /* line # 1431 */
    Rv8=((V *)Rv7)[1];
    Ra.sl[6]=1432; /* line # 1432 */
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1433; /* line # 1433 */
    Rv10=((V *)Rv9)[0];
    Ra.sl[6]=1434; /* line # 1434 */
    Rv11=Rv8;
    Ra.sl[6]=1436; /* line # 1436 */
    Rv12=((SL *)Rv11)[4];
    Ra.sl[6]=1437; /* line # 1437 */
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1438; /* line # 1438 */
      Rv13=((V *)Rv11)[7];
      Ra.sl[6]=1441; /* line # 1441 */
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Ra.sl[6]=1442; /* line # 1442 */
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1444; /* line # 1444 */
      Rv15=NULL;
    }
    Ra.sl[6]=1446; /* line # 1446 */
    if (((V *)Rv0)[4]!=NULL) {
      Ra.sl[6]=1448; /* line # 1448 */
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1449; /* line # 1449 */
      Rv17=Rv16;
      Ra.sl[6]=1450; /* line # 1450 */
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+972,142,3);
      else {
        Ra.sl[6]=1452; /* line # 1452 */
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else {
          Ra.sl[6]=1453; /* line # 1453 */
          Rv18=Rv12-1;
        }
      }
      Ra.sl[6]=1454; /* line # 1454 */
      P_lgt_free(&Rv16);
    }
    Ra.sl[6]=1457; /* line # 1457 */
    Rv19=((V *)Rv10)[0];
    Ra.sl[6]=1458; /* line # 1458 */
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1459; /* line # 1459 */
      Rv19=Rv9;
    }
    else {
      Ra.sl[6]=1462; /* line # 1462 */
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      Ra.sl[6]=1463; /* line # 1463 */
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1466; /* line # 1466 */
        while (Rv18>0&&Rv19!=NULL){
          Ra.sl[6]=1468; /* line # 1468 */
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        Ra.sl[6]=1470; /* line # 1470 */
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1473; /* line # 1473 */
    if (Rv19!=NULL) {
      Ra.sl[6]=1474; /* line # 1474 */
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000007(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+976;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1484; /* line # 1484 */
  Rv0=F_ty;
  Ra.sl[10]=1486; /* line # 1486 */
  Rv1=0;
  Ra.sl[10]=1487; /* line # 1487 */
  Ra.v[0]=NULL;
  Ra.sl[10]=1488; /* line # 1488 */
  Ra.v[1]=NULL;
  Ra.sl[10]=1489; /* line # 1489 */
  Rv2=NULL;
  Ra.sl[10]=1490; /* line # 1490 */
  Rv3=NULL;
  Ra.sl[10]=1491; /* line # 1491 */
  Rv4=((SL *)Rv0)[11];
  Ra.sl[10]=1492; /* line # 1492 */
  Rv5=0;
  Ra.sl[10]=1494; /* line # 1494 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1496; /* line # 1496 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1497; /* line # 1497 */
    Rv7=((V *)Rv0)[7];
    Ra.sl[10]=1498; /* line # 1498 */
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1499; /* line # 1499 */
      Rv8=Rv6;
      Ra.sl[10]=1501; /* line # 1501 */
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[5],0);
      Ra.sl[10]=1502; /* line # 1502 */
      ((SL *)Rv9)[4]=((SL *)Rv8)[14];
      Ra.sl[10]=1503; /* line # 1503 */
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1504; /* line # 1504 */
        ((V *)Rv3)[0]=Rv9;
      }
      Ra.sl[10]=1505; /* line # 1505 */
      Rv3=Rv9;
      Ra.sl[10]=1506; /* line # 1506 */
      Rv10=((V *)Rv9)[7];
      Ra.sl[10]=1507; /* line # 1507 */
      P_val_new(&Rv10,((V *)Rv8)[5]);
      Ra.sl[10]=1508; /* line # 1508 */
      ((V *)Rv10)[4]=((V *)Rv8)[5];
      Ra.sl[10]=1509; /* line # 1509 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[5])[11];
      Ra.sl[10]=1510; /* line # 1510 */
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else {
        Ra.sl[10]=1511; /* line # 1511 */
        ((V *)Ra.v[1])[0]=Rv10;
      }
      Ra.sl[10]=1512; /* line # 1512 */
      Ra.v[1]=Rv10;
      Ra.sl[10]=1514; /* line # 1514 */
      ((V *)Rv8)[9]=Rv9;
      Ra.sl[10]=1515; /* line # 1515 */
      ((UB *)Rv8)[60]=1;
      Ra.sl[10]=1516; /* line # 1516 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[10]=1517; /* line # 1517 */
      Rv6=((V *)Rv8)[3];
      Ra.sl[10]=1518; /* line # 1518 */
      if (((V *)Rv8)[5]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[5])[11];
      Ra.sl[10]=1519; /* line # 1519 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1524; /* line # 1524 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Ra.sl[10]=1526; /* line # 1526 */
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    Ra.sl[10]=1527; /* line # 1527 */
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1529; /* line # 1529 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      Ra.sl[10]=1530; /* line # 1530 */
      P_lgt_free(&Rv7);
    }
    else {
      Ra.sl[10]=1531; /* line # 1531 */
      P_src_error(Rd.s+993,147,4);
    }
  }
  Ra.sl[10]=1534; /* line # 1534 */
  if (F_szw>Rv4) Rv4=F_szw;
  Ra.sl[10]=1536; /* line # 1536 */
  if (((UB *)Rv0)[91]) {
    Ra.sl[10]=1537; /* line # 1537 */
    switch (((UB *)Rv0)[93]) {
      case 10:
      case 23:Ra.sl[10]=1539; /* line # 1539 */
      PAS_EXPSION_PRC_00000007(F_ty, &Rv1);
      break;
      case 8:
      case 9:Ra.sl[10]=1542; /* line # 1542 */
      PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
      break;
      default:Ra.sl[10]=1545; /* line # 1545 */
      P_src_error(Rd.s+993,131,3);
      break;
    }
  }
  Ra.sl[10]=1549; /* line # 1549 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1552; /* line # 1552 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1553; /* line # 1553 */
    while (Rv6!=NULL){
      Ra.sl[10]=1555; /* line # 1555 */
      ((UB *)Rv6)[60]=0;
      Ra.sl[10]=1556; /* line # 1556 */
      ((V *)Rv6)[9]=NULL;
      Ra.sl[10]=1557; /* line # 1557 */
      Rv6=((V *)Rv6)[3];
    }
  }
  Ra.sl[10]=1560; /* line # 1560 */
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1563; /* line # 1563 */
  if (Rv4>Rv1) {
    Ra.sl[10]=1565; /* line # 1565 */
    Rv10=NULL;
    Ra.sl[10]=1566; /* line # 1566 */
    P_val_new(&Rv10,NULL);
    Ra.sl[10]=1567; /* line # 1567 */
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1568; /* line # 1568 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.sl[10]=1569; /* line # 1569 */
    Ra.v[1]=Rv10;
    Ra.sl[10]=1570; /* line # 1570 */
    Rv11=Rv10;
    Ra.sl[10]=1572; /* line # 1572 */
    ((UB *)Rv11)[48]=28;
    Ra.sl[10]=1573; /* line # 1573 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    Ra.sl[10]=1574; /* line # 1574 */
    ((SL *)Rv11)[13]=0;
    Ra.sl[10]=1575; /* line # 1575 */
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1598; /* line # 1598 */
  Rv10=NULL;
  Ra.sl[10]=1599; /* line # 1599 */
  P_val_new(&Rv10, F_ty);
  Ra.sl[10]=1600; /* line # 1600 */
  Rv12=Rv10;
  Ra.sl[10]=1602; /* line # 1602 */
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1603; /* line # 1603 */
  ((SL *)Rv12)[6]=Rv4;
  Ra.sl[10]=1604; /* line # 1604 */
  ((V *)Rv12)[7]=Ra.v[0];
  Ra.sl[10]=1605; /* line # 1605 */
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1612; /* line # 1612 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+997;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1649; /* line # 1649 */
  Rv0=((V *)F_ip)[5];
  Ra.sl[6]=1651; /* line # 1651 */
  if (!((UB *)Rv0)[90]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Ra.sl[6]=1653; /* line # 1653 */
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[4];
  Ra.sl[6]=1655; /* line # 1655 */
  ((UW *)Rv1)[42]=((UW *)Rv1)[42]|16;
  Ra.sl[6]=1656; /* line # 1656 */
  if ((((UB *)Rv1)[86]==7||((UB *)Rv1)[86]==1)&&((SL *)Rv1)[12]>1) {
    Ra.sl[6]=1660; /* line # 1660 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else {
      Ra.sl[6]=1661; /* line # 1661 */
      Rv4=((V *)Rv2)[4];
    }
    Ra.sl[6]=1662; /* line # 1662 */
    Rv5=NULL;
    Ra.sl[6]=1663; /* line # 1663 */
    Rv6=NULL;
    Ra.sl[6]=1664; /* line # 1664 */
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1665; /* line # 1665 */
    Rv8=Rv4;
    Ra.sl[6]=1667; /* line # 1667 */
    while (Rv7!=NULL){
      Ra.sl[6]=1670; /* line # 1670 */
      P_lgt_new(&Rv9,((V *)Rv4)[5],13,NULL);
      Ra.sl[6]=1671; /* line # 1671 */
      Rv10=Rv9;
      Rv11=Rv8;
      Ra.sl[6]=1673; /* line # 1673 */
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      Ra.sl[6]=1674; /* line # 1674 */
      ((SL *)Rv10)[4]=((SL *)Rv11)[14];
      Ra.sl[6]=1675; /* line # 1675 */
      ((V *)Rv11)[9]=Rv9;
      Ra.sl[6]=1676; /* line # 1676 */
      ((UB *)Rv11)[60]=1;
      Ra.sl[6]=1679; /* line # 1679 */
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1681; /* line # 1681 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[6]=1682; /* line # 1682 */
      Rv8=((V *)Rv8)[3];
      Ra.sl[6]=1683; /* line # 1683 */
      Rv12=P_lgt_new_code(3, Rv9);
      Ra.sl[6]=1684; /* line # 1684 */
      if (Rv5==NULL) Rv5=Rv12;
      else {
        Ra.sl[6]=1685; /* line # 1685 */
        ((V *)Rv6)[0]=Rv12;
      }
      Ra.sl[6]=1686; /* line # 1686 */
      Rv6=Rv12;
    }
    Ra.sl[6]=1689; /* line # 1689 */
    if (((UB *)Rv2)[91]) {
      Ra.sl[6]=1691; /* line # 1691 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      Ra.sl[6]=1692; /* line # 1692 */
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      Ra.sl[6]=1693; /* line # 1693 */
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1696; /* line # 1696 */
    if (Rv5!=NULL) {
      Ra.sl[6]=1697; /* line # 1697 */
      switch (((UB *)Rv3)[104]) {
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:Ra.sl[6]=1700; /* line # 1700 */
        if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
        else {
          Ra.sl[6]=1701; /* line # 1701 */
          ((V *)((V *)Rv3)[17])[0]=Rv5;
        }
        Ra.sl[6]=1702; /* line # 1702 */
        ((V *)Rv3)[17]=Rv6;
        break;
        default:break;
      }
    }
    Ra.sl[6]=1706; /* line # 1706 */
    while (Rv4!=NULL){
      Ra.sl[6]=1707; /* line # 1707 */
      Rv13=Rv4;
      Ra.sl[6]=1709; /* line # 1709 */
      ((V *)Rv13)[9]=NULL;
      Ra.sl[6]=1710; /* line # 1710 */
      ((UB *)Rv13)[60]=0;
      Ra.sl[6]=1711; /* line # 1711 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1716; /* line # 1716 */
    if (((V *)Rv1)[7]==NULL) {
      Ra.sl[6]=1718; /* line # 1718 */
      ((UW *)Rv1)[42]=((UW *)Rv1)[42]|8;
      Ra.sl[6]=1719; /* line # 1719 */
      ((V *)Rv1)[7]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1011;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1738; /* line # 1738 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1739; /* line # 1739 */
    Rv0=F_p;
    Rv1=((V *)Rv0)[3]+8;
    Ra.sl[6]=1742; /* line # 1742 */
    if (((UB *)Rv1)[8]!=0) F_puna=P_exp_val_una(F_puna, V_oparg_cvtab.v[((UB *)Rv1)
    [8]]);
    Ra.sl[6]=1743; /* line # 1743 */
    Rv2=F_puna;
    Ra.sl[6]=1744; /* line # 1744 */
    if (((UB *)Rv2)[40]==14) {
      Ra.sl[6]=1745; /* line # 1745 */
      Rv3=((V *)Rv2)[7];
      Ra.sl[6]=1747; /* line # 1747 */
      ((UW *)Rv2)[10]=1;
      Ra.sl[6]=1748; /* line # 1748 */
      switch (((UB *)Rv0)[9]) {
        case 6:Ra.sl[6]=1749; /* line # 1749 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]<=0);
        break;
        case 43:Ra.sl[6]=1751; /* line # 1751 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]+1;
        break;
        case 44:Ra.sl[6]=1753; /* line # 1753 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]-1;
        break;
        case 45:Ra.sl[6]=1755; /* line # 1755 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]&1);
        break;
        case 10:Ra.sl[6]=1757; /* line # 1757 */
        if (((UB *)Rv3)[48]==11||((UB *)Rv3)[48]==17) {
          Ra.sl[6]=1758; /* line # 1758 */
          if (((SL *)Rv3)[13]>=0) {
            Ra.sl[6]=1759; /* line # 1759 */
            ((SL *)Rv3)[13]=-1-((SL *)Rv3)[13];
          }
          else {
            Ra.sl[6]=1760; /* line # 1760 */
            ((SL *)Rv3)[13]= -(1+((SL *)Rv3)[13]);
          }
        }
        break;
        case 46:Ra.sl[6]=1762; /* line # 1762 */
        ((SL *)Rv3)[13]= -((SL *)Rv3)[13];
        break;
        case 61:
        case 77:Ra.sl[6]=1764; /* line # 1764 */
        ((G *)Rv3)[7]=-((G *)Rv3)[7];
        break;
        case 47:Ra.sl[6]=1766; /* line # 1766 */
        ((SL *)Rv3)[13]=abs(((SL *)Rv3)[13]);
        break;
        case 62:
        case 78:Ra.sl[6]=1768; /* line # 1768 */
        ((G *)Rv3)[7]=fabs(((G *)Rv3)[7]);
        break;
        case 48:Ra.sl[6]=1770; /* line # 1770 */
        ((SL *)Rv3)[13]=PAS__I_SQR(((SL *)Rv3)[13]);
        break;
        case 63:
        case 79:Ra.sl[6]=1772; /* line # 1772 */
        ((G *)Rv3)[7]=PAS__G_SQR(((G *)Rv3)[7]);
        break;
        case 64:
        case 80:Ra.sl[6]=1775; /* line # 1775 */
        ((G *)Rv3)[7]=(double)((SL *)Rv3)[13];
        break;
        case 65:
        case 81:Ra.sl[6]=1777; /* line # 1777 */
        ((SL *)Rv3)[13]=PAS__G_ROUND(((G *)Rv3)[7]);
        break;
        case 66:
        case 82:Ra.sl[6]=1779; /* line # 1779 */
        ((SL *)Rv3)[13]=(int)(((G *)Rv3)[7]);
        break;
        case 92:
        case 110:Ra.sl[6]=1782; /* line # 1782 */
        if (((G *)Rv3)[7]<0.000000000000000E-001) P_src_error(Rd.s+1026,801,2);
        else {
          Ra.sl[6]=1783; /* line # 1783 */
          ((G *)Rv3)[7]=sqrt(((G *)Rv3)[7]);
        }
        break;
        case 93:
        case 111:Ra.sl[6]=1786; /* line # 1786 */
        ((G *)Rv3)[7]=sin(((G *)Rv3)[7]);
        break;
        case 94:
        case 112:Ra.sl[6]=1788; /* line # 1788 */
        ((G *)Rv3)[7]=cos(((G *)Rv3)[7]);
        break;
        case 95:
        case 113:Ra.sl[6]=1790; /* line # 1790 */
        ((G *)Rv3)[7]=tan(((G *)Rv3)[7]);
        break;
        case 96:
        case 114:Ra.sl[6]=1794; /* line # 1794 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,802,2);
        else {
          Ra.sl[6]=1795; /* line # 1795 */
          ((G *)Rv3)[7]=asin(((G *)Rv3)[7]);
        }
        break;
        case 97:
        case 115:Ra.sl[6]=1798; /* line # 1798 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,803,2);
        else {
          Ra.sl[6]=1799; /* line # 1799 */
          ((G *)Rv3)[7]=acos(((G *)Rv3)[7]);
        }
        break;
        case 98:
        case 116:Ra.sl[6]=1801; /* line # 1801 */
        ((G *)Rv3)[7]=atan(((G *)Rv3)[7]);
        break;
        case 102:
        case 120:Ra.sl[6]=1804; /* line # 1804 */
        ((G *)Rv3)[7]=PAS__SHG(((G *)Rv3)[7]);
        break;
        case 103:
        case 121:Ra.sl[6]=1806; /* line # 1806 */
        ((G *)Rv3)[7]=PAS__CHG(((G *)Rv3)[7]);
        break;
        case 104:
        case 122:Ra.sl[6]=1808; /* line # 1808 */
        ((G *)Rv3)[7]=PAS__THG(((G *)Rv3)[7]);
        break;
        case 105:
        case 123:Ra.sl[6]=1811; /* line # 1811 */
        ((G *)Rv3)[7]=PAS__ASHG(((G *)Rv3)[7]);
        break;
        case 106:
        case 124:Ra.sl[6]=1814; /* line # 1814 */
        if (((G *)Rv3)[7]<1.000000000000000E+000) P_src_error(Rd.s+1026,805,2);
        else {
          Ra.sl[6]=1815; /* line # 1815 */
          ((G *)Rv3)[7]=PAS__ACHG(((G *)Rv3)[7]);
        }
        break;
        case 107:
        case 125:Ra.sl[6]=1818; /* line # 1818 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,806,2);
        else {
          Ra.sl[6]=1819; /* line # 1819 */
          ((G *)Rv3)[7]=PAS__ATHG(((G *)Rv3)[7]);
        }
        break;
        case 100:
        case 118:Ra.sl[6]=1822; /* line # 1822 */
        ((G *)Rv3)[7]=exp(((G *)Rv3)[7]);
        break;
        case 101:
        case 119:Ra.sl[6]=1825; /* line # 1825 */
        if (((G *)Rv3)[7]<=0.000000000000000E-001) P_src_error(Rd.s+1026,804,2);
        else {
          Ra.sl[6]=1826; /* line # 1826 */
          ((G *)Rv3)[7]=log(((G *)Rv3)[7]);
        }
        break;
        default:break;
      }
      Ra.sl[6]=1830; /* line # 1830 */
      ((V *)Rv2)[4]=NULL;
      Ra.sl[6]=1832; /* line # 1832 */
      if (64&((UW *)Rv1)[5]) ((V *)Rv2)[3]=((V *)Rv1)[0];
      else {
        Ra.sl[6]=1833; /* line # 1833 */
        ((V *)Rv2)[3]=((V *)Rv0)[2];
      }
      Ra.sl[6]=1834; /* line # 1834 */
      ((V *)Rv3)[4]=((V *)Rv2)[3];
      Ra.sl[6]=1835; /* line # 1835 */
      ((UB *)Rv3)[48]=((UB *)((V *)Rv2)[3])[93];
    }
    else {
      Ra.sl[6]=1839; /* line # 1839 */
      if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+1026,851,2);
      Ra.sl[6]=1840; /* line # 1840 */
      if (((UB *)Rv0)[9]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])
      [11]) {
        Ra.sl[6]=1843; /* line # 1843 */
        P_lgt_new(&Rv4,((V *)Rv0)[2],6, F_puna);
        Ra.sl[6]=1844; /* line # 1844 */
        Rv5=Rv4;
        Ra.sl[6]=1846; /* line # 1846 */
        if (64&((UW *)Rv1)[5]) ((V *)Rv5)[3]=((V *)Rv1)[0];
        Ra.sl[6]=1847; /* line # 1847 */
        ((V *)Rv5)[0]=((V *)F_puna)[0];
        Ra.sl[6]=1848; /* line # 1848 */
        ((UB *)Rv5)[41]=((UB *)Rv0)[9];
        Ra.sl[6]=1849; /* line # 1849 */
        ((UW *)Rv5)[10]=((UW *)F_puna)[10]&~2;
        Ra.sl[6]=1851; /* line # 1851 */
        ((V *)Rv2)[0]=NULL;
        Ra.sl[6]=1852; /* line # 1852 */
        F_puna=Rv4;
      }
      else {
        Ra.sl[6]=1854; /* line # 1854 */
        ((V *)F_puna)[3]=((V *)Rv0)[2];
      }
    }
  }
  Ra.sl[6]=1857; /* line # 1857 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  G Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  register V Rv12;
  UL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1030;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1879; /* line # 1879 */
  Rv0=((V *)F_ob1)[0];
  Ra.sl[6]=1880; /* line # 1880 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1881; /* line # 1881 */
    Rv1=F_p;
    Ra.sl[6]=1883; /* line # 1883 */
    Rv2=((V *)Rv1)[2];
    Ra.sl[6]=1885; /* line # 1885 */
    Rv3=((V *)Rv1)[3]+8;
    Ra.sl[6]=1886; /* line # 1886 */
    if (64&((UW *)Rv3)[5]) Rv2=((V *)Rv3)[0];
    else {
      Ra.sl[6]=1888; /* line # 1888 */
      if (((UB *)Rv3)[8]!=0) F_ob1=P_exp_val_una(F_ob1, V_oparg_cvtab.v[((UB *)Rv3)
      [8]]);
    }
    Ra.sl[6]=1889; /* line # 1889 */
    Rv4=((V *)Rv1)[3]+24;
    Ra.sl[6]=1890; /* line # 1890 */
    if (64&((UW *)Rv4)[5]) Rv2=((V *)Rv4)[0];
    else {
      Ra.sl[6]=1892; /* line # 1892 */
      if (((UB *)Rv4)[8]!=0) Rv0=P_exp_val_una(Rv0, V_oparg_cvtab.v[((UB *)Rv4)[
8]]);
    }
    Ra.sl[6]=1893; /* line # 1893 */
    ((V *)F_ob1)[0]=Rv0;
    Ra.sl[6]=1894; /* line # 1894 */
    if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
      Ra.sl[6]=1897; /* line # 1897 */
      Rv5=((V *)F_ob1)[7];
      Rv6=Rv0;
      Ra.sl[6]=1898; /* line # 1898 */
      switch (((UB *)Rv1)[9]) {
        case 89:Ra.sl[6]=1899; /* line # 1899 */
        ((SL *)Rv5)[13]=PAS__IIPOWER(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 90:
        case 108:Ra.sl[6]=1901; /* line # 1901 */
        ((G *)Rv5)[7]=pow  (((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        case 91:
        case 109:Ra.sl[6]=1903; /* line # 1903 */
        ((G *)Rv5)[7]=PAS__IGPOWER(((G *)Rv5)[7],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 49:Ra.sl[6]=1905; /* line # 1905 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]+((SL *)((V *)Rv6)[7])[13];
        break;
        case 50:Ra.sl[6]=1906; /* line # 1906 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        break;
        case 51:Ra.sl[6]=1907; /* line # 1907 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]*((SL *)((V *)Rv6)[7])[13];
        break;
        case 52:Ra.sl[6]=1908; /* line # 1908 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]/((SL *)((V *)Rv6)[7])[13];
        break;
        case 53:Ra.sl[6]=1909; /* line # 1909 */
        ((SL *)Rv5)[13]=PAS__I_MOD(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 54:Ra.sl[6]=1910; /* line # 1910 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]%((SL *)((V *)Rv6)[7])[13];
        break;
        case 67:
        case 85:Ra.sl[6]=1913; /* line # 1913 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]+((G *)((V *)Rv6)[7])[7];
        break;
        case 68:
        case 86:Ra.sl[6]=1915; /* line # 1915 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        break;
        case 69:
        case 87:Ra.sl[6]=1917; /* line # 1917 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]*((G *)((V *)Rv6)[7])[7];
        break;
        case 70:
        case 88:Ra.sl[6]=1919; /* line # 1919 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]/((G *)((V *)Rv6)[7])[7];
        break;
        case 7:Ra.sl[6]=1921; /* line # 1921 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0&&((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 8:Ra.sl[6]=1922; /* line # 1922 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0||((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 9:Ra.sl[6]=1923; /* line # 1923 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0!=((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 11:Ra.sl[6]=1926; /* line # 1926 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13];
        break;
        case 12:Ra.sl[6]=1927; /* line # 1927 */
        ((UL *)Rv5)[13]=(((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13])&~(((UL *)Rv5)
        [13]&((UL *)((V *)Rv6)[7])[13]);
        break;
        case 13:Ra.sl[6]=1929; /* line # 1929 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&~((UL *)((V *)Rv6)[7])[13];
        break;
        case 14:Ra.sl[6]=1930; /* line # 1930 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13];
        break;
        case 15:Ra.sl[6]=1931; /* line # 1931 */
        ((SL *)Rv5)[13]=(SL)((((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 16:break;
        case 17:break;
        case 18:break;
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:Ra.sl[6]=1940; /* line # 1940 */
        switch (((UB *)Rv1)[9]) {
          case 19:
          case 20:Ra.sl[6]=1942; /* line # 1942 */
          Rv7=(SL)PAS__SET_LE(((UL *)Rv5)[13],((UL *)((V *)Rv6)[7])[13]);
          break;
          case 21:
          case 22:Ra.sl[6]=1944; /* line # 1944 */
          Rv7=(SL)PAS__SET_LE(((UL *)((V *)Rv6)[7])[13],((UL *)Rv5)[13]);
          break;
          case 23:Ra.sl[6]=1945; /* line # 1945 */
          Rv7=(SL)(((UL *)Rv5)[13]!=((UL *)((V *)Rv6)[7])[13]);
          break;
          case 24:Ra.sl[6]=1946; /* line # 1946 */
          Rv7=(SL)(((UL *)Rv5)[13]==((UL *)((V *)Rv6)[7])[13]);
          break;
          default:break;
        }
        Ra.sl[6]=1949; /* line # 1949 */
        ((UB *)Rv5)[48]=1;
        Ra.sl[6]=1950; /* line # 1950 */
        ((SL *)Rv5)[6]=0;
        Ra.sl[6]=1951; /* line # 1951 */
        ((SL *)Rv5)[13]=Rv7;
        break;
        case 25:Ra.sl[6]=1954; /* line # 1954 */
        Rv7=(SL)((1<<((SL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:Ra.sl[6]=1959; /* line # 1959 */
        Rv7=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        Ra.sl[6]=1960; /* line # 1960 */
        switch (((UB *)Rv1)[9]) {
          case 28:
          case 32:Ra.sl[6]=1961; /* line # 1961 */
          ((SL *)Rv5)[13]=(SL)(Rv7<0);
          break;
          case 29:
          case 33:Ra.sl[6]=1962; /* line # 1962 */
          ((SL *)Rv5)[13]=(SL)(Rv7<=0);
          break;
          case 30:
          case 34:Ra.sl[6]=1963; /* line # 1963 */
          ((SL *)Rv5)[13]=(SL)(Rv7>=0);
          break;
          case 31:
          case 35:Ra.sl[6]=1964; /* line # 1964 */
          ((SL *)Rv5)[13]=(SL)(Rv7>0);
          break;
          case 27:Ra.sl[6]=1965; /* line # 1965 */
          ((SL *)Rv5)[13]=(SL)(Rv7!=0);
          break;
          case 26:Ra.sl[6]=1966; /* line # 1966 */
          ((SL *)Rv5)[13]=(SL)(Rv7==0);
          break;
        }
        break;
        case 55:
        case 56:
        case 57:
        case 58:
        case 59:
        case 60:
        case 71:
        case 72:
        case 73:
        case 74:
        case 75:
        case 76:Ra.sl[6]=1972; /* line # 1972 */
        Rv8=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        Ra.sl[6]=1973; /* line # 1973 */
        switch (((UB *)Rv1)[9]) {
          case 55:
          case 71:Ra.sl[6]=1974; /* line # 1974 */
          ((SL *)Rv5)[13]=(SL)(Rv8<0.000000000000000E-001);
          break;
          case 56:
          case 72:Ra.sl[6]=1975; /* line # 1975 */
          ((SL *)Rv5)[13]=(SL)(Rv8<=0.000000000000000E-001);
          break;
          case 57:
          case 73:Ra.sl[6]=1976; /* line # 1976 */
          ((SL *)Rv5)[13]=(SL)(Rv8>=0.000000000000000E-001);
          break;
          case 58:
          case 74:Ra.sl[6]=1977; /* line # 1977 */
          ((SL *)Rv5)[13]=(SL)(Rv8>0.000000000000000E-001);
          break;
          case 60:
          case 76:Ra.sl[6]=1978; /* line # 1978 */
          ((SL *)Rv5)[13]=(SL)(Rv8!=0.000000000000000E-001);
          break;
          case 59:
          case 75:Ra.sl[6]=1979; /* line # 1979 */
          ((SL *)Rv5)[13]=(SL)(Rv8==0.000000000000000E-001);
          break;
        }
        break;
        case 36:
        case 37:break;
        case 99:
        case 117:Ra.sl[6]=1989; /* line # 1989 */
        ((G *)Rv5)[7]=atan2(((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        default:break;
      }
      Ra.sl[6]=1993; /* line # 1993 */
      Rv9=F_ob1;
      Rv10=((V *)Rv9)[7];
      Ra.sl[6]=1995; /* line # 1995 */
      ((V *)Rv9)[4]=NULL;
      Ra.sl[6]=1997; /* line # 1997 */
      ((V *)Rv9)[3]=Rv2;
      Ra.sl[6]=1998; /* line # 1998 */
      ((V *)Rv10)[4]=((V *)Rv9)[3];
      Ra.sl[6]=1999; /* line # 1999 */
      ((UB *)Rv10)[48]=((UB *)((V *)Rv9)[3])[93];
      Ra.sl[6]=2001; /* line # 2001 */
      ((V *)F_ob1)[0]=NULL;
      Ra.sl[6]=2002; /* line # 2002 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=2006; /* line # 2006 */
      Rv11=1;
      Ra.sl[6]=2007; /* line # 2007 */
      switch (((UB *)Rv1)[9]) {
        case 25:Ra.sl[6]=2009; /* line # 2009 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2011; /* line # 2011 */
          Rv12=F_ob1;
          Ra.sl[6]=2013; /* line # 2013 */
          Rv13=((SL *)((V *)Rv12)[7])[13];
          Ra.sl[6]=2014; /* line # 2014 */
          ((V *)Rv12)[3]=((V *)Rv0)[3];
          Ra.sl[6]=2015; /* line # 2015 */
          P_val_free(((V *)Rv12)+7);
          Ra.sl[6]=2016; /* line # 2016 */
          P_val_new(((V *)Rv12)+7,((V *)Rv12)[3]);
          Ra.sl[6]=2017; /* line # 2017 */
          Rv14=((V *)Rv12)[7];
          Ra.sl[6]=2019; /* line # 2019 */
          ((SL *)Rv14)[6]=(Rv13+7)/8;
          Ra.sl[6]=2020; /* line # 2020 */
          ((UL *)Rv14)[13]=1<<Rv13;
          Ra.sl[6]=2023; /* line # 2023 */
          P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
          Ra.sl[6]=2024; /* line # 2024 */
          Rv15=Rv0;
          Ra.sl[6]=2026; /* line # 2026 */
          ((UW *)Rv15)[10]=1;
          Ra.sl[6]=2027; /* line # 2027 */
          ((UB *)Rv15)[41]=15;
          Ra.sl[6]=2029; /* line # 2029 */
          Rv11=0;
        }
        break;
        case 7:Ra.sl[6]=2033; /* line # 2033 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2034; /* line # 2034 */
          Rv16=F_ob1;
          Ra.sl[6]=2036; /* line # 2036 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2037; /* line # 2037 */
          Rv11=0;
          Ra.sl[6]=2038; /* line # 2038 */
          if (((SL *)((V *)Rv16)[7])[13]<=0) {
            Ra.sl[6]=2040; /* line # 2040 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2041; /* line # 2041 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2044; /* line # 2044 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2047; /* line # 2047 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2048; /* line # 2048 */
            Rv17=Rv0;
            Ra.sl[6]=2050; /* line # 2050 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2051; /* line # 2051 */
            Rv11=0;
            Ra.sl[6]=2052; /* line # 2052 */
            if (((SL *)((V *)Rv17)[7])[13]<=0) {
              Ra.sl[6]=2053; /* line # 2053 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2056; /* line # 2056 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2057; /* line # 2057 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 8:Ra.sl[6]=2062; /* line # 2062 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2063; /* line # 2063 */
          Rv18=F_ob1;
          Ra.sl[6]=2065; /* line # 2065 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2066; /* line # 2066 */
          Rv11=0;
          Ra.sl[6]=2067; /* line # 2067 */
          if (((SL *)((V *)Rv18)[7])[13]>0) {
            Ra.sl[6]=2069; /* line # 2069 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2070; /* line # 2070 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2073; /* line # 2073 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2076; /* line # 2076 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2077; /* line # 2077 */
            Rv19=Rv0;
            Ra.sl[6]=2079; /* line # 2079 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2080; /* line # 2080 */
            Rv11=0;
            Ra.sl[6]=2081; /* line # 2081 */
            if (((SL *)((V *)Rv19)[7])[13]>0) {
              Ra.sl[6]=2082; /* line # 2082 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2085; /* line # 2085 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2086; /* line # 2086 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 1:
        case 3:
        case 4:
        case 5:Ra.sl[6]=2092; /* line # 2092 */
        Rv20=F_ob1;
        Ra.sl[6]=2094; /* line # 2094 */
        ((UW *)Rv20)[10]=((UW *)Rv20)[10]|8;
        Ra.sl[6]=2095; /* line # 2095 */
        if (!(2&((UW *)Rv20)[10])) P_src_error(Rd.s+1045,852,2);
        Ra.sl[6]=2097; /* line # 2097 */
        Rv21=Rv0;
        Ra.sl[6]=2099; /* line # 2099 */
        if (!(1&((UW *)Rv21)[10])) {
          Ra.sl[6]=2100; /* line # 2100 */
          P_src_error(Rd.s+1045,851,1);
        }
        Ra.sl[6]=2101; /* line # 2101 */
        if ((((UB *)Rv1)[9]!=1&&((UB *)Rv21)[40]==8)&&((V *)Rv21)[3]!=NULL) {
          Ra.sl[6]=2104; /* line # 2104 */
          Rv22=((V *)Rv21)[6];
          Ra.sl[6]=2105; /* line # 2105 */
          if (((V *)Rv22)[8]!=NULL) {
            Ra.sl[6]=2106; /* line # 2106 */
            if (((UB *)((V *)Rv22)[8])[86]==7) {
              Ra.sl[6]=2108; /* line # 2108 */
              ((V *)F_ob1)[0]=((V *)((V *)Rv21)[1])[0];
              Ra.sl[6]=2109; /* line # 2109 */
              P_lgt_free(((V *)Rv21)+1);
              Ra.sl[6]=2110; /* line # 2110 */
              ((UW *)Rv21)[10]=((UW *)Rv21)[10]|128;
              Ra.sl[6]=2111; /* line # 2111 */
              ((V *)Rv21)[1]=F_ob1;
              Ra.sl[6]=2112; /* line # 2112 */
              Rv11=0;
            }
          }
        }
        break;
        default:Ra.sl[6]=2117; /* line # 2117 */
        if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) {
          Ra.sl[6]=2118; /* line # 2118 */
          P_src_error(Rd.s+1045,851,1);
        }
        break;
      }
      Ra.sl[6]=2120; /* line # 2120 */
      if (Rv11) {
        Ra.sl[6]=2122; /* line # 2122 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Ra.sl[6]=2123; /* line # 2123 */
        Rv23=Rv0;
        Ra.sl[6]=2125; /* line # 2125 */
        ((V *)Rv23)[3]=Rv2;
        Ra.sl[6]=2126; /* line # 2126 */
        ((UW *)Rv23)[10]=1;
        Ra.sl[6]=2127; /* line # 2127 */
        ((UB *)Rv23)[41]=((UB *)Rv1)[9];
      }
      Ra.sl[6]=2130; /* line # 2130 */
      F_ob1=Rv0;
    }
  }
  Ra.sl[6]=2133; /* line # 2133 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1049;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2148; /* line # 2148 */
  Rv0=F_lgt;
  Ra.sl[6]=2149; /* line # 2149 */
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Ra.sl[6]=2150; /* line # 2150 */
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=2152; /* line # 2152 */
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2153; /* line # 2153 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) {
      Ra.sl[6]=2156; /* line # 2156 */
      Rv0=((V *)Rv1)[1];
    }
    else {
      Ra.sl[6]=2157; /* line # 2157 */
      Rv0=NULL;
    }
  }
  Ra.sl[6]=2159; /* line # 2159 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2165; /* line # 2165 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1070;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2187; /* line # 2187 */
  Rv0=0;
  Ra.sl[6]=2188; /* line # 2188 */
  Rv1=NULL;
  Ra.sl[6]=2189; /* line # 2189 */
  if ((*F_lgt)!=NULL) {
    Ra.sl[6]=2190; /* line # 2190 */
    Rv2=(*F_lgt);
    Ra.sl[6]=2192; /* line # 2192 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Ra.sl[6]=2193; /* line # 2193 */
    Rv3=((V *)Rv2)[1];
    Ra.sl[6]=2194; /* line # 2194 */
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2197; /* line # 2197 */
  if (Rv1!=NULL) {
    Ra.sl[6]=2198; /* line # 2198 */
    Rv4=Rv1;
    Ra.sl[6]=2200; /* line # 2200 */
    Rv5=NULL;
    Ra.sl[6]=2201; /* line # 2201 */
    Rv6=NULL;
    Ra.sl[6]=2202; /* line # 2202 */
    Rv7=((V *)Rv4)[8];
    Ra.sl[6]=2203; /* line # 2203 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2204; /* line # 2204 */
      Rv8=((V *)Rv4)[11];
      Ra.sl[6]=2205; /* line # 2205 */
      if (!((UB *)Rv8)[92]) {
        Ra.sl[6]=2213; /* line # 2213 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        Ra.sl[6]=2214; /* line # 2214 */
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        Ra.sl[6]=2215; /* line # 2215 */
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        Ra.sl[6]=2216; /* line # 2216 */
        ((V *)(*F_lgt))[1]=Rv5;
        Ra.sl[6]=2217; /* line # 2217 */
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2220; /* line # 2220 */
    while (Rv7!=NULL){
      Ra.sl[6]=2222; /* line # 2222 */
      Rv9=NULL;
      Ra.sl[6]=2223; /* line # 2223 */
      Rv10=0;
      Ra.sl[6]=2224; /* line # 2224 */
      Rv11=0;
      Ra.sl[6]=2225; /* line # 2225 */
      Rv12=Rv3;
      Ra.sl[6]=2226; /* line # 2226 */
      Rv13=Rv7;
      Ra.sl[6]=2228; /* line # 2228 */
      if (Rv3!=NULL) {
        Ra.sl[6]=2230; /* line # 2230 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          Ra.sl[6]=2233; /* line # 2233 */
          if (((V *)Rv13)[5]!=NULL) {
            Ra.sl[6]=2235; /* line # 2235 */
            Rv14=((V *)Rv13)[5];
            Ra.sl[6]=2236; /* line # 2236 */
            switch (((UB *)Rv14)[93]) {
              case 10:Ra.sl[6]=2238; /* line # 2238 */
              if (P_comp_type(((V *)Rv13)[5],V_typ_std.v[10],0,0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1,0)) {
                Ra.sl[6]=2240; /* line # 2240 */
                if (((UB *)Rv3)[40]==14) {
                  Ra.sl[6]=2242; /* line # 2242 */
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  Ra.sl[6]=2243; /* line # 2243 */
                  P_val_free(((V *)Rv3)+7);
                  Ra.sl[6]=2244; /* line # 2244 */
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2245; /* line # 2245 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Ra.sl[6]=2246; /* line # 2246 */
                  Rv16=((V *)Rv3)[7];
                  Ra.sl[6]=2248; /* line # 2248 */
                  ((UB *)Rv16)[48]=29;
                  Ra.sl[6]=2249; /* line # 2249 */
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2250; /* line # 2250 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  Ra.sl[6]=2251; /* line # 2251 */
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2256; /* line # 2256 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Ra.sl[6]=2257; /* line # 2257 */
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  Ra.sl[6]=2258; /* line # 2258 */
                  ((V *)Rv3)[0]=Rv17;
                  Ra.sl[6]=2259; /* line # 2259 */
                  ((UW *)Rv3)[10]=5;
                  Ra.sl[6]=2260; /* line # 2260 */
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2261; /* line # 2261 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2267; /* line # 2267 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0,0)) {
                Ra.sl[6]=2270; /* line # 2270 */
                Rv10=1;
                Ra.sl[6]=2271; /* line # 2271 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2272; /* line # 2272 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[5],3, Rv3);
                Ra.sl[6]=2273; /* line # 2273 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2274; /* line # 2274 */
                  ((V *)Rv5)[0]=Rv3;
                }
                Ra.sl[6]=2275; /* line # 2275 */
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[14];
                Ra.sl[6]=2276; /* line # 2276 */
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2279; /* line # 2279 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0,0)) {
                  Ra.sl[6]=2280; /* line # 2280 */
                  Rv10=1;
                  Rv11=1;
                }
              }
              Ra.sl[6]=2281; /* line # 2281 */
              if (((UB *)Rv14)[93]==9) Rv9=((V *)Rv13)[5];
              break;
              default:break;
            }
            Ra.sl[6]=2296; /* line # 2296 */
            if (64&((UW *)Rv13)[44]&&Rv6==NULL) Rv6=((V *)Rv3)[3];
            Ra.sl[6]=2299; /* line # 2299 */
            switch (((UB *)Rv13)[86]) {
              case 8:Ra.sl[6]=2302; /* line # 2302 */
              if (!(4&((UW *)Rv3)[10])) {
                Ra.sl[6]=2304; /* line # 2304 */
                Rv18=Rv3;
                Ra.sl[6]=2305; /* line # 2305 */
                if (64&((UW *)Rv13)[42]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Ra.sl[6]=2306; /* line # 2306 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2307; /* line # 2307 */
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                Ra.sl[6]=2308; /* line # 2308 */
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[6]=2310; /* line # 2310 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2311; /* line # 2311 */
                  ((V *)Rv5)[0]=Rv3;
                }
              }
              break;
              case 11:Ra.sl[6]=2317; /* line # 2317 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              Ra.sl[6]=2318; /* line # 2318 */
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              Ra.sl[6]=2319; /* line # 2319 */
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              Ra.sl[6]=2320; /* line # 2320 */
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2322; /* line # 2322 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else {
                Ra.sl[6]=2323; /* line # 2323 */
                ((V *)Rv5)[0]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=2328; /* line # 2328 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2334; /* line # 2334 */
        P_lgt_new(&Rv3,((V *)Rv13)[5],14,NULL);
        Ra.sl[6]=2336; /* line # 2336 */
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else {
          Ra.sl[6]=2337; /* line # 2337 */
          ((V *)Rv5)[0]=Rv3;
        }
        Ra.sl[6]=2338; /* line # 2338 */
        Rv0=1;
      }
      Ra.sl[6]=2341; /* line # 2341 */
      if (Rv0) {
        Ra.sl[6]=2342; /* line # 2342 */
        if (8192&((UW *)Rv13)[42]) {
          Ra.sl[6]=2343; /* line # 2343 */
          Rv19=Rv3;
          Ra.sl[6]=2345; /* line # 2345 */
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2346; /* line # 2346 */
          ((V *)Rv19)[3]=((V *)Rv13)[5];
          Ra.sl[6]=2347; /* line # 2347 */
          ((V *)Rv19)[4]=NULL;
        }
        else {
          Ra.sl[6]=2350; /* line # 2350 */
          if (((V *)Rv13)[7]!=NULL) {
            Ra.sl[6]=2351; /* line # 2351 */
            Rv20=Rv3;
            Ra.sl[6]=2353; /* line # 2353 */
            ((UB *)Rv20)[40]=14;
            Ra.sl[6]=2354; /* line # 2354 */
            ((V *)Rv20)[3]=((V *)Rv13)[5];
            Ra.sl[6]=2355; /* line # 2355 */
            ((V *)Rv20)[7]=((V *)Rv13)[7];
            Ra.sl[6]=2356; /* line # 2356 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[5]);
            Ra.sl[6]=2357; /* line # 2357 */
            ((V *)Rv20)[4]=NULL;
          }
          else {
            Ra.sl[6]=2359; /* line # 2359 */
            P_src_error_s(Rd.s+1086,854,2,((V *)Rv13)[0],NULL);
          }
        }
      }
      Ra.sl[6]=2361; /* line # 2361 */
      Rv5=Rv3;
      Ra.sl[6]=2364; /* line # 2364 */
      if (Rv9!=NULL) {
        Ra.sl[6]=2365; /* line # 2365 */
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2366; /* line # 2366 */
          Rv21=((V *)Rv9)[15];
          Ra.sl[6]=2367; /* line # 2367 */
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Ra.sl[6]=2369; /* line # 2369 */
            Rv22=Rv12;
            Ra.sl[6]=2370; /* line # 2370 */
            if (((UB *)Rv22)[40]==8) ((UW *)Rv22)[10]=((UW *)Rv22)[10]|128;
            Ra.sl[6]=2372; /* line # 2372 */
            Rv23=((V *)Rv9)[15];
            Ra.sl[6]=2373; /* line # 2373 */
            Rv24=NULL;
            Rv25=NULL;
            Ra.sl[6]=2375; /* line # 2375 */
            if (Rv10) {
              while (1){
                Ra.sl[6]=2379; /* line # 2379 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[93]!=22)  break;
              }
              Ra.sl[6]=2382; /* line # 2382 */
              if (Rv11) {
                Ra.sl[6]=2384; /* line # 2384 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Ra.sl[6]=2385; /* line # 2385 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2386; /* line # 2386 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2388; /* line # 2388 */
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[6]=2389; /* line # 2389 */
                  Rv7=((V *)Rv7)[3];
                }
                else {
                  Ra.sl[6]=2391; /* line # 2391 */
                  Rv25=Rv24;
                }
              }
              else {
                Ra.sl[6]=2395; /* line # 2395 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2397; /* line # 2397 */
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Ra.sl[6]=2398; /* line # 2398 */
                  Rv25=Rv24;
                  Ra.sl[6]=2399; /* line # 2399 */
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2401; /* line # 2401 */
                if (((UB *)Rv12)[40]==14) {
                  Ra.sl[6]=2402; /* line # 2402 */
                  Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)Rv12)[7])[6]);
                }
                else {
                  Ra.sl[6]=2405; /* line # 2405 */
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[5],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2407; /* line # 2407 */
                  if (!(64&((UW *)Rv7)[42])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[14];
                  Ra.sl[6]=2409; /* line # 2409 */
                  if (((V *)Rv17)[3]!=Rv23) {
                    Ra.sl[6]=2411; /* line # 2411 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2412; /* line # 2412 */
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                Ra.sl[6]=2415; /* line # 2415 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2416; /* line # 2416 */
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[6]=2417; /* line # 2417 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Ra.sl[6]=2418; /* line # 2418 */
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[6]=2423; /* line # 2423 */
              Rv26=((V *)Rv3)[3];
              Ra.sl[6]=2424; /* line # 2424 */
              if (Rv26!=NULL) {
                Ra.sl[6]=2425; /* line # 2425 */
                while (Rv9!=NULL&&Rv26!=NULL){
                  Ra.sl[6]=2426; /* line # 2426 */
                  if (((UB *)Rv9)[93]==9&&(((UB *)Rv26)[93]==9||((UB *)Rv26)[93]
                  ==8)) {
                    Ra.sl[6]=2430; /* line # 2430 */
                    Rv27=((V *)Rv26)[15];
                    Ra.sl[6]=2431; /* line # 2431 */
                    Rv23=((V *)Rv9)[15];
                    while (1){
                      Ra.sl[6]=2434; /* line # 2434 */
                      if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                      if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[93]!=22)  break;
                    }
                    Ra.sl[6]=2437; /* line # 2437 */
                    if (((UB *)Rv27)[93]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                    else {
                      Ra.sl[6]=2438; /* line # 2438 */
                      Rv28=Rv12;
                    }
                    Ra.sl[6]=2442; /* line # 2442 */
                    if (((UB *)((V *)Rv21)[13])[40]!=14) {
                      Ra.sl[6]=2444; /* line # 2444 */
                      if (((UB *)Rv27)[93]==22) {
                        Ra.sl[6]=2446; /* line # 2446 */
                        Rv17=P_lgt_type_eval(((V *)Rv27)[13],Rv28,NULL,0);
                        Ra.sl[6]=2447; /* line # 2447 */
                        if (((SL *)Rv27)[11]!=((SL *)Rv23)[11]) {
                          Ra.sl[6]=2449; /* line # 2449 */
                          Rv17=P_lgt_new_code(0, Rv17);
                          Ra.sl[6]=2450; /* line # 2450 */
                          ((V *)Rv17)[3]=Rv23;
                        }
                      }
                      else {
                        Ra.sl[6]=2453; /* line # 2453 */
                        Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[29]);
                      }
                      Ra.sl[6]=2454; /* line # 2454 */
                      if (Rv25==NULL) Rv24=Rv17;
                      else {
                        Ra.sl[6]=2455; /* line # 2455 */
                        ((V *)Rv25)[0]=Rv17;
                      }
                      Ra.sl[6]=2456; /* line # 2456 */
                      Rv25=Rv17;
                      Ra.sl[6]=2457; /* line # 2457 */
                      Rv7=((V *)Rv7)[3];
                    }
                    Ra.sl[6]=2460; /* line # 2460 */
                    if (((UB *)Rv27)[93]==22) {
                      Ra.sl[6]=2462; /* line # 2462 */
                      Rv17=P_lgt_type_eval(((V *)Rv27)[14],Rv28,NULL,0);
                      Ra.sl[6]=2463; /* line # 2463 */
                      if (Rv27!=Rv23) {
                        Ra.sl[6]=2465; /* line # 2465 */
                        Rv17=P_lgt_new_code(0, Rv17);
                        Ra.sl[6]=2466; /* line # 2466 */
                        ((V *)Rv17)[3]=Rv23;
                      }
                    }
                    else {
                      Ra.sl[6]=2469; /* line # 2469 */
                      Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[30]);
                    }
                    Ra.sl[6]=2470; /* line # 2470 */
                    if (Rv25==NULL) Rv24=Rv17;
                    else {
                      Ra.sl[6]=2471; /* line # 2471 */
                      ((V *)Rv25)[0]=Rv17;
                    }
                    Ra.sl[6]=2472; /* line # 2472 */
                    Rv25=Rv17;
                    Ra.sl[6]=2473; /* line # 2473 */
                    Rv7=((V *)Rv7)[3];
                    Ra.sl[6]=2474; /* line # 2474 */
                    Rv26=((V *)Rv26)[14];
                    Ra.sl[6]=2475; /* line # 2475 */
                    Rv9=((V *)Rv9)[14];
                  }
                  else {
                    Ra.sl[6]=2476; /* line # 2476 */
                    Rv9=NULL;
                  }
                }
              }
              Ra.sl[6]=2478; /* line # 2478 */
              Rv29=Rv3;
              Ra.sl[6]=2479; /* line # 2479 */
              if (((SL *)((V *)Rv29)[3])[10]>0) {
                Ra.sl[6]=2480; /* line # 2480 */
                ((SL *)Rv29)[4]=((SL *)Rv29)[4]+((SL *)((V *)Rv29)[3])[10];
              }
            }
            Ra.sl[6]=2484; /* line # 2484 */
            if (Rv24!=NULL) {
              Ra.sl[6]=2486; /* line # 2486 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              Ra.sl[6]=2487; /* line # 2487 */
              ((V *)Rv3)[0]=Rv24;
              Ra.sl[6]=2488; /* line # 2488 */
              Rv3=Rv25;
            }
            Ra.sl[6]=2490; /* line # 2490 */
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2493; /* line # 2493 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Ra.sl[6]=2494; /* line # 2494 */
      Rv7=((V *)Rv7)[3];
    }
    Ra.sl[6]=2497; /* line # 2497 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2498; /* line # 2498 */
      Rv30=(*F_lgt);
      Ra.sl[6]=2500; /* line # 2500 */
      if (Rv6!=NULL) {
        Ra.sl[6]=2502; /* line # 2502 */
        ((V *)Rv30)[3]=Rv6;
        Ra.sl[6]=2503; /* line # 2503 */
        if (!((UB *)Rv6)[92]&&((V *)Rv30)[1]!=NULL) {
          Ra.sl[6]=2504; /* line # 2504 */
          ((V *)((V *)Rv30)[1])[3]=Rv6;
        }
      }
      Ra.sl[6]=2508; /* line # 2508 */
      if (!((UB *)((V *)Rv4)[11])[92]) {
        Ra.sl[6]=2509; /* line # 2509 */
        P_tmpstk_allocate(((V *)Rv30)[1],((V *)((V *)Rv30)[1])[3]);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  register V Rv14;
  register V Rv15;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1090;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2648; /* line # 2648 */
  Rv0=0;
  Ra.sl[6]=2649; /* line # 2649 */
  while (!Rv0&&(*F_pg)!=NULL){
    Ra.sl[6]=2651; /* line # 2651 */
    Rv1=F_parm_lst;
    Ra.sl[6]=2652; /* line # 2652 */
    Rv2=(*F_pg);
    Ra.sl[6]=2653; /* line # 2653 */
    if (((UB *)Rv2)[8]&&F_npa<=2) {
      Ra.sl[6]=2655; /* line # 2655 */
      Rv3=Rv1;
      Ra.sl[6]=2656; /* line # 2656 */
      switch (F_npa) {
        case 0:Ra.sl[6]=2657; /* line # 2657 */
        Rv0=((V *)Rv2)[3]==NULL;
        break;
        case 1:Ra.sl[6]=2659; /* line # 2659 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[6]=2660; /* line # 2660 */
          if (((SL *)((V *)Rv2)[3])[0]==1) {
            Ra.sl[6]=2661; /* line # 2661 */
            Rv4=((V *)Rv2)[3]+8;
            Ra.sl[6]=2662; /* line # 2662 */
            if ((1&((UW *)Rv4)[5])<=(2&((UW *)Rv3)[10])) {
              Ra.sl[6]=2663; /* line # 2663 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv4)[0],(8&((UW *)Rv4)[5])!=0,0);
            }
          }
        }
        break;
        case 2:Ra.sl[6]=2665; /* line # 2665 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[6]=2666; /* line # 2666 */
          if ((((SL *)((V *)Rv2)[3])[0]==2&&((SL *)((V *)Rv3)[3])[11]>0)&&((SL *)(
          (V *)((V *)Rv3)[0])[3])[11]>0) {
            Ra.sl[6]=2667; /* line # 2667 */
            Rv5=((V *)Rv2)[3]+8;
            Ra.sl[6]=2669; /* line # 2669 */
            memcpy(Ra.s+32,((V *)Rv2)[3]+24,12);
            Ra.sl[6]=2670; /* line # 2670 */
            if (((1&((UW *)Rv5)[5])<=(2&((UW *)Rv3)[10])&&(1&Ra.uw[21])<=(2&((UW
             *)((V *)Rv3)[0])[10]))&&((SL *)((V *)Rv3)[3])[10]==0) {
              Ra.sl[6]=2673; /* line # 2673 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv5)[0],(8&((UW *)Rv5)[5])!=0,0)&&
              P_comp_type(((V *)((V *)Rv3)[0])[3],Ra.v[4],(8&Ra.uw[21])!=0,0);
            }
            Ra.sl[6]=2675; /* line # 2675 */
            if (Rv0) {
              Ra.sl[6]=2676; /* line # 2676 */
              if (4&((UW *)Rv5)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V *)((
              V *)Rv3)[0])[3])[13],0,0);
              else {
                Ra.sl[6]=2678; /* line # 2678 */
                if (16&((UW *)Rv5)[5]) Rv0=((V *)Rv3)[3]==((V *)((V *)Rv3)[0])[3]
                &&((SL *)((V *)Rv3)[3])[10]==0;
                else {
                  Ra.sl[6]=2680; /* line # 2680 */
                  if (32&((UW *)Rv5)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V
                   *)Rv3)[0])[3],8&((UW *)Rv5)[5]||8&Ra.uw[21],1);
                }
              }
            }
          }
        }
        break;
      }
    }
    else {
      Ra.sl[6]=2686; /* line # 2686 */
      Rv6=((V *)Rv2)[2];
      Ra.sl[6]=2687; /* line # 2687 */
      if (((SL *)Rv6)[20]>=F_npa) {
        Ra.sl[6]=2689; /* line # 2689 */
        Rv7=((V *)Rv6)[8];
        Ra.sl[6]=2690; /* line # 2690 */
        if (Rv7!=NULL) {
          Ra.sl[6]=2691; /* line # 2691 */
          if (((UB *)Rv7)[86]==7) {
            Ra.sl[6]=2692; /* line # 2692 */
            Rv7=((V *)Rv7)[3];
          }
        }
        Ra.sl[6]=2695; /* line # 2695 */
        if ((F_npa==2&&((SL *)Rv6)[20]==2)&&(((UB *)Rv6)[104]==1||((UB *)Rv6)[104]
        ==3)) {
          Ra.sl[6]=2697; /* line # 2697 */
          Rv8=Rv1;
          Ra.sl[6]=2699; /* line # 2699 */
          Rv9=((V *)Rv7)[3];
          Ra.sl[6]=2700; /* line # 2700 */
          Rv0=P_comp_type(((V *)Rv8)[3],((V *)Rv7)[5],8&((UW *)Rv7)[44]||((UB *)
          Rv7)[86]!=9,0)&&P_comp_type(((V *)((V *)Rv8)[0])[3],((V *)Rv9)[5],8&((
          UW *)Rv9)[44]||((UB *)Rv9)[86]!=9,0);
          Ra.sl[6]=2704; /* line # 2704 */
          if (Rv0) {
            Ra.sl[6]=2705; /* line # 2705 */
            if (4&((UW *)Rv7)[44]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)((V
             *)Rv8)[0])[3])[13],0,0);
            else {
              Ra.sl[6]=2707; /* line # 2707 */
              if (16&((UW *)Rv7)[44]) Rv0=((V *)Rv8)[3]==((V *)((V *)Rv8)[0])[3]
              &&((SL *)((V *)Rv8)[3])[10]==0;
              else {
                Ra.sl[6]=2709; /* line # 2709 */
                if (32&((UW *)Rv7)[44]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)
                Rv8)[0])[3],8&((UW *)Rv7)[44]||8&((UW *)Rv9)[44],0);
              }
            }
          }
        }
        Ra.sl[6]=2737; /* line # 2737 */
        if (!Rv0) {
          Ra.sl[6]=2739; /* line # 2739 */
          Rv0=1;
          Ra.sl[6]=2740; /* line # 2740 */
          while (Rv0&&Rv7!=NULL){
            Ra.sl[6]=2742; /* line # 2742 */
            Rv10=0;
            Ra.sl[6]=2743; /* line # 2743 */
            Rv11=Rv7;
            Ra.sl[6]=2744; /* line # 2744 */
            if (Rv1!=NULL) {
              Ra.sl[6]=2745; /* line # 2745 */
              Rv12=Rv1;
              Ra.sl[6]=2747; /* line # 2747 */
              if (((UB *)Rv12)[40]==17) {
                Ra.sl[6]=2748; /* line # 2748 */
                if (((V *)Rv11)[7]==NULL&&!(8192&((UW *)Rv11)[42])) {
                  Ra.sl[6]=2749; /* line # 2749 */
                  Rv0=0;
                }
                else {
                  Ra.sl[6]=2752; /* line # 2752 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
              }
              else {
                Ra.sl[6]=2756; /* line # 2756 */
                Rv13=P_comp_type(((V *)Rv12)[3],((V *)Rv11)[5],((UB *)Rv11)[86]!=
9,0);
                Ra.sl[6]=2759; /* line # 2759 */
                if (!Rv13&&((UB *)Rv12)[40]==14) {
                  Ra.sl[6]=2761; /* line # 2761 */
                  Rv14=((V *)Rv11)[5];
                  Ra.sl[6]=2762; /* line # 2762 */
                  switch (((UB *)Rv14)[93]) {
                    case 4:Ra.sl[6]=2770; /* line # 2770 */
                    if (((UB *)((V *)Rv12)[3])[93]==3) {
                      Ra.sl[6]=2772; /* line # 2772 */
                      ((V *)Rv12)[3]=V_typ_std.v[4];
                      Rv13=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[6]=2794; /* line # 2794 */
                    if ((P_comp_type(((V *)Rv14)[14],V_typ_std.v[0],1,0)&&((UB *)(
                    (V *)Rv14)[15])[93]==2)&&((SL *)Rv14)[10]==0) {
                      Ra.sl[6]=2797; /* line # 2797 */
                      if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[10],0,0)) {
                        Ra.sl[6]=2800; /* line # 2800 */
                        if (((UB *)Rv14)[93]==8) {
                          Ra.sl[6]=2801; /* line # 2801 */
                          Rv15=((V *)Rv14)[15];
                          Ra.sl[6]=2802; /* line # 2802 */
                          Rv13=(((SL *)Rv15)[30]-((SL *)Rv15)[29])+1==((SL *)((V
                           *)Rv12)[7])[6];
                        }
                        else {
                          Ra.sl[6]=2805; /* line # 2805 */
                          Rv13=1;
                        }
                      }
                      else {
                        Ra.sl[6]=2807; /* line # 2807 */
                        if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[0],0,0)) {
                          Ra.sl[6]=2809; /* line # 2809 */
                          if (((UB *)Rv14)[93]==9) Rv13=1;
                          else {
                            Ra.sl[6]=2810; /* line # 2810 */
                            Rv13=((SL *)Rv14)[30]==((SL *)Rv14)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=2815; /* line # 2815 */
                if (Rv13) {
                  Ra.sl[6]=2817; /* line # 2817 */
                  if (((V *)Rv11)[5]!=NULL) {
                    Ra.sl[6]=2818; /* line # 2818 */
                    if (((UB *)((V *)Rv11)[5])[93]==9) {
                      Ra.sl[6]=2819; /* line # 2819 */
                      Rv10=((SL *)((V *)Rv11)[5])[24];
                    }
                  }
                  Ra.sl[6]=2820; /* line # 2820 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
                else {
                  Ra.sl[6]=2821; /* line # 2821 */
                  Rv0=0;
                }
                Ra.sl[6]=2824; /* line # 2824 */
                if (Rv0) {
                  Ra.sl[6]=2826; /* line # 2826 */
                  if (((UB *)Rv11)[86]==9) {
                    Ra.sl[6]=2828; /* line # 2828 */
                    if (!(1&((UW *)Rv12)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[6]=2831; /* line # 2831 */
                    if (4&((UW *)Rv12)[10]) {
                      Ra.sl[6]=2833; /* line # 2833 */
                      if (32&((UW *)Rv11)[42]) {
                        Ra.sl[6]=2834; /* line # 2834 */
                        if (!(1&((UW *)Rv12)[10])) Rv0=0;
                      }
                      Ra.sl[6]=2835; /* line # 2835 */
                      if (64&((UW *)Rv11)[42]) {
                        Ra.sl[6]=2836; /* line # 2836 */
                        if (!(2&((UW *)Rv12)[10])) Rv0=0;
                      }
                    }
                    else {
                      Ra.sl[6]=2839; /* line # 2839 */
                      if (64&((UW *)Rv11)[42]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[6]=2844; /* line # 2844 */
              if (((V *)Rv11)[7]==NULL&&!(8192&((UW *)Rv11)[42])) {
                Ra.sl[6]=2845; /* line # 2845 */
                Rv0=0;
              }
              else {
                Ra.sl[6]=2847; /* line # 2847 */
                Rv7=((V *)Rv11)[3];
              }
            }
            Ra.sl[6]=2849; /* line # 2849 */
            if (Rv10>0) while (1){
              Ra.sl[6]=2851; /* line # 2851 */
              Rv7=((V *)Rv7)[3];
              Rv10=Rv10-1;
              if (Rv10==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[6]=2856; /* line # 2856 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  Ra.sl[6]=2858; /* line # 2858 */
  if (!Rv0) {
    Ra.sl[6]=2865; /* line # 2865 */
    P_src_error_s(Rd.s+1108,113,3, F_id,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1112;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2890; /* line # 2890 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  Ra.sl[6]=2891; /* line # 2891 */
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  Ra.sl[6]=2892; /* line # 2892 */
  if (F_p!=NULL) {
    Ra.sl[6]=2893; /* line # 2893 */
    Rv1=F_p;
    Ra.sl[6]=2895; /* line # 2895 */
    if (((UB *)Rv1)[8]) {
      Ra.sl[6]=2897; /* line # 2897 */
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else {
        Ra.sl[6]=2898; /* line # 2898 */
        Rv2=P_exp_val_bin(F_oblst, F_p);
      }
    }
    else {
      Ra.sl[6]=2903; /* line # 2903 */
      Rv3=((V *)Rv1)[2];
      Ra.sl[6]=2905; /* line # 2905 */
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      Ra.sl[6]=2908; /* line # 2908 */
      P_call_setting(&Rv2);
    }
    Ra.sl[6]=2910; /* line # 2910 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=2911; /* line # 2911 */
    Ret=F_oblst;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1125;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2927; /* line # 2927 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Ra.sl[6]=2928; /* line # 2928 */
  Rv0=((V *)F_ip)[10];
  Ra.sl[6]=2929; /* line # 2929 */
  if (F_np<=0) {
    Ra.sl[6]=2931; /* line # 2931 */
    Rv1=F_lgp;
    Ra.sl[6]=2932; /* line # 2932 */
    while (Rv1!=NULL){
      Ra.sl[6]=2933; /* line # 2933 */
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Ra.sl[6]=2935; /* line # 2935 */
  Rv2=NULL;
  Ra.sl[6]=2936; /* line # 2936 */
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2937; /* line # 2937 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    Ra.sl[6]=2941; /* line # 2941 */
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=2942; /* line # 2942 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      Ra.sl[6]=2943; /* line # 2943 */
      if (((V *)Rv3)[2]!=NULL) {
        Ra.sl[6]=2945; /* line # 2945 */
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        Ra.sl[6]=2946; /* line # 2946 */
        P_call_setting(&Rv2);
      }
    }
  }
  Ra.sl[6]=2950; /* line # 2950 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1140;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2959; /* line # 2959 */
  Ri.ub[0]=F_op;
  Ra.sl[6]=2961; /* line # 2961 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1151;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2976; /* line # 2976 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else {
    Ra.sl[6]=2977; /* line # 2977 */
    Rv0=((V *)V_ope_table.v[28])[3];
  }
  Ra.sl[6]=2978; /* line # 2978 */
  Rv1=((V *)F_prm)[0];
  Ra.sl[6]=2979; /* line # 2979 */
  Rv2=((UW *)F_prm)[10];
  Ra.sl[6]=2980; /* line # 2980 */
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=2981; /* line # 2981 */
  if (F_bovr) {
    Ra.sl[6]=2983; /* line # 2983 */
    ((UW *)F_prm)[10]=Rv2|3;
    Ra.sl[6]=2984; /* line # 2984 */
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=2986; /* line # 2986 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  Ra.sl[6]=2987; /* line # 2987 */
  if (F_bovr) {
    Ra.sl[6]=2989; /* line # 2989 */
    ((UW *)F_prm)[10]=Rv2;
    Ra.sl[6]=2990; /* line # 2990 */
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=2992; /* line # 2992 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
