/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5-3 OF 30-JUN-2024 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 152 ) = {{
 13,  13, 105, 110, 104, 101, 114, 105, 116,  95, 114, 101,  99, 117, 114,  64,
 64,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83,
111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97,
115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,
 51,  47, 112,  99, 109, 112,  95, 101, 110, 118, 105, 110, 104,  46, 112,  97,
115,  11,  11, 105, 110, 104, 101, 114, 105, 116,  95, 101, 110, 118,   4,   4,
 46, 112,  97, 115,   4,   4,  69,  78,  72,  69,  17,  17, 112,  97, 115,  95,
114, 101,  97, 100,  95, 101, 110, 118,  95, 102, 105, 108, 101,  16,  16,  97,
100, 100,  95, 105, 110, 104, 101, 114, 105, 116,  95, 102, 105, 108, 101,   5,
  5,  46, 112, 101, 110, 118,   0,   0
}};

/* Declaration of external variables. */
extern C V_sy_ch;
extern C V_sy_cmin;
extern V V_src_control;
extern SL V_src_openerr;
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern V V_attr_list;
extern Blk(V_sy_ident, 32 );
extern UB V_error_result;
extern UB V_emergency_stop;
extern UB V_lastsymb;
extern SL V_sy_ival;
extern G V_sy_rval;
extern V V_env_first;


/* Function/procedure prototypes. */
void P_src_close(V *F_p, UB F_bfree);
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
V P_level_search(V F_fp);
void P_set_env_file_spc(V F_pcur);
void P_compile_set_title();
V P_set_file_extention(V F_pf, V F_ex);
void P_set_srcfilespc(SL F_icd);
void P_insymbol();
void PAS_ENV_INH_inherit_env(V F_env);


/* Procedure/Function : " env_block "  */
void PAS_ENV_INH_env_block(){

  /* Code of procedure/function */
}


/* Procedure/Function : " inherit_recur "  */
void PAS_ENV_INH_inherit_recur(V F_env){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  C Rv0;
  C Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=114; /* line # 114 */
  P_set_env_file_spc(F_env);
  Ra.sl[6]=115; /* line # 115 */
  Rv0=V_sy_ch;
  Ra.sl[6]=116; /* line # 116 */
  Rv1=V_sy_cmin;
  Ra.sl[6]=117; /* line # 117 */
  PAS_ENV_INH_inherit_env(F_env);
  Ra.sl[6]=118; /* line # 118 */
  V_sy_ch=Rv0;
  Ra.sl[6]=119; /* line # 119 */
  V_sy_cmin=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " inherit_env "  */
void PAS_ENV_INH_inherit_env(V F_env){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+81;
  Ra.v[35]=Rd.s+15;
  Ra.sl[72]=137; /* line # 137 */
  Rv0=0;
  Ra.sl[72]=138; /* line # 138 */
  Rv1=NULL;
  Ra.sl[72]=139; /* line # 139 */
  Rv2=NULL;
  Ra.sl[72]=140; /* line # 140 */
  Rv3=V_src_control;
  Ra.sl[72]=141; /* line # 141 */
  Rv4=NULL;
  Ra.sl[72]=142; /* line # 142 */
  Rv5=F_env;
  Ra.sl[72]=144; /* line # 144 */
  PAS__STR_TO_STR(Ra.s,((V *)Rv5)[1]);
  Ra.sl[72]=145; /* line # 145 */
  Rv6=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  Ra.sl[72]=146; /* line # 146 */
  if (Rv6!=0) {
    Ra.sl[72]=147; /* line # 147 */
    if (Ra.c[Rv6+1]==46) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+292,Ra.s,Rd.
    s+94));
  }
  Ra.sl[72]=150; /* line # 150 */
  Rv4=P_src_file_open(Ra.s,0,NULL);
  Ra.sl[72]=151; /* line # 151 */
  if (V_src_openerr==0) {
    Ra.sl[72]=153; /* line # 153 */
    Rv7=Rv4;
    Ra.sl[72]=155; /* line # 155 */
    ((V *)Rv7)[1]=V_src_control;
    Ra.sl[72]=156; /* line # 156 */
    ((SL *)Rv7)[7]=((SL *)V_src_control)[7]+1;
    Ra.sl[72]=157; /* line # 157 */
    ((SL *)Rv7)[8]=((SL *)V_src_control)[8];
    Ra.sl[72]=158; /* line # 158 */
    ((SL *)Rv7)[6]=((SL *)V_src_control)[6];
    Ra.sl[72]=159; /* line # 159 */
    ((UL *)Rv7)[62]=((UL *)Rv7)[62]&102;
    Ra.sl[72]=162; /* line # 162 */
    P_compile_set_title();
    Ra.sl[72]=163; /* line # 163 */
    P_set_srcfilespc(1);
    Ra.sl[72]=164; /* line # 164 */
    V_sy_ch=32;
    Ra.sl[72]=165; /* line # 165 */
    V_sy_sym.ub[0]=104;
    Ra.sl[72]=166; /* line # 166 */
    V_src_control=Rv4;
    Ra.sl[72]=167; /* line # 167 */
    P_insymbol();
    Ra.sl[72]=169; /* line # 169 */
    Ra.sl[72]=171; /* line # 171 */
    if (V_sy_sym.ub[0]==73) {
      Ra.sl[72]=173; /* line # 173 */
      V_sy_sym.ub[0]=17;
      while (1){
        Ra.sl[72]=175; /* line # 175 */
        P_insymbol();
        Ra.sl[72]=176; /* line # 176 */
        if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
          Ra.sl[72]=177; /* line # 177 */
          PAS_ENV_INH_inherit_recur(F_env);
        }
        else {
          Ra.sl[72]=179; /* line # 179 */
          P_src_error(Rd.s+102,58,3);
        }
        Ra.sl[72]=180; /* line # 180 */
        P_insymbol();
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[72]=182; /* line # 182 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[72]=183; /* line # 183 */
        P_src_error(Rd.s+102,21,2);
      }
    }
    else {
      Ra.sl[72]=185; /* line # 185 */
      if (V_sy_sym.ub[0]==15) {
        Ra.sl[72]=188; /* line # 188 */
        V_sy_sym.ub[0]=17;
        while (1){
          Ra.sl[72]=190; /* line # 190 */
          P_insymbol();
          Ra.sl[72]=191; /* line # 191 */
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[72]=193; /* line # 193 */
            Rv8=P_level_search(V_attr_list);
            Ra.sl[72]=194; /* line # 194 */
            if (Rv8!=NULL) while (1){
              Ra.sl[72]=196; /* line # 196 */
              P_insymbol();
              Ra.sl[72]=197; /* line # 197 */
              switch (((UB *)Rv8)[54]) {
                case 18:Ra.sl[72]=200; /* line # 200 */
                if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+102,22,2);
                Ra.sl[72]=201; /* line # 201 */
                V_sy_sym.ub[0]=17;
                while (1){
                  Ra.sl[72]=203; /* line # 203 */
                  P_insymbol();
                  Ra.sl[72]=204; /* line # 204 */
                  if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                    Ra.sl[72]=205; /* line # 205 */
                    PAS_ENV_INH_inherit_recur(F_env);
                  }
                  else {
                    Ra.sl[72]=207; /* line # 207 */
                    P_src_error(Rd.s+102,58,3);
                  }
                  Ra.sl[72]=208; /* line # 208 */
                  P_insymbol();
                  if (V_sy_sym.ub[0]!=17)  break;
                }
                Ra.sl[72]=210; /* line # 210 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else {
                  Ra.sl[72]=211; /* line # 211 */
                  P_src_error(Rd.s+102,23,2);
                }
                break;
                case 19:Ra.sl[72]=216; /* line # 216 */
                if (V_sy_sym.ub[0]==13) P_insymbol();
                else {
                  Ra.sl[72]=217; /* line # 217 */
                  P_src_error(Rd.s+102,22,2);
                }
                Ra.sl[72]=218; /* line # 218 */
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[72]=220; /* line # 220 */
                  Rv0=1;
                  Ra.sl[72]=221; /* line # 221 */
                  P_insymbol();
                }
                Ra.sl[72]=223; /* line # 223 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else {
                  Ra.sl[72]=224; /* line # 224 */
                  P_src_error(Rd.s+102,23,2);
                }
                break;
                default:Ra.sl[72]=227; /* line # 227 */
                P_src_error_s(Rd.s+102,3,1, V_sy_ident.s,NULL);
                break;
              }
              if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==17)||V_sy_sym.ub[0]==16)  break;
            }
          }
          else {
            Ra.sl[72]=231; /* line # 231 */
            P_src_error(Rd.s+102,2,3);
          }
          if (V_sy_sym.ub[0]!=17)  break;
        }
        Ra.sl[72]=233; /* line # 233 */
        if (V_sy_sym.ub[0]==16) P_insymbol();
        else {
          Ra.sl[72]=234; /* line # 234 */
          P_src_error(Rd.s+102,26,2);
        }
      }
    }
    Ra.sl[72]=237; /* line # 237 */
    if (V_sy_sym.ub[0]==74) {
      Ra.sl[72]=239; /* line # 239 */
      P_insymbol();
      Ra.sl[72]=240; /* line # 240 */
      if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+102,93,4);
    }
    else {
      Ra.sl[72]=242; /* line # 242 */
      P_src_error(Rd.s+102,999,4);
    }
    Ra.sl[72]=245; /* line # 245 */
    if (V_error_result>1) V_emergency_stop=1;
    Ra.sl[72]=247; /* line # 247 */
    if (!V_emergency_stop) PAS_ENV_INH_env_block();
    Ra.sl[72]=249; /* line # 249 */
    if (V_src_control!=Rv4) {
      Ra.sl[72]=251; /* line # 251 */
      P_src_error(Rd.s+102,5,4);
      Ra.sl[72]=252; /* line # 252 */
      V_emergency_stop=1;
    }
    else {
      Ra.sl[72]=256; /* line # 256 */
      V_src_control=Rv3;
      Ra.sl[72]=257; /* line # 257 */
      P_src_close(&Rv4,1);
      Ra.sl[72]=258; /* line # 258 */
      P_set_srcfilespc(-1);
      Ra.sl[72]=259; /* line # 259 */
      if (V_error_result>1) V_emergency_stop=1;
    }
  }
  else {
    Ra.sl[72]=263; /* line # 263 */
    P_src_error(Rd.s+102,4,4);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " pas_read_env_file "  */
void P_pas_read_env_file(){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  C Rv0;
  C Rv1;
  UB Rv2;
  SL Rv3;
  G Rv4;
  V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+106;
  Ra.v[35]=Rd.s+15;
  Ra.sl[72]=281; /* line # 281 */
  Rv0=V_sy_ch;
  Ra.sl[72]=282; /* line # 282 */
  Rv1=V_sy_cmin;
  Ra.sl[72]=283; /* line # 283 */
  Rv2=V_lastsymb;
  Ra.sl[72]=284; /* line # 284 */
  memcpy(Ra.s+292,V_sy_sym.s,2);
  Ra.sl[72]=285; /* line # 285 */
  PAS__STR_TO_STR(Ra.s,V_sy_string.s);
  Ra.sl[72]=286; /* line # 286 */
  Rv3=V_sy_ival;
  Ra.sl[72]=287; /* line # 287 */
  Rv4=V_sy_rval;
  Ra.sl[72]=290; /* line # 290 */
  Rv5=V_env_first;
  Ra.sl[72]=291; /* line # 291 */
  while (Rv5!=NULL){
    Ra.sl[72]=292; /* line # 292 */
    Ra.sl[72]=294; /* line # 294 */
    PAS_ENV_INH_inherit_env(Rv5);
    Ra.sl[72]=295; /* line # 295 */
    Rv5=((V *)Rv5)[0];
  }
  Ra.sl[72]=299; /* line # 299 */
  V_sy_ch=Rv0;
  Ra.sl[72]=300; /* line # 300 */
  V_sy_cmin=Rv1;
  Ra.sl[72]=301; /* line # 301 */
  V_lastsymb=Rv2;
  Ra.sl[72]=302; /* line # 302 */
  memcpy(V_sy_sym.s,Ra.s+292,2);
  Ra.sl[72]=303; /* line # 303 */
  V_sy_ival=Rv3;
  Ra.sl[72]=304; /* line # 304 */
  V_sy_rval=Rv4;
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " add_inherit_file "  */
void P_add_inherit_file(V F_fenv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+125;
  Ra.v[2]=Rd.s+15;
  Ra.sl[6]=316; /* line # 316 */
  Rv0=P_set_file_extention(F_fenv,Rd.s+143);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_pas_env_init "  */
void P_create_pas_env_init(){

  /* Code of procedure/function */
}


/* Procedure/Function : " pas_write_env_file "  */
void P_pas_write_env_file(){

  /* Code of procedure/function */
}
