{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*     ---   COMMON   BASIC  PASCAL  RUN  ENVIRONMENT  MODULE    ---     *
*                                                                       *
*               ---  Version  3.1-B5 -- 31/07/2019 ---                  *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////



}


{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                        ----

                       nothing

                        ----

}

module PAS_BASIC_DEF;


%include 'passrc:pcmp_env';                            { *** Include the CPAS definitions }


type
  arg_desc = record {* Define the Operator Argument prototype }
    aty:     typ_forms; { Typ_form of the unique builtin type }
    acv:    oparg_conv; { Related conversion to aplied or not }
    apr:   oparg_flags  { related managment Flags }
  end;

  arglist = record { * Define the Operator arguments list prototype }
    nar:                          byte; { Number of arguments }
    tab:       array[1..2] of arg_desc  { The 1 or to argument(s) }
  end;
   

{ Identifier code for the operator argument list: each following symbol specify a type
  and the symbol is build to merge "l", n a number, and the successive argument types
separed by a "_" character.
  The result is the first just after the nu
    in =  integer, fl =  single, db =  double, li = literal,
    ch =     char, ws =    wset, wp = pointer, fe =  fentry,
    en =    ennum, __ =    void.
}

type
  argli_enum = ( { * Define the argument list attached symbols }
     
        AL_lin, { list : not. }
        AL_chn, { list : . }
        AL_inn, { list : ineg,ODD(),ABS(),SQR(). }
        AL_fln, { list : fneg,ROUND(),TRUNC(),ABS(),SQR(),SQRT(),<circ_fnc>,EXP(),LN(),<hyp_fnc>. }
        AL_dbn, { list : gneg,ROUND(),TRUNC(),ABS(),SQR(),SQRT(),<circ_fnc>,EXP(),LN(),<hyp_fnc>. }
        AL_wsn, { list : bcom. }
        AL_wen, { list : ORD(),CHR(). }
        ALrwen, { list : SUCC(),PRED(). }
        AL_inf, { list : SQRT(),<circ_fnc>,EXP(),LN(),<hyp_fnc>. }

    { Binary list }
    AL_chn_chn, { list : cmp. }
    AL_lin_lin, { list : cmp,and,or,xor. }

    AL_inn_inn, { list : iipow,imul,iadd,isub,idiv,mod,rem,cmp. }
    AL_fln_inn, { list : fipow. }
    AL_fln_inf, { list : fmul,fdiv,fadd,fsub,fcmp. }
    AL_inf_fln, { list : fpow,fmul,fdiv,fadd,fsub,fcmp. }
    AL_fln_fln, { list : fpow,fmul,fdiv,fadd,fsub,fcmp. }
    AL_inf_inf, { list : fdiv. }

    AL_wln_wln, { list : cmp. }
    AL_enn_enn, { list : eq,ne. }
    AL_ptn_ptn, { list : eq,ne. }
    AL_fen_fen, { list : eq,ne. }

    ALwptn_ptn, { list : i:= . }
    ALwfen_fen, { list : i:= . }

    ALwenn_enn, { list : i:= . }
    ALwfln_inf, { list : f:= . }
    ALwinf_fln, { list : f:= . }
    ALwfln_fln, { list : f:= . }

    AL_dbn_inn, { list : gpow. }
    AL_dbn_ing, { list : gmul,gdiv,gadd,gsub,gcmp. }
    AL_ing_dbn, { list : gpow,gmul,gdiv,gadd,gsub,gcmp. }
    AL_dbn_dbn, { list : gpow,gmul,gdiv,gadd,gsub,gcmp. }
    AL_flg_dbn, { list : gpow,gmul,gdiv,gadd,gsub,gcmp. }
    AL_dbn_flg, { list : gpow,gmul,gdiv,gadd,gsub,gcmp. }

    ALwdbn_ing, { list : g:= . }
    ALwdbn_flg, { list : g:= . }
    ALwinn_dbi, { list : g:= . }
    ALwfln_dbf, { list : g:= . }
    ALwdbn_dbn, { list : g:= . }

    AL_wsn_wsn, { list : band,bis,bic,set_cmp. }
    AL_enn_wsn, { list : in. }
    ALcwsn_wsn, { list : lt, le, ge, gt, eq, ne of set }
    AL_win_win, { list : wild eq, ne == _eq,_ne . }
    ALwwsn_wsn, { list : set := }
    ALwwin_win  { list : Wild := . }
  );

  list_arg_list = array[argli_enum] of arglist;

  ope_entry = record
    ope:       operator;
    pcd:     pcod_codes;
    rty:      typ_forms;
    lar:     argli_enum
  end;
    

const
  null_arg = arg_desc[form_null, cv_nop, []];
  
  arg_lst = list_arg_list[
    [ 1, [ [    form_lit, cv_nop,      []], null_arg ]],        { AL_lin : not }
    [ 1, [ [   form_char, cv_nop,      []], null_arg ]],        { AL_chn : }
    [ 1, [ [    form_int, cv_nop,      []], null_arg ]],        { AL_inn : neg }
    [ 1, [ [ form_single, cv_nop,      []], null_arg ]],        { AL_fln : neg }
    [ 1, [ [ form_double, cv_nop,      []], null_arg ]],        { AL_dbn : neg }
    [ 1, [ [   form_wset, cv_nop, [a_rty]], null_arg ]],        { AL_wsn : bcom }
    [ 1, [ [  form_ennum, cv_nop,      []], null_arg ]],        { AL_wen : ORD() }
    [ 1, [ [  form_ennum, cv_nop, [a_rty]], null_arg ]],        { ALrwen : SUCC(), PRED() }
    [ 1, [ [    form_int, cv_cif,      []], null_arg ]],        { AL_inf : <circ_fnc>,EXP(),LN(),<hyp_fnc>. }

    [ 2, [ [   form_char, cv_nop,      []], [   form_char, cv_nop,      []] ]], { AL_chn_chn }
    [ 2, [ [    form_lit, cv_nop,      []], [    form_lit, cv_nop,      []] ]], { AL_lin_lin }
    
    [ 2, [ [    form_int, cv_nop,      []], [    form_int, cv_nop,      []] ]], { AL_inn_inn }
    [ 2, [ [ form_single, cv_nop,      []], [    form_int, cv_nop,      []] ]], { AL_fln_inn }
    [ 2, [ [ form_single, cv_nop,      []], [    form_int, cv_cif,      []] ]], { AL_fln_inf }
    [ 2, [ [    form_int, cv_cif,      []], [ form_single, cv_nop,      []] ]], { AL_inf_fln }
    [ 2, [ [ form_single, cv_nop,      []], [ form_single, cv_nop,      []] ]], { AL_fln_fln }
    [ 2, [ [    form_int, cv_cif,      []], [    form_int, cv_cif,      []] ]], { AL_inf_inf }

    [ 2, [ [   form_wlit, cv_nop,       [a_ety]],  [   form_wlit, cv_nop,      []] ]],  { AL_wln_wln }
    [ 2, [ [  form_ennum, cv_nop,       [a_ety]],  [  form_ennum, cv_nop,      []] ]],  { AL_enn_enn }
    [ 2, [ [form_pointer, cv_nop, [a_ety,a_nil]],  [form_pointer, cv_nop, [a_nil]] ]],  { AL_ptn_ptn }
    [ 2, [ [ form_fentry, cv_nop, [a_ety,a_nil]],  [ form_fentry, cv_nop, [a_nil]] ]],  { AL_fen_fen }

    [ 2, [ [form_pointer,cv_nop,[a_ety,a_out]], [form_pointer,cv_nop,[a_dir,a_nil]] ]], { ALwptn_ptn }
    [ 2, [ [ form_fentry,cv_nop,[a_ety,a_out]], [ form_fentry,cv_nop,[a_dir,a_nil]] ]], { ALwfen_fen }

    [ 2, [ [  form_ennum, cv_nop, [a_ety,a_out]], [ form_ennum, cv_nop, []] ]], { ALwenn_enn }
    [ 2, [ [ form_single, cv_nop, [a_out]], [    form_int, cv_cif,      []] ]], { ALwfln_inf }
    [ 2, [ [    form_int, cv_nop, [a_out]], [ form_single, cv_cfi,      []] ]], { ALwinf_fln }
    [ 2, [ [ form_single, cv_nop, [a_out]], [ form_single, cv_nop,      []] ]], { ALwfln_fln }

    [ 2, [ [ form_double, cv_nop,      []], [    form_int, cv_nop,      []] ]], { AL_dbn_inn }
    [ 2, [ [ form_double, cv_nop,      []], [    form_int, cv_cig,      []] ]], { AL_dbn_ing }
    [ 2, [ [    form_int, cv_cig,      []], [ form_double, cv_nop,      []] ]], { AL_ing_dbn }
    [ 2, [ [ form_double, cv_nop,      []], [ form_double, cv_nop,      []] ]], { AL_dbn_dbn }
    [ 2, [ [ form_single, cv_cfg,      []], [ form_double, cv_nop,      []] ]], { AL_flg_dbn }
    [ 2, [ [ form_double, cv_nop,      []], [ form_single, cv_cfg,      []] ]], { AL_dbn_flg }

    [ 2, [ [ form_double, cv_nop, [a_out]], [    form_int, cv_cig,      []] ]], { ALwdbn_ing }
    [ 2, [ [ form_double, cv_nop, [a_out]], [ form_single, cv_cfg,      []] ]], { ALwdbn_flg }
    [ 2, [ [    form_int, cv_nop, [a_out]], [ form_double, cv_cgi,      []] ]], { ALwinn_dbi }
    [ 2, [ [ form_single, cv_nop, [a_out]], [ form_double, cv_cgf,      []] ]], { ALwfln_dbf }
    [ 2, [ [ form_double, cv_nop, [a_out]], [ form_double, cv_nop,      []] ]], { ALwdbn_dbn }

    [ 2, [ [   form_wset, cv_nop, [a_ety,a_rty]],  [   form_wset, cv_nop,       []] ]], { AL_wsn_wsn }
    [ 2, [ [  form_ennum, cv_nop,       [a_ind]],  [   form_wset, cv_nop,       []] ]], { AL_enm_wsn }
    [ 2, [ [   form_wset, cv_nop,       [a_ety]],  [   form_wset, cv_nop,       []] ]], { ALcwsn_wsn }
    [ 2, [ [   form_wild, cv_nop, [a_sty,a_dir]],  [   form_wild, cv_nop,       []] ]], { AL_win_win }
    
    [ 2, [ [   form_wset, cv_nop, [a_out,a_ety,a_dir]], [   form_wset, cv_nop,  [a_dir]] ]], { ALwwsn_wsn }    
    [ 2, [ [   form_wild, cv_nop, [a_out,a_sty,a_dir]], [   form_wild, cv_nop,  [a_dir]] ]]  { ALwwin_win }
  ];

var
  ope_arg_tab: array[argli_enum] of oparg_ptr;  { Table of all argument list of all standard operators }



procedure GEN_OPE_ARG_LIST;
var
  ptb: oparg_ptr;

begin { GEN_OPE_ARG_LIST }
  for argl := argli_enum"first to argli_enum"last do
  with arg_lst[argl] do
  begin
    NEW( ptb, nar );                    { Allocate the arguments list }
    for ia := 1 to nar do               { For each argument ... }
      with ptb^[ia], tab[ia] do
      begin
        oar_typ :=  typ_std[aty];       { ... Set the argument type pointer, ... }
        oar_cve :=           acv;       { ... the related conversion (or cv_nop) ... }
        oar_prp :=           apr        { ... and associated properties. }
      end;
    ope_arg_tab[argl] := ptb            { Put the argument list pointer in the argument list table. }
  end
end GEN_OPE_ARG_LIST;



procedure IDECTE_CREATE_NAME(     len: integer;
                              var nam: [readonly]
                                  array[$sz: integer] of char );
begin
  sy_ident.l := len;
  for i := 1 to len do
    sy_ident.s[i] := nam[i]
end IDECTE_CREATE_NAME;



procedure CREATE_STD_CONVERSION;
const
  nent =  16;

type
  cv_entry = record
    finp,               { Parameter type }
    fres:  typ_forms;   { Result type }
    codp: pcod_codes;   { Pcode operator }
    cvcd: oparg_conv    { Result index }
  end;

  std_cv_tbty = array[1..nent] of cv_entry;

const
  std_cv_tab = std_cv_tbty[
    {       f1           fr           cop    cvcd  }
    {  1..10 }
    [   form_int,   form_single,  pcod_cvif, cv_cif  ], { integer -> single }
    [form_single,      form_int,  pcod_cvfi, cv_cfi  ], { single -> integer }
    [   form_lit,      form_int,  pcod_noop, cv_nop  ], { boolean  -> integer }
    [  form_wlit,      form_int,  pcod_noop, cv_nop  ], { wlit -> integer }
    [   form_int,     form_char,  pcod_noop, cv_nop  ], { integer -> char }
    [  form_char,      form_int,  pcod_noop, cv_nop  ], { char -> integer }
    [   form_lit,      form_int,  pcod_noop, cv_nop  ], { boolean -> integer }
    [  form_wset,      form_int,  pcod_noop, cv_nop  ], { set -> integer }
    [   form_int,     form_wset,  pcod_noop, cv_nop  ], { integer -> set }
    [   form_nil,      form_int,  pcod_noop, cv_nop  ], { pointer -> integer }
    { 11..16 }
    [   form_int,   form_double,  pcod_cvig, cv_cig  ], { integer -> double }
    [form_double,      form_int,  pcod_cvgi, cv_cgi  ], { double -> integer }
    [form_double,   form_single,  pcod_cvgf, cv_cgf  ], { double -> single }
    [form_double,   form_double,  pcod_noop, cv_nop  ], { double -> double }
    [form_single,   form_double,  pcod_cvfg, cv_cfg  ], { single -> double }
    [form_single,   form_single,  pcod_noop, cv_nop  ]  { single -> single }
  ];

var
  tp: typ_ptr;
  pg: gen_ptr;

begin { CREATE_STD_CONVERSION }
  for ii := 1 to nent do
    with std_cv_tab[ii] do
    begin
      tp := typ_std[fres];                                              { Get the result type record definition }
      pg := NEW_OPER( codp, tp, typ_std[finp], cv_nop, [] );            { Create the operator of convertion ... }
      with tp^.typ_ide^ do
      begin                                                             { ... and put it in the generic list of ... }
        if ide_gfirst = nil then ide_gfirst := pg                       { ... the result type. }
                            else ide_glast^.gen_link := pg;
        ide_glast := pg;
      end;
      if codp <> pcod_noop then oparg_cvtab[cvcd] := pg                 { keep the true processor conversion in ... }
                                                                        { ... the standard conversion table. }
    end;
  oparg_cvtab[cv_nop] := nil
end CREATE_STD_CONVERSION;



procedure CREATE_STD_OPERATOR;
const
  nent = 152;

type
  std_ope_tbty = array[1..nent] of ope_entry;

const
  { *** Warning: This table is sorted from the specific to general *** }
  std_ope_tab = std_ope_tbty[
    {   ope         pcod          res_type    Arg. List  }
    { 001..001 }
    [  not_op,    pcod_not,       form_lit,       AL_lin ],
    { 002..005 }
    [  pow_op,   pcod_ipow,       form_int,   AL_inn_inn ],
    [  pow_op,   pcod_fipw,    form_single,   AL_fln_inn ],
    [  pow_op,   pcod_fpow,    form_single,   AL_inf_fln ],
    [  pow_op,   pcod_fpow,    form_single,   AL_fln_fln ],
    { 006..009 }
    [  mul_op,   pcod_imul,       form_int,   AL_inn_inn ],
    [  mul_op,   pcod_fmul,    form_single,   AL_fln_inf ],
    [  mul_op,   pcod_fmul,    form_single,   AL_inf_fln ],
    [  mul_op,   pcod_fmul,    form_single,   AL_fln_fln ],
    { 010..013 }
    [  div_op,   pcod_fdiv,    form_single,   AL_inf_inf ],
    [  div_op,   pcod_fdiv,    form_single,   AL_fln_inf ],
    [  div_op,   pcod_fdiv,    form_single,   AL_inf_fln ],
    [  div_op,   pcod_fdiv,    form_single,   AL_fln_fln ],
    { 014..016 }
    [ idiv_op,   pcod_idiv,       form_int,   AL_inn_inn ],
    [ imod_op,   pcod_imod,       form_int,   AL_inn_inn ],
    [ irem_op,   pcod_irem,       form_int,   AL_inn_inn ],
    { 017..020 }
    [  add_op,   pcod_iadd,       form_int,   AL_inn_inn ],
    [  add_op,   pcod_fadd,    form_single,   AL_fln_inf ],
    [  add_op,   pcod_fadd,    form_single,   AL_inf_fln ],
    [  add_op,   pcod_fadd,    form_single,   AL_fln_fln ],
    { 021..026 }
    [  sub_op,   pcod_ineg,       form_int,       AL_inn ],
    [  sub_op,   pcod_fneg,    form_single,       AL_fln ],
    [  sub_op,   pcod_isub,       form_int,   AL_inn_inn ],
    [  sub_op,   pcod_fsub,    form_single,   AL_fln_inf ],
    [  sub_op,   pcod_fsub,    form_single,   AL_inf_fln ],
    [  sub_op,   pcod_fsub,    form_single,   AL_fln_fln ],
    { 027..033 }
    [   lt_op,    pcod_ult,       form_lit,   AL_chn_chn ],
    [   lt_op,    pcod_ult,       form_lit,   AL_lin_lin ],
    [   lt_op,    pcod_ilt,       form_lit,   AL_inn_inn ],
    [   lt_op,    pcod_flt,       form_lit,   AL_fln_inf ],
    [   lt_op,    pcod_flt,       form_lit,   AL_inf_fln ],
    [   lt_op,    pcod_flt,       form_lit,   AL_fln_fln ],
    [   lt_op,    pcod_ult,       form_lit,   AL_wln_wln ],
    { 034..040 }
    [   le_op,    pcod_ule,       form_lit,   AL_chn_chn ],
    [   le_op,    pcod_ule,       form_lit,   AL_lin_lin ],
    [   le_op,    pcod_ile,       form_lit,   AL_inn_inn ],
    [   le_op,    pcod_fle,       form_lit,   AL_fln_inf ],
    [   le_op,    pcod_fle,       form_lit,   AL_inf_fln ],
    [   le_op,    pcod_fle,       form_lit,   AL_fln_fln ],
    [   le_op,    pcod_ule,       form_lit,   AL_wln_wln ],
    { 041..047 }
    [   ge_op,    pcod_uge,       form_lit,   AL_chn_chn ],
    [   ge_op,    pcod_uge,       form_lit,   AL_lin_lin ],
    [   ge_op,    pcod_ige,       form_lit,   AL_inn_inn ],
    [   ge_op,    pcod_fge,       form_lit,   AL_fln_inf ],
    [   ge_op,    pcod_fge,       form_lit,   AL_inf_fln ],
    [   ge_op,    pcod_fge,       form_lit,   AL_fln_fln ],
    [   ge_op,    pcod_uge,       form_lit,   AL_wln_wln ],
    { 048..054 }
    [   gt_op,    pcod_ugt,       form_lit,   AL_chn_chn ],
    [   gt_op,    pcod_ugt,       form_lit,   AL_lin_lin ],
    [   gt_op,    pcod_igt,       form_lit,   AL_inn_inn ],
    [   gt_op,    pcod_fgt,       form_lit,   AL_fln_inf ],
    [   gt_op,    pcod_fgt,       form_lit,   AL_inf_fln ],
    [   gt_op,    pcod_fgt,       form_lit,   AL_fln_fln ],
    [   gt_op,    pcod_ugt,       form_lit,   AL_wln_wln ],
    { 055..060 }
    [   ne_op,     pcod_ne,       form_lit,   AL_enn_enn ],
    [   ne_op,    pcod_fne,       form_lit,   AL_fln_inf ],
    [   ne_op,    pcod_fne,       form_lit,   AL_inf_fln ],
    [   ne_op,    pcod_fne,       form_lit,   AL_fln_fln ],
    [   ne_op,     pcod_ne,       form_lit,   AL_ptn_ptn ],
    [   ne_op,     pcod_ne,       form_lit,   AL_fen_fen ],
    { 061..066 }
    [   eq_op,     pcod_eq,       form_lit,   AL_enn_enn ],
    [   eq_op,    pcod_feq,       form_lit,   AL_fln_inf ],
    [   eq_op,    pcod_feq,       form_lit,   AL_inf_fln ],
    [   eq_op,    pcod_feq,       form_lit,   AL_fln_fln ],
    [   eq_op,     pcod_eq,       form_lit,   AL_ptn_ptn ],
    [   eq_op,     pcod_eq,       form_lit,   AL_fen_fen ],
    { 067..069 }
    [  and_op,    pcod_and,       form_lit,   AL_lin_lin ],
    [   or_op,     pcod_or,       form_lit,   AL_lin_lin ],
    [  xor_op,    pcod_xor,       form_lit,   AL_lin_lin ],
    { 070..071  := for pointer }
    [  ass_op, pcod_istore,      form_null,   ALwptn_ptn ],
    [  ass_op, pcod_istore,      form_null,   ALwfen_fen ],
    { 072..075  := for char, boolean, literal, integer, single }
    [  ass_op, pcod_istore,      form_null,   ALwenn_enn ],
    [  ass_op, pcod_fstore,      form_null,   ALwfln_inf ],
    [  ass_op, pcod_istore,      form_null,   ALwinf_fln ],
    [  ass_op, pcod_fstore,      form_null,   ALwfln_fln ],
    { *** Definitions for double use *** }
    { 076..080   ** for double }
    [  pow_op,   pcod_gipw,    form_double,   AL_dbn_inn ],
    [  pow_op,   pcod_gpow,    form_double,   AL_ing_dbn ],
    [  pow_op,   pcod_gpow,    form_double,   AL_dbn_dbn ],
    [  pow_op,   pcod_gpow,    form_double,   AL_flg_dbn ],
    [  pow_op,   pcod_gpow,    form_double,   AL_dbn_flg ],
    { 081..085   * for double }
    [  mul_op,   pcod_gmul,    form_double,   AL_dbn_ing ],
    [  mul_op,   pcod_gmul,    form_double,   AL_ing_dbn ],
    [  mul_op,   pcod_gmul,    form_double,   AL_dbn_dbn ],
    [  mul_op,   pcod_gmul,    form_double,   AL_flg_dbn ],
    [  mul_op,   pcod_gmul,    form_double,   AL_dbn_flg ],
    { 086..090   / for double }
    [  div_op,   pcod_gdiv,    form_double,   AL_dbn_ing ],
    [  div_op,   pcod_gdiv,    form_double,   AL_ing_dbn ],
    [  div_op,   pcod_gdiv,    form_double,   AL_dbn_dbn ],
    [  div_op,   pcod_gdiv,    form_double,   AL_flg_dbn ],
    [  div_op,   pcod_gdiv,    form_double,   AL_dbn_flg ],
    { 091..095   + for double }
    [  add_op,   pcod_gadd,    form_double,   AL_dbn_ing ],
    [  add_op,   pcod_gadd,    form_double,   AL_ing_dbn ],
    [  add_op,   pcod_gadd,    form_double,   AL_dbn_dbn ],
    [  add_op,   pcod_gadd,    form_double,   AL_flg_dbn ],
    [  add_op,   pcod_gadd,    form_double,   AL_dbn_flg ],
    { 096..101   - for double }
    [  sub_op,   pcod_gneg,    form_double,       AL_dbn ],
    [  sub_op,   pcod_gsub,    form_double,   AL_dbn_ing ],
    [  sub_op,   pcod_gsub,    form_double,   AL_ing_dbn ],
    [  sub_op,   pcod_gsub,    form_double,   AL_dbn_dbn ],
    [  sub_op,   pcod_gsub,    form_double,   AL_flg_dbn ],
    [  sub_op,   pcod_gsub,    form_double,   AL_dbn_flg ],
    { 102..106  < with double }
    [   lt_op,    pcod_glt,       form_lit,   AL_dbn_ing ],
    [   lt_op,    pcod_glt,       form_lit,   AL_ing_dbn ],
    [   lt_op,    pcod_glt,       form_lit,   AL_flg_dbn ],
    [   lt_op,    pcod_glt,       form_lit,   AL_dbn_flg ],
    [   lt_op,    pcod_glt,       form_lit,   AL_dbn_dbn ],
    { 107..111  <= with double }
    [   le_op,    pcod_gle,       form_lit,   AL_dbn_ing ],
    [   le_op,    pcod_gle,       form_lit,   AL_ing_dbn ],
    [   le_op,    pcod_gle,       form_lit,   AL_flg_dbn ],
    [   le_op,    pcod_gle,       form_lit,   AL_dbn_flg ],
    [   le_op,    pcod_gle,       form_lit,   AL_dbn_dbn ],
    { 112..116  >= with double }
    [   ge_op,    pcod_gge,       form_lit,   AL_dbn_ing ],
    [   ge_op,    pcod_gge,       form_lit,   AL_ing_dbn ],
    [   ge_op,    pcod_gge,       form_lit,   AL_flg_dbn ],
    [   ge_op,    pcod_gge,       form_lit,   AL_dbn_flg ],
    [   ge_op,    pcod_gge,       form_lit,   AL_dbn_dbn ],
    {117..121  > with double }
    [   gt_op,    pcod_ggt,       form_lit,   AL_dbn_ing ],
    [   gt_op,    pcod_ggt,       form_lit,   AL_ing_dbn ],
    [   gt_op,    pcod_ggt,       form_lit,   AL_flg_dbn ],
    [   gt_op,    pcod_ggt,       form_lit,   AL_dbn_flg ],
    [   gt_op,    pcod_ggt,       form_lit,   AL_dbn_dbn ],
    {122..166  compare with double }
    [   eq_op,    pcod_geq,       form_lit,   AL_dbn_ing ],
    [   eq_op,    pcod_geq,       form_lit,   AL_ing_dbn ],
    [   eq_op,    pcod_geq,       form_lit,   AL_flg_dbn ],
    [   eq_op,    pcod_geq,       form_lit,   AL_dbn_flg ],
    [   eq_op,    pcod_geq,       form_lit,   AL_dbn_dbn ],
    { 127..131  compare with double }
    [   ne_op,    pcod_gne,       form_lit,   AL_dbn_ing ],
    [   ne_op,    pcod_gne,       form_lit,   AL_ing_dbn ],
    [   ne_op,    pcod_gne,       form_lit,   AL_flg_dbn ],
    [   ne_op,    pcod_gne,       form_lit,   AL_dbn_flg ],
    [   ne_op,    pcod_gne,       form_lit,   AL_dbn_dbn ],
    { 132..136  := for double }
    [  ass_op, pcod_gstore,      form_null,   ALwdbn_ing ],
    [  ass_op, pcod_gstore,      form_null,   ALwdbn_flg ],
    [  ass_op, pcod_istore,      form_null,   ALwinn_dbi ],
    [  ass_op, pcod_fstore,      form_null,   ALwfln_dbf ],
    [  ass_op, pcod_gstore,      form_null,   ALwdbn_dbn ],
    {  not set now for string }
    { 137..148 for short set operation }
    [  mul_op,   pcod_band,      form_wset,   AL_wsn_wsn ],
    [  add_op,    pcod_bis,      form_wset,   AL_wsn_wsn ],
    [  sub_op,    pcod_com,      form_wset,       AL_wsn ],
    [  sub_op,    pcod_bic,      form_wset,   AL_wsn_wsn ],
    [  xor_op,   pcod_bxor,      form_wset,   AL_wsn_wsn ],
    [   in_op,  pcod_inset,       form_lit,   AL_enn_wsn ],
    [   lt_op,  pcod_setlt,       form_lit,   ALcwsn_wsn ],
    [   le_op,  pcod_setle,       form_lit,   ALcwsn_wsn ],
    [   ge_op,  pcod_setge,       form_lit,   ALcwsn_wsn ],
    [   gt_op,  pcod_setgt,       form_lit,   ALcwsn_wsn ],
    [   eq_op,  pcod_seteq,       form_lit,   ALcwsn_wsn ],
    [   ne_op,  pcod_setne,       form_lit,   ALcwsn_wsn ],
    { 149..152  := for structured }
    [   ne_op,    pcod__ne,       form_lit,   AL_win_win ],
    [   eq_op,    pcod__eq,       form_lit,   AL_win_win ],
    [  ass_op, pcod_istore,      form_null,   ALwwsn_wsn ],
    [  ass_op,  pcod_store,      form_null,   ALwwin_win ]
  ];

var
  i:  integer;
  op: operator;
  po: ope_ptr;
  pg: gen_ptr;

begin { CREATE_STD_OPERATOR }
  for op := not_op to no_op do  ope_table[op] := nil;  { Init table }
  for i := 1 to nent do
  with std_ope_tab[i] do
  begin
    if ope_table[ope] = nil then
    begin
      po := nil;
      NEW( po ); ope_table[ope] := po;
      with po^ do
      begin
        ope_operator := ope;
        ope_lex      :=   0;                           { Lex 0 for standard }
        ope_nxt      := nil;                           { Unused for standard }
        ope_llnk     := nil;                           { For standard operator definitions }
        ope_gfirst   := nil;
        ope_glast    := nil
      end
    end
    else po := ope_table[ope];
    pg := nil;
    NEW( pg, true );
    with pg^, po^ do
    begin
      gen_link :=  nil;
      gen_blt  := true;
      gen_cod  :=  pcd;
      gen_res  := typ_std[rty];
      gen_atb  := ope_arg_tab[lar];

      if ope_gfirst = nil then ope_gfirst := pg
                          else ope_glast^.gen_link := pg;
      ope_glast := pg
    end;
  end
end CREATE_STD_OPERATOR;



procedure CREATE_BLT_FUNCTION;
const
  nent  = 69;                                          { Number of builtin generic entry }

type
  gfnc_item = ( { * Define literal code for each generic function }
    gf_xx_succ, gf_xx_pred, gf_xxx_ord, gf_xxx_chr, gf_xxx_odd, gf_x_round,
    gf_x_trunc, gf_xxx_abs, gf_xxx_sqr, gf_xx_sqrt, gf_xxx_sin, gf_xxx_cos,
    gf_xxx_tan, gf__arcsin, gf__arccos, gf__arctan, gf_xxx_exp, gf_xxxx_ln,
    gf_xx_sinh, gf_xx_cosh, gf_xx_tanh, gf_argsinh, gf_argcosh, gf_argtanh
  );

  fnc_name = record
    l: byte;
    s: array[1..8] of char
  end;

  genfncty = array[gfnc_item] of fnc_name;


  fnc_entry = record
    ide:     gfnc_item; { Generic function identifier index }
    pcd:    pcod_codes; { Pcode statement }
    rft:     typ_forms; { Type form of function result }
    lar:    argli_enum  { Index of formal arguments list }
  end;

  entbty = array[1..nent] of fnc_entry;

const
  { Waring: The pro_entry order is related to the codtab order } 
  gfntab = genfncty[
    [ 4, 'succ'    ], [ 4, 'pred'    ], { gf_xx_succ : SUCC(<ennum>),    gf_xx_pred : PRED(<ennum>),   }
    [ 3, 'ord'     ], [ 3, 'chr'     ], { gf_xxx_ord : ORD(<ennum>),     gf_xxx_chr : CHR(<ennum>),    }
    [ 3, 'odd'     ], [ 5, 'round'   ], { gf_xxx_odd : IODD(<int>),      gf_x_round : ROUND(<real>),   }
    [ 5, 'trunc'   ], [ 3, 'abs'     ], { gf_x_trunc : TRUNC(<real>),    gf_xxx_abs : ABS(<number>)    }
    [ 3, 'sqr'     ], [ 4, 'sqrt'    ], { gf_xxx_sqr : SQR(<number>),    gf_xx_sqrt : SQRT(<real>),    }
    [ 3, 'sin'     ], [ 3, 'cos'     ], { gf_xxx_sin : SIN(<real>),      gf_xxx_cos : COS(<real>),     }
    [ 3, 'tan'     ], [ 6, 'arcsin'  ], { gf_xxx_tan : TAN(<real>),      gf__arcsin : ARCSIN(<real>),  }
    [ 6, 'arccos'  ], [ 6, 'arctan'  ], { gf__arccos:ARCCOS(<real>),gf__arctan:ARCTAN(<real>[,<real>]),}
    [ 3, 'exp'     ], [ 2, 'ln'      ], { gf_xxx_exp : EXP(<real>),      gf_xxxx_ln : LN(<real>),      }
    [ 4, 'sinh'    ], [ 4, 'cosh'    ], { gf_xx_sinh : SINH(<real>),     gf_xx_cosh : COSH(<real>),    }
    [ 4, 'tanh'    ], [ 7, 'argsinh' ], { gf_xx_tanh : TANH(<real>),     gf_argsinh : ARGSINH(<real>), }
    [ 7, 'argcosh' ], [ 7, 'argtanh' ]  { gf_argcosh : ARGCOSH(<real>)   gf_argtanh : ARGTANH(<real>)  }
  ];


  cod_tab = entbty[
    {  1.. 2 }
    [ gf_xx_succ,   pcod_succ,  form_ennum,     AL_wen ], [ gf_xx_pred,   pcod_pred,  form_ennum,     AL_wen ],
    {  3.. 5  ORD,  CHR, ODD  }
    [ gf_xxx_ord,   pcod_noop,    form_int,     AL_wen ], [ gf_xxx_chr,   pcod_noop,   form_char,     AL_wen ],
    [ gf_xxx_odd,   pcod_iodd,    form_lit,     AL_inn ],
    {  6.. 9 ROUND, TRUNC }
    [ gf_x_round,   pcod_cvfi,    form_int,     AL_fln ], [ gf_x_round,   pcod_cvgi,    form_int,     AL_dbn ],
    [ gf_x_trunc, pcod_ftrunc,    form_int,     AL_fln ], [ gf_x_trunc, pcod_gtrunc,    form_int,     AL_dbn ],
    { 10..18 ABS, SQR, SQRT }
    [ gf_xxx_abs,   pcod_iabs,    form_int,     AL_inn ], [ gf_xxx_abs,   pcod_fabs, form_single,     AL_fln ],
    [ gf_xxx_abs,   pcod_gabs, form_double,     AL_dbn ], [ gf_xxx_sqr,   pcod_isqr,    form_int,     AL_inn ],
    [ gf_xxx_sqr,   pcod_fsqr, form_single,     AL_fln ], [ gf_xxx_sqr,   pcod_gsqr, form_double,     AL_dbn ],
    [ gf_xx_sqrt,   pcod_sqrt, form_single,     AL_inf ], [ gf_xx_sqrt,   pcod_sqrt, form_single,     AL_fln ],
    [ gf_xx_sqrt,  pcod_gsqrt, form_double,     AL_dbn ],
    { 19..27 SIN, COS, TAN }
    [ gf_xxx_sin,    pcod_sin, form_single,     AL_inf ], [ gf_xxx_sin,    pcod_sin, form_single,     AL_fln ],
    [ gf_xxx_sin,   pcod_gsin, form_double,     AL_dbn ], [ gf_xxx_cos,    pcod_cos, form_single,     AL_inf ],
    [ gf_xxx_cos,    pcod_cos, form_single,     AL_fln ], [ gf_xxx_cos,   pcod_gcos, form_double,     AL_dbn ],
    [ gf_xxx_tan,    pcod_tan, form_single,     AL_inf ], [ gf_xxx_tan,    pcod_tan, form_single,     AL_fln ],
    [ gf_xxx_tan,   pcod_gtan, form_double,     AL_dbn ],
    { 28..36 ARCSIN, ARCCOS, ARCTAN }
    [ gf__arcsin,   pcod_asin, form_single,     AL_inf ], [ gf__arcsin,   pcod_asin, form_single,     AL_fln ],
    [ gf__arcsin,  pcod_gasin, form_double,     AL_dbn ], [ gf__arccos,   pcod_acos, form_single,     AL_inf ],
    [ gf__arccos,   pcod_acos, form_single,     AL_fln ], [ gf__arccos,  pcod_gacos, form_double,     AL_dbn ],
    [ gf__arctan,   pcod_atan, form_single,     AL_inf ], [ gf__arctan,   pcod_atan, form_single,     AL_fln ],
    [ gf__arctan,  pcod_gatan, form_double,     AL_dbn ],
    { 37..45 ARCTAN (2 parameters) }
    [ gf__arctan,   pcod_phas, form_single, AL_inf_inf ], [ gf__arctan,   pcod_phas, form_single, AL_fln_inf ],
    [ gf__arctan,   pcod_phas, form_single, AL_inf_fln ], [ gf__arctan,   pcod_phas, form_single, AL_fln_fln ],
    [ gf__arctan,  pcod_gphas, form_double, AL_dbn_ing ], [ gf__arctan,  pcod_gphas, form_double, AL_ing_dbn ],
    [ gf__arctan,  pcod_gphas, form_double, AL_dbn_flg ], [ gf__arctan,  pcod_gphas, form_double, AL_flg_dbn ],
    [ gf__arctan,  pcod_gphas, form_double, AL_dbn_dbn ],
    { 46..51 EXP, LOG }
    [ gf_xxx_exp,    pcod_exp, form_single,     AL_inf ], [ gf_xxx_exp,    pcod_exp, form_single,     AL_fln ],
    [ gf_xxx_exp,   pcod_gexp, form_double,     AL_dbn ], [ gf_xxxx_ln,    pcod_log, form_single,     AL_inf ],
    [ gf_xxxx_ln,    pcod_log, form_single,     AL_fln ], [ gf_xxxx_ln,   pcod_glog, form_double,     AL_dbn ],
    { 52..60 SINH, COSH, TANH }
    [ gf_xx_sinh,   pcod_sinh, form_single,     AL_inf ], [ gf_xx_sinh,   pcod_sinh, form_single,     AL_fln ],
    [ gf_xx_sinh,  pcod_gsinh, form_double,     AL_dbn ], [ gf_xx_cosh,   pcod_cosh, form_single,     AL_inf ],
    [ gf_xx_cosh,   pcod_cosh, form_single,     AL_fln ], [ gf_xx_cosh,  pcod_gcosh, form_double,     AL_dbn ],
    [ gf_xx_tanh,   pcod_tanh, form_single,     AL_inf ], [ gf_xx_tanh,   pcod_tanh, form_single,     AL_fln ],
    [ gf_xx_tanh,  pcod_gtanh, form_double,     AL_dbn ],
    { 61..69 ARGSINH, ARGCOSH, ARGTANH }
    [ gf_argsinh,  pcod_asinh, form_single,     AL_inf ], [ gf_argsinh,  pcod_asinh, form_single,     AL_fln ],
    [ gf_argsinh, pcod_gasinh, form_double,     AL_dbn ], [ gf_argcosh,  pcod_acosh, form_single,     AL_inf ],
    [ gf_argcosh,  pcod_acosh, form_single,     AL_fln ], [ gf_argcosh, pcod_gacosh, form_double,     AL_dbn ],
    [ gf_argtanh,  pcod_atanh, form_single,     AL_inf ], [ gf_argtanh,  pcod_atanh, form_single,     AL_fln ],
    [ gf_argtanh, pcod_gatanh, form_double,     AL_dbn ]
  ];

var
  i, j, ncount, pnb: integer;
  ip, ip1:           ide_ptr;
  pg:                gen_ptr;

  gid_tab: array[gfnc_item] of ide_ptr;

begin
  ncount := 1;
  { Initialize the function identifier table }
  for itm := gfnc_item"first to gfnc_item"last do gid_tab[itm] := nil;

  for ii := 1 to nent do
  with cod_tab[ii] do
  begin
    if gid_tab[ide] = nil then { * If the generic identifier was not created ... }
    with gfntab[ide] do                 { ... we must create it now. }
    begin
      IDECTE_CREATE_NAME( l, s );       { Set the identifier name }
      IDE_NEW( cla_generic, nil, ip);   { Creates the identifier }
      with ip^ do
      begin                             { Initialize the entry list to empty }
        ide_gproc  := nil;
        ide_gfirst := nil;
        ide_glast  := nil
      end;
      gid_tab[ide] := ip                { Keep the generic identifier for the next entry attachement }
    end else ip := gid_tab[ide]; { * Else we get the identifier pointer. }
    NEW( pg, true );                    { Create a builtin function entry }
    with ip^, pg^ do
    begin
      gen_link  :=                 nil; { Fill the builtin entry record }
      gen_blt   :=                true;
      gen_cod   :=                 pcd; { Set the entry pcode }
      gen_res   :=        typ_std[rft]; { Set the result function type }
      gen_atb   :=    ope_arg_tab[lar]; { Attach builtin entry argument(s) list }
      if ide_gfirst = nil then ide_gfirst := pg
      else ide_glast^.gen_link := pg;
      ide_glast :=          pg
    end
  end
end CREATE_BLT_FUNCTION;


procedure IDE_CREATE_BUILTIN;
begin { IDE_CREATE_BUILTIN }
  { Create all standard arguments lists }
  GEN_OPE_ARG_LIST;

  { Create all Standard Conversions }
  CREATE_STD_CONVERSION;

  { Create all Standard Operators }
  CREATE_STD_OPERATOR;

  { Create all Standard Procedures and Functions }
  CREATE_BLT_FUNCTION
end IDE_CREATE_BUILTIN;



procedure IDE_CREATE_ATTRIBUT;
type
  attr_tab = array[attr_kinds] of string(14);

const
  ideattr_tab = attr_tab[
    { Attr attributes }
    'address',          { attr_addr,        Address of object }
    'size',             { attr_size,        Size in byte of type/object }
    'first',            { attr_first,       First value {min) }
    'last',             { attr_last,        Last value (max) }
    'pred',             { attr_pred,        Previous Value PRD( ) }
    'succ',             { attr_succ,        Next value SUCC( ) }
    'image',            { attr_image,       Image of ennumerated type }
    'fobjsize',         { attr_fobjsize,    File Object size in Byte }
    'arr_i_first',      { attr_arrimin,     Array index minimum value }
    'arr_i_last',       { attr_arrimax,     Array index maximum value }
    'digits',           { attr_digits,      Number of valide digits }
    'max_exp',          { attr_emax,        More larger exponante }
    'small',            { attr_small,       Smaller number > 0 }
    'epsilon',          { attr_epsilon,     Smaller number > 1.0 - 1.0 }
    'large',            { attr_large,       More larger float number }
    'mantissa',         { attr_mantissa,    Number of bits in the mantissa }
    'cardinality',      { attr_card,        Set cardinality }
    'id_name',          { attr_name,        Identifier name to specify }

    { Atts/attp attributes lex block }
    'inherit',          { atts_inherit,     Inherit an environment }
    'environment',      { atts_environment, Create an environment }
    'global',           { atts_global,      Specify global object }
    'external',         { atts_external,    Specify external object }
    'hidden',           { atts_static,      Specify hidden object }
    'readonly',         { atts_readonly,    Specify readonly object }
    'optional',         { atts_optional,    Specify optional var formal }
    'volatile',         { atts_hidden,      Specify volatil variable }
    'static',           { atts_volatil,     Specify static variable }
    'byte',             { atts_byte,        Specify a byte allocation }
    'word',             { atts_word,        Specify a word allocation }
    'long',             { atts_long,        Specify a long allocation }

    { Special atribute for some complex generic functions/procedures }
    'setelem_type',     { attp_ind,         Indirect ref of the next arg. type }
    'direct_type',      { attp_dir,         Direct type reference: no parent }
    'samtype_arg',      { attp_sty,         Same type for the two arguments }
    'equtype_arg',      { attp_ety,         Eqivalent types for the two arguments }
    'return_type'       { attp_rty          Result function type to be same }
  ];
  
var
  i:  integer;
  ip: ide_ptr;
  
begin
  { For all ennumerated types }
  NEW_DISP_LEVEL( nil, dsp_record );        { Create an empty standard display }
  for att := attr_kinds"first to attr_kinds"last do
  with ideattr_tab[att] do
  begin
    IDECTE_CREATE_NAME( length, body );
    IDE_NEW( cla_attr, nil, ip );
    ip^.ide_attr := att;
  end;
  { Set Ennumerated Attr. List }
  attr_list := lex_ident_tree[curr_disp].disp_tree;
  curr_disp := curr_disp - 1
end IDE_CREATE_ATTRIBUT;



[global]
procedure GEN_CONV_ENTRY( tsrc, tdst: typ_ptr; pcd: pcod_codes );
{ Use to create a generic built-in entry for a new defined type }
var
  pg: gen_ptr;

begin
  pg := NEW_OPER( pcd, tdst, tsrc, cv_nop, [] );
  with tdst^.typ_ide^ do
  begin
    if ide_gfirst = nil then ide_gfirst := pg          { Fifo mode only }
                        else ide_gfirst^.gen_link := pg;
    ide_glast := pg
  end
end GEN_CONV_ENTRY;



[global]
procedure IDE_INIT;
{ To initialize the identifier data base and define all the basic objects }

var
  lgt1, lgt2:          lgt_ptr;
  cur_form:          typ_forms;
  pr:                  pro_ptr;
  tp, tp1, tp2:        typ_ptr;
  ip, ip1, ip2:        ide_ptr;

begin { IDE_INIT }
  curr_lex  :=  0;                              { Init current lex }
  curr_disp := -1;                              { Init the display identifier level }
  cprc_disp :=  0;                              { Init the current procedure display to standard display }
  lex_ident_level[0] := 0;                      { Init lex index list }
  pr := nil;
  NEW( pr );                                    { Creates a standard procedure record }
  NEW_DISP_LEVEL( pr, dsp_package );            { Creates an empty Standard Display }
  { Define a virtual Procedure as Owner of Standard def. }
  pro_current := pr;
  with pr^ do
  begin
    IDE_CREATE_NAME( '.standard.' );
    NEW( pro_stdname );
    pro_next            :=         nil;
    pro_link            :=         nil;
    pro_flags           :=          [];
    pro_stdname^        :=    sy_ident;         { Set the standard name }
    pro_operator        :=       no_op;
    pro_geneide         :=         nil;
    pro_idetree         :=         nil;
    pro_idelast         :=         nil;
    pro_parmlst         :=         nil;
    pro_lex             :=           0;
    pro_parmsize        :=           0;
    pro_nparm           :=           0;
    pro_typ             :=         nil;
    pro_prmtyls         :=         nil;
    pro_pkind           := pro_standard         { We are creating the standard package record }
  end;

  { Init for none standard types }

  IDE_NEW_TYP( form_wild , tp );                { Create the wild type }
  tp^.typ_size := 1;                            { Give a none dynamique size to wild type }

  for cur_form := form_pointer to form_free do
    typ_std[cur_form] := tp;

   { Define standard type integer }
 
  IDE_NEW_TYP_RANGE( -maxint, maxint, nil, int_typ );
  int_typ^.typ_fxdrange := false;               { Integer is The father of all Number types }
  int_typ^.typ_min := int_typ^.typ_min - 1;
  IDE_CREATE_NAME( 'integer' );                 { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, int_typ, ip );
  int_typ^.typ_ide := ip;                       { Set the reverse pointer }
  typ_std[form_int] := int_typ;

  { Define standard type unsigned }

  IDE_NEW_TYP_RANGE( 0, -1, int_typ, uns_typ );
  uns_typ^.typ_fxdrange := false;               { Unsigned is not a range in Integer types }
  IDE_CREATE_NAME( 'unsigned' );                { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, uns_typ, ip );
  uns_typ^.typ_ide := ip;                       { Set the reverse pointer }
  uns_typ^.typ_unsigned := true;

  { Define the Long unsigned and long integer (64 bits) as children of the standard integer }

  IDE_NEW_TYP_RANGE( -maxint, maxint, int_typ, lin_typ );
  lin_typ^.typ_fxdrange := false;               { long_integer is not a range in Integer types }
  lin_typ^.typ_size := 8;
  IDE_CREATE_NAME( 'long_integer' );            { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, lin_typ, lin_typ^.typ_ide );
   

  IDE_NEW_TYP_RANGE( 0, maxint, uns_typ, lun_typ );
  lun_typ^.typ_fxdrange := false;               { long_unsigned is not a range in unsigned types }
  lun_typ^.typ_size := 8;
  IDE_CREATE_NAME( 'long_unsigned' );           { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, lun_typ, lun_typ^.typ_ide );
  lun_typ^.typ_unsigned := true;
   
  
  { Partial Define Standard type boolean }
  IDE_NEW_TYP_RANGE( 0, 0, nil, tp );
  int_typ^.typ_fxdrange := false;               { Boolean is an Independant types }
  tp^.typ_form := form_lit;
  tp^.typ_size := 1;
  typ_std[form_lit] := tp;

  { Define standard type character }
  IDE_NEW_TYP_RANGE( 0, 255, nil, tp );
  int_typ^.typ_fxdrange := false;               { Char is an Independant types }
  with tp^ do
  begin
    typ_comp_size := LGT_NEW_ECONST( typ_std[form_int], 256 );
    typ_size := 1; typ_form := form_char
  end;
  IDE_CREATE_NAME( 'char' );                    { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_ide := ip;
  typ_std[form_char] := tp;


  { Set the single type ... }
  IDE_NEW_TYP( form_single, tp );
  tp^.typ_size := 4;
  IDE_CREATE_NAME( 'single');                   { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_ide := ip;
  typ_std[form_single] := tp;


  { ... and the double type }
  IDE_NEW_TYP( form_double, tp );
  tp^.typ_size := 8;
  IDE_CREATE_NAME( 'double');                   { Set identifier name for IDE_NEW }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_ide := ip;
  typ_std[form_double] := tp;

  IDE_NEW_TYP( form_set, tp );                  { Create an anonymous small set type }
  tp^.typ_size := 4;                            { deault size to 4 bytes }
  typ_std[form_set] := tp;

  IDE_NEW_TYP( form_lset, tp );                 { Create an anonymous large set type }
  tp^.typ_size := 4;                            { Default size to 32 bytes }
  typ_std[form_lset] := tp;

  typ_std[form_record] := nil;                  { Set for cpas_std_env definition of string }
  typ_std[form_array]  := nil;
  typ_std[form_file]   := nil;
  typ_std[form_conf]   := nil;


  { Create all wild types }
  {***********************}

  { Create nil type }
  IDE_CREATE_NAME( '$wild_pointer' );           { Set the identifier name "$wild_pointer" }
  IDE_NEW_TYP( form_pointer, tp );              { Create the wild pointer type record ... }
  IDE_NEW( cla_type, tp, ip );                  { ... and its related identifier record }
  tp^.typ_size          :=   4;                 { Set the default pointer type size (changed in a second INIT step) }
  tp^.typ_ide           :=  ip;                 { Attach the type to the identifier }
  tp^.typ_eltype        := nil;                 { Wild identifier have not pointed object type }
  {tp^.typ_eltype := typ_std[form_wild];}
  typ_std[form_pointer] :=  tp;                 { Keep the Pointer type record address in the standard type table }

  IDE_CREATE_NAME( 'nil' );                     { Set nil as an identifier that could not be a keyword }
  IDE_NEW_TYP( form_nil, tp );                  { Create the nil pointer type record ... }
  IDE_NEW( cla_type, tp, ip );                  { ... and its related identifier record }
  tp^.typ_size          :=   4;                 { Set the default pointer type size (changed in a second INIT step) }
  tp^.typ_ide           :=  ip;                 { Attach the type to the identifier }
  tp^.typ_eltype        := nil;                 { Wild identifier have not pointed object type }
  {tp^.typ_eltype := typ_std[form_wild];}
  typ_std[form_nil]     :=  tp;                 { Keep the Pointer type record address in the standard type table }
  
  
{ ////////////////////////// do not change of size during INIT Time }
  IDE_NEW_TYP( form_fentry, tp );               { Create an anonymous entry pointer type }
  tp^.typ_size   :=   0;
  tp^.typ_entry  := nil;
  typ_std[form_fentry] := tp;

  { Create wlit type }
  IDE_CREATE_NAME( '$wild_literal' );
  IDE_NEW_TYP( form_wlit, tp );                 { Define the wild literal (as boolean; day,month ... ) type }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 1; tp^.typ_ide := ip;
  typ_std[form_wlit] := tp;

  { Create ennum type }
  IDE_CREATE_NAME( '$wild_ennum' );
  IDE_NEW_TYP( form_ennum, tp );                { Define a wild enumerated object type }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 4; tp^.typ_ide := ip;
  typ_std[form_ennum] := tp;

  { Create wild type }
  IDE_CREATE_NAME( '$wild_thing' );
  tp := typ_std[form_wild];                     { Define indefined type - an unknown thing }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_wild] := tp;

  IDE_CREATE_NAME( '$wild_file' );
  IDE_NEW_TYP( form_wfile, tp );                { Define wild file }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  VAL_NEW( tp^.typ_inival, typ_std[form_nil] );
  tp^.typ_inival^.val_ival := 0;
  typ_std[form_wfile] := tp;

  dst_seta := max_seta;                         { Maximum size of a dst set in bits }
  dst_setw := max_setw;                         { Maximum size of a dst word set in bits }
  dst_seti := max_seti;                         { Maximum size of a dst set in word set }

  IDE_CREATE_NAME( '$wild_simple_set' );
  IDE_NEW_TYP( form_wset, tp );                 { Define wild small set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size        := dst_setw div 8;
  tp^.typ_ide         := ip;
  tp^.typ_cardinality := dst_setw;
  tp^.typ_seltype     := int_typ;
  typ_std[form_wset]  := tp;
  IDE_NEW_TYP( form_wset, tp );                 { Define wild small set }

  

  IDE_CREATE_NAME( '$wild_large_set' );
  IDE_NEW_TYP( form_wlset, tp );                { Define wild large set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size        := (dst_setw*dst_seti + 7) div 8;
  tp^.typ_ide         := ip;
  tp^.typ_cardinality := dst_seta;
  tp^.typ_seltype     := int_typ;
  typ_std[form_wlset] := tp;

  IDE_CREATE_NAME( '$wild_set' );
  IDE_NEW_TYP( form_wwset, tp );                { Define wild set }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size        := dst_setw div 8;
  tp^.typ_ide         := ip;
  tp^.typ_cardinality :=  0;
  typ_std[form_wwset] := tp;

  IDE_CREATE_NAME( '$wild_record' );
  IDE_NEW_TYP( form_wrecord, tp );              { Define wild record }
  IDE_NEW( cla_type, tp, ip );
  tp^.typ_size := 0; tp^.typ_ide := ip;
  typ_std[form_wrecord] := tp;

  IDE_NEW_TYP( form_null, tp );                 { Define a null type for indirect procedure return type }
  tp^.typ_size := 0;
  typ_std[form_null] := tp;

  inte_size := typ_std[form_int]^.typ_size;     { Size of an Integer in Bytes }
  fptr_size := typ_std[form_nil]^.typ_size;     { Size of a Pointer in Bytes }


  IDE_CREATE_ATTRIBUT;

  IDE_CREATE_BUILTIN;

  
  GEN_CONV_ENTRY( typ_std[form_ennum],            int_typ, pcod_noop );
  GEN_CONV_ENTRY(   typ_std[form_nil],            uns_typ, pcod_noop );
  GEN_CONV_ENTRY( typ_std[form_ennum],            uns_typ, pcod_noop );
  GEN_CONV_ENTRY( typ_std[form_ennum], typ_std[form_char], pcod_noop );

  { Assume the heritage of the integers properties for unsigned, long_integer and long_unsigned }
  uns_typ^.typ_ide^.ide_gfirst := int_typ^.typ_ide^.ide_gfirst;
  lin_typ^.typ_ide^.ide_gfirst := int_typ^.typ_ide^.ide_gfirst;
  lun_typ^.typ_ide^.ide_gfirst := int_typ^.typ_ide^.ide_gfirst;

  { Enter undeclared identifiers }
  IDE_CREATE_NAME( '.ul');
  IDE_NEW( cla_label,  typ_std[form_wild], ide_udptr[cla_label]  );
  IDE_CREATE_NAME( '.uu');
  IDE_NEW( cla_tparam, typ_std[form_wild], ide_udptr[cla_tparam] );
  IDE_CREATE_NAME( '.ut' );
  IDE_NEW( cla_type,   typ_std[form_wild], ide_udptr[cla_type]   );
  IDE_CREATE_NAME( '.uc' );
  IDE_NEW( cla_konst,  typ_std[form_wild], ide_udptr[cla_konst]  );
  with ide_udptr[cla_konst]^ do
  begin
    VAL_NEW( ide_value, typ_std[form_wild] );
    ide_value^.val_kind := form_null
  end;
  IDE_CREATE_NAME( '.uv' );
  IDE_NEW( cla_varbl, typ_std[form_wild], ide_udptr[cla_varbl] );
  IDE_CREATE_NAME( '.uf' );
  IDE_NEW( cla_field, typ_std[form_wild], ide_udptr[cla_field] );
  IDE_CREATE_NAME( '.ug' );
  IDE_NEW( cla_generic, typ_std[form_wild], ide_udptr[cla_generic] );
  IDE_CREATE_NAME( '.uw' );
  IDE_NEW( cla_genwfent, typ_std[form_wild], ide_udptr[cla_genwfent] );
  IDE_CREATE_NAME( '.up' );
  IDE_NEW( cla_fentry, typ_std[form_wild], ide_udptr[cla_fentry] );
  IDE_CREATE_NAME( '.us' );
  IDE_NEW( cla_statement, typ_std[form_wild], ide_udptr[cla_statement] );

  { Keep the Standard kind of store definitions for Store Operation }
  std_store_dgf := ope_table[ass_op]^.ope_gfirst;
  std_store_dgl := ope_table[ass_op]^.ope_glast;

  err_prt := true                               { Enable Undeclared Identifier Management }
end IDE_INIT;

end.
