zone à examiner de pcmp_comp.pas
*********************************



procedure TYPE_SPC {( var it: typ_ptr;                Create type pointer,
                            descr_sz: integer;        Descriptor size or 0,
                            parm: ide_ptr;            Parameter ide. root,
                            bdeforg,                  To allow definition or use (short) of organization.
                            buseorg: boolean;
                            owid: ide_ptr := nil ); forward;  };
const
  mdnam = 'TYPS';

var
  pro:             pro_ptr;
  lgt, lgt1, lgt2: lgt_ptr;
  r:                  real;
  i, iv, il, sz, aln, maln, sav_descr, ndim: integer;
  ip, iq, ip1:     ide_ptr;
  p1, p2, p3, p4:  typ_ptr;
  pv, pvh, pvl:    val_ptr;
  bneg, b_new:     boolean;

begin { TYPE_SPC }
  sav_descr := sy_descr_size;                                  { Save descriptor size }
  sy_descr_size := 0;                                          { Disable the descriptor allocator for recursive call }
  sy_type_gfirst := nil;                                       { No generic definition is assumed }
  with sy_sym do
  begin
    p1 := nil;
    if sy = packedsy then INSYMBOL;
    case sy of
      typesy:                                                  { Generic type definition }
        begin
          sav_descr := 0;                                      { Disable the local descritor size allocator }
          INSYMBOL;                                            { Gobble up "type" }
          { We expect a case }
          if sy <> casesy then SRC_ERROR( mdnam, 182, e_error )
                          else INSYMBOL;
          IDE_NEW_TYP( form_generic, p1 );                     { Built a generic type }
          p1^.typ_comp_size := CASE_DEFINITION( typesy, nil )
        end;

      newsy:                                                   { New version of a defined type }
        begin
          INSYMBOL;                                            { Gobble up "new" }
          ip := IDE_SEARCH( [cla_type] );
          INSYMBOL;
          if ip <> ide_udptr[cla_type] then                    { Declared type }
          with ip^ do
          begin
            IDE_NEW_TYP( ip^.ide_typ^.typ_form, p1 );
            sy_type_gfirst := ide_gfirst;
            with p1^ do
            begin
              typ_ide        := owid;                          { Set the link with the owner identifier }
              typ_parent     := ide_typ;
              typ_parmlst    := typ_parent^.typ_parmlst;
              typ_size       := typ_parent^.typ_size;
              typ_descr_size := typ_parent^.typ_descr_size;
              typ_align      := typ_parent^.typ_align;
              typ_inival     := typ_parent^.typ_inival;
              typ_hasidsc    := typ_parent^.typ_hasidsc;
              if typ_comp_size <> nil then
                typ_comp_size := LGT_LINK( typ_parent^.typ_comp_size );
              case typ_form of
                form_char, form_lit, form_int:
                  begin
                    typ_min := typ_parent^.typ_min;
                    typ_max := typ_parent^.typ_max;
                    typ_unsigned := typ_parent^.typ_unsigned;
                    typ_idelist := typ_parent^.typ_idelist
                  end;

                form_range:
                  begin
                    typ_nvalue := LGT_LINK( typ_parent^.typ_nvalue );
                    typ_high   := LGT_LINK( typ_parent^.typ_high   );
                    typ_low    := LGT_LINK( typ_parent^.typ_low    )
                  end;

                form_single, form_double: ;    { Nothing to do }

                form_private, form_organization,
                form_file, form_pointer:
                    typ_eltype  := typ_parent^.typ_eltype;

                form_set, form_lset:
                    typ_seltype := typ_parent^.typ_seltype;

                form_array:
                  begin
                    typ_el_size := typ_parent^.typ_el_size;
                    if typ_parent^.typ_el_comp_size <> nil then
                      typ_el_comp_size
                                 := LGT_LINK( typ_parent^.typ_el_comp_size )
                    else
                      typ_el_comp_size := nil;
                    typ_aeltype := typ_parent^.typ_aeltype;
                    typ_indtype := typ_parent^.typ_indtype
                  end;

                form_record:
                  begin
                    typ_firstfield := typ_parent^.typ_firstfield;
                    typ_lastfield  := typ_parent^.typ_lastfield;
                    if typ_parent^.typ_recvar <> nil then
                      typ_recvar   :=  LGT_LINK( typ_parent^.typ_recvar )
                    else
                      typ_recvar := nil
                  end;

                form_wlit,
                form_ennum,
                form_wwset,
                form_wild:
                  begin
                    sz  := typ_size;
                    aln := typ_align.int;
                    SET_ALIGNMENT_SPC( sz, aln );
                    if sz < typ_size then SRC_ERROR( mdnam, 214, e_error )
                                     else typ_size := sz;
                    if aln >= 0 then typ_align.int := aln
                  end;

              otherwise
                { Other are illegal }
                SRC_ERROR( mdnam, 206, e_severe )
              end;
            end
          end
        end;

      privatesy:
        begin
          if parm <> nil then SRC_ERROR( mdnam, 207, e_error );
          INSYMBOL;                                            { Gobble up "private" }
          if sy = pointersy then
            if bdeforg then
            begin                                              { For "private access" definition }
              INSYMBOL;                                        { Gobble up "access" }
              IDE_NEW_TYP( form_organization, p1 );
              with p1^ do
              begin
                typ_ide    := owid;
                typ_eltype := nil;
                typ_size   := fptr_size;
                typ_align  := typ_std[form_pointer]^.typ_align;
                typ_comp_size := nil
              end
            end
            { Illegal except for type definition }
            else SRC_ERROR( mdnam, 208, e_severe )
          else
          begin                                                { Normal undefined type }
            IDE_NEW_TYP( form_private, p1 );
            with p1^ do
            begin
              typ_eltype := nil;
              typ_comp_size := nil;
              { Default to integer Alignement }
              typ_align := typ_std[form_int]^.typ_align;
              typ_size  := 1                                   { It is the minimum possible size }
            end;
          end;
          with p1^ do
          begin
            { Get size and alignement specification in bits }
            sz  := typ_size;
            aln := typ_align.int;
            SET_ALIGNMENT_SPC( sz, aln );
            if sy_init_mod and (sy = colon) then DATA_FORMAT_SET( p1 );
            if sz < typ_size then SRC_ERROR( mdnam, 214, e_error )
                             else typ_size := sz;
            if aln >= 0 then typ_align.int := aln
          end
        end;

      arraysy:
        begin
          INSYMBOL;                                            { Gobble up "array" }
          if sy <> lbrack then SRC_ERROR( mdnam, 25, e_error );
          ndim := 0;
          ARRAY_DEF( p1, false, ndim, owid );
          { Set the prototype type for ennumerated image type }
          if ima_typ = nil then ima_typ := p1
        end;

      recordsy:
        begin
          il := curr_disp;
          IDE_NEW_TYP( form_record, p1 );                      { Create a typ_rec descriptor }
          with p1^ do
          begin                                                { It is a new record }
            typ_ide := owid;
            typ_descr_size := descr_sz;                        { Set the descriptor size }
            typ_size := typ_descr_size;                        { Set the size count origine }
            typ_firstfield := nil; typ_lastfield := nil;
            typ_recvar := nil;
            ip := nil
          end;
          INSYMBOL;                                            { Gobble up "record" or "=>" }
          NEW_DISP_LEVEL( nil, dsp_record );                   { Create a field display }
          has_intdesc := false;
          VARBL_SETTING( cla_field, p1^.typ_size, maln, p1 );
          with p1^ do
          begin
            typ_hasidsc       := has_intdesc;                  { Set the internal descriptor flag when required }
            typ_firstfield    := lex_ident_tree[curr_disp].disp_tree;
            if typ_recvar = nil then
              typ_lastfield   := lex_ident_tree[curr_disp].disp_ide_last;
            { Remove the record display level }
            curr_disp := PRED( curr_disp )
          end;
          { For variant the link of the previous field is done by IDE_NEW }
          if sy = endsy then INSYMBOL else SRC_ERROR( mdnam, 54, e_error );
          if typ_std[form_record] = nil then
          begin                                                { First record declaration is used as standard string def. }
            typ_std[form_record] := p1;
            with p1^ do
            begin
              stri_descrsz   := typ_descr_size;
              stri_lengthsz  := typ_firstfield^.ide_typ^.typ_size;
              stri_stroffset := typ_firstfield^.ide_nxt^.ide_offset
            end
          end
        end;

      filesy:                                                  { For file definition }
        begin
          INSYMBOL;                                            { Gobble up "file" keyword }
          if sy = ofsy then INSYMBOL else SRC_ERROR( mdnam, 51, e_error );
          IDE_NEW_TYP( form_file, p1 );                        { Create a typ_rec descriptor }
          with p1^ do
          begin
            typ_ide    := owid;
            typ_align  := typ_std[form_wfile]^.typ_align;
            typ_size   := typ_std[form_wfile]^.typ_size;
            typ_inival := typ_std[form_wfile]^.typ_inival;
            typ_parent := typ_std[form_wfile];
            { Get the file element type }
            TYPE_SPC( typ_eltype, 0, nil, false, false );

            { For any element type with Descriptor, we set the internal descriptor flag }
            if typ_eltype^.typ_hasidsc or (typ_eltype^.typ_descr_size > 0) then typ_hasidsc := true;

            if typ_eltype^.typ_size <= 0 then SRC_ERROR( mdnam, 149, e_severe )
          end;
          if typ_std[form_file] = nil then
            { First file declaration is used as standard text file def. }
            typ_std[form_file] := p1
        end;

      pointersy,
      indirsign:                                               { For pointer }
        begin
          INSYMBOL;                                            { Gobble up the access keyword ( or "^") }
          if (sy = proceduresy) or (sy = functionsy) then
            p1 := FORMAL_PROC_PTR( sy = functionsy )
          else
          begin
            IDE_NEW_TYP( form_pointer, p1 );                   { Create a typ_rec descriptor }
            with p1^ do
            begin
              typ_ide    := owid;
              typ_align := typ_std[form_nil]^.typ_align;
              typ_size := fptr_size;
              typ_parent := typ_std[form_nil];                 { All pointer has the nil type as parent }
              err_prt := false;                                { No error for forward def. }
              ip := IDE_SEARCH([cla_type]);                    { Look for the type identifier }
              err_prt := true;                                 { Reset normal error }
              if ip = nil then
              begin
                IDE_NEW( cla_type, p1, ip );                   { Create the identifier }
                ip^.ide_forlnk := fw_ptr;
                fw_ptr := ip
              end
              else typ_eltype := ip^.ide_typ;
              INSYMBOL;                                        { Gobble up the pointed type identifier }
              { Set the pointer conversion from any pointer type }
              sy_type_gfirst := NEW_OPER( pcod_noop, p1, typ_std[form_pointer], cv_nop, [a_nil] )
            end
          end
        end;

      lparen:
        if ima_typ <> nil then
        if ima_typ^.typ_parmlst <> nil then
        begin                                                  { Enumerate type }
          INSYMBOL;                                            { Gobble up the "(" }
          if typ_std[form_lit]^.typ_max = 0 then               { Boolean def. }
            p1 := typ_std[form_lit]
          else
            IDE_NEW_TYP( form_lit, p1 );                       { Create a typ_rec descriptor }
          with p1^ do
          begin
            typ_ide      := owid;
            typ_size     := typ_std[form_char]^.typ_size;      { Default size }
            typ_min      := 0;
            typ_max      := -1; typ_parent := nil;
            typ_unsigned := true;              { Always unsigned }
            typ_align    := typ_std[form_char]^.typ_align;
            il  := 0;
            pvh := nil;
            sz  := 0;
            while sy = identsy do
            begin
              if sy_ident.l > il then il := sy_ident.l;        { Build max. id. len. }
              IDE_NEW( cla_konst, p1, ip);                     { Create the const ident }
              { Link to current ident block list }
              if typ_idelist = nil then typ_idelist := ip;
              typ_max := SUCC( typ_max );
              with ip^ do
              begin
                { Creates the Literal Constant record }
                VAL_NEW( ide_value, p1 );
                with ide_value^ do
                begin
                  val_kind := form_lit;
                  val_ival := typ_max
                end;
                pv := nil;
                { Create the related identifier cte. string }
                VAL_NEW( pv, nil );
                { ... with the appropriate links }
                if pvh = nil then pvh := pv
                             else pvl^.val_next := pv;
                pvl := pv;
                with pv^ do
                begin
                  val_kind := form_string;
                  val_size := 0;                               { Temporary }
                  NEW( val_str, sy_ident.l + 1 );
                  val_typ  := ima_typ^.typ_aeltype;
                  with val_str^ do
                  begin                                        { Add the string size as the first string's character }
                    length  := sy_ident.l + 1;
                    body[1] := CHR( sy_ident.l );
                    for i := 1 to sy_ident.l do
                      body[i+1] := sy_ident.s[i]
                  end
                end
              end;
              INSYMBOL;
              if sy = comma then INSYMBOL
              else
                if sy <> rparen then SRC_ERROR( mdnam, 23, e_error);
              if sy = comma then SRC_ERROR( mdnam, 27, e_error )
            end                                                { While sy = identsy };
            INSYMBOL;                                          { Gobble up the ")" }
            { Creates the constant image string table subtype parm. List }
            lgt1 := LGT_NEW_ECONST( typ_std[form_int], il );
            lgt2 := LGT_NEW_ECONST( typ_std[form_int], typ_max );
            lgt2^.lgt_nxt := lgt1;
            p2 := TYPE_PARM_SET( ima_typ^.typ_ide, lgt2 );
            { Set the correct identifier size of each constant }
            pv := pvh;
            while pv <> nil do
            with pv^ do
            begin
              val_size := il + 1;                              { Set the correct string id. allocated size }
              pv := val_next
            end;
            { Creates the constant image string table }
            { Build the ennumerated range cte for descriptor }
            with ima_typ^.typ_parmlst^ do
            if ide_nxt <> nil then
            begin
              VAL_NEW( pv, ide_nxt^.ide_typ );
              with pv^, ide_nxt^ do
              begin                                            { Set the allocated size for identifier strings }
                val_ival := il;
                if ide_typ <> nil then val_size := ide_typ^.typ_size;
                val_next := pvh
              end;
              pvh := pv;
              pv := nil; VAL_NEW( pv, ide_typ );
              with pv^ do
              begin                                            { Allocate the size of the main array }
                val_ival := typ_max;
                if ide_typ <> nil then val_size := ide_typ^.typ_size;
                val_next :=  pvh
              end;
              pvh := pv
            end;
            LGT_NEW( typ_idetab, p2, lgt_const, nil );
            VAL_NEW( typ_idetab^.lgt_cte, p2 );
            with typ_idetab^, lgt_cte^ do
            begin
              val_size := p2^.typ_size;
              val_lst  := pvh
            end;
            if typ_max > 255 then
            begin
              { Set appropriate size and alignement motion }
              if typ_max > 65535 then typ_size := 4
                                 else typ_size := 2
            end;
            { Get size and alignment specification in bits }
            sz  := typ_size;
            aln := sz - 1;
            SET_ALIGNMENT_SPC( sz, aln );
            if sy_init_mod and (sy = colon) then DATA_FORMAT_SET( p1 );
            if sz < typ_size then SRC_ERROR( mdnam, 214, e_error )
                             else typ_size := sz;
            if aln >= 0 then typ_align.int := aln
          end { with p1^ do };
          { Set the default conversion from any enumerate type }
          sy_type_gfirst := NEW_OPER( pcod_noop, p1, typ_std[form_ennum], cv_nop, [] )
       end;

      setsy:
        begin                                                   { Set Construction }
          INSYMBOL;                                             { Gobble up "set" }
          if sy = ofsy then INSYMBOL else SRC_ERROR( mdnam, 51, e_error );
          TYPE_SPC( p2, 0, nil, false, false );
          if p2^.typ_form > form_int then
          begin                                                 { The element type must be a fixed ennumerated type }
            SRC_ERROR( mdnam, 215, e_severe );
            p2 := typ_std[form_lit]                             { Set boolean type }
          end;
          { Get cardinality }
          i := p2^.typ_max + 1;
          if i > dst_seta then i := dst_seta;
          { Round up to a byte number }
          il := ( i + 7 ) div 8;
          { The possible set sizes are : 1, 2 or n*4 }
          if il > 2 then il := (( il + 3 ) div 4)*4;

          { Create a typ_rec descriptor }
          if i > dst_setw then
          begin                                                 { For large Set }
            IDE_NEW_TYP( form_lset, p1 );
            aln := typ_std[form_wlset]^.typ_align.int
          end
          else
          begin
            IDE_NEW_TYP( form_set, p1 );
            sz := 1;
            case il of
                1: aln := 0;
                2: aln := 1;
              3,4: aln := 3;
            otherwise
              aln := typ_std[form_wset]^.typ_align.int
            end
          end;
          with p1^ do
          begin
            typ_ide         := owid;
            typ_cardinality := i;
            typ_seltype     := p2;
            typ_size        := il;
            sz  := il;
            SET_ALIGNMENT_SPC( sz, aln );
            { Too small used size }
            if il > sz then
            begin
              SRC_ERROR( mdnam, 214, e_warning );
              sz := il
            end;
            { Set alignment and size }
            typ_size := sz;
            if aln >= 0 then typ_align.int := aln;
            {Set the Image tabble for the element type of a set of integer or char }
            if p2 <> nil then
            with p2^ do
              if typ_form = form_int then
              with usi_tab^ do
              begin
                LGT_NEW( typ_idetab, ide_typ, lgt_const, nil );
                VAl_COPY( ide_value, typ_idetab^.lgt_cte, false )
              end
              else if typ_form = form_char then
              with csi_tab^ do
              begin
                LGT_NEW( typ_idetab, ide_typ, lgt_const, nil);
                VAL_COPY( ide_value, typ_idetab^.lgt_cte, false )
              end
          end
        end;

      ifsy:
        begin
          SRC_ERROR( mdnam, 219, e_error );
          p1 := nil
        end;

      casesy:
        begin
          lgt1 := CASE_DEFINITION( intconst, nil );
          p1 := lgt1^.lgt_typ; LGT_FREE( lgt1 )
        end;

    otherwise
        begin
          p1 := nil;
          if sy = identsy then
          begin
            ip := IDE_SEARCH( [cla_type,cla_konst,cla_tparam,cla_generic] );
            p1 := ip^.ide_typ;
            if ip <> ide_udptr[cla_type] then                   { Declared object }
              { See if declared type }
              if ip^.ide_class = cla_type then
              begin
                p1 := ip^.ide_typ;
                INSYMBOL;                                       { Gobble up the identifier }
                { Import the synonymous generic definition }
                sy_type_gfirst := ip^.ide_gfirst;
                if sy = lparen then                             { Some arguments are given }
                begin
                  with ip^ do
                  if ide_typ^.typ_parmlst = nil then
                  begin                                         { Argument(s) given for a type without formal }
                    SRC_ERROR( mdnam, 206, e_error );
                    SKIP_SYMBOL( rparen )
                  end
                  else
                  begin
                    lgt := nil;
                    ip1 := ide_typ^.typ_parmlst;                { Get type arg. list head }
                    sy  := comma;
                    while ip1 <> nil do
                    begin                                       { Scan of the type arg. list }
                      if sy = comma then INSYMBOL;              { Gobble up "(" or "," }
                      if (sy = comma) or (sy = rparen) then     { Default value }
                        if ip1^.ide_cteval <> nil then
                        begin                                   { A default value is defined for this argument }
                          LGT_NEW( lgt1, ip1^.ide_typ, lgt_const, nil );
                          lgt1^.lgt_cte := ip1^.ide_cteval;
                          VAL_NEW( ip1^.ide_cteval, ip1^.ide_typ )
                        end
                        else SRC_ERROR_S( mdnam, 228, e_severe, ip1^.ide_name^ )
                      else                                      { A value type parameter is provided }
                        lgt1 := EXPRESSION_TYPE( ip1^.ide_typ );
                      { Link the parameter expression in a queue }
                      if lgt = nil then lgt := lgt1
                                   else lgt2^.lgt_nxt := lgt1;
                      lgt2 := lgt1;
                      ip1 := ip1^.ide_nxt                       { Skip to next one }
                    end;
                    if sy = rparen then INSYMBOL
                                   else SRC_ERROR( mdnam, 23, e_error );
                    p1 := TYPE_PARM_SET( ip, lgt )
                  end
                end
                else
                with ip^ do
                begin
                  if ide_typ^.typ_form = form_organization then
                  begin { The ip type must be private to be change in organization }
                    if sy = ofsy then
                    begin
                      INSYMBOL;                                 { Gobble up the "of" symbol }
                      iq := IDE_SEARCH( [cla_type] );
                      INSYMBOL;
                      if iq <> ide_udptr[cla_type] then         { Declared type }
                      begin
                        IDE_NEW_TYP( form_organization, p1 );
                        with p1^ do
                        begin
                          typ_parent      := ide_typ;
                          typ_eltype      := iq^.ide_typ;
                          typ_parmlst     := typ_eltype^.typ_parmlst;
                          typ_descr_size  := 0;
                          { Attach the organization generic function/procedure }
                          sy_type_gfirst  := ide_gfirst;
                          typ_comp_size   := nil;
                          typ_size        := ide_typ^.typ_size;
                          typ_hasidsc     := ide_typ^.typ_hasidsc;

                          {/// if typ_eltype^.typ_form <> form_record then SRC_ERROR( mdnam, 999, e_severe ) ///}
                        end
                      end
                    end
                    else
                      {/// if not buseorg then SRC_ERROR( mdnam, 999, e_severe ); ///}
                  end;
                  p1^.typ_hasidsc := ide_typ^.typ_hasidsc or (ide_typ^.typ_descr_size > 0)
                end
              end
              else p1 := nil
          end;

          if p1 = nil then                                      { Not a type identifier }
          begin                                                 { Range specification }
            { Get the minimum value, must be ennumerat type }
            lgt1 := EXPRESSION_TYPE( typ_std[form_ennum],,, true );
            if sy = twodot then INSYMBOL else SRC_ERROR( mdnam, 28, e_error );
            lgt2 := EXPRESSION_TYPE( lgt1^.lgt_typ,,, true );
            sz  := lgt1^.lgt_typ^.typ_size;
            aln := lgt1^.lgt_typ^.typ_align.int;
            SET_ALIGNMENT_SPC( sz, aln );                       { Get size and alignement in bytes }
            if sz < 4 then i := 2**(8*sz) else i := maxint;
            with lgt1^ do
              if (lgt_kind = lgt_const) and (lgt2^.lgt_kind = lgt_const) then
              begin                                             { Fixed range limits }
                IDE_NEW_TYP_RANGE( lgt_cte^.val_ival,
                                   lgt2^.lgt_cte^.val_ival, lgt_typ, p1 );

                if sy_init_mod and (sy = colon) then DATA_FORMAT_SET( p1 );
                LGT_FREE( lgt1 ); LGT_FREE( lgt2 );
                with p1^ do
                begin
                  typ_unsigned := ( typ_min >= 0 );
                  if sy_fix_range_ctl then
                  begin
                    if typ_unsigned then
                    begin
                      if typ_umin > typ_umax then
                      begin
                        typ_umax := typ_umin;
                        SRC_ERROR( mdnam, 211, e_error )
                      end
                    end
                    else
                      if typ_min > typ_max then
                      begin
                        typ_max := typ_min;
                        SRC_ERROR( mdnam, 211, e_error )
                      end;
                    if typ_unsigned then
                    begin
                      case sz of
                        1: i := 256;
                        2, 3: i := 65536;
                        Otherwise
                          i := maxint
                      end;
                      if sz < 4 then
                      if typ_umax >= i then
                      begin
                        typ_umax := i - 1; typ_umin := 0;
                        SRC_ERROR( mdnam, 212, e_error ); aln := 0
                      end
                    end
                    else
                    begin
                      case sz of
                        1: i := 128;
                        2, 3: i := 32768;
                        Otherwise
                          i := maxint
                      end;
                      if (typ_max >= i) or (typ_min < -i)  then
                      begin
                        sz := 4; typ_max := i-1; typ_min := -i;
                        SRC_ERROR( mdnam, 213, e_error ); aln := 0
                      end
                    end
                  end
                end
              end
              else
              begin                                            { Dynamic range limits }
                IDE_NEW_TYP( form_range, p1 );
                with p1^ do
                begin
                  typ_parent := lgt_typ;                       { Link with the parent type }
                  if sy_fix_range_ctl then                     { Any dyn. is legal for for index }
                  begin
                    TYPE_CHECK_PARM( lgt1 );                   { Check for legal range bounds }
                    TYPE_CHECK_PARM( lgt2 )
                  end;
                  if lgt2^.lgt_kind <> lgt_const then
                    { The variable max value must be linked for conversion }
                    typ_high := LGT_NEW_CODE( pcod_noop, lgt2 )
                  else
                    { The constant max value can be used directly }
                    typ_high := lgt2;

                  typ_high^.lgt_typ := p1;                     { Set the High value range type }
                  if lgt1^.lgt_kind = lgt_const then
                  with lgt1^ do
                  begin                                        { The low limit is a constante }
                    typ_low := lgt1;
                    lgt_typ :=   p1;                           { Set the Low value range type }
                    if lgt_cte^.val_ival = 1 then              { typ_high is el.# }
                      { High limit = number of element (always variable) }
                      typ_nvalue := LGT_NEW_CODE( pcod_noop, lgt2 )
                    else
                    begin                                      { We must substract (low - 1) }
                      { The low limit must be decrease from 1 before ... }
                      typ_high^.lgt_nxt := LGT_NEW_ECONST( typ_std[form_int],
                                                 lgt_cte^.val_ival - 1 );
                      { Substract from the variable high limit }
                      typ_nvalue := LGT_NEW_CODE( pcod_isub, typ_high )
                    end
                  end
                  else                                         { Low is variable }
                  begin
                    { Built a conversion link with the expression of min val. }
                    typ_low := LGT_NEW_CODE( pcod_noop, lgt1 );
                    typ_low^.lgt_typ := p1;
                    if lgt2^.lgt_kind = lgt_const then
                    { The high limit is a constante,
                        that be incremented before ... }
                    begin
                      i := lgt2^.lgt_cte^.val_ival + 1;
                      if i = 0 then
                        { Substract can be replace by a negate ... }
                        typ_nvalue := LGT_NEW_CODE( pcod_ineg, typ_high )
                      else
                      begin                                    { ... to substract the low limit }
                        lgt1 := LGT_NEW_ECONST( typ_std[form_int], i );
                        lgt1^.lgt_nxt := typ_low;
                        typ_nvalue := LGT_NEW_CODE( pcod_isub, lgt1 )
                      end
                    end
                    else
                    begin                                      { All limits are variable }
                      typ_high^.lgt_nxt := typ_low;
                      lgt1 := LGT_NEW_CODE( pcod_isub, typ_high );
                      typ_nvalue := LGT_NEW_CODE( pcod_succ, lgt1 )
                    end
                  end
                end
              end;

            { Set the (Dynamic/Static) Range Allocation Size and Alignement }
            with p1^ do
            begin
              typ_ide  := owid;
              typ_size := sz;
              if aln >= 0 then typ_align.int := aln
            end
          end
        end;

    end { case };
    it := p1;                                                  { Give final type descriptor pointer };
  end
end TYPE_SPC;

**********************************************************************************************************

**********************************************************************************************************



procedure TYPE_DECL;
const
  mdnam = 'TYPD';

var
  bnorec:                           boolean;
  i, sav_disp, isz, aln, maln, max: integer;
  umax:                            unsigned;
  ip, p1, p2, p3, ipa:              ide_ptr;
  it, q, q1:                        typ_ptr;
  lgt, lgt1, lgt2, lgt3:            lgt_ptr;
  chain:                            id_name;
  bh:                               boolean;

begin { TYPE_DECL }
  ident_disp := curr_disp;
  with sy_sym do
  begin
    if sy_init_mod then                                { In Compiler SetUp mode }
      while sy = withsy do
      begin
        INSYMBOL;                                      { Gobble up "with" }
        if sy = identsy then
        begin
          p1 := IDE_SEARCH( [cla_type] );              { Look for a defined type }
          if p1 <> nil then q := p1^.ide_typ
                       else q := nil;
          if q <> nil then
          begin
            INSYMBOL;                                  { Gobble up the type symbol }
            if sy = usesy then                         { Set a Size and Alignement specification }
            with q^ do
            begin
              isz := typ_size;
              aln := 0;
              SET_ALIGNMENT_SPC( isz, aln );
              typ_size := isz; typ_align.int := aln;

              if (typ_form = form_int) or
                 (typ_form = form_lit) or
                 (typ_form = form_char) then
                if isz < 4 then
                begin
                  if typ_unsigned then
                  begin { Only the integer can be use to calibrate the ennumerated types }
                    typ_umin := 0;
                    umax := 2**(8*isz);
                    if typ_umax > umax then typ_umax := umax - 1
                  end
                  else
                  begin
                    max := 2**(8*isz - 1);
                    if typ_max >= max then typ_max := max - 1;
                    if typ_min <= -max then typ_min := -max
                  end
                end
                else
                  if typ_unsigned then begin  typ_min := 0; typ_max := -1  end
                                  else begin  typ_max := maxint; typ_min := -typ_max - 1  end;

              case typ_form of
                form_int:
                  begin
                    inte_size := typ_size;
                    uns_typ^.typ_size      := typ_size;
                    uns_typ^.typ_align.int := typ_align.int
                  end;
                form_nil, form_pointer:
                  begin
                    fptr_size := typ_size;
                    typ_std[form_nil]^.typ_size          :=      typ_size;
                    typ_std[form_nil]^.typ_align.int     := typ_align.int;
                    typ_std[form_pointer]^.typ_size      :=      typ_size;
                    typ_std[form_pointer]^.typ_align.int := typ_align.int;
                    typ_std[form_pointer]^.typ_size      :=      typ_size;
                    typ_std[form_pointer]^.typ_align.int := typ_align.int;
                    typ_std[form_wfile]^.typ_size        :=      typ_size; { By default a file must be a kind of pointer }
                    typ_std[form_wfile]^.typ_align.int   := typ_align.int
                  end;
                form_single: sngl_size := typ_size;
                form_double: dble_size := typ_size;
                form_wwset, form_wset:
                  begin
                    dst_setw := typ_size*8;
                    dst_seti := (dst_seta + dst_setw - 1) div dst_setw;
                    typ_std[form_wlset]^.typ_align.int := typ_align.int;
                    typ_std[form_wwset]^.typ_align.int := typ_align.int;
                    typ_std[form_wset]^.typ_align.int  := typ_align.int;
                    typ_std[form_wwset]^.typ_size      := typ_size;
                    typ_std[form_wset]^.typ_size       := typ_size
                  end;
                form_wlset:
                  begin
                    dst_seta := typ_size*8;
                    dst_seti := (dst_seta + dst_setw - 1) div dst_setw;
                    typ_std[form_wwset]^.typ_align.int := typ_align.int;
                    typ_std[form_wset]^.typ_align.int  := typ_align.int
                  end;
                form_wfile:
                  begin
                    { The alignement of a file must be equal of pointer one }
                    maln := typ_std[form_pointer]^.typ_align.int;
                    if maln <> aln then typ_align.int := maln;
                    { The file size must be equal of multiple of pointer size }
                    maln := typ_std[form_wfile]^.typ_size;
                    if isz <> maln then
                    begin
                      if isz < maln then isz := maln
                        else if isz mod maln <> 0 then isz := maln*(isz div maln + 1);
                      typ_size := isz;
                    end;
                  end;

              otherwise
              end;
              if sy = colon then   DATA_FORMAT_SET( q );{ Set any target computer characteristics }

              if sy = semicolon then INSYMBOL
                                else SRC_ERROR( mdnam, 21, e_error )
            end
            else SKIP_SYMBOL( semicolon );
          end
          else
          begin { Unexisting type to modify }
            SRC_ERROR( mdnam, 8001, e_severe );
            SKIP_SYMBOL( semicolon )
          end
        end
        else
        begin
          SRC_ERROR( mdnam, 8002, e_severe );
          SKIP_SYMBOL( semicolon )
        end
      end;

    { * * * Normal Type declaration Flow * * * }

    while sy = identsy do                              { Loop on Definitions }
    begin
      p1 := fw_ptr; ip := nil;
      while (p1 <> nil) and (ip = nil) do
      begin
        with p1^ do
          if MATCH( ide_name^, sy_ident ) = 0 then
          begin
            ip := p1;                                  { Save the already created identifier }
            if p1 = fw_ptr then fw_ptr := fw_ptr^.ide_forlnk
            else p2^.ide_forlnk := p1^.ide_forlnk      { Take of from forward list }
          end;
        p2 := p1; p1 := p1^.ide_forlnk
      end;
      if ip = nil then
      begin
        { /// We should verify that the identifier is not a formal parameter /// }
        IDE_NEW( cla_type, nil, ip);                   { Create the type identifier }
        q := nil
      end
      else q := ip^.ide_typ;                           { Get the forward typ_rec address }
      with ip^ do
      begin
        sav_disp := curr_disp;                         { Save the display level }
        INSYMBOL;                                      { Get the "=" or "(" }
        isz := 0;
        if sy = lparen then                            { Get type parameter list }
        begin
          INSYMBOL;                                    { Gobble up "(" }
          NEW_DISP_LEVEL( nil, dsp_proc );             { Create a new display }
          VARBL_SETTING( cla_tparam, isz, maln, nil );
          p1 := lex_ident_tree[curr_disp].disp_tree;   { Get the parameter list }
          p3 := p1; { /// }
          lgt1 := nil;
          while p3 <> nil do
          begin { Loop on all type-parm. to build the def. parm. list value }
            LGT_NEW( lgt3, p3^.ide_typ, lgt_const, nil );
            lgt3^.lgt_cte := p3^.ide_cteval;
            VAL_NEW( lgt3^.lgt_cte, p3^.ide_typ );
            if lgt1 = nil then lgt1 := lgt3
                          else lgt2^.lgt_nxt := lgt3;
            lgt2 := lgt3;
            p3 := p3^.ide_nxt
          end
        end
        else p1 := nil;

        if (sy <> relop) or (op <> eq_op) then SRC_ERROR( mdnam, 30, e_error )
                                          else INSYMBOL;

%ifdef %OLD %then

        if sy = lbrack then
        begin { Handle the prefix type PASCAL II allocation class attribute }
          sy := comma;
          while sy = comma do
          begin
            INSYMBOL;                                  { Get the attribute }
            if sy = identsy then
            begin
              ipa := LEVEL_SEARCH( attr_list );
              INSYMBOL;
              if ipa <> nil then
              case ipa^.ide_attr of
(*              atts_hidden:   bh := true; *)
                atts_byte:     spc_asize    :=  1;
                atts_word:     spc_asize    :=  2;
                atts_long:     spc_asize    :=  4;
                atts_quad:     spc_asize    :=  8;
              otherwise
                SRC_ERROR_S( mdnam, 161, e_error, sy_ident )
              end
              else
                SRC_ERROR_S( mdnam, 167, e_error, sy_ident )
            end
            else
            begin
              SRC_ERROR( mdnam, 163, e_error );
              SKIP_SYMBOL( rbrack )
            end
          end;
          if sy = rbrack then INSYMBOL
                         else SRC_ERROR( mdnam, 26, e_error )
        end;

%else

        if sy = lbrack then SET_DECL_ATTRIBUTE( false );

%endif
        { Set the specified type descriptor pointer }
        TYPE_SPC( ide_typ, isz, p1, true, false );

        curr_disp  :=       sav_disp;                  { Restore the original display level }
        ide_gfirst := sy_type_gfirst;                  { Set the initial generic setting }
        ide_glast  :=            nil;                  { Link to previous type identifier definition }
        tcas_flag  :=          false;                  { Clear the Flag to signal a dynamic case in a record }
        with ide_typ^ do
        if p1 <> nil then
        begin                                          { For type with formal parameter(s) }
          { Set the appropriate alignement for the first no descr. object
            and for the whole of object }
          case typ_form of
            form_range, form_generic,
            form_set, form_lset, form_array, form_record:
              begin
                typ_descr_size := IDE_TYP_ALIGN( isz, ide_typ );
                typ_parmlst := p1;                     { Attach the type formal list to type here }
                if maln > ide_typ^.typ_align.int then
                  ide_typ^.typ_align.int := maln;
                if typ_size < 0 then
                begin
                  lgt := LGT_TYPE_EVAL( typ_comp_size, nil );
                  if lgt^.lgt_kind = lgt_const then
                  begin                                { To set a default size (Must be < 0) }
                    typ_size := - lgt^.lgt_cte^.val_ival;
                    { Force a negative value }
                    if typ_size >= 0 then typ_size := -1;
                    LGT_FREE( lgt )
                  end
                end
              end;
          otherwise
            { This type cannot have parameter }
            SRC_ERROR( mdnam, 205, e_severe )
          end;

          bnorec := (typ_form <> form_record);

          if bnorec then
          begin                                        { A descriptor size must be allocated }
            if typ_comp_size = nil then
              typ_size := typ_size + typ_descr_size
            else
            begin
              if typ_comp_size^.lgt_kind = lgt_const then
              begin
                with typ_comp_size^ do
                  if lgt_cte <> nil then
                    lgt_cte^.val_ival := lgt_cte^.val_ival + typ_descr_size
              end
              else
              begin
                typ_comp_size^.lgt_nxt := LGT_NEW_ECONST( typ_std[form_int],
                                                          typ_descr_size );
                typ_comp_size := LGT_NEW_CODE( pcod_iadd, typ_comp_size )
              end
            end
          end;

          if tcas_flag then LGT_GEN_ROUTINE( ide_typ ) { Build the Case related service routine }
        end;

        { ///  curr_disp := sav_disp;                  { /// Restore the original display level }
        with ide_typ^ do
          if typ_ide = nil then                        { When it is a copy type but a really new type ... }
          begin
            if typ_parent <> nil then                  { Get generic(s) of parent }
              if typ_parent^.typ_ide <> nil then       { If possible ... }
             (* sy_type_gfirst := typ_parent^.typ_ide^.ide_gfirst; *)
                ide_gfirst := typ_parent^.typ_ide^.ide_gfirst;
            typ_ide := ip                              { ... set the revers identifier pointer }
          end;

        if q <> nil then q^.typ_eltype := ide_typ;     { Resolve forward pointer }

        { Manage a type initial value when specified }
        if (sy = becomes) or (sy = valuesy) then
        begin
          INSYMBOL;                            { gobble up ":=" or "value" }
          if (sy = lbrack) or (sy = lparen) then lgt := GET_AGREGATE( ide_typ )
                                            else lgt := EXPRESSION_TYPE( ide_typ );
          if lgt^.lgt_kind <> lgt_const then
            SRC_ERROR( mdnam, 53, e_severe )

          else
          with lgt^ do
          begin
            ide_typ^.typ_inival := lgt_cte;
            lgt_cte := nil
          end;
          LGT_FREE_TREE( lgt )
        end;

        { Build an attached sub-type for each type with parameter }
        if (p1 <> nil) and(ide_typ <> nil) then
          { A type with parameters is defined }
          ide_typ^.typ_attsub := TYPE_PARM_SET( ip, lgt1 );
        if sy = semicolon then INSYMBOL
                          else SRC_ERROR( mdnam, 21, e_error )

(*
        ;DUMP_TYPES( 8, ide_typ )
*)
      end { With ip^ do }
    end { while }
  end { with sy_sym }
end TYPE_DECL;


