program TEST_FNC1;

type
    matrix( n, m: integer ) = array[1..m, 1..n] of integer;

var
    m1, m2, m3: matrix( 2, 2 );



function * ( mb, mc: matrix( 2, 2 ) ): matrix( 2, 2 );
var
    s:        integer;
    m: matrix( 2, 2 );

begin
    for i := 1 to 2 do
    for j := 1 to 2 do
    begin
        s := 0;
        for k := 1 to 2 do
            s := s + mb[i,k]*mc[k,j];
        function[i,j] := s
    end
end * ;



procedure := ( out_var tg: matrix( 2, 2 ); in_var sr: matrix( 2, 2 ) );
begin
    for i := 1 to 2 do
        for j := 1 to 2 do
            tg[i,j] := sr[i,j]
end := ;




procedure WRITE$OBJECT( in_var ma: matrix; f: integer := 6 );
var
    mm, mn: integer;

begin
    mm := ma.m; mn := ma.n;
    for i := 1 to mm do
    begin
        WRITE( ' ':8 );
        for j := 1 to ma.n do
        begin
            if j = 1 then WRITE( '| ' ) else WRITE( ', ' );
            WRITE( ma[i,j]:f );
        end;
        WRITELN( ' |' )
    end;
    WRITELN
end WRITE$OBJECT;




begin { MAIN }
    m2 := matrix[ 2, 2, [  0,  1 ],
                        [  1,  0 ]];
    m3 := matrix[ 2, 2, [  1,  0 ],
                        [  0, -1 ]];

    m1 := m2*m3;


    WRITELN( "\n     m2 =\n", m2:4, "\n\n" );

    WRITELN( "\n     m3 =\n", m3:4, "\n\n" );

    WRITELN( "\n     m1 = m2*m3 = \n", m1:4, "\n\n" );


end TEST_FNC1.
