{

*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                ---  Long Integer/Unsigned I/O ---                     *
*                                                                       *
*               ---  Version  3.1-B1 -- 07/03/2016 ---                  *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Louis Neel                                   *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{%pragma trace 0;}
module PAS__QUAD_IO;

const
  max_dig = 65;           { maximum of digit for a number }
  ln10    = 2.3025851249695E+00; { LN( 10.0 ) }
  ten = DOUBLE( 10 );     { Constant 10.0 in double }
  odt = 1.0/ten;          { Constant 0.1 in double }
  soh = CHR( 0 );         { NULL character SOH }

type
  lng_rec = record case boolean of
              false:(ival: long_integer);
              true: (uval: long_unsigned)
            end;

var

  [external 'PAS__curr_iptr'] curr_input: text; { The current input }


  procedure ERROR( nerr: cc__int );
  external 'PAS__ERROR';

  procedure READ_CURRENT_EOLN;
  external 'PAS__READ_EOLN';




procedure READ_LONG_VAL( var lv:       lng_rec; { Long integer/unsigned variable to read }
                             fld:      integer; { Maximum field to use or default  }
                             base:  byte := 10; { Base to use }
                             bs,                { Flag to skip spacing character '_' }
                             bu:       boolean  { Flag for unsigned number }
                       );
const
  in_min = ORD( 'a' ) - ORD( 'A' );

type
  mdtyp = ( mdspace, mdint, mdstop );

var
  idg, ier, nch, ndg:     integer := 0;
  bneg, bstp:         boolean := false;
  md:                 mdtyp := mdspace;
  ch:                             char;
  

begin { READ_LONG_VAL }
  repeat
    if UFB( curr_input ) then GET( curr_input );                { To manage the terminal input line }
  exit if CURRENT_EOF or ((md > mdspace) and CURRENT_EOLN);     { Signal the end of read stream }
    ch := curr_input^;                                          { Get one character }
    if (ch >= 'a') and (ch <= 'f') then ch := CHR( ORD( ch ) - in_min );        { Reduce the case of char range my major case character }
    if md < mdstop then
    case ch of
      '_':      { When allowed by bs = true, we ignore this character ... }
        if not bs then md := mdstop;

      '+', '-': { Get the sign of number (or of an exponant) when specified }
        if md = mdspace then
        begin
          if ch = '-' then
            if bu then begin  md := mdstop; ier := 1  end
                  else begin  md := mdint; bneg := true  end
        end
        else md := mdstop;

      '0'..'9',                
      'A'..'F': { Get and use each figure of the number }
        begin
          if ch > '9' then idg := ORD( ch ) - ORD( 'A' )  + 10
                      else idg := ORD( ch ) - ORD( '0' );
          if idg >= base then md := mdstop                      { Separator or illegal character }
          else
          begin
            md := mdint;
            if (idg > 0) or (ndg > 0) then
            with lv do
            begin     { Store all significant figures }
              if bu then uval := uval*base + idg
                    else ival := ival*base + idg;
              ndg := ndg + 1
            end
          end
        end;
      
    otherwise
      if md > mdspace then md := mdstop;                        { Stop the read and ignore any special character until field completion }
    end;
    nch := nch + 1
  until (nch = fld) or ((fld = 0) and (md = mdstop));
  if bu then begin  if bneg then lv.ival := - lv.ival  end      { Apply the negative sign when a signed integer was readden }
end READ_LONG_VAL;




[global 'PAS__READ_LUNS']
procedure READ_LONG_UNSIGNED( var lv:    long_unsigned; { Long integer variable to read }
                                  fld:   integer :=  0; { Maximum field to use or default  }
                                  base:     byte := 10; { Base to use }
                                  bs: boolean := false  { Flag to skip spacing character '_' }
                            );
var
  lng: lng_rec;

begin
  READ_LONG_VAL( lng, fld, base, bs, true );
  lv := lng.uval
end READ_LONG_UNSIGNED;



[global 'PAS__READ_LINT']
procedure READ_LONG_INTEGER( var lv:      long_integer; { Long integer variable to read }
                                 fld:    integer :=  0; { Maximum field to use or default  }
                                 base:      byte := 10; { Base to use }
                                 bs:  boolean := false  { Flag to skip spacing character '_' }
                          );
var
  lng: lng_rec;

begin
  READ_LONG_VAL( lng, fld, base, bs, false );
  lv := lng.ival
end READ_LONG_INTEGER;




procedure WRITE_LONG_VAL( lv: lng_rec; fld: integer; base, frq: byte; sch: char; bu: boolean );
var
  ivl:            long_integer;
  ditb:   array[1..65] of char;
  fch:                    char;
  dig, i, j, k:        integer;
  bneg:       boolean := false;

begin { WRITE_LONG_VAL }
  fch := ' ';
  with lv do
  begin
    if lv.ival = 0 then                         { 0 is a common value for unsigned and signed integer }
    begin { For zero integer number }
      ditb[1] := '0'; j := 1; bneg := false
    end
    else
    begin { <> 0 number }
      if not bu then if lv.ival < 0 then bneg := true;
      if (base < 2) or (base > 16) then base := 10;
      if bu then begin  dig := ABS( lv.uval rem base ); ivl := lv.uval div base  end
            else begin  dig := ABS( lv.uval rem base ); ivl := lv.ival div base  end;
      if dig > 9 then ditb[1] := CHR( dig + ORD( 'A' ) - 10 )
                 else ditb[1] := CHR( dig + ORD( '0' ) );
      j := 1;
      k := 1;
      while ivl <> 0 do
      begin
        if k = frq then begin  ditb[j] := sch; j := j + 1; k := 0  end;
        j := j + 1; k := k + 1;
        dig := ABS( ivl rem base );
        if dig > 9 then
          ditb[j] := CHR( dig + ORD( 'A' ) - 10 )
        else
          ditb[j] := CHR( dig + ORD( '0' ) );
        ivl := ivl div base
      end
    end;
    if fld = 0 then                             { We set the field in agreement of the number }
      fld := j + ORD( bneg )
    else
      if fld < 0 then
      begin                                     { We set the field as positive with "0' at left }
        fch := '0'; fld := - fld
      end;
    i :=  fld - j;                              { Get the number of digit at left }
    if bneg then i := i - 1;
    if i >= 0 then                              { If the write is possible }
    begin
      if bneg and (fch = '0') then WRITE$OBJECT( '-' );
      for ii := 1 to i do WRITE$OBJECT( fch );
      if bneg and (fch = ' ') then WRITE$OBJECT( '-' );
      while j > 0 do
      begin
        WRITE$OBJECT( ditb[j] ); j := j - 1
      end
    end
    else { Too small field }
      for ii := 1 to fld do  WRITE$OBJECT( '*' )
  end
end WRITE_LONG_VAL;



[global 'PAS__WRITE_LUNS']
procedure WRITE_LONG_UNSIGNED(       lv: long_unsigned; { Long_unsigned to write }
                                     f:  integer := 22; { Field to use }
                                     ba,                { Base to use }
                                     fr: byte    :=  0; { Frequency of spacing character }
                                     ch: char   := '_'  { Spacing character }
                      );
var
  lng: lng_rec;

begin
  lng.uval := lv;
  WRITE_LONG_VAL( lng, f, ba, fr, ch, true )
end WRITE_LONG_UNSIGNED;



[global 'PAS__WRITE_LINT']
procedure WRITE_LONG_INTEGER(        lv:  long_integer; { Long_integer to write }
                                     f:  integer := 22; { Field to use }
                                     ba,                { Base to use }
                                     fr: byte    :=  0; { Frequency of spacing character }
                                     ch: char   := '_'  { Spacing character }
                       );
var
  lng: lng_rec;

begin
  lng.ival := lv;
  WRITE_LONG_VAL( lng, f, ba, fr, ch, false )
end WRITE_LONG_INTEGER;




end PAS__QUAD_IO.
