/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 2800 ) = {{
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 75,  75,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,
 45,  51,  95,  50,  48,  50,  52,  45,  48,  54,  45,  48,  53,  47, 112,  99,
109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,  97, 115,   3,   3,  84,
 84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95,
116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,  29,  32,  84, 104, 101,
 32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111, 117, 114,  99, 101,  32,
 70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  17,  17,  99,
111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95, 115,  98, 116, 116, 108,
 33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  67,
111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100, 117, 108, 101,  32, 105,
115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101, 116, 107, 101, 121, 119,
111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101, 121, 119, 111, 114, 100,
 95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3, 120, 111, 114,   3,   3,
 97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100, 105, 118,   3,   3, 109,
111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,   3,   3, 110, 105, 108,
  5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111, 116, 111,   4,   4, 116,
121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,  14, 117, 115, 101, 114,
 95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,   3, 118,  97, 114,   6,
  6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117, 116,  95, 118,  97, 114,
  7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,  97,  99,  99, 101, 115,
115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114, 114,  97, 121,   6,   6,
114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,   3,   3, 117, 115, 101,
  3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,   7,   7, 100, 105, 115,
112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,   5, 114, 101, 115, 101,
116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,   6,  97, 112, 112, 101,
110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114, 101,  97, 100, 108, 110,
  5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114, 105, 116, 101,   7,   7,
119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114, 105, 116, 101, 118,   7,
  7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109, 111, 100, 117, 108, 101,
  9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,   8,   8, 102, 117, 110,
 99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117, 114, 110,   7,   7, 102,
111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97, 116, 105,  99,   6,   6,
104, 105, 100, 100, 101, 110,   6,   6, 101, 120, 112, 111, 114, 116,   6,   6,
103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99, 107, 101, 100,   6,   6,
101, 120, 112, 111, 114, 116,   8,   8, 101, 120, 116, 101, 114, 110,  97, 108,
  8,   8, 115, 116,  97, 110, 100,  97, 114, 100,   6,   6, 105, 110, 108, 105,
110, 101,   5,   5,  98, 101, 103, 105, 110,   2,   2, 105, 102,   4,   4, 116,
104, 101, 110,   4,   4, 101, 108, 115, 101,   5,   5, 119, 104, 105, 108, 101,
  6,   6, 114, 101, 112, 101,  97, 116,   5,   5, 117, 110, 116, 105, 108,   3,
  3, 102, 111, 114,   4,   4, 108, 111, 111, 112,   4,   4, 101, 120, 105, 116,
  4,   4,  99,  97, 115, 101,   4,   4, 119, 105, 116, 104,   3,   3, 101, 110,
100,   9,   9, 111, 116, 104, 101, 114, 119, 105, 115, 101,   2,   2, 111, 102,
  2,   2, 100, 111,   2,   2, 116, 111,   6,   6, 100, 111, 119, 110, 116, 111,
  7,   7,  37, 100, 101, 102, 105, 110, 101,   9,   9,  37, 117, 110, 100, 101,
102, 105, 110, 101,   4,   4,  37, 108, 101, 116,   3,   3,  37, 105, 102,   6,
  6,  37, 105, 102, 100, 101, 102,   8,   8,  37, 105, 102, 117, 110, 100, 101,
102,   5,   5,  37, 116, 104, 101, 110,   5,   5,  37, 101, 108, 115, 101,   5,
  5,  37, 101, 108, 105, 102,   6,   6,  37, 101, 110, 100, 105, 102,   8,   8,
 37, 109, 101, 115, 115,  97, 103, 101,   7,   7,  37,  99, 104,  97, 105, 110,
101,   8,   8,  37, 105, 110,  99, 108, 117, 100, 101,   7,   7,  37, 112, 114,
 97, 103, 109,  97,   4,   4,  37, 101, 111, 102,  16,  16,  99, 114, 101,  97,
116, 101,  95, 109,  97,  99,  95, 105, 100, 101, 110, 116,   4,   4,  67,  82,
 69,  77,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   7,   7, 115, 111, 114, 116, 109,  99,
 49,  15,  15, 114, 101,  98, 117, 105, 108, 100,  95, 109,  99, 116, 114, 101,
101,  49,  14,  14, 114, 101,  98, 117, 105, 108, 100,  95, 109,  99, 116, 114,
101, 101,   6,   6, 110, 101, 120, 116,  99, 104,   8,   8, 112, 117, 116,  95,
 99, 104,  97, 114,   4,   4,  73,  78,  83,  89,  12,  12, 116, 101, 115, 116,
 95, 102, 105, 103, 117, 114, 101, 115,   7,   7, 102, 105, 103, 117, 114, 101,
115,   4,   4,  70,  73,  71,  85,  11,  11, 111, 118, 102,  95, 104,  97, 110,
100, 108, 101, 114,  11,  11,  84, 111, 111,  32,  79,  86,  72,  32,  69,  82,
 82,  12,  12, 105, 110, 115, 121, 109,  98, 111, 108,  95, 115, 114,  99,  13,
 13, 115, 107, 105, 112,  95, 109,  99, 115, 121, 109,  98, 111, 108,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,
  4,   4,  77,  67,  83,  75,  16,  16,  99,  98,  95, 109,  97,  99, 114, 111,
 95, 109,  97, 110,  97, 103, 101, 114,  13,  13, 109,  97,  99, 114, 111,  95,
114, 101, 112, 108,  97,  99, 101,   4,   4,  77,  65,  67,  84,  19,  19, 100,
101, 102, 105, 110, 101,  95, 109,  97,  99, 114, 111,  95, 115, 121, 109,  98,
111, 108,   4,   4,  67,  82,  77,  83,   0,   0,   6,   0,   0,   0,   6,   0,
 21,  21, 117, 110, 100, 101, 102, 105, 110, 101,  95, 109,  97,  99, 114, 111,
 95, 115, 121, 109,  98, 111, 108,   4,   4,  82,  77,  77,  83,   0,   0,   0,
  0,   0,   6,   0,  19,  19, 109,  97,  99, 114, 111,  95,  97, 115, 115, 105,
103, 110,  95, 115, 121, 109,  98, 111, 108,   4,   4,  65,  83,  77,  83,   0,
  0,   0,   6,   0,   0,   0,   0,   0,   0,   1,   0,   0,  16,   0,   0,   0,
  9,   9, 115, 104, 111, 119,  95, 109, 118,  97, 108,  15,  15,  32,  69,  88,
 80,  95,  73,  68,  69,  78,  84,  32,  45,  62,  32,  91,   3,   0,   0,   0,
  8,   0,   8, 109, 118,  97, 108,  95, 105, 110, 116,   8, 109, 118,  97, 108,
 95, 115, 116, 114,   8, 109, 118,  97, 108,  95, 110, 117, 108,   8, 109, 118,
 97, 108,  95, 117, 110, 100,   4,   4,  44,  32, 105,  61,   5,   5,  44,  32,
115,  61,  34,   2,   2,  34,  93,  11,  11, 115, 104, 111, 119,  95, 109, 115,
116,  97,  99, 107,  15,  15,  32, 115, 116,  97,  99, 107,  58,  32, 115, 116,
107, 112,  32,  61,  32,   2,   2,  32,  91,   4,   4,  93,  32,  61,  32,   8,
  8, 109, 118,  97, 108,  95,  99, 111, 112,   9,   9, 109, 118,  97, 108,  95,
102, 114, 101, 101,   5,   5, 109, 112, 117, 115, 104,   4,   4,  77,  80,  85,
 83,   4,   4, 109, 112, 111, 112,   4,   4,  77,  80,  79,  80,  15,  15, 103,
101, 116,  95, 109,  97,  99, 114, 111,  95, 118,  97, 108, 117, 101,   9,   9,
109, 101, 120, 112,  95, 105, 110, 116, 118,  11,  11, 109, 101, 120, 112,  95,
118, 108,  95, 115, 116, 114,   9,   9, 109, 101, 120, 112,  95, 115, 116, 114,
118,   9,   9, 109, 101, 120, 112,  95,  99,  97, 108, 108,   4,   4,  77,  67,
 65,  76,   0,   0,   7, 100, 101, 102, 105, 110, 101, 100,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   1,   0,   0,   0,   6, 115, 117,  98, 115, 116, 114,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32, 253, 255, 255, 255,   5, 105, 110, 100,
101, 120,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   2,   0,   0,   0,
  5, 108, 101, 110, 103, 116, 104,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  1,   0,   0,   0,   8,  42,  42,  42,  42,  42,  42,  42,  42,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   0,   0,   0,   0,  10,  10, 109, 101, 120, 112,  95, 105,
100, 101, 110, 116,   4,   4,  77,  73,  68,  69,   0,   0,   0,   0,   4,   0,
 10,  10, 109, 101, 120, 112,  95,  98, 105, 110, 111, 112,   4,   4,  77,  66,
 73,  78,  10,  10, 109, 101, 120, 112,  95, 117, 110,  97, 111, 112,   4,   4,
 77,  85,  78,  65,   8,   8, 109, 101, 120, 112,  95, 117, 110,  97,   4,   4,
 77,  69,  88,  80,   8,   8, 109, 101, 120, 112,  95, 109, 117, 108,   8,   8,
109, 101, 120, 112,  95,  97, 100, 100,   8,   8, 109, 101, 120, 112,  95, 114,
101, 108,   8,   8, 109, 101, 120, 112,  95,  97, 110, 100,  12,  12, 109,  95,
101, 120, 112, 114,  95, 105, 110, 115, 116, 107,  10,  10, 109, 101, 120, 112,
114,  95, 115, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95, 105, 118,
 97, 108,  10,  10, 109, 101, 120, 112, 114,  95,  98, 118,  97, 108, 255,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  13,
 13, 112, 114,  97, 103, 109,  97,  95, 109, 115, 116,  97, 116, 101,   4,   4,
 80,  82,  65,  71,  14,  14, 105, 110,  99, 108, 117, 100, 101,  95, 109, 115,
116,  97, 116, 101,   4,   4,  46, 112,  97, 115,   4,   4,  73,  78,  67,  76,
 35,  35,  32,  42,  32,  84, 104, 101,  32,  99, 117, 114, 114, 101, 110, 116,
 32, 115, 111, 117, 114,  99, 101,  32, 102, 105, 108, 101,  32, 105, 115,  32,
110, 111, 119,  32,  34,  20,  20,  32,  79, 112, 101, 110,  32,  69, 114, 114,
111, 114,  32,  40,  82,  84,  76,  41,  32,  35,  32,  22,  22,  32, 102, 111,
114,  32, 116, 104, 101,  32,  83, 111, 117, 114,  99, 101,  32, 102, 105, 108,
101,  32,  58,  15,  15,  32,  82,  84,  76,  32, 109, 101, 115, 115,  97, 103,
101,  32,  58,  32,  14,  14, 101, 110, 100, 102, 105, 108, 101,  95, 109, 115,
116,  97, 116, 101,  35,  35,  32,  42,  32,  84, 104, 101,  32,  99, 117, 114,
114, 101, 110, 116,  32, 115, 111, 117, 114,  99, 101,  32, 102, 105, 108, 101,
 32, 105, 115,  32, 110, 111, 119,  32,  34,   8,   8,  99, 110, 100,  95, 112,
117, 115, 104,   4,   4,  71,  66,  83,  89,   7,   7,  99, 110, 100,  95, 112,
111, 112,   9,   9,  99, 110, 100,  95,  99, 104, 101,  99, 107,  10,  10, 109,
105, 102,  95, 109, 115, 116,  97, 116, 101,   4,   4,  77,  67,  73,  70,   8,
  8, 105, 110, 115, 121, 109,  98, 111, 108,   4,   4,  77,  83,  89,  77,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  28,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,
 15,  15,  42,  42,  42,  32,  77, 101, 115, 115,  97, 103, 101,  32,  42,  42,
 42,  21,  21,  32,  78, 111,  86,  97, 108,  32, 102, 111, 114,  32, 109,  97,
 99,  32, 115, 121, 109,  98,  32,  34,  11,  11, 115, 107, 105, 112,  95, 115,
121, 109,  98, 111, 108,  12,  12, 115, 107, 105, 112,  95, 109, 115, 121, 109,
 98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   1,   0,   0,   0,  64,   0,   0,   0,   0,   1,   0,
  0,   0,   0,   0,   0,   0,   2,   0,   9,   9, 105, 110, 115, 121,  95, 105,
110, 105, 116,   0,   0,  53,  53,  32,  80,  32,  65,  32,  83,  32,  45,  32,
 80,  46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,  79,  70,  84,  87,
 65,  82,  69,  58,  32,  86,  51,  46,  49,  45,  66,  53,  32,  79,  70,  32,
 51,  49,  45,  74,  65,  78,  45,  50,  48,  50,  50,  32,  12,  12,  99, 112,
 97, 115,  95,  99, 109, 112,  46, 101, 114, 114,   5,   5,  32,  80,  65,  83,
 62,  48,  48,  32,  42,  42,  42,  32,  80,  67,  77,  80,  45,  67,  80,  65,
 83,  45,  67,  79,  77,  80,  73,  76,  69,  82,  32,  69,  82,  82,  79,  82,
 58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101, 110,  32, 116, 104,
101,  32,  34,  15,  15,  34,  32, 105, 110, 105, 116, 105,  97, 108,  32, 102,
105, 108, 101,  46,  54,  54,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32, 102, 111, 114,  32, 116, 104, 101,  32, 116,  97, 114,
103, 101, 116,  32, 115, 121, 115, 116, 101, 109,  32,  34,  22,  22,  32,  80,
 65,  83,  32,  67,  65,  78,  78,  79,  84,  32,  79,  80,  69,  78,  32,  84,
 72,  69,  32,  34,  23,  23,  34,  32,  79,  85,  84,  80,  85,  84,  32,  77,
 83,  71,  47,  76,  73,  83,  84,  32,  70,  73,  76,  69,  46,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 1192 ) = {{
  0,   0,   0,   0,   0,   1,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   4,   5,   6,   7,   7,   7,  15,   6,  16,  17,  10,  18,
 19,  20,   9,  21,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  14,  22,
 11,  12,  13,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  23,
 24,  25,  26,   7,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   4,
  5,   4,   4,   3,  11,  20,  13,  29,  14,  29,   9,  11,  17,  29,   9,  12,
  8,   7,  18,  29,  15,  29,   6,   0,  16,  29,  23,  29,   0,   0,   0,   0,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10, 112,  99, 109, 112, 100, 101,  98,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11, 112,  99, 109, 112, 100, 101,  98,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  0,   0,   0,   0, 254,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 648 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern V V_macsymb_tree;
extern V V_macsymb_frst;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern UB V_sy_attrflg;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern V V_sy_macsymb;
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_src_openerr;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern Blk(V_cpas_ini_dir, 264 );
extern Blk(V_trg_env_fspc, 264 );
extern UB V_error_result;
extern UB V_emergency_stop;
extern Blk(V_trg_sys_name, 264 );
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp);
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp);
C P_src_return(UB F_bfree);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_skip_msymbol(V F_smb, UB F_rec_flg);
void P_binary_objf_close();
void P_generation_pragma();
void PAS_INSMBOL_get_macro_value(V F_vl);
void PAS_INSMBOL_m_expr_instk();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=171; /* line # 171 */
  if (F_icd>=0) {
    Ra.sl[72]=173; /* line # 173 */
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
    Ra.sl[72]=174; /* line # 174 */
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+93);
    Ra.sl[72]=175; /* line # 175 */
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[72]=177; /* line # 177 */
      if (V_srf_free==NULL) {
        Ra.sl[72]=178; /* line # 178 */
        Rv0=PAS__NEW(16);
      }
      else {
        Ra.sl[72]=180; /* line # 180 */
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Ra.sl[72]=181; /* line # 181 */
      Rv1=Rv0;
      Ra.sl[72]=183; /* line # 183 */
      ((V *)Rv1)[0]=V_srf_list;
      Ra.sl[72]=184; /* line # 184 */
      ((V *)Rv1)[1]=NULL;
      Ra.sl[72]=185; /* line # 185 */
      P_val_new(((V *)Rv1)+1,NULL);
      Ra.sl[72]=187; /* line # 187 */
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[72]=190; /* line # 190 */
      Rv2=V_srf_list;
      Ra.sl[72]=192; /* line # 192 */
      P_val_free(((V *)Rv2)+1);
      Ra.sl[72]=193; /* line # 193 */
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[72]=195; /* line # 195 */
    Rv3=((V *)V_srf_list)[1];
    Ra.sl[72]=197; /* line # 197 */
    ((UB *)Rv3)[48]=29;
    Ra.sl[72]=198; /* line # 198 */
    ((SL *)Rv3)[6]=Ra.ub[1];
    Ra.sl[72]=199; /* line # 199 */
    Rv4=Ra.ub[1];
    ((V *)Rv3)[7]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[7])[0]=Rv4;
    Ra.sl[72]=200; /* line # 200 */
    PAS__STR_TO_STR(((V *)Rv3)[7],Ra.s);
  }
  else {
    Ra.sl[72]=205; /* line # 205 */
    Rv0=V_srf_list;
    Ra.sl[72]=206; /* line # 206 */
    Rv5=Rv0;
    Ra.sl[72]=208; /* line # 208 */
    V_srf_list=((V *)Rv5)[0];
    Ra.sl[72]=209; /* line # 209 */
    P_val_free(((V *)Rv5)+1);
    Ra.sl[72]=210; /* line # 210 */
    ((V *)Rv5)[0]=V_srf_free;
    Ra.sl[72]=212; /* line # 212 */
    V_srf_free=Rv0;
  }
  Ra.sl[72]=214; /* line # 214 */
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+98;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=235; /* line # 235 */
  Rv0=V_lst_current;
  Ra.sl[72]=237; /* line # 237 */
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  Ra.sl[72]=238; /* line # 238 */
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
  Ra.sl[72]=239; /* line # 239 */
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+117);
  Ra.sl[72]=240; /* line # 240 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.s+
122,Ra.s),Rd.s+153));
  Ra.sl[72]=241; /* line # 241 */
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  Ra.sl[72]=242; /* line # 242 */
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+157;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=258; /* line # 258 */
  Rv0=V_lst_current;
  Ra.sl[72]=260; /* line # 260 */
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  Ra.sl[72]=261; /* line # 261 */
  if (((V *)F_prc)[3]!=NULL) {
    Ra.sl[72]=262; /* line # 262 */
    Rv1=((V *)F_prc)[3];
    Ra.sl[72]=264; /* line # 264 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+292,Rv1+1,31,1,((UB *)Rv1)[0]));
    Ra.sl[72]=265; /* line # 265 */
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.
    s+176,Ra.s),Rd.s+211));
    Ra.sl[72]=266; /* line # 266 */
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    Ra.sl[72]=267; /* line # 267 */
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=293; /* line # 293 */
  Rv0=PAS__NEW(50);
  Ra.sl[6]=294; /* line # 294 */
  Rv1=Rv0;
  Ra.sl[6]=296; /* line # 296 */
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Ra.sl[6]=297; /* line # 297 */
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[6]=298; /* line # 298 */
  ((V *)Rv1)[4]=NULL;
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=299; /* line # 299 */
  ((UB *)Rv1)[48]=F_skw;
  ((UB *)Rv1)[49]=F_opkw;
  Ra.sl[6]=301; /* line # 301 */
  Rv3=V_keyword_tree;
  Ra.sl[6]=302; /* line # 302 */
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[6]=305; /* line # 305 */
      Rv4=Rv3;
      Ra.sl[6]=306; /* line # 306 */
      Rv5=Rv3;
      Ra.sl[6]=308; /* line # 308 */
      Rv6=P_match(Rv0,Rv5);
      Ra.sl[6]=309; /* line # 309 */
      if (Rv6>0) Rv3=((V *)Rv5)[5];
      else {
        Ra.sl[6]=310; /* line # 310 */
        Rv3=((V *)Rv5)[4];
      }
      if (Rv3==NULL)  break;
    }
    Ra.sl[6]=313; /* line # 313 */
    if (Rv6>0) ((V *)Rv4)[5]=Rv0;
    else {
      Ra.sl[6]=314; /* line # 314 */
      ((V *)Rv4)[4]=Rv0;
    }
  }
  else {
    Ra.sl[6]=316; /* line # 316 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+227;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=322; /* line # 322 */
  PAS_INSMBOL_PRC_00000000(Rd.s+245,12,21);
  Ra.sl[6]=323; /* line # 323 */
  PAS_INSMBOL_PRC_00000000(Rd.s+249,12,22);
  Ra.sl[6]=324; /* line # 324 */
  PAS_INSMBOL_PRC_00000000(Rd.s+254,11,20);
  Ra.sl[6]=325; /* line # 325 */
  PAS_INSMBOL_PRC_00000000(Rd.s+259,6,0);
  Ra.sl[6]=326; /* line # 326 */
  PAS_INSMBOL_PRC_00000000(Rd.s+264,8,8);
  Ra.sl[6]=327; /* line # 327 */
  PAS_INSMBOL_PRC_00000000(Rd.s+269,8,9);
  Ra.sl[6]=328; /* line # 328 */
  PAS_INSMBOL_PRC_00000000(Rd.s+274,8,10);
  Ra.sl[6]=329; /* line # 329 */
  PAS_INSMBOL_PRC_00000000(Rd.s+279,10,23);
  Ra.sl[6]=333; /* line # 333 */
  PAS_INSMBOL_PRC_00000000(Rd.s+283,27,29);
  Ra.sl[6]=334; /* line # 334 */
  PAS_INSMBOL_PRC_00000000(Rd.s+288,32,29);
  Ra.sl[6]=335; /* line # 335 */
  PAS_INSMBOL_PRC_00000000(Rd.s+295,33,29);
  Ra.sl[6]=336; /* line # 336 */
  PAS_INSMBOL_PRC_00000000(Rd.s+301,29,29);
  Ra.sl[6]=337; /* line # 337 */
  PAS_INSMBOL_PRC_00000000(Rd.s+307,28,29);
  Ra.sl[6]=338; /* line # 338 */
  PAS_INSMBOL_PRC_00000000(Rd.s+314,31,29);
  Ra.sl[6]=340; /* line # 340 */
  PAS_INSMBOL_PRC_00000000(Rd.s+330,30,29);
  Ra.sl[6]=341; /* line # 341 */
  PAS_INSMBOL_PRC_00000000(Rd.s+335,35,29);
  Ra.sl[6]=342; /* line # 342 */
  PAS_INSMBOL_PRC_00000000(Rd.s+343,36,29);
  Ra.sl[6]=343; /* line # 343 */
  PAS_INSMBOL_PRC_00000000(Rd.s+352,43,29);
  Ra.sl[6]=344; /* line # 344 */
  PAS_INSMBOL_PRC_00000000(Rd.s+361,38,29);
  Ra.sl[6]=345; /* line # 345 */
  PAS_INSMBOL_PRC_00000000(Rd.s+369,39,29);
  Ra.sl[6]=346; /* line # 346 */
  PAS_INSMBOL_PRC_00000000(Rd.s+375,40,29);
  Ra.sl[6]=347; /* line # 347 */
  PAS_INSMBOL_PRC_00000000(Rd.s+382,41,29);
  Ra.sl[6]=348; /* line # 348 */
  PAS_INSMBOL_PRC_00000000(Rd.s+390,42,29);
  Ra.sl[6]=349; /* line # 349 */
  PAS_INSMBOL_PRC_00000000(Rd.s+395,73,29);
  Ra.sl[6]=350; /* line # 350 */
  PAS_INSMBOL_PRC_00000000(Rd.s+400,58,29);
  Ra.sl[6]=351; /* line # 351 */
  PAS_INSMBOL_PRC_00000000(Rd.s+405,59,29);
  Ra.sl[6]=352; /* line # 352 */
  PAS_INSMBOL_PRC_00000000(Rd.s+411,60,29);
  Ra.sl[6]=353; /* line # 353 */
  PAS_INSMBOL_PRC_00000000(Rd.s+420,61,29);
  Ra.sl[6]=354; /* line # 354 */
  PAS_INSMBOL_PRC_00000000(Rd.s+426,62,29);
  Ra.sl[6]=355; /* line # 355 */
  PAS_INSMBOL_PRC_00000000(Rd.s+433,63,29);
  Ra.sl[6]=356; /* line # 356 */
  PAS_INSMBOL_PRC_00000000(Rd.s+442,64,29);
  Ra.sl[6]=358; /* line # 358 */
  PAS_INSMBOL_PRC_00000000(Rd.s+450,65,29);
  Ra.sl[6]=359; /* line # 359 */
  PAS_INSMBOL_PRC_00000000(Rd.s+456,66,29);
  Ra.sl[6]=360; /* line # 360 */
  PAS_INSMBOL_PRC_00000000(Rd.s+464,67,29);
  Ra.sl[6]=361; /* line # 361 */
  PAS_INSMBOL_PRC_00000000(Rd.s+471,68,29);
  Ra.sl[6]=362; /* line # 362 */
  PAS_INSMBOL_PRC_00000000(Rd.s+478,69,29);
  Ra.sl[6]=363; /* line # 363 */
  PAS_INSMBOL_PRC_00000000(Rd.s+487,70,29);
  Ra.sl[6]=365; /* line # 365 */
  PAS_INSMBOL_PRC_00000000(Rd.s+495,75,29);
  Ra.sl[6]=366; /* line # 366 */
  PAS_INSMBOL_PRC_00000000(Rd.s+504,74,29);
  Ra.sl[6]=367; /* line # 367 */
  PAS_INSMBOL_PRC_00000000(Rd.s+512,76,29);
  Ra.sl[6]=368; /* line # 368 */
  PAS_INSMBOL_PRC_00000000(Rd.s+523,77,29);
  Ra.sl[6]=369; /* line # 369 */
  PAS_INSMBOL_PRC_00000000(Rd.s+533,78,29);
  Ra.sl[6]=370; /* line # 370 */
  PAS_INSMBOL_PRC_00000000(Rd.s+541,79,29);
  Ra.sl[6]=371; /* line # 371 */
  PAS_INSMBOL_PRC_00000000(Rd.s+550,80,29);
  Ra.sl[6]=372; /* line # 372 */
  PAS_INSMBOL_PRC_00000000(Rd.s+558,81,29);
  Ra.sl[6]=373; /* line # 373 */
  PAS_INSMBOL_PRC_00000000(Rd.s+566,82,29);
  Ra.sl[6]=375; /* line # 375 */
  PAS_INSMBOL_PRC_00000000(Rd.s+574,84,29);
  Ra.sl[6]=376; /* line # 376 */
  PAS_INSMBOL_PRC_00000000(Rd.s+582,37,29);
  Ra.sl[6]=377; /* line # 377 */
  PAS_INSMBOL_PRC_00000000(Rd.s+590,82,29);
  Ra.sl[6]=378; /* line # 378 */
  PAS_INSMBOL_PRC_00000000(Rd.s+598,83,29);
  Ra.sl[6]=379; /* line # 379 */
  PAS_INSMBOL_PRC_00000000(Rd.s+608,85,29);
  Ra.sl[6]=380; /* line # 380 */
  PAS_INSMBOL_PRC_00000000(Rd.s+618,86,29);
  Ra.sl[6]=382; /* line # 382 */
  PAS_INSMBOL_PRC_00000000(Rd.s+626,71,29);
  Ra.sl[6]=383; /* line # 383 */
  PAS_INSMBOL_PRC_00000000(Rd.s+633,44,29);
  Ra.sl[6]=384; /* line # 384 */
  PAS_INSMBOL_PRC_00000000(Rd.s+637,45,29);
  Ra.sl[6]=385; /* line # 385 */
  PAS_INSMBOL_PRC_00000000(Rd.s+643,46,29);
  Ra.sl[6]=386; /* line # 386 */
  PAS_INSMBOL_PRC_00000000(Rd.s+649,47,29);
  Ra.sl[6]=387; /* line # 387 */
  PAS_INSMBOL_PRC_00000000(Rd.s+656,48,29);
  Ra.sl[6]=388; /* line # 388 */
  PAS_INSMBOL_PRC_00000000(Rd.s+664,49,29);
  Ra.sl[6]=389; /* line # 389 */
  PAS_INSMBOL_PRC_00000000(Rd.s+671,50,29);
  Ra.sl[6]=390; /* line # 390 */
  PAS_INSMBOL_PRC_00000000(Rd.s+676,54,29);
  Ra.sl[6]=391; /* line # 391 */
  PAS_INSMBOL_PRC_00000000(Rd.s+682,55,29);
  Ra.sl[6]=392; /* line # 392 */
  PAS_INSMBOL_PRC_00000000(Rd.s+688,56,29);
  Ra.sl[6]=393; /* line # 393 */
  PAS_INSMBOL_PRC_00000000(Rd.s+694,57,29);
  Ra.sl[6]=394; /* line # 394 */
  PAS_INSMBOL_PRC_00000000(Rd.s+700,72,29);
  Ra.sl[6]=395; /* line # 395 */
  PAS_INSMBOL_PRC_00000000(Rd.s+705,88,29);
  Ra.sl[6]=396; /* line # 396 */
  PAS_INSMBOL_PRC_00000000(Rd.s+716,87,29);
  Ra.sl[6]=397; /* line # 397 */
  PAS_INSMBOL_PRC_00000000(Rd.s+720,53,29);
  Ra.sl[6]=398; /* line # 398 */
  PAS_INSMBOL_PRC_00000000(Rd.s+724,51,29);
  Ra.sl[6]=399; /* line # 399 */
  PAS_INSMBOL_PRC_00000000(Rd.s+728,52,29);
  Ra.sl[6]=401; /* line # 401 */
  PAS_INSMBOL_PRC_00000000(Rd.s+736,91,29);
  Ra.sl[6]=402; /* line # 402 */
  PAS_INSMBOL_PRC_00000000(Rd.s+745,92,29);
  Ra.sl[6]=403; /* line # 403 */
  PAS_INSMBOL_PRC_00000000(Rd.s+756,93,29);
  Ra.sl[6]=404; /* line # 404 */
  PAS_INSMBOL_PRC_00000000(Rd.s+762,94,29);
  Ra.sl[6]=405; /* line # 405 */
  PAS_INSMBOL_PRC_00000000(Rd.s+767,95,29);
  Ra.sl[6]=406; /* line # 406 */
  PAS_INSMBOL_PRC_00000000(Rd.s+775,96,29);
  Ra.sl[6]=407; /* line # 407 */
  PAS_INSMBOL_PRC_00000000(Rd.s+785,97,29);
  Ra.sl[6]=408; /* line # 408 */
  PAS_INSMBOL_PRC_00000000(Rd.s+792,98,29);
  Ra.sl[6]=409; /* line # 409 */
  PAS_INSMBOL_PRC_00000000(Rd.s+799,99,29);
  Ra.sl[6]=410; /* line # 410 */
  PAS_INSMBOL_PRC_00000000(Rd.s+806,100,29);
  Ra.sl[6]=412; /* line # 412 */
  PAS_INSMBOL_PRC_00000000(Rd.s+814,102,29);
  Ra.sl[6]=413; /* line # 413 */
  PAS_INSMBOL_PRC_00000000(Rd.s+824,104,29);
  Ra.sl[6]=414; /* line # 414 */
  PAS_INSMBOL_PRC_00000000(Rd.s+833,103,29);
  Ra.sl[6]=415; /* line # 415 */
  PAS_INSMBOL_PRC_00000000(Rd.s+843,105,29);
  Ra.sl[6]=420; /* line # 420 */
  PAS_INSMBOL_PRC_00000000(Rd.s+852,106,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_mac_ident "  */
V P_create_mac_ident(V F_id, UB F_cmdf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+858;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=440; /* line # 440 */
  Rv0=V_macsymb_tree;
  Ra.sl[6]=441; /* line # 441 */
  Rv1=NULL;
  Ra.sl[6]=442; /* line # 442 */
  Rv2=1;
  Ra.sl[6]=443; /* line # 443 */
  while (Rv0!=NULL&&Rv2!=0){
    Ra.sl[6]=445; /* line # 445 */
    Rv1=Rv0;
    Ra.sl[6]=446; /* line # 446 */
    Rv3=Rv0;
    Ra.sl[6]=448; /* line # 448 */
    Rv2=P_match(F_id,Rv3);
    Ra.sl[6]=449; /* line # 449 */
    if (Rv2!=0) {
      Ra.sl[6]=450; /* line # 450 */
      if (Rv2>0) Rv0=((V *)Rv3)[6];
      else {
        Ra.sl[6]=451; /* line # 451 */
        Rv0=((V *)Rv3)[5];
      }
    }
  }
  Ra.sl[6]=454; /* line # 454 */
  if (Rv2==0) {
    Ra.sl[6]=455; /* line # 455 */
    if (F_cmdf) Rv4=Rv0;
    else {
      Ra.sl[6]=456; /* line # 456 */
      P_src_error_s(Rd.s+878,921,2, F_id,NULL);
    }
  }
  else {
    Ra.sl[6]=459; /* line # 459 */
    Rv4=PAS__NEW(80);
    Ra.sl[6]=460; /* line # 460 */
    Rv5=Rv4;
    Ra.sl[6]=462; /* line # 462 */
    memcpy(Rv5,F_id,32);
    Ra.sl[6]=463; /* line # 463 */
    ((V *)Rv5)[4]=NULL;
    Ra.sl[6]=464; /* line # 464 */
    ((V *)Rv5)[5]=NULL;
    Ra.sl[6]=465; /* line # 465 */
    ((V *)Rv5)[6]=NULL;
    Ra.sl[6]=466; /* line # 466 */
    ((UB *)Rv5)[56]=0;
    Ra.sl[6]=467; /* line # 467 */
    memcpy(Rv5+64,Rd.s+888,16);
    Ra.sl[6]=469; /* line # 469 */
    if (Rv1==NULL) {
      Ra.sl[6]=470; /* line # 470 */
      V_macsymb_tree=Rv4;
    }
    else {
      Ra.sl[6]=472; /* line # 472 */
      if (Rv2>0) ((V *)Rv1)[6]=Rv4;
      else {
        Ra.sl[6]=473; /* line # 473 */
        ((V *)Rv1)[5]=Rv4;
      }
    }
  }
  Ra.sl[6]=475; /* line # 475 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sortmc1 "  */
void PAS_INSMBOL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+904;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=502; /* line # 502 */
  Rv0=F_p;
  Ra.sl[6]=504; /* line # 504 */
  if (((V *)Rv0)[5]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[5]);
  Ra.sl[6]=505; /* line # 505 */
  Rv1=((UB *)Rv0)[0]==0;
  Ra.sl[6]=506; /* line # 506 */
  if (!Rv1) {
    Ra.sl[6]=508; /* line # 508 */
    if (V_macsymb_frst==NULL) V_macsymb_frst=F_p;
    else {
      Ra.sl[6]=509; /* line # 509 */
      ((V *)Lx[0].v[0])[4]=F_p;
    }
    Ra.sl[6]=510; /* line # 510 */
    Lx[0].v[0]=F_p;
    Ra.sl[6]=511; /* line # 511 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=512; /* line # 512 */
    Lx[0].sl[2]=Lx[0].sl[2]+1;
  }
  Ra.sl[6]=514; /* line # 514 */
  if (((V *)Rv0)[6]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[6]);
  Ra.sl[6]=516; /* line # 516 */
  if (Rv1) {
    Ra.sl[6]=518; /* line # 518 */
    Rv2=F_p;
    Rv3=Rv2+64;
    Ra.sl[6]=519; /* line # 519 */
    if (((V *)Rv3)[1]!=NULL) PAS__DISPOSE(((V *)Rv3)+1);
    Ra.sl[6]=520; /* line # 520 */
    PAS__DISPOSE(&F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rebuild_mctree1 "  */
V PAS_INSMBOL_PRC_00000002(SL F_n, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+913;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=533; /* line # 533 */
  Rv0=(F_n+F_m)/2;
  Ra.sl[6]=534; /* line # 534 */
  Rv1=((V *)Lx[0].v[2])[Rv0];
  Ra.sl[6]=535; /* line # 535 */
  Rv2=Rv1;
  Ra.sl[6]=537; /* line # 537 */
  if (Rv0==F_n) ((V *)Rv2)[5]=NULL;
  else {
    Ra.sl[6]=538; /* line # 538 */
    ((V *)Rv2)[5]=PAS_INSMBOL_PRC_00000002(F_n, Rv0-1);
  }
  Ra.sl[6]=539; /* line # 539 */
  if (Rv0==F_m) ((V *)Rv2)[6]=NULL;
  else {
    Ra.sl[6]=540; /* line # 540 */
    ((V *)Rv2)[6]=PAS_INSMBOL_PRC_00000002(Rv0+1, F_m);
  }
  Ra.sl[6]=542; /* line # 542 */
  Ret=Rv1;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rebuild_mctree "  */
void P_rebuild_mctree(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+930;
  Ra.v[5]=Rd.s+16;
  Ra.sl[12]=548; /* line # 548 */
  Ra.sl[2]=0;
  Ra.sl[12]=549; /* line # 549 */
  V_macsymb_frst=NULL;
  Ra.sl[12]=550; /* line # 550 */
  if (V_macsymb_tree!=NULL) {
    Ra.sl[12]=552; /* line # 552 */
    PAS_INSMBOL_PRC_00000001(V_macsymb_tree);
    Ra.sl[12]=553; /* line # 553 */
    if (Ra.sl[2]>0) {
      Ra.sl[12]=555; /* line # 555 */
      Ra.v[0]=V_macsymb_frst;
      Ra.sl[12]=556; /* line # 556 */
      Rv0=Ra.sl[2];
      Ra.v[2]=PAS__NEW(Rv0*8+8);
      ((SL *)Ra.v[2])[0]=Rv0;
      Ra.sl[12]=557; /* line # 557 */
      Rv1=1;
      for( Rf0=Ra.sl[2];Rf0>0;Rf0-- ) {
        Ra.sl[12]=558; /* line # 558 */
        ((V *)Ra.v[2])[Rv1]=Ra.v[0];
        Ra.v[0]=((V *)Ra.v[0])[4];
        Rv1++;
      }
      Ra.sl[12]=560; /* line # 560 */
      V_macsymb_tree=PAS_INSMBOL_PRC_00000002(1, Ra.sl[2]);
    }
    else {
      Ra.sl[12]=564; /* line # 564 */
      V_macsymb_tree=NULL;
      Ra.sl[12]=565; /* line # 565 */
      V_macsymb_frst=NULL;
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+946;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=652; /* line # 652 */
  V_sy_ch=P_src_inchar();
  Ra.sl[6]=653; /* line # 653 */
  V_sy_cmin=V_sy_ch;
  Ra.sl[6]=654; /* line # 654 */
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  Ra.sl[6]=655; /* line # 655 */
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+954;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=661; /* line # 661 */
  if (!Rs.ub[0]) {
    Ra.sl[6]=662; /* line # 662 */
    if (Rs.sl[1]<V_sy_string.ub[0]) {
      Ra.sl[6]=664; /* line # 664 */
      V_sy_string.c[Rs.sl[1]+1]=V_sy_ch;
      Ra.sl[6]=665; /* line # 665 */
      Rs.sl[1]=Rs.sl[1]+1;
    }
    else {
      Ra.sl[6]=669; /* line # 669 */
      P_src_error(Rd.s+966,12,2);
      Ra.sl[6]=670; /* line # 670 */
      Rs.ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000005(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+970;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=680; /* line # 680 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    Ra.sl[6]=682; /* line # 682 */
    if ((Rs.ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else {
      Ra.sl[6]=683; /* line # 683 */
      Rv0=-1;
    }
  }
  Ra.sl[6]=684; /* line # 684 */
  if (Rv0>=Rs.sl[3]) Rv0=-2;
  Ra.sl[6]=685; /* line # 685 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000006(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+984;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=696; /* line # 696 */
  Rv0=PAS_INSMBOL_PRC_00000005(F_ch);
  Ra.sl[6]=697; /* line # 697 */
  if (Rv0==-2) {
    Ra.sl[6]=699; /* line # 699 */
    Rv0=0;
    P_src_error(Rd.s+995,16,2);
  }
  Ra.sl[6]=701; /* line # 701 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000007(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+999;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=711; /* line # 711 */
  Ri.sl[0]=Ri.sl[0]+1;
  Ra.sl[6]=712; /* line # 712 */
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1012,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  Ra.sl[6]=713; /* line # 713 */
  if (F_ierr>=20&&F_ierr<=25) {
    Ra.sl[6]=715; /* line # 715 */
    if (!Rs.ub[16]) {
      Ra.sl[6]=717; /* line # 717 */
      P_src_error(Rd.s+966,11,2);
      Ra.sl[6]=718; /* line # 718 */
      Rs.g[3]=1.000000000000000E+000;
      Rs.g[4]=1.000000000000000E+000;
      Ra.sl[6]=719; /* line # 719 */
      Rs.ub[16]=1;
    }
    Ra.sl[6]=721; /* line # 721 */
    Ret=1;
  }
  else {
    Ra.sl[6]=724; /* line # 724 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1025;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=730; /* line # 730 */
  while (V_sy_ch==32||V_sy_ch==0)
  PAS_INSMBOL_PRC_00000003();
  Ra.sl[6]=731; /* line # 731 */
  Rs.ub[40]=1;
  Ra.sl[6]=732; /* line # 732 */
  Rs.ub[41]=V_sy_attrflg;
  Ra.sl[6]=733; /* line # 733 */
  V_sy_attrflg=0;
  Ra.sl[6]=734; /* line # 734 */
  Rv0=V_src_control;
  ((SL *)Rv0)[4]=((SL *)Rv0)[5];
  Ra.sl[6]=735; /* line # 735 */
  Ra.sl[6]=736; /* line # 736 */
  switch (Ri.ub[V_sy_cmin+4]) {
    case 8:
    case 9:Ra.sl[6]=739; /* line # 739 */
    PAS__ESTABLISH(PAS_INSMBOL_PRC_00000007);
    Ra.sl[6]=740; /* line # 740 */
    Rs.ub[16]=0;
    Ra.sl[6]=741; /* line # 741 */
    V_sy_sym.ub[0]=19;
    Ra.sl[6]=742; /* line # 742 */
    V_sy_sym.ub[1]=29;
    Ra.sl[6]=743; /* line # 743 */
    Rs.g[6]=0.000000000000000E-001;
    Ra.sl[6]=744; /* line # 744 */
    Rs.sl[3]=10;
    Ra.sl[6]=745; /* line # 745 */
    Rs.sl[14]=0;
    Ra.sl[6]=746; /* line # 746 */
    Rs.ub[8]=0;
    Ra.sl[6]=747; /* line # 747 */
    while (Ri.ub[V_sy_cmin+4]==8){
      Ra.sl[6]=749; /* line # 749 */
      V_sy_sym.ub[0]=2;
      Ra.sl[6]=750; /* line # 750 */
      Rs.sl[15]=(SL)V_sy_cmin-48;
      Ra.sl[6]=751; /* line # 751 */
      if (Rs.sl[14]>0||Rs.sl[15]>0) Rs.sl[14]=Rs.sl[14]+1;
      while (1){
        Ra.sl[6]=752; /* line # 752 */
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_cmin!=95)  break;
      }
      Ra.sl[6]=753; /* line # 753 */
      if (!Rs.ub[16]) Rs.g[6]=Rs.g[6]*1.000000000000000E+001+(double)Rs.sl[15];
    }
    Ra.sl[6]=756; /* line # 756 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Ra.sl[6]=758; /* line # 758 */
      Rs.sl[14]=0;
      Ra.sl[6]=759; /* line # 759 */
      Rs.sl[3]=PAS__G_ROUND(Rs.g[6]);
      Ra.sl[6]=760; /* line # 760 */
      if (Rs.sl[3]<2||Rs.sl[3]>16) {
        Ra.sl[6]=762; /* line # 762 */
        P_src_error(Rd.s+966,14,2);
        Ra.sl[6]=763; /* line # 763 */
        Rs.sl[3]=10;
      }
      Ra.sl[6]=765; /* line # 765 */
      Rs.ub[8]=1;
      Ra.sl[6]=766; /* line # 766 */
      Rs.g[6]=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[6]=768; /* line # 768 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Ra.sl[6]=769; /* line # 769 */
        Rs.sl[15]=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
        Ra.sl[6]=770; /* line # 770 */
        if ((float)Rs.sl[15]<(F)0.000000E-01)  break;
        Ra.sl[6]=771; /* line # 771 */
        if (!Rs.ub[16]) Rs.g[6]=Rs.g[6]*(double)Rs.sl[3]+(double)Rs.sl[15];
        Ra.sl[6]=772; /* line # 772 */
        if (Rs.sl[14]>0||Rs.sl[15]>0) Rs.sl[14]=Rs.sl[14]+1;
      }
    }
    Ra.sl[6]=777; /* line # 777 */
    Rs.g[8]=(double)Rs.sl[3];
    Rs.g[3]=Rs.g[8];
    Ra.sl[6]=779; /* line # 779 */
    if (V_sy_ch==46) {
      Ra.sl[6]=781; /* line # 781 */
      if (P_src_next_char()==46) {
        Ra.sl[6]=782; /* line # 782 */
        if (V_sy_sym.ub[0]==19) {
          Ra.sl[6]=784; /* line # 784 */
          PAS_INSMBOL_PRC_00000003();
          Ra.sl[6]=785; /* line # 785 */
          V_sy_sym.ub[0]=20;
        }
        else {
          Ra.sl[6]=787; /* line # 787 */
          Rs.ub[40]=0;
        }
      }
      else {
        while (1){
          Ra.sl[6]=790; /* line # 790 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Ra.sl[6]=791; /* line # 791 */
        Rs.g[8]=(double)Rs.sl[3];
        Rs.g[3]=Rs.g[8];
        Rs.g[4]=1.000000000000000E+000;
        Ra.sl[6]=792; /* line # 792 */
        if (PAS_INSMBOL_PRC_00000005(V_sy_cmin)<0) {
          Ra.sl[6]=793; /* line # 793 */
          Rs.ub[40]=0;
        }
        else {
          Ra.sl[6]=796; /* line # 796 */
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[6]=798; /* line # 798 */
            if (Rs.g[4]!=1.000000000000000E+000) while (1){
              Ra.sl[6]=799; /* line # 799 */
              PAS_INSMBOL_PRC_00000003();
              if (V_sy_cmin!=95)  break;
            }
            Ra.sl[6]=800; /* line # 800 */
            Rs.sl[15]=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
            Ra.sl[6]=801; /* line # 801 */
            if (Rs.sl[15]<0)  break;
            Ra.sl[6]=802; /* line # 802 */
            Rs.g[4]=Rs.g[4]/Rs.g[8];
            Ra.sl[6]=803; /* line # 803 */
            Rs.g[6]=Rs.g[6]+Rs.g[4]*(double)Rs.sl[15];
            Ra.sl[6]=804; /* line # 804 */
            Rs.sl[14]=Rs.sl[14]+1;
          }
        }
      }
    }
    Ra.sl[6]=810; /* line # 810 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=812; /* line # 812 */
    if (V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=20) {
      Ra.sl[6]=814; /* line # 814 */
      if (V_sy_cmin==101) {
        Ra.sl[6]=816; /* line # 816 */
        V_sy_sym.ub[0]=4;
        Ra.sl[6]=817; /* line # 817 */
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[6]=818; /* line # 818 */
        if (V_sy_ch==43||V_sy_ch==45) {
          Ra.sl[6]=820; /* line # 820 */
          if (V_sy_ch==45) Rs.g[3]=1.000000000000000E+000/Rs.g[3];
          Ra.sl[6]=821; /* line # 821 */
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[6]=823; /* line # 823 */
        Rs.sl[18]=0;
        Ra.sl[6]=825; /* line # 825 */
        while (Ri.ub[V_sy_cmin+4]==8){
          Ra.sl[6]=827; /* line # 827 */
          Rs.sl[18]=Rs.sl[18]*10+((SL)V_sy_ch-48);
          Ra.sl[6]=828; /* line # 828 */
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[6]=832; /* line # 832 */
        Rs.g[4]=1.000000000000000E+000;
        Ra.sl[6]=833; /* line # 833 */
        while (Rs.sl[18]!=0&&!Rs.ub[16]){
          Ra.sl[6]=835; /* line # 835 */
          if (Rs.sl[18]&1) {
            Ra.sl[6]=837; /* line # 837 */
            Rs.sl[18]=Rs.sl[18]-1;
            Ra.sl[6]=838; /* line # 838 */
            Rs.g[4]=Rs.g[4]*Rs.g[3];
          }
          else {
            Ra.sl[6]=842; /* line # 842 */
            Rs.sl[18]=Rs.sl[18]/2;
            Ra.sl[6]=843; /* line # 843 */
            Rs.g[3]=PAS__G_SQR(Rs.g[3]);
          }
        }
        Ra.sl[6]=846; /* line # 846 */
        if (!Rs.ub[16]) Rs.g[6]=Rs.g[6]*Rs.g[4];
      }
      Ra.sl[6]=849; /* line # 849 */
      if (Rs.ub[16]) Rs.g[6]=0.000000000000000E-001;
      Ra.sl[6]=851; /* line # 851 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[6]=853; /* line # 853 */
        if (Rs.g[6]<=4.294967295000001E+009&&Rs.g[6]>=-2.147483648000001E+009) {
          Ra.sl[6]=855; /* line # 855 */
          if (Rs.g[6]>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rs.g[6])+1;
          else {
            Ra.sl[6]=856; /* line # 856 */
            V_sy_ival=(int)(Rs.g[6]);
          }
          Ra.sl[6]=857; /* line # 857 */
          V_sy_rval=(double)V_sy_ival;
          Ra.sl[6]=858; /* line # 858 */
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
            Ra.sl[6]=861; /* line # 861 */
            PAS_INSMBOL_PRC_00000003();
            Ra.sl[6]=862; /* line # 862 */
            P_ide_int_label();
            Ra.sl[6]=863; /* line # 863 */
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[6]=866; /* line # 866 */
          V_sy_sym.ub[0]=4;
        }
      }
      Ra.sl[6]=869; /* line # 869 */
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[6]=871; /* line # 871 */
        V_sy_ival=0;
        Ra.sl[6]=872; /* line # 872 */
        if (Rs.g[6]>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[6]=876; /* line # 876 */
          if (Rs.sl[3]>2) Rs.sl[14]=Rs.sl[14]*(int)(log(Rs.g[8])/6.931471805599453E-001)
          +2;
          else {
            Ra.sl[6]=877; /* line # 877 */
            Rs.sl[14]=Rs.sl[14]+2;
          }
          Ra.sl[6]=879; /* line # 879 */
          if (Rs.sl[14]>24) V_sy_sym.ub[0]=4;
          else {
            Ra.sl[6]=880; /* line # 880 */
            V_sy_sym.ub[0]=3;
          }
        }
      }
      Ra.sl[6]=883; /* line # 883 */
      V_sy_rval=Rs.g[6];
      Ra.sl[6]=884; /* line # 884 */
      Rs.ub[40]=0;
    }
    Ra.sl[6]=886; /* line # 886 */
    PAS__REVERT();
    break;
    case 7:Ra.sl[6]=890; /* line # 890 */
    Ra.sl[6]=892; /* line # 892 */
    V_sy_ident.ub[0]=0;
    while (1){
      Ra.sl[6]=894; /* line # 894 */
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[6]=897; /* line # 897 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        Ra.sl[6]=898; /* line # 898 */
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      Ra.sl[6]=900; /* line # 900 */
      PAS_INSMBOL_PRC_00000003();
      if (Ri.ub[V_sy_cmin+4]!=7&&Ri.ub[V_sy_cmin+4]!=8)  break;
    }
    Ra.sl[6]=903; /* line # 903 */
    Rs.v[10]=V_keyword_tree;
    while (1){
      Ra.sl[6]=905; /* line # 905 */
      Rv1=Rs.v[10];
      Ra.sl[6]=907; /* line # 907 */
      Rs.sl[22]=P_match(V_sy_ident.s,Rv1);
      Ra.sl[6]=908; /* line # 908 */
      if (Rs.sl[22]!=0) {
        Ra.sl[6]=909; /* line # 909 */
        if (Rs.sl[22]>0) Rs.v[10]=((V *)Rv1)[5];
        else Rs.v[10]=((V *)Rv1)[4];
      }
      if (Rs.sl[22]==0||Rs.v[10]==NULL)  break;
    }
    Ra.sl[6]=912; /* line # 912 */
    if (Rs.v[10]!=NULL) {
      Ra.sl[6]=913; /* line # 913 */
      memcpy(V_sy_sym.s,Rs.v[10]+48,2);
    }
    else {
      Ra.sl[6]=916; /* line # 916 */
      V_sy_macsymb=V_macsymb_tree;
      Ra.sl[6]=918; /* line # 918 */
      V_sy_sym.ub[0]=101;
      Ra.sl[6]=919; /* line # 919 */
      Rs.sl[22]=1;
      Ra.sl[6]=920; /* line # 920 */
      while (Rs.sl[22]!=0&&V_sy_macsymb!=NULL){
        Ra.sl[6]=921; /* line # 921 */
        Rv2=V_sy_macsymb;
        Ra.sl[6]=923; /* line # 923 */
        Rs.sl[22]=P_match(V_sy_ident.s,Rv2);
        Ra.sl[6]=924; /* line # 924 */
        if (Rs.sl[22]!=0) {
          Ra.sl[6]=925; /* line # 925 */
          if (Rs.sl[22]>0) V_sy_macsymb=((V *)Rv2)[6];
          else V_sy_macsymb=((V *)Rv2)[5];
        }
      }
      Ra.sl[6]=927; /* line # 927 */
      if (Rs.sl[22]==0) V_sy_sym.ub[0]=101;
      else {
        Ra.sl[6]=930; /* line # 930 */
        if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
          Ra.sl[6]=933; /* line # 933 */
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=1;
        }
        else {
          Ra.sl[6]=937; /* line # 937 */
          if (Ri.ub[V_sy_cmin+4]==6) {
            Ra.sl[6]=938; /* line # 938 */
            V_sy_attrflg=1;
          }
          Ra.sl[6]=939; /* line # 939 */
          V_sy_sym.ub[0]=0;
        }
      }
      Ra.sl[6]=942; /* line # 942 */
      V_sy_sym.ub[1]=29;
    }
    Ra.sl[6]=944; /* line # 944 */
    Rs.ub[40]=0;
    break;
    case 6:Ra.sl[6]=948; /* line # 948 */
    if (Rs.ub[41]) {
      Ra.sl[6]=950; /* line # 950 */
      V_sy_sym.ub[0]=24;
      V_sy_sym.ub[1]=29;
      Ra.sl[6]=951; /* line # 951 */
      Rs.ub[41]=0;
    }
    else {
      Ra.sl[6]=955; /* line # 955 */
      V_sy_sym.ub[1]=29;
      Ra.sl[6]=957; /* line # 957 */
      Rv3=V_src_control;
      Ra.sl[6]=959; /* line # 959 */
      Rs.ub[92]=(524288&((UL *)Rv3)[62])!=0;
      Ra.sl[6]=960; /* line # 960 */
      ((UB *)Rv3)[252]=4;
      Ra.sl[6]=961; /* line # 961 */
      ((UL *)Rv3)[62]=((UL *)Rv3)[62]|524288;
      Ra.sl[6]=963; /* line # 963 */
      Rs.c[93]=V_sy_cmin;
      Ra.sl[6]=964; /* line # 964 */
      V_sy_sym.ub[0]=5;
      Ra.sl[6]=965; /* line # 965 */
      Rs.sl[1]=1;
      Rs.ub[0]=0;
      Ra.sl[6]=966; /* line # 966 */
      Rs.ub[94]=1;
      Ra.sl[6]=967; /* line # 967 */
      while (Rs.ub[94]){
        Ra.sl[6]=969; /* line # 969 */
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[6]=970; /* line # 970 */
        while (Ri.ub[V_sy_cmin+4]==1)
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[6]=971; /* line # 971 */
        if (Ri.ub[V_sy_cmin+4]==2) Rs.ub[94]=0;
        Ra.sl[6]=972; /* line # 972 */
        if (V_sy_ch==Rs.c[93]) {
          Ra.sl[6]=974; /* line # 974 */
          if (Rs.c[93]==P_src_next_char()) {
            Ra.sl[6]=976; /* line # 976 */
            PAS_INSMBOL_PRC_00000003();
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            Ra.sl[6]=980; /* line # 980 */
            ((UB *)V_src_control)[252]=0;
            Ra.sl[6]=981; /* line # 981 */
            Rs.ub[94]=0;
          }
        }
        else {
          Ra.sl[6]=985; /* line # 985 */
          if (Rs.c[93]==34&&V_sy_ch==92) {
            Ra.sl[6]=987; /* line # 987 */
            PAS_INSMBOL_PRC_00000003();
            Ra.sl[6]=988; /* line # 988 */
            switch (V_sy_cmin) {
              case 34:
              case 39:
              case 92:break;
              case 97:Ra.sl[6]=990; /* line # 990 */
              V_sy_ch=7;
              break;
              case 98:Ra.sl[6]=991; /* line # 991 */
              V_sy_ch=8;
              break;
              case 101:Ra.sl[6]=992; /* line # 992 */
              V_sy_ch=27;
              break;
              case 102:Ra.sl[6]=993; /* line # 993 */
              V_sy_ch=12;
              break;
              case 110:Ra.sl[6]=994; /* line # 994 */
              V_sy_ch=10;
              break;
              case 114:Ra.sl[6]=995; /* line # 995 */
              V_sy_ch=13;
              break;
              case 116:Ra.sl[6]=996; /* line # 996 */
              V_sy_ch=9;
              break;
              case 118:Ra.sl[6]=997; /* line # 997 */
              V_sy_ch=11;
              break;
              case 122:Ra.sl[6]=998; /* line # 998 */
              V_sy_ch=0;
              break;
              case 48:
              case 49:
              case 50:
              case 51:
              case 52:
              case 53:
              case 54:
              case 55:
              case 56:
              case 57:Ra.sl[6]=1001; /* line # 1001 */
              Rs.sl[22]=(SL)V_sy_cmin-48;
              PAS_INSMBOL_PRC_00000003();
              Ra.sl[6]=1002; /* line # 1002 */
              Rs.sl[24]=3;
              Ra.sl[6]=1003; /* line # 1003 */
              while ((Rs.sl[24]>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
                Ra.sl[6]=1005; /* line # 1005 */
                Rs.sl[22]=(Rs.sl[22]*10+(SL)V_sy_cmin)-48;
                Ra.sl[6]=1006; /* line # 1006 */
                PAS_INSMBOL_PRC_00000003();
              }
              Ra.sl[6]=1008; /* line # 1008 */
              if (Rs.sl[22]<=255) V_sy_ch=(C)Rs.sl[22];
              else {
                Ra.sl[6]=1009; /* line # 1009 */
                V_sy_ch=32;
                P_src_error(Rd.s+966,17,2);
              }
              break;
              default:Ra.sl[6]=1012; /* line # 1012 */
              V_sy_ch=32;
              P_src_error(Rd.s+966,18,2);
              break;
            }
            Ra.sl[6]=1014; /* line # 1014 */
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            Ra.sl[6]=1016; /* line # 1016 */
            PAS_INSMBOL_PRC_00000004();
          }
        }
      }
      Ra.sl[6]=1018; /* line # 1018 */
      V_sy_string.ub[1]=Rs.sl[1] -1;
      Ra.sl[6]=1020; /* line # 1020 */
      Rv4=V_src_control;
      Ra.sl[6]=1021; /* line # 1021 */
      if (!Rs.ub[92]) {
        Ra.sl[6]=1023; /* line # 1023 */
        ((UL *)Rv4)[62]=((UL *)Rv4)[62]&~524288;
        Ra.sl[6]=1024; /* line # 1024 */
        if (Ri.ub[V_sy_cmin+4]==1) V_sy_ch=32;
      }
    }
    break;
    case 14:Ra.sl[6]=1030; /* line # 1030 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1031; /* line # 1031 */
    V_sy_sym.ub[1]=29;
    Ra.sl[6]=1032; /* line # 1032 */
    if (V_sy_ch==61) V_sy_sym.ub[0]=22;
    else {
      Ra.sl[6]=1033; /* line # 1033 */
      V_sy_sym.ub[0]=21;
      Rs.ub[40]=0;
    }
    break;
    case 11:Ra.sl[6]=1038; /* line # 1038 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1039; /* line # 1039 */
    V_sy_sym.ub[0]=10;
    Ra.sl[6]=1040; /* line # 1040 */
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      Ra.sl[6]=1042; /* line # 1042 */
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[6]=1043; /* line # 1043 */
        V_sy_sym.ub[1]=14;
        Rs.ub[40]=0;
      }
    }
    break;
    case 13:Ra.sl[6]=1048; /* line # 1048 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1049; /* line # 1049 */
    V_sy_sym.ub[0]=10;
    Ra.sl[6]=1050; /* line # 1050 */
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      Ra.sl[6]=1051; /* line # 1051 */
      V_sy_sym.ub[1]=17;
      Rs.ub[40]=0;
    }
    break;
    case 5:Ra.sl[6]=1056; /* line # 1056 */
    Rs.c[93]=V_sy_ch;
    Ra.sl[6]=1057; /* line # 1057 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1058; /* line # 1058 */
    if (V_sy_ch==Rs.c[93]) {
      V_sy_sym.ub[0]=9;
      V_sy_sym.ub[1]=13;
    }
    else {
      Ra.sl[6]=1059; /* line # 1059 */
      V_sy_sym.ub[0]=12;
      V_sy_sym.ub[1]=21;
      Rs.ub[40]=0;
    }
    break;
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[6]=1064; /* line # 1064 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    break;
    case 17:
    case 25:
    case 26:Ra.sl[6]=1068; /* line # 1068 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    Ra.sl[6]=1069; /* line # 1069 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1070; /* line # 1070 */
    if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
    Ra.sl[6]=1071; /* line # 1071 */
    Rs.ub[40]=0;
    break;
    case 10:Ra.sl[6]=1076; /* line # 1076 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1077; /* line # 1077 */
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      Ra.sl[6]=1078; /* line # 1078 */
      V_sy_sym.ub[0]=8;
      V_sy_sym.ub[1]=6;
      Rs.ub[40]=0;
    }
    break;
    case 12:Ra.sl[6]=1083; /* line # 1083 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[6]=1084; /* line # 1084 */
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=25;
      V_sy_sym.ub[1]=29;
    }
    else {
      Ra.sl[6]=1085; /* line # 1085 */
      V_sy_sym.ub[0]=10;
      V_sy_sym.ub[1]=19;
      Rs.ub[40]=0;
    }
    break;
    case 2:Ra.sl[6]=1089; /* line # 1089 */
    V_sy_sym.ub[0]=106;
    V_sy_sym.ub[1]=29;
    V_sy_ch=32;
    Rs.ub[40]=0;
    break;
    case 1:Ra.sl[6]=1092; /* line # 1092 */
    V_sy_sym.ub[0]=89;
    V_sy_sym.ub[1]=29;
    Rs.ub[40]=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[6]=1095; /* line # 1095 */
    V_sy_sym.ub[0]=107;
    Ra.sl[6]=1096; /* line # 1096 */
    V_sy_sym.ub[1]=29;
    Ra.sl[6]=1097; /* line # 1097 */
    Rs.ub[40]=0;
    Ra.sl[6]=1098; /* line # 1098 */
    if (V_sy_ch!=32) P_src_error(Rd.s+966,13,2);
    Ra.sl[6]=1099; /* line # 1099 */
    V_sy_ch=32;
    break;
  }
  Ra.sl[6]=1102; /* line # 1102 */
  if (Rs.ub[40]) PAS_INSMBOL_PRC_00000003();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_mcsymbol "  */
void PAS_INSMBOL_skip_mcsymbol(V F_smb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1039;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1131; /* line # 1131 */
  Ra.sl[6]=1132; /* line # 1132 */
  if (!PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,108)) {
    Ra.sl[6]=1134; /* line # 1134 */
    while (!((PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,108)||V_sy_sym.ub[0]==90)||V_sy_sym
    .ub[0]==106)){
      Ra.sl[6]=1136; /* line # 1136 */
      P_insymbol_src();
      Ra.sl[6]=1137; /* line # 1137 */
      switch (V_sy_sym.ub[0]) {
        case 94:
        case 95:
        case 96:Ra.sl[6]=1139; /* line # 1139 */
        while (PAS__INOP_LSET(V_sy_sym.ub[0],Rd.s+1056,97)){
          Ra.sl[6]=1141; /* line # 1141 */
          PAS_INSMBOL_skip_mcsymbol(Rd.s+1072);
          Ra.sl[6]=1142; /* line # 1142 */
          P_insymbol_src();
        }
        break;
        case 106:Ra.sl[6]=1155; /* line # 1155 */
        P_src_error(Rd.s+1090,932,3);
        break;
        default:break;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cb_macro_manager "  */
V PAS_INSMBOL_cb_macro_manager(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1094;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1166; /* line # 1166 */
  Rv0=F_mcp;
  Ra.sl[6]=1168; /* line # 1168 */
  ((UB *)Rv0)[56]=0;
  Ra.sl[6]=1170; /* line # 1170 */
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " macro_replace "  */
void P_macro_replace(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1112;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1187; /* line # 1187 */
  Rv2=F_mcp;
  Rv3=Rv2+64;
  Ra.sl[6]=1188; /* line # 1188 */
  if (!((UB *)Rv2)[56]) {
    Ra.sl[6]=1191; /* line # 1191 */
    switch (((UB *)Rv3)[0]) {
      case 0:Ra.sl[6]=1194; /* line # 1194 */
      Rv0=PAS__NEW(24);
      ((UB *)Rv0)[0]=22;
      Ra.sl[6]=1195; /* line # 1195 */
      PAS__VWRITE_INIT(Rv0,1);
      PAS__WRITE_INT(((SL *)Rv3)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[6]=1199; /* line # 1199 */
      Rv4=((UB *)((V *)Rv3)[1])[1];
      Rv0=PAS__NEW((SL)Rv4+2);
      ((UB *)Rv0)[0]=Rv4;
      Ra.sl[6]=1200; /* line # 1200 */
      PAS__STR_TO_STR(Rv0,((V *)Rv3)[1]);
      break;
      default:break;
    }
    Ra.sl[6]=1204; /* line # 1204 */
    ((UB *)Rv2)[56]=1;
    Ra.sl[6]=1206; /* line # 1206 */
    Rv1=P_src_macro_open(Rv0, (V)PAS_INSMBOL_cb_macro_manager,F_mcp,1,NULL);
    Ra.sl[6]=1207; /* line # 1207 */
    V_sy_ch=0;
  }
  else {
    Ra.sl[6]=1210; /* line # 1210 */
    P_src_error_s(Rd.s+1129,930,2, F_mcp,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_macro_symbol "  */
void PAS_INSMBOL_define_macro_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1133;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1224; /* line # 1224 */
  Ra.sl[6]=1226; /* line # 1226 */
  P_insymbol_src();
  while (1){
    Ra.sl[6]=1228; /* line # 1228 */
    if (V_sy_sym.ub[0]==101) {
      Ra.sl[6]=1230; /* line # 1230 */
      P_src_error_s(Rd.s+1156,921,2, V_sy_ident.s,NULL);
      Ra.sl[6]=1231; /* line # 1231 */
      P_skip_msymbol((V)Rd.s+1160,0);
    }
    else {
      Ra.sl[6]=1234; /* line # 1234 */
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=1236; /* line # 1236 */
        P_src_error(Rd.s+1156,922,2);
        Ra.sl[6]=1237; /* line # 1237 */
        P_skip_msymbol((V)Rd.s+1164,0);
      }
      else {
        Ra.sl[6]=1241; /* line # 1241 */
        Rv0=P_create_mac_ident(V_sy_ident.s,0);
        Ra.sl[6]=1242; /* line # 1242 */
        P_insymbol_src();
        Ra.sl[6]=1243; /* line # 1243 */
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=1244; /* line # 1244 */
          Rv1=Rv0;
          Ra.sl[6]=1246; /* line # 1246 */
          P_insymbol_src();
          Ra.sl[6]=1247; /* line # 1247 */
          PAS_INSMBOL_get_macro_value(Rv1+64);
        }
      }
    }
    Ra.sl[6]=1259; /* line # 1259 */
    if (V_sy_sym.ub[0]!=17)  break;
    Ra.sl[6]=1260; /* line # 1260 */
    P_insymbol_src();
  }
  Ra.sl[6]=1262; /* line # 1262 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1156,21,2);
  else {
    Ra.sl[6]=1263; /* line # 1263 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " undefine_macro_symbol "  */
void PAS_INSMBOL_undefine_macro_mbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1168;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1275; /* line # 1275 */
  Ra.sl[6]=1277; /* line # 1277 */
  P_insymbol_src();
  while (1){
    Ra.sl[6]=1279; /* line # 1279 */
    if (V_sy_sym.ub[0]!=101) {
      Ra.sl[6]=1281; /* line # 1281 */
      P_src_error(Rd.s+1193,922,2);
      Ra.sl[6]=1282; /* line # 1282 */
      P_skip_msymbol((V)Rd.s+1200,0);
    }
    else {
      Ra.sl[6]=1286; /* line # 1286 */
      if (V_sy_macsymb==NULL) {
        Ra.sl[6]=1287; /* line # 1287 */
        P_src_error_s(Rd.s+1193,923,2, V_sy_ident.s,NULL);
      }
      else {
        Ra.sl[6]=1289; /* line # 1289 */
        Rv0=V_sy_macsymb;
        Ra.sl[6]=1291; /* line # 1291 */
        ((UB *)Rv0)[0]=0;
        Ra.sl[6]=1292; /* line # 1292 */
        if (((V *)Rv0)[9]!=NULL) {
          Ra.sl[6]=1293; /* line # 1293 */
          PAS__DISPOSE(((V *)Rv0)+9);
        }
      }
      Ra.sl[6]=1295; /* line # 1295 */
      P_insymbol_src();
    }
    Ra.sl[6]=1297; /* line # 1297 */
    if (V_sy_sym.ub[0]!=17)  break;
    Ra.sl[6]=1298; /* line # 1298 */
    P_insymbol_src();
  }
  Ra.sl[6]=1300; /* line # 1300 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1193,21,2);
  else {
    Ra.sl[6]=1301; /* line # 1301 */
    P_insymbol_src();
  }
  Ra.sl[6]=1303; /* line # 1303 */
  P_rebuild_mctree();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_assign_symbol "  */
void PAS_INSMBOL_macro_assign_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1204;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1316; /* line # 1316 */
  Ra.sl[6]=1318; /* line # 1318 */
  P_insymbol_src();
  Ra.sl[6]=1319; /* line # 1319 */
  if (V_sy_sym.ub[0]!=101) {
    Ra.sl[6]=1321; /* line # 1321 */
    P_src_error(Rd.s+1227,922,2);
    Ra.sl[6]=1322; /* line # 1322 */
    P_skip_msymbol(Rd.s+1232,0);
  }
  else {
    Ra.sl[6]=1326; /* line # 1326 */
    Rv0=V_sy_macsymb;
    Ra.sl[6]=1327; /* line # 1327 */
    P_insymbol_src();
    Ra.sl[6]=1328; /* line # 1328 */
    if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1227,32,2);
    else {
      Ra.sl[6]=1329; /* line # 1329 */
      P_insymbol_src();
    }
    Ra.sl[6]=1330; /* line # 1330 */
    Rv1=Rv0;
    Ra.sl[6]=1332; /* line # 1332 */
    if (((V *)Rv1)[9]!=NULL) PAS__DISPOSE(((V *)Rv1)+9);
    Ra.sl[6]=1333; /* line # 1333 */
    PAS_INSMBOL_get_macro_value(Rv1+64);
  }
  Ra.sl[6]=1336; /* line # 1336 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1227,21,2);
  else {
    Ra.sl[6]=1337; /* line # 1337 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mval "  */
void PAS_INSMBOL_show_mval(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1248;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1345; /* line # 1345 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1259,-1,-1,32);
  PAS__WRITE_ENM(((UB *)F_vl)[0],Rd.s+1276,0,-1,32);
  PAS__WRITE_STR(Rd.s+1318,-1,-1,32);
  PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
  PAS__WRITE_STR(Rd.s+1324,-1,-1,32);
  Ra.sl[6]=1346; /* line # 1346 */
  if (((V *)F_vl)[1]!=NULL&&((UB *)F_vl)[0]==1) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(((V *)F_vl)[1],-1,-1,32);
  }
  Ra.sl[6]=1347; /* line # 1347 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1331,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mstack "  */
void PAS_INSMBOL_show_mstack(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1335;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1352; /* line # 1352 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(F_s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1348,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[39],-2,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=1353; /* line # 1353 */
  Rv0=Ri.sl[39];
  for( Rf0=Ri.sl[39];Rf0>0;Rf0-- ) {
    Ra.sl[6]=1355; /* line # 1355 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1365,-1,-1,32);
    PAS__WRITE_INT(Rv0,-2,0);
    PAS__WRITE_STR(Rd.s+1369,-1,-1,32);
    PAS_INSMBOL_show_mval((Rs.s+Rv0*16+88));
    Rv0--;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_cop "  */
void PAS_INSMBOL_mval_cop(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1375;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1363; /* line # 1363 */
  ((UB *)F_dst)[0]=((UB *)F_src)[0];
  Ra.sl[6]=1364; /* line # 1364 */
  ((SL *)F_dst)[1]=((SL *)F_src)[1];
  Ra.sl[6]=1365; /* line # 1365 */
  if (((V *)F_src)[1]!=NULL) {
    Ra.sl[6]=1367; /* line # 1367 */
    Rv0=((UB *)((V *)F_src)[1])[1];
    ((V *)F_dst)[1]=PAS__NEW((SL)Rv0+2);
    ((UB *)((V *)F_dst)[1])[0]=Rv0;
    Ra.sl[6]=1368; /* line # 1368 */
    PAS__STR_TO_STR(((V *)F_dst)[1],((V *)F_src)[1]);
  }
  else {
    Ra.sl[6]=1370; /* line # 1370 */
    ((V *)F_dst)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_free "  */
void PAS_INSMBOL_mval_free(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1385;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1377; /* line # 1377 */
  if (((V *)F_vl)[1]!=NULL) PAS__DISPOSE(((V *)F_vl)+1);
  Ra.sl[6]=1378; /* line # 1378 */
  memcpy(F_vl,Rd.s+888,16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpush "  */
void PAS_INSMBOL_mpush(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1396;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1388; /* line # 1388 */
  if (Ri.sl[39]<32) Ri.sl[39]=Ri.sl[39]+1;
  else {
    Ra.sl[6]=1389; /* line # 1389 */
    P_src_error(Rd.s+1405,911,3);
  }
  Ra.sl[6]=1390; /* line # 1390 */
  PAS_INSMBOL_mval_cop(F_vl,(Rs.s+Ri.sl[39]*16+88));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpop "  */
void PAS_INSMBOL_mpop(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1409;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1400; /* line # 1400 */
  if (Ri.sl[39]>0) {
    Ra.sl[6]=1402; /* line # 1402 */
    memcpy(F_vl,(Rs.s+Ri.sl[39]*16+88),16);
    Ra.sl[6]=1403; /* line # 1403 */
    Ri.sl[39]=Ri.sl[39]-1;
  }
  else {
    Ra.sl[6]=1407; /* line # 1407 */
    P_src_error(Rd.s+1417,912,3);
    Ra.sl[6]=1408; /* line # 1408 */
    memcpy(F_vl,Rd.s+888,16);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_macro_value "  */
void PAS_INSMBOL_get_macro_value(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1421;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1426; /* line # 1426 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1427; /* line # 1427 */
  PAS_INSMBOL_mpop(F_vl);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_intv "  */
SL PAS_INSMBOL_mexp_intv(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1438;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1439; /* line # 1439 */
  PAS_INSMBOL_mpop(Ra.s+32);
  Ra.sl[6]=1440; /* line # 1440 */
  Ra.sl[6]=1441; /* line # 1441 */
  if (Ra.ub[32]==0) Rv0=Ra.sl[9];
  else {
    Ra.sl[6]=1442; /* line # 1442 */
    if (Ra.v[5]==NULL) Rv0=0;
    else {
      Ra.sl[6]=1445; /* line # 1445 */
      Rv1=Ra.v[5];
      Ra.sl[6]=1447; /* line # 1447 */
      Rv0=0;
      Rv2=0;
      Rv3=((UB *)Rv1)[1];
      Ra.sl[6]=1448; /* line # 1448 */
      while (Rv2<Rv3&&((C *)Rv1)[Rv2+1]<=32)
      Rv2=Rv2+1;
      Ra.sl[6]=1449; /* line # 1449 */
      while (Rv2<Rv3){
        Ra.sl[6]=1451; /* line # 1451 */
        Rv4=((C *)Rv1)[Rv2+1];
        Ra.sl[6]=1452; /* line # 1452 */
        if ((Rv4<48||Rv4>57)&&Rv4>32)  break;
        Ra.sl[6]=1453; /* line # 1453 */
        if (Rv4>32) Rv0=Rv0*10+((SL)Rv4-48);
        Ra.sl[6]=1454; /* line # 1454 */
        Rv2=Rv2+1;
      }
      Ra.sl[6]=1457; /* line # 1457 */
      PAS__DISPOSE(Ra.v+5);
    }
  }
  Ra.sl[6]=1459; /* line # 1459 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexp_vl_str "  */
void PAS_INSMBOL_mexp_vl_str(V F_vl, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1449;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1467; /* line # 1467 */
  Ra.sl[6]=1468; /* line # 1468 */
  if (((UB *)F_vl)[0]==0) {
    PAS__VWRITE_INIT(F_str,1);
    PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=1471; /* line # 1471 */
    PAS__STR_TO_STR(F_str,((V *)F_vl)[1]);
    Ra.sl[6]=1472; /* line # 1472 */
    PAS__DISPOSE(((V *)F_vl)+1);
    Ra.sl[6]=1473; /* line # 1473 */
    ((V *)F_vl)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_strv "  */
void PAS_INSMBOL_mexp_strv(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1462;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1484; /* line # 1484 */
  PAS_INSMBOL_mpop(Ra.s+32);
  Ra.sl[6]=1485; /* line # 1485 */
  PAS_INSMBOL_mexp_vl_str(Ra.s+32,F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_call "  */
void PAS_INSMBOL_mexp_call(UB F_fn, SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 824 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+888,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1473;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1501; /* line # 1501 */
  Ra.sl[140]=1503; /* line # 1503 */
  if (F_fn==0) {
    Ra.sl[140]=1505; /* line # 1505 */
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1486,22,2);
    else {
      Ra.sl[140]=1506; /* line # 1506 */
      P_insymbol_src();
    }
    Ra.sl[140]=1507; /* line # 1507 */
    if (V_sy_sym.ub[0]==101&&V_sy_macsymb!=NULL) Ra.sl[1]=1;
    else {
      Ra.sl[140]=1508; /* line # 1508 */
      Ra.sl[1]=0;
    }
    Ra.sl[140]=1509; /* line # 1509 */
    Ra.ub[0]=0;
    Ra.sl[140]=1511; /* line # 1511 */
    P_insymbol_src();
    Ra.sl[140]=1512; /* line # 1512 */
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1486,23,2);
    Ra.sl[140]=1513; /* line # 1513 */
    PAS_INSMBOL_mpush(Ra.s);
  }
  else {
    Ra.sl[140]=1517; /* line # 1517 */
    Rv0=0;
    Ra.sl[140]=1518; /* line # 1518 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[140]=1520; /* line # 1520 */
      V_sy_sym.ub[0]=17;
      Ra.sl[140]=1521; /* line # 1521 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[140]=1523; /* line # 1523 */
        P_insymbol_src();
        Ra.sl[140]=1524; /* line # 1524 */
        PAS_INSMBOL_m_expr_instk();
        Ra.sl[140]=1525; /* line # 1525 */
        Rv0=Rv0+1;
      }
      Ra.sl[140]=1527; /* line # 1527 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1486,23,2);
    }
    Ra.sl[140]=1529; /* line # 1529 */
    if (F_narg>0&&Rv0!=F_narg||F_narg<0&&Rv0> -F_narg) {
      Ra.sl[140]=1532; /* line # 1532 */
      P_src_error_s(Rd.s+1486,925,2,(Rd.s+F_fn*36+1492),NULL);
      Ra.sl[140]=1533; /* line # 1533 */
      for( Rf0=Rv0;Rf0>0;Rf0-- )
      PAS_INSMBOL_mpop(Ra.s);
      Ra.sl[140]=1534; /* line # 1534 */
      PAS_INSMBOL_mpush(Rd.s+888);
    }
    else {
      Ra.sl[140]=1539; /* line # 1539 */
      switch (F_fn) {
        case 3:Ra.sl[140]=1542; /* line # 1542 */
        PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[140]=1543; /* line # 1543 */
        Ra.sl[1]=Ra.ub[17];
        break;
        case 1:Ra.sl[140]=1549; /* line # 1549 */
        if (F_narg==3) Rv1=PAS_INSMBOL_mexp_intv();
        else Rv1=0;
        Ra.sl[140]=1550; /* line # 1550 */
        if (F_narg>1) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=1;
        Ra.sl[140]=1551; /* line # 1551 */
        if (F_narg>0) PAS_INSMBOL_mexp_strv(Ra.s+16);
        else Ra.ub[17]=0;
        Ra.sl[140]=1552; /* line # 1552 */
        Ra.ub[0]=1;
        Ra.sl[140]=1553; /* line # 1553 */
        Ra.sl[1]=0;
        Ra.sl[140]=1554; /* line # 1554 */
        PAS__STR_TO_STR(Ra.s+273,PAS__SUBSTR_STR(Ra.s+564,Ra.s+16,Rv2, Rv1));
        Ra.sl[140]=1555; /* line # 1555 */
        if (Ra.ub[274]>0) {
          Ra.sl[140]=1557; /* line # 1557 */
          Rv3=Ra.ub[274];
          Ra.v[1]=PAS__NEW((SL)Rv3+2);
          ((UB *)Ra.v[1])[0]=Rv3;
          Ra.sl[140]=1558; /* line # 1558 */
          PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
        }
        break;
        case 2:Ra.sl[140]=1565; /* line # 1565 */
        if (F_narg==3) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=0;
        Ra.sl[140]=1566; /* line # 1566 */
        if (F_narg<2) Ra.ub[274]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+273);
        Ra.sl[140]=1567; /* line # 1567 */
        if (F_narg<1) Ra.ub[17]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[140]=1568; /* line # 1568 */
        Ra.sl[1]=PAS__NINDEX_STR(Ra.s+18,(SL)Ra.ub[17],Ra.s+275,(SL)Ra.ub[274],Rv2,-1,1);
        break;
        default:Ra.sl[140]=1573; /* line # 1573 */
        P_src_error(Rd.s+1486,929,2);
        break;
      }
      Ra.sl[140]=1575; /* line # 1575 */
      PAS_INSMBOL_mpush(Ra.s);
    }
  }
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_ident "  */
void PAS_INSMBOL_mexp_ident(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register UB Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1672;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1593; /* line # 1593 */
  Rv0=1;
  Ra.sl[6]=1594; /* line # 1594 */
  Rv1=1;
  Ra.sl[6]=1595; /* line # 1595 */
  Ra.sl[6]=1597; /* line # 1597 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[6]=1600; /* line # 1600 */
    Rv2=0;
    Ra.sl[6]=1601; /* line # 1601 */
    while (Rv2<4){
      Ra.sl[6]=1603; /* line # 1603 */
      if (P_match(V_sy_ident.s,(Rd.s+Rv2*36+1492))==0)  break;
      Ra.sl[6]=1604; /* line # 1604 */
      Rv2=Rv2+1;
    }
    Ra.sl[6]=1606; /* line # 1606 */
    if (Rv2>=4) {
      Ra.sl[6]=1608; /* line # 1608 */
      P_src_error_s(Rd.s+1686,928,3, V_sy_ident.s,NULL);
      Ra.sl[6]=1609; /* line # 1609 */
      P_skip_msymbol((V)Rd.s+1692,0);
    }
    else {
      Ra.sl[6]=1613; /* line # 1613 */
      P_insymbol_src();
      Ra.sl[6]=1614; /* line # 1614 */
      PAS_INSMBOL_mexp_call(Rv2, Rd.sl[Rv2*9+381]);
      Ra.sl[6]=1615; /* line # 1615 */
      Rv1=0;
    }
    break;
    case 101:Ra.sl[6]=1620; /* line # 1620 */
    if (V_sy_macsymb!=NULL) {
      Ra.sl[6]=1622; /* line # 1622 */
      Rv1=0;
      Ra.sl[6]=1623; /* line # 1623 */
      PAS_INSMBOL_mpush(V_sy_macsymb+64);
    }
    else {
      Ra.sl[6]=1627; /* line # 1627 */
      P_src_error_s(Rd.s+1686,923,2, V_sy_ident.s,NULL);
    }
    break;
    case 5:Ra.sl[6]=1632; /* line # 1632 */
    Ra.ub[32]=1;
    Ra.sl[6]=1633; /* line # 1633 */
    Ra.sl[9]=0;
    Ra.sl[6]=1634; /* line # 1634 */
    if (V_sy_string.ub[1]>0) {
      Ra.sl[6]=1636; /* line # 1636 */
      Rv3=V_sy_string.ub[1];
      Ra.v[5]=PAS__NEW((SL)Rv3+2);
      ((UB *)Ra.v[5])[0]=Rv3;
      Ra.sl[6]=1637; /* line # 1637 */
      PAS__STR_TO_STR(Ra.v[5],V_sy_string.s);
    }
    break;
    case 2:Ra.sl[6]=1643; /* line # 1643 */
    Ra.ub[32]=0;
    Ra.sl[6]=1644; /* line # 1644 */
    Ra.sl[9]=V_sy_ival;
    Ra.sl[6]=1645; /* line # 1645 */
    Ra.v[5]=NULL;
    break;
    case 17:
    case 18:Ra.sl[6]=1651; /* line # 1651 */
    memcpy(Ra.s+32,Rd.s+888,16);
    Ra.sl[6]=1652; /* line # 1652 */
    Rv0=0;
    break;
    default:Ra.sl[6]=1656; /* line # 1656 */
    memcpy(Ra.s+32,Rd.s+888,16);
    Ra.sl[6]=1657; /* line # 1657 */
    Rv0=0;
    Ra.sl[6]=1658; /* line # 1658 */
    P_src_error(Rd.s+1686,926,2);
    break;
  }
  Ra.sl[6]=1660; /* line # 1660 */
  if (Rv1) PAS_INSMBOL_mpush(Ra.s+32);
  Ra.sl[6]=1661; /* line # 1661 */
  if (Rv0) P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_binop "  */
void PAS_INSMBOL_mexp_binop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 840 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  SL Rv2;
  register F Rgf;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+888,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1696;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1680; /* line # 1680 */
  switch (F_ope) {
    case 6:Ra.sl[140]=1683; /* line # 1683 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1684; /* line # 1684 */
    Ra.ub[0]=0;
    Ra.sl[140]=1685; /* line # 1685 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()*Rv0;
    break;
    case 7:Ra.sl[140]=1689; /* line # 1689 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1690; /* line # 1690 */
    Ra.ub[0]=0;
    Ra.sl[140]=1691; /* line # 1691 */
    if (Rv0!=0) Ra.sl[1]=PAS__F_ROUND((float)PAS_INSMBOL_mexp_intv()/(float)Rv0)
    ;
    else {
      Ra.sl[140]=1692; /* line # 1692 */
      Ra.sl[1]=0;
    }
    break;
    case 11:Ra.sl[140]=1696; /* line # 1696 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1697; /* line # 1697 */
    Ra.ub[0]=0;
    Ra.sl[140]=1698; /* line # 1698 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()+Rv0;
    break;
    case 12:Ra.sl[140]=1702; /* line # 1702 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1703; /* line # 1703 */
    Ra.ub[0]=0;
    Ra.sl[140]=1704; /* line # 1704 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()-Rv0;
    break;
    case 13:Ra.sl[140]=1708; /* line # 1708 */
    PAS_INSMBOL_mexp_strv(Ra.s+16);
    Ra.sl[140]=1709; /* line # 1709 */
    PAS_INSMBOL_mexp_strv(Ra.s+273);
    Ra.sl[140]=1710; /* line # 1710 */
    PAS__STR_TO_STR(Ra.s+273,PAS__CON_STR_STR(Ra.s+564,Ra.s+273,Ra.s+16));
    Ra.sl[140]=1711; /* line # 1711 */
    Ra.ub[0]=1;
    Ra.sl[140]=1712; /* line # 1712 */
    Ra.sl[1]=0;
    Ra.sl[140]=1713; /* line # 1713 */
    Rv1=Ra.ub[274];
    Ra.v[1]=PAS__NEW((SL)Rv1+2);
    ((UB *)Ra.v[1])[0]=Rv1;
    Ra.sl[140]=1714; /* line # 1714 */
    PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:Ra.sl[140]=1718; /* line # 1718 */
    PAS_INSMBOL_mpop(Ra.s+824);
    Ra.sl[140]=1719; /* line # 1719 */
    PAS_INSMBOL_mpop(Ra.s);
    Ra.sl[140]=1720; /* line # 1720 */
    Ra.ub[0]=0;
    Ra.sl[140]=1721; /* line # 1721 */
    if (Ra.ub[824]==1||Ra.ub[0]==1) {
      Ra.sl[140]=1723; /* line # 1723 */
      PAS_INSMBOL_mexp_vl_str(Ra.s+824,Ra.s+16);
      Ra.sl[140]=1724; /* line # 1724 */
      PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+273);
      Ra.sl[140]=1725; /* line # 1725 */
      Rv2=PAS__MATCH_STR(Ra.s+273,Ra.s+16);
      Ra.sl[140]=1726; /* line # 1726 */
      Ra.v[1]=NULL;
    }
    else {
      Ra.sl[140]=1728; /* line # 1728 */
      Rv2=Ra.sl[1]-Ra.sl[207];
    }
    Ra.sl[140]=1729; /* line # 1729 */
    switch (F_ope) {
      case 14:Ra.sl[140]=1730; /* line # 1730 */
      Ra.sl[1]=(SL)(Rv2<0);
      break;
      case 15:Ra.sl[140]=1731; /* line # 1731 */
      Ra.sl[1]=(SL)(Rv2<=0);
      break;
      case 16:Ra.sl[140]=1732; /* line # 1732 */
      Ra.sl[1]=(SL)(Rv2>=0);
      break;
      case 17:Ra.sl[140]=1733; /* line # 1733 */
      Ra.sl[1]=(SL)(Rv2>0);
      break;
      case 18:Ra.sl[140]=1734; /* line # 1734 */
      Ra.sl[1]=(SL)(Rv2!=0);
      break;
      case 19:Ra.sl[140]=1735; /* line # 1735 */
      Ra.sl[1]=(SL)(Rv2==0);
      break;
    }
    break;
    case 20:Ra.sl[140]=1740; /* line # 1740 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1741; /* line # 1741 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1742; /* line # 1742 */
    Ra.ub[0]=0;
    Ra.sl[140]=1743; /* line # 1743 */
    Ra.sl[1]=(SL)(Rv0>0&&Rv2>0);
    break;
    case 21:Ra.sl[140]=1748; /* line # 1748 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1749; /* line # 1749 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1750; /* line # 1750 */
    Ra.ub[0]=0;
    Ra.sl[140]=1751; /* line # 1751 */
    Ra.sl[1]=(SL)(Rv0>0||Rv2>0);
    break;
    case 22:Ra.sl[140]=1756; /* line # 1756 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1757; /* line # 1757 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1758; /* line # 1758 */
    Ra.ub[0]=0;
    Ra.sl[140]=1759; /* line # 1759 */
    Ra.sl[1]=(SL)(Rv0>0&&Rv2<=0||Rv0<=0&&Rv2>0);
    break;
    default:Ra.sl[140]=1765; /* line # 1765 */
    P_src_error(Rd.s+1710,927,3);
    break;
  }
  Ra.sl[140]=1767; /* line # 1767 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_unaop "  */
void PAS_INSMBOL_mexp_unaop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+888,16);
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+1714;
  Ra.v[4]=Rd.s+16;
  Ra.sl[10]=1783; /* line # 1783 */
  switch (F_ope) {
    case 0:Ra.sl[10]=1786; /* line # 1786 */
    Ra.ub[0]=0;
    Ra.sl[10]=1787; /* line # 1787 */
    Ra.v[1]=NULL;
    Ra.sl[10]=1788; /* line # 1788 */
    Ra.sl[1]=(SL)(PAS_INSMBOL_mexp_intv()<=0);
    break;
    case 12:Ra.sl[10]=1792; /* line # 1792 */
    Ra.ub[0]=0;
    Ra.sl[10]=1793; /* line # 1793 */
    Ra.v[1]=NULL;
    Ra.sl[10]=1794; /* line # 1794 */
    Ra.sl[1]= -PAS_INSMBOL_mexp_intv();
    break;
    default:Ra.sl[10]=1798; /* line # 1798 */
    P_src_error(Rd.s+1728,927,3);
    break;
  }
  Ra.sl[10]=1801; /* line # 1801 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[2];
}


/* Procedure/Function : " mexp_una "  */
void PAS_INSMBOL_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1732;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1836; /* line # 1836 */
  Ra.sl[6]=1838; /* line # 1838 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) {
    Ra.sl[6]=1839; /* line # 1839 */
    V_sy_sym.ub[0]=6;
  }
  Ra.sl[6]=1840; /* line # 1840 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=1842; /* line # 1842 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else {
      Ra.sl[6]=1843; /* line # 1843 */
      Rv0=29;
    }
    Ra.sl[6]=1844; /* line # 1844 */
    P_insymbol_src();
    Ra.sl[6]=1845; /* line # 1845 */
    PAS_INSMBOL_PRC_00000012();
    Ra.sl[6]=1846; /* line # 1846 */
    if (Rv0!=29) PAS_INSMBOL_mexp_unaop(Rv0);
  }
  else {
    Ra.sl[6]=1849; /* line # 1849 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1851; /* line # 1851 */
      P_insymbol_src();
      Ra.sl[6]=1852; /* line # 1852 */
      PAS_INSMBOL_m_expr_instk();
      Ra.sl[6]=1853; /* line # 1853 */
      if (V_sy_sym.ub[0]==14) P_insymbol_src();
      else {
        Ra.sl[6]=1854; /* line # 1854 */
        P_src_error(Rd.s+1744,23,3);
      }
    }
    else {
      Ra.sl[6]=1856; /* line # 1856 */
      PAS_INSMBOL_mexp_ident();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_mul "  */
void PAS_INSMBOL_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1748;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1861; /* line # 1861 */
  PAS_INSMBOL_PRC_00000012();
  Ra.sl[6]=1862; /* line # 1862 */
  Ra.sl[6]=1863; /* line # 1863 */
  while (V_sy_sym.ub[0]==8){
    Ra.sl[6]=1865; /* line # 1865 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1866; /* line # 1866 */
    P_insymbol_src();
    Ra.sl[6]=1867; /* line # 1867 */
    PAS_INSMBOL_PRC_00000012();
    Ra.sl[6]=1868; /* line # 1868 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_add "  */
void PAS_INSMBOL_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1758;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1873; /* line # 1873 */
  PAS_INSMBOL_PRC_00000011();
  Ra.sl[6]=1874; /* line # 1874 */
  Ra.sl[6]=1875; /* line # 1875 */
  while (V_sy_sym.ub[0]==9){
    Ra.sl[6]=1877; /* line # 1877 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1878; /* line # 1878 */
    P_insymbol_src();
    Ra.sl[6]=1879; /* line # 1879 */
    PAS_INSMBOL_PRC_00000011();
    Ra.sl[6]=1880; /* line # 1880 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_rel "  */
void PAS_INSMBOL_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1768;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1885; /* line # 1885 */
  PAS_INSMBOL_PRC_00000010();
  Ra.sl[6]=1886; /* line # 1886 */
  Ra.sl[6]=1887; /* line # 1887 */
  while (V_sy_sym.ub[0]==10){
    Ra.sl[6]=1889; /* line # 1889 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1890; /* line # 1890 */
    P_insymbol_src();
    Ra.sl[6]=1891; /* line # 1891 */
    PAS_INSMBOL_PRC_00000010();
    Ra.sl[6]=1892; /* line # 1892 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_and "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1778;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1897; /* line # 1897 */
  PAS_INSMBOL_PRC_00000009();
  Ra.sl[6]=1898; /* line # 1898 */
  Ra.sl[6]=1899; /* line # 1899 */
  while (V_sy_sym.ub[0]==11){
    Ra.sl[6]=1901; /* line # 1901 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1902; /* line # 1902 */
    P_insymbol_src();
    Ra.sl[6]=1903; /* line # 1903 */
    PAS_INSMBOL_PRC_00000009();
    Ra.sl[6]=1904; /* line # 1904 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " m_expr_instk "  */
void PAS_INSMBOL_m_expr_instk(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1788;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1909; /* line # 1909 */
  PAS_INSMBOL_PRC_00000008();
  Ra.sl[6]=1910; /* line # 1910 */
  Ra.sl[6]=1911; /* line # 1911 */
  while (V_sy_sym.ub[0]==12){
    Ra.sl[6]=1913; /* line # 1913 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1914; /* line # 1914 */
    P_insymbol_src();
    Ra.sl[6]=1915; /* line # 1915 */
    PAS_INSMBOL_PRC_00000008();
    Ra.sl[6]=1916; /* line # 1916 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_sval "  */
void PAS_INSMBOL_mexpr_sval(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1802;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1924; /* line # 1924 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1925; /* line # 1925 */
  PAS_INSMBOL_mexp_strv(F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_ival "  */
SL PAS_INSMBOL_mexpr_ival(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1814;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1932; /* line # 1932 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1933; /* line # 1933 */
  Ret=PAS_INSMBOL_mexp_intv();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexpr_bval "  */
UB PAS_INSMBOL_mexpr_bval(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1826;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1940; /* line # 1940 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1941; /* line # 1941 */
  Ret=PAS_INSMBOL_mexp_intv()>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_pragma_mstate(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1080 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+888,16);
  Ra.ub[16]=255;
  PAS__STR_TO_STR(Ra.s+16,Rd.s+1838);
  Ra.ub[273]=255;
  PAS__STR_TO_STR(Ra.s+273,Rd.s+1838);
  Ra.ub[530]=255;
  PAS__STR_TO_STR(Ra.s+530,Rd.s+1838);
  Ra.ub[787]=255;
  PAS__STR_TO_STR(Ra.s+787,Rd.s+1838);
  Ra.v[131]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1048;
  Ra.v[132]=Rd.s+2095;
  Ra.v[133]=Rd.s+16;
  Ra.sl[268]=2020; /* line # 2020 */
  P_insymbol_src();
  Ra.sl[268]=2021; /* line # 2021 */
  Rv0=V_sy_label_flag;
  Ra.sl[268]=2022; /* line # 2022 */
  V_sy_label_flag=0;
  Ra.sl[268]=2023; /* line # 2023 */
  Rv1=F_p_src;
  Ra.sl[268]=2025; /* line # 2025 */
  Rv2=35&((UL *)Rv1)[62];
  Ra.sl[268]=2026; /* line # 2026 */
  while (V_sy_sym.ub[0]==0){
    Ra.sl[268]=2028; /* line # 2028 */
    Rv3=0;
    Ra.sl[268]=2029; /* line # 2029 */
    Rv4=0;
    while (1){
      Ra.sl[268]=2031; /* line # 2031 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      Ra.sl[268]=2032; /* line # 2032 */
      if (Rv3||Rv4==23)  break;
      Ra.sl[268]=2033; /* line # 2033 */
      Rv4=Rv4+1;
    }
    Ra.sl[268]=2035; /* line # 2035 */
    P_insymbol_src();
    Ra.sl[268]=2036; /* line # 2036 */
    switch (Rv4) {
      case 0:Ra.sl[268]=2039; /* line # 2039 */
      PAS_INSMBOL_get_macro_value(Ra.s);
      Ra.sl[268]=2040; /* line # 2040 */
      if (Ra.ub[0]==1) {
        Ra.sl[268]=2042; /* line # 2042 */
        PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+16);
        Ra.sl[268]=2043; /* line # 2043 */
        if (Ra.ub[17]>0) {
          Ra.sl[268]=2044; /* line # 2044 */
          Rv5=V_lst_current;
          Ra.sl[268]=2047; /* line # 2047 */
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          Ra.sl[268]=2049; /* line # 2049 */
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+273,((V *)Rv5)[2]);
          Ra.sl[268]=2050; /* line # 2050 */
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+530,((V *)Rv5)[4]);
          Ra.sl[268]=2051; /* line # 2051 */
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+787,((V *)Rv5)[5]);
          Ra.sl[268]=2053; /* line # 2053 */
          P_lst_open(&V_lst_current, Ra.s+16,Ra.s+273,Ra.s+530,Ra.s+787,132,-1,0,0,0,
          &Rv6);
          Ra.sl[268]=2065; /* line # 2065 */
          if (Rv6!=0) {
            Ra.sl[268]=2066; /* line # 2066 */
            if (!V_sy_init_mod) {
              Ra.sl[268]=2068; /* line # 2068 */
              P_src_error(Rd.s+2112,905,2);
            }
            else {
              Ra.sl[268]=2070; /* line # 2070 */
              Rv2=Rv2&~1;
            }
          }
          else {
            Ra.sl[268]=2073; /* line # 2073 */
            if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
            Ra.sl[268]=2074; /* line # 2074 */
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[268]=2078; /* line # 2078 */
          Rv2=Rv2&~1;
        }
      }
      Ra.sl[268]=2080; /* line # 2080 */
      if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
      Ra.sl[268]=2081; /* line # 2081 */
      Rv2=Rv2|1;
      break;
      case 1:Ra.sl[268]=2084; /* line # 2084 */
      Rv2=Rv2&~1;
      break;
      case 2:Ra.sl[268]=2086; /* line # 2086 */
      Rv2=Rv2|2;
      break;
      case 3:Ra.sl[268]=2087; /* line # 2087 */
      Rv2=Rv2&~2;
      break;
      case 4:Ra.sl[268]=2089; /* line # 2089 */
      Rv2=Rv2|32;
      break;
      case 5:Ra.sl[268]=2090; /* line # 2090 */
      Rv2=Rv2&~32;
      break;
      case 6:Ra.sl[268]=2094; /* line # 2094 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2095; /* line # 2095 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2097; /* line # 2097 */
        ((SL *)Rv1)[8]=V_sy_ival;
        Ra.sl[268]=2098; /* line # 2098 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2100; /* line # 2100 */
        ((SL *)Rv1)[8]=1;
      }
      break;
      case 7:Ra.sl[268]=2105; /* line # 2105 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2106; /* line # 2106 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2108; /* line # 2108 */
        ((SL *)Rv1)[11]=V_sy_ival;
        Ra.sl[268]=2109; /* line # 2109 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2111; /* line # 2111 */
        ((SL *)Rv1)[11]=1;
      }
      Ra.sl[268]=2112; /* line # 2112 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2113; /* line # 2113 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2114; /* line # 2114 */
        ((SL *)Rv1)[12]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2115; /* line # 2115 */
        ((SL *)Rv1)[12]=255;
      }
      break;
      case 8:Ra.sl[268]=2118; /* line # 2118 */
      V_cmp_macf=1;
      break;
      case 9:Ra.sl[268]=2119; /* line # 2119 */
      V_cmp_macf=0;
      break;
      case 10:Ra.sl[268]=2121; /* line # 2121 */
      V_cmp_cobj=1;
      break;
      case 11:Ra.sl[268]=2122; /* line # 2122 */
      V_cmp_cobj=0;
      break;
      case 12:Ra.sl[268]=2125; /* line # 2125 */
      if (V_sy_sym.ub[0]==5) {
        Ra.sl[268]=2126; /* line # 2126 */
        if (V_sy_ident.ub[0]>0) {
          Ra.sl[268]=2128; /* line # 2128 */
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Ra.sl[268]=2129; /* line # 2129 */
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[268]=2130; /* line # 2130 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          Ra.sl[268]=2131; /* line # 2131 */
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else {
          Ra.sl[268]=2133; /* line # 2133 */
          P_src_error(Rd.s+2112,904,4);
        }
      }
      else {
        Ra.sl[268]=2136; /* line # 2136 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 13:Ra.sl[268]=2140; /* line # 2140 */
      if (V_cmp_objf) {
        Ra.sl[268]=2142; /* line # 2142 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 14:Ra.sl[268]=2145; /* line # 2145 */
      V_cmp_bltt=1;
      break;
      case 15:Ra.sl[268]=2146; /* line # 2146 */
      V_cmp_bltt=0;
      break;
      case 16:Ra.sl[268]=2149; /* line # 2149 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2153; /* line # 2153 */
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[268]=2154; /* line # 2154 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2156; /* line # 2156 */
        P_src_error(Rd.s+2112,906,3);
      }
      break;
      case 17:Ra.sl[268]=2158; /* line # 2158 */
      V_cmp_debugopt=1;
      break;
      case 18:Ra.sl[268]=2159; /* line # 2159 */
      V_cmp_debugopt=0;
      break;
      case 19:Ra.sl[268]=2161; /* line # 2161 */
      V_cmp_range=1;
      break;
      case 20:Ra.sl[268]=2162; /* line # 2162 */
      V_cmp_range=0;
      break;
      case 21:Ra.sl[268]=2164; /* line # 2164 */
      P_generation_pragma();
      break;
      case 22:Ra.sl[268]=2166; /* line # 2166 */
      V_cmp_cmpdbg=1;
      break;
      case 23:Ra.sl[268]=2167; /* line # 2167 */
      V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[268]=2170; /* line # 2170 */
      P_src_error_s(Rd.s+2112,901,1, V_sy_ident.s,NULL);
      break;
    }
    Ra.sl[268]=2172; /* line # 2172 */
    if (V_sy_sym.ub[0]==17) P_insymbol_src();
  }
  Ra.sl[268]=2174; /* line # 2174 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+2112,21,2);
  else {
    Ra.sl[268]=2175; /* line # 2175 */
    P_insymbol_src();
  }
  Ra.sl[268]=2176; /* line # 2176 */
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~35|Rv2;
  Ra.sl[268]=2178; /* line # 2178 */
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[131];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_include_mstate(UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 800 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=254;
  Ra.ub[256]=254;
  Ra.v[64]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+512;
  Ra.v[65]=Rd.s+2116;
  Ra.v[66]=Rd.s+16;
  Ra.sl[134]=2196; /* line # 2196 */
  Ra.sl[134]=2198; /* line # 2198 */
  Rv0=V_sy_sym.ub[0]==103;
  Ra.sl[134]=2199; /* line # 2199 */
  P_insymbol_src();
  Ra.sl[134]=2200; /* line # 2200 */
  PAS_INSMBOL_mexpr_sval(Ra.s);
  Ra.sl[134]=2201; /* line # 2201 */
  Rv1=NULL;
  Ra.sl[134]=2202; /* line # 2202 */
  Rv2=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  Ra.sl[134]=2203; /* line # 2203 */
  if (Rv2==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+540,Ra.s,Rd.s+2132));
  Ra.sl[134]=2205; /* line # 2205 */
  Rv1=P_src_file_open(Ra.s,0,NULL);
  Ra.sl[134]=2206; /* line # 2206 */
  if (V_src_openerr==0) {
    Ra.sl[134]=2208; /* line # 2208 */
    Rv3=Rv1;
    Ra.sl[134]=2210; /* line # 2210 */
    ((V *)Rv3)[1]=V_src_control;
    Ra.sl[134]=2211; /* line # 2211 */
    ((SL *)Rv3)[7]=((SL *)V_src_control)[7];
    Ra.sl[134]=2212; /* line # 2212 */
    if (Rv0) ((SL *)Rv3)[7]=((SL *)Rv3)[7]+1;
    Ra.sl[134]=2213; /* line # 2213 */
    ((SL *)Rv3)[8]=((SL *)V_src_control)[8];
    Ra.sl[134]=2214; /* line # 2214 */
    ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
    Ra.sl[134]=2215; /* line # 2215 */
    ((SL *)Rv3)[11]=((SL *)V_src_control)[11];
    Ra.sl[134]=2216; /* line # 2216 */
    ((SL *)Rv3)[12]=((SL *)V_src_control)[12];
    Ra.sl[134]=2217; /* line # 2217 */
    ((UL *)Rv3)[62]=((UL *)Rv3)[62]|((UL *)V_src_control)[62]&103;
    Ra.sl[134]=2221; /* line # 2221 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[134]=2223; /* line # 2223 */
      P_insymbol_src();
      Ra.sl[134]=2224; /* line # 2224 */
      PAS_INSMBOL_pragma_mstate(Rv1);
    }
    else {
      Ra.sl[134]=2227; /* line # 2227 */
      if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+2140,21,2);
    }
    Ra.sl[134]=2228; /* line # 2228 */
    if (!Rv0) P_src_end_of_line();
    Ra.sl[134]=2229; /* line # 2229 */
    V_src_control=Rv1;
    Ra.sl[134]=2230; /* line # 2230 */
    if (V_cmp_trace>0) V_cmp_tracecount=0;
    Ra.sl[134]=2231; /* line # 2231 */
    P_compile_set_title();
    Ra.sl[134]=2232; /* line # 2232 */
    P_set_srcfilespc((SL)Rv0);
    Ra.sl[134]=2233; /* line # 2233 */
    V_sy_ch=32;
    Ra.sl[134]=2234; /* line # 2234 */
    V_sy_sym.ub[0]=104;
    Ra.sl[134]=2235; /* line # 2235 */
    if (!Rv0) {
      Ra.sl[134]=2237; /* line # 2237 */
      Rv4=V_src_control;
      Ra.sl[134]=2239; /* line # 2239 */
      Rv1=((V *)Rv4)[1];
      Ra.sl[134]=2240; /* line # 2240 */
      ((V *)Rv4)[1]=((V *)Rv1)[1];
      Ra.sl[134]=2242; /* line # 2242 */
      P_src_close(&Rv1,1);
    }
    Ra.sl[134]=2244; /* line # 2244 */
    Rv5=V_src_control;
    Ra.sl[134]=2245; /* line # 2245 */
    if (1&((UL *)Rv5)[62]) {
      Ra.sl[134]=2247; /* line # 2247 */
      P_lst_newline();
      Ra.sl[134]=2248; /* line # 2248 */
      PAS__VWRITE_INIT(Ra.s+256,1);
      PAS__WRITE_STR(Rd.s+2144,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
      Ra.sl[134]=2249; /* line # 2249 */
      P_lst_put_string(Ra.s+256);
    }
  }
  else {
    Ra.sl[134]=2253; /* line # 2253 */
    P_lst_newline();
    Ra.sl[134]=2254; /* line # 2254 */
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Rd.s+2181,-1,-1,32);
    PAS__WRITE_INT(V_src_openerr,3,0);
    PAS__WRITE_STR(Rd.s+2203,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[134]=2255; /* line # 2255 */
    P_lst_put_string(Ra.s+256);
    Ra.sl[134]=2256; /* line # 2256 */
    P_lst_newline();
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_put_string(Ra.s+256);
    Ra.sl[134]=2257; /* line # 2257 */
    PAS__GET_RTL_MSG(V_src_openerr, Ra.s);
    Ra.sl[134]=2258; /* line # 2258 */
    P_lst_newline();
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Rd.s+2227,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_eoln();
    Ra.sl[134]=2267; /* line # 2267 */
    while ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=106){
      Ra.sl[134]=2269; /* line # 2269 */
      P_insymbol_src();
    }
    Ra.sl[134]=2270; /* line # 2270 */
    if (F_bnsferr) {
      Ra.sl[134]=2271; /* line # 2271 */
      P_src_error(Rd.s+2140,902,4);
    }
    else {
      Ra.sl[134]=2273; /* line # 2273 */
      P_src_error(Rd.s+2140,902,3);
    }
  }
  Ra.sl[134]=2276; /* line # 2276 */
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[64];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_endfile_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 544 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=254;
  Ra.v[32]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+256;
  Ra.v[33]=Rd.s+2244;
  Ra.v[34]=Rd.s+16;
  Ra.sl[70]=2288; /* line # 2288 */
  Rv0=V_src_control;
  Ra.sl[70]=2290; /* line # 2290 */
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=90;
  else {
    Ra.sl[70]=2293; /* line # 2293 */
    V_sy_ch=P_src_return(1);
    Ra.sl[70]=2294; /* line # 2294 */
    V_sy_sym.ub[0]=107;
    Ra.sl[70]=2295; /* line # 2295 */
    V_sy_ch=32;
    Ra.sl[70]=2296; /* line # 2296 */
    P_set_srcfilespc(-1);
    Ra.sl[70]=2297; /* line # 2297 */
    P_compile_set_title();
  }
  Ra.sl[70]=2299; /* line # 2299 */
  Rv1=V_src_control;
  Ra.sl[70]=2300; /* line # 2300 */
  if (1&((UL *)Rv1)[62]) {
    Ra.sl[70]=2302; /* line # 2302 */
    P_lst_newline();
    Ra.sl[70]=2303; /* line # 2303 */
    PAS__VWRITE_INIT(Ra.s,1);
    PAS__WRITE_STR(Rd.s+2260,-1,-1,32);
    PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+284,((V *)Rv1)[35]),-1,-1,32);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_EOLN();
    Ra.sl[70]=2305; /* line # 2305 */
    P_lst_put_string(Ra.s);
  }
  Ra.sl[70]=2308; /* line # 2308 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  Ra.sl[70]=2309; /* line # 2309 */
  if (V_sy_sym.ub[0]==90) V_pas_compile=0;
  else {
    Ra.sl[70]=2310; /* line # 2310 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[32];
}


/* Procedure/Function : " cnd_push "  */
UB PAS_INSMBOL_cnd_push(UB F_cds){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2297;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2319; /* line # 2319 */
  if (Ri.sl[232]<32) {
    Ra.sl[6]=2321; /* line # 2321 */
    Ri.sl[232]=Ri.sl[232]+1;
    Ra.sl[6]=2322; /* line # 2322 */
    Rs.ub[Ri.sl[232]+615]=F_cds;
  }
  else {
    Ra.sl[6]=2326; /* line # 2326 */
    P_src_error(Rd.s+2309,950,4);
    Ra.sl[6]=2327; /* line # 2327 */
    Rv0=0;
  }
  Ra.sl[6]=2329; /* line # 2329 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cnd_pop "  */
UB PAS_INSMBOL_cnd_pop(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2313;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2336; /* line # 2336 */
  if (Ri.sl[232]<=0) {
    Ra.sl[6]=2338; /* line # 2338 */
    P_src_error(Rd.s+2309,951,4);
    Ra.sl[6]=2339; /* line # 2339 */
    Rv0=0;
  }
  else {
    Ra.sl[6]=2341; /* line # 2341 */
    Ri.sl[232]=Ri.sl[232]-1;
  }
  Ra.sl[6]=2342; /* line # 2342 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cnd_check "  */
UB PAS_INSMBOL_cnd_check(UB F_cds){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2322;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2350; /* line # 2350 */
  if (Ri.sl[232]>0) {
    Ra.sl[6]=2352; /* line # 2352 */
    if (F_cds>=Rs.ub[Ri.sl[232]+615]) Rs.ub[Ri.sl[232]+615]=F_cds;
    else {
      Ra.sl[6]=2353; /* line # 2353 */
      Rv0=0;
    }
  }
  else {
    Ra.sl[6]=2354; /* line # 2354 */
    Rv0=0;
  }
  Ra.sl[6]=2356; /* line # 2356 */
  if (!Rv0) P_src_error(Rd.s+2309,952,4);
  Ra.sl[6]=2357; /* line # 2357 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mif_mstate "  */
UB PAS_INSMBOL_mif_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2333;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2372; /* line # 2372 */
  Ra.sl[6]=2374; /* line # 2374 */
  Rv0=V_sy_sym.ub[0];
  Ra.sl[6]=2375; /* line # 2375 */
  P_insymbol_src();
  Ra.sl[6]=2376; /* line # 2376 */
  switch (Rv0) {
    case 95:
    case 96:Ra.sl[6]=2380; /* line # 2380 */
    Rv1=V_sy_macsymb!=NULL^Rv0==96;
    Ra.sl[6]=2381; /* line # 2381 */
    P_insymbol_src();
    Ra.sl[6]=2382; /* line # 2382 */
    PAS_INSMBOL_cnd_push(0);
    break;
    case 94:Ra.sl[6]=2387; /* line # 2387 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    Ra.sl[6]=2388; /* line # 2388 */
    PAS_INSMBOL_cnd_push(0);
    break;
    case 99:Ra.sl[6]=2393; /* line # 2393 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    Ra.sl[6]=2394; /* line # 2394 */
    PAS_INSMBOL_cnd_check(1);
    break;
    default:break;
  }
  Ra.sl[6]=2399; /* line # 2399 */
  if (V_sy_sym.ub[0]!=97) P_src_error(Rd.s+2347,932,2);
  Ra.sl[6]=2401; /* line # 2401 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;
  UB Rv2;
  UB Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2351;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2433; /* line # 2433 */
  P_insymbol_src();
  Ra.sl[6]=2434; /* line # 2434 */
  Rv0=V_src_control;
  Ra.sl[6]=2435; /* line # 2435 */
  while (V_sy_sym.ub[0]>=91){
    Ra.sl[6]=2437; /* line # 2437 */
    switch (V_sy_sym.ub[0]) {
      case 103:
      case 104:Ra.sl[6]=2439; /* line # 2439 */
      PAS_INSMBOL_include_mstate(V_sy_init_mod);
      break;
      case 105:Ra.sl[6]=2442; /* line # 2442 */
      PAS_INSMBOL_pragma_mstate(V_src_control);
      break;
      case 91:Ra.sl[6]=2445; /* line # 2445 */
      PAS_INSMBOL_define_macro_symbol();
      break;
      case 92:Ra.sl[6]=2448; /* line # 2448 */
      PAS_INSMBOL_undefine_macro_mbol();
      break;
      case 93:Ra.sl[6]=2451; /* line # 2451 */
      PAS_INSMBOL_macro_assign_symbol();
      break;
      case 94:
      case 95:
      case 96:Ra.sl[6]=2455; /* line # 2455 */
      Rv1=((C *)Rv0)[54];
      while (1){
        Ra.sl[6]=2457; /* line # 2457 */
        Rv2=PAS_INSMBOL_mif_mstate();
        Ra.sl[6]=2458; /* line # 2458 */
        if (Rv2)  break;
        Ra.sl[6]=2460; /* line # 2460 */
        ((C *)Rv0)[54]=83;
        Ra.sl[6]=2461; /* line # 2461 */
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2368);
        Ra.sl[6]=2462; /* line # 2462 */
        ((C *)Rv0)[54]=Rv1;
        if (V_sy_sym.ub[0]!=99)  break;
      }
      Ra.sl[6]=2464; /* line # 2464 */
      if (Rv2||V_sy_sym.ub[0]==98) {
        Ra.sl[6]=2466; /* line # 2466 */
        ((C *)Rv0)[54]=Rv1;
        Ra.sl[6]=2467; /* line # 2467 */
        PAS_INSMBOL_cnd_check(2);
        Ra.sl[6]=2468; /* line # 2468 */
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2472; /* line # 2472 */
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2384);
        Ra.sl[6]=2473; /* line # 2473 */
        PAS_INSMBOL_cnd_pop();
        Ra.sl[6]=2474; /* line # 2474 */
        ((C *)Rv0)[54]=Rv1;
        Ra.sl[6]=2475; /* line # 2475 */
        if (V_sy_sym.ub[0]==100) P_insymbol_src();
        else {
          Ra.sl[6]=2476; /* line # 2476 */
          P_src_error(Rd.s+2363,953,4);
        }
      }
      break;
      case 98:
      case 99:
      case 100:Ra.sl[6]=2482; /* line # 2482 */
      Rv1=((C *)Rv0)[54];
      ((C *)Rv0)[54]=83;
      Ra.sl[6]=2483; /* line # 2483 */
      PAS_INSMBOL_skip_mcsymbol(Rd.s+2400);
      Ra.sl[6]=2484; /* line # 2484 */
      P_insymbol_src();
      Ra.sl[6]=2485; /* line # 2485 */
      ((C *)Rv0)[54]=Rv1;
      Ra.sl[6]=2486; /* line # 2486 */
      PAS_INSMBOL_cnd_pop();
      break;
      case 101:Ra.sl[6]=2490; /* line # 2490 */
      if (V_sy_macsymb!=NULL) {
        Ra.sl[6]=2492; /* line # 2492 */
        P_macro_replace(V_sy_macsymb);
        Ra.sl[6]=2493; /* line # 2493 */
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2496; /* line # 2496 */
        P_src_error_s(Rd.s+2363,995,3, V_sy_ident.s,NULL);
      }
      break;
      case 102:Ra.sl[6]=2500; /* line # 2500 */
      P_insymbol_src();
      Ra.sl[6]=2501; /* line # 2501 */
      if (V_sy_sym.ub[0]==13) P_insymbol_src();
      else P_src_error(Rd.s+2363,955,2);
      Ra.sl[6]=2502; /* line # 2502 */
      PAS__VWRITE_INIT(Ri.s+932,1);
      PAS__WRITE_STR(Rd.s+2416,-1,-1,32);
      PAS__WRITE_EOLN();
      while (1){
        Ra.sl[6]=2504; /* line # 2504 */
        P_insymbol_src();
        Ra.sl[6]=2505; /* line # 2505 */
        switch (V_sy_sym.ub[0]) {
          case 5:Ra.sl[6]=2507; /* line # 2507 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(V_sy_string.s,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          case 101:Ra.sl[6]=2511; /* line # 2511 */
          Rv3=1;
          Ra.sl[6]=2512; /* line # 2512 */
          if (V_sy_macsymb!=NULL) {
            Rv4=V_sy_macsymb+64;
            Ra.sl[6]=2513; /* line # 2513 */
            switch (((UB *)Rv4)[0]) {
              case 0:Ra.sl[6]=2514; /* line # 2514 */
              PAS__VWRITE_INIT(Ri.s+932,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rv4)[1],0,0);
              PAS__WRITE_EOLN();
              break;
              case 1:Ra.sl[6]=2515; /* line # 2515 */
              PAS__VWRITE_INIT(Ri.s+932,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_STR(((V *)Rv4)[1],-1,-1,32);
              PAS__WRITE_EOLN();
              break;
              default:Ra.sl[6]=2517; /* line # 2517 */
              Rv3=0;
              break;
            }
          }
          else {
            Ra.sl[6]=2519; /* line # 2519 */
            Rv3=0;
          }
          Ra.sl[6]=2520; /* line # 2520 */
          if (Rv3) {
            PAS__VWRITE_INIT(Ri.s+932,0);
            PAS__WRITE_STR(Rd.s+2433,-1,-1,32);
            PAS__WRITE_CHT(V_sy_ident.s+1,31, V_sy_ident.ub[0],-1,32);
            PAS__WRITE_CHAR(34);
            PAS__WRITE_EOLN();
          }
          break;
          case 0:Ra.sl[6]=2524; /* line # 2524 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(V_sy_ident.s+1,31, V_sy_ident.ub[0],-1,32);
          PAS__WRITE_EOLN();
          break;
          case 2:Ra.sl[6]=2527; /* line # 2527 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(V_sy_ival,12,0);
          PAS__WRITE_EOLN();
          break;
          case 3:Ra.sl[6]=2529; /* line # 2529 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(V_sy_rval,24,-15,0);
          PAS__WRITE_CHAR(70);
          PAS__WRITE_EOLN();
          break;
          case 4:Ra.sl[6]=2531; /* line # 2531 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(V_sy_rval,24,-15,0);
          PAS__WRITE_CHAR(68);
          PAS__WRITE_EOLN();
          break;
          default:Ra.sl[6]=2534; /* line # 2534 */
          P_src_error(Rd.s+2363,956,2);
          break;
        }
        Ra.sl[6]=2537; /* line # 2537 */
        P_insymbol_src();
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=2539; /* line # 2539 */
      P_lst_newline();
      P_lst_put_string(Ri.s+932);
      P_lst_eoln();
      Ra.sl[6]=2540; /* line # 2540 */
      if (V_sy_sym.ub[0]==14) P_insymbol_src();
      else {
        Ra.sl[6]=2541; /* line # 2541 */
        P_src_error(Rd.s+2363,957,2);
      }
      break;
      case 106:Ra.sl[6]=2547; /* line # 2547 */
      PAS_INSMBOL_endfile_mstate();
      break;
      default:Ra.sl[6]=2552; /* line # 2552 */
      P_src_error(Rd.s+2363,997,3);
      Ra.sl[6]=2553; /* line # 2553 */
      P_insymbol_src();
      break;
    }
    Ra.sl[6]=2555; /* line # 2555 */
    if (Ri.sl[232]<0) {
      Ra.sl[6]=2557; /* line # 2557 */
      P_src_error(Rd.s+2363,996,2);
      Ra.sl[6]=2558; /* line # 2558 */
      Ri.sl[232]=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2456;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2568; /* line # 2568 */
  Ra.sl[6]=2569; /* line # 2569 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=90){
    Ra.sl[6]=2571; /* line # 2571 */
    P_insymbol();
    Ra.sl[6]=2572; /* line # 2572 */
    switch (V_sy_sym.ub[0]) {
      case 56:Ra.sl[6]=2574; /* line # 2574 */
      if (!F_rec_flg) {
        Ra.sl[6]=2576; /* line # 2576 */
        P_skip_symbol(72,0,0);
        P_insymbol();
      }
      break;
      case 41:Ra.sl[6]=2580; /* line # 2580 */
      P_skip_symbol(72,1,0);
      P_insymbol();
      break;
      case 54:
      case 71:Ra.sl[6]=2584; /* line # 2584 */
      P_skip_symbol(72,0,0);
      P_insymbol();
      break;
      case 13:Ra.sl[6]=2588; /* line # 2588 */
      P_skip_symbol(14,0,0);
      P_insymbol();
      break;
      case 15:Ra.sl[6]=2592; /* line # 2592 */
      P_skip_symbol(16,0,0);
      P_insymbol();
      break;
      case 48:Ra.sl[6]=2596; /* line # 2596 */
      P_skip_symbol(49,0,0);
      P_insymbol();
      break;
      case 72:Ra.sl[6]=2599; /* line # 2599 */
      if (F_tosymbol==46||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_msymbol "  */
void P_skip_msymbol(V F_smb, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2469;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2609; /* line # 2609 */
  Ra.sl[6]=2610; /* line # 2610 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,108)||V_sy_sym.ub[0]==90)){
    Ra.sl[6]=2612; /* line # 2612 */
    P_insymbol();
    Ra.sl[6]=2613; /* line # 2613 */
    switch (V_sy_sym.ub[0]) {
      case 56:Ra.sl[6]=2615; /* line # 2615 */
      if (!F_rec_flg) {
        Ra.sl[6]=2617; /* line # 2617 */
        P_skip_msymbol(Rd.s+2484,0);
        P_insymbol();
      }
      break;
      case 41:Ra.sl[6]=2622; /* line # 2622 */
      P_skip_msymbol(Rd.s+2496,1);
      P_insymbol();
      break;
      case 54:
      case 71:Ra.sl[6]=2627; /* line # 2627 */
      P_skip_msymbol(Rd.s+2508,0);
      P_insymbol();
      break;
      case 13:Ra.sl[6]=2632; /* line # 2632 */
      P_skip_msymbol((V)Rd.s+2520,0);
      P_insymbol();
      break;
      case 15:Ra.sl[6]=2637; /* line # 2637 */
      P_skip_msymbol((V)Rd.s+2524,0);
      P_insymbol();
      break;
      case 48:Ra.sl[6]=2642; /* line # 2642 */
      P_skip_msymbol(Rd.s+2528,0);
      P_insymbol();
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2536;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2658; /* line # 2658 */
  P_lst_g_init(Rd.s+2547,Rd.s+2549,&Rv0);
  Ra.sl[6]=2660; /* line # 2660 */
  if (Rv0==0) {
    Ra.sl[6]=2663; /* line # 2663 */
    P_err_init(PAS__CON_STR_STR(Ra.s+28,V_cpas_ini_dir.s,Rd.s+2604));
    Ra.sl[6]=2666; /* line # 2666 */
    P_src_init(Rd.s+2618,V_trg_env_fspc.s);
    Ra.sl[6]=2668; /* line # 2668 */
    if (V_src_control==NULL) {
      Ra.sl[6]=2670; /* line # 2670 */
      V_error_result=4;
      V_emergency_stop=1;
      Ra.sl[6]=2671; /* line # 2671 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2625,-1,-1,32);
      PAS__WRITE_STR(V_trg_env_fspc.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+2675,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[6]=2672; /* line # 2672 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2692,-1,-1,32);
      PAS__WRITE_STR(V_trg_sys_name.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=2680; /* line # 2680 */
      PAS_INSMBOL_set_keyword_tree();
      Ra.sl[6]=2682; /* line # 2682 */
      V_proc_seq=0;
      Ra.sl[6]=2683; /* line # 2683 */
      V_srf_free=NULL;
      Ra.sl[6]=2684; /* line # 2684 */
      V_srf_list=NULL;
      Ra.sl[6]=2685; /* line # 2685 */
      Ri.sl[232]=0;
      Ra.sl[6]=2689; /* line # 2689 */
      P_ide_init();
      Ra.sl[6]=2692; /* line # 2692 */
      P_set_srcfilespc(1);
      Ra.sl[6]=2695; /* line # 2695 */
      V_sy_attrflg=0;
      Ra.sl[6]=2696; /* line # 2696 */
      V_sy_ch=32;
      Ra.sl[6]=2699; /* line # 2699 */
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[6]=2704; /* line # 2704 */
    V_error_result=4;
    V_emergency_stop=1;
    Ra.sl[6]=2705; /* line # 2705 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2748,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2547,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2772,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
