/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 2632 ) = {{
 16,  16, 103, 101, 110,  95, 111, 112, 101,  95,  97, 114, 103,  95, 108, 105,
115, 116,  75,  75,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114,
101,  47,  83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,
 99, 112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,
 66,  53,  45,  51,  95,  50,  48,  50,  52,  45,  48,  54,  45,  48,  53,  47,
112,  99, 109, 112,  95,  98,  97, 115, 100, 101, 102,  46, 112,  97, 115,   0,
  1,   0,   1,   0,   0,   0,  28,   0,   0,   0,   1,   0,   0,   0,   0,   0,
 28,   0,   0,   0,   1,   0,   2,   0,   0,   0,  28,   0,   0,   0,   1,   0,
  3,   0,   0,   0,  28,   0,   0,   0,   1,   0,   4,   0,   0,   0,  28,   0,
  0,   0,   1,   0,  17,   0,  64,   0,  28,   0,   0,   0,   1,   0,  15,   0,
  0,   0,  28,   0,   0,   0,   1,   0,  15,   0,  64,   0,  28,   0,   0,   0,
  1,   0,   2,   1,   0,   0,  28,   0,   0,   0,   2,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   2,   0,   1,   0,   0,   0,   1,   0,   0,   0,   2,   0,
  2,   0,   0,   0,   2,   0,   0,   0,   2,   0,   3,   0,   0,   0,   2,   0,
  0,   0,   2,   0,   3,   0,   0,   0,   2,   1,   0,   0,   2,   0,   2,   1,
  0,   0,   3,   0,   0,   0,   2,   0,   3,   0,   0,   0,   3,   0,   0,   0,
  2,   0,   2,   1,   0,   0,   2,   1,   0,   0,   2,   0,  14,   0,  32,   0,
 14,   0,   0,   0,   2,   0,  15,   0,  32,   0,  15,   0,   0,   0,   2,   0,
  5,   0, 160,   0,   5,   0, 128,   0,   2,   0,   6,   0, 160,   0,   6,   0,
128,   0,   2,   0,   5,   0,  33,   0,   5,   0, 136,   0,   2,   0,   6,   0,
 33,   0,   6,   0, 136,   0,   2,   0,  15,   0,  33,   0,  15,   0,   0,   0,
  2,   0,   3,   0,   1,   0,   2,   1,   0,   0,   2,   0,   2,   0,   1,   0,
  3,   2,   0,   0,   2,   0,   3,   0,   1,   0,   3,   0,   0,   0,   2,   0,
  4,   0,   0,   0,   2,   0,   0,   0,   2,   0,   4,   0,   0,   0,   2,   3,
  0,   0,   2,   0,   2,   3,   0,   0,   4,   0,   0,   0,   2,   0,   4,   0,
  0,   0,   4,   0,   0,   0,   2,   0,   3,   5,   0,   0,   4,   0,   0,   0,
  2,   0,   4,   0,   0,   0,   3,   5,   0,   0,   2,   0,   4,   0,   1,   0,
  2,   3,   0,   0,   2,   0,   4,   0,   1,   0,   3,   5,   0,   0,   2,   0,
  2,   0,   1,   0,   4,   4,   0,   0,   2,   0,   3,   0,   1,   0,   4,   6,
  0,   0,   2,   0,   4,   0,   1,   0,   4,   0,   0,   0,   2,   0,  17,   0,
 96,   0,  17,   0,   0,   0,   2,   0,  15,   0,   4,   0,  17,   0,   0,   0,
  2,   0,  17,   0,  32,   0,  17,   0,   0,   0,   2,   0,  21,   0,  24,   0,
 21,   0,   0,   0,   2,   0,  17,   0,  41,   0,  17,   0,   8,   0,   2,   0,
 21,   0,  25,   0,  21,   0,   8,   0,  18,  18, 105, 100, 101,  99, 116, 101,
 95,  99, 114, 101,  97, 116, 101,  95, 110,  97, 109, 101,  21,  21,  99, 114,
101,  97, 116, 101,  95, 115, 116, 100,  95,  99, 111, 110, 118, 101, 114, 115,
105, 111, 110,   2,   3,  64,   1,   3,   2,  65,   2,   1,   2,   0,   0,  14,
  2,   0,   0,   2,   0,   0,   0,   0,   2,   0,   0,   1,   2,   0,   0,  17,
  2,   0,   0,   2,  17,   0,   0,  13,   2,   0,   0,   2,   4,  80,   3,   4,
  2,  81,   4,   4,   3,  84,   6,   4,   4,   0,   0,   3,   4,  83,   5,   3,
  3,   0,   0,  19,  19,  99, 114, 101,  97, 116, 101,  95, 115, 116, 100,  95,
111, 112, 101, 114,  97, 116, 111, 114,   0,   6,   1,   0,   5,  89,   2,  11,
  5,  91,   3,  12,   5,  90,   3,  14,   5,  90,   3,  15,   6,  51,   2,  11,
  6,  69,   3,  13,   6,  69,   3,  14,   6,  69,   3,  15,   7,  70,   3,  16,
  7,  70,   3,  13,   7,  70,   3,  14,   7,  70,   3,  15,   8,  52,   2,  11,
  9,  53,   2,  11,  10,  54,   2,  11,  11,  49,   2,  11,  11,  67,   3,  13,
 11,  67,   3,  14,  11,  67,   3,  15,  12,  46,   2,   2,  12,  61,   3,   3,
 12,  50,   2,  11,  12,  68,   3,  13,  12,  68,   3,  14,  12,  68,   3,  15,
 14,  28,   1,   9,  14,  28,   1,  10,  14,  32,   1,  11,  14,  55,   1,  13,
 14,  55,   1,  14,  14,  55,   1,  15,  14,  28,   1,  17,  15,  29,   1,   9,
 15,  29,   1,  10,  15,  33,   1,  11,  15,  56,   1,  13,  15,  56,   1,  14,
 15,  56,   1,  15,  15,  29,   1,  17,  16,  30,   1,   9,  16,  30,   1,  10,
 16,  34,   1,  11,  16,  57,   1,  13,  16,  57,   1,  14,  16,  57,   1,  15,
 16,  30,   1,  17,  17,  31,   1,   9,  17,  31,   1,  10,  17,  35,   1,  11,
 17,  58,   1,  13,  17,  58,   1,  14,  17,  58,   1,  15,  17,  31,   1,  17,
 18,  27,   1,  18,  18,  60,   1,  13,  18,  60,   1,  14,  18,  60,   1,  15,
 18,  27,   1,  19,  18,  27,   1,  20,  19,  26,   1,  18,  19,  59,   1,  13,
 19,  59,   1,  14,  19,  59,   1,  15,  19,  26,   1,  19,  19,  26,   1,  20,
 20,   7,   1,  10,  21,   8,   1,  10,  22,   9,   1,  10,  28,   3,  28,  21,
 28,   3,  28,  22,  28,   3,  28,  23,  28,   4,  28,  24,  28,   3,  28,  25,
 28,   4,  28,  26,   5, 109,   4,  27,   5, 108,   4,  29,   5, 108,   4,  30,
  5, 108,   4,  31,   5, 108,   4,  32,   6,  87,   4,  28,   6,  87,   4,  29,
  6,  87,   4,  30,   6,  87,   4,  31,   6,  87,   4,  32,   7,  88,   4,  28,
  7,  88,   4,  29,   7,  88,   4,  30,   7,  88,   4,  31,   7,  88,   4,  32,
 11,  85,   4,  28,  11,  85,   4,  29,  11,  85,   4,  30,  11,  85,   4,  31,
 11,  85,   4,  32,  12,  77,   4,   4,  12,  86,   4,  28,  12,  86,   4,  29,
 12,  86,   4,  30,  12,  86,   4,  31,  12,  86,   4,  32,  14,  71,   1,  28,
 14,  71,   1,  29,  14,  71,   1,  31,  14,  71,   1,  32,  14,  71,   1,  30,
 15,  72,   1,  28,  15,  72,   1,  29,  15,  72,   1,  31,  15,  72,   1,  32,
 15,  72,   1,  30,  16,  73,   1,  28,  16,  73,   1,  29,  16,  73,   1,  31,
 16,  73,   1,  32,  16,  73,   1,  30,  17,  74,   1,  28,  17,  74,   1,  29,
 17,  74,   1,  31,  17,  74,   1,  32,  17,  74,   1,  30,  19,  75,   1,  28,
 19,  75,   1,  29,  19,  75,   1,  31,  19,  75,   1,  32,  19,  75,   1,  30,
 18,  76,   1,  28,  18,  76,   1,  29,  18,  76,   1,  31,  18,  76,   1,  32,
 18,  76,   1,  30,  28,   5,  28,  33,  28,   5,  28,  34,  28,   3,  28,  35,
 28,   4,  28,  36,  28,   5,  28,  37,   6,  11,  17,  38,  11,  14,  17,  38,
 12,  10,  17,   5,  12,  13,  17,  38,  22,  12,  17,  38,  23,  25,   1,  39,
 14,  19,   1,  40,  15,  20,   1,  40,  16,  21,   1,  40,  17,  22,   1,  40,
 19,  23,   1,  40,  18,  24,   1,  40,  18,  37,   1,  41,  19,  36,   1,  41,
 28,   3,  28,  42,  28,   1,  28,  43,  19,  19,  99, 114, 101,  97, 116, 101,
 95,  98, 108, 116,  95, 102, 117, 110,  99, 116, 105, 111, 110,   0,  43,  15,
  6,   1,  44,  15,   6,   2,   0,   2,   6,   3,   0,   0,   6,   4,  45,   1,
  2,   5,  65,   2,   3,   5,  81,   2,   4,   6,  66,   2,   3,   6,  82,   2,
  4,   7,  47,   2,   2,   7,  62,   3,   3,   7,  78,   4,   4,   8,  48,   2,
  2,   8,  63,   3,   3,   8,  79,   4,   4,   9,  92,   3,   8,   9,  92,   3,
  3,   9, 110,   4,   4,  10,  93,   3,   8,  10,  93,   3,   3,  10, 111,   4,
  4,  11,  94,   3,   8,  11,  94,   3,   3,  11, 112,   4,   4,  12,  95,   3,
  8,  12,  95,   3,   3,  12, 113,   4,   4,  13,  96,   3,   8,  13,  96,   3,
  3,  13, 114,   4,   4,  14,  97,   3,   8,  14,  97,   3,   3,  14, 115,   4,
  4,  15,  98,   3,   8,  15,  98,   3,   3,  15, 116,   4,   4,  15,  99,   3,
 16,  15,  99,   3,  13,  15,  99,   3,  14,  15,  99,   3,  15,  15, 117,   4,
 28,  15, 117,   4,  29,  15, 117,   4,  32,  15, 117,   4,  31,  15, 117,   4,
 30,  16, 100,   3,   8,  16, 100,   3,   3,  16, 118,   4,   4,  17, 101,   3,
  8,  17, 101,   3,   3,  17, 119,   4,   4,  18, 102,   3,   8,  18, 102,   3,
  3,  18, 120,   4,   4,  19, 103,   3,   8,  19, 103,   3,   3,  19, 121,   4,
  4,  20, 104,   3,   8,  20, 104,   3,   3,  20, 122,   4,   4,  21, 105,   3,
  8,  21, 105,   3,   3,  21, 123,   4,   4,  22, 106,   3,   8,  22, 106,   3,
  3,  22, 124,   4,   4,  23, 107,   3,   8,  23, 107,   3,   3,  23, 125,   4,
  4,   4, 115, 117,  99,  99,  32,  32,  32,  32,   4, 112, 114, 101, 100,  32,
 32,  32,  32,   3, 111, 114, 100,  32,  32,  32,  32,  32,   3,  99, 104, 114,
 32,  32,  32,  32,  32,   3, 111, 100, 100,  32,  32,  32,  32,  32,   5, 114,
111, 117, 110, 100,  32,  32,  32,   5, 116, 114, 117, 110,  99,  32,  32,  32,
  3,  97,  98, 115,  32,  32,  32,  32,  32,   3, 115, 113, 114,  32,  32,  32,
 32,  32,   4, 115, 113, 114, 116,  32,  32,  32,  32,   3, 115, 105, 110,  32,
 32,  32,  32,  32,   3,  99, 111, 115,  32,  32,  32,  32,  32,   3, 116,  97,
110,  32,  32,  32,  32,  32,   6,  97, 114,  99, 115, 105, 110,  32,  32,   6,
 97, 114,  99,  99, 111, 115,  32,  32,   6,  97, 114,  99, 116,  97, 110,  32,
 32,   3, 101, 120, 112,  32,  32,  32,  32,  32,   2, 108, 110,  32,  32,  32,
 32,  32,  32,   4, 115, 105, 110, 104,  32,  32,  32,  32,   4,  99, 111, 115,
104,  32,  32,  32,  32,   4, 116,  97, 110, 104,  32,  32,  32,  32,   7,  97,
114, 103, 115, 105, 110, 104,  32,   7,  97, 114, 103,  99, 111, 115, 104,  32,
  7,  97, 114, 103, 116,  97, 110, 104,  32,  18,  18, 105, 100, 101,  95,  99,
114, 101,  97, 116, 101,  95,  98, 117, 105, 108, 116, 105, 110,  19,  19, 105,
100, 101,  95,  99, 114, 101,  97, 116, 101,  95,  97, 116, 116, 114, 105,  98,
117, 116,  14,   7,  97, 100, 100, 114, 101, 115, 115,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 115, 105, 122, 101,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   5, 102, 105, 114, 115, 116,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 108,  97, 115, 116,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 112, 114, 101, 100,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 115, 117,  99,  99,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   5, 105, 109,  97, 103, 101,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   8, 102, 111,  98, 106, 115, 105, 122, 101,   0,   0,   0,   0,
  0,   0,  14,  11,  97, 114, 114,  95, 105,  95, 102, 105, 114, 115, 116,   0,
  0,   0,  14,  10,  97, 114, 114,  95, 105,  95, 108,  97, 115, 116,   0,   0,
  0,   0,  14,   6, 100, 105, 103, 105, 116, 115,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   7, 109,  97, 120,  95, 101, 120, 112,   0,   0,   0,   0,   0,
  0,   0,  14,   5, 115, 109,  97, 108, 108,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   7, 101, 112, 115, 105, 108, 111, 110,   0,   0,   0,   0,   0,
  0,   0,  14,   5, 108,  97, 114, 103, 101,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   8, 109,  97, 110, 116, 105, 115, 115,  97,   0,   0,   0,   0,
  0,   0,  14,  11,  99,  97, 114, 100, 105, 110,  97, 108, 105, 116, 121,   0,
  0,   0,  14,   7, 105, 100,  95, 110,  97, 109, 101,   0,   0,   0,   0,   0,
  0,   0,  14,   7, 105, 110, 104, 101, 114, 105, 116,   0,   0,   0,   0,   0,
  0,   0,  14,  11, 101, 110, 118, 105, 114, 111, 110, 109, 101, 110, 116,   0,
  0,   0,  14,   8, 114, 101,  97, 100, 111, 110, 108, 121,   0,   0,   0,   0,
  0,   0,  14,   8, 111, 112, 116, 105, 111, 110,  97, 108,   0,   0,   0,   0,
  0,   0,  14,   8, 118, 111, 108,  97, 116, 105, 108, 101,   0,   0,   0,   0,
  0,   0,  14,   4,  98, 121, 116, 101,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 119, 111, 114, 100,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 108, 111, 110, 103,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,   4, 113, 117,  97, 100,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  14,  12, 115, 101, 116, 101, 108, 101, 109,  95, 116, 121, 112, 101,
  0,   0,  14,  11, 100, 105, 114, 101,  99, 116,  95, 116, 121, 112, 101,   0,
  0,   0,  14,  11, 115,  97, 109, 116, 121, 112, 101,  95,  97, 114, 103,   0,
  0,   0,  14,  11, 101, 113, 117, 116, 121, 112, 101,  95,  97, 114, 103,   0,
  0,   0,  14,  11, 114, 101, 116, 117, 114, 110,  95, 116, 121, 112, 101,   0,
  0,   0,  14,  14, 103, 101, 110,  95,  99, 111, 110, 118,  95, 101, 110, 116,
114, 121,   8,   8, 105, 100, 101,  95, 105, 110, 105, 116,  10,  10,  46, 115,
116,  97, 110, 100,  97, 114, 100,  46,   7,   7, 105, 110, 116, 101, 103, 101,
114,   8,   8, 117, 110, 115, 105, 103, 110, 101, 100,  12,  12, 108, 111, 110,
103,  95, 105, 110, 116, 101, 103, 101, 114,  13,  13, 108, 111, 110, 103,  95,
117, 110, 115, 105, 103, 110, 101, 100,   4,   4,  99, 104,  97, 114,   6,   6,
115, 105, 110, 103, 108, 101,   6,   6, 100, 111, 117,  98, 108, 101,  13,  13,
 36, 119, 105, 108, 100,  95, 112, 111, 105, 110, 116, 101, 114,   3,   3, 110,
105, 108,  13,  13,  36, 119, 105, 108, 100,  95, 108, 105, 116, 101, 114,  97,
108,  11,  11,  36, 119, 105, 108, 100,  95, 101, 110, 110, 117, 109,  11,  11,
 36, 119, 105, 108, 100,  95, 116, 104, 105, 110, 103,  10,  10,  36, 119, 105,
108, 100,  95, 102, 105, 108, 101,  16,  16,  36, 119, 105, 108, 100,  95, 115,
105, 109, 112, 108, 101,  95, 115, 101, 116,  15,  15,  36, 119, 105, 108, 100,
 95, 108,  97, 114, 103, 101,  95, 115, 101, 116,   9,   9,  36, 119, 105, 108,
100,  95, 115, 101, 116,  12,  12,  36, 119, 105, 108, 100,  95, 114, 101,  99,
111, 114, 100,   3,   3,  46, 117, 108,   3,   3,  46, 117, 117,   3,   3,  46,
117, 116,   3,   3,  46, 117,  99,   3,   3,  46, 117, 118,   3,   3,  46, 117,
102,   3,   3,  46, 117, 103,   3,   3,  46, 117, 119,   3,   3,  46, 117, 112,
  3,   3,  46, 117, 115,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 352 );

/* Declaration of external variables. */
extern Blk(V_typ_std, 248 );
extern Blk(V_sy_ident, 32 );
extern Blk(V_oparg_cvtab, 56 );
extern Blk(V_ope_table, 240 );
extern V V_attr_list;
extern Blk(V_lex_ident_tree, 4160 );
extern SL V_curr_disp;
extern SL V_curr_lex;
extern SL V_cprc_disp;
extern Blk(V_lex_ident_level, 128 );
extern V V_pro_current;
extern V V_int_typ;
extern V V_uns_typ;
extern V V_lin_typ;
extern V V_lun_typ;
extern SL V_dst_seta;
extern SL V_dst_setw;
extern SL V_dst_seti;
extern SL V_inte_size;
extern SL V_fptr_size;
extern Blk(V_ide_udptr, 120 );
extern V V_std_store_dgf;
extern V V_std_store_dgl;
extern UB V_err_prt;


/* Function/procedure prototypes. */
void P_val_new(V *F_p, V F_ty);
V P_lgt_new_econst(V F_ty, SL F_iv);
void P_new_disp_level(V F_ow, UB F_kind);
void P_ide_new(UB F_fc, V F_ty, V *F_ip);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ);
void P_ide_create_name(V F_name);
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2);


/* Procedure/Function : " gen_ope_arg_list "  */
void PAS_BAS_DEF_gen_ope_arg_list(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register SL Rv2;
  V Rv3;
  register SL Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=293; /* line # 293 */
  Rv0=0;
  for( Rf1=44;Rf1>0;Rf1-- ) {
    Ra.sl[6]=294; /* line # 294 */
    Rv1=(Rd.s+Rv0*10+96);
    Ra.sl[6]=296; /* line # 296 */
    Rv2=((UB *)Rv1)[0];
    Rv3=PAS__NEW(Rv2*16+8);
    ((SL *)Rv3)[0]=Rv2;
    Rv4=0;
    for( Rf0=Rv2;Rf0>0;Rf0-- )
    Rv4++;
    Ra.sl[6]=297; /* line # 297 */
    Rv5=1;
    for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
      Ra.sl[6]=298; /* line # 298 */
      Rv6=(((S *)Rv3)+Rv5*16-8);
      Rv7=(((S *)Rv1)+Rv5*4-2);
      Ra.sl[6]=300; /* line # 300 */
      ((V *)Rv6)[0]=V_typ_std.v[((UB *)Rv7)[0]];
      Ra.sl[6]=301; /* line # 301 */
      ((UB *)Rv6)[8]=((UB *)Rv7)[1];
      Ra.sl[6]=302; /* line # 302 */
      ((UW *)Rv6)[5]=((UW *)Rv7)[1];
      Rv5++;
    }
    Ra.sl[6]=304; /* line # 304 */
    Rs.v[Rv0]=Rv3;
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " idecte_create_name "  */
void PAS_BAS_DEF_idecte_create_name(SL F_len, V F_nam, SL F__Sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+536;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=314; /* line # 314 */
  V_sy_ident.ub[0]=F_len;
  Ra.sl[6]=315; /* line # 315 */
  Rv0=1;
  for( Rf0=F_len;Rf0>0;Rf0-- ) {
    Ra.sl[6]=316; /* line # 316 */
    V_sy_ident.c[Rv0]=((C *)F_nam)[Rv0-1];
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_std_conversion "  */
void PAS_BAS_DEF_create_std_convsion(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+556;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=363; /* line # 363 */
  Rv0=1;
  for( Rf0=16;Rf0>0;Rf0-- ) {
    Ra.sl[6]=364; /* line # 364 */
    Rv1=(Rd.s+Rv0*4+575);
    Ra.sl[6]=366; /* line # 366 */
    Rv2=V_typ_std.v[((UB *)Rv1)[1]];
    Ra.sl[6]=367; /* line # 367 */
    Rv3=P_new_oper(((UB *)Rv1)[2],Rv2, V_typ_std.v[((UB *)Rv1)[0]],0,0,NULL,0,0);
    Ra.sl[6]=368; /* line # 368 */
    Rv4=((V *)Rv2)[3];
    Ra.sl[6]=370; /* line # 370 */
    if (((V *)Rv4)[10]==NULL) ((V *)Rv4)[10]=Rv3;
    else {
      Ra.sl[6]=371; /* line # 371 */
      ((V *)((V *)Rv4)[11])[0]=Rv3;
    }
    Ra.sl[6]=372; /* line # 372 */
    ((V *)Rv4)[11]=Rv3;
    Ra.sl[6]=374; /* line # 374 */
    if (((UB *)Rv1)[2]!=0) V_oparg_cvtab.v[((UB *)Rv1)[3]]=Rv3;
    Rv0++;
  }
  Ra.sl[6]=377; /* line # 377 */
  V_oparg_cvtab.v[0]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_std_operator "  */
void PAS_BAS_DEF_create_std_operator(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+643;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=586; /* line # 586 */
  Rv0=0;
  for( Rf0=30;Rf0>0;Rf0-- ) {
    V_ope_table.v[Rv0]=NULL;
    Rv0++;
  }
  Ra.sl[6]=587; /* line # 587 */
  Rv1=1;
  for( Rf0=152;Rf0>0;Rf0-- ) {
    Ra.sl[6]=588; /* line # 588 */
    Rv2=(Rd.s+Rv1*4+660);
    Ra.sl[6]=590; /* line # 590 */
    if (V_ope_table.v[((UB *)Rv2)[0]]==NULL) {
      Ra.sl[6]=592; /* line # 592 */
      Rv3=NULL;
      Ra.sl[6]=593; /* line # 593 */
      Rv3=PAS__NEW(40);
      V_ope_table.v[((UB *)Rv2)[0]]=Rv3;
      Ra.sl[6]=594; /* line # 594 */
      Rv4=Rv3;
      Ra.sl[6]=596; /* line # 596 */
      ((UB *)Rv4)[0]=((UB *)Rv2)[0];
      Ra.sl[6]=597; /* line # 597 */
      ((SL *)Rv4)[1]=0;
      Ra.sl[6]=598; /* line # 598 */
      ((V *)Rv4)[1]=NULL;
      Ra.sl[6]=599; /* line # 599 */
      ((V *)Rv4)[2]=NULL;
      Ra.sl[6]=600; /* line # 600 */
      ((V *)Rv4)[3]=NULL;
      Ra.sl[6]=601; /* line # 601 */
      ((V *)Rv4)[4]=NULL;
    }
    else {
      Ra.sl[6]=604; /* line # 604 */
      Rv3=V_ope_table.v[((UB *)Rv2)[0]];
    }
    Ra.sl[6]=605; /* line # 605 */
    Rv5=NULL;
    Ra.sl[6]=606; /* line # 606 */
    Rv5=PAS__NEW(32);
    Ra.sl[6]=607; /* line # 607 */
    Rv6=Rv5;
    Rv7=Rv3;
    Ra.sl[6]=609; /* line # 609 */
    ((V *)Rv6)[0]=NULL;
    Ra.sl[6]=610; /* line # 610 */
    ((UB *)Rv6)[8]=1;
    Ra.sl[6]=611; /* line # 611 */
    ((UB *)Rv6)[9]=((UB *)Rv2)[1];
    Ra.sl[6]=612; /* line # 612 */
    ((V *)Rv6)[2]=V_typ_std.v[((UB *)Rv2)[2]];
    Ra.sl[6]=613; /* line # 613 */
    ((V *)Rv6)[3]=Rs.v[((UB *)Rv2)[3]];
    Ra.sl[6]=615; /* line # 615 */
    if (((V *)Rv7)[3]==NULL) ((V *)Rv7)[3]=Rv5;
    else {
      Ra.sl[6]=616; /* line # 616 */
      ((V *)((V *)Rv7)[4])[0]=Rv5;
    }
    Ra.sl[6]=617; /* line # 617 */
    ((V *)Rv7)[4]=Rv5;
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_blt_function "  */
void PAS_BAS_DEF_create_blt_function(){
  /* Define the automatic variable space. */
  Blk( Ra, 224 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1272;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=730; /* line # 730 */
  Rv0=1;
  Ra.sl[6]=732; /* line # 732 */
  Rv1=0;
  for( Rf0=24;Rf0>0;Rf0-- ) {
    Ra.v[Rv1+4]=NULL;
    Rv1++;
  }
  Ra.sl[6]=734; /* line # 734 */
  Rv2=1;
  for( Rf0=69;Rf0>0;Rf0-- ) {
    Ra.sl[6]=735; /* line # 735 */
    Rv3=(Rd.s+Rv2*4+1289);
    Ra.sl[6]=737; /* line # 737 */
    if (Ra.v[((UB *)Rv3)[0]+4]==NULL) {
      Ra.sl[6]=738; /* line # 738 */
      Rv4=(Rd.s+((UB *)Rv3)[0]*9+1569);
      Ra.sl[6]=740; /* line # 740 */
      PAS_BAS_DEF_idecte_create_name(((UB *)Rv4)[0],Rv4+1,8);
      Ra.sl[6]=741; /* line # 741 */
      P_ide_new(9,NULL,&Rv5);
      Ra.sl[6]=742; /* line # 742 */
      Rv6=Rv5;
      Ra.sl[6]=744; /* line # 744 */
      ((V *)Rv6)[8]=NULL;
      Ra.sl[6]=745; /* line # 745 */
      ((V *)Rv6)[10]=NULL;
      Ra.sl[6]=746; /* line # 746 */
      ((V *)Rv6)[11]=NULL;
      Ra.sl[6]=748; /* line # 748 */
      Ra.v[((UB *)Rv3)[0]+4]=Rv5;
    }
    else {
      Ra.sl[6]=749; /* line # 749 */
      Rv5=Ra.v[((UB *)Rv3)[0]+4];
    }
    Ra.sl[6]=750; /* line # 750 */
    Rv7=PAS__NEW(32);
    Ra.sl[6]=751; /* line # 751 */
    Rv8=Rv5;
    Rv9=Rv7;
    Ra.sl[6]=753; /* line # 753 */
    ((V *)Rv9)[0]=NULL;
    Ra.sl[6]=754; /* line # 754 */
    ((UB *)Rv9)[8]=1;
    Ra.sl[6]=755; /* line # 755 */
    ((UB *)Rv9)[9]=((UB *)Rv3)[1];
    Ra.sl[6]=756; /* line # 756 */
    ((V *)Rv9)[2]=V_typ_std.v[((UB *)Rv3)[2]];
    Ra.sl[6]=757; /* line # 757 */
    ((V *)Rv9)[3]=Rs.v[((UB *)Rv3)[3]];
    Ra.sl[6]=758; /* line # 758 */
    if (((V *)Rv8)[10]==NULL) ((V *)Rv8)[10]=Rv7;
    else {
      Ra.sl[6]=759; /* line # 759 */
      ((V *)((V *)Rv8)[11])[0]=Rv7;
    }
    Ra.sl[6]=760; /* line # 760 */
    ((V *)Rv8)[11]=Rv7;
    Rv2++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_create_builtin "  */
void PAS_BAS_DEF_ide_create_builtin(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1785;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=769; /* line # 769 */
  PAS_BAS_DEF_gen_ope_arg_list();
  Ra.sl[6]=772; /* line # 772 */
  PAS_BAS_DEF_create_std_convsion();
  Ra.sl[6]=775; /* line # 775 */
  PAS_BAS_DEF_create_std_operator();
  Ra.sl[6]=778; /* line # 778 */
  PAS_BAS_DEF_create_blt_function();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_create_attribut "  */
void PAS_BAS_DEF_ide_create_attribut(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1805;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=841; /* line # 841 */
  P_new_disp_level(NULL,1);
  Ra.sl[6]=842; /* line # 842 */
  Rv0=0;
  for( Rf0=32;Rf0>0;Rf0-- ) {
    Ra.sl[6]=843; /* line # 843 */
    Rv1=(Rd.s+Rv0*16+1826);
    Ra.sl[6]=845; /* line # 845 */
    PAS_BAS_DEF_idecte_create_name(((UB *)Rv1)[1],Rv1+2,(UL)((UB *)Rv1)[0]);
    Ra.sl[6]=846; /* line # 846 */
    P_ide_new(12,NULL,&Rv2);
    Ra.sl[6]=847; /* line # 847 */
    ((UB *)Rv2)[54]=Rv0;
    Rv0++;
  }
  Ra.sl[6]=850; /* line # 850 */
  V_attr_list=V_lex_ident_tree.v[V_curr_disp*8+1];
  Ra.sl[6]=851; /* line # 851 */
  V_curr_disp=V_curr_disp-1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_conv_entry "  */
void P_gen_conv_entry(V F_tsrc, V F_tdst, UB F_pcd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2338;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=863; /* line # 863 */
  Rv0=P_new_oper(F_pcd, F_tdst, F_tsrc,0,0,NULL,0,0);
  Ra.sl[6]=864; /* line # 864 */
  Rv1=((V *)F_tdst)[3];
  Ra.sl[6]=866; /* line # 866 */
  if (((V *)Rv1)[10]==NULL) ((V *)Rv1)[10]=Rv0;
  else {
    Ra.sl[6]=867; /* line # 867 */
    ((V *)((V *)Rv1)[10])[0]=Rv0;
  }
  Ra.sl[6]=868; /* line # 868 */
  ((V *)Rv1)[11]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_init "  */
void P_ide_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2354;
  Ra.v[2]=Rd.s+18;
  Ra.sl[6]=886; /* line # 886 */
  V_curr_lex=0;
  Ra.sl[6]=887; /* line # 887 */
  V_curr_disp=-1;
  Ra.sl[6]=888; /* line # 888 */
  V_cprc_disp=0;
  Ra.sl[6]=889; /* line # 889 */
  V_lex_ident_level.sl[0]=0;
  Ra.sl[6]=890; /* line # 890 */
  Rv0=NULL;
  Ra.sl[6]=891; /* line # 891 */
  Rv0=PAS__NEW(245);
  Ra.sl[6]=892; /* line # 892 */
  P_new_disp_level(Rv0,5);
  Ra.sl[6]=894; /* line # 894 */
  V_pro_current=Rv0;
  Ra.sl[6]=895; /* line # 895 */
  Rv1=Rv0;
  Ra.sl[6]=897; /* line # 897 */
  P_ide_create_name(Rd.s+2364);
  Ra.sl[6]=898; /* line # 898 */
  ((V *)Rv1)[3]=PAS__NEW(32);
  Ra.sl[6]=899; /* line # 899 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[6]=900; /* line # 900 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=901; /* line # 901 */
  ((UW *)Rv1)[8]=0;
  Ra.sl[6]=902; /* line # 902 */
  memcpy(((V *)Rv1)[3],V_sy_ident.s,32);
  Ra.sl[6]=903; /* line # 903 */
  ((UB *)Rv1)[32]=29;
  Ra.sl[6]=904; /* line # 904 */
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=905; /* line # 905 */
  ((V *)Rv1)[6]=NULL;
  Ra.sl[6]=906; /* line # 906 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=907; /* line # 907 */
  ((V *)Rv1)[8]=NULL;
  Ra.sl[6]=908; /* line # 908 */
  ((SL *)Rv1)[18]=0;
  Ra.sl[6]=909; /* line # 909 */
  ((SL *)Rv1)[19]=0;
  Ra.sl[6]=910; /* line # 910 */
  ((SL *)Rv1)[20]=0;
  Ra.sl[6]=911; /* line # 911 */
  ((V *)Rv1)[11]=NULL;
  Ra.sl[6]=912; /* line # 912 */
  ((V *)Rv1)[12]=NULL;
  Ra.sl[6]=913; /* line # 913 */
  ((UB *)Rv1)[104]=1;
  Ra.sl[6]=918; /* line # 918 */
  P_ide_new_typ(21, &Rv2);
  Ra.sl[6]=919; /* line # 919 */
  ((SL *)Rv2)[11]=1;
  Ra.sl[6]=921; /* line # 921 */
  Rv3=5;
  for( Rf0=26;Rf0>0;Rf0-- ) {
    Ra.sl[6]=922; /* line # 922 */
    V_typ_std.v[Rv3]=Rv2;
    Rv3++;
  }
  Ra.sl[6]=926; /* line # 926 */
  P_ide_new_typ_range(-2147483647,2147483647,NULL,&V_int_typ);
  Ra.sl[6]=927; /* line # 927 */
  ((UB *)V_int_typ)[89]=0;
  Ra.sl[6]=928; /* line # 928 */
  ((SL *)V_int_typ)[29]=((SL *)V_int_typ)[29]-1;
  Ra.sl[6]=929; /* line # 929 */
  P_ide_create_name(Rd.s+2376);
  Ra.sl[6]=930; /* line # 930 */
  P_ide_new(1, V_int_typ, &Rv4);
  Ra.sl[6]=931; /* line # 931 */
  ((V *)V_int_typ)[3]=Rv4;
  Ra.sl[6]=932; /* line # 932 */
  V_typ_std.v[2]=V_int_typ;
  Ra.sl[6]=936; /* line # 936 */
  P_ide_new_typ_range(0,-1, V_int_typ, &V_uns_typ);
  Ra.sl[6]=937; /* line # 937 */
  ((UB *)V_uns_typ)[89]=0;
  Ra.sl[6]=938; /* line # 938 */
  P_ide_create_name(Rd.s+2385);
  Ra.sl[6]=939; /* line # 939 */
  P_ide_new(1, V_uns_typ, &Rv4);
  Ra.sl[6]=940; /* line # 940 */
  ((V *)V_uns_typ)[3]=Rv4;
  Ra.sl[6]=941; /* line # 941 */
  ((UB *)V_uns_typ)[112]=1;
  Ra.sl[6]=945; /* line # 945 */
  P_ide_new_typ_range(-2147483647,2147483647, V_int_typ, &V_lin_typ);
  Ra.sl[6]=946; /* line # 946 */
  ((UB *)V_lin_typ)[89]=0;
  Ra.sl[6]=947; /* line # 947 */
  ((SL *)V_lin_typ)[11]=8;
  Ra.sl[6]=948; /* line # 948 */
  P_ide_create_name(Rd.s+2395);
  Ra.sl[6]=949; /* line # 949 */
  P_ide_new(1, V_lin_typ,((V *)V_lin_typ)+3);
  Ra.sl[6]=952; /* line # 952 */
  P_ide_new_typ_range(0,2147483647, V_uns_typ, &V_lun_typ);
  Ra.sl[6]=953; /* line # 953 */
  ((UB *)V_lun_typ)[89]=0;
  Ra.sl[6]=954; /* line # 954 */
  ((SL *)V_lun_typ)[11]=8;
  Ra.sl[6]=955; /* line # 955 */
  P_ide_create_name(Rd.s+2409);
  Ra.sl[6]=956; /* line # 956 */
  P_ide_new(1, V_lun_typ,((V *)V_lun_typ)+3);
  Ra.sl[6]=957; /* line # 957 */
  ((UB *)V_lun_typ)[112]=1;
  Ra.sl[6]=961; /* line # 961 */
  P_ide_new_typ_range(0,0,NULL,&Rv2);
  Ra.sl[6]=962; /* line # 962 */
  ((UB *)V_int_typ)[89]=0;
  Ra.sl[6]=963; /* line # 963 */
  ((UB *)Rv2)[93]=1;
  Ra.sl[6]=964; /* line # 964 */
  ((SL *)Rv2)[11]=1;
  Ra.sl[6]=965; /* line # 965 */
  V_typ_std.v[1]=Rv2;
  Ra.sl[6]=968; /* line # 968 */
  P_ide_new_typ_range(0,255,NULL,&Rv2);
  Ra.sl[6]=969; /* line # 969 */
  ((UB *)V_int_typ)[89]=0;
  Ra.sl[6]=970; /* line # 970 */
  Rv5=Rv2;
  Ra.sl[6]=972; /* line # 972 */
  ((V *)Rv5)[9]=P_lgt_new_econst(V_typ_std.v[2],256);
  Ra.sl[6]=973; /* line # 973 */
  ((SL *)Rv5)[11]=1;
  ((UB *)Rv5)[93]=0;
  Ra.sl[6]=975; /* line # 975 */
  P_ide_create_name(Rd.s+2424);
  Ra.sl[6]=976; /* line # 976 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=977; /* line # 977 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=978; /* line # 978 */
  V_typ_std.v[0]=Rv2;
  Ra.sl[6]=982; /* line # 982 */
  P_ide_new_typ(3, &Rv2);
  Ra.sl[6]=983; /* line # 983 */
  ((SL *)Rv2)[11]=4;
  Ra.sl[6]=984; /* line # 984 */
  P_ide_create_name(Rd.s+2430);
  Ra.sl[6]=985; /* line # 985 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=986; /* line # 986 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=987; /* line # 987 */
  V_typ_std.v[3]=Rv2;
  Ra.sl[6]=991; /* line # 991 */
  P_ide_new_typ(4, &Rv2);
  Ra.sl[6]=992; /* line # 992 */
  ((SL *)Rv2)[11]=8;
  Ra.sl[6]=993; /* line # 993 */
  P_ide_create_name(Rd.s+2438);
  Ra.sl[6]=994; /* line # 994 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=995; /* line # 995 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=996; /* line # 996 */
  V_typ_std.v[4]=Rv2;
  Ra.sl[6]=998; /* line # 998 */
  P_ide_new_typ(11, &Rv2);
  Ra.sl[6]=999; /* line # 999 */
  ((SL *)Rv2)[11]=4;
  Ra.sl[6]=1000; /* line # 1000 */
  V_typ_std.v[11]=Rv2;
  Ra.sl[6]=1002; /* line # 1002 */
  P_ide_new_typ(12, &Rv2);
  Ra.sl[6]=1003; /* line # 1003 */
  ((SL *)Rv2)[11]=4;
  Ra.sl[6]=1004; /* line # 1004 */
  V_typ_std.v[12]=Rv2;
  Ra.sl[6]=1006; /* line # 1006 */
  V_typ_std.v[10]=NULL;
  Ra.sl[6]=1007; /* line # 1007 */
  V_typ_std.v[8]=NULL;
  Ra.sl[6]=1008; /* line # 1008 */
  V_typ_std.v[7]=NULL;
  Ra.sl[6]=1009; /* line # 1009 */
  V_typ_std.v[9]=NULL;
  Ra.sl[6]=1016; /* line # 1016 */
  P_ide_create_name(Rd.s+2446);
  Ra.sl[6]=1017; /* line # 1017 */
  P_ide_new_typ(5, &Rv2);
  Ra.sl[6]=1018; /* line # 1018 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1019; /* line # 1019 */
  ((SL *)Rv2)[11]=4;
  Ra.sl[6]=1020; /* line # 1020 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1021; /* line # 1021 */
  ((V *)Rv2)[12]=NULL;
  Ra.sl[6]=1023; /* line # 1023 */
  V_typ_std.v[5]=Rv2;
  Ra.sl[6]=1025; /* line # 1025 */
  P_ide_create_name(Rd.s+2461);
  Ra.sl[6]=1026; /* line # 1026 */
  P_ide_new_typ(13, &Rv2);
  Ra.sl[6]=1027; /* line # 1027 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1028; /* line # 1028 */
  ((SL *)Rv2)[11]=4;
  Ra.sl[6]=1029; /* line # 1029 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1030; /* line # 1030 */
  ((V *)Rv2)[12]=NULL;
  Ra.sl[6]=1032; /* line # 1032 */
  V_typ_std.v[13]=Rv2;
  Ra.sl[6]=1036; /* line # 1036 */
  P_ide_new_typ(6, &Rv2);
  Ra.sl[6]=1037; /* line # 1037 */
  ((SL *)Rv2)[11]=0;
  Ra.sl[6]=1038; /* line # 1038 */
  ((V *)Rv2)[13]=NULL;
  Ra.sl[6]=1039; /* line # 1039 */
  V_typ_std.v[6]=Rv2;
  Ra.sl[6]=1042; /* line # 1042 */
  P_ide_create_name(Rd.s+2466);
  Ra.sl[6]=1043; /* line # 1043 */
  P_ide_new_typ(14, &Rv2);
  Ra.sl[6]=1044; /* line # 1044 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1045; /* line # 1045 */
  ((SL *)Rv2)[11]=1;
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1046; /* line # 1046 */
  V_typ_std.v[14]=Rv2;
  Ra.sl[6]=1049; /* line # 1049 */
  P_ide_create_name(Rd.s+2481);
  Ra.sl[6]=1050; /* line # 1050 */
  P_ide_new_typ(15, &Rv2);
  Ra.sl[6]=1051; /* line # 1051 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1052; /* line # 1052 */
  ((SL *)Rv2)[11]=4;
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1053; /* line # 1053 */
  V_typ_std.v[15]=Rv2;
  Ra.sl[6]=1056; /* line # 1056 */
  P_ide_create_name(Rd.s+2494);
  Ra.sl[6]=1057; /* line # 1057 */
  Rv2=V_typ_std.v[21];
  Ra.sl[6]=1058; /* line # 1058 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1059; /* line # 1059 */
  ((SL *)Rv2)[11]=0;
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1060; /* line # 1060 */
  V_typ_std.v[21]=Rv2;
  Ra.sl[6]=1062; /* line # 1062 */
  P_ide_create_name(Rd.s+2507);
  Ra.sl[6]=1063; /* line # 1063 */
  P_ide_new_typ(16, &Rv2);
  Ra.sl[6]=1064; /* line # 1064 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1065; /* line # 1065 */
  ((SL *)Rv2)[11]=0;
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1066; /* line # 1066 */
  P_val_new(((V *)Rv2)+10,V_typ_std.v[13]);
  Ra.sl[6]=1067; /* line # 1067 */
  ((SL *)((V *)Rv2)[10])[13]=0;
  Ra.sl[6]=1068; /* line # 1068 */
  V_typ_std.v[16]=Rv2;
  Ra.sl[6]=1070; /* line # 1070 */
  V_dst_seta=256;
  Ra.sl[6]=1071; /* line # 1071 */
  V_dst_setw=32;
  Ra.sl[6]=1072; /* line # 1072 */
  V_dst_seti=8;
  Ra.sl[6]=1074; /* line # 1074 */
  P_ide_create_name(Rd.s+2519);
  Ra.sl[6]=1075; /* line # 1075 */
  P_ide_new_typ(17, &Rv2);
  Ra.sl[6]=1076; /* line # 1076 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1077; /* line # 1077 */
  ((SL *)Rv2)[11]=V_dst_setw/8;
  Ra.sl[6]=1078; /* line # 1078 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1079; /* line # 1079 */
  ((SL *)Rv2)[24]=V_dst_setw;
  Ra.sl[6]=1080; /* line # 1080 */
  ((V *)Rv2)[13]=V_int_typ;
  Ra.sl[6]=1081; /* line # 1081 */
  V_typ_std.v[17]=Rv2;
  Ra.sl[6]=1082; /* line # 1082 */
  P_ide_new_typ(17, &Rv2);
  Ra.sl[6]=1086; /* line # 1086 */
  P_ide_create_name(Rd.s+2537);
  Ra.sl[6]=1087; /* line # 1087 */
  P_ide_new_typ(18, &Rv2);
  Ra.sl[6]=1088; /* line # 1088 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1089; /* line # 1089 */
  ((SL *)Rv2)[11]=(V_dst_setw*V_dst_seti+7)/8;
  Ra.sl[6]=1090; /* line # 1090 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1091; /* line # 1091 */
  ((SL *)Rv2)[24]=V_dst_seta;
  Ra.sl[6]=1092; /* line # 1092 */
  ((V *)Rv2)[13]=V_int_typ;
  Ra.sl[6]=1093; /* line # 1093 */
  V_typ_std.v[18]=Rv2;
  Ra.sl[6]=1095; /* line # 1095 */
  P_ide_create_name(Rd.s+2554);
  Ra.sl[6]=1096; /* line # 1096 */
  P_ide_new_typ(19, &Rv2);
  Ra.sl[6]=1097; /* line # 1097 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1098; /* line # 1098 */
  ((SL *)Rv2)[11]=V_dst_setw/8;
  Ra.sl[6]=1099; /* line # 1099 */
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1100; /* line # 1100 */
  ((SL *)Rv2)[24]=0;
  Ra.sl[6]=1101; /* line # 1101 */
  V_typ_std.v[19]=Rv2;
  Ra.sl[6]=1103; /* line # 1103 */
  P_ide_create_name(Rd.s+2565);
  Ra.sl[6]=1104; /* line # 1104 */
  P_ide_new_typ(20, &Rv2);
  Ra.sl[6]=1105; /* line # 1105 */
  P_ide_new(1, Rv2, &Rv4);
  Ra.sl[6]=1106; /* line # 1106 */
  ((SL *)Rv2)[11]=0;
  ((V *)Rv2)[3]=Rv4;
  Ra.sl[6]=1107; /* line # 1107 */
  V_typ_std.v[20]=Rv2;
  Ra.sl[6]=1109; /* line # 1109 */
  P_ide_new_typ(28, &Rv2);
  Ra.sl[6]=1110; /* line # 1110 */
  ((SL *)Rv2)[11]=0;
  Ra.sl[6]=1111; /* line # 1111 */
  V_typ_std.v[28]=Rv2;
  Ra.sl[6]=1113; /* line # 1113 */
  V_inte_size=((SL *)V_typ_std.v[2])[11];
  Ra.sl[6]=1114; /* line # 1114 */
  V_fptr_size=((SL *)V_typ_std.v[13])[11];
  Ra.sl[6]=1117; /* line # 1117 */
  PAS_BAS_DEF_ide_create_attribut();
  Ra.sl[6]=1119; /* line # 1119 */
  PAS_BAS_DEF_ide_create_builtin();
  Ra.sl[6]=1122; /* line # 1122 */
  P_gen_conv_entry(V_typ_std.v[15],V_int_typ,0);
  Ra.sl[6]=1123; /* line # 1123 */
  P_gen_conv_entry(V_typ_std.v[13],V_uns_typ,0);
  Ra.sl[6]=1124; /* line # 1124 */
  P_gen_conv_entry(V_typ_std.v[15],V_uns_typ,0);
  Ra.sl[6]=1125; /* line # 1125 */
  P_gen_conv_entry(V_typ_std.v[15],V_typ_std.v[0],0);
  Ra.sl[6]=1128; /* line # 1128 */
  ((V *)((V *)V_uns_typ)[3])[10]=((V *)((V *)V_int_typ)[3])[10];
  Ra.sl[6]=1129; /* line # 1129 */
  ((V *)((V *)V_lin_typ)[3])[10]=((V *)((V *)V_int_typ)[3])[10];
  Ra.sl[6]=1130; /* line # 1130 */
  ((V *)((V *)V_lun_typ)[3])[10]=((V *)((V *)V_int_typ)[3])[10];
  Ra.sl[6]=1133; /* line # 1133 */
  P_ide_create_name(Rd.s+2579);
  Ra.sl[6]=1134; /* line # 1134 */
  P_ide_new(3, V_typ_std.v[21],V_ide_udptr.v+3);
  Ra.sl[6]=1135; /* line # 1135 */
  P_ide_create_name(Rd.s+2584);
  Ra.sl[6]=1136; /* line # 1136 */
  P_ide_new(2, V_typ_std.v[21],V_ide_udptr.v+2);
  Ra.sl[6]=1137; /* line # 1137 */
  P_ide_create_name(Rd.s+2589);
  Ra.sl[6]=1138; /* line # 1138 */
  P_ide_new(1, V_typ_std.v[21],V_ide_udptr.v+1);
  Ra.sl[6]=1139; /* line # 1139 */
  P_ide_create_name(Rd.s+2594);
  Ra.sl[6]=1140; /* line # 1140 */
  P_ide_new(4, V_typ_std.v[21],V_ide_udptr.v+4);
  Ra.sl[6]=1141; /* line # 1141 */
  Rv6=V_ide_udptr.v[4];
  Ra.sl[6]=1143; /* line # 1143 */
  P_val_new(((V *)Rv6)+7,V_typ_std.v[21]);
  Ra.sl[6]=1144; /* line # 1144 */
  ((UB *)((V *)Rv6)[7])[48]=28;
  Ra.sl[6]=1146; /* line # 1146 */
  P_ide_create_name(Rd.s+2599);
  Ra.sl[6]=1147; /* line # 1147 */
  P_ide_new(5, V_typ_std.v[21],V_ide_udptr.v+5);
  Ra.sl[6]=1148; /* line # 1148 */
  P_ide_create_name(Rd.s+2604);
  Ra.sl[6]=1149; /* line # 1149 */
  P_ide_new(6, V_typ_std.v[21],V_ide_udptr.v+6);
  Ra.sl[6]=1150; /* line # 1150 */
  P_ide_create_name(Rd.s+2609);
  Ra.sl[6]=1151; /* line # 1151 */
  P_ide_new(9, V_typ_std.v[21],V_ide_udptr.v+9);
  Ra.sl[6]=1152; /* line # 1152 */
  P_ide_create_name(Rd.s+2614);
  Ra.sl[6]=1153; /* line # 1153 */
  P_ide_new(8, V_typ_std.v[21],V_ide_udptr.v+8);
  Ra.sl[6]=1154; /* line # 1154 */
  P_ide_create_name(Rd.s+2619);
  Ra.sl[6]=1155; /* line # 1155 */
  P_ide_new(7, V_typ_std.v[21],V_ide_udptr.v+7);
  Ra.sl[6]=1156; /* line # 1156 */
  P_ide_create_name(Rd.s+2624);
  Ra.sl[6]=1157; /* line # 1157 */
  P_ide_new(10, V_typ_std.v[21],V_ide_udptr.v+10);
  Ra.sl[6]=1160; /* line # 1160 */
  V_std_store_dgf=((V *)V_ope_table.v[28])[3];
  Ra.sl[6]=1161; /* line # 1161 */
  V_std_store_dgl=((V *)V_ope_table.v[28])[4];
  Ra.sl[6]=1163; /* line # 1163 */
  V_err_prt=1;
  PAS__curr_cntx=Ra.v[0];
}
