{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*    ---  Utility to Create dedicated message selection  module  ---    *
*                                                                       *
*               ---  Version 3.1-A4 - 15/12/2014 ---                    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Neel                                         *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
program GEN_CPAS_RTL_MSG;
{ to generate a standart error message file for mxdcmp }



type
  msg_ptr              =      ^msg_rec; { * Define the message pointer }
  
  msg_rec( len: byte ) = record         { * Define the message record type }
    msg_next:                  msg_ptr; { Link to the next message }
    msg_ecod,                           { The error code value }
    msg_addr:                  integer; { Address of the message in the character table }
    msg_str:             string( len )  { The message } 
  end;

  msg_ent = record                      { * Define athe message entry record }
    ent_cod,                            { Error code number }
    ent_iad:                  integer;  { String of message index in the character message table }
    ent_msg:                  msg_ptr;  { Error message pointer in the the message table }
  end;

  { Define the message entry table }
  msg_etb( siz: integer ) = array[1..siz] of msg_ent;

  { Define the Index sorting table of messages }
  sort_tab( siz: integer ) = array[1..siz] of msg_ptr;

var
  frs_msg,                              { First and last pointer of ... }
  lst_msg:      msg_ptr :=         nil; { ... the message list queue. }

  msg_dir:                   ^msg_etb;  { Directory of message table }

  max_ecd,                              { Maximum error code }
  msg_siz,                              { Current top of the message memory }
  msg_cnt:      integer :=           0; { Message counter }

  pro_nm,                               { Procedure name }
  inp_nm,                               { Input and output file specification }
  out_nm:       string  :=          '';

  out:                            text; { Input and output files }



procedure SET_PARAMETERS;
{ To set the GEN_CPAS_RTL_MSG parameters }
var
  i, j:                integer;
  berr:       boolean := false;

begin
  { Get the GEN_CPAS_RTL_MSG Process Parameters }
  if argc > 1 then
  begin
    inp_nm := argv[1]^;
    if argc > 2 then out_nm := argv[2]^;
    if argc > 3 then pro_nm := argv[3]^
  end;
  if inp_nm.length = 0 then
  begin
    WRITELN; WRITE( ' Input File = ' ); READLN( inp_nm );
  end;
  if out_nm.length = 0 then
  begin
    WRITELN; WRITE( ' Output File = ' ); READLN( out_nm );
    i := INDEX( out_nm, '/', -1 );
    j := INDEX( out_nm, '.', -1 );
    if j <= i then out_nm := out_nm||'.pas'
  end;
  if pro_nm.length = 0 then
  begin
    WRITELN; WRITE( ' Procedure Name = ' ); READLN( pro_nm );
    for i := 1 to pro_nm.length do
      case pro_nm[i] of
        'A'..'Z', 'a'..'z', '#', '%', '$', '_': ;
        '0'..'9': if i = 1 then berr := true;
      otherwise
        berr := true
      end;
    if berr then
    begin
      WRITELN( 'GEN_CPAS_RTL_MSG : Illegal procedure name "', pro_nm, '"' );
      PASCAL_EXIT( 2 )
    end
  end
end SET_PARAMETERS;



procedure READ_MESSAGES;
var
  ch:             char;
  cline:        string; 
  p:           msg_ptr;
  nerr:        integer;
  inp:            text;

begin
  OPEN( inp, inp_nm, [read_file,error_file] );
  { Open the input file, and the message file }
  if iostatus <> 0 then
  begin
    WRITELN( ' Cannot Open the input file "', inp_nm, '".' );
    PASCAL_EXIT( 2 )
  end;
  while not EOF( inp ) do
  begin
    READ( inp, nerr );                  { Get error number }
    { Skip all trailing character until ";" }
    ch := ' ';
    while not EOLN( inp ) and (ch <> ';') do READ( inp, ch );
    READLN( inp, ch, cline );           { Read the message (but ignore the first space) }
    if cline.length > 0 then
    begin
      if max_ecd < nerr then max_ecd := nerr;
      NEW( p, cline.length );
      with p^ do
      begin
        msg_next :=        nil;
        msg_ecod :=       nerr;
        msg_addr :=    msg_siz;
        msg_str  :=      cline
      end;
      if frs_msg = nil then frs_msg := p
                       else lst_msg^.msg_next := p;
      lst_msg := p;
      msg_siz := msg_siz + cline.length + 1;
      msg_cnt := msg_cnt + 1
    end
  end;
  CLOSE( inp );
  if frs_msg = nil then
  begin
    WRITELN( ' GEN_CPAS_RTL_MSG : Any message was found in the file "', inp_nm, '" => Stop.' );
    PASCAL_EXIT( 2 )
  end
end READ_MESSAGES;



procedure MAKE_SORTING_AND_INDEX;
var
  pms:         msg_ptr;
  stb:       ^sort_tab;
  ind:         integer;

begin
  NEW( stb, max_ecd );
  for ecd := 1 to max_ecd do  stb^[ecd] := nil;
  pms := frs_msg;
  while pms <> nil do
  with pms^ do
  begin
    stb^[msg_ecod] := pms;
    pms := msg_next
  end;
  NEW( msg_dir, msg_cnt );
  ind := 0;
  for ecd := 1 to max_ecd do
    if stb^[ecd] <> nil then
    begin
      ind := ind + 1;
      with msg_dir^[ind] do
      begin
        ent_cod := ecd;
        ent_iad :=   0;
        ent_msg := stb^[ecd]
      end
    end;
  DISPOSE( stb )
end MAKE_SORTING_AND_INDEX;



procedure WRITE_PAS_CODE;
var
  iad, iad0, inb, ind: integer;

  byte_line: array[0..15] of byte;
  flag_line: array[0..15] of boolean;

  procedure OUT_LINE_OF_BYTE( bce: boolean );
  begin
    WRITE( out, ' ':4 );
    for ii := 0 to inb do
    begin
      WRITE( out, ' ', byte_line[ii]:-3 );
      if bce or (ii < inb) then WRITE( out, ',' )
                           else WRITE( out, ' ' )
    end;
    if inb < 15 then for ii := inb+1 to 15 do WRITE( out, ' ':5 );
    WRITE( out, ' { /', iad0:-5, ' : ' );
    for ii := 0 to inb do
    begin
      if flag_line[ii] then WRITE( out, ' ', byte_line[ii]:-3 )
                       else WRITE( out, ' ''', CHR( byte_line[ii] ), '''' );
      if bce or (ii < inb) then WRITE( out, ',' )
                           else WRITE( out, ' ' )
    end;
    if inb < 15 then for ii := inb+1 to 15 do WRITE( out, ' ':5 );
    WRITELN( out, ' }' )
  end OUT_LINE_OF_BYTE;



  procedure PUT_MSG_LENGTH( len: integer );
  begin
    inb := iad mod 16;
    if inb = 0 then iad0 := iad + 1;
    byte_line[inb] := len; flag_line[inb] := true;
    if inb = 15 then OUT_LINE_OF_BYTE( iad < msg_siz );
    iad := iad + 1
  end PUT_MSG_LENGTH;



  procedure PUT_MSG_CHAR( ch: char );
  begin
    inb := iad mod 16;
    if inb = 0 then iad0 := iad + 1;
    byte_line[inb] := ORD( ch ); flag_line[inb] := false;
    if inb = 15 then OUT_LINE_OF_BYTE( iad < msg_siz );
    iad := iad + 1
  end PUT_MSG_CHAR;



begin { WRITE_PAS_CODE }
  OPEN( out, out_nm, [write_file,error_file] );
  { If the file is existing, the old file is supershed }
  if iostatus <> 0 then
  begin
    WRITELN( ' Cannot Open the output file "', out_nm, '".' );
    PASCAL_EXIT( 2 )
  end;

  WRITELN( out, '{' );
  WRITELN( out, ' ***********************************************************************************' );
  WRITELN( out, ' *                                                                                 *' );
  WRITELN( out, ' *  This file is automatically generated from a specified data error message file  *' );
  WRITELN( out, ' *  by the  CPAS  Utilities program  GEN_CPAS_INCL_MSG.  The  included  procedure  *' );
  WRITELN( out, ' *  PAS__GET_INCL_MSG take the error number <nerr>, locates in its internal table  *' );
  WRITELN( out, ' *  the related message, and on success return it in the formal argument <msg>.    *' );
  WRITELN( out, ' *                                                                                 *' );
  WRITELN( out, ' *  This Pascal code is a part CPASCAL kit, and  as for its  other files of codes  *' );
  WRITELN( out, ' *  this document is protected by the GNU Global Public License License (GPL).     *' );
  WRITELN( out, ' *                                                                                 *' );
  WRITELN( out, ' *                                                                                 *' );
  WRITELN( out, ' *                                                                                 *' );
  WRITELN( out, ' ***********************************************************************************' );
  WRITELN( out, '}' );
  WRITELN( out );
  WRITELN( out, 'module GIMSG_', pro_nm, ';' );
  WRITELN( out );  
  WRITELN( out, '[global ''', pro_nm, ''']' );
  WRITELN( out, 'procedure ', pro_nm, '( nerr: integer; var msg: string );' );  
  WRITELN( out, 'const' );
  WRITELN( out, '  dir_size = ', msg_cnt:3, ';' );
  WRITELN( out );
  WRITELN( out, 'type' );
  WRITELN( out, '  err_entry = record' );
  WRITELN( out, '    err_cod,' );
  WRITELN( out, '    err_mad: short_integer ' );
  WRITELN( out, '  end;' );
  WRITELN( out );
  WRITELN( out, '[static] var' );
  WRITELN( out, '  ir, sz: integer;' );
  WRITELN( out );
  WRITELN( out, '  msg_tab: array[1..', msg_siz:0, '] of byte := [' );
  inb := 0;
  iad := 0;
  for ind := 1 to msg_cnt do
    with msg_dir^[ind], ent_msg^ do
    begin
      ent_iad := iad + 1;
      PUT_MSG_LENGTH( msg_str.length );
      for ii := 1 to msg_str.length do  PUT_MSG_CHAR( msg_str[ii] )
    end;  WRITELN( out );

  if inb mod 16 <> 15 then OUT_LINE_OF_BYTE( false );
  WRITELN( out, '  ];' );
  WRITELN( out );

  WRITELN( out, '  msg_dir: array[1..dir_size] of err_entry := [' );
  inb := 0;
  for ind := 1 to msg_cnt do
    with msg_dir^[ind] do
    begin
      inb := inb + 1;
      if inb = 1 then WRITE( out, ' ':4 );
      WRITE( out, '[ ', ent_cod:4, ', ', ent_iad:4, ']' );
      if ind = msg_cnt then
        WRITELN( out )
      else
        if inb = 8 then begin  WRITELN( out, ',' ); inb := 0  end
                   else WRITE( out, ', ' );
    end;
  if inb <> 0 then WRITELN( out );
  WRITELN( out, '  ];' );
  WRITELN( out );
  WRITELN( out );
  WRITELN( out, '  function LOCATE_MSG( ner, i1, i2: integer ): integer;' );
  WRITELN( out, '  var' );
  WRITELN( out, '    im, em: integer;' );
  WRITELN( out );
  WRITELN( out, '  begin' );
  WRITELN( out, '    if i2 - i1 <= 1 then' );
  WRITELN( out, '      if i2 = i1 then' );
  WRITELN( out, '        if ner = msg_dir[i1].err_cod then LOCATE_MSG := i1' );
  WRITELN( out, '                                     else LOCATE_MSG :=  0' );
  WRITELN( out, '      else' );
  WRITELN( out, '        if ner = msg_dir[i1].err_cod then LOCATE_MSG := i1' );
  WRITELN( out, '        else if ner = msg_dir[i2].err_cod then LOCATE_MSG := i2' );
  WRITELN( out, '                                          else LOCATE_MSG :=  0' );
  WRITELN( out, '    else' );
  WRITELN( out, '    begin' );
  WRITELN( out, '      im := (i1 + i2) div 2; em := msg_dir[im].err_cod;' );
  WRITELN( out, '      if ner = em then LOCATE_MSG := im' );
  WRITELN( out, '      else' );
  WRITELN( out, '        if ner < em then LOCATE_MSG := LOCATE_MSG( ner, i1, im )' );
  WRITELN( out, '                    else LOCATE_MSG := LOCATE_MSG( ner, im, i2 )' );
  WRITELN( out, '    end' );
  WRITELN( out, '  end LOCATE_MSG;' );
  WRITELN( out );
  WRITELN( out );
  WRITELN( out, 'begin { ', pro_nm, ' }' );
  WRITELN( out, '  ir  := LOCATE_MSG( nerr, 1, dir_size );' );
  WRITELN( out, '  if ir > 0 then' );
  WRITELN( out, '  with msg_dir[ir] do' );
  WRITELN( out, '  begin' );
  WRITELN( out, '    sz := msg_tab[err_mad];' );
  WRITELN( out, '    if sz > msg.capacity then sz := msg.capacity;' );
  WRITELN( out, '    for ii := 1 to sz do  msg[ii] := CHR( msg_tab[err_mad+ii] );' );
  WRITELN( out, '    msg.length := sz' );
  WRITELN( out, '  end' );
  WRITELN( out, '  else msg.length := 0' );
  WRITELN( out, 'end ', pro_nm, ';' );
  WRITELN( out );
  WRITELN( out, 'end GIMSG_', pro_nm, '.' );
  CLOSE( out )
end WRITE_PAS_CODE;


begin { GEN_CPAS_RTL_MSG }
  SET_PARAMETERS;
  READ_MESSAGES;
  MAKE_SORTING_AND_INDEX;
  WRITE_PAS_CODE;
  WRITELN( ' GEN_CPAS_INCL_MSG  has created the module "GIMSG_', pro_nm, '".' )
end GEN_CPAS_RTL_MSG.

