program test_schema;

type
    matrice( m, n: integer ) = array[1..m, 1..n] of integer;

var
    m1: matrice( 2, 2 ) := [ [  1,  0 ],
                             [  0, -1 ] ];

    m2: matrice( 3, 3 ) := [ [  0,  0,  1 ],
                             [  0,  1,  0 ],
                             [  1,  0,  0 ] ];

    m3: matrice( 3, 4 ) := [ [   1,   1,   2,   3 ],
                             [   5,   8,  13,  21 ],
                             [  34,  55,  89, 144 ]
                           ];

    m4: matrice( 2, 2 ) := [ [  0,  1 ],
                             [  1,  0 ]
                           ];
    m5: matrice( 2, 2 );



function transpose( in_var m: matrice( 2, 2 ) ): matrice( 2, 2 );
var
    s: integer;

begin
    if m.m < m.n then s := m.m else s := m.n;
    for i := 1 to s do
        for j := 1 to s do
            transpose[j,i] := m[i;j]
end transpose;



procedure := ( out_var d: matrice; in_var s: matrice );
begin
    if d.m <> s.m or d.n <> s.n then
        for i := 1 to d.m do
            for j := 1 to d.n do
                d[i,j] := 0
    else
    begin
        for i := 1 to d.m do
            for j := 1 to d.n do
                d[i,j] := s[i,j]
    end
end := ;



function * ( in_var a, b: matrice( 2, 2 ) ): matrice( 2, 2 );
var
    m: matrice( 2, 2 );
    s: integer;

begin
    for i := 1 to a.m do
        for j := 1 to a.n do
        begin
            s := 0;
            for k := 1 to a.n do
                s := s + a[i,k]*b[k,j];
            m[i,j] := s
        end;
    return m
end *;



procedure WRITE$OBJECT( in_var m: matrice; p, s: integer );
var

begin
    WRITELN;
    for i := 1 to m.m do
    begin
        WRITE( ' ':s, '|' );
        for j := 1 to m.n do
        begin
            if j > 1 then WRITE( ', ' );
            WRITE( m[i,j]:p )
        end;
        WRITELN( '   |' )
    end;
    WRITELN
end WRITE$OBJECT;


begin { Main program }

    WRITELN( "\n M1[ ", m1.m:2, ', ', m1.n:2, ' ] = ', m1:5:8, "\n" );
    WRITELN( "\n M2[ ", m2.m:2, ', ', m2.n:2, ' ] = ', m2:5:8, "\n" );
    WRITELN( "\n M3[ ", m3.m:2, ', ', m3.n:2, ' ] = ', m3:5:8, "\n" );

    m5 := m1*m4;

    WRITELN( "\n M1[ ", m1.m:2, ', ', m1.n:2, ' ] = ', m1:5:8, "\n" );
    WRITELN( "\n M4[ ", m4.m:2, ', ', m4.n:2, ' ] = ', m4:5:8, "\n" );
    WRITELN( "\n M5 = M1*M4 = [ ", m5.m:2, ', ', m5.n:2, ' ] = ', m5:5:8, "\n" );

end test_schema.
