program test_fpu_error;

var
  a, b, c:        real;
  i, j, k:     integer;
  op:     string( 15 );
  line:         string;

label ET_ERR;

function FPU_Handler( ierr: cc__int): cc__int;
var
  msg: string;

begin
  msg.length := 0;
  GET_RTL_MESSAGE( ierr, msg );
  WRITELN( ' Error # ', ierr:0, ' detected !' );
  WRITELN( ' Run Time Library message is : <', msg, '>' );
  goto ET_ERR;
  FPU_Handler := 0
end FPU_Handler;


begin
  ESTABLISH( FPU_Handler );
HELP:
  WRITELN( ' To test the computing exceptions, you enter' );
  WRITELN( ' An operator following of two numbers (here named <u> and <v> as :' );
  WRITELN( '  / 5 4  that give 1.25 but / 5 0 give a ZeroDevide Exception.' );
  WRITELN( ' The operators  can be +, -, *, / fr the floating operators,' );
  WRITELN( ' S or s for the Square Root, gives SQRT( v1 )*v2,' );
  WRITELN( ' L or l for the Neperian logarithme, gives LN( v1 )*v2,' );
  WRITELN( ' A or a for the ARCCOS function, gives ARCCOS( v1 )*v2,' ); 
  WRITELN( ' D, d, or R, r for the integer divide and remainder and' ); 
  WRITELN( ' M or m for the integer multiplication (no Overflow detection).' );
  WRITELN;
  WRITELN( '    To quit type EOT (=^D) or Q or q as operator.' );
  WRITELN;
  
RECOM:
  loop
    repeat
      WRITE( ' ope, a, b = ' ); READ( op::true );
exit RECOM if EOF( input ) or op[1]= 'q' or op[1] = 'Q' ;
      READLN( a, b );
    until op.length > 0;
  
    WRITELN( ' Perform the operation ', a, '  ', op, ' ', b );
    case op[1] of
      '+': begin  c := a + b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
      '-': begin  c := a - b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
      '*': begin  c := a * b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
      '/': begin  c := a / b; WRITELN( a, ' ', op, ' ', b, ' = ', c )  end;
      'S',
      's': begin  c := SQRT( a )*b; WRITELN( ' SQRT( ', a, ' )*', b, ' = ', c )  end;
      'L',
      'l': begin  c := LN( a )*b; WRITELN( ' LN( ', a, ' )*', b, ' = ', c )  end;
      'D',
      'd':
        begin
          i := ROUND( a ); j := ROUND( b ); k := i div j;
          WRITELN( ' ',  i:0, ' div ', j:0, ' = ', k:0 )
        end;
      'R',
      'r':
        begin
          i := ROUND( a ); j := ROUND( b ); k := i rem j;
          WRITELN( ' ',  i:0, ' rem ', j:0, ' = ', k:0 )
        end;
      'M',
      'm':
        begin
           i := ROUND( a ); j := ROUND( b ); k := i * j;
           WRITELN( ' ',  i:0, ' * ', j:0, ' = ', k:0 );
           WRITELN( ' ** Warning integer overflow is not detected **' );
        end;
      'a',
      'A':
        begin
          c := ARCCOS( a )*b;
          WRITELN( ' ACOS( ', a, ' )*', b, ' = ', c )
          end;
      'H',
      'h':
        goto HELP;
    otherwise
      WRITELN( ' Unknown operation !!!' );
      goto HELP
    end
  end;
  WRITELN( ' Normal End.' );
  PASCAL_EXIT;

ET_ERR:
  WRITELN( ' Handler as detected an Error !' );
  goto RECOM
end test_fpu_error.
