{ %pragma listlvl:2; }
{
 *************************************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                      MMM    MMM   XXX      XXX  DDDDDDDD              *
 *                      MMMM  MMMM    XXX    XXX   DDDDDDDDDD            *
 *                      MM MMMM MM     XXX  XXX    DD      DDD           *
 *                      MM  MM  MM      XXXXXX     DD       DD           *
 *                      MM      MM       XXXX      DD       DD           *
 *        T  H  E       MM      MM       XXXX      DD       DD           *
 *                      MM      MM      XXXXXX     DD       DD           *
 *                      MM      MM     XXX  XXX    DD      DDD           *
 *                      MM      MM    XXX    XXX   DDDDDDDDDD            *
 *                     MMMM    MMMM  XXX      XXX  DDDDDDDD              *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *              SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M              *
 *             S       Y   Y  S         T    E      MM   MM              *
 *             S        Y Y   S         T    E      M M M M              *
 *              SSSS     Y     SSSS     T    EEEEE  M  M  M              *
 *                  S    Y         S    T    E      M     M              *
 *                  S    Y         S    T    E      M     M  ..          *
 *             SSSSS     Y    SSSSS     T    EEEEEE M     M  ..          *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                        P. WOLFERS Software                            *
 *                                                                       *
 *                  Laboratoire de Cristallographie                      *
 *                                                                       *
 *                         B.P. 166 C.N.R.S.                             *
 *                                                                       *
 *                      25 Avenue des Martyrs                            *
 *                                                                       *
 *                      F 38042 GRENOBLE CEDEX 9                         *
 *                                                                       *
 *                                                                       *
 *************************************************************************

 /////////////////////////////////////////////////////////////////////////
 //                                                                     //
 //                    General Public License                           //
 //                                                                     //
 // This file is part of the V C++ GUI Framework, and is covered        //
 // under the terms of the GNU Library General Public License,          //
 // Version 2. This library has NO WARRANTY. See the source file        //
 // vapp.cxx for more complete information about license terms.         //
 //                                                                     //
 // This license described in this file overrides all other licenses    //
 // that might be specified in other files for this library.            //
 //                                                                     //
 // This library is free software; you can redistribute it and/or       //
 // modify it under the terms of the GNU Lesser General Public          //
 // License as published by the Free Software Foundation; either        //
 // version 2.1 of the License, or (at your option) any later version.  //
 //                                                                     //
 // This library is distributed in the hope that it will be useful,     //
 // but WITHOUT ANY WARRANTY; without even the implied warranty of      //
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
 // Library General Public License for more details.                    //
 //                                                                     //
 // You should have received a copy of the GNU Lesser General Public    //
 // License along with this library (see COPYING.LIB); if not, write to //
 // the Free Software Foundation :                                      //
 //                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
 //                                                                     //
 /////////////////////////////////////////////////////////////////////////
}

{
  ************************************************************************
  *                                                                      *
  *                                                                      *
  *               M X D   S A T E L L I T E   H A N D L E R              *
  *                                                                      *
  *                                                                      *
  *                                                                      *
  *            To read string and number for command analysys            *
  *                                                                      *
  *                                                                      *
  *                   Version 1.1-D of  20-Oct-2010                      *
  *                                                                      *
  *                                                                      *
  *                                                                      *
  *                                                                      *
  ************************************************************************
}

{ To Insert in the user program :
 module SATELLITE_ENV( input, output );
}


{**************************************************}
{*    Satellite Environment Types Definitions     *}
{**************************************************}
const
  max_lid   =  16;                            { Maximum size of an identifier }
  max_list  =  64;                            { Maximum number of value to output }


type

  str_ptr   = ^string;                        { Pointer to a string }

  lstring   = string( 255 );                  { Our String Definition }

  sbyte     = short_integer;                  { Define our signed byte type }

  ide_name  = record                          { The Local Identifier string definition }
                cod: integer;                 { The User code to identify the symbol }
                len: byte;                    { The length and the characters of ident. }
                str: packed array[1..max_lid] of char
              end;

  symb_type = ( sy_eof, sy_eoln,              { Type of Last symbol : EOF, EOLN Reached }
                sy_ident,                     { Identifier }
                sy_str, sy_int, sy_real,      { String, Integer, Real }
                sy_add_op, sy_sub_op,         { + - }
                sy_mul_op, sy_div_op,         { * / }
                sy_power_op,                  { ^ }
                sy_eq_op, sy_ne_op,           { = <> }
                sy_lt_op, sy_le_op,           { < <= }
                sy_ge_op, sy_gt_op,           { >= > }
                sy_or_op, sy_and_op,          { or (| or !), and (&) }
                sy_lpar, sy_rpar,             { ( ) }
                sy_lbra, sy_rbra,             { [ ] }
                sy_comma, sy_colon,           { , : } 
                sy_semicolon, sy_antislash,   { ; \ }
                sy_illegal );                 { Illegal }

  expr_rec = record
                expr_cte,                     { Constant to add }
                expr_fac: real;               { Factor of identifier }
                expr_ide: ide_name            { Identifier (when used) }
             end;


  { Define an identifier table }
  cmd_smbtb( sz: integer ) = array[1..sz] of ide_name;

  cmd_stbptr = ^cmd_smbtb;                    { Symbol table pointer }


  out_types = ( intty, fltty, strty );        { Type to output }

  out_typtr = ^out_tyrec;                     { Pointer to an Output List Element }

  out_tyrec = record                          { * Output List Element Definition * }
                case out_rty: out_types of    { Kind of List Element }
                  intty:( out_intv: integer); { Integer value to output }
                  fltty:( out_fltv: real );   { Floatting value to output }
                  strty:( out_strv: str_ptr)  { String to Output }
              end;

  ellist_ty = array[1..max_list] of out_tyrec;  { Element list type }




{****************************************************}
{*   Satellite Environment Variables Definitions    *}
{****************************************************}

[external]
var
  inp_prompt,                                 { The Main input Prompt }
  inp_prompt2,                                { The Specified Input Prompt }
  inp_string,                                 { String to read (if inp_string_flg) }
  inpf,                                       { The input file specification }
  outf:           lstring;                    { The output file specification }

  inp_string_flg,                             { Input in a string flag }
  inp_file_req,                               { Input mode false/true for open requested cmd_file }
  inp_file_flg,                               { Input mode false/true for cmd_line/file }
  out_file_flg:   boolean;                    { Outut mode false/true for std output/file }

  inp_ch:         char;                       { Last input char }
  inp_symb:       symb_type;                  { Type of Last symbol }
  inp_ident:      ide_name;                   { Last input symbol }
  inp_code:       integer;                    { The current identifier command code }
  inp_str:        lstring;                    { Last input string }
  inp_real:       real;                       { Last input floatting number }
  inp_string_idx,                             { Index for string input }
  inp_int:        integer;                    { Last input integer }

  inp_csmbtb:     cmd_stbptr;                 { Current symbol table pointer }

  out_ellist:     ellist_ty;                  { Output List }
  out_frmstr:     str_ptr;                    { Pointer to the current format string }
  out_list_sz:    integer;                    { Used size of output list }

  inp_file,                                   { Input file when used }
  out_file:       text;                       { Output file when used }





{********************************************************************}
{*          Satellite Environment Read Directive Procedures         *)
{********************************************************************}

procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] ide_name );
external 'GS_ERROR_IDE';


procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] string );
external 'GS_ERROR_STR';


procedure WARNING( in_var mdnam, msg: string; in_var parm: [optional] ide_name );
external 'GS_WARNING_IDE';


procedure WARNING( in_var mdnam, msg: string; in_var parm: [optional] string );
external 'GS_WARNING_STR';


function IDE_MATCH( in_var id1, id2: ide_name ): boolean;
external;



function IDE_SEARCH( in_var idetab: array[sz: integer] of ide_name;
                     in_var id: string ): integer;
external 'GS_ISEARCH_STR';



function IDE_SEARCH( in_var idetab: cmd_smbtb;
                     in_var ide: ide_name ): integer;
external 'GS_ISEARCH_IDE1';



function IDE_SEARCH( in_var idetab: array[sz: integer] of ide_name;
                     in_var ide: ide_name ): integer;
external 'GS_ISEARCH_IDE';


procedure INSYMBOL;
external;


procedure SKIP_SYMBOL( ts: symb_type );
external;


procedure INP_INQUIRE( in_var name: string );
external;


procedure INP_R_VALUE( in_var name: string; var rv: real );
external;


procedure INP_I_VALUE( in_var name: string; var iv: integer );
external;


procedure INP_S_VALUE( in_var name: string; var str: string );
external;


function INP_SEPAR( sep: symb_type ): boolean;
external;


procedure INP_EXPRESSION( var fac, cte: real; var str: string );
external;


function INP_LOOKSEMICOLON: boolean;
external;


procedure CHANGE_CASE( var s: string; bmaj: boolean := false; ibg, ind: integer := 0 );
external;



{********************************************************************}
{*    Satellite Environment Formatted Write Directive Procedures    *)
{********************************************************************}


procedure OUT_VALUE( iv: integer );
external 'OUT_VALUE_IV';



procedure OUT_VALUE( rv: real );
external 'OUT_VALUE_RV';



procedure OUT_VALUE( in_var str: string );
external 'OUT_VALUE_SV';



procedure FORMAT_VALUE( in_var frm: string; var ii, iv, jv: integer; var ch: char );
external;



procedure FORMATTED_OUTPUT( var f: text; in_var frm: string;
                                nb0, nb1, nb2, nb3: integer := 0; oflg: boolean := false );
external;
{ Write the text atxt in the file f as specified by the inserted
  format specification as defined here :

    Any character as copied on the output except the character "%" that is
  the format specification character.
   The acceptable format statements are:
     %%        - to print the single character "%",
     %<r>(     - to repeat the following part (until %) r times,
     %)        - to end a repeated sequence,
     %<f>x     - to insert <f> space,
     %<f>l     - to print (or skip) <f> line (default is 1),
     %<f>.<b># - to print nb0 or nb1, nb2, nb3 (in this order) [only when oflg is true],
     %<f>.<b>i - to print an integer number (~ I<f>) <b> can used to specify a base <> 10,
     %<f>.<d>v - or, 
     %<f>.<d>f - to print a floatting number (~ F<f>.<d>),
     %<f>.<p>s - or,
     %<f>.<p>t - to print a string (~ A<f>) <p> = -1/0/1 for right/centre/left position.

  The formal parameters fmu, nst and nb are respectively the site multiplicity,
  and the number of equivalent sites in the positions, and the sequential
  integer site number. 
}



{*****************************************************************************************}
{ End of Insertion :
end SATELLITE_ENV.
}
