/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[2];

/* Define the local data section. */
static Blk( Rd, 2760 ) = {{
 14,  14, 115, 101, 116,  95, 115, 114,  99, 102, 105, 108, 101, 115, 112,  99,
 64,  64,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,
 97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,
 45,  50,  47, 112,  99, 109, 112,  95, 105, 110, 115, 121, 109,  98,  46, 112,
 97, 115,   3,   3,  84,  84,  58,  17,  17,  99, 111, 109, 112, 105, 108, 101,
 95, 115, 101, 116,  95, 116, 105, 116, 108, 101,   3,   3,  84,  84,  58,  29,
 29,  32,  84, 104, 101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  83, 111,
117, 114,  99, 101,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,
 34,  46,  17,  17,  99, 111, 109, 112, 105, 108, 101,  95, 115, 101, 116,  95,
115,  98, 116, 116, 108,  33,  33,  32,  84, 104, 101,  32,  67, 117, 114, 114,
101, 110, 116,  32,  67, 111, 109, 112, 105, 108, 101, 100,  32,  77, 111, 100,
117, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  10,  10, 115, 101,
116, 107, 101, 121, 119, 111, 114, 100,  16,  16, 115, 101, 116,  95, 107, 101,
121, 119, 111, 114, 100,  95, 116, 114, 101, 101,   2,   2, 111, 114,   3,   3,
120, 111, 114,   3,   3,  97, 110, 100,   3,   3, 110, 111, 116,   3,   3, 100,
105, 118,   3,   3, 109, 111, 100,   3,   3, 114, 101, 109,   2,   2, 105, 110,
  3,   3, 110, 105, 108,   5,   5, 108,  97,  98, 101, 108,   4,   4, 103, 111,
116, 111,   4,   4, 116, 121, 112, 101,   5,   5,  99, 111, 110, 115, 116,  14,
 14, 117, 115, 101, 114,  95, 115, 116,  97, 116, 101, 109, 101, 110, 116,   3,
  3, 118,  97, 114,   6,   6, 105, 110,  95, 118,  97, 114,   7,   7, 111, 117,
116,  95, 118,  97, 114,   7,   7, 112, 114, 105, 118,  97, 116, 101,   6,   6,
 97,  99,  99, 101, 115, 115,   4,   4, 102, 105, 108, 101,   5,   5,  97, 114,
114,  97, 121,   6,   6, 114, 101,  99, 111, 114, 100,   3,   3, 115, 101, 116,
  3,   3, 117, 115, 101,   3,   3, 110, 101, 119,   4,   4, 110, 101, 119, 104,
  7,   7, 100, 105, 115, 112, 111, 115, 101,   4,   4, 111, 112, 101, 110,   5,
  5, 114, 101, 115, 101, 116,   7,   7, 114, 101, 119, 114, 105, 116, 101,   6,
  6,  97, 112, 112, 101, 110, 100,   4,   4, 114, 101,  97, 100,   6,   6, 114,
101,  97, 100, 108, 110,   5,   5, 114, 101,  97, 100, 118,   5,   5, 119, 114,
105, 116, 101,   7,   7, 119, 114, 105, 116, 101, 108, 110,   6,   6, 119, 114,
105, 116, 101, 118,   7,   7, 112, 114, 111, 103, 114,  97, 109,   6,   6, 109,
111, 100, 117, 108, 101,   9,   9, 112, 114, 111,  99, 101, 100, 117, 114, 101,
  8,   8, 102, 117, 110,  99, 116, 105, 111, 110,   6,   6, 114, 101, 116, 117,
114, 110,   7,   7, 102, 111, 114, 119,  97, 114, 100,   6,   6, 115, 116,  97,
116, 105,  99,   6,   6, 103, 108, 111,  98,  97, 108,   6,   6, 112,  97,  99,
107, 101, 100,   8,   8, 101, 120, 116, 101, 114, 110,  97, 108,   8,   8, 115,
116,  97, 110, 100,  97, 114, 100,   6,   6, 105, 110, 108, 105, 110, 101,   5,
  5,  98, 101, 103, 105, 110,   2,   2, 105, 102,   4,   4, 116, 104, 101, 110,
  4,   4, 101, 108, 115, 101,   5,   5, 119, 104, 105, 108, 101,   6,   6, 114,
101, 112, 101,  97, 116,   5,   5, 117, 110, 116, 105, 108,   3,   3, 102, 111,
114,   4,   4, 108, 111, 111, 112,   4,   4, 101, 120, 105, 116,   4,   4,  99,
 97, 115, 101,   4,   4, 119, 105, 116, 104,   3,   3, 101, 110, 100,   9,   9,
111, 116, 104, 101, 114, 119, 105, 115, 101,   2,   2, 111, 102,   2,   2, 100,
111,   2,   2, 116, 111,   6,   6, 100, 111, 119, 110, 116, 111,   7,   7,  37,
100, 101, 102, 105, 110, 101,   9,   9,  37, 117, 110, 100, 101, 102, 105, 110,
101,   4,   4,  37, 108, 101, 116,   3,   3,  37, 105, 102,   6,   6,  37, 105,
102, 100, 101, 102,   8,   8,  37, 105, 102, 117, 110, 100, 101, 102,   5,   5,
 37, 116, 104, 101, 110,   5,   5,  37, 101, 108, 115, 101,   5,   5,  37, 101,
108, 105, 102,   6,   6,  37, 101, 110, 100, 105, 102,   8,   8,  37, 109, 101,
115, 115,  97, 103, 101,   7,   7,  37,  99, 104,  97, 105, 110, 101,   8,   8,
 37, 105, 110,  99, 108, 117, 100, 101,   7,   7,  37, 112, 114,  97, 103, 109,
 97,   4,   4,  37, 101, 111, 102,  16,  16,  99, 114, 101,  97, 116, 101,  95,
109,  97,  99,  95, 105, 100, 101, 110, 116,   4,   4,  67,  82,  69,  77,   0,
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  7,   7, 115, 111, 114, 116, 109,  99,  49,  15,  15, 114, 101,  98, 117, 105,
108, 100,  95, 109,  99, 116, 114, 101, 101,  49,  14,  14, 114, 101,  98, 117,
105, 108, 100,  95, 109,  99, 116, 114, 101, 101,   6,   6, 110, 101, 120, 116,
 99, 104,   8,   8, 112, 117, 116,  95,  99, 104,  97, 114,   4,   4,  73,  78,
 83,  89,  12,  12, 116, 101, 115, 116,  95, 102, 105, 103, 117, 114, 101, 115,
  7,   7, 102, 105, 103, 117, 114, 101, 115,   4,   4,  70,  73,  71,  85,  11,
 11, 111, 118, 102,  95, 104,  97, 110, 100, 108, 101, 114,  11,  11,  84, 111,
111,  32,  79,  86,  72,  32,  69,  82,  82,  12,  12, 105, 110, 115, 121, 109,
 98, 111, 108,  95, 115, 114,  99,  13,  13, 115, 107, 105, 112,  95, 109,  99,
115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0, 112,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   4,   4,  77,  67,  83,  75,  16,  16,  99,  98,  95, 109,
 97,  99, 114, 111,  95, 109,  97, 110,  97, 103, 101, 114,  13,  13, 109,  97,
 99, 114, 111,  95, 114, 101, 112, 108,  97,  99, 101,   4,   4,  77,  65,  67,
 84,  19,  19, 100, 101, 102, 105, 110, 101,  95, 109,  97,  99, 114, 111,  95,
115, 121, 109,  98, 111, 108,   4,   4,  67,  82,  77,  83,   0,   0,   6,   0,
  0,   0,   6,   0,  21,  21, 117, 110, 100, 101, 102, 105, 110, 101,  95, 109,
 97,  99, 114, 111,  95, 115, 121, 109,  98, 111, 108,   4,   4,  82,  77,  77,
 83,   0,   0,   0,   0,   0,   6,   0,  19,  19, 109,  97,  99, 114, 111,  95,
 97, 115, 115, 105, 103, 110,  95, 115, 121, 109,  98, 111, 108,   4,   4,  65,
 83,  77,  83,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  4,   0,   0,   0,   9,   9, 115, 104, 111, 119,  95, 109, 118,  97, 108,  15,
 15,  32,  69,  88,  80,  95,  73,  68,  69,  78,  84,  32,  45,  62,  32,  91,
  3,   0,   0,   0,   8,   0,   8, 109, 118,  97, 108,  95, 105, 110, 116,   8,
109, 118,  97, 108,  95, 115, 116, 114,   8, 109, 118,  97, 108,  95, 110, 117,
108,   8, 109, 118,  97, 108,  95, 117, 110, 100,   4,   4,  44,  32, 105,  61,
  5,   5,  44,  32, 115,  61,  34,   2,   2,  34,  93,  11,  11, 115, 104, 111,
119,  95, 109, 115, 116,  97,  99, 107,  15,  15,  32, 115, 116,  97,  99, 107,
 58,  32, 115, 116, 107, 112,  32,  61,  32,   2,   2,  32,  91,   4,   4,  93,
 32,  61,  32,   8,   8, 109, 118,  97, 108,  95,  99, 111, 112,   9,   9, 109,
118,  97, 108,  95, 102, 114, 101, 101,   5,   5, 109, 112, 117, 115, 104,   4,
  4,  77,  80,  85,  83,   4,   4, 109, 112, 111, 112,   4,   4,  77,  80,  79,
 80,  15,  15, 103, 101, 116,  95, 109,  97,  99, 114, 111,  95, 118,  97, 108,
117, 101,   9,   9, 109, 101, 120, 112,  95, 105, 110, 116, 118,  11,  11, 109,
101, 120, 112,  95, 118, 108,  95, 115, 116, 114,   9,   9, 109, 101, 120, 112,
 95, 115, 116, 114, 118,   9,   9, 109, 101, 120, 112,  95,  99,  97, 108, 108,
  4,   4,  77,  67,  65,  76,   0,   0,   7, 100, 101, 102, 105, 110, 101, 100,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   1,   0,   0,   0,   6, 115, 117,  98,
115, 116, 114,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 253, 255, 255, 255,
  5, 105, 110, 100, 101, 120,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  2,   0,   0,   0,   5, 108, 101, 110, 103, 116, 104,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,   1,   0,   0,   0,   8,  42,  42,  42,  42,  42,  42,  42,
 42,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   0,  10,  10, 109, 101,
120, 112,  95, 105, 100, 101, 110, 116,   4,   4,  77,  73,  68,  69,   0,   0,
  0,   0,   4,   0,  10,  10, 109, 101, 120, 112,  95,  98, 105, 110, 111, 112,
  4,   4,  77,  66,  73,  78,  10,  10, 109, 101, 120, 112,  95, 117, 110,  97,
111, 112,   4,   4,  77,  85,  78,  65,   8,   8, 109, 101, 120, 112,  95, 117,
110,  97,   4,   4,  77,  69,  88,  80,   8,   8, 109, 101, 120, 112,  95, 109,
117, 108,   8,   8, 109, 101, 120, 112,  95,  97, 100, 100,   8,   8, 109, 101,
120, 112,  95, 114, 101, 108,   8,   8, 109, 101, 120, 112,  95,  97, 110, 100,
 12,  12, 109,  95, 101, 120, 112, 114,  95, 105, 110, 115, 116, 107,  10,  10,
109, 101, 120, 112, 114,  95, 115, 118,  97, 108,  10,  10, 109, 101, 120, 112,
114,  95, 105, 118,  97, 108,  10,  10, 109, 101, 120, 112, 114,  95,  98, 118,
 97, 108, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,  13,  13, 112, 114,  97, 103, 109,  97,  95, 109, 115, 116,  97,
116, 101,   4,   4,  80,  82,  65,  71,  14,  14, 105, 110,  99, 108, 117, 100,
101,  95, 109, 115, 116,  97, 116, 101,   4,   4,  46, 112,  97, 115,   4,   4,
 73,  78,  67,  76,  35,  35,  32,  42,  32,  84, 104, 101,  32,  99, 117, 114,
114, 101, 110, 116,  32, 115, 111, 117, 114,  99, 101,  32, 102, 105, 108, 101,
 32, 105, 115,  32, 110, 111, 119,  32,  34,  20,  20,  32,  79, 112, 101, 110,
 32,  69, 114, 114, 111, 114,  32,  40,  82,  84,  76,  41,  32,  35,  32,  22,
 22,  32, 102, 111, 114,  32, 116, 104, 101,  32,  83, 111, 117, 114,  99, 101,
 32, 102, 105, 108, 101,  32,  58,  15,  15,  32,  82,  84,  76,  32, 109, 101,
115, 115,  97, 103, 101,  32,  58,  32,  14,  14, 101, 110, 100, 102, 105, 108,
101,  95, 109, 115, 116,  97, 116, 101,  35,  35,  32,  42,  32,  84, 104, 101,
 32,  99, 117, 114, 114, 101, 110, 116,  32, 115, 111, 117, 114,  99, 101,  32,
102, 105, 108, 101,  32, 105, 115,  32, 110, 111, 119,  32,  34,   8,   8,  99,
110, 100,  95, 112, 117, 115, 104,   4,   4,  71,  66,  83,  89,   7,   7,  99,
110, 100,  95, 112, 111, 112,   9,   9,  99, 110, 100,  95,  99, 104, 101,  99,
107,  10,  10, 109, 105, 102,  95, 109, 115, 116,  97, 116, 101,   4,   4,  77,
 67,  73,  70,   8,   8, 105, 110, 115, 121, 109,  98, 111, 108,   4,   4,  77,
 83,  89,  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,  15,  15,  42,  42,  42,  32,  77, 101, 115, 115,  97, 103,
101,  32,  42,  42,  42,  21,  21,  32,  78, 111,  86,  97, 108,  32, 102, 111,
114,  32, 109,  97,  99,  32, 115, 121, 109,  98,  32,  34,  11,  11, 115, 107,
105, 112,  95, 115, 121, 109,  98, 111, 108,  12,  12, 115, 107, 105, 112,  95,
109, 115, 121, 109,  98, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,  64,   0,   0,
  0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   2,   0,   9,   9, 105, 110,
115, 121,  95, 105, 110, 105, 116,   0,   0,  53,  53,  32,  80,  32,  65,  32,
 83,  32,  45,  32,  80,  46,  32,  87,  79,  76,  70,  69,  82,  83,  32,  83,
 79,  70,  84,  87,  65,  82,  69,  58,  32,  86,  51,  46,  49,  45,  66,  53,
 32,  79,  70,  32,  51,  49,  45,  74,  65,  78,  45,  50,  48,  50,  50,  32,
 12,  12,  99, 112,  97, 115,  95,  99, 109, 112,  46, 101, 114, 114,   5,   5,
 32,  80,  65,  83,  62,  48,  48,  32,  42,  42,  42,  32,  80,  67,  77,  80,
 45,  67,  80,  65,  83,  45,  67,  79,  77,  80,  73,  76,  69,  82,  32,  69,
 82,  82,  79,  82,  58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101,
110,  32, 116, 104, 101,  32,  34,  15,  15,  34,  32, 105, 110, 105, 116, 105,
 97, 108,  32, 102, 105, 108, 101,  46,  54,  54,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32, 102, 111, 114,  32, 116, 104, 101,
 32, 116,  97, 114, 103, 101, 116,  32, 115, 121, 115, 116, 101, 109,  32,  34,
 22,  22,  32,  80,  65,  83,  32,  67,  65,  78,  78,  79,  84,  32,  79,  80,
 69,  78,  32,  84,  72,  69,  32,  34,  23,  23,  34,  32,  79,  85,  84,  80,
 85,  84,  32,  77,  83,  71,  47,  76,  73,  83,  84,  32,  70,  73,  76,  69,
 46,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 1192 ) = {{
  0,   0,   0,   0,   0,   1,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
  3,   3,   3,   3,   4,   5,   6,   7,   7,   7,  15,   6,  16,  17,  10,  18,
 19,  20,   9,  21,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  14,  22,
 11,  12,  13,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  23,
 24,  25,  26,   7,   4,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
  7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   4,
  5,   4,   4,   3,  11,  20,  13,  29,  14,  29,   9,  11,  17,  29,   9,  12,
  8,   7,  18,  29,  15,  29,   6,   0,  16,  29,  23,  29,   0,   0,   0,   0,
  7, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14, 109,  97,  99, 114, 111,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 101,  99, 104, 111,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 101,  99, 104, 111,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  7, 108, 105, 115, 116, 108, 118, 108,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  6, 102, 111, 114, 109,  97, 116,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 108, 105, 115, 116,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 112,  95, 108, 105, 115, 116,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 13,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 110,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 14,  99, 112,  95,  98, 105, 110,  95, 101, 120, 101,  95, 111, 102, 102,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95,  98, 105, 110,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95,  98, 105, 110,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9,  99, 112,  95, 101, 120, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10,  99, 112,  95, 101, 120, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  5, 116, 114,  97,  99, 101,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 100, 101,  98, 117, 103,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 100, 101,  98, 117, 103,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  8, 114,  97, 110, 103, 101,  95, 111, 110,  32,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  9, 114,  97, 110, 103, 101,  95, 111, 102, 102,  32,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11,  99, 111, 100, 101,  95, 111, 112, 116, 105, 111, 110,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 10, 112,  99, 109, 112, 100, 101,  98,  95, 111, 110,  32,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
 11, 112,  99, 109, 112, 100, 101,  98,  95, 111, 102, 102,  32,  32,  32,  32,
 32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
  0,   0,   0,   0, 254,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 544 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_srf_list;
extern V V_srf_free;
extern UB V_cntx_srinf;
extern V V_lst_current;
extern V V_keyword_tree;
extern V V_macsymb_tree;
extern V V_macsymb_frst;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_sy_string, 264 );
extern V PAS__f_output;
extern UB V_sy_attrflg;
extern Blk(V_sy_sym, 8 );
extern SL V_sy_ival;
extern G V_sy_rval;
extern UB V_sy_label_flag;
extern Blk(V_sy_ident, 32 );
extern V V_sy_macsymb;
extern UB V_sy_init_mod;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern V V_pas_obj;
extern UB V_cmp_objf;
extern UB V_cmp_bltt;
extern SL V_cmp_traceopt;
extern UB V_cmp_debugopt;
extern UB V_cmp_range;
extern UB V_cmp_cmpdbg;
extern SL V_src_openerr;
extern SL V_cmp_trace;
extern SL V_cmp_tracecount;
extern UB V_pas_compile;
extern Blk(V_cpas_ini_dir, 264 );
extern Blk(V_trg_env_fspc, 264 );
extern UB V_cmp_macroexp;
extern UB V_error_result;
extern UB V_emergency_stop;
extern Blk(V_trg_sys_name, 264 );
extern SL V_proc_seq;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_src_close(V *F_p, UB F_bfree);
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp);
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp);
C P_src_return(UB F_bfree);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_inchar();
C P_src_next_char();
void P_src_set_flags(UL F_flg, UB F_fclr);
void P_src_init(V F_def_prt, V F_def_src);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
SL P_match(V F_s1, V F_s2);
void P_ide_int_label();
void P_ide_init();
void P_skip_msymbol(V F_smb, UB F_rec_flg);
void P_binary_objf_close();
void P_generation_pragma();
void PAS_INSMBOL_get_macro_value(V F_vl);
void PAS_INSMBOL_m_expr_instk();


/* Procedure/Function : " set_srcfilespc "  */
void P_set_srcfilespc(SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=171; /* line # 171 */
  if (F_icd>=0) {
    Ra.sl[72]=173; /* line # 173 */
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
    Ra.sl[72]=174; /* line # 174 */
    if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+82);
    Ra.sl[72]=175; /* line # 175 */
    if (F_icd>0||V_srf_list==NULL) {
      Ra.sl[72]=177; /* line # 177 */
      if (V_srf_free==NULL) {
        Ra.sl[72]=178; /* line # 178 */
        Rv0=PAS__NEW(16);
      }
      else {
        Ra.sl[72]=180; /* line # 180 */
        Rv0=V_srf_free;
        V_srf_free=((V *)Rv0)[0];
      }
      Ra.sl[72]=181; /* line # 181 */
      Rv1=Rv0;
      Ra.sl[72]=183; /* line # 183 */
      ((V *)Rv1)[0]=V_srf_list;
      Ra.sl[72]=184; /* line # 184 */
      ((V *)Rv1)[1]=NULL;
      Ra.sl[72]=185; /* line # 185 */
      P_val_new(((V *)Rv1)+1,NULL);
      Ra.sl[72]=187; /* line # 187 */
      V_srf_list=Rv0;
    }
    else {
      Ra.sl[72]=190; /* line # 190 */
      Rv2=V_srf_list;
      Ra.sl[72]=192; /* line # 192 */
      P_val_free(((V *)Rv2)+1);
      Ra.sl[72]=193; /* line # 193 */
      P_val_new(((V *)Rv2)+1,NULL);
    }
    Ra.sl[72]=195; /* line # 195 */
    Rv3=((V *)V_srf_list)[1];
    Ra.sl[72]=197; /* line # 197 */
    ((UB *)Rv3)[48]=29;
    Ra.sl[72]=198; /* line # 198 */
    ((SL *)Rv3)[6]=Ra.ub[1];
    Ra.sl[72]=199; /* line # 199 */
    Rv4=Ra.ub[1];
    ((V *)Rv3)[7]=PAS__NEW((SL)Rv4+2);
    ((UB *)((V *)Rv3)[7])[0]=Rv4;
    Ra.sl[72]=200; /* line # 200 */
    PAS__STR_TO_STR(((V *)Rv3)[7],Ra.s);
  }
  else {
    Ra.sl[72]=205; /* line # 205 */
    Rv0=V_srf_list;
    Ra.sl[72]=206; /* line # 206 */
    Rv5=Rv0;
    Ra.sl[72]=208; /* line # 208 */
    V_srf_list=((V *)Rv5)[0];
    Ra.sl[72]=209; /* line # 209 */
    P_val_free(((V *)Rv5)+1);
    Ra.sl[72]=210; /* line # 210 */
    ((V *)Rv5)[0]=V_srf_free;
    Ra.sl[72]=212; /* line # 212 */
    V_srf_free=Rv0;
  }
  Ra.sl[72]=214; /* line # 214 */
  V_cntx_srinf=1;
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_title "  */
void P_compile_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+87;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=235; /* line # 235 */
  Rv0=V_lst_current;
  Ra.sl[72]=237; /* line # 237 */
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  Ra.sl[72]=238; /* line # 238 */
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+292,((V *)V_src_control)[35]));
  Ra.sl[72]=239; /* line # 239 */
  if (Ra.ub[1]==0) PAS__STR_TO_STR(Ra.s,Rd.s+106);
  Ra.sl[72]=240; /* line # 240 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.s+
111,Ra.s),Rd.s+142));
  Ra.sl[72]=241; /* line # 241 */
  Rv1=Ra.ub[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  Ra.sl[72]=242; /* line # 242 */
  PAS__STR_TO_STR(((V *)Rv0)[4],Ra.s);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " compile_set_sbttl "  */
void P_compile_set_sbttl(V F_prc){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+146;
  Ra.v[35]=Rd.s+16;
  Ra.sl[72]=258; /* line # 258 */
  Rv0=V_lst_current;
  Ra.sl[72]=260; /* line # 260 */
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  Ra.sl[72]=261; /* line # 261 */
  if (((V *)F_prc)[3]!=NULL) {
    Ra.sl[72]=262; /* line # 262 */
    Rv1=((V *)F_prc)[3];
    Ra.sl[72]=264; /* line # 264 */
    PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_CHT(Ra.s+292,Rv1+1,31,1,((UB *)Rv1)[0]));
    Ra.sl[72]=265; /* line # 265 */
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+549,PAS__CON_STR_STR(Ra.s+292,Rd.
    s+165,Ra.s),Rd.s+200));
    Ra.sl[72]=266; /* line # 266 */
    Rv2=Ra.ub[1];
    ((V *)Rv0)[5]=PAS__NEW((SL)Rv2+2);
    ((UB *)((V *)Rv0)[5])[0]=Rv2;
    Ra.sl[72]=267; /* line # 267 */
    PAS__STR_TO_STR(((V *)Rv0)[5],Ra.s);
  }
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " setkeyword "  */
void PAS_INSMBOL_PRC_00000000(V F_kname, UB F_skw, UB F_opkw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+204;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=293; /* line # 293 */
  Rv0=PAS__NEW(50);
  Ra.sl[6]=294; /* line # 294 */
  Rv1=Rv0;
  Ra.sl[6]=296; /* line # 296 */
  ((UB *)Rv1)[0]=((UB *)F_kname)[1];
  Ra.sl[6]=297; /* line # 297 */
  Rv2=1;
  for( Rf0=((UB *)Rv1)[0];Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=((C *)F_kname)[Rv2+1];
    Rv2++;
  }
  Ra.sl[6]=298; /* line # 298 */
  ((V *)Rv1)[4]=NULL;
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=299; /* line # 299 */
  ((UB *)Rv1)[48]=F_skw;
  ((UB *)Rv1)[49]=F_opkw;
  Ra.sl[6]=301; /* line # 301 */
  Rv3=V_keyword_tree;
  Ra.sl[6]=302; /* line # 302 */
  if (Rv3!=NULL) {
    while (1){
      Ra.sl[6]=305; /* line # 305 */
      Rv4=Rv3;
      Ra.sl[6]=306; /* line # 306 */
      Rv5=Rv3;
      Ra.sl[6]=308; /* line # 308 */
      Rv6=P_match(Rv0,Rv5);
      Ra.sl[6]=309; /* line # 309 */
      if (Rv6>0) Rv3=((V *)Rv5)[5];
      else {
        Ra.sl[6]=310; /* line # 310 */
        Rv3=((V *)Rv5)[4];
      }
      if (Rv3==NULL)  break;
    }
    Ra.sl[6]=313; /* line # 313 */
    if (Rv6>0) ((V *)Rv4)[5]=Rv0;
    else {
      Ra.sl[6]=314; /* line # 314 */
      ((V *)Rv4)[4]=Rv0;
    }
  }
  else {
    Ra.sl[6]=316; /* line # 316 */
    V_keyword_tree=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_keyword_tree "  */
void PAS_INSMBOL_set_keyword_tree(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+216;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=322; /* line # 322 */
  PAS_INSMBOL_PRC_00000000(Rd.s+234,12,21);
  Ra.sl[6]=323; /* line # 323 */
  PAS_INSMBOL_PRC_00000000(Rd.s+238,12,22);
  Ra.sl[6]=324; /* line # 324 */
  PAS_INSMBOL_PRC_00000000(Rd.s+243,11,20);
  Ra.sl[6]=325; /* line # 325 */
  PAS_INSMBOL_PRC_00000000(Rd.s+248,6,0);
  Ra.sl[6]=326; /* line # 326 */
  PAS_INSMBOL_PRC_00000000(Rd.s+253,8,8);
  Ra.sl[6]=327; /* line # 327 */
  PAS_INSMBOL_PRC_00000000(Rd.s+258,8,9);
  Ra.sl[6]=328; /* line # 328 */
  PAS_INSMBOL_PRC_00000000(Rd.s+263,8,10);
  Ra.sl[6]=329; /* line # 329 */
  PAS_INSMBOL_PRC_00000000(Rd.s+268,10,23);
  Ra.sl[6]=333; /* line # 333 */
  PAS_INSMBOL_PRC_00000000(Rd.s+272,27,29);
  Ra.sl[6]=334; /* line # 334 */
  PAS_INSMBOL_PRC_00000000(Rd.s+277,32,29);
  Ra.sl[6]=335; /* line # 335 */
  PAS_INSMBOL_PRC_00000000(Rd.s+284,33,29);
  Ra.sl[6]=336; /* line # 336 */
  PAS_INSMBOL_PRC_00000000(Rd.s+290,29,29);
  Ra.sl[6]=337; /* line # 337 */
  PAS_INSMBOL_PRC_00000000(Rd.s+296,28,29);
  Ra.sl[6]=338; /* line # 338 */
  PAS_INSMBOL_PRC_00000000(Rd.s+303,31,29);
  Ra.sl[6]=340; /* line # 340 */
  PAS_INSMBOL_PRC_00000000(Rd.s+319,30,29);
  Ra.sl[6]=341; /* line # 341 */
  PAS_INSMBOL_PRC_00000000(Rd.s+324,35,29);
  Ra.sl[6]=342; /* line # 342 */
  PAS_INSMBOL_PRC_00000000(Rd.s+332,36,29);
  Ra.sl[6]=343; /* line # 343 */
  PAS_INSMBOL_PRC_00000000(Rd.s+341,43,29);
  Ra.sl[6]=344; /* line # 344 */
  PAS_INSMBOL_PRC_00000000(Rd.s+350,38,29);
  Ra.sl[6]=345; /* line # 345 */
  PAS_INSMBOL_PRC_00000000(Rd.s+358,39,29);
  Ra.sl[6]=346; /* line # 346 */
  PAS_INSMBOL_PRC_00000000(Rd.s+364,40,29);
  Ra.sl[6]=347; /* line # 347 */
  PAS_INSMBOL_PRC_00000000(Rd.s+371,41,29);
  Ra.sl[6]=348; /* line # 348 */
  PAS_INSMBOL_PRC_00000000(Rd.s+379,42,29);
  Ra.sl[6]=349; /* line # 349 */
  PAS_INSMBOL_PRC_00000000(Rd.s+384,73,29);
  Ra.sl[6]=350; /* line # 350 */
  PAS_INSMBOL_PRC_00000000(Rd.s+389,58,29);
  Ra.sl[6]=351; /* line # 351 */
  PAS_INSMBOL_PRC_00000000(Rd.s+394,59,29);
  Ra.sl[6]=352; /* line # 352 */
  PAS_INSMBOL_PRC_00000000(Rd.s+400,60,29);
  Ra.sl[6]=353; /* line # 353 */
  PAS_INSMBOL_PRC_00000000(Rd.s+409,61,29);
  Ra.sl[6]=354; /* line # 354 */
  PAS_INSMBOL_PRC_00000000(Rd.s+415,62,29);
  Ra.sl[6]=355; /* line # 355 */
  PAS_INSMBOL_PRC_00000000(Rd.s+422,63,29);
  Ra.sl[6]=356; /* line # 356 */
  PAS_INSMBOL_PRC_00000000(Rd.s+431,64,29);
  Ra.sl[6]=358; /* line # 358 */
  PAS_INSMBOL_PRC_00000000(Rd.s+439,65,29);
  Ra.sl[6]=359; /* line # 359 */
  PAS_INSMBOL_PRC_00000000(Rd.s+445,66,29);
  Ra.sl[6]=360; /* line # 360 */
  PAS_INSMBOL_PRC_00000000(Rd.s+453,67,29);
  Ra.sl[6]=361; /* line # 361 */
  PAS_INSMBOL_PRC_00000000(Rd.s+460,68,29);
  Ra.sl[6]=362; /* line # 362 */
  PAS_INSMBOL_PRC_00000000(Rd.s+467,69,29);
  Ra.sl[6]=363; /* line # 363 */
  PAS_INSMBOL_PRC_00000000(Rd.s+476,70,29);
  Ra.sl[6]=365; /* line # 365 */
  PAS_INSMBOL_PRC_00000000(Rd.s+484,75,29);
  Ra.sl[6]=366; /* line # 366 */
  PAS_INSMBOL_PRC_00000000(Rd.s+493,74,29);
  Ra.sl[6]=367; /* line # 367 */
  PAS_INSMBOL_PRC_00000000(Rd.s+501,76,29);
  Ra.sl[6]=368; /* line # 368 */
  PAS_INSMBOL_PRC_00000000(Rd.s+512,77,29);
  Ra.sl[6]=369; /* line # 369 */
  PAS_INSMBOL_PRC_00000000(Rd.s+522,78,29);
  Ra.sl[6]=370; /* line # 370 */
  PAS_INSMBOL_PRC_00000000(Rd.s+530,79,29);
  Ra.sl[6]=371; /* line # 371 */
  PAS_INSMBOL_PRC_00000000(Rd.s+539,86,29);
  Ra.sl[6]=372; /* line # 372 */
  PAS_INSMBOL_PRC_00000000(Rd.s+547,81,29);
  Ra.sl[6]=373; /* line # 373 */
  PAS_INSMBOL_PRC_00000000(Rd.s+555,37,29);
  Ra.sl[6]=374; /* line # 374 */
  PAS_INSMBOL_PRC_00000000(Rd.s+563,80,29);
  Ra.sl[6]=375; /* line # 375 */
  PAS_INSMBOL_PRC_00000000(Rd.s+573,82,29);
  Ra.sl[6]=376; /* line # 376 */
  PAS_INSMBOL_PRC_00000000(Rd.s+583,83,29);
  Ra.sl[6]=377; /* line # 377 */
  PAS_INSMBOL_PRC_00000000(Rd.s+591,71,29);
  Ra.sl[6]=378; /* line # 378 */
  PAS_INSMBOL_PRC_00000000(Rd.s+598,44,29);
  Ra.sl[6]=379; /* line # 379 */
  PAS_INSMBOL_PRC_00000000(Rd.s+602,45,29);
  Ra.sl[6]=380; /* line # 380 */
  PAS_INSMBOL_PRC_00000000(Rd.s+608,46,29);
  Ra.sl[6]=381; /* line # 381 */
  PAS_INSMBOL_PRC_00000000(Rd.s+614,47,29);
  Ra.sl[6]=382; /* line # 382 */
  PAS_INSMBOL_PRC_00000000(Rd.s+621,48,29);
  Ra.sl[6]=383; /* line # 383 */
  PAS_INSMBOL_PRC_00000000(Rd.s+629,49,29);
  Ra.sl[6]=384; /* line # 384 */
  PAS_INSMBOL_PRC_00000000(Rd.s+636,50,29);
  Ra.sl[6]=385; /* line # 385 */
  PAS_INSMBOL_PRC_00000000(Rd.s+641,54,29);
  Ra.sl[6]=386; /* line # 386 */
  PAS_INSMBOL_PRC_00000000(Rd.s+647,55,29);
  Ra.sl[6]=387; /* line # 387 */
  PAS_INSMBOL_PRC_00000000(Rd.s+653,56,29);
  Ra.sl[6]=388; /* line # 388 */
  PAS_INSMBOL_PRC_00000000(Rd.s+659,57,29);
  Ra.sl[6]=389; /* line # 389 */
  PAS_INSMBOL_PRC_00000000(Rd.s+665,72,29);
  Ra.sl[6]=390; /* line # 390 */
  PAS_INSMBOL_PRC_00000000(Rd.s+670,85,29);
  Ra.sl[6]=391; /* line # 391 */
  PAS_INSMBOL_PRC_00000000(Rd.s+681,84,29);
  Ra.sl[6]=392; /* line # 392 */
  PAS_INSMBOL_PRC_00000000(Rd.s+685,53,29);
  Ra.sl[6]=393; /* line # 393 */
  PAS_INSMBOL_PRC_00000000(Rd.s+689,51,29);
  Ra.sl[6]=394; /* line # 394 */
  PAS_INSMBOL_PRC_00000000(Rd.s+693,52,29);
  Ra.sl[6]=396; /* line # 396 */
  PAS_INSMBOL_PRC_00000000(Rd.s+701,89,29);
  Ra.sl[6]=397; /* line # 397 */
  PAS_INSMBOL_PRC_00000000(Rd.s+710,90,29);
  Ra.sl[6]=398; /* line # 398 */
  PAS_INSMBOL_PRC_00000000(Rd.s+721,91,29);
  Ra.sl[6]=399; /* line # 399 */
  PAS_INSMBOL_PRC_00000000(Rd.s+727,92,29);
  Ra.sl[6]=400; /* line # 400 */
  PAS_INSMBOL_PRC_00000000(Rd.s+732,93,29);
  Ra.sl[6]=401; /* line # 401 */
  PAS_INSMBOL_PRC_00000000(Rd.s+740,94,29);
  Ra.sl[6]=402; /* line # 402 */
  PAS_INSMBOL_PRC_00000000(Rd.s+750,95,29);
  Ra.sl[6]=403; /* line # 403 */
  PAS_INSMBOL_PRC_00000000(Rd.s+757,96,29);
  Ra.sl[6]=404; /* line # 404 */
  PAS_INSMBOL_PRC_00000000(Rd.s+764,97,29);
  Ra.sl[6]=405; /* line # 405 */
  PAS_INSMBOL_PRC_00000000(Rd.s+771,98,29);
  Ra.sl[6]=407; /* line # 407 */
  PAS_INSMBOL_PRC_00000000(Rd.s+779,100,29);
  Ra.sl[6]=408; /* line # 408 */
  PAS_INSMBOL_PRC_00000000(Rd.s+789,102,29);
  Ra.sl[6]=409; /* line # 409 */
  PAS_INSMBOL_PRC_00000000(Rd.s+798,101,29);
  Ra.sl[6]=410; /* line # 410 */
  PAS_INSMBOL_PRC_00000000(Rd.s+808,103,29);
  Ra.sl[6]=415; /* line # 415 */
  PAS_INSMBOL_PRC_00000000(Rd.s+817,104,29);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_mac_ident "  */
V P_create_mac_ident(V F_id, UB F_cmdf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+823;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=435; /* line # 435 */
  Rv0=V_macsymb_tree;
  Ra.sl[6]=436; /* line # 436 */
  Rv1=NULL;
  Ra.sl[6]=437; /* line # 437 */
  Rv2=1;
  Ra.sl[6]=438; /* line # 438 */
  while (Rv0!=NULL&&Rv2!=0){
    Ra.sl[6]=440; /* line # 440 */
    Rv1=Rv0;
    Ra.sl[6]=441; /* line # 441 */
    Rv3=Rv0;
    Ra.sl[6]=443; /* line # 443 */
    Rv2=P_match(F_id,Rv3);
    Ra.sl[6]=444; /* line # 444 */
    if (Rv2!=0) {
      Ra.sl[6]=445; /* line # 445 */
      if (Rv2>0) Rv0=((V *)Rv3)[6];
      else {
        Ra.sl[6]=446; /* line # 446 */
        Rv0=((V *)Rv3)[5];
      }
    }
  }
  Ra.sl[6]=449; /* line # 449 */
  if (Rv2==0) {
    Ra.sl[6]=450; /* line # 450 */
    if (F_cmdf) Rv4=Rv0;
    else {
      Ra.sl[6]=451; /* line # 451 */
      P_src_error_s(Rd.s+843,921,2, F_id,NULL);
    }
  }
  else {
    Ra.sl[6]=454; /* line # 454 */
    Rv4=PAS__NEW(80);
    Ra.sl[6]=455; /* line # 455 */
    Rv5=Rv4;
    Ra.sl[6]=457; /* line # 457 */
    memcpy(Rv5,F_id,32);
    Ra.sl[6]=458; /* line # 458 */
    ((V *)Rv5)[4]=NULL;
    Ra.sl[6]=459; /* line # 459 */
    ((V *)Rv5)[5]=NULL;
    Ra.sl[6]=460; /* line # 460 */
    ((V *)Rv5)[6]=NULL;
    Ra.sl[6]=461; /* line # 461 */
    ((UB *)Rv5)[56]=0;
    Ra.sl[6]=462; /* line # 462 */
    memcpy(Rv5+64,Rd.s+848,16);
    Ra.sl[6]=464; /* line # 464 */
    if (Rv1==NULL) {
      Ra.sl[6]=465; /* line # 465 */
      V_macsymb_tree=Rv4;
    }
    else {
      Ra.sl[6]=467; /* line # 467 */
      if (Rv2>0) ((V *)Rv1)[6]=Rv4;
      else {
        Ra.sl[6]=468; /* line # 468 */
        ((V *)Rv1)[5]=Rv4;
      }
    }
  }
  Ra.sl[6]=470; /* line # 470 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sortmc1 "  */
void PAS_INSMBOL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+864;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=497; /* line # 497 */
  Rv0=F_p;
  Ra.sl[6]=499; /* line # 499 */
  if (((V *)Rv0)[5]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[5]);
  Ra.sl[6]=500; /* line # 500 */
  Rv1=((UB *)Rv0)[0]==0;
  Ra.sl[6]=501; /* line # 501 */
  if (!Rv1) {
    Ra.sl[6]=503; /* line # 503 */
    if (V_macsymb_frst==NULL) V_macsymb_frst=F_p;
    else {
      Ra.sl[6]=504; /* line # 504 */
      ((V *)Lx[0].v[0])[4]=F_p;
    }
    Ra.sl[6]=505; /* line # 505 */
    Lx[0].v[0]=F_p;
    Ra.sl[6]=506; /* line # 506 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=507; /* line # 507 */
    Lx[0].sl[2]=Lx[0].sl[2]+1;
  }
  Ra.sl[6]=509; /* line # 509 */
  if (((V *)Rv0)[6]!=NULL) PAS_INSMBOL_PRC_00000001(((V *)Rv0)[6]);
  Ra.sl[6]=511; /* line # 511 */
  if (Rv1) {
    Ra.sl[6]=513; /* line # 513 */
    Rv2=F_p;
    Rv3=Rv2+64;
    Ra.sl[6]=514; /* line # 514 */
    if (((V *)Rv3)[1]!=NULL) PAS__DISPOSE(((V *)Rv3)+1);
    Ra.sl[6]=515; /* line # 515 */
    PAS__DISPOSE(&F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rebuild_mctree1 "  */
V PAS_INSMBOL_PRC_00000002(SL F_n, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+873;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=528; /* line # 528 */
  Rv0=(F_n+F_m)/2;
  Ra.sl[6]=529; /* line # 529 */
  Rv1=((V *)Lx[0].v[2])[Rv0];
  Ra.sl[6]=530; /* line # 530 */
  Rv2=Rv1;
  Ra.sl[6]=532; /* line # 532 */
  if (Rv0==F_n) ((V *)Rv2)[5]=NULL;
  else {
    Ra.sl[6]=533; /* line # 533 */
    ((V *)Rv2)[5]=PAS_INSMBOL_PRC_00000002(F_n, Rv0-1);
  }
  Ra.sl[6]=534; /* line # 534 */
  if (Rv0==F_m) ((V *)Rv2)[6]=NULL;
  else {
    Ra.sl[6]=535; /* line # 535 */
    ((V *)Rv2)[6]=PAS_INSMBOL_PRC_00000002(Rv0+1, F_m);
  }
  Ra.sl[6]=537; /* line # 537 */
  Ret=Rv1;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rebuild_mctree "  */
void P_rebuild_mctree(){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register SL Rv0;
  SL Rv1;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+890;
  Ra.v[5]=Rd.s+16;
  Ra.sl[12]=543; /* line # 543 */
  Ra.sl[2]=0;
  Ra.sl[12]=544; /* line # 544 */
  V_macsymb_frst=NULL;
  Ra.sl[12]=545; /* line # 545 */
  if (V_macsymb_tree!=NULL) {
    Ra.sl[12]=547; /* line # 547 */
    PAS_INSMBOL_PRC_00000001(V_macsymb_tree);
    Ra.sl[12]=548; /* line # 548 */
    if (Ra.sl[2]>0) {
      Ra.sl[12]=550; /* line # 550 */
      Ra.v[0]=V_macsymb_frst;
      Ra.sl[12]=551; /* line # 551 */
      Rv0=Ra.sl[2];
      Ra.v[2]=PAS__NEW(Rv0*8+8);
      ((SL *)Ra.v[2])[0]=Rv0;
      Ra.sl[12]=552; /* line # 552 */
      Rv1=1;
      for( Rf0=Ra.sl[2];Rf0>0;Rf0-- ) {
        Ra.sl[12]=553; /* line # 553 */
        ((V *)Ra.v[2])[Rv1]=Ra.v[0];
        Ra.v[0]=((V *)Ra.v[0])[4];
        Rv1++;
      }
      Ra.sl[12]=555; /* line # 555 */
      V_macsymb_tree=PAS_INSMBOL_PRC_00000002(1, Ra.sl[2]);
    }
    else {
      Ra.sl[12]=559; /* line # 559 */
      V_macsymb_tree=NULL;
      Ra.sl[12]=560; /* line # 560 */
      V_macsymb_frst=NULL;
    }
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " nextch "  */
void PAS_INSMBOL_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+906;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=647; /* line # 647 */
  V_sy_ch=P_src_inchar();
  Ra.sl[6]=648; /* line # 648 */
  V_sy_cmin=V_sy_ch;
  Ra.sl[6]=649; /* line # 649 */
  if (V_sy_ch>=65&&V_sy_ch<=90) V_sy_cmin=(C)((SL)V_sy_ch+32);
  Ra.sl[6]=650; /* line # 650 */
  if (V_sy_cmin>127) V_sy_cmin=63;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " put_char "  */
void PAS_INSMBOL_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+914;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=656; /* line # 656 */
  if (!Lx[1].ub[0]) {
    Ra.sl[6]=657; /* line # 657 */
    if (Lx[1].sl[1]<V_sy_string.ub[0]) {
      Ra.sl[6]=659; /* line # 659 */
      V_sy_string.c[Lx[1].sl[1]+1]=V_sy_ch;
      Ra.sl[6]=660; /* line # 660 */
      Lx[1].sl[1]=Lx[1].sl[1]+1;
    }
    else {
      Ra.sl[6]=664; /* line # 664 */
      P_src_error(Rd.s+926,12,2);
      Ra.sl[6]=665; /* line # 665 */
      Lx[1].ub[0]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_figures "  */
SL PAS_INSMBOL_PRC_00000005(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+930;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=675; /* line # 675 */
  if (F_ch>=48&&F_ch<=57) Rv0=(SL)F_ch-48;
  else {
    Ra.sl[6]=677; /* line # 677 */
    if ((Lx[1].ub[8]&&F_ch>=97)&&F_ch<=102) Rv0=(10+(SL)F_ch)-97;
    else {
      Ra.sl[6]=678; /* line # 678 */
      Rv0=-1;
    }
  }
  Ra.sl[6]=679; /* line # 679 */
  if (Rv0>=Lx[1].sl[3]) Rv0=-2;
  Ra.sl[6]=680; /* line # 680 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " figures "  */
SL PAS_INSMBOL_PRC_00000006(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+944;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=691; /* line # 691 */
  Rv0=PAS_INSMBOL_PRC_00000005(F_ch);
  Ra.sl[6]=692; /* line # 692 */
  if (Rv0==-2) {
    Ra.sl[6]=694; /* line # 694 */
    Rv0=0;
    P_src_error(Rd.s+955,16,2);
  }
  Ra.sl[6]=696; /* line # 696 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ovf_handler "  */
SL PAS_INSMBOL_PRC_00000007(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+959;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=706; /* line # 706 */
  Ri.sl[0]=Ri.sl[0]+1;
  Ra.sl[6]=707; /* line # 707 */
  if (Ri.sl[0]>10) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+972,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(2);
  }
  Ra.sl[6]=708; /* line # 708 */
  if (F_ierr>=20&&F_ierr<=25) {
    Ra.sl[6]=710; /* line # 710 */
    if (!Lx[1].ub[16]) {
      Ra.sl[6]=712; /* line # 712 */
      P_src_error(Rd.s+926,11,2);
      Ra.sl[6]=713; /* line # 713 */
      Lx[1].g[3]=1.000000000000000E+000;
      Lx[1].g[4]=1.000000000000000E+000;
      Ra.sl[6]=714; /* line # 714 */
      Lx[1].ub[16]=1;
    }
    Ra.sl[6]=716; /* line # 716 */
    Ret=1;
  }
  else {
    Ra.sl[6]=719; /* line # 719 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol_src "  */
void P_insymbol_src(){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register V Rv2;
  G Rv3;
  SL Rv4;
  SL Rv5;
  G Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  C Rv14;
  UB Rv15;
  SL Rv16;
  register V Rv17;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+985;
  Ra.v[7]=Rd.s+16;
  Ra.sl[16]=725; /* line # 725 */
  while (V_sy_ch==32||V_sy_ch==0)
  PAS_INSMBOL_PRC_00000003();
  Ra.sl[16]=726; /* line # 726 */
  Rv0=1;
  Ra.sl[16]=727; /* line # 727 */
  Rv1=V_sy_attrflg;
  Ra.sl[16]=728; /* line # 728 */
  V_sy_attrflg=0;
  Ra.sl[16]=729; /* line # 729 */
  Rv2=V_src_control;
  ((SL *)Rv2)[4]=((SL *)Rv2)[5];
  Ra.sl[16]=730; /* line # 730 */
  Ra.sl[16]=731; /* line # 731 */
  switch (Ri.ub[V_sy_cmin+4]) {
    case 8:
    case 9:Ra.sl[16]=734; /* line # 734 */
    PAS__ESTABLISH(PAS_INSMBOL_PRC_00000007);
    Ra.sl[16]=735; /* line # 735 */
    Ra.ub[16]=0;
    Ra.sl[16]=736; /* line # 736 */
    V_sy_sym.ub[0]=19;
    Ra.sl[16]=737; /* line # 737 */
    V_sy_sym.ub[1]=29;
    Ra.sl[16]=738; /* line # 738 */
    Rv3=0.000000000000000E-001;
    Ra.sl[16]=739; /* line # 739 */
    Ra.sl[3]=10;
    Ra.sl[16]=740; /* line # 740 */
    Rv4=0;
    Ra.sl[16]=741; /* line # 741 */
    Ra.ub[8]=0;
    Ra.sl[16]=742; /* line # 742 */
    while (Ri.ub[V_sy_cmin+4]==8){
      Ra.sl[16]=744; /* line # 744 */
      V_sy_sym.ub[0]=2;
      Ra.sl[16]=745; /* line # 745 */
      Rv5=(SL)V_sy_cmin-48;
      Ra.sl[16]=746; /* line # 746 */
      if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      while (1){
        Ra.sl[16]=747; /* line # 747 */
        PAS_INSMBOL_PRC_00000003();
        if (V_sy_cmin!=95)  break;
      }
      Ra.sl[16]=748; /* line # 748 */
      if (!Ra.ub[16]) Rv3=Rv3*1.000000000000000E+001+(double)Rv5;
    }
    Ra.sl[16]=751; /* line # 751 */
    if (V_sy_sym.ub[0]==2&&V_sy_ch==35) {
      Ra.sl[16]=753; /* line # 753 */
      Rv4=0;
      Ra.sl[16]=754; /* line # 754 */
      Ra.sl[3]=(Rv3>0.0?(SL)(Rv3+0.5):(SL)(Rv3-0.5));
      Ra.sl[16]=755; /* line # 755 */
      if (Ra.sl[3]<2||Ra.sl[3]>16) {
        Ra.sl[16]=757; /* line # 757 */
        P_src_error(Rd.s+926,14,2);
        Ra.sl[16]=758; /* line # 758 */
        Ra.sl[3]=10;
      }
      Ra.sl[16]=760; /* line # 760 */
      Ra.ub[8]=1;
      Ra.sl[16]=761; /* line # 761 */
      Rv3=0.000000000000000E-001;
      while (1){
        while (1){
          Ra.sl[16]=763; /* line # 763 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Ra.sl[16]=764; /* line # 764 */
        Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
        Ra.sl[16]=765; /* line # 765 */
        if ((float)Rv5<(F)0.000000E-01)  break;
        Ra.sl[16]=766; /* line # 766 */
        if (!Ra.ub[16]) Rv3=Rv3*(double)Ra.sl[3]+(double)Rv5;
        Ra.sl[16]=767; /* line # 767 */
        if (Rv4>0||Rv5>0) Rv4=Rv4+1;
      }
    }
    Ra.sl[16]=772; /* line # 772 */
    Rv6=(double)Ra.sl[3];
    Ra.g[3]=Rv6;
    Ra.sl[16]=774; /* line # 774 */
    if (V_sy_ch==46) {
      Ra.sl[16]=776; /* line # 776 */
      if (P_src_next_char()==46) {
        Ra.sl[16]=777; /* line # 777 */
        if (V_sy_sym.ub[0]==19) {
          Ra.sl[16]=779; /* line # 779 */
          PAS_INSMBOL_PRC_00000003();
          Ra.sl[16]=780; /* line # 780 */
          V_sy_sym.ub[0]=20;
        }
        else {
          Ra.sl[16]=782; /* line # 782 */
          Rv0=0;
        }
      }
      else {
        while (1){
          Ra.sl[16]=785; /* line # 785 */
          PAS_INSMBOL_PRC_00000003();
          if (V_sy_cmin!=95)  break;
        }
        Ra.sl[16]=786; /* line # 786 */
        Rv6=(double)Ra.sl[3];
        Ra.g[3]=Rv6;
        Ra.g[4]=1.000000000000000E+000;
        Ra.sl[16]=787; /* line # 787 */
        if (PAS_INSMBOL_PRC_00000005(V_sy_cmin)<0) {
          Ra.sl[16]=788; /* line # 788 */
          Rv0=0;
        }
        else {
          Ra.sl[16]=791; /* line # 791 */
          V_sy_sym.ub[0]=4;
          while (1){
            Ra.sl[16]=793; /* line # 793 */
            if (Ra.g[4]!=1.000000000000000E+000) while (1){
              Ra.sl[16]=794; /* line # 794 */
              PAS_INSMBOL_PRC_00000003();
              if (V_sy_cmin!=95)  break;
            }
            Ra.sl[16]=795; /* line # 795 */
            Rv5=PAS_INSMBOL_PRC_00000006(V_sy_cmin);
            Ra.sl[16]=796; /* line # 796 */
            if (Rv5<0)  break;
            Ra.sl[16]=797; /* line # 797 */
            Ra.g[4]=Ra.g[4]/Rv6;
            Ra.sl[16]=798; /* line # 798 */
            Rv3=Rv3+Ra.g[4]*(double)Rv5;
            Ra.sl[16]=799; /* line # 799 */
            Rv4=Rv4+1;
          }
        }
      }
    }
    Ra.sl[16]=805; /* line # 805 */
    if (V_sy_cmin==35) PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=807; /* line # 807 */
    if (V_sy_sym.ub[0]!=19&&V_sy_sym.ub[0]!=20) {
      Ra.sl[16]=809; /* line # 809 */
      if (V_sy_cmin==101) {
        Ra.sl[16]=811; /* line # 811 */
        V_sy_sym.ub[0]=4;
        Ra.sl[16]=812; /* line # 812 */
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[16]=813; /* line # 813 */
        if (V_sy_ch==43||V_sy_ch==45) {
          Ra.sl[16]=815; /* line # 815 */
          if (V_sy_ch==45) Ra.g[3]=1.000000000000000E+000/Ra.g[3];
          Ra.sl[16]=816; /* line # 816 */
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[16]=818; /* line # 818 */
        Rv7=0;
        Ra.sl[16]=820; /* line # 820 */
        while (Ri.ub[V_sy_cmin+4]==8){
          Ra.sl[16]=822; /* line # 822 */
          Rv7=Rv7*10+((SL)V_sy_ch-48);
          Ra.sl[16]=823; /* line # 823 */
          PAS_INSMBOL_PRC_00000003();
        }
        Ra.sl[16]=827; /* line # 827 */
        Ra.g[4]=1.000000000000000E+000;
        Ra.sl[16]=828; /* line # 828 */
        while (Rv7!=0&&!Ra.ub[16]){
          Ra.sl[16]=830; /* line # 830 */
          if (Rv7&1) {
            Ra.sl[16]=832; /* line # 832 */
            Rv7=Rv7-1;
            Ra.sl[16]=833; /* line # 833 */
            Ra.g[4]=Ra.g[4]*Ra.g[3];
          }
          else {
            Ra.sl[16]=837; /* line # 837 */
            Rv7=Rv7/2;
            Ra.sl[16]=838; /* line # 838 */
            Ra.g[3]=PAS__G_SQR(Ra.g[3]);
          }
        }
        Ra.sl[16]=841; /* line # 841 */
        if (!Ra.ub[16]) Rv3=Rv3*Ra.g[4];
      }
      Ra.sl[16]=844; /* line # 844 */
      if (Ra.ub[16]) Rv3=0.000000000000000E-001;
      Ra.sl[16]=846; /* line # 846 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[16]=848; /* line # 848 */
        if (Rv3<=4.294967295000001E+009&&Rv3>=-2.147483648000001E+009) {
          Ra.sl[16]=850; /* line # 850 */
          if (Rv3>2.147483647000000E+009) V_sy_ival=(int)(4.294967295000001E+009-
          Rv3)+1;
          else {
            Ra.sl[16]=851; /* line # 851 */
            V_sy_ival=(int)(Rv3);
          }
          Ra.sl[16]=852; /* line # 852 */
          V_sy_rval=(double)V_sy_ival;
          Ra.sl[16]=853; /* line # 853 */
          if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
            Ra.sl[16]=856; /* line # 856 */
            PAS_INSMBOL_PRC_00000003();
            Ra.sl[16]=857; /* line # 857 */
            P_ide_int_label();
            Ra.sl[16]=858; /* line # 858 */
            V_sy_sym.ub[0]=1;
          }
        }
        else {
          Ra.sl[16]=861; /* line # 861 */
          V_sy_sym.ub[0]=4;
        }
      }
      Ra.sl[16]=864; /* line # 864 */
      if (V_sy_sym.ub[0]==4) {
        Ra.sl[16]=866; /* line # 866 */
        V_sy_ival=0;
        Ra.sl[16]=867; /* line # 867 */
        if (Rv3>3.402823466385288E+038) V_sy_sym.ub[0]=4;
        else {
          Ra.sl[16]=871; /* line # 871 */
          if (Ra.sl[3]>2) Rv4=Rv4*(int)(log(Rv6)/6.931471805599453E-001)+2;
          else {
            Ra.sl[16]=872; /* line # 872 */
            Rv4=Rv4+2;
          }
          Ra.sl[16]=874; /* line # 874 */
          if (Rv4>24) V_sy_sym.ub[0]=4;
          else {
            Ra.sl[16]=875; /* line # 875 */
            V_sy_sym.ub[0]=3;
          }
        }
      }
      Ra.sl[16]=878; /* line # 878 */
      V_sy_rval=Rv3;
      Ra.sl[16]=879; /* line # 879 */
      Rv0=0;
    }
    Ra.sl[16]=881; /* line # 881 */
    PAS__REVERT();
    break;
    case 7:Ra.sl[16]=885; /* line # 885 */
    Ra.sl[16]=887; /* line # 887 */
    V_sy_ident.ub[0]=0;
    while (1){
      Ra.sl[16]=889; /* line # 889 */
      if (V_sy_ident.ub[0]<31) {
        Ra.sl[16]=892; /* line # 892 */
        V_sy_ident.ub[0]=V_sy_ident.ub[0]+1;
        Ra.sl[16]=893; /* line # 893 */
        V_sy_ident.c[V_sy_ident.ub[0]]=V_sy_cmin;
      }
      Ra.sl[16]=895; /* line # 895 */
      PAS_INSMBOL_PRC_00000003();
      if (Ri.ub[V_sy_cmin+4]!=7&&Ri.ub[V_sy_cmin+4]!=8)  break;
    }
    Ra.sl[16]=898; /* line # 898 */
    Rv8=V_keyword_tree;
    while (1){
      Ra.sl[16]=900; /* line # 900 */
      Rv9=Rv8;
      Ra.sl[16]=902; /* line # 902 */
      Rv10=P_match(V_sy_ident.s,Rv9);
      Ra.sl[16]=903; /* line # 903 */
      if (Rv10!=0) {
        Ra.sl[16]=904; /* line # 904 */
        if (Rv10>0) Rv8=((V *)Rv9)[5];
        else Rv8=((V *)Rv9)[4];
      }
      if (Rv10==0||Rv8==NULL)  break;
    }
    Ra.sl[16]=907; /* line # 907 */
    if (Rv8!=NULL) {
      Ra.sl[16]=908; /* line # 908 */
      memcpy(V_sy_sym.s,Rv8+48,2);
    }
    else {
      Ra.sl[16]=911; /* line # 911 */
      V_sy_macsymb=V_macsymb_tree;
      Ra.sl[16]=913; /* line # 913 */
      V_sy_sym.ub[0]=99;
      Ra.sl[16]=914; /* line # 914 */
      Rv10=1;
      Ra.sl[16]=915; /* line # 915 */
      while (Rv10!=0&&V_sy_macsymb!=NULL){
        Ra.sl[16]=916; /* line # 916 */
        Rv11=V_sy_macsymb;
        Ra.sl[16]=918; /* line # 918 */
        Rv10=P_match(V_sy_ident.s,Rv11);
        Ra.sl[16]=919; /* line # 919 */
        if (Rv10!=0) {
          Ra.sl[16]=920; /* line # 920 */
          if (Rv10>0) V_sy_macsymb=((V *)Rv11)[6];
          else V_sy_macsymb=((V *)Rv11)[5];
        }
      }
      Ra.sl[16]=922; /* line # 922 */
      if (Rv10==0) V_sy_sym.ub[0]=99;
      else {
        Ra.sl[16]=925; /* line # 925 */
        if ((V_sy_label_flag&&Ri.ub[V_sy_cmin+4]==14)&&P_src_next_char()!=61) {
          Ra.sl[16]=928; /* line # 928 */
          PAS_INSMBOL_PRC_00000003();
          V_sy_sym.ub[0]=1;
        }
        else {
          Ra.sl[16]=932; /* line # 932 */
          if (Ri.ub[V_sy_cmin+4]==6) {
            Ra.sl[16]=933; /* line # 933 */
            V_sy_attrflg=1;
          }
          Ra.sl[16]=934; /* line # 934 */
          V_sy_sym.ub[0]=0;
        }
      }
      Ra.sl[16]=937; /* line # 937 */
      V_sy_sym.ub[1]=29;
    }
    Ra.sl[16]=939; /* line # 939 */
    Rv0=0;
    break;
    case 6:Ra.sl[16]=943; /* line # 943 */
    if (Rv1) {
      Ra.sl[16]=945; /* line # 945 */
      V_sy_sym.ub[0]=24;
      V_sy_sym.ub[1]=29;
      Ra.sl[16]=946; /* line # 946 */
      Rv1=0;
    }
    else {
      Ra.sl[16]=950; /* line # 950 */
      V_sy_sym.ub[1]=29;
      Ra.sl[16]=952; /* line # 952 */
      Rv12=V_src_control;
      Ra.sl[16]=954; /* line # 954 */
      Rv13=(524288&((UL *)Rv12)[62])!=0;
      Ra.sl[16]=955; /* line # 955 */
      ((UB *)Rv12)[252]=4;
      Ra.sl[16]=956; /* line # 956 */
      ((UL *)Rv12)[62]=((UL *)Rv12)[62]|524288;
      Ra.sl[16]=958; /* line # 958 */
      Rv14=V_sy_cmin;
      Ra.sl[16]=959; /* line # 959 */
      V_sy_sym.ub[0]=5;
      Ra.sl[16]=960; /* line # 960 */
      Ra.sl[1]=1;
      Ra.ub[0]=0;
      Ra.sl[16]=961; /* line # 961 */
      Rv15=1;
      Ra.sl[16]=962; /* line # 962 */
      while (Rv15){
        Ra.sl[16]=964; /* line # 964 */
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[16]=965; /* line # 965 */
        while (Ri.ub[V_sy_cmin+4]==1)
        PAS_INSMBOL_PRC_00000003();
        Ra.sl[16]=966; /* line # 966 */
        if (Ri.ub[V_sy_cmin+4]==2) Rv15=0;
        Ra.sl[16]=967; /* line # 967 */
        if (V_sy_ch==Rv14) {
          Ra.sl[16]=969; /* line # 969 */
          if (Rv14==P_src_next_char()) {
            Ra.sl[16]=971; /* line # 971 */
            PAS_INSMBOL_PRC_00000003();
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            Ra.sl[16]=975; /* line # 975 */
            ((UB *)V_src_control)[252]=0;
            Ra.sl[16]=976; /* line # 976 */
            Rv15=0;
          }
        }
        else {
          Ra.sl[16]=980; /* line # 980 */
          if (Rv14==34&&V_sy_ch==92) {
            Ra.sl[16]=982; /* line # 982 */
            PAS_INSMBOL_PRC_00000003();
            Ra.sl[16]=983; /* line # 983 */
            switch (V_sy_cmin) {
              case 34:
              case 39:
              case 92:break;
              case 97:Ra.sl[16]=985; /* line # 985 */
              V_sy_ch=7;
              break;
              case 98:Ra.sl[16]=986; /* line # 986 */
              V_sy_ch=8;
              break;
              case 101:Ra.sl[16]=987; /* line # 987 */
              V_sy_ch=27;
              break;
              case 102:Ra.sl[16]=988; /* line # 988 */
              V_sy_ch=12;
              break;
              case 110:Ra.sl[16]=989; /* line # 989 */
              V_sy_ch=10;
              break;
              case 114:Ra.sl[16]=990; /* line # 990 */
              V_sy_ch=13;
              break;
              case 116:Ra.sl[16]=991; /* line # 991 */
              V_sy_ch=9;
              break;
              case 118:Ra.sl[16]=992; /* line # 992 */
              V_sy_ch=11;
              break;
              case 122:Ra.sl[16]=993; /* line # 993 */
              V_sy_ch=0;
              break;
              case 48:
              case 49:
              case 50:
              case 51:
              case 52:
              case 53:
              case 54:
              case 55:
              case 56:
              case 57:Ra.sl[16]=996; /* line # 996 */
              Rv10=(SL)V_sy_cmin-48;
              PAS_INSMBOL_PRC_00000003();
              Ra.sl[16]=997; /* line # 997 */
              Rv16=3;
              Ra.sl[16]=998; /* line # 998 */
              while ((Rv16>0&&V_sy_cmin>=48)&&V_sy_cmin<=57){
                Ra.sl[16]=1000; /* line # 1000 */
                Rv10=(Rv10*10+(SL)V_sy_cmin)-48;
                Ra.sl[16]=1001; /* line # 1001 */
                PAS_INSMBOL_PRC_00000003();
              }
              Ra.sl[16]=1003; /* line # 1003 */
              if (Rv10<=255) V_sy_ch=(C)Rv10;
              else {
                Ra.sl[16]=1004; /* line # 1004 */
                V_sy_ch=32;
                P_src_error(Rd.s+926,17,2);
              }
              break;
              default:Ra.sl[16]=1007; /* line # 1007 */
              V_sy_ch=32;
              P_src_error(Rd.s+926,18,2);
              break;
            }
            Ra.sl[16]=1009; /* line # 1009 */
            PAS_INSMBOL_PRC_00000004();
          }
          else {
            Ra.sl[16]=1011; /* line # 1011 */
            PAS_INSMBOL_PRC_00000004();
          }
        }
      }
      Ra.sl[16]=1013; /* line # 1013 */
      V_sy_string.ub[1]=Ra.sl[1] -1;
      Ra.sl[16]=1015; /* line # 1015 */
      Rv17=V_src_control;
      Ra.sl[16]=1016; /* line # 1016 */
      if (!Rv13) {
        Ra.sl[16]=1018; /* line # 1018 */
        ((UL *)Rv17)[62]=((UL *)Rv17)[62]&~524288;
        Ra.sl[16]=1019; /* line # 1019 */
        if (Ri.ub[V_sy_cmin+4]==1) V_sy_ch=32;
      }
    }
    break;
    case 14:Ra.sl[16]=1025; /* line # 1025 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1026; /* line # 1026 */
    V_sy_sym.ub[1]=29;
    Ra.sl[16]=1027; /* line # 1027 */
    if (V_sy_ch==61) V_sy_sym.ub[0]=22;
    else {
      Ra.sl[16]=1028; /* line # 1028 */
      V_sy_sym.ub[0]=21;
      Rv0=0;
    }
    break;
    case 11:Ra.sl[16]=1033; /* line # 1033 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1034; /* line # 1034 */
    V_sy_sym.ub[0]=10;
    Ra.sl[16]=1035; /* line # 1035 */
    if (V_sy_ch==61) V_sy_sym.ub[1]=15;
    else {
      Ra.sl[16]=1037; /* line # 1037 */
      if (V_sy_ch==62) V_sy_sym.ub[1]=18;
      else {
        Ra.sl[16]=1038; /* line # 1038 */
        V_sy_sym.ub[1]=14;
        Rv0=0;
      }
    }
    break;
    case 13:Ra.sl[16]=1043; /* line # 1043 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1044; /* line # 1044 */
    V_sy_sym.ub[0]=10;
    Ra.sl[16]=1045; /* line # 1045 */
    if (V_sy_ch==61) V_sy_sym.ub[1]=16;
    else {
      Ra.sl[16]=1046; /* line # 1046 */
      V_sy_sym.ub[1]=17;
      Rv0=0;
    }
    break;
    case 5:Ra.sl[16]=1051; /* line # 1051 */
    Rv14=V_sy_ch;
    Ra.sl[16]=1052; /* line # 1052 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1053; /* line # 1053 */
    if (V_sy_ch==Rv14) {
      V_sy_sym.ub[0]=9;
      V_sy_sym.ub[1]=13;
    }
    else {
      Ra.sl[16]=1054; /* line # 1054 */
      V_sy_sym.ub[0]=12;
      V_sy_sym.ub[1]=21;
      Rv0=0;
    }
    break;
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[16]=1059; /* line # 1059 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    break;
    case 17:
    case 25:
    case 26:Ra.sl[16]=1063; /* line # 1063 */
    memcpy(V_sy_sym.s,(Ri.s+Ri.ub[V_sy_cmin+4]*2+102),2);
    Ra.sl[16]=1064; /* line # 1064 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1065; /* line # 1065 */
    if (Ri.ub[V_sy_cmin+4]==6) V_sy_attrflg=1;
    Ra.sl[16]=1066; /* line # 1066 */
    Rv0=0;
    break;
    case 10:Ra.sl[16]=1071; /* line # 1071 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1072; /* line # 1072 */
    if (V_sy_ch==42) {
      V_sy_sym.ub[0]=7;
      V_sy_sym.ub[1]=5;
    }
    else {
      Ra.sl[16]=1073; /* line # 1073 */
      V_sy_sym.ub[0]=8;
      V_sy_sym.ub[1]=6;
      Rv0=0;
    }
    break;
    case 12:Ra.sl[16]=1078; /* line # 1078 */
    PAS_INSMBOL_PRC_00000003();
    Ra.sl[16]=1079; /* line # 1079 */
    if (V_sy_ch==62) {
      V_sy_sym.ub[0]=25;
      V_sy_sym.ub[1]=29;
    }
    else {
      Ra.sl[16]=1080; /* line # 1080 */
      V_sy_sym.ub[0]=10;
      V_sy_sym.ub[1]=19;
      Rv0=0;
    }
    break;
    case 2:Ra.sl[16]=1084; /* line # 1084 */
    V_sy_sym.ub[0]=104;
    V_sy_sym.ub[1]=29;
    V_sy_ch=32;
    Rv0=0;
    break;
    case 1:Ra.sl[16]=1087; /* line # 1087 */
    V_sy_sym.ub[0]=87;
    V_sy_sym.ub[1]=29;
    Rv0=0;
    V_sy_ch=32;
    break;
    default:Ra.sl[16]=1090; /* line # 1090 */
    V_sy_sym.ub[0]=105;
    Ra.sl[16]=1091; /* line # 1091 */
    V_sy_sym.ub[1]=29;
    Ra.sl[16]=1092; /* line # 1092 */
    Rv0=0;
    Ra.sl[16]=1093; /* line # 1093 */
    if (V_sy_ch!=32) P_src_error(Rd.s+926,13,2);
    Ra.sl[16]=1094; /* line # 1094 */
    V_sy_ch=32;
    break;
  }
  Ra.sl[16]=1097; /* line # 1097 */
  if (Rv0) PAS_INSMBOL_PRC_00000003();
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " skip_mcsymbol "  */
void PAS_INSMBOL_skip_mcsymbol(V F_smb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+999;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1104; /* line # 1104 */
  Ra.sl[6]=1105; /* line # 1105 */
  if (!PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,106)) {
    Ra.sl[6]=1107; /* line # 1107 */
    while (!((PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,106)||V_sy_sym.ub[0]==88)||V_sy_sym
    .ub[0]==104)){
      Ra.sl[6]=1109; /* line # 1109 */
      P_insymbol_src();
      Ra.sl[6]=1110; /* line # 1110 */
      switch (V_sy_sym.ub[0]) {
        case 92:
        case 93:
        case 94:Ra.sl[6]=1112; /* line # 1112 */
        while (PAS__INOP_LSET(V_sy_sym.ub[0],Rd.s+1016,95)){
          Ra.sl[6]=1114; /* line # 1114 */
          PAS_INSMBOL_skip_mcsymbol(Rd.s+1028);
          Ra.sl[6]=1115; /* line # 1115 */
          P_insymbol_src();
        }
        break;
        case 104:Ra.sl[6]=1128; /* line # 1128 */
        P_src_error(Rd.s+1046,932,3);
        break;
        default:break;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cb_macro_manager "  */
V PAS_INSMBOL_cb_macro_manager(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1050;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1139; /* line # 1139 */
  Rv0=F_mcp;
  Ra.sl[6]=1141; /* line # 1141 */
  ((UB *)Rv0)[56]=0;
  Ra.sl[6]=1143; /* line # 1143 */
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " macro_replace "  */
void P_macro_replace(V F_mcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register UB Rv4;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1068;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1160; /* line # 1160 */
  Rv2=F_mcp;
  Rv3=Rv2+64;
  Ra.sl[6]=1161; /* line # 1161 */
  if (!((UB *)Rv2)[56]) {
    Ra.sl[6]=1164; /* line # 1164 */
    switch (((UB *)Rv3)[0]) {
      case 0:Ra.sl[6]=1167; /* line # 1167 */
      Rv0=PAS__NEW(24);
      ((UB *)Rv0)[0]=22;
      Ra.sl[6]=1168; /* line # 1168 */
      PAS__VWRITE_INIT(Rv0,1);
      PAS__WRITE_INT(((SL *)Rv3)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[6]=1172; /* line # 1172 */
      Rv4=((UB *)((V *)Rv3)[1])[1];
      Rv0=PAS__NEW((SL)Rv4+2);
      ((UB *)Rv0)[0]=Rv4;
      Ra.sl[6]=1173; /* line # 1173 */
      PAS__STR_TO_STR(Rv0,((V *)Rv3)[1]);
      break;
      default:break;
    }
    Ra.sl[6]=1177; /* line # 1177 */
    ((UB *)Rv2)[56]=1;
    Ra.sl[6]=1179; /* line # 1179 */
    Rv1=P_src_macro_open(Rv0, (V)PAS_INSMBOL_cb_macro_manager,F_mcp,1,NULL);
    Ra.sl[6]=1180; /* line # 1180 */
    V_sy_ch=0;
  }
  else {
    Ra.sl[6]=1183; /* line # 1183 */
    P_src_error_s(Rd.s+1085,930,2, F_mcp,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_macro_symbol "  */
void PAS_INSMBOL_define_macro_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1089;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1197; /* line # 1197 */
  Ra.sl[6]=1199; /* line # 1199 */
  P_insymbol_src();
  while (1){
    Ra.sl[6]=1201; /* line # 1201 */
    if (V_sy_sym.ub[0]==99) {
      Ra.sl[6]=1203; /* line # 1203 */
      P_src_error_s(Rd.s+1112,921,2, V_sy_ident.s,NULL);
      Ra.sl[6]=1204; /* line # 1204 */
      P_skip_msymbol((V)Rd.s+1116,0);
    }
    else {
      Ra.sl[6]=1207; /* line # 1207 */
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=1209; /* line # 1209 */
        P_src_error(Rd.s+1112,922,2);
        Ra.sl[6]=1210; /* line # 1210 */
        P_skip_msymbol((V)Rd.s+1120,0);
      }
      else {
        Ra.sl[6]=1214; /* line # 1214 */
        Rv0=P_create_mac_ident(V_sy_ident.s,0);
        Ra.sl[6]=1215; /* line # 1215 */
        P_insymbol_src();
        Ra.sl[6]=1216; /* line # 1216 */
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=1217; /* line # 1217 */
          Rv1=Rv0;
          Ra.sl[6]=1219; /* line # 1219 */
          P_insymbol_src();
          Ra.sl[6]=1220; /* line # 1220 */
          PAS_INSMBOL_get_macro_value(Rv1+64);
        }
      }
    }
    Ra.sl[6]=1232; /* line # 1232 */
    if (V_sy_sym.ub[0]!=17)  break;
    Ra.sl[6]=1233; /* line # 1233 */
    P_insymbol_src();
  }
  Ra.sl[6]=1235; /* line # 1235 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1112,21,2);
  else {
    Ra.sl[6]=1236; /* line # 1236 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " undefine_macro_symbol "  */
void PAS_INSMBOL_undefine_macro_mbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1124;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1248; /* line # 1248 */
  Ra.sl[6]=1250; /* line # 1250 */
  P_insymbol_src();
  while (1){
    Ra.sl[6]=1252; /* line # 1252 */
    if (V_sy_sym.ub[0]!=99) {
      Ra.sl[6]=1254; /* line # 1254 */
      P_src_error(Rd.s+1149,922,2);
      Ra.sl[6]=1255; /* line # 1255 */
      P_skip_msymbol((V)Rd.s+1156,0);
    }
    else {
      Ra.sl[6]=1259; /* line # 1259 */
      if (V_sy_macsymb==NULL) {
        Ra.sl[6]=1260; /* line # 1260 */
        P_src_error_s(Rd.s+1149,923,2, V_sy_ident.s,NULL);
      }
      else {
        Ra.sl[6]=1262; /* line # 1262 */
        Rv0=V_sy_macsymb;
        Ra.sl[6]=1264; /* line # 1264 */
        ((UB *)Rv0)[0]=0;
        Ra.sl[6]=1265; /* line # 1265 */
        if (((V *)Rv0)[9]!=NULL) {
          Ra.sl[6]=1266; /* line # 1266 */
          PAS__DISPOSE(((V *)Rv0)+9);
        }
      }
      Ra.sl[6]=1268; /* line # 1268 */
      P_insymbol_src();
    }
    Ra.sl[6]=1270; /* line # 1270 */
    if (V_sy_sym.ub[0]!=17)  break;
    Ra.sl[6]=1271; /* line # 1271 */
    P_insymbol_src();
  }
  Ra.sl[6]=1273; /* line # 1273 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1149,21,2);
  else {
    Ra.sl[6]=1274; /* line # 1274 */
    P_insymbol_src();
  }
  Ra.sl[6]=1276; /* line # 1276 */
  P_rebuild_mctree();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " macro_assign_symbol "  */
void PAS_INSMBOL_macro_assign_symbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1160;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1289; /* line # 1289 */
  Ra.sl[6]=1291; /* line # 1291 */
  P_insymbol_src();
  Ra.sl[6]=1292; /* line # 1292 */
  if (V_sy_sym.ub[0]!=99) {
    Ra.sl[6]=1294; /* line # 1294 */
    P_src_error(Rd.s+1183,922,2);
    Ra.sl[6]=1295; /* line # 1295 */
    P_skip_msymbol(Rd.s+1188,0);
  }
  else {
    Ra.sl[6]=1299; /* line # 1299 */
    Rv0=V_sy_macsymb;
    Ra.sl[6]=1300; /* line # 1300 */
    P_insymbol_src();
    Ra.sl[6]=1301; /* line # 1301 */
    if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1183,32,2);
    else {
      Ra.sl[6]=1302; /* line # 1302 */
      P_insymbol_src();
    }
    Ra.sl[6]=1303; /* line # 1303 */
    Rv1=Rv0;
    Ra.sl[6]=1305; /* line # 1305 */
    if (((V *)Rv1)[9]!=NULL) PAS__DISPOSE(((V *)Rv1)+9);
    Ra.sl[6]=1306; /* line # 1306 */
    PAS_INSMBOL_get_macro_value(Rv1+64);
  }
  Ra.sl[6]=1309; /* line # 1309 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1183,21,2);
  else {
    Ra.sl[6]=1310; /* line # 1310 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mval "  */
void PAS_INSMBOL_show_mval(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1204;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1318; /* line # 1318 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1215,-1,-1,32);
  PAS__WRITE_ENM(((UB *)F_vl)[0],Rd.s+1232,0,-1,32);
  PAS__WRITE_STR(Rd.s+1274,-1,-1,32);
  PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
  PAS__WRITE_STR(Rd.s+1280,-1,-1,32);
  Ra.sl[6]=1319; /* line # 1319 */
  if (((V *)F_vl)[1]!=NULL&&((UB *)F_vl)[0]==1) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(((V *)F_vl)[1],-1,-1,32);
  }
  Ra.sl[6]=1320; /* line # 1320 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1287,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_mstack "  */
void PAS_INSMBOL_show_mstack(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1291;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1325; /* line # 1325 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(F_s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+1304,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[39],-2,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=1326; /* line # 1326 */
  Rv0=Ri.sl[39];
  for( Rf0=Ri.sl[39];Rf0>0;Rf0-- ) {
    Ra.sl[6]=1328; /* line # 1328 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1321,-1,-1,32);
    PAS__WRITE_INT(Rv0,-2,0);
    PAS__WRITE_STR(Rd.s+1325,-1,-1,32);
    PAS_INSMBOL_show_mval((Rs.s+Rv0*16-16));
    Rv0--;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_cop "  */
void PAS_INSMBOL_mval_cop(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1331;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1336; /* line # 1336 */
  ((UB *)F_dst)[0]=((UB *)F_src)[0];
  Ra.sl[6]=1337; /* line # 1337 */
  ((SL *)F_dst)[1]=((SL *)F_src)[1];
  Ra.sl[6]=1338; /* line # 1338 */
  if (((V *)F_src)[1]!=NULL) {
    Ra.sl[6]=1340; /* line # 1340 */
    Rv0=((UB *)((V *)F_src)[1])[1];
    ((V *)F_dst)[1]=PAS__NEW((SL)Rv0+2);
    ((UB *)((V *)F_dst)[1])[0]=Rv0;
    Ra.sl[6]=1341; /* line # 1341 */
    PAS__STR_TO_STR(((V *)F_dst)[1],((V *)F_src)[1]);
  }
  else {
    Ra.sl[6]=1343; /* line # 1343 */
    ((V *)F_dst)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mval_free "  */
void PAS_INSMBOL_mval_free(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1341;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1350; /* line # 1350 */
  if (((V *)F_vl)[1]!=NULL) PAS__DISPOSE(((V *)F_vl)+1);
  Ra.sl[6]=1351; /* line # 1351 */
  memcpy(F_vl,Rd.s+848,16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpush "  */
void PAS_INSMBOL_mpush(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1352;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1361; /* line # 1361 */
  if (Ri.sl[39]<32) Ri.sl[39]=Ri.sl[39]+1;
  else {
    Ra.sl[6]=1362; /* line # 1362 */
    P_src_error(Rd.s+1361,911,3);
  }
  Ra.sl[6]=1363; /* line # 1363 */
  PAS_INSMBOL_mval_cop(F_vl,(Rs.s+Ri.sl[39]*16-16));
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mpop "  */
void PAS_INSMBOL_mpop(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1365;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1373; /* line # 1373 */
  if (Ri.sl[39]>0) {
    Ra.sl[6]=1375; /* line # 1375 */
    memcpy(F_vl,(Rs.s+Ri.sl[39]*16-16),16);
    Ra.sl[6]=1376; /* line # 1376 */
    Ri.sl[39]=Ri.sl[39]-1;
  }
  else {
    Ra.sl[6]=1380; /* line # 1380 */
    P_src_error(Rd.s+1373,912,3);
    Ra.sl[6]=1381; /* line # 1381 */
    memcpy(F_vl,Rd.s+848,16);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_macro_value "  */
void PAS_INSMBOL_get_macro_value(V F_vl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1377;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1399; /* line # 1399 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1400; /* line # 1400 */
  PAS_INSMBOL_mpop(F_vl);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_intv "  */
SL PAS_INSMBOL_mexp_intv(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1394;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1412; /* line # 1412 */
  PAS_INSMBOL_mpop(Ra.s+32);
  Ra.sl[6]=1413; /* line # 1413 */
  Ra.sl[6]=1414; /* line # 1414 */
  if (Ra.ub[32]==0) Rv0=Ra.sl[9];
  else {
    Ra.sl[6]=1415; /* line # 1415 */
    if (Ra.v[5]==NULL) Rv0=0;
    else {
      Ra.sl[6]=1418; /* line # 1418 */
      Rv1=Ra.v[5];
      Ra.sl[6]=1420; /* line # 1420 */
      Rv0=0;
      Rv2=0;
      Rv3=((UB *)Rv1)[1];
      Ra.sl[6]=1421; /* line # 1421 */
      while (Rv2<Rv3&&((C *)Rv1)[Rv2+1]<=32)
      Rv2=Rv2+1;
      Ra.sl[6]=1422; /* line # 1422 */
      while (Rv2<Rv3){
        Ra.sl[6]=1424; /* line # 1424 */
        Rv4=((C *)Rv1)[Rv2+1];
        Ra.sl[6]=1425; /* line # 1425 */
        if ((Rv4<48||Rv4>57)&&Rv4>32)  break;
        Ra.sl[6]=1426; /* line # 1426 */
        if (Rv4>32) Rv0=Rv0*10+((SL)Rv4-48);
        Ra.sl[6]=1427; /* line # 1427 */
        Rv2=Rv2+1;
      }
      Ra.sl[6]=1430; /* line # 1430 */
      PAS__DISPOSE(Ra.v+5);
    }
  }
  Ra.sl[6]=1432; /* line # 1432 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexp_vl_str "  */
void PAS_INSMBOL_mexp_vl_str(V F_vl, V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1405;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1440; /* line # 1440 */
  Ra.sl[6]=1441; /* line # 1441 */
  if (((UB *)F_vl)[0]==0) {
    PAS__VWRITE_INIT(F_str,1);
    PAS__WRITE_INT(((SL *)F_vl)[1],0,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=1444; /* line # 1444 */
    PAS__STR_TO_STR(F_str,((V *)F_vl)[1]);
    Ra.sl[6]=1445; /* line # 1445 */
    PAS__DISPOSE(((V *)F_vl)+1);
    Ra.sl[6]=1446; /* line # 1446 */
    ((V *)F_vl)[1]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_strv "  */
void PAS_INSMBOL_mexp_strv(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1418;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1457; /* line # 1457 */
  PAS_INSMBOL_mpop(Ra.s+32);
  Ra.sl[6]=1458; /* line # 1458 */
  PAS_INSMBOL_mexp_vl_str(Ra.s+32,F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_call "  */
void PAS_INSMBOL_mexp_call(UB F_fn, SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 824 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+848,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1429;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1474; /* line # 1474 */
  Ra.sl[140]=1476; /* line # 1476 */
  if (F_fn==0) {
    Ra.sl[140]=1478; /* line # 1478 */
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1442,22,2);
    else {
      Ra.sl[140]=1479; /* line # 1479 */
      P_insymbol_src();
    }
    Ra.sl[140]=1480; /* line # 1480 */
    if (V_sy_sym.ub[0]==99&&V_sy_macsymb!=NULL) Ra.sl[1]=1;
    else {
      Ra.sl[140]=1481; /* line # 1481 */
      Ra.sl[1]=0;
    }
    Ra.sl[140]=1482; /* line # 1482 */
    Ra.ub[0]=0;
    Ra.sl[140]=1484; /* line # 1484 */
    P_insymbol_src();
    Ra.sl[140]=1485; /* line # 1485 */
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1442,23,2);
    Ra.sl[140]=1486; /* line # 1486 */
    PAS_INSMBOL_mpush(Ra.s);
  }
  else {
    Ra.sl[140]=1490; /* line # 1490 */
    Rv0=0;
    Ra.sl[140]=1491; /* line # 1491 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[140]=1493; /* line # 1493 */
      V_sy_sym.ub[0]=17;
      Ra.sl[140]=1494; /* line # 1494 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[140]=1496; /* line # 1496 */
        P_insymbol_src();
        Ra.sl[140]=1497; /* line # 1497 */
        PAS_INSMBOL_m_expr_instk();
        Ra.sl[140]=1498; /* line # 1498 */
        Rv0=Rv0+1;
      }
      Ra.sl[140]=1500; /* line # 1500 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+1442,23,2);
    }
    Ra.sl[140]=1502; /* line # 1502 */
    if (F_narg>0&&Rv0!=F_narg||F_narg<0&&Rv0> -F_narg) {
      Ra.sl[140]=1505; /* line # 1505 */
      P_src_error_s(Rd.s+1442,925,2,(Rd.s+F_fn*36+1448),NULL);
      Ra.sl[140]=1506; /* line # 1506 */
      for( Rf0=Rv0;Rf0>0;Rf0-- )
      PAS_INSMBOL_mpop(Ra.s);
      Ra.sl[140]=1507; /* line # 1507 */
      PAS_INSMBOL_mpush(Rd.s+848);
    }
    else {
      Ra.sl[140]=1512; /* line # 1512 */
      switch (F_fn) {
        case 3:Ra.sl[140]=1515; /* line # 1515 */
        PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[140]=1516; /* line # 1516 */
        Ra.sl[1]=Ra.ub[17];
        break;
        case 1:Ra.sl[140]=1522; /* line # 1522 */
        if (F_narg==3) Rv1=PAS_INSMBOL_mexp_intv();
        else Rv1=0;
        Ra.sl[140]=1523; /* line # 1523 */
        if (F_narg>1) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=1;
        Ra.sl[140]=1524; /* line # 1524 */
        if (F_narg>0) PAS_INSMBOL_mexp_strv(Ra.s+16);
        else Ra.ub[17]=0;
        Ra.sl[140]=1525; /* line # 1525 */
        Ra.ub[0]=1;
        Ra.sl[140]=1526; /* line # 1526 */
        Ra.sl[1]=0;
        Ra.sl[140]=1527; /* line # 1527 */
        PAS__STR_TO_STR(Ra.s+273,PAS__SUBSTR_STR(Ra.s+564,Ra.s+16,Rv2, Rv1));
        Ra.sl[140]=1528; /* line # 1528 */
        if (Ra.ub[274]>0) {
          Ra.sl[140]=1530; /* line # 1530 */
          Rv3=Ra.ub[274];
          Ra.v[1]=PAS__NEW((SL)Rv3+2);
          ((UB *)Ra.v[1])[0]=Rv3;
          Ra.sl[140]=1531; /* line # 1531 */
          PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
        }
        break;
        case 2:Ra.sl[140]=1538; /* line # 1538 */
        if (F_narg==3) Rv2=PAS_INSMBOL_mexp_intv();
        else Rv2=0;
        Ra.sl[140]=1539; /* line # 1539 */
        if (F_narg<2) Ra.ub[274]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+273);
        Ra.sl[140]=1540; /* line # 1540 */
        if (F_narg<1) Ra.ub[17]=0;
        else PAS_INSMBOL_mexp_strv(Ra.s+16);
        Ra.sl[140]=1541; /* line # 1541 */
        Ra.sl[1]=PAS__NINDEX_STR(Ra.s+18,(SL)Ra.ub[17],Ra.s+275,(SL)Ra.ub[274],Rv2,-1,1);
        break;
        default:Ra.sl[140]=1546; /* line # 1546 */
        P_src_error(Rd.s+1442,929,2);
        break;
      }
      Ra.sl[140]=1548; /* line # 1548 */
      PAS_INSMBOL_mpush(Ra.s);
    }
  }
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_ident "  */
void PAS_INSMBOL_mexp_ident(){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  register UB Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1628;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1566; /* line # 1566 */
  Rv0=1;
  Ra.sl[6]=1567; /* line # 1567 */
  Rv1=1;
  Ra.sl[6]=1568; /* line # 1568 */
  Ra.sl[6]=1570; /* line # 1570 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[6]=1573; /* line # 1573 */
    Rv2=0;
    Ra.sl[6]=1574; /* line # 1574 */
    while (Rv2<4){
      Ra.sl[6]=1576; /* line # 1576 */
      if (P_match(V_sy_ident.s,(Rd.s+Rv2*36+1448))==0)  break;
      Ra.sl[6]=1577; /* line # 1577 */
      Rv2=Rv2+1;
    }
    Ra.sl[6]=1579; /* line # 1579 */
    if (Rv2>=4) {
      Ra.sl[6]=1581; /* line # 1581 */
      P_src_error_s(Rd.s+1642,928,3, V_sy_ident.s,NULL);
      Ra.sl[6]=1582; /* line # 1582 */
      P_skip_msymbol((V)Rd.s+1648,0);
    }
    else {
      Ra.sl[6]=1586; /* line # 1586 */
      P_insymbol_src();
      Ra.sl[6]=1587; /* line # 1587 */
      PAS_INSMBOL_mexp_call(Rv2, Rd.sl[Rv2*9+370]);
      Ra.sl[6]=1588; /* line # 1588 */
      Rv1=0;
    }
    break;
    case 99:Ra.sl[6]=1593; /* line # 1593 */
    if (V_sy_macsymb!=NULL) {
      Ra.sl[6]=1595; /* line # 1595 */
      Rv1=0;
      Ra.sl[6]=1596; /* line # 1596 */
      PAS_INSMBOL_mpush(V_sy_macsymb+64);
    }
    else {
      Ra.sl[6]=1600; /* line # 1600 */
      P_src_error_s(Rd.s+1642,923,2, V_sy_ident.s,NULL);
    }
    break;
    case 5:Ra.sl[6]=1605; /* line # 1605 */
    Ra.ub[32]=1;
    Ra.sl[6]=1606; /* line # 1606 */
    Ra.sl[9]=0;
    Ra.sl[6]=1607; /* line # 1607 */
    if (V_sy_string.ub[1]>0) {
      Ra.sl[6]=1609; /* line # 1609 */
      Rv3=V_sy_string.ub[1];
      Ra.v[5]=PAS__NEW((SL)Rv3+2);
      ((UB *)Ra.v[5])[0]=Rv3;
      Ra.sl[6]=1610; /* line # 1610 */
      PAS__STR_TO_STR(Ra.v[5],V_sy_string.s);
    }
    break;
    case 2:Ra.sl[6]=1616; /* line # 1616 */
    Ra.ub[32]=0;
    Ra.sl[6]=1617; /* line # 1617 */
    Ra.sl[9]=V_sy_ival;
    Ra.sl[6]=1618; /* line # 1618 */
    Ra.v[5]=NULL;
    break;
    case 17:
    case 18:Ra.sl[6]=1624; /* line # 1624 */
    memcpy(Ra.s+32,Rd.s+848,16);
    Ra.sl[6]=1625; /* line # 1625 */
    Rv0=0;
    break;
    default:Ra.sl[6]=1629; /* line # 1629 */
    memcpy(Ra.s+32,Rd.s+848,16);
    Ra.sl[6]=1630; /* line # 1630 */
    Rv0=0;
    Ra.sl[6]=1631; /* line # 1631 */
    P_src_error(Rd.s+1642,926,2);
    break;
  }
  Ra.sl[6]=1633; /* line # 1633 */
  if (Rv1) PAS_INSMBOL_mpush(Ra.s+32);
  Ra.sl[6]=1634; /* line # 1634 */
  if (Rv0) P_insymbol_src();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_binop "  */
void PAS_INSMBOL_mexp_binop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 840 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;
  SL Rv2;
  register F Rgf;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+848,16);
  Ra.ub[16]=255;
  Ra.ub[273]=255;
  Ra.v[67]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+536;
  Ra.v[68]=Rd.s+1652;
  Ra.v[69]=Rd.s+16;
  Ra.sl[140]=1653; /* line # 1653 */
  switch (F_ope) {
    case 6:Ra.sl[140]=1656; /* line # 1656 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1657; /* line # 1657 */
    Ra.ub[0]=0;
    Ra.sl[140]=1658; /* line # 1658 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()*Rv0;
    break;
    case 7:Ra.sl[140]=1662; /* line # 1662 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1663; /* line # 1663 */
    Ra.ub[0]=0;
    Ra.sl[140]=1664; /* line # 1664 */
    if (Rv0!=0) Ra.sl[1]=PAS__F_ROUND((float)PAS_INSMBOL_mexp_intv()/(float)Rv0)
    ;
    else {
      Ra.sl[140]=1665; /* line # 1665 */
      Ra.sl[1]=0;
    }
    break;
    case 11:Ra.sl[140]=1669; /* line # 1669 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1670; /* line # 1670 */
    Ra.ub[0]=0;
    Ra.sl[140]=1671; /* line # 1671 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()+Rv0;
    break;
    case 12:Ra.sl[140]=1675; /* line # 1675 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1676; /* line # 1676 */
    Ra.ub[0]=0;
    Ra.sl[140]=1677; /* line # 1677 */
    Ra.sl[1]=PAS_INSMBOL_mexp_intv()-Rv0;
    break;
    case 13:Ra.sl[140]=1681; /* line # 1681 */
    PAS_INSMBOL_mexp_strv(Ra.s+16);
    Ra.sl[140]=1682; /* line # 1682 */
    PAS_INSMBOL_mexp_strv(Ra.s+273);
    Ra.sl[140]=1683; /* line # 1683 */
    PAS__STR_TO_STR(Ra.s+273,PAS__CON_STR_STR(Ra.s+564,Ra.s+273,Ra.s+16));
    Ra.sl[140]=1684; /* line # 1684 */
    Ra.ub[0]=1;
    Ra.sl[140]=1685; /* line # 1685 */
    Ra.sl[1]=0;
    Ra.sl[140]=1686; /* line # 1686 */
    Rv1=Ra.ub[274];
    Ra.v[1]=PAS__NEW((SL)Rv1+2);
    ((UB *)Ra.v[1])[0]=Rv1;
    Ra.sl[140]=1687; /* line # 1687 */
    PAS__STR_TO_STR(Ra.v[1],Ra.s+273);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:Ra.sl[140]=1691; /* line # 1691 */
    PAS_INSMBOL_mpop(Ra.s+824);
    Ra.sl[140]=1692; /* line # 1692 */
    PAS_INSMBOL_mpop(Ra.s);
    Ra.sl[140]=1693; /* line # 1693 */
    Ra.ub[0]=0;
    Ra.sl[140]=1694; /* line # 1694 */
    if (Ra.ub[824]==1||Ra.ub[0]==1) {
      Ra.sl[140]=1696; /* line # 1696 */
      PAS_INSMBOL_mexp_vl_str(Ra.s+824,Ra.s+16);
      Ra.sl[140]=1697; /* line # 1697 */
      PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+273);
      Ra.sl[140]=1698; /* line # 1698 */
      Rv2=PAS__MATCH_STR(Ra.s+273,Ra.s+16);
      Ra.sl[140]=1699; /* line # 1699 */
      Ra.v[1]=NULL;
    }
    else {
      Ra.sl[140]=1701; /* line # 1701 */
      Rv2=Ra.sl[1]-Ra.sl[207];
    }
    Ra.sl[140]=1702; /* line # 1702 */
    switch (F_ope) {
      case 14:Ra.sl[140]=1703; /* line # 1703 */
      Ra.sl[1]=(SL)(Rv2<0);
      break;
      case 15:Ra.sl[140]=1704; /* line # 1704 */
      Ra.sl[1]=(SL)(Rv2<=0);
      break;
      case 16:Ra.sl[140]=1705; /* line # 1705 */
      Ra.sl[1]=(SL)(Rv2>=0);
      break;
      case 17:Ra.sl[140]=1706; /* line # 1706 */
      Ra.sl[1]=(SL)(Rv2>0);
      break;
      case 18:Ra.sl[140]=1707; /* line # 1707 */
      Ra.sl[1]=(SL)(Rv2!=0);
      break;
      case 19:Ra.sl[140]=1708; /* line # 1708 */
      Ra.sl[1]=(SL)(Rv2==0);
      break;
    }
    break;
    case 20:Ra.sl[140]=1713; /* line # 1713 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1714; /* line # 1714 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1715; /* line # 1715 */
    Ra.ub[0]=0;
    Ra.sl[140]=1716; /* line # 1716 */
    Ra.sl[1]=(SL)(Rv0>0&&Rv2>0);
    break;
    case 21:Ra.sl[140]=1721; /* line # 1721 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1722; /* line # 1722 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1723; /* line # 1723 */
    Ra.ub[0]=0;
    Ra.sl[140]=1724; /* line # 1724 */
    Ra.sl[1]=(SL)(Rv0>0||Rv2>0);
    break;
    case 22:Ra.sl[140]=1729; /* line # 1729 */
    Rv0=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1730; /* line # 1730 */
    Rv2=PAS_INSMBOL_mexp_intv();
    Ra.sl[140]=1731; /* line # 1731 */
    Ra.ub[0]=0;
    Ra.sl[140]=1732; /* line # 1732 */
    Ra.sl[1]=(SL)(Rv0>0&&Rv2<=0||Rv0<=0&&Rv2>0);
    break;
    default:Ra.sl[140]=1738; /* line # 1738 */
    P_src_error(Rd.s+1666,927,3);
    break;
  }
  Ra.sl[140]=1740; /* line # 1740 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[67];
}


/* Procedure/Function : " mexp_unaop "  */
void PAS_INSMBOL_mexp_unaop(UB F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+848,16);
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+1670;
  Ra.v[4]=Rd.s+16;
  Ra.sl[10]=1756; /* line # 1756 */
  switch (F_ope) {
    case 0:Ra.sl[10]=1759; /* line # 1759 */
    Ra.ub[0]=0;
    Ra.sl[10]=1760; /* line # 1760 */
    Ra.v[1]=NULL;
    Ra.sl[10]=1761; /* line # 1761 */
    Ra.sl[1]=(SL)(PAS_INSMBOL_mexp_intv()<=0);
    break;
    case 12:Ra.sl[10]=1765; /* line # 1765 */
    Ra.ub[0]=0;
    Ra.sl[10]=1766; /* line # 1766 */
    Ra.v[1]=NULL;
    Ra.sl[10]=1767; /* line # 1767 */
    Ra.sl[1]= -PAS_INSMBOL_mexp_intv();
    break;
    default:Ra.sl[10]=1771; /* line # 1771 */
    P_src_error(Rd.s+1684,927,3);
    break;
  }
  Ra.sl[10]=1774; /* line # 1774 */
  PAS_INSMBOL_mpush(Ra.s);
  PAS__curr_cntx=Ra.v[2];
}


/* Procedure/Function : " mexp_una "  */
void PAS_INSMBOL_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1688;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1809; /* line # 1809 */
  Ra.sl[6]=1811; /* line # 1811 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) {
    Ra.sl[6]=1812; /* line # 1812 */
    V_sy_sym.ub[0]=6;
  }
  Ra.sl[6]=1813; /* line # 1813 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=1815; /* line # 1815 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else {
      Ra.sl[6]=1816; /* line # 1816 */
      Rv0=29;
    }
    Ra.sl[6]=1817; /* line # 1817 */
    P_insymbol_src();
    Ra.sl[6]=1818; /* line # 1818 */
    PAS_INSMBOL_PRC_00000012();
    Ra.sl[6]=1819; /* line # 1819 */
    if (Rv0!=29) PAS_INSMBOL_mexp_unaop(Rv0);
  }
  else {
    Ra.sl[6]=1822; /* line # 1822 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1824; /* line # 1824 */
      P_insymbol_src();
      Ra.sl[6]=1825; /* line # 1825 */
      PAS_INSMBOL_m_expr_instk();
      Ra.sl[6]=1826; /* line # 1826 */
      if (V_sy_sym.ub[0]==14) P_insymbol_src();
      else {
        Ra.sl[6]=1827; /* line # 1827 */
        P_src_error(Rd.s+1700,23,3);
      }
    }
    else {
      Ra.sl[6]=1829; /* line # 1829 */
      PAS_INSMBOL_mexp_ident();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_mul "  */
void PAS_INSMBOL_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1704;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1834; /* line # 1834 */
  PAS_INSMBOL_PRC_00000012();
  Ra.sl[6]=1835; /* line # 1835 */
  Ra.sl[6]=1836; /* line # 1836 */
  while (V_sy_sym.ub[0]==8){
    Ra.sl[6]=1838; /* line # 1838 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1839; /* line # 1839 */
    P_insymbol_src();
    Ra.sl[6]=1840; /* line # 1840 */
    PAS_INSMBOL_PRC_00000012();
    Ra.sl[6]=1841; /* line # 1841 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_add "  */
void PAS_INSMBOL_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1714;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1846; /* line # 1846 */
  PAS_INSMBOL_PRC_00000011();
  Ra.sl[6]=1847; /* line # 1847 */
  Ra.sl[6]=1848; /* line # 1848 */
  while (V_sy_sym.ub[0]==9){
    Ra.sl[6]=1850; /* line # 1850 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1851; /* line # 1851 */
    P_insymbol_src();
    Ra.sl[6]=1852; /* line # 1852 */
    PAS_INSMBOL_PRC_00000011();
    Ra.sl[6]=1853; /* line # 1853 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_rel "  */
void PAS_INSMBOL_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1724;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1858; /* line # 1858 */
  PAS_INSMBOL_PRC_00000010();
  Ra.sl[6]=1859; /* line # 1859 */
  Ra.sl[6]=1860; /* line # 1860 */
  while (V_sy_sym.ub[0]==10){
    Ra.sl[6]=1862; /* line # 1862 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1863; /* line # 1863 */
    P_insymbol_src();
    Ra.sl[6]=1864; /* line # 1864 */
    PAS_INSMBOL_PRC_00000010();
    Ra.sl[6]=1865; /* line # 1865 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexp_and "  */
void PAS_INSMBOL_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1734;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1870; /* line # 1870 */
  PAS_INSMBOL_PRC_00000009();
  Ra.sl[6]=1871; /* line # 1871 */
  Ra.sl[6]=1872; /* line # 1872 */
  while (V_sy_sym.ub[0]==11){
    Ra.sl[6]=1874; /* line # 1874 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1875; /* line # 1875 */
    P_insymbol_src();
    Ra.sl[6]=1876; /* line # 1876 */
    PAS_INSMBOL_PRC_00000009();
    Ra.sl[6]=1877; /* line # 1877 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " m_expr_instk "  */
void PAS_INSMBOL_m_expr_instk(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1744;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1882; /* line # 1882 */
  PAS_INSMBOL_PRC_00000008();
  Ra.sl[6]=1883; /* line # 1883 */
  Ra.sl[6]=1884; /* line # 1884 */
  while (V_sy_sym.ub[0]==12){
    Ra.sl[6]=1886; /* line # 1886 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[6]=1887; /* line # 1887 */
    P_insymbol_src();
    Ra.sl[6]=1888; /* line # 1888 */
    PAS_INSMBOL_PRC_00000008();
    Ra.sl[6]=1889; /* line # 1889 */
    PAS_INSMBOL_mexp_binop(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_sval "  */
void PAS_INSMBOL_mexpr_sval(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1758;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1897; /* line # 1897 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1898; /* line # 1898 */
  PAS_INSMBOL_mexp_strv(F_str);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mexpr_ival "  */
SL PAS_INSMBOL_mexpr_ival(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1770;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1905; /* line # 1905 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1906; /* line # 1906 */
  Ret=PAS_INSMBOL_mexp_intv();
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mexpr_bval "  */
UB PAS_INSMBOL_mexpr_bval(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1782;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=1913; /* line # 1913 */
  PAS_INSMBOL_m_expr_instk();
  Ra.sl[6]=1914; /* line # 1914 */
  Ret=PAS_INSMBOL_mexp_intv()>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " pragma_mstate "  */
void PAS_INSMBOL_pragma_mstate(V F_p_src){
  /* Define the automatic variable space. */
  Blk( Ra, 1080 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  SL Rv6;
  register UB Rv7;

  /* Code of procedure/function */
  memcpy(Ra.s,Rd.s+848,16);
  Ra.ub[16]=255;
  PAS__STR_TO_STR(Ra.s+16,Rd.s+1794);
  Ra.ub[273]=255;
  PAS__STR_TO_STR(Ra.s+273,Rd.s+1794);
  Ra.ub[530]=255;
  PAS__STR_TO_STR(Ra.s+530,Rd.s+1794);
  Ra.ub[787]=255;
  PAS__STR_TO_STR(Ra.s+787,Rd.s+1794);
  Ra.v[131]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1048;
  Ra.v[132]=Rd.s+2051;
  Ra.v[133]=Rd.s+16;
  Ra.sl[268]=1993; /* line # 1993 */
  P_insymbol_src();
  Ra.sl[268]=1994; /* line # 1994 */
  Rv0=V_sy_label_flag;
  Ra.sl[268]=1995; /* line # 1995 */
  V_sy_label_flag=0;
  Ra.sl[268]=1996; /* line # 1996 */
  Rv1=F_p_src;
  Ra.sl[268]=1998; /* line # 1998 */
  Rv2=35&((UL *)Rv1)[62];
  Ra.sl[268]=1999; /* line # 1999 */
  while (V_sy_sym.ub[0]==0){
    Ra.sl[268]=2001; /* line # 2001 */
    Rv3=0;
    Ra.sl[268]=2002; /* line # 2002 */
    Rv4=0;
    while (1){
      Ra.sl[268]=2004; /* line # 2004 */
      Rv3=P_match(V_sy_ident.s,(Ri.s+Rv4*32+160))==0;
      Ra.sl[268]=2005; /* line # 2005 */
      if (Rv3||Rv4==23)  break;
      Ra.sl[268]=2006; /* line # 2006 */
      Rv4=Rv4+1;
    }
    Ra.sl[268]=2008; /* line # 2008 */
    P_insymbol_src();
    Ra.sl[268]=2009; /* line # 2009 */
    switch (Rv4) {
      case 0:Ra.sl[268]=2012; /* line # 2012 */
      PAS_INSMBOL_get_macro_value(Ra.s);
      Ra.sl[268]=2013; /* line # 2013 */
      if (Ra.ub[0]==1) {
        Ra.sl[268]=2015; /* line # 2015 */
        PAS_INSMBOL_mexp_vl_str(Ra.s,Ra.s+16);
        Ra.sl[268]=2016; /* line # 2016 */
        if (Ra.ub[17]>0) {
          Ra.sl[268]=2017; /* line # 2017 */
          Rv5=V_lst_current;
          Ra.sl[268]=2020; /* line # 2020 */
          if (((UB *)((V *)Rv5)[1])[1]>0) P_lst_eoln();
          Ra.sl[268]=2022; /* line # 2022 */
          if (((V *)Rv5)[2]!=NULL) PAS__STR_TO_STR(Ra.s+273,((V *)Rv5)[2]);
          Ra.sl[268]=2023; /* line # 2023 */
          if (((V *)Rv5)[4]!=NULL) PAS__STR_TO_STR(Ra.s+530,((V *)Rv5)[4]);
          Ra.sl[268]=2024; /* line # 2024 */
          if (((V *)Rv5)[5]!=NULL) PAS__STR_TO_STR(Ra.s+787,((V *)Rv5)[5]);
          Ra.sl[268]=2026; /* line # 2026 */
          P_lst_open(&V_lst_current, Ra.s+16,Ra.s+273,Ra.s+530,Ra.s+787,132,-1,0,0,0,
          &Rv6);
          Ra.sl[268]=2038; /* line # 2038 */
          if (Rv6!=0) {
            Ra.sl[268]=2039; /* line # 2039 */
            if (!V_sy_init_mod) {
              Ra.sl[268]=2041; /* line # 2041 */
              P_src_error(Rd.s+2068,905,2);
            }
            else {
              Ra.sl[268]=2043; /* line # 2043 */
              Rv2=Rv2&~1;
            }
          }
          else {
            Ra.sl[268]=2046; /* line # 2046 */
            if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
            Ra.sl[268]=2047; /* line # 2047 */
            Rv2=Rv2|1;
          }
        }
        else {
          Ra.sl[268]=2051; /* line # 2051 */
          Rv2=Rv2&~1;
        }
      }
      Ra.sl[268]=2053; /* line # 2053 */
      if (((SL *)Rv1)[8]<((SL *)Rv1)[7]) ((SL *)Rv1)[8]=((SL *)Rv1)[7];
      Ra.sl[268]=2054; /* line # 2054 */
      Rv2=Rv2|1;
      break;
      case 1:Ra.sl[268]=2057; /* line # 2057 */
      Rv2=Rv2&~1;
      break;
      case 2:Ra.sl[268]=2059; /* line # 2059 */
      Rv2=Rv2|2;
      break;
      case 3:Ra.sl[268]=2060; /* line # 2060 */
      Rv2=Rv2&~2;
      break;
      case 4:Ra.sl[268]=2062; /* line # 2062 */
      Rv2=Rv2|32;
      break;
      case 5:Ra.sl[268]=2063; /* line # 2063 */
      Rv2=Rv2&~32;
      break;
      case 6:Ra.sl[268]=2067; /* line # 2067 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2068; /* line # 2068 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2070; /* line # 2070 */
        ((SL *)Rv1)[8]=V_sy_ival;
        Ra.sl[268]=2071; /* line # 2071 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2073; /* line # 2073 */
        ((SL *)Rv1)[8]=1;
      }
      break;
      case 7:Ra.sl[268]=2078; /* line # 2078 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2079; /* line # 2079 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2081; /* line # 2081 */
        ((SL *)Rv1)[11]=V_sy_ival;
        Ra.sl[268]=2082; /* line # 2082 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2084; /* line # 2084 */
        ((SL *)Rv1)[11]=1;
      }
      Ra.sl[268]=2085; /* line # 2085 */
      if (V_sy_sym.ub[0]==21) P_insymbol_src();
      Ra.sl[268]=2086; /* line # 2086 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2087; /* line # 2087 */
        ((SL *)Rv1)[12]=V_sy_ival;
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2088; /* line # 2088 */
        ((SL *)Rv1)[12]=255;
      }
      break;
      case 8:Ra.sl[268]=2091; /* line # 2091 */
      V_cmp_macf=1;
      break;
      case 9:Ra.sl[268]=2092; /* line # 2092 */
      V_cmp_macf=0;
      break;
      case 10:Ra.sl[268]=2094; /* line # 2094 */
      V_cmp_cobj=1;
      break;
      case 11:Ra.sl[268]=2095; /* line # 2095 */
      V_cmp_cobj=0;
      break;
      case 12:Ra.sl[268]=2098; /* line # 2098 */
      if (V_sy_sym.ub[0]==5) {
        Ra.sl[268]=2099; /* line # 2099 */
        if (V_sy_ident.ub[0]>0) {
          Ra.sl[268]=2101; /* line # 2101 */
          if (V_pas_obj!=NULL) P_binary_objf_close();
          Ra.sl[268]=2102; /* line # 2102 */
          Rv7=V_sy_string.ub[1];
          V_pas_obj=PAS__NEW((SL)Rv7+2);
          ((UB *)V_pas_obj)[0]=Rv7;
          Ra.sl[268]=2103; /* line # 2103 */
          PAS__STR_TO_STR(V_pas_obj,V_sy_string.s);
          Ra.sl[268]=2104; /* line # 2104 */
          P_insymbol_src();
          V_cmp_objf=1;
        }
        else {
          Ra.sl[268]=2106; /* line # 2106 */
          P_src_error(Rd.s+2068,904,4);
        }
      }
      else {
        Ra.sl[268]=2109; /* line # 2109 */
        if (V_cmp_objf) P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 13:Ra.sl[268]=2113; /* line # 2113 */
      if (V_cmp_objf) {
        Ra.sl[268]=2115; /* line # 2115 */
        P_binary_objf_close();
        V_cmp_objf=0;
      }
      break;
      case 14:Ra.sl[268]=2118; /* line # 2118 */
      V_cmp_bltt=1;
      break;
      case 15:Ra.sl[268]=2119; /* line # 2119 */
      V_cmp_bltt=0;
      break;
      case 16:Ra.sl[268]=2122; /* line # 2122 */
      if (V_sy_sym.ub[0]==2) {
        Ra.sl[268]=2126; /* line # 2126 */
        V_cmp_traceopt=V_sy_ival;
        Ra.sl[268]=2127; /* line # 2127 */
        P_insymbol_src();
      }
      else {
        Ra.sl[268]=2129; /* line # 2129 */
        P_src_error(Rd.s+2068,906,3);
      }
      break;
      case 17:Ra.sl[268]=2131; /* line # 2131 */
      V_cmp_debugopt=1;
      break;
      case 18:Ra.sl[268]=2132; /* line # 2132 */
      V_cmp_debugopt=0;
      break;
      case 19:Ra.sl[268]=2134; /* line # 2134 */
      V_cmp_range=1;
      break;
      case 20:Ra.sl[268]=2135; /* line # 2135 */
      V_cmp_range=0;
      break;
      case 21:Ra.sl[268]=2137; /* line # 2137 */
      P_generation_pragma();
      break;
      case 22:Ra.sl[268]=2139; /* line # 2139 */
      V_cmp_cmpdbg=1;
      break;
      case 23:Ra.sl[268]=2140; /* line # 2140 */
      V_cmp_cmpdbg=0;
      break;
      default:Ra.sl[268]=2143; /* line # 2143 */
      P_src_error_s(Rd.s+2068,901,1, V_sy_ident.s,NULL);
      break;
    }
    Ra.sl[268]=2145; /* line # 2145 */
    if (V_sy_sym.ub[0]==17) P_insymbol_src();
  }
  Ra.sl[268]=2147; /* line # 2147 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+2068,21,2);
  else {
    Ra.sl[268]=2148; /* line # 2148 */
    P_insymbol_src();
  }
  Ra.sl[268]=2149; /* line # 2149 */
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~35|Rv2;
  Ra.sl[268]=2151; /* line # 2151 */
  V_sy_label_flag=Rv0;
  PAS__curr_cntx=Ra.v[131];
}


/* Procedure/Function : " include_mstate "  */
void PAS_INSMBOL_include_mstate(UB F_bnsferr){
  /* Define the automatic variable space. */
  Blk( Ra, 800 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=254;
  Ra.ub[256]=254;
  Ra.v[64]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+512;
  Ra.v[65]=Rd.s+2072;
  Ra.v[66]=Rd.s+16;
  Ra.sl[134]=2169; /* line # 2169 */
  Ra.sl[134]=2171; /* line # 2171 */
  Rv0=V_sy_sym.ub[0]==101;
  Ra.sl[134]=2172; /* line # 2172 */
  P_insymbol_src();
  Ra.sl[134]=2173; /* line # 2173 */
  PAS_INSMBOL_mexpr_sval(Ra.s);
  Ra.sl[134]=2174; /* line # 2174 */
  Rv1=NULL;
  Ra.sl[134]=2175; /* line # 2175 */
  Rv2=PAS__NINDEX_CHA(Ra.s+2,(SL)Ra.ub[1],46,-1,-1,1);
  Ra.sl[134]=2176; /* line # 2176 */
  if (Rv2==0) PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+540,Ra.s,Rd.s+2088));
  Ra.sl[134]=2178; /* line # 2178 */
  Rv1=P_src_file_open(Ra.s,0,NULL);
  Ra.sl[134]=2179; /* line # 2179 */
  if (V_src_openerr==0) {
    Ra.sl[134]=2181; /* line # 2181 */
    Rv3=Rv1;
    Ra.sl[134]=2183; /* line # 2183 */
    ((V *)Rv3)[1]=V_src_control;
    Ra.sl[134]=2184; /* line # 2184 */
    ((SL *)Rv3)[7]=((SL *)V_src_control)[7];
    Ra.sl[134]=2185; /* line # 2185 */
    if (Rv0) ((SL *)Rv3)[7]=((SL *)Rv3)[7]+1;
    Ra.sl[134]=2186; /* line # 2186 */
    ((SL *)Rv3)[8]=((SL *)V_src_control)[8];
    Ra.sl[134]=2187; /* line # 2187 */
    ((SL *)Rv3)[6]=((SL *)V_src_control)[6];
    Ra.sl[134]=2188; /* line # 2188 */
    ((SL *)Rv3)[11]=((SL *)V_src_control)[11];
    Ra.sl[134]=2189; /* line # 2189 */
    ((SL *)Rv3)[12]=((SL *)V_src_control)[12];
    Ra.sl[134]=2190; /* line # 2190 */
    ((UL *)Rv3)[62]=((UL *)Rv3)[62]|((UL *)V_src_control)[62]&103;
    Ra.sl[134]=2194; /* line # 2194 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[134]=2196; /* line # 2196 */
      P_insymbol_src();
      Ra.sl[134]=2197; /* line # 2197 */
      PAS_INSMBOL_pragma_mstate(Rv1);
    }
    else {
      Ra.sl[134]=2200; /* line # 2200 */
      if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+2096,21,2);
    }
    Ra.sl[134]=2201; /* line # 2201 */
    if (!Rv0) P_src_end_of_line();
    Ra.sl[134]=2202; /* line # 2202 */
    V_src_control=Rv1;
    Ra.sl[134]=2203; /* line # 2203 */
    if (V_cmp_trace>0) V_cmp_tracecount=0;
    Ra.sl[134]=2204; /* line # 2204 */
    P_compile_set_title();
    Ra.sl[134]=2205; /* line # 2205 */
    P_set_srcfilespc((SL)Rv0);
    Ra.sl[134]=2206; /* line # 2206 */
    V_sy_ch=32;
    Ra.sl[134]=2207; /* line # 2207 */
    V_sy_sym.ub[0]=102;
    Ra.sl[134]=2208; /* line # 2208 */
    if (!Rv0) {
      Ra.sl[134]=2210; /* line # 2210 */
      Rv4=V_src_control;
      Ra.sl[134]=2212; /* line # 2212 */
      Rv1=((V *)Rv4)[1];
      Ra.sl[134]=2213; /* line # 2213 */
      ((V *)Rv4)[1]=((V *)Rv1)[1];
      Ra.sl[134]=2215; /* line # 2215 */
      P_src_close(&Rv1,1);
    }
    Ra.sl[134]=2217; /* line # 2217 */
    Rv5=V_src_control;
    Ra.sl[134]=2218; /* line # 2218 */
    if (1&((UL *)Rv5)[62]) {
      Ra.sl[134]=2220; /* line # 2220 */
      P_lst_newline();
      Ra.sl[134]=2221; /* line # 2221 */
      PAS__VWRITE_INIT(Ra.s+256,1);
      PAS__WRITE_STR(Rd.s+2100,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
      Ra.sl[134]=2222; /* line # 2222 */
      P_lst_put_string(Ra.s+256);
    }
  }
  else {
    Ra.sl[134]=2226; /* line # 2226 */
    P_lst_newline();
    Ra.sl[134]=2227; /* line # 2227 */
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Rd.s+2137,-1,-1,32);
    PAS__WRITE_INT(V_src_openerr,3,0);
    PAS__WRITE_STR(Rd.s+2159,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[134]=2228; /* line # 2228 */
    P_lst_put_string(Ra.s+256);
    Ra.sl[134]=2229; /* line # 2229 */
    P_lst_newline();
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_put_string(Ra.s+256);
    Ra.sl[134]=2230; /* line # 2230 */
    PAS__GET_RTL_MSG(V_src_openerr, Ra.s);
    Ra.sl[134]=2231; /* line # 2231 */
    P_lst_newline();
    PAS__VWRITE_INIT(Ra.s+256,1);
    PAS__WRITE_STR(Rd.s+2183,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_EOLN();
    P_lst_eoln();
    Ra.sl[134]=2240; /* line # 2240 */
    while ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=88)&&V_sy_sym.ub[0]!=104){
      Ra.sl[134]=2242; /* line # 2242 */
      P_insymbol_src();
    }
    Ra.sl[134]=2243; /* line # 2243 */
    if (F_bnsferr) {
      Ra.sl[134]=2244; /* line # 2244 */
      P_src_error(Rd.s+2096,902,4);
    }
    else {
      Ra.sl[134]=2246; /* line # 2246 */
      P_src_error(Rd.s+2096,902,3);
    }
  }
  Ra.sl[134]=2249; /* line # 2249 */
  P_insymbol_src();
  PAS__curr_cntx=Ra.v[64];
}


/* Procedure/Function : " endfile_mstate "  */
void PAS_INSMBOL_endfile_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 544 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=254;
  Ra.v[32]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+256;
  Ra.v[33]=Rd.s+2200;
  Ra.v[34]=Rd.s+16;
  Ra.sl[70]=2261; /* line # 2261 */
  Rv0=V_src_control;
  Ra.sl[70]=2263; /* line # 2263 */
  if (((V *)Rv0)[1]==NULL) V_sy_sym.ub[0]=88;
  else {
    Ra.sl[70]=2266; /* line # 2266 */
    V_sy_ch=P_src_return(1);
    Ra.sl[70]=2267; /* line # 2267 */
    V_sy_sym.ub[0]=105;
    Ra.sl[70]=2268; /* line # 2268 */
    V_sy_ch=32;
    Ra.sl[70]=2269; /* line # 2269 */
    P_set_srcfilespc(-1);
    Ra.sl[70]=2270; /* line # 2270 */
    P_compile_set_title();
  }
  Ra.sl[70]=2272; /* line # 2272 */
  Rv1=V_src_control;
  Ra.sl[70]=2273; /* line # 2273 */
  if (1&((UL *)Rv1)[62]) {
    Ra.sl[70]=2275; /* line # 2275 */
    P_lst_newline();
    Ra.sl[70]=2276; /* line # 2276 */
    PAS__VWRITE_INIT(Ra.s,1);
    PAS__WRITE_STR(Rd.s+2216,-1,-1,32);
    PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+284,((V *)Rv1)[35]),-1,-1,32);
    PAS__WRITE_CHAR(34);
    PAS__WRITE_EOLN();
    Ra.sl[70]=2278; /* line # 2278 */
    P_lst_put_string(Ra.s);
  }
  Ra.sl[70]=2281; /* line # 2281 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  Ra.sl[70]=2282; /* line # 2282 */
  if (V_sy_sym.ub[0]==88) V_pas_compile=0;
  else {
    Ra.sl[70]=2283; /* line # 2283 */
    P_insymbol_src();
  }
  PAS__curr_cntx=Ra.v[32];
}


/* Procedure/Function : " cnd_push "  */
UB PAS_INSMBOL_cnd_push(UB F_cds){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2253;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2292; /* line # 2292 */
  if (Ri.sl[232]<32) {
    Ra.sl[6]=2294; /* line # 2294 */
    Ri.sl[232]=Ri.sl[232]+1;
    Ra.sl[6]=2295; /* line # 2295 */
    Rs.ub[Ri.sl[232]+511]=F_cds;
  }
  else {
    Ra.sl[6]=2299; /* line # 2299 */
    P_src_error(Rd.s+2265,950,4);
    Ra.sl[6]=2300; /* line # 2300 */
    Rv0=0;
  }
  Ra.sl[6]=2302; /* line # 2302 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cnd_pop "  */
UB PAS_INSMBOL_cnd_pop(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2269;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2309; /* line # 2309 */
  if (Ri.sl[232]<=0) {
    Ra.sl[6]=2311; /* line # 2311 */
    P_src_error(Rd.s+2265,951,4);
    Ra.sl[6]=2312; /* line # 2312 */
    Rv0=0;
  }
  else {
    Ra.sl[6]=2314; /* line # 2314 */
    Ri.sl[232]=Ri.sl[232]-1;
  }
  Ra.sl[6]=2315; /* line # 2315 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cnd_check "  */
UB PAS_INSMBOL_cnd_check(UB F_cds){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2278;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2323; /* line # 2323 */
  if (Ri.sl[232]>0) {
    Ra.sl[6]=2325; /* line # 2325 */
    if (F_cds>=Rs.ub[Ri.sl[232]+511]) Rs.ub[Ri.sl[232]+511]=F_cds;
    else {
      Ra.sl[6]=2326; /* line # 2326 */
      Rv0=0;
    }
  }
  else {
    Ra.sl[6]=2327; /* line # 2327 */
    Rv0=0;
  }
  Ra.sl[6]=2329; /* line # 2329 */
  if (!Rv0) P_src_error(Rd.s+2265,952,4);
  Ra.sl[6]=2330; /* line # 2330 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " mif_mstate "  */
UB PAS_INSMBOL_mif_mstate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2289;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2345; /* line # 2345 */
  Ra.sl[6]=2347; /* line # 2347 */
  Rv0=V_sy_sym.ub[0];
  Ra.sl[6]=2348; /* line # 2348 */
  P_insymbol_src();
  Ra.sl[6]=2349; /* line # 2349 */
  switch (Rv0) {
    case 93:
    case 94:Ra.sl[6]=2353; /* line # 2353 */
    Rv1=V_sy_macsymb!=NULL^Rv0==94;
    Ra.sl[6]=2354; /* line # 2354 */
    P_insymbol_src();
    Ra.sl[6]=2355; /* line # 2355 */
    PAS_INSMBOL_cnd_push(0);
    break;
    case 92:Ra.sl[6]=2360; /* line # 2360 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    Ra.sl[6]=2361; /* line # 2361 */
    PAS_INSMBOL_cnd_push(0);
    break;
    case 97:Ra.sl[6]=2366; /* line # 2366 */
    Rv1=PAS_INSMBOL_mexpr_bval();
    Ra.sl[6]=2367; /* line # 2367 */
    PAS_INSMBOL_cnd_check(1);
    break;
    default:break;
  }
  Ra.sl[6]=2372; /* line # 2372 */
  if (V_sy_sym.ub[0]!=95) P_src_error(Rd.s+2303,932,2);
  Ra.sl[6]=2374; /* line # 2374 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insymbol "  */
void P_insymbol(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  C Rv1;
  UB Rv2;
  UB Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2307;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2406; /* line # 2406 */
  P_insymbol_src();
  Ra.sl[6]=2407; /* line # 2407 */
  Rv0=V_src_control;
  Ra.sl[6]=2408; /* line # 2408 */
  while (V_sy_sym.ub[0]>=89){
    Ra.sl[6]=2410; /* line # 2410 */
    switch (V_sy_sym.ub[0]) {
      case 101:
      case 102:Ra.sl[6]=2412; /* line # 2412 */
      PAS_INSMBOL_include_mstate(V_sy_init_mod);
      break;
      case 103:Ra.sl[6]=2415; /* line # 2415 */
      PAS_INSMBOL_pragma_mstate(V_src_control);
      break;
      case 89:Ra.sl[6]=2418; /* line # 2418 */
      PAS_INSMBOL_define_macro_symbol();
      break;
      case 90:Ra.sl[6]=2421; /* line # 2421 */
      PAS_INSMBOL_undefine_macro_mbol();
      break;
      case 91:Ra.sl[6]=2424; /* line # 2424 */
      PAS_INSMBOL_macro_assign_symbol();
      break;
      case 92:
      case 93:
      case 94:Ra.sl[6]=2428; /* line # 2428 */
      Rv1=((C *)Rv0)[54];
      while (1){
        Ra.sl[6]=2430; /* line # 2430 */
        Rv2=PAS_INSMBOL_mif_mstate();
        Ra.sl[6]=2431; /* line # 2431 */
        if (Rv2)  break;
        Ra.sl[6]=2433; /* line # 2433 */
        ((C *)Rv0)[54]=83;
        Ra.sl[6]=2434; /* line # 2434 */
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2324);
        Ra.sl[6]=2435; /* line # 2435 */
        ((C *)Rv0)[54]=Rv1;
        if (V_sy_sym.ub[0]!=97)  break;
      }
      Ra.sl[6]=2437; /* line # 2437 */
      if (Rv2||V_sy_sym.ub[0]==96) {
        Ra.sl[6]=2439; /* line # 2439 */
        ((C *)Rv0)[54]=Rv1;
        Ra.sl[6]=2440; /* line # 2440 */
        PAS_INSMBOL_cnd_check(2);
        Ra.sl[6]=2441; /* line # 2441 */
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2445; /* line # 2445 */
        PAS_INSMBOL_skip_mcsymbol(Rd.s+2340);
        Ra.sl[6]=2446; /* line # 2446 */
        PAS_INSMBOL_cnd_pop();
        Ra.sl[6]=2447; /* line # 2447 */
        ((C *)Rv0)[54]=Rv1;
        Ra.sl[6]=2448; /* line # 2448 */
        if (V_sy_sym.ub[0]==98) P_insymbol_src();
        else {
          Ra.sl[6]=2449; /* line # 2449 */
          P_src_error(Rd.s+2319,953,4);
        }
      }
      break;
      case 96:
      case 97:
      case 98:Ra.sl[6]=2455; /* line # 2455 */
      Rv1=((C *)Rv0)[54];
      ((C *)Rv0)[54]=83;
      Ra.sl[6]=2456; /* line # 2456 */
      PAS_INSMBOL_skip_mcsymbol(Rd.s+2356);
      Ra.sl[6]=2457; /* line # 2457 */
      P_insymbol_src();
      Ra.sl[6]=2458; /* line # 2458 */
      ((C *)Rv0)[54]=Rv1;
      Ra.sl[6]=2459; /* line # 2459 */
      PAS_INSMBOL_cnd_pop();
      break;
      case 99:Ra.sl[6]=2463; /* line # 2463 */
      if (V_sy_macsymb!=NULL) {
        Ra.sl[6]=2465; /* line # 2465 */
        P_macro_replace(V_sy_macsymb);
        Ra.sl[6]=2466; /* line # 2466 */
        P_insymbol_src();
      }
      else {
        Ra.sl[6]=2469; /* line # 2469 */
        P_src_error_s(Rd.s+2319,995,3, V_sy_ident.s,NULL);
      }
      break;
      case 100:Ra.sl[6]=2473; /* line # 2473 */
      P_insymbol_src();
      Ra.sl[6]=2474; /* line # 2474 */
      if (V_sy_sym.ub[0]==13) P_insymbol_src();
      else P_src_error(Rd.s+2319,955,2);
      Ra.sl[6]=2475; /* line # 2475 */
      PAS__VWRITE_INIT(Ri.s+932,1);
      PAS__WRITE_STR(Rd.s+2372,-1,-1,32);
      PAS__WRITE_EOLN();
      while (1){
        Ra.sl[6]=2477; /* line # 2477 */
        P_insymbol_src();
        Ra.sl[6]=2478; /* line # 2478 */
        switch (V_sy_sym.ub[0]) {
          case 5:Ra.sl[6]=2480; /* line # 2480 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(V_sy_string.s,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          case 99:Ra.sl[6]=2484; /* line # 2484 */
          Rv3=1;
          Ra.sl[6]=2485; /* line # 2485 */
          if (V_sy_macsymb!=NULL) {
            Rv4=V_sy_macsymb+64;
            Ra.sl[6]=2486; /* line # 2486 */
            switch (((UB *)Rv4)[0]) {
              case 0:Ra.sl[6]=2487; /* line # 2487 */
              PAS__VWRITE_INIT(Ri.s+932,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rv4)[1],0,0);
              PAS__WRITE_EOLN();
              break;
              case 1:Ra.sl[6]=2488; /* line # 2488 */
              PAS__VWRITE_INIT(Ri.s+932,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_STR(((V *)Rv4)[1],-1,-1,32);
              PAS__WRITE_EOLN();
              break;
              default:Ra.sl[6]=2490; /* line # 2490 */
              Rv3=0;
              break;
            }
          }
          else {
            Ra.sl[6]=2492; /* line # 2492 */
            Rv3=0;
          }
          Ra.sl[6]=2493; /* line # 2493 */
          if (Rv3) {
            PAS__VWRITE_INIT(Ri.s+932,0);
            PAS__WRITE_STR(Rd.s+2389,-1,-1,32);
            PAS__WRITE_CHT(V_sy_ident.s+1,31, V_sy_ident.ub[0],-1,32);
            PAS__WRITE_CHAR(34);
            PAS__WRITE_EOLN();
          }
          break;
          case 0:Ra.sl[6]=2497; /* line # 2497 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(V_sy_ident.s+1,31, V_sy_ident.ub[0],-1,32);
          PAS__WRITE_EOLN();
          break;
          case 2:Ra.sl[6]=2500; /* line # 2500 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(V_sy_ival,12,0);
          PAS__WRITE_EOLN();
          break;
          case 3:Ra.sl[6]=2502; /* line # 2502 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(V_sy_rval,24,-15,0);
          PAS__WRITE_CHAR(70);
          PAS__WRITE_EOLN();
          break;
          case 4:Ra.sl[6]=2504; /* line # 2504 */
          PAS__VWRITE_INIT(Ri.s+932,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(V_sy_rval,24,-15,0);
          PAS__WRITE_CHAR(68);
          PAS__WRITE_EOLN();
          break;
          default:Ra.sl[6]=2507; /* line # 2507 */
          P_src_error(Rd.s+2319,956,2);
          break;
        }
        Ra.sl[6]=2510; /* line # 2510 */
        P_insymbol_src();
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=2512; /* line # 2512 */
      P_lst_newline();
      P_lst_put_string(Ri.s+932);
      P_lst_eoln();
      Ra.sl[6]=2513; /* line # 2513 */
      if (V_sy_sym.ub[0]==14) P_insymbol_src();
      else {
        Ra.sl[6]=2514; /* line # 2514 */
        P_src_error(Rd.s+2319,957,2);
      }
      break;
      case 104:Ra.sl[6]=2520; /* line # 2520 */
      PAS_INSMBOL_endfile_mstate();
      break;
      default:Ra.sl[6]=2525; /* line # 2525 */
      P_src_error(Rd.s+2319,997,3);
      Ra.sl[6]=2526; /* line # 2526 */
      P_insymbol_src();
      break;
    }
    Ra.sl[6]=2528; /* line # 2528 */
    if (Ri.sl[232]<0) {
      Ra.sl[6]=2530; /* line # 2530 */
      P_src_error(Rd.s+2319,996,2);
      Ra.sl[6]=2531; /* line # 2531 */
      Ri.sl[232]=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_symbol "  */
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2412;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2541; /* line # 2541 */
  Ra.sl[6]=2542; /* line # 2542 */
  while (V_sy_sym.ub[0]!=F_tosymbol&&V_sy_sym.ub[0]!=88){
    Ra.sl[6]=2544; /* line # 2544 */
    P_insymbol();
    Ra.sl[6]=2545; /* line # 2545 */
    switch (V_sy_sym.ub[0]) {
      case 56:Ra.sl[6]=2547; /* line # 2547 */
      if (!F_rec_flg) {
        Ra.sl[6]=2549; /* line # 2549 */
        P_skip_symbol(72,0,0);
        P_insymbol();
      }
      break;
      case 41:Ra.sl[6]=2553; /* line # 2553 */
      P_skip_symbol(72,1,0);
      P_insymbol();
      break;
      case 54:
      case 71:Ra.sl[6]=2557; /* line # 2557 */
      P_skip_symbol(72,0,0);
      P_insymbol();
      break;
      case 13:Ra.sl[6]=2561; /* line # 2561 */
      P_skip_symbol(14,0,0);
      P_insymbol();
      break;
      case 15:Ra.sl[6]=2565; /* line # 2565 */
      P_skip_symbol(16,0,0);
      P_insymbol();
      break;
      case 48:Ra.sl[6]=2569; /* line # 2569 */
      P_skip_symbol(49,0,0);
      P_insymbol();
      break;
      case 72:Ra.sl[6]=2572; /* line # 2572 */
      if (F_tosymbol==46||F_errflg) goto L_l_0;
      break;
      default:break;
    }
  }
L_l_0: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_msymbol "  */
void P_skip_msymbol(V F_smb, UB F_rec_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2425;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2582; /* line # 2582 */
  Ra.sl[6]=2583; /* line # 2583 */
  while (!(PAS__INOP_LSET(V_sy_sym.ub[0],F_smb,106)||V_sy_sym.ub[0]==88)){
    Ra.sl[6]=2585; /* line # 2585 */
    P_insymbol();
    Ra.sl[6]=2586; /* line # 2586 */
    switch (V_sy_sym.ub[0]) {
      case 56:Ra.sl[6]=2588; /* line # 2588 */
      if (!F_rec_flg) {
        Ra.sl[6]=2590; /* line # 2590 */
        P_skip_msymbol(Rd.s+2440,0);
        P_insymbol();
      }
      break;
      case 41:Ra.sl[6]=2595; /* line # 2595 */
      P_skip_msymbol(Rd.s+2452,1);
      P_insymbol();
      break;
      case 54:
      case 71:Ra.sl[6]=2600; /* line # 2600 */
      P_skip_msymbol(Rd.s+2464,0);
      P_insymbol();
      break;
      case 13:Ra.sl[6]=2605; /* line # 2605 */
      P_skip_msymbol((V)Rd.s+2476,0);
      P_insymbol();
      break;
      case 15:Ra.sl[6]=2610; /* line # 2610 */
      P_skip_msymbol((V)Rd.s+2480,0);
      P_insymbol();
      break;
      case 48:Ra.sl[6]=2615; /* line # 2615 */
      P_skip_msymbol(Rd.s+2484,0);
      P_insymbol();
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " insy_init "  */
void P_insy_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 288 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2492;
  Ra.v[2]=Rd.s+16;
  Ra.sl[6]=2631; /* line # 2631 */
  P_lst_g_init(Rd.s+2503,Rd.s+2505,&Rv0);
  Ra.sl[6]=2633; /* line # 2633 */
  if (Rv0==0) {
    Ra.sl[6]=2636; /* line # 2636 */
    P_err_init(PAS__CON_STR_STR(Ra.s+28,V_cpas_ini_dir.s,Rd.s+2560));
    Ra.sl[6]=2639; /* line # 2639 */
    P_src_init(Rd.s+2574,V_trg_env_fspc.s);
    Ra.sl[6]=2640; /* line # 2640 */
    if (V_cmp_macroexp) {
      Ra.sl[6]=2641; /* line # 2641 */
      P_src_set_flags(2,0);
    }
    Ra.sl[6]=2643; /* line # 2643 */
    if (V_src_control==NULL) {
      Ra.sl[6]=2645; /* line # 2645 */
      V_error_result=4;
      V_emergency_stop=1;
      Ra.sl[6]=2646; /* line # 2646 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2581,-1,-1,32);
      PAS__WRITE_STR(V_trg_env_fspc.s,-1,-1,32);
      PAS__WRITE_STR(Rd.s+2631,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[6]=2647; /* line # 2647 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2648,-1,-1,32);
      PAS__WRITE_STR(V_trg_sys_name.s,-1,-1,32);
      PAS__WRITE_CHAR(34);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=2655; /* line # 2655 */
      PAS_INSMBOL_set_keyword_tree();
      Ra.sl[6]=2657; /* line # 2657 */
      V_proc_seq=0;
      Ra.sl[6]=2658; /* line # 2658 */
      V_srf_free=NULL;
      Ra.sl[6]=2659; /* line # 2659 */
      V_srf_list=NULL;
      Ra.sl[6]=2660; /* line # 2660 */
      Ri.sl[232]=0;
      Ra.sl[6]=2664; /* line # 2664 */
      P_ide_init();
      Ra.sl[6]=2667; /* line # 2667 */
      P_set_srcfilespc(1);
      Ra.sl[6]=2670; /* line # 2670 */
      V_sy_attrflg=0;
      Ra.sl[6]=2671; /* line # 2671 */
      V_sy_ch=32;
      Ra.sl[6]=2674; /* line # 2674 */
      V_sy_label_flag=0;
    }
  }
  else {
    Ra.sl[6]=2679; /* line # 2679 */
    V_error_result=4;
    V_emergency_stop=1;
    Ra.sl[6]=2680; /* line # 2680 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2704,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2503,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2728,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}
