/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 1168 ) = {{
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  62,  62,  47,
104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  50,  47,
112,  99, 109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115,
101, 116,  95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,
  9,   9, 115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109,
112,  97, 114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,
 97, 114, 101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,
 99, 111, 109, 112,  95, 115,  99,  97, 108,  97, 114,  13,  13,  99, 104, 105,
108, 100, 114, 101, 110,  95, 116, 121, 112, 101,  13,  13, 115, 117,  98,  95,
 99, 111, 109, 112,  95, 116, 121, 112, 101,   1,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   3,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   4,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,
  0,   0,   0,   0,   4,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   1,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   0,   0,   4,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   4,   4,   4,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
  0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   0,
  0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   4,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,
  0,   0,   4,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   4,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,
  4,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   0,   0,   0,   0,   0,   4,   4,   0,   4,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   4,   4,   4,   0,
  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   9,   9,  99,
111, 109, 112,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  95, 112,
114, 111,  99,  95,  97, 114, 103,  18,  18, 116, 121, 112, 101,  95, 112,  97,
114, 109,  95,  99, 116, 101,  95, 105, 110, 105, 116,   4,   4,  84,  89,  67,
 49,  21,  21, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,
 95, 114, 101, 108, 101,  97, 115, 101,  15,  15, 115, 116, 114, 105, 110, 103,
 95, 105, 110,  95,  97, 114, 114,  97, 121,  19,  19, 115, 116, 114, 105, 110,
103,  95, 105, 110,  95, 115, 117,  98, 115, 116, 114, 105, 110, 103,  16,  16,
105, 110, 105, 116, 105,  97, 108, 105, 122, 101,  95, 118,  97, 114,  98, 108,
 15,  15, 116, 121, 112, 101,  95,  99, 104, 101,  99, 107,  95, 112,  97, 114,
109,   4,   4,  84,  89,  67,  72,  17,  17, 115, 117,  98, 116, 121, 112, 101,
 95, 115, 101, 116,  95, 118,  97, 108, 117, 101,  13,  13, 116, 121, 112, 101,
 95, 112,  97, 114, 109,  95, 115, 101, 116,   4,   4,  84,  80,  82,  77,  12,
 12, 105, 110, 105, 116,  95, 100, 121, 110,  95, 116,  97,  98,  11,  11, 100,
121, 110,  95, 114, 101,  99,  95, 103, 115, 108,  12,  12, 105, 110, 105, 116,
 95, 100, 121, 110,  95, 114, 101,  99,  10,  10, 105, 110, 105, 116,  95, 100,
121, 110,  95, 100,   4,   4,  73,  68,  89,  78,  10,  10, 105, 110, 105, 116,
 95, 100,  95, 100, 121, 110,   4,   4,  73,  68,  68,  89,  10,  10, 105, 110,
105, 116,  95, 100,  95, 116,  97,  98,   4,   4,  73,  68,  84,  66,  10,  10,
105, 110, 105, 116,  95, 100,  95, 114, 101,  99,   4,   4,  73,  68,  82,  68,
 13,  13, 105, 110, 105, 116,  95, 100,  95, 115, 116,  97, 116, 105,  99,   4,
  4,  73,  68,  83,  84,  12,  12, 105, 110, 105, 116,  95, 100,  95, 118,  97,
114,  98, 108,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95, 117, 110,  97,
  4,   4,  69,  67,  85,  78,  11,  11, 101, 120, 112,  95, 118,  97, 108,  95,
 98, 105, 110,   4,   4,  69,  88,  80,  66,  19,  19, 108, 111, 111, 107,  95,
102, 111, 114,  95, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,  12,  12,
 99,  97, 108, 108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  67,  65,
 76,  76,  14,  14, 103, 101, 110, 101, 114, 105,  99,  95, 115, 101,  97, 114,
 99, 104,   4,   4,  71,  69,  78,  83,  11,  11, 101, 120, 112,  95, 103, 101,
110, 111, 112, 101, 114,  13,  13, 103, 101, 110, 101, 114,  97, 116, 101,  95,
 99,  97, 108, 108,   9,   9, 101, 120, 112,  95, 103, 101, 110, 111, 112,  13,
 13, 108, 103, 116,  95, 103, 101, 110,  95, 115, 116, 111, 114, 101,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {{
 29,   0,   0,   0,   0,   0,   0,   0
}};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 248 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern Blk(V_oparg_cvtab, 56 );
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=93; /* line # 93 */
  if (V_sy_sym.ub[0]==5) {
    Ra.sl[6]=95; /* line # 95 */
    (*F_nam)=PAS__NEW(32);
    Ra.sl[6]=96; /* line # 96 */
    Rv0=(*F_nam);
    Ra.sl[6]=98; /* line # 98 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else {
      Ra.sl[6]=99; /* line # 99 */
      ((UB *)Rv0)[0]=V_sy_string.ub[1];
    }
    Ra.sl[6]=100; /* line # 100 */
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[6]=101; /* line # 101 */
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=103; /* line # 103 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=118; /* line # 118 */
  Rv0=F_pr;
  Ra.sl[6]=120; /* line # 120 */
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+92,129,1);
  Ra.sl[6]=121; /* line # 121 */
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=124; /* line # 124 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[6]=125; /* line # 125 */
    P_src_error(Rd.s+92,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+96;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=139; /* line # 139 */
  V_enm_range=0;
  Ra.sl[6]=140; /* line # 140 */
  Rv0=F_ty1==F_ty2;
  Ra.sl[6]=142; /* line # 142 */
  if (!Rv0) {
    Ra.sl[6]=143; /* line # 143 */
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=144; /* line # 144 */
      if (((((UB *)F_ty1)[92]==((UB *)F_ty2)[92]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) {
        Ra.sl[6]=148; /* line # 148 */
        switch (((UB *)F_ty1)[92]) {
          case 0:
          case 1:
          case 2:Ra.sl[6]=150; /* line # 150 */
          if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)
          F_ty2)[29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) {
            Ra.sl[6]=152; /* line # 152 */
            Rv0=1;
          }
          break;
          case 3:
          case 4:Ra.sl[6]=153; /* line # 153 */
          Rv0=1;
          break;
          case 5:
          case 7:
          case 13:Ra.sl[6]=155; /* line # 155 */
          Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
          break;
          case 11:
          case 12:Ra.sl[6]=157; /* line # 157 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) {
            Ra.sl[6]=158; /* line # 158 */
            Rv0=P_same_type(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          }
          break;
          case 8:
          case 9:Ra.sl[6]=160; /* line # 160 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
          [25]) {
            Ra.sl[6]=162; /* line # 162 */
            if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
            F_ty1)[14],((V *)F_ty2)[14])) {
              Ra.sl[6]=164; /* line # 164 */
              Rv0=1;
            }
          }
          break;
          case 22:Ra.sl[6]=166; /* line # 166 */
          Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
          break;
          case 6:Ra.sl[6]=168; /* line # 168 */
          Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          break;
          default:break;
        }
      }
    }
  }
  Ra.sl[6]=171; /* line # 171 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=184; /* line # 184 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Ra.sl[6]=187; /* line # 187 */
    Rv0=0;
    Ra.sl[6]=188; /* line # 188 */
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=190; /* line # 190 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else {
        Ra.sl[6]=191; /* line # 191 */
        Rv0=1;
      }
      Ra.sl[6]=192; /* line # 192 */
      if (Rv0) {
        Ra.sl[6]=194; /* line # 194 */
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=198; /* line # 198 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Ra.sl[6]=201; /* line # 201 */
          Rv0=P_same_type(((V *)Rv1)[4],((V *)Rv2)[4]);
          Ra.sl[6]=202; /* line # 202 */
          if (Rv0) {
            Ra.sl[6]=204; /* line # 204 */
            if (((UB *)Rv1)[56]==7) {
              Ra.sl[6]=205; /* line # 205 */
              if (((UB *)Rv2)[56]==7) {
                Ra.sl[6]=206; /* line # 206 */
                if (((UB *)((V *)Rv1)[9])[104]==3&&((UB *)((V *)Rv2)[9])[104]==3)
                 {
                  Ra.sl[6]=207; /* line # 207 */
                  Rv0=P_compare_entry(((V *)Rv1)[9],((V *)Rv2)[9]);
                }
                else {
                  Ra.sl[6]=208; /* line # 208 */
                  Rv0=0;
                }
              }
              else {
                Ra.sl[6]=209; /* line # 209 */
                Rv0=0;
              }
            }
            Ra.sl[6]=210; /* line # 210 */
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        Ra.sl[6]=213; /* line # 213 */
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=217; /* line # 217 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+122;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=231; /* line # 231 */
  Rv0=0;
  Ra.sl[6]=232; /* line # 232 */
  if (F_pgc!=NULL&&F_ent!=NULL) {
    Ra.sl[6]=235; /* line # 235 */
    while (F_pgc!=NULL&&!Rv0){
      Ra.sl[6]=236; /* line # 236 */
      Rv1=F_pgc;
      Ra.sl[6]=238; /* line # 238 */
      if (!((UB *)Rv1)[8]) {
        Ra.sl[6]=240; /* line # 240 */
        Rv2=((V *)Rv1)[2];
        Ra.sl[6]=241; /* line # 241 */
        Rv0=P_compare_entry(Rv2, F_ent);
      }
      Ra.sl[6]=243; /* line # 243 */
      if (!Rv0) {
        Ra.sl[6]=244; /* line # 244 */
        if (F_pgc==F_pgl) F_pgc=NULL;
        else {
          Ra.sl[6]=245; /* line # 245 */
          F_pgc=((V *)F_pgc)[0];
        }
      }
    }
  }
  Ra.sl[6]=248; /* line # 248 */
  if (!Rv0) F_pgc=NULL;
  Ra.sl[6]=249; /* line # 249 */
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+142;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=268; /* line # 268 */
  Rv0=4;
  Ra.sl[6]=269; /* line # 269 */
  if (F_te==F_tf) Rv0=0;
  else {
    Ra.sl[6]=270; /* line # 270 */
    if (F_te!=NULL&&F_tf!=NULL) {
      Ra.sl[6]=271; /* line # 271 */
      Rv1=F_te;
      Ra.sl[6]=272; /* line # 272 */
      if (((UB *)Rv1)[92]==((UB *)F_tf)[92]) {
        Ra.sl[6]=273; /* line # 273 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          Ra.sl[6]=276; /* line # 276 */
          if (((UB *)Rv1)[112]) {
            Ra.sl[6]=277; /* line # 277 */
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=279; /* line # 279 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Ra.sl[6]=280; /* line # 280 */
          Rv4=F_tf;
          Ra.sl[6]=281; /* line # 281 */
          if (((UB *)Rv4)[112]) {
            Ra.sl[6]=282; /* line # 282 */
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=284; /* line # 284 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          Ra.sl[6]=286; /* line # 286 */
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          Ra.sl[6]=288; /* line # 288 */
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=290; /* line # 290 */
            if (Rv2==Rv5) {
              Ra.sl[6]=291; /* line # 291 */
              if (Rv3==Rv6) Rv0=0;
              else {
                Ra.sl[6]=292; /* line # 292 */
                Rv0=1;
              }
            }
            else {
              Ra.sl[6]=293; /* line # 293 */
              Rv0=2;
            }
          }
          else {
            Ra.sl[6]=294; /* line # 294 */
            Rv0=3;
          }
        }
        else {
          Ra.sl[6]=296; /* line # 296 */
          V_enm_range=1;
        }
      }
    }
  }
  Ra.sl[6]=297; /* line # 297 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " children_type "  */
UB P_children_type(V F_eff, V F_frm, UB F_bpar, UB F_bsym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=311; /* line # 311 */
  if (F_frm!=NULL) {
    Ra.sl[6]=313; /* line # 313 */
    F_bpar=1;
    Ra.sl[6]=314; /* line # 314 */
    if (F_bpar) {
      Ra.sl[6]=316; /* line # 316 */
      Rv1=F_eff;
      Ra.sl[6]=317; /* line # 317 */
      while (Rv1!=NULL&&Rv1!=F_frm)
      Rv1=((V *)Rv1)[0];
      Ra.sl[6]=318; /* line # 318 */
      Rv0=Rv1==F_frm;
      Ra.sl[6]=319; /* line # 319 */
      if (!Rv0&&F_bsym) Rv0=P_children_type(F_frm, F_eff, F_bpar,0);
    }
    else {
      Ra.sl[6]=321; /* line # 321 */
      Rv0=F_eff==F_frm;
    }
  }
  Ra.sl[6]=323; /* line # 323 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sub_comp_type "  */
UB PAS_EXPSION_PRC_00000000(V F_eff, V F_frm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=379; /* line # 379 */
  Rv0=0;
  Ra.sl[6]=380; /* line # 380 */
  Rv1=F_frm;
  Ra.sl[6]=381; /* line # 381 */
  switch (Rd.ub[((UB *)F_eff)[92]*22+((UB *)Rv1)[92]+185]) {
    case 4:Ra.sl[6]=382; /* line # 382 */
    Rv0=1;
    break;
    case 1:Ra.sl[6]=385; /* line # 385 */
    switch (((UB *)Rv1)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=389; /* line # 389 */
      if (((UB *)Rv1)[88]) {
        Ra.sl[6]=390; /* line # 390 */
        if (!Lx[0].ub[28]) Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
        else {
          Ra.sl[6]=391; /* line # 391 */
          Rv0=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv1)[11]==((SL *)
          F_eff)[11];
        }
      }
      break;
      case 11:
      case 12:Ra.sl[6]=395; /* line # 395 */
      Rv0=P_comp_type(((V *)F_eff)[13],((V *)Rv1)[13],Lx[0].ub[28],0);
      break;
      case 8:Ra.sl[6]=398; /* line # 398 */
      Rv0=((V *)F_eff)[14]==((V *)Rv1)[14]&&P_comp_type(((V *)F_eff)[15],((V *)Rv1)
      [15],1,1);
      break;
      case 9:Ra.sl[6]=402; /* line # 402 */
      Rv0=P_comp_type(((V *)F_eff)[14],((V *)Rv1)[14],1,0)&&P_comp_type(((V *)F_eff)
      [15],((V *)((V *)Rv1)[15])[0],1,1);
      break;
      case 5:Ra.sl[6]=406; /* line # 406 */
      if (((V *)Rv1)[12]==NULL) Rv0=1;
      else {
        Ra.sl[6]=407; /* line # 407 */
        Rv0=P_comp_type(((V *)F_eff)[12],((V *)Rv1)[12],1,1);
      }
      break;
      case 6:Ra.sl[6]=410; /* line # 410 */
      if (((V *)Rv1)[13]==NULL) Rv0=1;
      else {
        Ra.sl[6]=411; /* line # 411 */
        Rv0=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv1)[13]);
      }
      break;
      default:break;
    }
    break;
    case 3:Ra.sl[6]=417; /* line # 417 */
    Rv0=P_comp_type(F_frm, V_typ_std.v[10],0,0);
    break;
    case 2:Ra.sl[6]=420; /* line # 420 */
    if (P_comp_type(F_eff, V_typ_std.v[10],0,0)) {
      Ra.sl[6]=422; /* line # 422 */
      Rv0=P_comp_type(((V *)((V *)F_eff)[13])[4],F_frm,0,0);
    }
    break;
    default:break;
  }
  Ra.sl[6]=427; /* line # 427 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_exact;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+669;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=432; /* line # 432 */
  V_enm_range=0;
  Ra.sl[6]=434; /* line # 434 */
  Rv0=0;
  Ra.sl[6]=435; /* line # 435 */
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=437; /* line # 437 */
    Rv0=P_children_type(F_eff, F_frm,!Ra.ub[28],F_sym);
    Ra.sl[6]=438; /* line # 438 */
    if (!Rv0) {
      Ra.sl[6]=439; /* line # 439 */
      Rv1=F_frm;
      Ra.sl[6]=441; /* line # 441 */
      if (((UB *)Rv1)[92]==22) {
        Ra.sl[6]=442; /* line # 442 */
        Rv0=P_comp_type(((V *)Rv1)[0],F_eff, Ra.ub[28],0);
      }
      Ra.sl[6]=444; /* line # 444 */
      if (!Rv0) {
        Ra.sl[6]=445; /* line # 445 */
        if (((UB *)F_eff)[92]<=21&&((UB *)Rv1)[92]<=21) {
          Ra.sl[6]=447; /* line # 447 */
          Rv0=PAS_EXPSION_PRC_00000000(F_eff, F_frm);
          Ra.sl[6]=448; /* line # 448 */
          if (!Rv0&&F_sym) Rv0=PAS_EXPSION_PRC_00000000(F_frm, F_eff);
        }
      }
    }
  }
  Ra.sl[6]=452; /* line # 452 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+680;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=466; /* line # 466 */
  Rv0=1;
  Ra.sl[6]=467; /* line # 467 */
  if (F_epr!=F_fpr) {
    Ra.sl[6]=468; /* line # 468 */
    if (F_epr!=NULL&&F_fpr!=NULL) {
      Ra.sl[6]=470; /* line # 470 */
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=471; /* line # 471 */
        Rv0=0;
      }
      else {
        Ra.sl[6]=474; /* line # 474 */
        Rv1=((V *)F_epr)[8];
        Ra.sl[6]=475; /* line # 475 */
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=476; /* line # 476 */
        if (((V *)F_epr)[11]!=NULL) {
          Ra.sl[6]=477; /* line # 477 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        Ra.sl[6]=478; /* line # 478 */
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          Ra.sl[6]=480; /* line # 480 */
          if (((UB *)Rv2)[56]!=((UB *)Rv1)[56]) Rv0=0;
          else {
            Ra.sl[6]=482; /* line # 482 */
            switch (((UB *)Rv2)[56]) {
              case 5:Ra.sl[6]=484; /* line # 484 */
              Rv0=P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],((UB *)Rv2)[94]!=8,0);
              break;
              case 7:Ra.sl[6]=487; /* line # 487 */
              if (P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1,0)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[9],((V *)Rv2)[9]);
              else {
                Ra.sl[6]=488; /* line # 488 */
                Rv0=0;
              }
              break;
              default:break;
            }
          }
          Ra.sl[6]=493; /* line # 493 */
          Rv1=((V *)Rv1)[3];
          Ra.sl[6]=494; /* line # 494 */
          Rv2=((V *)Rv2)[3];
        }
      }
      Ra.sl[6]=497; /* line # 497 */
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=499; /* line # 499 */
      Rv0=0;
    }
  }
  Ra.sl[6]=500; /* line # 500 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+695;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=518; /* line # 518 */
  if (F_ty!=NULL) {
    Ra.sl[6]=519; /* line # 519 */
    Rv0=F_ty;
    Ra.sl[6]=521; /* line # 521 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=522; /* line # 522 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=523; /* line # 523 */
    while (Rv1!=NULL){
      Ra.sl[6]=524; /* line # 524 */
      Rv3=Rv1;
      Ra.sl[6]=526; /* line # 526 */
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Ra.sl[6]=527; /* line # 527 */
      Rv5=Rv4;
      Ra.sl[6]=529; /* line # 529 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      Ra.sl[6]=530; /* line # 530 */
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+717,132,3);
      else {
        Ra.sl[6]=532; /* line # 532 */
        Rv6=((V *)Rv5)[7];
        Ra.sl[6]=533; /* line # 533 */
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[4])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[4];
      }
      Ra.sl[6]=534; /* line # 534 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[15];
      Ra.sl[6]=536; /* line # 536 */
      ((V *)Rv3)[10]=Rv4;
      Ra.sl[6]=537; /* line # 537 */
      ((UB *)Rv3)[64]=1;
      Ra.sl[6]=538; /* line # 538 */
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=539; /* line # 539 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      Ra.sl[6]=540; /* line # 540 */
      (*F_lghl)=Rv4;
      Ra.sl[6]=541; /* line # 541 */
      (*F_count)=(*F_count)+1;
      Ra.sl[6]=542; /* line # 542 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=543; /* line # 543 */
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+721;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=558; /* line # 558 */
  Rv0=((V *)F_ty)[4];
  Ra.sl[6]=559; /* line # 559 */
  while (Rv0!=NULL){
    Ra.sl[6]=560; /* line # 560 */
    Rv1=Rv0;
    Ra.sl[6]=562; /* line # 562 */
    ((UB *)Rv1)[64]=0;
    Ra.sl[6]=563; /* line # 563 */
    ((V *)Rv1)[10]=NULL;
    Ra.sl[6]=564; /* line # 564 */
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+744;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=581; /* line # 581 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=582; /* line # 582 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=584; /* line # 584 */
    Rv2=NULL;
    Ra.sl[6]=585; /* line # 585 */
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=586; /* line # 586 */
    Rv4=NULL;
    Ra.sl[6]=587; /* line # 587 */
    Rv5=NULL;
    Ra.sl[6]=588; /* line # 588 */
    Rv6=0;
    Ra.sl[6]=589; /* line # 589 */
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=596; /* line # 596 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      Ra.sl[6]=597; /* line # 597 */
      while (Rv4!=NULL){
        Ra.sl[6]=599; /* line # 599 */
        Rv5=Rv4;
        Ra.sl[6]=600; /* line # 600 */
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=601; /* line # 601 */
        Rv7=Rv5;
        Ra.sl[6]=603; /* line # 603 */
        Rv8=NULL;
        Ra.sl[6]=604; /* line # 604 */
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        Ra.sl[6]=605; /* line # 605 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=606; /* line # 606 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=607; /* line # 607 */
        Rv2=Rv8;
        Ra.sl[6]=609; /* line # 609 */
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=611; /* line # 611 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    Ra.sl[6]=614; /* line # 614 */
    if (Rv3<=0) {
      Ra.sl[6]=615; /* line # 615 */
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=616; /* line # 616 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    Ra.sl[6]=618; /* line # 618 */
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=621; /* line # 621 */
      if (Rv3<=0) Rv3=1;
      Ra.sl[6]=622; /* line # 622 */
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else {
        Ra.sl[6]=623; /* line # 623 */
        ((V *)Rv2)[0]=((V *)Rv0)[7];
      }
      Ra.sl[6]=624; /* line # 624 */
      Rv2=((V *)Rv0)[7];
      Ra.sl[6]=625; /* line # 625 */
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=626; /* line # 626 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Ra.sl[6]=628; /* line # 628 */
        Rv8=NULL;
        Ra.sl[6]=629; /* line # 629 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=630; /* line # 630 */
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=631; /* line # 631 */
        ((V *)Rv2)[0]=Rv8;
        Ra.sl[6]=632; /* line # 632 */
        Rv2=Rv8;
      }
      break;
      case 29:Ra.sl[6]=638; /* line # 638 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      Ra.sl[6]=639; /* line # 639 */
      if (Rv10==NULL) Rv11=0;
      else {
        Ra.sl[6]=640; /* line # 640 */
        Rv11=((UB *)Rv10)[1];
      }
      Ra.sl[6]=641; /* line # 641 */
      if (Rv3<=0) {
        Ra.sl[6]=642; /* line # 642 */
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=644; /* line # 644 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          Ra.sl[6]=645; /* line # 645 */
          if (Rv12!=NULL) {
            Ra.sl[6]=646; /* line # 646 */
            Rv13=Rv12;
            Ra.sl[6]=647; /* line # 647 */
            if (((UB *)Rv13)[40]==14) {
              Ra.sl[6]=648; /* line # 648 */
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=651; /* line # 651 */
      if (Rv3<=0) Rv3=Rv11;
      Ra.sl[6]=652; /* line # 652 */
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Ra.sl[6]=654; /* line # 654 */
        Rv8=NULL;
        Ra.sl[6]=655; /* line # 655 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=656; /* line # 656 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else {
          Ra.sl[6]=657; /* line # 657 */
          ((SL *)Rv8)[13]=32;
        }
        Ra.sl[6]=658; /* line # 658 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=659; /* line # 659 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=660; /* line # 660 */
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=665; /* line # 665 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    Ra.sl[6]=666; /* line # 666 */
    P_val_new(((V *)Rv0)+7,F_ty);
    Ra.sl[6]=667; /* line # 667 */
    Rv15=((V *)Rv0)[7];
    Ra.sl[6]=669; /* line # 669 */
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=670; /* line # 670 */
    ((SL *)Rv15)[6]=Rv3;
    Ra.sl[6]=671; /* line # 671 */
    ((SL *)Rv15)[2]=Rv6;
    Ra.sl[6]=674; /* line # 674 */
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=676; /* line # 676 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+761;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=690; /* line # 690 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=691; /* line # 691 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=693; /* line # 693 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=694; /* line # 694 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=695; /* line # 695 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Ra.sl[6]=696; /* line # 696 */
    Rv3=((V *)Rv0)[7];
    Ra.sl[6]=698; /* line # 698 */
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    Ra.sl[6]=699; /* line # 699 */
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=702; /* line # 702 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+782;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=714; /* line # 714 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[6];
  Ra.sl[6]=716; /* line # 716 */
  ((UW *)Rv0)[46]=((UW *)Rv0)[46]|8;
  Ra.sl[6]=718; /* line # 718 */
  P_lgt_new(&Rv2,((V *)Rv0)[4],14,NULL);
  Ra.sl[6]=719; /* line # 719 */
  Rv3=Rv2;
  Ra.sl[6]=721; /* line # 721 */
  ((V *)Rv3)[7]=((V *)Rv0)[8];
  Ra.sl[6]=722; /* line # 722 */
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=724; /* line # 724 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  Ra.sl[6]=727; /* line # 727 */
  if (((UB *)((V *)Rv0)[4])[92]==7||((UB *)((V *)Rv0)[4])[92]==16) {
    Ra.sl[6]=728; /* line # 728 */
    Rv2=P_lgt_new_code(3, Rv2);
  }
  else {
    Ra.sl[6]=730; /* line # 730 */
    Rv2=P_exp_genop(28, Rv2);
  }
  Ra.sl[6]=733; /* line # 733 */
  switch (((UB *)Rv1)[104]) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:Ra.sl[6]=736; /* line # 736 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else {
      Ra.sl[6]=737; /* line # 737 */
      ((V *)((V *)Rv1)[17])[0]=Rv2;
    }
    Ra.sl[6]=738; /* line # 738 */
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+800;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=758; /* line # 758 */
  Rv0=F_lgt;
  Ra.sl[6]=759; /* line # 759 */
  switch (((UB *)Rv0)[40]) {
    case 13:Ra.sl[6]=761; /* line # 761 */
    Rv1=((V *)Rv0)[6];
    Ra.sl[6]=762; /* line # 762 */
    if (((UB *)Rv1)[56]!=2) {
      Ra.sl[6]=764; /* line # 764 */
      P_src_error_s(Rd.s+819,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=770; /* line # 770 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[6]=771; /* line # 771 */
    while (Rv2!=NULL){
      Ra.sl[6]=773; /* line # 773 */
      P_type_check_parm(Rv2);
      Ra.sl[6]=774; /* line # 774 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=776; /* line # 776 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=784; /* line # 784 */
      P_src_error(Rd.s+819,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=790; /* line # 790 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+819,203,3);
    break;
    default:Ra.sl[6]=794; /* line # 794 */
    P_src_error(Rd.s+819,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000001(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+823;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=818; /* line # 818 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    Ra.sl[6]=821; /* line # 821 */
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    Ra.sl[6]=822; /* line # 822 */
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=824; /* line # 824 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        Ra.sl[6]=826; /* line # 826 */
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        Ra.sl[6]=827; /* line # 827 */
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+842;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=835; /* line # 835 */
  Rv0=0;
  Ra.sl[6]=836; /* line # 836 */
  Rv1=F_lgt;
  Ra.sl[6]=837; /* line # 837 */
  Rv2=F_ip;
  Ra.sl[6]=839; /* line # 839 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=840; /* line # 840 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Ra.sl[6]=843; /* line # 843 */
    Rv4=Rv3;
    Rv5=Rv1;
    Ra.sl[6]=844; /* line # 844 */
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[4],0,0)) {
      Ra.sl[6]=847; /* line # 847 */
      P_type_check_parm(Rv1);
      Ra.sl[6]=848; /* line # 848 */
      ((UB *)Rv4)[64]=2;
      Ra.sl[6]=849; /* line # 849 */
      ((V *)Rv4)[10]=Rv1;
    }
    else {
      Ra.sl[6]=852; /* line # 852 */
      P_src_error_s(Rd.s+859,201,3,((V *)Rv4)[0],NULL);
    }
    Ra.sl[6]=854; /* line # 854 */
    Rv1=((V *)Rv1)[0];
    Ra.sl[6]=855; /* line # 855 */
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=858; /* line # 858 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+859,998,3);
  Ra.sl[6]=860; /* line # 860 */
  if (((UB *)((V *)Rv2)[4])[92]==27) {
    Ra.sl[6]=862; /* line # 862 */
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[4])[9],NULL,NULL,0);
    Ra.sl[6]=864; /* line # 864 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else {
      Ra.sl[6]=865; /* line # 865 */
      P_src_error(Rd.s+859,222,3);
    }
  }
  else {
    Ra.sl[6]=869; /* line # 869 */
    P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv6);
    Ra.sl[6]=870; /* line # 870 */
    Rv7=Rv6;
    Ra.sl[6]=872; /* line # 872 */
    ((UB *)Rv7)[89]=1;
    Ra.sl[6]=873; /* line # 873 */
    ((V *)Rv7)[0]=((V *)Rv2)[4];
    Ra.sl[6]=874; /* line # 874 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[4])[4];
    Ra.sl[6]=875; /* line # 875 */
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[4])[11];
    Ra.sl[6]=876; /* line # 876 */
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[4])[10];
    Ra.sl[6]=877; /* line # 877 */
    memcpy(Rv7+48,((V *)Rv2)[4]+48,1);
    Ra.sl[6]=878; /* line # 878 */
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[4])[10];
    Ra.sl[6]=879; /* line # 879 */
    ((UB *)Rv7)[90]=((UB *)((V *)Rv2)[4])[90];
    Ra.sl[6]=881; /* line # 881 */
    V_sy_type_gfirst=((V *)Rv2)[10];
    Ra.sl[6]=882; /* line # 882 */
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=884; /* line # 884 */
    PAS_EXPSION_PRC_00000001(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[4])[9]
    );
    Ra.sl[6]=886; /* line # 886 */
    switch (((UB *)Rv7)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=889; /* line # 889 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      Ra.sl[6]=890; /* line # 890 */
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      Ra.sl[6]=891; /* line # 891 */
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      Ra.sl[6]=892; /* line # 892 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=897; /* line # 897 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[4])[12]);
      Ra.sl[6]=898; /* line # 898 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[4])[14]);
      Ra.sl[6]=899; /* line # 899 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[4])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=905; /* line # 905 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:Ra.sl[6]=908; /* line # 908 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=919; /* line # 919 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      Ra.sl[6]=920; /* line # 920 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[4])
      [13]);
      Ra.sl[6]=922; /* line # 922 */
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      Ra.sl[6]=923; /* line # 923 */
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=932; /* line # 932 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      Ra.sl[6]=933; /* line # 933 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      Ra.sl[6]=934; /* line # 934 */
      if (((V *)((V *)Rv7)[0])[14]!=NULL) {
        Ra.sl[6]=935; /* line # 935 */
        ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)Rv7)[0])[14]);
      }
      else {
        Ra.sl[6]=937; /* line # 937 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=942; /* line # 942 */
      P_src_error(Rd.s+859,998,3);
      break;
    }
  }
  Ra.sl[6]=948; /* line # 948 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=950; /* line # 950 */
  while (Rv3!=NULL){
    Ra.sl[6]=951; /* line # 951 */
    Rv8=Rv3;
    Ra.sl[6]=953; /* line # 953 */
    ((V *)Rv8)[10]=NULL;
    Ra.sl[6]=954; /* line # 954 */
    ((UB *)Rv8)[64]=0;
    Ra.sl[6]=955; /* line # 955 */
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=959; /* line # 959 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+863;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=993; /* line # 993 */
  Rv0=F_ty;
  Ra.sl[6]=994; /* line # 994 */
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=997; /* line # 997 */
    Rv1=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
    Ra.sl[6]=1000; /* line # 1000 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Ra.sl[6]=1001; /* line # 1001 */
    Rv2=P_lgt_new_code(3, Rv1);
    Ra.sl[6]=1004; /* line # 1004 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[6]=1005; /* line # 1005 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    Ra.sl[6]=1006; /* line # 1006 */
    (*F_lgl)=Rv2;
    Ra.sl[6]=1009; /* line # 1009 */
    Rv3=1;
    Ra.sl[6]=1010; /* line # 1010 */
    if (((V *)Rv0)[13]!=NULL) {
      Ra.sl[6]=1012; /* line # 1012 */
      Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
      Ra.sl[6]=1013; /* line # 1013 */
      if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
        Ra.sl[6]=1016; /* line # 1016 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
        Ra.sl[6]=1019; /* line # 1019 */
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Ra.sl[6]=1020; /* line # 1020 */
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[6]=1022; /* line # 1022 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else {
          Ra.sl[6]=1023; /* line # 1023 */
          ((V *)(*F_lgl))[0]=Rv2;
        }
        Ra.sl[6]=1024; /* line # 1024 */
        (*F_lgl)=Rv2;
        Ra.sl[6]=1025; /* line # 1025 */
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1028; /* line # 1028 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
    }
    Ra.sl[6]=1031; /* line # 1031 */
    if (Lx[2].ub[28]) {
      Ra.sl[6]=1033; /* line # 1033 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      Ra.sl[6]=1034; /* line # 1034 */
      ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
    }
    else {
      Ra.sl[6]=1036; /* line # 1036 */
      P_lgt_new_copy(F_trg, &Rv2);
    }
    Ra.sl[6]=1038; /* line # 1038 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=1041; /* line # 1041 */
    Rv6=Rv2;
    ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
    Ra.sl[6]=1042; /* line # 1042 */
    P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
    Ra.sl[6]=1043; /* line # 1043 */
    Rv7=((V *)Rv0)[14];
    Rv8=Rv2;
    Ra.sl[6]=1045; /* line # 1045 */
    ((V *)Rv8)[6]=F_ty;
    Ra.sl[6]=1046; /* line # 1046 */
    if (((UB *)Rv7)[92]!=10&&((UB *)Rv7)[92]!=23) {
      Ra.sl[6]=1047; /* line # 1047 */
      ((SL *)Rv8)[4]=((SL *)Rv8)[4]+((SL *)Rv7)[10];
    }
    Ra.sl[6]=1048; /* line # 1048 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=1057; /* line # 1057 */
    Rv9=((V *)Rv0)[15];
    Ra.sl[6]=1058; /* line # 1058 */
    if (((UB *)Rv9)[92]!=22) {
      Ra.sl[6]=1060; /* line # 1060 */
      if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
      else {
        Ra.sl[6]=1061; /* line # 1061 */
        Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
      }
      Ra.sl[6]=1062; /* line # 1062 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
    }
    else {
      Ra.sl[6]=1064; /* line # 1064 */
      Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
    }
    Ra.sl[6]=1066; /* line # 1066 */
    Rv12=Rv11;
    Ra.sl[6]=1067; /* line # 1067 */
    PAS_EXPSION_PRC_00000002(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
    Ra.sl[6]=1070; /* line # 1070 */
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[6]=1078; /* line # 1078 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    Ra.sl[6]=1079; /* line # 1079 */
    ((UB *)Rv5)[41]=5;
    Ra.sl[6]=1082; /* line # 1082 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[6]=1083; /* line # 1083 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    Ra.sl[6]=1084; /* line # 1084 */
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000005(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+877;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1108; /* line # 1108 */
  Rv0=NULL;
  Ra.sl[6]=1109; /* line # 1109 */
  Rv1=NULL;
  Ra.sl[6]=1110; /* line # 1110 */
  PAS_EXPSION_PRC_00000004(F_ty, Lx[1].v[4],&Rv0, &Rv1);
  Ra.sl[6]=1111; /* line # 1111 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1113; /* line # 1113 */
    if (Rv1!=Rv0) {
      Ra.sl[6]=1115; /* line # 1115 */
      P_lgt_new(&Rv0,NULL,0, Rv0);
      Ra.sl[6]=1116; /* line # 1116 */
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1119; /* line # 1119 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+890;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1125; /* line # 1125 */
  Rv0=F_ty;
  Ra.sl[6]=1127; /* line # 1127 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1129; /* line # 1129 */
  while (Rv1!=NULL){
    Ra.sl[6]=1130; /* line # 1130 */
    Rv2=Rv1;
    Ra.sl[6]=1132; /* line # 1132 */
    if (((V *)Rv2)[4]!=NULL) {
      Ra.sl[6]=1133; /* line # 1133 */
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1135; /* line # 1135 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Ra.sl[6]=1138; /* line # 1138 */
        if (Lx[2].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[4],2, P_lgt_link(Ra.v[4]));
        else {
          Ra.sl[6]=1139; /* line # 1139 */
          P_lgt_new_copy(Ra.v[4],&Rv4);
        }
        Ra.sl[6]=1140; /* line # 1140 */
        Rv5=Rv4;
        Ra.sl[6]=1142; /* line # 1142 */
        ((V *)Rv5)[4]=Rv1;
        Ra.sl[6]=1144; /* line # 1144 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[15];
        Ra.sl[6]=1147; /* line # 1147 */
        if (((UB *)Rv3)[92]!=10&&((UB *)Rv3)[92]!=23) {
          Ra.sl[6]=1148; /* line # 1148 */
          ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)((V *)Rv2)[4])[10];
        }
        Ra.sl[6]=1150; /* line # 1150 */
        PAS_EXPSION_PRC_00000002(((V *)Rv2)[4],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1152; /* line # 1152 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1153; /* line # 1153 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1157; /* line # 1157 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1160; /* line # 1160 */
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1162; /* line # 1162 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else {
      Ra.sl[6]=1163; /* line # 1163 */
      ((V *)(*F_lgl))[0]=Rv6;
    }
    Ra.sl[6]=1164; /* line # 1164 */
    (*F_lgl)=Rv6;
    Ra.sl[6]=1165; /* line # 1165 */
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1168; /* line # 1168 */
    P_lgt_new_copy(Rv7, &Rv4);
    Ra.sl[6]=1169; /* line # 1169 */
    ((V *)Rv6)[1]=Rv4;
    Ra.sl[6]=1170; /* line # 1170 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1173; /* line # 1173 */
    Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
    Ra.sl[6]=1174; /* line # 1174 */
    ((V *)Rv4)[0]=Rv6;
    Ra.sl[6]=1175; /* line # 1175 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1178; /* line # 1178 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1179; /* line # 1179 */
    ((V *)Rv6)[0]=Rv4;
    Ra.sl[6]=1180; /* line # 1180 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1181; /* line # 1181 */
    while (Rv7!=NULL){
      Ra.sl[6]=1183; /* line # 1183 */
      Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
      Ra.sl[6]=1184; /* line # 1184 */
      ((V *)Rv4)[0]=Rv6;
      Ra.sl[6]=1185; /* line # 1185 */
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+904;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1212; /* line # 1212 */
  Rv0=F_ty;
  Ra.sl[6]=1214; /* line # 1214 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1216; /* line # 1216 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1217; /* line # 1217 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=1218; /* line # 1218 */
    while (Rv1!=NULL&&Rv2!=NULL){
      Ra.sl[6]=1219; /* line # 1219 */
      Rv3=Rv1;
      Ra.sl[6]=1222; /* line # 1222 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[4],2, P_lgt_link(F_trg));
      else {
        Ra.sl[6]=1223; /* line # 1223 */
        P_lgt_new_copy(F_trg, &Rv4);
      }
      Ra.sl[6]=1226; /* line # 1226 */
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1228; /* line # 1228 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      Ra.sl[6]=1229; /* line # 1229 */
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
      Ra.sl[6]=1230; /* line # 1230 */
      if (((UB *)Rv6)[92]!=10&&((UB *)Rv6)[92]!=23) {
        Ra.sl[6]=1231; /* line # 1231 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]-((SL *)Rv6)[10];
      }
      Ra.sl[6]=1232; /* line # 1232 */
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[4],0);
      Ra.sl[6]=1233; /* line # 1233 */
      ((V *)Rv3)[10]=((V *)Rv5)[0];
      Ra.sl[6]=1235; /* line # 1235 */
      ((UB *)Rv3)[64]=1;
      Ra.sl[6]=1237; /* line # 1237 */
      P_lgt_new(&Rv4,((V *)Rv3)[4],6, Rv4);
      Ra.sl[6]=1238; /* line # 1238 */
      ((UB *)Rv4)[41]=3;
      Ra.sl[6]=1241; /* line # 1241 */
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else {
        Ra.sl[6]=1242; /* line # 1242 */
        ((V *)(*F_lgl))[0]=Rv4;
      }
      Ra.sl[6]=1243; /* line # 1243 */
      (*F_lgl)=Rv4;
      Ra.sl[6]=1244; /* line # 1244 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=1245; /* line # 1245 */
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1249; /* line # 1249 */
  if (((UB *)Rv0)[90]) {
    Ra.sl[6]=1250; /* line # 1250 */
    switch (((UB *)Rv0)[92]) {
      case 10:
      case 23:Ra.sl[6]=1252; /* line # 1252 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgh,F_lgl);
      break;
      case 8:
      case 9:Ra.sl[6]=1255; /* line # 1255 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
      break;
      default:Ra.sl[6]=1258; /* line # 1258 */
      P_src_error(Rd.s+918,131,3);
      break;
    }
  }
  Ra.sl[6]=1261; /* line # 1261 */
  Rv1=((V *)F_ty)[4];
  Ra.sl[6]=1262; /* line # 1262 */
  while (Rv1!=NULL){
    Ra.sl[6]=1263; /* line # 1263 */
    Rv7=Rv1;
    Ra.sl[6]=1265; /* line # 1265 */
    ((V *)Rv7)[10]=NULL;
    Ra.sl[6]=1266; /* line # 1266 */
    ((UB *)Rv7)[64]=0;
    Ra.sl[6]=1267; /* line # 1267 */
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+922;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1274; /* line # 1274 */
  if (((UB *)F_ty)[90]) {
    Ra.sl[6]=1276; /* line # 1276 */
    switch (((UB *)F_ty)[92]) {
      case 10:
      case 23:Ra.sl[6]=1278; /* line # 1278 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      case 8:
      case 9:Ra.sl[6]=1281; /* line # 1281 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      default:Ra.sl[6]=1284; /* line # 1284 */
      P_src_error(Rd.s+936,131,3);
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+940;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1314; /* line # 1314 */
  Rv0=F_ty;
  Ra.sl[6]=1316; /* line # 1316 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=1317; /* line # 1317 */
    Rv1=((V *)Rv0)[15];
    Ra.sl[6]=1318; /* line # 1318 */
    if (((UB *)Rv1)[92]!=22) {
      Ra.sl[6]=1319; /* line # 1319 */
      if (((UB *)Rv1)[112]) {
        Ra.sl[6]=1320; /* line # 1320 */
        Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      }
      else {
        Ra.sl[6]=1322; /* line # 1322 */
        Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1325; /* line # 1325 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      Ra.sl[6]=1326; /* line # 1326 */
      if (((UB *)Rv3)[40]==14) {
        Ra.sl[6]=1328; /* line # 1328 */
        Rv2=((SL *)((V *)Rv3)[7])[13];
        Ra.sl[6]=1329; /* line # 1329 */
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1331; /* line # 1331 */
        P_src_error(Rd.s+954,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1333; /* line # 1333 */
    Rv2=0;
  }
  Ra.sl[6]=1335; /* line # 1335 */
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1337; /* line # 1337 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    Ra.sl[6]=1338; /* line # 1338 */
    if (((UB *)Rv3)[40]==14) {
      Ra.sl[6]=1340; /* line # 1340 */
      Rv4=((SL *)((V *)Rv3)[7])[13];
      Ra.sl[6]=1341; /* line # 1341 */
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1343; /* line # 1343 */
      P_src_error(Rd.s+954,142,4);
    }
  }
  else {
    Ra.sl[6]=1345; /* line # 1345 */
    Rv4=((SL *)Rv0)[25];
  }
  Ra.sl[6]=1347; /* line # 1347 */
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1349; /* line # 1349 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Ra.sl[6]=1351; /* line # 1351 */
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=1353; /* line # 1353 */
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1354; /* line # 1354 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    Ra.sl[6]=1355; /* line # 1355 */
    if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv7;
    else {
      Ra.sl[6]=1356; /* line # 1356 */
      ((V *)Lx[3].v[1])[0]=Rv7;
    }
    Ra.sl[6]=1357; /* line # 1357 */
    Lx[3].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1359; /* line # 1359 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000007(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+958;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1378; /* line # 1378 */
  Rv0=F_ty;
  Ra.sl[6]=1380; /* line # 1380 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1382; /* line # 1382 */
  while (Rv1!=NULL){
    Ra.sl[6]=1383; /* line # 1383 */
    Rv2=Rv1;
    Ra.sl[6]=1385; /* line # 1385 */
    if (((V *)Rv2)[4]!=NULL) {
      Ra.sl[6]=1386; /* line # 1386 */
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1388; /* line # 1388 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Ra.sl[6]=1390; /* line # 1390 */
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[4],0);
        Ra.sl[6]=1391; /* line # 1391 */
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1394; /* line # 1394 */
        if (((SL *)Rv3)[11]>0) {
          Ra.sl[6]=1396; /* line # 1396 */
          Rv4=NULL;
          Ra.sl[6]=1397; /* line # 1397 */
          P_val_new(&Rv4, V_typ_std.v[0]);
          Ra.sl[6]=1398; /* line # 1398 */
          Rv6=Rv4;
          Ra.sl[6]=1400; /* line # 1400 */
          Rv5=((SL *)Rv3)[11];
          Ra.sl[6]=1401; /* line # 1401 */
          ((UB *)Rv6)[48]=28;
          Ra.sl[6]=1402; /* line # 1402 */
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          Ra.sl[6]=1403; /* line # 1403 */
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1406; /* line # 1406 */
          Rv5=0;
        }
      }
      Ra.sl[6]=1407; /* line # 1407 */
      if (Rv5>0) {
        Ra.sl[6]=1409; /* line # 1409 */
        (*F_iadr)=(*F_iadr)+Rv5;
        Ra.sl[6]=1410; /* line # 1410 */
        if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv4;
        else {
          Ra.sl[6]=1411; /* line # 1411 */
          ((V *)Lx[3].v[1])[0]=Rv4;
        }
        Ra.sl[6]=1412; /* line # 1412 */
        Lx[3].v[1]=Rv4;
      }
      Ra.sl[6]=1414; /* line # 1414 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1415; /* line # 1415 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1419; /* line # 1419 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1420; /* line # 1420 */
    Rv7=((V *)Rv0)[14];
    Ra.sl[6]=1422; /* line # 1422 */
    Rv8=((V *)Rv7)[1];
    Ra.sl[6]=1423; /* line # 1423 */
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1424; /* line # 1424 */
    Rv10=((V *)Rv9)[0];
    Ra.sl[6]=1425; /* line # 1425 */
    Rv11=Rv8;
    Ra.sl[6]=1427; /* line # 1427 */
    Rv12=((SL *)Rv11)[4];
    Ra.sl[6]=1428; /* line # 1428 */
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1429; /* line # 1429 */
      Rv13=((V *)Rv11)[7];
      Ra.sl[6]=1432; /* line # 1432 */
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Ra.sl[6]=1433; /* line # 1433 */
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1435; /* line # 1435 */
      Rv15=NULL;
    }
    Ra.sl[6]=1437; /* line # 1437 */
    if (((V *)Rv0)[4]!=NULL) {
      Ra.sl[6]=1439; /* line # 1439 */
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1440; /* line # 1440 */
      Rv17=Rv16;
      Ra.sl[6]=1441; /* line # 1441 */
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+972,142,3);
      else {
        Ra.sl[6]=1443; /* line # 1443 */
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else {
          Ra.sl[6]=1444; /* line # 1444 */
          Rv18=Rv12-1;
        }
      }
      Ra.sl[6]=1445; /* line # 1445 */
      P_lgt_free(&Rv16);
    }
    Ra.sl[6]=1448; /* line # 1448 */
    Rv19=((V *)Rv10)[0];
    Ra.sl[6]=1449; /* line # 1449 */
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1450; /* line # 1450 */
      Rv19=Rv9;
    }
    else {
      Ra.sl[6]=1453; /* line # 1453 */
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      Ra.sl[6]=1454; /* line # 1454 */
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1457; /* line # 1457 */
        while (Rv18>0&&Rv19!=NULL){
          Ra.sl[6]=1459; /* line # 1459 */
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        Ra.sl[6]=1461; /* line # 1461 */
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1464; /* line # 1464 */
    if (Rv19!=NULL) {
      Ra.sl[6]=1465; /* line # 1465 */
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000007(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+976;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1475; /* line # 1475 */
  Rv0=F_ty;
  Ra.sl[10]=1477; /* line # 1477 */
  Rv1=0;
  Ra.sl[10]=1478; /* line # 1478 */
  Ra.v[0]=NULL;
  Ra.sl[10]=1479; /* line # 1479 */
  Ra.v[1]=NULL;
  Ra.sl[10]=1480; /* line # 1480 */
  Rv2=NULL;
  Ra.sl[10]=1481; /* line # 1481 */
  Rv3=NULL;
  Ra.sl[10]=1482; /* line # 1482 */
  Rv4=((SL *)Rv0)[11];
  Ra.sl[10]=1483; /* line # 1483 */
  Rv5=0;
  Ra.sl[10]=1485; /* line # 1485 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1487; /* line # 1487 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1488; /* line # 1488 */
    Rv7=((V *)Rv0)[7];
    Ra.sl[10]=1489; /* line # 1489 */
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1490; /* line # 1490 */
      Rv8=Rv6;
      Ra.sl[10]=1492; /* line # 1492 */
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[4],0);
      Ra.sl[10]=1493; /* line # 1493 */
      ((SL *)Rv9)[4]=((SL *)Rv8)[15];
      Ra.sl[10]=1494; /* line # 1494 */
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1495; /* line # 1495 */
        ((V *)Rv3)[0]=Rv9;
      }
      Ra.sl[10]=1496; /* line # 1496 */
      Rv3=Rv9;
      Ra.sl[10]=1497; /* line # 1497 */
      Rv10=((V *)Rv9)[7];
      Ra.sl[10]=1498; /* line # 1498 */
      P_val_new(&Rv10,((V *)Rv8)[4]);
      Ra.sl[10]=1499; /* line # 1499 */
      ((V *)Rv10)[4]=((V *)Rv8)[4];
      Ra.sl[10]=1500; /* line # 1500 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1501; /* line # 1501 */
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else {
        Ra.sl[10]=1502; /* line # 1502 */
        ((V *)Ra.v[1])[0]=Rv10;
      }
      Ra.sl[10]=1503; /* line # 1503 */
      Ra.v[1]=Rv10;
      Ra.sl[10]=1505; /* line # 1505 */
      ((V *)Rv8)[10]=Rv9;
      Ra.sl[10]=1506; /* line # 1506 */
      ((UB *)Rv8)[64]=1;
      Ra.sl[10]=1507; /* line # 1507 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[10]=1508; /* line # 1508 */
      Rv6=((V *)Rv8)[3];
      Ra.sl[10]=1509; /* line # 1509 */
      if (((V *)Rv8)[4]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1510; /* line # 1510 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1515; /* line # 1515 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Ra.sl[10]=1517; /* line # 1517 */
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    Ra.sl[10]=1518; /* line # 1518 */
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1520; /* line # 1520 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      Ra.sl[10]=1521; /* line # 1521 */
      P_lgt_free(&Rv7);
    }
    else {
      Ra.sl[10]=1522; /* line # 1522 */
      P_src_error(Rd.s+993,147,4);
    }
  }
  Ra.sl[10]=1525; /* line # 1525 */
  if (F_szw>Rv4) Rv4=F_szw;
  Ra.sl[10]=1527; /* line # 1527 */
  if (((UB *)Rv0)[90]) {
    Ra.sl[10]=1528; /* line # 1528 */
    switch (((UB *)Rv0)[92]) {
      case 10:
      case 23:Ra.sl[10]=1530; /* line # 1530 */
      PAS_EXPSION_PRC_00000007(F_ty, &Rv1);
      break;
      case 8:
      case 9:Ra.sl[10]=1533; /* line # 1533 */
      PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
      break;
      default:Ra.sl[10]=1536; /* line # 1536 */
      P_src_error(Rd.s+993,131,3);
      break;
    }
  }
  Ra.sl[10]=1540; /* line # 1540 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1543; /* line # 1543 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1544; /* line # 1544 */
    while (Rv6!=NULL){
      Ra.sl[10]=1546; /* line # 1546 */
      ((UB *)Rv6)[64]=0;
      Ra.sl[10]=1547; /* line # 1547 */
      ((V *)Rv6)[10]=NULL;
      Ra.sl[10]=1548; /* line # 1548 */
      Rv6=((V *)Rv6)[3];
    }
  }
  Ra.sl[10]=1551; /* line # 1551 */
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1554; /* line # 1554 */
  if (Rv4>Rv1) {
    Ra.sl[10]=1556; /* line # 1556 */
    Rv10=NULL;
    Ra.sl[10]=1557; /* line # 1557 */
    P_val_new(&Rv10,NULL);
    Ra.sl[10]=1558; /* line # 1558 */
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1559; /* line # 1559 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.sl[10]=1560; /* line # 1560 */
    Ra.v[1]=Rv10;
    Ra.sl[10]=1561; /* line # 1561 */
    Rv11=Rv10;
    Ra.sl[10]=1563; /* line # 1563 */
    ((UB *)Rv11)[48]=28;
    Ra.sl[10]=1564; /* line # 1564 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    Ra.sl[10]=1565; /* line # 1565 */
    ((SL *)Rv11)[13]=0;
    Ra.sl[10]=1566; /* line # 1566 */
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1589; /* line # 1589 */
  Rv10=NULL;
  Ra.sl[10]=1590; /* line # 1590 */
  P_val_new(&Rv10, F_ty);
  Ra.sl[10]=1591; /* line # 1591 */
  Rv12=Rv10;
  Ra.sl[10]=1593; /* line # 1593 */
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1594; /* line # 1594 */
  ((SL *)Rv12)[6]=Rv4;
  Ra.sl[10]=1595; /* line # 1595 */
  ((V *)Rv12)[7]=Ra.v[0];
  Ra.sl[10]=1596; /* line # 1596 */
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1603; /* line # 1603 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+997;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1634; /* line # 1634 */
  Rv0=((V *)F_ip)[4];
  Ra.sl[6]=1636; /* line # 1636 */
  if (!((UB *)Rv0)[89]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Ra.sl[6]=1638; /* line # 1638 */
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[6];
  Ra.sl[6]=1640; /* line # 1640 */
  ((UW *)Rv1)[46]=((UW *)Rv1)[46]|16;
  Ra.sl[6]=1641; /* line # 1641 */
  if ((((UB *)Rv1)[94]==6||((UB *)Rv1)[94]==1)&&((SL *)Rv1)[10]>1) {
    Ra.sl[6]=1645; /* line # 1645 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else {
      Ra.sl[6]=1646; /* line # 1646 */
      Rv4=((V *)Rv2)[4];
    }
    Ra.sl[6]=1647; /* line # 1647 */
    Rv5=NULL;
    Ra.sl[6]=1648; /* line # 1648 */
    Rv6=NULL;
    Ra.sl[6]=1649; /* line # 1649 */
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1650; /* line # 1650 */
    Rv8=Rv4;
    Ra.sl[6]=1652; /* line # 1652 */
    while (Rv7!=NULL){
      Ra.sl[6]=1655; /* line # 1655 */
      P_lgt_new(&Rv9,((V *)Rv4)[4],13,NULL);
      Ra.sl[6]=1656; /* line # 1656 */
      Rv10=Rv9;
      Rv11=Rv8;
      Ra.sl[6]=1658; /* line # 1658 */
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      Ra.sl[6]=1659; /* line # 1659 */
      ((SL *)Rv10)[4]=((SL *)Rv11)[15];
      Ra.sl[6]=1660; /* line # 1660 */
      ((V *)Rv11)[10]=Rv9;
      Ra.sl[6]=1661; /* line # 1661 */
      ((UB *)Rv11)[64]=1;
      Ra.sl[6]=1664; /* line # 1664 */
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1666; /* line # 1666 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[6]=1667; /* line # 1667 */
      Rv8=((V *)Rv8)[3];
      Ra.sl[6]=1668; /* line # 1668 */
      Rv12=P_lgt_new_code(3, Rv9);
      Ra.sl[6]=1669; /* line # 1669 */
      if (Rv5==NULL) Rv5=Rv12;
      else {
        Ra.sl[6]=1670; /* line # 1670 */
        ((V *)Rv6)[0]=Rv12;
      }
      Ra.sl[6]=1671; /* line # 1671 */
      Rv6=Rv12;
    }
    Ra.sl[6]=1674; /* line # 1674 */
    if (((UB *)Rv2)[90]) {
      Ra.sl[6]=1676; /* line # 1676 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      Ra.sl[6]=1677; /* line # 1677 */
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      Ra.sl[6]=1678; /* line # 1678 */
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1681; /* line # 1681 */
    if (Rv5!=NULL) {
      Ra.sl[6]=1682; /* line # 1682 */
      switch (((UB *)Rv3)[104]) {
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:Ra.sl[6]=1685; /* line # 1685 */
        if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
        else {
          Ra.sl[6]=1686; /* line # 1686 */
          ((V *)((V *)Rv3)[17])[0]=Rv5;
        }
        Ra.sl[6]=1687; /* line # 1687 */
        ((V *)Rv3)[17]=Rv6;
        break;
        default:break;
      }
    }
    Ra.sl[6]=1691; /* line # 1691 */
    while (Rv4!=NULL){
      Ra.sl[6]=1692; /* line # 1692 */
      Rv13=Rv4;
      Ra.sl[6]=1694; /* line # 1694 */
      ((V *)Rv13)[10]=NULL;
      Ra.sl[6]=1695; /* line # 1695 */
      ((UB *)Rv13)[64]=0;
      Ra.sl[6]=1696; /* line # 1696 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1701; /* line # 1701 */
    if (((V *)Rv1)[8]==NULL) {
      Ra.sl[6]=1703; /* line # 1703 */
      ((UW *)Rv1)[46]=((UW *)Rv1)[46]|8;
      Ra.sl[6]=1704; /* line # 1704 */
      ((V *)Rv1)[8]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1011;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1723; /* line # 1723 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1724; /* line # 1724 */
    Rv0=F_p;
    Rv1=((V *)Rv0)[3]+8;
    Ra.sl[6]=1727; /* line # 1727 */
    if (((UB *)Rv1)[8]!=0) F_puna=P_exp_val_una(F_puna, V_oparg_cvtab.v[((UB *)Rv1)
    [8]]);
    Ra.sl[6]=1728; /* line # 1728 */
    Rv2=F_puna;
    Ra.sl[6]=1729; /* line # 1729 */
    if (((UB *)Rv2)[40]==14) {
      Ra.sl[6]=1730; /* line # 1730 */
      Rv3=((V *)Rv2)[7];
      Ra.sl[6]=1732; /* line # 1732 */
      ((UW *)Rv2)[10]=1;
      Ra.sl[6]=1733; /* line # 1733 */
      switch (((UB *)Rv0)[9]) {
        case 6:Ra.sl[6]=1734; /* line # 1734 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]<=0);
        break;
        case 43:Ra.sl[6]=1736; /* line # 1736 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]+1;
        break;
        case 44:Ra.sl[6]=1738; /* line # 1738 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]-1;
        break;
        case 45:Ra.sl[6]=1740; /* line # 1740 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]&1);
        break;
        case 10:Ra.sl[6]=1742; /* line # 1742 */
        if (((UB *)Rv3)[48]==11||((UB *)Rv3)[48]==17) {
          Ra.sl[6]=1743; /* line # 1743 */
          if (((SL *)Rv3)[13]>=0) {
            Ra.sl[6]=1744; /* line # 1744 */
            ((SL *)Rv3)[13]=-1-((SL *)Rv3)[13];
          }
          else {
            Ra.sl[6]=1745; /* line # 1745 */
            ((SL *)Rv3)[13]= -(1+((SL *)Rv3)[13]);
          }
        }
        break;
        case 46:Ra.sl[6]=1747; /* line # 1747 */
        ((SL *)Rv3)[13]= -((SL *)Rv3)[13];
        break;
        case 61:
        case 77:Ra.sl[6]=1749; /* line # 1749 */
        ((G *)Rv3)[7]=-((G *)Rv3)[7];
        break;
        case 47:Ra.sl[6]=1751; /* line # 1751 */
        ((SL *)Rv3)[13]=abs(((SL *)Rv3)[13]);
        break;
        case 62:
        case 78:Ra.sl[6]=1753; /* line # 1753 */
        ((G *)Rv3)[7]=fabs(((G *)Rv3)[7]);
        break;
        case 48:Ra.sl[6]=1755; /* line # 1755 */
        ((SL *)Rv3)[13]=PAS__I_SQR(((SL *)Rv3)[13]);
        break;
        case 63:
        case 79:Ra.sl[6]=1757; /* line # 1757 */
        ((G *)Rv3)[7]=PAS__G_SQR(((G *)Rv3)[7]);
        break;
        case 64:
        case 80:Ra.sl[6]=1760; /* line # 1760 */
        ((G *)Rv3)[7]=(double)((SL *)Rv3)[13];
        break;
        case 65:
        case 81:Ra.sl[6]=1762; /* line # 1762 */
        ((SL *)Rv3)[13]=PAS__G_ROUND(((G *)Rv3)[7]);
        break;
        case 66:
        case 82:Ra.sl[6]=1764; /* line # 1764 */
        ((SL *)Rv3)[13]=(int)(((G *)Rv3)[7]);
        break;
        case 92:
        case 110:Ra.sl[6]=1767; /* line # 1767 */
        if (((G *)Rv3)[7]<0.000000000000000E-001) P_src_error(Rd.s+1026,801,2);
        else {
          Ra.sl[6]=1768; /* line # 1768 */
          ((G *)Rv3)[7]=sqrt(((G *)Rv3)[7]);
        }
        break;
        case 93:
        case 111:Ra.sl[6]=1771; /* line # 1771 */
        ((G *)Rv3)[7]=sin(((G *)Rv3)[7]);
        break;
        case 94:
        case 112:Ra.sl[6]=1773; /* line # 1773 */
        ((G *)Rv3)[7]=cos(((G *)Rv3)[7]);
        break;
        case 95:
        case 113:Ra.sl[6]=1775; /* line # 1775 */
        ((G *)Rv3)[7]=tan(((G *)Rv3)[7]);
        break;
        case 96:
        case 114:Ra.sl[6]=1779; /* line # 1779 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,802,2);
        else {
          Ra.sl[6]=1780; /* line # 1780 */
          ((G *)Rv3)[7]=asin(((G *)Rv3)[7]);
        }
        break;
        case 97:
        case 115:Ra.sl[6]=1783; /* line # 1783 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,803,2);
        else {
          Ra.sl[6]=1784; /* line # 1784 */
          ((G *)Rv3)[7]=acos(((G *)Rv3)[7]);
        }
        break;
        case 98:
        case 116:Ra.sl[6]=1786; /* line # 1786 */
        ((G *)Rv3)[7]=atan(((G *)Rv3)[7]);
        break;
        case 102:
        case 120:Ra.sl[6]=1789; /* line # 1789 */
        ((G *)Rv3)[7]=PAS__SHG(((G *)Rv3)[7]);
        break;
        case 103:
        case 121:Ra.sl[6]=1791; /* line # 1791 */
        ((G *)Rv3)[7]=PAS__CHG(((G *)Rv3)[7]);
        break;
        case 104:
        case 122:Ra.sl[6]=1793; /* line # 1793 */
        ((G *)Rv3)[7]=PAS__THG(((G *)Rv3)[7]);
        break;
        case 105:
        case 123:Ra.sl[6]=1796; /* line # 1796 */
        ((G *)Rv3)[7]=PAS__ASHG(((G *)Rv3)[7]);
        break;
        case 106:
        case 124:Ra.sl[6]=1799; /* line # 1799 */
        if (((G *)Rv3)[7]<1.000000000000000E+000) P_src_error(Rd.s+1026,805,2);
        else {
          Ra.sl[6]=1800; /* line # 1800 */
          ((G *)Rv3)[7]=PAS__ACHG(((G *)Rv3)[7]);
        }
        break;
        case 107:
        case 125:Ra.sl[6]=1803; /* line # 1803 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+1026,806,2);
        else {
          Ra.sl[6]=1804; /* line # 1804 */
          ((G *)Rv3)[7]=PAS__ATHG(((G *)Rv3)[7]);
        }
        break;
        case 100:
        case 118:Ra.sl[6]=1807; /* line # 1807 */
        ((G *)Rv3)[7]=exp(((G *)Rv3)[7]);
        break;
        case 101:
        case 119:Ra.sl[6]=1810; /* line # 1810 */
        if (((G *)Rv3)[7]<=0.000000000000000E-001) P_src_error(Rd.s+1026,804,2);
        else {
          Ra.sl[6]=1811; /* line # 1811 */
          ((G *)Rv3)[7]=log(((G *)Rv3)[7]);
        }
        break;
        default:break;
      }
      Ra.sl[6]=1815; /* line # 1815 */
      ((V *)Rv2)[4]=NULL;
      Ra.sl[6]=1817; /* line # 1817 */
      if (64&((UW *)Rv1)[5]) ((V *)Rv2)[3]=((V *)Rv1)[0];
      else {
        Ra.sl[6]=1818; /* line # 1818 */
        ((V *)Rv2)[3]=((V *)Rv0)[2];
      }
      Ra.sl[6]=1819; /* line # 1819 */
      ((V *)Rv3)[4]=((V *)Rv2)[3];
      Ra.sl[6]=1820; /* line # 1820 */
      ((UB *)Rv3)[48]=((UB *)((V *)Rv2)[3])[92];
    }
    else {
      Ra.sl[6]=1824; /* line # 1824 */
      if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+1026,851,2);
      Ra.sl[6]=1825; /* line # 1825 */
      if (((UB *)Rv0)[9]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])
      [11]) {
        Ra.sl[6]=1828; /* line # 1828 */
        P_lgt_new(&Rv4,((V *)Rv0)[2],6, F_puna);
        Ra.sl[6]=1829; /* line # 1829 */
        Rv5=Rv4;
        Ra.sl[6]=1831; /* line # 1831 */
        if (64&((UW *)Rv1)[5]) ((V *)Rv5)[3]=((V *)Rv1)[0];
        Ra.sl[6]=1832; /* line # 1832 */
        ((V *)Rv5)[0]=((V *)F_puna)[0];
        Ra.sl[6]=1833; /* line # 1833 */
        ((UB *)Rv5)[41]=((UB *)Rv0)[9];
        Ra.sl[6]=1834; /* line # 1834 */
        ((UW *)Rv5)[10]=((UW *)F_puna)[10]&~2;
        Ra.sl[6]=1836; /* line # 1836 */
        ((V *)Rv2)[0]=NULL;
        Ra.sl[6]=1837; /* line # 1837 */
        F_puna=Rv4;
      }
      else {
        Ra.sl[6]=1839; /* line # 1839 */
        ((V *)F_puna)[3]=((V *)Rv0)[2];
      }
    }
  }
  Ra.sl[6]=1842; /* line # 1842 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  G Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  register V Rv12;
  UL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1030;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1864; /* line # 1864 */
  Rv0=((V *)F_ob1)[0];
  Ra.sl[6]=1865; /* line # 1865 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1866; /* line # 1866 */
    Rv1=F_p;
    Ra.sl[6]=1868; /* line # 1868 */
    Rv2=((V *)Rv1)[2];
    Ra.sl[6]=1870; /* line # 1870 */
    Rv3=((V *)Rv1)[3]+8;
    Ra.sl[6]=1871; /* line # 1871 */
    if (64&((UW *)Rv3)[5]) Rv2=((V *)Rv3)[0];
    else {
      Ra.sl[6]=1873; /* line # 1873 */
      if (((UB *)Rv3)[8]!=0) F_ob1=P_exp_val_una(F_ob1, V_oparg_cvtab.v[((UB *)Rv3)
      [8]]);
    }
    Ra.sl[6]=1874; /* line # 1874 */
    Rv4=((V *)Rv1)[3]+24;
    Ra.sl[6]=1875; /* line # 1875 */
    if (64&((UW *)Rv4)[5]) Rv2=((V *)Rv4)[0];
    else {
      Ra.sl[6]=1877; /* line # 1877 */
      if (((UB *)Rv4)[8]!=0) Rv0=P_exp_val_una(Rv0, V_oparg_cvtab.v[((UB *)Rv4)[
8]]);
    }
    Ra.sl[6]=1878; /* line # 1878 */
    ((V *)F_ob1)[0]=Rv0;
    Ra.sl[6]=1879; /* line # 1879 */
    if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
      Ra.sl[6]=1882; /* line # 1882 */
      Rv5=((V *)F_ob1)[7];
      Rv6=Rv0;
      Ra.sl[6]=1883; /* line # 1883 */
      switch (((UB *)Rv1)[9]) {
        case 89:Ra.sl[6]=1884; /* line # 1884 */
        ((SL *)Rv5)[13]=PAS__IIPOWER(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 90:
        case 108:Ra.sl[6]=1886; /* line # 1886 */
        ((G *)Rv5)[7]=pow  (((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        case 91:
        case 109:Ra.sl[6]=1888; /* line # 1888 */
        ((G *)Rv5)[7]=PAS__IGPOWER(((G *)Rv5)[7],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 49:Ra.sl[6]=1890; /* line # 1890 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]+((SL *)((V *)Rv6)[7])[13];
        break;
        case 50:Ra.sl[6]=1891; /* line # 1891 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        break;
        case 51:Ra.sl[6]=1892; /* line # 1892 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]*((SL *)((V *)Rv6)[7])[13];
        break;
        case 52:Ra.sl[6]=1893; /* line # 1893 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]/((SL *)((V *)Rv6)[7])[13];
        break;
        case 53:Ra.sl[6]=1894; /* line # 1894 */
        ((SL *)Rv5)[13]=PAS__I_MOD(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 54:Ra.sl[6]=1895; /* line # 1895 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]%((SL *)((V *)Rv6)[7])[13];
        break;
        case 67:
        case 85:Ra.sl[6]=1898; /* line # 1898 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]+((G *)((V *)Rv6)[7])[7];
        break;
        case 68:
        case 86:Ra.sl[6]=1900; /* line # 1900 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        break;
        case 69:
        case 87:Ra.sl[6]=1902; /* line # 1902 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]*((G *)((V *)Rv6)[7])[7];
        break;
        case 70:
        case 88:Ra.sl[6]=1904; /* line # 1904 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]/((G *)((V *)Rv6)[7])[7];
        break;
        case 7:Ra.sl[6]=1906; /* line # 1906 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0&&((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 8:Ra.sl[6]=1907; /* line # 1907 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0||((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 9:Ra.sl[6]=1908; /* line # 1908 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0!=((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 11:Ra.sl[6]=1911; /* line # 1911 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13];
        break;
        case 12:Ra.sl[6]=1912; /* line # 1912 */
        ((UL *)Rv5)[13]=(((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13])&~(((UL *)Rv5)
        [13]&((UL *)((V *)Rv6)[7])[13]);
        break;
        case 13:Ra.sl[6]=1914; /* line # 1914 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&~((UL *)((V *)Rv6)[7])[13];
        break;
        case 14:Ra.sl[6]=1915; /* line # 1915 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13];
        break;
        case 15:Ra.sl[6]=1916; /* line # 1916 */
        ((SL *)Rv5)[13]=(SL)((((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 16:break;
        case 17:break;
        case 18:break;
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:Ra.sl[6]=1925; /* line # 1925 */
        switch (((UB *)Rv1)[9]) {
          case 19:
          case 20:Ra.sl[6]=1927; /* line # 1927 */
          Rv7=(SL)PAS__SET_LE(((UL *)Rv5)[13],((UL *)((V *)Rv6)[7])[13]);
          break;
          case 21:
          case 22:Ra.sl[6]=1929; /* line # 1929 */
          Rv7=(SL)PAS__SET_LE(((UL *)((V *)Rv6)[7])[13],((UL *)Rv5)[13]);
          break;
          case 23:Ra.sl[6]=1930; /* line # 1930 */
          Rv7=(SL)(((UL *)Rv5)[13]!=((UL *)((V *)Rv6)[7])[13]);
          break;
          case 24:Ra.sl[6]=1931; /* line # 1931 */
          Rv7=(SL)(((UL *)Rv5)[13]==((UL *)((V *)Rv6)[7])[13]);
          break;
          default:break;
        }
        Ra.sl[6]=1934; /* line # 1934 */
        ((UB *)Rv5)[48]=1;
        Ra.sl[6]=1935; /* line # 1935 */
        ((SL *)Rv5)[6]=0;
        Ra.sl[6]=1936; /* line # 1936 */
        ((SL *)Rv5)[13]=Rv7;
        break;
        case 25:Ra.sl[6]=1939; /* line # 1939 */
        Rv7=(SL)((1<<((SL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:Ra.sl[6]=1944; /* line # 1944 */
        Rv7=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        Ra.sl[6]=1945; /* line # 1945 */
        switch (((UB *)Rv1)[9]) {
          case 28:
          case 32:Ra.sl[6]=1946; /* line # 1946 */
          ((SL *)Rv5)[13]=(SL)(Rv7<0);
          break;
          case 29:
          case 33:Ra.sl[6]=1947; /* line # 1947 */
          ((SL *)Rv5)[13]=(SL)(Rv7<=0);
          break;
          case 30:
          case 34:Ra.sl[6]=1948; /* line # 1948 */
          ((SL *)Rv5)[13]=(SL)(Rv7>=0);
          break;
          case 31:
          case 35:Ra.sl[6]=1949; /* line # 1949 */
          ((SL *)Rv5)[13]=(SL)(Rv7>0);
          break;
          case 27:Ra.sl[6]=1950; /* line # 1950 */
          ((SL *)Rv5)[13]=(SL)(Rv7!=0);
          break;
          case 26:Ra.sl[6]=1951; /* line # 1951 */
          ((SL *)Rv5)[13]=(SL)(Rv7==0);
          break;
        }
        break;
        case 55:
        case 56:
        case 57:
        case 58:
        case 59:
        case 60:
        case 71:
        case 72:
        case 73:
        case 74:
        case 75:
        case 76:Ra.sl[6]=1957; /* line # 1957 */
        Rv8=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        Ra.sl[6]=1958; /* line # 1958 */
        switch (((UB *)Rv1)[9]) {
          case 55:
          case 71:Ra.sl[6]=1959; /* line # 1959 */
          ((SL *)Rv5)[13]=(SL)(Rv8<0.000000000000000E-001);
          break;
          case 56:
          case 72:Ra.sl[6]=1960; /* line # 1960 */
          ((SL *)Rv5)[13]=(SL)(Rv8<=0.000000000000000E-001);
          break;
          case 57:
          case 73:Ra.sl[6]=1961; /* line # 1961 */
          ((SL *)Rv5)[13]=(SL)(Rv8>=0.000000000000000E-001);
          break;
          case 58:
          case 74:Ra.sl[6]=1962; /* line # 1962 */
          ((SL *)Rv5)[13]=(SL)(Rv8>0.000000000000000E-001);
          break;
          case 60:
          case 76:Ra.sl[6]=1963; /* line # 1963 */
          ((SL *)Rv5)[13]=(SL)(Rv8!=0.000000000000000E-001);
          break;
          case 59:
          case 75:Ra.sl[6]=1964; /* line # 1964 */
          ((SL *)Rv5)[13]=(SL)(Rv8==0.000000000000000E-001);
          break;
        }
        break;
        case 36:
        case 37:break;
        case 99:
        case 117:Ra.sl[6]=1974; /* line # 1974 */
        ((G *)Rv5)[7]=atan2(((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        default:break;
      }
      Ra.sl[6]=1978; /* line # 1978 */
      Rv9=F_ob1;
      Rv10=((V *)Rv9)[7];
      Ra.sl[6]=1980; /* line # 1980 */
      ((V *)Rv9)[4]=NULL;
      Ra.sl[6]=1982; /* line # 1982 */
      ((V *)Rv9)[3]=Rv2;
      Ra.sl[6]=1983; /* line # 1983 */
      ((V *)Rv10)[4]=((V *)Rv9)[3];
      Ra.sl[6]=1984; /* line # 1984 */
      ((UB *)Rv10)[48]=((UB *)((V *)Rv9)[3])[92];
      Ra.sl[6]=1986; /* line # 1986 */
      ((V *)F_ob1)[0]=NULL;
      Ra.sl[6]=1987; /* line # 1987 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=1991; /* line # 1991 */
      Rv11=1;
      Ra.sl[6]=1992; /* line # 1992 */
      switch (((UB *)Rv1)[9]) {
        case 25:Ra.sl[6]=1994; /* line # 1994 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=1996; /* line # 1996 */
          Rv12=F_ob1;
          Ra.sl[6]=1998; /* line # 1998 */
          Rv13=((SL *)((V *)Rv12)[7])[13];
          Ra.sl[6]=1999; /* line # 1999 */
          ((V *)Rv12)[3]=((V *)Rv0)[3];
          Ra.sl[6]=2000; /* line # 2000 */
          P_val_free(((V *)Rv12)+7);
          Ra.sl[6]=2001; /* line # 2001 */
          P_val_new(((V *)Rv12)+7,((V *)Rv12)[3]);
          Ra.sl[6]=2002; /* line # 2002 */
          Rv14=((V *)Rv12)[7];
          Ra.sl[6]=2004; /* line # 2004 */
          ((SL *)Rv14)[6]=(Rv13+7)/8;
          Ra.sl[6]=2005; /* line # 2005 */
          ((UL *)Rv14)[13]=1<<Rv13;
          Ra.sl[6]=2008; /* line # 2008 */
          P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
          Ra.sl[6]=2009; /* line # 2009 */
          Rv15=Rv0;
          Ra.sl[6]=2011; /* line # 2011 */
          ((UW *)Rv15)[10]=1;
          Ra.sl[6]=2012; /* line # 2012 */
          ((UB *)Rv15)[41]=15;
          Ra.sl[6]=2014; /* line # 2014 */
          Rv11=0;
        }
        break;
        case 7:Ra.sl[6]=2018; /* line # 2018 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2019; /* line # 2019 */
          Rv16=F_ob1;
          Ra.sl[6]=2021; /* line # 2021 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2022; /* line # 2022 */
          Rv11=0;
          Ra.sl[6]=2023; /* line # 2023 */
          if (((SL *)((V *)Rv16)[7])[13]<=0) {
            Ra.sl[6]=2025; /* line # 2025 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2026; /* line # 2026 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2029; /* line # 2029 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2032; /* line # 2032 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2033; /* line # 2033 */
            Rv17=Rv0;
            Ra.sl[6]=2035; /* line # 2035 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2036; /* line # 2036 */
            Rv11=0;
            Ra.sl[6]=2037; /* line # 2037 */
            if (((SL *)((V *)Rv17)[7])[13]<=0) {
              Ra.sl[6]=2038; /* line # 2038 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2041; /* line # 2041 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2042; /* line # 2042 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 8:Ra.sl[6]=2047; /* line # 2047 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2048; /* line # 2048 */
          Rv18=F_ob1;
          Ra.sl[6]=2050; /* line # 2050 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2051; /* line # 2051 */
          Rv11=0;
          Ra.sl[6]=2052; /* line # 2052 */
          if (((SL *)((V *)Rv18)[7])[13]>0) {
            Ra.sl[6]=2054; /* line # 2054 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2055; /* line # 2055 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2058; /* line # 2058 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2061; /* line # 2061 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2062; /* line # 2062 */
            Rv19=Rv0;
            Ra.sl[6]=2064; /* line # 2064 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2065; /* line # 2065 */
            Rv11=0;
            Ra.sl[6]=2066; /* line # 2066 */
            if (((SL *)((V *)Rv19)[7])[13]>0) {
              Ra.sl[6]=2067; /* line # 2067 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2070; /* line # 2070 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2071; /* line # 2071 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 1:
        case 3:
        case 4:
        case 5:Ra.sl[6]=2077; /* line # 2077 */
        Rv20=F_ob1;
        Ra.sl[6]=2079; /* line # 2079 */
        ((UW *)Rv20)[10]=((UW *)Rv20)[10]|8;
        Ra.sl[6]=2080; /* line # 2080 */
        if (!(2&((UW *)Rv20)[10])) P_src_error(Rd.s+1045,852,2);
        Ra.sl[6]=2082; /* line # 2082 */
        Rv21=Rv0;
        Ra.sl[6]=2084; /* line # 2084 */
        if (!(1&((UW *)Rv21)[10])) {
          Ra.sl[6]=2085; /* line # 2085 */
          P_src_error(Rd.s+1045,851,1);
        }
        Ra.sl[6]=2086; /* line # 2086 */
        if ((((UB *)Rv1)[9]!=1&&((UB *)Rv21)[40]==8)&&((V *)Rv21)[3]!=NULL) {
          Ra.sl[6]=2089; /* line # 2089 */
          Rv22=((V *)Rv21)[6];
          Ra.sl[6]=2090; /* line # 2090 */
          if (((V *)Rv22)[8]!=NULL) {
            Ra.sl[6]=2091; /* line # 2091 */
            if (((UB *)((V *)Rv22)[8])[94]==6) {
              Ra.sl[6]=2093; /* line # 2093 */
              ((V *)F_ob1)[0]=((V *)((V *)Rv21)[1])[0];
              Ra.sl[6]=2094; /* line # 2094 */
              P_lgt_free(((V *)Rv21)+1);
              Ra.sl[6]=2095; /* line # 2095 */
              ((UW *)Rv21)[10]=((UW *)Rv21)[10]|128;
              Ra.sl[6]=2096; /* line # 2096 */
              ((V *)Rv21)[1]=F_ob1;
              Ra.sl[6]=2097; /* line # 2097 */
              Rv11=0;
            }
          }
        }
        break;
        default:Ra.sl[6]=2102; /* line # 2102 */
        if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) {
          Ra.sl[6]=2103; /* line # 2103 */
          P_src_error(Rd.s+1045,851,1);
        }
        break;
      }
      Ra.sl[6]=2105; /* line # 2105 */
      if (Rv11) {
        Ra.sl[6]=2107; /* line # 2107 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Ra.sl[6]=2108; /* line # 2108 */
        Rv23=Rv0;
        Ra.sl[6]=2110; /* line # 2110 */
        ((V *)Rv23)[3]=Rv2;
        Ra.sl[6]=2111; /* line # 2111 */
        ((UW *)Rv23)[10]=1;
        Ra.sl[6]=2112; /* line # 2112 */
        ((UB *)Rv23)[41]=((UB *)Rv1)[9];
      }
      Ra.sl[6]=2115; /* line # 2115 */
      F_ob1=Rv0;
    }
  }
  Ra.sl[6]=2118; /* line # 2118 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1049;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2133; /* line # 2133 */
  Rv0=F_lgt;
  Ra.sl[6]=2134; /* line # 2134 */
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Ra.sl[6]=2135; /* line # 2135 */
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=2137; /* line # 2137 */
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2138; /* line # 2138 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) {
      Ra.sl[6]=2141; /* line # 2141 */
      Rv0=((V *)Rv1)[1];
    }
    else {
      Ra.sl[6]=2142; /* line # 2142 */
      Rv0=NULL;
    }
  }
  Ra.sl[6]=2144; /* line # 2144 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2150; /* line # 2150 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1070;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2172; /* line # 2172 */
  Rv0=0;
  Ra.sl[6]=2173; /* line # 2173 */
  Rv1=NULL;
  Ra.sl[6]=2174; /* line # 2174 */
  if ((*F_lgt)!=NULL) {
    Ra.sl[6]=2175; /* line # 2175 */
    Rv2=(*F_lgt);
    Ra.sl[6]=2177; /* line # 2177 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Ra.sl[6]=2178; /* line # 2178 */
    Rv3=((V *)Rv2)[1];
    Ra.sl[6]=2179; /* line # 2179 */
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2182; /* line # 2182 */
  if (Rv1!=NULL) {
    Ra.sl[6]=2183; /* line # 2183 */
    Rv4=Rv1;
    Ra.sl[6]=2185; /* line # 2185 */
    Rv5=NULL;
    Ra.sl[6]=2186; /* line # 2186 */
    Rv6=NULL;
    Ra.sl[6]=2187; /* line # 2187 */
    Rv7=((V *)Rv4)[8];
    Ra.sl[6]=2188; /* line # 2188 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2189; /* line # 2189 */
      Rv8=((V *)Rv4)[11];
      Ra.sl[6]=2190; /* line # 2190 */
      if (!((UB *)Rv8)[91]) {
        Ra.sl[6]=2198; /* line # 2198 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        Ra.sl[6]=2199; /* line # 2199 */
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        Ra.sl[6]=2200; /* line # 2200 */
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        Ra.sl[6]=2201; /* line # 2201 */
        ((V *)(*F_lgt))[1]=Rv5;
        Ra.sl[6]=2202; /* line # 2202 */
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2205; /* line # 2205 */
    while (Rv7!=NULL){
      Ra.sl[6]=2207; /* line # 2207 */
      Rv9=NULL;
      Ra.sl[6]=2208; /* line # 2208 */
      Rv10=0;
      Ra.sl[6]=2209; /* line # 2209 */
      Rv11=0;
      Ra.sl[6]=2210; /* line # 2210 */
      Rv12=Rv3;
      Ra.sl[6]=2211; /* line # 2211 */
      Rv13=Rv7;
      Ra.sl[6]=2213; /* line # 2213 */
      if (Rv3!=NULL) {
        Ra.sl[6]=2215; /* line # 2215 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          Ra.sl[6]=2218; /* line # 2218 */
          if (((V *)Rv13)[4]!=NULL) {
            Ra.sl[6]=2220; /* line # 2220 */
            Rv14=((V *)Rv13)[4];
            Ra.sl[6]=2221; /* line # 2221 */
            switch (((UB *)Rv14)[92]) {
              case 10:Ra.sl[6]=2223; /* line # 2223 */
              if (P_comp_type(((V *)Rv13)[4],V_typ_std.v[10],0,0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1,0)) {
                Ra.sl[6]=2225; /* line # 2225 */
                if (((UB *)Rv3)[40]==14) {
                  Ra.sl[6]=2227; /* line # 2227 */
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  Ra.sl[6]=2228; /* line # 2228 */
                  P_val_free(((V *)Rv3)+7);
                  Ra.sl[6]=2229; /* line # 2229 */
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2230; /* line # 2230 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Ra.sl[6]=2231; /* line # 2231 */
                  Rv16=((V *)Rv3)[7];
                  Ra.sl[6]=2233; /* line # 2233 */
                  ((UB *)Rv16)[48]=29;
                  Ra.sl[6]=2234; /* line # 2234 */
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2235; /* line # 2235 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  Ra.sl[6]=2236; /* line # 2236 */
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2241; /* line # 2241 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Ra.sl[6]=2242; /* line # 2242 */
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  Ra.sl[6]=2243; /* line # 2243 */
                  ((V *)Rv3)[0]=Rv17;
                  Ra.sl[6]=2244; /* line # 2244 */
                  ((UW *)Rv3)[10]=5;
                  Ra.sl[6]=2245; /* line # 2245 */
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2246; /* line # 2246 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2252; /* line # 2252 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0,0)) {
                Ra.sl[6]=2255; /* line # 2255 */
                Rv10=1;
                Ra.sl[6]=2256; /* line # 2256 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2257; /* line # 2257 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[4],3, Rv3);
                Ra.sl[6]=2258; /* line # 2258 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2259; /* line # 2259 */
                  ((V *)Rv5)[0]=Rv3;
                }
                Ra.sl[6]=2260; /* line # 2260 */
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
                Ra.sl[6]=2261; /* line # 2261 */
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2264; /* line # 2264 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0,0)) {
                  Ra.sl[6]=2265; /* line # 2265 */
                  Rv10=1;
                  Rv11=1;
                }
              }
              Ra.sl[6]=2266; /* line # 2266 */
              if (((UB *)Rv14)[92]==9) Rv9=((V *)Rv13)[4];
              break;
              default:break;
            }
            Ra.sl[6]=2281; /* line # 2281 */
            if (64&((UW *)Rv13)[48]&&Rv6==NULL) Rv6=((V *)Rv3)[3];
            Ra.sl[6]=2284; /* line # 2284 */
            switch (((UB *)Rv13)[94]) {
              case 7:Ra.sl[6]=2287; /* line # 2287 */
              if (!(4&((UW *)Rv3)[10])) {
                Ra.sl[6]=2289; /* line # 2289 */
                Rv18=Rv3;
                Ra.sl[6]=2290; /* line # 2290 */
                if (64&((UW *)Rv13)[46]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Ra.sl[6]=2291; /* line # 2291 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2292; /* line # 2292 */
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                Ra.sl[6]=2293; /* line # 2293 */
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[6]=2295; /* line # 2295 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2296; /* line # 2296 */
                  ((V *)Rv5)[0]=Rv3;
                }
              }
              break;
              case 10:Ra.sl[6]=2302; /* line # 2302 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              Ra.sl[6]=2303; /* line # 2303 */
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              Ra.sl[6]=2304; /* line # 2304 */
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              Ra.sl[6]=2305; /* line # 2305 */
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2307; /* line # 2307 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else {
                Ra.sl[6]=2308; /* line # 2308 */
                ((V *)Rv5)[0]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=2313; /* line # 2313 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2319; /* line # 2319 */
        P_lgt_new(&Rv3,((V *)Rv13)[4],14,NULL);
        Ra.sl[6]=2321; /* line # 2321 */
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else {
          Ra.sl[6]=2322; /* line # 2322 */
          ((V *)Rv5)[0]=Rv3;
        }
        Ra.sl[6]=2323; /* line # 2323 */
        Rv0=1;
      }
      Ra.sl[6]=2326; /* line # 2326 */
      if (Rv0) {
        Ra.sl[6]=2327; /* line # 2327 */
        if (8192&((UW *)Rv13)[46]) {
          Ra.sl[6]=2328; /* line # 2328 */
          Rv19=Rv3;
          Ra.sl[6]=2330; /* line # 2330 */
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2331; /* line # 2331 */
          ((V *)Rv19)[3]=((V *)Rv13)[4];
          Ra.sl[6]=2332; /* line # 2332 */
          ((V *)Rv19)[4]=NULL;
        }
        else {
          Ra.sl[6]=2335; /* line # 2335 */
          if (((V *)Rv13)[8]!=NULL) {
            Ra.sl[6]=2336; /* line # 2336 */
            Rv20=Rv3;
            Ra.sl[6]=2338; /* line # 2338 */
            ((UB *)Rv20)[40]=14;
            Ra.sl[6]=2339; /* line # 2339 */
            ((V *)Rv20)[3]=((V *)Rv13)[4];
            Ra.sl[6]=2340; /* line # 2340 */
            ((V *)Rv20)[7]=((V *)Rv13)[8];
            Ra.sl[6]=2341; /* line # 2341 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[4]);
            Ra.sl[6]=2342; /* line # 2342 */
            ((V *)Rv20)[4]=NULL;
          }
          else {
            Ra.sl[6]=2344; /* line # 2344 */
            P_src_error_s(Rd.s+1086,854,2,((V *)Rv13)[0],NULL);
          }
        }
      }
      Ra.sl[6]=2346; /* line # 2346 */
      Rv5=Rv3;
      Ra.sl[6]=2349; /* line # 2349 */
      if (Rv9!=NULL) {
        Ra.sl[6]=2350; /* line # 2350 */
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2351; /* line # 2351 */
          Rv21=((V *)Rv9)[15];
          Ra.sl[6]=2352; /* line # 2352 */
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Ra.sl[6]=2354; /* line # 2354 */
            Rv22=Rv12;
            Ra.sl[6]=2355; /* line # 2355 */
            if (((UB *)Rv22)[40]==8) ((UW *)Rv22)[10]=((UW *)Rv22)[10]|128;
            Ra.sl[6]=2357; /* line # 2357 */
            Rv23=((V *)Rv9)[15];
            Ra.sl[6]=2358; /* line # 2358 */
            Rv24=NULL;
            Rv25=NULL;
            Ra.sl[6]=2360; /* line # 2360 */
            if (Rv10) {
              while (1){
                Ra.sl[6]=2364; /* line # 2364 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
              }
              Ra.sl[6]=2367; /* line # 2367 */
              if (Rv11) {
                Ra.sl[6]=2369; /* line # 2369 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Ra.sl[6]=2370; /* line # 2370 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2371; /* line # 2371 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2373; /* line # 2373 */
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[6]=2374; /* line # 2374 */
                  Rv7=((V *)Rv7)[3];
                }
                else {
                  Ra.sl[6]=2376; /* line # 2376 */
                  Rv25=Rv24;
                }
              }
              else {
                Ra.sl[6]=2380; /* line # 2380 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2382; /* line # 2382 */
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Ra.sl[6]=2383; /* line # 2383 */
                  Rv25=Rv24;
                  Ra.sl[6]=2384; /* line # 2384 */
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2386; /* line # 2386 */
                if (((UB *)Rv12)[40]==14) {
                  Ra.sl[6]=2387; /* line # 2387 */
                  Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)Rv12)[7])[6]);
                }
                else {
                  Ra.sl[6]=2390; /* line # 2390 */
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[4],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2392; /* line # 2392 */
                  if (!(64&((UW *)Rv7)[46])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[15];
                  Ra.sl[6]=2394; /* line # 2394 */
                  if (((V *)Rv17)[3]!=Rv23) {
                    Ra.sl[6]=2396; /* line # 2396 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2397; /* line # 2397 */
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                Ra.sl[6]=2400; /* line # 2400 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2401; /* line # 2401 */
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[6]=2402; /* line # 2402 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Ra.sl[6]=2403; /* line # 2403 */
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[6]=2408; /* line # 2408 */
              Rv26=((V *)Rv3)[3];
              Ra.sl[6]=2409; /* line # 2409 */
              if (Rv26!=NULL) {
                Ra.sl[6]=2410; /* line # 2410 */
                while (Rv9!=NULL&&Rv26!=NULL){
                  Ra.sl[6]=2411; /* line # 2411 */
                  if (((UB *)Rv9)[92]==9&&(((UB *)Rv26)[92]==9||((UB *)Rv26)[92]
                  ==8)) {
                    Ra.sl[6]=2415; /* line # 2415 */
                    Rv27=((V *)Rv26)[15];
                    Ra.sl[6]=2416; /* line # 2416 */
                    Rv23=((V *)Rv9)[15];
                    while (1){
                      Ra.sl[6]=2419; /* line # 2419 */
                      if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                      if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
                    }
                    Ra.sl[6]=2422; /* line # 2422 */
                    if (((UB *)Rv27)[92]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                    else {
                      Ra.sl[6]=2423; /* line # 2423 */
                      Rv28=Rv12;
                    }
                    Ra.sl[6]=2427; /* line # 2427 */
                    if (((UB *)((V *)Rv21)[13])[40]!=14) {
                      Ra.sl[6]=2429; /* line # 2429 */
                      if (((UB *)Rv27)[92]==22) {
                        Ra.sl[6]=2431; /* line # 2431 */
                        Rv17=P_lgt_type_eval(((V *)Rv27)[13],Rv28,NULL,0);
                        Ra.sl[6]=2432; /* line # 2432 */
                        if (((SL *)Rv27)[11]!=((SL *)Rv23)[11]) {
                          Ra.sl[6]=2434; /* line # 2434 */
                          Rv17=P_lgt_new_code(0, Rv17);
                          Ra.sl[6]=2435; /* line # 2435 */
                          ((V *)Rv17)[3]=Rv23;
                        }
                      }
                      else {
                        Ra.sl[6]=2438; /* line # 2438 */
                        Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[29]);
                      }
                      Ra.sl[6]=2439; /* line # 2439 */
                      if (Rv25==NULL) Rv24=Rv17;
                      else {
                        Ra.sl[6]=2440; /* line # 2440 */
                        ((V *)Rv25)[0]=Rv17;
                      }
                      Ra.sl[6]=2441; /* line # 2441 */
                      Rv25=Rv17;
                      Ra.sl[6]=2442; /* line # 2442 */
                      Rv7=((V *)Rv7)[3];
                    }
                    Ra.sl[6]=2445; /* line # 2445 */
                    if (((UB *)Rv27)[92]==22) {
                      Ra.sl[6]=2447; /* line # 2447 */
                      Rv17=P_lgt_type_eval(((V *)Rv27)[14],Rv28,NULL,0);
                      Ra.sl[6]=2448; /* line # 2448 */
                      if (Rv27!=Rv23) {
                        Ra.sl[6]=2450; /* line # 2450 */
                        Rv17=P_lgt_new_code(0, Rv17);
                        Ra.sl[6]=2451; /* line # 2451 */
                        ((V *)Rv17)[3]=Rv23;
                      }
                    }
                    else {
                      Ra.sl[6]=2454; /* line # 2454 */
                      Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[30]);
                    }
                    Ra.sl[6]=2455; /* line # 2455 */
                    if (Rv25==NULL) Rv24=Rv17;
                    else {
                      Ra.sl[6]=2456; /* line # 2456 */
                      ((V *)Rv25)[0]=Rv17;
                    }
                    Ra.sl[6]=2457; /* line # 2457 */
                    Rv25=Rv17;
                    Ra.sl[6]=2458; /* line # 2458 */
                    Rv7=((V *)Rv7)[3];
                    Ra.sl[6]=2459; /* line # 2459 */
                    Rv26=((V *)Rv26)[14];
                    Ra.sl[6]=2460; /* line # 2460 */
                    Rv9=((V *)Rv9)[14];
                  }
                  else {
                    Ra.sl[6]=2461; /* line # 2461 */
                    Rv9=NULL;
                  }
                }
              }
              Ra.sl[6]=2463; /* line # 2463 */
              Rv29=Rv3;
              Ra.sl[6]=2464; /* line # 2464 */
              if (((SL *)((V *)Rv29)[3])[10]>0) {
                Ra.sl[6]=2465; /* line # 2465 */
                ((SL *)Rv29)[4]=((SL *)Rv29)[4]+((SL *)((V *)Rv29)[3])[10];
              }
            }
            Ra.sl[6]=2469; /* line # 2469 */
            if (Rv24!=NULL) {
              Ra.sl[6]=2471; /* line # 2471 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              Ra.sl[6]=2472; /* line # 2472 */
              ((V *)Rv3)[0]=Rv24;
              Ra.sl[6]=2473; /* line # 2473 */
              Rv3=Rv25;
            }
            Ra.sl[6]=2475; /* line # 2475 */
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2478; /* line # 2478 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Ra.sl[6]=2479; /* line # 2479 */
      Rv7=((V *)Rv7)[3];
    }
    Ra.sl[6]=2482; /* line # 2482 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2483; /* line # 2483 */
      Rv30=(*F_lgt);
      Ra.sl[6]=2485; /* line # 2485 */
      if (Rv6!=NULL) {
        Ra.sl[6]=2487; /* line # 2487 */
        ((V *)Rv30)[3]=Rv6;
        Ra.sl[6]=2488; /* line # 2488 */
        if (!((UB *)Rv6)[91]&&((V *)Rv30)[1]!=NULL) {
          Ra.sl[6]=2489; /* line # 2489 */
          ((V *)((V *)Rv30)[1])[3]=Rv6;
        }
      }
      Ra.sl[6]=2493; /* line # 2493 */
      if (!((UB *)((V *)Rv4)[11])[91]) {
        Ra.sl[6]=2494; /* line # 2494 */
        P_tmpstk_allocate(((V *)Rv30)[1],((V *)((V *)Rv30)[1])[3]);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  register V Rv14;
  register V Rv15;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1090;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2633; /* line # 2633 */
  Rv0=0;
  Ra.sl[6]=2634; /* line # 2634 */
  while (!Rv0&&(*F_pg)!=NULL){
    Ra.sl[6]=2636; /* line # 2636 */
    Rv1=F_parm_lst;
    Ra.sl[6]=2637; /* line # 2637 */
    Rv2=(*F_pg);
    Ra.sl[6]=2638; /* line # 2638 */
    if (((UB *)Rv2)[8]&&F_npa<=2) {
      Ra.sl[6]=2640; /* line # 2640 */
      Rv3=Rv1;
      Ra.sl[6]=2641; /* line # 2641 */
      switch (F_npa) {
        case 0:Ra.sl[6]=2642; /* line # 2642 */
        Rv0=((V *)Rv2)[3]==NULL;
        break;
        case 1:Ra.sl[6]=2644; /* line # 2644 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[6]=2645; /* line # 2645 */
          if (((SL *)((V *)Rv2)[3])[0]==1) {
            Ra.sl[6]=2646; /* line # 2646 */
            Rv4=((V *)Rv2)[3]+8;
            Ra.sl[6]=2647; /* line # 2647 */
            if ((1&((UW *)Rv4)[5])<=(2&((UW *)Rv3)[10])) {
              Ra.sl[6]=2648; /* line # 2648 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv4)[0],(8&((UW *)Rv4)[5])!=0,0);
            }
          }
        }
        break;
        case 2:Ra.sl[6]=2650; /* line # 2650 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[6]=2651; /* line # 2651 */
          if ((((SL *)((V *)Rv2)[3])[0]==2&&((SL *)((V *)Rv3)[3])[11]>0)&&((SL *)(
          (V *)((V *)Rv3)[0])[3])[11]>0) {
            Ra.sl[6]=2652; /* line # 2652 */
            Rv5=((V *)Rv2)[3]+8;
            Ra.sl[6]=2654; /* line # 2654 */
            memcpy(Ra.s+32,((V *)Rv2)[3]+24,12);
            Ra.sl[6]=2655; /* line # 2655 */
            if (((1&((UW *)Rv5)[5])<=(2&((UW *)Rv3)[10])&&(1&Ra.uw[21])<=(2&((UW
             *)((V *)Rv3)[0])[10]))&&((SL *)((V *)Rv3)[3])[10]==0) {
              Ra.sl[6]=2658; /* line # 2658 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv5)[0],(8&((UW *)Rv5)[5])!=0,0)&&
              P_comp_type(((V *)((V *)Rv3)[0])[3],Ra.v[4],(8&Ra.uw[21])!=0,0);
            }
            Ra.sl[6]=2660; /* line # 2660 */
            if (Rv0) {
              Ra.sl[6]=2661; /* line # 2661 */
              if (4&((UW *)Rv5)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V *)((
              V *)Rv3)[0])[3])[13],0,0);
              else {
                Ra.sl[6]=2663; /* line # 2663 */
                if (16&((UW *)Rv5)[5]) Rv0=((V *)Rv3)[3]==((V *)((V *)Rv3)[0])[3]
                &&((SL *)((V *)Rv3)[3])[10]==0;
                else {
                  Ra.sl[6]=2665; /* line # 2665 */
                  if (32&((UW *)Rv5)[5]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V
                   *)Rv3)[0])[3],8&((UW *)Rv5)[5]||8&Ra.uw[21],1);
                }
              }
            }
          }
        }
        break;
      }
    }
    else {
      Ra.sl[6]=2671; /* line # 2671 */
      Rv6=((V *)Rv2)[2];
      Ra.sl[6]=2672; /* line # 2672 */
      if (((SL *)Rv6)[20]>=F_npa) {
        Ra.sl[6]=2674; /* line # 2674 */
        Rv7=((V *)Rv6)[8];
        Ra.sl[6]=2675; /* line # 2675 */
        if (Rv7!=NULL) {
          Ra.sl[6]=2676; /* line # 2676 */
          if (((UB *)Rv7)[94]==6) {
            Ra.sl[6]=2677; /* line # 2677 */
            Rv7=((V *)Rv7)[3];
          }
        }
        Ra.sl[6]=2680; /* line # 2680 */
        if ((F_npa==2&&((SL *)Rv6)[20]==2)&&(((UB *)Rv6)[104]==1||((UB *)Rv6)[104]
        ==2)) {
          Ra.sl[6]=2682; /* line # 2682 */
          Rv8=Rv1;
          Ra.sl[6]=2684; /* line # 2684 */
          Rv9=((V *)Rv7)[3];
          Ra.sl[6]=2685; /* line # 2685 */
          Rv0=P_comp_type(((V *)Rv8)[3],((V *)Rv7)[4],8&((UW *)Rv7)[48]||((UB *)
          Rv7)[94]!=8,0)&&P_comp_type(((V *)((V *)Rv8)[0])[3],((V *)Rv9)[4],8&((
          UW *)Rv9)[48]||((UB *)Rv9)[94]!=8,0);
          Ra.sl[6]=2689; /* line # 2689 */
          if (Rv0) {
            Ra.sl[6]=2690; /* line # 2690 */
            if (4&((UW *)Rv7)[48]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)((V
             *)Rv8)[0])[3])[13],0,0);
            else {
              Ra.sl[6]=2692; /* line # 2692 */
              if (16&((UW *)Rv7)[48]) Rv0=((V *)Rv8)[3]==((V *)((V *)Rv8)[0])[3]
              &&((SL *)((V *)Rv8)[3])[10]==0;
              else {
                Ra.sl[6]=2694; /* line # 2694 */
                if (32&((UW *)Rv7)[48]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)
                Rv8)[0])[3],8&((UW *)Rv7)[48]||8&((UW *)Rv9)[48],0);
              }
            }
          }
        }
        Ra.sl[6]=2722; /* line # 2722 */
        if (!Rv0) {
          Ra.sl[6]=2724; /* line # 2724 */
          Rv0=1;
          Ra.sl[6]=2725; /* line # 2725 */
          while (Rv0&&Rv7!=NULL){
            Ra.sl[6]=2727; /* line # 2727 */
            Rv10=0;
            Ra.sl[6]=2728; /* line # 2728 */
            Rv11=Rv7;
            Ra.sl[6]=2729; /* line # 2729 */
            if (Rv1!=NULL) {
              Ra.sl[6]=2730; /* line # 2730 */
              Rv12=Rv1;
              Ra.sl[6]=2732; /* line # 2732 */
              if (((UB *)Rv12)[40]==17) {
                Ra.sl[6]=2733; /* line # 2733 */
                if (((V *)Rv11)[8]==NULL&&!(8192&((UW *)Rv11)[46])) {
                  Ra.sl[6]=2734; /* line # 2734 */
                  Rv0=0;
                }
                else {
                  Ra.sl[6]=2737; /* line # 2737 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
              }
              else {
                Ra.sl[6]=2741; /* line # 2741 */
                Rv13=P_comp_type(((V *)Rv12)[3],((V *)Rv11)[4],((UB *)Rv11)[94]!=
8,0);
                Ra.sl[6]=2744; /* line # 2744 */
                if (!Rv13&&((UB *)Rv12)[40]==14) {
                  Ra.sl[6]=2746; /* line # 2746 */
                  Rv14=((V *)Rv11)[4];
                  Ra.sl[6]=2747; /* line # 2747 */
                  switch (((UB *)Rv14)[92]) {
                    case 4:Ra.sl[6]=2755; /* line # 2755 */
                    if (((UB *)((V *)Rv12)[3])[92]==3) {
                      Ra.sl[6]=2757; /* line # 2757 */
                      ((V *)Rv12)[3]=V_typ_std.v[4];
                      Rv13=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[6]=2779; /* line # 2779 */
                    if ((P_comp_type(((V *)Rv14)[14],V_typ_std.v[0],1,0)&&((UB *)(
                    (V *)Rv14)[15])[92]==2)&&((SL *)Rv14)[10]==0) {
                      Ra.sl[6]=2782; /* line # 2782 */
                      if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[10],0,0)) {
                        Ra.sl[6]=2785; /* line # 2785 */
                        if (((UB *)Rv14)[92]==8) {
                          Ra.sl[6]=2786; /* line # 2786 */
                          Rv15=((V *)Rv14)[15];
                          Ra.sl[6]=2787; /* line # 2787 */
                          Rv13=(((SL *)Rv15)[30]-((SL *)Rv15)[29])+1==((SL *)((V
                           *)Rv12)[7])[6];
                        }
                        else {
                          Ra.sl[6]=2790; /* line # 2790 */
                          Rv13=1;
                        }
                      }
                      else {
                        Ra.sl[6]=2792; /* line # 2792 */
                        if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[0],0,0)) {
                          Ra.sl[6]=2794; /* line # 2794 */
                          if (((UB *)Rv14)[92]==9) Rv13=1;
                          else {
                            Ra.sl[6]=2795; /* line # 2795 */
                            Rv13=((SL *)Rv14)[30]==((SL *)Rv14)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=2800; /* line # 2800 */
                if (Rv13) {
                  Ra.sl[6]=2802; /* line # 2802 */
                  if (((V *)Rv11)[4]!=NULL) {
                    Ra.sl[6]=2803; /* line # 2803 */
                    if (((UB *)((V *)Rv11)[4])[92]==9) {
                      Ra.sl[6]=2804; /* line # 2804 */
                      Rv10=((SL *)((V *)Rv11)[4])[24];
                    }
                  }
                  Ra.sl[6]=2805; /* line # 2805 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
                else {
                  Ra.sl[6]=2806; /* line # 2806 */
                  Rv0=0;
                }
                Ra.sl[6]=2809; /* line # 2809 */
                if (Rv0) {
                  Ra.sl[6]=2811; /* line # 2811 */
                  if (((UB *)Rv11)[94]==8) {
                    Ra.sl[6]=2813; /* line # 2813 */
                    if (!(1&((UW *)Rv12)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[6]=2816; /* line # 2816 */
                    if (4&((UW *)Rv12)[10]) {
                      Ra.sl[6]=2818; /* line # 2818 */
                      if (32&((UW *)Rv11)[46]) {
                        Ra.sl[6]=2819; /* line # 2819 */
                        if (!(1&((UW *)Rv12)[10])) Rv0=0;
                      }
                      Ra.sl[6]=2820; /* line # 2820 */
                      if (64&((UW *)Rv11)[46]) {
                        Ra.sl[6]=2821; /* line # 2821 */
                        if (!(2&((UW *)Rv12)[10])) Rv0=0;
                      }
                    }
                    else {
                      Ra.sl[6]=2824; /* line # 2824 */
                      if (64&((UW *)Rv11)[46]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[6]=2829; /* line # 2829 */
              if (((V *)Rv11)[8]==NULL&&!(8192&((UW *)Rv11)[46])) {
                Ra.sl[6]=2830; /* line # 2830 */
                Rv0=0;
              }
              else {
                Ra.sl[6]=2832; /* line # 2832 */
                Rv7=((V *)Rv11)[3];
              }
            }
            Ra.sl[6]=2834; /* line # 2834 */
            if (Rv10>0) while (1){
              Ra.sl[6]=2836; /* line # 2836 */
              Rv7=((V *)Rv7)[3];
              Rv10=Rv10-1;
              if (Rv10==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[6]=2841; /* line # 2841 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  Ra.sl[6]=2843; /* line # 2843 */
  if (!Rv0) {
    Ra.sl[6]=2850; /* line # 2850 */
    P_src_error_s(Rd.s+1108,113,3, F_id,NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1112;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2875; /* line # 2875 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  Ra.sl[6]=2876; /* line # 2876 */
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  Ra.sl[6]=2877; /* line # 2877 */
  if (F_p!=NULL) {
    Ra.sl[6]=2878; /* line # 2878 */
    Rv1=F_p;
    Ra.sl[6]=2880; /* line # 2880 */
    if (((UB *)Rv1)[8]) {
      Ra.sl[6]=2882; /* line # 2882 */
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else {
        Ra.sl[6]=2883; /* line # 2883 */
        Rv2=P_exp_val_bin(F_oblst, F_p);
      }
    }
    else {
      Ra.sl[6]=2888; /* line # 2888 */
      Rv3=((V *)Rv1)[2];
      Ra.sl[6]=2890; /* line # 2890 */
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      Ra.sl[6]=2893; /* line # 2893 */
      P_call_setting(&Rv2);
    }
    Ra.sl[6]=2895; /* line # 2895 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=2896; /* line # 2896 */
    Ret=F_oblst;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1125;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2912; /* line # 2912 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Ra.sl[6]=2913; /* line # 2913 */
  Rv0=((V *)F_ip)[10];
  Ra.sl[6]=2914; /* line # 2914 */
  if (F_np<=0) {
    Ra.sl[6]=2916; /* line # 2916 */
    Rv1=F_lgp;
    Ra.sl[6]=2917; /* line # 2917 */
    while (Rv1!=NULL){
      Ra.sl[6]=2918; /* line # 2918 */
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Ra.sl[6]=2920; /* line # 2920 */
  Rv2=NULL;
  Ra.sl[6]=2921; /* line # 2921 */
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2922; /* line # 2922 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    Ra.sl[6]=2926; /* line # 2926 */
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=2927; /* line # 2927 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      Ra.sl[6]=2928; /* line # 2928 */
      if (((V *)Rv3)[2]!=NULL) {
        Ra.sl[6]=2930; /* line # 2930 */
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        Ra.sl[6]=2931; /* line # 2931 */
        P_call_setting(&Rv2);
      }
    }
  }
  Ra.sl[6]=2935; /* line # 2935 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1140;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2944; /* line # 2944 */
  Ri.ub[0]=F_op;
  Ra.sl[6]=2946; /* line # 2946 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1151;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2961; /* line # 2961 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else {
    Ra.sl[6]=2962; /* line # 2962 */
    Rv0=((V *)V_ope_table.v[28])[3];
  }
  Ra.sl[6]=2963; /* line # 2963 */
  Rv1=((V *)F_prm)[0];
  Ra.sl[6]=2964; /* line # 2964 */
  Rv2=((UW *)F_prm)[10];
  Ra.sl[6]=2965; /* line # 2965 */
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=2966; /* line # 2966 */
  if (F_bovr) {
    Ra.sl[6]=2968; /* line # 2968 */
    ((UW *)F_prm)[10]=Rv2|3;
    Ra.sl[6]=2969; /* line # 2969 */
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=2971; /* line # 2971 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  Ra.sl[6]=2972; /* line # 2972 */
  if (F_bovr) {
    Ra.sl[6]=2974; /* line # 2974 */
    ((UW *)F_prm)[10]=Rv2;
    Ra.sl[6]=2975; /* line # 2975 */
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=2977; /* line # 2977 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
