/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[6];

/* Define the local data section. */
static Blk( Rd, 1384 ) = {{
 15,  15, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  95, 116, 121, 112,
101,  62,  62,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,
 47,  83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,
 53,  45,  50,  47, 112,  99, 109, 112,  95,  99, 111, 109, 112,  46, 112,  97,
115,   4,   4,  69,  88,  80,  84,  10,  10, 101, 120, 112,  95, 103, 101, 110,
110, 117, 109,   4,   4,  69,  71,  67,  84,   9,   9,  97, 116, 116, 114,  95,
116, 121, 112, 101,   4,   4,  65,  84,  84,  89,   9,   9,  36, 117, 110, 115,
105, 103, 110, 101, 100,   8,   8,  36, 105, 110, 116, 101, 103, 101, 114,   7,
  7,  36, 115, 105, 110, 103, 108, 101,   7,   7,  36, 100, 111, 117,  98, 108,
101,   6,   6,  36,  97, 116, 116, 114,  95,  14,  14,  98, 117, 105, 108, 100,
 95,  97, 114, 103,  95, 108, 105, 115, 116,   4,   4,  66,  65,  82,  71,  16,
 16,  99,  97, 108, 108,  95, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,
 99,   4,   4,  70,  67,  65,  76,  18,  18,  99,  97, 108, 108,  95, 105, 110,
100, 105, 114, 101,  99, 116,  95, 112, 114, 111,  99,  12,  12,  99,  97, 108,
108,  95, 103, 101, 110, 101, 114, 105,  99,   4,   4,  67,  65,  76,  71,   9,
  9, 111, 112, 101, 110,  95,  99,  97, 108, 108,   4,   4,  79,  80,  69,  78,
 14,  14, 114, 101,  97, 100, 119, 114, 105, 116, 101,  95,  99,  97, 108, 108,
  4,   4,  82,  87,  73,  79,  18,  18, 103, 101, 116,  95, 115, 116,  97, 116,
101,  95, 101, 102, 102,  95, 108, 105, 115, 116,  15,  15, 117, 115, 101, 114,
 95, 115, 116,  97, 116, 101,  95,  99,  97, 108, 108,   4,   4,  85,  83,  84,
 65,   8,   8, 110, 101, 119,  95,  99,  97, 108, 108,   4,   4,  78,  69,  87,
 67,  12,  12, 100, 105, 115, 112, 111, 115, 101,  95,  99,  97, 108, 108,   4,
  4,  70,  82,  69,  69,  20,  20, 103, 101, 110,  95, 108, 105, 115, 116,  95,
 97, 103, 114, 101, 103,  97, 116,  95, 115, 101, 116,   4,   4,  83,  65,  71,
 82,  20,  20, 103, 101, 110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101,
103,  97, 116,  95, 116,  97,  98,   4,   4,  84,  65,  71,  82,  20,  20, 103,
101, 110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95,
114, 101,  99,   4,   4,  82,  65,  71,  82,  12,  12, 103, 101, 116,  95,  97,
103, 114, 101, 103,  97, 116, 101,   4,   4,  65,  71,  82,  69,  13,  13, 101,
120, 112,  95,  99, 111, 110, 115, 116,  95, 115, 101, 116,   4,   4,  67,  83,
 69,  84,  11,  11, 103, 101, 116,  95, 112, 114, 111,  99, 114, 101, 102,   4,
  4,  71,  80,  82,  79,  15,  15, 101, 120, 112,  95, 103, 101, 110, 101, 114,
105,  99,  95, 114, 101, 102,   4,   4,  69,  88,  71,  69,  14,  14, 101, 120,
112,  95, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114,   4,   4,  82,  70,
 79,  66,   9,   9, 101, 120, 112,  95, 105, 110, 100, 105, 114,   4,   4,  73,
 78,  68,  73,   9,   9, 101, 120, 112,  95, 102, 105, 101, 108, 100,   4,   4,
 71,  70,  76,  68,   9,   9, 101, 120, 112,  95, 105, 110, 100, 101, 120,   4,
  4,  73,  78,  68,  88,   7,   7, 101, 120, 112,  95, 117, 110,  97,   4,   4,
 69,  88,  80,  82,   7,   7, 101, 120, 112,  95, 112, 111, 119,   7,   7, 101,
120, 112,  95, 109, 117, 108,   7,   7, 101, 120, 112,  95,  97, 100, 100,   7,
  7, 101, 120, 112,  95, 114, 101, 108,   7,   7, 101, 120, 112,  95,  97, 110,
100,  10,  10, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  14,  14,  99,
 97, 115, 101,  95, 119, 111, 114, 107,  95, 108, 105, 115, 116,   4,   4,  67,
 65,  83,  68,  15,  15,  99,  97, 115, 101,  95, 100, 101, 102, 105, 110, 105,
116, 105, 111, 110,  17,  17, 115, 101, 116,  95,  97, 108, 105, 103, 110, 109,
101, 110, 116,  95, 115, 112,  99,   4,   4,  65,  76,  71,  78,  14,  14,  99,
111, 110, 102, 111, 114, 109,  97, 110, 116,  95, 100, 101, 102,   4,   4,  67,
 78,  70,  65,   9,   9,  97, 114, 114,  97, 121,  95, 100, 101, 102,   4,   4,
 65,  82,  82,  89,   8,   8, 116, 121, 112, 101,  95, 115, 112,  99,   4,   4,
 84,  89,  80,  83,  18,  18, 115, 101, 116,  95, 100, 101,  99, 108,  95,  97,
116, 116, 114, 105,  98, 117, 116, 101,   4,   4,  68,  65,  84,  84,  13,  13,
118,  97, 114,  98, 108,  95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  86,
 65,  82,  66,   9,   9,  99, 111, 110, 115, 116, 100, 101,  99, 108,   4,   4,
 67,  79,  78,  68,   8,   8, 116, 121, 112, 101, 100, 101,  99, 108,   4,   4,
 84,  89,  80,  68,   7,   7, 118,  97, 114, 100, 101,  99, 108,   9,   9, 108,
 97,  98, 101, 108, 100, 101,  99, 108,   4,   4,  76,  65,  66,  68,  13,  13,
115, 116,  97, 116, 101, 109, 101, 110, 116, 100, 101,  99, 108,   4,   4,  83,
 84,  65,  68,  13,  13,  97, 114, 103, 117, 109, 101, 110, 116,  95, 108, 105,
115, 116,   4,   4,  65,  82,  71,  76,   3,   3,  46, 114, 118,  16,  16, 102,
111, 114, 109,  97, 108,  95, 112, 114, 111,  99,  95, 100, 101,  99, 108,   4,
  4,  70,  80,  68,  69,  15,  15, 102, 111, 114, 109,  97, 108,  95, 112, 114,
111,  99,  95, 112, 116, 114,   4,   4,  70,  80,  68,  69,  18,  18, 105, 110,
115, 101, 114, 116,  95, 110, 101, 119,  95, 103, 101, 110, 101, 114, 105,  99,
  4,   4,  73,  71,  69,  78,   9,   9, 112, 114, 111,  99,  95, 100, 101,  99,
108,   4,   4,  68,  80,  82,  79,   4,   4,  80,  82,  67,  95,   4,   4,  80,
 82,  67,  95,   9,   9, 112, 114, 111,  99,  95,  98, 111, 100, 121,   4,   4,
 71,  69,  78,  68,   9,   9, 103, 101, 110, 101,  95, 100, 101,  99, 108,  10,
 10, 103, 101, 110,  95,  97, 115, 115, 105, 103, 110,   4,   4,  71,  65,  83,
 83,  11,  11, 114, 101, 116, 117, 114, 110, 115, 116,  97, 116, 101,   4,   4,
 82,  69,  84,  85,  15,  15,  97, 115, 115, 105, 103, 110, 109, 101, 110, 116,
115, 116,  97, 116, 101,   4,   4,  65,  83,  83,  73,  10,  10, 119, 105, 116,
104,  95, 115, 116,  97, 116, 101,   4,   4,  87,  73,  84,  72,   7,   7, 105,
102, 115, 116,  97, 116, 101,   4,   4,  73,  70,  83,  84,   9,   9, 101, 120,
105, 116, 115, 116,  97, 116, 101,   4,   4,  69,  88,  83,  84,   9,   9, 108,
111, 111, 112, 115, 116,  97, 116, 101,   4,   4,  76,  79,  79,  80,   8,   8,
102, 111, 114, 115, 116,  97, 116, 101,   4,   4,  70,  79,  82,  95,   9,   9,
103, 111, 116, 111, 115, 116,  97, 116, 101,   4,   4,  71,  84,  79,  76,  10,
 10,  98, 101, 103, 105, 110, 115, 116,  97, 116, 101,   4,   4,  66,  69,  71,
 83,  12,  12, 108,  97,  98, 101, 108,  95,  97, 116, 116,  97,  99, 104,   9,
  9, 115, 116,  97, 116, 101, 109, 101, 110, 116,   4,   4,  83,  84,  65,  84,
  9,   9, 115, 116,  97, 116, 101, 108, 105, 115, 116,   4,   4,  83,  84,  76,
 73,   9,   9,  99, 109, 112,  95,  98, 108, 111,  99, 107,   4,   4,  66,  76,
 79,  67,   5,   5,  46, 116, 101, 109, 112,   8,   8,  99, 109, 112,  95, 105,
110, 105, 116,   9,   9,  99, 109, 112,  95, 112,  97, 115, 115,  50,  11,  11,
 99, 109, 112,  95,  99, 111, 109, 112, 105, 108, 101,   4,   4,  67,  77,  80,
 77,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 64 ) = {{
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern Blk(V_typ_std, 248 );
extern UB V_cmp_range;
extern V V_curr_descr;
extern UB V_enm_range;
extern Blk(V_sy_sym, 8 );
extern V V_attr_list;
extern Blk(V_sy_ident, 32 );
extern V V_ima_typ;
extern V V_int_typ;
extern Blk(V_ide_udptr, 120 );
extern V V_iof_std_open;
extern UB V_sy_label_flag;
extern SL V_dst_seti;
extern SL V_dst_seta;
extern SL V_dst_setw;
extern V V_set_entry_proc;
extern SL V_stri_stroffset;
extern UB V_lastsymb;
extern V V_sy_search;
extern Blk(V_lex_ident_tree, 4160 );
extern SL V_ident_disp;
extern SL V_sy_ival;
extern G V_sy_rval;
extern Blk(V_sy_string, 264 );
extern SL V_curr_disp;
extern UB V_sy_casedef;
extern UB V_err_prt;
extern SL V_sy_descr_size;
extern V V_sy_type_gfirst;
extern UB V_sy_init_mod;
extern UB V_sy_fix_range_ctl;
extern SL V_fptr_size;
extern SL V_stri_descrsz;
extern SL V_stri_lengthsz;
extern V V_usi_tab;
extern V V_csi_tab;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;
extern SL V_inte_size;
extern V V_uns_typ;
extern SL V_sngl_size;
extern SL V_dble_size;
extern UB V_tcas_flag;
extern SL V_curr_lex;
extern UB V_error_result;
extern UB V_cmp_dynamic;
extern Blk(V_lex_ident_level, 128 );
extern UB V_sy_generic_qmod;
extern V V_pro_d_first;
extern V V_pro_d_last;
extern Blk(V_opname, 960 );
extern SL V_proc_seq;
extern SL V_cmp_traceopt;
extern SL V_cmp_trace;
extern UB V_cmp_objf;
extern V V_pro_last;
extern V V_pro_first;
extern V V_new_entry_proc;
extern V V_newh_entry_proc;
extern V V_dispose_entry_proc;
extern V V_iof_std_close;
extern V V_inp_std_sel;
extern V V_inp_std_gene;
extern V V_inp_std_eoln;
extern V V_inp_std_bin;
extern V V_out_std_sel;
extern V V_out_std_gene;
extern V V_out_std_eoln;
extern V V_out_std_bin;
extern V V_gen_std_string1;
extern V V_gen_std_cnfardsc;
extern Blk(V_ope_table, 240 );
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_wildtmp_stk;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_src_control;
extern UB V_emergency_stop;
extern V V_pro_current;
extern SL V_cprc_disp;
extern UB V_sy_var_init_mod;
extern V V_cntx_varbl;
extern V V_wildtmp_typ;
extern V V_wildtmp_ide;
extern SL V_wildtmp_psz;
extern Blk(V_wildtmp_pal, 8 );
extern UB V_opt_exec;
extern UB V_cmp_cmpdbg;
extern UB V_cmp_genenv;
extern SL V_cmp_listlvl;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern UB V_cmp_bltt;
extern UB V_cmp_opt;
extern UB V_cmp_debugopt;
extern UB V_cmp_debug;
extern SL V_cmp_tracecount;
extern SL V_cntx_procname;
extern SL V_cntx_srcfname;
extern SL V_cntx_linenbr;
extern SL V_cntx_size;
extern V V_cntx_typ;
extern V V_env_file;
extern V V_env_first;
extern V V_env_last;
extern C V_sy_ch;
extern V V_lst_current;
extern V V_pas_main;


/* Function/procedure prototypes. */
void P_lst_page();
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_search_char();
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_data_format_set(V F_ty);
V P_tab_new(SL F_sz);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_all_free(V F_p);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
SL P_lgt_get_econst(V F_lgt, SL F_idf);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2);
void P_new_disp_level(V F_ow, UB F_kind);
void P_ide_reserve_disp(SL F_prv);
SL P_match(V F_s1, V F_s2);
V P_new_int_name(V F_head, SL *F_nbs);
V P_level_search(V F_fp);
V P_lex_search(SL F_disp);
V P_ide_search(UW F_fs);
void P_ide_new(UB F_fc, V F_ty, V *F_ip);
void P_gen_cntxvar(V F_pr, V F_id);
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd);
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd);
void P_label_purge(V *F_prv_cntx);
SL P_typ_alignement(SL F_iaddr, V F_aln);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_cte_allocate(V F_vp, V F_id);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ);
void P_tmpstk_free(V F_stkp);
void P_free_typ_list(V *F_p);
void P_free_ide_list(V *F_p);
void P_ide_create_name(V F_name);
void P_ide_int_label();
V P_ide_search_from_nameid(V F_ip);
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach);
void P_set_env_file_spc(V F_pcur);
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2);
void P_compile_set_title();
void P_compile_set_sbttl(V F_prc);
void P_insymbol();
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rflg);
void P_insy_init();
void P_set_strname(V *F_nam);
void P_set_stdname(V F_pr);
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent);
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count);
void P_type_parm_cte_release(V F_ty);
void P_string_in_array(V F_lgt, V F_ty);
void P_string_in_substring(V F_lgt, V F_ty);
void P_call_setting(V *F_lgt);
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst);
V P_exp_genoper(V F_id, V F_p, V F_oblst);
V P_exp_genop(UB F_op, V F_oblst);
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
void P_initialize_varbl(V F_ip);
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide);
void P_init_d_varbl(V F_ip);
void P_type_check_parm(V F_lgt);
V P_type_parm_set(V F_ip, V F_lgt);
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void P_lgt_gen_routine(V F_ty);
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj);
void P_lgt_extract_simple_cte(V F_lgt);
void P_lgt_all_fparm(V F_pr);
void P_lgt_pass1_complet(V F_pr);
void P_lgt_dump_proc(V F_pr);
void P_lgt_dump_static(V F_pr);
void P_generation_setting();
void P_generate_code_p1(V F_proc);
void P_generate_code_p2();
void P_pas_read_env_file();
void P_pas_write_env_file();
void PAS_COMILER_cmp_pass2(V F_pr);
V PAS_COMILER_PRC_00000000();
V PAS_COMILER_PRC_00000001(UB F_isfunction);
V PAS_COMILER_PRC_00000002(UB F_isfunction);
V PAS_COMILER_PRC_00000019(V F_ty);
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg);
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ);
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty);
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg);


/* Procedure/Function : " expression_type "  */
V PAS_COMILER_PRC_00000005(V F_it, UB F_exact, UB F_no_def, UB F_no_check){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  C Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=181; /* line # 181 */
  Rv0=0;
  Ra.sl[6]=182; /* line # 182 */
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=183; /* line # 183 */
  if (Rv1!=NULL) {
    Ra.sl[6]=184; /* line # 184 */
    Rv2=Rv1;
    Rv3=F_it;
    Ra.sl[6]=185; /* line # 185 */
    if (((V *)Rv2)[3]!=F_it) {
      Ra.sl[6]=187; /* line # 187 */
      if (((UB *)Rv2)[40]==14) {
        Ra.sl[6]=189; /* line # 189 */
        if (((V *)Rv2)[3]==V_typ_std.v[13]&&P_comp_type(((V *)Rv2)[3],F_it,0,0))
         {
          Ra.sl[6]=190; /* line # 190 */
          ((V *)Rv2)[3]=F_it;
          Rv0=1;
        }
        else {
          Ra.sl[6]=192; /* line # 192 */
          if (P_comp_type(((V *)Rv2)[3],V_typ_std.v[10],0,0)||P_comp_type(((V *)
          Rv2)[3],V_typ_std.v[0],1,0)) {
            Ra.sl[6]=195; /* line # 195 */
            if ((((UB *)Rv3)[92]==10&&((UB *)((V *)Rv2)[3])[92]==0)&&P_comp_type((
            (V *)Rv2)[3],F_it, F_exact,0)) {
              Ra.sl[6]=199; /* line # 199 */
              if (((V *)Rv2)[7]!=NULL) Rv4=(C)((SL *)((V *)Rv2)[7])[13];
              else Rv4=32;
              Ra.sl[6]=200; /* line # 200 */
              P_val_free(((V *)Rv2)+7);
              Ra.sl[6]=201; /* line # 201 */
              P_val_new(((V *)Rv2)+7,V_typ_std.v[10]);
              Ra.sl[6]=202; /* line # 202 */
              ((V *)Rv2)[3]=V_typ_std.v[10];
              Ra.sl[6]=203; /* line # 203 */
              Rv5=((V *)Rv2)[7];
              Ra.sl[6]=205; /* line # 205 */
              ((UB *)Rv5)[48]=29;
              Ra.sl[6]=206; /* line # 206 */
              ((SL *)Rv5)[6]=1;
              Ra.sl[6]=207; /* line # 207 */
              ((V *)Rv5)[7]=PAS__NEW(3);
              ((UB *)((V *)Rv5)[7])[0]=1;
              Ra.sl[6]=208; /* line # 208 */
              PAS__CHA_TO_STR(((V *)Rv5)[7],Rv4);
              Ra.sl[6]=210; /* line # 210 */
              Rv0=1;
            }
            else {
              Ra.sl[6]=213; /* line # 213 */
              if (((UB *)Rv3)[92]==8&&((V *)Rv3)[14]==V_typ_std.v[0]) {
                Ra.sl[6]=216; /* line # 216 */
                P_string_in_array(Rv1, F_it);
                Ra.sl[6]=217; /* line # 217 */
                Rv0=1;
              }
              else {
                Ra.sl[6]=220; /* line # 220 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=222; /* line # 222 */
                  P_string_in_substring(Rv1, F_it);
                  Ra.sl[6]=223; /* line # 223 */
                  Rv0=1;
                }
              }
            }
          }
          else {
            Ra.sl[6]=227; /* line # 227 */
            if (((V *)((V *)Rv2)[3])[0]==F_it) Rv0=1;
            else {
              Ra.sl[6]=229; /* line # 229 */
              switch (((UB *)Rv3)[92]) {
                case 0:
                case 1:
                case 2:Ra.sl[6]=231; /* line # 231 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=233; /* line # 233 */
                  if (((V *)Rv2)[7]!=NULL) {
                    Ra.sl[6]=234; /* line # 234 */
                    Rv6=((V *)Rv2)[7];
                    Ra.sl[6]=236; /* line # 236 */
                    if (((UB *)Rv3)[112]) {
                      Ra.sl[6]=238; /* line # 238 */
                      if (((UL *)Rv3)[29]<=((UL *)Rv6)[13]&&((UL *)Rv3)[30]>=((UL
                       *)Rv6)[13]) {
                        Ra.sl[6]=239; /* line # 239 */
                        ((V *)Rv2)[3]=F_it;
                        ((V *)Rv6)[4]=F_it;
                        Rv0=1;
                      }
                    }
                    else {
                      Ra.sl[6]=242; /* line # 242 */
                      if (((SL *)Rv3)[29]<=((SL *)Rv6)[13]&&((SL *)Rv3)[30]>=((SL
                       *)Rv6)[13]) {
                        Ra.sl[6]=243; /* line # 243 */
                        ((V *)Rv2)[3]=F_it;
                        ((V *)Rv6)[4]=F_it;
                        Rv0=1;
                      }
                    }
                    Ra.sl[6]=245; /* line # 245 */
                    if (!Rv0) P_src_error(Rd.s+83,154,2);
                  }
                }
                break;
                case 22:Ra.sl[6]=249; /* line # 249 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=251; /* line # 251 */
                  if (((V *)Rv2)[7]!=NULL) {
                    Ra.sl[6]=252; /* line # 252 */
                    Rv7=((V *)Rv2)[7];
                    Ra.sl[6]=253; /* line # 253 */
                    if (((SL *)((V *)Rv2)[3])[11]<=((SL *)Rv3)[11]) {
                      Ra.sl[6]=255; /* line # 255 */
                      ((V *)Rv2)[3]=F_it;
                      Ra.sl[6]=256; /* line # 256 */
                      ((V *)Rv7)[4]=F_it;
                      Ra.sl[6]=257; /* line # 257 */
                      if (V_cmp_range&&!F_no_check) {
                        Ra.sl[6]=259; /* line # 259 */
                        Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
                        Ra.sl[6]=261; /* line # 261 */
                        ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,
                        NULL,0);
                        Ra.sl[6]=262; /* line # 262 */
                        ((V *)Rv1)[0]=Rv8;
                        Ra.sl[6]=263; /* line # 263 */
                        Rv1=P_lgt_new_code(2, Rv1);
                        Ra.sl[6]=264; /* line # 264 */
                        ((V *)Rv1)[3]=F_it;
                      }
                      Ra.sl[6]=266; /* line # 266 */
                      Rv0=1;
                    }
                  }
                }
                break;
                case 3:
                case 4:Ra.sl[6]=270; /* line # 270 */
                Rv9=((V *)Rv2)[7];
                Ra.sl[6]=272; /* line # 272 */
                if (((V *)Rv2)[3]!=NULL) {
                  Ra.sl[6]=273; /* line # 273 */
                  switch (((UB *)((V *)Rv2)[3])[92]) {
                    case 2:Ra.sl[6]=274; /* line # 274 */
                    ((G *)Rv9)[7]=(double)((SL *)Rv9)[13];
                    Rv0=1;
                    break;
                    case 3:
                    case 4:Ra.sl[6]=275; /* line # 275 */
                    Rv0=1;
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=278; /* line # 278 */
                if (Rv0) {
                  Ra.sl[6]=280; /* line # 280 */
                  ((UB *)Rv9)[48]=((UB *)Rv3)[92];
                  Ra.sl[6]=281; /* line # 281 */
                  ((V *)Rv9)[4]=F_it;
                  Ra.sl[6]=282; /* line # 282 */
                  ((V *)Rv2)[3]=F_it;
                }
                break;
                default:break;
              }
            }
          }
        }
      }
      Ra.sl[6]=295; /* line # 295 */
      if (!Rv0) {
        Ra.sl[6]=296; /* line # 296 */
        if (!P_comp_type(((V *)Rv2)[3],F_it, F_exact,0)) {
          Ra.sl[6]=298; /* line # 298 */
          P_src_error(Rd.s+83,109,3);
          Ra.sl[6]=299; /* line # 299 */
          ((V *)Rv1)[3]=F_it;
        }
        else {
          Ra.sl[6]=302; /* line # 302 */
          if (V_cmp_range&&!F_no_check) {
            Ra.sl[6]=303; /* line # 303 */
            switch (((UB *)Rv3)[92]) {
              case 0:
              case 1:
              case 2:Ra.sl[6]=305; /* line # 305 */
              if (V_enm_range) {
                Ra.sl[6]=307; /* line # 307 */
                Rv8=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[29]);
                Ra.sl[6]=308; /* line # 308 */
                ((V *)Rv8)[0]=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[30]);
                Ra.sl[6]=309; /* line # 309 */
                ((V *)Rv1)[0]=Rv8;
                Ra.sl[6]=310; /* line # 310 */
                Rv1=P_lgt_new_code(2, Rv1);
                Ra.sl[6]=311; /* line # 311 */
                ((V *)Rv1)[3]=F_it;
              }
              break;
              case 22:Ra.sl[6]=316; /* line # 316 */
              Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
              Ra.sl[6]=317; /* line # 317 */
              ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,NULL,0);
              Ra.sl[6]=318; /* line # 318 */
              ((V *)Rv1)[0]=Rv8;
              Ra.sl[6]=319; /* line # 319 */
              Rv1=P_lgt_new_code(2, Rv1);
              Ra.sl[6]=320; /* line # 320 */
              ((V *)Rv1)[3]=F_it;
              break;
              default:break;
            }
          }
        }
      }
    }
  }
  Ra.sl[6]=326; /* line # 326 */
  if (F_no_def) {
    Ra.sl[6]=327; /* line # 327 */
    if (((UB *)Rv1)[40]==17) P_src_error(Rd.s+83,181,2);
  }
  Ra.sl[6]=328; /* line # 328 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_gennum "  */
SL PAS_COMILER_PRC_00000006(V *F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+87;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=343; /* line # 343 */
  Rv0=PAS_COMILER_PRC_00000005((*F_ty),0,0,0);
  Ra.sl[6]=344; /* line # 344 */
  Rv1=Rv0;
  Ra.sl[6]=346; /* line # 346 */
  (*F_ty)=((V *)Rv1)[3];
  Ra.sl[6]=347; /* line # 347 */
  if (((UB *)Rv1)[40]==14) {
    Ra.sl[6]=348; /* line # 348 */
    Ret=((SL *)((V *)Rv1)[7])[13];
  }
  else {
    Ra.sl[6]=351; /* line # 351 */
    P_src_error(Rd.s+101,853,2);
    Ra.sl[6]=352; /* line # 352 */
    Ret=((SL *)(*F_ty))[29];
  }
  Ra.sl[6]=355; /* line # 355 */
  P_lgt_free_tree(&Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " attr_type "  */
V PAS_COMILER_PRC_00000007(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=31;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+105;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=380; /* line # 380 */
  Rv0=NULL;
  Ra.sl[16]=381; /* line # 381 */
  Rv1=F_ty;
  Ra.sl[16]=383; /* line # 383 */
  P_insymbol();
  Ra.sl[16]=384; /* line # 384 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[16]=386; /* line # 386 */
    Rv2=P_level_search(V_attr_list);
    Ra.sl[16]=387; /* line # 387 */
    if (Rv2==NULL) P_src_error_s(Rd.s+118,105,3, V_sy_ident.s,NULL);
    else {
      Ra.sl[16]=389; /* line # 389 */
      switch (((UB *)Rv2)[57]) {
        case 0:Ra.sl[16]=397; /* line # 397 */
        if (F_lgt==NULL) P_src_error_s(Rd.s+118,161,3, V_sy_ident.s,NULL);
        Ra.sl[16]=398; /* line # 398 */
        P_lgt_new(&Rv0, V_typ_std.v[13],4, F_lgt);
        Ra.sl[16]=399; /* line # 399 */
        F_lgt=NULL;
        break;
        case 1:Ra.sl[16]=403; /* line # 403 */
        if (((SL *)Rv1)[11]>=0) {
          Ra.sl[16]=404; /* line # 404 */
          Rv0=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[11]);
        }
        else {
          Ra.sl[16]=407; /* line # 407 */
          Rv0=P_lgt_type_compute(((V *)Rv1)[8],((V *)Rv1)[9],((SL *)Rv1)[11],F_lgt);
          Ra.sl[16]=408; /* line # 408 */
          if (F_lgt!=NULL) {
            Ra.sl[16]=410; /* line # 410 */
            if (((UB *)F_lgt)[40]!=14) F_lgt=NULL;
          }
        }
        break;
        case 8:
        case 9:Ra.sl[16]=416; /* line # 416 */
        if (P_comp_type(F_ty, V_typ_std.v[10],1,0)) F_ty=((V *)((V *)F_ty)[13])[
4];
        Ra.sl[16]=417; /* line # 417 */
        switch (((UB *)F_ty)[92]) {
          case 8:
          case 9:Ra.sl[16]=420; /* line # 420 */
          Rv3=((V *)F_ty)[15];
          Ra.sl[16]=421; /* line # 421 */
          if (((UB *)Rv3)[92]==22) {
            Ra.sl[16]=423; /* line # 423 */
            if (((UB *)Rv2)[57]==8) Rv0=((V *)Rv3)[13];
            else {
              Ra.sl[16]=424; /* line # 424 */
              Rv0=((V *)Rv3)[14];
            }
            Ra.sl[16]=430; /* line # 430 */
            Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
            Ra.sl[16]=431; /* line # 431 */
            ((V *)Rv0)[3]=((V *)Rv3)[0];
          }
          else {
            Ra.sl[16]=435; /* line # 435 */
            if (((UB *)Rv2)[57]==8) Rv4=((SL *)Rv3)[29];
            else {
              Ra.sl[16]=436; /* line # 436 */
              Rv4=((SL *)Rv3)[30];
            }
            Ra.sl[16]=437; /* line # 437 */
            Rv0=P_lgt_new_econst(((V *)F_ty)[15],Rv4);
          }
          break;
          default:Ra.sl[16]=440; /* line # 440 */
          P_src_error(Rd.s+118,158,3);
          Ra.sl[16]=441; /* line # 441 */
          Rv0=P_lgt_new_econst(V_typ_std.v[15],1);
          break;
        }
        break;
        case 2:
        case 3:Ra.sl[16]=447; /* line # 447 */
        if (((UB *)Rv1)[92]<=2) {
          Ra.sl[16]=448; /* line # 448 */
          if (((UB *)Rv2)[57]==2) Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[29]);
          else {
            Ra.sl[16]=449; /* line # 449 */
            Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[30]);
          }
        }
        else {
          Ra.sl[16]=451; /* line # 451 */
          if (((UB *)Rv1)[92]==22) {
            Ra.sl[16]=453; /* line # 453 */
            if (((UB *)Rv2)[57]==2) Rv0=((V *)Rv1)[13];
            else {
              Ra.sl[16]=454; /* line # 454 */
              Rv0=((V *)Rv1)[14];
            }
            Ra.sl[16]=455; /* line # 455 */
            Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
          }
        }
        break;
        case 4:Ra.sl[16]=459; /* line # 459 */
        if (F_lgt!=NULL) {
          Ra.sl[16]=461; /* line # 461 */
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
          Ra.sl[16]=462; /* line # 462 */
          Rv0=P_exp_genop(11, F_lgt);
          F_lgt=NULL;
        }
        break;
        case 5:Ra.sl[16]=466; /* line # 466 */
        if (F_lgt!=NULL) {
          Ra.sl[16]=468; /* line # 468 */
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
          Ra.sl[16]=469; /* line # 469 */
          Rv0=P_exp_genop(12, F_lgt);
          F_lgt=NULL;
        }
        break;
        case 6:Ra.sl[16]=473; /* line # 473 */
        switch (((UB *)Rv1)[92]) {
          case 1:Ra.sl[16]=475; /* line # 475 */
          if (F_lgt==NULL) {
            Ra.sl[16]=477; /* line # 477 */
            Rv0=P_lgt_link(((V *)Rv1)[13]);
          }
          else {
            Ra.sl[16]=480; /* line # 480 */
            P_lgt_new(&Rv0,((V *)V_ima_typ)[14],1, P_lgt_link(((V *)Rv1)[13]));
            Ra.sl[16]=482; /* line # 482 */
            ((V *)((V *)Rv0)[1])[0]=F_lgt;
            Ra.sl[16]=483; /* line # 483 */
            ((V *)F_lgt)[0]=P_lgt_new_econst(V_int_typ,((SL *)((V *)((V *)Rv1)[13]
            )[3])[25]);
          }
          break;
          case 11:
          case 12:Ra.sl[16]=487; /* line # 487 */
          if (((V *)Rv1)[13]!=NULL) {
            Ra.sl[16]=488; /* line # 488 */
            Rv5=((V *)Rv1)[13];
            Ra.sl[16]=489; /* line # 489 */
            if (F_lgt==NULL) {
              Ra.sl[16]=492; /* line # 492 */
              if (((V *)Rv5)[13]==NULL) {
                Ra.sl[16]=493; /* line # 493 */
                Rv0=P_lgt_link(((V *)Rv5)[13]);
              }
            }
          }
          break;
          default:break;
        }
        break;
        case 7:Ra.sl[16]=501; /* line # 501 */
        if (F_ty==V_typ_std.v[7]) Rv4=0;
        else {
          Ra.sl[16]=503; /* line # 503 */
          if (((UB *)Rv1)[92]==7&&((V *)Rv1)[12]!=NULL) Rv4=((SL *)((V *)Rv1)[12]
          )[11];
          else {
            Ra.sl[16]=504; /* line # 504 */
            Rv4=2147483647;
          }
        }
        Ra.sl[16]=505; /* line # 505 */
        Rv0=P_lgt_new_econst(V_typ_std.v[2],Rv4);
        break;
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:Ra.sl[16]=514; /* line # 514 */
        Ra.sl[16]=517; /* line # 517 */
        Ra.ub[1]=0;
        Ra.sl[16]=518; /* line # 518 */
        switch (((UB *)Rv1)[92]) {
          case 2:Ra.sl[16]=521; /* line # 521 */
          if (((UB *)Rv1)[112]) {
            PAS__VWRITE_INIT(Ra.s,1);
            PAS__WRITE_STR(Rd.s+122,-1,-1,32);
            PAS__WRITE_EOLN();
          }
          else {
            Ra.sl[16]=522; /* line # 522 */
            PAS__VWRITE_INIT(Ra.s,1);
            PAS__WRITE_STR(Rd.s+133,-1,-1,32);
            PAS__WRITE_EOLN();
          }
          Ra.sl[16]=523; /* line # 523 */
          PAS__VWRITE_INIT(Ra.s,0);
          PAS__WRITE_INT(((SL *)Rv1)[11],1,0);
          PAS__WRITE_CHAR(36);
          PAS__WRITE_EOLN();
          break;
          case 3:Ra.sl[16]=525; /* line # 525 */
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+143,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          case 4:Ra.sl[16]=526; /* line # 526 */
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+152,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          default:break;
        }
        Ra.sl[16]=529; /* line # 529 */
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_STR(Rd.s+161,-1,-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[16]=530; /* line # 530 */
        Rv6=((V *)Rv2)[0];
        Ra.sl[16]=531; /* line # 531 */
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[16]=533; /* line # 533 */
        P_ide_create_name(Ra.s);
        Ra.sl[16]=534; /* line # 534 */
        Rv7=P_lex_search(0);
        Ra.sl[16]=535; /* line # 535 */
        if (Rv7!=NULL) {
          Ra.sl[16]=536; /* line # 536 */
          Rv8=Rv7;
          Ra.sl[16]=537; /* line # 537 */
          if (((UB *)Rv8)[56]==4) {
            Ra.sl[16]=539; /* line # 539 */
            P_lgt_new(&Rv0,((V *)Rv8)[4],14,NULL);
            Ra.sl[16]=540; /* line # 540 */
            Rv9=Rv0;
            Ra.sl[16]=542; /* line # 542 */
            ((V *)Rv9)[7]=((V *)Rv8)[8];
            Ra.sl[16]=543; /* line # 543 */
            P_val_new(((V *)Rv9)+7,((V *)Rv8)[4]);
          }
        }
        Ra.sl[16]=546; /* line # 546 */
        if (Rv0==NULL) {
          Ra.sl[16]=548; /* line # 548 */
          Rv0=P_lgt_new_econst(V_typ_std.v[2],0);
          Ra.sl[16]=549; /* line # 549 */
          P_src_error_s(Rd.s+118,164,2,((V *)Rv2)[0],NULL);
        }
        break;
        case 16:Ra.sl[16]=554; /* line # 554 */
        if (((UB *)Rv1)[92]==11||((UB *)Rv1)[92]==12) {
          Ra.sl[16]=555; /* line # 555 */
          Rv0=P_lgt_new_econst(V_int_typ,((SL *)Rv1)[24]);
        }
        break;
        default:break;
      }
    }
    Ra.sl[16]=559; /* line # 559 */
    P_insymbol();
  }
  else {
    Ra.sl[16]=563; /* line # 563 */
    P_src_error(Rd.s+118,162,2);
  }
  Ra.sl[16]=565; /* line # 565 */
  if (F_lgt!=NULL) P_lgt_free(&F_lgt);
  Ra.sl[16]=566; /* line # 566 */
  if (Rv0!=NULL) Ret=Rv0;
  else {
    Ra.sl[16]=569; /* line # 569 */
    P_src_error(Rd.s+118,169,2);
    Ra.sl[16]=570; /* line # 570 */
    Ret=P_lgt_new_econst(V_typ_std.v[2],1);
  }
  PAS__curr_cntx=Ra.v[5];
  return(Ret);
}


/* Procedure/Function : " build_arg_list "  */
V PAS_COMILER_PRC_00000008(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+169;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=590; /* line # 590 */
  Rv0=F_pr;
  Ra.sl[6]=592; /* line # 592 */
  Rv1=NULL;
  Ra.sl[6]=593; /* line # 593 */
  Rv2=((V *)Rv0)[8];
  Ra.sl[6]=594; /* line # 594 */
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[6]=595; /* line # 595 */
    if (!((UB *)((V *)Rv0)[11])[91]) Rv2=((V *)Rv2)[3];
  }
  Ra.sl[6]=596; /* line # 596 */
  if (Rv2!=NULL) {
    Ra.sl[6]=598; /* line # 598 */
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+187,22,2);
    else {
      Ra.sl[6]=599; /* line # 599 */
      P_insymbol();
    }
    Ra.sl[6]=600; /* line # 600 */
    while (Rv2!=NULL){
      Ra.sl[6]=602; /* line # 602 */
      if (((UB *)Rv2)[56]==7) {
        Ra.sl[6]=604; /* line # 604 */
        Rv3=0;
        Ra.sl[6]=605; /* line # 605 */
        Rv4=((V *)Rv2)[9];
        Ra.sl[6]=606; /* line # 606 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=608; /* line # 608 */
          Rv5=P_ide_search(928);
          Ra.sl[6]=609; /* line # 609 */
          if (Rv5!=V_ide_udptr.v[5]) {
            Ra.sl[6]=612; /* line # 612 */
            Rv6=Rv5;
            Ra.sl[6]=614; /* line # 614 */
            if (((UB *)Rv6)[56]==5) {
              Ra.sl[6]=616; /* line # 616 */
              Rv7=NULL;
              Ra.sl[6]=617; /* line # 617 */
              if (((V *)Rv6)[4]!=NULL) {
                Ra.sl[6]=618; /* line # 618 */
                Rv8=((V *)Rv6)[4];
                Ra.sl[6]=619; /* line # 619 */
                if (((UB *)Rv8)[92]==6) Rv7=((V *)Rv8)[13];
              }
              Ra.sl[6]=620; /* line # 620 */
              if (Rv7!=NULL) {
                Ra.sl[6]=622; /* line # 622 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=623; /* line # 623 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else {
                    Ra.sl[6]=625; /* line # 625 */
                    P_src_error_s(Rd.s+187,120,3, V_sy_ident.s,NULL);
                  }
                }
              }
            }
            else {
              Ra.sl[6]=628; /* line # 628 */
              if (((UB *)Rv6)[56]==7) {
                Ra.sl[6]=630; /* line # 630 */
                Rv7=((V *)Rv6)[9];
                Ra.sl[6]=632; /* line # 632 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=633; /* line # 633 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else {
                    Ra.sl[6]=635; /* line # 635 */
                    P_src_error_s(Rd.s+187,121,3, V_sy_ident.s,NULL);
                  }
                }
              }
              else {
                Ra.sl[6]=639; /* line # 639 */
                Rv9=P_compare_proc_argid(((V *)Rv5)[10],((V *)Rv5)[11],Rv4);
                Ra.sl[6]=644; /* line # 644 */
                Rv9=((V *)Rv5)[10];
                Ra.sl[6]=646; /* line # 646 */
                while (Rv9!=NULL&&!Rv3){
                  Ra.sl[6]=647; /* line # 647 */
                  Rv10=Rv9;
                  Ra.sl[6]=649; /* line # 649 */
                  if (!((UB *)Rv10)[8]) {
                    Ra.sl[6]=651; /* line # 651 */
                    Rv7=((V *)Rv10)[2];
                    Ra.sl[6]=652; /* line # 652 */
                    Rv3=P_comp_proc_arg(Rv7, Rv4);
                  }
                  Ra.sl[6]=654; /* line # 654 */
                  Rv9=((V *)Rv10)[0];
                }
                Ra.sl[6]=656; /* line # 656 */
                if (!Rv3) P_src_error_s(Rd.s+187,122,3, V_sy_ident.s,((V *)Rv2)[
0]);
              }
            }
          }
          Ra.sl[6]=659; /* line # 659 */
          P_insymbol();
        }
        else {
          Ra.sl[6]=663; /* line # 663 */
          Rv7=((V *)Rv2)[8];
          Ra.sl[6]=664; /* line # 664 */
          if (Rv7==NULL) P_src_error_s(Rd.s+187,148,3,((V *)Rv2)[0],NULL);
          else {
            Ra.sl[6]=666; /* line # 666 */
            if (Rv4!=NULL) Rv3=P_comp_proc_arg(Rv7, Rv4);
            else {
              Ra.sl[6]=667; /* line # 667 */
              P_src_error_s(Rd.s+187,123,3,((V *)Rv2)[0],NULL);
            }
          }
        }
        Ra.sl[6]=670; /* line # 670 */
        if (Rv3) {
          Ra.sl[6]=672; /* line # 672 */
          P_lgt_new(&Rv11,((V *)Rv7)[11],11,NULL);
          Ra.sl[6]=673; /* line # 673 */
          ((V *)Rv11)[6]=Rv7;
          Ra.sl[6]=674; /* line # 674 */
          if (((V *)Rv7)[11]!=((V *)Rv4)[11]&&((V *)Rv4)[11]!=NULL) {
            Ra.sl[6]=675; /* line # 675 */
            if (!P_comp_type(((V *)Rv7)[11],((V *)Rv4)[11],1,0)) {
              Ra.sl[6]=676; /* line # 676 */
              P_src_error_s(Rd.s+187,124,3,((V *)Rv5)[0],((V *)Rv2)[0]);
            }
          }
        }
      }
      else {
        Ra.sl[6]=681; /* line # 681 */
        Rv11=PAS_COMILER_PRC_00000005(((V *)Rv2)[4],((UB *)Rv2)[94]!=8,0,0);
        Ra.sl[6]=682; /* line # 682 */
        Rv12=Rv11;
        Ra.sl[6]=683; /* line # 683 */
        if (((UB *)Rv12)[40]==17) {
          Ra.sl[6]=684; /* line # 684 */
          if (((V *)Rv2)[8]==NULL) {
            Ra.sl[6]=686; /* line # 686 */
            P_src_error_s(Rd.s+187,854,3,((V *)Rv2)[0],NULL);
          }
          else {
            Ra.sl[6]=689; /* line # 689 */
            ((UB *)Rv12)[40]=14;
            Ra.sl[6]=690; /* line # 690 */
            ((V *)Rv12)[3]=((V *)Rv2)[4];
            Ra.sl[6]=691; /* line # 691 */
            ((V *)Rv12)[7]=((V *)Rv2)[8];
            Ra.sl[6]=692; /* line # 692 */
            P_val_new(((V *)Rv12)+7,NULL);
            Ra.sl[6]=693; /* line # 693 */
            ((V *)Rv12)[4]=NULL;
          }
        }
      }
      Ra.sl[6]=698; /* line # 698 */
      if (Rv1!=NULL) ((V *)Rv13)[0]=Rv11;
      else {
        Ra.sl[6]=699; /* line # 699 */
        Rv1=Rv11;
      }
      Ra.sl[6]=700; /* line # 700 */
      Rv13=Rv11;
      Ra.sl[6]=702; /* line # 702 */
      Rv2=((V *)Rv2)[3];
      Ra.sl[6]=703; /* line # 703 */
      if (V_sy_sym.ub[0]==17) P_insymbol();
    }
    Ra.sl[6]=705; /* line # 705 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=706; /* line # 706 */
      P_src_error(Rd.s+187,23,3);
    }
  }
  Ra.sl[6]=709; /* line # 709 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_formal_proc "  */
V PAS_COMILER_PRC_00000009(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+191;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=725; /* line # 725 */
  Rv0=F_ip;
  Ra.sl[6]=727; /* line # 727 */
  switch (((UB *)Rv0)[56]) {
    case 7:Ra.sl[6]=729; /* line # 729 */
    Rv1=((V *)F_ip)[9];
    break;
    case 8:Ra.sl[6]=732; /* line # 732 */
    Rv1=((V *)((V *)Rv0)[10])[2];
    break;
    default:Ra.sl[6]=735; /* line # 735 */
    Rv1=NULL;
    break;
  }
  Ra.sl[6]=738; /* line # 738 */
  if (Rv1!=NULL) {
    Ra.sl[6]=739; /* line # 739 */
    Ra.sl[6]=741; /* line # 741 */
    Rv2=PAS_COMILER_PRC_00000008(Rv1);
    Ra.sl[6]=742; /* line # 742 */
    Rv2=P_lgt_new_call(((V *)Rv1)[11],Rv1, Rv2);
    Ra.sl[6]=743; /* line # 743 */
    P_call_setting(&Rv2);
  }
  else {
    Ra.sl[6]=747; /* line # 747 */
    P_src_error(Rd.s+211,998,3);
    Ra.sl[6]=748; /* line # 748 */
    Rv2=NULL;
  }
  Ra.sl[6]=750; /* line # 750 */
  if (Rv2==NULL) {
    Ra.sl[6]=752; /* line # 752 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    Ra.sl[6]=754; /* line # 754 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      Ra.sl[6]=756; /* line # 756 */
      P_src_error(Rd.s+211,73,3);
      Ra.sl[6]=757; /* line # 757 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=759; /* line # 759 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_indirect_proc "  */
V PAS_COMILER_PRC_00000010(V F_lge){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=773; /* line # 773 */
  Rv0=NULL;
  Ra.sl[6]=774; /* line # 774 */
  if (F_lge!=NULL) {
    Ra.sl[6]=775; /* line # 775 */
    Rv1=F_lge;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=777; /* line # 777 */
    Rv3=((V *)Rv2)[13];
    Ra.sl[6]=778; /* line # 778 */
    if (Rv3!=NULL) {
      Ra.sl[6]=779; /* line # 779 */
      Rv4=Rv3;
      Ra.sl[6]=781; /* line # 781 */
      ((V *)F_lge)[0]=PAS_COMILER_PRC_00000008(Rv3);
      Ra.sl[6]=782; /* line # 782 */
      P_lgt_new(&Rv0,((V *)Rv4)[11],7, F_lge);
      Ra.sl[6]=783; /* line # 783 */
      Rv5=Rv0;
      Ra.sl[6]=785; /* line # 785 */
      if (((V *)Rv4)[11]!=NULL) {
        Ra.sl[6]=787; /* line # 787 */
        if (!((UB *)((V *)Rv4)[11])[91]) {
          Ra.sl[6]=788; /* line # 788 */
          ((UW *)Rv5)[10]=((UW *)Rv5)[10]|4;
        }
      }
      else {
        Ra.sl[6]=790; /* line # 790 */
        ((V *)Rv0)[3]=V_typ_std.v[28];
      }
      Ra.sl[6]=791; /* line # 791 */
      ((V *)Rv5)[6]=Rv3;
    }
  }
  Ra.sl[6]=795; /* line # 795 */
  if (Rv0==NULL) {
    Ra.sl[6]=796; /* line # 796 */
    Rv0=P_lgt_new_econst(V_typ_std.v[21],0);
  }
  Ra.sl[6]=797; /* line # 797 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_generic "  */
V PAS_COMILER_PRC_00000011(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+235;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=813; /* line # 813 */
  Rv0=NULL;
  Ra.sl[6]=814; /* line # 814 */
  Rv1=0;
  Ra.sl[6]=815; /* line # 815 */
  Ra.sl[6]=818; /* line # 818 */
  if (V_sy_sym.ub[0]==13) {
    while (1){
      Ra.sl[6]=821; /* line # 821 */
      P_insymbol();
      Ra.sl[6]=822; /* line # 822 */
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=824; /* line # 824 */
      if (Rv0==NULL) Rv0=Rv2;
      else((V *)Rv3)[0]=Rv2;
      Ra.sl[6]=825; /* line # 825 */
      Rv3=Rv2;
      Ra.sl[6]=826; /* line # 826 */
      Rv1=Rv1+1;
      Ra.sl[6]=827; /* line # 827 */
      if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
        Ra.sl[6]=828; /* line # 828 */
        P_src_error(Rd.s+251,24,2);
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=830; /* line # 830 */
    P_insymbol();
  }
  Ra.sl[6]=832; /* line # 832 */
  Rv2=P_generate_call(F_ip, Rv0, Rv1,0);
  Ra.sl[6]=834; /* line # 834 */
  if (Rv2==NULL) {
    Ra.sl[6]=836; /* line # 836 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    Ra.sl[6]=838; /* line # 838 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      Ra.sl[6]=840; /* line # 840 */
      P_src_error(Rd.s+251,73,3);
      Ra.sl[6]=841; /* line # 841 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=843; /* line # 843 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " open_call "  */
V PAS_COMILER_PRC_00000012(SL F_ifnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+255;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=864; /* line # 864 */
  Rv0=NULL;
  Ra.sl[6]=865; /* line # 865 */
  Rv1=P_ide_search_from_nameid(V_iof_std_open);
  Ra.sl[6]=866; /* line # 866 */
  if (Rv1!=NULL) {
    Ra.sl[6]=867; /* line # 867 */
    Ra.sl[6]=869; /* line # 869 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[6]=870; /* line # 870 */
      P_src_error(Rd.s+268,22,2);
    }
    Ra.sl[6]=872; /* line # 872 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[16],0,0,0);
    Ra.sl[6]=874; /* line # 874 */
    Rv3=((V *)((V *)Rv2)[3])[12];
    Ra.sl[6]=875; /* line # 875 */
    if (((V *)Rv2)[3]==V_typ_std.v[7]) {
      Ra.sl[6]=876; /* line # 876 */
      Rv4=0;
    }
    else {
      Ra.sl[6]=879; /* line # 879 */
      if (Rv3!=NULL) Rv4=abs(((SL *)Rv3)[11]);
      Ra.sl[6]=880; /* line # 880 */
      if (Rv4==0) Rv4=1;
    }
    Ra.sl[6]=882; /* line # 882 */
    Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv4);
    Ra.sl[6]=883; /* line # 883 */
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=884; /* line # 884 */
    Rv6=2;
    Ra.sl[6]=886; /* line # 886 */
    switch (F_ifnc) {
      case 1:Ra.sl[6]=887; /* line # 887 */
      Rv7=1;
      break;
      case 2:Ra.sl[6]=888; /* line # 888 */
      Rv7=2;
      break;
      case 3:Ra.sl[6]=889; /* line # 889 */
      Rv7=6;
      break;
      default:Ra.sl[6]=891; /* line # 891 */
      Rv7=0;
      break;
    }
    Ra.sl[6]=893; /* line # 893 */
    if (Rv7!=0) {
      Ra.sl[6]=895; /* line # 895 */
      if (V_sy_sym.ub[0]==17) {
        Ra.sl[6]=897; /* line # 897 */
        P_insymbol();
        Ra.sl[6]=899; /* line # 899 */
        Rv8=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=900; /* line # 900 */
        ((V *)Rv5)[0]=Rv8;
        Ra.sl[6]=901; /* line # 901 */
        Rv5=Rv8;
        Ra.sl[6]=902; /* line # 902 */
        Rv6=Rv6+1;
      }
      Ra.sl[6]=904; /* line # 904 */
      Rv8=P_lgt_new_econst(V_typ_std.v[2],Rv7);
      Ra.sl[6]=905; /* line # 905 */
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=906; /* line # 906 */
      Rv5=Rv8;
      Ra.sl[6]=907; /* line # 907 */
      Rv6=Rv6+1;
    }
    Ra.sl[6]=910; /* line # 910 */
    while (V_sy_sym.ub[0]==17){
      Ra.sl[6]=912; /* line # 912 */
      P_insymbol();
      Ra.sl[6]=913; /* line # 913 */
      Rv8=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=914; /* line # 914 */
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=915; /* line # 915 */
      Rv5=Rv8;
      Ra.sl[6]=916; /* line # 916 */
      Rv6=Rv6+1;
    }
    Ra.sl[6]=918; /* line # 918 */
    Rv9=((V *)Rv1)[10];
    Ra.sl[6]=920; /* line # 920 */
    P_generic_search(((V *)Rv1)[0],Rv6, &Rv9, Rv2);
    Ra.sl[6]=921; /* line # 921 */
    if (Rv9!=NULL) {
      Rv10=Rv9;
      Ra.sl[6]=922; /* line # 922 */
      if (((V *)Rv10)[2]!=NULL) {
        Ra.sl[6]=924; /* line # 924 */
        Rv0=P_lgt_new_call(((V *)((V *)Rv10)[2])[11],((V *)Rv10)[2],Rv2);
        Ra.sl[6]=925; /* line # 925 */
        P_call_setting(&Rv0);
      }
    }
    Ra.sl[6]=928; /* line # 928 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=929; /* line # 929 */
      P_src_error(Rd.s+268,23,2);
    }
  }
  Ra.sl[6]=931; /* line # 931 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " readwrite_call "  */
V PAS_COMILER_PRC_00000013(V F_dfi, V F_psel, V F_pio1, V F_pio2, V F_peoln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+272;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=949; /* line # 949 */
  Rv0=NULL;
  Ra.sl[6]=950; /* line # 950 */
  Rv1=NULL;
  Ra.sl[6]=951; /* line # 951 */
  Rv2=0;
  Ra.sl[6]=952; /* line # 952 */
  V_sy_label_flag=0;
  Ra.sl[6]=954; /* line # 954 */
  Ra.sl[6]=956; /* line # 956 */
  Rv3=F_pio1;
  Ra.sl[6]=957; /* line # 957 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=959; /* line # 959 */
    Rv4=0;
    Ra.sl[6]=960; /* line # 960 */
    Rv5=1;
    Ra.sl[6]=961; /* line # 961 */
    Rv2=1;
    Ra.sl[6]=962; /* line # 962 */
    P_insymbol();
    Ra.sl[6]=963; /* line # 963 */
    Rv6=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=964; /* line # 964 */
    if (F_dfi==NULL) {
      Ra.sl[6]=966; /* line # 966 */
      Rv1=Rv6;
      Ra.sl[6]=967; /* line # 967 */
      Rv7=1;
      Ra.sl[6]=968; /* line # 968 */
      if (V_sy_sym.ub[0]==21) {
        Ra.sl[6]=970; /* line # 970 */
        Rv8=Rv1;
        Ra.sl[6]=971; /* line # 971 */
        while (V_sy_sym.ub[0]==21){
          Ra.sl[6]=973; /* line # 973 */
          P_insymbol();
          Ra.sl[6]=974; /* line # 974 */
          Rv9=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=975; /* line # 975 */
          ((V *)Rv8)[0]=Rv9;
          Ra.sl[6]=976; /* line # 976 */
          Rv8=Rv9;
          Ra.sl[6]=977; /* line # 977 */
          Rv7=Rv7+1;
        }
      }
      Ra.sl[6]=980; /* line # 980 */
      if (V_sy_sym.ub[0]==14) {
        Ra.sl[6]=982; /* line # 982 */
        Rv2=0;
        P_insymbol();
      }
      else {
        Ra.sl[6]=984; /* line # 984 */
        if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+290,29,2);
      }
      Ra.sl[6]=985; /* line # 985 */
      Rv5=0;
    }
    else {
      Ra.sl[6]=989; /* line # 989 */
      if (P_comp_type(((V *)Rv6)[3],V_typ_std.v[16],0,0)) {
        Ra.sl[6]=991; /* line # 991 */
        Rv1=Rv6;
        Ra.sl[6]=993; /* line # 993 */
        if (((V *)Rv1)[3]!=V_typ_std.v[7]) Rv3=F_pio2;
        Ra.sl[6]=995; /* line # 995 */
        if (V_sy_sym.ub[0]==14) {
          Ra.sl[6]=996; /* line # 996 */
          Rv2=0;
          P_insymbol();
        }
        else {
          Ra.sl[6]=998; /* line # 998 */
          if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+290,29,2);
        }
        Ra.sl[6]=1000; /* line # 1000 */
        Rv5=0;
      }
    }
  }
  else {
    Ra.sl[6]=1005; /* line # 1005 */
    if (F_dfi==NULL) P_src_error(Rd.s+290,22,2);
  }
  Ra.sl[6]=1007; /* line # 1007 */
  if (F_psel!=NULL) F_psel=P_ide_search_from_nameid(F_psel);
  Ra.sl[6]=1008; /* line # 1008 */
  if (Rv3!=NULL) Rv3=P_ide_search_from_nameid(Rv3);
  Ra.sl[6]=1009; /* line # 1009 */
  if (F_peoln!=NULL) F_peoln=P_ide_search_from_nameid(F_peoln);
  Ra.sl[6]=1011; /* line # 1011 */
  if (Rv1==NULL) Rv1=P_lgt_new_idref(F_dfi,NULL);
  Ra.sl[6]=1014; /* line # 1014 */
  Rv0=P_exp_genoper(((V *)F_psel)[0],((V *)F_psel)[10],Rv1);
  Ra.sl[6]=1015; /* line # 1015 */
  Rv8=Rv0;
  Ra.sl[6]=1017; /* line # 1017 */
  if (Rv2) {
    Ra.sl[6]=1019; /* line # 1019 */
    while (Rv5||V_sy_sym.ub[0]==17){
      Ra.sl[6]=1021; /* line # 1021 */
      if (!Rv5) {
        Ra.sl[6]=1023; /* line # 1023 */
        P_insymbol();
        Ra.sl[6]=1024; /* line # 1024 */
        Rv6=PAS_COMILER_PRC_00000000();
      }
      else {
        Ra.sl[6]=1026; /* line # 1026 */
        Rv5=0;
      }
      Ra.sl[6]=1027; /* line # 1027 */
      Rv10=NULL;
      Ra.sl[6]=1028; /* line # 1028 */
      Rv7=1;
      Ra.sl[6]=1029; /* line # 1029 */
      while (V_sy_sym.ub[0]==21){
        Ra.sl[6]=1031; /* line # 1031 */
        P_insymbol();
        Ra.sl[6]=1032; /* line # 1032 */
        Rv9=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=1033; /* line # 1033 */
        if (Rv10==NULL) Rv10=Rv9;
        else {
          Ra.sl[6]=1034; /* line # 1034 */
          ((V *)Rv11)[0]=Rv9;
        }
        Ra.sl[6]=1035; /* line # 1035 */
        Rv11=Rv9;
        Ra.sl[6]=1036; /* line # 1036 */
        Rv7=Rv7+1;
      }
      Ra.sl[6]=1038; /* line # 1038 */
      ((V *)Rv6)[0]=Rv10;
      Ra.sl[6]=1039; /* line # 1039 */
      Rv12=((V *)Rv3)[10];
      Ra.sl[6]=1041; /* line # 1041 */
      P_generic_search(((V *)Rv3)[0],Rv7, &Rv12, Rv6);
      Ra.sl[6]=1042; /* line # 1042 */
      if (Rv12!=NULL) {
        Rv13=Rv12;
        Ra.sl[6]=1044; /* line # 1044 */
        if (((V *)Rv13)[2]!=NULL) {
          Ra.sl[6]=1046; /* line # 1046 */
          Rv10=P_lgt_new_call(((V *)((V *)Rv13)[2])[11],((V *)Rv13)[2],Rv6);
          Ra.sl[6]=1047; /* line # 1047 */
          P_call_setting(&Rv10);
        }
        Ra.sl[6]=1049; /* line # 1049 */
        ((V *)Rv8)[0]=Rv10;
        Ra.sl[6]=1050; /* line # 1050 */
        Rv8=Rv10;
      }
    }
    Ra.sl[6]=1053; /* line # 1053 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=1054; /* line # 1054 */
      P_src_error(Rd.s+290,23,2);
    }
  }
  Ra.sl[6]=1058; /* line # 1058 */
  if (F_peoln!=NULL) {
    Ra.sl[6]=1060; /* line # 1060 */
    Rv12=((V *)F_peoln)[10];
    Ra.sl[6]=1062; /* line # 1062 */
    P_generic_search(((V *)F_peoln)[0],0, &Rv12,NULL);
    Ra.sl[6]=1063; /* line # 1063 */
    if (Rv12!=NULL) {
      Rv14=Rv12;
      Ra.sl[6]=1065; /* line # 1065 */
      if (((V *)Rv14)[2]!=NULL) {
        Ra.sl[6]=1067; /* line # 1067 */
        Rv10=P_lgt_new_call(((V *)((V *)Rv14)[2])[11],((V *)Rv14)[2],NULL);
        Ra.sl[6]=1068; /* line # 1068 */
        P_call_setting(&Rv10);
      }
      Ra.sl[6]=1070; /* line # 1070 */
      ((V *)Rv8)[0]=Rv10;
      Ra.sl[6]=1071; /* line # 1071 */
      Rv8=Rv10;
    }
  }
  Ra.sl[6]=1075; /* line # 1075 */
  if (Rv8!=Rv0) {
    Ra.sl[6]=1077; /* line # 1077 */
    P_lgt_new(&Rv0,NULL,0, Rv0);
    Ra.sl[6]=1078; /* line # 1078 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[6]=1080; /* line # 1080 */
  V_sy_label_flag=1;
  Ra.sl[6]=1081; /* line # 1081 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_state_eff_list "  */
V PAS_COMILER_PRC_00000015(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+294;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1105; /* line # 1105 */
  Rv0=NULL;
  Ra.sl[6]=1106; /* line # 1106 */
  Rv1=NULL;
  Ra.sl[6]=1107; /* line # 1107 */
  Lx[0].sl[0]=0;
  Ra.sl[6]=1108; /* line # 1108 */
  Ra.sl[6]=1110; /* line # 1110 */
  V_sy_sym.ub[0]=21;
  Ra.sl[6]=1111; /* line # 1111 */
  while (V_sy_sym.ub[0]==21){
    Ra.sl[6]=1113; /* line # 1113 */
    P_insymbol();
    Ra.sl[6]=1114; /* line # 1114 */
    Rv2=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=1115; /* line # 1115 */
    if (Rv1==NULL) Rv0=Rv2;
    else {
      Ra.sl[6]=1116; /* line # 1116 */
      ((V *)Rv1)[0]=Rv2;
    }
    Ra.sl[6]=1117; /* line # 1117 */
    Rv1=Rv2;
    Ra.sl[6]=1118; /* line # 1118 */
    Lx[0].sl[0]=Lx[0].sl[0]+1;
  }
  Ra.sl[6]=1121; /* line # 1121 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " user_state_call "  */
V PAS_COMILER_PRC_00000014(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  UB Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+314;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=1126; /* line # 1126 */
  Rv0=NULL;
  Ra.sl[8]=1127; /* line # 1127 */
  Rv1=NULL;
  Ra.sl[8]=1128; /* line # 1128 */
  Rv2=NULL;
  Ra.sl[8]=1129; /* line # 1129 */
  Rv3=NULL;
  Ra.sl[8]=1130; /* line # 1130 */
  Rv4=0;
  Ra.sl[8]=1131; /* line # 1131 */
  Rv5=0;
  Ra.sl[8]=1132; /* line # 1132 */
  Rv6=0;
  Ra.sl[8]=1133; /* line # 1133 */
  V_sy_label_flag=0;
  Ra.sl[8]=1134; /* line # 1134 */
  Rv7=((V *)F_ip)[8];
  Ra.sl[8]=1135; /* line # 1135 */
  Ra.sl[8]=1137; /* line # 1137 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[8]=1139; /* line # 1139 */
    Rv4=1;
    Ra.sl[8]=1140; /* line # 1140 */
    Rv3=PAS_COMILER_PRC_00000015();
  }
  Ra.sl[8]=1143; /* line # 1143 */
  while (Rv7!=NULL){
    Ra.sl[8]=1144; /* line # 1144 */
    Rv8=Rv7;
    Ra.sl[8]=1147; /* line # 1147 */
    if (((V *)Rv8)[2]==NULL||Rv3==NULL)  break;
    Ra.sl[8]=1149; /* line # 1149 */
    Rv5=P_comp_type(((V *)Rv3)[3],((V *)Rv8)[2],0,0);
    Ra.sl[8]=1150; /* line # 1150 */
    if (Rv5)  break;
    Ra.sl[8]=1152; /* line # 1152 */
    if (((V *)Rv8)[3]!=NULL)  break;
    Ra.sl[8]=1153; /* line # 1153 */
    Rv7=((V *)Rv8)[0];
  }
  Ra.sl[8]=1156; /* line # 1156 */
  if (Rv7==NULL) {
    Ra.sl[8]=1158; /* line # 1158 */
    P_src_error_s(Rd.s+333,41,3,((V *)F_ip)[0],NULL);
    Ra.sl[8]=1159; /* line # 1159 */
    P_skip_symbol(14,0,0);
    Ra.sl[8]=1160; /* line # 1160 */
    Ret=NULL;
  }
  else {
    Ra.sl[8]=1163; /* line # 1163 */
    Rv9=Rv7;
    Ra.sl[8]=1166; /* line # 1166 */
    if (((V *)Rv9)[4]!=NULL) Rv10=P_ide_search_from_nameid(((V *)Rv9)[4]);
    else {
      Ra.sl[8]=1167; /* line # 1167 */
      Rv10=NULL;
    }
    Ra.sl[8]=1168; /* line # 1168 */
    if (((V *)Rv9)[5]!=NULL) Rv11=P_ide_search_from_nameid(((V *)Rv9)[5]);
    else {
      Ra.sl[8]=1169; /* line # 1169 */
      Rv11=NULL;
    }
    Ra.sl[8]=1170; /* line # 1170 */
    if (((V *)Rv9)[6]!=NULL) Rv12=P_ide_search_from_nameid(((V *)Rv9)[6]);
    else {
      Ra.sl[8]=1171; /* line # 1171 */
      Rv12=NULL;
    }
    Ra.sl[8]=1174; /* line # 1174 */
    if (Rv4&&V_sy_sym.ub[0]==14) {
      Ra.sl[8]=1175; /* line # 1175 */
      P_insymbol();
      Rv4=0;
    }
    Ra.sl[8]=1177; /* line # 1177 */
    if (Rv5) {
      Ra.sl[8]=1179; /* line # 1179 */
      Rv2=Rv3;
      Ra.sl[8]=1180; /* line # 1180 */
      Rv13=Rv2;
      Ra.sl[8]=1181; /* line # 1181 */
      Rv3=NULL;
      Ra.sl[8]=1182; /* line # 1182 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+333,29,2);
    }
    else {
      Ra.sl[8]=1185; /* line # 1185 */
      if (((V *)Rv9)[3]!=NULL) {
        Ra.sl[8]=1187; /* line # 1187 */
        Ra.sl[0]=1;
        Ra.sl[8]=1188; /* line # 1188 */
        if (((UB *)Rv9)[8]) {
          ((UB *)Rv9)[8]=0;
          Rv13=((V *)Rv9)[3];
        }
        else {
          Ra.sl[8]=1189; /* line # 1189 */
          Rv13=P_lgt_link(((V *)Rv9)[3]);
        }
      }
      else {
        Ra.sl[8]=1192; /* line # 1192 */
        Ra.sl[0]=0;
        Rv13=NULL;
      }
    }
    Ra.sl[8]=1194; /* line # 1194 */
    if (Rv10!=NULL) {
      Ra.sl[8]=1196; /* line # 1196 */
      Rv0=P_generate_call(Rv10, Rv13, Ra.sl[0],0);
      Ra.sl[8]=1197; /* line # 1197 */
      Rv1=Rv0;
      Ra.sl[8]=1198; /* line # 1198 */
      if (Rv5) Rv6=1;
    }
    Ra.sl[8]=1202; /* line # 1202 */
    if (Rv4) {
      while (1){
        Ra.sl[8]=1206; /* line # 1206 */
        if (Rv3==NULL) Rv3=PAS_COMILER_PRC_00000015();
        Ra.sl[8]=1207; /* line # 1207 */
        if (((UB *)Rv9)[9]) {
          Ra.sl[8]=1209; /* line # 1209 */
          if (Rv5) {
            Ra.sl[8]=1210; /* line # 1210 */
            if (Rv6) Rv13=P_lgt_link(Rv2);
            else {
              Ra.sl[8]=1211; /* line # 1211 */
              Rv6=1;
              Rv13=Rv2;
            }
          }
          else {
            Ra.sl[8]=1213; /* line # 1213 */
            if (((UB *)Rv9)[8]) {
              ((UB *)Rv9)[8]=0;
              Rv13=((V *)Rv9)[3];
            }
            else {
              Ra.sl[8]=1214; /* line # 1214 */
              Rv13=P_lgt_link(((V *)Rv9)[3]);
            }
          }
          Ra.sl[8]=1215; /* line # 1215 */
          ((V *)Rv13)[0]=Rv3;
          Ra.sl[8]=1216; /* line # 1216 */
          Rv3=Rv13;
        }
        Ra.sl[8]=1219; /* line # 1219 */
        Rv13=P_generate_call(Rv11, Rv3, Ra.sl[0],0);
        Ra.sl[8]=1221; /* line # 1221 */
        if (Rv13!=NULL) {
          Ra.sl[8]=1223; /* line # 1223 */
          if (Rv1==NULL) Rv0=Rv13;
          else {
            Ra.sl[8]=1224; /* line # 1224 */
            ((V *)Rv1)[0]=Rv13;
          }
          Ra.sl[8]=1225; /* line # 1225 */
          Rv1=Rv13;
        }
        Ra.sl[8]=1227; /* line # 1227 */
        Rv3=NULL;
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[8]=1230; /* line # 1230 */
      if (V_sy_sym.ub[0]!=14) {
        Ra.sl[8]=1232; /* line # 1232 */
        P_src_error(Rd.s+333,34,3);
        Ra.sl[8]=1233; /* line # 1233 */
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[8]=1234; /* line # 1234 */
        P_insymbol();
      }
    }
    Ra.sl[8]=1237; /* line # 1237 */
    if (Rv12!=NULL) {
      Ra.sl[8]=1239; /* line # 1239 */
      if (((UB *)Rv9)[9]) {
        Ra.sl[8]=1241; /* line # 1241 */
        Ra.sl[0]=1;
        Ra.sl[8]=1242; /* line # 1242 */
        if (Rv5) {
          Ra.sl[8]=1243; /* line # 1243 */
          if (Rv6) Rv3=P_lgt_link(Rv2);
          else {
            Ra.sl[8]=1244; /* line # 1244 */
            Rv6=1;
            Rv3=Rv2;
          }
        }
        else {
          Ra.sl[8]=1246; /* line # 1246 */
          if (((UB *)Rv9)[8]) {
            ((UB *)Rv9)[8]=0;
            Rv3=((V *)Rv9)[3];
          }
          else {
            Ra.sl[8]=1247; /* line # 1247 */
            Rv3=P_lgt_link(((V *)Rv9)[3]);
          }
        }
      }
      else {
        Ra.sl[8]=1250; /* line # 1250 */
        Ra.sl[0]=0;
        Rv3=NULL;
      }
      Ra.sl[8]=1251; /* line # 1251 */
      Rv13=P_generate_call(Rv12, Rv3, Ra.sl[0],0);
      Ra.sl[8]=1252; /* line # 1252 */
      if (Rv1==NULL) Rv0=Rv13;
      else {
        Ra.sl[8]=1253; /* line # 1253 */
        ((V *)Rv1)[0]=Rv13;
      }
      Ra.sl[8]=1254; /* line # 1254 */
      Rv1=Rv13;
    }
  }
  Ra.sl[8]=1258; /* line # 1258 */
  if (Rv1!=Rv0) {
    Ra.sl[8]=1260; /* line # 1260 */
    P_lgt_new(&Rv0,NULL,0, Rv0);
    Ra.sl[8]=1261; /* line # 1261 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[8]=1264; /* line # 1264 */
  V_sy_label_flag=1;
  Ra.sl[8]=1265; /* line # 1265 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " new_call "  */
V PAS_COMILER_PRC_00000016(V F_new_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  SL Rv9;
  V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  V Rv16;
  V Rv17;
  SL Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+337;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1284; /* line # 1284 */
  Rv0=NULL;
  Ra.sl[6]=1285; /* line # 1285 */
  Rv1=NULL;
  Ra.sl[6]=1286; /* line # 1286 */
  Rv2=NULL;
  Ra.sl[6]=1287; /* line # 1287 */
  Rv3=NULL;
  Ra.sl[6]=1288; /* line # 1288 */
  Ra.sl[6]=1290; /* line # 1290 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[6]=1291; /* line # 1291 */
    P_src_error(Rd.s+349,22,2);
  }
  Ra.sl[6]=1293; /* line # 1293 */
  Rv4=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Ra.sl[6]=1294; /* line # 1294 */
  if (Rv4!=NULL) {
    Ra.sl[6]=1295; /* line # 1295 */
    Rv5=Rv4;
    Ra.sl[6]=1296; /* line # 1296 */
    if (2&((UW *)Rv5)[10]) {
      Ra.sl[6]=1297; /* line # 1297 */
      Rv6=((V *)Rv5)[3];
    }
  }
  Ra.sl[6]=1298; /* line # 1298 */
  if (Rv6!=NULL) {
    Ra.sl[6]=1299; /* line # 1299 */
    Rv7=Rv6;
    Ra.sl[6]=1300; /* line # 1300 */
    if (((UB *)Rv7)[92]==5) Rv3=((V *)Rv7)[12];
    else {
      Ra.sl[6]=1301; /* line # 1301 */
      Rv3=NULL;
    }
  }
  Ra.sl[6]=1303; /* line # 1303 */
  if (Rv3!=NULL) {
    Ra.sl[6]=1304; /* line # 1304 */
    Rv8=Rv3;
    Ra.sl[6]=1306; /* line # 1306 */
    Rv9=((SL *)Rv8)[11];
    Ra.sl[6]=1307; /* line # 1307 */
    if (((V *)Rv8)[4]!=NULL||((UB *)Rv8)[90]) {
      Ra.sl[6]=1313; /* line # 1313 */
      if (((V *)Rv8)[4]!=NULL) {
        Ra.sl[6]=1315; /* line # 1315 */
        Rv10=((V *)Rv8)[4];
        Ra.sl[6]=1316; /* line # 1316 */
        while (Rv10!=NULL){
          Ra.sl[6]=1318; /* line # 1318 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          Ra.sl[6]=1319; /* line # 1319 */
          Rv11=PAS_COMILER_PRC_00000005(((V *)Rv10)[4],0,0,0);
          Ra.sl[6]=1320; /* line # 1320 */
          if (((UB *)Rv11)[40]==17) {
            Ra.sl[6]=1321; /* line # 1321 */
            Rv12=Rv11;
            Ra.sl[6]=1323; /* line # 1323 */
            ((UB *)Rv12)[40]=14;
            Ra.sl[6]=1324; /* line # 1324 */
            ((V *)Rv12)[7]=((V *)Rv10)[11];
            Ra.sl[6]=1325; /* line # 1325 */
            if (((V *)Rv12)[7]==NULL) {
              Ra.sl[6]=1327; /* line # 1327 */
              P_src_error(Rd.s+349,126,3);
            }
            Ra.sl[6]=1328; /* line # 1328 */
            P_val_new(((V *)Rv12)+7,NULL);
            Ra.sl[6]=1329; /* line # 1329 */
            ((V *)Rv12)[4]=NULL;
            Ra.sl[6]=1330; /* line # 1330 */
            ((V *)Rv12)[3]=((V *)Rv10)[4];
          }
          Ra.sl[6]=1333; /* line # 1333 */
          if (((UB *)Rv11)[40]!=14) {
            Ra.sl[6]=1335; /* line # 1335 */
            P_lgt_new(&Rv13,((V *)Rv10)[4],13,NULL);
            Ra.sl[6]=1336; /* line # 1336 */
            ((V *)Rv13)[0]=Rv11;
            Ra.sl[6]=1337; /* line # 1337 */
            P_all_new(((V *)Rv13)+7,((V *)Rv10)[4],NULL,0);
            Ra.sl[6]=1338; /* line # 1338 */
            P_lgt_new(&Rv11,((V *)Rv10)[4],6, Rv13);
            Ra.sl[6]=1339; /* line # 1339 */
            ((UB *)Rv11)[41]=3;
            Ra.sl[6]=1341; /* line # 1341 */
            if (Rv0==NULL) Rv0=Rv11;
            else {
              Ra.sl[6]=1342; /* line # 1342 */
              ((V *)Rv14)[0]=Rv11;
            }
            Ra.sl[6]=1343; /* line # 1343 */
            Rv14=Rv11;
          }
          else {
            Ra.sl[6]=1345; /* line # 1345 */
            Rv13=Rv11;
          }
          Ra.sl[6]=1347; /* line # 1347 */
          Rv15=Rv10;
          Ra.sl[6]=1350; /* line # 1350 */
          ((V *)Rv15)[10]=Rv13;
          Ra.sl[6]=1351; /* line # 1351 */
          ((UB *)Rv15)[64]=2;
          Ra.sl[6]=1353; /* line # 1353 */
          P_lgt_new(&Rv16,((V *)Rv15)[4],2, P_lgt_link(Rv4));
          Ra.sl[6]=1354; /* line # 1354 */
          ((SL *)Rv16)[4]=((SL *)Rv15)[15];
          Ra.sl[6]=1355; /* line # 1355 */
          if (((UB *)Rv13)[40]==14) ((V *)Rv16)[0]=Rv13;
          else {
            Ra.sl[6]=1356; /* line # 1356 */
            ((V *)Rv16)[0]=P_lgt_link(Rv13);
          }
          Ra.sl[6]=1357; /* line # 1357 */
          P_lgt_new(&Rv13,((V *)Rv15)[4],6, Rv16);
          Ra.sl[6]=1358; /* line # 1358 */
          ((UB *)Rv13)[41]=3;
          Ra.sl[6]=1359; /* line # 1359 */
          if (Rv1==NULL) Rv1=Rv13;
          else {
            Ra.sl[6]=1360; /* line # 1360 */
            ((V *)Rv17)[0]=Rv13;
          }
          Ra.sl[6]=1361; /* line # 1361 */
          Rv17=Rv13;
          Ra.sl[6]=1365; /* line # 1365 */
          if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
            Ra.sl[6]=1366; /* line # 1366 */
            P_src_error(Rd.s+349,34,2);
          }
          Ra.sl[6]=1367; /* line # 1367 */
          Rv10=((V *)Rv10)[3];
        }
      }
      Ra.sl[6]=1370; /* line # 1370 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=1371; /* line # 1371 */
        P_src_error(Rd.s+349,24,2);
      }
      Ra.sl[6]=1378; /* line # 1378 */
      Rv11=P_lgt_type_compute(((V *)Rv8)[8],((V *)Rv8)[9],((SL *)Rv8)[11],NULL);
      Ra.sl[6]=1391; /* line # 1391 */
      if (((UB *)Rv8)[90]) P_init_d_dyn(Rv3, Rv4, &Rv1, &Rv17,1,NULL);
      Ra.sl[6]=1393; /* line # 1393 */
      Rv10=((V *)Rv8)[4];
      Ra.sl[6]=1395; /* line # 1395 */
      while (Rv10!=NULL){
        Ra.sl[6]=1397; /* line # 1397 */
        ((UB *)Rv10)[64]=0;
        Ra.sl[6]=1398; /* line # 1398 */
        ((V *)Rv10)[10]=NULL;
        Ra.sl[6]=1399; /* line # 1399 */
        Rv10=((V *)Rv10)[3];
      }
      Ra.sl[6]=1403; /* line # 1403 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      Ra.sl[6]=1406; /* line # 1406 */
      ((V *)Rv4)[0]=Rv2;
      Ra.sl[6]=1408; /* line # 1408 */
      P_lgt_new(&Rv2, Rv6,6, Rv4);
      Ra.sl[6]=1409; /* line # 1409 */
      ((UB *)Rv2)[41]=3;
      Ra.sl[6]=1412; /* line # 1412 */
      if (Rv0==NULL) Rv0=Rv2;
      else {
        Ra.sl[6]=1413; /* line # 1413 */
        ((V *)Rv14)[0]=Rv2;
      }
      Ra.sl[6]=1414; /* line # 1414 */
      ((V *)Rv2)[0]=Rv1;
      Ra.sl[6]=1415; /* line # 1415 */
      P_lgt_new(&Rv1,NULL,0, Rv0);
      Ra.sl[6]=1416; /* line # 1416 */
      ((UB *)Rv1)[41]=2;
    }
    else {
      Ra.sl[6]=1420; /* line # 1420 */
      Rv9=((SL *)Rv8)[11];
      Ra.sl[6]=1421; /* line # 1421 */
      if (Rv9<=0) P_src_error(Rd.s+349,130,3);
      Ra.sl[6]=1422; /* line # 1422 */
      if (((UB *)Rv8)[92]==10) {
        Ra.sl[6]=1424; /* line # 1424 */
        Rv11=((V *)Rv8)[14];
        Ra.sl[6]=1425; /* line # 1425 */
        if (Rv11!=NULL) {
          Ra.sl[6]=1426; /* line # 1426 */
          if (((UB *)Rv11)[40]==16) Rv11=((V *)Rv11)[1];
        }
        Ra.sl[6]=1427; /* line # 1427 */
        while (V_sy_sym.ub[0]==17&&Rv11!=NULL){
          Ra.sl[6]=1429; /* line # 1429 */
          Rv2=((V *)Rv11)[1];
          Ra.sl[6]=1430; /* line # 1430 */
          Rv16=((V *)Rv2)[0];
          Ra.sl[6]=1431; /* line # 1431 */
          P_insymbol();
          Ra.sl[6]=1433; /* line # 1433 */
          Rv13=PAS_COMILER_PRC_00000005(((V *)((V *)Rv16)[0])[3],0,0,0);
          Ra.sl[6]=1434; /* line # 1434 */
          Rv18=-1;
          Ra.sl[6]=1435; /* line # 1435 */
          Rv19=Rv13;
          Ra.sl[6]=1437; /* line # 1437 */
          if (((UB *)Rv19)[40]==14) {
            Ra.sl[6]=1438; /* line # 1438 */
            Rv18=((SL *)((V *)Rv19)[7])[13];
          }
          else {
            Ra.sl[6]=1440; /* line # 1440 */
            P_src_error(Rd.s+349,181,2);
          }
          Ra.sl[6]=1441; /* line # 1441 */
          P_lgt_free_tree(&Rv13);
          Ra.sl[6]=1443; /* line # 1443 */
          Rv20=Rv2;
          Rv21=((V *)Rv20)[7];
          Ra.sl[6]=1445; /* line # 1445 */
          Rv18=Rv18-((SL *)Rv20)[4];
          Ra.sl[6]=1446; /* line # 1446 */
          if (Rv18>=0&&Rv18<((SL *)Rv21)[6]) {
            Ra.sl[6]=1448; /* line # 1448 */
            Rv18=((SL *)((V *)((V *)Rv2)[7])[7])[Rv18];
            Ra.sl[6]=1449; /* line # 1449 */
            if (Rv18>=0) {
              Ra.sl[6]=1450; /* line # 1450 */
              Rv16=((V *)((V *)Rv16)[0])[0];
            }
            Ra.sl[6]=1451; /* line # 1451 */
            while (Rv18>0&&Rv16!=NULL){
              Ra.sl[6]=1453; /* line # 1453 */
              Rv18=Rv18-1;
              Ra.sl[6]=1454; /* line # 1454 */
              Rv16=((V *)Rv16)[0];
            }
            Ra.sl[6]=1456; /* line # 1456 */
            if (Rv16==NULL) Rv16=((V *)Rv2)[0];
          }
          Ra.sl[6]=1459; /* line # 1459 */
          Rv22=((V *)Rv16)[3];
          Ra.sl[6]=1461; /* line # 1461 */
          Rv11=((V *)Rv22)[14];
          Ra.sl[6]=1462; /* line # 1462 */
          Rv9=((SL *)Rv22)[11];
        }
      }
      Ra.sl[6]=1466; /* line # 1466 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=1467; /* line # 1467 */
        P_src_error(Rd.s+349,23,2);
        Ra.sl[6]=1468; /* line # 1468 */
        P_skip_symbol(14,0,0);
      }
      Ra.sl[6]=1471; /* line # 1471 */
      P_lgt_new(&Rv1, Rv6,6, Rv4);
      Ra.sl[6]=1472; /* line # 1472 */
      ((UB *)Rv1)[41]=3;
      Ra.sl[6]=1473; /* line # 1473 */
      Rv11=P_lgt_new_econst(V_typ_std.v[2],Rv9);
      Ra.sl[6]=1475; /* line # 1475 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      Ra.sl[6]=1476; /* line # 1476 */
      ((V *)Rv4)[0]=Rv2;
    }
  }
  else {
    Ra.sl[6]=1481; /* line # 1481 */
    P_lgt_free_tree(&Rv4);
    Ra.sl[6]=1482; /* line # 1482 */
    P_src_error(Rd.s+349,180,3);
  }
  Ra.sl[6]=1485; /* line # 1485 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dispose_call "  */
V PAS_COMILER_PRC_00000017(V F_free_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+353;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1498; /* line # 1498 */
  Ra.sl[6]=1500; /* line # 1500 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[6]=1501; /* line # 1501 */
    P_src_error(Rd.s+369,22,2);
  }
  Ra.sl[6]=1503; /* line # 1503 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Ra.sl[6]=1504; /* line # 1504 */
  Rv1=P_lgt_new_call(NULL,F_free_fnc, Rv0);
  Ra.sl[6]=1505; /* line # 1505 */
  if (V_sy_sym.ub[0]==17) P_skip_symbol(14,0,0);
  Ra.sl[6]=1506; /* line # 1506 */
  if (V_sy_sym.ub[0]==14) P_insymbol();
  else {
    Ra.sl[6]=1507; /* line # 1507 */
    P_src_error(Rd.s+369,23,2);
    Ra.sl[6]=1508; /* line # 1508 */
    P_skip_symbol(14,0,0);
  }
  Ra.sl[6]=1511; /* line # 1511 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_set "  */
V PAS_COMILER_PRC_00000018(V F_ty, UB F_bcte){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  UL Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+373;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1531; /* line # 1531 */
  Rv0=1;
  Ra.sl[6]=1532; /* line # 1532 */
  P_insymbol();
  Ra.sl[6]=1533; /* line # 1533 */
  Ra.sl[6]=1534; /* line # 1534 */
  if (V_sy_sym.ub[0]==16) {
    Ra.sl[6]=1536; /* line # 1536 */
    P_lgt_new(&Rv1, V_typ_std.v[19],14,NULL);
    Ra.sl[6]=1537; /* line # 1537 */
    if (F_ty!=NULL) ((V *)Rv1)[3]=F_ty;
    Ra.sl[6]=1538; /* line # 1538 */
    P_val_new(((V *)Rv1)+7,((V *)Rv1)[3]);
    Ra.sl[6]=1539; /* line # 1539 */
    Rv2=((V *)Rv1)[7];
    Ra.sl[6]=1541; /* line # 1541 */
    ((SL *)Rv2)[6]=0;
    Ra.sl[6]=1542; /* line # 1542 */
    ((UL *)Rv2)[13]=0;
  }
  else {
    Ra.sl[6]=1547; /* line # 1547 */
    Rv1=NULL;
    Ra.sl[6]=1548; /* line # 1548 */
    Rv3=NULL;
    Ra.sl[6]=1549; /* line # 1549 */
    Rv4=NULL;
    Ra.sl[6]=1550; /* line # 1550 */
    Rv5=0;
    Ra.sl[6]=1551; /* line # 1551 */
    Rv6=-1;
    Ra.sl[6]=1552; /* line # 1552 */
    Rv7=0;
    for( Rf0=(V_dst_seti-1)+1;Rf0>0;Rf0-- ) {
      Ra.ul[Rv7+7]=0;
      Rv7++;
    }
    Ra.sl[6]=1553; /* line # 1553 */
    Rv8=F_ty;
    Ra.sl[6]=1554; /* line # 1554 */
    Rv9=NULL;
    Ra.sl[6]=1555; /* line # 1555 */
    if (F_ty!=NULL) {
      Ra.sl[6]=1556; /* line # 1556 */
      Rv10=F_ty;
      Ra.sl[6]=1558; /* line # 1558 */
      Rv9=((V *)Rv10)[13];
      Ra.sl[6]=1559; /* line # 1559 */
      Rv11=((SL *)Rv10)[24];
    }
    while (1){
      Ra.sl[6]=1564; /* line # 1564 */
      if (Rv0) Rv0=0;
      else {
        Ra.sl[6]=1565; /* line # 1565 */
        P_insymbol();
      }
      Ra.sl[6]=1567; /* line # 1567 */
      if (Rv9==NULL) {
        Ra.sl[6]=1570; /* line # 1570 */
        Rv12=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
        Ra.sl[6]=1571; /* line # 1571 */
        if (((UB *)Rv12)[40]==17) {
          Ra.sl[6]=1573; /* line # 1573 */
          P_src_error(Rd.s+397,137,2);
          Ra.sl[6]=1574; /* line # 1574 */
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1578; /* line # 1578 */
          Rv9=((V *)Rv12)[3];
          Ra.sl[6]=1579; /* line # 1579 */
          if (Rv9!=NULL) {
            Ra.sl[6]=1581; /* line # 1581 */
            Rv11=-1;
            Ra.sl[6]=1582; /* line # 1582 */
            while (Rv9!=NULL&&Rv11<0){
              Ra.sl[6]=1583; /* line # 1583 */
              switch (((UB *)Rv9)[92]) {
                case 0:
                case 1:
                case 2:Ra.sl[6]=1584; /* line # 1584 */
                Rv11=((SL *)Rv9)[30];
                break;
                case 22:Ra.sl[6]=1585; /* line # 1585 */
                Rv9=((V *)Rv9)[0];
                break;
                default:Ra.sl[6]=1587; /* line # 1587 */
                P_src_error(Rd.s+397,110,2);
                Ra.sl[6]=1588; /* line # 1588 */
                Rv9=V_typ_std.v[2];
                Ra.sl[6]=1589; /* line # 1589 */
                Rv11=0;
                break;
              }
            }
            Ra.sl[6]=1591; /* line # 1591 */
            if (Rv11<0) P_src_error(Rd.s+397,110,2);
            else {
              Ra.sl[6]=1594; /* line # 1594 */
              if (Rv11>=V_dst_seta) Rv11=V_dst_seta-1;
            }
          }
          Ra.sl[6]=1596; /* line # 1596 */
          if (Rv11<0) Rv9=NULL;
          Ra.sl[6]=1599; /* line # 1599 */
          if (F_ty==NULL&&Rv9!=NULL) {
            Ra.sl[6]=1601; /* line # 1601 */
            if (Rv11<V_dst_setw) P_ide_new_typ(11, &Rv8);
            else {
              Ra.sl[6]=1602; /* line # 1602 */
              P_ide_new_typ(12, &Rv8);
            }
            Ra.sl[6]=1603; /* line # 1603 */
            Rv13=Rv8;
            Ra.sl[6]=1605; /* line # 1605 */
            ((V *)Rv13)[13]=Rv9;
            Ra.sl[6]=1606; /* line # 1606 */
            ((SL *)Rv13)[24]=Rv11+1;
            Ra.sl[6]=1607; /* line # 1607 */
            if (Rv11<V_dst_setw) {
              Ra.sl[6]=1608; /* line # 1608 */
              memcpy(Rv13+48,V_typ_std.v[17]+48,1);
            }
            else {
              Ra.sl[6]=1610; /* line # 1610 */
              memcpy(Rv13+48,V_typ_std.v[18]+48,1);
            }
            Ra.sl[6]=1612; /* line # 1612 */
            Rv14=((((SL *)Rv13)[24]+V_dst_setw)-1)/V_dst_setw;
            Ra.sl[6]=1614; /* line # 1614 */
            ((SL *)Rv13)[11]=(Rv14*V_dst_setw+7)/8;
          }
        }
      }
      else {
        Ra.sl[6]=1620; /* line # 1620 */
        Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
      }
      Ra.sl[6]=1622; /* line # 1622 */
      if (((UB *)Rv12)[40]==14) {
        Ra.sl[6]=1624; /* line # 1624 */
        Rv5=1;
        Ra.sl[6]=1625; /* line # 1625 */
        Rv14=P_lgt_get_econst(Rv12,-1);
        Ra.sl[6]=1626; /* line # 1626 */
        P_lgt_free(&Rv12);
        Ra.sl[6]=1627; /* line # 1627 */
        if (V_sy_sym.ub[0]==20) {
          Ra.sl[6]=1629; /* line # 1629 */
          P_insymbol();
          Ra.sl[6]=1630; /* line # 1630 */
          Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
          Ra.sl[6]=1631; /* line # 1631 */
          if (((UB *)Rv12)[40]!=14) {
            Ra.sl[6]=1633; /* line # 1633 */
            P_src_error(Rd.s+397,53,2);
            Ra.sl[6]=1634; /* line # 1634 */
            Rv15=Rv14;
          }
          else {
            Ra.sl[6]=1636; /* line # 1636 */
            Rv15=P_lgt_get_econst(Rv12, Rv14);
          }
          Ra.sl[6]=1637; /* line # 1637 */
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1638; /* line # 1638 */
          Rv15=Rv14;
        }
        Ra.sl[6]=1639; /* line # 1639 */
        if (((Rv14<0||Rv14>Rv11)||Rv15<Rv14)||Rv15>Rv11) {
          Ra.sl[6]=1641; /* line # 1641 */
          P_src_error(Rd.s+397,138,2);
          Ra.sl[6]=1642; /* line # 1642 */
          Rv15=Rv14-1;
        }
        Ra.sl[6]=1644; /* line # 1644 */
        Rv16=Rv14;
        for( Rf0=(Rv15+1)-Rv14;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1646; /* line # 1646 */
          if (Rv16>Rv6) Rv6=Rv16;
          Ra.sl[6]=1647; /* line # 1647 */
          Rv17=Rv16/V_dst_setw;
          Ra.sl[6]=1648; /* line # 1648 */
          Rv18=Rv16%V_dst_setw;
          Ra.sl[6]=1649; /* line # 1649 */
          if (1<<Rv18&Ra.ul[Rv17+7]) P_src_error(Rd.s+397,139,2);
          else {
            Ra.sl[6]=1650; /* line # 1650 */
            Ra.ul[Rv17+7]=Ra.ul[Rv17+7]|1<<Rv18;
          }
          Rv16++;
        }
      }
      else {
        Ra.sl[6]=1653; /* line # 1653 */
        if (((UB *)Rv12)[40]!=17) {
          Ra.sl[6]=1655; /* line # 1655 */
          if (F_bcte) P_src_error(Rd.s+397,140,3);
          Ra.sl[6]=1656; /* line # 1656 */
          if (((UB *)Rv8)[91]) {
            Ra.sl[6]=1658; /* line # 1658 */
            Rv12=P_lgt_new_code(16, Rv12);
            Ra.sl[6]=1659; /* line # 1659 */
            ((V *)Rv12)[3]=Rv8;
            Ra.sl[6]=1660; /* line # 1660 */
            if (Rv1!=NULL) {
              Ra.sl[6]=1662; /* line # 1662 */
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1663; /* line # 1663 */
              Rv1=P_lgt_new_code(14, Rv1);
              Ra.sl[6]=1664; /* line # 1664 */
              ((V *)Rv1)[3]=Rv8;
            }
            else {
              Ra.sl[6]=1666; /* line # 1666 */
              Rv1=Rv12;
            }
          }
          else {
            Ra.sl[6]=1670; /* line # 1670 */
            Rv12=P_lgt_new_call(Rv8, V_set_entry_proc, Rv12);
            Ra.sl[6]=1671; /* line # 1671 */
            P_call_setting(&Rv12);
            Ra.sl[6]=1672; /* line # 1672 */
            if (Rv1!=NULL) {
              Ra.sl[6]=1674; /* line # 1674 */
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1675; /* line # 1675 */
              Rv1=P_exp_genop(11, Rv1);
              Ra.sl[6]=1676; /* line # 1676 */
              ((V *)Rv1)[3]=Rv8;
            }
            else {
              Ra.sl[6]=1678; /* line # 1678 */
              Rv1=Rv12;
            }
          }
        }
        else {
          Ra.sl[6]=1683; /* line # 1683 */
          P_src_error(Rd.s+397,141,2);
          Ra.sl[6]=1684; /* line # 1684 */
          P_lgt_free(&Rv12);
        }
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=1688; /* line # 1688 */
    if (Rv5) {
      Ra.sl[6]=1690; /* line # 1690 */
      if ((Rv1==NULL&&Rv8!=NULL)&&F_ty==NULL) {
        Ra.sl[6]=1691; /* line # 1691 */
        Rv19=Rv8;
        Ra.sl[6]=1693; /* line # 1693 */
        ((SL *)Rv19)[24]=Rv6+1;
        Ra.sl[6]=1694; /* line # 1694 */
        Rv11=Rv6;
        Ra.sl[6]=1695; /* line # 1695 */
        if (Rv6>=V_dst_setw) {
          Ra.sl[6]=1697; /* line # 1697 */
          ((UB *)Rv19)[91]=0;
          Ra.sl[6]=1698; /* line # 1698 */
          ((UB *)Rv19)[92]=12;
          Ra.sl[6]=1699; /* line # 1699 */
          ((SL *)Rv19)[11]=(((((SL *)Rv19)[24]+V_dst_setw)-1)/V_dst_setw)*((SL *)
          V_typ_std.v[17])[11];
          Ra.sl[6]=1701; /* line # 1701 */
          ((UB *)Rv19)[48]=((UB *)V_typ_std.v[18])[48];
        }
        else {
          Ra.sl[6]=1705; /* line # 1705 */
          ((UB *)Rv19)[91]=1;
          Ra.sl[6]=1706; /* line # 1706 */
          ((UB *)Rv19)[92]=11;
          Ra.sl[6]=1707; /* line # 1707 */
          ((SL *)Rv19)[11]=(((SL *)Rv19)[24]+7)/8;
          Ra.sl[6]=1708; /* line # 1708 */
          switch (((SL *)Rv19)[11]) {
            case 1:Ra.sl[6]=1709; /* line # 1709 */
            ((UB *)Rv19)[48]=0;
            break;
            case 2:Ra.sl[6]=1710; /* line # 1710 */
            ((UB *)Rv19)[48]=1;
            break;
            default:Ra.sl[6]=1712; /* line # 1712 */
            ((SL *)Rv19)[11]=4;
            Ra.sl[6]=1713; /* line # 1713 */
            ((UB *)Rv19)[48]=((UB *)V_typ_std.v[17])[48];
            break;
          }
        }
      }
      Ra.sl[6]=1718; /* line # 1718 */
      if (Rv11<V_dst_setw) {
        Ra.sl[6]=1720; /* line # 1720 */
        Rv12=P_lgt_new_econst(Rv8, Ra.sl[7]);
      }
      else {
        Ra.sl[6]=1724; /* line # 1724 */
        P_lgt_new(&Rv12, Rv8,14,NULL);
        Ra.sl[6]=1725; /* line # 1725 */
        P_val_new(((V *)Rv12)+7,Rv8);
        Ra.sl[6]=1726; /* line # 1726 */
        Rv20=((V *)Rv12)[7];
        Ra.sl[6]=1728; /* line # 1728 */
        ((V *)Rv20)[7]=PAS__NEW(32);
        Ra.sl[6]=1729; /* line # 1729 */
        ((SL *)Rv20)[6]=(Rv6+V_dst_setw)/V_dst_setw;
        Ra.sl[6]=1730; /* line # 1730 */
        Rv21=0;
        for( Rf0=(((SL *)Rv20)[6]-1)+1;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1731; /* line # 1731 */
          ((SL *)((V *)Rv20)[7])[Rv21]=Ra.sl[Rv21+7];
          Rv21++;
        }
      }
    }
    Ra.sl[6]=1736; /* line # 1736 */
    if (Rv6>=0) {
      Ra.sl[6]=1737; /* line # 1737 */
      if (Rv1==NULL) {
        Ra.sl[6]=1738; /* line # 1738 */
        Rv1=Rv12;
      }
      else {
        Ra.sl[6]=1741; /* line # 1741 */
        ((V *)Rv12)[0]=Rv1;
        Ra.sl[6]=1742; /* line # 1742 */
        Rv1=P_exp_genop(11, Rv12);
        Ra.sl[6]=1743; /* line # 1743 */
        ((V *)Rv1)[3]=Rv8;
      }
    }
  }
  Ra.sl[6]=1746; /* line # 1746 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_tab "  */
void PAS_COMILER_PRC_00000020(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+401;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1778; /* line # 1778 */
  Ra.sl[6]=1780; /* line # 1780 */
  Rv0=F_ty;
  Ra.sl[6]=1782; /* line # 1782 */
  Rv1=((V *)Rv0)[15];
  Ra.sl[6]=1783; /* line # 1783 */
  Rv2=((V *)Rv0)[14];
  Ra.sl[6]=1786; /* line # 1786 */
  if (Rv1!=NULL) {
    Ra.sl[6]=1787; /* line # 1787 */
    Rv3=Rv1;
    Ra.sl[6]=1788; /* line # 1788 */
    if (((UB *)Rv3)[92]!=22) {
      Ra.sl[6]=1789; /* line # 1789 */
      if (((UB *)Rv3)[112]) {
        Ra.sl[6]=1790; /* line # 1790 */
        Lx[1].sl[0]=(((UL *)Rv3)[30]+1)-((UL *)Rv3)[29];
      }
      else {
        Ra.sl[6]=1792; /* line # 1792 */
        Lx[1].sl[0]=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1795; /* line # 1795 */
      Rv4=P_lgt_type_eval(((V *)Rv3)[12],NULL,NULL,0);
      Ra.sl[6]=1796; /* line # 1796 */
      if (((UB *)Rv4)[40]==14) {
        Ra.sl[6]=1798; /* line # 1798 */
        Lx[1].sl[0]=((SL *)((V *)Rv4)[7])[13];
        Ra.sl[6]=1799; /* line # 1799 */
        P_lgt_free(&Rv4);
      }
      else {
        Ra.sl[6]=1801; /* line # 1801 */
        P_src_error(Rd.s+425,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1803; /* line # 1803 */
    Lx[1].sl[0]=0;
  }
  Ra.sl[6]=1804; /* line # 1804 */
  Rv5=F_ty;
  Ra.sl[6]=1805; /* line # 1805 */
  if (((V *)Rv5)[13]!=NULL) {
    Ra.sl[6]=1807; /* line # 1807 */
    Rv4=P_lgt_type_eval(((V *)Rv5)[13],NULL,NULL,0);
    Ra.sl[6]=1808; /* line # 1808 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=1810; /* line # 1810 */
      Lx[1].sl[1]=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=1811; /* line # 1811 */
      P_lgt_free(&Rv4);
    }
    else {
      Ra.sl[6]=1813; /* line # 1813 */
      P_src_error(Rd.s+425,142,4);
    }
  }
  else {
    Ra.sl[6]=1815; /* line # 1815 */
    Lx[1].sl[1]=((SL *)Rv5)[25];
  }
  Ra.sl[6]=1817; /* line # 1817 */
  if (Rv2==NULL) Lx[1].sl[0]=0;
  Ra.sl[6]=1819; /* line # 1819 */
  Rv6=0;
  Ra.sl[6]=1820; /* line # 1820 */
  V_sy_sym.ub[0]=17;
  Ra.sl[6]=1821; /* line # 1821 */
  while (Rv6<Lx[1].sl[0]&&V_sy_sym.ub[0]==17){
    Ra.sl[6]=1823; /* line # 1823 */
    P_insymbol();
    Ra.sl[6]=1824; /* line # 1824 */
    Rv6=Rv6+1;
    Ra.sl[6]=1825; /* line # 1825 */
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1827; /* line # 1827 */
      Rv4=PAS_COMILER_PRC_00000019(((V *)F_ty)[14]);
    }
    else {
      Ra.sl[6]=1829; /* line # 1829 */
      Rv4=PAS_COMILER_PRC_00000005(((V *)F_ty)[14],0,0,0);
    }
    Ra.sl[6]=1830; /* line # 1830 */
    if (((UB *)Rv4)[40]!=14) Lx[1].ub[8]=0;
    Ra.sl[6]=1832; /* line # 1832 */
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv4;
    else {
      Ra.sl[6]=1833; /* line # 1833 */
      ((V *)Lx[1].v[3])[0]=Rv4;
    }
    Ra.sl[6]=1834; /* line # 1834 */
    Lx[1].v[3]=Rv4;
  }
  Ra.sl[6]=1836; /* line # 1836 */
  if (Rv6<Lx[1].sl[0]) {
    Ra.sl[6]=1837; /* line # 1837 */
    P_src_error(Rd.s+425,144,3);
  }
  else {
    Ra.sl[6]=1839; /* line # 1839 */
    if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
      Ra.sl[6]=1841; /* line # 1841 */
      P_src_error(Rd.s+425,146,2);
      Ra.sl[6]=1842; /* line # 1842 */
      P_skip_symbol(Lx[1].ub[32],0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_list_agregat_rec "  */
void PAS_COMILER_PRC_00000021(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+429;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1861; /* line # 1861 */
  Rv0=F_ty;
  Ra.sl[6]=1863; /* line # 1863 */
  V_sy_sym.ub[0]=17;
  Ra.sl[6]=1864; /* line # 1864 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1866; /* line # 1866 */
  while (V_sy_sym.ub[0]==17&&Rv1!=NULL){
    Ra.sl[6]=1868; /* line # 1868 */
    P_insymbol();
    Ra.sl[6]=1869; /* line # 1869 */
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1871; /* line # 1871 */
      Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[4]);
    }
    else {
      Ra.sl[6]=1874; /* line # 1874 */
      Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[4],0,0,0);
    }
    Ra.sl[6]=1876; /* line # 1876 */
    if (((UB *)Rv2)[40]!=14) Lx[1].ub[8]=0;
    Ra.sl[6]=1878; /* line # 1878 */
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
    else {
      Ra.sl[6]=1879; /* line # 1879 */
      ((V *)Lx[1].v[3])[0]=Rv2;
    }
    Ra.sl[6]=1880; /* line # 1880 */
    Lx[1].v[3]=Rv2;
    Ra.sl[6]=1881; /* line # 1881 */
    if (Rv1==((V *)Rv0)[13]) Rv1=NULL;
    else {
      Ra.sl[6]=1882; /* line # 1882 */
      Rv1=((V *)Rv1)[3];
    }
  }
  Ra.sl[6]=1886; /* line # 1886 */
  Rv3=((V *)Rv0)[14];
  Ra.sl[6]=1887; /* line # 1887 */
  if (Rv3!=NULL) {
    Ra.sl[6]=1888; /* line # 1888 */
    if (((UB *)Rv3)[40]==16) Rv3=((V *)Rv3)[1];
  }
  Ra.sl[6]=1890; /* line # 1890 */
  if (Rv3==NULL) {
    Ra.sl[6]=1892; /* line # 1892 */
    if (Rv1!=NULL) {
      Ra.sl[6]=1893; /* line # 1893 */
      P_src_error(Rd.s+453,144,3);
    }
    else {
      Ra.sl[6]=1895; /* line # 1895 */
      if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
        Ra.sl[6]=1897; /* line # 1897 */
        P_src_error(Rd.s+453,146,2);
        Ra.sl[6]=1898; /* line # 1898 */
        P_skip_symbol(Lx[1].ub[32],0,0);
      }
    }
    Ra.sl[6]=1900; /* line # 1900 */
    goto Ret_Label;
  }
  Ra.sl[6]=1903; /* line # 1903 */
  Rv4=Rv3;
  Ra.sl[6]=1905; /* line # 1905 */
  Rv5=((V *)Rv4)[1];
  Ra.sl[6]=1906; /* line # 1906 */
  Rv6=((V *)Rv5)[0];
  Ra.sl[6]=1907; /* line # 1907 */
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1908; /* line # 1908 */
  Rv8=Rv5;
  Ra.sl[6]=1910; /* line # 1910 */
  Rv9=((SL *)Rv8)[4];
  Ra.sl[6]=1911; /* line # 1911 */
  if (((V *)Rv8)[7]!=NULL) {
    Ra.sl[6]=1912; /* line # 1912 */
    Rv10=((V *)Rv8)[7];
    Ra.sl[6]=1914; /* line # 1914 */
    Rv11=(((SL *)Rv10)[6]+Rv9)-1;
    Ra.sl[6]=1915; /* line # 1915 */
    Rv12=((V *)Rv10)[7];
  }
  else {
    Ra.sl[6]=1917; /* line # 1917 */
    Rv12=NULL;
  }
  Ra.sl[6]=1919; /* line # 1919 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1921; /* line # 1921 */
    Rv2=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1922; /* line # 1922 */
    Rv13=Rv2;
    Ra.sl[6]=1923; /* line # 1923 */
    if (((UB *)Rv13)[40]!=14) P_src_error(Rd.s+453,142,3);
    else {
      Ra.sl[6]=1925; /* line # 1925 */
      if (((V *)Rv13)[7]!=NULL) Rv14=((SL *)((V *)Rv13)[7])[13];
      else {
        Ra.sl[6]=1926; /* line # 1926 */
        Rv14=Rv9-1;
      }
    }
    Ra.sl[6]=1927; /* line # 1927 */
    P_lgt_free(&Rv2);
  }
  else {
    Ra.sl[6]=1931; /* line # 1931 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else {
      Ra.sl[6]=1932; /* line # 1932 */
      P_src_error(Rd.s+453,29,3);
    }
    Ra.sl[6]=1934; /* line # 1934 */
    Rv14=PAS_COMILER_PRC_00000006(((V *)Rv7)+3);
    Ra.sl[6]=1935; /* line # 1935 */
    if (((V *)Rv7)[4]!=NULL) {
      Ra.sl[6]=1937; /* line # 1937 */
      Rv15=((SL *)((V *)Rv7)[4])[15];
      Ra.sl[6]=1938; /* line # 1938 */
      Rv2=P_lgt_new_econst(((V *)Rv7)[3],Rv14);
      Ra.sl[6]=1940; /* line # 1940 */
      ((SL *)Rv2)[4]=Rv15;
      Ra.sl[6]=1942; /* line # 1942 */
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
      else {
        Ra.sl[6]=1943; /* line # 1943 */
        ((V *)Lx[1].v[3])[0]=Rv2;
      }
      Ra.sl[6]=1944; /* line # 1944 */
      Lx[1].v[3]=Rv2;
    }
  }
  Ra.sl[6]=1948; /* line # 1948 */
  Rv16=((V *)Rv7)[0];
  Ra.sl[6]=1949; /* line # 1949 */
  if (Rv14<Rv9||Rv14>Rv11) {
    Ra.sl[6]=1950; /* line # 1950 */
    Rv16=Rv6;
  }
  else {
    Ra.sl[6]=1953; /* line # 1953 */
    Rv14=((SL *)Rv12)[(Rv14-Rv9)];
    Ra.sl[6]=1954; /* line # 1954 */
    if (Rv14<0) Rv16=Rv6;
    else {
      Ra.sl[6]=1957; /* line # 1957 */
      while (Rv14>0&&Rv16!=NULL){
        Ra.sl[6]=1959; /* line # 1959 */
        Rv16=((V *)Rv16)[0];
        Rv14=Rv14-1;
      }
      Ra.sl[6]=1961; /* line # 1961 */
      if (Rv16==NULL) Rv16=Rv6;
    }
  }
  Ra.sl[6]=1964; /* line # 1964 */
  if (Rv16!=NULL) {
    Ra.sl[6]=1965; /* line # 1965 */
    if (((V *)Rv16)[3]!=NULL) PAS_COMILER_PRC_00000021(((V *)Rv16)[3]);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_agregate "  */
V PAS_COMILER_PRC_00000019(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+457;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=1973; /* line # 1973 */
  Rv0=F_ty;
  Ra.sl[16]=1974; /* line # 1974 */
  if (((UB *)Rv0)[92]==11||((UB *)Rv0)[92]==12) {
    Ra.sl[16]=1976; /* line # 1976 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+473,25,2);
    Ra.sl[16]=1977; /* line # 1977 */
    Rv1=PAS_COMILER_PRC_00000018(F_ty,0);
    Ra.sl[16]=1978; /* line # 1978 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else {
      Ra.sl[16]=1979; /* line # 1979 */
      P_src_error(Rd.s+473,26,2);
    }
  }
  else {
    Ra.sl[16]=1982; /* line # 1982 */
    if (((UB *)Rv0)[91]) {
      Ra.sl[16]=1983; /* line # 1983 */
      P_src_error(Rd.s+473,131,3);
    }
    else {
      Ra.sl[16]=1986; /* line # 1986 */
      Ra.ub[8]=1;
      Ra.sl[16]=1987; /* line # 1987 */
      Rv1=NULL;
      Ra.sl[16]=1988; /* line # 1988 */
      Ra.v[2]=NULL;
      Ra.sl[16]=1989; /* line # 1989 */
      Ra.v[3]=NULL;
      Ra.sl[16]=1990; /* line # 1990 */
      if (V_sy_sym.ub[0]==13) Ra.ub[32]=14;
      else {
        Ra.sl[16]=1991; /* line # 1991 */
        Ra.ub[32]=16;
      }
      Ra.sl[16]=1992; /* line # 1992 */
      Rv2=((SL *)Rv0)[11];
      Ra.sl[16]=1993; /* line # 1993 */
      Rv3=0;
      Ra.sl[16]=1994; /* line # 1994 */
      V_sy_sym.ub[0]=17;
      Ra.sl[16]=1996; /* line # 1996 */
      if (((V *)Rv0)[4]!=NULL) {
        Ra.sl[16]=1998; /* line # 1998 */
        Rv4=((V *)Rv0)[4];
        Ra.sl[16]=1999; /* line # 1999 */
        if (((UB *)Rv0)[89]) {
          Ra.sl[16]=2002; /* line # 2002 */
          P_type_parm_cte_init(F_ty, Ra.v+2,Ra.v+3,&Rv3);
        }
        else while (1){
          Ra.sl[16]=2032; /* line # 2032 */
          P_insymbol();
          Ra.sl[16]=2033; /* line # 2033 */
          Rv5=Rv4;
          Ra.sl[16]=2035; /* line # 2035 */
          Rv6=((V *)Rv5)[4];
          Ra.sl[16]=2037; /* line # 2037 */
          Rv7=PAS_COMILER_PRC_00000005(Rv6,0,0,0);
          Ra.sl[16]=2038; /* line # 2038 */
          Rv8=Rv7;
          Ra.sl[16]=2040; /* line # 2040 */
          if (((UB *)Rv8)[40]==17) {
            Ra.sl[16]=2042; /* line # 2042 */
            ((UB *)Rv8)[40]=14;
            Ra.sl[16]=2043; /* line # 2043 */
            ((V *)Rv8)[7]=((V *)Rv5)[11];
            Ra.sl[16]=2045; /* line # 2045 */
            if (((V *)Rv8)[7]==NULL) P_src_error_s(Rd.s+473,157,3,((V *)Rv4)[0],
            NULL);
            Ra.sl[16]=2046; /* line # 2046 */
            P_val_new(((V *)Rv8)+7,Rv6);
            Ra.sl[16]=2047; /* line # 2047 */
            ((V *)Rv8)[4]=NULL;
            Ra.sl[16]=2048; /* line # 2048 */
            ((V *)Rv8)[3]=Rv6;
          }
          else {
            Ra.sl[16]=2051; /* line # 2051 */
            if (((UB *)Rv8)[40]!=14) P_src_error(Rd.s+473,132,3);
          }
          Ra.sl[16]=2052; /* line # 2052 */
          ((SL *)Rv8)[4]=((SL *)Rv5)[15];
          Ra.sl[16]=2056; /* line # 2056 */
          ((V *)Rv5)[10]=Rv7;
          Ra.sl[16]=2057; /* line # 2057 */
          ((UB *)Rv5)[64]=1;
          Ra.sl[16]=2059; /* line # 2059 */
          if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
          else {
            Ra.sl[16]=2060; /* line # 2060 */
            ((V *)Ra.v[3])[0]=Rv7;
          }
          Ra.sl[16]=2061; /* line # 2061 */
          Ra.v[3]=Rv7;
          Ra.sl[16]=2063; /* line # 2063 */
          Rv4=((V *)Rv4)[3];
          Ra.sl[16]=2064; /* line # 2064 */
          Rv3=Rv3+1;
          if (Rv4==NULL||V_sy_sym.ub[0]!=17)  break;
        }
      }
      Ra.sl[16]=2070; /* line # 2070 */
      if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
        Ra.sl[16]=2072; /* line # 2072 */
        Rv9=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
        Ra.sl[16]=2073; /* line # 2073 */
        if (((UB *)Rv9)[40]==14) {
          Ra.sl[16]=2075; /* line # 2075 */
          Rv2=((SL *)((V *)Rv9)[7])[13];
          Ra.sl[16]=2076; /* line # 2076 */
          P_lgt_free(&Rv9);
        }
        else {
          Ra.sl[16]=2077; /* line # 2077 */
          P_src_error(Rd.s+473,142,3);
        }
      }
      Ra.sl[16]=2081; /* line # 2081 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+473,29,2);
      Ra.sl[16]=2083; /* line # 2083 */
      switch (((UB *)Rv0)[92]) {
        case 11:
        case 12:Ra.sl[16]=2086; /* line # 2086 */
        if (V_sy_sym.ub[0]==13) P_src_error(Rd.s+473,133,2);
        Ra.sl[16]=2087; /* line # 2087 */
        Rv7=PAS_COMILER_PRC_00000018(F_ty,0);
        Ra.sl[16]=2088; /* line # 2088 */
        if (((UB *)Rv7)[40]!=14) Ra.ub[8]=0;
        Ra.sl[16]=2090; /* line # 2090 */
        if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
        else {
          Ra.sl[16]=2091; /* line # 2091 */
          ((V *)Ra.v[3])[0]=Rv7;
        }
        Ra.sl[16]=2092; /* line # 2092 */
        Ra.v[3]=Rv7;
        break;
        case 10:
        case 23:Ra.sl[16]=2096; /* line # 2096 */
        PAS_COMILER_PRC_00000021(F_ty);
        break;
        case 8:Ra.sl[16]=2099; /* line # 2099 */
        PAS_COMILER_PRC_00000020(F_ty);
        break;
        default:Ra.sl[16]=2102; /* line # 2102 */
        P_src_error(Rd.s+473,131,3);
        Ra.sl[16]=2103; /* line # 2103 */
        P_skip_symbol(Ra.ub[32],0,0);
        break;
      }
      Ra.sl[16]=2106; /* line # 2106 */
      if (V_sy_sym.ub[0]==Ra.ub[32]) P_insymbol();
      else {
        Ra.sl[16]=2107; /* line # 2107 */
        P_src_error(Rd.s+473,26,2);
      }
      Ra.sl[16]=2109; /* line # 2109 */
      if (((V *)Rv0)[4]!=NULL) P_type_parm_cte_release(F_ty);
      Ra.sl[16]=2125; /* line # 2125 */
      if (Ra.ub[8]) {
        Ra.sl[16]=2127; /* line # 2127 */
        P_lgt_new(&Rv1, F_ty,14,NULL);
        Ra.sl[16]=2128; /* line # 2128 */
        switch (((UB *)F_ty)[92]) {
          case 8:
          case 9:
          case 10:Ra.sl[16]=2131; /* line # 2131 */
          P_val_new(((V *)Rv1)+7,F_ty);
          Ra.sl[16]=2132; /* line # 2132 */
          ((V *)((V *)Rv1)[7])[7]=NULL;
          Ra.sl[16]=2133; /* line # 2133 */
          Rv10=NULL;
          Ra.sl[16]=2134; /* line # 2134 */
          Rv11=Rv1;
          Rv12=((V *)Rv11)[7];
          Ra.sl[16]=2136; /* line # 2136 */
          ((SL *)Rv12)[2]=Rv3;
          Ra.sl[16]=2137; /* line # 2137 */
          ((SL *)Rv12)[6]=Rv2;
          Ra.sl[16]=2138; /* line # 2138 */
          while (Ra.v[2]!=NULL){
            Ra.sl[16]=2139; /* line # 2139 */
            Ra.sl[16]=2141; /* line # 2141 */
            Rv7=Ra.v[2];
            Ra.sl[16]=2142; /* line # 2142 */
            Rv13=NULL;
            Ra.sl[16]=2143; /* line # 2143 */
            P_val_copy(((V *)Rv7)+7,&Rv13,1);
            Ra.sl[16]=2144; /* line # 2144 */
            if (Rv10==NULL) ((V *)((V *)Rv1)[7])[7]=Rv13;
            else {
              Ra.sl[16]=2145; /* line # 2145 */
              ((V *)Rv10)[0]=Rv13;
            }
            Ra.sl[16]=2146; /* line # 2146 */
            if (((UB *)F_ty)[92]!=10) {
              Ra.sl[16]=2148; /* line # 2148 */
              if (Rv3>0) Rv3=Rv3-1;
              else {
                Ra.sl[16]=2149; /* line # 2149 */
                if (((UB *)Rv13)[48]==29) ((SL *)Rv13)[6]=Ra.sl[1]-V_stri_stroffset;
                else {
                  Ra.sl[16]=2150; /* line # 2150 */
                  ((SL *)Rv13)[6]=Ra.sl[1];
                }
              }
            }
            Ra.sl[16]=2151; /* line # 2151 */
            Rv10=Rv13;
            Ra.sl[16]=2152; /* line # 2152 */
            Ra.v[2]=((V *)Ra.v[2])[0];
            Ra.sl[16]=2153; /* line # 2153 */
            ((V *)Rv7)[7]=NULL;
            Ra.sl[16]=2154; /* line # 2154 */
            P_lgt_free(&Rv7);
          }
          break;
          default:Ra.sl[16]=2160; /* line # 2160 */
          P_val_copy(((V *)Ra.v[2])+7,((V *)Rv1)+7,1);
          Ra.sl[16]=2161; /* line # 2161 */
          ((SL *)((V *)Rv1)[7])[2]=Rv3;
          break;
        }
      }
      else {
        Ra.sl[16]=2167; /* line # 2167 */
        P_src_error(Rd.s+473,143,3);
        Ra.sl[16]=2168; /* line # 2168 */
        P_lgt_free_tree(Ra.v+2);
        Ra.sl[16]=2169; /* line # 2169 */
        Rv1=P_lgt_new_econst(V_typ_std.v[21],0);
      }
    }
  }
  Ra.sl[16]=2172; /* line # 2172 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " exp_const_set "  */
V PAS_COMILER_PRC_00000022(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+477;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2185; /* line # 2185 */
  Rv0=PAS_COMILER_PRC_00000018(NULL,0);
  Ra.sl[6]=2186; /* line # 2186 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else {
    Ra.sl[6]=2187; /* line # 2187 */
    P_src_error(Rd.s+494,26,2);
  }
  Ra.sl[6]=2188; /* line # 2188 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_procref "  */
V PAS_COMILER_PRC_00000023(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+498;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2201; /* line # 2201 */
  Rv0=NULL;
  Ra.sl[6]=2202; /* line # 2202 */
  Rv1=Lx[5].v[13];
  Ra.sl[6]=2203; /* line # 2203 */
  while (Rv1!=NULL&&Rv0==NULL){
    Ra.sl[6]=2204; /* line # 2204 */
    switch (((UB *)Rv1)[104]) {
      case 5:
      case 8:
      case 9:
      case 10:Ra.sl[6]=2206; /* line # 2206 */
      Rv0=Rv1;
      break;
      case 4:Ra.sl[6]=2208; /* line # 2208 */
      Rv1=((V *)Rv1)[14];
      break;
      default:Ra.sl[6]=2211; /* line # 2211 */
      P_src_error(Rd.s+513,171,3);
      Ra.sl[6]=2212; /* line # 2212 */
      Rv1=NULL;
      break;
    }
  }
  Ra.sl[6]=2214; /* line # 2214 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_generic_ref "  */
V PAS_COMILER_PRC_00000024(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+517;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2234; /* line # 2234 */
  Rv0=NULL;
  Ra.sl[6]=2235; /* line # 2235 */
  P_insymbol();
  Ra.sl[6]=2236; /* line # 2236 */
  Ra.sl[6]=2237; /* line # 2237 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2239; /* line # 2239 */
    Rv1=P_ide_search(898);
    Ra.sl[6]=2240; /* line # 2240 */
    if (Rv1!=V_ide_udptr.v[1]) {
      Ra.sl[6]=2241; /* line # 2241 */
      Rv2=Rv1;
      Ra.sl[6]=2243; /* line # 2243 */
      P_insymbol();
      Ra.sl[6]=2244; /* line # 2244 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=2245; /* line # 2245 */
        P_src_error(Rd.s+536,26,2);
      }
      Ra.sl[6]=2246; /* line # 2246 */
      switch (((UB *)Rv2)[56]) {
        case 1:
        case 8:
        case 9:Ra.sl[6]=2249; /* line # 2249 */
        Rv3=((V *)Rv2)[10];
        Ra.sl[6]=2250; /* line # 2250 */
        while (Rv3!=NULL&&!P_comp_proc_arg(((V *)Rv3)[2],((V *)F_ty)[13]))
        Rv3=((V *)Rv3)[0];
        Ra.sl[6]=2251; /* line # 2251 */
        if (Rv3==NULL) Rv0=NULL;
        else {
          Ra.sl[6]=2252; /* line # 2252 */
          Rv0=((V *)Rv3)[2];
        }
        Ra.sl[6]=2253; /* line # 2253 */
        if (((SL *)Rv0)[18]>1) P_src_error_s(Rd.s+536,401,2,((V *)Rv2)[0],NULL);
        break;
        case 7:Ra.sl[6]=2257; /* line # 2257 */
        if (P_comp_proc_arg(((V *)Rv2)[9],((V *)F_ty)[13])) Rv0=((V *)Rv2)[9];
        else {
          Ra.sl[6]=2258; /* line # 2258 */
          Rv0=NULL;
        }
        break;
        default:break;
      }
      Ra.sl[6]=2262; /* line # 2262 */
      if (Rv0!=NULL) {
        Ra.sl[6]=2264; /* line # 2264 */
        P_lgt_new(&Rv4, F_ty,10,NULL);
        Ra.sl[6]=2265; /* line # 2265 */
        ((V *)Rv4)[6]=Rv0;
      }
    }
  }
  Ra.sl[6]=2269; /* line # 2269 */
  if (Rv0==NULL) {
    Ra.sl[6]=2271; /* line # 2271 */
    P_src_error(Rd.s+536,402,3);
    Ra.sl[6]=2272; /* line # 2272 */
    Rv4=P_lgt_new_econst(V_typ_std.v[13],0);
  }
  Ra.sl[6]=2274; /* line # 2274 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_identifier "  */
V PAS_COMILER_PRC_00000025(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register UB Rv17;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+540;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2291; /* line # 2291 */
  Ra.sl[6]=2293; /* line # 2293 */
  if (V_sy_sym.ub[0]==77) {
    Ra.sl[6]=2295; /* line # 2295 */
    Rv0=PAS_COMILER_PRC_00000023();
    Ra.sl[6]=2296; /* line # 2296 */
    if (Rv0!=NULL) {
      Ra.sl[6]=2297; /* line # 2297 */
      if (((V *)Rv0)[11]!=NULL) {
        Ra.sl[6]=2298; /* line # 2298 */
        if (!((UB *)((V *)Rv0)[11])[91]) {
          Ra.sl[6]=2300; /* line # 2300 */
          P_insymbol();
          Ra.sl[6]=2301; /* line # 2301 */
          V_lastsymb=V_sy_sym.ub[0];
          Ra.sl[6]=2302; /* line # 2302 */
          V_sy_search=((V *)Rv0)[8];
          Ra.sl[6]=2303; /* line # 2303 */
          V_sy_sym.ub[0]=0;
        }
      }
    }
    Ra.sl[6]=2305; /* line # 2305 */
    if (V_sy_sym.ub[0]==77) {
      Ra.sl[6]=2307; /* line # 2307 */
      P_src_error(Rd.s+558,190,3);
      Ra.sl[6]=2308; /* line # 2308 */
      P_insymbol();
    }
  }
  Ra.sl[6]=2312; /* line # 2312 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2314; /* line # 2314 */
    if (V_sy_search==NULL) {
      Ra.sl[6]=2316; /* line # 2316 */
      Rv1=P_ide_search(1014);
      Ra.sl[6]=2318; /* line # 2318 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=2322; /* line # 2322 */
      Rv1=V_sy_search;
      Ra.sl[6]=2323; /* line # 2323 */
      V_sy_sym.ub[0]=V_lastsymb;
      Ra.sl[6]=2324; /* line # 2324 */
      V_sy_search=NULL;
    }
    Ra.sl[6]=2327; /* line # 2327 */
    if (Rv1!=NULL) {
      Ra.sl[6]=2329; /* line # 2329 */
      Rv2=Rv1;
      Ra.sl[6]=2330; /* line # 2330 */
      switch (((UB *)Rv2)[56]) {
        case 1:Ra.sl[6]=2333; /* line # 2333 */
        if (Rv1==V_ide_udptr.v[1]) {
          Ra.sl[6]=2335; /* line # 2335 */
          Rv3=P_lgt_new_econst(V_typ_std.v[21],0);
        }
        else {
          Ra.sl[6]=2337; /* line # 2337 */
          switch (V_sy_sym.ub[0]) {
            case 24:Ra.sl[6]=2338; /* line # 2338 */
            Rv3=PAS_COMILER_PRC_00000007(NULL,((V *)Rv2)[4]);
            break;
            case 13:Ra.sl[6]=2340; /* line # 2340 */
            if (((V *)Rv2)[10]!=NULL) Rv3=PAS_COMILER_PRC_00000011(Rv1,1);
            else {
              Ra.sl[6]=2341; /* line # 2341 */
              Rv3=PAS_COMILER_PRC_00000019(((V *)Rv2)[4]);
            }
            break;
            case 15:Ra.sl[6]=2343; /* line # 2343 */
            if (((V *)Rv2)[4]!=NULL) {
              Ra.sl[6]=2344; /* line # 2344 */
              if (((UB *)((V *)Rv2)[4])[92]==6) Rv3=PAS_COMILER_PRC_00000024(((V
               *)Rv2)[4]);
              else {
                Ra.sl[6]=2345; /* line # 2345 */
                Rv3=PAS_COMILER_PRC_00000019(((V *)Rv2)[4]);
              }
            }
            break;
            default:Ra.sl[6]=2347; /* line # 2347 */
            P_src_error(Rd.s+558,36,3);
            break;
          }
        }
        break;
        case 7:
        case 8:Ra.sl[6]=2352; /* line # 2352 */
        Rv3=PAS_COMILER_PRC_00000009(Rv1,1);
        break;
        case 9:Ra.sl[6]=2355; /* line # 2355 */
        Rv3=PAS_COMILER_PRC_00000011(Rv1,1);
        break;
        case 2:Ra.sl[6]=2359; /* line # 2359 */
        switch (((UB *)Rv2)[64]) {
          case 2:Ra.sl[6]=2361; /* line # 2361 */
          if (((V *)Rv2)[11]!=NULL) {
            Ra.sl[6]=2363; /* line # 2363 */
            P_lgt_new(&Rv3,((V *)Rv2)[4],14,NULL);
            Ra.sl[6]=2364; /* line # 2364 */
            Rv4=Rv3;
            Ra.sl[6]=2366; /* line # 2366 */
            ((V *)Rv4)[7]=((V *)Rv2)[11];
            Ra.sl[6]=2367; /* line # 2367 */
            P_val_new(((V *)Rv4)+7,((V *)Rv2)[4]);
          }
          else {
            Ra.sl[6]=2372; /* line # 2372 */
            Rv3=PAS_COMILER_PRC_00000005(((V *)Rv2)[4],0,0,0);
          }
          break;
          case 0:Ra.sl[6]=2376; /* line # 2376 */
          P_lgt_new(&Rv3,((V *)Rv2)[4],13,NULL);
          Ra.sl[6]=2377; /* line # 2377 */
          if (((V *)Rv2)[9]==NULL) ((V *)Rv2)[9]=Rv3;
          Ra.sl[6]=2381; /* line # 2381 */
          ((V *)Rv2)[10]=NULL;
          Ra.sl[6]=2382; /* line # 2382 */
          Rv5=Rv3;
          Ra.sl[6]=2384; /* line # 2384 */
          ((V *)Rv5)[6]=Rv1;
          Ra.sl[6]=2385; /* line # 2385 */
          ((UW *)Rv5)[10]=1;
          break;
          case 3:Ra.sl[6]=2390; /* line # 2390 */
          Rv6=(V_lex_ident_tree.s+V_ident_disp*64);
          Ra.sl[6]=2391; /* line # 2391 */
          if (((UB *)Rv6)[24]==1) {
            Ra.sl[6]=2393; /* line # 2393 */
            P_lgt_new_copy(((V *)Rv6)[2],&Rv3);
            Ra.sl[6]=2394; /* line # 2394 */
            Rv7=Rv3;
            Ra.sl[6]=2396; /* line # 2396 */
            ((V *)Rv7)[3]=((V *)Rv2)[4];
            Ra.sl[6]=2397; /* line # 2397 */
            ((SL *)Rv7)[4]=((SL *)Rv7)[4]+((SL *)Rv2)[15];
          }
          else {
            Ra.sl[6]=2402; /* line # 2402 */
            P_lgt_new_copy(((V *)Rv6)[2],&Rv3);
            Ra.sl[6]=2403; /* line # 2403 */
            P_lgt_new(&Rv3,((V *)Rv2)[4],2, Rv3);
            Ra.sl[6]=2404; /* line # 2404 */
            ((SL *)Rv3)[4]=((SL *)Rv2)[15];
            Ra.sl[6]=2405; /* line # 2405 */
            if (((SL *)Rv6)[13]>=0) {
              Ra.sl[6]=2406; /* line # 2406 */
              ((SL *)Rv6)[13]=((SL *)Rv6)[13]+1;
            }
            else {
              Ra.sl[6]=2408; /* line # 2408 */
              Rv8=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
              Ra.sl[6]=2409; /* line # 2409 */
              ((SL *)Rv8)[13]=((SL *)Rv8)[13]+1;
            }
          }
          break;
          default:break;
        }
        Ra.sl[6]=2414; /* line # 2414 */
        ((V *)Rv3)[4]=Rv1;
        Ra.sl[6]=2415; /* line # 2415 */
        ((UW *)Rv3)[10]=1;
        break;
        case 5:Ra.sl[6]=2421; /* line # 2421 */
        Rv3=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=2422; /* line # 2422 */
        Rv9=Rv3;
        Ra.sl[6]=2424; /* line # 2424 */
        if (((SL *)Lx[5].v[13])[18]>=((SL *)Rv2)[10]) {
          Ra.sl[6]=2425; /* line # 2425 */
          ((UW *)Rv2)[46]=((UW *)Rv2)[46]|4;
        }
        Ra.sl[6]=2427; /* line # 2427 */
        switch (((UB *)Rv2)[94]) {
          case 1:
          case 2:
          case 3:
          case 6:Ra.sl[6]=2434; /* line # 2434 */
          if ((((UB *)((V *)Rv2)[4])[89]||((UB *)((V *)Rv2)[4])[90])&&!(16&((UW *)
          Rv2)[46])) {
            Ra.sl[6]=2436; /* line # 2436 */
            P_init_d_varbl(Rv1);
          }
          Ra.sl[6]=2440; /* line # 2440 */
          if (((((UB *)Rv2)[94]==1&&((SL *)Rv2)[10]>1)&&((V *)Rv2)[8]!=NULL)&&!(
8&((UW *)Rv2)[46])) {
            Ra.sl[6]=2444; /* line # 2444 */
            P_initialize_varbl(Rv1);
          }
          break;
          case 10:Ra.sl[6]=2450; /* line # 2450 */
          ((V *)Rv9)[3]=V_typ_std.v[13];
          Ra.sl[6]=2451; /* line # 2451 */
          ((UW *)Rv9)[10]=1;
          break;
          default:break;
        }
        Ra.sl[6]=2458; /* line # 2458 */
        ((V *)Rv3)[4]=Rv1;
        break;
        case 4:Ra.sl[6]=2463; /* line # 2463 */
        Rv3=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=2464; /* line # 2464 */
        ((V *)Rv3)[4]=Rv1;
        break;
        case 6:Ra.sl[6]=2468; /* line # 2468 */
        Rv10=(V_lex_ident_tree.s+V_ident_disp*64);
        Ra.sl[6]=2470; /* line # 2470 */
        P_lgt_new_copy(((V *)Rv10)[2],&Rv3);
        Ra.sl[6]=2471; /* line # 2471 */
        if (((UB *)Rv10)[24]==1) {
          Ra.sl[6]=2473; /* line # 2473 */
          if (((SL *)((V *)Rv3)[3])[10]>0) V_curr_descr=Rv3;
          Ra.sl[6]=2474; /* line # 2474 */
          P_lgt_new(&Rv3,((V *)Rv2)[4],3, Rv3);
          Ra.sl[6]=2475; /* line # 2475 */
          ((SL *)Rv3)[4]=((SL *)Rv2)[15];
        }
        else {
          Ra.sl[6]=2479; /* line # 2479 */
          Rv11=Rv3;
          Ra.sl[6]=2480; /* line # 2480 */
          if (((UB *)((V *)Rv11)[3])[92]==24) {
            Ra.sl[6]=2482; /* line # 2482 */
            Rv12=((V *)((V *)((V *)Rv11)[3])[0])[3];
            Ra.sl[6]=2483; /* line # 2483 */
            ((V *)Rv11)[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv2)[15]);
            Ra.sl[6]=2484; /* line # 2484 */
            if (Rv12!=NULL) {
              Ra.sl[6]=2485; /* line # 2485 */
              Rv3=P_exp_genoper(((V *)Rv12)[0],((V *)Rv12)[10],Rv3);
            }
            else {
              Ra.sl[6]=2487; /* line # 2487 */
              P_src_error(Rd.s+558,998,3);
            }
            Ra.sl[6]=2488; /* line # 2488 */
            ((V *)Rv3)[3]=((V *)Rv2)[4];
          }
          else {
            Ra.sl[6]=2492; /* line # 2492 */
            P_lgt_new(&Rv3,((V *)((V *)Rv3)[3])[12],2, Rv3);
            Ra.sl[6]=2493; /* line # 2493 */
            if (((SL *)((V *)Rv3)[3])[10]>0) V_curr_descr=Rv3;
            Ra.sl[6]=2494; /* line # 2494 */
            Ra.sl[6]=2495; /* line # 2495 */
            P_lgt_new(&Rv3,((V *)Rv2)[4],3, Rv3);
            Ra.sl[6]=2496; /* line # 2496 */
            ((SL *)Rv3)[4]=((SL *)Rv2)[15];
          }
          Ra.sl[6]=2498; /* line # 2498 */
          if (((SL *)Rv10)[13]>=0) {
            Ra.sl[6]=2499; /* line # 2499 */
            ((SL *)Rv10)[13]=((SL *)Rv10)[13]+1;
          }
          else {
            Ra.sl[6]=2501; /* line # 2501 */
            Rv13=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
            Ra.sl[6]=2502; /* line # 2502 */
            ((SL *)Rv13)[13]=((SL *)Rv13)[13]+1;
          }
        }
        Ra.sl[6]=2504; /* line # 2504 */
        Rv14=Rv3;
        Ra.sl[6]=2506; /* line # 2506 */
        ((UW *)Rv14)[10]=((UW *)((V *)Rv10)[2])[10]|4;
        Ra.sl[6]=2507; /* line # 2507 */
        ((V *)Rv14)[4]=Rv1;
        break;
      }
    }
    else {
      Ra.sl[6]=2514; /* line # 2514 */
      P_src_error(Rd.s+558,107,3);
      Ra.sl[6]=2515; /* line # 2515 */
      Rv3=P_lgt_new_econst(V_typ_std.v[21],0);
    }
  }
  else {
    Ra.sl[6]=2520; /* line # 2520 */
    switch (V_sy_sym.ub[0]) {
      case 27:Ra.sl[6]=2521; /* line # 2521 */
      Rv3=P_lgt_new_econst(V_typ_std.v[13],0);
      break;
      case 2:Ra.sl[6]=2522; /* line # 2522 */
      Rv3=P_lgt_new_econst(V_typ_std.v[2],V_sy_ival);
      break;
      case 3:Ra.sl[6]=2525; /* line # 2525 */
      Rv3=P_lgt_new_econst(V_typ_std.v[3],0);
      Ra.sl[6]=2526; /* line # 2526 */
      ((G *)((V *)Rv3)[7])[7]=V_sy_rval;
      break;
      case 4:Ra.sl[6]=2530; /* line # 2530 */
      Rv3=P_lgt_new_econst(V_typ_std.v[4],0);
      Ra.sl[6]=2531; /* line # 2531 */
      ((G *)((V *)Rv3)[7])[7]=V_sy_rval;
      break;
      case 5:Ra.sl[6]=2535; /* line # 2535 */
      Rv3=P_lgt_new_econst(V_typ_std.v[0],(SL)V_sy_string.c[2]);
      Ra.sl[6]=2537; /* line # 2537 */
      if (V_sy_string.ub[1]!=1) {
        Ra.sl[6]=2538; /* line # 2538 */
        Rv15=Rv3;
        Rv16=((V *)Rv15)[7];
        Ra.sl[6]=2541; /* line # 2541 */
        ((V *)Rv15)[3]=V_typ_std.v[10];
        Ra.sl[6]=2542; /* line # 2542 */
        ((UB *)Rv16)[48]=29;
        Ra.sl[6]=2543; /* line # 2543 */
        ((SL *)Rv16)[6]=V_sy_string.ub[1];
        Ra.sl[6]=2544; /* line # 2544 */
        ((V *)Rv16)[4]=((V *)Rv15)[3];
        Ra.sl[6]=2545; /* line # 2545 */
        if (V_sy_string.ub[1]>0) {
          Ra.sl[6]=2547; /* line # 2547 */
          Rv17=V_sy_string.ub[1];
          ((V *)Rv16)[7]=PAS__NEW((SL)Rv17+2);
          ((UB *)((V *)Rv16)[7])[0]=Rv17;
          Ra.sl[6]=2548; /* line # 2548 */
          PAS__STR_TO_STR(((V *)Rv16)[7],V_sy_string.s);
        }
        else {
          Ra.sl[6]=2550; /* line # 2550 */
          ((V *)Rv16)[7]=NULL;
        }
      }
      break;
      default:Ra.sl[6]=2555; /* line # 2555 */
      if (Ri.ub[0]) P_src_error(Rd.s+558,44,2);
      Ra.sl[6]=2556; /* line # 2556 */
      P_lgt_new(&Rv3, V_typ_std.v[21],17,NULL);
      break;
    }
    Ra.sl[6]=2560; /* line # 2560 */
    if (((UB *)Rv3)[40]!=17) P_insymbol();
  }
  Ra.sl[6]=2563; /* line # 2563 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_indir "  */
V PAS_COMILER_PRC_00000026(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+562;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2576; /* line # 2576 */
  Rv0=F_pobj;
  Ra.sl[6]=2577; /* line # 2577 */
  Rv1=((V *)F_pobj)[3];
  Ra.sl[6]=2579; /* line # 2579 */
  switch (((UB *)Rv1)[92]) {
    case 7:Ra.sl[6]=2582; /* line # 2582 */
    ((V *)F_pobj)[3]=V_typ_std.v[13];
    Ra.sl[6]=2583; /* line # 2583 */
    P_lgt_new(&Rv0, V_typ_std.v[13],2, F_pobj);
    Ra.sl[6]=2584; /* line # 2584 */
    Rv2=Rv0;
    ((UW *)Rv2)[10]=((UW *)Rv2)[10]|4;
    Ra.sl[6]=2585; /* line # 2585 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, Rv0);
    break;
    case 5:Ra.sl[6]=2590; /* line # 2590 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, F_pobj);
    break;
    case 6:Ra.sl[6]=2596; /* line # 2596 */
    Rv0=PAS_COMILER_PRC_00000010(F_pobj);
    break;
    default:Ra.sl[6]=2600; /* line # 2600 */
    P_src_error(Rd.s+575,151,3);
    break;
  }
  Ra.sl[6]=2602; /* line # 2602 */
  if (((UB *)Rv1)[92]!=6) {
    Ra.sl[6]=2603; /* line # 2603 */
    Rv3=Rv0;
    ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
  }
  Ra.sl[6]=2605; /* line # 2605 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_field "  */
V PAS_COMILER_PRC_00000027(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+579;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2621; /* line # 2621 */
  Rv0=0;
  Ra.sl[6]=2622; /* line # 2622 */
  Rv1=NULL;
  Ra.sl[6]=2623; /* line # 2623 */
  Rv2=0;
  Ra.sl[6]=2624; /* line # 2624 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2626; /* line # 2626 */
    Rv3=F_pobj;
    Rv4=((V *)Rv3)[3];
    Ra.sl[6]=2628; /* line # 2628 */
    if (((V *)Rv4)[4]!=NULL) {
      Ra.sl[6]=2630; /* line # 2630 */
      Rv1=P_level_search(((V *)Rv4)[4]);
      Ra.sl[6]=2631; /* line # 2631 */
      if (Rv1!=NULL) {
        Ra.sl[6]=2632; /* line # 2632 */
        Rv5=Rv1;
        Ra.sl[6]=2634; /* line # 2634 */
        if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
        Ra.sl[6]=2635; /* line # 2635 */
        Rv2=((SL *)Rv5)[15];
      }
    }
    Ra.sl[6]=2639; /* line # 2639 */
    if (Rv1==NULL) {
      Ra.sl[6]=2640; /* line # 2640 */
      if (((UB *)Rv4)[92]!=10) {
        Ra.sl[6]=2642; /* line # 2642 */
        F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
        Ra.sl[6]=2643; /* line # 2643 */
        P_src_error(Rd.s+592,152,3);
        Ra.sl[6]=2644; /* line # 2644 */
        Rv0=1;
      }
      else {
        Ra.sl[6]=2648; /* line # 2648 */
        Rv1=P_level_search(((V *)Rv4)[12]);
        Ra.sl[6]=2649; /* line # 2649 */
        if (Rv1!=NULL) {
          Ra.sl[6]=2650; /* line # 2650 */
          Rv6=Rv1;
          Ra.sl[6]=2652; /* line # 2652 */
          if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
          Ra.sl[6]=2653; /* line # 2653 */
          Rv2=((SL *)Rv6)[15];
        }
        else Ra.sl[6]=2656; /* line # 2656 */
      }
    }
    Ra.sl[6]=2658; /* line # 2658 */
    if (Rv1!=NULL) {
      Ra.sl[6]=2659; /* line # 2659 */
      Rv7=Rv1;
      Ra.sl[6]=2661; /* line # 2661 */
      if (Rv2!=0&&V_curr_descr==F_pobj) {
        Ra.sl[6]=2662; /* line # 2662 */
        if (((UB *)Rv3)[40]==14) {
          P_lgt_new_copy(F_pobj, &F_pobj);
          ((V *)F_pobj)[3]=((V *)Rv7)[4];
        }
        else {
          Ra.sl[6]=2664; /* line # 2664 */
          P_lgt_new(&F_pobj,((V *)Rv7)[4],3, F_pobj);
          Ra.sl[6]=2665; /* line # 2665 */
          ((UW *)F_pobj)[10]=((UW *)((V *)F_pobj)[1])[10];
        }
      }
      else {
        Ra.sl[6]=2668; /* line # 2668 */
        Rv2=((SL *)Rv3)[4]+Rv2;
        ((V *)Rv3)[3]=((V *)Rv7)[4];
      }
      Ra.sl[6]=2669; /* line # 2669 */
      ((SL *)F_pobj)[4]=((SL *)Rv3)[4]+Rv2;
    }
    else {
      Ra.sl[6]=2673; /* line # 2673 */
      F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
      Ra.sl[6]=2674; /* line # 2674 */
      P_src_error_s(Rd.s+592,153,2, V_sy_ident.s,NULL);
      Ra.sl[6]=2675; /* line # 2675 */
      Rv0=1;
    }
    Ra.sl[6]=2678; /* line # 2678 */
    P_insymbol();
  }
  else {
    Ra.sl[6]=2682; /* line # 2682 */
    P_src_error(Rd.s+592,156,3);
    Ra.sl[6]=2683; /* line # 2683 */
    Rv0=1;
  }
  Ra.sl[6]=2686; /* line # 2686 */
  Rv8=F_pobj;
  Ra.sl[6]=2687; /* line # 2687 */
  if (Rv0) ((V *)Rv8)[3]=V_typ_std.v[21];
  else {
    Ra.sl[6]=2690; /* line # 2690 */
    ((SL *)Rv8)[4]=Rv2;
    Ra.sl[6]=2691; /* line # 2691 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=2692; /* line # 2692 */
    if (((UB *)Rv8)[40]==14) {
      Ra.sl[6]=2693; /* line # 2693 */
      if (((V *)Rv8)[3]!=NULL) {
        Ra.sl[6]=2694; /* line # 2694 */
        if (((UB *)((V *)Rv8)[3])[91]) P_lgt_extract_simple_cte(F_pobj);
      }
    }
  }
  Ra.sl[6]=2697; /* line # 2697 */
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_index "  */
V PAS_COMILER_PRC_00000028(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+596;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2711; /* line # 2711 */
  Rv0=F_pobj;
  Ra.sl[6]=2714; /* line # 2714 */
  if (P_comp_type(((V *)F_pobj)[3],V_typ_std.v[10],1,0)) {
    Ra.sl[6]=2716; /* line # 2716 */
    V_curr_descr=F_pobj;
    Ra.sl[6]=2717; /* line # 2717 */
    P_lgt_new(&Rv0,((V *)((V *)V_typ_std.v[10])[13])[4],3, F_pobj);
    Ra.sl[6]=2718; /* line # 2718 */
    ((SL *)Rv0)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
  }
  else {
    Ra.sl[6]=2721; /* line # 2721 */
    Rv1=F_pobj;
    Ra.sl[6]=2722; /* line # 2722 */
    if (((SL *)((V *)F_pobj)[3])[10]>0) {
      Ra.sl[6]=2724; /* line # 2724 */
      V_curr_descr=F_pobj;
      Ra.sl[6]=2725; /* line # 2725 */
      P_lgt_new(&Rv0,((V *)F_pobj)[3],3, F_pobj);
      Ra.sl[6]=2726; /* line # 2726 */
      ((SL *)Rv0)[4]=((SL *)F_pobj)[4]+((SL *)((V *)F_pobj)[3])[10];
    }
    else {
      Ra.sl[6]=2728; /* line # 2728 */
      Rv0=F_pobj;
    }
  }
  Ra.sl[6]=2730; /* line # 2730 */
  Rv2=Rv0;
  Ra.sl[6]=2732; /* line # 2732 */
  Rv3=((V *)Rv2)[3];
  Ra.sl[6]=2733; /* line # 2733 */
  if (((UB *)Rv3)[92]==8||((UB *)Rv3)[92]==9) {
    Ra.sl[6]=2736; /* line # 2736 */
    Rv4=PAS_COMILER_PRC_00000005(((V *)Rv3)[15],0,0,0);
    Ra.sl[6]=2737; /* line # 2737 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=2739; /* line # 2739 */
      Rv5=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=2740; /* line # 2740 */
      P_lgt_free(&Rv4);
    }
    Ra.sl[6]=2742; /* line # 2742 */
    Rv6=NULL;
    Ra.sl[6]=2743; /* line # 2743 */
    Rv7=NULL;
    Ra.sl[6]=2744; /* line # 2744 */
    Rv8=NULL;
    Ra.sl[6]=2746; /* line # 2746 */
    Rv9=((V *)Rv3)[15];
    Ra.sl[6]=2747; /* line # 2747 */
    if (((UB *)Rv9)[92]==22) {
      Ra.sl[6]=2748; /* line # 2748 */
      if (((UB *)((V *)Rv9)[13])[40]==14) {
        Ra.sl[6]=2750; /* line # 2750 */
        Rv10=((SL *)((V *)((V *)Rv9)[13])[7])[13];
        Ra.sl[6]=2751; /* line # 2751 */
        Rv7=((V *)Rv9)[14];
      }
      else {
        Ra.sl[6]=2755; /* line # 2755 */
        Rv6=P_lgt_type_eval(((V *)Rv9)[13],V_curr_descr,NULL,0);
        Ra.sl[6]=2762; /* line # 2762 */
        if (((UB *)((V *)Rv9)[14])[40]==14) {
          Ra.sl[6]=2764; /* line # 2764 */
          Rv11=((SL *)((V *)((V *)Rv9)[14])[7])[13];
          Ra.sl[6]=2765; /* line # 2765 */
          Rv7=((V *)Rv9)[14];
        }
      }
    }
    else {
      Ra.sl[6]=2770; /* line # 2770 */
      Rv10=((SL *)Rv9)[29];
      Ra.sl[6]=2771; /* line # 2771 */
      Rv11=((SL *)Rv9)[30];
    }
    Ra.sl[6]=2774; /* line # 2774 */
    if (((SL *)Rv3)[25]>0) Rv12=((SL *)Rv3)[25];
    else {
      Ra.sl[6]=2777; /* line # 2777 */
      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
      Ra.sl[6]=2778; /* line # 2778 */
      if (Rv8!=NULL) {
        Ra.sl[6]=2779; /* line # 2779 */
        Rv13=Rv8;
        Ra.sl[6]=2780; /* line # 2780 */
        if (((UB *)Rv13)[40]==14) {
          Ra.sl[6]=2782; /* line # 2782 */
          Rv12=((SL *)((V *)Rv13)[7])[13];
          Ra.sl[6]=2783; /* line # 2783 */
          P_lgt_free(&Rv8);
        }
      }
    }
    Ra.sl[6]=2787; /* line # 2787 */
    if (Rv4==NULL&&Rv6==NULL) {
      Ra.sl[6]=2789; /* line # 2789 */
      if (Rv5<Rv10||Rv7==NULL&&Rv5>Rv11) {
        Ra.sl[6]=2790; /* line # 2790 */
        P_src_error(Rd.s+609,154,2);
      }
      Ra.sl[6]=2791; /* line # 2791 */
      Rv5=Rv5-Rv10;
      Ra.sl[6]=2792; /* line # 2792 */
      if (Rv8==NULL) {
        Ra.sl[6]=2794; /* line # 2794 */
        Rv14=Rv0;
        Ra.sl[6]=2795; /* line # 2795 */
        ((SL *)Rv14)[4]=((SL *)Rv2)[4]+Rv5*Rv12;
        Ra.sl[6]=2796; /* line # 2796 */
        ((V *)Rv14)[3]=((V *)Rv3)[14];
      }
      else {
        Ra.sl[6]=2800; /* line # 2800 */
        Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        Ra.sl[6]=2801; /* line # 2801 */
        ((V *)Rv0)[0]=Rv4;
        Ra.sl[6]=2802; /* line # 2802 */
        ((V *)Rv4)[0]=Rv8;
        Ra.sl[6]=2803; /* line # 2803 */
        P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
        Ra.sl[6]=2804; /* line # 2804 */
        ((UW *)Rv14)[10]=((UW *)Rv0)[10];
        Ra.sl[6]=2805; /* line # 2805 */
        ((V *)Rv14)[6]=((V *)Rv2)[3];
      }
    }
    else {
      Ra.sl[6]=2810; /* line # 2810 */
      P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
      Ra.sl[6]=2811; /* line # 2811 */
      ((V *)Rv14)[6]=((V *)Rv2)[3];
      Ra.sl[6]=2812; /* line # 2812 */
      if (Rv8==NULL) {
        Ra.sl[6]=2814; /* line # 2814 */
        if (Rv4==NULL) {
          Ra.sl[6]=2816; /* line # 2816 */
          Rv4=P_lgt_new_code(46, Rv6);
          Ra.sl[6]=2817; /* line # 2817 */
          ((SL *)Rv14)[4]=Rv5*Rv12;
        }
        else {
          Ra.sl[6]=2821; /* line # 2821 */
          if (Rv6==NULL) {
            Ra.sl[6]=2822; /* line # 2822 */
            ((SL *)Rv14)[4]= -Rv10*Rv12;
          }
          else {
            Ra.sl[6]=2826; /* line # 2826 */
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2827; /* line # 2827 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        Ra.sl[6]=2830; /* line # 2830 */
        ((V *)Rv4)[0]=P_lgt_new_econst(V_int_typ, Rv12);
      }
      else {
        Ra.sl[6]=2834; /* line # 2834 */
        if (Rv4==NULL) {
          Ra.sl[6]=2836; /* line # 2836 */
          if (Rv5!=0) {
            Ra.sl[6]=2837; /* line # 2837 */
            Rv4=P_lgt_new_econst(V_int_typ, Rv5);
          }
        }
        else {
          Ra.sl[6]=2840; /* line # 2840 */
          if (Rv6==NULL) {
            Ra.sl[6]=2841; /* line # 2841 */
            if (Rv10!=0) {
              Ra.sl[6]=2842; /* line # 2842 */
              Rv6=P_lgt_new_econst(V_int_typ, Rv10);
            }
          }
        }
        Ra.sl[6]=2844; /* line # 2844 */
        if (Rv4==NULL) {
          Ra.sl[6]=2845; /* line # 2845 */
          Rv4=P_lgt_new_code(46, Rv4);
        }
        else {
          Ra.sl[6]=2847; /* line # 2847 */
          if (Rv6!=NULL) {
            Ra.sl[6]=2849; /* line # 2849 */
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2850; /* line # 2850 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        Ra.sl[6]=2852; /* line # 2852 */
        ((V *)Rv4)[0]=Rv8;
      }
      Ra.sl[6]=2854; /* line # 2854 */
      ((V *)Rv0)[0]=Rv4;
    }
  }
  else {
    Ra.sl[6]=2859; /* line # 2859 */
    P_src_error(Rd.s+609,155,3);
    Ra.sl[6]=2860; /* line # 2860 */
    ((V *)Rv2)[3]=V_typ_std.v[21];
    Ra.sl[6]=2861; /* line # 2861 */
    ((V *)Rv2)[1]=NULL;
    Ra.sl[6]=2862; /* line # 2862 */
    Rv14=F_pobj;
    Ra.sl[6]=2863; /* line # 2863 */
    P_skip_symbol(16,0,0);
  }
  Ra.sl[6]=2866; /* line # 2866 */
  Rv15=Rv14;
  Ra.sl[6]=2877; /* line # 2877 */
  ((UW *)Rv15)[10]=((UW *)Rv15)[10]|4;
  Ra.sl[6]=2878; /* line # 2878 */
  if (((UB *)Rv15)[40]==14) {
    Ra.sl[6]=2879; /* line # 2879 */
    if (((V *)Rv15)[3]!=NULL) {
      Ra.sl[6]=2880; /* line # 2880 */
      if (((UB *)((V *)Rv15)[3])[91]) P_lgt_extract_simple_cte(Rv14);
    }
  }
  Ra.sl[6]=2883; /* line # 2883 */
  Ret=Rv14;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_una "  */
V PAS_COMILER_PRC_00000034(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  UB Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+613;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2928; /* line # 2928 */
  Ra.sl[6]=2930; /* line # 2930 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) {
    Ra.sl[6]=2931; /* line # 2931 */
    V_sy_sym.ub[0]=6;
  }
  Ra.sl[6]=2932; /* line # 2932 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=2934; /* line # 2934 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else {
      Ra.sl[6]=2935; /* line # 2935 */
      Rv0=29;
    }
    Ra.sl[6]=2936; /* line # 2936 */
    P_insymbol();
    Ra.sl[6]=2937; /* line # 2937 */
    Rv1=PAS_COMILER_PRC_00000034();
    Ra.sl[6]=2938; /* line # 2938 */
    if (Rv0!=29) {
      Ra.sl[6]=2939; /* line # 2939 */
      if (((UB *)Rv1)[40]!=17) {
        Ra.sl[6]=2940; /* line # 2940 */
        Rv1=P_exp_genop(Rv0, Rv1);
      }
    }
  }
  else {
    Ra.sl[6]=2942; /* line # 2942 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=2944; /* line # 2944 */
      P_insymbol();
      Ra.sl[6]=2945; /* line # 2945 */
      Rv1=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=2946; /* line # 2946 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=2947; /* line # 2947 */
        P_src_error(Rd.s+624,23,3);
      }
    }
    else {
      Ra.sl[6]=2949; /* line # 2949 */
      if (V_sy_sym.ub[0]==15) {
        Ra.sl[6]=2950; /* line # 2950 */
        Rv1=PAS_COMILER_PRC_00000022();
      }
      else {
        Ra.sl[6]=2954; /* line # 2954 */
        Rv1=PAS_COMILER_PRC_00000025();
        Ra.sl[6]=2955; /* line # 2955 */
        Rv2=((UB *)Rv1)[40]!=17;
        Ra.sl[6]=2956; /* line # 2956 */
        if (((SL *)((V *)Rv1)[3])[10]>0) V_curr_descr=Rv1;
        Ra.sl[6]=2957; /* line # 2957 */
        while (Rv2){
          Ra.sl[6]=2958; /* line # 2958 */
          switch (V_sy_sym.ub[0]) {
            case 23:Ra.sl[6]=2961; /* line # 2961 */
            P_insymbol();
            Ra.sl[6]=2962; /* line # 2962 */
            Rv1=PAS_COMILER_PRC_00000026(Rv1);
            Ra.sl[6]=2963; /* line # 2963 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            break;
            case 15:Ra.sl[6]=2968; /* line # 2968 */
            V_sy_sym.ub[0]=17;
            Ra.sl[6]=2969; /* line # 2969 */
            while (V_sy_sym.ub[0]==17){
              Ra.sl[6]=2971; /* line # 2971 */
              P_insymbol();
              Ra.sl[6]=2972; /* line # 2972 */
              Rv1=PAS_COMILER_PRC_00000028(Rv1);
              Ra.sl[6]=2973; /* line # 2973 */
              if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            }
            Ra.sl[6]=2975; /* line # 2975 */
            if (V_sy_sym.ub[0]==16) P_insymbol();
            else {
              Ra.sl[6]=2976; /* line # 2976 */
              P_src_error(Rd.s+624,26,2);
            }
            break;
            case 19:Ra.sl[6]=2981; /* line # 2981 */
            P_insymbol();
            Ra.sl[6]=2982; /* line # 2982 */
            Rv1=PAS_COMILER_PRC_00000027(Rv1);
            Ra.sl[6]=2983; /* line # 2983 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            break;
            case 24:Ra.sl[6]=2987; /* line # 2987 */
            Rv1=PAS_COMILER_PRC_00000007(Rv1,((V *)Rv1)[3]);
            break;
            default:Ra.sl[6]=2990; /* line # 2990 */
            Rv2=0;
            break;
          }
        }
      }
    }
  }
  Ra.sl[6]=2995; /* line # 2995 */
  Ri.ub[0]=0;
  Ra.sl[6]=2996; /* line # 2996 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_pow "  */
V PAS_COMILER_PRC_00000033(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+628;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3000; /* line # 3000 */
  Rv0=PAS_COMILER_PRC_00000034();
  Ra.sl[6]=3001; /* line # 3001 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3002; /* line # 3002 */
    Ra.sl[6]=3003; /* line # 3003 */
    if (V_sy_sym.ub[0]==7) {
      Ra.sl[6]=3005; /* line # 3005 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3006; /* line # 3006 */
      P_insymbol();
      Ra.sl[6]=3007; /* line # 3007 */
      Ri.ub[0]=1;
      Ra.sl[6]=3008; /* line # 3008 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000034();
      Ra.sl[6]=3009; /* line # 3009 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3011; /* line # 3011 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_mul "  */
V PAS_COMILER_PRC_00000032(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+637;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3015; /* line # 3015 */
  Rv0=PAS_COMILER_PRC_00000033();
  Ra.sl[6]=3016; /* line # 3016 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3017; /* line # 3017 */
    Ra.sl[6]=3018; /* line # 3018 */
    while (V_sy_sym.ub[0]==8){
      Ra.sl[6]=3020; /* line # 3020 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3021; /* line # 3021 */
      P_insymbol();
      Ra.sl[6]=3022; /* line # 3022 */
      Ri.ub[0]=1;
      Ra.sl[6]=3023; /* line # 3023 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000033();
      Ra.sl[6]=3024; /* line # 3024 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3026; /* line # 3026 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_add "  */
V PAS_COMILER_PRC_00000031(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+646;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3030; /* line # 3030 */
  Rv0=PAS_COMILER_PRC_00000032();
  Ra.sl[6]=3031; /* line # 3031 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3032; /* line # 3032 */
    Ra.sl[6]=3033; /* line # 3033 */
    while (V_sy_sym.ub[0]==9){
      Ra.sl[6]=3035; /* line # 3035 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3036; /* line # 3036 */
      P_insymbol();
      Ra.sl[6]=3037; /* line # 3037 */
      Ri.ub[0]=1;
      Ra.sl[6]=3038; /* line # 3038 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000032();
      Ra.sl[6]=3039; /* line # 3039 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3041; /* line # 3041 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_rel "  */
V PAS_COMILER_PRC_00000030(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+655;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3045; /* line # 3045 */
  Rv0=PAS_COMILER_PRC_00000031();
  Ra.sl[6]=3046; /* line # 3046 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3047; /* line # 3047 */
    Ra.sl[6]=3048; /* line # 3048 */
    while (V_sy_sym.ub[0]==10){
      Ra.sl[6]=3050; /* line # 3050 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3051; /* line # 3051 */
      P_insymbol();
      Ra.sl[6]=3052; /* line # 3052 */
      Ri.ub[0]=1;
      Ra.sl[6]=3053; /* line # 3053 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000031();
      Ra.sl[6]=3054; /* line # 3054 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3056; /* line # 3056 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_and "  */
V PAS_COMILER_PRC_00000029(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+664;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3060; /* line # 3060 */
  Rv0=PAS_COMILER_PRC_00000030();
  Ra.sl[6]=3061; /* line # 3061 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3062; /* line # 3062 */
    Ra.sl[6]=3063; /* line # 3063 */
    while (V_sy_sym.ub[0]==11){
      Ra.sl[6]=3065; /* line # 3065 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3066; /* line # 3066 */
      P_insymbol();
      Ra.sl[6]=3067; /* line # 3067 */
      Ri.ub[0]=1;
      Ra.sl[6]=3068; /* line # 3068 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000030();
      Ra.sl[6]=3069; /* line # 3069 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3071; /* line # 3071 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " expression "  */
V PAS_COMILER_PRC_00000000(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+673;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3075; /* line # 3075 */
  Rv0=PAS_COMILER_PRC_00000029();
  Ra.sl[6]=3076; /* line # 3076 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3077; /* line # 3077 */
    Ra.sl[6]=3078; /* line # 3078 */
    while (V_sy_sym.ub[0]==12){
      Ra.sl[6]=3080; /* line # 3080 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3081; /* line # 3081 */
      P_insymbol();
      Ra.sl[6]=3082; /* line # 3082 */
      Ri.ub[0]=1;
      Ra.sl[6]=3083; /* line # 3083 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000029();
      Ra.sl[6]=3084; /* line # 3084 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3086; /* line # 3086 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_work_list "  */
V PAS_COMILER_PRC_00000039(UB F_mode, V F_ty, UB F_blist){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+685;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3177; /* line # 3177 */
  Rv0=NULL;
  Ra.sl[6]=3178; /* line # 3178 */
  Ra.sl[6]=3179; /* line # 3179 */
  switch (F_mode) {
    case 2:
    case 29:Ra.sl[6]=3182; /* line # 3182 */
    P_lgt_new(&Rv0,NULL,16,NULL);
    Ra.sl[6]=3183; /* line # 3183 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+3,0,NULL,0,0);
    Ra.sl[6]=3184; /* line # 3184 */
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=85) {
      Ra.sl[6]=3185; /* line # 3185 */
      P_src_error(Rd.s+703,35,2);
    }
    break;
    case 41:Ra.sl[6]=3189; /* line # 3189 */
    Rv2=F_ty;
    Ra.sl[6]=3191; /* line # 3191 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[6]=3192; /* line # 3192 */
      P_src_error(Rd.s+703,22,2);
    }
    Ra.sl[6]=3193; /* line # 3193 */
    P_ide_new_typ(23, &Rv3);
    Ra.sl[6]=3194; /* line # 3194 */
    P_lgt_new(&Rv0, Rv3,16,NULL);
    Ra.sl[6]=3195; /* line # 3195 */
    Rv4=Rv3;
    Ra.sl[6]=3197; /* line # 3197 */
    ((SL *)Rv4)[11]=Lx[2].sl[0];
    Ra.sl[6]=3198; /* line # 3198 */
    ((V *)Rv4)[12]=NULL;
    Ra.sl[6]=3199; /* line # 3199 */
    ((V *)Rv4)[13]=NULL;
    Ra.sl[6]=3200; /* line # 3200 */
    ((V *)Rv4)[14]=NULL;
    Ra.sl[6]=3201; /* line # 3201 */
    PAS_COMILER_PRC_00000037(6,((SL *)Rv4)+11,&Rv5, Rv3);
    Ra.sl[6]=3202; /* line # 3202 */
    if (Lx[2].v[1]==NULL) {
      Ra.sl[6]=3203; /* line # 3203 */
      ((V *)Rv4)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    }
    else {
      Ra.sl[6]=3205; /* line # 3205 */
      ((V *)Rv4)[12]=((V *)Lx[2].v[1])[3];
    }
    Ra.sl[6]=3206; /* line # 3206 */
    if (((V *)Rv4)[13]==NULL) {
      Ra.sl[6]=3207; /* line # 3207 */
      ((V *)Rv4)[13]=V_lex_ident_tree.v[V_curr_disp*8+4];
    }
    Ra.sl[6]=3208; /* line # 3208 */
    Lx[2].v[1]=((V *)Rv4)[13];
    Ra.sl[6]=3211; /* line # 3211 */
    if (((SL *)Rv3)[11]>((SL *)Rv2)[11]) ((SL *)Rv2)[11]=((SL *)Rv3)[11];
    else {
      Ra.sl[6]=3212; /* line # 3212 */
      if (((SL *)Rv3)[11]<0) ((SL *)Rv2)[11]=-1;
    }
    Ra.sl[6]=3214; /* line # 3214 */
    if (Rv5>((UB *)Rv2)[48]) ((UB *)Rv2)[48]=Rv5;
    Ra.sl[6]=3215; /* line # 3215 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=3216; /* line # 3216 */
      P_src_error(Rd.s+703,23,2);
    }
    break;
    case 22:Ra.sl[6]=3221; /* line # 3221 */
    Rv0=PAS_COMILER_PRC_00000005(F_ty,0,0,0);
    Ra.sl[6]=3222; /* line # 3222 */
    if ((V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=85) {
      Ra.sl[6]=3223; /* line # 3223 */
      P_src_error(Rd.s+703,35,2);
    }
    break;
    default:Ra.sl[6]=3227; /* line # 3227 */
    if (F_blist) Rv0=PAS_COMILER_PRC_00000035(72,1);
    else {
      Ra.sl[6]=3228; /* line # 3228 */
      Rv0=PAS_COMILER_PRC_00000036(NULL,1);
    }
    Ra.sl[6]=3229; /* line # 3229 */
    if (Rv0==NULL) {
      Ra.sl[6]=3231; /* line # 3231 */
      P_lgt_new(&Rv0,NULL,16,NULL);
      Ra.sl[6]=3232; /* line # 3232 */
      if (F_blist) {
        Ra.sl[6]=3233; /* line # 3233 */
        Rv1=Rv0;
        Ra.sl[6]=3234; /* line # 3234 */
        ((UW *)Rv1)[10]=((UW *)Rv1)[10]|2048;
      }
    }
    Ra.sl[6]=3236; /* line # 3236 */
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=85) {
      Ra.sl[6]=3237; /* line # 3237 */
      P_src_error(Rd.s+703,35,2);
    }
    break;
  }
  Ra.sl[6]=3239; /* line # 3239 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_definition "  */
V PAS_COMILER_PRC_00000004(UB F_mode, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 2096 );

  /* Local variable stored in C variable */
  V Rv0;
  C Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  UB Rv14;
  UB Rv15;
  UB Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  SL Rv25;
  register int Rf0;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+707;
  Ra.v[4]=Rd.s+17;
  Ra.sl[10]=3244; /* line # 3244 */
  Ra.sl[10]=3246; /* line # 3246 */
  if (F_mode==41) {
    Ra.sl[10]=3247; /* line # 3247 */
    Ra.sl[0]=abs(((SL *)F_ty)[11]);
  }
  else {
    Ra.sl[10]=3249; /* line # 3249 */
    Ra.sl[0]=0;
  }
  Ra.sl[10]=3250; /* line # 3250 */
  Rv0=NULL;
  Ra.sl[10]=3251; /* line # 3251 */
  if (F_mode==41) {
    Ra.sl[10]=3254; /* line # 3254 */
    if (F_ty!=NULL) {
      Ra.sl[10]=3255; /* line # 3255 */
      Ra.v[1]=((V *)F_ty)[13];
    }
    Ra.sl[10]=3256; /* line # 3256 */
    V_sy_casedef=1;
    Ra.sl[10]=3257; /* line # 3257 */
    Rv1=P_src_search_char();
    Ra.sl[10]=3258; /* line # 3258 */
    if (Rv1==58) {
      Ra.sl[10]=3260; /* line # 3260 */
      P_ide_new(6,NULL,&Rv2);
      Ra.sl[10]=3261; /* line # 3261 */
      Ra.v[1]=Rv2;
      Ra.sl[10]=3262; /* line # 3262 */
      P_insymbol();
      Ra.sl[10]=3263; /* line # 3263 */
      if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+703,29,2);
      else {
        Ra.sl[10]=3264; /* line # 3264 */
        P_insymbol();
      }
      Ra.sl[10]=3266; /* line # 3266 */
      Rv3=1;
    }
    else {
      Ra.sl[10]=3268; /* line # 3268 */
      Rv3=0;
    }
    Ra.sl[10]=3271; /* line # 3271 */
    V_err_prt=0;
    Ra.sl[10]=3272; /* line # 3272 */
    Rv4=P_ide_search(2);
    Ra.sl[10]=3273; /* line # 3273 */
    V_err_prt=1;
    Ra.sl[10]=3274; /* line # 3274 */
    if (!Rv3&&Rv4!=NULL) {
      Ra.sl[10]=3276; /* line # 3276 */
      Rv1=P_src_search_char();
      Ra.sl[10]=3277; /* line # 3277 */
      if (Rv1==34||Rv1==40) Rv4=NULL;
    }
    Ra.sl[10]=3279; /* line # 3279 */
    if (Rv4!=NULL) {
      Ra.sl[10]=3281; /* line # 3281 */
      Rv0=((V *)Rv4)[4];
      Ra.sl[10]=3282; /* line # 3282 */
      if (!P_comp_type(Rv0, V_typ_std.v[15],0,0)) {
        Ra.sl[10]=3285; /* line # 3285 */
        P_src_error(Rd.s+703,60,2);
        Ra.sl[10]=3286; /* line # 3286 */
        Rv0=V_typ_std.v[2];
      }
      Ra.sl[10]=3288; /* line # 3288 */
      if (Rv3) {
        Ra.sl[10]=3289; /* line # 3289 */
        Rv5=Rv2;
        Ra.sl[10]=3291; /* line # 3291 */
        ((V *)Rv5)[4]=Rv0;
        Ra.sl[10]=3292; /* line # 3292 */
        ((SL *)Rv5)[15]=P_ide_typ_align(Ra.sl[0],Rv0);
        Ra.sl[10]=3293; /* line # 3293 */
        Ra.sl[0]=((SL *)Rv5)[15]+((SL *)Rv0)[11];
        Ra.sl[10]=3295; /* line # 3295 */
        if (((UB *)Rv0)[48]>((UB *)F_ty)[48]) {
          Ra.sl[10]=3296; /* line # 3296 */
          ((UB *)F_ty)[48]=((UB *)Rv0)[48];
        }
      }
      Ra.sl[10]=3299; /* line # 3299 */
      P_lgt_new(&Rv6, Rv0,16,NULL);
      Ra.sl[10]=3300; /* line # 3300 */
      if (Rv3) ((V *)Rv6)[4]=Rv2;
      Ra.sl[10]=3301; /* line # 3301 */
      P_insymbol();
    }
  }
  Ra.sl[10]=3305; /* line # 3305 */
  if (Rv0==NULL) {
    Ra.sl[10]=3308; /* line # 3308 */
    Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
    Ra.sl[10]=3309; /* line # 3309 */
    if (F_mode==29||F_mode==41) {
      Ra.sl[10]=3310; /* line # 3310 */
      P_type_check_parm(Rv6);
    }
    else {
      Ra.sl[10]=3311; /* line # 3311 */
      if (F_mode==2) {
        Ra.sl[10]=3312; /* line # 3312 */
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[10]=3314; /* line # 3314 */
          P_src_error(Rd.s+703,61,3);
        }
      }
    }
    Ra.sl[10]=3315; /* line # 3315 */
    Rv0=((V *)Rv6)[3];
  }
  Ra.sl[10]=3318; /* line # 3318 */
  if (V_sy_sym.ub[0]!=84) P_src_error(Rd.s+703,51,2);
  Ra.sl[10]=3320; /* line # 3320 */
  P_lgt_new(&Rv7,((V *)Rv6)[3],14,NULL);
  Ra.sl[10]=3321; /* line # 3321 */
  Rv8=Rv7;
  Ra.sl[10]=3323; /* line # 3323 */
  ((V *)Rv8)[0]=Rv6;
  Ra.sl[10]=3324; /* line # 3324 */
  P_val_new(((V *)Rv8)+7,NULL);
  Ra.sl[10]=3325; /* line # 3325 */
  ((UB *)((V *)Rv8)[7])[48]=21;
  Ra.sl[10]=3327; /* line # 3327 */
  P_lgt_new(&Rv9,((V *)Rv6)[3],0, Rv7);
  Ra.sl[10]=3328; /* line # 3328 */
  ((UB *)Rv9)[41]=3;
  Ra.sl[10]=3329; /* line # 3329 */
  Rv10=0;
  for( Rf0=512;Rf0>0;Rf0-- ) {
    Ra.sl[Rv10+11]=-1;
    Rv10++;
  }
  Ra.sl[10]=3330; /* line # 3330 */
  Rv11=0;
  Rv12=1;
  Rv13=0;
  Ra.sl[10]=3331; /* line # 3331 */
  Rv14=0;
  Ra.sl[10]=3332; /* line # 3332 */
  Rv15=1;
  Ra.sl[10]=3333; /* line # 3333 */
  Rv16=V_sy_label_flag;
  while (1){
    Ra.sl[10]=3335; /* line # 3335 */
    if (Rv15) V_sy_sym.ub[0]=17;
    Ra.sl[10]=3336; /* line # 3336 */
    V_sy_label_flag=0;
    Ra.sl[10]=3337; /* line # 3337 */
    while (V_sy_sym.ub[0]==17||!Rv15){
      Ra.sl[10]=3339; /* line # 3339 */
      if (Rv15) P_insymbol();
      else {
        Ra.sl[10]=3340; /* line # 3340 */
        Rv15=1;
      }
      Ra.sl[10]=3342; /* line # 3342 */
      Rv17=PAS_COMILER_PRC_00000006(&Rv0);
      Ra.sl[10]=3343; /* line # 3343 */
      if (V_sy_sym.ub[0]==20) {
        Ra.sl[10]=3345; /* line # 3345 */
        P_insymbol();
        Rv18=PAS_COMILER_PRC_00000006(&Rv0);
        Ra.sl[10]=3346; /* line # 3346 */
        if (Rv18<Rv17) {
          Ra.sl[10]=3348; /* line # 3348 */
          Rv18=Rv17;
          P_src_error(Rd.s+703,62,2);
        }
      }
      else {
        Ra.sl[10]=3350; /* line # 3350 */
        Rv18=Rv17;
      }
      while (1){
        Ra.sl[10]=3352; /* line # 3352 */
        if (Rv12>Rv13) {
          Ra.sl[10]=3354; /* line # 3354 */
          Rv12=Rv17;
          Rv13=Rv17;
          Rv19=Rv17;
          Ra.sl[10]=3355; /* line # 3355 */
          Ra.sl[11]=Rv11;
        }
        else {
          Ra.sl[10]=3359; /* line # 3359 */
          if (Rv17>Rv13) Rv13=Rv17;
          else {
            Ra.sl[10]=3360; /* line # 3360 */
            if (Rv17<Rv12) Rv12=Rv17;
          }
          Ra.sl[10]=3361; /* line # 3361 */
          Rv20=Rv17-Rv19;
          Ra.sl[10]=3362; /* line # 3362 */
          if (Rv20<0) Rv20=(Rv20+511)+1;
          Ra.sl[10]=3363; /* line # 3363 */
          if (Rv20<0||Rv20>511) {
            Ra.sl[10]=3365; /* line # 3365 */
            P_src_error(Rd.s+703,63,3);
          }
          else {
            Ra.sl[10]=3369; /* line # 3369 */
            if (Ra.sl[Rv20+11]!=-1) {
              Ra.sl[10]=3370; /* line # 3370 */
              P_src_error(Rd.s+703,64,2);
            }
            else {
              Ra.sl[10]=3372; /* line # 3372 */
              Ra.sl[Rv20+11]=Rv11;
            }
          }
        }
        Ra.sl[10]=3375; /* line # 3375 */
        Rv17=Rv17+1;
        if (Rv17>Rv18)  break;
      }
    }
    Ra.sl[10]=3378; /* line # 3378 */
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+703,31,2);
    Ra.sl[10]=3379; /* line # 3379 */
    V_sy_label_flag=Rv16;
    Ra.sl[10]=3381; /* line # 3381 */
    Rv21=PAS_COMILER_PRC_00000039(F_mode, F_ty,0);
    Ra.sl[10]=3382; /* line # 3382 */
    if (V_sy_sym.ub[0]==18) {
      Ra.sl[10]=3384; /* line # 3384 */
      V_sy_label_flag=0;
      Ra.sl[10]=3385; /* line # 3385 */
      P_insymbol();
      Ra.sl[10]=3386; /* line # 3386 */
      Rv15=0;
    }
    Ra.sl[10]=3389; /* line # 3389 */
    if (Rv21==NULL) P_lgt_new(&Rv21,NULL,16,NULL);
    Ra.sl[10]=3390; /* line # 3390 */
    ((V *)Rv6)[0]=Rv21;
    Rv6=Rv21;
    Ra.sl[10]=3391; /* line # 3391 */
    Rv11=Rv11+1;
    if (((V_sy_sym.ub[0]==85||V_sy_sym.ub[0]==72)||V_sy_sym.ub[0]==14)||V_sy_sym
    .ub[0]==88)  break;
  }
  Ra.sl[10]=3393; /* line # 3393 */
  V_sy_label_flag=Rv16;
  Ra.sl[10]=3394; /* line # 3394 */
  if (V_sy_sym.ub[0]==85) {
    Ra.sl[10]=3396; /* line # 3396 */
    P_insymbol();
    Ra.sl[10]=3397; /* line # 3397 */
    Rv6=PAS_COMILER_PRC_00000039(F_mode, F_ty,1);
  }
  else {
    Ra.sl[10]=3401; /* line # 3401 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Ra.sl[10]=3402; /* line # 3402 */
    if (F_mode==41) {
      Ra.sl[10]=3404; /* line # 3404 */
      P_ide_new_typ(23,((V *)Rv6)+3);
      Ra.sl[10]=3405; /* line # 3405 */
      Rv22=((V *)Rv6)[3];
      Ra.sl[10]=3407; /* line # 3407 */
      ((V *)Rv22)[12]=NULL;
      Ra.sl[10]=3408; /* line # 3408 */
      ((V *)Rv22)[13]=NULL;
      Ra.sl[10]=3409; /* line # 3409 */
      ((V *)Rv22)[14]=NULL;
      Ra.sl[10]=3410; /* line # 3410 */
      ((SL *)Rv22)[11]=Ra.sl[0];
    }
  }
  Ra.sl[10]=3414; /* line # 3414 */
  Rv21=((V *)Rv7)[0];
  Ra.sl[10]=3415; /* line # 3415 */
  ((V *)Rv6)[0]=Rv21;
  Ra.sl[10]=3416; /* line # 3416 */
  ((V *)Rv7)[0]=Rv6;
  Ra.sl[10]=3417; /* line # 3417 */
  if (F_mode!=41) P_insymbol();
  Ra.sl[10]=3419; /* line # 3419 */
  ((SL *)Rv9)[4]=Rv11;
  Ra.sl[10]=3420; /* line # 3420 */
  Rv23=Rv7;
  Rv24=((V *)Rv23)[7];
  Ra.sl[10]=3422; /* line # 3422 */
  ((SL *)Rv23)[4]=Rv12;
  Ra.sl[10]=3423; /* line # 3423 */
  ((SL *)Rv24)[6]=(Rv13-Rv12)+1;
  Ra.sl[10]=3424; /* line # 3424 */
  ((V *)Rv24)[7]=P_tab_new(((SL *)Rv24)[6]);
  Ra.sl[10]=3425; /* line # 3425 */
  Rv17=Rv12-Rv19;
  Ra.sl[10]=3426; /* line # 3426 */
  if (Rv17<0) Rv17=(Rv17+511)+1;
  Ra.sl[10]=3427; /* line # 3427 */
  Rv25=0;
  for( Rf0=(Rv13-Rv12)+1;Rf0>0;Rf0-- ) {
    Ra.sl[10]=3429; /* line # 3429 */
    ((SL *)((V *)Rv24)[7])[Rv25]=Ra.sl[Rv17+11];
    Ra.sl[10]=3430; /* line # 3430 */
    Rv17=Rv17+1;
    Ra.sl[10]=3431; /* line # 3431 */
    if (Rv17>511) Rv17=0;
    Rv25++;
  }
  Ra.sl[10]=3435; /* line # 3435 */
  V_sy_casedef=0;
  Ra.sl[10]=3436; /* line # 3436 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " set_alignment_spc "  */
void PAS_COMILER_PRC_00000040(SL *F_sz, SL *F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+724;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3450; /* line # 3450 */
  Ra.sl[6]=3453; /* line # 3453 */
  if (Rs.sl[0]>0) {
    Ra.sl[6]=3455; /* line # 3455 */
    (*F_sz)=Rs.sl[0];
    Rv0=(*F_sz);
    Rs.sl[0]=-1;
    Ra.sl[6]=3456; /* line # 3456 */
    if (Rs.sl[1]<0) {
      Ra.sl[6]=3458; /* line # 3458 */
      (*F_aln)=1;
      Ra.sl[6]=3459; /* line # 3459 */
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3460; /* line # 3460 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  Ra.sl[6]=3463; /* line # 3463 */
  if (Rs.sl[1]>=0) {
    Ra.sl[6]=3464; /* line # 3464 */
    (*F_aln)=Rs.sl[1];
    Rs.sl[1]=-1;
  }
  Ra.sl[6]=3465; /* line # 3465 */
  if (V_sy_sym.ub[0]==73) {
    Ra.sl[6]=3467; /* line # 3467 */
    P_insymbol();
    Ra.sl[6]=3469; /* line # 3469 */
    (*F_sz)=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
    Ra.sl[6]=3470; /* line # 3470 */
    if ((*F_sz)<1) (*F_sz)=1;
    Ra.sl[6]=3471; /* line # 3471 */
    Rv0=(*F_sz);
    Ra.sl[6]=3472; /* line # 3472 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=3474; /* line # 3474 */
      P_insymbol();
      Ra.sl[6]=3475; /* line # 3475 */
      Rv0=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
      Ra.sl[6]=3476; /* line # 3476 */
      if (Rv0>256) P_src_error(Rd.s+745,231,2);
    }
    Ra.sl[6]=3478; /* line # 3478 */
    if (Rv0<0||Rv0>256) Rv0=((SL *)V_typ_std.v[4])[11];
    Ra.sl[6]=3479; /* line # 3479 */
    if (Rv0<=1) (*F_aln)=0;
    else {
      Ra.sl[6]=3481; /* line # 3481 */
      (*F_aln)=1;
      Ra.sl[6]=3482; /* line # 3482 */
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3483; /* line # 3483 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " conformant_def "  */
void PAS_COMILER_PRC_00000041(V *F_tr, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+749;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3502; /* line # 3502 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[6]=3503; /* line # 3503 */
  P_ide_new_typ(22, F_tr);
  Ra.sl[6]=3504; /* line # 3504 */
  Rv2=(*F_tr);
  Ra.sl[6]=3506; /* line # 3506 */
  if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv0);
  else {
    Ra.sl[6]=3507; /* line # 3507 */
    P_src_error(Rd.s+767,232,3);
  }
  Ra.sl[6]=3508; /* line # 3508 */
  P_insymbol();
  Ra.sl[6]=3509; /* line # 3509 */
  if (V_sy_sym.ub[0]==20) {
    Ra.sl[6]=3511; /* line # 3511 */
    P_insymbol();
    Ra.sl[6]=3512; /* line # 3512 */
    if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv1);
    else {
      Ra.sl[6]=3513; /* line # 3513 */
      P_src_error(Rd.s+767,232,3);
    }
    Ra.sl[6]=3514; /* line # 3514 */
    P_insymbol();
  }
  Ra.sl[6]=3516; /* line # 3516 */
  if (V_sy_sym.ub[0]==21) {
    Ra.sl[6]=3518; /* line # 3518 */
    P_insymbol();
    Ra.sl[6]=3519; /* line # 3519 */
    PAS_COMILER_PRC_00000038(((V *)Rv2),0,NULL,0,0);
    Ra.sl[6]=3520; /* line # 3520 */
    ((SL *)Rv2)[11]=((SL *)((V *)Rv2)[0])[11];
    Ra.sl[6]=3521; /* line # 3521 */
    memcpy(Rv2+48,((V *)Rv2)[0]+48,1);
    Ra.sl[6]=3522; /* line # 3522 */
    if (Rv0!=NULL) {
      Ra.sl[6]=3524; /* line # 3524 */
      ((V *)Rv0)[4]=((V *)Rv2)[0];
      Ra.sl[6]=3525; /* line # 3525 */
      ((UB *)Rv0)[94]=8;
      Ra.sl[6]=3526; /* line # 3526 */
      ((UW *)Rv0)[46]=32;
      Ra.sl[6]=3527; /* line # 3527 */
      if (Rv1==NULL) {
        Ra.sl[6]=3529; /* line # 3529 */
        ((V *)Rv2)[13]=P_lgt_new_econst(((V *)Rv2)[0],1);
        Ra.sl[6]=3530; /* line # 3530 */
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=3531; /* line # 3531 */
        ((V *)Rv2)[12]=P_lgt_link(((V *)Rv2)[14]);
        Ra.sl[6]=3532; /* line # 3532 */
        ((V *)((V *)Rv2)[12])[3]=V_int_typ;
        Ra.sl[6]=3533; /* line # 3533 */
        (*F_ndim)=(*F_ndim)+1;
      }
      else {
        Ra.sl[6]=3537; /* line # 3537 */
        ((V *)Rv1)[4]=((V *)Rv2)[0];
        Ra.sl[6]=3538; /* line # 3538 */
        ((UB *)Rv1)[94]=8;
        Ra.sl[6]=3539; /* line # 3539 */
        ((UW *)Rv1)[46]=32;
        Ra.sl[6]=3540; /* line # 3540 */
        ((V *)Rv2)[13]=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=3541; /* line # 3541 */
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=3542; /* line # 3542 */
        Rv3=P_lgt_link(((V *)Rv2)[14]);
        Ra.sl[6]=3543; /* line # 3543 */
        ((V *)Rv3)[0]=P_lgt_link(((V *)Rv2)[13]);
        Ra.sl[6]=3544; /* line # 3544 */
        Rv3=P_lgt_new_code(50, Rv3);
        Ra.sl[6]=3545; /* line # 3545 */
        ((V *)Rv3)[0]=P_lgt_new_econst(V_int_typ,1);
        Ra.sl[6]=3546; /* line # 3546 */
        ((V *)Rv2)[12]=P_lgt_new_code(49, Rv3);
        Ra.sl[6]=3547; /* line # 3547 */
        (*F_ndim)=(*F_ndim)+2;
      }
    }
  }
  else {
    Ra.sl[6]=3550; /* line # 3550 */
    P_src_error(Rd.s+767,31,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_def "  */
void PAS_COMILER_PRC_00000042(V *F_art, UB F_bconf, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+771;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3569; /* line # 3569 */
  P_insymbol();
  Ra.sl[6]=3570; /* line # 3570 */
  if (F_bconf) P_ide_new_typ(9, F_art);
  else {
    Ra.sl[6]=3571; /* line # 3571 */
    P_ide_new_typ(8, F_art);
  }
  Ra.sl[6]=3572; /* line # 3572 */
  Rv0=(*F_art);
  Ra.sl[6]=3574; /* line # 3574 */
  ((V *)Rv0)[15]=NULL;
  Ra.sl[6]=3575; /* line # 3575 */
  if (F_bconf) {
    Ra.sl[6]=3576; /* line # 3576 */
    PAS_COMILER_PRC_00000041(((V *)Rv0)+15,F_ndim);
  }
  else {
    Ra.sl[6]=3579; /* line # 3579 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+15,0,NULL,0,0);
    Ra.sl[6]=3580; /* line # 3580 */
    (*F_ndim)=(*F_ndim)+2;
  }
  Ra.sl[6]=3582; /* line # 3582 */
  Rv1=NULL;
  Rv2=1;
  Ra.sl[6]=3583; /* line # 3583 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=3584; /* line # 3584 */
    Rv3=((V *)Rv0)[15];
    Ra.sl[6]=3586; /* line # 3586 */
    switch (((UB *)Rv3)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=3588; /* line # 3588 */
      if (((UB *)Rv3)[112]) Rv2=(((UL *)Rv3)[30]-((UL *)Rv3)[29])+1;
      else {
        Ra.sl[6]=3589; /* line # 3589 */
        Rv2=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
      break;
      case 22:Ra.sl[6]=3591; /* line # 3591 */
      Rv1=P_lgt_link(((V *)Rv3)[12]);
      break;
      default:Ra.sl[6]=3594; /* line # 3594 */
      P_src_error(Rd.s+784,210,3);
      break;
    }
  }
  Ra.sl[6]=3599; /* line # 3599 */
  if (V_sy_sym.ub[0]==17) {
    Ra.sl[6]=3601; /* line # 3601 */
    PAS_COMILER_PRC_00000042(((V *)Rv0)+14,F_bconf, F_ndim);
    Ra.sl[6]=3602; /* line # 3602 */
    ((SL *)Rv0)[24]=(*F_ndim);
  }
  else {
    Ra.sl[6]=3606; /* line # 3606 */
    ((SL *)Rv0)[24]=(*F_ndim);
    Ra.sl[6]=3607; /* line # 3607 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else {
      Ra.sl[6]=3608; /* line # 3608 */
      P_src_error(Rd.s+784,26,2);
    }
    Ra.sl[6]=3609; /* line # 3609 */
    if (V_sy_sym.ub[0]==84) P_insymbol();
    else {
      Ra.sl[6]=3610; /* line # 3610 */
      P_src_error(Rd.s+784,51,2);
    }
    Ra.sl[6]=3611; /* line # 3611 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+14,0,NULL,0,0);
  }
  Ra.sl[6]=3615; /* line # 3615 */
  if (((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=3618; /* line # 3618 */
    ((UB *)Rv0)[48]=((UB *)((V *)Rv0)[14])[48];
    Ra.sl[6]=3620; /* line # 3620 */
    Rv4=((V *)Rv0)[14];
    Ra.sl[6]=3622; /* line # 3622 */
    Rv5=NULL;
    Ra.sl[6]=3623; /* line # 3623 */
    Rv6=((SL *)Rv4)[11];
    Ra.sl[6]=3624; /* line # 3624 */
    Rv7=((V *)Rv4)[9];
    Ra.sl[6]=3625; /* line # 3625 */
    memcpy(Ra.s+28,Rv4+48,1);
    Ra.sl[6]=3626; /* line # 3626 */
    if (Rv6>0) Rv6=P_typ_alignement(Rv6, Rv4+48);
    Ra.sl[6]=3627; /* line # 3627 */
    if (Rv6>=0) Rv7=NULL;
    Ra.sl[6]=3629; /* line # 3629 */
    if (Rv7!=NULL) {
      Ra.sl[6]=3630; /* line # 3630 */
      if (((UB *)Rv7)[40]==14) Rv6=((SL *)((V *)Rv7)[7])[13];
      else {
        Ra.sl[6]=3631; /* line # 3631 */
        P_lgt_copy_tree(Rv7, &Rv5);
      }
    }
    Ra.sl[6]=3632; /* line # 3632 */
    if ((Rv5!=NULL&&((UB *)Rv0)[48]>0)&&((UB *)((V *)Rv0)[14])[92]!=8) {
      Ra.sl[6]=3635; /* line # 3635 */
      Rv8=1;
      Ra.sl[6]=3636; /* line # 3636 */
      if ((((UB *)Rv5)[40]==6&&((UB *)Rv5)[41]==49)&&((V *)Rv5)[1]!=NULL) {
        Ra.sl[6]=3639; /* line # 3639 */
        if (((V *)((V *)Rv5)[1])[0]!=NULL) {
          Ra.sl[6]=3640; /* line # 3640 */
          Rv9=((V *)((V *)Rv5)[1])[0];
          Ra.sl[6]=3641; /* line # 3641 */
          if (((UB *)Rv9)[40]==14&&((V *)Rv9)[7]!=NULL) {
            Ra.sl[6]=3643; /* line # 3643 */
            Rv10=((SL *)((V *)Rv9)[7])[13]+Ra.ub[28];
            Ra.sl[6]=3644; /* line # 3644 */
            P_val_free(((V *)Rv9)+7);
            Ra.sl[6]=3645; /* line # 3645 */
            P_val_new(((V *)Rv9)+7,V_int_typ);
            Ra.sl[6]=3646; /* line # 3646 */
            ((SL *)((V *)Rv9)[7])[13]=Rv10;
            Ra.sl[6]=3647; /* line # 3647 */
            Rv8=0;
          }
        }
      }
      Ra.sl[6]=3649; /* line # 3649 */
      if (Rv8) {
        Ra.sl[6]=3651; /* line # 3651 */
        ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
        Ra.sl[6]=3652; /* line # 3652 */
        Rv5=P_lgt_new_code(49, Rv5);
      }
      Ra.sl[6]=3654; /* line # 3654 */
      ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
      Ra.sl[6]=3655; /* line # 3655 */
      Rv5=P_lgt_new_code(13, Rv5);
    }
    Ra.sl[6]=3658; /* line # 3658 */
    ((V *)Rv0)[13]=Rv5;
    Ra.sl[6]=3659; /* line # 3659 */
    ((SL *)Rv0)[25]=Rv6;
    Ra.sl[6]=3662; /* line # 3662 */
    if (((UB *)((V *)Rv0)[14])[90]||((SL *)((V *)Rv0)[14])[10]>0) {
      Ra.sl[6]=3663; /* line # 3663 */
      ((UB *)Rv0)[90]=1;
    }
    Ra.sl[6]=3666; /* line # 3666 */
    ((SL *)Rv0)[11]=((SL *)Rv0)[25]*Rv2;
    Ra.sl[6]=3667; /* line # 3667 */
    if (Rv1==NULL&&((V *)Rv0)[13]==NULL) {
      Ra.sl[6]=3668; /* line # 3668 */
      ((V *)Rv0)[9]=NULL;
    }
    else {
      Ra.sl[6]=3671; /* line # 3671 */
      if (Rv1==NULL) {
        Ra.sl[6]=3673; /* line # 3673 */
        Rv1=P_lgt_new_econst(V_int_typ, Rv2);
        Ra.sl[6]=3674; /* line # 3674 */
        ((V *)Rv1)[0]=((V *)Rv0)[13];
        Ra.sl[6]=3675; /* line # 3675 */
        ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
      }
      else {
        Ra.sl[6]=3678; /* line # 3678 */
        if (((V *)Rv0)[13]==NULL) {
          Ra.sl[6]=3679; /* line # 3679 */
          if (((SL *)Rv0)[25]==1) {
            Ra.sl[6]=3680; /* line # 3680 */
            ((V *)Rv0)[9]=Rv1;
          }
          else {
            Ra.sl[6]=3683; /* line # 3683 */
            ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
            Ra.sl[6]=3684; /* line # 3684 */
            ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
          }
        }
        else {
          Ra.sl[6]=3688; /* line # 3688 */
          ((V *)Rv1)[0]=((V *)Rv0)[13];
          Ra.sl[6]=3689; /* line # 3689 */
          ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
        }
      }
      Ra.sl[6]=3691; /* line # 3691 */
      ((SL *)Rv0)[11]=-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_spc "  */
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  SL Rv24;
  SL Rv25;
  register V Rv26;
  SL Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;
  register V Rv31;
  register V Rv32;
  V Rv33;
  register V Rv34;
  register V Rv35;
  V Rv36;
  V Rv37;
  register V Rv38;
  register UB Rv39;
  register V Rv40;
  SL Rv41;
  V Rv42;
  register V Rv43;
  register V Rv44;
  register V Rv45;
  register V Rv46;
  register V Rv47;
  register V Rv48;
  register V Rv49;
  register V Rv50;
  register V Rv51;
  register V Rv52;
  register V Rv53;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+788;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3719; /* line # 3719 */
  Rv0=V_sy_descr_size;
  Ra.sl[6]=3720; /* line # 3720 */
  V_sy_descr_size=0;
  Ra.sl[6]=3721; /* line # 3721 */
  V_sy_type_gfirst=NULL;
  Ra.sl[6]=3722; /* line # 3722 */
  Ra.sl[6]=3724; /* line # 3724 */
  Rv1=NULL;
  Ra.sl[6]=3725; /* line # 3725 */
  if (V_sy_sym.ub[0]==37) P_insymbol();
  Ra.sl[6]=3726; /* line # 3726 */
  switch (V_sy_sym.ub[0]) {
    case 29:Ra.sl[6]=3729; /* line # 3729 */
    Rv0=0;
    Ra.sl[6]=3730; /* line # 3730 */
    P_insymbol();
    Ra.sl[6]=3732; /* line # 3732 */
    if (V_sy_sym.ub[0]!=56) P_src_error(Rd.s+800,182,2);
    else {
      Ra.sl[6]=3733; /* line # 3733 */
      P_insymbol();
    }
    Ra.sl[6]=3734; /* line # 3734 */
    P_ide_new_typ(27, &Rv1);
    Ra.sl[6]=3735; /* line # 3735 */
    ((V *)Rv1)[9]=PAS_COMILER_PRC_00000004(29,NULL);
    break;
    case 58:Ra.sl[6]=3740; /* line # 3740 */
    P_insymbol();
    Ra.sl[6]=3741; /* line # 3741 */
    Rv2=P_ide_search(2);
    Ra.sl[6]=3742; /* line # 3742 */
    P_insymbol();
    Ra.sl[6]=3743; /* line # 3743 */
    if (Rv2!=V_ide_udptr.v[1]) {
      Ra.sl[6]=3744; /* line # 3744 */
      Rv19=Rv2;
      Ra.sl[6]=3746; /* line # 3746 */
      P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv1);
      Ra.sl[6]=3747; /* line # 3747 */
      V_sy_type_gfirst=((V *)Rv19)[10];
      Ra.sl[6]=3748; /* line # 3748 */
      Rv20=Rv1;
      Ra.sl[6]=3750; /* line # 3750 */
      ((V *)Rv20)[0]=((V *)Rv19)[4];
      Ra.sl[6]=3751; /* line # 3751 */
      ((V *)Rv20)[4]=((V *)((V *)Rv20)[0])[4];
      Ra.sl[6]=3752; /* line # 3752 */
      ((SL *)Rv20)[11]=((SL *)((V *)Rv20)[0])[11];
      Ra.sl[6]=3753; /* line # 3753 */
      ((SL *)Rv20)[10]=((SL *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3754; /* line # 3754 */
      memcpy(Rv20+48,((V *)Rv20)[0]+48,1);
      Ra.sl[6]=3755; /* line # 3755 */
      ((V *)Rv20)[10]=((V *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3756; /* line # 3756 */
      ((UB *)Rv20)[90]=((UB *)((V *)Rv20)[0])[90];
      Ra.sl[6]=3757; /* line # 3757 */
      if (((V *)Rv20)[9]!=NULL) {
        Ra.sl[6]=3758; /* line # 3758 */
        ((V *)Rv20)[9]=P_lgt_link(((V *)((V *)Rv20)[0])[9]);
      }
      Ra.sl[6]=3759; /* line # 3759 */
      switch (((UB *)Rv20)[92]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=3762; /* line # 3762 */
        ((SL *)Rv20)[29]=((SL *)((V *)Rv20)[0])[29];
        Ra.sl[6]=3763; /* line # 3763 */
        ((SL *)Rv20)[30]=((SL *)((V *)Rv20)[0])[30];
        Ra.sl[6]=3764; /* line # 3764 */
        ((UB *)Rv20)[112]=((UB *)((V *)Rv20)[0])[112];
        Ra.sl[6]=3765; /* line # 3765 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 22:Ra.sl[6]=3770; /* line # 3770 */
        ((V *)Rv20)[12]=P_lgt_link(((V *)((V *)Rv20)[0])[12]);
        Ra.sl[6]=3771; /* line # 3771 */
        ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        Ra.sl[6]=3772; /* line # 3772 */
        ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        break;
        case 3:
        case 4:break;
        case 5:
        case 7:
        case 24:
        case 26:Ra.sl[6]=3779; /* line # 3779 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 11:
        case 12:Ra.sl[6]=3782; /* line # 3782 */
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        break;
        case 8:Ra.sl[6]=3786; /* line # 3786 */
        ((SL *)Rv20)[25]=((SL *)((V *)Rv20)[0])[25];
        Ra.sl[6]=3787; /* line # 3787 */
        if (((V *)((V *)Rv20)[0])[13]!=NULL) {
          Ra.sl[6]=3788; /* line # 3788 */
          ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        }
        else {
          Ra.sl[6]=3791; /* line # 3791 */
          ((V *)Rv20)[13]=NULL;
        }
        Ra.sl[6]=3792; /* line # 3792 */
        ((V *)Rv20)[14]=((V *)((V *)Rv20)[0])[14];
        Ra.sl[6]=3793; /* line # 3793 */
        ((V *)Rv20)[15]=((V *)((V *)Rv20)[0])[15];
        break;
        case 10:Ra.sl[6]=3798; /* line # 3798 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        Ra.sl[6]=3799; /* line # 3799 */
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        Ra.sl[6]=3800; /* line # 3800 */
        if (((V *)((V *)Rv20)[0])[14]!=NULL) {
          Ra.sl[6]=3801; /* line # 3801 */
          ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        }
        else {
          Ra.sl[6]=3803; /* line # 3803 */
          ((V *)Rv20)[14]=NULL;
        }
        break;
        case 14:
        case 15:
        case 19:
        case 21:Ra.sl[6]=3811; /* line # 3811 */
        Rv11=((SL *)Rv20)[11];
        Ra.sl[6]=3812; /* line # 3812 */
        Rv12=((UB *)Rv20)[48];
        Ra.sl[6]=3813; /* line # 3813 */
        PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
        Ra.sl[6]=3814; /* line # 3814 */
        if (Rv11<((SL *)Rv20)[11]) P_src_error(Rd.s+800,214,2);
        else {
          Ra.sl[6]=3815; /* line # 3815 */
          ((SL *)Rv20)[11]=Rv11;
        }
        Ra.sl[6]=3816; /* line # 3816 */
        if (Rv12>=0) ((UB *)Rv20)[48]=Rv12;
        break;
        default:Ra.sl[6]=3821; /* line # 3821 */
        P_src_error(Rd.s+800,206,3);
        break;
      }
    }
    break;
    case 43:Ra.sl[6]=3829; /* line # 3829 */
    if (F_parm!=NULL) P_src_error(Rd.s+800,207,2);
    Ra.sl[6]=3830; /* line # 3830 */
    P_insymbol();
    Ra.sl[6]=3831; /* line # 3831 */
    if (V_sy_sym.ub[0]==38) {
      Ra.sl[6]=3832; /* line # 3832 */
      if (F_bdeforg) {
        Ra.sl[6]=3834; /* line # 3834 */
        P_insymbol();
        Ra.sl[6]=3835; /* line # 3835 */
        P_ide_new_typ(24, &Rv1);
        Ra.sl[6]=3836; /* line # 3836 */
        Rv21=Rv1;
        Ra.sl[6]=3838; /* line # 3838 */
        ((V *)Rv21)[12]=NULL;
        Ra.sl[6]=3839; /* line # 3839 */
        ((SL *)Rv21)[11]=V_fptr_size;
        Ra.sl[6]=3840; /* line # 3840 */
        memcpy(Rv21+48,V_typ_std.v[5]+48,1);
        Ra.sl[6]=3841; /* line # 3841 */
        ((V *)Rv21)[9]=NULL;
      }
      else {
        Ra.sl[6]=3845; /* line # 3845 */
        P_src_error(Rd.s+800,208,3);
      }
    }
    else {
      Ra.sl[6]=3848; /* line # 3848 */
      P_ide_new_typ(26, &Rv1);
      Ra.sl[6]=3849; /* line # 3849 */
      Rv22=Rv1;
      Ra.sl[6]=3851; /* line # 3851 */
      ((V *)Rv22)[12]=NULL;
      Ra.sl[6]=3852; /* line # 3852 */
      ((V *)Rv22)[9]=NULL;
      Ra.sl[6]=3854; /* line # 3854 */
      memcpy(Rv22+48,V_typ_std.v[2]+48,1);
      Ra.sl[6]=3855; /* line # 3855 */
      ((SL *)Rv22)[11]=1;
    }
    Ra.sl[6]=3858; /* line # 3858 */
    Rv23=Rv1;
    Ra.sl[6]=3861; /* line # 3861 */
    Rv11=((SL *)Rv23)[11];
    Ra.sl[6]=3862; /* line # 3862 */
    Rv12=((UB *)Rv23)[48];
    Ra.sl[6]=3863; /* line # 3863 */
    PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
    Ra.sl[6]=3864; /* line # 3864 */
    if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
    Ra.sl[6]=3865; /* line # 3865 */
    if (Rv11<((SL *)Rv23)[11]) P_src_error(Rd.s+800,214,2);
    else {
      Ra.sl[6]=3866; /* line # 3866 */
      ((SL *)Rv23)[11]=Rv11;
    }
    Ra.sl[6]=3867; /* line # 3867 */
    if (Rv12>=0) ((UB *)Rv23)[48]=Rv12;
    break;
    case 40:Ra.sl[6]=3873; /* line # 3873 */
    P_insymbol();
    Ra.sl[6]=3874; /* line # 3874 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+800,25,2);
    Ra.sl[6]=3875; /* line # 3875 */
    Rv24=0;
    Ra.sl[6]=3876; /* line # 3876 */
    PAS_COMILER_PRC_00000042(&Rv1,0, &Rv24);
    Ra.sl[6]=3878; /* line # 3878 */
    if (V_ima_typ==NULL) V_ima_typ=Rv1;
    break;
    case 41:Ra.sl[6]=3883; /* line # 3883 */
    Rv25=V_curr_disp;
    Ra.sl[6]=3884; /* line # 3884 */
    P_ide_new_typ(10, &Rv1);
    Ra.sl[6]=3885; /* line # 3885 */
    Rv26=Rv1;
    Ra.sl[6]=3887; /* line # 3887 */
    ((SL *)Rv26)[10]=F_descr_sz;
    Ra.sl[6]=3888; /* line # 3888 */
    ((SL *)Rv26)[11]=((SL *)Rv26)[10];
    Ra.sl[6]=3889; /* line # 3889 */
    ((V *)Rv26)[12]=NULL;
    ((V *)Rv26)[13]=NULL;
    Ra.sl[6]=3890; /* line # 3890 */
    ((V *)Rv26)[14]=NULL;
    Ra.sl[6]=3891; /* line # 3891 */
    Rv2=NULL;
    Ra.sl[6]=3893; /* line # 3893 */
    P_insymbol();
    Ra.sl[6]=3894; /* line # 3894 */
    P_new_disp_level(NULL,1);
    Ra.sl[6]=3895; /* line # 3895 */
    Lx[5].ub[0]=0;
    Ra.sl[6]=3896; /* line # 3896 */
    PAS_COMILER_PRC_00000037(6,((SL *)Rv1)+11,&Rv27, Rv1);
    Ra.sl[6]=3897; /* line # 3897 */
    Rv28=Rv1;
    Ra.sl[6]=3899; /* line # 3899 */
    ((UB *)Rv28)[90]=Lx[5].ub[0];
    Ra.sl[6]=3900; /* line # 3900 */
    ((V *)Rv28)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    Ra.sl[6]=3901; /* line # 3901 */
    if (((V *)Rv28)[14]==NULL) {
      Ra.sl[6]=3902; /* line # 3902 */
      ((V *)Rv28)[13]=V_lex_ident_tree.v[V_curr_disp*8+4];
    }
    Ra.sl[6]=3904; /* line # 3904 */
    V_curr_disp=V_curr_disp -1;
    Ra.sl[6]=3907; /* line # 3907 */
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else P_src_error(Rd.s+800,54,2);
    Ra.sl[6]=3908; /* line # 3908 */
    if (V_typ_std.v[10]==NULL) {
      Ra.sl[6]=3910; /* line # 3910 */
      V_typ_std.v[10]=Rv1;
      Ra.sl[6]=3911; /* line # 3911 */
      Rv29=Rv1;
      Ra.sl[6]=3913; /* line # 3913 */
      V_stri_descrsz=((SL *)Rv29)[10];
      Ra.sl[6]=3914; /* line # 3914 */
      V_stri_lengthsz=((SL *)((V *)((V *)Rv29)[12])[4])[11];
      Ra.sl[6]=3915; /* line # 3915 */
      V_stri_stroffset=((SL *)((V *)((V *)Rv29)[12])[3])[15];
    }
    break;
    case 39:Ra.sl[6]=3922; /* line # 3922 */
    P_insymbol();
    Ra.sl[6]=3923; /* line # 3923 */
    if (V_sy_sym.ub[0]==84) P_insymbol();
    else P_src_error(Rd.s+800,51,2);
    Ra.sl[6]=3924; /* line # 3924 */
    P_ide_new_typ(7, &Rv1);
    Ra.sl[6]=3925; /* line # 3925 */
    Rv30=Rv1;
    Ra.sl[6]=3927; /* line # 3927 */
    memcpy(Rv30+48,V_typ_std.v[16]+48,1);
    Ra.sl[6]=3928; /* line # 3928 */
    ((SL *)Rv30)[11]=((SL *)V_typ_std.v[16])[11];
    Ra.sl[6]=3929; /* line # 3929 */
    ((V *)Rv30)[10]=((V *)V_typ_std.v[16])[10];
    Ra.sl[6]=3930; /* line # 3930 */
    ((V *)Rv30)[0]=V_typ_std.v[16];
    Ra.sl[6]=3932; /* line # 3932 */
    PAS_COMILER_PRC_00000038(((V *)Rv30)+12,0,NULL,0,0);
    Ra.sl[6]=3935; /* line # 3935 */
    if (((UB *)((V *)Rv30)[12])[90]||((SL *)((V *)Rv30)[12])[10]>0) ((UB *)Rv30)
    [90]=1;
    Ra.sl[6]=3937; /* line # 3937 */
    if (((SL *)((V *)Rv30)[12])[11]<=0) P_src_error(Rd.s+800,149,3);
    Ra.sl[6]=3939; /* line # 3939 */
    if (V_typ_std.v[7]==NULL) {
      Ra.sl[6]=3941; /* line # 3941 */
      V_typ_std.v[7]=Rv1;
    }
    break;
    case 23:
    case 38:Ra.sl[6]=3947; /* line # 3947 */
    P_insymbol();
    Ra.sl[6]=3948; /* line # 3948 */
    if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
      Ra.sl[6]=3949; /* line # 3949 */
      Rv1=PAS_COMILER_PRC_00000002(V_sy_sym.ub[0]==77);
    }
    else {
      Ra.sl[6]=3952; /* line # 3952 */
      P_ide_new_typ(5, &Rv1);
      Ra.sl[6]=3953; /* line # 3953 */
      Rv31=Rv1;
      Ra.sl[6]=3955; /* line # 3955 */
      memcpy(Rv31+48,V_typ_std.v[13]+48,1);
      Ra.sl[6]=3956; /* line # 3956 */
      ((SL *)Rv31)[11]=V_fptr_size;
      Ra.sl[6]=3957; /* line # 3957 */
      ((V *)Rv31)[0]=V_typ_std.v[13];
      Ra.sl[6]=3958; /* line # 3958 */
      V_err_prt=0;
      Ra.sl[6]=3959; /* line # 3959 */
      Rv2=P_ide_search(2);
      Ra.sl[6]=3960; /* line # 3960 */
      V_err_prt=1;
      Ra.sl[6]=3961; /* line # 3961 */
      if (Rv2==NULL) {
        Ra.sl[6]=3963; /* line # 3963 */
        P_ide_new(1, Rv1, &Rv2);
        Ra.sl[6]=3964; /* line # 3964 */
        ((V *)Rv2)[8]=Lx[5].v[1];
        Ra.sl[6]=3965; /* line # 3965 */
        Lx[5].v[1]=Rv2;
      }
      else {
        Ra.sl[6]=3967; /* line # 3967 */
        ((V *)Rv31)[12]=((V *)Rv2)[4];
      }
      Ra.sl[6]=3968; /* line # 3968 */
      P_insymbol();
      Ra.sl[6]=3970; /* line # 3970 */
      V_sy_type_gfirst=P_new_oper(0, Rv1, V_typ_std.v[5],0,128,NULL,0,0);
    }
    break;
    case 13:Ra.sl[6]=3976; /* line # 3976 */
    if (V_ima_typ!=NULL) {
      Ra.sl[6]=3977; /* line # 3977 */
      if (((V *)V_ima_typ)[4]!=NULL) {
        Ra.sl[6]=3979; /* line # 3979 */
        P_insymbol();
        Ra.sl[6]=3980; /* line # 3980 */
        if (((SL *)V_typ_std.v[1])[30]==0) {
          Ra.sl[6]=3981; /* line # 3981 */
          Rv1=V_typ_std.v[1];
        }
        else {
          Ra.sl[6]=3983; /* line # 3983 */
          P_ide_new_typ(1, &Rv1);
        }
        Ra.sl[6]=3984; /* line # 3984 */
        Rv32=Rv1;
        Ra.sl[6]=3986; /* line # 3986 */
        ((SL *)Rv32)[11]=((SL *)V_typ_std.v[0])[11];
        Ra.sl[6]=3987; /* line # 3987 */
        ((SL *)Rv32)[29]=0;
        Ra.sl[6]=3988; /* line # 3988 */
        ((SL *)Rv32)[30]=-1;
        ((V *)Rv32)[0]=NULL;
        Ra.sl[6]=3989; /* line # 3989 */
        ((UB *)Rv32)[112]=1;
        Ra.sl[6]=3990; /* line # 3990 */
        memcpy(Rv32+48,V_typ_std.v[0]+48,1);
        Ra.sl[6]=3991; /* line # 3991 */
        Rv25=0;
        Ra.sl[6]=3992; /* line # 3992 */
        Rv33=NULL;
        Ra.sl[6]=3993; /* line # 3993 */
        Rv11=0;
        Ra.sl[6]=3994; /* line # 3994 */
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=3996; /* line # 3996 */
          if (V_sy_ident.ub[0]>Rv25) Rv25=V_sy_ident.ub[0];
          Ra.sl[6]=3997; /* line # 3997 */
          P_ide_new(4, Rv1, &Rv2);
          Ra.sl[6]=3999; /* line # 3999 */
          if (((V *)Rv32)[12]==NULL) ((V *)Rv32)[12]=Rv2;
          Ra.sl[6]=4000; /* line # 4000 */
          ((SL *)Rv32)[30]=((SL *)Rv32)[30]+1;
          Ra.sl[6]=4001; /* line # 4001 */
          Rv34=Rv2;
          Ra.sl[6]=4004; /* line # 4004 */
          P_val_new(((V *)Rv34)+8,Rv1);
          Ra.sl[6]=4005; /* line # 4005 */
          Rv35=((V *)Rv34)[8];
          Ra.sl[6]=4007; /* line # 4007 */
          ((UB *)Rv35)[48]=1;
          Ra.sl[6]=4008; /* line # 4008 */
          ((SL *)Rv35)[13]=((SL *)Rv32)[30];
          Ra.sl[6]=4010; /* line # 4010 */
          Rv36=NULL;
          Ra.sl[6]=4012; /* line # 4012 */
          P_val_new(&Rv36,NULL);
          Ra.sl[6]=4014; /* line # 4014 */
          if (Rv33==NULL) Rv33=Rv36;
          else {
            Ra.sl[6]=4015; /* line # 4015 */
            ((V *)Rv37)[0]=Rv36;
          }
          Ra.sl[6]=4016; /* line # 4016 */
          Rv37=Rv36;
          Ra.sl[6]=4017; /* line # 4017 */
          Rv38=Rv36;
          Ra.sl[6]=4019; /* line # 4019 */
          ((UB *)Rv38)[48]=29;
          Ra.sl[6]=4020; /* line # 4020 */
          ((SL *)Rv38)[6]=0;
          Ra.sl[6]=4021; /* line # 4021 */
          Rv39=V_sy_ident.ub[0]+1;
          ((V *)Rv38)[7]=PAS__NEW((SL)Rv39+2);
          ((UB *)((V *)Rv38)[7])[0]=Rv39;
          Ra.sl[6]=4022; /* line # 4022 */
          ((V *)Rv38)[4]=((V *)V_ima_typ)[14];
          Ra.sl[6]=4023; /* line # 4023 */
          Rv40=((V *)Rv38)[7];
          Ra.sl[6]=4025; /* line # 4025 */
          ((UB *)Rv40)[1]=V_sy_ident.ub[0]+1;
          Ra.sl[6]=4026; /* line # 4026 */
          ((C *)Rv40)[2]=V_sy_ident.c[0];
          Ra.sl[6]=4027; /* line # 4027 */
          Rv41=1;
          for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
            Ra.sl[6]=4028; /* line # 4028 */
            ((C *)Rv40)[(Rv41+1)+1]=V_sy_ident.c[Rv41];
            Rv41++;
          }
          Ra.sl[6]=4032; /* line # 4032 */
          P_insymbol();
          Ra.sl[6]=4033; /* line # 4033 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=4035; /* line # 4035 */
            if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+800,23,2);
          }
          Ra.sl[6]=4036; /* line # 4036 */
          if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+800,27,2);
        }
        Ra.sl[6]=4038; /* line # 4038 */
        P_insymbol();
        Ra.sl[6]=4040; /* line # 4040 */
        Rv6=P_lgt_new_econst(V_typ_std.v[2],Rv25);
        Ra.sl[6]=4041; /* line # 4041 */
        Rv7=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv32)[30]);
        Ra.sl[6]=4042; /* line # 4042 */
        ((V *)Rv7)[0]=Rv6;
        Ra.sl[6]=4043; /* line # 4043 */
        Rv42=P_type_parm_set(((V *)V_ima_typ)[3],Rv7);
        Ra.sl[6]=4045; /* line # 4045 */
        Rv36=Rv33;
        Ra.sl[6]=4046; /* line # 4046 */
        while (Rv36!=NULL){
          Ra.sl[6]=4047; /* line # 4047 */
          Rv43=Rv36;
          Ra.sl[6]=4049; /* line # 4049 */
          ((SL *)Rv43)[6]=Rv25+1;
          Ra.sl[6]=4050; /* line # 4050 */
          Rv36=((V *)Rv43)[0];
        }
        Ra.sl[6]=4054; /* line # 4054 */
        Rv44=((V *)V_ima_typ)[4];
        Ra.sl[6]=4055; /* line # 4055 */
        if (((V *)Rv44)[3]!=NULL) {
          Ra.sl[6]=4057; /* line # 4057 */
          P_val_new(&Rv36,((V *)((V *)Rv44)[3])[4]);
          Ra.sl[6]=4058; /* line # 4058 */
          Rv45=Rv36;
          Rv46=((V *)Rv44)[3];
          Ra.sl[6]=4060; /* line # 4060 */
          ((SL *)Rv45)[13]=Rv25;
          Ra.sl[6]=4061; /* line # 4061 */
          if (((V *)Rv46)[4]!=NULL) ((SL *)Rv45)[6]=((SL *)((V *)Rv46)[4])[11];
          Ra.sl[6]=4062; /* line # 4062 */
          ((V *)Rv45)[0]=Rv33;
          Ra.sl[6]=4064; /* line # 4064 */
          Rv33=Rv36;
          Ra.sl[6]=4065; /* line # 4065 */
          Rv36=NULL;
          P_val_new(&Rv36,((V *)Rv44)[4]);
          Ra.sl[6]=4066; /* line # 4066 */
          Rv47=Rv36;
          Ra.sl[6]=4068; /* line # 4068 */
          ((SL *)Rv47)[13]=((SL *)Rv32)[30];
          Ra.sl[6]=4069; /* line # 4069 */
          if (((V *)Rv44)[4]!=NULL) ((SL *)Rv47)[6]=((SL *)((V *)Rv44)[4])[11];
          Ra.sl[6]=4070; /* line # 4070 */
          ((V *)Rv47)[0]=Rv33;
          Ra.sl[6]=4072; /* line # 4072 */
          Rv33=Rv36;
        }
        Ra.sl[6]=4074; /* line # 4074 */
        P_lgt_new(((V *)Rv32)+13,Rv42,14,NULL);
        Ra.sl[6]=4075; /* line # 4075 */
        P_val_new(((V *)((V *)Rv32)[13])+7,Rv42);
        Ra.sl[6]=4076; /* line # 4076 */
        Rv48=((V *)Rv32)[13];
        Rv49=((V *)Rv48)[7];
        Ra.sl[6]=4078; /* line # 4078 */
        ((SL *)Rv49)[6]=((SL *)Rv42)[11];
        Ra.sl[6]=4079; /* line # 4079 */
        ((V *)Rv49)[7]=Rv33;
        Ra.sl[6]=4081; /* line # 4081 */
        if (((SL *)Rv32)[30]>255) {
          Ra.sl[6]=4084; /* line # 4084 */
          if (((SL *)Rv32)[30]>65535) ((SL *)Rv32)[11]=4;
          else {
            Ra.sl[6]=4085; /* line # 4085 */
            ((SL *)Rv32)[11]=2;
          }
        }
        Ra.sl[6]=4088; /* line # 4088 */
        Rv11=((SL *)Rv32)[11];
        Ra.sl[6]=4089; /* line # 4089 */
        Rv12=Rv11-1;
        Ra.sl[6]=4090; /* line # 4090 */
        PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
        Ra.sl[6]=4091; /* line # 4091 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
        Ra.sl[6]=4092; /* line # 4092 */
        if (Rv11<((SL *)Rv32)[11]) P_src_error(Rd.s+800,214,2);
        else {
          Ra.sl[6]=4093; /* line # 4093 */
          ((SL *)Rv32)[11]=Rv11;
        }
        Ra.sl[6]=4094; /* line # 4094 */
        if (Rv12>=0) ((UB *)Rv32)[48]=Rv12;
        Ra.sl[6]=4097; /* line # 4097 */
        V_sy_type_gfirst=P_new_oper(0, Rv1, V_typ_std.v[15],0,0,NULL,0,0);
      }
    }
    break;
    case 42:Ra.sl[6]=4102; /* line # 4102 */
    P_insymbol();
    Ra.sl[6]=4103; /* line # 4103 */
    if (V_sy_sym.ub[0]==84) P_insymbol();
    else P_src_error(Rd.s+800,51,2);
    Ra.sl[6]=4104; /* line # 4104 */
    PAS_COMILER_PRC_00000038(&Rv42,0,NULL,0,0);
    Ra.sl[6]=4105; /* line # 4105 */
    if (((UB *)Rv42)[92]>2) {
      Ra.sl[6]=4107; /* line # 4107 */
      P_src_error(Rd.s+800,215,3);
      Ra.sl[6]=4108; /* line # 4108 */
      Rv42=V_typ_std.v[1];
    }
    Ra.sl[6]=4111; /* line # 4111 */
    Rv13=((SL *)Rv42)[30]+1;
    Ra.sl[6]=4112; /* line # 4112 */
    if (Rv13>V_dst_seta) Rv13=V_dst_seta;
    Ra.sl[6]=4114; /* line # 4114 */
    Rv25=(Rv13+7)/8;
    Ra.sl[6]=4116; /* line # 4116 */
    if (Rv25>2) Rv25=((Rv25+3)/4)*4;
    Ra.sl[6]=4119; /* line # 4119 */
    if (Rv13>V_dst_setw) {
      Ra.sl[6]=4121; /* line # 4121 */
      P_ide_new_typ(12, &Rv1);
      Ra.sl[6]=4122; /* line # 4122 */
      Rv12=((UB *)V_typ_std.v[18])[48];
    }
    else {
      Ra.sl[6]=4126; /* line # 4126 */
      P_ide_new_typ(11, &Rv1);
      Ra.sl[6]=4127; /* line # 4127 */
      Rv11=1;
      Ra.sl[6]=4128; /* line # 4128 */
      switch (Rv25) {
        case 1:Ra.sl[6]=4129; /* line # 4129 */
        Rv12=0;
        break;
        case 2:Ra.sl[6]=4130; /* line # 4130 */
        Rv12=1;
        break;
        case 3:
        case 4:Ra.sl[6]=4131; /* line # 4131 */
        Rv12=3;
        break;
        default:Ra.sl[6]=4133; /* line # 4133 */
        Rv12=((UB *)V_typ_std.v[17])[48];
        break;
      }
    }
    Ra.sl[6]=4136; /* line # 4136 */
    Rv50=Rv1;
    Ra.sl[6]=4138; /* line # 4138 */
    ((SL *)Rv50)[24]=Rv13;
    Ra.sl[6]=4139; /* line # 4139 */
    ((V *)Rv50)[13]=Rv42;
    Ra.sl[6]=4140; /* line # 4140 */
    ((SL *)Rv50)[11]=Rv25;
    Ra.sl[6]=4141; /* line # 4141 */
    Rv11=Rv25;
    Ra.sl[6]=4142; /* line # 4142 */
    PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
    Ra.sl[6]=4144; /* line # 4144 */
    if (Rv25>Rv11) {
      Ra.sl[6]=4146; /* line # 4146 */
      P_src_error(Rd.s+800,214,1);
      Ra.sl[6]=4147; /* line # 4147 */
      Rv11=Rv25;
    }
    Ra.sl[6]=4150; /* line # 4150 */
    ((SL *)Rv50)[11]=Rv11;
    Ra.sl[6]=4151; /* line # 4151 */
    if (Rv12>=0) ((UB *)Rv50)[48]=Rv12;
    Ra.sl[6]=4153; /* line # 4153 */
    if (Rv42!=NULL) {
      Ra.sl[6]=4154; /* line # 4154 */
      Rv51=Rv42;
      Ra.sl[6]=4155; /* line # 4155 */
      if (((UB *)Rv51)[92]==2) {
        Ra.sl[6]=4156; /* line # 4156 */
        Rv52=V_usi_tab;
        Ra.sl[6]=4158; /* line # 4158 */
        P_lgt_new(((V *)Rv51)+13,((V *)Rv52)[4],14,NULL);
        Ra.sl[6]=4159; /* line # 4159 */
        P_val_copy(((V *)Rv52)+8,((V *)((V *)Rv51)[13])+7,0);
      }
      else {
        Ra.sl[6]=4161; /* line # 4161 */
        if (((UB *)Rv51)[92]==0) {
          Ra.sl[6]=4162; /* line # 4162 */
          Rv53=V_csi_tab;
          Ra.sl[6]=4164; /* line # 4164 */
          P_lgt_new(((V *)Rv51)+13,((V *)Rv53)[4],14,NULL);
          Ra.sl[6]=4165; /* line # 4165 */
          P_val_copy(((V *)Rv53)+8,((V *)((V *)Rv51)[13])+7,0);
        }
      }
    }
    break;
    case 44:Ra.sl[6]=4172; /* line # 4172 */
    P_src_error(Rd.s+800,219,2);
    Ra.sl[6]=4173; /* line # 4173 */
    Rv1=NULL;
    break;
    case 56:Ra.sl[6]=4178; /* line # 4178 */
    Rv6=PAS_COMILER_PRC_00000004(2,NULL);
    Ra.sl[6]=4179; /* line # 4179 */
    Rv1=((V *)Rv6)[3];
    P_lgt_free(&Rv6);
    break;
    default:Ra.sl[6]=4184; /* line # 4184 */
    Rv1=NULL;
    Ra.sl[6]=4185; /* line # 4185 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=4187; /* line # 4187 */
      Rv2=P_ide_search(534);
      Ra.sl[6]=4188; /* line # 4188 */
      Rv1=((V *)Rv2)[4];
      Ra.sl[6]=4189; /* line # 4189 */
      if (Rv2!=V_ide_udptr.v[1]) {
        Ra.sl[6]=4191; /* line # 4191 */
        if (((UB *)Rv2)[56]==1) {
          Ra.sl[6]=4193; /* line # 4193 */
          Rv1=((V *)Rv2)[4];
          Ra.sl[6]=4194; /* line # 4194 */
          P_insymbol();
          Ra.sl[6]=4196; /* line # 4196 */
          V_sy_type_gfirst=((V *)Rv2)[10];
          Ra.sl[6]=4197; /* line # 4197 */
          if (V_sy_sym.ub[0]==13) {
            Ra.sl[6]=4199; /* line # 4199 */
            Rv3=Rv2;
            Ra.sl[6]=4200; /* line # 4200 */
            if (((V *)((V *)Rv3)[4])[4]==NULL) {
              Ra.sl[6]=4202; /* line # 4202 */
              P_src_error(Rd.s+800,206,2);
              Ra.sl[6]=4203; /* line # 4203 */
              P_skip_symbol(14,0,0);
            }
            else {
              Ra.sl[6]=4207; /* line # 4207 */
              Rv4=NULL;
              Ra.sl[6]=4208; /* line # 4208 */
              Rv5=((V *)((V *)Rv3)[4])[4];
              Ra.sl[6]=4209; /* line # 4209 */
              V_sy_sym.ub[0]=17;
              Ra.sl[6]=4210; /* line # 4210 */
              while (Rv5!=NULL){
                Ra.sl[6]=4212; /* line # 4212 */
                if (V_sy_sym.ub[0]==17) P_insymbol();
                Ra.sl[6]=4213; /* line # 4213 */
                if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==14) {
                  Ra.sl[6]=4214; /* line # 4214 */
                  if (((V *)Rv5)[11]!=NULL) {
                    Ra.sl[6]=4216; /* line # 4216 */
                    P_lgt_new(&Rv6,((V *)Rv5)[4],14,NULL);
                    Ra.sl[6]=4217; /* line # 4217 */
                    ((V *)Rv6)[7]=((V *)Rv5)[11];
                    Ra.sl[6]=4218; /* line # 4218 */
                    P_val_new(((V *)Rv5)+11,((V *)Rv5)[4]);
                  }
                  else {
                    Ra.sl[6]=4220; /* line # 4220 */
                    P_src_error_s(Rd.s+800,228,3,((V *)Rv5)[0],NULL);
                  }
                }
                else {
                  Ra.sl[6]=4222; /* line # 4222 */
                  Rv6=PAS_COMILER_PRC_00000005(((V *)Rv5)[4],0,0,0);
                }
                Ra.sl[6]=4224; /* line # 4224 */
                if (Rv4==NULL) Rv4=Rv6;
                else {
                  Ra.sl[6]=4225; /* line # 4225 */
                  ((V *)Rv7)[0]=Rv6;
                }
                Ra.sl[6]=4226; /* line # 4226 */
                Rv7=Rv6;
                Ra.sl[6]=4227; /* line # 4227 */
                Rv5=((V *)Rv5)[3];
              }
              Ra.sl[6]=4229; /* line # 4229 */
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else {
                Ra.sl[6]=4230; /* line # 4230 */
                P_src_error(Rd.s+800,23,2);
              }
              Ra.sl[6]=4231; /* line # 4231 */
              Rv1=P_type_parm_set(Rv2, Rv4);
            }
          }
          else {
            Ra.sl[6]=4235; /* line # 4235 */
            Rv8=Rv2;
            Ra.sl[6]=4237; /* line # 4237 */
            if (((UB *)((V *)Rv8)[4])[92]==24) {
              Ra.sl[6]=4239; /* line # 4239 */
              if (V_sy_sym.ub[0]==84) {
                Ra.sl[6]=4241; /* line # 4241 */
                P_insymbol();
                Ra.sl[6]=4242; /* line # 4242 */
                Rv9=P_ide_search(2);
                Ra.sl[6]=4243; /* line # 4243 */
                P_insymbol();
                Ra.sl[6]=4244; /* line # 4244 */
                if (Rv9!=V_ide_udptr.v[1]) {
                  Ra.sl[6]=4246; /* line # 4246 */
                  P_ide_new_typ(24, &Rv1);
                  Ra.sl[6]=4247; /* line # 4247 */
                  Rv10=Rv1;
                  Ra.sl[6]=4249; /* line # 4249 */
                  ((V *)Rv10)[0]=((V *)Rv8)[4];
                  Ra.sl[6]=4250; /* line # 4250 */
                  ((V *)Rv10)[12]=((V *)Rv9)[4];
                  Ra.sl[6]=4251; /* line # 4251 */
                  ((V *)Rv10)[4]=((V *)((V *)Rv10)[12])[4];
                  Ra.sl[6]=4252; /* line # 4252 */
                  ((SL *)Rv10)[10]=0;
                  Ra.sl[6]=4254; /* line # 4254 */
                  V_sy_type_gfirst=((V *)Rv8)[10];
                  Ra.sl[6]=4255; /* line # 4255 */
                  ((V *)Rv10)[9]=NULL;
                  Ra.sl[6]=4256; /* line # 4256 */
                  ((SL *)Rv10)[11]=((SL *)((V *)Rv8)[4])[11];
                  Ra.sl[6]=4257; /* line # 4257 */
                  ((UB *)Rv10)[90]=((UB *)((V *)Rv8)[4])[90];
                }
              }
              else Ra.sl[6]=4265; /* line # 4265 */
            }
            Ra.sl[6]=4266; /* line # 4266 */
            ((UB *)Rv1)[90]=((UB *)((V *)Rv8)[4])[90]||((SL *)((V *)Rv8)[4])[10]
            >0;
          }
        }
        else {
          Ra.sl[6]=4269; /* line # 4269 */
          Rv1=NULL;
        }
      }
    }
    Ra.sl[6]=4272; /* line # 4272 */
    if (Rv1==NULL) {
      Ra.sl[6]=4275; /* line # 4275 */
      Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,1);
      Ra.sl[6]=4276; /* line # 4276 */
      if (V_sy_sym.ub[0]==20) P_insymbol();
      else P_src_error(Rd.s+800,28,2);
      Ra.sl[6]=4277; /* line # 4277 */
      Rv7=PAS_COMILER_PRC_00000005(((V *)Rv6)[3],0,0,1);
      Ra.sl[6]=4278; /* line # 4278 */
      Rv11=((SL *)((V *)Rv6)[3])[11];
      Ra.sl[6]=4279; /* line # 4279 */
      Rv12=((UB *)((V *)Rv6)[3])[48];
      Ra.sl[6]=4280; /* line # 4280 */
      PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
      Ra.sl[6]=4281; /* line # 4281 */
      if (Rv11<4) Rv13=PAS__IIPOWER(2,8*Rv11);
      else Rv13=2147483647;
      Ra.sl[6]=4282; /* line # 4282 */
      Rv14=Rv6;
      Ra.sl[6]=4283; /* line # 4283 */
      if (((UB *)Rv14)[40]==14&&((UB *)Rv7)[40]==14) {
        Ra.sl[6]=4285; /* line # 4285 */
        P_ide_new_typ_range(((SL *)((V *)Rv14)[7])[13],((SL *)((V *)Rv7)[7])[13]
        ,((V *)Rv14)[3],&Rv1);
        Ra.sl[6]=4288; /* line # 4288 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
        Ra.sl[6]=4289; /* line # 4289 */
        P_lgt_free(&Rv6);
        P_lgt_free(&Rv7);
        Ra.sl[6]=4290; /* line # 4290 */
        Rv15=Rv1;
        Ra.sl[6]=4292; /* line # 4292 */
        ((UB *)Rv15)[112]=((SL *)Rv15)[29]>=0;
        Ra.sl[6]=4293; /* line # 4293 */
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4295; /* line # 4295 */
          if (((UB *)Rv15)[112]) {
            Ra.sl[6]=4297; /* line # 4297 */
            if (((UL *)Rv15)[29]>((UL *)Rv15)[30]) {
              Ra.sl[6]=4299; /* line # 4299 */
              ((UL *)Rv15)[30]=((UL *)Rv15)[29];
              Ra.sl[6]=4300; /* line # 4300 */
              P_src_error(Rd.s+800,211,2);
            }
          }
          else {
            Ra.sl[6]=4304; /* line # 4304 */
            if (((SL *)Rv15)[29]>((SL *)Rv15)[30]) {
              Ra.sl[6]=4306; /* line # 4306 */
              ((SL *)Rv15)[30]=((SL *)Rv15)[29];
              Ra.sl[6]=4307; /* line # 4307 */
              P_src_error(Rd.s+800,211,2);
            }
          }
          Ra.sl[6]=4309; /* line # 4309 */
          if (((UB *)Rv15)[112]) {
            Ra.sl[6]=4311; /* line # 4311 */
            if (Rv11<4) {
              Ra.sl[6]=4312; /* line # 4312 */
              if (((UL *)Rv15)[30]>=Rv13) {
                Ra.sl[6]=4314; /* line # 4314 */
                Rv11=4;
                Ra.sl[6]=4315; /* line # 4315 */
                P_src_error(Rd.s+800,212,2);
                Rv12=0;
              }
            }
          }
          else {
            Ra.sl[6]=4320; /* line # 4320 */
            if (Rv13!=2147483647) Rv13=Rv13/2;
            Ra.sl[6]=4321; /* line # 4321 */
            if (((SL *)Rv15)[30]>=Rv13||((SL *)Rv15)[29]< -Rv13) {
              Ra.sl[6]=4323; /* line # 4323 */
              Rv11=4;
              Ra.sl[6]=4324; /* line # 4324 */
              P_src_error(Rd.s+800,213,2);
              Rv12=0;
            }
          }
        }
      }
      else {
        Ra.sl[6]=4332; /* line # 4332 */
        P_ide_new_typ(22, &Rv1);
        Ra.sl[6]=4333; /* line # 4333 */
        Rv16=Rv1;
        Ra.sl[6]=4335; /* line # 4335 */
        ((V *)Rv16)[0]=((V *)Rv14)[3];
        Ra.sl[6]=4336; /* line # 4336 */
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4338; /* line # 4338 */
          P_type_check_parm(Rv6);
          Ra.sl[6]=4339; /* line # 4339 */
          P_type_check_parm(Rv7);
        }
        Ra.sl[6]=4341; /* line # 4341 */
        if (((UB *)Rv7)[40]!=14) {
          Ra.sl[6]=4343; /* line # 4343 */
          ((V *)Rv16)[14]=P_lgt_new_code(0, Rv7);
        }
        else {
          Ra.sl[6]=4346; /* line # 4346 */
          ((V *)Rv16)[14]=Rv7;
        }
        Ra.sl[6]=4348; /* line # 4348 */
        ((V *)((V *)Rv16)[14])[3]=Rv1;
        Ra.sl[6]=4349; /* line # 4349 */
        if (((UB *)Rv6)[40]==14) {
          Ra.sl[6]=4350; /* line # 4350 */
          Rv17=Rv6;
          Ra.sl[6]=4352; /* line # 4352 */
          ((V *)Rv16)[13]=Rv6;
          Ra.sl[6]=4353; /* line # 4353 */
          ((V *)Rv17)[3]=Rv1;
          Ra.sl[6]=4354; /* line # 4354 */
          if (((SL *)((V *)Rv17)[7])[13]==1) {
            Ra.sl[6]=4356; /* line # 4356 */
            ((V *)Rv16)[12]=P_lgt_new_code(0, Rv7);
          }
          else {
            Ra.sl[6]=4360; /* line # 4360 */
            ((V *)((V *)Rv16)[14])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)((V
             *)Rv17)[7])[13]-1);
            Ra.sl[6]=4363; /* line # 4363 */
            ((V *)Rv16)[12]=P_lgt_new_code(50,((V *)Rv16)[14]);
          }
        }
        else {
          Ra.sl[6]=4369; /* line # 4369 */
          ((V *)Rv16)[13]=P_lgt_new_code(0, Rv6);
          Ra.sl[6]=4370; /* line # 4370 */
          ((V *)((V *)Rv16)[13])[3]=Rv1;
          Ra.sl[6]=4371; /* line # 4371 */
          if (((UB *)Rv7)[40]==14) {
            Ra.sl[6]=4375; /* line # 4375 */
            Rv13=((SL *)((V *)Rv7)[7])[13]+1;
            Ra.sl[6]=4376; /* line # 4376 */
            if (Rv13==0) {
              Ra.sl[6]=4378; /* line # 4378 */
              ((V *)Rv16)[12]=P_lgt_new_code(46,((V *)Rv16)[14]);
            }
            else {
              Ra.sl[6]=4381; /* line # 4381 */
              Rv6=P_lgt_new_econst(V_typ_std.v[2],Rv13);
              Ra.sl[6]=4382; /* line # 4382 */
              ((V *)Rv6)[0]=((V *)Rv16)[13];
              Ra.sl[6]=4383; /* line # 4383 */
              ((V *)Rv16)[12]=P_lgt_new_code(50, Rv6);
            }
          }
          else {
            Ra.sl[6]=4388; /* line # 4388 */
            ((V *)((V *)Rv16)[14])[0]=((V *)Rv16)[13];
            Ra.sl[6]=4389; /* line # 4389 */
            Rv6=P_lgt_new_code(50,((V *)Rv16)[14]);
            Ra.sl[6]=4390; /* line # 4390 */
            ((V *)Rv16)[12]=P_lgt_new_code(43, Rv6);
          }
        }
      }
      Ra.sl[6]=4397; /* line # 4397 */
      Rv18=Rv1;
      Ra.sl[6]=4399; /* line # 4399 */
      ((SL *)Rv18)[11]=Rv11;
      Ra.sl[6]=4400; /* line # 4400 */
      if (Rv12>=0) ((UB *)Rv18)[48]=Rv12;
    }
    break;
  }
  Ra.sl[6]=4406; /* line # 4406 */
  (*F_it)=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_decl_attribute "  */
void PAS_COMILER_PRC_00000043(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+804;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4420; /* line # 4420 */
  Ra.sl[6]=4422; /* line # 4422 */
  P_insymbol();
  Ra.sl[6]=4423; /* line # 4423 */
  switch (V_sy_sym.ub[0]) {
    case 86:Ra.sl[6]=4424; /* line # 4424 */
    Lx[5].ub[16]=2;
    P_insymbol();
    break;
    case 80:
    case 81:
    case 82:Ra.sl[6]=4427; /* line # 4427 */
    if (V_sy_sym.ub[0]==81) Lx[5].ub[16]=3;
    else {
      Ra.sl[6]=4430; /* line # 4430 */
      Lx[5].ub[16]=4;
      Ra.sl[6]=4431; /* line # 4431 */
      if (V_sy_sym.ub[0]==82) {
        Ra.sl[6]=4432; /* line # 4432 */
        if (V_sy_init_mod) Lx[5].ub[16]=5;
        else {
          Ra.sl[6]=4433; /* line # 4433 */
          P_src_error(Rd.s+826,992,2);
        }
      }
    }
    Ra.sl[6]=4435; /* line # 4435 */
    P_insymbol();
    Ra.sl[6]=4436; /* line # 4436 */
    Lx[5].v[3]=NULL;
    Ra.sl[6]=4437; /* line # 4437 */
    P_set_strname(Lx[5].v+3);
    break;
    case 0:Ra.sl[6]=4442; /* line # 4442 */
    Rv0=P_level_search(V_attr_list);
    Ra.sl[6]=4443; /* line # 4443 */
    if (Rv0!=NULL) {
      Ra.sl[6]=4444; /* line # 4444 */
      switch (((UB *)Rv0)[57]) {
        case 27:Ra.sl[6]=4445; /* line # 4445 */
        Rs.sl[0]=1;
        break;
        case 28:Ra.sl[6]=4446; /* line # 4446 */
        Rs.sl[0]=2;
        break;
        case 29:Ra.sl[6]=4447; /* line # 4447 */
        Rs.sl[0]=4;
        break;
        default:Ra.sl[6]=4449; /* line # 4449 */
        P_src_error_s(Rd.s+826,165,2, V_sy_ident.s,NULL);
        break;
      }
    }
    else {
      Ra.sl[6]=4452; /* line # 4452 */
      P_src_error(Rd.s+826,162,2);
    }
    break;
    default:Ra.sl[6]=4456; /* line # 4456 */
    P_src_error(Rd.s+826,163,2);
    Ra.sl[6]=4457; /* line # 4457 */
    P_skip_symbol(16,0,0);
    break;
  }
  Ra.sl[6]=4459; /* line # 4459 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else {
    Ra.sl[6]=4460; /* line # 4460 */
    P_src_error(Rd.s+826,26,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_setting "  */
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  UW Rv8;
  UB Rv9;
  V Rv10;
  register V Rv11;
  UB Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  V Rv22;
  register V Rv23;
  register V Rv24;
  register V Rv25;
  V Rv26;
  register V Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+830;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4488; /* line # 4488 */
  Rv0=0;
  Ra.sl[6]=4489; /* line # 4489 */
  Rv1=Lx[5].ub[16];
  Ra.sl[6]=4490; /* line # 4490 */
  Rv2=NULL;
  Ra.sl[6]=4491; /* line # 4491 */
  Lx[5].ub[16]=1;
  Ra.sl[6]=4492; /* line # 4492 */
  if (Lx[5].v[3]!=NULL) {
    Ra.sl[6]=4494; /* line # 4494 */
    P_src_error_s(Rd.s+847,166,1, Lx[5].v[3],NULL);
    Ra.sl[6]=4495; /* line # 4495 */
    Lx[5].v[3]=NULL;
  }
  Ra.sl[6]=4497; /* line # 4497 */
  Rv3=0;
  Ra.sl[6]=4498; /* line # 4498 */
  Rv4=NULL;
  Rv5=NULL;
  Ra.sl[6]=4500; /* line # 4500 */
  if (F_v_class==6) {
    Ra.sl[6]=4502; /* line # 4502 */
    ((V *)F_ty)[12]=V_lex_ident_tree.v[V_curr_disp*8+4];
  }
  Ra.sl[6]=4504; /* line # 4504 */
  Ra.sl[6]=4505; /* line # 4505 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==15){
    Ra.sl[6]=4507; /* line # 4507 */
    Rv6=NULL;
    Ra.sl[6]=4508; /* line # 4508 */
    Rv7=NULL;
    Ra.sl[6]=4509; /* line # 4509 */
    Rv8=96;
    while (1){
      Ra.sl[6]=4511; /* line # 4511 */
      switch (F_v_class) {
        case 5:Ra.sl[6]=4514; /* line # 4514 */
        if (V_sy_sym.ub[0]==15) {
          Ra.sl[6]=4516; /* line # 4516 */
          PAS_COMILER_PRC_00000043();
          Ra.sl[6]=4517; /* line # 4517 */
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[6]=4519; /* line # 4519 */
            Rv9=Lx[5].ub[16];
            Ra.sl[6]=4520; /* line # 4520 */
            Rv2=Lx[5].v[3];
            Ra.sl[6]=4521; /* line # 4521 */
            Lx[5].ub[16]=1;
            Ra.sl[6]=4522; /* line # 4522 */
            Lx[5].v[3]=NULL;
          }
          else {
            Ra.sl[6]=4524; /* line # 4524 */
            Rv0=1;
          }
        }
        else {
          Ra.sl[6]=4528; /* line # 4528 */
          Rv9=Rv1;
          Ra.sl[6]=4529; /* line # 4529 */
          Rv2=NULL;
        }
        Ra.sl[6]=4531; /* line # 4531 */
        if (!Rv0) {
          Ra.sl[6]=4533; /* line # 4533 */
          V_cmp_twicedclon=1;
          Ra.sl[6]=4534; /* line # 4534 */
          P_ide_new(5,NULL,&Rv10);
          Ra.sl[6]=4535; /* line # 4535 */
          V_cmp_twicedclon=0;
          Ra.sl[6]=4537; /* line # 4537 */
          if (Rv9!=1&&Rv2!=NULL) {
            Ra.sl[6]=4538; /* line # 4538 */
            Rv11=Rv10;
            Ra.sl[6]=4540; /* line # 4540 */
            if (((V *)Rv11)[9]!=NULL) {
              Ra.sl[6]=4541; /* line # 4541 */
              if (P_match(Rv2,((V *)Rv11)[9])!=0) {
                Ra.sl[6]=4542; /* line # 4542 */
                P_src_error_s(Rd.s+847,218,2,((V *)Rv11)[0],NULL);
              }
            }
            Ra.sl[6]=4543; /* line # 4543 */
            ((V *)Rv11)[9]=Rv2;
          }
        }
        break;
        case 2:Ra.sl[6]=4547; /* line # 4547 */
        P_ide_new(2,NULL,&Rv10);
        break;
        case 1:
        case 6:Ra.sl[6]=4549; /* line # 4549 */
        P_ide_new(6,NULL,&Rv10);
        break;
        default:break;
      }
      Ra.sl[6]=4553; /* line # 4553 */
      if (!Rv0) {
        Ra.sl[6]=4555; /* line # 4555 */
        if (!V_cmp_twicedcl) {
          Ra.sl[6]=4557; /* line # 4557 */
          if (Rv5!=NULL) ((V *)Rv5)[3]=Rv10;
          else {
            Ra.sl[6]=4559; /* line # 4559 */
            if (Rv4==NULL) Rv4=Rv10;
          }
          Ra.sl[6]=4560; /* line # 4560 */
          if (Rv6==NULL) Rv6=Rv10;
          Ra.sl[6]=4561; /* line # 4561 */
          Rv5=Rv10;
        }
        Ra.sl[6]=4563; /* line # 4563 */
        P_insymbol();
        Ra.sl[6]=4564; /* line # 4564 */
        if (V_sy_sym.ub[0]==17) P_insymbol();
        else {
          Ra.sl[6]=4565; /* line # 4565 */
          if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+847,29,2);
        }
        Ra.sl[6]=4566; /* line # 4566 */
        if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+847,27,2);
      }
      if (V_sy_sym.ub[0]!=0&&V_sy_sym.ub[0]!=15)  break;
    }
    Ra.sl[6]=4570; /* line # 4570 */
    if (!Rv0) {
      Ra.sl[6]=4572; /* line # 4572 */
      P_insymbol();
      Ra.sl[6]=4574; /* line # 4574 */
      Rs.sl[1]=-1;
      Ra.sl[6]=4575; /* line # 4575 */
      Rs.sl[0]=-1;
      Ra.sl[6]=4576; /* line # 4576 */
      Rv12=0;
      Ra.sl[6]=4577; /* line # 4577 */
      if (V_sy_sym.ub[0]==15) {
        Ra.sl[6]=4579; /* line # 4579 */
        V_sy_sym.ub[0]=17;
        Ra.sl[6]=4580; /* line # 4580 */
        while (V_sy_sym.ub[0]==17){
          Ra.sl[6]=4582; /* line # 4582 */
          P_insymbol();
          Ra.sl[6]=4583; /* line # 4583 */
          switch (V_sy_sym.ub[0]) {
            case 86:Ra.sl[6]=4584; /* line # 4584 */
            Rv9=2;
            P_insymbol();
            break;
            case 80:
            case 81:
            case 82:Ra.sl[6]=4587; /* line # 4587 */
            if (V_sy_sym.ub[0]==81) Rv9=3;
            else {
              Ra.sl[6]=4588; /* line # 4588 */
              Rv9=4;
            }
            Ra.sl[6]=4589; /* line # 4589 */
            if (V_sy_sym.ub[0]==82) {
              Ra.sl[6]=4590; /* line # 4590 */
              if (V_sy_init_mod) Rv9=5;
              else {
                Ra.sl[6]=4591; /* line # 4591 */
                P_src_error(Rd.s+847,992,2);
              }
            }
            Ra.sl[6]=4592; /* line # 4592 */
            P_insymbol();
            break;
            case 0:Ra.sl[6]=4596; /* line # 4596 */
            Rv13=P_level_search(V_attr_list);
            Ra.sl[6]=4597; /* line # 4597 */
            P_insymbol();
            Ra.sl[6]=4598; /* line # 4598 */
            if (Rv13!=NULL) {
              Ra.sl[6]=4599; /* line # 4599 */
              switch (((UB *)Rv13)[57]) {
                case 20:Ra.sl[6]=4600; /* line # 4600 */
                Rv9=3;
                break;
                case 21:Ra.sl[6]=4601; /* line # 4601 */
                Rv9=4;
                break;
                case 22:Ra.sl[6]=4602; /* line # 4602 */
                Rv9=2;
                break;
                case 25:Ra.sl[6]=4603; /* line # 4603 */
                Rv12=1;
                break;
                case 26:break;
                case 27:Ra.sl[6]=4605; /* line # 4605 */
                Rs.sl[0]=1;
                break;
                case 28:Ra.sl[6]=4606; /* line # 4606 */
                Rs.sl[0]=2;
                break;
                case 29:Ra.sl[6]=4607; /* line # 4607 */
                Rs.sl[0]=4;
                break;
                default:Ra.sl[6]=4609; /* line # 4609 */
                P_src_error_s(Rd.s+847,165,2, V_sy_ident.s,NULL);
                break;
              }
            }
            else {
              Ra.sl[6]=4612; /* line # 4612 */
              P_src_error_s(Rd.s+847,167,2, V_sy_ident.s,NULL);
            }
            break;
            default:Ra.sl[6]=4615; /* line # 4615 */
            P_src_error(Rd.s+847,163,2);
            Ra.sl[6]=4616; /* line # 4616 */
            P_skip_symbol(16,0,0);
            break;
          }
        }
        Ra.sl[6]=4619; /* line # 4619 */
        if (V_sy_sym.ub[0]==16) P_insymbol();
        else {
          Ra.sl[6]=4620; /* line # 4620 */
          P_src_error(Rd.s+847,26,2);
        }
      }
      Ra.sl[6]=4622; /* line # 4622 */
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        Ra.sl[6]=4623; /* line # 4623 */
        P_insymbol();
        Rv12=1;
      }
      Ra.sl[6]=4628; /* line # 4628 */
      if (Rv9==1&&Rv1!=1) {
        Ra.sl[6]=4629; /* line # 4629 */
        Rv9=Rv1;
        Rv2=NULL;
      }
      Ra.sl[6]=4631; /* line # 4631 */
      PAS_COMILER_PRC_00000038(&Rv14,0,NULL,0,0);
      Ra.sl[6]=4633; /* line # 4633 */
      switch (F_v_class) {
        case 5:Ra.sl[6]=4637; /* line # 4637 */
        if (((SL *)Rv14)[11]<0&&((V *)Rv14)[1]!=NULL) {
          Ra.sl[6]=4638; /* line # 4638 */
          Rv14=((V *)Rv14)[1];
        }
        break;
        case 2:Ra.sl[6]=4640; /* line # 4640 */
        if (Rv14!=NULL) {
          Ra.sl[6]=4641; /* line # 4641 */
          Rv15=Rv14;
          Ra.sl[6]=4643; /* line # 4643 */
          switch (((UB *)Rv15)[92]) {
            case 0:
            case 1:
            case 2:break;
            default:Ra.sl[6]=4646; /* line # 4646 */
            P_src_error(Rd.s+847,207,3);
            break;
          }
        }
        break;
        case 6:Ra.sl[6]=4650; /* line # 4650 */
        Rv16=Rv14;
        Ra.sl[6]=4652; /* line # 4652 */
        if (((UB *)Rv16)[90]||((SL *)Rv16)[10]>0) Lx[5].ub[0]=1;
        break;
        default:break;
      }
      Ra.sl[6]=4658; /* line # 4658 */
      Rv17=Rv14;
      Ra.sl[6]=4660; /* line # 4660 */
      if (Rv3<((UB *)Rv17)[48]) Rv3=((UB *)Rv17)[48];
      Ra.sl[6]=4662; /* line # 4662 */
      Rv7=((V *)Rv17)[10];
      Ra.sl[6]=4665; /* line # 4665 */
      if (F_v_class==5) {
        Ra.sl[6]=4667; /* line # 4667 */
        if (Rv9==1) {
          Ra.sl[6]=4668; /* line # 4668 */
          switch (V_sy_sym.ub[0]) {
            case 86:Ra.sl[6]=4669; /* line # 4669 */
            Rv9=2;
            P_insymbol();
            break;
            case 81:Ra.sl[6]=4670; /* line # 4670 */
            Rv9=3;
            P_insymbol();
            break;
            case 80:Ra.sl[6]=4671; /* line # 4671 */
            Rv9=4;
            P_insymbol();
            break;
            default:break;
          }
        }
        Ra.sl[6]=4674; /* line # 4674 */
        if (V_sy_sym.ub[0]==26) {
          Ra.sl[6]=4676; /* line # 4676 */
          Rv8=32;
          Ra.sl[6]=4677; /* line # 4677 */
          P_insymbol();
        }
      }
      Ra.sl[6]=4681; /* line # 4681 */
      if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
        Ra.sl[6]=4682; /* line # 4682 */
        if (F_v_class==6) {
          Ra.sl[6]=4684; /* line # 4684 */
          P_src_error(Rd.s+847,220,2);
        }
        else {
          Ra.sl[6]=4688; /* line # 4688 */
          P_insymbol();
          Ra.sl[6]=4689; /* line # 4689 */
          if (V_sy_sym.ub[0]!=13&&V_sy_sym.ub[0]!=15) {
            Ra.sl[6]=4690; /* line # 4690 */
            Rv18=PAS_COMILER_PRC_00000005(Rv14,0,0,0);
          }
          else {
            Ra.sl[6]=4692; /* line # 4692 */
            Rv18=PAS_COMILER_PRC_00000019(Rv14);
          }
          Ra.sl[6]=4694; /* line # 4694 */
          if (((UB *)Rv18)[40]!=14) {
            Ra.sl[6]=4695; /* line # 4695 */
            P_src_error(Rd.s+847,216,3);
          }
          else {
            Ra.sl[6]=4697; /* line # 4697 */
            Rv19=Rv18;
            Ra.sl[6]=4699; /* line # 4699 */
            Rv7=((V *)Rv19)[7];
            Ra.sl[6]=4700; /* line # 4700 */
            ((V *)Rv19)[7]=NULL;
          }
          Ra.sl[6]=4702; /* line # 4702 */
          Rv20=1;
          Ra.sl[6]=4703; /* line # 4703 */
          P_lgt_free_tree(&Rv18);
        }
      }
      else {
        Ra.sl[6]=4705; /* line # 4705 */
        Rv20=0;
      }
      Ra.sl[6]=4708; /* line # 4708 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=4710; /* line # 4710 */
        if (V_sy_sym.ub[0]==0) P_src_error_s(Rd.s+847,52,2, V_sy_ident.s,NULL);
      }
      Ra.sl[6]=4713; /* line # 4713 */
      if (Rv6!=NULL) while (1){
        Ra.sl[6]=4715; /* line # 4715 */
        Rv21=Rv6;
        Ra.sl[6]=4717; /* line # 4717 */
        Rv22=((V *)Rv21)[4];
        Ra.sl[6]=4718; /* line # 4718 */
        ((V *)Rv21)[4]=Rv14;
        Ra.sl[6]=4719; /* line # 4719 */
        if ((*F_isz)>0) (*F_isz)=P_ide_typ_align((*F_isz),Rv14);
        Ra.sl[6]=4720; /* line # 4720 */
        switch (F_v_class) {
          case 5:Ra.sl[6]=4723; /* line # 4723 */
          ((UW *)Rv21)[46]=Rv8;
          Ra.sl[6]=4724; /* line # 4724 */
          if (Rv12) ((UW *)Rv21)[46]=((UW *)Rv21)[46]|16384;
          Ra.sl[6]=4726; /* line # 4726 */
          if (((UB *)Rv21)[94]==4||((SL *)Rv21)[22]>0) {
            Ra.sl[6]=4728; /* line # 4728 */
            if (Rv22!=NULL&&Rv22!=Rv14) {
              Ra.sl[6]=4729; /* line # 4729 */
              P_src_error_s(Rd.s+847,217,3,((V *)Rv21)[0],NULL);
            }
            Ra.sl[6]=4730; /* line # 4730 */
            ((UB *)Rv21)[94]=Rv9;
          }
          else {
            Ra.sl[6]=4734; /* line # 4734 */
            if (((UB *)Rv21)[94]==0) ((UB *)Rv21)[94]=Rv9;
            Ra.sl[6]=4735; /* line # 4735 */
            switch (((UB *)Rv21)[94]) {
              case 3:
              case 4:
              case 5:Ra.sl[6]=4738; /* line # 4738 */
              if (((V *)Rv21)[9]==NULL) {
                Ra.sl[6]=4739; /* line # 4739 */
                P_set_gbl_def_nam(((V *)Rv21)+9,((V *)Rv21)[0],86);
              }
              Ra.sl[6]=4740; /* line # 4740 */
              ((SL *)Rv21)[22]=-1;
              break;
              default:Ra.sl[6]=4744; /* line # 4744 */
              if (16384&((UW *)Rv21)[46]||V_cmp_igenv!=0) {
                Ra.sl[6]=4745; /* line # 4745 */
                ((SL *)Rv21)[22]=-1;
              }
              break;
            }
          }
          Ra.sl[6]=4749; /* line # 4749 */
          if (Rv7!=NULL) {
            Ra.sl[6]=4750; /* line # 4750 */
            if (((UB *)Rv21)[94]==4||((SL *)Rv21)[22]>0) {
              Ra.sl[6]=4752; /* line # 4752 */
              if (Rv20) P_src_error_s(Rd.s+847,209,2,((V *)Rv21)[0],NULL);
              Ra.sl[6]=4755; /* line # 4755 */
              Rv7=NULL;
            }
            else {
              Ra.sl[6]=4759; /* line # 4759 */
              ((V *)Rv21)[8]=Rv7;
              Ra.sl[6]=4760; /* line # 4760 */
              P_val_new(((V *)Rv21)+8,Rv14);
              Ra.sl[6]=4761; /* line # 4761 */
              Rv23=((V *)Rv21)[8];
              Ra.sl[6]=4763; /* line # 4763 */
              ((UW *)Rv23)[8]=((UW *)Rv10)[46];
              Ra.sl[6]=4764; /* line # 4764 */
              ((SL *)Rv23)[5]=((SL *)Rv21)[22];
            }
          }
          Ra.sl[6]=4768; /* line # 4768 */
          switch (((UB *)Rv21)[94]) {
            case 3:Ra.sl[6]=4771; /* line # 4771 */
            if (((UB *)((V *)Rv21)[4])[89]||((UB *)((V *)Rv21)[4])[90]) P_init_d_varbl(
            Rv6);
            Ra.sl[6]=4772; /* line # 4772 */
            P_all_new(((V *)Rv21)+10,Rv14, Rv6,((UB *)Rv21)[94]);
            Ra.sl[6]=4773; /* line # 4773 */
            ((V *)((V *)Rv21)[10])[13]=((V *)Rv21)[8];
            Ra.sl[6]=4774; /* line # 4774 */
            if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv21)[10];
            else {
              Ra.sl[6]=4775; /* line # 4775 */
              ((V *)V_all_lglobal)[0]=((V *)Rv21)[10];
            }
            Ra.sl[6]=4776; /* line # 4776 */
            ((V *)((V *)Rv21)[10])[1]=V_all_lglobal;
            Ra.sl[6]=4777; /* line # 4777 */
            V_all_lglobal=((V *)Rv21)[10];
            break;
            case 1:
            case 2:Ra.sl[6]=4780; /* line # 4780 */
            if (((SL *)Rv21)[22]==0) {
              Ra.sl[6]=4782; /* line # 4782 */
              if (((UB *)((V *)Rv21)[4])[89]||((UB *)((V *)Rv21)[4])[90]) P_init_d_varbl(
              Rv6);
              Ra.sl[6]=4783; /* line # 4783 */
              P_all_new(((V *)Rv21)+10,Rv14, Rv6,((UB *)Rv21)[94]);
              Ra.sl[6]=4784; /* line # 4784 */
              ((V *)((V *)Rv21)[10])[13]=((V *)Rv21)[8];
              Ra.sl[6]=4785; /* line # 4785 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv21)[10];
              else {
                Ra.sl[6]=4786; /* line # 4786 */
                ((V *)V_all_lstatic)[0]=((V *)Rv21)[10];
              }
              Ra.sl[6]=4787; /* line # 4787 */
              ((V *)((V *)Rv21)[10])[1]=V_all_lstatic;
              Ra.sl[6]=4788; /* line # 4788 */
              V_all_lstatic=((V *)Rv21)[10];
            }
            break;
            default:break;
          }
          break;
          case 1:
          case 6:Ra.sl[6]=4795; /* line # 4795 */
          Ra.sl[6]=4797; /* line # 4797 */
          ((SL *)Rv21)[15]=(*F_isz);
          Ra.sl[6]=4798; /* line # 4798 */
          if ((*F_isz)<0) {
            Ra.sl[6]=4800; /* line # 4800 */
            P_src_error(Rd.s+847,221,3);
          }
          break;
          case 2:Ra.sl[6]=4805; /* line # 4805 */
          ((UB *)Rv21)[64]=0;
          Ra.sl[6]=4806; /* line # 4806 */
          ((V *)Rv21)[11]=Rv7;
          Ra.sl[6]=4809; /* line # 4809 */
          if (((V *)Rv21)[11]==NULL) {
            Ra.sl[6]=4811; /* line # 4811 */
            P_val_new(((V *)Rv21)+11,Rv14);
            Ra.sl[6]=4812; /* line # 4812 */
            Rv24=((V *)Rv21)[11];
            Rv25=Rv14;
            Ra.sl[6]=4813; /* line # 4813 */
            switch (((UB *)Rv25)[92]) {
              case 0:Ra.sl[6]=4815; /* line # 4815 */
              ((SL *)Rv24)[13]=((SL *)Rv25)[30];
              break;
              case 1:
              case 2:Ra.sl[6]=4817; /* line # 4817 */
              if (((SL *)Rv25)[30]>32767) ((SL *)Rv24)[13]=32767;
              else {
                Ra.sl[6]=4818; /* line # 4818 */
                ((SL *)Rv24)[13]=((SL *)Rv25)[30];
              }
              break;
              default:break;
            }
          }
          else {
            Ra.sl[6]=4823; /* line # 4823 */
            P_val_new(((V *)Rv21)+11,Rv14);
          }
          Ra.sl[6]=4824; /* line # 4824 */
          ((SL *)Rv21)[15]=(*F_isz);
          break;
        }
        Ra.sl[6]=4829; /* line # 4829 */
        if ((*F_isz)>=0) {
          Ra.sl[6]=4830; /* line # 4830 */
          if (((SL *)Rv14)[11]>=0) {
            Ra.sl[6]=4831; /* line # 4831 */
            (*F_isz)=(*F_isz)+((SL *)Rv14)[11];
          }
          else {
            Ra.sl[6]=4833; /* line # 4833 */
            if ((F_v_class==6||F_v_class==1)&&((V *)Rv14)[9]!=NULL) {
              Ra.sl[6]=4836; /* line # 4836 */
              Rv26=P_lgt_link(((V *)Rv14)[9]);
              Ra.sl[6]=4837; /* line # 4837 */
              if ((*F_isz)>0) {
                Ra.sl[6]=4839; /* line # 4839 */
                ((V *)Rv26)[0]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
                Ra.sl[6]=4840; /* line # 4840 */
                ((V *)F_ty)[9]=P_lgt_new_code(49, Rv26);
              }
              else {
                Ra.sl[6]=4842; /* line # 4842 */
                ((V *)F_ty)[9]=Rv26;
              }
              Ra.sl[6]=4843; /* line # 4843 */
              (*F_isz)=-1;
            }
            else {
              Ra.sl[6]=4848; /* line # 4848 */
              P_src_error(Rd.s+847,301,3);
            }
          }
        }
        Ra.sl[6]=4850; /* line # 4850 */
        Rv6=((V *)Rv6)[3];
        if (Rv6==NULL)  break;
      }
      Ra.sl[6]=4852; /* line # 4852 */
      if (Rv20&&Rv7!=NULL) P_val_free(&Rv7);
      Ra.sl[6]=4853; /* line # 4853 */
      Rv20=0;
    }
  }
  Ra.sl[6]=4857; /* line # 4857 */
  if (!Rv0) {
    Ra.sl[6]=4858; /* line # 4858 */
    Ra.sl[6]=4859; /* line # 4859 */
    switch (F_v_class) {
      case 1:
      case 6:Ra.sl[6]=4861; /* line # 4861 */
      Rv27=F_ty;
      Ra.sl[6]=4862; /* line # 4862 */
      switch (V_sy_sym.ub[0]) {
        case 72:Ra.sl[6]=4864; /* line # 4864 */
        if (F_v_class==6&&(*F_isz)>=0) {
          Ra.sl[6]=4865; /* line # 4865 */
          ((V *)Rv27)[9]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
        }
        break;
        case 14:Ra.sl[6]=4869; /* line # 4869 */
        if (F_v_class==6&&(*F_isz)>=0) {
          Ra.sl[6]=4870; /* line # 4870 */
          ((V *)Rv27)[9]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
        }
        Ra.sl[6]=4871; /* line # 4871 */
        if (((UB *)F_ty)[92]!=23) {
          Ra.sl[6]=4873; /* line # 4873 */
          P_src_error(Rd.s+847,223,2);
          P_insymbol();
        }
        break;
        case 56:Ra.sl[6]=4878; /* line # 4878 */
        Rv28=F_ty;
        Rv29=(V_lex_ident_tree.s+V_curr_disp*64);
        Ra.sl[6]=4879; /* line # 4879 */
        if (((SL *)Rv28)[11]<0) {
          Ra.sl[6]=4881; /* line # 4881 */
          P_src_error(Rd.s+847,224,3);
          Ra.sl[6]=4882; /* line # 4882 */
          P_insymbol();
          P_skip_symbol(72,0,0);
        }
        else {
          Ra.sl[6]=4886; /* line # 4886 */
          P_insymbol();
          Ra.sl[6]=4887; /* line # 4887 */
          if (F_v_class==6) {
            Ra.sl[6]=4888; /* line # 4888 */
            if (((V *)Rv28)[13]==NULL) {
              Ra.sl[6]=4889; /* line # 4889 */
              ((V *)Rv28)[12]=((V *)Rv29)[1];
            }
            else {
              Ra.sl[6]=4891; /* line # 4891 */
              ((V *)Rv28)[12]=((V *)((V *)Rv28)[13])[3];
            }
          }
          Ra.sl[6]=4892; /* line # 4892 */
          ((V *)Rv28)[13]=((V *)Rv29)[4];
          Ra.sl[6]=4893; /* line # 4893 */
          ((V *)Rv28)[14]=PAS_COMILER_PRC_00000004(41, F_ty);
          Ra.sl[6]=4894; /* line # 4894 */
          ((V *)Rv28)[9]=P_lgt_new_code(0,((V *)Rv28)[14]);
        }
        break;
        default:Ra.sl[6]=4899; /* line # 4899 */
        P_src_error(Rd.s+847,225,2);
        break;
      }
      break;
      case 2:Ra.sl[6]=4902; /* line # 4902 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+847,23,2);
      else {
        Ra.sl[6]=4903; /* line # 4903 */
        P_insymbol();
      }
      break;
      default:break;
    }
  }
  Ra.sl[6]=4907; /* line # 4907 */
  (*F_aln)=Rv3;
  Ra.sl[6]=4908; /* line # 4908 */
  if (F_ty!=NULL) {
    Ra.sl[6]=4909; /* line # 4909 */
    Rv30=F_ty;
    Ra.sl[6]=4910; /* line # 4910 */
    if (Rv3>((UB *)Rv30)[48]) ((UB *)Rv30)[48]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " constdecl "  */
void PAS_COMILER_PRC_00000044(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+851;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4925; /* line # 4925 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=4926; /* line # 4926 */
  Ra.sl[6]=4928; /* line # 4928 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==43){
    Ra.sl[6]=4930; /* line # 4930 */
    if (V_sy_sym.ub[0]==43) {
      Ra.sl[6]=4932; /* line # 4932 */
      P_insymbol();
      Ra.sl[6]=4933; /* line # 4933 */
      Rv0=1;
    }
    else {
      Ra.sl[6]=4935; /* line # 4935 */
      Rv0=0;
    }
    Ra.sl[6]=4936; /* line # 4936 */
    if (V_sy_sym.ub[0]!=0) {
      Ra.sl[6]=4938; /* line # 4938 */
      P_src_error(Rd.s+864,107,3);
      Ra.sl[6]=4939; /* line # 4939 */
      P_skip_symbol(18,0,0);
    }
    else {
      Ra.sl[6]=4943; /* line # 4943 */
      P_ide_new(4,NULL,&Rv1);
      Ra.sl[6]=4944; /* line # 4944 */
      P_insymbol();
      Ra.sl[6]=4946; /* line # 4946 */
      if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) {
        Ra.sl[6]=4947; /* line # 4947 */
        P_src_error(Rd.s+864,30,2);
      }
      else {
        Ra.sl[6]=4949; /* line # 4949 */
        P_insymbol();
      }
      Ra.sl[6]=4950; /* line # 4950 */
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=4951; /* line # 4951 */
      Rv3=Rv1;
      Rv4=Rv2;
      Ra.sl[6]=4953; /* line # 4953 */
      if (((UB *)Rv4)[40]!=14) P_src_error(Rd.s+864,53,3);
      else {
        Ra.sl[6]=4956; /* line # 4956 */
        ((V *)Rv3)[4]=((V *)Rv4)[3];
        Ra.sl[6]=4957; /* line # 4957 */
        ((V *)Rv3)[8]=((V *)Rv4)[7];
        Ra.sl[6]=4958; /* line # 4958 */
        ((UB *)Rv3)[80]=2;
        Ra.sl[6]=4959; /* line # 4959 */
        ((V *)Rv4)[7]=NULL;
        Ra.sl[6]=4960; /* line # 4960 */
        if ((((V *)Rv3)[8]!=NULL&&!Rv0)&&V_cmp_igenv==0) {
          Ra.sl[6]=4961; /* line # 4961 */
          if (((V *)Rv3)[4]!=NULL) {
            Ra.sl[6]=4962; /* line # 4962 */
            Rv5=((V *)Rv3)[8];
            Ra.sl[6]=4964; /* line # 4964 */
            ((SL *)Rv5)[5]=0;
            Ra.sl[6]=4965; /* line # 4965 */
            ((UW *)Rv5)[8]=((UW *)Rv5)[8]&~16384;
            Ra.sl[6]=4966; /* line # 4966 */
            P_cte_allocate(((V *)Rv3)[8],Rv1);
          }
        }
        Ra.sl[6]=4969; /* line # 4969 */
        if (V_sy_init_mod) {
          Ra.sl[6]=4970; /* line # 4970 */
          if (((UB *)((V *)Rv3)[4])[92]==8) {
            Ra.sl[6]=4971; /* line # 4971 */
            if (V_usi_tab==NULL) V_usi_tab=Rv1;
            else {
              Ra.sl[6]=4972; /* line # 4972 */
              if (V_csi_tab==NULL) V_csi_tab=Rv1;
            }
          }
        }
      }
      Ra.sl[6]=4975; /* line # 4975 */
      if (Rv2!=NULL) P_lgt_free_tree(&Rv2);
    }
    Ra.sl[6]=4977; /* line # 4977 */
    if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==18) P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " typedecl "  */
void PAS_COMILER_PRC_00000045(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UL Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  V Rv16;
  V Rv17;
  UB Rv18;
  register V Rv19;
  V Rv20;
  UB Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+868;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4999; /* line # 4999 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=5000; /* line # 5000 */
  Ra.sl[6]=5002; /* line # 5002 */
  if (V_sy_init_mod) {
    Ra.sl[6]=5003; /* line # 5003 */
    while (V_sy_sym.ub[0]==57){
      Ra.sl[6]=5005; /* line # 5005 */
      P_insymbol();
      Ra.sl[6]=5006; /* line # 5006 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5008; /* line # 5008 */
        Rv0=P_ide_search(2);
        Ra.sl[6]=5009; /* line # 5009 */
        if (Rv0!=NULL) Rv1=((V *)Rv0)[4];
        else {
          Ra.sl[6]=5010; /* line # 5010 */
          Rv1=NULL;
        }
        Ra.sl[6]=5011; /* line # 5011 */
        if (Rv1!=NULL) {
          Ra.sl[6]=5013; /* line # 5013 */
          P_insymbol();
          Ra.sl[6]=5014; /* line # 5014 */
          if (V_sy_sym.ub[0]==73) {
            Ra.sl[6]=5015; /* line # 5015 */
            Rv2=Rv1;
            Ra.sl[6]=5017; /* line # 5017 */
            Rv3=((SL *)Rv2)[11];
            Ra.sl[6]=5018; /* line # 5018 */
            Rv4=0;
            Ra.sl[6]=5019; /* line # 5019 */
            PAS_COMILER_PRC_00000040(&Rv3, &Rv4);
            Ra.sl[6]=5020; /* line # 5020 */
            ((SL *)Rv2)[11]=Rv3;
            ((UB *)Rv2)[48]=Rv4;
            Ra.sl[6]=5022; /* line # 5022 */
            if ((((UB *)Rv2)[92]==2||((UB *)Rv2)[92]==1)||((UB *)Rv2)[92]==0) {
              Ra.sl[6]=5025; /* line # 5025 */
              if (Rv3<4) {
                Ra.sl[6]=5027; /* line # 5027 */
                if (((UB *)Rv2)[112]) {
                  Ra.sl[6]=5029; /* line # 5029 */
                  ((UL *)Rv2)[29]=0;
                  Ra.sl[6]=5030; /* line # 5030 */
                  Rv5=PAS__IIPOWER(2,8*Rv3);
                  Ra.sl[6]=5031; /* line # 5031 */
                  if (((UL *)Rv2)[30]>Rv5) ((UL *)Rv2)[30]=Rv5-1;
                }
                else {
                  Ra.sl[6]=5035; /* line # 5035 */
                  Rv6=PAS__IIPOWER(2,8*Rv3-1);
                  Ra.sl[6]=5036; /* line # 5036 */
                  if (((SL *)Rv2)[30]>=Rv6) ((SL *)Rv2)[30]=Rv6-1;
                  Ra.sl[6]=5037; /* line # 5037 */
                  if (((SL *)Rv2)[29]<= -Rv6) ((SL *)Rv2)[29]= -Rv6;
                }
              }
              else {
                Ra.sl[6]=5041; /* line # 5041 */
                if (((UB *)Rv2)[112]) {
                  ((SL *)Rv2)[29]=0;
                  ((SL *)Rv2)[30]=-1;
                }
                else {
                  Ra.sl[6]=5042; /* line # 5042 */
                  ((SL *)Rv2)[30]=2147483647;
                  ((SL *)Rv2)[29]= -((SL *)Rv2)[30]-1;
                }
              }
            }
            Ra.sl[6]=5044; /* line # 5044 */
            switch (((UB *)Rv2)[92]) {
              case 2:Ra.sl[6]=5047; /* line # 5047 */
              V_inte_size=((SL *)Rv2)[11];
              Ra.sl[6]=5048; /* line # 5048 */
              ((SL *)V_uns_typ)[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5049; /* line # 5049 */
              ((UB *)V_uns_typ)[48]=((UB *)Rv2)[48];
              break;
              case 5:
              case 13:Ra.sl[6]=5053; /* line # 5053 */
              V_fptr_size=((SL *)Rv2)[11];
              Ra.sl[6]=5054; /* line # 5054 */
              ((SL *)V_typ_std.v[13])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5055; /* line # 5055 */
              ((UB *)V_typ_std.v[13])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5056; /* line # 5056 */
              ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5057; /* line # 5057 */
              ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5058; /* line # 5058 */
              ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5059; /* line # 5059 */
              ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5060; /* line # 5060 */
              ((SL *)V_typ_std.v[16])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5061; /* line # 5061 */
              ((UB *)V_typ_std.v[16])[48]=((UB *)Rv2)[48];
              break;
              case 3:Ra.sl[6]=5063; /* line # 5063 */
              V_sngl_size=((SL *)Rv2)[11];
              break;
              case 4:Ra.sl[6]=5064; /* line # 5064 */
              V_dble_size=((SL *)Rv2)[11];
              break;
              case 17:
              case 19:Ra.sl[6]=5067; /* line # 5067 */
              V_dst_setw=((SL *)Rv2)[11]*8;
              Ra.sl[6]=5068; /* line # 5068 */
              V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
              Ra.sl[6]=5069; /* line # 5069 */
              ((UB *)V_typ_std.v[18])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5070; /* line # 5070 */
              ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5071; /* line # 5071 */
              ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5072; /* line # 5072 */
              ((SL *)V_typ_std.v[19])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5073; /* line # 5073 */
              ((SL *)V_typ_std.v[17])[11]=((SL *)Rv2)[11];
              break;
              case 18:Ra.sl[6]=5077; /* line # 5077 */
              V_dst_seta=((SL *)Rv2)[11]*8;
              Ra.sl[6]=5078; /* line # 5078 */
              V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
              Ra.sl[6]=5079; /* line # 5079 */
              ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5080; /* line # 5080 */
              ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
              break;
              case 16:Ra.sl[6]=5085; /* line # 5085 */
              Rv7=((UB *)V_typ_std.v[5])[48];
              Ra.sl[6]=5086; /* line # 5086 */
              if (Rv7!=Rv4) ((UB *)Rv2)[48]=Rv7;
              Ra.sl[6]=5088; /* line # 5088 */
              Rv7=((SL *)V_typ_std.v[16])[11];
              Ra.sl[6]=5089; /* line # 5089 */
              if (Rv3!=Rv7) {
                Ra.sl[6]=5091; /* line # 5091 */
                if (Rv3<Rv7) Rv3=Rv7;
                else {
                  Ra.sl[6]=5092; /* line # 5092 */
                  if (PAS__I_MOD(Rv3,Rv7)!=0) Rv3=Rv7*(Rv3/Rv7+1);
                }
                Ra.sl[6]=5093; /* line # 5093 */
                ((SL *)Rv2)[11]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=5099; /* line # 5099 */
            if (V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
            Ra.sl[6]=5101; /* line # 5101 */
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else {
              Ra.sl[6]=5102; /* line # 5102 */
              P_src_error(Rd.s+880,21,2);
            }
          }
          else {
            Ra.sl[6]=5104; /* line # 5104 */
            P_skip_symbol(18,0,0);
          }
        }
        else {
          Ra.sl[6]=5108; /* line # 5108 */
          P_src_error(Rd.s+880,8001,3);
          Ra.sl[6]=5109; /* line # 5109 */
          P_skip_symbol(18,0,0);
        }
      }
      else {
        Ra.sl[6]=5114; /* line # 5114 */
        P_src_error(Rd.s+880,8002,3);
        Ra.sl[6]=5115; /* line # 5115 */
        P_skip_symbol(18,0,0);
      }
    }
  }
  Ra.sl[6]=5121; /* line # 5121 */
  while (V_sy_sym.ub[0]==0){
    Ra.sl[6]=5123; /* line # 5123 */
    Rv0=Lx[5].v[1];
    Rv8=NULL;
    Ra.sl[6]=5124; /* line # 5124 */
    while (Rv0!=NULL&&Rv8==NULL){
      Ra.sl[6]=5126; /* line # 5126 */
      Rv9=Rv0;
      Ra.sl[6]=5127; /* line # 5127 */
      if (P_match(((V *)Rv9)[0],V_sy_ident.s)==0) {
        Ra.sl[6]=5129; /* line # 5129 */
        Rv8=Rv0;
        Ra.sl[6]=5130; /* line # 5130 */
        if (Rv0==Lx[5].v[1]) Lx[5].v[1]=((V *)Lx[5].v[1])[8];
        else {
          Ra.sl[6]=5131; /* line # 5131 */
          ((V *)Rv10)[8]=((V *)Rv0)[8];
        }
      }
      Ra.sl[6]=5133; /* line # 5133 */
      Rv10=Rv0;
      Rv0=((V *)Rv0)[8];
    }
    Ra.sl[6]=5135; /* line # 5135 */
    if (Rv8==NULL) {
      Ra.sl[6]=5138; /* line # 5138 */
      P_ide_new(1,NULL,&Rv8);
      Ra.sl[6]=5139; /* line # 5139 */
      Rv1=NULL;
    }
    else {
      Ra.sl[6]=5141; /* line # 5141 */
      Rv1=((V *)Rv8)[4];
    }
    Ra.sl[6]=5142; /* line # 5142 */
    Rv11=Rv8;
    Ra.sl[6]=5144; /* line # 5144 */
    Rv12=V_curr_disp;
    Ra.sl[6]=5145; /* line # 5145 */
    P_insymbol();
    Ra.sl[6]=5146; /* line # 5146 */
    Rv3=0;
    Ra.sl[6]=5147; /* line # 5147 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=5149; /* line # 5149 */
      P_insymbol();
      Ra.sl[6]=5150; /* line # 5150 */
      P_new_disp_level(NULL,4);
      Ra.sl[6]=5151; /* line # 5151 */
      PAS_COMILER_PRC_00000037(2, &Rv3, &Rv7,NULL);
      Ra.sl[6]=5152; /* line # 5152 */
      Rv0=V_lex_ident_tree.v[V_curr_disp*8+1];
      Ra.sl[6]=5153; /* line # 5153 */
      Rv13=Rv0;
      Ra.sl[6]=5154; /* line # 5154 */
      Rv14=NULL;
      Ra.sl[6]=5155; /* line # 5155 */
      while (Rv13!=NULL){
        Ra.sl[6]=5157; /* line # 5157 */
        P_lgt_new(&Rv15,((V *)Rv13)[4],14,NULL);
        Ra.sl[6]=5158; /* line # 5158 */
        ((V *)Rv15)[7]=((V *)Rv13)[11];
        Ra.sl[6]=5159; /* line # 5159 */
        P_val_new(((V *)Rv15)+7,((V *)Rv13)[4]);
        Ra.sl[6]=5160; /* line # 5160 */
        if (Rv14==NULL) Rv14=Rv15;
        else {
          Ra.sl[6]=5161; /* line # 5161 */
          ((V *)Rv16)[0]=Rv15;
        }
        Ra.sl[6]=5162; /* line # 5162 */
        Rv16=Rv15;
        Ra.sl[6]=5163; /* line # 5163 */
        Rv13=((V *)Rv13)[3];
      }
    }
    else {
      Ra.sl[6]=5166; /* line # 5166 */
      Rv0=NULL;
    }
    Ra.sl[6]=5168; /* line # 5168 */
    if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+880,30,2);
    else {
      Ra.sl[6]=5169; /* line # 5169 */
      P_insymbol();
    }
    Ra.sl[6]=5171; /* line # 5171 */
    if (V_sy_sym.ub[0]==15) {
      Ra.sl[6]=5173; /* line # 5173 */
      V_sy_sym.ub[0]=17;
      Ra.sl[6]=5174; /* line # 5174 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[6]=5176; /* line # 5176 */
        P_insymbol();
        Ra.sl[6]=5177; /* line # 5177 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=5179; /* line # 5179 */
          Rv17=P_level_search(V_attr_list);
          Ra.sl[6]=5180; /* line # 5180 */
          P_insymbol();
          Ra.sl[6]=5181; /* line # 5181 */
          if (Rv17!=NULL) {
            Ra.sl[6]=5182; /* line # 5182 */
            switch (((UB *)Rv17)[57]) {
              case 25:Ra.sl[6]=5183; /* line # 5183 */
              Rv18=1;
              break;
              case 27:Ra.sl[6]=5184; /* line # 5184 */
              Rs.sl[0]=1;
              break;
              case 28:Ra.sl[6]=5185; /* line # 5185 */
              Rs.sl[0]=2;
              break;
              case 29:Ra.sl[6]=5186; /* line # 5186 */
              Rs.sl[0]=4;
              break;
              default:Ra.sl[6]=5188; /* line # 5188 */
              P_src_error_s(Rd.s+880,161,2, V_sy_ident.s,NULL);
              break;
            }
          }
          else {
            Ra.sl[6]=5191; /* line # 5191 */
            P_src_error_s(Rd.s+880,167,2, V_sy_ident.s,NULL);
          }
        }
        else {
          Ra.sl[6]=5195; /* line # 5195 */
          P_src_error(Rd.s+880,163,2);
          Ra.sl[6]=5196; /* line # 5196 */
          P_skip_symbol(16,0,0);
        }
      }
      Ra.sl[6]=5199; /* line # 5199 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=5200; /* line # 5200 */
        P_src_error(Rd.s+880,26,2);
      }
    }
    Ra.sl[6]=5204; /* line # 5204 */
    PAS_COMILER_PRC_00000038(((V *)Rv11)+4,Rv3, Rv0,1,0);
    Ra.sl[6]=5206; /* line # 5206 */
    V_curr_disp=Rv12;
    Ra.sl[6]=5207; /* line # 5207 */
    ((V *)Rv11)[10]=V_sy_type_gfirst;
    Ra.sl[6]=5208; /* line # 5208 */
    ((V *)Rv11)[11]=NULL;
    Ra.sl[6]=5209; /* line # 5209 */
    V_tcas_flag=0;
    Ra.sl[6]=5210; /* line # 5210 */
    Rv19=((V *)Rv11)[4];
    Ra.sl[6]=5211; /* line # 5211 */
    if (Rv0!=NULL) {
      Ra.sl[6]=5215; /* line # 5215 */
      switch (((UB *)Rv19)[92]) {
        case 8:
        case 10:
        case 11:
        case 12:
        case 22:
        case 27:Ra.sl[6]=5219; /* line # 5219 */
        ((SL *)Rv19)[10]=P_ide_typ_align(Rv3,((V *)Rv11)[4]);
        Ra.sl[6]=5220; /* line # 5220 */
        ((V *)Rv19)[4]=Rv0;
        Ra.sl[6]=5221; /* line # 5221 */
        if (Rv7>((UB *)((V *)Rv11)[4])[48]) {
          Ra.sl[6]=5222; /* line # 5222 */
          ((UB *)((V *)Rv11)[4])[48]=Rv7;
        }
        Ra.sl[6]=5223; /* line # 5223 */
        if (((SL *)Rv19)[11]<0) {
          Ra.sl[6]=5225; /* line # 5225 */
          Rv20=P_lgt_type_eval(((V *)Rv19)[9],NULL,NULL,0);
          Ra.sl[6]=5226; /* line # 5226 */
          if (((UB *)Rv20)[40]==14) {
            Ra.sl[6]=5228; /* line # 5228 */
            ((SL *)Rv19)[11]= -((SL *)((V *)Rv20)[7])[13];
            Ra.sl[6]=5230; /* line # 5230 */
            if (((SL *)Rv19)[11]>=0) ((SL *)Rv19)[11]=-1;
            Ra.sl[6]=5231; /* line # 5231 */
            P_lgt_free(&Rv20);
          }
        }
        break;
        default:Ra.sl[6]=5237; /* line # 5237 */
        P_src_error(Rd.s+880,205,3);
        break;
      }
      Ra.sl[6]=5240; /* line # 5240 */
      Rv21=((UB *)Rv19)[92]!=10;
      Ra.sl[6]=5242; /* line # 5242 */
      if (Rv21) {
        Ra.sl[6]=5244; /* line # 5244 */
        if (((V *)Rv19)[9]==NULL) {
          Ra.sl[6]=5245; /* line # 5245 */
          ((SL *)Rv19)[11]=((SL *)Rv19)[11]+((SL *)Rv19)[10];
        }
        else {
          Ra.sl[6]=5248; /* line # 5248 */
          if (((UB *)((V *)Rv19)[9])[40]==14) {
            Ra.sl[6]=5250; /* line # 5250 */
            Rv22=((V *)Rv19)[9];
            Ra.sl[6]=5251; /* line # 5251 */
            if (((V *)Rv22)[7]!=NULL) {
              Ra.sl[6]=5252; /* line # 5252 */
              ((SL *)((V *)Rv22)[7])[13]=((SL *)((V *)Rv22)[7])[13]+((SL *)Rv19)
              [10];
            }
          }
          else {
            Ra.sl[6]=5256; /* line # 5256 */
            ((V *)((V *)Rv19)[9])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv19)
            [10]);
            Ra.sl[6]=5258; /* line # 5258 */
            ((V *)Rv19)[9]=P_lgt_new_code(49,((V *)Rv19)[9]);
          }
        }
      }
      Ra.sl[6]=5263; /* line # 5263 */
      if (V_tcas_flag) P_lgt_gen_routine(((V *)Rv11)[4]);
    }
    Ra.sl[6]=5267; /* line # 5267 */
    Rv23=((V *)Rv11)[4];
    Ra.sl[6]=5268; /* line # 5268 */
    if (((V *)Rv23)[3]==NULL) {
      Ra.sl[6]=5270; /* line # 5270 */
      if (((V *)Rv23)[0]!=NULL) {
        Ra.sl[6]=5271; /* line # 5271 */
        if (((V *)((V *)Rv23)[0])[3]!=NULL) {
          Ra.sl[6]=5273; /* line # 5273 */
          ((V *)Rv11)[10]=((V *)((V *)((V *)Rv23)[0])[3])[10];
        }
      }
      Ra.sl[6]=5274; /* line # 5274 */
      ((V *)Rv23)[3]=Rv8;
    }
    Ra.sl[6]=5277; /* line # 5277 */
    if (Rv1!=NULL) ((V *)Rv1)[12]=((V *)Rv11)[4];
    Ra.sl[6]=5280; /* line # 5280 */
    if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
      Ra.sl[6]=5282; /* line # 5282 */
      P_insymbol();
      Ra.sl[6]=5283; /* line # 5283 */
      if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) Rv20=PAS_COMILER_PRC_00000019((
      (V *)Rv11)[4]);
      else {
        Ra.sl[6]=5284; /* line # 5284 */
        Rv20=PAS_COMILER_PRC_00000005(((V *)Rv11)[4],0,0,0);
      }
      Ra.sl[6]=5285; /* line # 5285 */
      if (((UB *)Rv20)[40]!=14) {
        Ra.sl[6]=5286; /* line # 5286 */
        P_src_error(Rd.s+880,53,3);
      }
      else {
        Ra.sl[6]=5289; /* line # 5289 */
        Rv24=Rv20;
        Ra.sl[6]=5291; /* line # 5291 */
        ((V *)((V *)Rv11)[4])[10]=((V *)Rv24)[7];
        Ra.sl[6]=5292; /* line # 5292 */
        ((V *)Rv24)[7]=NULL;
      }
      Ra.sl[6]=5294; /* line # 5294 */
      P_lgt_free_tree(&Rv20);
    }
    Ra.sl[6]=5298; /* line # 5298 */
    if (Rv0!=NULL&&((V *)Rv11)[4]!=NULL) {
      Ra.sl[6]=5300; /* line # 5300 */
      ((V *)((V *)Rv11)[4])[1]=P_type_parm_set(Rv8, Rv14);
    }
    Ra.sl[6]=5301; /* line # 5301 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=5302; /* line # 5302 */
      P_src_error(Rd.s+880,21,2);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " vardecl "  */
void PAS_COMILER_PRC_00000046(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+884;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5323; /* line # 5323 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=5324; /* line # 5324 */
  Rv0=0;
  Ra.sl[6]=5325; /* line # 5325 */
  Ra.sl[6]=5326; /* line # 5326 */
  PAS_COMILER_PRC_00000037(5, &Rv0, &Rv1,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " labeldecl "  */
void PAS_COMILER_PRC_00000047(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+893;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5340; /* line # 5340 */
  Rv0=0;
  Ra.sl[6]=5341; /* line # 5341 */
  while (1){
    Ra.sl[6]=5344; /* line # 5344 */
    P_insymbol();
    Ra.sl[6]=5345; /* line # 5345 */
    if (V_sy_sym.ub[0]==2) P_ide_int_label();
    Ra.sl[6]=5346; /* line # 5346 */
    if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+906,69,3);
    else {
      Ra.sl[6]=5350; /* line # 5350 */
      P_ide_new(3,NULL,&Rv1);
      Ra.sl[6]=5351; /* line # 5351 */
      if (Rv1!=NULL) {
        Ra.sl[6]=5352; /* line # 5352 */
        Rv2=Rv1;
        Ra.sl[6]=5354; /* line # 5354 */
        Rv3=Lx[5].v[13];
        Ra.sl[6]=5355; /* line # 5355 */
        if (((V *)Rv3)[20]==NULL) ((V *)Rv3)[20]=Rv1;
        else {
          Ra.sl[6]=5356; /* line # 5356 */
          ((V *)Lx[5].v[4])[8]=Rv1;
        }
        Ra.sl[6]=5357; /* line # 5357 */
        Lx[5].v[4]=Rv1;
        Ra.sl[6]=5358; /* line # 5358 */
        ((UB *)Rv2)[57]=1;
      }
    }
    Ra.sl[6]=5361; /* line # 5361 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=17)  break;
  }
  Ra.sl[6]=5363; /* line # 5363 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else {
    Ra.sl[6]=5364; /* line # 5364 */
    P_src_error(Rd.s+906,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statementdecl "  */
void PAS_COMILER_PRC_00000048(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+910;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5384; /* line # 5384 */
  Ra.sl[6]=5386; /* line # 5386 */
  P_insymbol();
  Ra.sl[6]=5387; /* line # 5387 */
  if (V_sy_sym.ub[0]!=0) {
    Ra.sl[6]=5389; /* line # 5389 */
    P_src_error(Rd.s+927,107,3);
    Ra.sl[6]=5390; /* line # 5390 */
    P_skip_symbol(18,1,0);
  }
  else {
    Ra.sl[6]=5394; /* line # 5394 */
    V_err_prt=0;
    Ra.sl[6]=5395; /* line # 5395 */
    Rv0=P_ide_search(1024);
    Ra.sl[6]=5396; /* line # 5396 */
    V_err_prt=1;
    Ra.sl[6]=5397; /* line # 5397 */
    if (Rv0!=NULL) {
      Ra.sl[6]=5398; /* line # 5398 */
      if (((SL *)Rv0)[10]!=V_curr_lex) Rv1=NULL;
      else {
        Ra.sl[6]=5399; /* line # 5399 */
        Rv1=Rv0;
      }
    }
    else {
      Ra.sl[6]=5400; /* line # 5400 */
      Rv1=NULL;
    }
    Ra.sl[6]=5402; /* line # 5402 */
    if (Rv1==NULL) {
      Ra.sl[6]=5403; /* line # 5403 */
      P_ide_new(10,NULL,&Rv1);
    }
    Ra.sl[6]=5404; /* line # 5404 */
    P_insymbol();
    Ra.sl[6]=5406; /* line # 5406 */
    Ra.sl[6]=5408; /* line # 5408 */
    if (V_sy_sym.ub[0]==57) {
      Ra.sl[6]=5410; /* line # 5410 */
      P_insymbol();
      Ra.sl[6]=5411; /* line # 5411 */
      if (V_sy_sym.ub[0]==37) P_insymbol();
      Ra.sl[6]=5412; /* line # 5412 */
      if (V_sy_sym.ub[0]==40) {
        Ra.sl[6]=5414; /* line # 5414 */
        P_insymbol();
        Ra.sl[6]=5415; /* line # 5415 */
        if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+927,25,2);
        Ra.sl[6]=5416; /* line # 5416 */
        Rv2=0;
        Ra.sl[6]=5418; /* line # 5418 */
        PAS_COMILER_PRC_00000042(Ri.v+3,1, &Rv2);
      }
      else {
        Ra.sl[6]=5421; /* line # 5421 */
        PAS_COMILER_PRC_00000038(Ri.v+3,0,NULL,0,1);
      }
      Ra.sl[6]=5423; /* line # 5423 */
      if (V_sy_sym.ub[0]==22) {
        Ra.sl[6]=5425; /* line # 5425 */
        P_insymbol();
        Ra.sl[6]=5426; /* line # 5426 */
        Ri.v[4]=PAS_COMILER_PRC_00000005(Ri.v[3],0,0,0);
      }
      Ra.sl[6]=5428; /* line # 5428 */
      if (V_sy_sym.ub[0]==48) {
        Ra.sl[6]=5429; /* line # 5429 */
        Ri.ub[17]=1;
        P_insymbol();
      }
      Ra.sl[6]=5430; /* line # 5430 */
      if (V_sy_sym.ub[0]==53) P_insymbol();
      else {
        Ra.sl[6]=5431; /* line # 5431 */
        P_src_error(Rd.s+927,55,2);
      }
    }
    Ra.sl[6]=5433; /* line # 5433 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5435; /* line # 5435 */
      Ri.v[5]=P_ide_search(514);
      Ra.sl[6]=5436; /* line # 5436 */
      P_insymbol();
    }
    Ra.sl[6]=5438; /* line # 5438 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else {
      Ra.sl[6]=5439; /* line # 5439 */
      P_src_error(Rd.s+927,29,2);
    }
    Ra.sl[6]=5440; /* line # 5440 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5442; /* line # 5442 */
      Ri.v[6]=P_ide_search(514);
      Ra.sl[6]=5443; /* line # 5443 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=5444; /* line # 5444 */
      P_src_error_s(Rd.s+927,42,3,((V *)Rv1)[0],NULL);
    }
    Ra.sl[6]=5445; /* line # 5445 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=5447; /* line # 5447 */
      P_insymbol();
      Ra.sl[6]=5448; /* line # 5448 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5450; /* line # 5450 */
        Ri.v[7]=P_ide_search(514);
        Ra.sl[6]=5451; /* line # 5451 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=5453; /* line # 5453 */
        P_src_error_s(Rd.s+927,43,2,((V *)Rv1)[0],NULL);
      }
    }
    Ra.sl[6]=5457; /* line # 5457 */
    if (V_error_result<=1) {
      Ra.sl[6]=5459; /* line # 5459 */
      Rv3=PAS__NEW(56);
      Ra.sl[6]=5460; /* line # 5460 */
      memcpy(Rv3,Ri.s+8,56);
      Ra.sl[6]=5461; /* line # 5461 */
      Rv4=Rv1;
      Ra.sl[6]=5463; /* line # 5463 */
      if (((V *)Rv4)[9]==NULL) {
        Ra.sl[6]=5465; /* line # 5465 */
        if (Rv0!=NULL) {
          Ra.sl[6]=5466; /* line # 5466 */
          ((V *)Rv3)[0]=((V *)Rv0)[8];
        }
        Ra.sl[6]=5467; /* line # 5467 */
        ((V *)Rv4)[8]=Rv3;
        Ra.sl[6]=5468; /* line # 5468 */
        ((V *)Rv4)[9]=Rv3;
      }
      else {
        Ra.sl[6]=5472; /* line # 5472 */
        ((V *)Rv3)[0]=((V *)((V *)Rv4)[9])[0];
        Ra.sl[6]=5473; /* line # 5473 */
        ((V *)((V *)Rv4)[9])[0]=Rv3;
        Ra.sl[6]=5474; /* line # 5474 */
        ((V *)Rv4)[9]=Rv3;
      }
    }
  }
  Ra.sl[6]=5479; /* line # 5479 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else {
    Ra.sl[6]=5480; /* line # 5480 */
    P_src_error(Rd.s+927,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " argument_list "  */
UB PAS_COMILER_PRC_00000003(V *F_pr, UB F_isfunct, UB F_no_entry){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  SL Rv8;
  UW Rv9;
  UB Rv10;
  UW Rv11;
  UB Rv12;
  SL Rv13;
  V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+931;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5518; /* line # 5518 */
  Rv0=0;
  Ra.sl[6]=5519; /* line # 5519 */
  Rv1=Lx[5].v[13];
  Ra.sl[6]=5520; /* line # 5520 */
  Lx[5].v[13]=(*F_pr);
  Ra.sl[6]=5521; /* line # 5521 */
  Rv2=NULL;
  Ra.sl[6]=5522; /* line # 5522 */
  Rv3=0;
  Ra.sl[6]=5523; /* line # 5523 */
  Rv4=(*F_pr);
  Ra.sl[6]=5525; /* line # 5525 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=5527; /* line # 5527 */
    V_sy_sym.ub[0]=18;
    while (1){
      Ra.sl[6]=5529; /* line # 5529 */
      P_insymbol();
      Ra.sl[6]=5530; /* line # 5530 */
      if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
        Ra.sl[6]=5532; /* line # 5532 */
        if (F_no_entry) P_src_error(Rd.s+948,125,3);
        Ra.sl[6]=5533; /* line # 5533 */
        Rv0=1;
        Ra.sl[6]=5534; /* line # 5534 */
        Rv5=V_sy_sym.ub[0]==77;
        Ra.sl[6]=5535; /* line # 5535 */
        P_insymbol();
        Ra.sl[6]=5536; /* line # 5536 */
        Rv6=PAS_COMILER_PRC_00000001(Rv5);
        Ra.sl[6]=5537; /* line # 5537 */
        Rv3=Rv3+1;
        Ra.sl[6]=5539; /* line # 5539 */
        if (Rv2==NULL) Rv2=Rv6;
        Ra.sl[6]=5540; /* line # 5540 */
        Rv7=Rv6;
      }
      else {
        Ra.sl[6]=5544; /* line # 5544 */
        Rv8=0;
        Ra.sl[6]=5545; /* line # 5545 */
        Rv9=96;
        Ra.sl[6]=5546; /* line # 5546 */
        Rv10=0;
        Ra.sl[6]=5547; /* line # 5547 */
        Rv11=0;
        Ra.sl[6]=5548; /* line # 5548 */
        Rv12=8;
        while (1){
          Ra.sl[6]=5550; /* line # 5550 */
          switch (V_sy_sym.ub[0]) {
            case 30:Ra.sl[6]=5551; /* line # 5551 */
            Rv12=7;
            break;
            case 35:Ra.sl[6]=5552; /* line # 5552 */
            Rv9=32;
            Rv12=7;
            break;
            case 36:Ra.sl[6]=5553; /* line # 5553 */
            Rv9=64;
            Rv12=7;
            break;
            default:Ra.sl[6]=5555; /* line # 5555 */
            Rv10=1;
            break;
          }
          Ra.sl[6]=5557; /* line # 5557 */
          if (!Rv10) P_insymbol();
          if (Rv10)  break;
        }
        Ra.sl[6]=5560; /* line # 5560 */
        Rv7=NULL;
        Ra.sl[6]=5561; /* line # 5561 */
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=5563; /* line # 5563 */
          P_ide_new(5,NULL,&Rv6);
          Ra.sl[6]=5564; /* line # 5564 */
          Rv3=Rv3+1;
          Ra.sl[6]=5565; /* line # 5565 */
          Rv8=Rv8+1;
          Ra.sl[6]=5567; /* line # 5567 */
          if (Rv7==NULL) {
            Ra.sl[6]=5569; /* line # 5569 */
            if (Rv2==NULL) Rv2=Rv6;
            Ra.sl[6]=5570; /* line # 5570 */
            Rv7=Rv6;
          }
          Ra.sl[6]=5572; /* line # 5572 */
          P_insymbol();
          Ra.sl[6]=5573; /* line # 5573 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=5575; /* line # 5575 */
            if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+948,29,2);
          }
        }
        Ra.sl[6]=5578; /* line # 5578 */
        if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+948,31,2);
        else {
          Ra.sl[6]=5579; /* line # 5579 */
          P_insymbol();
        }
        Ra.sl[6]=5581; /* line # 5581 */
        if (V_sy_sym.ub[0]==15) {
          while (1){
            Ra.sl[6]=5584; /* line # 5584 */
            P_insymbol();
            Ra.sl[6]=5585; /* line # 5585 */
            if (V_sy_sym.ub[0]==0) {
              Ra.sl[6]=5587; /* line # 5587 */
              Rv6=P_level_search(V_attr_list);
              Ra.sl[6]=5588; /* line # 5588 */
              P_insymbol();
              Ra.sl[6]=5589; /* line # 5589 */
              if (Rv6!=NULL) {
                Ra.sl[6]=5590; /* line # 5590 */
                switch (((UB *)Rv6)[57]) {
                  case 17:Ra.sl[6]=5591; /* line # 5591 */
                  Rv9=Rv9|2048;
                  break;
                  case 16:Ra.sl[6]=5592; /* line # 5592 */
                  Rv9=Rv9|1024;
                  break;
                  case 1:Ra.sl[6]=5593; /* line # 5593 */
                  Rv9=Rv9|512;
                  break;
                  case 6:Ra.sl[6]=5594; /* line # 5594 */
                  Rv9=Rv9|256;
                  break;
                  case 24:Ra.sl[6]=5597; /* line # 5597 */
                  if (Rv12!=7) {
                    Ra.sl[6]=5598; /* line # 5598 */
                    P_src_error(Rd.s+948,242,2);
                  }
                  Ra.sl[6]=5599; /* line # 5599 */
                  Rv9=Rv9|8192;
                  break;
                  case 23:Ra.sl[6]=5601; /* line # 5601 */
                  Rv9=(Rv9|32)&~64;
                  break;
                  case 30:Ra.sl[6]=5602; /* line # 5602 */
                  Rv11=Rv11|4;
                  break;
                  case 31:Ra.sl[6]=5603; /* line # 5603 */
                  Rv11=Rv11|8;
                  break;
                  case 32:Ra.sl[6]=5604; /* line # 5604 */
                  Rv11=Rv11|16;
                  break;
                  case 33:Ra.sl[6]=5605; /* line # 5605 */
                  Rv11=Rv11|32;
                  break;
                  case 34:Ra.sl[6]=5606; /* line # 5606 */
                  Rv11=Rv11|64;
                  break;
                  default:break;
                }
              }
            }
            else {
              Ra.sl[6]=5610; /* line # 5610 */
              P_src_error(Rd.s+948,2,3);
            }
            if (V_sy_sym.ub[0]!=17)  break;
          }
          Ra.sl[6]=5612; /* line # 5612 */
          if (V_sy_sym.ub[0]==16) P_insymbol();
          else {
            Ra.sl[6]=5613; /* line # 5613 */
            P_src_error(Rd.s+948,26,2);
          }
        }
        Ra.sl[6]=5616; /* line # 5616 */
        if (V_sy_sym.ub[0]==37) P_insymbol();
        Ra.sl[6]=5617; /* line # 5617 */
        if (V_sy_sym.ub[0]==40) {
          Ra.sl[6]=5619; /* line # 5619 */
          if (Rv8>1) P_src_error(Rd.s+948,243,3);
          Ra.sl[6]=5620; /* line # 5620 */
          P_insymbol();
          Ra.sl[6]=5621; /* line # 5621 */
          if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+948,25,2);
          Ra.sl[6]=5622; /* line # 5622 */
          Rv13=0;
          Ra.sl[6]=5623; /* line # 5623 */
          if (!V_sy_init_mod) {
            Ra.sl[6]=5624; /* line # 5624 */
            if (Rv12==8&&!V_cmp_dynamic) {
              Ra.sl[6]=5626; /* line # 5626 */
              Rv12=7;
              Rv9=32;
              Ra.sl[6]=5627; /* line # 5627 */
              P_src_error(Rd.s+948,229,1);
            }
          }
          Ra.sl[6]=5630; /* line # 5630 */
          PAS_COMILER_PRC_00000042(&Rv14,1, &Rv13);
        }
        else {
          Ra.sl[6]=5634; /* line # 5634 */
          PAS_COMILER_PRC_00000038(&Rv14,0,NULL,0,1);
          Ra.sl[6]=5635; /* line # 5635 */
          if (Rv14!=NULL) {
            Ra.sl[6]=5636; /* line # 5636 */
            if (!V_sy_init_mod) {
              Ra.sl[6]=5637; /* line # 5637 */
              if ((((SL *)Rv14)[11]<0&&Rv12==8)&&!V_cmp_dynamic) {
                Ra.sl[6]=5640; /* line # 5640 */
                Rv12=7;
                Rv9=32;
                Ra.sl[6]=5641; /* line # 5641 */
                P_src_error(Rd.s+948,226,1);
              }
            }
          }
        }
        Ra.sl[6]=5644; /* line # 5644 */
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=5646; /* line # 5646 */
          P_insymbol();
          Ra.sl[6]=5647; /* line # 5647 */
          Rv15=PAS_COMILER_PRC_00000005(Rv14,0,0,0);
          Ra.sl[6]=5648; /* line # 5648 */
          Rv16=Rv15;
          Ra.sl[6]=5649; /* line # 5649 */
          if (((UB *)Rv16)[40]!=14) {
            Ra.sl[6]=5650; /* line # 5650 */
            P_src_error(Rd.s+948,53,3);
          }
          else {
            Ra.sl[6]=5653; /* line # 5653 */
            Rv17=((V *)Rv16)[7];
            Ra.sl[6]=5654; /* line # 5654 */
            ((V *)Rv16)[7]=NULL;
          }
          Ra.sl[6]=5656; /* line # 5656 */
          if (Rv12==7&&64&Rv9) {
            Ra.sl[6]=5657; /* line # 5657 */
            P_src_error(Rd.s+948,241,2);
          }
        }
        else {
          Ra.sl[6]=5659; /* line # 5659 */
          Rv17=NULL;
        }
        Ra.sl[6]=5660; /* line # 5660 */
        Rv6=Rv7;
        Ra.sl[6]=5661; /* line # 5661 */
        while (Rv6!=NULL){
          Ra.sl[6]=5663; /* line # 5663 */
          Rv18=Rv6;
          Ra.sl[6]=5664; /* line # 5664 */
          if (((UB *)Rv18)[94]==0) {
            Ra.sl[6]=5666; /* line # 5666 */
            ((V *)Rv18)[4]=Rv14;
            Ra.sl[6]=5667; /* line # 5667 */
            ((UW *)Rv18)[46]=Rv9;
            Ra.sl[6]=5668; /* line # 5668 */
            ((UB *)Rv18)[94]=Rv12;
            Ra.sl[6]=5669; /* line # 5669 */
            ((V *)Rv18)[8]=Rv17;
            Ra.sl[6]=5670; /* line # 5670 */
            ((UW *)Rv18)[48]=Rv11;
            Ra.sl[6]=5671; /* line # 5671 */
            if (Rv17!=NULL) P_val_new(((V *)Rv18)+8,Rv14);
          }
          Ra.sl[6]=5673; /* line # 5673 */
          Rv7=Rv6;
          Rv6=((V *)Rv6)[3];
        }
        Ra.sl[6]=5675; /* line # 5675 */
        if (Rv17!=NULL) P_val_free(&Rv17);
      }
      if (V_sy_sym.ub[0]!=18)  break;
    }
    Ra.sl[6]=5678; /* line # 5678 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=5679; /* line # 5679 */
      P_src_error(Rd.s+948,23,2);
    }
  }
  Ra.sl[6]=5681; /* line # 5681 */
  ((V *)Rv4)[11]=NULL;
  Ra.sl[6]=5682; /* line # 5682 */
  if (F_isfunct) {
    Ra.sl[6]=5684; /* line # 5684 */
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+948,31,2);
    Ra.sl[6]=5686; /* line # 5686 */
    Rv9=97;
    Ra.sl[6]=5687; /* line # 5687 */
    if (V_sy_sym.ub[0]==15) {
      while (1){
        Ra.sl[6]=5690; /* line # 5690 */
        P_insymbol();
        Ra.sl[6]=5691; /* line # 5691 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=5693; /* line # 5693 */
          Rv6=P_level_search(V_attr_list);
          Ra.sl[6]=5694; /* line # 5694 */
          P_insymbol();
          Ra.sl[6]=5695; /* line # 5695 */
          if (Rv6!=NULL) {
            Ra.sl[6]=5696; /* line # 5696 */
            switch (((UB *)Rv6)[57]) {
              case 16:Ra.sl[6]=5697; /* line # 5697 */
              Rv9=Rv9|1024;
              break;
              case 1:Ra.sl[6]=5698; /* line # 5698 */
              Rv9=Rv9|512;
              break;
              default:break;
            }
          }
        }
        else {
          Ra.sl[6]=5702; /* line # 5702 */
          P_src_error(Rd.s+948,2,3);
        }
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=5704; /* line # 5704 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=5705; /* line # 5705 */
        P_src_error(Rd.s+948,26,2);
      }
    }
    Ra.sl[6]=5707; /* line # 5707 */
    PAS_COMILER_PRC_00000038(((V *)Rv4)+11,0,NULL,0,1);
    Ra.sl[6]=5709; /* line # 5709 */
    if (((V *)Rv4)[11]==NULL) ((V *)Rv4)[11]=V_typ_std.v[21];
  }
  Ra.sl[6]=5711; /* line # 5711 */
  if (((V *)Rv4)[11]!=NULL) {
    Ra.sl[6]=5712; /* line # 5712 */
    if (!((UB *)((V *)Rv4)[11])[91]) {
      Ra.sl[6]=5714; /* line # 5714 */
      Rv19=((V *)Rv4)[11];
      Ra.sl[6]=5715; /* line # 5715 */
      if (((SL *)Rv19)[11]<0&&((V *)Rv19)[1]!=NULL) {
        Ra.sl[6]=5716; /* line # 5716 */
        ((V *)Rv4)[11]=((V *)Rv19)[1];
      }
      Ra.sl[6]=5719; /* line # 5719 */
      P_ide_create_name(Rd.s+952);
      Ra.sl[6]=5720; /* line # 5720 */
      P_ide_new(5,((V *)Rv4)[11],&Rv6);
      Ra.sl[6]=5721; /* line # 5721 */
      if (Rv2!=NULL) {
        Ra.sl[6]=5722; /* line # 5722 */
        ((V *)Rv7)[3]=NULL;
      }
      Ra.sl[6]=5723; /* line # 5723 */
      Rv20=Rv6;
      Ra.sl[6]=5725; /* line # 5725 */
      ((V *)Rv20)[3]=Rv2;
      Rv2=Rv6;
      Ra.sl[6]=5726; /* line # 5726 */
      ((UW *)Rv20)[46]=Rv9;
      Ra.sl[6]=5727; /* line # 5727 */
      ((UB *)Rv20)[94]=6;
    }
  }
  Ra.sl[6]=5730; /* line # 5730 */
  ((SL *)Rv4)[20]=Rv3;
  Ra.sl[6]=5731; /* line # 5731 */
  ((V *)Rv4)[8]=Rv2;
  Ra.sl[6]=5732; /* line # 5732 */
  Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
  Ra.sl[6]=5734; /* line # 5734 */
  ((V *)Rv4)[6]=((V *)Rv21)[1];
  Ra.sl[6]=5735; /* line # 5735 */
  ((V *)Rv4)[7]=((V *)Rv21)[4];
  Ra.sl[6]=5736; /* line # 5736 */
  ((V *)Rv4)[12]=((V *)Rv21)[5];
  Ra.sl[6]=5739; /* line # 5739 */
  Lx[5].v[13]=Rv1;
  Ra.sl[6]=5740; /* line # 5740 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_decl "  */
V PAS_COMILER_PRC_00000001(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+957;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5758; /* line # 5758 */
  Ra.sl[6]=5759; /* line # 5759 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=5761; /* line # 5761 */
    Rv0=P_level_search(V_lex_ident_tree.v[V_curr_disp*8+1]);
    Ra.sl[6]=5762; /* line # 5762 */
    if (Rv0!=NULL) P_src_error(Rd.s+977,101,3);
    Ra.sl[6]=5763; /* line # 5763 */
    P_ide_new(7,NULL,&Rv0);
    Ra.sl[6]=5764; /* line # 5764 */
    Rv1=PAS__NEW(120);
    Ra.sl[6]=5765; /* line # 5765 */
    Rv2=Rv1;
    Ra.sl[6]=5767; /* line # 5767 */
    ((V *)Rv2)[0]=NULL;
    Ra.sl[6]=5768; /* line # 5768 */
    ((V *)Rv2)[1]=NULL;
    Ra.sl[6]=5769; /* line # 5769 */
    ((UW *)Rv2)[8]=0;
    Ra.sl[6]=5770; /* line # 5770 */
    ((V *)Rv2)[3]=NULL;
    Ra.sl[6]=5771; /* line # 5771 */
    ((UB *)Rv2)[32]=29;
    Ra.sl[6]=5772; /* line # 5772 */
    ((V *)Rv2)[5]=NULL;
    Ra.sl[6]=5773; /* line # 5773 */
    ((V *)Rv2)[6]=NULL;
    Ra.sl[6]=5774; /* line # 5774 */
    ((V *)Rv2)[7]=NULL;
    Ra.sl[6]=5775; /* line # 5775 */
    ((V *)Rv2)[8]=NULL;
    Ra.sl[6]=5776; /* line # 5776 */
    ((SL *)Rv2)[18]=V_curr_lex;
    Ra.sl[6]=5777; /* line # 5777 */
    ((SL *)Rv2)[19]=0;
    Ra.sl[6]=5778; /* line # 5778 */
    ((SL *)Rv2)[20]=0;
    Ra.sl[6]=5779; /* line # 5779 */
    ((V *)Rv2)[11]=NULL;
    Ra.sl[6]=5780; /* line # 5780 */
    ((V *)Rv2)[12]=NULL;
    Ra.sl[6]=5781; /* line # 5781 */
    ((UB *)Rv2)[104]=3;
    Ra.sl[6]=5782; /* line # 5782 */
    ((V *)Rv2)[14]=NULL;
    Ra.sl[6]=5784; /* line # 5784 */
    ((V *)Rv0)[9]=Rv1;
    Ra.sl[6]=5786; /* line # 5786 */
    Rv3=V_curr_lex;
    Ra.sl[6]=5787; /* line # 5787 */
    Rv4=V_curr_disp;
    Ra.sl[6]=5788; /* line # 5788 */
    if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
    else {
      Ra.sl[6]=5789; /* line # 5789 */
      P_src_error(Rd.s+977,1002,3);
    }
    Ra.sl[6]=5790; /* line # 5790 */
    P_new_disp_level(Rv1,4);
    Ra.sl[6]=5791; /* line # 5791 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    Ra.sl[6]=5792; /* line # 5792 */
    P_insymbol();
    Ra.sl[6]=5793; /* line # 5793 */
    Rv5=PAS_COMILER_PRC_00000003(&Rv1, F_isfunction,0);
    Ra.sl[6]=5794; /* line # 5794 */
    V_curr_lex=Rv3;
    V_curr_disp=Rv4;
    Ra.sl[6]=5797; /* line # 5797 */
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[6]=5799; /* line # 5799 */
      P_insymbol();
      Ra.sl[6]=5800; /* line # 5800 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5803; /* line # 5803 */
        Rv6=P_ide_search(898);
        Ra.sl[6]=5804; /* line # 5804 */
        if (Rv6!=V_ide_udptr.v[1]) {
          Ra.sl[6]=5805; /* line # 5805 */
          Rv7=Rv6;
          Ra.sl[6]=5807; /* line # 5807 */
          Rv8=NULL;
          Ra.sl[6]=5808; /* line # 5808 */
          if (((UB *)Rv7)[56]==7) {
            Ra.sl[6]=5810; /* line # 5810 */
            Rv8=((V *)Rv7)[9];
            Ra.sl[6]=5811; /* line # 5811 */
            if (Rv8==Rv1) P_src_error(Rd.s+977,403,3);
          }
          else {
            Ra.sl[6]=5815; /* line # 5815 */
            if (((V *)Rv7)[11]!=((V *)Rv7)[10]&&((V *)Rv7)[11]!=NULL) {
              Ra.sl[6]=5816; /* line # 5816 */
              P_src_error_s(Rd.s+977,118,2, V_sy_ident.s,NULL);
            }
            else {
              Ra.sl[6]=5818; /* line # 5818 */
              Rv9=((V *)Rv7)[10];
              Ra.sl[6]=5819; /* line # 5819 */
              if (((UB *)Rv9)[8]) P_src_error(Rd.s+977,998,4);
              else {
                Ra.sl[6]=5820; /* line # 5820 */
                Rv8=((V *)Rv9)[2];
              }
            }
          }
          Ra.sl[6]=5823; /* line # 5823 */
          if (!P_comp_proc_arg(Rv8, Rv1)) P_src_error(Rd.s+977,119,3);
          else {
            Ra.sl[6]=5824; /* line # 5824 */
            ((V *)Rv0)[8]=Rv8;
          }
          Ra.sl[6]=5825; /* line # 5825 */
          P_insymbol();
        }
      }
      else {
        Ra.sl[6]=5829; /* line # 5829 */
        P_src_error(Rd.s+977,32,3);
      }
    }
  }
  else {
    Ra.sl[6]=5834; /* line # 5834 */
    Rv0=V_ide_udptr.v[7];
    Ra.sl[6]=5835; /* line # 5835 */
    P_src_error(Rd.s+977,107,3);
  }
  Ra.sl[6]=5837; /* line # 5837 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_ptr "  */
V PAS_COMILER_PRC_00000002(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  UB Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+981;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5856; /* line # 5856 */
  Ra.sl[6]=5858; /* line # 5858 */
  Rv0=PAS__NEW(120);
  Ra.sl[6]=5859; /* line # 5859 */
  Rv1=Rv0;
  Ra.sl[6]=5861; /* line # 5861 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[6]=5862; /* line # 5862 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=5863; /* line # 5863 */
  ((UW *)Rv1)[8]=0;
  Ra.sl[6]=5864; /* line # 5864 */
  ((V *)Rv1)[3]=NULL;
  Ra.sl[6]=5865; /* line # 5865 */
  ((UB *)Rv1)[32]=29;
  Ra.sl[6]=5866; /* line # 5866 */
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=5867; /* line # 5867 */
  ((V *)Rv1)[6]=NULL;
  Ra.sl[6]=5868; /* line # 5868 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=5869; /* line # 5869 */
  ((V *)Rv1)[8]=NULL;
  Ra.sl[6]=5870; /* line # 5870 */
  ((SL *)Rv1)[18]=V_curr_lex;
  Ra.sl[6]=5871; /* line # 5871 */
  ((SL *)Rv1)[19]=0;
  Ra.sl[6]=5872; /* line # 5872 */
  ((SL *)Rv1)[20]=0;
  Ra.sl[6]=5873; /* line # 5873 */
  ((V *)Rv1)[11]=NULL;
  Ra.sl[6]=5874; /* line # 5874 */
  ((V *)Rv1)[12]=NULL;
  Ra.sl[6]=5875; /* line # 5875 */
  ((UB *)Rv1)[104]=3;
  Ra.sl[6]=5876; /* line # 5876 */
  ((V *)Rv1)[14]=NULL;
  Ra.sl[6]=5878; /* line # 5878 */
  Rv2=V_curr_lex;
  Ra.sl[6]=5879; /* line # 5879 */
  Rv3=V_curr_disp;
  Ra.sl[6]=5880; /* line # 5880 */
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=5881; /* line # 5881 */
    P_src_error(Rd.s+1000,1002,3);
  }
  Ra.sl[6]=5882; /* line # 5882 */
  P_new_disp_level(Rv0,4);
  Ra.sl[6]=5883; /* line # 5883 */
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Ra.sl[6]=5884; /* line # 5884 */
  P_insymbol();
  Ra.sl[6]=5885; /* line # 5885 */
  Rv4=PAS_COMILER_PRC_00000003(&Rv0, F_isfunction,0);
  Ra.sl[6]=5886; /* line # 5886 */
  V_curr_lex=Rv2;
  V_curr_disp=Rv3;
  Ra.sl[6]=5888; /* line # 5888 */
  if (V_sy_sym.ub[0]==22) {
    Ra.sl[6]=5890; /* line # 5890 */
    P_insymbol();
    Ra.sl[6]=5891; /* line # 5891 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5894; /* line # 5894 */
      Rv5=P_ide_search(898);
      Ra.sl[6]=5895; /* line # 5895 */
      if (Rv5!=V_ide_udptr.v[1]) {
        Ra.sl[6]=5896; /* line # 5896 */
        Rv6=Rv5;
        Ra.sl[6]=5898; /* line # 5898 */
        Rv7=NULL;
        Ra.sl[6]=5899; /* line # 5899 */
        if (((UB *)Rv6)[56]==7) {
          Ra.sl[6]=5901; /* line # 5901 */
          Rv7=((V *)Rv6)[9];
          Ra.sl[6]=5902; /* line # 5902 */
          if (Rv7==Rv0) P_src_error(Rd.s+1000,403,3);
        }
        else {
          Ra.sl[6]=5906; /* line # 5906 */
          if (((V *)Rv6)[11]!=((V *)Rv6)[10]&&((V *)Rv6)[11]!=NULL) {
            Ra.sl[6]=5907; /* line # 5907 */
            P_src_error_s(Rd.s+1000,118,2, V_sy_ident.s,NULL);
          }
          else {
            Ra.sl[6]=5909; /* line # 5909 */
            Rv8=((V *)Rv6)[10];
            Ra.sl[6]=5910; /* line # 5910 */
            if (((UB *)Rv8)[8]) P_src_error(Rd.s+1000,998,4);
            else {
              Ra.sl[6]=5911; /* line # 5911 */
              Rv7=((V *)Rv8)[2];
            }
          }
        }
        Ra.sl[6]=5914; /* line # 5914 */
        if (!P_comp_proc_arg(Rv7, Rv0)) P_src_error(Rd.s+1000,119,3);
        else {
          Ra.sl[6]=5915; /* line # 5915 */
          ((V *)Rv5)[8]=Rv7;
        }
        Ra.sl[6]=5916; /* line # 5916 */
        P_insymbol();
      }
    }
    else {
      Ra.sl[6]=5919; /* line # 5919 */
      P_src_error(Rd.s+1000,32,3);
    }
  }
  else {
    Ra.sl[6]=5921; /* line # 5921 */
    Rv7=NULL;
  }
  Ra.sl[6]=5923; /* line # 5923 */
  P_ide_new_typ(6, &Rv9);
  Ra.sl[6]=5924; /* line # 5924 */
  Rv10=Rv9;
  Ra.sl[6]=5926; /* line # 5926 */
  ((V *)Rv10)[0]=NULL;
  Ra.sl[6]=5927; /* line # 5927 */
  memcpy(Rv10+48,V_typ_std.v[13]+48,1);
  Ra.sl[6]=5928; /* line # 5928 */
  ((SL *)Rv10)[11]=V_fptr_size;
  Ra.sl[6]=5929; /* line # 5929 */
  ((V *)Rv10)[12]=((V *)Rv0)[11];
  Ra.sl[6]=5930; /* line # 5930 */
  ((V *)Rv10)[13]=Rv0;
  Ra.sl[6]=5932; /* line # 5932 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insert_new_generic "  */
void PAS_COMILER_PRC_00000049(V *F_pgfirst, V *F_pglast, V F_pg, UB F_bwfent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1004;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5943; /* line # 5943 */
  if (F_pg!=NULL) {
    Ra.sl[6]=5945; /* line # 5945 */
    if (F_bwfent&&(*F_pgfirst)!=NULL) {
      Ra.sl[6]=5946; /* line # 5946 */
      P_src_error(Rd.s+1026,114,3);
    }
    Ra.sl[6]=5948; /* line # 5948 */
    if (V_sy_generic_qmod) {
      Ra.sl[6]=5950; /* line # 5950 */
      if ((*F_pgfirst)==NULL) (*F_pgfirst)=F_pg;
      else {
        Ra.sl[6]=5951; /* line # 5951 */
        ((V *)(*F_pglast))[0]=F_pg;
      }
      Ra.sl[6]=5952; /* line # 5952 */
      (*F_pglast)=F_pg;
    }
    else {
      Ra.sl[6]=5956; /* line # 5956 */
      ((V *)F_pg)[0]=(*F_pgfirst);
      Ra.sl[6]=5958; /* line # 5958 */
      (*F_pgfirst)=F_pg;
      Ra.sl[6]=5959; /* line # 5959 */
      if ((*F_pglast)==NULL) (*F_pglast)=F_pg;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_decl "  */
void PAS_COMILER_PRC_00000051(V F_pgf, V F_pgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  UB Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1030;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6022; /* line # 6022 */
  Lx[3].ub[0]=0;
  Ra.sl[6]=6023; /* line # 6023 */
  Lx[3].v[1]=NULL;
  Ra.sl[6]=6024; /* line # 6024 */
  Rv0=NULL;
  Ra.sl[6]=6025; /* line # 6025 */
  P_insymbol();
  Ra.sl[6]=6027; /* line # 6027 */
  if (V_sy_sym.ub[0]==13) Lx[3].ub[16]=0;
  Ra.sl[6]=6028; /* line # 6028 */
  if (!Lx[3].ub[16]) {
    Ra.sl[6]=6030; /* line # 6030 */
    Lx[3].v[3]=PAS__NEW(245);
    Ra.sl[6]=6031; /* line # 6031 */
    Rv1=Lx[3].v[3];
    Ra.sl[6]=6033; /* line # 6033 */
    ((V *)Rv1)[0]=NULL;
    Ra.sl[6]=6034; /* line # 6034 */
    ((V *)Rv1)[1]=NULL;
    Ra.sl[6]=6035; /* line # 6035 */
    ((UW *)Rv1)[8]=0;
    Ra.sl[6]=6036; /* line # 6036 */
    ((V *)Rv1)[3]=NULL;
    Ra.sl[6]=6037; /* line # 6037 */
    ((UB *)Rv1)[32]=29;
    Ra.sl[6]=6038; /* line # 6038 */
    ((V *)Rv1)[5]=NULL;
    Ra.sl[6]=6039; /* line # 6039 */
    ((V *)Rv1)[6]=NULL;
    Ra.sl[6]=6040; /* line # 6040 */
    ((V *)Rv1)[7]=NULL;
    Ra.sl[6]=6041; /* line # 6041 */
    ((V *)Rv1)[8]=NULL;
    Ra.sl[6]=6042; /* line # 6042 */
    ((SL *)Rv1)[18]=V_curr_lex;
    Ra.sl[6]=6043; /* line # 6043 */
    ((SL *)Rv1)[19]=0;
    Ra.sl[6]=6044; /* line # 6044 */
    ((SL *)Rv1)[20]=0;
    Ra.sl[6]=6045; /* line # 6045 */
    ((V *)Rv1)[11]=NULL;
    Ra.sl[6]=6046; /* line # 6046 */
    ((V *)Rv1)[12]=NULL;
    Ra.sl[6]=6047; /* line # 6047 */
    ((UB *)Rv1)[104]=9;
    Ra.sl[6]=6049; /* line # 6049 */
    ((V *)Rv1)[14]=Lx[5].v[13];
    Ra.sl[6]=6050; /* line # 6050 */
    ((V *)Rv1)[15]=NULL;
    Ra.sl[6]=6051; /* line # 6051 */
    ((V *)Rv1)[16]=NULL;
    Ra.sl[6]=6052; /* line # 6052 */
    ((V *)Rv1)[17]=NULL;
    Ra.sl[6]=6053; /* line # 6053 */
    ((V *)Rv1)[18]=NULL;
    Ra.sl[6]=6054; /* line # 6054 */
    ((V *)Rv1)[19]=NULL;
    Ra.sl[6]=6055; /* line # 6055 */
    ((V *)Rv1)[20]=NULL;
    Ra.sl[6]=6056; /* line # 6056 */
    ((V *)Rv1)[21]=NULL;
    Ra.sl[6]=6057; /* line # 6057 */
    ((V *)Rv1)[22]=NULL;
    Ra.sl[6]=6058; /* line # 6058 */
    ((V *)Rv1)[23]=NULL;
    Ra.sl[6]=6059; /* line # 6059 */
    ((V *)Rv1)[24]=NULL;
    Ra.sl[6]=6060; /* line # 6060 */
    ((V *)Rv1)[25]=NULL;
    Ra.sl[6]=6061; /* line # 6061 */
    ((V *)Rv1)[26]=NULL;
    Ra.sl[6]=6062; /* line # 6062 */
    ((V *)Rv1)[27]=NULL;
    Ra.sl[6]=6063; /* line # 6063 */
    ((SL *)Rv1)[56]=-1;
    Ra.sl[6]=6064; /* line # 6064 */
    ((SL *)Rv1)[57]=0;
    Ra.sl[6]=6065; /* line # 6065 */
    ((SL *)Rv1)[58]=0;
    Ra.sl[6]=6066; /* line # 6066 */
    ((SL *)Rv1)[59]=0;
    Ra.sl[6]=6067; /* line # 6067 */
    ((SL *)Rv1)[60]=0;
    Ra.sl[6]=6068; /* line # 6068 */
    ((UB *)Rv1)[244]=0;
  }
  else {
    Ra.sl[6]=6072; /* line # 6072 */
    Rv2=Lx[3].v[3];
    Ra.sl[6]=6074; /* line # 6074 */
    Rv0=((V *)Rv2)[8];
    Ra.sl[6]=6075; /* line # 6075 */
    if (((V *)Rv2)[11]!=NULL) {
      Ra.sl[6]=6076; /* line # 6076 */
      if (!((UB *)((V *)Rv2)[11])[91]) {
        Ra.sl[6]=6077; /* line # 6077 */
        Rv0=((V *)Rv0)[3];
      }
    }
  }
  Ra.sl[6]=6081; /* line # 6081 */
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=6082; /* line # 6082 */
    P_src_error(Rd.s+1043,1002,3);
  }
  Ra.sl[6]=6083; /* line # 6083 */
  P_new_disp_level(Lx[3].v[3],4);
  Ra.sl[6]=6084; /* line # 6084 */
  V_lex_ident_tree.v[V_curr_disp*8+1]=Rv0;
  Ra.sl[6]=6085; /* line # 6085 */
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Ra.sl[6]=6086; /* line # 6086 */
  Lx[3].sl[8]=V_curr_disp;
  Lx[3].sl[9]=V_curr_lex;
  Ra.sl[6]=6088; /* line # 6088 */
  Ra.sl[6]=6090; /* line # 6090 */
  if (!Lx[3].ub[16]) {
    Ra.sl[6]=6092; /* line # 6092 */
    Lx[3].ub[40]=PAS_COMILER_PRC_00000003(Lx[3].v+3,Lx[3].ub[41],Lx[3].ub[42]);
    Ra.sl[6]=6094; /* line # 6094 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6095; /* line # 6095 */
      P_src_error(Rd.s+1043,21,2);
    }
    Ra.sl[6]=6099; /* line # 6099 */
    if (Lx[3].sl[11]!=0) {
      Ra.sl[6]=6100; /* line # 6100 */
      if (Lx[3].sl[11]>0) {
        Ra.sl[6]=6101; /* line # 6101 */
        if (((SL *)Lx[3].v[3])[20]!=Lx[3].sl[11]) P_src_error_s(Rd.s+1043,127,2,
        Lx[3].s+48,NULL);
        else {
          Ra.sl[6]=6103; /* line # 6103 */
          if (((SL *)Lx[3].v[3])[20]!=1&&((SL *)Lx[3].v[3])[20]!=2) {
            Ra.sl[6]=6104; /* line # 6104 */
            P_src_error_s(Rd.s+1043,127,2, Lx[3].s+48,NULL);
          }
        }
      }
    }
    Ra.sl[6]=6107; /* line # 6107 */
    Lx[3].v[1]=P_compare_proc_argid(F_pgf, F_pgl, Lx[3].v[3]);
    Ra.sl[6]=6108; /* line # 6108 */
    Rv3=Lx[3].v[1]==NULL;
    Ra.sl[6]=6109; /* line # 6109 */
    if (!Rv3) {
      Ra.sl[6]=6111; /* line # 6111 */
      Rv4=Lx[3].v[3];
      Ra.sl[6]=6112; /* line # 6112 */
      Lx[3].v[3]=((V *)Lx[3].v[1])[2];
      Ra.sl[6]=6113; /* line # 6113 */
      Rv0=((V *)Lx[3].v[3])[8];
      Ra.sl[6]=6114; /* line # 6114 */
      Rv5=((V *)Rv4)[8];
      Ra.sl[6]=6115; /* line # 6115 */
      while (Rv0!=NULL&&Rv5!=NULL){
        Ra.sl[6]=6117; /* line # 6117 */
        PAS__DISPOSE(((V *)Rv0));
        Ra.sl[6]=6118; /* line # 6118 */
        ((V *)Rv0)[0]=((V *)Rv5)[0];
        Ra.sl[6]=6119; /* line # 6119 */
        Rv0=((V *)Rv0)[3];
        Rv5=((V *)Rv5)[3];
      }
      Ra.sl[6]=6121; /* line # 6121 */
      Rv6=(V_lex_ident_tree.s+V_curr_disp*64);
      Rv7=Lx[3].v[3];
      Ra.sl[6]=6123; /* line # 6123 */
      P_free_ide_list(((V *)Rv4)+8);
      Ra.sl[6]=6124; /* line # 6124 */
      P_free_typ_list(((V *)Rv4)+12);
      Ra.sl[6]=6125; /* line # 6125 */
      ((V *)Rv6)[0]=Lx[3].v[3];
      Ra.sl[6]=6126; /* line # 6126 */
      ((V *)Rv6)[1]=((V *)Rv7)[6];
      Ra.sl[6]=6129; /* line # 6129 */
      ((V *)Rv6)[4]=((V *)Rv7)[7];
      Ra.sl[6]=6130; /* line # 6130 */
      ((V *)Rv6)[5]=((V *)Rv7)[12];
      Ra.sl[6]=6135; /* line # 6135 */
      Lx[3].v[1]=NULL;
      Ra.sl[6]=6137; /* line # 6137 */
      switch (((UB *)Lx[3].v[3])[104]) {
        case 2:Ra.sl[6]=6139; /* line # 6139 */
        if (Lx[3].ub[80]!=8) P_src_error_s(Rd.s+1043,100,2, Lx[3].s+48,NULL);
        break;
        case 7:Ra.sl[6]=6141; /* line # 6141 */
        if (Lx[3].ub[80]!=9) P_src_error_s(Rd.s+1043,100,2, Lx[3].s+48,NULL);
        break;
        default:Ra.sl[6]=6143; /* line # 6143 */
        P_src_error_s(Rd.s+1043,102,2, Lx[3].s+48,NULL);
        Ra.sl[6]=6144; /* line # 6144 */
        Lx[3].ub[80]=8;
        break;
      }
      Ra.sl[6]=6146; /* line # 6146 */
      PAS__DISPOSE(&Rv4);
      Ra.sl[6]=6147; /* line # 6147 */
      ((UB *)Lx[3].v[3])[104]=9;
    }
    else {
      Ra.sl[6]=6151; /* line # 6151 */
      Lx[3].v[1]=PAS__NEW(32);
      Ra.sl[6]=6152; /* line # 6152 */
      Rv8=Lx[3].v[1];
      Ra.sl[6]=6154; /* line # 6154 */
      ((V *)Rv8)[0]=NULL;
      Ra.sl[6]=6155; /* line # 6155 */
      ((UB *)Rv8)[8]=0;
      Ra.sl[6]=6156; /* line # 6156 */
      ((V *)Rv8)[2]=Lx[3].v[3];
      Ra.sl[6]=6159; /* line # 6159 */
      if (V_pro_d_first==NULL) V_pro_d_first=Lx[3].v[3];
      else {
        Ra.sl[6]=6160; /* line # 6160 */
        ((V *)V_pro_d_last)[1]=Lx[3].v[3];
      }
      Ra.sl[6]=6161; /* line # 6161 */
      V_pro_d_last=Lx[3].v[3];
    }
  }
  else {
    Ra.sl[6]=6165; /* line # 6165 */
    Rv9=Lx[3].v[3];
    Ra.sl[6]=6167; /* line # 6167 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6168; /* line # 6168 */
      P_src_error(Rd.s+1043,21,2);
    }
    Ra.sl[6]=6169; /* line # 6169 */
    if (((UB *)Rv9)[104]==2) Lx[3].ub[80]=8;
    Ra.sl[6]=6170; /* line # 6170 */
    ((UB *)Rv9)[104]=9;
  }
  Ra.sl[6]=6174; /* line # 6174 */
  Rv10=Lx[3].v[3];
  Ra.sl[6]=6176; /* line # 6176 */
  if (V_sy_sym.ub[0]==79) {
    Ra.sl[6]=6178; /* line # 6178 */
    if (Lx[3].ub[16]||((UB *)Rv10)[104]!=9) P_src_error_s(Rd.s+1043,128,2, Lx[3]
    .s+48,NULL);
    else {
      Ra.sl[6]=6179; /* line # 6179 */
      ((UB *)Rv10)[104]=7;
    }
    Ra.sl[6]=6180; /* line # 6180 */
    P_insymbol();
    Ra.sl[6]=6181; /* line # 6181 */
    if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
    else {
      Ra.sl[6]=6183; /* line # 6183 */
      if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
        Ra.sl[6]=6185; /* line # 6185 */
        ((UB *)Rv10)[32]=Lx[3].ub[82];
        Ra.sl[6]=6186; /* line # 6186 */
        ((V *)Rv10)[3]=PAS__NEW(32);
        Ra.sl[6]=6187; /* line # 6187 */
        if (((UB *)Rv10)[32]==29) {
          Ra.sl[6]=6188; /* line # 6188 */
          memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
        }
        else {
          Ra.sl[6]=6190; /* line # 6190 */
          memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
      }
      else {
        Ra.sl[6]=6193; /* line # 6193 */
        ((V *)Rv10)[3]=P_new_int_name(Rd.s+1049,&V_proc_seq);
      }
    }
    Ra.sl[6]=6195; /* line # 6195 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6196; /* line # 6196 */
      P_src_error(Rd.s+1043,21,2);
    }
  }
  else {
    Ra.sl[6]=6199; /* line # 6199 */
    if (V_sy_sym.ub[0]==80||V_sy_sym.ub[0]==82&&V_sy_init_mod) {
      Ra.sl[6]=6201; /* line # 6201 */
      if (((UB *)Rv10)[104]!=9) {
        Ra.sl[6]=6203; /* line # 6203 */
        P_src_error_s(Rd.s+1043,108,2, Lx[3].s+48,NULL);
      }
      Ra.sl[6]=6204; /* line # 6204 */
      if (V_sy_sym.ub[0]==80) {
        Ra.sl[6]=6206; /* line # 6206 */
        ((UB *)Rv10)[104]=2;
        Ra.sl[6]=6207; /* line # 6207 */
        ((SL *)Rv10)[18]=1;
      }
      else {
        Ra.sl[6]=6212; /* line # 6212 */
        ((UB *)Rv10)[104]=1;
        Ra.sl[6]=6213; /* line # 6213 */
        ((SL *)Rv10)[18]=0;
      }
      Ra.sl[6]=6215; /* line # 6215 */
      P_insymbol();
      Ra.sl[6]=6217; /* line # 6217 */
      if (V_sy_sym.ub[0]==5) {
        Ra.sl[6]=6219; /* line # 6219 */
        P_set_stdname(Lx[3].v[3]);
      }
      else {
        Ra.sl[6]=6221; /* line # 6221 */
        if (Lx[3].ub[80]==((UB *)Rv10)[104]&&Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6222; /* line # 6222 */
          ((V *)Rv10)[3]=Lx[3].v[11];
        }
        else {
          Ra.sl[6]=6225; /* line # 6225 */
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6226; /* line # 6226 */
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6227; /* line # 6227 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else {
            Ra.sl[6]=6229; /* line # 6229 */
            P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
          }
        }
      }
      Ra.sl[6]=6232; /* line # 6232 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=6233; /* line # 6233 */
        P_src_error(Rd.s+1043,21,2);
      }
    }
    else {
      Ra.sl[6]=6237; /* line # 6237 */
      Lx[3].ub[0]=1;
      Ra.sl[6]=6239; /* line # 6239 */
      if (Lx[3].ub[80]!=9) {
        Ra.sl[6]=6241; /* line # 6241 */
        ((UB *)Rv10)[104]=Lx[3].ub[80];
        Ra.sl[6]=6242; /* line # 6242 */
        ((SL *)Rv10)[18]=1;
        Ra.sl[6]=6243; /* line # 6243 */
        if (Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6244; /* line # 6244 */
          if (Rv3) ((V *)Rv10)[3]=Lx[3].v[11];
          else {
            Ra.sl[6]=6247; /* line # 6247 */
            if (((V *)Rv10)[3]!=NULL) {
              Ra.sl[6]=6248; /* line # 6248 */
              if (P_match(((V *)Rv10)[3],Lx[3].v[11])!=0) {
                Ra.sl[6]=6249; /* line # 6249 */
                P_src_error(Rd.s+1043,129,1);
              }
            }
          }
        }
        else {
          Ra.sl[6]=6254; /* line # 6254 */
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6255; /* line # 6255 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else {
            Ra.sl[6]=6257; /* line # 6257 */
            P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
          }
        }
        Ra.sl[6]=6260; /* line # 6260 */
        switch (Lx[3].ub[80]) {
          case 2:Ra.sl[6]=6261; /* line # 6261 */
          Lx[3].ub[0]=0;
          break;
          case 8:Ra.sl[6]=6263; /* line # 6263 */
          if (Lx[3].sl[24]>1) {
            Ra.sl[6]=6264; /* line # 6264 */
            P_src_error(Rd.s+1043,404,2);
          }
          break;
          default:break;
        }
      }
      Ra.sl[6]=6269; /* line # 6269 */
      Rv11=0;
      Ra.sl[6]=6270; /* line # 6270 */
      Rv12=0;
      while (1){
        Ra.sl[6]=6272; /* line # 6272 */
        switch (V_sy_sym.ub[0]) {
          case 83:Ra.sl[6]=6275; /* line # 6275 */
          P_insymbol();
          ((UW *)Rv10)[8]=1;
          Ra.sl[6]=6276; /* line # 6276 */
          Rv12=1;
          break;
          case 5:
          case 81:Ra.sl[6]=6282; /* line # 6282 */
          if (V_sy_sym.ub[0]==81) {
            Ra.sl[6]=6283; /* line # 6283 */
            ((UB *)Rv10)[104]=8;
            P_insymbol();
          }
          Ra.sl[6]=6284; /* line # 6284 */
          if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
          else {
            Ra.sl[6]=6285; /* line # 6285 */
            P_src_error(Rd.s+1043,58,2);
          }
          Ra.sl[6]=6286; /* line # 6286 */
          Rv12=1;
          break;
          default:Ra.sl[6]=6290; /* line # 6290 */
          Rv11=1;
          Ra.sl[6]=6291; /* line # 6291 */
          if (Rv12) {
            Ra.sl[6]=6292; /* line # 6292 */
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else {
              Ra.sl[6]=6293; /* line # 6293 */
              P_src_error(Rd.s+1043,21,2);
            }
          }
          break;
        }
        if (Rv11)  break;
      }
      Ra.sl[6]=6297; /* line # 6297 */
      if (((V *)Rv10)[3]==NULL) {
        Ra.sl[6]=6299; /* line # 6299 */
        if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
          Ra.sl[6]=6301; /* line # 6301 */
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6302; /* line # 6302 */
          ((V *)Rv10)[3]=PAS__NEW(32);
          Ra.sl[6]=6303; /* line # 6303 */
          if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
          else {
            Ra.sl[6]=6304; /* line # 6304 */
            memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
          }
        }
        else {
          Ra.sl[6]=6307; /* line # 6307 */
          ((V *)Rv10)[3]=P_new_int_name(Rd.s+1055,&V_proc_seq);
        }
      }
    }
  }
  Ra.sl[6]=6310; /* line # 6310 */
  V_curr_lex=Lx[3].sl[24];
  Ra.sl[6]=6311; /* line # 6311 */
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6312; /* line # 6312 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_body "  */
void PAS_COMILER_PRC_00000052(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1059;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6326; /* line # 6326 */
  V_curr_disp=Lx[3].sl[8];
  Ra.sl[6]=6327; /* line # 6327 */
  V_curr_lex=Lx[3].sl[9];
  Ra.sl[6]=6328; /* line # 6328 */
  Rv0=Lx[3].v[3];
  Ra.sl[6]=6330; /* line # 6330 */
  if (V_cmp_traceopt>0) {
    Ra.sl[6]=6332; /* line # 6332 */
    if (V_cmp_trace>=0) Rv1=3;
    else {
      Ra.sl[6]=6334; /* line # 6334 */
      Rv1=5;
    }
    Ra.sl[6]=6335; /* line # 6335 */
    V_cmp_trace=V_cmp_traceopt;
    Ra.sl[6]=6336; /* line # 6336 */
    P_gen_cntxvar(Lx[3].v[3],Lx[3].v[14]);
  }
  else {
    Ra.sl[6]=6339; /* line # 6339 */
    if (V_cmp_trace>0) V_cmp_trace=0;
  }
  Ra.sl[6]=6341; /* line # 6341 */
  P_lgt_all_fparm(Lx[3].v[3]);
  Ra.sl[6]=6343; /* line # 6343 */
  P_cmp_block(Lx[3].v[3],1, Rv1);
  Ra.sl[6]=6345; /* line # 6345 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else {
    Ra.sl[6]=6346; /* line # 6346 */
    P_src_error(Rd.s+1072,54,3);
  }
  Ra.sl[6]=6347; /* line # 6347 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=6348; /* line # 6348 */
    if (Lx[3].ub[82]==29) {
      Ra.sl[6]=6350; /* line # 6350 */
      Ra.sl[6]=6351; /* line # 6351 */
      if (V_sy_sym.ub[0]==0&&P_match(Lx[3].s+48,V_sy_ident.s)==0) {
        Ra.sl[6]=6352; /* line # 6352 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=6353; /* line # 6353 */
        P_src_error_s(Rd.s+1072,71,2, V_sy_ident.s,NULL);
      }
    }
    else {
      Ra.sl[6]=6356; /* line # 6356 */
      if (V_sy_sym.ub[0]==22&&Lx[3].ub[82]==28||V_sy_sym.ub[1]==Lx[3].ub[82]) P_insymbol();
      else {
        Ra.sl[6]=6357; /* line # 6357 */
        P_src_error(Rd.s+1072,72,2);
      }
    }
  }
  Ra.sl[6]=6359; /* line # 6359 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1072,21,2);
  Ra.sl[6]=6360; /* line # 6360 */
  P_compile_set_sbttl(Lx[5].v[13]);
  Ra.sl[6]=6361; /* line # 6361 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  Ra.sl[6]=6364; /* line # 6364 */
  if (V_cmp_objf&&V_error_result<=1) {
    Ra.sl[6]=6367; /* line # 6367 */
    if (V_cmp_trace>0&&((V *)Rv0)[16]!=NULL) {
      Ra.sl[6]=6368; /* line # 6368 */
      P_gen_linetrace(Lx[3].v[3],((V *)Rv0)+16,((V *)Rv0)+17,4);
    }
    Ra.sl[6]=6370; /* line # 6370 */
    if (((V *)Rv0)[16]!=((V *)Rv0)[17]) {
      Ra.sl[6]=6372; /* line # 6372 */
      P_lgt_new(((V *)Rv0)+16,NULL,0,((V *)Rv0)[16]);
      Ra.sl[6]=6373; /* line # 6373 */
      ((UB *)((V *)Rv0)[16])[41]=2;
      Ra.sl[6]=6374; /* line # 6374 */
      ((V *)Rv0)[17]=((V *)Rv0)[16];
    }
    Ra.sl[6]=6377; /* line # 6377 */
    if (((UB *)Rv0)[104]==10) {
      Ra.sl[6]=6378; /* line # 6378 */
      ((UW *)Rv0)[8]=((UW *)Rv0)[8]|129;
    }
    else {
      Ra.sl[6]=6380; /* line # 6380 */
      ((UW *)Rv0)[8]=((UW *)Rv0)[8]|128;
    }
    Ra.sl[6]=6383; /* line # 6383 */
    if (V_pro_last==NULL) V_pro_first=Lx[3].v[3];
    else {
      Ra.sl[6]=6384; /* line # 6384 */
      ((V *)V_pro_last)[0]=Lx[3].v[3];
    }
    Ra.sl[6]=6385; /* line # 6385 */
    V_pro_last=Lx[3].v[3];
    Ra.sl[6]=6388; /* line # 6388 */
    PAS_COMILER_cmp_pass2(Lx[3].v[3]);
  }
  Ra.sl[6]=6393; /* line # 6393 */
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6394; /* line # 6394 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gene_decl "  */
void PAS_COMILER_PRC_00000050(){
  /* Define the automatic variable space. */
  Blk( Ra, 184 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  UB Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  UB Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+1076;
  Ra.v[17]=Rd.s+17;
  Ra.sl[36]=6401; /* line # 6401 */
  Ra.ub[16]=0;
  Ra.sl[36]=6402; /* line # 6402 */
  Ra.ub[42]=1;
  Ra.sl[36]=6403; /* line # 6403 */
  Ra.ub[40]=0;
  Ra.sl[36]=6404; /* line # 6404 */
  Ra.v[3]=NULL;
  Ra.sl[36]=6405; /* line # 6405 */
  Ra.ub[82]=29;
  Ra.sl[36]=6406; /* line # 6406 */
  Ra.ub[81]=0;
  Ra.sl[36]=6407; /* line # 6407 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[36]=6408; /* line # 6408 */
  Ra.sl[11]=0;
  Ra.sl[36]=6410; /* line # 6410 */
  Ra.v[13]=Lx[5].v[1];
  Ra.sl[36]=6411; /* line # 6411 */
  Ra.sl[24]=V_curr_lex;
  Ra.sl[36]=6412; /* line # 6412 */
  Ra.sl[25]=V_curr_disp;
  Ra.sl[36]=6414; /* line # 6414 */
  Ra.sl[36]=6416; /* line # 6416 */
  Ra.ub[80]=9;
  Ra.sl[36]=6417; /* line # 6417 */
  Ra.v[11]=NULL;
  Ra.sl[36]=6418; /* line # 6418 */
  if (Lx[5].ub[16]!=1) {
    Ra.sl[36]=6420; /* line # 6420 */
    switch (Lx[5].ub[16]) {
      case 3:
      case 4:Ra.sl[36]=6423; /* line # 6423 */
      if (Lx[5].ub[16]==3) Ra.ub[80]=8;
      else {
        Ra.sl[36]=6424; /* line # 6424 */
        Ra.ub[80]=2;
      }
      Ra.sl[36]=6425; /* line # 6425 */
      if (Lx[5].v[3]!=NULL) {
        Ra.sl[36]=6426; /* line # 6426 */
        Ra.v[11]=Lx[5].v[3];
        Lx[5].v[3]=NULL;
      }
      break;
      default:Ra.sl[36]=6429; /* line # 6429 */
      P_src_error(Rd.s+1072,81,2);
      break;
    }
    Ra.sl[36]=6431; /* line # 6431 */
    Lx[5].ub[16]=1;
    Ra.sl[36]=6432; /* line # 6432 */
    Lx[5].v[3]=NULL;
  }
  Ra.sl[36]=6435; /* line # 6435 */
  Ra.ub[41]=V_sy_sym.ub[0]==77;
  Ra.sl[36]=6436; /* line # 6436 */
  P_insymbol();
  Ra.sl[36]=6437; /* line # 6437 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[36]=6440; /* line # 6440 */
    memcpy(Ra.s+48,V_sy_ident.s,32);
    Ra.sl[36]=6441; /* line # 6441 */
    V_err_prt=0;
    Ra.sl[36]=6442; /* line # 6442 */
    Rv1=P_ide_search(770);
    Ra.sl[36]=6443; /* line # 6443 */
    V_err_prt=1;
    Ra.sl[36]=6444; /* line # 6444 */
    if (Rv1!=NULL) {
      Ra.sl[36]=6445; /* line # 6445 */
      if (((SL *)Rv1)[10]!=V_curr_lex) Rv0=NULL;
      else {
        Ra.sl[36]=6446; /* line # 6446 */
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[36]=6447; /* line # 6447 */
      Rv0=NULL;
    }
    Ra.sl[36]=6449; /* line # 6449 */
    if (Rv0!=NULL) {
      Ra.sl[36]=6450; /* line # 6450 */
      Rv2=Rv0;
      Ra.sl[36]=6452; /* line # 6452 */
      Ra.v[14]=((V *)Rv2)[0];
      Ra.sl[36]=6453; /* line # 6453 */
      switch (((UB *)Rv2)[56]) {
        case 1:
        case 8:
        case 9:Ra.sl[36]=6455; /* line # 6455 */
        if (((V *)Rv2)[9]!=NULL) {
          Ra.sl[36]=6457; /* line # 6457 */
          Ra.ub[16]=1;
          Ra.sl[36]=6458; /* line # 6458 */
          Ra.v[3]=((V *)Rv2)[9];
          Ra.sl[36]=6459; /* line # 6459 */
          Rv3=Ra.v[3];
          Ra.sl[36]=6460; /* line # 6460 */
          if (((UB *)Rv3)[104]==7||((UB *)Rv3)[104]==2) {
            Ra.sl[36]=6461; /* line # 6461 */
            Ra.ub[42]=0;
          }
        }
        break;
        default:Ra.sl[36]=6466; /* line # 6466 */
        P_src_error_s(Rd.s+1072,101,3,((V *)Rv2)[0],NULL);
        break;
      }
      Ra.sl[36]=6469; /* line # 6469 */
      PAS_COMILER_PRC_00000051(((V *)Rv2)[10],((V *)Rv2)[11]);
      Ra.sl[36]=6471; /* line # 6471 */
      PAS_COMILER_PRC_00000049(((V *)Rv2)+10,((V *)Rv2)+11,Ra.v[1],((UB *)Rv2)[56]
      ==8);
    }
    else {
      Ra.sl[36]=6495; /* line # 6495 */
      Ra.ub[42]=0;
      Ra.sl[36]=6496; /* line # 6496 */
      Ra.v[14]=PAS__NEW(32);
      Ra.sl[36]=6497; /* line # 6497 */
      Ra.sl[36]=6499; /* line # 6499 */
      ((UB *)Ra.v[14])[0]=V_sy_ident.ub[0];
      Ra.sl[36]=6500; /* line # 6500 */
      Rv4=1;
      for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
        ((C *)Ra.v[14])[Rv4]=V_sy_ident.c[Rv4];
        Rv4++;
      }
      Ra.sl[36]=6503; /* line # 6503 */
      Ra.ub[81]=Rv1==NULL;
      Ra.sl[36]=6504; /* line # 6504 */
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6505; /* line # 6505 */
      memcpy(Ra.s+148,V_sy_ident.s,32);
      Ra.sl[36]=6506; /* line # 6506 */
      memcpy(V_sy_ident.s,Ra.s+48,32);
      Ra.sl[36]=6507; /* line # 6507 */
      if (Ra.ub[40]) {
        Ra.sl[36]=6509; /* line # 6509 */
        P_ide_new(8,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6510; /* line # 6510 */
        Rv5=Rv0;
        Ra.sl[36]=6512; /* line # 6512 */
        ((V *)Rv5)[10]=Ra.v[1];
        Ra.sl[36]=6513; /* line # 6513 */
        ((V *)Rv5)[11]=NULL;
        Ra.sl[36]=6515; /* line # 6515 */
        if (((UB *)Ra.v[3])[104]==7||((UB *)Ra.v[3])[104]==2) {
          Ra.sl[36]=6516; /* line # 6516 */
          ((V *)Rv5)[9]=Ra.v[3];
        }
        else {
          Ra.sl[36]=6517; /* line # 6517 */
          ((V *)Rv5)[9]=NULL;
        }
      }
      else {
        Ra.sl[36]=6523; /* line # 6523 */
        if (Rv1!=NULL) {
          Ra.sl[36]=6525; /* line # 6525 */
          Rv6=((UB *)Rv1)[56];
          Ra.sl[36]=6526; /* line # 6526 */
          ((V *)Ra.v[1])[0]=((V *)Rv1)[10];
        }
        else {
          Ra.sl[36]=6530; /* line # 6530 */
          Rv6=9;
          Ra.sl[36]=6531; /* line # 6531 */
          ((V *)Ra.v[1])[0]=NULL;
        }
        Ra.sl[36]=6534; /* line # 6534 */
        P_ide_new(Rv6,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6538; /* line # 6538 */
        Rv7=Rv0;
        Ra.sl[36]=6540; /* line # 6540 */
        ((V *)Rv7)[10]=Ra.v[1];
        ((V *)Rv7)[11]=Ra.v[1];
        Ra.sl[36]=6542; /* line # 6542 */
        if (((UB *)Ra.v[3])[104]==7) ((V *)Rv7)[9]=Ra.v[3];
        else {
          Ra.sl[36]=6543; /* line # 6543 */
          ((V *)Rv7)[9]=NULL;
        }
      }
      Ra.sl[36]=6547; /* line # 6547 */
      memcpy(V_sy_ident.s,Ra.s+148,32);
    }
    Ra.sl[36]=6550; /* line # 6550 */
    if (V_sy_init_mod) {
      Ra.sl[36]=6552; /* line # 6552 */
      Rv8=1;
      Ra.sl[36]=6553; /* line # 6553 */
      switch (V_sy_sym.ub[0]) {
        case 58:Ra.sl[36]=6554; /* line # 6554 */
        V_new_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 59:Ra.sl[36]=6555; /* line # 6555 */
        V_newh_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 60:Ra.sl[36]=6556; /* line # 6556 */
        V_dispose_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 42:Ra.sl[36]=6557; /* line # 6557 */
        V_set_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 61:Ra.sl[36]=6559; /* line # 6559 */
        V_iof_std_open=Rv0;
        break;
        case 39:Ra.sl[36]=6560; /* line # 6560 */
        V_iof_std_close=Rv0;
        break;
        case 62:Ra.sl[36]=6561; /* line # 6561 */
        V_inp_std_sel=Rv0;
        break;
        case 65:Ra.sl[36]=6562; /* line # 6562 */
        V_inp_std_gene=Rv0;
        break;
        case 66:Ra.sl[36]=6563; /* line # 6563 */
        V_inp_std_eoln=Rv0;
        break;
        case 35:Ra.sl[36]=6564; /* line # 6564 */
        V_inp_std_bin=Rv0;
        break;
        case 63:Ra.sl[36]=6565; /* line # 6565 */
        V_out_std_sel=Rv0;
        break;
        case 68:Ra.sl[36]=6566; /* line # 6566 */
        V_out_std_gene=Rv0;
        break;
        case 69:Ra.sl[36]=6567; /* line # 6567 */
        V_out_std_eoln=Rv0;
        break;
        case 36:Ra.sl[36]=6568; /* line # 6568 */
        V_out_std_bin=Rv0;
        break;
        case 41:Ra.sl[36]=6570; /* line # 6570 */
        V_gen_std_string1=Rv0;
        break;
        case 40:Ra.sl[36]=6571; /* line # 6571 */
        V_gen_std_cnfardsc=Rv0;
        break;
        default:Ra.sl[36]=6574; /* line # 6574 */
        Rv8=0;
        break;
      }
      Ra.sl[36]=6576; /* line # 6576 */
      if (Rv8) {
        Ra.sl[36]=6578; /* line # 6578 */
        P_insymbol();
        Ra.sl[36]=6579; /* line # 6579 */
        if (V_sy_sym.ub[0]==18) P_insymbol();
        else {
          Ra.sl[36]=6580; /* line # 6580 */
          P_src_error(Rd.s+1072,21,2);
        }
      }
    }
    Ra.sl[36]=6584; /* line # 6584 */
    if (Ra.v[3]!=NULL) ((V *)Ra.v[3])[5]=Rv0;
    break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 22:Ra.sl[36]=6597; /* line # 6597 */
    if (V_sy_sym.ub[0]==6) Ra.sl[11]=1;
    else {
      Ra.sl[36]=6598; /* line # 6598 */
      Ra.sl[11]=2;
    }
    Ra.sl[36]=6599; /* line # 6599 */
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[36]=6601; /* line # 6601 */
      if (Ra.ub[41]) P_src_error(Rd.s+1072,115,3);
      Ra.sl[36]=6602; /* line # 6602 */
      Ra.ub[82]=28;
    }
    else {
      Ra.sl[36]=6605; /* line # 6605 */
      Ra.ub[82]=V_sy_sym.ub[1];
      Ra.sl[36]=6606; /* line # 6606 */
      if (!Ra.ub[41]) P_src_error(Rd.s+1072,116,3);
    }
    Ra.sl[36]=6608; /* line # 6608 */
    if (Ra.ub[82]==12) Ra.sl[11]=-1;
    Ra.sl[36]=6610; /* line # 6610 */
    memcpy(Ra.s+48,(V_opname.s+Ra.ub[82]*32),32);
    Ra.sl[36]=6612; /* line # 6612 */
    Ra.v[14]=PAS__NEW(32);
    Ra.sl[36]=6613; /* line # 6613 */
    Rv9=(V_opname.s+Ra.ub[82]*32);
    Ra.sl[36]=6615; /* line # 6615 */
    ((UB *)Ra.v[14])[0]=((UB *)Rv9)[0]+2;
    Ra.sl[36]=6616; /* line # 6616 */
    ((C *)Ra.v[14])[1]=79;
    Ra.sl[36]=6617; /* line # 6617 */
    ((C *)Ra.v[14])[2]=95;
    Ra.sl[36]=6618; /* line # 6618 */
    Rv10=1;
    for( Rf0=((UB *)Rv9)[0];Rf0>0;Rf0-- ) {
      ((C *)Ra.v[14])[(2+Rv10)]=((C *)Rv9)[Rv10];
      Rv10++;
    }
    Ra.sl[36]=6621; /* line # 6621 */
    Rv11=V_ope_table.v[Ra.ub[82]];
    Ra.sl[36]=6622; /* line # 6622 */
    if (Rv11!=NULL) Rv12=((SL *)Rv11)[1]==V_curr_lex;
    else {
      Ra.sl[36]=6623; /* line # 6623 */
      Rv12=0;
    }
    Ra.sl[36]=6624; /* line # 6624 */
    if (Rv12) {
      Ra.sl[36]=6625; /* line # 6625 */
      Rv13=Rv11;
      Ra.sl[36]=6627; /* line # 6627 */
      Ra.v[3]=NULL;
      Ra.sl[36]=6628; /* line # 6628 */
      PAS_COMILER_PRC_00000051(((V *)Rv13)[3],((V *)Rv13)[4]);
      Ra.sl[36]=6629; /* line # 6629 */
      PAS_COMILER_PRC_00000049(((V *)Rv13)+3,((V *)Rv13)+4,Ra.v[1],0);
    }
    else {
      Ra.sl[36]=6641; /* line # 6641 */
      Ra.v[3]=NULL;
      Ra.sl[36]=6642; /* line # 6642 */
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6643; /* line # 6643 */
      if (Ra.v[1]!=NULL) {
        Ra.sl[36]=6645; /* line # 6645 */
        Rv14=PAS__NEW(40);
        Ra.sl[36]=6646; /* line # 6646 */
        Rv15=Rv14;
        Ra.sl[36]=6648; /* line # 6648 */
        ((UB *)Rv15)[0]=Ra.ub[82];
        Ra.sl[36]=6649; /* line # 6649 */
        ((SL *)Rv15)[1]=V_curr_lex;
        Ra.sl[36]=6650; /* line # 6650 */
        ((V *)Rv15)[1]=((V *)Lx[5].v[13])[19];
        Ra.sl[36]=6651; /* line # 6651 */
        ((V *)Rv15)[2]=Rv11;
        Ra.sl[36]=6652; /* line # 6652 */
        ((V *)Rv15)[3]=Ra.v[1];
        Ra.sl[36]=6653; /* line # 6653 */
        ((V *)Rv15)[4]=Ra.v[1];
        Ra.sl[36]=6654; /* line # 6654 */
        if (Rv11==NULL) {
          Ra.sl[36]=6655; /* line # 6655 */
          ((V *)Ra.v[1])[0]=NULL;
        }
        else {
          Ra.sl[36]=6657; /* line # 6657 */
          ((V *)Ra.v[1])[0]=((V *)Rv11)[3];
        }
      }
      Ra.sl[36]=6660; /* line # 6660 */
      ((V *)Lx[5].v[13])[19]=Rv14;
      Ra.sl[36]=6661; /* line # 6661 */
      V_ope_table.v[Ra.ub[82]]=Rv14;
    }
    Ra.sl[36]=6664; /* line # 6664 */
    if (Ra.v[3]!=NULL) ((UB *)Ra.v[3])[32]=Ra.ub[82];
    break;
    default:Ra.sl[36]=6674; /* line # 6674 */
    P_src_error(Rd.s+1072,117,3);
    break;
  }
  Ra.sl[36]=6677; /* line # 6677 */
  if (Ra.ub[0]) PAS_COMILER_PRC_00000052();
  PAS__curr_cntx=Ra.v[15];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " gen_assign "  */
V PAS_COMILER_PRC_00000053(V F_target, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1087;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6704; /* line # 6704 */
  Rv0=V_sy_label_flag;
  Ra.sl[6]=6705; /* line # 6705 */
  V_sy_label_flag=0;
  Ra.sl[6]=6708; /* line # 6708 */
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6710; /* line # 6710 */
  V_sy_label_flag=Rv0;
  Ra.sl[6]=6712; /* line # 6712 */
  ((V *)F_target)[0]=Rv1;
  Ra.sl[6]=6713; /* line # 6713 */
  if (((UB *)F_target)[40]==8) {
    Ra.sl[6]=6714; /* line # 6714 */
    Rv2=((V *)F_target)[6];
    Ra.sl[6]=6716; /* line # 6716 */
    Rv3=1;
    Ra.sl[6]=6717; /* line # 6717 */
    if (((V *)Rv2)[11]!=NULL) {
      Ra.sl[6]=6718; /* line # 6718 */
      if (((UB *)((V *)Rv2)[11])[92]==24) Rv3=0;
    }
    Ra.sl[6]=6719; /* line # 6719 */
    if (Rv3) P_src_error(Rd.s+1101,175,3);
  }
  Ra.sl[6]=6721; /* line # 6721 */
  Rv4=P_lgt_gen_store(F_target,0, F_bovr);
  Ra.sl[6]=6722; /* line # 6722 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " returnstate "  */
V PAS_COMILER_PRC_00000054(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1105;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6740; /* line # 6740 */
  Rv0=NULL;
  Ra.sl[6]=6741; /* line # 6741 */
  Rv1=PAS_COMILER_PRC_00000023();
  Ra.sl[6]=6743; /* line # 6743 */
  if (Rv1!=NULL) {
    Ra.sl[6]=6744; /* line # 6744 */
    Rv2=Rv1;
    Ra.sl[6]=6746; /* line # 6746 */
    if (((V *)Rv2)[11]==NULL) {
      Ra.sl[6]=6747; /* line # 6747 */
      if (F_ip!=NULL) {
        Ra.sl[6]=6750; /* line # 6750 */
        P_src_error_s(Rd.s+1120,172,3,((V *)F_ip)[0],NULL);
        Ra.sl[6]=6751; /* line # 6751 */
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[6]=6755; /* line # 6755 */
        P_lgt_new(&Rv0,NULL,0,NULL);
        Ra.sl[6]=6756; /* line # 6756 */
        ((UB *)Rv0)[41]=7;
      }
    }
    else {
      Ra.sl[6]=6760; /* line # 6760 */
      Rv3=NULL;
      Ra.sl[6]=6761; /* line # 6761 */
      Lx[5].ub[40]=1;
      Ra.sl[6]=6762; /* line # 6762 */
      if (F_ip!=NULL) {
        Ra.sl[6]=6764; /* line # 6764 */
        if (F_ip!=((V *)Rv2)[5]) {
          Ra.sl[6]=6766; /* line # 6766 */
          P_src_error_s(Rd.s+1120,405,3,((V *)F_ip)[0],NULL);
          Ra.sl[6]=6767; /* line # 6767 */
          P_skip_symbol(18,0,0);
        }
      }
      Ra.sl[6]=6771; /* line # 6771 */
      if (((UB *)((V *)Rv2)[11])[91]) {
        Ra.sl[6]=6773; /* line # 6773 */
        P_lgt_new(&Rv3,((V *)Rv2)[11],12,NULL);
        Ra.sl[6]=6774; /* line # 6774 */
        ((V *)Rv3)[6]=Rv1;
        Ra.sl[6]=6775; /* line # 6775 */
        if (F_ip!=NULL) {
          Ra.sl[6]=6776; /* line # 6776 */
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6777; /* line # 6777 */
            P_src_error(Rd.s+1120,32,2);
          }
        }
      }
      else {
        Ra.sl[6]=6781; /* line # 6781 */
        if (F_ip==NULL||V_sy_sym.ub[0]==22) {
          Ra.sl[6]=6783; /* line # 6783 */
          Rv3=P_lgt_new_idref(((V *)Rv2)[8],NULL);
          Ra.sl[6]=6784; /* line # 6784 */
          Rv4=((V *)Rv2)[8];
          Ra.sl[6]=6785; /* line # 6785 */
          if ((((UB *)((V *)Rv4)[4])[89]||((UB *)((V *)Rv4)[4])[90])&&!(16&((UW *)
          Rv4)[46])) {
            Ra.sl[6]=6787; /* line # 6787 */
            P_init_d_varbl(((V *)Rv2)[8]);
          }
          Ra.sl[6]=6788; /* line # 6788 */
          if (F_ip!=NULL) P_insymbol();
        }
        else {
          Ra.sl[6]=6792; /* line # 6792 */
          V_sy_search=((V *)Rv2)[8];
          Ra.sl[6]=6793; /* line # 6793 */
          V_lastsymb=V_sy_sym.ub[0];
          Ra.sl[6]=6794; /* line # 6794 */
          V_sy_sym.ub[0]=0;
          Ra.sl[6]=6795; /* line # 6795 */
          Rv3=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=6796; /* line # 6796 */
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6797; /* line # 6797 */
            P_src_error(Rd.s+1120,32,2);
          }
        }
      }
      Ra.sl[6]=6802; /* line # 6802 */
      Rv0=PAS_COMILER_PRC_00000053(Rv3,1);
      Ra.sl[6]=6804; /* line # 6804 */
      if (F_ip==NULL) {
        Ra.sl[6]=6806; /* line # 6806 */
        P_lgt_new(&Rv0,NULL,0, Rv0);
        Ra.sl[6]=6807; /* line # 6807 */
        ((UB *)Rv0)[41]=7;
      }
    }
  }
  Ra.sl[6]=6811; /* line # 6811 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " assignmentstate "  */
V PAS_COMILER_PRC_00000055(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1124;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6824; /* line # 6824 */
  V_sy_search=F_ip;
  Ra.sl[6]=6826; /* line # 6826 */
  V_lastsymb=V_sy_sym.ub[0];
  Ra.sl[6]=6827; /* line # 6827 */
  V_sy_sym.ub[0]=0;
  Ra.sl[6]=6828; /* line # 6828 */
  Rv0=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6829; /* line # 6829 */
  Rv1=Rv0;
  Ra.sl[6]=6830; /* line # 6830 */
  switch (((UB *)Rv1)[40]) {
    case 1:
    case 2:
    case 3:
    case 7:
    case 8:
    case 13:Ra.sl[6]=6841; /* line # 6841 */
    if (((V *)Rv1)[3]==V_typ_std.v[28]&&((UB *)Rv1)[40]==7) {
      Ra.sl[6]=6842; /* line # 6842 */
      Rv2=Rv0;
    }
    else {
      Ra.sl[6]=6845; /* line # 6845 */
      if (!(2&((UW *)Rv1)[10])) {
        Ra.sl[6]=6847; /* line # 6847 */
        P_src_error(Rd.s+1143,173,2);
      }
      Ra.sl[6]=6849; /* line # 6849 */
      if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1143,32,2);
      else {
        Ra.sl[6]=6850; /* line # 6850 */
        P_insymbol();
      }
      Ra.sl[6]=6851; /* line # 6851 */
      Rv2=PAS_COMILER_PRC_00000053(Rv0,0);
    }
    break;
    default:Ra.sl[6]=6856; /* line # 6856 */
    P_src_error(Rd.s+1143,174,3);
    Ra.sl[6]=6857; /* line # 6857 */
    P_skip_symbol(18,0,0);
    Ra.sl[6]=6858; /* line # 6858 */
    P_lgt_free_tree(&Rv0);
    Ra.sl[6]=6859; /* line # 6859 */
    Rv2=NULL;
    break;
  }
  Ra.sl[6]=6861; /* line # 6861 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " with_state "  */
V PAS_COMILER_PRC_00000056(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1147;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6879; /* line # 6879 */
  Rv0=0;
  Ra.sl[6]=6880; /* line # 6880 */
  Rv1=NULL;
  Ra.sl[6]=6881; /* line # 6881 */
  Rv2=1;
  Ra.sl[6]=6882; /* line # 6882 */
  while (1){
    Ra.sl[6]=6884; /* line # 6884 */
    Rv3=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=6885; /* line # 6885 */
    Rv4=0;
    Ra.sl[6]=6886; /* line # 6886 */
    Rv5=0;
    Ra.sl[6]=6887; /* line # 6887 */
    Rv6=NULL;
    Ra.sl[6]=6888; /* line # 6888 */
    Rv7=((V *)Rv3)[3];
    Ra.sl[6]=6890; /* line # 6890 */
    Rv8=Rv7;
    Rv9=Rv3;
    Ra.sl[6]=6891; /* line # 6891 */
    if (((((UB *)Rv8)[92]==5||((UB *)Rv8)[92]==7)||((UB *)Rv8)[92]==24)&&((V *)Rv8)
    [12]!=NULL) {
      Ra.sl[6]=6897; /* line # 6897 */
      Rv10=1;
      Ra.sl[6]=6898; /* line # 6898 */
      Rv4=1;
      Ra.sl[6]=6899; /* line # 6899 */
      Rv6=Rv7;
      Ra.sl[6]=6900; /* line # 6900 */
      Rv7=((V *)Rv6)[12];
    }
    else {
      Ra.sl[6]=6904; /* line # 6904 */
      Rv10=((UB *)Rv9)[40]!=14&&((UB *)Rv9)[40]!=13;
    }
    Ra.sl[6]=6906; /* line # 6906 */
    if (((UB *)Rv7)[92]!=10) Rv7=NULL;
    Ra.sl[6]=6908; /* line # 6908 */
    Rv2=Rv7==NULL;
    Ra.sl[6]=6910; /* line # 6910 */
    if (Rv2) {
      Ra.sl[6]=6912; /* line # 6912 */
      P_src_error(Rd.s+1161,176,3);
      Ra.sl[6]=6913; /* line # 6913 */
      P_skip_symbol(72,0,0);
    }
    else {
      Ra.sl[6]=6916; /* line # 6916 */
      if (Rv10) {
        Ra.sl[6]=6918; /* line # 6918 */
        if (!Rv4) {
          Ra.sl[6]=6919; /* line # 6919 */
          if (((UB *)Rv3)[40]==2&&((SL *)Rv3)[4]==0) {
            Ra.sl[6]=6921; /* line # 6921 */
            Rv11=((V *)Rv3)[1];
            Ra.sl[6]=6922; /* line # 6922 */
            P_lgt_free(&Rv3);
            Ra.sl[6]=6923; /* line # 6923 */
            Rv6=((V *)Rv11)[3];
            Ra.sl[6]=6924; /* line # 6924 */
            Rv3=Rv11;
          }
          else {
            Ra.sl[6]=6928; /* line # 6928 */
            if (Rv6==NULL) {
              Ra.sl[6]=6929; /* line # 6929 */
              P_ide_new_typ(5, &Rv6);
            }
            Ra.sl[6]=6930; /* line # 6930 */
            Rv12=Rv6;
            Ra.sl[6]=6932; /* line # 6932 */
            memcpy(Rv12+48,V_typ_std.v[13]+48,1);
            Ra.sl[6]=6933; /* line # 6933 */
            ((SL *)Rv12)[11]=V_fptr_size;
            Ra.sl[6]=6934; /* line # 6934 */
            ((V *)Rv12)[12]=Rv7;
            Ra.sl[6]=6936; /* line # 6936 */
            P_lgt_new(&Rv3, Rv6,4, Rv3);
          }
        }
        Ra.sl[6]=6941; /* line # 6941 */
        Ra.sl[6]=6943; /* line # 6943 */
        Rv5=1;
        Ra.sl[6]=6944; /* line # 6944 */
        P_lgt_new(&Rv11, Rv6,13,NULL);
        Ra.sl[6]=6945; /* line # 6945 */
        P_all_new(((V *)Rv11)+7,Rv6,NULL,0);
        Ra.sl[6]=6946; /* line # 6946 */
        ((V *)Rv11)[0]=Rv3;
        Ra.sl[6]=6947; /* line # 6947 */
        Rv3=P_lgt_new_code(3, Rv11);
        Ra.sl[6]=6948; /* line # 6948 */
        ((SL *)Rv3)[4]=0;
        Ra.sl[6]=6949; /* line # 6949 */
        ((V *)Rv3)[0]=Rv1;
        Ra.sl[6]=6950; /* line # 6950 */
        Rv1=Rv3;
      }
      else {
        Ra.sl[6]=6954; /* line # 6954 */
        Rv11=Rv3;
      }
    }
    Ra.sl[6]=6959; /* line # 6959 */
    if (V_curr_disp<64) {
      Ra.sl[6]=6961; /* line # 6961 */
      Rv0=Rv0+1;
      Ra.sl[6]=6962; /* line # 6962 */
      P_new_disp_level(NULL,1);
      Ra.sl[6]=6963; /* line # 6963 */
      Rv13=(V_lex_ident_tree.s+V_curr_disp*64);
      Ra.sl[6]=6965; /* line # 6965 */
      ((V *)Rv13)[2]=Rv11;
      Ra.sl[6]=6966; /* line # 6966 */
      Rv14=Rv7;
      Ra.sl[6]=6967; /* line # 6967 */
      if (((V *)Rv14)[4]!=NULL) {
        Ra.sl[6]=6969; /* line # 6969 */
        Rv15=((V *)Rv14)[4];
        Ra.sl[6]=6970; /* line # 6970 */
        while (Rv15!=NULL){
          Ra.sl[6]=6972; /* line # 6972 */
          ((UB *)Rv15)[64]=3;
          Ra.sl[6]=6973; /* line # 6973 */
          Rv15=((V *)Rv15)[3];
        }
        Ra.sl[6]=6975; /* line # 6975 */
        ((V *)Rv13)[1]=((V *)Rv14)[4];
      }
      else {
        Ra.sl[6]=6978; /* line # 6978 */
        ((V *)Rv13)[1]=((V *)Rv14)[12];
      }
      Ra.sl[6]=6980; /* line # 6980 */
      ((SL *)Rv13)[13]=0;
      Ra.sl[6]=6981; /* line # 6981 */
      if (Rv10) {
        Ra.sl[6]=6982; /* line # 6982 */
        if (Rv5) ((UB *)Rv13)[24]=2;
        else {
          Ra.sl[6]=6983; /* line # 6983 */
          ((UB *)Rv13)[24]=3;
        }
      }
      else {
        Ra.sl[6]=6984; /* line # 6984 */
        ((UB *)Rv13)[24]=1;
      }
      Ra.sl[6]=6985; /* line # 6985 */
      if (((V *)Rv7)[4]!=NULL&&((UB *)Rv7)[92]==10) {
        Ra.sl[6]=6988; /* line # 6988 */
        Rv0=Rv0+1;
        Ra.sl[6]=6989; /* line # 6989 */
        P_new_disp_level(NULL,1);
        Ra.sl[6]=6990; /* line # 6990 */
        memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
        Ra.sl[6]=6991; /* line # 6991 */
        Rv16=(V_lex_ident_tree.s+V_curr_disp*64);
        Ra.sl[6]=6993; /* line # 6993 */
        ((V *)Rv16)[1]=((V *)Rv7)[12];
        Ra.sl[6]=6994; /* line # 6994 */
        ((SL *)Rv16)[13]=-1;
      }
    }
    else {
      Ra.sl[6]=7000; /* line # 7000 */
      P_src_error(Rd.s+1161,1003,4);
    }
    Ra.sl[6]=7001; /* line # 7001 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    if (V_sy_sym.ub[0]!=0)  break;
  }
  Ra.sl[6]=7003; /* line # 7003 */
  Ra.sl[6]=7005; /* line # 7005 */
  if (V_sy_sym.ub[0]==53) P_insymbol();
  else P_src_error(Rd.s+1161,55,2);
  Ra.sl[6]=7008; /* line # 7008 */
  Rv17=V_cntx_label;
  Ra.sl[6]=7009; /* line # 7009 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7010; /* line # 7010 */
  Rv18=PAS_COMILER_PRC_00000036(NULL,1);
  Ra.sl[6]=7012; /* line # 7012 */
  if (Rv18!=NULL) {
    Ra.sl[6]=7013; /* line # 7013 */
    Rv19=Rv18;
    Ra.sl[6]=7014; /* line # 7014 */
    if (((UB *)Rv19)[40]==0) {
      Ra.sl[6]=7015; /* line # 7015 */
      switch (((UB *)Rv19)[41]) {
        case 0:
        case 2:Ra.sl[6]=7017; /* line # 7017 */
        Rv20=1;
        break;
        default:Ra.sl[6]=7020; /* line # 7020 */
        Rv20=0;
        break;
      }
    }
    else {
      Ra.sl[6]=7023; /* line # 7023 */
      Rv20=0;
    }
  }
  else {
    Ra.sl[6]=7024; /* line # 7024 */
    P_lgt_new(&Rv18,NULL,16,NULL);
  }
  Ra.sl[6]=7026; /* line # 7026 */
  P_label_purge(&Rv17);
  Ra.sl[6]=7029; /* line # 7029 */
  while (Rv0>0){
    Ra.sl[6]=7031; /* line # 7031 */
    Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=7033; /* line # 7033 */
    if (((SL *)Rv21)[13]>=0) {
      Ra.sl[6]=7034; /* line # 7034 */
      if (((SL *)Rv21)[13]==0) {
        Ra.sl[6]=7036; /* line # 7036 */
        switch (((UB *)Rv21)[24]) {
          case 1:
          case 3:Ra.sl[6]=7039; /* line # 7039 */
          P_lgt_free_tree(((V *)Rv21)+2);
          break;
          case 2:Ra.sl[6]=7043; /* line # 7043 */
          Rv3=Rv1;
          Ra.sl[6]=7044; /* line # 7044 */
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=7045; /* line # 7045 */
          ((V *)Rv3)[0]=NULL;
          Ra.sl[6]=7046; /* line # 7046 */
          P_all_free(((V *)((V *)Rv21)[2])[7]);
          Ra.sl[6]=7047; /* line # 7047 */
          ((V *)Rv21)[2]=NULL;
          Ra.sl[6]=7048; /* line # 7048 */
          P_lgt_free_tree(&Rv3);
          break;
          default:break;
        }
      }
      else {
        Ra.sl[6]=7054; /* line # 7054 */
        if (((UB *)Rv21)[24]==2) {
          Ra.sl[6]=7056; /* line # 7056 */
          Rv3=Rv1;
          Ra.sl[6]=7057; /* line # 7057 */
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=7059; /* line # 7059 */
          if (Rv20) {
            Ra.sl[6]=7061; /* line # 7061 */
            ((V *)Rv3)[0]=((V *)Rv18)[1];
            Ra.sl[6]=7062; /* line # 7062 */
            ((V *)Rv18)[1]=Rv3;
          }
          else {
            Ra.sl[6]=7066; /* line # 7066 */
            Rv20=1;
            Ra.sl[6]=7067; /* line # 7067 */
            ((V *)Rv3)[0]=Rv18;
            Ra.sl[6]=7068; /* line # 7068 */
            P_lgt_new(&Rv18,NULL,0, Rv3);
            Ra.sl[6]=7069; /* line # 7069 */
            ((UB *)Rv18)[41]=2;
          }
        }
      }
    }
    Ra.sl[6]=7073; /* line # 7073 */
    Rv15=((V *)Rv21)[1];
    Ra.sl[6]=7074; /* line # 7074 */
    if (((UB *)Rv15)[56]==2) {
      Ra.sl[6]=7076; /* line # 7076 */
      while (Rv15!=NULL){
        Ra.sl[6]=7078; /* line # 7078 */
        ((UB *)Rv15)[64]=0;
        Ra.sl[6]=7079; /* line # 7079 */
        ((V *)Rv15)[10]=NULL;
        Ra.sl[6]=7080; /* line # 7080 */
        Rv15=((V *)Rv15)[3];
      }
    }
    Ra.sl[6]=7083; /* line # 7083 */
    V_curr_disp=V_curr_disp -1;
    Ra.sl[6]=7084; /* line # 7084 */
    Rv0=Rv0-1;
  }
  Ra.sl[6]=7087; /* line # 7087 */
  Ret=Rv18;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ifstate "  */
V PAS_COMILER_PRC_00000057(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1165;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7101; /* line # 7101 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,1,0);
  Ra.sl[6]=7102; /* line # 7102 */
  Rv1=NULL;
  Ra.sl[6]=7103; /* line # 7103 */
  Rv2=NULL;
  Ra.sl[6]=7104; /* line # 7104 */
  Rv3=V_cntx_label;
  Ra.sl[6]=7105; /* line # 7105 */
  Rv4=Rv0;
  Ra.sl[6]=7107; /* line # 7107 */
  if (V_sy_sym.ub[0]==45) P_insymbol();
  else P_src_error(Rd.s+1176,56,2);
  Ra.sl[6]=7109; /* line # 7109 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7110; /* line # 7110 */
  Rv1=PAS_COMILER_PRC_00000036(NULL,1);
  Ra.sl[6]=7111; /* line # 7111 */
  P_label_purge(&Rv3);
  Ra.sl[6]=7112; /* line # 7112 */
  if (V_sy_sym.ub[0]!=18) {
    Ra.sl[6]=7113; /* line # 7113 */
    if (V_sy_sym.ub[0]==46) {
      Ra.sl[6]=7115; /* line # 7115 */
      P_insymbol();
      Ra.sl[6]=7116; /* line # 7116 */
      V_cntx_lblvl=V_cntx_lblvl+1;
      Ra.sl[6]=7117; /* line # 7117 */
      Rv2=PAS_COMILER_PRC_00000036(NULL,1);
      Ra.sl[6]=7118; /* line # 7118 */
      P_label_purge(&Rv3);
    }
  }
  Ra.sl[6]=7121; /* line # 7121 */
  if (Rv1==NULL&&Rv2==NULL) {
    Ra.sl[6]=7123; /* line # 7123 */
    P_lgt_free(&Rv0);
    Ra.sl[6]=7124; /* line # 7124 */
    Rv5=NULL;
  }
  else {
    Ra.sl[6]=7127; /* line # 7127 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=7129; /* line # 7129 */
      if (((SL *)((V *)Rv4)[7])[13]>0) {
        Ra.sl[6]=7131; /* line # 7131 */
        Rv5=Rv1;
        Ra.sl[6]=7132; /* line # 7132 */
        P_lgt_free_tree(&Rv2);
      }
      else {
        Ra.sl[6]=7136; /* line # 7136 */
        Rv5=Rv2;
        Ra.sl[6]=7137; /* line # 7137 */
        P_lgt_free_tree(&Rv1);
      }
      Ra.sl[6]=7139; /* line # 7139 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=7144; /* line # 7144 */
      if (Rv1==NULL) {
        Ra.sl[6]=7146; /* line # 7146 */
        Rv0=P_exp_genop(0, Rv0);
        Ra.sl[6]=7147; /* line # 7147 */
        ((V *)Rv0)[0]=Rv2;
      }
      else {
        Ra.sl[6]=7151; /* line # 7151 */
        ((V *)Rv0)[0]=Rv1;
        Ra.sl[6]=7152; /* line # 7152 */
        ((V *)Rv1)[0]=Rv2;
      }
      Ra.sl[6]=7154; /* line # 7154 */
      P_lgt_new(&Rv5,NULL,0, Rv0);
      Ra.sl[6]=7155; /* line # 7155 */
      ((UB *)Rv5)[41]=8;
    }
  }
  Ra.sl[6]=7159; /* line # 7159 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exitstate "  */
V PAS_COMILER_PRC_00000058(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1180;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7173; /* line # 7173 */
  Ra.sl[6]=7175; /* line # 7175 */
  P_lgt_new(&Rv0,NULL,16, Lx[5].v[6]);
  Ra.sl[6]=7176; /* line # 7176 */
  if (Lx[5].v[6]==NULL) {
    Ra.sl[6]=7177; /* line # 7177 */
    P_src_error(Rd.s+1193,244,2);
  }
  Ra.sl[6]=7178; /* line # 7178 */
  P_lgt_new(&Rv1,NULL,0, Rv0);
  Ra.sl[6]=7179; /* line # 7179 */
  ((UB *)Rv1)[41]=6;
  Ra.sl[6]=7180; /* line # 7180 */
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  Ra.sl[6]=7181; /* line # 7181 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=7183; /* line # 7183 */
    Rv2=P_ide_search(8);
    Ra.sl[6]=7184; /* line # 7184 */
    if (Rv2==V_ide_udptr.v[3]) Rv2=NULL;
    Ra.sl[6]=7185; /* line # 7185 */
    if (Rv2!=NULL) {
      Ra.sl[6]=7186; /* line # 7186 */
      Rv3=Rv2;
      Ra.sl[6]=7189; /* line # 7189 */
      Rv4=V_cntx_label;
      Ra.sl[6]=7190; /* line # 7190 */
      while (Rv4!=NULL&&Rv4!=Rv2)
      Rv4=((V *)Rv4)[9];
      Ra.sl[6]=7191; /* line # 7191 */
      if (Rv4==NULL) {
        Ra.sl[6]=7193; /* line # 7193 */
        P_src_error(Rd.s+1193,177,3);
      }
      Ra.sl[6]=7194; /* line # 7194 */
      ((UB *)Rv3)[57]=((UB *)Rv3)[57]|2;
      Ra.sl[6]=7195; /* line # 7195 */
      ((V *)Rv0)[1]=((V *)Rv3)[11];
    }
    Ra.sl[6]=7203; /* line # 7203 */
    P_insymbol();
  }
  Ra.sl[6]=7206; /* line # 7206 */
  if (V_sy_sym.ub[0]==44) {
    Ra.sl[6]=7208; /* line # 7208 */
    P_insymbol();
    Ra.sl[6]=7210; /* line # 7210 */
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
  }
  Ra.sl[6]=7213; /* line # 7213 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " loopstate "  */
V PAS_COMILER_PRC_00000059(UB F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1197;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7229; /* line # 7229 */
  Rv0=Lx[5].v[6];
  Ra.sl[6]=7230; /* line # 7230 */
  P_lgt_new(Lx[5].v+6,NULL,0,NULL);
  Ra.sl[6]=7231; /* line # 7231 */
  ((UB *)Lx[5].v[6])[41]=4;
  Ra.sl[6]=7232; /* line # 7232 */
  Rv1=Lx[5].v[6];
  Ra.sl[6]=7233; /* line # 7233 */
  if (F_symb==47) {
    Ra.sl[6]=7235; /* line # 7235 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    Ra.sl[6]=7236; /* line # 7236 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else {
      Ra.sl[6]=7237; /* line # 7237 */
      P_src_error(Rd.s+1210,55,2);
    }
  }
  else {
    Ra.sl[6]=7240; /* line # 7240 */
    P_lgt_new(&Rv2,NULL,16,NULL);
  }
  Ra.sl[6]=7241; /* line # 7241 */
  ((V *)Rv1)[1]=Rv2;
  Ra.sl[6]=7243; /* line # 7243 */
  Ra.sl[6]=7245; /* line # 7245 */
  Rv3=Lx[4].v[0];
  Ra.sl[6]=7246; /* line # 7246 */
  if (Rv3!=NULL) ((V *)Rv3)[11]=Lx[5].v[6];
  Ra.sl[6]=7248; /* line # 7248 */
  Rv4=V_cntx_label;
  Ra.sl[6]=7250; /* line # 7250 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7253; /* line # 7253 */
  switch (F_symb) {
    case 47:Ra.sl[6]=7254; /* line # 7254 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000036(NULL,1);
    break;
    case 48:Ra.sl[6]=7258; /* line # 7258 */
    Rv5=PAS_COMILER_PRC_00000035(49,0);
    Ra.sl[6]=7259; /* line # 7259 */
    if (V_sy_sym.ub[0]==49) P_insymbol();
    else {
      Ra.sl[6]=7260; /* line # 7260 */
      P_src_error(Rd.s+1210,57,2);
    }
    Ra.sl[6]=7263; /* line # 7263 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Ra.sl[6]=7264; /* line # 7264 */
    Rv7=Rv6;
    Ra.sl[6]=7266; /* line # 7266 */
    ((V *)Rv7)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    Ra.sl[6]=7267; /* line # 7267 */
    ((V *)Rv7)[1]=Lx[5].v[6];
    Ra.sl[6]=7269; /* line # 7269 */
    P_lgt_new(&Rv6,NULL,0, Rv6);
    Ra.sl[6]=7270; /* line # 7270 */
    ((UB *)Rv6)[41]=6;
    Ra.sl[6]=7271; /* line # 7271 */
    if (Rv5!=NULL) {
      Ra.sl[6]=7273; /* line # 7273 */
      ((V *)Lx[5].v[7])[0]=Rv6;
      Ra.sl[6]=7274; /* line # 7274 */
      ((V *)Rv2)[0]=Rv5;
    }
    else {
      Ra.sl[6]=7277; /* line # 7277 */
      ((V *)Rv2)[0]=Rv6;
    }
    break;
    case 54:Ra.sl[6]=7282; /* line # 7282 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000035(72,0);
    Ra.sl[6]=7283; /* line # 7283 */
    if (V_sy_sym.ub[0]!=72) P_src_error(Rd.s+1210,54,2);
    else {
      Ra.sl[6]=7284; /* line # 7284 */
      P_insymbol();
    }
    Ra.sl[6]=7285; /* line # 7285 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=7286; /* line # 7286 */
      if (Rv3==P_ide_search(8)) {
        Ra.sl[6]=7287; /* line # 7287 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=7289; /* line # 7289 */
        P_src_error_s(Rd.s+1210,179,2, V_sy_ident.s,NULL);
      }
    }
    break;
  }
  Ra.sl[6]=7292; /* line # 7292 */
  P_label_purge(&Rv4);
  Ra.sl[6]=7295; /* line # 7295 */
  Lx[5].v[6]=Rv0;
  Ra.sl[6]=7296; /* line # 7296 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " forstate "  */
V PAS_COMILER_PRC_00000060(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  UB Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1214;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7314; /* line # 7314 */
  Rv2=Lx[5].v[6];
  Ra.sl[6]=7315; /* line # 7315 */
  Rv3=V_curr_disp;
  Ra.sl[6]=7316; /* line # 7316 */
  Rv4=V_cntx_label;
  Ra.sl[6]=7317; /* line # 7317 */
  P_new_disp_level(Lx[5].v[13],0);
  Ra.sl[6]=7318; /* line # 7318 */
  Ra.sl[6]=7319; /* line # 7319 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1226,168,2);
  else {
    Ra.sl[6]=7322; /* line # 7322 */
    P_ide_new(5,NULL,&Rv5);
    Ra.sl[6]=7323; /* line # 7323 */
    P_insymbol();
    Ra.sl[6]=7324; /* line # 7324 */
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else P_src_error(Rd.s+1226,32,2);
    Ra.sl[6]=7325; /* line # 7325 */
    V_sy_fix_range_ctl=0;
    Ra.sl[6]=7326; /* line # 7326 */
    Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,1,0);
    Ra.sl[6]=7329; /* line # 7329 */
    switch (V_sy_sym.ub[0]) {
      case 51:Ra.sl[6]=7332; /* line # 7332 */
      P_insymbol();
      Ra.sl[6]=7333; /* line # 7333 */
      Rv6=38;
      break;
      case 52:Ra.sl[6]=7338; /* line # 7338 */
      P_insymbol();
      Ra.sl[6]=7339; /* line # 7339 */
      Rv6=39;
      break;
      default:Ra.sl[6]=7343; /* line # 7343 */
      P_src_error(Rd.s+1226,59,2);
      Ra.sl[6]=7344; /* line # 7344 */
      Rv6=38;
      break;
    }
    Ra.sl[6]=7347; /* line # 7347 */
    Rv7=PAS_COMILER_PRC_00000005(((V *)Rv0)[3],0,1,0);
    Ra.sl[6]=7349; /* line # 7349 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else {
      Ra.sl[6]=7350; /* line # 7350 */
      P_src_error(Rd.s+1226,55,2);
    }
    Ra.sl[6]=7352; /* line # 7352 */
    P_lgt_new(Lx[5].v+6,V_typ_std.v[2],0,NULL);
    Ra.sl[6]=7353; /* line # 7353 */
    ((UB *)Lx[5].v[6])[41]=5;
    Ra.sl[6]=7355; /* line # 7355 */
    if (Rv6==39) {
      Ra.sl[6]=7357; /* line # 7357 */
      Rv8=Rv7;
      Ra.sl[6]=7359; /* line # 7359 */
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv7);
      else {
        Ra.sl[6]=7360; /* line # 7360 */
        Rv7=Rv0;
      }
    }
    else {
      Ra.sl[6]=7364; /* line # 7364 */
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv8);
      else {
        Ra.sl[6]=7365; /* line # 7365 */
        Rv8=Rv0;
      }
    }
    Ra.sl[6]=7367; /* line # 7367 */
    if (((UB *)Rv8)[40]==14) {
      Ra.sl[6]=7369; /* line # 7369 */
      Rv9=Rv7;
      Ra.sl[6]=7370; /* line # 7370 */
      Rv10=P_lgt_new_econst(((V *)Rv8)[3],((SL *)((V *)Rv8)[7])[13]-1);
    }
    else {
      Ra.sl[6]=7374; /* line # 7374 */
      Rv10=Rv8;
      Ra.sl[6]=7375; /* line # 7375 */
      if (((UB *)Rv7)[40]==14) {
        Ra.sl[6]=7376; /* line # 7376 */
        Rv9=P_lgt_new_econst(((V *)Rv7)[3],((SL *)((V *)Rv7)[7])[13]+1);
      }
      else {
        Ra.sl[6]=7379; /* line # 7379 */
        ((V *)Rv7)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Ra.sl[6]=7380; /* line # 7380 */
        Rv9=P_lgt_new_code(49, Rv7);
      }
    }
    Ra.sl[6]=7384; /* line # 7384 */
    Rv7=P_lgt_new_addsub(1,1, Rv9, Rv10);
    Ra.sl[6]=7387; /* line # 7387 */
    ((V *)Lx[5].v[6])[1]=Rv7;
    Ra.sl[6]=7389; /* line # 7389 */
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=7391; /* line # 7391 */
    Rv11=Rv5;
    Ra.sl[6]=7393; /* line # 7393 */
    ((V *)Rv11)[4]=((V *)Rv8)[3];
    Ra.sl[6]=7394; /* line # 7394 */
    ((UW *)Rv11)[46]=32;
    Ra.sl[6]=7395; /* line # 7395 */
    ((UB *)Rv11)[94]=1;
    Ra.sl[6]=7398; /* line # 7398 */
    Rv12=Lx[4].v[0];
    Ra.sl[6]=7399; /* line # 7399 */
    if (Rv12!=NULL) {
      Ra.sl[6]=7400; /* line # 7400 */
      Rv13=Rv12;
      Ra.sl[6]=7402; /* line # 7402 */
      ((V *)Rv13)[9]=V_cntx_label;
      Ra.sl[6]=7403; /* line # 7403 */
      V_cntx_label=Rv12;
      Ra.sl[6]=7404; /* line # 7404 */
      ((V *)Rv13)[11]=Lx[5].v[6];
    }
    Ra.sl[6]=7407; /* line # 7407 */
    V_cntx_lblvl=V_cntx_lblvl+1;
    Ra.sl[6]=7410; /* line # 7410 */
    Rv8=PAS_COMILER_PRC_00000036(NULL,1);
    Ra.sl[6]=7411; /* line # 7411 */
    ((V *)Rv7)[0]=Rv8;
    Ra.sl[6]=7413; /* line # 7413 */
    if (1&((UW *)Rv5)[46]) {
      Ra.sl[6]=7418; /* line # 7418 */
      Rv0=P_lgt_link(Rv0);
      Ra.sl[6]=7419; /* line # 7419 */
      Rv0=P_lgt_new_idref(Rv5, Rv0);
      Ra.sl[6]=7420; /* line # 7420 */
      Rv0=P_lgt_new_code(3, Rv0);
      Ra.sl[6]=7421; /* line # 7421 */
      ((V *)Rv0)[0]=Lx[5].v[6];
      Ra.sl[6]=7423; /* line # 7423 */
      P_lgt_new(Lx[5].v+6,NULL,0, Rv0);
      Ra.sl[6]=7424; /* line # 7424 */
      ((UB *)Lx[5].v[6])[41]=2;
      Ra.sl[6]=7427; /* line # 7427 */
      Rv0=P_lgt_new_idref(Rv5,NULL);
      Ra.sl[6]=7428; /* line # 7428 */
      Rv0=P_lgt_new_code(Rv6, Rv0);
      Ra.sl[6]=7429; /* line # 7429 */
      ((V *)Rv0)[3]=Rv1;
      Ra.sl[6]=7430; /* line # 7430 */
      if (Rv8!=NULL) ((V *)Rv8)[0]=Rv0;
      else {
        Ra.sl[6]=7431; /* line # 7431 */
        ((V *)Rv7)[0]=Rv0;
      }
    }
    else {
      Ra.sl[6]=7435; /* line # 7435 */
      if (((UB *)Rv0)[40]==14) P_lgt_free(&Rv0);
    }
    Ra.sl[6]=7437; /* line # 7437 */
    Rv0=Lx[5].v[6];
  }
  Ra.sl[6]=7440; /* line # 7440 */
  Lx[5].v[6]=Rv2;
  Ra.sl[6]=7442; /* line # 7442 */
  if (V_curr_disp>Rv3) {
    Ra.sl[6]=7444; /* line # 7444 */
    P_ide_reserve_disp(Rv3);
  }
  Ra.sl[6]=7445; /* line # 7445 */
  P_label_purge(&Rv4);
  Ra.sl[6]=7446; /* line # 7446 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gotostate "  */
V PAS_COMILER_PRC_00000061(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1230;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7459; /* line # 7459 */
  Rv0=NULL;
  Ra.sl[6]=7460; /* line # 7460 */
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  Ra.sl[6]=7461; /* line # 7461 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1243,69,3);
  Ra.sl[6]=7462; /* line # 7462 */
  V_err_prt=0;
  Ra.sl[6]=7463; /* line # 7463 */
  Rv1=P_ide_search(8);
  Ra.sl[6]=7464; /* line # 7464 */
  V_err_prt=1;
  Ra.sl[6]=7466; /* line # 7466 */
  if (Rv1==NULL) {
    Ra.sl[6]=7468; /* line # 7468 */
    P_ide_new(3,NULL,&Rv1);
    Ra.sl[6]=7469; /* line # 7469 */
    Rv2=Lx[5].v[13];
    Ra.sl[6]=7470; /* line # 7470 */
    if (((V *)Rv2)[20]==NULL) ((V *)Rv2)[20]=Rv1;
    else {
      Ra.sl[6]=7471; /* line # 7471 */
      ((V *)Lx[5].v[4])[8]=Rv1;
    }
    Ra.sl[6]=7472; /* line # 7472 */
    Lx[5].v[4]=Rv1;
  }
  Ra.sl[6]=7474; /* line # 7474 */
  P_lgt_new(&Rv0,NULL,0,NULL);
  Ra.sl[6]=7475; /* line # 7475 */
  Rv3=Rv0;
  Rv4=Rv1;
  Ra.sl[6]=7477; /* line # 7477 */
  if (((SL *)Rv4)[10]!=V_curr_lex) {
    Ra.sl[6]=7479; /* line # 7479 */
    ((UB *)Rv3)[41]=10;
    Ra.sl[6]=7481; /* line # 7481 */
    ((UB *)Rv4)[57]=((UB *)Rv4)[57]|12;
  }
  else {
    Ra.sl[6]=7485; /* line # 7485 */
    ((UB *)Rv4)[57]=((UB *)Rv4)[57]|4;
    Ra.sl[6]=7486; /* line # 7486 */
    if (32&((UB *)Rv4)[57]) {
      Ra.sl[6]=7488; /* line # 7488 */
      P_src_error(Rd.s+1243,70,2);
    }
    else {
      Ra.sl[6]=7490; /* line # 7490 */
      ((SL *)Rv4)[24]=V_cntx_lblvl;
    }
    Ra.sl[6]=7491; /* line # 7491 */
    ((UB *)Rv3)[41]=9;
  }
  Ra.sl[6]=7493; /* line # 7493 */
  ((V *)Rv3)[6]=Rv1;
  Ra.sl[6]=7495; /* line # 7495 */
  P_insymbol();
  Ra.sl[6]=7496; /* line # 7496 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " beginstate "  */
V PAS_COMILER_PRC_00000062(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1247;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7509; /* line # 7509 */
  Rv0=V_cntx_label;
  Ra.sl[6]=7510; /* line # 7510 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7511; /* line # 7511 */
  Rv1=PAS_COMILER_PRC_00000035(72,1);
  Ra.sl[6]=7512; /* line # 7512 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else {
    Ra.sl[6]=7513; /* line # 7513 */
    P_src_error(Rd.s+1261,54,2);
  }
  Ra.sl[6]=7514; /* line # 7514 */
  P_label_purge(&Rv0);
  Ra.sl[6]=7515; /* line # 7515 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " label_attach "  */
void PAS_COMILER_PRC_00000063(V F_lab_list, V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1265;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7521; /* line # 7521 */
  if (F_lab_list!=NULL&&F_trg!=NULL) {
    Ra.sl[6]=7522; /* line # 7522 */
    ((V *)F_trg)[4]=F_lab_list;
  }
  Ra.sl[6]=7530; /* line # 7530 */
  while (F_lab_list!=NULL){
    Ra.sl[6]=7531; /* line # 7531 */
    Rv0=F_lab_list;
    Ra.sl[6]=7533; /* line # 7533 */
    ((V *)Rv0)[11]=F_trg;
    F_lab_list=((V *)Rv0)[10];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement "  */
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1279;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=7540; /* line # 7540 */
  Rv0=NULL;
  Ra.sl[8]=7541; /* line # 7541 */
  Rv1=NULL;
  Ra.sl[8]=7542; /* line # 7542 */
  Ra.v[0]=NULL;
  Ra.sl[8]=7543; /* line # 7543 */
  Rv2=V_wildtmp_stk;
  Ra.sl[8]=7545; /* line # 7545 */
  Ra.sl[8]=7547; /* line # 7547 */
  Rv3=NULL;
  Ra.sl[8]=7548; /* line # 7548 */
  if (V_sy_sym.ub[0]==1) while (1){
    Ra.sl[8]=7550; /* line # 7550 */
    V_err_prt=0;
    Ra.sl[8]=7551; /* line # 7551 */
    Rv4=P_ide_search(8);
    Ra.sl[8]=7552; /* line # 7552 */
    V_err_prt=1;
    Ra.sl[8]=7554; /* line # 7554 */
    if (Rv4!=NULL) {
      Ra.sl[8]=7556; /* line # 7556 */
      if (((SL *)Rv4)[10]!=V_curr_lex) Rv4=NULL;
      else {
        Ra.sl[8]=7558; /* line # 7558 */
        if (16&((UB *)Rv4)[57]) {
          Ra.sl[8]=7560; /* line # 7560 */
          P_src_error_s(Rd.s+1292,75,3, V_sy_ident.s,NULL);
        }
      }
    }
    Ra.sl[8]=7562; /* line # 7562 */
    if (Rv4==NULL) {
      Ra.sl[8]=7564; /* line # 7564 */
      P_ide_new(3,NULL,&Rv4);
      Ra.sl[8]=7565; /* line # 7565 */
      Rv5=Lx[5].v[13];
      Ra.sl[8]=7566; /* line # 7566 */
      if (((V *)Rv5)[20]==NULL) ((V *)Rv5)[20]=Rv4;
      else {
        Ra.sl[8]=7567; /* line # 7567 */
        ((V *)Lx[5].v[4])[8]=Rv4;
      }
      Ra.sl[8]=7568; /* line # 7568 */
      Lx[5].v[4]=Rv4;
    }
    Ra.sl[8]=7571; /* line # 7571 */
    Rv6=Rv4;
    Ra.sl[8]=7573; /* line # 7573 */
    ((V *)Rv6)[9]=V_cntx_label;
    Ra.sl[8]=7574; /* line # 7574 */
    V_cntx_label=Rv4;
    Ra.sl[8]=7575; /* line # 7575 */
    ((UB *)Rv6)[57]=((UB *)Rv6)[57]|16;
    Ra.sl[8]=7576; /* line # 7576 */
    if (4&((UB *)Rv6)[57]) {
      Ra.sl[8]=7577; /* line # 7577 */
      if (((SL *)Rv6)[24]<V_cntx_lblvl) {
        Ra.sl[8]=7578; /* line # 7578 */
        P_src_error_s(Rd.s+1292,70,2, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[8]=7580; /* line # 7580 */
    if (Rv3==NULL) Rv3=Rv4;
    Ra.sl[8]=7581; /* line # 7581 */
    ((V *)Rv4)[10]=Ra.v[0];
    Ra.sl[8]=7582; /* line # 7582 */
    Ra.v[0]=Rv4;
    Ra.sl[8]=7583; /* line # 7583 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=1)  break;
  }
  Ra.sl[8]=7586; /* line # 7586 */
  if (V_cmp_trace>0) {
    Ra.sl[8]=7587; /* line # 7587 */
    switch (V_sy_sym.ub[0]) {
      case 18:
      case 48:
      case 54:
      case 71:break;
      default:Ra.sl[8]=7592; /* line # 7592 */
      if (Lx[5].sl[28]<2) {
        Ra.sl[8]=7593; /* line # 7593 */
        if (Ra.v[0]!=NULL) {
          Ra.sl[8]=7594; /* line # 7594 */
          if (8&((UB *)Ra.v[0])[57]) Lx[5].sl[28]=2;
          else {
            Ra.sl[8]=7595; /* line # 7595 */
            Lx[5].sl[28]=1;
          }
        }
      }
      Ra.sl[8]=7597; /* line # 7597 */
      Rv1=P_lgt_new_line(Lx[5].v[13],F_lgp, Lx[5].sl[28]);
      Ra.sl[8]=7599; /* line # 7599 */
      if (Ra.v[0]!=NULL) {
        Ra.sl[8]=7601; /* line # 7601 */
        if (Rv1==NULL) {
          Ra.sl[8]=7603; /* line # 7603 */
          if (F_lgp!=NULL) {
            Ra.sl[8]=7604; /* line # 7604 */
            ((V *)Rv3)[10]=((V *)F_lgp)[4];
          }
          Ra.sl[8]=7605; /* line # 7605 */
          PAS_COMILER_PRC_00000063(Ra.v[0],F_lgp);
        }
        else {
          Ra.sl[8]=7608; /* line # 7608 */
          PAS_COMILER_PRC_00000063(Ra.v[0],Rv1);
        }
        Ra.sl[8]=7609; /* line # 7609 */
        Ra.v[0]=NULL;
      }
      Ra.sl[8]=7611; /* line # 7611 */
      Lx[5].sl[28]=0;
      break;
    }
  }
  Ra.sl[8]=7615; /* line # 7615 */
  memcpy(Ra.s+36,V_sy_sym.s,2);
  Ra.sl[8]=7616; /* line # 7616 */
  Ra.sl[8]=7618; /* line # 7618 */
  if ((((Ra.ub[36]!=72&&Ra.ub[36]!=88)&&Ra.ub[36]!=49)&&Ra.ub[36]!=0)&&Ra.ub[36]
  !=18) {
    Ra.sl[8]=7619; /* line # 7619 */
    P_insymbol();
  }
  Ra.sl[8]=7620; /* line # 7620 */
  switch (Ra.ub[36]) {
    case 88:break;
    case 0:Ra.sl[8]=7624; /* line # 7624 */
    Rv4=P_ide_search(2016);
    Ra.sl[8]=7633; /* line # 7633 */
    Rv7=Rv4;
    Ra.sl[8]=7635; /* line # 7635 */
    P_insymbol();
    Ra.sl[8]=7636; /* line # 7636 */
    switch (((UB *)Rv7)[56]) {
      case 10:Ra.sl[8]=7638; /* line # 7638 */
      Rv0=PAS_COMILER_PRC_00000014(Rv4);
      break;
      case 7:Ra.sl[8]=7642; /* line # 7642 */
      Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
      Ra.sl[8]=7643; /* line # 7643 */
      if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
      break;
      case 8:
      case 9:Ra.sl[8]=7648; /* line # 7648 */
      switch (V_sy_sym.ub[0]) {
        case 15:
        case 19:
        case 22:Ra.sl[8]=7652; /* line # 7652 */
        Rv0=PAS_COMILER_PRC_00000054(Rv4);
        break;
        default:Ra.sl[8]=7655; /* line # 7655 */
        if (((UB *)Rv7)[56]==9) Rv0=PAS_COMILER_PRC_00000011(Rv4,0);
        else {
          Ra.sl[8]=7656; /* line # 7656 */
          Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
        }
        Ra.sl[8]=7657; /* line # 7657 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
        break;
      }
      break;
      default:Ra.sl[8]=7661; /* line # 7661 */
      Rv0=PAS_COMILER_PRC_00000055(Rv4);
      break;
    }
    break;
    case 71:Ra.sl[8]=7666; /* line # 7666 */
    Rv0=PAS_COMILER_PRC_00000062();
    break;
    case 44:Ra.sl[8]=7667; /* line # 7667 */
    Rv0=PAS_COMILER_PRC_00000057();
    break;
    case 47:
    case 48:
    case 54:Ra.sl[8]=7670; /* line # 7670 */
    Rv0=PAS_COMILER_PRC_00000059(Ra.ub[36]);
    break;
    case 50:Ra.sl[8]=7671; /* line # 7671 */
    Rv0=PAS_COMILER_PRC_00000060();
    break;
    case 55:Ra.sl[8]=7672; /* line # 7672 */
    Rv0=PAS_COMILER_PRC_00000058();
    break;
    case 57:Ra.sl[8]=7673; /* line # 7673 */
    Rv0=PAS_COMILER_PRC_00000056();
    break;
    case 56:Ra.sl[8]=7674; /* line # 7674 */
    Rv0=PAS_COMILER_PRC_00000004(56,NULL);
    break;
    case 33:Ra.sl[8]=7675; /* line # 7675 */
    Rv0=PAS_COMILER_PRC_00000061();
    break;
    case 58:Ra.sl[8]=7677; /* line # 7677 */
    Rv0=PAS_COMILER_PRC_00000016(V_new_entry_proc);
    break;
    case 59:Ra.sl[8]=7678; /* line # 7678 */
    Rv0=PAS_COMILER_PRC_00000016(V_newh_entry_proc);
    break;
    case 60:Ra.sl[8]=7679; /* line # 7679 */
    Rv0=PAS_COMILER_PRC_00000017(V_dispose_entry_proc);
    break;
    case 61:Ra.sl[8]=7681; /* line # 7681 */
    Rv0=PAS_COMILER_PRC_00000012(0);
    break;
    case 62:Ra.sl[8]=7682; /* line # 7682 */
    Rv0=PAS_COMILER_PRC_00000012(1);
    break;
    case 63:Ra.sl[8]=7683; /* line # 7683 */
    Rv0=PAS_COMILER_PRC_00000012(2);
    break;
    case 64:Ra.sl[8]=7684; /* line # 7684 */
    Rv0=PAS_COMILER_PRC_00000012(3);
    break;
    case 65:Ra.sl[8]=7687; /* line # 7687 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    NULL);
    break;
    case 66:Ra.sl[8]=7690; /* line # 7690 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    V_inp_std_eoln);
    break;
    case 67:Ra.sl[8]=7693; /* line # 7693 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_inp_std_sel, V_inp_std_gene,NULL,V_inp_std_eoln);
    break;
    case 68:Ra.sl[8]=7696; /* line # 7696 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    NULL);
    break;
    case 69:Ra.sl[8]=7699; /* line # 7699 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    V_out_std_eoln);
    break;
    case 70:Ra.sl[8]=7702; /* line # 7702 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_out_std_sel, V_out_std_gene,NULL,V_out_std_eoln);
    break;
    case 78:Ra.sl[8]=7706; /* line # 7706 */
    Rv0=PAS_COMILER_PRC_00000054(NULL);
    break;
    default:break;
  }
  Ra.sl[8]=7710; /* line # 7710 */
  if (Ra.v[0]!=NULL) {
    Ra.sl[8]=7712; /* line # 7712 */
    if (Rv0==NULL) P_lgt_new(&Rv0,NULL,17,NULL);
    Ra.sl[8]=7713; /* line # 7713 */
    PAS_COMILER_PRC_00000063(Ra.v[0],Rv0);
  }
  Ra.sl[8]=7717; /* line # 7717 */
  if (Rv0!=NULL) {
    Ra.sl[8]=7719; /* line # 7719 */
    if (Rv1!=NULL) {
      Ra.sl[8]=7721; /* line # 7721 */
      ((V *)Rv1)[0]=Rv0;
      Ra.sl[8]=7722; /* line # 7722 */
      if (F_bsequ) {
        Ra.sl[8]=7724; /* line # 7724 */
        P_lgt_new(&Rv0,NULL,0, Rv1);
        Ra.sl[8]=7725; /* line # 7725 */
        ((UB *)Rv0)[41]=2;
        Ra.sl[8]=7726; /* line # 7726 */
        Lx[5].v[8]=Rv0;
      }
      else {
        Ra.sl[8]=7730; /* line # 7730 */
        Lx[5].v[8]=Rv0;
        Ra.sl[8]=7731; /* line # 7731 */
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[8]=7735; /* line # 7735 */
      Lx[5].v[8]=Rv0;
    }
  }
  else {
    Ra.sl[8]=7739; /* line # 7739 */
    if (Rv1!=NULL) Rv0=Rv1;
    Ra.sl[8]=7740; /* line # 7740 */
    Lx[5].v[8]=Rv0;
  }
  Ra.sl[8]=7743; /* line # 7743 */
  P_tmpstk_free(Rv2);
  Ra.sl[8]=7744; /* line # 7744 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[4]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " statelist "  */
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1296;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7759; /* line # 7759 */
  Rv0=V_src_control;
  ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
  Ra.sl[6]=7760; /* line # 7760 */
  Rv1=NULL;
  Ra.sl[6]=7761; /* line # 7761 */
  Rv2=NULL;
  Ra.sl[6]=7762; /* line # 7762 */
  Ra.sl[6]=7764; /* line # 7764 */
  while (V_sy_sym.ub[0]==18)
  P_insymbol();
  Ra.sl[6]=7765; /* line # 7765 */
  if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=88)&&V_sy_sym.ub[0]!=72)&&!V_emergency_stop)
   {
    Ra.sl[6]=7768; /* line # 7768 */
    Rv1=PAS_COMILER_PRC_00000036(NULL,0);
    Ra.sl[6]=7769; /* line # 7769 */
    Rv2=Lx[5].v[8];
    Ra.sl[6]=7771; /* line # 7771 */
    while (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=88)&&V_sy_sym.ub[0]!=72)
    &&!V_emergency_stop){
      Ra.sl[6]=7774; /* line # 7774 */
      if (V_sy_sym.ub[0]==18) {
        Ra.sl[6]=7775; /* line # 7775 */
        while (V_sy_sym.ub[0]==18)
        P_insymbol();
      }
      else {
        Ra.sl[6]=7776; /* line # 7776 */
        P_src_error(Rd.s+1309,21,2);
      }
      Ra.sl[6]=7777; /* line # 7777 */
      if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=88)&&V_sy_sym.ub[0]!=72)&&
      !V_emergency_stop) {
        Ra.sl[6]=7780; /* line # 7780 */
        Rv3=PAS_COMILER_PRC_00000036(Rv2,0);
        Ra.sl[6]=7781; /* line # 7781 */
        if (Rv3!=NULL) {
          Ra.sl[6]=7783; /* line # 7783 */
          if (Rv1==NULL) Rv1=Rv3;
          else {
            Ra.sl[6]=7784; /* line # 7784 */
            ((V *)Rv2)[0]=Rv3;
          }
          Ra.sl[6]=7785; /* line # 7785 */
          Rv2=Lx[5].v[8];
        }
      }
    }
  }
  Ra.sl[6]=7791; /* line # 7791 */
  Rv4=V_src_control;
  ((SL *)Rv4)[6]=((SL *)Rv4)[6]-1;
  Ra.sl[6]=7792; /* line # 7792 */
  Lx[5].v[7]=Rv2;
  Ra.sl[6]=7793; /* line # 7793 */
  if (F_seq_flg&&Rv1!=Rv2) {
    Ra.sl[6]=7795; /* line # 7795 */
    P_lgt_new(&Rv2,NULL,0, Rv1);
    Ra.sl[6]=7796; /* line # 7796 */
    ((UB *)Rv2)[41]=2;
    Ra.sl[6]=7797; /* line # 7797 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=7799; /* line # 7799 */
    Ret=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cmp_block "  */
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[13]=F_owner;
  Ra.sl[28]=F_glicd;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+72;
  Ra.v[10]=Rd.s+1313;
  Ra.v[11]=Rd.s+17;
  Ra.sl[24]=7807; /* line # 7807 */
  if (V_curr_lex>0) {
    Ra.sl[24]=7809; /* line # 7809 */
    P_new_disp_level(Ra.v[13],4);
  }
  Ra.sl[24]=7813; /* line # 7813 */
  Ra.ub[40]=0;
  Ra.sl[24]=7814; /* line # 7814 */
  Ra.v[6]=NULL;
  Ra.sl[24]=7815; /* line # 7815 */
  Ra.v[1]=NULL;
  Ra.sl[24]=7816; /* line # 7816 */
  Rv0=NULL;
  Ra.sl[24]=7817; /* line # 7817 */
  Rv1=V_cntx_label;
  Ra.sl[24]=7818; /* line # 7818 */
  V_cntx_label=NULL;
  Ra.sl[24]=7819; /* line # 7819 */
  Rv2=Ra.v[13];
  Ra.sl[24]=7821; /* line # 7821 */
  ((V *)Rv2)[19]=NULL;
  Ra.sl[24]=7822; /* line # 7822 */
  ((V *)Rv2)[23]=NULL;
  Ra.sl[24]=7823; /* line # 7823 */
  ((V *)Rv2)[24]=NULL;
  Ra.sl[24]=7826; /* line # 7826 */
  P_compile_set_sbttl(Ra.v[13]);
  Ra.sl[24]=7828; /* line # 7828 */
  Ra.sl[24]=7830; /* line # 7830 */
  Ra.ub[16]=1;
  Ra.sl[24]=7831; /* line # 7831 */
  Ra.v[3]=NULL;
  while (1){
    Ra.sl[24]=7833; /* line # 7833 */
    V_pro_current=Ra.v[13];
    Ra.sl[24]=7834; /* line # 7834 */
    V_cprc_disp=V_curr_disp;
    Ra.sl[24]=7837; /* line # 7837 */
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043();
    Ra.sl[24]=7838; /* line # 7838 */
    switch (V_sy_sym.ub[0]) {
      case 28:Ra.sl[24]=7842; /* line # 7842 */
      P_insymbol();
      Ra.sl[24]=7843; /* line # 7843 */
      PAS_COMILER_PRC_00000044();
      break;
      case 29:Ra.sl[24]=7848; /* line # 7848 */
      P_insymbol();
      Ra.sl[24]=7849; /* line # 7849 */
      PAS_COMILER_PRC_00000045();
      break;
      case 30:Ra.sl[24]=7854; /* line # 7854 */
      if (V_sy_init_mod) {
        Ra.sl[24]=7855; /* line # 7855 */
        V_sy_var_init_mod=1;
      }
      Ra.sl[24]=7856; /* line # 7856 */
      P_insymbol();
      Ra.sl[24]=7857; /* line # 7857 */
      PAS_COMILER_PRC_00000046();
      Ra.sl[24]=7858; /* line # 7858 */
      if (V_sy_init_mod) {
        Ra.sl[24]=7859; /* line # 7859 */
        V_sy_var_init_mod=0;
      }
      break;
      case 32:Ra.sl[24]=7862; /* line # 7862 */
      PAS_COMILER_PRC_00000047();
      break;
      case 31:Ra.sl[24]=7864; /* line # 7864 */
      PAS_COMILER_PRC_00000048();
      break;
      case 76:
      case 77:Ra.sl[24]=7869; /* line # 7869 */
      PAS_COMILER_PRC_00000050();
      Ra.sl[24]=7870; /* line # 7870 */
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=7871; /* line # 7871 */
      V_cntx_varbl=((V *)Ra.v[13])[22];
      break;
      case 71:
      case 72:
      case 88:break;
      default:Ra.sl[24]=7877; /* line # 7877 */
      P_src_error(Rd.s+1326,91,2);
      Ra.sl[24]=7878; /* line # 7878 */
      P_insymbol();
      break;
    }
    if ((V_sy_sym.ub[0]==88||V_sy_sym.ub[0]==71)||V_sy_sym.ub[0]==72)  break;
  }
  Ra.sl[24]=7883; /* line # 7883 */
  if (V_curr_lex>0) {
    Ra.sl[24]=7884; /* line # 7884 */
    if (V_sy_sym.ub[0]==71) {
      Ra.sl[24]=7887; /* line # 7887 */
      P_ide_create_name(Rd.s+1330);
      Ra.sl[24]=7888; /* line # 7888 */
      P_ide_new_typ(21, &V_wildtmp_typ);
      Ra.sl[24]=7890; /* line # 7890 */
      ((SL *)V_wildtmp_typ)[11]=0;
      Ra.sl[24]=7891; /* line # 7891 */
      P_ide_new(5, V_wildtmp_typ, &V_wildtmp_ide);
      Ra.sl[24]=7892; /* line # 7892 */
      ((UW *)V_wildtmp_ide)[46]=96;
      Ra.sl[24]=7893; /* line # 7893 */
      V_wildtmp_psz=0;
      Ra.sl[24]=7894; /* line # 7894 */
      V_wildtmp_pal.ub[0]=0;
      Ra.sl[24]=7895; /* line # 7895 */
      V_wildtmp_stk=NULL;
      Ra.sl[24]=7897; /* line # 7897 */
      V_cntx_lblvl=0;
      Ra.sl[24]=7898; /* line # 7898 */
      V_cprc_disp=V_curr_disp;
      Ra.sl[24]=7899; /* line # 7899 */
      V_pro_current=Ra.v[13];
      Ra.sl[24]=7900; /* line # 7900 */
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=7902; /* line # 7902 */
      if (Ra.v[1]!=NULL) {
        Ra.sl[24]=7904; /* line # 7904 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=Ra.v[1];
        else {
          Ra.sl[24]=7905; /* line # 7905 */
          ((V *)Ra.v[13])[23]=Ra.v[1];
        }
        Ra.sl[24]=7906; /* line # 7906 */
        P_src_error(Rd.s+1326,92,3);
      }
      Ra.sl[24]=7910; /* line # 7910 */
      V_sy_label_flag=1;
      Ra.sl[24]=7912; /* line # 7912 */
      P_insymbol();
      Ra.sl[24]=7914; /* line # 7914 */
      Rv3=Ra.v[13];
      Ra.sl[24]=7917; /* line # 7917 */
      ((V *)Rv3)[16]=PAS_COMILER_PRC_00000035(72,0);
      Ra.sl[24]=7919; /* line # 7919 */
      if (((V *)Rv3)[11]!=NULL) {
        Ra.sl[24]=7920; /* line # 7920 */
        if (!Ra.ub[40]) P_src_error(Rd.s+1326,74,3);
      }
      Ra.sl[24]=7923; /* line # 7923 */
      if (((V *)Rv3)[18]!=NULL) {
        Ra.sl[24]=7925; /* line # 7925 */
        ((V *)((V *)Rv3)[17])[0]=((V *)Rv3)[16];
        Ra.sl[24]=7926; /* line # 7926 */
        ((V *)Rv3)[16]=((V *)Rv3)[18];
      }
      Ra.sl[24]=7928; /* line # 7928 */
      ((V *)Rv3)[17]=Ra.v[7];
      Ra.sl[24]=7932; /* line # 7932 */
      Rv4=((V *)Ra.v[13])[19];
      Ra.sl[24]=7933; /* line # 7933 */
      while (Rv4!=NULL){
        Ra.sl[24]=7935; /* line # 7935 */
        Rv5=Rv4;
        Ra.sl[24]=7937; /* line # 7937 */
        V_ope_table.v[((UB *)Rv5)[0]]=((V *)Rv5)[2];
        Ra.sl[24]=7941; /* line # 7941 */
        Rv6=((V *)Rv5)[1];
        Ra.sl[24]=7943; /* line # 7943 */
        PAS__DISPOSE(&Rv4);
        Ra.sl[24]=7944; /* line # 7944 */
        Rv4=Rv6;
      }
      Ra.sl[24]=7948; /* line # 7948 */
      V_sy_label_flag=0;
    }
  }
  Ra.sl[24]=7953; /* line # 7953 */
  if (((UB *)Ra.v[13])[104]>=4) {
    Ra.sl[24]=7955; /* line # 7955 */
    V_cntx_label=((V *)Ra.v[13])[20];
    Ra.sl[24]=7956; /* line # 7956 */
    while (V_cntx_label!=Rv1&&V_cntx_label!=NULL){
      Ra.sl[24]=7957; /* line # 7957 */
      Rv7=V_cntx_label;
      Ra.sl[24]=7959; /* line # 7959 */
      if (4&((UB *)Rv7)[57]) {
        Ra.sl[24]=7962; /* line # 7962 */
        if (!(16&((UB *)Rv7)[57])) P_src_error(Rd.s+1326,66,3);
      }
      Ra.sl[24]=7963; /* line # 7963 */
      V_cntx_label=((V *)Rv7)[8];
    }
  }
  Ra.sl[24]=7966; /* line # 7966 */
  V_cntx_label=Rv1;
  PAS__curr_cntx=Ra.v[9];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " cmp_init "  */
void P_cmp_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1337;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7986; /* line # 7986 */
  V_emergency_stop=0;
  Ra.sl[6]=7988; /* line # 7988 */
  P_insy_init();
  Ra.sl[6]=7990; /* line # 7990 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=7992; /* line # 7992 */
  V_opt_exec=0;
  Ra.sl[6]=7994; /* line # 7994 */
  V_cmp_cmpdbg=0;
  Ra.sl[6]=7996; /* line # 7996 */
  V_cmp_range=0;
  Ra.sl[6]=7997; /* line # 7997 */
  V_cmp_dynamic=0;
  Ra.sl[6]=7998; /* line # 7998 */
  V_cmp_genenv=0;
  Ra.sl[6]=7999; /* line # 7999 */
  V_cmp_listlvl=1;
  Ra.sl[6]=8000; /* line # 8000 */
  V_cmp_igenv=-1;
  Ra.sl[6]=8002; /* line # 8002 */
  V_cmp_macf=0;
  Ra.sl[6]=8003; /* line # 8003 */
  V_cmp_cobj=0;
  Ra.sl[6]=8004; /* line # 8004 */
  V_cmp_objf=0;
  Ra.sl[6]=8005; /* line # 8005 */
  V_cmp_bltt=0;
  Ra.sl[6]=8006; /* line # 8006 */
  V_cmp_opt=1;
  Ra.sl[6]=8007; /* line # 8007 */
  V_cmp_debugopt=0;
  Ra.sl[6]=8008; /* line # 8008 */
  V_cmp_debug=0;
  Ra.sl[6]=8009; /* line # 8009 */
  V_cmp_traceopt=5;
  Ra.sl[6]=8010; /* line # 8010 */
  V_cmp_trace=-1;
  Ra.sl[6]=8011; /* line # 8011 */
  V_cmp_tracecount=0;
  Ra.sl[6]=8012; /* line # 8012 */
  V_cmp_twicedclon=0;
  Ra.sl[6]=8014; /* line # 8014 */
  V_sy_init_mod=1;
  Ra.sl[6]=8015; /* line # 8015 */
  V_sy_generic_qmod=1;
  Ra.sl[6]=8016; /* line # 8016 */
  V_sy_var_init_mod=0;
  Ra.sl[6]=8018; /* line # 8018 */
  V_sy_casedef=0;
  Ra.sl[6]=8020; /* line # 8020 */
  P_insymbol();
  Ra.sl[6]=8022; /* line # 8022 */
  P_compile_set_title();
  Ra.sl[6]=8023; /* line # 8023 */
  P_compile_set_sbttl(V_lex_ident_tree.v[0]);
  Ra.sl[6]=8025; /* line # 8025 */
  P_generation_setting();
  Ra.sl[6]=8028; /* line # 8028 */
  P_cmp_block(V_lex_ident_tree.v[0],1,0);
  Ra.sl[6]=8030; /* line # 8030 */
  if (V_error_result!=0) {
    Ra.sl[6]=8031; /* line # 8031 */
    V_emergency_stop=1;
  }
  Ra.sl[6]=8033; /* line # 8033 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8057; /* line # 8057 */
  V_cntx_procname=V_fptr_size;
  Ra.sl[6]=8058; /* line # 8058 */
  V_cntx_srcfname=V_cntx_procname+V_fptr_size;
  Ra.sl[6]=8059; /* line # 8059 */
  V_cntx_linenbr=V_cntx_srcfname+V_fptr_size;
  Ra.sl[6]=8060; /* line # 8060 */
  V_cntx_size=V_cntx_linenbr+V_inte_size;
  Ra.sl[6]=8061; /* line # 8061 */
  P_ide_new_typ(10, &V_cntx_typ);
  Ra.sl[6]=8062; /* line # 8062 */
  Rv0=V_cntx_typ;
  Ra.sl[6]=8064; /* line # 8064 */
  ((UB *)Rv0)[48]=((UB *)V_typ_std.v[5])[48];
  Ra.sl[6]=8065; /* line # 8065 */
  ((SL *)Rv0)[11]=V_cntx_size;
  Ra.sl[6]=8066; /* line # 8066 */
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=8067; /* line # 8067 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=8068; /* line # 8068 */
  ((V *)Rv0)[14]=NULL;
  Ra.sl[6]=8070; /* line # 8070 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  Ra.sl[6]=8071; /* line # 8071 */
  V_sy_init_mod=0;
  Ra.sl[6]=8072; /* line # 8072 */
  V_sy_generic_qmod=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_pass2 "  */
void PAS_COMILER_cmp_pass2(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1347;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8080; /* line # 8080 */
  Rv0=F_pr;
  Ra.sl[6]=8089; /* line # 8089 */
  P_lgt_pass1_complet(F_pr);
  Ra.sl[6]=8091; /* line # 8091 */
  if (V_cmp_macf) {
    Ra.sl[6]=8093; /* line # 8093 */
    P_lgt_dump_proc(F_pr);
    Ra.sl[6]=8094; /* line # 8094 */
    P_lst_page();
  }
  Ra.sl[6]=8099; /* line # 8099 */
  switch (((UB *)Rv0)[104]) {
    case 5:
    case 8:
    case 9:Ra.sl[6]=8105; /* line # 8105 */
    P_generate_code_p1(F_pr);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_compile "  */
UB P_cmp_compile(UB F_interactive){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;
  V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1358;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8129; /* line # 8129 */
  V_emergency_stop=0;
  Ra.sl[6]=8130; /* line # 8130 */
  Rv0=0;
  Ra.sl[6]=8132; /* line # 8132 */
  V_env_file=NULL;
  Ra.sl[6]=8133; /* line # 8133 */
  V_env_first=NULL;
  Ra.sl[6]=8134; /* line # 8134 */
  V_env_last=NULL;
  Ra.sl[6]=8136; /* line # 8136 */
  Ra.sl[6]=8138; /* line # 8138 */
  if (!V_emergency_stop) {
    Ra.sl[6]=8140; /* line # 8140 */
    P_compile_set_title();
    Ra.sl[6]=8146; /* line # 8146 */
    Rv1=V_src_control;
    Ra.sl[6]=8148; /* line # 8148 */
    ((SL *)Rv1)[7]=1;
    Ra.sl[6]=8149; /* line # 8149 */
    ((SL *)Rv1)[8]=V_cmp_listlvl;
    Ra.sl[6]=8153; /* line # 8153 */
    V_sy_ch=32;
    Ra.sl[6]=8154; /* line # 8154 */
    P_insymbol();
    Ra.sl[6]=8156; /* line # 8156 */
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=8158; /* line # 8158 */
    PAS__DISPOSE(((V *)V_lst_current)+5);
    Ra.sl[6]=8160; /* line # 8160 */
    Rv2=PAS__NEW(245);
    Ra.sl[6]=8161; /* line # 8161 */
    V_pro_current=Rv2;
    Ra.sl[6]=8163; /* line # 8163 */
    if (V_sy_sym.ub[0]==73) {
      Ra.sl[6]=8165; /* line # 8165 */
      V_sy_sym.ub[0]=17;
      while (1){
        Ra.sl[6]=8167; /* line # 8167 */
        P_insymbol();
        Ra.sl[6]=8168; /* line # 8168 */
        if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
          Ra.sl[6]=8169; /* line # 8169 */
          P_set_env_file_spc(NULL);
        }
        else {
          Ra.sl[6]=8171; /* line # 8171 */
          P_src_error(Rd.s+1373,58,3);
        }
        Ra.sl[6]=8172; /* line # 8172 */
        P_insymbol();
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=8174; /* line # 8174 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=8175; /* line # 8175 */
        P_src_error(Rd.s+1373,21,2);
      }
    }
    else {
      Ra.sl[6]=8177; /* line # 8177 */
      if (V_sy_sym.ub[0]==15) {
        Ra.sl[6]=8180; /* line # 8180 */
        V_sy_sym.ub[0]=17;
        while (1){
          Ra.sl[6]=8182; /* line # 8182 */
          P_insymbol();
          Ra.sl[6]=8183; /* line # 8183 */
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[6]=8185; /* line # 8185 */
            Rv3=P_level_search(V_attr_list);
            Ra.sl[6]=8186; /* line # 8186 */
            if (Rv3!=NULL) while (1){
              Ra.sl[6]=8188; /* line # 8188 */
              P_insymbol();
              Ra.sl[6]=8189; /* line # 8189 */
              switch (((UB *)Rv3)[57]) {
                case 18:Ra.sl[6]=8192; /* line # 8192 */
                if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1373,22,2);
                Ra.sl[6]=8193; /* line # 8193 */
                V_sy_sym.ub[0]=17;
                while (1){
                  Ra.sl[6]=8195; /* line # 8195 */
                  P_insymbol();
                  Ra.sl[6]=8196; /* line # 8196 */
                  if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                    Ra.sl[6]=8197; /* line # 8197 */
                    P_set_env_file_spc(NULL);
                  }
                  else {
                    Ra.sl[6]=8199; /* line # 8199 */
                    P_src_error(Rd.s+1373,58,3);
                  }
                  Ra.sl[6]=8200; /* line # 8200 */
                  P_insymbol();
                  if (V_sy_sym.ub[0]!=17)  break;
                }
                Ra.sl[6]=8202; /* line # 8202 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else {
                  Ra.sl[6]=8203; /* line # 8203 */
                  P_src_error(Rd.s+1373,23,2);
                }
                break;
                case 19:Ra.sl[6]=8208; /* line # 8208 */
                if (V_sy_sym.ub[0]==13) P_insymbol();
                else {
                  Ra.sl[6]=8209; /* line # 8209 */
                  P_src_error(Rd.s+1373,22,2);
                }
                Ra.sl[6]=8210; /* line # 8210 */
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[6]=8212; /* line # 8212 */
                  Rv4=V_sy_string.ub[1];
                  V_env_file=PAS__NEW((SL)Rv4+2);
                  ((UB *)V_env_file)[0]=Rv4;
                  Ra.sl[6]=8213; /* line # 8213 */
                  PAS__STR_TO_STR(V_env_file,V_sy_string.s);
                  Ra.sl[6]=8214; /* line # 8214 */
                  V_cmp_genenv=1;
                  Ra.sl[6]=8215; /* line # 8215 */
                  V_cmp_igenv=0;
                  Ra.sl[6]=8216; /* line # 8216 */
                  P_insymbol();
                }
                else {
                  Ra.sl[6]=8220; /* line # 8220 */
                  V_cmp_genenv=0;
                  Ra.sl[6]=8221; /* line # 8221 */
                  V_cmp_igenv=-1;
                }
                Ra.sl[6]=8223; /* line # 8223 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else {
                  Ra.sl[6]=8224; /* line # 8224 */
                  P_src_error(Rd.s+1373,23,2);
                }
                break;
                default:Ra.sl[6]=8227; /* line # 8227 */
                P_src_error_s(Rd.s+1373,3,1, V_sy_ident.s,NULL);
                break;
              }
              if ((V_sy_sym.ub[0]==88||V_sy_sym.ub[0]==17)||V_sy_sym.ub[0]==16)  break;
            }
          }
          else {
            Ra.sl[6]=8231; /* line # 8231 */
            P_src_error(Rd.s+1373,2,3);
          }
          if (V_sy_sym.ub[0]!=17)  break;
        }
        Ra.sl[6]=8233; /* line # 8233 */
        if (V_sy_sym.ub[0]==16) P_insymbol();
        else {
          Ra.sl[6]=8234; /* line # 8234 */
          P_src_error(Rd.s+1373,26,2);
        }
      }
    }
    Ra.sl[6]=8237; /* line # 8237 */
    if (V_cmp_igenv>=0) V_cmp_genenv=1;
    else {
      Ra.sl[6]=8238; /* line # 8238 */
      V_cmp_genenv=0;
    }
    Ra.sl[6]=8240; /* line # 8240 */
    if (V_sy_sym.ub[0]==74) {
      Ra.sl[6]=8242; /* line # 8242 */
      P_insymbol();
      Ra.sl[6]=8243; /* line # 8243 */
      Rv0=1;
      Ra.sl[6]=8244; /* line # 8244 */
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=8246; /* line # 8246 */
        P_src_error(Rd.s+1373,93,4);
        Ra.sl[6]=8247; /* line # 8247 */
        V_emergency_stop=1;
      }
    }
    else {
      Ra.sl[6]=8251; /* line # 8251 */
      if (V_sy_sym.ub[0]==75) {
        Ra.sl[6]=8253; /* line # 8253 */
        P_insymbol();
        Ra.sl[6]=8254; /* line # 8254 */
        if (V_sy_sym.ub[0]!=0) {
          Ra.sl[6]=8256; /* line # 8256 */
          P_src_error(Rd.s+1373,93,4);
          Ra.sl[6]=8257; /* line # 8257 */
          V_emergency_stop=1;
        }
      }
      else {
        Ra.sl[6]=8261; /* line # 8261 */
        P_src_error(Rd.s+1373,94,4);
      }
    }
  }
  Ra.sl[6]=8264; /* line # 8264 */
  if (!V_emergency_stop) {
    Ra.sl[6]=8266; /* line # 8266 */
    Rv5=Rv2;
    Ra.sl[6]=8269; /* line # 8269 */
    V_curr_lex=V_curr_lex+1;
    Ra.sl[6]=8270; /* line # 8270 */
    P_new_disp_level(Rv2,4);
    Ra.sl[6]=8273; /* line # 8273 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    Ra.sl[6]=8275; /* line # 8275 */
    P_ide_new(9,NULL,&Rv6);
    Ra.sl[6]=8277; /* line # 8277 */
    ((V *)Rv5)[0]=NULL;
    Ra.sl[6]=8278; /* line # 8278 */
    ((V *)Rv5)[1]=NULL;
    Ra.sl[6]=8279; /* line # 8279 */
    ((UW *)Rv5)[8]=128;
    Ra.sl[6]=8280; /* line # 8280 */
    ((V *)Rv5)[3]=((V *)Rv6)[0];
    Ra.sl[6]=8281; /* line # 8281 */
    ((UB *)Rv5)[32]=29;
    Ra.sl[6]=8282; /* line # 8282 */
    ((V *)Rv5)[5]=Rv6;
    Ra.sl[6]=8283; /* line # 8283 */
    ((V *)Rv5)[6]=NULL;
    Ra.sl[6]=8284; /* line # 8284 */
    ((V *)Rv5)[7]=NULL;
    Ra.sl[6]=8285; /* line # 8285 */
    ((V *)Rv5)[8]=NULL;
    Ra.sl[6]=8286; /* line # 8286 */
    ((SL *)Rv5)[18]=0;
    Ra.sl[6]=8287; /* line # 8287 */
    ((SL *)Rv5)[19]=0;
    Ra.sl[6]=8288; /* line # 8288 */
    ((SL *)Rv5)[20]=0;
    Ra.sl[6]=8289; /* line # 8289 */
    ((V *)Rv5)[11]=NULL;
    Ra.sl[6]=8290; /* line # 8290 */
    ((V *)Rv5)[12]=NULL;
    Ra.sl[6]=8291; /* line # 8291 */
    if (Rv0) ((UB *)Rv5)[104]=6;
    else {
      Ra.sl[6]=8292; /* line # 8292 */
      ((UB *)Rv5)[104]=5;
    }
    Ra.sl[6]=8294; /* line # 8294 */
    ((V *)Rv5)[14]=NULL;
    Ra.sl[6]=8295; /* line # 8295 */
    ((V *)Rv5)[15]=NULL;
    Ra.sl[6]=8296; /* line # 8296 */
    ((V *)Rv5)[16]=NULL;
    Ra.sl[6]=8297; /* line # 8297 */
    ((V *)Rv5)[17]=NULL;
    Ra.sl[6]=8298; /* line # 8298 */
    ((V *)Rv5)[18]=NULL;
    Ra.sl[6]=8299; /* line # 8299 */
    ((V *)Rv5)[19]=NULL;
    Ra.sl[6]=8300; /* line # 8300 */
    ((V *)Rv5)[20]=NULL;
    Ra.sl[6]=8301; /* line # 8301 */
    ((V *)Rv5)[21]=NULL;
    Ra.sl[6]=8302; /* line # 8302 */
    ((V *)Rv5)[22]=NULL;
    Ra.sl[6]=8303; /* line # 8303 */
    ((V *)Rv5)[23]=NULL;
    Ra.sl[6]=8304; /* line # 8304 */
    ((V *)Rv5)[24]=NULL;
    Ra.sl[6]=8306; /* line # 8306 */
    ((V *)Rv5)[25]=NULL;
    Ra.sl[6]=8307; /* line # 8307 */
    ((V *)Rv5)[26]=NULL;
    Ra.sl[6]=8308; /* line # 8308 */
    ((V *)Rv5)[27]=NULL;
    Ra.sl[6]=8309; /* line # 8309 */
    ((SL *)Rv5)[56]=-1;
    Ra.sl[6]=8310; /* line # 8310 */
    ((SL *)Rv5)[57]=0;
    Ra.sl[6]=8311; /* line # 8311 */
    ((SL *)Rv5)[58]=0;
    Ra.sl[6]=8312; /* line # 8312 */
    ((SL *)Rv5)[59]=0;
    Ra.sl[6]=8313; /* line # 8313 */
    ((SL *)Rv5)[60]=0;
    Ra.sl[6]=8314; /* line # 8314 */
    ((UB *)Rv5)[244]=0;
    Ra.sl[6]=8317; /* line # 8317 */
    V_pas_main=Rv2;
    Ra.sl[6]=8318; /* line # 8318 */
    P_insymbol();
    Ra.sl[6]=8319; /* line # 8319 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=8321; /* line # 8321 */
      V_sy_sym.ub[0]=17;
      Ra.sl[6]=8322; /* line # 8322 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[6]=8324; /* line # 8324 */
        P_insymbol();
        Ra.sl[6]=8325; /* line # 8325 */
        if (V_sy_sym.ub[0]==0) P_insymbol();
        else {
          Ra.sl[6]=8326; /* line # 8326 */
          P_src_error(Rd.s+1373,95,1);
        }
      }
      Ra.sl[6]=8328; /* line # 8328 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=8329; /* line # 8329 */
        P_src_error(Rd.s+1373,23,2);
      }
    }
    Ra.sl[6]=8331; /* line # 8331 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=8332; /* line # 8332 */
      P_src_error(Rd.s+1373,21,2);
    }
    Ra.sl[6]=8336; /* line # 8336 */
    if (V_env_first!=NULL) P_pas_read_env_file();
    Ra.sl[6]=8338; /* line # 8338 */
    if (V_cmp_debugopt) {
      Ra.sl[6]=8340; /* line # 8340 */
      V_cmp_debug=1;
      Ra.sl[6]=8341; /* line # 8341 */
      V_cmp_traceopt=1;
    }
    Ra.sl[6]=8344; /* line # 8344 */
    if (V_cmp_traceopt>0) {
      Ra.sl[6]=8346; /* line # 8346 */
      P_gen_cntxvar(Rv2,((V *)Rv6)[0]);
      Ra.sl[6]=8347; /* line # 8347 */
      V_cmp_trace=V_cmp_traceopt;
      Ra.sl[6]=8348; /* line # 8348 */
      Rv7=5;
    }
    else {
      Ra.sl[6]=8350; /* line # 8350 */
      Rv7=0;
    }
    Ra.sl[6]=8352; /* line # 8352 */
    P_cmp_block(Rv2,1, Rv7);
    Ra.sl[6]=8354; /* line # 8354 */
    if (V_cmp_trace>0&&!Rv0) {
      Ra.sl[6]=8356; /* line # 8356 */
      Rv8=Rv2;
      Ra.sl[6]=8357; /* line # 8357 */
      P_gen_linetrace(Rv2,((V *)Rv8)+16,((V *)Rv8)+17,6);
    }
    Ra.sl[6]=8359; /* line # 8359 */
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else {
      Ra.sl[6]=8360; /* line # 8360 */
      P_src_error(Rd.s+1373,54,2);
    }
    Ra.sl[6]=8361; /* line # 8361 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=8363; /* line # 8363 */
      if (V_sy_sym.ub[0]==0&&P_match(((V *)Rv6)[0],V_sy_ident.s)==0) {
        Ra.sl[6]=8364; /* line # 8364 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=8366; /* line # 8366 */
        P_src_error_s(Rd.s+1373,96,1, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[6]=8368; /* line # 8368 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else {
      Ra.sl[6]=8369; /* line # 8369 */
      P_src_error(Rd.s+1373,21,1);
    }
    Ra.sl[6]=8370; /* line # 8370 */
    if (V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=8372; /* line # 8372 */
      P_src_error(Rd.s+1373,991,1);
      Ra.sl[6]=8373; /* line # 8373 */
      while (V_sy_sym.ub[0]!=88)
      P_insymbol();
    }
    else {
      Ra.sl[6]=8375; /* line # 8375 */
      P_src_end_of_line();
    }
    Ra.sl[6]=8376; /* line # 8376 */
    if (V_pro_last==NULL) V_pro_first=Rv2;
    else {
      Ra.sl[6]=8377; /* line # 8377 */
      ((V *)V_pro_last)[0]=Rv2;
    }
    Ra.sl[6]=8378; /* line # 8378 */
    V_pro_last=Rv2;
    Ra.sl[6]=8381; /* line # 8381 */
    if (V_error_result>1) {
      Ra.sl[6]=8382; /* line # 8382 */
      V_emergency_stop=1;
    }
    else {
      Ra.sl[6]=8385; /* line # 8385 */
      Rv9=Rv2;
      Ra.sl[6]=8386; /* line # 8386 */
      if (((V *)Rv9)[16]!=((V *)Rv9)[17]) {
        Ra.sl[6]=8388; /* line # 8388 */
        P_lgt_new(((V *)Rv9)+16,NULL,0,((V *)Rv9)[16]);
        Ra.sl[6]=8389; /* line # 8389 */
        ((UB *)((V *)Rv9)[16])[41]=2;
        Ra.sl[6]=8390; /* line # 8390 */
        ((V *)Rv9)[17]=((V *)Rv9)[16];
      }
      Ra.sl[6]=8392; /* line # 8392 */
      PAS_COMILER_cmp_pass2(Rv2);
    }
    Ra.sl[6]=8395; /* line # 8395 */
    if (V_cmp_macf) {
      Ra.sl[6]=8397; /* line # 8397 */
      P_lgt_dump_static(Rv2);
      Ra.sl[6]=8398; /* line # 8398 */
      P_lst_page();
    }
    Ra.sl[6]=8401; /* line # 8401 */
    if (V_error_result>1) V_emergency_stop=1;
    else {
      Ra.sl[6]=8404; /* line # 8404 */
      P_pas_write_env_file();
      Ra.sl[6]=8405; /* line # 8405 */
      P_generate_code_p2();
    }
  }
  Ra.sl[6]=8409; /* line # 8409 */
  Ret=V_error_result;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
