%pragma trace 1;
{
             *****  CPAS Portable Shell  *******

*************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*               C P A S   P O R T A B L E   S H E L L                   *
*                       ( Main Source File )                            *
*                                by                                     *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 www.pierre.wolfers.fr                                 *
*                                             FRANCE.                   *
*                                                                       *
*                                                                       *
*        Portable CPAS SHELL -  Version V1.7B -  31-JUL-2019            *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                Global Public License (GPL)                          //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}


program Cpas_Shell;
{ Portable Shell Program }


%include 'PASSRC:cpascal_path_env.pas';         { Include the pascal environment Path definitions }


{ We load the Source file environment }
%include 'PASSRC:cpas_shell_base_env.pas';      { Get the common shell definitions }



const
  cpsh_name   = ' CPSH';                        { Define the CPAS SHELL Name for Common Message }
  cpsh_heading= 'CPas-SHell V1.7-B of the 31-JUL-2019';
  cpsh_deflst = '';                             { Define the default listing file as standard output }
  cpsh_errfile= 'cpsh.err';                     { Define the source error message file }
  cpsh_prompt = ' cpsh>';                       { Define the Shell prompt }

  cpsh_defsrc = 'cpsh_std_env.cpsh_init';       { Define the Initial Script file }




{ ******************************************************************** }
{ ***********     Types to get and parse a CPSH command   ************ }
{ ******************************************************************** }

type



      {*******************************}
      { keyword information Structure }
      {*******************************}




{ ******************************************************************** }
{ ***********  Variables to get and parse a SHELL command  *********** }
{ ******************************************************************** }

var

  ier:        integer;          { General error code }


     {************************************************}
     { Title and Subtitle Listing of source managment }
     {************************************************}




procedure SET_SPECIFIC_SYMBOL( procedure SET_KWD( in_var kname: string;
                                                           skw: symbol;
                                                          opkw: wennum;
                                                           ske: symbol:=nothing) );
begin { To Define all specific Key-Words }
  { *** Empty Procedure, There are No specific statement for cpsh *** }
end SET_SPECIFIC_SYMBOL;



procedure DEFINE_SPECIFIC_ENTRY( procedure DEF_ENTRY( in_var nam: string;
                                                             knd: ide_kinds;
                                                             fnc: ide_bltfnc;
                                                             npa1: integer;
                                                             npa2: integer := -1 ) );
begin { To Define all specific built_in entries }
end DEFINE_SPECIFIC_ENTRY;




procedure MANAGE_SPECIFIC_SYMBOL( spc_sym: wennum );
begin { To manage the specific statement }
  { *** Empty Procedure, There are No specific statement for cpsh *** }
end MANAGE_SPECIFIC_SYMBOL;



procedure EXECUTE_SPECIFIC_ENTRY( npa: integer; fnc: wennum );
{ npa = number of effective parameter(s), fnc = the function specification }
begin
end EXECUTE_SPECIFIC_ENTRY;


{*********************************************************************************************}



%chaine 'PASSRC:cpas_shell_base.pas';      { Chaine to the common interpreter code }


{*********************************************************************************************}
