/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 96 ) = {{
  5,   5, 108, 105, 112, 111, 119,  85,  85,  47, 114, 117, 110,  47, 109, 101,
100, 105,  97,  47, 112, 105, 101, 114, 114, 101,  47,  83,  83,  68,  95,  83,
 97, 118, 101,  45,  50,  47,  83, 111, 102, 116,  95,  78, 101, 119, 115,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  50,  47,  99,
112,  97, 115,  95,  95, 108, 105, 112, 111, 119,  46, 112,  97, 115,   0,   0
}};




/* Procedure/Function : " lipow "  */
SQ PAS__LIPOWER(SQ F_z, SQ F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SQ Rv0;
  register int Rgi;
  register SQ Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=60; /* line # 60 */
  if (F_n<0) {
    if (F_z==1) Rv0=1;
    else Rv0=0;
  }
  else {
    Rv0=1;
    Ra.sl[6]=65; /* line # 65 */
    while (F_n>0)
    if (F_n&1) {
      F_n=F_n-1;
      Rv0=Rv0*F_z;
    }
    else {
      Ra.sl[6]=72; /* line # 72 */
      F_n=F_n/2;
      F_z=F_z*F_z;
    }
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
