{ %pragma listlvl:2; }
{
 *************************************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                      MMM    MMM   XXX      XXX  DDDDDDDD              *
 *                      MMMM  MMMM    XXX    XXX   DDDDDDDDDD            *
 *                      MM MMMM MM     XXX  XXX    DD      DDD           *
 *                      MM  MM  MM      XXXXXX     DD       DD           *
 *                      MM      MM       XXXX      DD       DD           *
 *        T  H  E       MM      MM       XXXX      DD       DD           *
 *                      MM      MM      XXXXXX     DD       DD           *
 *                      MM      MM     XXX  XXX    DD      DDD           *
 *                      MM      MM    XXX    XXX   DDDDDDDDDD            *
 *                     MMMM    MMMM  XXX      XXX  DDDDDDDD              *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *              SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M              *
 *             S       Y   Y  S         T    E      MM   MM              *
 *             S        Y Y   S         T    E      M M M M              *
 *              SSSS     Y     SSSS     T    EEEEE  M  M  M              *
 *                  S    Y         S    T    E      M     M              *
 *                  S    Y         S    T    E      M     M  ..          *
 *             SSSSS     Y    SSSSS     T    EEEEEE M     M  ..          *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                        P. WOLFERS Software                            *
 *                                                                       *
 *                  Laboratoire de Cristallographie                      *
 *                                                                       *
 *                         B.P. 166 C.N.R.S.                             *
 *                                                                       *
 *                      25 Avenue des Martyrs                            *
 *                                                                       *
 *                      F 38042 GRENOBLE CEDEX 9                         *
 *                                                                       *
 *                                                                       *
 *************************************************************************

 /////////////////////////////////////////////////////////////////////////
 //                                                                     //
 //                    General Public License                           //
 //                                                                     //
 // This file is part of the V C++ GUI Framework, and is covered        //
 // under the terms of the GNU Library General Public License,          //
 // Version 2. This library has NO WARRANTY. See the source file        //
 // vapp.cxx for more complete information about license terms.         //
 //                                                                     //
 // This license described in this file overrides all other licenses    //
 // that might be specified in other files for this library.            //
 //                                                                     //
 // This library is free software; you can redistribute it and/or       //
 // modify it under the terms of the GNU Lesser General Public          //
 // License as published by the Free Software Foundation; either        //
 // version 2.1 of the License, or (at your option) any later version.  //
 //                                                                     //
 // This library is distributed in the hope that it will be useful,     //
 // but WITHOUT ANY WARRANTY; without even the implied warranty of      //
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
 // Library General Public License for more details.                    //
 //                                                                     //
 // You should have received a copy of the GNU Lesser General Public    //
 // License along with this library (see COPYING.LIB); if not, write to //
 // the Free Software Foundation :                                      //
 //                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
 //                                                                     //
 /////////////////////////////////////////////////////////////////////////
}

{
  ************************************************************************
  *                                                                      *
  *                                                                      *
  *               M X D   S A T E L L I T E   H A N D L E R              *
  *                                                                      *
  *                                                                      *
  *                                                                      *
  *            To read string and number for command analysis            *
  *                                                                      *
  *                                                                      *
  *                    Version 1.1-D of  20-Oct-2010                     *
  *                                                                      *
  *                                                                      *
  *                                                                      *
  *                                                                      *
  ************************************************************************
}

{ To Insert in the user program : }
module SATELLITE( input, output );


%include 'MXDSRC:satellite_env';




{****************************************************}
{*   Satellite Environment Variables Definitions    *}
{****************************************************}

[global]
var
  inp_prompt,                                 { The Main input Prompt }
  inp_prompt2,                                { The Specified Input Prompt }
  inp_string,                                 { String to read (if inp_string_flg) }
  inpf,                                       { The input file specification }
  outf:           lstring;                    { The output file specification }

  inp_string_flg,                             { Input in a string flag }
  inp_file_req,                               { Input mode false/true for open requested cmd_file }
  inp_file_flg,                               { Input mode false/true for cmd_line/file }
  out_file_flg:   boolean := false;           { Output mode false/true for std output/file }

  inp_ch:         char := ' ';                { Last input char }
  inp_symb:       symb_type := sy_eoln;       { Type of Last symbol }
  inp_ident:      ide_name;                   { Last input symbol }
  inp_code:       integer;                    { The current identifier command code }
  inp_str:        lstring;                    { Last input string }
  inp_real:       real;                       { Last input floatting number }
  inp_string_idx,                             { Index for string input }
  inp_int:        integer;                    { Last input integer }

  inp_csmbtb:     cmd_stbptr := nil;          { Current symbol table pointer }

  out_ellist:     ellist_ty;                  { Output List }
  out_frmstr:     str_ptr    := nil;          { Pointer to the current format string }
  out_list_sz:    integer    :=   0;          { Used size of output list }

  inp_file,                                   { Input file when used }
  out_file:       text;                       { Output file when used }





{********************************************************************}
{*          Satellite Environment Read Directive Procedures         *)
{********************************************************************}


[global 'GS_ERROR_IDE']
procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] ide_name );
begin
  WRITELN;
  WRITE( ' *** Gen_Space Error (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm.str:parm.len, '".' );
  PASCAL_EXIT( 2 )
end ERROR;



[global 'GS_ERROR_STR']
procedure ERROR( in_var mdnam, msg: string; in_var parm: [optional] string );
begin
  WRITELN;
  WRITE( ' *** Gen_Space Error (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm, '".' );
  PASCAL_EXIT( 2 )
end ERROR;



[global 'GS_WARNING_IDE']
procedure WARNING( in_var mdnam, msg: string; in_var parm: [optional] ide_name );
begin
  WRITELN;
  WRITE( ' *** Gen_Space Warning (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm.str:parm.len, '".' )
end WARNING;



[global 'GS_WARNING_STR']
procedure WARNING( in_var mdnam, msg: string; in_var parm: [optional] string );
begin
  WRITELN;
  WRITE( ' *** Gen_Space Warning (', mdnam, ') : ', msg );
  if parm"address = nil then WRITELN( '. ***' )
                        else WRITELN( ' "', parm, '".' )
end WARNING;



[global]
function IDE_MATCH( in_var id1, id2: ide_name ): boolean;
var
  i: integer;

begin
  if id1.len = id2.len then
  begin
    i := 1;
    while (i <= id1.len) and (id1.str[i] = id2.str[i]) do i := i + 1;
    IDE_MATCH := (i > id1.len)
  end
  else IDE_MATCH := false
end IDE_MATCH;



[global 'GS_ISEARCH_STR']
function IDE_SEARCH( in_var idetab: array[sz: integer] of ide_name;
                     in_var id: string ): integer;
var
  ide: ide_name;
  i: integer;

begin
  i := id.length;
  if i > max_lid then i := max_lid;
  while id[i] <= ' ' do i := i - 1;
  if i > 0 then
  begin
    ide.len := i;
    while i > 0 do begin  ide.str[i] := id[i]; i := i - 1  end;
    i := 1;
    while (i <= sz) and not IDE_MATCH( idetab[i], ide ) do i := i + 1;
    if i > sz then IDE_SEARCH := 0
              else IDE_SEARCH := idetab[i].cod
  end
  else IDE_SEARCH := 0
end IDE_SEARCH;



[global 'GS_ISEARCH_IDE1']
function IDE_SEARCH( in_var idetab: cmd_smbtb;
                     in_var ide: ide_name ): integer;
var
  i: integer;

begin
  i := 1;
  while (i <= idetab.sz) and not IDE_MATCH( idetab[i], ide ) do
    i := i + 1;
  if i > idetab.sz then IDE_SEARCH := 0
                   else IDE_SEARCH := idetab[i].cod
end IDE_SEARCH;



[global 'GS_ISEARCH_IDE']
function IDE_SEARCH( in_var idetab: array[sz: integer] of ide_name;
                     in_var ide: ide_name ): integer;
var
  i: integer;

begin
  i := 1;
  while (i <= sz) and not IDE_MATCH( idetab[i], ide ) do
    i := i + 1;
  if i > sz then IDE_SEARCH := 0
            else IDE_SEARCH := idetab[i].cod
end IDE_SEARCH;





[global]
procedure INSYMBOL;

type
  ch_type = ( eos, eol, ctl,                          {  EOF, EOLN, <all control character }
              oth, dig, let, quo,                     { other char, digit, letter and assim., "'"  '"' }
              dif, lpa, rpa, lbr, rbr,                { '#', '(', ')', '[', ']', }
              lac, rac,                               (* '{', '}' *)
              oor, oan, oad, osu, omu, odi, opw,      { '!' or '|', '&', '+', '-', '*', '/', '^' }
              oeq, olt, ogt,                          { '=', '<', '>' }
              scm, spe, s2p, ssc, sas                 { ',', '.', ':', '\' }
            );

  ch_tab_ty  = array[CHR(0)..CHR(127)] of ch_type;


var
  ch_tab: [static] ch_tab_ty := (
         { 0    1    2    3    4    5    6    7 }     {  Meaning with XON=DC1, XOFF=DC3, SP=' '  }
  { 000 } eos, eol, ctl, ctl, ctl, ctl, ctl, ctl,     {  NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL  } 
  { 010 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {   BS,  HT,  LF,  VT,  FF,  CR,  SO,  SI  } 
  { 020 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB  } 
  { 030 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  CAN,  EM, SUB, ESC,  FS,  GS,  RS,  US  } 
  { 040 } oth, oor, quo, dif, let, let, oan, quo,     {  ' ', '!', '"', '#', '$', '%', '&', "'"  } 
  { 050 } lpa, rpa, omu, oad, scm, osu, spe, odi,     {  '(', ')', '*', '+', ',', '-', '.', '/'  } 
  { 060 } dig, dig, dig, dig, dig, dig, dig, dig,     {  '0', '1', '2', '3', '4', '5', '6', '7'  }
  { 070 } dig, dig, s2p, ssc, olt, oeq, ogt, oth,     {  '8', '9', ':', ';', '<', '=', '>', '?'  }
  { 100 } let, let, let, let, let, let, let, let,     {  '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G'  }
  { 110 } let, let, let, let, let, let, let, let,     {  'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'  }
  { 120 } let, let, let, let, let, let, let, let,     {  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W'  }
  { 130 } let, let, let, lbr, sas, rbr, opw, let,     {  'X', 'Y', 'Z', '[', '\', ']', '^', '_'  }
  { 140 } oth, let, let, let, let, let, let, let,     {  '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g'  }
  { 150 } let, let, let, let, let, let, let, let,     {  'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o'  }
  { 160 } let, let, let, let, let, let, let, let,     {  'p', 'q', 'r', 's', 't', 'u', 'v', 'w'  }
  { 170 } let, let, let, lac, oor, rac, oth, ctl);    (* 'x', 'y', 'z', '{', '|', '}', '~', DEL *)

var
  iv, id, nd: integer;
  rd, rf, rv: double;
  bok,  bnc:  boolean;

  quot, cmin: [static] char;
  chcat:      [static] ch_type;


  procedure INP_GETCH_IN_FILE( var f: text );
  {Procedure to get One character from the input stream }
  begin
    if inp_string_flg then
      if inp_string_idx <= inp_string.length then
      begin
        inp_ch := inp_string[inp_string_idx];
        inp_string_idx := inp_string_idx + 1
      end
      else inp_ch := CHR( 0 )
    else
      if EOF( f ) then inp_ch := CHR( 0 )
      else
        if EOLN( f ) then
        begin  GET( f ); chcat := eol; inp_ch := CHR( 1 )  end
        else
        begin
          inp_ch := f^; GET( f );
          if inp_ch <= ' ' then inp_ch := ' '
        end
  end INP_GETCH_IN_FILE;


  procedure INP_GETCH;
  begin
    if inp_file_flg then
      INP_GETCH_IN_FILE( inp_file )
    else
    begin
      if UFB( input ) then
        if inp_prompt2.length > 0 then WRITE( output, inp_prompt2 )
                                  else WRITE( output, inp_prompt );
      INP_GETCH_IN_FILE( input )
    end;
    chcat := ch_tab[inp_ch];
    if (inp_ch >= 'A') and (inp_ch <= 'Z') then
      cmin := CHR( ORD( inp_ch ) + (ORD( 'a' ) - ORD( 'A' )) )
    else
      cmin := inp_ch
  end INP_GETCH;




begin { INSYMBOL }
  bnc := true;                                { Assume: we must read the next character }
  while inp_ch = ' ' do INP_GETCH;            { Skip any space character }
  repeat
    bok := true;                              { Assume stop to read (important for comments) }
    case chcat of
      dif: { # : Line of End of the line as a Comment }
        begin
          while (chcat <> eos) and (chcat <> eol) do INP_GETCH;
          if chcat <> eos then
          repeat
            INP_GETCH; { Skip to next not spacing character }
          until inp_ch <> ' ';
          bok := false
        end;

      lac: (* "{ ... }" Comment in text can be on many lines *)
        begin
          while (chcat <> eos) and (chcat <> rac) do INP_GETCH;
          if chcat <> eos then
          repeat
            INP_GETCH; { Skip to next not spaing character }
          until inp_ch <> ' ';
          bok := false
        end;

      quo: { String Quote }
        begin
          inp_str.length := 0;                { Clear the string variable }
          quot := inp_ch;                     { Keep the memory of quote character }
          loop
            INP_GETCH;
          exit if chcat = eos;                { Stop on end of file }
            if chcat = eol then
              INP_GETCH;                      { Ignore any eoln }
            if inp_ch = quot then             { On a Quote character }
            begin
              INP_GETCH;                      { Get the next one }
          exit if inp_ch <> quot              { Unique Quote => End of String }
              { Double quote => Insert one quote in string }
            end;
            if inp_str.length < inp_str.capacity then
              inp_str.length := inp_str.length + 1;   { Check for string overflow }
            inp_str[inp_str.length] := inp_ch
          end;
          inp_symb := sy_str;                 { We have found a string }
          bnc := false                        { The next character is already got }
        end;

      let: { Alpha character => Identifier }
        with inp_ident do
        begin
          len := 0;                           { Clear the current identifier name }
          repeat
            if len < max_lid then             { Check for string overflow }
              len := len + 1;
            str[len] := cmin;
            INP_GETCH;                        { Get the next character }
          until ((chcat <> let) and (chcat <> dig)) or (len >= max_lid);
          inp_symb := sy_ident;
          bnc := false;                       { The next character is already got }
          if inp_csmbtb <> nil then
            inp_code := IDE_SEARCH( inp_csmbtb^, inp_ident )
          else
            inp_code := 0
        end;

      dig, spe: { Figures character }
        begin
          rv := 0.0; rf := 1.0; nd := 0;
          inp_symb := sy_int;                 { Assume to be an integer }
          while chcat = dig do
          begin
            id := ORD( inp_ch ) - ORD( '0' ); { Get the figure value }
            if id = 0 then nd := nd + 1       { Count of zero at left of decimal period }
                      else nd := 0;           { ... to allow to use the integer exponentiel form }
            rv := rv*10.0 + id;               { Form the integer part of the number }
            INP_GETCH                         { Get the next character }
          end;
          if chcat = spe then
          begin
            nd := 0;                          { Eliminate the integer kind of number }
            INP_GETCH;
            inp_symb := sy_real;              { Set to be a real (floatting number) }
            while chcat = dig do
            begin
              id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
              rf := rf*0.1;
              rv := rv + id*rf;               { Form the decimal part of the number }
              INP_GETCH                       { Get the next character }
            end
          end;
          if cmin = 'e' then
          begin
            INP_GETCH;                        { Gobble up the Exponant character }
            iv := 0;                          { Prepare the exponant read }
            rd := 10.0;
            if (inp_ch = '+') or (inp_ch = '-') then
            begin                             { Manage the exponant signe }
              if inp_ch = '-' then rd := 0.1;
              INP_GETCH
            end;
            while chcat = dig do
            begin
              id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
              iv := iv*10 + id;               { Form the exponant value }
              INP_GETCH                       { Get the next character }
            end;
            rf := 1.0;
            while iv <> 0 do                  { Form rf = rd**iv }
              if ODD( iv ) then
              begin  iv := iv - 1; rf := rf*rd  end
              else
              begin  iv := iv div 2; rd := SQR( rd )  end;
            { Set as impossible value for integer when exponent is < -nd }
            if nd - iv < 0 then inp_symb := sy_real;
            rv := rv*rf                       { Finish to form the Real Number }
          end;
          { Set the integer value when it is possible }
          if (rv <= double( integer"last )) and
             (rv >= double( integer"first )) then iv := ROUND( rv )
          else begin  iv := 0; inp_symb := sy_real  end;
          inp_real := rv; inp_int := iv;
          bnc := false                        { The next character is already got }
        end;

      oor: inp_symb := sy_or_op;
      oan: inp_symb := sy_and_op;
      oad: inp_symb := sy_add_op;
      osu: inp_symb := sy_sub_op;
      omu: begin
             INP_GETCH;
             if chcat = omu then inp_symb := sy_power_op
                            else begin  inp_symb := sy_mul_op; bnc := false  end
           end;
      odi: inp_symb := sy_div_op;
      opw: inp_symb := sy_power_op;
      oeq: inp_symb := sy_eq_op;
      olt: begin
             INP_GETCH;
             if chcat = ogt then inp_symb := sy_ne_op
             else if chcat = oeq then inp_symb := sy_le_op
                                 else begin  inp_symb := sy_lt_op; bnc := false  end
           end;
      ogt: begin
             INP_GETCH;
             if chcat = oeq then inp_symb := sy_ge_op
                            else begin  inp_symb := sy_gt_op; bnc := false  end
           end;
      lbr: inp_symb := sy_lbra;
      rbr: inp_symb := sy_rbra;
      lpa: inp_symb := sy_lpar;
      rpa: inp_symb := sy_rpar;

      scm: inp_symb := sy_comma;
      s2p: inp_symb := sy_colon;
      ssc: inp_symb := sy_semicolon;
      sas: inp_symb := sy_antislash;

      eol: begin
             inp_ch := ' '; cmin := ' '; bnc := false; 
             inp_symb := sy_eoln
           end;

      eos: begin
             if TTY_CLR_EOF( input ) and UFB( input ) then
             begin
               inp_ch := CHR( 1 ); chcat := eol;
               cmin   := CHR( 1 );   bnc := false
             end;
             inp_symb := sy_eof
           end;

    otherwise
      WRITELN( ' *** Gen_Space : Illegal char :', inp_ch, ' in input.' );
      INP_GETCH;
      inp_symb := sy_illegal
    end
  until bok;
  if bnc then INP_GETCH                       { Get the next character when required }
end INSYMBOL;


[global]
procedure SKIP_SYMBOL( ts: symb_type );
var
  ps: symb_type := sy_illegal;

begin
  while (inp_symb <> sy_eof) and (inp_symb <> ts) do
  begin
    case ts of
      sy_lpar:      SKIP_SYMBOL( sy_rpar );
      sy_lbra:      SKIP_SYMBOL( sy_rbra );
      sy_eoln:      if ts = sy_semicolon then EXIT;
      sy_semicolon: if (ts = sy_rpar) or (ts = sy_rbra) then EXIT;
    otherwise
    end;
    ps := ts;
    INSYMBOL;
    if ps = sy_comma and inp_symb = sy_eoln then INSYMBOL { Ignore EOLN just after comma }
  end
end SKIP_SYMBOL;



[global]
procedure INP_INQUIRE( in_var name: string );
begin
  while inp_symb = sy_eoln do
  begin
    inp_prompt2 := name;
    INSYMBOL;
    inp_prompt2.length := 0
  end
end INP_INQUIRE;



[global]
procedure INP_R_VALUE( in_var name: string; var rv: real );
var
  num: integer;
  rvl: real;
  bdo, bng, bin: boolean;

begin
  bdo := false;
  bng := false;
  bin := true;
  INP_INQUIRE( name );
  repeat
    case inp_symb of
      sy_add_op: ;

      sy_sub_op: bng := not bng;

      sy_int:    begin { Integer or Fraction }
                   num := inp_int;
                   INSYMBOL;
                   if inp_symb = sy_div_op then
                   begin { It is a fraction }
                     INSYMBOL;
                     if inp_symb <> sy_int then
                       ERROR( 'RVAL', 'Illegal fraction : Expected form <int>/<int>' );
                     rvl := num/inp_int;
                     bdo := true
                   end
                   else 
                   begin { it is not a fraction }
                     rvl := num; bdo := true;
                     bin := false
                   end;
                   if bng then rv := - rvl
                          else rv :=   rvl
                 end; 

      sy_real: begin
                 bdo := true;
                 if bng then rv := - inp_real
                        else rv :=   inp_real
               end;

      sy_colon, sy_comma, sy_semicolon, sy_eoln:
               begin
                 bin := false;                { Never skip the separator }
                 bdo := true                  { We keep the initial rv value }
               end;
    otherwise
      ERROR( 'RVAL', 'Illegal separator.' )
    end;
    if bin then INSYMBOL
  until bdo or (inp_symb = sy_eof)
end INP_R_VALUE;



[global]
procedure INP_I_VALUE( in_var name: string; var iv: integer );
var
  rvl: real;
  bdo, bng, bin: boolean;

begin
  bdo := false;
  bng := false;
  bin := true;
  INP_INQUIRE( name );
  repeat
    case inp_symb of
      sy_add_op: ;

      sy_sub_op: bng := not bng;

      sy_int:    begin { Integer or Real }
                   if bng then iv := - inp_int
                          else iv :=   inp_int;
                   bdo := true
                 end;
 
      sy_real:   if (inp_real <= integer"last) or
                    (inp_real >= integer"first) then
                 begin
                   if bng then iv := - inp_real
                          else iv :=   inp_real;
                   WARNING( 'IVAL', 'Round of Floatting Value to Integer.' );
                   bdo := true
                 end
                 else
                   ERROR( 'IVAL', 'Floatting Magnitude to Large for Integer Conversion.' );

      sy_colon, sy_comma, sy_semicolon, sy_eoln:
               begin
                 bin := false;                { Never skip the separator }
                 bdo := true                  { We keep the initial rv value }
               end;
    otherwise
      ERROR( 'IVAL', 'Illegal separator.' )
    end;
    if bin then INSYMBOL
  until bdo or (inp_symb = sy_eof)
end INP_I_VALUE;



[global]
procedure INP_S_VALUE( in_var name: string; var str: string );
var
  bdo, bin: boolean;

begin
  bdo := false;
  bin := true;
  INP_INQUIRE( name );
  repeat
    case inp_symb of
      sy_str:  begin
                 if inp_str.length > str.capacity then
                   str.length := str.capacity
                 else
                   str.length := inp_str.length;
                 for i := 1 to str.length do
                   str[i] := inp_str[i];
                 bdo := true
               end;

      sy_colon, sy_comma, sy_semicolon, sy_eoln:
               begin
                 bin := false;                { Never skip the separator }
                 bdo := true                  { We keep the initial str value }
               end;
    otherwise
      ERROR( 'SVAL', 'Illegal separator.' )
    end;
    if bin then INSYMBOL
  until bdo or (inp_symb = sy_eof)
end INP_S_VALUE;



[global]
function INP_SEPAR( sep: symb_type ): boolean;
begin
  if inp_symb = sep then
  begin  INSYMBOL; INP_SEPAR := true  end
  else INP_SEPAR := false
end INP_SEPAR;




[global]
procedure INP_EXPRESSION( var fac, cte: real; var str: string );
const
  mdnam = 'EXPR';

var
  val: expr_rec;

  procedure EXP_DO_OPER( op: symb_type; var v1, v2: expr_rec );
  begin
    if ABS( v2.expr_fac ) > 1.0E-5 then
      if ABS( v1.expr_fac ) > 1.0E-5 then
      begin
        if ((op <> sy_add_op) and (op <> sy_sub_op)) or
            not IDE_MATCH( v1.expr_ide, v2.expr_ide ) then
          ERROR( mdnam, 'Illegal multi-symbol expression.', v2.expr_ide )
      end
      else
        v1.expr_ide := v2.expr_ide;

    case op of
      sy_add_op:
        begin
          v1.expr_cte := v1.expr_cte + v2.expr_cte;
          v1.expr_fac := v1.expr_fac + v2.expr_fac
        end;

      sy_sub_op:
        begin
          v1.expr_cte := v1.expr_cte - v2.expr_cte;
          v1.expr_fac := v1.expr_fac - v2.expr_fac
        end;

      sy_mul_op:
        begin
          v1.expr_cte := v1.expr_cte * v2.expr_cte;
          v1.expr_fac := v1.expr_fac * v2.expr_cte
        end;

      sy_div_op:
        if v2.expr_fac > 1.0E-5 then
          ERROR( mdnam, 'Illegal Division by the symbol', v2.expr_ide )
        else
          if ABS( v2.expr_cte ) < 1.0E-5 then
            ERROR( mdnam, 'Illegal Divide by a number close of 0.0' )
          else
          begin
            v1.expr_cte := v1.expr_cte/v2.expr_cte;
            v1.expr_fac := v1.expr_fac/v2.expr_cte
          end;

    otherwise
    end
  end EXP_DO_OPER;



  function EXP_ADDSUB: expr_rec;
  var
    v1, v2: expr_rec;
    op: symb_type;


    function EXP_MULDIV: expr_rec;
    var
      v1, v2: expr_rec;
      op: symb_type;

      function EXP_UNAOPE: expr_rec;
      var
        v: expr_rec := [ 0.0, 0.0, [0, 0, ' '] ];
        bn: boolean := false;

      begin { EXP_UNAOPE }
        while (inp_symb = sy_add_op) or (inp_symb = sy_sub_op) do
        begin
          if inp_symb = sy_sub_op then bn := not bn;
          INSYMBOL
        end;
        case inp_symb of
          sy_int,
          sy_real:
            begin  v.expr_cte := inp_real; INSYMBOL  end;
          sy_ident:
            begin  v.expr_fac := 1.0; v.expr_ide := inp_ident; INSYMBOL  end;
          sy_lpar:
            begin
              INSYMBOL;
              v := EXP_ADDSUB;
              if inp_symb = sy_rpar then INSYMBOL
              else
                ERROR( mdnam, 'Right parenthesys was expected.' )
            end;
        otherwise
          ERROR( mdnam, 'Illegal Expression operator or term.' )
        end;
        if bn then
        begin
          v.expr_cte := - v.expr_cte;
          v.expr_fac := - v.expr_fac  
        end;
        EXP_UNAOPE := v
      end EXP_UNAOPE;

    begin { EXP_MULDIV }
      v1 := EXP_UNAOPE;
      while (inp_symb = sy_mul_op) or (inp_symb = sy_div_op) do
      begin
        op := inp_symb; INSYMBOL;
        v2 := EXP_UNAOPE;
        EXP_DO_OPER( op, v1, v2 )
      end;
      EXP_MULDIV := v1
    end EXP_MULDIV;
 
  begin { EXP_ADDSUB }
    v1 := EXP_MULDIV;
    while (inp_symb = sy_add_op) or (inp_symb = sy_sub_op) do
    begin
      op := inp_symb; INSYMBOL;
      v2 := EXP_MULDIV;
      EXP_DO_OPER( op, v1, v2 )
    end;
    EXP_ADDSUB := v1
  end EXP_ADDSUB;

begin { INP_EXPRESSION }
  val := EXP_ADDSUB;
  with val do
  begin
    fac := expr_fac;
    cte := expr_cte;
    str := SUBSTR( expr_ide.str, 1, expr_ide.len )
  end
end INP_EXPRESSION;



[global]
function INP_LOOKSEMICOLON: boolean;
begin
  INP_LOOKSEMICOLON := (inp_symb = sy_semicolon) or (inp_symb = sy_eoln);
  if inp_symb = sy_semicolon then INSYMBOL
end INP_LOOKSEMICOLON;



[global]
procedure CHANGE_CASE( var s: string; bmaj: boolean := false; ibg, ind: integer := 0 );
{ Use to change the case of a string or a part of a string }
const
  shch = ORD( 'A' ) - ORD( 'a' );

var
  ch: char;

begin
  if (ind <= 0) or (ind > s.length) then ind := s.length;
  if ibg <= 0 then ibg := 1;
  for i := ibg to ind do
  begin
    ch := s[i];
    if bmaj then
    begin
      if (ch >= 'a') and (ch <= 'z') then s[i] := CHR( ORD( ch ) + shch )
    end
    else
      if (ch >= 'A') and (ch <= 'Z') then s[i] := CHR( ORD( ch ) - shch )
  end
end CHANGE_CASE;




{********************************************************************}
{*    Satellite Environment Formatted Write Directive Procedures    *)
{********************************************************************}

[global 'OUT_VALUE_IV']
procedure OUT_VALUE( iv: integer );
begin
  if out_list_sz < max_list then out_list_sz := out_list_sz + 1;
  with out_ellist[out_list_sz] do
  begin
    out_rty  := intty;
    out_intv := iv
  end
end OUT_VALUE;


[global 'OUT_VALUE_RV']
procedure OUT_VALUE( rv: real );
begin
  if out_list_sz < max_list then out_list_sz := out_list_sz + 1;
  with out_ellist[out_list_sz] do
  begin
    out_rty  := fltty;
    out_fltv := rv
  end
end OUT_VALUE;


[global 'OUT_VALUE_SV']
procedure OUT_VALUE( in_var str: string );
begin
  if out_list_sz < max_list then out_list_sz := out_list_sz + 1;
  with out_ellist[out_list_sz] do
  begin
    out_rty  := strty;
    out_strv := str"address
  end
end OUT_VALUE;


[global]
procedure FORMAT_VALUE( in_var frm: string; var ii, iv, jv: integer; var ch: char );
var
  bn: boolean;

begin
  iv := 0; jv := 0; bn := false;
  ch := frm[ii]; ii := ii + 1;
  while (ch = '-') and (ii < frm.length) do
  begin
    ch := frm[ii]; ii := ii + 1; bn := not bn
  end;
  while (ch >= '0') and (ch <= '9') and (ii <= frm.length) do
  begin
    iv := iv*10 + ORD( ch ) - ORD( '0' );
    ch := frm[ii]; ii := ii + 1
  end;
  if bn then iv := - iv;
  if ch = '.' then
  begin
    ch := frm[ii]; ii := ii + 1;
    bn := false;
    while (ch = '-') and (ii <= frm.length) do
    begin
      ch := frm[ii]; ii := ii + 1; bn := not bn
    end;
    while (ch >= '0') and (ch <= '9') and (ii <= frm.length) do
    begin
      jv := jv*10 + ORD( ch ) - ORD( '0' );
      ch := frm[ii]; ii := ii + 1
    end;
    if bn then jv := - jv
  end
end FORMAT_VALUE;



[global]
procedure FORMATTED_OUTPUT( var f: text; in_var frm: string;
                                nb0, nb1, nb2, nb3: integer := 0; oflg: boolean := false );
{ Write the text atxt in the file f as specified by the inserted
  format specification as defined here :

    Any character as copied on the output except the character "%" that is
  the format specification character.
   The acceptable format statements are:
     %%        - to print the single character "%",
     %<r>(     - to repeat the following part (until %) r times,
     %)        - to end a repeated sequence,
     %<f>x     - to insert <f> space,
     %<f>l     - to print (or skip) <f> line (default is 1),
     %<f>.<b># - to print nb0 or nb1, nb2, nb3 (in this order) [only when oflg is true],
     %<f>.<b>i - to print an integer number (~ I<f>) <b> can used to specify a base <> 10,
     %<f>.<d>v - or, 
     %<f>.<d>f - to print a floating number (~ F<f>.<d>),
     %<f>.<p>s - or,
     %<f>.<p>t - to print a string (~ A<f>) <p> = -1/0/1 for right/centre/left position.

  The formal parameters fmu, nst and nb are respectively the site multiplicity,
  and the number of equivalent sites in the positions, and the sequential
  integer site number. 
}
const
  max_repsp = 4;

type
  stk_rep = record
              ip, nc: byte
            end;

var
  ii, ij, ik, iv, ir, jv, sp, ia: integer;
  tk: array[1..max_repsp] of stk_rep;
  ch: char;
  bn: boolean;

begin
  ii := 1;
  ij := 1;
  ik := 0;
  sp := 0;
  ia := 0;
  repeat
    ch := frm[ii]; ii := ii + 1;
    if (ch = '%') and (ii <= frm.length) then
    begin { We have find the special character }
      FORMAT_VALUE( frm, ii, iv, jv, ch );
      if (ch >= 'A') and (ch <= 'Z') then
        ch := CHR( ORD( ch ) + (ORD( 'a' ) - ORD( 'A' )));
      case ch of
        ')': { End of Repeat }
             if sp > 0 then
             begin
               tk[sp].nc := tk[sp].nc - 1;
               if tk[sp].nc > 0 then ii := tk[sp].ip
                                else sp := sp - 1
             end;

        '(': { Begin Repeat }
             begin
               if sp < max_repsp then sp := sp + 1;
               tk[sp].ip := ii; tk[sp].nc := iv
             end;

        '%': { write the character "%" }
             WRITE( f, '%' );

        'l': { Print or skip <iv> line }
             repeat  WRITELN( f ); iv := iv - 1  until iv <= 0; 

        'x': { Print space(s) }
             WRITE( f, ' ':iv );

        '#': { Print an additional integer number }
             if oflg or (jv < 0) then
             begin
               jv := ABS( jv ); if (jv < 2) or (jv > 16) then jv := 10;
               case ia of
                 0: WRITE( f, nb0:iv:jv );
                 1: WRITE( f, nb1:iv:jv );
                 2: WRITE( f, nb2:iv:jv );
                 3: WRITE( f, nb3:iv:jv );
               end;
               ia := (ia + 1) mod 4
             end
             else WRITE( f, ' ':iv );

        'i': { Print an integer value }
             begin
  exit if ik >= out_list_sz;
               ik := ik + 1; WRITE( f, out_ellist[ik].out_intv:iv:jv );
             end;
 
        'f',
        'v': { Print a floatting value }
             begin
  exit if ik >= out_list_sz;
               ik := ik + 1; WRITE( f, out_ellist[ik].out_fltv:iv:jv );
             end;

        's',
        't': { Print a string (or text) value }
             begin
  exit if ik >= out_list_sz;
               ik := ik + 1; WRITE( f, out_ellist[ik].out_strv^:iv:jv );
             end;

      otherwise
      end
    end
    else
      WRITE( f, ch )
  until ii > frm.length;
  out_list_sz := 0;
  WRITELN( f )
end FORMATTED_OUTPUT;



{*****************************************************************************************}
{ End of Insertion : }
end SATELLITE.

