#
#       Makefile for pcmp (Pascal Compiler) on WINDOWS 95/NT and UNIX systems
#
#
CFLAGS	= -g
PAS	=	/usr/local/bin/pcmp -t1
INC	=	-I/usr/local/include
LIB	=	-L./ -L/usr/local/lib
#
OBJS = pcmp_ident.o pcmp_basdef.o pcmp_insymb.o pcmp_envinh.o\
	pcmp_lgt.o pcmp_dump.o pcmp_expr.o pcmp_comp.o pcmp_genc.o
#
install: pcmp_lib.a pcmp
#
pcmp_lib.a:$(OBJS)
	ar -r pcmp_lib.a $(OBJS)
#
pcmp: pcmp_main.pas pcmp_lib.a cpas_system_name_init.cpas
	$(PAS) -t+ pcmp_main
	$(CC) $(CFLAGS) $(INC) pcmp_main.c pcmp_lib.a libcpas.a -lm -o ./pcmp
#
pcmp_ident.c: pcmp_ident.pas
	$(PAS) -t+ pcmp_ident
#
pcmp_basdef.c: pcmp_basdef.pas
	$(PAS) -t+ pcmp_basdef
#
pcmp_insymb.c: pcmp_insymb.pas
	$(PAS) -t+ pcmp_insymb
#
pcmp_envinh.c: pcmp_envinh.pas
	$(PAS) -t+ pcmp_envinh
#
pcmp_lgt.c: pcmp_lgt.pas
	$(PAS) -t+ pcmp_lgt
#
pcmp_dump.c: pcmp_dump.pas
	$(PAS) -t+ pcmp_dump
#
pcmp_expr.c: pcmp_expr.pas
	$(PAS) -t+ pcmp_expr
#
pcmp_comp.c: pcmp_comp.pas
	$(PAS) -t+ pcmp_comp
#
pcmp_genc.c: pcmp_genc.pas
	$(PAS) -t+ pcmp_genc
#
#
clean:
	-rm pcmp*.c pcmp*.o  pcmp*.a
#
end:
