{%pragma cp_list_on;}
{
 *************************************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                      MMM    MMM   XXX      XXX  DDDDDDDD              *
 *                      MMMM  MMMM    XXX    XXX   DDDDDDDDDD            *
 *                      MM MMMM MM     XXX  XXX    DD      DDD           *
 *                      MM  MM  MM      XXXXXX     DD       DD           *
 *                      MM      MM       XXXX      DD       DD           *
 *        T  H  E       MM      MM       XXXX      DD       DD           *
 *                      MM      MM      XXXXXX     DD       DD           *
 *                      MM      MM     XXX  XXX    DD      DDD           *
 *                      MM      MM    XXX    XXX   DDDDDDDDDD            *
 *                     MMMM    MMMM  XXX      XXX  DDDDDDDD              *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *              SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M              *
 *             S       Y   Y  S         T    E      MM   MM              *
 *             S        Y Y   S         T    E      M M M M              *
 *              SSSS     Y     SSSS     T    EEEEE  M  M  M              *
 *                  S    Y         S    T    E      M     M              *
 *                  S    Y         S    T    E      M     M  ..          *
 *             SSSSS     Y    SSSSS     T    EEEEEE M     M  ..          *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                        P. WOLFERS Software                            *
 *                                                                       *
 *                  Laboratoire de Cristallographie                      *
 *                                                                       *
 *                         B.P. 166 C.N.R.S.                             *
 *                                                                       *
 *                      25 Avenue des Martyrs                            *
 *                                                                       *
 *                      F 38042 GRENOBLE CEDEX 9                         *
 *                                                                       *
 *                                                                       *
 *************************************************************************

 /////////////////////////////////////////////////////////////////////////
 //                                                                     //
 //                    General Public License                           //
 //                                                                     //
 // This file is part of the V C++ GUI Framework, and is covered        //
 // under the terms of the GNU Library General Public License,          //
 // Version 2. This program has NO WARRANTY. See the source file        //
 // vapp.cxx for more complete information about license terms.         //
 //                                                                     //
 // This license described in this file overrides all other licenses    //
 // that might be specified in other files for this library.            //
 //                                                                     //
 // This program is free software; you can redistribute it and/or       //
 // modify it under the terms of the GNU Lesser General Public          //
 // License as published by the Free Software Foundation; either        //
 // version 2.1 of the License, or (at your option) any later version.  //
 //                                                                     //
 // This software is distributed in the hope that it will be useful,    //
 // but WITHOUT ANY WARRANTY; without even the implied warranty of      //
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
 // Library General Public License for more details.                    //
 //                                                                     //
 // You should have received a copy of the GNU Lesser General Public    //
 // License along with this library (see COPYING.LIB); if not, write to //
 // the Free Software Foundation :                                      //
 //                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
 //                                                                     //
 /////////////////////////////////////////////////////////////////////////
}

program GEN_SPACE_GROUP( input, output );
{
  ***********************************************************
  *                                                         *
  *                                                         *
  *            G E N   S P A C E   G R O U P                *
  *                                                         *
  *                                                         *
  *                   P R O G R A M                         *
  *                                                         *
  *                                                         *
  *            Version 1.1-D -  20-OCT-2010                 *
  *                                                         *
  *                                                         *
  *   To generate the space group matrix from the name      *
  *             or number of space group.                   *
  *                                                         *
  *                                                         *
  *                                                         *
  ***********************************************************
}




{**********************************************}
{*   GEN_SPACE_GROUP constants Definitions    *}
{**********************************************}

const
  version   = 'V 1.1 C of 30-Sep-2009';       { Software Version }

  pi        = 4.0*ARCTAN( 1.0 );              { The pi number }
  inrd      = pi/180.0;                       { Factor to convert degrees in radians }

  max_str   = 128;                            { Maximum size of a string constant }

  help_file_spc = 'MXDLIB:gen_space.hlp';     { Help file specification }


  dtlabel   = 'Direct Metric Tensor';         { Labels for not data output of tensors and matrixs }
  rtlabel   = 'Reciprocal Metric Tensor';
  dmlabel   = 'Direct to Normalized Transformation Matrix';
  rmlabel   = 'Reciprocal to Normalized Transformation Matrix';

{ Include the satellite environment }
%include 'MXDSRC:satellite_env';



{**********************************************}
{*     GEN_SPACE_GROUP Types Definitions      *}
{**********************************************}

type


  grp_str   = string( 16 );                   { Define our type of string }



  %include 'MXDSRC:mxd_group_gen';



{**********************************************}
{*   GEN_SPACE_GROUP Variables Definitions    *}
{**********************************************}

var
  grp_ok:         boolean :=  true;           { Flag for correct data (false on error and stop) }
  grp_dten, grp_rten,                         { Direct and reciprocal metrci tensor output flags (from command line) }
  grp_dmat, grp_rmat,                         { Direct and reciprocal transformation matrix output flags (from command line) }
  grp_hkl,                                    { Flag for HKL List Generation }
  grp_poslstf,                                { Flag for Special Position List }
  grp_operf,                                  { Flag for output }
  grp_xyzf,                                   { Flag for general xyz output }
  grp_posf,                                   { Flag for position Evaluation }
  grp_symbf,                                  { Flag for Symbolic evaluation }
  grp_cvmod,                                  { Flag for Conversational mode }
  grp_addmod:     boolean := false;           { Flag for mode with additional directives }

  grp_pliststr,                               { Position List String Request }
  grp_posstr,                                 { Numeric Position string Request }
  grp_symbstr:    string( 255 );              { Symbolic Position string Request }

  hf:             text;                       { Help File }




{********************************************************************}
{*             GEN_SPACE_GROUP Commands Table definition            *)
{********************************************************************}

const
  cmdtab_sz = 35;


type
  cmd_namtypes = array[1..cmdtab_sz] of ide_name;

const
  fc_help    =  -1; fc_undef   =   0;
  fc_cell    =   1; fc_group   =   2;
  fc_org     =   3; fc_axis    =   4;
  fc_norm    =   5; fc_latt    =   6;
  fc_sxyz    =   7;
  fc_mtens   =   8; fc_rmtens  =   9;
  fc_tmd     =  10, fc_tmr     =  11;
  fc_oper    =  12; fc_o_cell  =  13;
  fc_data    =  14; fc_list    =  15;
  fc_gxyz    =  16;
  fc_posit   =  17; fc_poslist =  18;
  fc_ghkl    =  19; fc_wvect   =  20;
  fc_wvdel   =  21; fc_text    =  22;
  fc_wave    =  23;


  (* Remember: cmd_smbtb( sz: integer ) = array[1..sz] of ide_name; defined in "satellite_env.pas" *)

  cmd_table = cmd_smbtb[ cmdtab_sz,
                            [   fc_cell,  4,           'cell'],   { Get the Unit cell }
                            [  fc_group,  5,          'group'],   { Get the group name or group specifications }
                            [    fc_org, 14, 'origine_change'],   { Specify an origine translation }
                            [    fc_org,  3,            'org'],
                            [   fc_axis, 11,    'axis_change'],   { Specify an axis change (permutation only) }
                            [   fc_axis,  3,            'a_c'],
                            [   fc_norm, 14, 'set_normalized'],   { Specify output in Normalized Referential }
                            [   fc_norm,  3,            'nrm'],
                            [   fc_latt, 11,    'set_lattice'],   { Specify output in Lattice Referential }
                            [   fc_latt,  3,            's_l'],
                            [   fc_sxyz,  4,           'sxyz'],   { Output the symbolic equivalent atom positions }
                            [  fc_mtens, 13,  'metric_tensor'],   { Output the metric tensor of direct lattice }
                            [  fc_mtens,  3,            'm_t'],
                            [    fc_tmd, 10,     'dcell_to_w'],   { Output Direct cell to Work Space matrix }
                            [    fc_tmr, 10,     'rcell_to_w'],   { Output Reciprocal cell to Work Space matrix }
                            [ fc_rmtens, 14, 'metric_rtensor'],   { Output the reciporcal metric tensor of direct lattice }
                            [ fc_rmtens,  4,           'm_rt'],
                            [   fc_oper, 10,     'out_matrix'],   { Output the space group matrix operators }
                            [   fc_oper,  3,            'o_m'],
                            [   fc_oper,  8,       'operator'],   { Matrix operator list Required }
                            [ fc_o_cell,  8,       'out_cell'],   { Output the reciprocal unit cell }
                            [ fc_o_cell,  3,            'o_c'],
                            [   fc_data,  4,           'data'],   { Data format required }
                            [   fc_list,  4,           'list'],   { List format required }
                            [   fc_gxyz,  4,           'gxyz'],   { xyz (Symb. general Pos. Required }
                            [fc_poslist, 13,  'position_list'],   { Position List }
                            [fc_poslist,  3,            'p_l'],
                            [  fc_wvect,  9,      'wave_vect'],   { Wave Vector definition }
                            [  fc_wvdel, 12,   'rm_wave_vect'],   { Wave Vector remove }
                            [   fc_ghkl,  8,       'hkl_list'],   { To generate an hkl list }
                            [   fc_posit, 8,       'position'],   { Equivalent position are required }
                            [   fc_wave,  8,    'wave_length'],   { Specify a Wave length }
                            [   fc_text,  4,           'text'],   { To insert a given text }
                            [   fc_help,  4,           'help'],   { Output the help file text }
                            [   fc_help,  1,              'h'] ];




{********************************************************************}
{*                  GEN_SPACE_GROUP Init procedures                 *}
{********************************************************************}


procedure Version_Output( var f: text );
begin
    WRITELN( f );
    WRITELN( f, ' * * *  Current Gen_Space Program Version ', version, '  * * *' );
    WRITELN( f )
end Version_Output;



procedure OUTPUT_HELP;
const
  mdnam = 'HELP';

var
  filespc: string( 255 );
  out: text;

begin
  INSYMBOL;
  if inp_symb = sy_str then begin  filespc := inp_str; INSYMBOL  end
                       else filespc.length := 0;
  INP_LOOKSEMICOLON;
  OPEN( hf, help_file_spc, [read_file,error_file] );
  if iostatus <> 0 then
  begin
    ERROR( mdnam, ' Sorry, I can''t open the help file', help_file_spc );
    return
  end;

  if filespc.length > 0 then
  begin
    OPEN( out, filespc, [write_file,error_file] );
    if iostatus <> 0 then
    begin
      ERROR( mdnam, ' Sorry, I can''t open the output file', filespc );
      return
    end;
    VERSION_OUTPUT( out );
    repeat  out^ := hf^; GET( hf ); PUT( out )  until EOF( hf );
    CLOSE( hf ); CLOSE( out )
  end
  else
  begin
    VERSION_OUTPUT( output );
    repeat  output^ := hf^; GET( hf ); PUT( output )  until EOF( hf );
    CLOSE( hf )
  end
end OUTPUT_HELP;



procedure INIT;
const

  mdnam = 'INIT';

  opttab_sz = 32;
  c_file =  1;
  c_cell =  2;
  c_org  =  3;
  c_axis =  4;
  c_data =  5;
  c_oper =  6;
  c_gxyz =  7;
  c_pos  =  8;
  c_nrm  =  9;
  c_symb = 10;
  c_posl = 11;
  c_qvec = 12;
  c_ghkl = 13;
  c_wave = 14;
  c_dten = 15;
  c_rten = 16;
  c_dmat = 17;
  c_rmat = 18;
  c_help = -1;


type
  opt_namtypes = array[1..opttab_sz] of ide_name;

const
  opt_names = opt_namtypes[ [c_file, 2,   '-f'], [c_file, 4,    '-inp'],
                            [c_cell, 2,   '-c'], [c_cell, 5,   '-cell'],
                            [c_org,  4, '-org'], [c_org,  8,'-origine'],
                            [c_axis, 5,'-axis'], [c_axis, 7, '-repere'],
                            [c_data, 5,'-data'], [c_oper, 4,    '-ope'],
                            [c_gxyz, 5,'-gxyz'], [c_pos,  4,    '-pos'],
                            [c_nrm,  4, '-nrm'], [c_symb, 5,   '-sxyz'],
                            [c_posl, 5,'-posl'], [c_posl, 8,'-poslist'],
                            [c_qvec, 3,  '-qv'], [c_qvec, 8,'-qvector'],
                            [c_ghkl, 5,'-ghkl'], [c_ghkl, 7, '-hklist'],
                            [c_wave, 5,'-wave'], [c_wave, 2,      '-w'],
                            [c_dten, 5,'-dten'], [c_dten, 8,'-dtensor'],
                            [c_rten, 5,'-rten'], [c_rten, 8,'-rtensor'],
                            [c_dmat, 5,'-dmat'], [c_dmat, 8,'-dmatrix'],
                            [c_rmat, 5,'-rmat'], [c_rmat, 8,'-rmatrix'],
                            [c_help, 2,   '-h'], [c_help, 5,   '-help'] ];

var
  nv, ii, jj, ll:      integer;
  sopt, sparm:    string( 64 );
  rvl:    array[1..12] of real;
  cvl:                    real;


  procedure INIT_GET_VALUES( var nvl: integer; ll: integer; bfrac: boolean := false );
  const
    opttsz = 10;

    mdnam = 'INIT';


  var
    ij, jj, kp, num, den: integer;
    snum: string( 14 );
    ch: char;

  begin
    nvl := 0;
    ij := 1;
    while (ij <= sparm.length) and (nvl < ll) do
    begin
      jj := INDEX( sparm, ':', nvl + 1 );
      kp := INDEX( sparm, ',', nvl + 1 );
      if kp > 0 then
        if (jj <= 0) or (jj > kp) then jj := kp;
      if jj <= 0 then jj := sparm.length + 1;
      nvl := nvl + 1;
      rvl[nvl] := 0.0;
      if jj > ij then
      begin
        if bfrac then
        begin
          snum := SUBSTR( sparm, ij, jj-ij+1 );
          kp := INDEX( snum, '/' );
          if kp > 1 then
          begin
            READV( snum, num:kp-1, ch, den:snum.length-kp );
            if den < 1 then den := 1;
            rvl[nvl] := num/den
          end
          else READV( sparm:ij, rvl[nvl]:jj-ij+1 )
        end
        else READV( sparm:ij, rvl[nvl]:jj-ij+1 )
      end;
      ij := jj + 1
    end
  end INIT_GET_VALUES;


begin { INIT }
  grp_ok := true;                              { All is OK until shown otherwise }
  ii := 1;
  while ii < argc do
  begin
    sparm := argv[ii]^;
    if sparm.length > 0 then
      if sparm[1] = '-' then
      begin
        jj := INDEX( sparm, '=' );
        if jj > 0 then
        begin
          sopt  := SUBSTR( sparm, 1, jj - 1 );
          sparm := SUBSTR( sparm, jj + 1 )
        end
        else
        begin  sopt := sparm; sparm.length := 0  end;
        CHANGE_CASE( sopt );
        case IDE_SEARCH( opt_names, sopt ) of
           c_file: { Select an input file }
                   begin
                     if sparm.length = 0 then grp_cvmod := true
                                         else inpf := sparm;
                     inp_file_req := true
                   end;

           c_cell: { Specify a Unit Cell }
                   begin
                     INIT_GET_VALUES( nv, 6 );
                     if (nv > 0) and (rvl[1] > 0.0) then
                     begin
                       d_aa := rvl[1]; d_bb := d_aa; d_cc := d_aa;
                       d_al := 0.0; d_be := 0.0; d_ga := 0.0;
                       if (nv >= 2) and (rvl[2] <> 0.0) then d_bb := rvl[2];
                       if (nv >= 3) and (rvl[3] <> 0.0) then d_cc := rvl[3];
                       if (nv >= 4) and (rvl[4] <> 0.0) then d_al := rvl[4];
                       d_be := d_al; d_ga := d_al;
                       if (nv >= 5) and (rvl[5] <> 0.0) then d_be := rvl[5];
                       if (nv >= 6) and (rvl[6] <> 0.0) then d_ga := rvl[6];
                       grp_cell := true
                     end
                   end;

           c_org:  { Specify an Origine translation (in 1/24 units) }
                   begin
                     INIT_GET_VALUES( nv, 3, true );
                     if nv > 0 then
                     begin
                       grp_utrans[1] := ROUND( rvl[1]*24.0 ) mod 24;
                       if nv >= 2 then grp_utrans[2] := ROUND( rvl[2]*24.0 ) mod 24;
                       if nv >= 3 then grp_utrans[3] := ROUND( rvl[3]*24.0 ) mod 24;
                       grp_org := true
                     end
                   end;

           c_axis: { Specify a Change of axis }
                   begin
                     CHANGE_CASE( sparm );
                     if sparm.length > 3 then sparm := SUBSTR( sparm, 1,3 );
                     nv := INDEX( 'a   b   c   abc bca cab acb bac cba', sparm ) - 1;
                     if (nv < 0) or (nv mod 4 <> 0) then
                     begin
                       WRITELN;
                       WRITELN( ' *** Unknown permuttation of axis "', sparm, '" => Stop *** ' );
                       WRITELN;
                       return
                     end;
                     nv := nv div 4;
                     case nv of
                       0, 3: grp_orient := l_xyz;
                       1, 4: grp_orient := l_yzx;
                       2, 5: grp_orient := l_zxy;
                       6:    grp_orient := l_xzy;
                       7:    grp_orient := l_yxz;
                       8:    grp_orient := l_zyx;
                     end
                   end;

           c_qvec: begin
                     INIT_GET_VALUES( nv, 4, true );
                     if (nv >= 1) and (grp_qvnbr < max_qvec) then
                     begin
                       grp_qvnbr := grp_qvnbr + 1;
                       with grp_qvect[grp_qvnbr] do
                       begin
                         qw_vect[1] := rvl[1];
                         if nv > 1 then qw_vect[2] := rvl[2] else qw_vect[2] := 0.0;
                         if nv > 2 then qw_vect[3] := rvl[3] else qw_vect[3] := 0.0;
                         if nv > 3 then qw_nqma := ABS( ROUND( rvl[4] ) )
                                   else qw_nqma := 1;
                         qw_nqmi := -qw_nqma;
                         qw_nf   :=        0;
                         qw_msup :=        0;
                         for ig := 1 to 48 do qw_gkt[ig] := z_lvec;
                         qw_nfqv :=   z_lvec;
                         qw_rflg :=    false
                       end
                     end
                   end;

           c_ghkl: begin
                     INIT_GET_VALUES( nv, 5, true );
                     if nv > 0 then
                     begin
                       grp_us2dm := rvl[1]; if grp_us2dm < 0.1 then grp_us2dm := 0.1;
                       for ii := 2 to nv do
                       begin
                         ll := ABS( ROUND( rvl[ii] ) );
                         case ii of
                           2: begin  grp_nsort := ODD( ll ); grp_wrequ := ll div 2  end;
                           3, 4, 5: if ll <= sbyte"last then grp_hklmax[ii-1] := ll
                                                        else grp_hklmax[ii-1] := 31;
                         otherwise
                         end
                       end;
                       grp_hkl := true
                     end
                   end;

           c_wave: begin
                     INIT_GET_VALUES( nv, 3, true );
                     if nv >= 1 then
                     begin
                       hkl_wavel := ABS( rvl[1] );
                       if nv > 1 then
                       begin
                         hkl_thmax := ABS( rvl[2] );
                         if nv > 2 then hkl_thmin := ABS( rvl[3] )
                       end
                     end
                   end;

           c_dten: grp_dten  := true; { Set Metric tensor or transformation output flags }
           c_rten: grp_rten  := true;
           c_dmat: grp_dmat  := true;
           c_rmat: grp_rmat  := true;

           c_data: grp_dataf := true; { Generate Output on data format }

           c_gxyz: grp_xyzf  := true; { Generate Symbolic General Position Output }

           c_oper: grp_operf := true; { Generate Matrix of each space Group Operator }

           c_nrm:  grp_normf := true; { Generate Normalised Orthogonal base Output }

           c_posl: begin
                     grp_pliststr := sparm;
                     grp_poslstf  := true
                   end;

           c_pos:  begin
                     grp_posstr   := sparm;
                     grp_posf     := true
                   end;

           c_symb: begin
                     grp_symbstr  := sparm;
                     grp_symbf    := true
                   end;

           c_help: { Gen Space Help on standard output }
                   begin
                     OPEN( hf, help_file_spc, [read_file,error_file] );
                     if iostatus = 0 then
                     begin
                       VERSION_OUTPUT( output );
                       repeat
                         output^ := hf^; GET( hf ); PUT( output )
                       until EOF( hf );
                       CLOSE( hf )
                     end
                     else
                       ERROR( mdnam, ' Sorry, I can''t open the help file', help_file_spc );
                     PASCAL_EXIT( 0 )
                   end
        otherwise
          WRITELN;
          WRITELN( ' *** Unknown Gen_Space_Group Option "', sopt, '" => Stop *** ' );
          WRITELN;
          grp_ok := false;
          return
        end;
      end
      else
        if grp_name.length = 0 then
        begin
          grp_name := sparm;
          grp_number := 0;
          ll := 1;
          while (ll <= sparm.length) and (sparm[ll] >= '0') and (sparm[ll] <= '9') do
          begin
            grp_number := grp_number*10 + ORD( sparm[ll] ) - ORD( '0' );
            ll := ll + 1
          end;
          if ll <= sparm.length then grp_number := 0
        end
        else
          if outf.length = 0 then outf := sparm;
    ii := ii + 1
  end;
  if inpf.length > 0 then
  begin
    OPEN( inp_file, inpf, [read_file,error_file] );
    if iostatus <> 0 then ERROR( mdnam, 'MXD_Gen_Space Cannot Open the Input File', inpf )
  end;
  if outf.length > 0 then
  begin
    OPEN( out_file, outf, [write_file,error_file] );
    if iostatus <> 0 then
    begin
      WRITELN( ' *** MXD_Gen_Space Cannot Open the Output File "', outf, '".' );
      grp_ok := false
    end
  end
end INIT;



procedure EXEC_FIRST_DIRECTIVES;
const
  mdnam = 'FST1';

var
  t_x, t_y, t_z, rv:      real;
  i:                   integer;
  strg:           string( 64 );

begin { EXEC_FIRST_DIRECTIVES }
  inp_prompt := ' Gen_Space_Setting> ';
  inp_csmbtb := cmd_table"address;

  repeat
    INP_INQUIRE( '' );
    case inp_symb of
      sy_ident:
        case inp_code of
          fc_undef: { undefined command }
            begin
              ERROR( mdnam, 'Undefined Command', inp_ident );
              SKIP_SYMBOL( sy_semicolon ); INSYMBOL
            end;

          fc_cell:  { Cell Specification }
            begin
              INSYMBOL;
              d_aa := 0.0;
              INP_R_VALUE( ' A = ', d_aa );
              if d_aa < 0.001 then ERROR( 'Cell', 'Illegal value of the cell parameter A' );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' B = ', d_bb );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' C = ', d_cc );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' Alpha = ', d_al );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' Beta = ', d_be );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' Gamma = ', d_ga );
              INP_LOOKSEMICOLON;
              grp_cell := true
            end;

          fc_group: { Groupe Specification }
            begin
              INSYMBOL;
              INP_INQUIRE( ' Space Group = ' );
              if inp_symb = sy_int then
              begin
                INP_I_VALUE( '', grp_number );
                WRITEV( grp_name, grp_number:0 )
              end
              else
              begin
                grp_number := 0;
                INP_S_VALUE( '', grp_name )
              end;
              INP_LOOKSEMICOLON
            end;

          fc_org:   { Origine Specification }
            begin
              INSYMBOL;
              t_x := 0.0; t_y := 0.0; t_z := 0.0;
              INP_R_VALUE( ' TX = ', t_x );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' TY = ', t_y );
              if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' TZ = ', t_z );
              INP_LOOKSEMICOLON;
              grp_utrans[1] := ROUND( t_x*24.0 ) mod 24;
              grp_utrans[2] := ROUND( t_y*24.0 ) mod 24;
              grp_utrans[3] := ROUND( t_z*24.0 ) mod 24;
              grp_org := true
            end;

          fc_axis:  { Axis - Orientation Specification }
            begin
              INSYMBOL;
              INP_S_VALUE( ' Axis Permutation = ', strg );
              INP_LOOKSEMICOLON;
              CHANGE_CASE( strg );
              if strg.length > 3 then strg := SUBSTR( strg, 1, 3 );
              i := INDEX( 'a   b   c   abc bca cab acb bac cba', strg );
              if i < 1 then
                ERROR( mdnam, 'Ignored Unknown permuttation of axis', strg )
              else
              begin
                i := (i - 1) div 4;
                case i of
                  0, 3: grp_orient := l_xyz;
                  1, 4: grp_orient := l_yzx;
                  2, 5: grp_orient := l_zxy;
                  6:    grp_orient := l_xzy;
                  7:    grp_orient := l_yxz;
                  8:    grp_orient := l_zyx;
                end
              end
            end;

          fc_data:
            begin
              INSYMBOL;
              INP_LOOKSEMICOLON;
              grp_dataf := true { Generate Output on data format }
            end;

          fc_norm:
            begin
              INSYMBOL;
              INP_LOOKSEMICOLON;
              grp_normf := true { Generate Output on normalized reference }
            end;

          fc_help: OUTPUT_HELP;

        otherwise
          return
        end;

      sy_semicolon: INSYMBOL;

      sy_eoln: { Nothing to do };

      sy_eof: EXIT;

    otherwise
      ERROR( mdnam, 'Illegal Command, A command identifier was expected.' );
      SKIP_SYMBOL( sy_semicolon )
    end
  until inp_symb = sy_eof
end EXEC_FIRST_DIRECTIVES;





{********************************************************************}
{*           GEN_SPACE_GROUP - Group Generation procedures          *}
{********************************************************************}



procedure GEN_POSITION_LIST( var f: text );
begin
  WRITE_POSITIONS_LIST( f );
end GEN_POSITION_LIST;



procedure GEN_SYMB_POSITIONS( var f: text );
var
  sx, sy, sz: string( 32 );
  format, title: string( 255 );
  xyz: xyz_coord;

begin
  INP_INQUIRE( ' Symbolic X,Y,Z = ' );
  SOURCE_TO_XYZ( xyz, sx, sy, sz, format, title );
  if title.length = 0 then
    if grp_dataf then title := symb_dbtit else title := symb_datit;
  if format.length = 0 then
    if grp_dataf then format := symb_dbfrm else format := symb_dafrm;
  WRITE_SYMB_POSITIONS( f, xyz, sx, sy, sz, format, title )
end GEN_SYMB_POSITIONS;



procedure GEN_NUM_POSITIONS( var f: text );
const
  mdnam = 'GNMP';

var
  sx, sy, sz: string( 32 );
  format, title: string( 255 );
  xyz: dvector;

begin
  format.length := 0;
  title.length  := 0;
  INP_R_VALUE( ' Numeric X,Y,Z = ', xyz[1] );
  if (inp_symb = sy_comma) or (inp_symb = sy_colon) then INSYMBOL
  else WARNING( mdnam, 'A separator "," or ":" was expected' );
  INP_R_VALUE( ' Y = ', xyz[2] );
  if (inp_symb = sy_comma) or (inp_symb = sy_colon) then INSYMBOL
  else WARNING( mdnam, 'A separator "," or ":" was expected' );
  INP_R_VALUE( ' Z = ', xyz[3] );
  if (inp_symb = sy_comma) or (inp_symb = sy_colon) then
  begin
    INSYMBOL;
    if inp_symb = sy_str then begin  format := inp_str; INSYMBOL  end;
    if (inp_symb = sy_comma) or (inp_symb = sy_colon) then
    begin
      INSYMBOL;
      if inp_symb = sy_str then begin  title := inp_str; INSYMBOL  end
    end
  end;
  if title.length = 0 then
    if grp_dataf then title := pos_dbtit
                 else title := pos_datit;
  if format.length = 0 then
    if grp_dataf then format := pos_dbfrm
                 else format := pos_dafrm;
  WRITE_NUM_POSITIONS( f, xyz, format, title )
end GEN_NUM_POSITIONS;



procedure GEN_OUT_OPERATORS( var f: text );
var
  format:  string( 255 ) := '';
  s:              string( 32 );
  d:                   integer;

begin
  if not grp_dataf then
  begin
    for ii := 1 to grp_nope do
    begin
      WRITEV( s, 'Matrix[', ii:-2,']' );
      DISPLAY_OPERATOR( f, s, grp_oper[ii] )
    end
  end
  else
  begin
    if inp_symb = sy_str then format := inp_str
                         else format :=  operdf;

    for ii := 1 to grp_nope do
    begin
      if DET_OPERATOR( grp_oper[ii] ) > 0 then OUT_VALUE(  1 )
                                          else OUT_VALUE( -1 );
      for i := 1 to 3 do
        for j := 1 to 4 do
          OUT_VALUE( grp_oper[ii,i,j] );
      FORMATTED_OUTPUT( f, format, grp_nope, ii, 0, 0, ii = 1 )
    end
  end
end GEN_OUT_OPERATORS;



procedure OUT_GRP_MATRIX( var f: text; in_var frm, lab: string; var mat: matrix; datflg: boolean );
begin
  if not datflg then OUT_VALUE( lab );
  for i := 1 to 3 do
    for j := 1 to 3 do
      OUT_VALUE( mat[i,j] );
  FORMATTED_OUTPUT( f, frm )
end OUT_GRP_MATRIX;



procedure GENERATE_GROUP( var f: text );
type
  perm_names = array[lat_orie] of packed array[1..8] of char;
  syst_names = array[lat_kind] of string( 12 );
  latt_names = array[lat_type] of char;

const
  mdnam = 'GENG';

  perm_ntb = perm_names[ ' a, b, c', ' b, c, a', ' c, a, b',    { l_xyz, l_yzx, l_zxy, }
                         ' a,-c, b', ' b, a,-c', '-c, b, a' ];  { l_xzy, l_yxz, l_zyx  }

  latt_nam = latt_names[ 'u', 'P', 'A', 'B', 'C', 'F', 'I', 'R', 'H' ];

  syst_nam = syst_names[    'undefined',     'Triclinic',   'Monoclinic',
                         'Orthorhombic',    'Tetragonal',     'Trigonal',
                            'Hexagonal',  'Rhombohedral',        'Cubic' ];

var
  s:   string( 128 );
  v:         lvector;
  ice:       integer;
  bln, bco:  boolean;

begin
  GEN_SPACE_GROUP;
  if grp_cell then CELL_COMPUTE;

  if not grp_dataf then
  begin
    Version_Output( f );
    WRITE( f, syst_nam[grp_sys], ' crystallographic system' );
    if grp_sys = l_rho then WRITELN( f, ' (described in rhombohedral axes)' )
                       else WRITELN( f );
    WRITE( f, 'Space Group "', grp_name:, '" (#', grp_number:0, ') with lattice ', latt_nam[grp_lattice] );
    if (grp_sys = l_mon) or (grp_sys = l_ort) then WRITE( f, ' with orientation ', perm_ntb[grp_orient] );
    bln := false;
    if grp_org then
    begin
      WRITE( f, ' The Origine Translation is ' ); DISPLAY_LVECTOR( f, grp_utrans );
      bln := true
    end;
    if grp_invope > 0 then
    begin
      for i := 1 to 3 do  v[i] := grp_oper[grp_invope,i,4] div 2;
      if not bln then WRITE( f, ', ' );
      WRITE( f, 'Inversion center at ' ); DISPLAY_LVECTOR( f, v )
    end
  end
  else
  begin
    WRITE( f, syst_nam[grp_sys]:12, ' ', grp_name:9, ' ', grp_number:4, ' ', ORD( grp_sys ):1, ' ', ORD( grp_orient ):1 );
    if grp_invope > 0 then
    begin
      bco := false;
      for i := 1 to 3 do  if grp_oper[grp_invope,i,4] <> 0 then bco := true;
      if bco then WRITE( f, '  1' )
             else WRITE( f, ' -1' );
      for i := 1 to 3 do  WRITE( f, ' ', grp_oper[grp_invope,i,4] div 2:3 )
    end
    else WRITE( f, '  0    0    0    0' );
    WRITELN( f )
  end;

  if grp_xyzf then
    if grp_dataf then
      WRITE_SYMB_POSITIONS( f, identity_xyz, 'x', 'y', 'z', symb_dbfrm, symb_dbtit )
    else
      WRITE_SYMB_POSITIONS( f, identity_xyz, 'x', 'y', 'z', symb_dafrm, symb_getit );

  if grp_operf then
  begin
    inp_string_flg := true;
    inp_string_idx := 1;
    inp_string := grp_posstr;
    INSYMBOL;
    GEN_OUT_OPERATORS( f );
    inp_ch   := ' ';
    inp_symb := sy_eoln;
    inp_string_flg := false
  end;

  if grp_poslstf then
  begin
    inp_string_flg := true;
    inp_string_idx := 1;
    inp_string := grp_pliststr;
    INSYMBOL;
    GEN_POSITION_LIST( f );
    inp_ch   := ' ';
    inp_symb := sy_eoln;
    inp_string_flg := false
  end;

  if grp_symbf then
  begin
    inp_string_flg := true;
    inp_string_idx := 1;
    inp_string := grp_symbstr;
    INSYMBOL;
    GEN_SYMB_POSITIONS( f );
    inp_ch   := ' ';
    inp_symb := sy_eoln;
    inp_string_flg := false
  end;

  if grp_posf then
  begin
    inp_string_flg := true;
    inp_string_idx := 1;
    inp_string := grp_posstr;
    INSYMBOL;
    GEN_NUM_POSITIONS( f );
    inp_ch   := ' ';
    inp_symb := sy_eoln;
    inp_string_flg := false
  end;

  if grp_cell then
  begin { grp_dataf /// }
    if grp_dataf then s := rmatdf
                 else s := rmatlf;
    if grp_dten then OUT_GRP_MATRIX( f, s, dtlabel, grp_dmt, grp_dataf );
    if grp_rten then OUT_GRP_MATRIX( f, s, rtlabel, grp_rmt, grp_dataf );
    if grp_dmat then OUT_GRP_MATRIX( f, s, dmlabel, grp_tmd, grp_dataf );
    if grp_rmat then OUT_GRP_MATRIX( f, s, rmlabel, grp_tmr, grp_dataf )
  end
end GENERATE_GROUP;



procedure EXEC_ADD_DIRECTIVES( var f: text );
const
  mdnam = 'FST2';

var
  icmd, ip: integer;
  sfrm: string( 255 );

  procedure GET_FORMAT( in_var df: string );
  begin
    if (inp_symb = sy_colon) or (inp_symb = sy_comma) then
    begin
      INSYMBOL;
      INP_S_VALUE( ' Format = ', sfrm )
    end
    else sfrm := df
  end GET_FORMAT;


begin { EXEC_ADD_DIRECTIVES }
  inp_prompt := ' Gen_Space_execute> ';
  repeat
    INP_INQUIRE( '' );
  exit if inp_symb = sy_eof;
    case inp_symb of
      sy_ident:
        case inp_code of
          fc_undef:  { undefined command }
             begin
               ERROR( mdnam, 'Undefined Command', inp_ident );
               SKIP_SYMBOL( sy_semicolon )
             end;

          fc_norm, fc_latt:{ Specify output in normalized or lattice referential }
            begin
              INSYMBOL;
              grp_normf := (inp_code = fc_norm);
              INP_LOOKSEMICOLON
            end;

          fc_data, fc_list:{ Specify output in normalized or lattice referential }
            begin
              INSYMBOL;
              grp_dataf := (inp_code = fc_data);
              INP_LOOKSEMICOLON
            end;

          fc_poslist:
            begin
              INSYMBOL; GEN_POSITION_LIST( f ); INP_LOOKSEMICOLON
            end;

          fc_gxyz:
            begin
              INSYMBOL;
              if grp_dataf then
                WRITE_SYMB_POSITIONS( f, identity_xyz, 'x', 'y', 'z', symb_dbfrm, symb_dbtit )
              else
                WRITE_SYMB_POSITIONS( f, identity_xyz, 'x', 'y', 'z', symb_dafrm, symb_getit );
              INP_LOOKSEMICOLON
            end;

          fc_sxyz:
            begin
              INSYMBOL;
              GEN_SYMB_POSITIONS( f );
              INP_LOOKSEMICOLON
            end;

          fc_posit:
            begin
              INSYMBOL;
              GEN_NUM_POSITIONS( f );
              INP_LOOKSEMICOLON
            end;


          fc_mtens, fc_rmtens,  { Output the direct or reciprocal metric tensor of direct lattice }
          fc_tmd,   fc_tmr:     { ... and direct or reciprocal to work space Matrxi }
            begin
              INSYMBOL;
              if grp_dataf then GET_FORMAT( rmatdf )
                           else GET_FORMAT( rmatlf );
              case inp_code of
                fc_mtens:  OUT_GRP_MATRIX( f, sfrm, dtlabel, grp_dmt, grp_dataf );
                fc_rmtens: OUT_GRP_MATRIX( f, sfrm, rtlabel, grp_rmt, grp_dataf );
                fc_tmd:    OUT_GRP_MATRIX( f, sfrm, dmlabel, grp_tmd, grp_dataf );
                fc_tmr:    OUT_GRP_MATRIX( f, sfrm, rmlabel, grp_tmr, grp_dataf );
              end;
(*
              if grp_dataf then GET_FORMAT( rmatdf )
              else
              begin
                GET_FORMAT( rmatlf );
                case inp_code of
                  fc_mtens:  OUT_VALUE( dtlabel );
                  fc_rmtens: OUT_VALUE( rtlabel );
                  fc_tmd:    OUT_VALUE( dmlabel );
                  fc_tmr:    OUT_VALUE( rmlabel );
                end
              end;
              for i := 1 to 3 do
                for j := 1 to 3 do
                  case inp_code of
                    fc_mtens:  OUT_VALUE( grp_dmt[i,j] );
                    fc_rmtens: OUT_VALUE( grp_rmt[i,j] );
                    fc_tmd:    OUT_VALUE( grp_tmd[i,j] );
                    fc_tmr:    OUT_VALUE( grp_tmr[i,j] );
                  end;
              FORMATTED_OUTPUT( f, sfrm );
*)
              INP_LOOKSEMICOLON
            end;

          fc_oper: { Output the space group matrix's operator }
            begin
              INSYMBOL;
              GEN_OUT_OPERATORS( f );
              INP_LOOKSEMICOLON
            end;

          fc_o_cell: { Output the reciprocal unit cell }
            if grp_cell then
            begin
              INSYMBOL;
              if not grp_dataf then
              begin
                GET_FORMAT( daucf );
                OUT_VALUE( d_aa ); OUT_VALUE( d_bb ); OUT_VALUE( d_cc );
                OUT_VALUE( d_al ); OUT_VALUE( d_be ); OUT_VALUE( d_ga );
                FORMATTED_OUTPUT( f, sfrm );
                GET_FORMAT( raucf );
                OUT_VALUE( r_aa ); OUT_VALUE( r_bb ); OUT_VALUE( r_cc );
                OUT_VALUE( r_al ); OUT_VALUE( r_be ); OUT_VALUE( r_ga );
                FORMATTED_OUTPUT( f, sfrm )
              end
              else
              begin
                GET_FORMAT( aucef );
                OUT_VALUE( d_aa ); OUT_VALUE( d_bb ); OUT_VALUE( d_cc );
                OUT_VALUE( d_al ); OUT_VALUE( d_be ); OUT_VALUE( d_ga );
                FORMATTED_OUTPUT( f, sfrm );
                GET_FORMAT( aucef );
                OUT_VALUE( r_aa ); OUT_VALUE( r_bb ); OUT_VALUE( r_cc );
                OUT_VALUE( r_al ); OUT_VALUE( r_be ); OUT_VALUE( r_ga );
                FORMATTED_OUTPUT( f, sfrm )
              end;
              INP_LOOKSEMICOLON
            end
            else SKIP_SYMBOL( sy_semicolon );

          fc_wvect:
            begin
              INSYMBOL;
              if grp_qvnbr < max_qvec then
              begin
                grp_qvnbr := grp_qvnbr + 1;
                with grp_qvect[grp_qvnbr] do
                begin
                  for ii := 1 to 3 do  qw_vect[ii] := 0.0;
                  qw_nqma := 1;
                  INP_R_VALUE( ' KX = ', qw_vect[1] );
                  if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' KY = ', qw_vect[2] );
                  if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' KZ = ', qw_vect[3] );
                  if INP_SEPAR( sy_comma ) then INP_I_VALUE( ' NQ MAX = ', qw_nqma );
                  if INP_SEPAR( sy_comma ) then INP_I_VALUE( ' NQ Mixing Flag = ', ip );
                  if qw_nqma <= 0 then qw_nqma := 1;
                  qw_nqmi := - qw_nqma;
                  qw_nf   :=         0;
                  qw_msup :=         0;
                  qw_nfqv :=    z_lvec;
                  for ig := 1 to 48 do qw_gkt[ig] := z_lvec;
                  qw_rflg :=    false
                end;
                INP_LOOKSEMICOLON
              end
              else
              begin
                ERROR( mdnam, 'The Maximum number of wave vector is reached.' );
                SKIP_SYMBOL( sy_semicolon )
              end
            end;

          fc_wvdel:
            begin
              INSYMBOL;
              ip := -1;
              INP_I_VALUE( 'Number of Wave Vector to remove = ', ip );
              if (ip >= 1) and (ip <= grp_qvnbr) then
              begin
                if ip < grp_qvnbr then
                  for ii := grp_qvnbr downto ip + 1 do  grp_qvect[ii-1] := grp_qvect[ii];
                grp_qvnbr := grp_qvnbr - 1;
                INP_LOOKSEMICOLON
              end
              else
              begin
                ERROR( mdnam, 'Bad Wave vector number.' );
                SKIP_SYMBOL( sy_semicolon )
              end
            end;

          fc_ghkl:
            if grp_cell then
            begin
              INSYMBOL;
              if inp_symb <> sy_semicolon then
              begin
                INP_R_VALUE( ' HKL List Generator: 1/2D Max ', grp_us2dm );
                if grp_us2dm < 0.1 then grp_us2dm := 0.1;
                ip := 0;
                if INP_SEPAR( sy_comma ) then INP_I_VALUE( ' No 1/2d Sort = ', ip );
                grp_nsort := ODD( ip ); grp_wrequ := ip div 2;
                if INP_SEPAR( sy_comma ) then INP_I_VALUE( ' H Max = ', grp_hklmax[1] );
                if INP_SEPAR( sy_comma ) then INP_I_VALUE( ' K Max = ', grp_hklmax[2] );
                if INP_SEPAR( sy_comma ) then INP_I_VALUE( ' L Max = ', grp_hklmax[3] );
                for ii := 1 to 3 do  grp_hklmax[ii] := ABS( grp_hklmax[ii] )
              end;
              GENERATE_HKL_LIST( f );
              INP_LOOKSEMICOLON
            end;

          fc_wave:
            begin
              INSYMBOL;
              if inp_symb <> sy_semicolon then
              begin
                INP_R_VALUE( ' Wave Length to use (in Angstroem) ', hkl_wavel );
                if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' 2 Theta Maximum = ', hkl_thmax );
                if INP_SEPAR( sy_comma ) then INP_R_VALUE( ' 2 Theta Minimum = ', hkl_thmin )
              end
            end;

          fc_text:
            begin
              INSYMBOL;
              INP_S_VALUE( ' Text to Insert = ', sfrm );
              INP_LOOKSEMICOLON;
              WRITELN( f, sfrm )
            end;

          fc_help: OUTPUT_HELP;

        otherwise
          ERROR( mdnam, 'Illegal Command at this place', inp_ident );
          SKIP_SYMBOL( sy_semicolon )
        end;

      sy_semicolon: INSYMBOL;

      sy_eoln: { Nothing to do } ;

    otherwise
      ERROR( mdnam, 'Illegal Command, A command identifier was expected).' );
      SKIP_SYMBOL( sy_semicolon )
    end
  until inp_symb = sy_eof
end EXEC_ADD_DIRECTIVES;




{********************************************************************}
{*                  GEN_SPACE_GROUP Main procedure                  *}
{********************************************************************}

begin { GEN_SPACE_GROUP }
  INIT;
  if not grp_ok then PASCAL_EXIT( 2 );
  if inp_file_req then EXEC_FIRST_DIRECTIVES;
  if not grp_ok then PASCAL_EXIT( 2 );
  if grp_name.length = 0 then 
    ERROR( 'GENS', 'A Space group must be specified (by name or number).' );

  if outf.length > 0 then GENERATE_GROUP( out_file )
                     else GENERATE_GROUP( output );

  if grp_hkl and grp_cell then
    if outf.length > 0 then GENERATE_HKL_LIST( out_file )
                       else GENERATE_HKL_LIST( output );

  if inp_file_req then
    if outf.length > 0 then EXEC_ADD_DIRECTIVES( out_file )
                       else EXEC_ADD_DIRECTIVES( output );
  WRITELN
end GEN_SPACE_GROUP.

