{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*               ---   SERVICE ROUTINES PASCAL MODULE   ---              *
*                                                                       *
*                 ---  Version  3.1-B4 -- 30/09/2016 ---                *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{************     CPAS  version    *************}


(*
  [inherit(   'lib:cpas_b__src_env',            { Use the Basic Library Definitions }
              'lib:pas_env')]                   { Use the pas env definitions }
*)
module PAS_IDENT;

{ *** Include basic compiler environment *** }
%include 'passrc:pcmp_env';


{ Basic environment for identifier operation }

const
  debug = false;                                { Output for Debug }

var { * For the repeat context mode, we insert the context expression at the begining }
  prv_ident: ide_ptr;                           { To keep the previous identifier for IDE_NEW }
  id_left: boolean;                             { ... and the last match result }

  id_sflg: boolean := false;                    { To flag the use of id_save }
  id_save: string( 255 );                       { To save sy_string when we creat an internal id. }





       {********************************}
       { Basic Procedures and Functions }
       {********************************}

[global]
procedure STR_COPY( var target, src: str_ptr );
{ To copy a string, allocate it when it is not existing }
var
  l: integer;

begin { STR_COPY }
  if target <> src then
    if src = nil then                           { No source string }
    begin
      if target <> nil then target^.length := 0
    end
    else
    begin                                       { True source string }
      { No existing target, create it }
      if (src^.length > 0) and (target = nil) then NEW( target, src^.length );
      target := src
    end
end STR_COPY;



[global]
procedure VAL_COPY( var v1, v2: val_ptr; bfree: boolean );
{ To copy a constant (Value Record) (v1 -> v2) from a block to
  an other block and (if bfree = true) free the source block }
{ if an old block was allocated to the target, then it is free }
var
  i:  integer;
  pv: val_ptr;

begin
  if v2 <> nil then VAL_FREE( v2 );
  if v1 = nil then v2 := nil
  else
  if bfree and (v1^.val_nuse = 1) then
  begin
    v2 := v1; v1 := nil
  end
  else
  begin
    VAL_NEW( v2, v1^.val_typ );
    v2^ := v1^;
    with v2^ do
    begin
      val_next := nil;
      val_nuse :=   1;
      val_lex  := curr_lex;
      case val_kind of
        form_string:
          if val_str <> nil then
          begin
            val_str := nil;
            STR_COPY( val_str, v1^.val_str )
          end;

        form_conf, form_array, form_record:
          if val_lst <> nil then
            with val_lst^ do
              val_nuse := val_nuse + 1;

        form_wild: { case table }
          begin
            val_tab := TAB_NEW( val_size );
            with v1^.val_tab^ do
              for i := 0 to val_size - 1 do
                val_tab^.lw[i] := lw[i]
          end;

      otherwise
      end
    end;
    if bfree then VAL_FREE( v1 )
  end
end VAL_COPY;



end.
