/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"
static P Lx[5];

/* Define the local data section. */
static Blk( Rd, 3608 ) = {
 11,  11, 115, 101, 116,  95, 115, 116, 114, 110,  97, 109, 101,  60,  60,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  52,  47, 112,  99,
109, 112,  95, 101, 120, 112, 114,  46, 112,  97, 115,  11,  11, 115, 101, 116,
 95, 115, 116, 100, 110,  97, 109, 101,   4,   4,  69,  88,  84,  80,   9,   9,
115,  97, 109, 101,  95, 116, 121, 112, 101,  13,  13,  99, 111, 109, 112,  97,
114, 101,  95, 101, 110, 116, 114, 121,  18,  18,  99, 111, 109, 112,  97, 114,
101,  95, 112, 114, 111,  99,  95,  97, 114, 103, 105, 100,  11,  11,  99, 111,
109, 112,  95, 115,  99,  97, 108,  97, 114,  13,  13,  99, 104, 105, 108, 100,
114, 101, 110,  95, 116, 121, 112, 101,  13,  13, 115, 117,  98,  95,  99, 111,
109, 112,  95, 116, 121, 112, 101,   9,   9,  99, 111, 109, 112,  95, 116, 121,
112, 101,  13,  13,  99, 111, 109, 112,  95, 112, 114, 111,  99,  95,  97, 114,
103,  18,  18, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,  99, 116, 101,
 95, 105, 110, 105, 116,   4,   4,  84,  89,  67,  49,  21,  21, 116, 121, 112,
101,  95, 112,  97, 114, 109,  95,  99, 116, 101,  95, 114, 101, 108, 101,  97,
115, 101,  15,  15, 115, 116, 114, 105, 110, 103,  95, 105, 110,  95,  97, 114,
114,  97, 121,  19,  19, 115, 116, 114, 105, 110, 103,  95, 105, 110,  95, 115,
117,  98, 115, 116, 114, 105, 110, 103,  16,  16, 105, 110, 105, 116, 105,  97,
108, 105, 122, 101,  95, 118,  97, 114,  98, 108,  15,  15, 116, 121, 112, 101,
 95,  99, 104, 101,  99, 107,  95, 112,  97, 114, 109,   4,   4,  84,  89,  67,
 72,  17,  17, 115, 117,  98, 116, 121, 112, 101,  95, 115, 101, 116,  95, 118,
 97, 108, 117, 101,  13,  13, 116, 121, 112, 101,  95, 112,  97, 114, 109,  95,
115, 101, 116,   4,   4,  84,  80,  82,  77,  12,  12, 105, 110, 105, 116,  95,
100, 121, 110,  95, 116,  97,  98,  11,  11, 100, 121, 110,  95, 114, 101,  99,
 95, 103, 115, 108,  12,  12, 105, 110, 105, 116,  95, 100, 121, 110,  95, 114,
101,  99,  10,  10, 105, 110, 105, 116,  95, 100, 121, 110,  95, 100,   4,   4,
 73,  68,  89,  78,  10,  10, 105, 110, 105, 116,  95, 100,  95, 100, 121, 110,
  4,   4,  73,  68,  68,  89,  10,  10, 105, 110, 105, 116,  95, 100,  95, 116,
 97,  98,   4,   4,  73,  68,  84,  66,  10,  10, 105, 110, 105, 116,  95, 100,
 95, 114, 101,  99,   4,   4,  73,  68,  82,  68,  13,  13, 105, 110, 105, 116,
 95, 100,  95, 115, 116,  97, 116, 105,  99,   4,   4,  73,  68,  83,  84,  12,
 12, 105, 110, 105, 116,  95, 100,  95, 118,  97, 114,  98, 108,  11,  11, 101,
120, 112,  95, 118,  97, 108,  95, 117, 110,  97,   4,   4,  69,  67,  85,  78,
 11,  11, 101, 120, 112,  95, 118,  97, 108,  95,  98, 105, 110,   4,   4,  69,
 88,  80,  66,  19,  19, 108, 111, 111, 107,  95, 102, 111, 114,  95, 100, 101,
115,  99, 114, 105, 112, 116, 111, 114,  12,  12,  99,  97, 108, 108,  95, 115,
101, 116, 116, 105, 110, 103,   4,   4,  67,  65,  76,  76,   4,   4, 119, 114,
116, 116,   0,   0,  30,   0,   0,   0,  17,   0,   9, 102, 111, 114, 109,  95,
 99, 104,  97, 114,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114,
109,  95, 108, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102,
111, 114, 109,  95, 105, 110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 11, 102, 111, 114, 109,  95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,
  0,   0,  11, 102, 111, 114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,
  0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101,
114,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 102, 101, 110, 116,
114, 121,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 105,
108, 101,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
 97, 114, 114,  97, 121,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95,  99, 111, 110, 102,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102,
111, 114, 109,  95, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   0,
  8, 102, 111, 114, 109,  95, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 108, 115, 101, 116,   0,   0,   0,   0,
  0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,
  0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110,
110, 117, 109,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
119, 102, 105, 108, 101,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114,
109,  95, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102,
111, 114, 109,  95, 119, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,
 10, 102, 111, 114, 109,  95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,
  0,   0,  12, 102, 111, 114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103,
101,   0,   0,   0,   0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97,
114, 105,  97, 110, 116,   0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95,
111, 114, 103,  97, 110, 105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114,
109,  95,  99, 111, 110, 115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102,
111, 114, 109,  95, 112, 114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,
 12, 102, 111, 114, 109,  95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 110, 117, 108, 108,   0,   0,   0,   0,
  0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 115, 116, 114, 105, 110, 103,
  0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 114, 101, 101,
  0,   0,   0,   0,   0,   0,   0,   0,   7,   7,  45,  45,  45,  45,  45,  45,
 32,   3,   3, 119, 114, 116,   0,   0,   6,   0,   0,   0,   6,   0,   6,  99,
118,  95, 110, 111, 112,   6,  99, 118,  95,  99, 105, 102,   6,  99, 118,  95,
 99, 102, 105,   6,  99, 118,  95,  99, 105, 103,   6,  99, 118,  95,  99, 103,
105,   6,  99, 118,  95,  99, 102, 103,   6,  99, 118,  95,  99, 103, 102,   2,
  2,  44,  91,   0,   7,   0,   0,   0,   5,   0,   5,  97,  95, 111, 117, 116,
  5,  97,  95, 105,  97, 111,   5,  97,  95, 105, 110, 100,   5,  97,  95, 100,
105, 114,   5,  97,  95, 115, 116, 121,   5,  97,  95, 114, 116, 121,   5,  97,
 95, 110, 105, 108,   5,  97,  95, 110, 111, 102,   2,   2,  93,  62,  12,  12,
115, 104, 111, 119,  95, 114, 101, 113, 117, 101, 115, 116,  26,  26,  32,  71,
101, 110, 101, 114, 105,  99,  95,  83, 101,  97, 114,  99, 104,  32, 102, 111,
114,  32, 110, 112,  97,  32,  61,  32,   6,   6,  32, 119, 105, 116, 104,  32,
 13,  13,  65, 114, 103,  95,  49,  32, 102,  95, 116, 121, 112, 101,  32,  15,
 15,  44,  32,  65, 114, 103,  95,  50,  32, 102,  95, 116, 121, 112, 101,  32,
  7,   7,  78, 111,  32,  97, 114, 103,  46,  10,  10, 115, 104, 111, 119,  95,
101, 110, 116, 114, 121,  16,  16,  32,  79, 107,  32, 102, 111, 114,  32,  69,
110, 116, 114, 121,  32,  58,  32,  10,  10,  32,  32,  32,  32,  69, 110, 116,
114, 121,  32,   2,   2,  44,  32,   4,   4,  32,  45,  62,  32,  11,  11,  32,
 45,  62,  32,  99, 111, 100, 101,  32,  61,  32,   0,   0, 127,   0,   0,   0,
 15,   0,   9, 112,  99, 111, 100,  95, 110, 111, 111, 112,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 116, 111, 114, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 114,  97, 110, 103, 101,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 105, 115, 116, 111, 114, 101,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 102, 115, 116, 111, 114, 101,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103, 115, 116, 111, 114, 101,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 110, 111, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  97, 110, 100,   0,   0,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 111, 114,   0,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 120, 111, 114,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 109,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  98,  97, 110, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  98, 120, 111, 114,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 115,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  98, 105, 116,   0,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 115, 101, 116, 103, 101, 110,   0,   0,
  0,   0,  12, 112,  99, 111, 100,  95, 108, 115, 101, 116, 103, 101, 110,   0,
  0,   0,  14, 112,  99, 111, 100,  95, 108, 115, 101, 116,  97, 100, 100, 101,
108,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108, 116,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 108, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 103, 116,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 101, 113,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 115, 101, 116, 110, 101,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 105, 110, 115, 101, 116,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 101, 113,   0,   0,   0,   0,   0,   0,
  0,   0,   7, 112,  99, 111, 100,  95, 110, 101,   0,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 117, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  95, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  95, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 105, 110,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 100, 101,  99,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  97, 115, 104,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 108, 115, 104,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 114, 111, 116,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 117,  99,  99,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 112, 114, 101, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 111, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 109, 111, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 114, 101, 109,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 102, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 102,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 105,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 102, 116, 114, 117, 110,  99,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 108, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 101,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 103, 116,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 101, 113,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 103, 110, 101,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 110, 101, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  97,  98, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 113, 114,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 105, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 105,   0,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103, 116, 114, 117, 110,  99,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 102, 103,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 118, 103, 102,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  97, 100, 100,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 117,  98,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 109, 117, 108,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 100, 105, 118,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 105, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 102, 105, 112, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 113, 114, 116,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 115, 105, 110,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95,  99, 111, 115,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 116,  97, 110,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97, 115, 105, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97,  99, 111, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  97, 116,  97, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 112, 104,  97, 115,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 101, 120, 112,   0,   0,   0,   0,   0,
  0,   0,   8, 112,  99, 111, 100,  95, 108, 111, 103,   0,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 115, 105, 110, 104,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95,  99, 111, 115, 104,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 116,  97, 110, 104,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97, 115, 105, 110, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97,  99, 111, 115, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95,  97, 116,  97, 110, 104,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 112, 111, 119,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 105, 112, 119,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 113, 114, 116,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 115, 105, 110,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103,  99, 111, 115,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 116,  97, 110,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 115, 105, 110,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97,  99, 111, 115,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  97, 116,  97, 110,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 112, 104,  97, 115,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 101, 120, 112,   0,   0,   0,   0,
  0,   0,   9, 112,  99, 111, 100,  95, 103, 108, 111, 103,   0,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 115, 105, 110, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103,  99, 111, 115, 104,   0,   0,   0,
  0,   0,  10, 112,  99, 111, 100,  95, 103, 116,  97, 110, 104,   0,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 115, 105, 110, 104,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97,  99, 111, 115, 104,   0,   0,
  0,   0,  11, 112,  99, 111, 100,  95, 103,  97, 116,  97, 110, 104,   0,   0,
  0,   0,  14, 112,  99, 111, 100,  95,  95, 103, 101, 110, 115, 116, 114, 108,
 49,   0,  15, 112,  99, 111, 100,  95,  95, 103, 101, 110, 112, 114, 109, 116,
121, 112,   4,   4, 100, 117, 109, 112,  14,  14, 103, 101, 110, 101, 114, 105,
 99,  95, 115, 101,  97, 114,  99, 104,   4,   4,  71,  69,  78,  83,  11,  11,
101, 120, 112,  95, 103, 101, 110, 111, 112, 101, 114,  13,  13, 103, 101, 110,
101, 114,  97, 116, 101,  95,  99,  97, 108, 108,   9,   9, 101, 120, 112,  95,
103, 101, 110, 111, 112,  13,  13, 108, 103, 116,  95, 103, 101, 110,  95, 115,
116, 111, 114, 101,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 488 ) = {
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   4,   4,
  0,   0,   0,   0,   0,   4,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   4,   0,   0,   1,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  0,   4,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   1,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,
  0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,
  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   4,
  0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,
  0,   0,   0,   4,   4,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   4,   4,   0,   4,   0,   0,
  0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  0,   0,   0,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   4,   0,   0,   0,   0,   0,   4,   4,   4,   4,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,   0,   4,
  0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,
  4,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   4,   0,   0,   0,   0,   0,   4,   0,   4,   0,   4,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   4,
  0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   0,
  0,   0,   0,   4,   4,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   4,   4,   4,
  4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
  4,   4,   4,   4,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(V_sy_sym, 8 );
extern Blk(V_sy_string, 264 );
extern UB V_enm_range;
extern Blk(V_typ_std, 248 );
extern SL V_stri_stroffset;
extern V V_comp_typ_ptr;
extern V V_sy_type_gfirst;
extern V V_int_typ;
extern Blk(V_oparg_cvtab, 56 );
extern V V_wildtmp_ide;
extern V V_gen_std_string1;
extern V PAS__f_output;
extern Blk(V_opname, 960 );
extern Blk(V_ope_table, 240 );
extern V V_std_store_dgf;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
V P_all_new_tmp(V F_ty, V F_id);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_tmpstk_allocate(V F_lgt, V F_ty);
V P_ide_search_from_nameid(V F_ip);
void P_insymbol();
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
UB P_compare_entry(V F_pr1, V F_pr2);
V P_exp_genop(UB F_op, V F_oblst);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir);
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl);
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw);


/* Procedure/Function : " set_strname "  */
void P_set_strname(V *F_nam){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=95; /* line # 95 */
  if (V_sy_sym.ub[0]==5) {
    Ra.sl[6]=97; /* line # 97 */
    (*F_nam)=PAS__NEW(32);
    Ra.sl[6]=98; /* line # 98 */
    Rv0=(*F_nam);
    Ra.sl[6]=100; /* line # 100 */
    if (V_sy_string.ub[1]>30) ((UB *)Rv0)[0]=30;
    else {
      Ra.sl[6]=101; /* line # 101 */
      ((UB *)Rv0)[0]=V_sy_string.ub[1];
    }
    Ra.sl[6]=102; /* line # 102 */
    Rv1=1;
    for( Rf0=((UB *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[6]=103; /* line # 103 */
      ((C *)Rv0)[Rv1]=V_sy_string.c[Rv1+1];
      Rv1++;
    }
    Ra.sl[6]=105; /* line # 105 */
    P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_stdname "  */
void P_set_stdname(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+75;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=120; /* line # 120 */
  Rv0=F_pr;
  Ra.sl[6]=122; /* line # 122 */
  if (((V *)Rv0)[3]!=NULL) P_src_error(Rd.s+90,129,1);
  Ra.sl[6]=123; /* line # 123 */
  if (V_sy_sym.ub[0]==5) P_set_strname(((V *)Rv0)+3);
  else {
    Ra.sl[6]=126; /* line # 126 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[6]=127; /* line # 127 */
    P_src_error(Rd.s+90,58,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " same_type "  */
UB P_same_type(V F_ty1, V F_ty2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=141; /* line # 141 */
  V_enm_range=0;
  Ra.sl[6]=142; /* line # 142 */
  Rv0=F_ty1==F_ty2;
  Ra.sl[6]=144; /* line # 144 */
  if (!Rv0) {
    Ra.sl[6]=145; /* line # 145 */
    if (F_ty1!=NULL&&F_ty2!=NULL) {
      Ra.sl[6]=146; /* line # 146 */
      if (((((UB *)F_ty1)[92]==((UB *)F_ty2)[92]&&((V *)F_ty1)[0]==((V *)F_ty2)[
0])&&((V *)F_ty1)[3]==((V *)F_ty2)[3])&&((SL *)F_ty1)[11]==((SL *)F_ty2)[11]) {
        Ra.sl[6]=150; /* line # 150 */
        switch (((UB *)F_ty1)[92]) {
          case 0:
          case 1:
          case 2:Ra.sl[6]=152; /* line # 152 */
          if ((((UB *)F_ty1)[112]==((UB *)F_ty2)[112]&&((SL *)F_ty1)[29]==((SL *)
          F_ty2)[29])&&((SL *)F_ty1)[30]==((SL *)F_ty2)[30]) {
            Ra.sl[6]=154; /* line # 154 */
            Rv0=1;
          }
          break;
          case 3:
          case 4:Ra.sl[6]=155; /* line # 155 */
          Rv0=1;
          break;
          case 5:
          case 7:
          case 13:Ra.sl[6]=157; /* line # 157 */
          Rv0=P_same_type(((V *)F_ty1)[12],((V *)F_ty2)[12]);
          break;
          case 11:
          case 12:Ra.sl[6]=159; /* line # 159 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]) {
            Ra.sl[6]=160; /* line # 160 */
            Rv0=P_same_type(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          }
          break;
          case 8:
          case 9:Ra.sl[6]=162; /* line # 162 */
          if (((SL *)F_ty1)[24]==((SL *)F_ty2)[24]&&((SL *)F_ty1)[25]==((SL *)F_ty2)
          [25]) {
            Ra.sl[6]=164; /* line # 164 */
            if (P_same_type(((V *)F_ty1)[15],((V *)F_ty2)[15])&&P_same_type(((V *)
            F_ty1)[14],((V *)F_ty2)[14])) {
              Ra.sl[6]=166; /* line # 166 */
              Rv0=1;
            }
          }
          break;
          case 22:Ra.sl[6]=168; /* line # 168 */
          Rv0=P_same_type(((V *)F_ty1)[0],((V *)F_ty2)[0]);
          break;
          case 6:Ra.sl[6]=170; /* line # 170 */
          Rv0=P_compare_entry(((V *)F_ty1)[13],((V *)F_ty2)[13]);
          break;
          default:break;
        }
      }
    }
  }
  Ra.sl[6]=173; /* line # 173 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_entry "  */
UB P_compare_entry(V F_pr1, V F_pr2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=186; /* line # 186 */
  if (F_pr1==F_pr2) Rv0=F_pr1!=NULL;
  else {
    Ra.sl[6]=189; /* line # 189 */
    Rv0=0;
    Ra.sl[6]=190; /* line # 190 */
    if (F_pr1!=NULL&&F_pr2!=NULL) {
      Ra.sl[6]=192; /* line # 192 */
      if (((V *)F_pr1)[11]!=((V *)F_pr2)[11]) Rv0=P_same_type(((V *)F_pr1)[11],(
      (V *)F_pr2)[11]);
      else {
        Ra.sl[6]=193; /* line # 193 */
        Rv0=1;
      }
      Ra.sl[6]=194; /* line # 194 */
      if (Rv0) {
        Ra.sl[6]=196; /* line # 196 */
        Rv1=((V *)F_pr1)[8];
        Rv2=((V *)F_pr2)[8];
        Ra.sl[6]=200; /* line # 200 */
        if (Rv1==NULL||Rv2==NULL) Rv0=Rv1==Rv2;
        else while (1){
          Ra.sl[6]=203; /* line # 203 */
          Rv0=P_same_type(((V *)Rv1)[4],((V *)Rv2)[4]);
          Ra.sl[6]=204; /* line # 204 */
          if (Rv0) {
            Ra.sl[6]=206; /* line # 206 */
            if (((UB *)Rv1)[56]==7) {
              Ra.sl[6]=207; /* line # 207 */
              if (((UB *)Rv2)[56]==7) {
                Ra.sl[6]=208; /* line # 208 */
                if (((UB *)((V *)Rv1)[9])[104]==3&&((UB *)((V *)Rv2)[9])[104]==3)
                 {
                  Ra.sl[6]=209; /* line # 209 */
                  Rv0=P_compare_entry(((V *)Rv1)[9],((V *)Rv2)[9]);
                }
                else {
                  Ra.sl[6]=210; /* line # 210 */
                  Rv0=0;
                }
              }
              else {
                Ra.sl[6]=211; /* line # 211 */
                Rv0=0;
              }
            }
            Ra.sl[6]=212; /* line # 212 */
            Rv1=((V *)Rv1)[3];
            Rv2=((V *)Rv2)[3];
          }
          if ((Rv1==NULL||Rv2==NULL)||!Rv0)  break;
        }
        Ra.sl[6]=215; /* line # 215 */
        if (Rv1!=Rv2) Rv0=0;
      }
    }
  }
  Ra.sl[6]=219; /* line # 219 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " compare_proc_argid "  */
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+120;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=233; /* line # 233 */
  Rv0=0;
  Ra.sl[6]=234; /* line # 234 */
  if (F_pgc!=NULL&&F_ent!=NULL) {
    Ra.sl[6]=237; /* line # 237 */
    while (F_pgc!=NULL&&!Rv0){
      Ra.sl[6]=238; /* line # 238 */
      Rv1=F_pgc;
      Ra.sl[6]=240; /* line # 240 */
      if (!((UB *)Rv1)[8]) {
        Ra.sl[6]=242; /* line # 242 */
        Rv2=((V *)Rv1)[2];
        Ra.sl[6]=243; /* line # 243 */
        Rv0=P_compare_entry(Rv2, F_ent);
      }
      Ra.sl[6]=245; /* line # 245 */
      if (!Rv0) {
        Ra.sl[6]=246; /* line # 246 */
        if (F_pgc==F_pgl) F_pgc=NULL;
        else {
          Ra.sl[6]=247; /* line # 247 */
          F_pgc=((V *)F_pgc)[0];
        }
      }
    }
  }
  Ra.sl[6]=250; /* line # 250 */
  if (!Rv0) F_pgc=NULL;
  Ra.sl[6]=251; /* line # 251 */
  Ret=F_pgc;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_scalar "  */
SL PAS_EXPSION_comp_scalar(V F_te, V F_tf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  G Rv2;
  G Rv3;
  register V Rv4;
  G Rv5;
  G Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+140;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=270; /* line # 270 */
  Rv0=4;
  Ra.sl[6]=271; /* line # 271 */
  if (F_te==F_tf) Rv0=0;
  else {
    Ra.sl[6]=272; /* line # 272 */
    if (F_te!=NULL&&F_tf!=NULL) {
      Ra.sl[6]=273; /* line # 273 */
      Rv1=F_te;
      Ra.sl[6]=274; /* line # 274 */
      if (((UB *)Rv1)[92]==((UB *)F_tf)[92]) {
        Ra.sl[6]=275; /* line # 275 */
        if ((((V *)Rv1)[0]==F_tf||F_te==((V *)F_tf)[0])||((V *)Rv1)[0]!=NULL&&((
        V *)Rv1)[0]==((V *)F_tf)[0]) {
          Ra.sl[6]=278; /* line # 278 */
          if (((UB *)Rv1)[112]) {
            Ra.sl[6]=279; /* line # 279 */
            Rv2=(double)((UL *)Rv1)[29];
            Rv3=(double)((UL *)Rv1)[30];
          }
          else {
            Ra.sl[6]=281; /* line # 281 */
            Rv2=(double)((SL *)Rv1)[29];
            Rv3=(double)((SL *)Rv1)[30];
          }
          Ra.sl[6]=282; /* line # 282 */
          Rv4=F_tf;
          Ra.sl[6]=283; /* line # 283 */
          if (((UB *)Rv4)[112]) {
            Ra.sl[6]=284; /* line # 284 */
            Rv5=(double)((UL *)Rv4)[29];
            Rv6=(double)((UL *)Rv4)[30];
          }
          else {
            Ra.sl[6]=286; /* line # 286 */
            Rv5=(double)((SL *)Rv4)[29];
            Rv6=(double)((SL *)Rv4)[30];
          }
          Ra.sl[6]=288; /* line # 288 */
          if (Rv5>Rv2||Rv6<Rv3) V_enm_range=1;
          Ra.sl[6]=290; /* line # 290 */
          if (Rv2<=Rv6&&Rv3>=Rv5) {
            Ra.sl[6]=292; /* line # 292 */
            if (Rv2==Rv5) {
              Ra.sl[6]=293; /* line # 293 */
              if (Rv3==Rv6) Rv0=0;
              else {
                Ra.sl[6]=294; /* line # 294 */
                Rv0=1;
              }
            }
            else {
              Ra.sl[6]=295; /* line # 295 */
              Rv0=2;
            }
          }
          else {
            Ra.sl[6]=296; /* line # 296 */
            Rv0=3;
          }
        }
        else {
          Ra.sl[6]=298; /* line # 298 */
          V_enm_range=1;
        }
      }
    }
  }
  Ra.sl[6]=299; /* line # 299 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " children_type "  */
UB P_children_type(V F_eff, V F_frm, UB F_bpar, UB F_bsym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+153;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=313; /* line # 313 */
  F_bpar=1;
  Ra.sl[6]=314; /* line # 314 */
  if (F_frm!=NULL) {
    Ra.sl[6]=316; /* line # 316 */
    if (F_bpar) {
      Ra.sl[6]=318; /* line # 318 */
      Rv1=F_eff;
      Ra.sl[6]=319; /* line # 319 */
      while (Rv1!=NULL&&Rv1!=F_frm)
      Rv1=((V *)Rv1)[0];
      Ra.sl[6]=320; /* line # 320 */
      Rv0=Rv1==F_frm;
      Ra.sl[6]=321; /* line # 321 */
      if (!Rv0&&F_bsym) Rv0=P_children_type(F_frm, F_eff, F_bpar,0);
    }
    else {
      Ra.sl[6]=323; /* line # 323 */
      Rv0=F_eff==F_frm;
    }
  }
  Ra.sl[6]=325; /* line # 325 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sub_comp_type "  */
UB PAS_EXPSION_PRC_00000000(V F_eff, V F_frm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+168;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=380; /* line # 380 */
  Rv0=F_frm;
  Ra.sl[6]=381; /* line # 381 */
  switch (Ri.ub[((UB *)F_eff)[92]*22+((UB *)Rv0)[92]]) {
    case 4:Ra.sl[6]=382; /* line # 382 */
    Rv1=1;
    break;
    case 1:Ra.sl[6]=385; /* line # 385 */
    switch (((UB *)Rv0)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=389; /* line # 389 */
      if (((UB *)Rv0)[88]) {
        Ra.sl[6]=390; /* line # 390 */
        if (!Lx[0].ub[28]) Rv1=PAS_EXPSION_comp_scalar(F_eff, F_frm)<=2;
        else {
          Ra.sl[6]=391; /* line # 391 */
          Rv1=PAS_EXPSION_comp_scalar(F_eff, F_frm)==0&&((SL *)Rv0)[11]==((SL *)
          F_eff)[11];
        }
      }
      break;
      case 11:
      case 12:Ra.sl[6]=395; /* line # 395 */
      Rv1=P_comp_type(((V *)F_eff)[13],((V *)Rv0)[13],Lx[0].ub[28],0);
      break;
      case 8:Ra.sl[6]=398; /* line # 398 */
      Rv1=((V *)F_eff)[14]==((V *)Rv0)[14]&&P_comp_type(((V *)F_eff)[15],((V *)Rv0)
      [15],1,1);
      break;
      case 9:Ra.sl[6]=402; /* line # 402 */
      Rv1=((V *)F_eff)[14]==((V *)Rv0)[14]&&P_comp_type(((V *)F_eff)[15],((V *)(
      (V *)Rv0)[15])[0],1,1);
      break;
      case 5:Ra.sl[6]=406; /* line # 406 */
      if (((V *)Rv0)[12]==NULL) Rv1=((UB *)F_eff)[92]==5;
      else {
        Ra.sl[6]=407; /* line # 407 */
        Rv1=P_comp_type(((V *)F_eff)[12],((V *)Rv0)[12],1,1);
      }
      break;
      case 6:Ra.sl[6]=410; /* line # 410 */
      if (((V *)Rv0)[13]==NULL) Rv1=((UB *)F_eff)[92]==6;
      else {
        Ra.sl[6]=411; /* line # 411 */
        Rv1=P_comp_proc_arg(((V *)F_eff)[13],((V *)Rv0)[13]);
      }
      break;
      default:break;
    }
    break;
    case 3:Ra.sl[6]=417; /* line # 417 */
    Rv1=P_comp_type(F_frm, V_typ_std.v[10],0,0);
    break;
    case 2:Ra.sl[6]=420; /* line # 420 */
    if (P_comp_type(F_eff, V_typ_std.v[10],0,0)) {
      Ra.sl[6]=422; /* line # 422 */
      Rv1=P_comp_type(((V *)((V *)F_eff)[13])[4],F_frm,0,0);
    }
    break;
    default:Ra.sl[6]=426; /* line # 426 */
    Rv1=0;
    break;
  }
  Ra.sl[6]=428; /* line # 428 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " comp_type "  */
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_exact;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+183;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=433; /* line # 433 */
  V_enm_range=0;
  Ra.sl[6]=435; /* line # 435 */
  Rv0=0;
  Ra.sl[6]=436; /* line # 436 */
  if (F_eff!=NULL&&F_frm!=NULL) {
    Ra.sl[6]=438; /* line # 438 */
    Rv0=P_children_type(F_eff, F_frm,!Ra.ub[28],F_sym);
    Ra.sl[6]=439; /* line # 439 */
    if (!Rv0) {
      Ra.sl[6]=440; /* line # 440 */
      Rv1=F_frm;
      Ra.sl[6]=442; /* line # 442 */
      if (((UB *)Rv1)[92]==22) {
        Ra.sl[6]=443; /* line # 443 */
        Rv0=P_comp_type(((V *)Rv1)[0],F_eff, Ra.ub[28],0);
      }
      Ra.sl[6]=445; /* line # 445 */
      if (!Rv0) {
        Ra.sl[6]=446; /* line # 446 */
        if (((UB *)F_eff)[92]<=21&&((UB *)Rv1)[92]<=21) {
          Ra.sl[6]=448; /* line # 448 */
          Rv0=PAS_EXPSION_PRC_00000000(F_eff, F_frm);
          Ra.sl[6]=449; /* line # 449 */
          if (!Rv0&&F_sym) Rv0=PAS_EXPSION_PRC_00000000(F_frm, F_eff);
        }
      }
    }
  }
  Ra.sl[6]=453; /* line # 453 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " comp_proc_arg "  */
UB P_comp_proc_arg(V F_epr, V F_fpr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=467; /* line # 467 */
  Rv0=1;
  Ra.sl[6]=468; /* line # 468 */
  if (F_epr!=F_fpr) {
    Ra.sl[6]=469; /* line # 469 */
    if (F_epr!=NULL&&F_fpr!=NULL) {
      Ra.sl[6]=471; /* line # 471 */
      if (((V *)F_epr)[11]!=((V *)F_fpr)[11]) {
        Ra.sl[6]=472; /* line # 472 */
        Rv0=0;
      }
      else {
        Ra.sl[6]=475; /* line # 475 */
        Rv1=((V *)F_epr)[8];
        Ra.sl[6]=476; /* line # 476 */
        Rv2=((V *)F_fpr)[8];
        Ra.sl[6]=477; /* line # 477 */
        if (((V *)F_epr)[11]!=NULL) {
          Ra.sl[6]=478; /* line # 478 */
          Rv1=((V *)Rv1)[3];
          Rv2=((V *)Rv2)[3];
        }
        Ra.sl[6]=479; /* line # 479 */
        while ((Rv1!=NULL&&Rv2!=NULL)&&Rv0){
          Ra.sl[6]=481; /* line # 481 */
          if (((UB *)Rv2)[56]!=((UB *)Rv1)[56]) Rv0=0;
          else {
            Ra.sl[6]=483; /* line # 483 */
            switch (((UB *)Rv2)[56]) {
              case 5:Ra.sl[6]=485; /* line # 485 */
              Rv0=P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],((UB *)Rv2)[94]!=8,0);
              break;
              case 7:Ra.sl[6]=488; /* line # 488 */
              if (P_comp_type(((V *)Rv1)[4],((V *)Rv2)[4],1,0)) Rv0=P_comp_proc_arg((
              (V *)Rv1)[9],((V *)Rv2)[9]);
              else {
                Ra.sl[6]=489; /* line # 489 */
                Rv0=0;
              }
              break;
              default:break;
            }
          }
          Ra.sl[6]=494; /* line # 494 */
          Rv1=((V *)Rv1)[3];
          Ra.sl[6]=495; /* line # 495 */
          Rv2=((V *)Rv2)[3];
        }
      }
      Ra.sl[6]=498; /* line # 498 */
      if (Rv1!=NULL||Rv2!=NULL) Rv0=0;
    }
    else {
      Ra.sl[6]=500; /* line # 500 */
      Rv0=0;
    }
  }
  Ra.sl[6]=501; /* line # 501 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " type_parm_cte_init "  */
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+209;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=519; /* line # 519 */
  if (F_ty!=NULL) {
    Ra.sl[6]=520; /* line # 520 */
    Rv0=F_ty;
    Ra.sl[6]=522; /* line # 522 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=523; /* line # 523 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=524; /* line # 524 */
    while (Rv1!=NULL){
      Ra.sl[6]=525; /* line # 525 */
      Rv3=Rv1;
      Ra.sl[6]=527; /* line # 527 */
      Rv4=P_lgt_type_eval(Rv2,NULL,NULL,0);
      Ra.sl[6]=528; /* line # 528 */
      Rv5=Rv4;
      Ra.sl[6]=530; /* line # 530 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      Ra.sl[6]=531; /* line # 531 */
      if (((UB *)Rv5)[40]!=14) P_src_error(Rd.s+231,132,3);
      else {
        Ra.sl[6]=533; /* line # 533 */
        Rv6=((V *)Rv5)[7];
        Ra.sl[6]=534; /* line # 534 */
        ((SL *)Rv6)[6]=((SL *)((V *)Rv3)[4])[11];
        ((V *)Rv6)[4]=((V *)Rv3)[4];
      }
      Ra.sl[6]=535; /* line # 535 */
      ((SL *)Rv5)[4]=((SL *)Rv3)[15];
      Ra.sl[6]=537; /* line # 537 */
      ((V *)Rv3)[10]=Rv4;
      Ra.sl[6]=538; /* line # 538 */
      ((UB *)Rv3)[64]=1;
      Ra.sl[6]=539; /* line # 539 */
      if ((*F_lghf)==NULL) (*F_lghf)=Rv4;
      else {
        Ra.sl[6]=540; /* line # 540 */
        ((V *)(*F_lghl))[0]=Rv4;
      }
      Ra.sl[6]=541; /* line # 541 */
      (*F_lghl)=Rv4;
      Ra.sl[6]=542; /* line # 542 */
      (*F_count)=(*F_count)+1;
      Ra.sl[6]=543; /* line # 543 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=544; /* line # 544 */
      Rv1=((V *)Rv3)[3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_cte_release "  */
void P_type_parm_cte_release(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+235;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=559; /* line # 559 */
  Rv0=((V *)F_ty)[4];
  Ra.sl[6]=560; /* line # 560 */
  while (Rv0!=NULL){
    Ra.sl[6]=561; /* line # 561 */
    Rv1=Rv0;
    Ra.sl[6]=563; /* line # 563 */
    ((UB *)Rv1)[64]=0;
    Ra.sl[6]=564; /* line # 564 */
    ((V *)Rv1)[10]=NULL;
    Ra.sl[6]=565; /* line # 565 */
    Rv0=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_array "  */
void P_string_in_array(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  register V Rv15;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+258;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=582; /* line # 582 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=583; /* line # 583 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=585; /* line # 585 */
    Rv2=NULL;
    Ra.sl[6]=586; /* line # 586 */
    Rv3=((SL *)Rv1)[11];
    Ra.sl[6]=587; /* line # 587 */
    Rv4=NULL;
    Ra.sl[6]=588; /* line # 588 */
    Rv5=NULL;
    Ra.sl[6]=589; /* line # 589 */
    Rv6=0;
    Ra.sl[6]=590; /* line # 590 */
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=597; /* line # 597 */
      P_type_parm_cte_init(F_ty, &Rv4, &Rv5, &Rv6);
      Ra.sl[6]=598; /* line # 598 */
      while (Rv4!=NULL){
        Ra.sl[6]=600; /* line # 600 */
        Rv5=Rv4;
        Ra.sl[6]=601; /* line # 601 */
        Rv4=((V *)Rv4)[0];
        Ra.sl[6]=602; /* line # 602 */
        Rv7=Rv5;
        Ra.sl[6]=604; /* line # 604 */
        Rv8=NULL;
        Ra.sl[6]=605; /* line # 605 */
        P_val_copy(((V *)Rv7)+7,&Rv8,1);
        Ra.sl[6]=606; /* line # 606 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=607; /* line # 607 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=608; /* line # 608 */
        Rv2=Rv8;
        Ra.sl[6]=610; /* line # 610 */
        P_lgt_free(&Rv5);
      }
      Ra.sl[6]=612; /* line # 612 */
      Rv3=Rv3-((SL *)Rv1)[10];
    }
    Ra.sl[6]=615; /* line # 615 */
    if (Rv3<=0) {
      Ra.sl[6]=616; /* line # 616 */
      if (((V *)Rv1)[7]!=NULL) {
        Ra.sl[6]=617; /* line # 617 */
        Rv3=((SL *)((V *)((V *)Rv1)[7])[7])[13];
      }
    }
    Ra.sl[6]=619; /* line # 619 */
    switch (((UB *)((V *)Rv0)[7])[48]) {
      case 0:Ra.sl[6]=622; /* line # 622 */
      if (Rv3<=0) Rv3=1;
      Ra.sl[6]=623; /* line # 623 */
      if (Rv2==NULL) Rv9=((V *)Rv0)[7];
      else {
        Ra.sl[6]=624; /* line # 624 */
        ((V *)Rv2)[0]=((V *)Rv0)[7];
      }
      Ra.sl[6]=625; /* line # 625 */
      Rv2=((V *)Rv0)[7];
      Ra.sl[6]=626; /* line # 626 */
      ((V *)Rv0)[7]=NULL;
      Ra.sl[6]=627; /* line # 627 */
      for( Rf0=Rv3-1;Rf0>0;Rf0-- ) {
        Ra.sl[6]=629; /* line # 629 */
        Rv8=NULL;
        Ra.sl[6]=630; /* line # 630 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=631; /* line # 631 */
        ((SL *)Rv8)[13]=32;
        Ra.sl[6]=632; /* line # 632 */
        ((V *)Rv2)[0]=Rv8;
        Ra.sl[6]=633; /* line # 633 */
        Rv2=Rv8;
      }
      break;
      case 29:Ra.sl[6]=639; /* line # 639 */
      Rv10=((V *)((V *)Rv0)[7])[7];
      Ra.sl[6]=640; /* line # 640 */
      if (Rv10==NULL) Rv11=0;
      else {
        Ra.sl[6]=641; /* line # 641 */
        Rv11=((UB *)Rv10)[1];
      }
      Ra.sl[6]=642; /* line # 642 */
      if (Rv3<=0) {
        Ra.sl[6]=643; /* line # 643 */
        if (((V *)Rv1)[9]!=NULL) {
          Ra.sl[6]=645; /* line # 645 */
          Rv12=P_lgt_type_eval(((V *)Rv1)[9],NULL,NULL,0);
          Ra.sl[6]=646; /* line # 646 */
          if (Rv12!=NULL) {
            Ra.sl[6]=647; /* line # 647 */
            Rv13=Rv12;
            Ra.sl[6]=648; /* line # 648 */
            if (((UB *)Rv13)[40]==14) {
              Ra.sl[6]=649; /* line # 649 */
              if (((V *)Rv13)[7]!=NULL) Rv3=((SL *)((V *)Rv13)[7])[13];
            }
          }
        }
      }
      Ra.sl[6]=652; /* line # 652 */
      if (Rv3<=0) Rv3=Rv11;
      Ra.sl[6]=653; /* line # 653 */
      Rv14=1;
      for( Rf0=Rv3;Rf0>0;Rf0-- ) {
        Ra.sl[6]=655; /* line # 655 */
        Rv8=NULL;
        Ra.sl[6]=656; /* line # 656 */
        P_val_new(&Rv8, V_typ_std.v[0]);
        Ra.sl[6]=657; /* line # 657 */
        if (Rv14<=Rv11) ((SL *)Rv8)[13]=(SL)((C *)Rv10)[Rv14+1];
        else {
          Ra.sl[6]=658; /* line # 658 */
          ((SL *)Rv8)[13]=32;
        }
        Ra.sl[6]=659; /* line # 659 */
        if (Rv2==NULL) Rv9=Rv8;
        else {
          Ra.sl[6]=660; /* line # 660 */
          ((V *)Rv2)[0]=Rv8;
        }
        Ra.sl[6]=661; /* line # 661 */
        Rv2=Rv8;
        Rv14++;
      }
      break;
      default:break;
    }
    Ra.sl[6]=666; /* line # 666 */
    if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    Ra.sl[6]=667; /* line # 667 */
    P_val_new(((V *)Rv0)+7,F_ty);
    Ra.sl[6]=668; /* line # 668 */
    Rv15=((V *)Rv0)[7];
    Ra.sl[6]=670; /* line # 670 */
    ((V *)Rv15)[7]=Rv9;
    Ra.sl[6]=671; /* line # 671 */
    ((SL *)Rv15)[6]=Rv3;
    Ra.sl[6]=672; /* line # 672 */
    ((SL *)Rv15)[2]=Rv6;
    Ra.sl[6]=675; /* line # 675 */
    if (((V *)Rv1)[4]!=NULL) P_type_parm_cte_release(F_ty);
  }
  Ra.sl[6]=677; /* line # 677 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " string_in_substring "  */
void P_string_in_substring(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+275;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=691; /* line # 691 */
  if (((V *)F_lgt)[7]!=NULL) {
    Ra.sl[6]=692; /* line # 692 */
    Rv0=F_lgt;
    Rv1=F_ty;
    Ra.sl[6]=694; /* line # 694 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=695; /* line # 695 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=696; /* line # 696 */
    P_val_copy(&Rv2,((V *)Rv0)+7,1);
    Ra.sl[6]=697; /* line # 697 */
    Rv3=((V *)Rv0)[7];
    Ra.sl[6]=699; /* line # 699 */
    ((SL *)Rv3)[6]=((SL *)Rv1)[11]-V_stri_stroffset;
    Ra.sl[6]=700; /* line # 700 */
    ((V *)Rv3)[4]=F_ty;
  }
  Ra.sl[6]=703; /* line # 703 */
  ((V *)F_lgt)[3]=F_ty;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " initialize_varbl "  */
void P_initialize_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+296;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=715; /* line # 715 */
  Rv0=F_ip;
  Rv1=((V *)Rv0)[6];
  Ra.sl[6]=717; /* line # 717 */
  ((UW *)Rv0)[46]=((UW *)Rv0)[46]|8;
  Ra.sl[6]=719; /* line # 719 */
  P_lgt_new(&Rv2,((V *)Rv0)[4],14,NULL);
  Ra.sl[6]=720; /* line # 720 */
  Rv3=Rv2;
  Ra.sl[6]=722; /* line # 722 */
  ((V *)Rv3)[7]=((V *)Rv0)[8];
  Ra.sl[6]=723; /* line # 723 */
  P_val_new(((V *)Rv3)+7,NULL);
  Ra.sl[6]=725; /* line # 725 */
  Rv2=P_lgt_new_idref(F_ip, Rv2);
  Ra.sl[6]=728; /* line # 728 */
  if (((UB *)((V *)Rv0)[4])[92]==7||((UB *)((V *)Rv0)[4])[92]==16) {
    Ra.sl[6]=729; /* line # 729 */
    Rv2=P_lgt_new_code(3, Rv2);
  }
  else {
    Ra.sl[6]=731; /* line # 731 */
    Rv2=P_exp_genop(28, Rv2);
  }
  Ra.sl[6]=734; /* line # 734 */
  switch (((UB *)Rv1)[104]) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:Ra.sl[6]=737; /* line # 737 */
    if (((V *)Rv1)[18]==NULL) ((V *)Rv1)[18]=Rv2;
    else {
      Ra.sl[6]=738; /* line # 738 */
      ((V *)((V *)Rv1)[17])[0]=Rv2;
    }
    Ra.sl[6]=739; /* line # 739 */
    ((V *)Rv1)[17]=Rv2;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_check_parm "  */
void P_type_check_parm(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+314;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=759; /* line # 759 */
  Rv0=F_lgt;
  Ra.sl[6]=760; /* line # 760 */
  switch (((UB *)Rv0)[40]) {
    case 13:Ra.sl[6]=762; /* line # 762 */
    Rv1=((V *)Rv0)[6];
    Ra.sl[6]=763; /* line # 763 */
    if (((UB *)Rv1)[56]!=2) {
      Ra.sl[6]=765; /* line # 765 */
      P_src_error_s(Rd.s+333,201,3,((V *)Rv1)[0],NULL);
    }
    break;
    case 14:break;
    case 6:Ra.sl[6]=771; /* line # 771 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[6]=772; /* line # 772 */
    while (Rv2!=NULL){
      Ra.sl[6]=774; /* line # 774 */
      P_type_check_parm(Rv2);
      Ra.sl[6]=775; /* line # 775 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[6]=777; /* line # 777 */
    switch (((UB *)Rv0)[41]) {
      case 2:
      case 6:
      case 7:
      case 13:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 43:
      case 44:
      case 46:
      case 47:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 89:break;
      default:Ra.sl[6]=785; /* line # 785 */
      P_src_error(Rd.s+333,202,3);
      break;
    }
    break;
    case 16:Ra.sl[6]=791; /* line # 791 */
    if (((V *)Rv0)[3]==NULL) P_src_error(Rd.s+333,203,3);
    break;
    default:Ra.sl[6]=795; /* line # 795 */
    P_src_error(Rd.s+333,204,3);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " subtype_set_value "  */
void PAS_EXPSION_PRC_00000001(V *F_lgr, SL *F_irv, V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+337;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=819; /* line # 819 */
  if (F_lgp==NULL) (*F_lgr)=NULL;
  else {
    Ra.sl[6]=822; /* line # 822 */
    (*F_lgr)=P_lgt_type_eval(F_lgp,NULL,NULL,0);
    Ra.sl[6]=823; /* line # 823 */
    if ((*F_lgr)!=NULL) {
      Ra.sl[6]=825; /* line # 825 */
      if ((*F_irv)<0&&((UB *)(*F_lgr))[40]==14) {
        Ra.sl[6]=827; /* line # 827 */
        if (((V *)(*F_lgr))[7]!=NULL) (*F_irv)=((SL *)((V *)(*F_lgr))[7])[13];
        Ra.sl[6]=828; /* line # 828 */
        P_lgt_free(F_lgr);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_parm_set "  */
V P_type_parm_set(V F_ip, V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+356;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=836; /* line # 836 */
  Rv0=0;
  Ra.sl[6]=837; /* line # 837 */
  Rv1=F_lgt;
  Ra.sl[6]=838; /* line # 838 */
  Rv2=F_ip;
  Ra.sl[6]=840; /* line # 840 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=841; /* line # 841 */
  while (Rv3!=NULL&&Rv1!=NULL){
    Ra.sl[6]=844; /* line # 844 */
    Rv4=Rv3;
    Rv5=Rv1;
    Ra.sl[6]=845; /* line # 845 */
    if (P_comp_type(((V *)Rv5)[3],((V *)Rv4)[4],0,0)) {
      Ra.sl[6]=848; /* line # 848 */
      P_type_check_parm(Rv1);
      Ra.sl[6]=849; /* line # 849 */
      ((UB *)Rv4)[64]=2;
      Ra.sl[6]=850; /* line # 850 */
      ((V *)Rv4)[10]=Rv1;
    }
    else {
      Ra.sl[6]=853; /* line # 853 */
      P_src_error_s(Rd.s+373,201,3,((V *)Rv4)[0],NULL);
    }
    Ra.sl[6]=855; /* line # 855 */
    Rv1=((V *)Rv1)[0];
    Ra.sl[6]=856; /* line # 856 */
    Rv3=((V *)Rv3)[3];
  }
  Ra.sl[6]=859; /* line # 859 */
  if (Rv1!=NULL||Rv3!=NULL) P_src_error(Rd.s+373,998,3);
  Ra.sl[6]=861; /* line # 861 */
  if (((UB *)((V *)Rv2)[4])[92]==27) {
    Ra.sl[6]=863; /* line # 863 */
    Rv1=P_lgt_type_eval(((V *)((V *)Rv2)[4])[9],NULL,NULL,0);
    Ra.sl[6]=865; /* line # 865 */
    if (((UB *)Rv1)[40]==14) Rv6=V_comp_typ_ptr;
    else {
      Ra.sl[6]=866; /* line # 866 */
      P_src_error(Rd.s+373,222,3);
    }
  }
  else {
    Ra.sl[6]=870; /* line # 870 */
    P_ide_new_typ(((UB *)((V *)Rv2)[4])[92],&Rv6);
    Ra.sl[6]=871; /* line # 871 */
    Rv7=Rv6;
    Ra.sl[6]=873; /* line # 873 */
    ((UB *)Rv7)[89]=1;
    Ra.sl[6]=874; /* line # 874 */
    ((V *)Rv7)[0]=((V *)Rv2)[4];
    Ra.sl[6]=875; /* line # 875 */
    ((V *)Rv7)[4]=((V *)((V *)Rv2)[4])[4];
    Ra.sl[6]=876; /* line # 876 */
    ((SL *)Rv7)[11]=((SL *)((V *)Rv2)[4])[11];
    Ra.sl[6]=877; /* line # 877 */
    ((SL *)Rv7)[10]=((SL *)((V *)Rv2)[4])[10];
    Ra.sl[6]=878; /* line # 878 */
    memcpy(Rv7+48,((V *)Rv2)[4]+48,1);
    Ra.sl[6]=879; /* line # 879 */
    ((V *)Rv7)[10]=((V *)((V *)Rv2)[4])[10];
    Ra.sl[6]=880; /* line # 880 */
    ((UB *)Rv7)[90]=((UB *)((V *)Rv2)[4])[90];
    Ra.sl[6]=882; /* line # 882 */
    V_sy_type_gfirst=((V *)Rv2)[10];
    Ra.sl[6]=883; /* line # 883 */
    ((V *)Rv7)[7]=F_lgt;
    Ra.sl[6]=885; /* line # 885 */
    PAS_EXPSION_PRC_00000001(((V *)Rv7)+9,((SL *)Rv7)+11,((V *)((V *)Rv2)[4])[9]
    );
    Ra.sl[6]=887; /* line # 887 */
    switch (((UB *)Rv7)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=890; /* line # 890 */
      ((SL *)Rv7)[29]=((SL *)((V *)Rv7)[0])[29];
      Ra.sl[6]=891; /* line # 891 */
      ((SL *)Rv7)[30]=((SL *)((V *)Rv7)[0])[30];
      Ra.sl[6]=892; /* line # 892 */
      ((UB *)Rv7)[112]=((UB *)((V *)Rv7)[0])[112];
      Ra.sl[6]=893; /* line # 893 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 22:Ra.sl[6]=898; /* line # 898 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+12,&Rv0,((V *)((V *)Rv2)[4])[12]);
      Ra.sl[6]=899; /* line # 899 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+14,&Rv0,((V *)((V *)Rv2)[4])[14]);
      Ra.sl[6]=900; /* line # 900 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,&Rv0,((V *)((V *)Rv2)[4])[13]);
      break;
      case 3:
      case 4:break;
      case 5:
      case 24:
      case 26:Ra.sl[6]=906; /* line # 906 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      break;
      case 11:
      case 12:Ra.sl[6]=909; /* line # 909 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      break;
      case 8:Ra.sl[6]=920; /* line # 920 */
      ((SL *)Rv7)[25]=((SL *)((V *)Rv7)[0])[25];
      Ra.sl[6]=921; /* line # 921 */
      PAS_EXPSION_PRC_00000001(((V *)Rv7)+13,((SL *)Rv7)+25,((V *)((V *)Rv2)[4])
      [13]);
      Ra.sl[6]=923; /* line # 923 */
      ((V *)Rv7)[14]=((V *)((V *)Rv7)[0])[14];
      Ra.sl[6]=924; /* line # 924 */
      ((V *)Rv7)[15]=((V *)((V *)Rv7)[0])[15];
      break;
      case 10:Ra.sl[6]=933; /* line # 933 */
      ((V *)Rv7)[12]=((V *)((V *)Rv7)[0])[12];
      Ra.sl[6]=934; /* line # 934 */
      ((V *)Rv7)[13]=((V *)((V *)Rv7)[0])[13];
      Ra.sl[6]=935; /* line # 935 */
      if (((V *)((V *)Rv7)[0])[14]!=NULL) {
        Ra.sl[6]=936; /* line # 936 */
        ((V *)Rv7)[14]=P_lgt_link(((V *)((V *)Rv7)[0])[14]);
      }
      else {
        Ra.sl[6]=938; /* line # 938 */
        ((V *)Rv7)[14]=NULL;
      }
      break;
      default:Ra.sl[6]=943; /* line # 943 */
      P_src_error(Rd.s+373,998,3);
      break;
    }
  }
  Ra.sl[6]=949; /* line # 949 */
  Rv3=((V *)((V *)Rv2)[4])[4];
  Ra.sl[6]=951; /* line # 951 */
  while (Rv3!=NULL){
    Ra.sl[6]=952; /* line # 952 */
    Rv8=Rv3;
    Ra.sl[6]=954; /* line # 954 */
    ((V *)Rv8)[10]=NULL;
    Ra.sl[6]=955; /* line # 955 */
    ((UB *)Rv8)[64]=0;
    Ra.sl[6]=956; /* line # 956 */
    Rv3=((V *)Rv8)[3];
  }
  Ra.sl[6]=960; /* line # 960 */
  Ret=Rv6;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_tab "  */
void PAS_EXPSION_PRC_00000003(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+377;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=994; /* line # 994 */
  Rv0=F_ty;
  Ra.sl[6]=995; /* line # 995 */
  if (((V *)Rv0)[15]!=NULL&&((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=998; /* line # 998 */
    Rv1=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
    Ra.sl[6]=1001; /* line # 1001 */
    ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,0);
    Ra.sl[6]=1002; /* line # 1002 */
    Rv2=P_lgt_new_code(3, Rv1);
    Ra.sl[6]=1005; /* line # 1005 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
    else {
      Ra.sl[6]=1006; /* line # 1006 */
      ((V *)(*F_lgl))[0]=Rv2;
    }
    Ra.sl[6]=1007; /* line # 1007 */
    (*F_lgl)=Rv2;
    Ra.sl[6]=1010; /* line # 1010 */
    Rv3=1;
    Ra.sl[6]=1011; /* line # 1011 */
    if (((V *)Rv0)[13]!=NULL) {
      Ra.sl[6]=1013; /* line # 1013 */
      Rv4=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
      Ra.sl[6]=1014; /* line # 1014 */
      if (((UB *)Rv4)[40]!=14&&((UB *)Rv4)[40]!=13) {
        Ra.sl[6]=1017; /* line # 1017 */
        Rv2=P_all_new_tmp(V_int_typ, Lx[2].v[4]);
        Ra.sl[6]=1020; /* line # 1020 */
        ((V *)Rv2)[0]=Rv4;
        Rv4=P_lgt_link(Rv2);
        Ra.sl[6]=1021; /* line # 1021 */
        Rv2=P_lgt_new_code(3, Rv2);
        Ra.sl[6]=1023; /* line # 1023 */
        if ((*F_lgh)==NULL) (*F_lgh)=Rv2;
        else {
          Ra.sl[6]=1024; /* line # 1024 */
          ((V *)(*F_lgl))[0]=Rv2;
        }
        Ra.sl[6]=1025; /* line # 1025 */
        (*F_lgl)=Rv2;
        Ra.sl[6]=1026; /* line # 1026 */
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1029; /* line # 1029 */
      Rv4=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
    }
    Ra.sl[6]=1032; /* line # 1032 */
    if (Lx[2].ub[28]) {
      Ra.sl[6]=1034; /* line # 1034 */
      P_lgt_new(&Rv2, F_ty,2, P_lgt_link(F_trg));
      Ra.sl[6]=1035; /* line # 1035 */
      ((SL *)Rv2)[4]=((SL *)Rv2)[4]+((SL *)Rv0)[10];
    }
    else {
      Ra.sl[6]=1037; /* line # 1037 */
      P_lgt_new_copy(F_trg, &Rv2);
    }
    Ra.sl[6]=1039; /* line # 1039 */
    Rv5=P_lgt_link(Rv1);
    ((V *)Rv5)[0]=Rv4;
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=1042; /* line # 1042 */
    Rv6=Rv2;
    ((UW *)Rv6)[10]=((UW *)Rv6)[10]|4;
    Ra.sl[6]=1043; /* line # 1043 */
    P_lgt_new(&Rv2,((V *)Rv0)[14],1, Rv2);
    Ra.sl[6]=1044; /* line # 1044 */
    Rv7=((V *)Rv0)[14];
    Rv8=Rv2;
    Ra.sl[6]=1046; /* line # 1046 */
    ((V *)Rv8)[6]=F_ty;
    Ra.sl[6]=1047; /* line # 1047 */
    if (((UB *)Rv7)[92]!=10&&((UB *)Rv7)[92]!=23) {
      Ra.sl[6]=1048; /* line # 1048 */
      ((SL *)Rv8)[4]=((SL *)Rv8)[4]+((SL *)Rv7)[10];
    }
    Ra.sl[6]=1049; /* line # 1049 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=1058; /* line # 1058 */
    Rv9=((V *)Rv0)[15];
    Ra.sl[6]=1059; /* line # 1059 */
    if (((UB *)Rv9)[92]!=22) {
      Ra.sl[6]=1061; /* line # 1061 */
      if (((UB *)Rv9)[112]) Rv10=(((UL *)Rv9)[30]-((UL *)Rv9)[29])+1;
      else {
        Ra.sl[6]=1062; /* line # 1062 */
        Rv10=(((SL *)Rv9)[30]-((SL *)Rv9)[29])+1;
      }
      Ra.sl[6]=1063; /* line # 1063 */
      Rv11=P_lgt_new_econst(((V *)Rv9)[15],Rv10);
    }
    else {
      Ra.sl[6]=1065; /* line # 1065 */
      Rv11=P_lgt_type_eval(((V *)Rv9)[12],NULL,NULL,0);
    }
    Ra.sl[6]=1067; /* line # 1067 */
    Rv12=Rv11;
    Ra.sl[6]=1068; /* line # 1068 */
    PAS_EXPSION_PRC_00000002(((V *)Rv0)[14],Rv2, &Rv11, &Rv12,0);
    Ra.sl[6]=1071; /* line # 1071 */
    ((V *)Rv12)[0]=P_lgt_new_code(38, P_lgt_link(Rv1));
    Ra.sl[6]=1079; /* line # 1079 */
    P_lgt_new(&Rv5, V_typ_std.v[2],0, Rv11);
    Ra.sl[6]=1080; /* line # 1080 */
    ((UB *)Rv5)[41]=5;
    Ra.sl[6]=1083; /* line # 1083 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv5;
    else {
      Ra.sl[6]=1084; /* line # 1084 */
      ((V *)(*F_lgl))[0]=Rv5;
    }
    Ra.sl[6]=1085; /* line # 1085 */
    (*F_lgl)=Rv5;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dyn_rec_gsl "  */
V PAS_EXPSION_PRC_00000005(V F_ty, V F_lgtw){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+391;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1109; /* line # 1109 */
  Rv0=NULL;
  Ra.sl[6]=1110; /* line # 1110 */
  Rv1=NULL;
  Ra.sl[6]=1111; /* line # 1111 */
  PAS_EXPSION_PRC_00000004(F_ty, Lx[1].v[4],&Rv0, &Rv1);
  Ra.sl[6]=1112; /* line # 1112 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1114; /* line # 1114 */
    if (Rv1!=Rv0) {
      Ra.sl[6]=1116; /* line # 1116 */
      P_lgt_new(&Rv0,NULL,0, Rv0);
      Ra.sl[6]=1117; /* line # 1117 */
      ((UB *)Rv0)[41]=2;
    }
  }
  Ra.sl[6]=1120; /* line # 1120 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_dyn_rec "  */
void PAS_EXPSION_PRC_00000004(V F_ty, V F_trg, V *F_lgh, V *F_lgl){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_trg;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+404;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1126; /* line # 1126 */
  Rv0=F_ty;
  Ra.sl[6]=1128; /* line # 1128 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1130; /* line # 1130 */
  while (Rv1!=NULL){
    Ra.sl[6]=1131; /* line # 1131 */
    Rv2=Rv1;
    Ra.sl[6]=1133; /* line # 1133 */
    if (((V *)Rv2)[4]!=NULL) {
      Ra.sl[6]=1134; /* line # 1134 */
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1136; /* line # 1136 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Ra.sl[6]=1139; /* line # 1139 */
        if (Lx[2].ub[28]) P_lgt_new(&Rv4,((V *)Rv2)[4],2, P_lgt_link(Ra.v[4]));
        else {
          Ra.sl[6]=1140; /* line # 1140 */
          P_lgt_new_copy(Ra.v[4],&Rv4);
        }
        Ra.sl[6]=1141; /* line # 1141 */
        Rv5=Rv4;
        Ra.sl[6]=1143; /* line # 1143 */
        ((V *)Rv5)[4]=Rv1;
        Ra.sl[6]=1145; /* line # 1145 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv2)[15];
        Ra.sl[6]=1148; /* line # 1148 */
        if (((UB *)Rv3)[92]!=10&&((UB *)Rv3)[92]!=23) {
          Ra.sl[6]=1149; /* line # 1149 */
          ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)((V *)Rv2)[4])[10];
        }
        Ra.sl[6]=1151; /* line # 1151 */
        PAS_EXPSION_PRC_00000002(((V *)Rv2)[4],Rv4, F_lgh,F_lgl,0);
      }
      Ra.sl[6]=1153; /* line # 1153 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1154; /* line # 1154 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1158; /* line # 1158 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1161; /* line # 1161 */
    P_lgt_new_copy(((V *)Rv0)[14],&Rv6);
    Ra.sl[6]=1163; /* line # 1163 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv6;
    else {
      Ra.sl[6]=1164; /* line # 1164 */
      ((V *)(*F_lgl))[0]=Rv6;
    }
    Ra.sl[6]=1165; /* line # 1165 */
    (*F_lgl)=Rv6;
    Ra.sl[6]=1166; /* line # 1166 */
    Rv7=((V *)((V *)Rv0)[14])[1];
    Ra.sl[6]=1169; /* line # 1169 */
    P_lgt_new_copy(Rv7, &Rv4);
    Ra.sl[6]=1170; /* line # 1170 */
    ((V *)Rv6)[1]=Rv4;
    Ra.sl[6]=1171; /* line # 1171 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1174; /* line # 1174 */
    Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
    Ra.sl[6]=1175; /* line # 1175 */
    ((V *)Rv4)[0]=Rv6;
    Ra.sl[6]=1176; /* line # 1176 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1179; /* line # 1179 */
    Rv4=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1180; /* line # 1180 */
    ((V *)Rv6)[0]=Rv4;
    Ra.sl[6]=1181; /* line # 1181 */
    Rv7=((V *)Rv7)[0];
    Ra.sl[6]=1182; /* line # 1182 */
    while (Rv7!=NULL){
      Ra.sl[6]=1184; /* line # 1184 */
      Rv6=PAS_EXPSION_PRC_00000005(((V *)Rv7)[3],Rv7);
      Ra.sl[6]=1185; /* line # 1185 */
      ((V *)Rv4)[0]=Rv6;
      Ra.sl[6]=1186; /* line # 1186 */
      Rv4=Rv6;
      Rv7=((V *)Rv7)[0];
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " init_dyn_d "  */
void PAS_EXPSION_PRC_00000002(V F_ty, V F_trg, V *F_lgh, V *F_lgl, UB F_bindir){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+418;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1213; /* line # 1213 */
  Rv0=F_ty;
  Ra.sl[6]=1215; /* line # 1215 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1217; /* line # 1217 */
    Rv1=((V *)Rv0)[4];
    Ra.sl[6]=1218; /* line # 1218 */
    Rv2=((V *)Rv0)[7];
    Ra.sl[6]=1219; /* line # 1219 */
    while (Rv1!=NULL&&Rv2!=NULL){
      Ra.sl[6]=1220; /* line # 1220 */
      Rv3=Rv1;
      Ra.sl[6]=1223; /* line # 1223 */
      if (F_bindir) P_lgt_new(&Rv4,((V *)Rv3)[4],2, P_lgt_link(F_trg));
      else {
        Ra.sl[6]=1224; /* line # 1224 */
        P_lgt_new_copy(F_trg, &Rv4);
      }
      Ra.sl[6]=1227; /* line # 1227 */
      Rv5=Rv4;
      Rv6=F_ty;
      Ra.sl[6]=1229; /* line # 1229 */
      ((V *)Rv5)[3]=((V *)Rv3)[4];
      Ra.sl[6]=1230; /* line # 1230 */
      ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
      Ra.sl[6]=1231; /* line # 1231 */
      if (((UB *)Rv6)[92]!=10&&((UB *)Rv6)[92]!=23) {
        Ra.sl[6]=1232; /* line # 1232 */
        ((SL *)Rv5)[4]=((SL *)Rv5)[4]-((SL *)Rv6)[10];
      }
      Ra.sl[6]=1233; /* line # 1233 */
      ((V *)Rv5)[0]=P_lgt_type_eval(Rv2,NULL,((V *)Rv3)[4],0);
      Ra.sl[6]=1234; /* line # 1234 */
      ((V *)Rv3)[10]=((V *)Rv5)[0];
      Ra.sl[6]=1236; /* line # 1236 */
      ((UB *)Rv3)[64]=1;
      Ra.sl[6]=1238; /* line # 1238 */
      P_lgt_new(&Rv4,((V *)Rv3)[4],6, Rv4);
      Ra.sl[6]=1239; /* line # 1239 */
      ((UB *)Rv4)[41]=3;
      Ra.sl[6]=1242; /* line # 1242 */
      if ((*F_lgh)==NULL) (*F_lgh)=Rv4;
      else {
        Ra.sl[6]=1243; /* line # 1243 */
        ((V *)(*F_lgl))[0]=Rv4;
      }
      Ra.sl[6]=1244; /* line # 1244 */
      (*F_lgl)=Rv4;
      Ra.sl[6]=1245; /* line # 1245 */
      Rv2=((V *)Rv2)[0];
      Ra.sl[6]=1246; /* line # 1246 */
      Rv1=((V *)Rv3)[3];
    }
  }
  Ra.sl[6]=1250; /* line # 1250 */
  if (((UB *)Rv0)[90]) {
    Ra.sl[6]=1251; /* line # 1251 */
    switch (((UB *)Rv0)[92]) {
      case 10:
      case 23:Ra.sl[6]=1253; /* line # 1253 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgh,F_lgl);
      break;
      case 8:
      case 9:Ra.sl[6]=1256; /* line # 1256 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgh,F_lgl);
      break;
      default:Ra.sl[6]=1259; /* line # 1259 */
      P_src_error(Rd.s+432,131,3);
      break;
    }
  }
  Ra.sl[6]=1262; /* line # 1262 */
  Rv1=((V *)F_ty)[4];
  Ra.sl[6]=1263; /* line # 1263 */
  while (Rv1!=NULL){
    Ra.sl[6]=1264; /* line # 1264 */
    Rv7=Rv1;
    Ra.sl[6]=1266; /* line # 1266 */
    ((V *)Rv7)[10]=NULL;
    Ra.sl[6]=1267; /* line # 1267 */
    ((UB *)Rv7)[64]=0;
    Ra.sl[6]=1268; /* line # 1268 */
    Rv1=((V *)Rv7)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_dyn "  */
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[28]=F_bindir;
  Ra.v[4]=F_ide;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+436;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1275; /* line # 1275 */
  if (((UB *)F_ty)[90]) {
    Ra.sl[6]=1277; /* line # 1277 */
    switch (((UB *)F_ty)[92]) {
      case 10:
      case 23:Ra.sl[6]=1279; /* line # 1279 */
      PAS_EXPSION_PRC_00000004(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      case 8:
      case 9:Ra.sl[6]=1282; /* line # 1282 */
      PAS_EXPSION_PRC_00000003(F_ty, F_trg, F_lgth,F_lgtl);
      break;
      default:Ra.sl[6]=1285; /* line # 1285 */
      P_src_error(Rd.s+450,131,3);
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " init_d_tab "  */
void PAS_EXPSION_PRC_00000006(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+454;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1315; /* line # 1315 */
  Rv0=F_ty;
  Ra.sl[6]=1317; /* line # 1317 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=1318; /* line # 1318 */
    Rv1=((V *)Rv0)[15];
    Ra.sl[6]=1319; /* line # 1319 */
    if (((UB *)Rv1)[92]!=22) {
      Ra.sl[6]=1320; /* line # 1320 */
      if (((UB *)Rv1)[112]) {
        Ra.sl[6]=1321; /* line # 1321 */
        Rv2=(((UL *)Rv1)[30]-((UL *)Rv1)[29])+1;
      }
      else {
        Ra.sl[6]=1323; /* line # 1323 */
        Rv2=(((SL *)Rv1)[30]-((SL *)Rv1)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1326; /* line # 1326 */
      Rv3=P_lgt_type_eval(((V *)Rv1)[12],NULL,NULL,0);
      Ra.sl[6]=1327; /* line # 1327 */
      if (((UB *)Rv3)[40]==14) {
        Ra.sl[6]=1329; /* line # 1329 */
        Rv2=((SL *)((V *)Rv3)[7])[13];
        Ra.sl[6]=1330; /* line # 1330 */
        P_lgt_free(&Rv3);
      }
      else {
        Ra.sl[6]=1332; /* line # 1332 */
        P_src_error(Rd.s+468,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1334; /* line # 1334 */
    Rv2=0;
  }
  Ra.sl[6]=1336; /* line # 1336 */
  if (((V *)Rv0)[13]!=NULL) {
    Ra.sl[6]=1338; /* line # 1338 */
    Rv3=P_lgt_type_eval(((V *)Rv0)[13],NULL,NULL,0);
    Ra.sl[6]=1339; /* line # 1339 */
    if (((UB *)Rv3)[40]==14) {
      Ra.sl[6]=1341; /* line # 1341 */
      Rv4=((SL *)((V *)Rv3)[7])[13];
      Ra.sl[6]=1342; /* line # 1342 */
      P_lgt_free(&Rv3);
    }
    else {
      Ra.sl[6]=1344; /* line # 1344 */
      P_src_error(Rd.s+468,142,4);
    }
  }
  else {
    Ra.sl[6]=1346; /* line # 1346 */
    Rv4=((SL *)Rv0)[25];
  }
  Ra.sl[6]=1348; /* line # 1348 */
  if (((V *)Rv0)[14]==NULL) Rv2=0;
  Ra.sl[6]=1350; /* line # 1350 */
  Rv5=PAS_EXPSION_init_d_static(((V *)Rv0)[14],Rv4);
  Ra.sl[6]=1352; /* line # 1352 */
  Rv6=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=1354; /* line # 1354 */
    if (Rv6==1) Rv7=Rv5;
    else {
      Ra.sl[6]=1355; /* line # 1355 */
      Rv7=NULL;
      P_val_copy(&Rv5, &Rv7,0);
    }
    Ra.sl[6]=1356; /* line # 1356 */
    if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv7;
    else {
      Ra.sl[6]=1357; /* line # 1357 */
      ((V *)Lx[3].v[1])[0]=Rv7;
    }
    Ra.sl[6]=1358; /* line # 1358 */
    Lx[3].v[1]=Rv7;
    Rv6++;
  }
  Ra.sl[6]=1360; /* line # 1360 */
  (*F_iadr)=(*F_iadr)+Rv4*Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_rec "  */
void PAS_EXPSION_PRC_00000007(V F_ty, SL *F_iadr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  SL Rv18;
  V Rv19;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+472;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1379; /* line # 1379 */
  Rv0=F_ty;
  Ra.sl[6]=1381; /* line # 1381 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1383; /* line # 1383 */
  while (Rv1!=NULL){
    Ra.sl[6]=1384; /* line # 1384 */
    Rv2=Rv1;
    Ra.sl[6]=1386; /* line # 1386 */
    if (((V *)Rv2)[4]!=NULL) {
      Ra.sl[6]=1387; /* line # 1387 */
      Rv3=((V *)Rv2)[4];
      Ra.sl[6]=1389; /* line # 1389 */
      if (((V *)Rv3)[4]!=NULL||((UB *)Rv3)[90]) {
        Ra.sl[6]=1391; /* line # 1391 */
        Rv4=PAS_EXPSION_init_d_static(((V *)Rv2)[4],0);
        Ra.sl[6]=1392; /* line # 1392 */
        Rv5=((SL *)Rv4)[6];
      }
      else {
        Ra.sl[6]=1395; /* line # 1395 */
        if (((SL *)Rv3)[11]>0) {
          Ra.sl[6]=1397; /* line # 1397 */
          Rv4=NULL;
          Ra.sl[6]=1398; /* line # 1398 */
          P_val_new(&Rv4, V_typ_std.v[0]);
          Ra.sl[6]=1399; /* line # 1399 */
          Rv6=Rv4;
          Ra.sl[6]=1401; /* line # 1401 */
          Rv5=((SL *)Rv3)[11];
          Ra.sl[6]=1402; /* line # 1402 */
          ((UB *)Rv6)[48]=28;
          Ra.sl[6]=1403; /* line # 1403 */
          ((SL *)Rv6)[6]=((SL *)Rv3)[11];
          Ra.sl[6]=1404; /* line # 1404 */
          ((SL *)Rv6)[13]=0;
        }
        else {
          Ra.sl[6]=1407; /* line # 1407 */
          Rv5=0;
        }
      }
      Ra.sl[6]=1408; /* line # 1408 */
      if (Rv5>0) {
        Ra.sl[6]=1410; /* line # 1410 */
        (*F_iadr)=(*F_iadr)+Rv5;
        Ra.sl[6]=1411; /* line # 1411 */
        if (Lx[3].v[0]==NULL) Lx[3].v[0]=Rv4;
        else {
          Ra.sl[6]=1412; /* line # 1412 */
          ((V *)Lx[3].v[1])[0]=Rv4;
        }
        Ra.sl[6]=1413; /* line # 1413 */
        Lx[3].v[1]=Rv4;
      }
      Ra.sl[6]=1415; /* line # 1415 */
      if (Rv1==((V *)Rv3)[13]) Rv1=NULL;
      else {
        Ra.sl[6]=1416; /* line # 1416 */
        Rv1=((V *)Rv2)[3];
      }
    }
  }
  Ra.sl[6]=1420; /* line # 1420 */
  if (((V *)Rv0)[14]!=NULL&&((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1421; /* line # 1421 */
    Rv7=((V *)Rv0)[14];
    Ra.sl[6]=1423; /* line # 1423 */
    Rv8=((V *)Rv7)[1];
    Ra.sl[6]=1424; /* line # 1424 */
    Rv9=((V *)Rv8)[0];
    Ra.sl[6]=1425; /* line # 1425 */
    Rv10=((V *)Rv9)[0];
    Ra.sl[6]=1426; /* line # 1426 */
    Rv11=Rv8;
    Ra.sl[6]=1428; /* line # 1428 */
    Rv12=((SL *)Rv11)[4];
    Ra.sl[6]=1429; /* line # 1429 */
    if (((V *)Rv11)[7]!=NULL) {
      Ra.sl[6]=1430; /* line # 1430 */
      Rv13=((V *)Rv11)[7];
      Ra.sl[6]=1433; /* line # 1433 */
      Rv14=(((SL *)Rv13)[6]+Rv12)-1;
      Ra.sl[6]=1434; /* line # 1434 */
      Rv15=((V *)Rv13)[7];
    }
    else {
      Ra.sl[6]=1436; /* line # 1436 */
      Rv15=NULL;
    }
    Ra.sl[6]=1438; /* line # 1438 */
    if (((V *)Rv0)[4]!=NULL) {
      Ra.sl[6]=1440; /* line # 1440 */
      Rv16=P_lgt_type_eval(Rv10,NULL,NULL,0);
      Ra.sl[6]=1441; /* line # 1441 */
      Rv17=Rv16;
      Ra.sl[6]=1442; /* line # 1442 */
      if (((UB *)Rv17)[40]!=14) P_src_error(Rd.s+486,142,3);
      else {
        Ra.sl[6]=1444; /* line # 1444 */
        if (((V *)Rv17)[7]!=NULL) Rv18=((SL *)((V *)Rv17)[7])[13];
        else {
          Ra.sl[6]=1445; /* line # 1445 */
          Rv18=Rv12-1;
        }
      }
      Ra.sl[6]=1446; /* line # 1446 */
      P_lgt_free(&Rv16);
    }
    Ra.sl[6]=1449; /* line # 1449 */
    Rv19=((V *)Rv10)[0];
    Ra.sl[6]=1450; /* line # 1450 */
    if (Rv18<Rv12||Rv18>Rv14) {
      Ra.sl[6]=1451; /* line # 1451 */
      Rv19=Rv9;
    }
    else {
      Ra.sl[6]=1454; /* line # 1454 */
      Rv18=((SL *)Rv15)[(Rv18-Rv12)];
      Ra.sl[6]=1455; /* line # 1455 */
      if (Rv18<0) Rv19=Rv9;
      else {
        Ra.sl[6]=1458; /* line # 1458 */
        while (Rv18>0&&Rv19!=NULL){
          Ra.sl[6]=1460; /* line # 1460 */
          Rv19=((V *)Rv19)[0];
          Rv18=Rv18-1;
        }
        Ra.sl[6]=1462; /* line # 1462 */
        if (Rv19==NULL) Rv19=Rv9;
      }
    }
    Ra.sl[6]=1465; /* line # 1465 */
    if (Rv19!=NULL) {
      Ra.sl[6]=1466; /* line # 1466 */
      if (((V *)Rv19)[3]!=NULL) PAS_EXPSION_PRC_00000007(((V *)Rv19)[3],F_iadr);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_d_static "  */
V PAS_EXPSION_init_d_static(V F_ty, SL F_szw){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+490;
  Ra.v[4]=Rd.s+13;
  Ra.sl[10]=1476; /* line # 1476 */
  Rv0=F_ty;
  Ra.sl[10]=1478; /* line # 1478 */
  Rv1=0;
  Ra.sl[10]=1479; /* line # 1479 */
  Ra.v[0]=NULL;
  Ra.sl[10]=1480; /* line # 1480 */
  Ra.v[1]=NULL;
  Ra.sl[10]=1481; /* line # 1481 */
  Rv2=NULL;
  Ra.sl[10]=1482; /* line # 1482 */
  Rv3=NULL;
  Ra.sl[10]=1483; /* line # 1483 */
  Rv4=((SL *)Rv0)[11];
  Ra.sl[10]=1484; /* line # 1484 */
  Rv5=0;
  Ra.sl[10]=1486; /* line # 1486 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1488; /* line # 1488 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1489; /* line # 1489 */
    Rv7=((V *)Rv0)[7];
    Ra.sl[10]=1490; /* line # 1490 */
    while (Rv6!=NULL&&Rv7!=NULL){
      Ra.sl[10]=1491; /* line # 1491 */
      Rv8=Rv6;
      Ra.sl[10]=1493; /* line # 1493 */
      Rv9=P_lgt_type_eval(Rv7,NULL,((V *)Rv8)[4],0);
      Ra.sl[10]=1494; /* line # 1494 */
      ((SL *)Rv9)[4]=((SL *)Rv8)[15];
      Ra.sl[10]=1495; /* line # 1495 */
      if (Rv2==NULL) Rv2=Rv9;
      else {
        Ra.sl[10]=1496; /* line # 1496 */
        ((V *)Rv3)[0]=Rv9;
      }
      Ra.sl[10]=1497; /* line # 1497 */
      Rv3=Rv9;
      Ra.sl[10]=1498; /* line # 1498 */
      Rv10=((V *)Rv9)[7];
      Ra.sl[10]=1499; /* line # 1499 */
      P_val_new(&Rv10,((V *)Rv8)[4]);
      Ra.sl[10]=1500; /* line # 1500 */
      ((V *)Rv10)[4]=((V *)Rv8)[4];
      Ra.sl[10]=1501; /* line # 1501 */
      ((SL *)Rv10)[6]=((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1502; /* line # 1502 */
      if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
      else {
        Ra.sl[10]=1503; /* line # 1503 */
        ((V *)Ra.v[1])[0]=Rv10;
      }
      Ra.sl[10]=1504; /* line # 1504 */
      Ra.v[1]=Rv10;
      Ra.sl[10]=1506; /* line # 1506 */
      ((V *)Rv8)[10]=Rv9;
      Ra.sl[10]=1507; /* line # 1507 */
      ((UB *)Rv8)[64]=1;
      Ra.sl[10]=1508; /* line # 1508 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[10]=1509; /* line # 1509 */
      Rv6=((V *)Rv8)[3];
      Ra.sl[10]=1510; /* line # 1510 */
      if (((V *)Rv8)[4]!=NULL) Rv1=Rv1+((SL *)((V *)Rv8)[4])[11];
      Ra.sl[10]=1511; /* line # 1511 */
      Rv5=Rv5+1;
    }
  }
  Ra.sl[10]=1516; /* line # 1516 */
  if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
    Ra.sl[10]=1518; /* line # 1518 */
    Rv7=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
    Ra.sl[10]=1519; /* line # 1519 */
    if (((UB *)Rv7)[40]==14) {
      Ra.sl[10]=1521; /* line # 1521 */
      Rv4=((SL *)((V *)Rv7)[7])[13];
      Ra.sl[10]=1522; /* line # 1522 */
      P_lgt_free(&Rv7);
    }
    else {
      Ra.sl[10]=1523; /* line # 1523 */
      P_src_error(Rd.s+507,147,4);
    }
  }
  Ra.sl[10]=1526; /* line # 1526 */
  if (F_szw>Rv4) Rv4=F_szw;
  Ra.sl[10]=1528; /* line # 1528 */
  if (((UB *)Rv0)[90]) {
    Ra.sl[10]=1529; /* line # 1529 */
    switch (((UB *)Rv0)[92]) {
      case 10:
      case 23:Ra.sl[10]=1531; /* line # 1531 */
      PAS_EXPSION_PRC_00000007(F_ty, &Rv1);
      break;
      case 8:
      case 9:Ra.sl[10]=1534; /* line # 1534 */
      PAS_EXPSION_PRC_00000006(F_ty, &Rv1);
      break;
      default:Ra.sl[10]=1537; /* line # 1537 */
      P_src_error(Rd.s+507,131,3);
      break;
    }
  }
  Ra.sl[10]=1541; /* line # 1541 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[10]=1544; /* line # 1544 */
    Rv6=((V *)Rv0)[4];
    Ra.sl[10]=1545; /* line # 1545 */
    while (Rv6!=NULL){
      Ra.sl[10]=1547; /* line # 1547 */
      ((UB *)Rv6)[64]=0;
      Ra.sl[10]=1548; /* line # 1548 */
      ((V *)Rv6)[10]=NULL;
      Ra.sl[10]=1549; /* line # 1549 */
      Rv6=((V *)Rv6)[3];
    }
  }
  Ra.sl[10]=1552; /* line # 1552 */
  P_lgt_free_tree(&Rv2);
  Ra.sl[10]=1555; /* line # 1555 */
  if (Rv4>Rv1) {
    Ra.sl[10]=1557; /* line # 1557 */
    Rv10=NULL;
    Ra.sl[10]=1558; /* line # 1558 */
    P_val_new(&Rv10,NULL);
    Ra.sl[10]=1559; /* line # 1559 */
    if (Ra.v[0]==NULL) Ra.v[0]=Rv10;
    else {
      Ra.sl[10]=1560; /* line # 1560 */
      ((V *)Ra.v[1])[0]=Rv10;
    }
    Ra.sl[10]=1561; /* line # 1561 */
    Ra.v[1]=Rv10;
    Ra.sl[10]=1562; /* line # 1562 */
    Rv11=Rv10;
    Ra.sl[10]=1564; /* line # 1564 */
    ((UB *)Rv11)[48]=28;
    Ra.sl[10]=1565; /* line # 1565 */
    ((V *)Rv11)[4]=V_typ_std.v[0];
    Ra.sl[10]=1566; /* line # 1566 */
    ((SL *)Rv11)[13]=0;
    Ra.sl[10]=1567; /* line # 1567 */
    ((SL *)Rv11)[6]=Rv4-Rv1;
  }
  Ra.sl[10]=1590; /* line # 1590 */
  Rv10=NULL;
  Ra.sl[10]=1591; /* line # 1591 */
  P_val_new(&Rv10, F_ty);
  Ra.sl[10]=1592; /* line # 1592 */
  Rv12=Rv10;
  Ra.sl[10]=1594; /* line # 1594 */
  ((SL *)Rv12)[2]=((SL *)Rv0)[10];
  Ra.sl[10]=1595; /* line # 1595 */
  ((SL *)Rv12)[6]=Rv4;
  Ra.sl[10]=1596; /* line # 1596 */
  ((V *)Rv12)[7]=Ra.v[0];
  Ra.sl[10]=1597; /* line # 1597 */
  ((SL *)Rv12)[2]=Rv5;
  Ra.sl[10]=1604; /* line # 1604 */
  Ret=Rv10;
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " init_d_varbl "  */
void P_init_d_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+511;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1635; /* line # 1635 */
  Rv0=((V *)F_ip)[4];
  Ra.sl[6]=1637; /* line # 1637 */
  if (!((UB *)Rv0)[89]&&((V *)Rv0)[1]!=NULL) Rv0=((V *)Rv0)[1];
  Ra.sl[6]=1639; /* line # 1639 */
  Rv1=F_ip;
  Rv2=Rv0;
  Rv3=((V *)Rv1)[6];
  Ra.sl[6]=1641; /* line # 1641 */
  ((UW *)Rv1)[46]=((UW *)Rv1)[46]|16;
  Ra.sl[6]=1642; /* line # 1642 */
  if ((((UB *)Rv1)[94]==6||((UB *)Rv1)[94]==1)&&((SL *)Rv1)[10]>1) {
    Ra.sl[6]=1646; /* line # 1646 */
    if (((V *)Rv2)[0]!=NULL) Rv4=((V *)((V *)Rv2)[0])[4];
    else {
      Ra.sl[6]=1647; /* line # 1647 */
      Rv4=((V *)Rv2)[4];
    }
    Ra.sl[6]=1648; /* line # 1648 */
    Rv5=NULL;
    Ra.sl[6]=1649; /* line # 1649 */
    Rv6=NULL;
    Ra.sl[6]=1650; /* line # 1650 */
    Rv7=((V *)Rv2)[7];
    Ra.sl[6]=1651; /* line # 1651 */
    Rv8=Rv4;
    Ra.sl[6]=1653; /* line # 1653 */
    while (Rv7!=NULL){
      Ra.sl[6]=1656; /* line # 1656 */
      P_lgt_new(&Rv9,((V *)Rv4)[4],13,NULL);
      Ra.sl[6]=1657; /* line # 1657 */
      Rv10=Rv9;
      Rv11=Rv8;
      Ra.sl[6]=1659; /* line # 1659 */
      ((V *)Rv10)[6]=F_ip;
      ((V *)Rv10)[7]=NULL;
      Ra.sl[6]=1660; /* line # 1660 */
      ((SL *)Rv10)[4]=((SL *)Rv11)[15];
      Ra.sl[6]=1661; /* line # 1661 */
      ((V *)Rv11)[10]=Rv9;
      Ra.sl[6]=1662; /* line # 1662 */
      ((UB *)Rv11)[64]=1;
      Ra.sl[6]=1665; /* line # 1665 */
      P_lgt_new_copy(Rv7, &Rv12);
      ((V *)Rv9)[0]=Rv12;
      Ra.sl[6]=1667; /* line # 1667 */
      Rv7=((V *)Rv7)[0];
      Ra.sl[6]=1668; /* line # 1668 */
      Rv8=((V *)Rv8)[3];
      Ra.sl[6]=1669; /* line # 1669 */
      Rv12=P_lgt_new_code(3, Rv9);
      Ra.sl[6]=1670; /* line # 1670 */
      if (Rv5==NULL) Rv5=Rv12;
      else {
        Ra.sl[6]=1671; /* line # 1671 */
        ((V *)Rv6)[0]=Rv12;
      }
      Ra.sl[6]=1672; /* line # 1672 */
      Rv6=Rv12;
    }
    Ra.sl[6]=1675; /* line # 1675 */
    if (((UB *)Rv2)[90]) {
      Ra.sl[6]=1677; /* line # 1677 */
      Rv9=P_lgt_new_idref(F_ip,NULL);
      Ra.sl[6]=1678; /* line # 1678 */
      P_init_d_dyn(Rv0, Rv9, &Rv5, &Rv6,0, F_ip);
      Ra.sl[6]=1679; /* line # 1679 */
      P_lgt_free(&Rv9);
    }
    Ra.sl[6]=1682; /* line # 1682 */
    if (Rv5!=NULL) {
      Ra.sl[6]=1683; /* line # 1683 */
      switch (((UB *)Rv3)[104]) {
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:Ra.sl[6]=1686; /* line # 1686 */
        if (((V *)Rv3)[18]==NULL) ((V *)Rv3)[18]=Rv5;
        else {
          Ra.sl[6]=1687; /* line # 1687 */
          ((V *)((V *)Rv3)[17])[0]=Rv5;
        }
        Ra.sl[6]=1688; /* line # 1688 */
        ((V *)Rv3)[17]=Rv6;
        break;
        default:break;
      }
    }
    Ra.sl[6]=1692; /* line # 1692 */
    while (Rv4!=NULL){
      Ra.sl[6]=1693; /* line # 1693 */
      Rv13=Rv4;
      Ra.sl[6]=1695; /* line # 1695 */
      ((V *)Rv13)[10]=NULL;
      Ra.sl[6]=1696; /* line # 1696 */
      ((UB *)Rv13)[64]=0;
      Ra.sl[6]=1697; /* line # 1697 */
      Rv4=((V *)Rv13)[3];
    }
  }
  else {
    Ra.sl[6]=1702; /* line # 1702 */
    if (((V *)Rv1)[8]==NULL) {
      Ra.sl[6]=1704; /* line # 1704 */
      ((UW *)Rv1)[46]=((UW *)Rv1)[46]|8;
      Ra.sl[6]=1705; /* line # 1705 */
      ((V *)Rv1)[8]=PAS_EXPSION_init_d_static(Rv0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_val_una "  */
V P_exp_val_una(V F_puna, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+525;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1724; /* line # 1724 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1725; /* line # 1725 */
    Rv0=F_p;
    Rv1=((V *)Rv0)[3]+8;
    Ra.sl[6]=1728; /* line # 1728 */
    if (((UB *)Rv1)[8]!=0) F_puna=P_exp_val_una(F_puna, V_oparg_cvtab.v[((UB *)Rv1)
    [8]]);
    Ra.sl[6]=1729; /* line # 1729 */
    Rv2=F_puna;
    Ra.sl[6]=1730; /* line # 1730 */
    if (((UB *)Rv2)[40]==14) {
      Ra.sl[6]=1731; /* line # 1731 */
      Rv3=((V *)Rv2)[7];
      Ra.sl[6]=1733; /* line # 1733 */
      ((UW *)Rv2)[10]=1;
      Ra.sl[6]=1734; /* line # 1734 */
      switch (((UB *)Rv0)[9]) {
        case 6:Ra.sl[6]=1735; /* line # 1735 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]<=0);
        break;
        case 43:Ra.sl[6]=1737; /* line # 1737 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]+1;
        break;
        case 44:Ra.sl[6]=1739; /* line # 1739 */
        ((SL *)Rv3)[13]=((SL *)Rv3)[13]-1;
        break;
        case 45:Ra.sl[6]=1741; /* line # 1741 */
        ((SL *)Rv3)[13]=(SL)(((SL *)Rv3)[13]&1);
        break;
        case 10:Ra.sl[6]=1743; /* line # 1743 */
        if (((UB *)Rv3)[48]==11||((UB *)Rv3)[48]==17) {
          Ra.sl[6]=1744; /* line # 1744 */
          if (((SL *)Rv3)[13]>=0) {
            Ra.sl[6]=1745; /* line # 1745 */
            ((SL *)Rv3)[13]=-1-((SL *)Rv3)[13];
          }
          else {
            Ra.sl[6]=1746; /* line # 1746 */
            ((SL *)Rv3)[13]= -(1+((SL *)Rv3)[13]);
          }
        }
        break;
        case 46:Ra.sl[6]=1748; /* line # 1748 */
        ((SL *)Rv3)[13]= -((SL *)Rv3)[13];
        break;
        case 61:
        case 77:Ra.sl[6]=1750; /* line # 1750 */
        ((G *)Rv3)[7]=-((G *)Rv3)[7];
        break;
        case 47:Ra.sl[6]=1752; /* line # 1752 */
        ((SL *)Rv3)[13]=abs(((SL *)Rv3)[13]);
        break;
        case 62:
        case 78:Ra.sl[6]=1754; /* line # 1754 */
        ((G *)Rv3)[7]=fabs(((G *)Rv3)[7]);
        break;
        case 48:Ra.sl[6]=1756; /* line # 1756 */
        ((SL *)Rv3)[13]=PAS__I_SQR(((SL *)Rv3)[13]);
        break;
        case 63:
        case 79:Ra.sl[6]=1758; /* line # 1758 */
        ((G *)Rv3)[7]=PAS__G_SQR(((G *)Rv3)[7]);
        break;
        case 64:
        case 80:Ra.sl[6]=1761; /* line # 1761 */
        ((G *)Rv3)[7]=(double)((SL *)Rv3)[13];
        break;
        case 65:
        case 81:Ra.sl[6]=1763; /* line # 1763 */
        ((SL *)Rv3)[13]=PAS__G_ROUND(((G *)Rv3)[7]);
        break;
        case 66:
        case 82:Ra.sl[6]=1765; /* line # 1765 */
        ((SL *)Rv3)[13]=(int)(((G *)Rv3)[7]);
        break;
        case 92:
        case 110:Ra.sl[6]=1768; /* line # 1768 */
        if (((G *)Rv3)[7]<0.000000000000000E-001) P_src_error(Rd.s+540,801,2);
        else {
          Ra.sl[6]=1769; /* line # 1769 */
          ((G *)Rv3)[7]=sqrt(((G *)Rv3)[7]);
        }
        break;
        case 93:
        case 111:Ra.sl[6]=1772; /* line # 1772 */
        ((G *)Rv3)[7]=sin(((G *)Rv3)[7]);
        break;
        case 94:
        case 112:Ra.sl[6]=1774; /* line # 1774 */
        ((G *)Rv3)[7]=cos(((G *)Rv3)[7]);
        break;
        case 95:
        case 113:Ra.sl[6]=1776; /* line # 1776 */
        ((G *)Rv3)[7]=tan(((G *)Rv3)[7]);
        break;
        case 96:
        case 114:Ra.sl[6]=1780; /* line # 1780 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+540,802,2);
        else {
          Ra.sl[6]=1781; /* line # 1781 */
          ((G *)Rv3)[7]=asin(((G *)Rv3)[7]);
        }
        break;
        case 97:
        case 115:Ra.sl[6]=1784; /* line # 1784 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+540,803,2);
        else {
          Ra.sl[6]=1785; /* line # 1785 */
          ((G *)Rv3)[7]=acos(((G *)Rv3)[7]);
        }
        break;
        case 98:
        case 116:Ra.sl[6]=1787; /* line # 1787 */
        ((G *)Rv3)[7]=atan(((G *)Rv3)[7]);
        break;
        case 102:
        case 120:Ra.sl[6]=1790; /* line # 1790 */
        ((G *)Rv3)[7]=PAS__SHG(((G *)Rv3)[7]);
        break;
        case 103:
        case 121:Ra.sl[6]=1792; /* line # 1792 */
        ((G *)Rv3)[7]=PAS__CHG(((G *)Rv3)[7]);
        break;
        case 104:
        case 122:Ra.sl[6]=1794; /* line # 1794 */
        ((G *)Rv3)[7]=PAS__THG(((G *)Rv3)[7]);
        break;
        case 105:
        case 123:Ra.sl[6]=1797; /* line # 1797 */
        ((G *)Rv3)[7]=PAS__ASHG(((G *)Rv3)[7]);
        break;
        case 106:
        case 124:Ra.sl[6]=1800; /* line # 1800 */
        if (((G *)Rv3)[7]<1.000000000000000E+000) P_src_error(Rd.s+540,805,2);
        else {
          Ra.sl[6]=1801; /* line # 1801 */
          ((G *)Rv3)[7]=PAS__ACHG(((G *)Rv3)[7]);
        }
        break;
        case 107:
        case 125:Ra.sl[6]=1804; /* line # 1804 */
        if (fabs(((G *)Rv3)[7])>1.000000000000000E+000) P_src_error(Rd.s+540,806,2);
        else {
          Ra.sl[6]=1805; /* line # 1805 */
          ((G *)Rv3)[7]=PAS__ATHG(((G *)Rv3)[7]);
        }
        break;
        case 100:
        case 118:Ra.sl[6]=1808; /* line # 1808 */
        ((G *)Rv3)[7]=exp(((G *)Rv3)[7]);
        break;
        case 101:
        case 119:Ra.sl[6]=1811; /* line # 1811 */
        if (((G *)Rv3)[7]<=0.000000000000000E-001) P_src_error(Rd.s+540,804,2);
        else {
          Ra.sl[6]=1812; /* line # 1812 */
          ((G *)Rv3)[7]=log(((G *)Rv3)[7]);
        }
        break;
        default:break;
      }
      Ra.sl[6]=1816; /* line # 1816 */
      ((V *)Rv2)[4]=NULL;
      Ra.sl[6]=1818; /* line # 1818 */
      if (32&((UB *)Rv1)[9]) ((V *)Rv2)[3]=((V *)Rv1)[0];
      else {
        Ra.sl[6]=1819; /* line # 1819 */
        ((V *)Rv2)[3]=((V *)Rv0)[2];
      }
      Ra.sl[6]=1820; /* line # 1820 */
      ((V *)Rv3)[4]=((V *)Rv2)[3];
      Ra.sl[6]=1821; /* line # 1821 */
      ((UB *)Rv3)[48]=((UB *)((V *)Rv2)[3])[92];
    }
    else {
      Ra.sl[6]=1825; /* line # 1825 */
      if (!(1&((UW *)F_puna)[10])) P_src_error(Rd.s+540,851,2);
      Ra.sl[6]=1826; /* line # 1826 */
      if (((UB *)Rv0)[9]!=0||((SL *)((V *)F_puna)[3])[11]!=((SL *)((V *)Rv0)[2])
      [11]) {
        Ra.sl[6]=1829; /* line # 1829 */
        P_lgt_new(&Rv4,((V *)Rv0)[2],6, F_puna);
        Ra.sl[6]=1830; /* line # 1830 */
        Rv5=Rv4;
        Ra.sl[6]=1832; /* line # 1832 */
        if (32&((UB *)Rv1)[9]) ((V *)Rv5)[3]=((V *)Rv1)[0];
        Ra.sl[6]=1833; /* line # 1833 */
        ((V *)Rv5)[0]=((V *)F_puna)[0];
        Ra.sl[6]=1834; /* line # 1834 */
        ((UB *)Rv5)[41]=((UB *)Rv0)[9];
        Ra.sl[6]=1835; /* line # 1835 */
        ((UW *)Rv5)[10]=((UW *)F_puna)[10]&~2;
        Ra.sl[6]=1837; /* line # 1837 */
        ((V *)Rv2)[0]=NULL;
        Ra.sl[6]=1838; /* line # 1838 */
        F_puna=Rv4;
      }
      else {
        Ra.sl[6]=1840; /* line # 1840 */
        ((V *)F_puna)[3]=((V *)Rv0)[2];
      }
    }
  }
  Ra.sl[6]=1843; /* line # 1843 */
  Ret=F_puna;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_val_bin "  */
V P_exp_val_bin(V F_ob1, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  G Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  register V Rv12;
  UL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+544;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1865; /* line # 1865 */
  Rv0=((V *)F_ob1)[0];
  Ra.sl[6]=1866; /* line # 1866 */
  if (((V *)F_p)[3]!=NULL) {
    Ra.sl[6]=1867; /* line # 1867 */
    Rv1=F_p;
    Ra.sl[6]=1869; /* line # 1869 */
    Rv2=((V *)Rv1)[2];
    Ra.sl[6]=1871; /* line # 1871 */
    Rv3=((V *)Rv1)[3]+8;
    Ra.sl[6]=1872; /* line # 1872 */
    if (32&((UB *)Rv3)[9]) Rv2=((V *)Rv3)[0];
    else {
      Ra.sl[6]=1874; /* line # 1874 */
      if (((UB *)Rv3)[8]!=0) F_ob1=P_exp_val_una(F_ob1, V_oparg_cvtab.v[((UB *)Rv3)
      [8]]);
    }
    Ra.sl[6]=1875; /* line # 1875 */
    Rv4=((V *)Rv1)[3]+24;
    Ra.sl[6]=1876; /* line # 1876 */
    if (32&((UB *)Rv4)[9]) Rv2=((V *)Rv4)[0];
    else {
      Ra.sl[6]=1878; /* line # 1878 */
      if (((UB *)Rv4)[8]!=0) Rv0=P_exp_val_una(Rv0, V_oparg_cvtab.v[((UB *)Rv4)[
8]]);
    }
    Ra.sl[6]=1879; /* line # 1879 */
    ((V *)F_ob1)[0]=Rv0;
    Ra.sl[6]=1880; /* line # 1880 */
    if (((UB *)F_ob1)[40]==14&&((UB *)Rv0)[40]==14) {
      Ra.sl[6]=1883; /* line # 1883 */
      Rv5=((V *)F_ob1)[7];
      Rv6=Rv0;
      Ra.sl[6]=1884; /* line # 1884 */
      switch (((UB *)Rv1)[9]) {
        case 89:Ra.sl[6]=1885; /* line # 1885 */
        ((SL *)Rv5)[13]=PAS__IIPOWER(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 90:
        case 108:Ra.sl[6]=1887; /* line # 1887 */
        ((G *)Rv5)[7]=pow  (((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        case 91:
        case 109:Ra.sl[6]=1889; /* line # 1889 */
        ((G *)Rv5)[7]=PAS__IGPOWER(((G *)Rv5)[7],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 49:Ra.sl[6]=1891; /* line # 1891 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]+((SL *)((V *)Rv6)[7])[13];
        break;
        case 50:Ra.sl[6]=1892; /* line # 1892 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        break;
        case 51:Ra.sl[6]=1893; /* line # 1893 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]*((SL *)((V *)Rv6)[7])[13];
        break;
        case 52:Ra.sl[6]=1894; /* line # 1894 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]/((SL *)((V *)Rv6)[7])[13];
        break;
        case 53:Ra.sl[6]=1895; /* line # 1895 */
        ((SL *)Rv5)[13]=PAS__I_MOD(((SL *)Rv5)[13],((SL *)((V *)Rv6)[7])[13]);
        break;
        case 54:Ra.sl[6]=1896; /* line # 1896 */
        ((SL *)Rv5)[13]=((SL *)Rv5)[13]%((SL *)((V *)Rv6)[7])[13];
        break;
        case 67:
        case 85:Ra.sl[6]=1899; /* line # 1899 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]+((G *)((V *)Rv6)[7])[7];
        break;
        case 68:
        case 86:Ra.sl[6]=1901; /* line # 1901 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        break;
        case 69:
        case 87:Ra.sl[6]=1903; /* line # 1903 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]*((G *)((V *)Rv6)[7])[7];
        break;
        case 70:
        case 88:Ra.sl[6]=1905; /* line # 1905 */
        ((G *)Rv5)[7]=((G *)Rv5)[7]/((G *)((V *)Rv6)[7])[7];
        break;
        case 7:Ra.sl[6]=1907; /* line # 1907 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0&&((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 8:Ra.sl[6]=1908; /* line # 1908 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0||((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 9:Ra.sl[6]=1909; /* line # 1909 */
        ((SL *)Rv5)[13]=(SL)(((SL *)Rv5)[13]>0!=((SL *)((V *)Rv6)[7])[13]>0);
        break;
        case 11:Ra.sl[6]=1912; /* line # 1912 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13];
        break;
        case 12:Ra.sl[6]=1913; /* line # 1913 */
        ((UL *)Rv5)[13]=(((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13])&~(((UL *)Rv5)
        [13]&((UL *)((V *)Rv6)[7])[13]);
        break;
        case 13:Ra.sl[6]=1915; /* line # 1915 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]&~((UL *)((V *)Rv6)[7])[13];
        break;
        case 14:Ra.sl[6]=1916; /* line # 1916 */
        ((UL *)Rv5)[13]=((UL *)Rv5)[13]|((UL *)((V *)Rv6)[7])[13];
        break;
        case 15:Ra.sl[6]=1917; /* line # 1917 */
        ((SL *)Rv5)[13]=(SL)((((UL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 16:break;
        case 17:break;
        case 18:break;
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:Ra.sl[6]=1926; /* line # 1926 */
        switch (((UB *)Rv1)[9]) {
          case 19:
          case 20:Ra.sl[6]=1928; /* line # 1928 */
          Rv7=(SL)PAS__SET_LE(((UL *)Rv5)[13],((UL *)((V *)Rv6)[7])[13]);
          break;
          case 21:
          case 22:Ra.sl[6]=1930; /* line # 1930 */
          Rv7=(SL)PAS__SET_LE(((UL *)((V *)Rv6)[7])[13],((UL *)Rv5)[13]);
          break;
          case 23:Ra.sl[6]=1931; /* line # 1931 */
          Rv7=(SL)(((UL *)Rv5)[13]!=((UL *)((V *)Rv6)[7])[13]);
          break;
          case 24:Ra.sl[6]=1932; /* line # 1932 */
          Rv7=(SL)(((UL *)Rv5)[13]==((UL *)((V *)Rv6)[7])[13]);
          break;
          default:break;
        }
        Ra.sl[6]=1935; /* line # 1935 */
        ((UB *)Rv5)[48]=1;
        Ra.sl[6]=1936; /* line # 1936 */
        ((SL *)Rv5)[6]=0;
        Ra.sl[6]=1937; /* line # 1937 */
        ((SL *)Rv5)[13]=Rv7;
        break;
        case 25:Ra.sl[6]=1940; /* line # 1940 */
        Rv7=(SL)((1<<((SL *)Rv5)[13]&((UL *)((V *)Rv6)[7])[13])!=0);
        break;
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:Ra.sl[6]=1945; /* line # 1945 */
        Rv7=((SL *)Rv5)[13]-((SL *)((V *)Rv6)[7])[13];
        Ra.sl[6]=1946; /* line # 1946 */
        switch (((UB *)Rv1)[9]) {
          case 28:
          case 32:Ra.sl[6]=1947; /* line # 1947 */
          ((SL *)Rv5)[13]=(SL)(Rv7<0);
          break;
          case 29:
          case 33:Ra.sl[6]=1948; /* line # 1948 */
          ((SL *)Rv5)[13]=(SL)(Rv7<=0);
          break;
          case 30:
          case 34:Ra.sl[6]=1949; /* line # 1949 */
          ((SL *)Rv5)[13]=(SL)(Rv7>=0);
          break;
          case 31:
          case 35:Ra.sl[6]=1950; /* line # 1950 */
          ((SL *)Rv5)[13]=(SL)(Rv7>0);
          break;
          case 27:Ra.sl[6]=1951; /* line # 1951 */
          ((SL *)Rv5)[13]=(SL)(Rv7!=0);
          break;
          case 26:Ra.sl[6]=1952; /* line # 1952 */
          ((SL *)Rv5)[13]=(SL)(Rv7==0);
          break;
        }
        break;
        case 55:
        case 56:
        case 57:
        case 58:
        case 59:
        case 60:
        case 71:
        case 72:
        case 73:
        case 74:
        case 75:
        case 76:Ra.sl[6]=1958; /* line # 1958 */
        Rv8=((G *)Rv5)[7]-((G *)((V *)Rv6)[7])[7];
        Ra.sl[6]=1959; /* line # 1959 */
        switch (((UB *)Rv1)[9]) {
          case 55:
          case 71:Ra.sl[6]=1960; /* line # 1960 */
          ((SL *)Rv5)[13]=(SL)(Rv8<0.000000000000000E-001);
          break;
          case 56:
          case 72:Ra.sl[6]=1961; /* line # 1961 */
          ((SL *)Rv5)[13]=(SL)(Rv8<=0.000000000000000E-001);
          break;
          case 57:
          case 73:Ra.sl[6]=1962; /* line # 1962 */
          ((SL *)Rv5)[13]=(SL)(Rv8>=0.000000000000000E-001);
          break;
          case 58:
          case 74:Ra.sl[6]=1963; /* line # 1963 */
          ((SL *)Rv5)[13]=(SL)(Rv8>0.000000000000000E-001);
          break;
          case 60:
          case 76:Ra.sl[6]=1964; /* line # 1964 */
          ((SL *)Rv5)[13]=(SL)(Rv8!=0.000000000000000E-001);
          break;
          case 59:
          case 75:Ra.sl[6]=1965; /* line # 1965 */
          ((SL *)Rv5)[13]=(SL)(Rv8==0.000000000000000E-001);
          break;
        }
        break;
        case 36:
        case 37:break;
        case 99:
        case 117:Ra.sl[6]=1975; /* line # 1975 */
        ((G *)Rv5)[7]=atan2(((G *)Rv5)[7],((G *)((V *)Rv6)[7])[7]);
        break;
        default:break;
      }
      Ra.sl[6]=1979; /* line # 1979 */
      Rv9=F_ob1;
      Rv10=((V *)Rv9)[7];
      Ra.sl[6]=1981; /* line # 1981 */
      ((V *)Rv9)[4]=NULL;
      Ra.sl[6]=1983; /* line # 1983 */
      ((V *)Rv9)[3]=Rv2;
      Ra.sl[6]=1984; /* line # 1984 */
      ((V *)Rv10)[4]=((V *)Rv9)[3];
      Ra.sl[6]=1985; /* line # 1985 */
      ((UB *)Rv10)[48]=((UB *)((V *)Rv9)[3])[92];
      Ra.sl[6]=1987; /* line # 1987 */
      ((V *)F_ob1)[0]=NULL;
      Ra.sl[6]=1988; /* line # 1988 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=1992; /* line # 1992 */
      Rv11=1;
      Ra.sl[6]=1993; /* line # 1993 */
      switch (((UB *)Rv1)[9]) {
        case 25:Ra.sl[6]=1995; /* line # 1995 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=1997; /* line # 1997 */
          Rv12=F_ob1;
          Ra.sl[6]=1999; /* line # 1999 */
          Rv13=((SL *)((V *)Rv12)[7])[13];
          Ra.sl[6]=2000; /* line # 2000 */
          ((V *)Rv12)[3]=((V *)Rv0)[3];
          Ra.sl[6]=2001; /* line # 2001 */
          P_val_free(((V *)Rv12)+7);
          Ra.sl[6]=2002; /* line # 2002 */
          P_val_new(((V *)Rv12)+7,((V *)Rv12)[3]);
          Ra.sl[6]=2003; /* line # 2003 */
          Rv14=((V *)Rv12)[7];
          Ra.sl[6]=2005; /* line # 2005 */
          ((SL *)Rv14)[6]=(Rv13+7)/8;
          Ra.sl[6]=2006; /* line # 2006 */
          ((UL *)Rv14)[13]=1<<Rv13;
          Ra.sl[6]=2009; /* line # 2009 */
          P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
          Ra.sl[6]=2010; /* line # 2010 */
          Rv15=Rv0;
          Ra.sl[6]=2012; /* line # 2012 */
          ((UW *)Rv15)[10]=1;
          Ra.sl[6]=2013; /* line # 2013 */
          ((UB *)Rv15)[41]=15;
          Ra.sl[6]=2015; /* line # 2015 */
          Rv11=0;
        }
        break;
        case 7:Ra.sl[6]=2019; /* line # 2019 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2020; /* line # 2020 */
          Rv16=F_ob1;
          Ra.sl[6]=2022; /* line # 2022 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2023; /* line # 2023 */
          Rv11=0;
          Ra.sl[6]=2024; /* line # 2024 */
          if (((SL *)((V *)Rv16)[7])[13]<=0) {
            Ra.sl[6]=2026; /* line # 2026 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2027; /* line # 2027 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2030; /* line # 2030 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2033; /* line # 2033 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2034; /* line # 2034 */
            Rv17=Rv0;
            Ra.sl[6]=2036; /* line # 2036 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2037; /* line # 2037 */
            Rv11=0;
            Ra.sl[6]=2038; /* line # 2038 */
            if (((SL *)((V *)Rv17)[7])[13]<=0) {
              Ra.sl[6]=2039; /* line # 2039 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2042; /* line # 2042 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2043; /* line # 2043 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 8:Ra.sl[6]=2048; /* line # 2048 */
        if (((UB *)F_ob1)[40]==14) {
          Ra.sl[6]=2049; /* line # 2049 */
          Rv18=F_ob1;
          Ra.sl[6]=2051; /* line # 2051 */
          ((V *)F_ob1)[0]=NULL;
          Ra.sl[6]=2052; /* line # 2052 */
          Rv11=0;
          Ra.sl[6]=2053; /* line # 2053 */
          if (((SL *)((V *)Rv18)[7])[13]>0) {
            Ra.sl[6]=2055; /* line # 2055 */
            P_lgt_free_tree(&Rv0);
            Ra.sl[6]=2056; /* line # 2056 */
            Rv0=F_ob1;
          }
          else {
            Ra.sl[6]=2059; /* line # 2059 */
            P_lgt_free(&F_ob1);
          }
        }
        else {
          Ra.sl[6]=2062; /* line # 2062 */
          if (((UB *)Rv0)[40]==14) {
            Ra.sl[6]=2063; /* line # 2063 */
            Rv19=Rv0;
            Ra.sl[6]=2065; /* line # 2065 */
            ((V *)F_ob1)[0]=NULL;
            Ra.sl[6]=2066; /* line # 2066 */
            Rv11=0;
            Ra.sl[6]=2067; /* line # 2067 */
            if (((SL *)((V *)Rv19)[7])[13]>0) {
              Ra.sl[6]=2068; /* line # 2068 */
              P_lgt_free_tree(&F_ob1);
            }
            else {
              Ra.sl[6]=2071; /* line # 2071 */
              P_lgt_free(&Rv0);
              Ra.sl[6]=2072; /* line # 2072 */
              Rv0=F_ob1;
            }
          }
        }
        break;
        case 1:
        case 3:
        case 4:
        case 5:Ra.sl[6]=2078; /* line # 2078 */
        Rv20=F_ob1;
        Ra.sl[6]=2080; /* line # 2080 */
        ((UW *)Rv20)[10]=((UW *)Rv20)[10]|8;
        Ra.sl[6]=2081; /* line # 2081 */
        if (!(2&((UW *)Rv20)[10])) P_src_error(Rd.s+559,852,2);
        Ra.sl[6]=2083; /* line # 2083 */
        Rv21=Rv0;
        Ra.sl[6]=2085; /* line # 2085 */
        if (!(1&((UW *)Rv21)[10])) {
          Ra.sl[6]=2086; /* line # 2086 */
          P_src_error(Rd.s+559,851,1);
        }
        Ra.sl[6]=2087; /* line # 2087 */
        if ((((UB *)Rv1)[9]!=1&&((UB *)Rv21)[40]==8)&&((V *)Rv21)[3]!=NULL) {
          Ra.sl[6]=2090; /* line # 2090 */
          Rv22=((V *)Rv21)[6];
          Ra.sl[6]=2091; /* line # 2091 */
          if (((V *)Rv22)[8]!=NULL) {
            Ra.sl[6]=2092; /* line # 2092 */
            if (((UB *)((V *)Rv22)[8])[94]==6) {
              Ra.sl[6]=2094; /* line # 2094 */
              ((V *)F_ob1)[0]=((V *)((V *)Rv21)[1])[0];
              Ra.sl[6]=2095; /* line # 2095 */
              P_lgt_free(((V *)Rv21)+1);
              Ra.sl[6]=2096; /* line # 2096 */
              ((UW *)Rv21)[10]=((UW *)Rv21)[10]|128;
              Ra.sl[6]=2097; /* line # 2097 */
              ((V *)Rv21)[1]=F_ob1;
              Ra.sl[6]=2098; /* line # 2098 */
              Rv11=0;
            }
          }
        }
        break;
        default:Ra.sl[6]=2103; /* line # 2103 */
        if (!(1&((UW *)F_ob1)[10]&&1&((UW *)Rv0)[10])) {
          Ra.sl[6]=2104; /* line # 2104 */
          P_src_error(Rd.s+559,851,1);
        }
        break;
      }
      Ra.sl[6]=2106; /* line # 2106 */
      if (Rv11) {
        Ra.sl[6]=2108; /* line # 2108 */
        P_lgt_new(&Rv0,((V *)Rv1)[2],6, F_ob1);
        Ra.sl[6]=2109; /* line # 2109 */
        Rv23=Rv0;
        Ra.sl[6]=2111; /* line # 2111 */
        ((V *)Rv23)[3]=Rv2;
        Ra.sl[6]=2112; /* line # 2112 */
        ((UW *)Rv23)[10]=1;
        Ra.sl[6]=2113; /* line # 2113 */
        ((UB *)Rv23)[41]=((UB *)Rv1)[9];
      }
      Ra.sl[6]=2116; /* line # 2116 */
      F_ob1=Rv0;
    }
  }
  Ra.sl[6]=2119; /* line # 2119 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_descriptor "  */
V P_look_for_descriptor(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+563;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2134; /* line # 2134 */
  Rv0=F_lgt;
  Ra.sl[6]=2135; /* line # 2135 */
  while (Rv0!=NULL&&((V *)Rv0)[3]!=NULL){
    Ra.sl[6]=2136; /* line # 2136 */
    Rv1=Rv0;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=2138; /* line # 2138 */
    if (((SL *)Rv2)[10]>0)  break;
    Ra.sl[6]=2139; /* line # 2139 */
    if (((((UB *)Rv1)[40]==3||((UB *)Rv1)[40]==1)||((UB *)Rv1)[40]==5)||((UB *)Rv1)
    [40]==16) {
      Ra.sl[6]=2142; /* line # 2142 */
      Rv0=((V *)Rv1)[1];
    }
    else {
      Ra.sl[6]=2143; /* line # 2143 */
      Rv0=NULL;
    }
  }
  Ra.sl[6]=2145; /* line # 2145 */
  if (Rv0==NULL) Rv0=F_lgt;
  Ra.sl[6]=2151; /* line # 2151 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_setting "  */
void P_call_setting(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  UB Rv10;
  UB Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  C Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  V Rv23;
  V Rv24;
  V Rv25;
  V Rv26;
  V Rv27;
  V Rv28;
  register V Rv29;
  register V Rv30;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+584;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2173; /* line # 2173 */
  Rv0=0;
  Ra.sl[6]=2174; /* line # 2174 */
  Rv1=NULL;
  Ra.sl[6]=2175; /* line # 2175 */
  if ((*F_lgt)!=NULL) {
    Ra.sl[6]=2176; /* line # 2176 */
    Rv2=(*F_lgt);
    Ra.sl[6]=2178; /* line # 2178 */
    if (((V *)Rv2)[6]!=NULL) Rv1=((V *)Rv2)[6];
    Ra.sl[6]=2179; /* line # 2179 */
    Rv3=((V *)Rv2)[1];
    Ra.sl[6]=2180; /* line # 2180 */
    if (((UB *)Rv2)[40]==7) Rv3=((V *)Rv3)[0];
  }
  Ra.sl[6]=2183; /* line # 2183 */
  if (Rv1!=NULL) {
    Ra.sl[6]=2184; /* line # 2184 */
    Rv4=Rv1;
    Ra.sl[6]=2186; /* line # 2186 */
    Rv5=NULL;
    Ra.sl[6]=2187; /* line # 2187 */
    Rv6=NULL;
    Ra.sl[6]=2188; /* line # 2188 */
    Rv7=((V *)Rv4)[8];
    Ra.sl[6]=2189; /* line # 2189 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2190; /* line # 2190 */
      Rv8=((V *)Rv4)[11];
      Ra.sl[6]=2191; /* line # 2191 */
      if (!((UB *)Rv8)[91]) {
        Ra.sl[6]=2199; /* line # 2199 */
        Rv5=P_lgt_new_idref(V_wildtmp_ide, Rv3);
        Ra.sl[6]=2200; /* line # 2200 */
        ((V *)Rv5)[3]=((V *)Rv4)[11];
        Ra.sl[6]=2201; /* line # 2201 */
        ((V *)Rv5)[4]=((V *)Rv4)[5];
        Ra.sl[6]=2202; /* line # 2202 */
        ((V *)(*F_lgt))[1]=Rv5;
        Ra.sl[6]=2203; /* line # 2203 */
        Rv7=((V *)Rv7)[3];
      }
    }
    Ra.sl[6]=2206; /* line # 2206 */
    while (Rv7!=NULL){
      Ra.sl[6]=2208; /* line # 2208 */
      Rv9=NULL;
      Ra.sl[6]=2209; /* line # 2209 */
      Rv10=0;
      Ra.sl[6]=2210; /* line # 2210 */
      Rv11=0;
      Ra.sl[6]=2211; /* line # 2211 */
      Rv12=Rv3;
      Ra.sl[6]=2212; /* line # 2212 */
      Rv13=Rv7;
      Ra.sl[6]=2214; /* line # 2214 */
      if (Rv3!=NULL) {
        Ra.sl[6]=2216; /* line # 2216 */
        if (((UB *)Rv3)[40]==17) Rv0=1;
        else {
          Ra.sl[6]=2219; /* line # 2219 */
          if (((V *)Rv13)[4]!=NULL) {
            Ra.sl[6]=2221; /* line # 2221 */
            Rv14=((V *)Rv13)[4];
            Ra.sl[6]=2222; /* line # 2222 */
            switch (((UB *)Rv14)[92]) {
              case 10:Ra.sl[6]=2224; /* line # 2224 */
              if (P_comp_type(((V *)Rv13)[4],V_typ_std.v[10],0,0)&&P_comp_type((
              (V *)Rv3)[3],V_typ_std.v[0],1,0)) {
                Ra.sl[6]=2226; /* line # 2226 */
                if (((UB *)Rv3)[40]==14) {
                  Ra.sl[6]=2228; /* line # 2228 */
                  Rv15=(C)((SL *)((V *)Rv3)[7])[13];
                  Ra.sl[6]=2229; /* line # 2229 */
                  P_val_free(((V *)Rv3)+7);
                  Ra.sl[6]=2230; /* line # 2230 */
                  P_val_new(((V *)Rv3)+7,V_typ_std.v[10]);
                  Ra.sl[6]=2231; /* line # 2231 */
                  ((V *)Rv3)[3]=V_typ_std.v[10];
                  Ra.sl[6]=2232; /* line # 2232 */
                  Rv16=((V *)Rv3)[7];
                  Ra.sl[6]=2234; /* line # 2234 */
                  ((UB *)Rv16)[48]=29;
                  Ra.sl[6]=2235; /* line # 2235 */
                  ((SL *)Rv16)[6]=1;
                  Ra.sl[6]=2236; /* line # 2236 */
                  ((V *)Rv16)[7]=PAS__NEW(3);
                  ((UB *)((V *)Rv16)[7])[0]=1;
                  Ra.sl[6]=2237; /* line # 2237 */
                  PAS__CHA_TO_STR(((V *)Rv16)[7],Rv15);
                }
                else {
                  Ra.sl[6]=2242; /* line # 2242 */
                  Rv17=((V *)Rv3)[0];
                  ((V *)Rv3)[0]=NULL;
                  Ra.sl[6]=2243; /* line # 2243 */
                  Rv3=P_generate_call(V_gen_std_string1, Rv3,0,1);
                  Ra.sl[6]=2244; /* line # 2244 */
                  ((V *)Rv3)[0]=Rv17;
                  Ra.sl[6]=2245; /* line # 2245 */
                  ((UW *)Rv3)[10]=5;
                  Ra.sl[6]=2246; /* line # 2246 */
                  if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                  else {
                    Ra.sl[6]=2247; /* line # 2247 */
                    ((V *)Rv5)[0]=Rv3;
                  }
                }
              }
              break;
              case 8:
              case 9:Ra.sl[6]=2253; /* line # 2253 */
              if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[10],0,0)) {
                Ra.sl[6]=2256; /* line # 2256 */
                Rv10=1;
                Ra.sl[6]=2257; /* line # 2257 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2258; /* line # 2258 */
                P_lgt_new(&Rv3,((V *)((V *)V_typ_std.v[10])[13])[4],3, Rv3);
                Ra.sl[6]=2259; /* line # 2259 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2260; /* line # 2260 */
                  ((V *)Rv5)[0]=Rv3;
                }
                Ra.sl[6]=2261; /* line # 2261 */
                ((SL *)Rv3)[4]=((SL *)((V *)V_typ_std.v[10])[13])[15];
                Ra.sl[6]=2262; /* line # 2262 */
                ((V *)Rv3)[0]=Rv17;
              }
              else {
                Ra.sl[6]=2265; /* line # 2265 */
                if (P_comp_type(((V *)Rv3)[3],V_typ_std.v[0],0,0)) {
                  Ra.sl[6]=2266; /* line # 2266 */
                  Rv10=1;
                  Rv11=1;
                }
              }
              Ra.sl[6]=2267; /* line # 2267 */
              if (((UB *)Rv14)[92]==9) Rv9=((V *)Rv13)[4];
              break;
              case 13:
              case 14:
              case 15:
              case 17:
              case 18:
              case 19:
              case 20:
              case 21:Ra.sl[6]=2274; /* line # 2274 */
              if (Rv6==NULL) Rv6=((V *)Rv3)[3];
              else {
                Ra.sl[6]=2276; /* line # 2276 */
                if (((UB *)Rv6)[91]&&!((UB *)((V *)Rv3)[3])[91]||((SL *)Rv6)[11]
                <((SL *)((V *)Rv3)[3])[11]) {
                  Ra.sl[6]=2277; /* line # 2277 */
                  Rv6=((V *)Rv3)[3];
                }
              }
              break;
              default:break;
            }
            Ra.sl[6]=2282; /* line # 2282 */
            if (32&((UB *)Rv13)[95]&&Rv6==NULL) Rv6=((V *)Rv3)[3];
            Ra.sl[6]=2285; /* line # 2285 */
            switch (((UB *)Rv13)[94]) {
              case 7:Ra.sl[6]=2288; /* line # 2288 */
              if (!(4&((UW *)Rv3)[10])) {
                Ra.sl[6]=2290; /* line # 2290 */
                Rv18=Rv3;
                Ra.sl[6]=2291; /* line # 2291 */
                if (64&((UW *)Rv13)[46]) ((UW *)Rv18)[10]=((UW *)Rv18)[10]|8;
                Ra.sl[6]=2292; /* line # 2292 */
                Rv17=((V *)Rv3)[0];
                ((V *)Rv3)[0]=NULL;
                Ra.sl[6]=2293; /* line # 2293 */
                P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
                Ra.sl[6]=2294; /* line # 2294 */
                ((V *)Rv3)[0]=Rv17;
                Ra.sl[6]=2296; /* line # 2296 */
                if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
                else {
                  Ra.sl[6]=2297; /* line # 2297 */
                  ((V *)Rv5)[0]=Rv3;
                }
              }
              break;
              case 10:Ra.sl[6]=2303; /* line # 2303 */
              Rv17=((V *)Rv3)[0];
              ((V *)Rv3)[0]=NULL;
              Ra.sl[6]=2304; /* line # 2304 */
              P_lgt_new(&Rv3,((V *)Rv3)[3],5, Rv3);
              Ra.sl[6]=2305; /* line # 2305 */
              ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
              Ra.sl[6]=2306; /* line # 2306 */
              ((V *)Rv3)[0]=Rv17;
              Ra.sl[6]=2308; /* line # 2308 */
              if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
              else {
                Ra.sl[6]=2309; /* line # 2309 */
                ((V *)Rv5)[0]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=2314; /* line # 2314 */
            Rv0=0;
          }
        }
      }
      else {
        Ra.sl[6]=2320; /* line # 2320 */
        P_lgt_new(&Rv3,((V *)Rv13)[4],14,NULL);
        Ra.sl[6]=2322; /* line # 2322 */
        if (Rv5==NULL) ((V *)(*F_lgt))[1]=Rv3;
        else {
          Ra.sl[6]=2323; /* line # 2323 */
          ((V *)Rv5)[0]=Rv3;
        }
        Ra.sl[6]=2324; /* line # 2324 */
        Rv0=1;
      }
      Ra.sl[6]=2327; /* line # 2327 */
      if (Rv0) {
        Ra.sl[6]=2328; /* line # 2328 */
        if (8192&((UW *)Rv13)[46]) {
          Ra.sl[6]=2329; /* line # 2329 */
          Rv19=Rv3;
          Ra.sl[6]=2331; /* line # 2331 */
          ((UB *)Rv19)[40]=17;
          Ra.sl[6]=2332; /* line # 2332 */
          ((V *)Rv19)[3]=((V *)Rv13)[4];
          Ra.sl[6]=2333; /* line # 2333 */
          ((V *)Rv19)[4]=NULL;
        }
        else {
          Ra.sl[6]=2336; /* line # 2336 */
          if (((V *)Rv13)[8]!=NULL) {
            Ra.sl[6]=2337; /* line # 2337 */
            Rv20=Rv3;
            Ra.sl[6]=2339; /* line # 2339 */
            ((UB *)Rv20)[40]=14;
            Ra.sl[6]=2340; /* line # 2340 */
            ((V *)Rv20)[3]=((V *)Rv13)[4];
            Ra.sl[6]=2341; /* line # 2341 */
            ((V *)Rv20)[7]=((V *)Rv13)[8];
            Ra.sl[6]=2342; /* line # 2342 */
            P_val_new(((V *)Rv20)+7,((V *)Rv13)[4]);
            Ra.sl[6]=2343; /* line # 2343 */
            ((V *)Rv20)[4]=NULL;
          }
          else {
            Ra.sl[6]=2345; /* line # 2345 */
            P_src_error_s(Rd.s+600,854,2,((V *)Rv13)[0],NULL);
          }
        }
      }
      Ra.sl[6]=2347; /* line # 2347 */
      Rv5=Rv3;
      Ra.sl[6]=2350; /* line # 2350 */
      if (Rv9!=NULL) {
        Ra.sl[6]=2351; /* line # 2351 */
        if (((V *)Rv9)[15]!=NULL) {
          Ra.sl[6]=2352; /* line # 2352 */
          Rv21=((V *)Rv9)[15];
          Ra.sl[6]=2353; /* line # 2353 */
          if (((V *)Rv21)[13]!=NULL&&((V *)Rv21)[14]!=NULL) {
            Ra.sl[6]=2355; /* line # 2355 */
            Rv22=Rv12;
            Ra.sl[6]=2356; /* line # 2356 */
            if (((UB *)Rv22)[40]==8) ((UW *)Rv22)[10]=((UW *)Rv22)[10]|128;
            Ra.sl[6]=2358; /* line # 2358 */
            Rv23=((V *)Rv9)[15];
            Ra.sl[6]=2359; /* line # 2359 */
            Rv24=NULL;
            Rv25=NULL;
            Ra.sl[6]=2361; /* line # 2361 */
            if (Rv10) {
              while (1){
                Ra.sl[6]=2365; /* line # 2365 */
                if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
              }
              Ra.sl[6]=2368; /* line # 2368 */
              if (Rv11) {
                Ra.sl[6]=2370; /* line # 2370 */
                Rv24=P_lgt_new_econst(Rv23,1);
                Ra.sl[6]=2371; /* line # 2371 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2372; /* line # 2372 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2374; /* line # 2374 */
                  Rv25=P_lgt_new_econst(Rv23,1);
                  ((V *)Rv24)[0]=Rv25;
                  Ra.sl[6]=2375; /* line # 2375 */
                  Rv7=((V *)Rv7)[3];
                }
                else {
                  Ra.sl[6]=2377; /* line # 2377 */
                  Rv25=Rv24;
                }
              }
              else {
                Ra.sl[6]=2381; /* line # 2381 */
                if (((UB *)((V *)Rv21)[13])[40]!=14) {
                  Ra.sl[6]=2383; /* line # 2383 */
                  Rv24=P_lgt_new_econst(Rv23,1);
                  Ra.sl[6]=2384; /* line # 2384 */
                  Rv25=Rv24;
                  Ra.sl[6]=2385; /* line # 2385 */
                  Rv7=((V *)Rv7)[3];
                }
                Ra.sl[6]=2387; /* line # 2387 */
                if (((UB *)Rv12)[40]==14) {
                  Ra.sl[6]=2388; /* line # 2388 */
                  Rv17=P_lgt_new_econst(Rv23,((SL *)((V *)Rv12)[7])[6]);
                }
                else {
                  Ra.sl[6]=2391; /* line # 2391 */
                  P_lgt_new(&Rv17,((V *)((V *)V_typ_std.v[10])[4])[4],3, P_lgt_link(
                  Rv12));
                  Ra.sl[6]=2393; /* line # 2393 */
                  if (!(64&((UW *)Rv7)[46])) ((SL *)Rv17)[4]=((SL *)((V *)V_typ_std
                  .v[10])[12])[15];
                  Ra.sl[6]=2395; /* line # 2395 */
                  if (((V *)Rv17)[3]!=Rv23) {
                    Ra.sl[6]=2397; /* line # 2397 */
                    Rv17=P_lgt_new_code(0, Rv17);
                    Ra.sl[6]=2398; /* line # 2398 */
                    ((V *)Rv17)[3]=Rv23;
                  }
                }
                Ra.sl[6]=2401; /* line # 2401 */
                Rv7=((V *)Rv7)[3];
                Ra.sl[6]=2402; /* line # 2402 */
                if (Rv25==NULL) Rv24=Rv17;
                else {
                  Ra.sl[6]=2403; /* line # 2403 */
                  ((V *)Rv25)[0]=Rv17;
                }
                Ra.sl[6]=2404; /* line # 2404 */
                Rv25=Rv17;
              }
            }
            else {
              Ra.sl[6]=2409; /* line # 2409 */
              Rv26=((V *)Rv3)[3];
              Ra.sl[6]=2410; /* line # 2410 */
              if (Rv26!=NULL) {
                Ra.sl[6]=2411; /* line # 2411 */
                while (Rv9!=NULL&&Rv26!=NULL){
                  Ra.sl[6]=2412; /* line # 2412 */
                  if (((UB *)Rv9)[92]==9&&(((UB *)Rv26)[92]==9||((UB *)Rv26)[92]
                  ==8)) {
                    Ra.sl[6]=2416; /* line # 2416 */
                    Rv27=((V *)Rv26)[15];
                    Ra.sl[6]=2417; /* line # 2417 */
                    Rv23=((V *)Rv9)[15];
                    while (1){
                      Ra.sl[6]=2420; /* line # 2420 */
                      if (((V *)Rv23)[0]!=NULL) Rv23=((V *)Rv23)[0];
                      if (((V *)Rv23)[0]==NULL||((UB *)Rv23)[92]!=22)  break;
                    }
                    Ra.sl[6]=2423; /* line # 2423 */
                    if (((UB *)Rv27)[92]==22) Rv28=P_look_for_descriptor(Rv12, Rv27);
                    else {
                      Ra.sl[6]=2424; /* line # 2424 */
                      Rv28=Rv12;
                    }
                    Ra.sl[6]=2428; /* line # 2428 */
                    if (((UB *)((V *)Rv21)[13])[40]!=14) {
                      Ra.sl[6]=2430; /* line # 2430 */
                      if (((UB *)Rv27)[92]==22) {
                        Ra.sl[6]=2432; /* line # 2432 */
                        Rv17=P_lgt_type_eval(((V *)Rv27)[13],Rv28,NULL,0);
                        Ra.sl[6]=2433; /* line # 2433 */
                        if (((SL *)Rv27)[11]!=((SL *)Rv23)[11]) {
                          Ra.sl[6]=2435; /* line # 2435 */
                          Rv17=P_lgt_new_code(0, Rv17);
                          Ra.sl[6]=2436; /* line # 2436 */
                          ((V *)Rv17)[3]=Rv23;
                        }
                      }
                      else {
                        Ra.sl[6]=2439; /* line # 2439 */
                        Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[29]);
                      }
                      Ra.sl[6]=2440; /* line # 2440 */
                      if (Rv25==NULL) Rv24=Rv17;
                      else {
                        Ra.sl[6]=2441; /* line # 2441 */
                        ((V *)Rv25)[0]=Rv17;
                      }
                      Ra.sl[6]=2442; /* line # 2442 */
                      Rv25=Rv17;
                      Ra.sl[6]=2443; /* line # 2443 */
                      Rv7=((V *)Rv7)[3];
                    }
                    Ra.sl[6]=2446; /* line # 2446 */
                    if (((UB *)Rv27)[92]==22) {
                      Ra.sl[6]=2448; /* line # 2448 */
                      Rv17=P_lgt_type_eval(((V *)Rv27)[14],Rv28,NULL,0);
                      Ra.sl[6]=2449; /* line # 2449 */
                      if (Rv27!=Rv23) {
                        Ra.sl[6]=2451; /* line # 2451 */
                        Rv17=P_lgt_new_code(0, Rv17);
                        Ra.sl[6]=2452; /* line # 2452 */
                        ((V *)Rv17)[3]=Rv23;
                      }
                    }
                    else {
                      Ra.sl[6]=2455; /* line # 2455 */
                      Rv17=P_lgt_new_econst(Rv23,((SL *)Rv27)[30]);
                    }
                    Ra.sl[6]=2456; /* line # 2456 */
                    if (Rv25==NULL) Rv24=Rv17;
                    else {
                      Ra.sl[6]=2457; /* line # 2457 */
                      ((V *)Rv25)[0]=Rv17;
                    }
                    Ra.sl[6]=2458; /* line # 2458 */
                    Rv25=Rv17;
                    Ra.sl[6]=2459; /* line # 2459 */
                    Rv7=((V *)Rv7)[3];
                    Ra.sl[6]=2460; /* line # 2460 */
                    Rv26=((V *)Rv26)[14];
                    Ra.sl[6]=2461; /* line # 2461 */
                    Rv9=((V *)Rv9)[14];
                  }
                  else {
                    Ra.sl[6]=2462; /* line # 2462 */
                    Rv9=NULL;
                  }
                }
              }
              Ra.sl[6]=2464; /* line # 2464 */
              Rv29=Rv3;
              Ra.sl[6]=2465; /* line # 2465 */
              if (((SL *)((V *)Rv29)[3])[10]>0) {
                Ra.sl[6]=2466; /* line # 2466 */
                ((SL *)Rv29)[4]=((SL *)Rv29)[4]+((SL *)((V *)Rv29)[3])[10];
              }
            }
            Ra.sl[6]=2470; /* line # 2470 */
            if (Rv24!=NULL) {
              Ra.sl[6]=2472; /* line # 2472 */
              ((V *)Rv25)[0]=((V *)Rv3)[0];
              Ra.sl[6]=2473; /* line # 2473 */
              ((V *)Rv3)[0]=Rv24;
              Ra.sl[6]=2474; /* line # 2474 */
              Rv3=Rv25;
            }
            Ra.sl[6]=2476; /* line # 2476 */
            Rv5=Rv3;
          }
        }
      }
      Ra.sl[6]=2479; /* line # 2479 */
      if (Rv3!=NULL) Rv3=((V *)Rv3)[0];
      Ra.sl[6]=2480; /* line # 2480 */
      Rv7=((V *)Rv7)[3];
    }
    Ra.sl[6]=2483; /* line # 2483 */
    if (((V *)Rv4)[11]!=NULL) {
      Ra.sl[6]=2484; /* line # 2484 */
      Rv30=(*F_lgt);
      Ra.sl[6]=2486; /* line # 2486 */
      if (Rv6!=NULL) {
        Ra.sl[6]=2488; /* line # 2488 */
        ((V *)Rv30)[3]=Rv6;
        Ra.sl[6]=2489; /* line # 2489 */
        if (!((UB *)Rv6)[91]&&((V *)Rv30)[1]!=NULL) {
          Ra.sl[6]=2490; /* line # 2490 */
          ((V *)((V *)Rv30)[1])[3]=Rv6;
        }
      }
      Ra.sl[6]=2494; /* line # 2494 */
      if (!((UB *)((V *)Rv4)[11])[91]) {
        Ra.sl[6]=2495; /* line # 2495 */
        P_tmpstk_allocate(((V *)Rv30)[1],((V *)((V *)Rv30)[1])[3]);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wrtt "  */
void PAS_EXPSION_PRC_00000008(V F_pt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+604;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2545; /* line # 2545 */
  if (F_pt!=NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_ENM(((UB *)F_pt)[92],Rd.s+612,0,-1,32);
  }
  else {
    Ra.sl[6]=2546; /* line # 2546 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1176,-1,-1,32);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wrt "  */
void PAS_EXPSION_PRC_00000009(V F_arg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1185;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2554; /* line # 2554 */
  Ra.sl[6]=2556; /* line # 2556 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(60);
  Ra.sl[6]=2557; /* line # 2557 */
  PAS_EXPSION_PRC_00000008(((V *)F_arg)[0]);
  Ra.sl[6]=2558; /* line # 2558 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(44);
  PAS__WRITE_ENM(((UB *)F_arg)[8],Rd.s+1192,0,-1,32);
  PAS__WRITE_STR(Rd.s+1247,-1,-1,32);
  Ra.sl[6]=2559; /* line # 2559 */
  Rv1=0;
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Ra.sl[6]=2561; /* line # 2561 */
    if (1<<Rv1&((UB *)F_arg)[9]) {
      Ra.sl[6]=2563; /* line # 2563 */
      if (Rv0) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(44);
      }
      else Rv0=1;
      Ra.sl[6]=2564; /* line # 2564 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_ENM(Rv1, Rd.s+1252,0,-1,32);
    }
    Rv1++;
  }
  Ra.sl[6]=2567; /* line # 2567 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1306,-1,-1,32);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_request "  */
void PAS_EXPSION_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1310;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2573; /* line # 2573 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+1324,-1,-1,32);
  PAS__WRITE_INT(Lx[4].sl[13],0,0);
  PAS__WRITE_STR(Rd.s+1352,-1,-1,32);
  Ra.sl[6]=2574; /* line # 2574 */
  if (Lx[4].v[7]!=NULL) {
    Ra.sl[6]=2575; /* line # 2575 */
    Rv0=Lx[4].v[7];
    Ra.sl[6]=2577; /* line # 2577 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1360,-1,-1,32);
    PAS_EXPSION_PRC_00000008(((V *)Rv0)[3]);
    Ra.sl[6]=2578; /* line # 2578 */
    if (((V *)Rv0)[0]!=NULL) {
      Ra.sl[6]=2580; /* line # 2580 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1375,-1,-1,32);
      PAS_EXPSION_PRC_00000008(((V *)((V *)Rv0)[0])[3]);
    }
    Ra.sl[6]=2582; /* line # 2582 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=2583; /* line # 2583 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1392,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " show_entry "  */
void PAS_EXPSION_PRC_00000011(V F_pg, UB F_bt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1401;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2588; /* line # 2588 */
  Rv0=F_pg;
  Ra.sl[6]=2589; /* line # 2589 */
  if (((UB *)Rv0)[8]&&Lx[4].sl[13]<=2) {
    Ra.sl[6]=2591; /* line # 2591 */
    if (F_bt) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1413,-1,-1,32);
    }
    else {
      Ra.sl[6]=2592; /* line # 2592 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1431,-1,-1,32);
    }
    Ra.sl[6]=2593; /* line # 2593 */
    if (((V *)Rv0)[3]!=NULL) {
      Ra.sl[6]=2595; /* line # 2595 */
      PAS_EXPSION_PRC_00000009(((V *)Rv0)[3]+8);
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1443,-1,-1,32);
      Ra.sl[6]=2596; /* line # 2596 */
      if (((SL *)((V *)Rv0)[3])[0]>1) {
        Ra.sl[6]=2598; /* line # 2598 */
        PAS_EXPSION_PRC_00000009(((V *)Rv0)[3]+24);
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1447,-1,-1,32);
      }
    }
    Ra.sl[6]=2601; /* line # 2601 */
    PAS_EXPSION_PRC_00000008(((V *)Rv0)[2]);
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1453,-1,-1,32);
    PAS__WRITE_ENM(((UB *)Rv0)[9],Rd.s+1468,0,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dump "  */
void PAS_EXPSION_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3522;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2607; /* line # 2607 */
  PAS_EXPSION_PRC_00000010();
  Ra.sl[6]=2608; /* line # 2608 */
  while (Lx[4].v[0]!=NULL){
    Ra.sl[6]=2609; /* line # 2609 */
    Rv0=Lx[4].v[0];
    Ra.sl[6]=2611; /* line # 2611 */
    PAS_EXPSION_PRC_00000011(Lx[4].v[0],0);
    Ra.sl[6]=2612; /* line # 2612 */
    Lx[4].v[0]=((V *)Rv0)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " generic_search "  */
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  UB Rv13;
  register V Rv14;
  register V Rv15;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.sl[13]=F_npa;
  Ra.v[7]=F_parm_lst;
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+3528;
  Ra.v[3]=Rd.s+13;
  Ra.sl[8]=2623; /* line # 2623 */
  Ra.v[0]=(*F_pg);
  Ra.sl[8]=2628; /* line # 2628 */
  Rv0=0;
  Ra.sl[8]=2629; /* line # 2629 */
  while (!Rv0&&(*F_pg)!=NULL){
    Ra.sl[8]=2631; /* line # 2631 */
    Rv1=Ra.v[7];
    Ra.sl[8]=2632; /* line # 2632 */
    Rv2=(*F_pg);
    Ra.sl[8]=2633; /* line # 2633 */
    if (((UB *)Rv2)[8]&&Ra.sl[13]<=2) {
      Ra.sl[8]=2635; /* line # 2635 */
      Rv3=Rv1;
      Ra.sl[8]=2636; /* line # 2636 */
      switch (Ra.sl[13]) {
        case 0:Ra.sl[8]=2637; /* line # 2637 */
        Rv0=((V *)Rv2)[3]==NULL;
        break;
        case 1:Ra.sl[8]=2639; /* line # 2639 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[8]=2640; /* line # 2640 */
          if (((SL *)((V *)Rv2)[3])[0]==1) {
            Ra.sl[8]=2641; /* line # 2641 */
            Rv4=((V *)Rv2)[3]+8;
            Ra.sl[8]=2642; /* line # 2642 */
            if ((1&((UB *)Rv4)[9])<=(2&((UW *)Rv3)[10])) {
              Ra.sl[8]=2643; /* line # 2643 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv4)[0],(8&((UB *)Rv4)[9])!=0,0);
            }
          }
        }
        break;
        case 2:Ra.sl[8]=2645; /* line # 2645 */
        if (((V *)Rv2)[3]!=NULL) {
          Ra.sl[8]=2646; /* line # 2646 */
          if ((((SL *)((V *)Rv2)[3])[0]==2&&((SL *)((V *)Rv3)[3])[11]>0)&&((SL *)(
          (V *)((V *)Rv3)[0])[3])[11]>0) {
            Ra.sl[8]=2647; /* line # 2647 */
            Rv5=((V *)Rv2)[3]+8;
            Ra.sl[8]=2649; /* line # 2649 */
            memcpy(Ra.s+40,((V *)Rv2)[3]+24,10);
            Ra.sl[8]=2650; /* line # 2650 */
            if ((1&((UB *)Rv5)[9])<=(2&((UW *)Rv3)[10])&&(1&Ra.ub[49])<=(2&((UW *)(
            (V *)Rv3)[0])[10])) {
              Ra.sl[8]=2652; /* line # 2652 */
              Rv0=P_comp_type(((V *)Rv3)[3],((V *)Rv5)[0],(8&((UB *)Rv5)[9])!=0,0)&&
              P_comp_type(((V *)((V *)Rv3)[0])[3],Ra.v[5],(8&Ra.ub[49])!=0,0);
            }
            Ra.sl[8]=2654; /* line # 2654 */
            if (Rv0) {
              Ra.sl[8]=2655; /* line # 2655 */
              if (4&((UB *)Rv5)[9]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V *)((
              V *)Rv3)[0])[3])[13],0,0);
              else {
                Ra.sl[8]=2657; /* line # 2657 */
                if (16&((UB *)Rv5)[9]) Rv0=P_comp_type(((V *)Rv3)[3],((V *)((V *)
                Rv3)[0])[3],8&((UB *)Rv5)[9]||8&Ra.ub[49],1);
              }
            }
          }
        }
        break;
      }
    }
    else {
      Ra.sl[8]=2663; /* line # 2663 */
      Rv6=((V *)Rv2)[2];
      Ra.sl[8]=2664; /* line # 2664 */
      if (((SL *)Rv6)[20]>=Ra.sl[13]) {
        Ra.sl[8]=2666; /* line # 2666 */
        Rv7=((V *)Rv6)[8];
        Ra.sl[8]=2667; /* line # 2667 */
        if (((V *)Rv6)[8]!=NULL) {
          Ra.sl[8]=2668; /* line # 2668 */
          if (((UB *)((V *)Rv6)[8])[94]==6) {
            Ra.sl[8]=2669; /* line # 2669 */
            Rv7=((V *)Rv7)[3];
          }
        }
        Ra.sl[8]=2671; /* line # 2671 */
        if ((Ra.sl[13]==2&&((SL *)Rv6)[20]==2)&&(((UB *)Rv6)[104]==1||((UB *)Rv6)
        [104]==2)) {
          Ra.sl[8]=2673; /* line # 2673 */
          Rv8=Rv1;
          Ra.sl[8]=2675; /* line # 2675 */
          Rv9=((V *)Rv7)[3];
          Ra.sl[8]=2676; /* line # 2676 */
          Rv0=P_comp_type(((V *)Rv8)[3],((V *)Rv7)[4],!(8&((UB *)Rv7)[95]),0)&&P_comp_type((
          (V *)((V *)Rv8)[0])[3],((V *)Rv9)[4],!(8&((UB *)Rv9)[95]),0);
          Ra.sl[8]=2678; /* line # 2678 */
          if (Rv0) {
            Ra.sl[8]=2679; /* line # 2679 */
            if (4&((UB *)Rv7)[95]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)((V
             *)Rv8)[0])[3])[13],0,0);
            else {
              Ra.sl[8]=2681; /* line # 2681 */
              if (16&((UB *)Rv7)[95]) Rv0=P_comp_type(((V *)Rv8)[3],((V *)((V *)
              Rv8)[0])[3],8&((UB *)Rv7)[95]||8&((UB *)Rv9)[95],0);
            }
          }
        }
        Ra.sl[8]=2708; /* line # 2708 */
        if (!Rv0) {
          Ra.sl[8]=2710; /* line # 2710 */
          Rv0=1;
          Ra.sl[8]=2711; /* line # 2711 */
          while (Rv0&&Rv7!=NULL){
            Ra.sl[8]=2713; /* line # 2713 */
            Rv10=0;
            Ra.sl[8]=2714; /* line # 2714 */
            Rv11=Rv7;
            Ra.sl[8]=2715; /* line # 2715 */
            if (Rv1!=NULL) {
              Ra.sl[8]=2716; /* line # 2716 */
              Rv12=Rv1;
              Ra.sl[8]=2718; /* line # 2718 */
              if (((UB *)Rv12)[40]==17) {
                Ra.sl[8]=2719; /* line # 2719 */
                if (((V *)Rv11)[8]==NULL&&!(8192&((UW *)Rv11)[46])) {
                  Ra.sl[8]=2720; /* line # 2720 */
                  Rv0=0;
                }
                else {
                  Ra.sl[8]=2723; /* line # 2723 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
              }
              else {
                Ra.sl[8]=2727; /* line # 2727 */
                Rv13=P_comp_type(((V *)Rv12)[3],((V *)Rv11)[4],((UB *)Rv11)[94]!=
8,0);
                Ra.sl[8]=2730; /* line # 2730 */
                if (!Rv13&&((UB *)Rv12)[40]==14) {
                  Ra.sl[8]=2732; /* line # 2732 */
                  Rv14=((V *)Rv11)[4];
                  Ra.sl[8]=2733; /* line # 2733 */
                  switch (((UB *)Rv14)[92]) {
                    case 4:Ra.sl[8]=2741; /* line # 2741 */
                    if (((UB *)((V *)Rv12)[3])[92]==3) {
                      Ra.sl[8]=2743; /* line # 2743 */
                      ((V *)Rv12)[3]=V_typ_std.v[4];
                      Rv13=1;
                    }
                    break;
                    case 8:
                    case 9:Ra.sl[8]=2765; /* line # 2765 */
                    if ((P_comp_type(((V *)Rv14)[14],V_typ_std.v[0],1,0)&&((UB *)(
                    (V *)Rv14)[15])[92]==2)&&((SL *)Rv14)[10]==0) {
                      Ra.sl[8]=2768; /* line # 2768 */
                      if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[10],0,0)) {
                        Ra.sl[8]=2771; /* line # 2771 */
                        if (((UB *)Rv14)[92]==8) {
                          Ra.sl[8]=2772; /* line # 2772 */
                          Rv15=((V *)Rv14)[15];
                          Ra.sl[8]=2773; /* line # 2773 */
                          Rv13=(((SL *)Rv15)[30]-((SL *)Rv15)[29])+1==((SL *)((V
                           *)Rv12)[7])[6];
                        }
                        else {
                          Ra.sl[8]=2776; /* line # 2776 */
                          Rv13=1;
                        }
                      }
                      else {
                        Ra.sl[8]=2778; /* line # 2778 */
                        if (P_comp_type(((V *)Rv12)[3],V_typ_std.v[0],0,0)) {
                          Ra.sl[8]=2780; /* line # 2780 */
                          if (((UB *)Rv14)[92]==9) Rv13=1;
                          else {
                            Ra.sl[8]=2781; /* line # 2781 */
                            Rv13=((SL *)Rv14)[30]==((SL *)Rv14)[29];
                          }
                        }
                      }
                    }
                    break;
                    default:break;
                  }
                }
                Ra.sl[8]=2786; /* line # 2786 */
                if (Rv13) {
                  Ra.sl[8]=2788; /* line # 2788 */
                  if (((V *)Rv11)[4]!=NULL) {
                    Ra.sl[8]=2789; /* line # 2789 */
                    if (((UB *)((V *)Rv11)[4])[92]==9) {
                      Ra.sl[8]=2790; /* line # 2790 */
                      Rv10=((SL *)((V *)Rv11)[4])[24];
                    }
                  }
                  Ra.sl[8]=2791; /* line # 2791 */
                  Rv7=((V *)Rv11)[3];
                  Rv1=((V *)Rv12)[0];
                }
                else {
                  Ra.sl[8]=2792; /* line # 2792 */
                  Rv0=0;
                }
                Ra.sl[8]=2795; /* line # 2795 */
                if (Rv0) {
                  Ra.sl[8]=2797; /* line # 2797 */
                  if (((UB *)Rv11)[94]==8) {
                    Ra.sl[8]=2799; /* line # 2799 */
                    if (!(1&((UW *)Rv12)[10])) Rv0=0;
                  }
                  else {
                    Ra.sl[8]=2802; /* line # 2802 */
                    if (4&((UW *)Rv12)[10]) {
                      Ra.sl[8]=2804; /* line # 2804 */
                      if (32&((UW *)Rv11)[46]) {
                        Ra.sl[8]=2805; /* line # 2805 */
                        if (!(1&((UW *)Rv12)[10])) Rv0=0;
                      }
                      Ra.sl[8]=2806; /* line # 2806 */
                      if (64&((UW *)Rv11)[46]) {
                        Ra.sl[8]=2807; /* line # 2807 */
                        if (!(2&((UW *)Rv12)[10])) Rv0=0;
                      }
                    }
                    else {
                      Ra.sl[8]=2810; /* line # 2810 */
                      if (64&((UW *)Rv11)[46]) Rv0=0;
                    }
                  }
                }
              }
            }
            else {
              Ra.sl[8]=2815; /* line # 2815 */
              if (((V *)Rv11)[8]==NULL&&!(8192&((UW *)Rv11)[46])) {
                Ra.sl[8]=2816; /* line # 2816 */
                Rv0=0;
              }
              else {
                Ra.sl[8]=2818; /* line # 2818 */
                Rv7=((V *)Rv11)[3];
              }
            }
            Ra.sl[8]=2820; /* line # 2820 */
            if (Rv10>0) while (1){
              Ra.sl[8]=2822; /* line # 2822 */
              Rv7=((V *)Rv7)[3];
              Rv10=Rv10-1;
              if (Rv10==0)  break;
            }
          }
        }
      }
    }
    Ra.sl[8]=2827; /* line # 2827 */
    if (!Rv0) (*F_pg)=((V *)(*F_pg))[0];
  }
  Ra.sl[8]=2829; /* line # 2829 */
  if (!Rv0) {
    Ra.sl[8]=2831; /* line # 2831 */
    PAS_EXPSION_PRC_00000012();
    Ra.sl[8]=2832; /* line # 2832 */
    P_src_error_s(Rd.s+3546,113,3, F_id,NULL);
  }
  else Ra.sl[8]=2838; /* line # 2838 */
  PAS__curr_cntx=Ra.v[1];
  Lx[4]=Lx_Sv;
}


/* Procedure/Function : " exp_genoper "  */
V P_exp_genoper(V F_id, V F_p, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3550;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2857; /* line # 2857 */
  Rv0=1+(SL)(((V *)F_oblst)[0]!=NULL);
  Ra.sl[6]=2858; /* line # 2858 */
  P_generic_search(F_id,Rv0, &F_p, F_oblst);
  Ra.sl[6]=2859; /* line # 2859 */
  if (F_p!=NULL) {
    Ra.sl[6]=2860; /* line # 2860 */
    Rv1=F_p;
    Ra.sl[6]=2862; /* line # 2862 */
    if (((UB *)Rv1)[8]) {
      Ra.sl[6]=2864; /* line # 2864 */
      if (Rv0==1) Rv2=P_exp_val_una(F_oblst, F_p);
      else {
        Ra.sl[6]=2865; /* line # 2865 */
        Rv2=P_exp_val_bin(F_oblst, F_p);
      }
    }
    else {
      Ra.sl[6]=2870; /* line # 2870 */
      Rv3=((V *)Rv1)[2];
      Ra.sl[6]=2872; /* line # 2872 */
      Rv2=P_lgt_new_call(((V *)Rv3)[11],((V *)Rv1)[2],F_oblst);
      Ra.sl[6]=2875; /* line # 2875 */
      P_call_setting(&Rv2);
    }
    Ra.sl[6]=2877; /* line # 2877 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=2878; /* line # 2878 */
    Ret=F_oblst;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generate_call "  */
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3563;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2894; /* line # 2894 */
  if (F_bsnsea) P_ide_search_from_nameid(F_ip);
  Ra.sl[6]=2895; /* line # 2895 */
  Rv0=((V *)F_ip)[10];
  Ra.sl[6]=2896; /* line # 2896 */
  if (F_np<=0) {
    Ra.sl[6]=2898; /* line # 2898 */
    Rv1=F_lgp;
    Ra.sl[6]=2899; /* line # 2899 */
    while (Rv1!=NULL){
      Ra.sl[6]=2900; /* line # 2900 */
      Rv1=((V *)Rv1)[0];
      F_np=F_np+1;
    }
  }
  Ra.sl[6]=2902; /* line # 2902 */
  Rv2=NULL;
  Ra.sl[6]=2903; /* line # 2903 */
  if (F_np==1||F_np==2) {
    Ra.sl[6]=2904; /* line # 2904 */
    Rv2=P_exp_genoper(((V *)F_ip)[0],Rv0, F_lgp);
  }
  else {
    Ra.sl[6]=2908; /* line # 2908 */
    P_generic_search(((V *)F_ip)[0],F_np, &Rv0, F_lgp);
    Ra.sl[6]=2909; /* line # 2909 */
    if (Rv0!=NULL) {
      Rv3=Rv0;
      Ra.sl[6]=2910; /* line # 2910 */
      if (((V *)Rv3)[2]!=NULL) {
        Ra.sl[6]=2912; /* line # 2912 */
        Rv2=P_lgt_new_call(((V *)((V *)Rv3)[2])[11],((V *)Rv3)[2],F_lgp);
        Ra.sl[6]=2913; /* line # 2913 */
        P_call_setting(&Rv2);
      }
    }
  }
  Ra.sl[6]=2917; /* line # 2917 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_genop "  */
V P_exp_genop(UB F_op, V F_oblst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3578;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2925; /* line # 2925 */
  Ret=P_exp_genoper((V_opname.s+F_op*32),((V *)V_ope_table.v[F_op])[3],F_oblst);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_gen_store "  */
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UW Rv2;
  UW Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3589;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=2940; /* line # 2940 */
  if (F_bstd) Rv0=V_std_store_dgf;
  else {
    Ra.sl[6]=2941; /* line # 2941 */
    Rv0=((V *)V_ope_table.v[28])[3];
  }
  Ra.sl[6]=2942; /* line # 2942 */
  Rv1=((V *)F_prm)[0];
  Ra.sl[6]=2943; /* line # 2943 */
  Rv2=((UW *)F_prm)[10];
  Ra.sl[6]=2944; /* line # 2944 */
  Rv3=((UW *)Rv1)[10];
  Ra.sl[6]=2945; /* line # 2945 */
  if (F_bovr) {
    Ra.sl[6]=2947; /* line # 2947 */
    ((UW *)F_prm)[10]=Rv2|3;
    Ra.sl[6]=2948; /* line # 2948 */
    ((UW *)Rv1)[10]=Rv3|1;
  }
  Ra.sl[6]=2950; /* line # 2950 */
  Rv4=P_exp_genoper(V_opname.s+896,Rv0, F_prm);
  Ra.sl[6]=2951; /* line # 2951 */
  if (F_bovr) {
    Ra.sl[6]=2953; /* line # 2953 */
    ((UW *)F_prm)[10]=Rv2;
    Ra.sl[6]=2954; /* line # 2954 */
    ((UW *)Rv1)[10]=Rv3;
  }
  Ra.sl[6]=2956; /* line # 2956 */
  Ret=Rv4;
  goto Ret_Label;
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
