/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"




/* Procedure/Function : " major_char "  */
C PAS__MAJOR_CHAR(C F_ch){
  register C Ret;

  /* Code of procedure/function */
  if (F_ch>=97&&F_ch<=122) Ret=(C)((SL)F_ch-32);
  else Ret=F_ch;
  return(Ret);
}


/* Procedure/Function : " minor_char "  */
C PAS__MINOR_CHAR(C F_ch){
  register C Ret;

  /* Code of procedure/function */
  if (F_ch>=65&&F_ch<=90) Ret=(C)((SL)F_ch+32);
  else Ret=F_ch;
  return(Ret);
}


/* Procedure/Function : " char_in_str "  */
V PAS__CHAR_IN_STR(V Ret, C F_ch){

  /* Code of procedure/function */
  ((UB *)Ret)[0]=1;
  ((C *)Ret)[2]=F_ch;
  ((UB *)Ret)[1]=1;
  return(Ret);
}


/* Procedure/Function : " cha_cpy "  */
void PAS__CHA_TO_STR(V F_dst, C F_ch){

  /* Code of procedure/function */
  ((UB *)F_dst)[1]=1;
  ((C *)F_dst)[2]=F_ch;
}


/* Procedure/Function : " cht_to_cht "  */
void PAS__CHT_TO_CHT(V F_dst, SL F_sd, V F_src, SL F_ss){
  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  if (F_ss>F_sd) Rv0=F_sd;
  else Rv0=F_ss;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_dst)[Rv1-1]=((C *)F_src)[Rv1-1];
    Rv1++;
  }
  if (F_ss<F_sd) {
    Rv2=Rv0+1;
    for( Rf0=(F_sd+1)-(Rv0+1);Rf0>0;Rf0-- ) {
      ((C *)F_dst)[Rv2-1]=32;
      Rv2++;
    }
  }
}


/* Procedure/Function : " cht_to_str "  */
void PAS__CHT_TO_STR(V F_dst, V F_src, SL F_sz){
  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  if (F_sz>((UB *)F_dst)[0]) Rv0=((UB *)F_dst)[0];
  else Rv0=F_sz;
  ((UB *)F_dst)[1]=Rv0;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_dst)[Rv1+1]=((C *)F_src)[Rv1-1];
    Rv1++;
  }
}


/* Procedure/Function : " str_cpy "  */
void PAS__STR_TO_STR(V F_dst, V F_src){
  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  if (F_src!=F_dst&&F_dst!=NULL) {
    Rv0=F_dst;
    if (F_src!=NULL) {
      Rv1=((UB *)F_src)[1];
      if (Rv1>((UB *)Rv0)[0]) Rv1=((UB *)Rv0)[0];
      ((UB *)Rv0)[1]=Rv1;
      Rv2=1;
      for( Rf0=Rv1;Rf0>0;Rf0-- ) {
        ((C *)Rv0)[Rv2+1]=((C *)F_src)[Rv2+1];
        Rv2++;
      }
    }
    else((UB *)Rv0)[1]=0;
  }
}


/* Procedure/Function : " set_case "  */
void PAS__SET_CASE(V F_s, UB F_maj){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  if (F_maj) {
    Rv0=1;
    for( Rf0=((UB *)F_s)[1];Rf0>0;Rf0-- ) {
      if (((C *)F_s)[Rv0+1]>=97&&((C *)F_s)[Rv0+1]<=122) ((C *)F_s)[Rv0+1]=(C)((
      SL)((C *)F_s)[Rv0+1]-32);
      Rv0++;
    }
  }
  else {
    Rv1=1;
    for( Rf0=((UB *)F_s)[1];Rf0>0;Rf0-- ) {
      if (((C *)F_s)[Rv1+1]>=65&&((C *)F_s)[Rv1+1]<=90) ((C *)F_s)[Rv1+1]=(C)((SL)
      ((C *)F_s)[Rv1+1]+32);
      Rv1++;
    }
  }
}


/* Procedure/Function : " concat_cc "  */
V PAS__CON_CHA_CHA(V Ret, C F_c1, C F_c2){

  /* Code of procedure/function */
  ((UB *)Ret)[0]=2;
  ((UB *)Ret)[1]=2;
  ((C *)Ret)[2]=F_c1;
  ((C *)Ret)[3]=F_c2;
  return(Ret);
}


/* Procedure/Function : " concat_sc "  */
V PAS__CON_STR_CHA(V Ret, V F_s1, C F_c2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Rv0=((UB *)F_s1)[1];
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  ((C *)Ret)[(Rv0+1)+1]=F_c2;
  ((UB *)Ret)[1]=Rv0+1;
  return(Ret);
}


/* Procedure/Function : " concat_cs "  */
V PAS__CON_CHA_STR(V Ret, C F_c1, V F_s2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Rv0=((UB *)F_s2)[1];
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  ((C *)Ret)[2]=F_c1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[(Rv1+1)+1]=((C *)F_s2)[Rv1+1];
    Rv1++;
  }
  ((UB *)Ret)[1]=Rv0+1;
  return(Ret);
}


/* Procedure/Function : " concat_ss "  */
V PAS__CON_STR_STR(V Ret, V F_s1, V F_s2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (((UB *)F_s1)[1]>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=((UB *)F_s1)[1];
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>((UB *)F_s2)[1]) Rv2=((UB *)F_s2)[1];
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3+1];
    Rv3++;
  }
  ((UB *)Ret)[1]=Rv0;
  return(Ret);
}


/* Procedure/Function : " concat_tc "  */
V PAS__CON_CHT_CHA(V Ret, V F_s1, SL F_l1, C F_c2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Rv0=((UB *)Ret)[0];
  if (F_l1>=((UB *)Ret)[0]) {
    Rv1=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
      Rv1++;
    }
    ((UB *)Ret)[1]=Rv0;
  }
  else {
    Rv2=1;
    for( Rf0=F_l1;Rf0>0;Rf0-- ) {
      ((C *)Ret)[Rv2+1]=((C *)F_s1)[Rv2-1];
      Rv2++;
    }
    ((C *)Ret)[(F_l1+1)+1]=F_c2;
    ((UB *)Ret)[1]=F_l1+1;
  }
  return(Ret);
}


/* Procedure/Function : " concat_ct "  */
V PAS__CON_CHA_CHT(V Ret, C F_c1, V F_s2, SL F_l2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Rv0=F_l2;
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  ((C *)Ret)[2]=F_c1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[(Rv1+1)+1]=((C *)F_s2)[Rv1-1];
    Rv1++;
  }
  ((UB *)Ret)[1]=Rv0+1;
  return(Ret);
}


/* Procedure/Function : " concat_st "  */
V PAS__CON_STR_CHT(V Ret, V F_s1, V F_s2, SL F_l2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (((UB *)F_s1)[1]>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=((UB *)F_s1)[1];
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>F_l2) Rv2=F_l2;
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3-1];
    Rv3++;
  }
  ((UB *)Ret)[1]=Rv0;
  return(Ret);
}


/* Procedure/Function : " concat_ts "  */
V PAS__CON_CHT_STR(V Ret, V F_s1, SL F_l1, V F_s2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (F_l1>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=F_l1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>((UB *)F_s2)[1]) Rv2=((UB *)F_s2)[1];
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3+1];
    Rv3++;
  }
  ((UB *)Ret)[1]=Rv0;
  return(Ret);
}


/* Procedure/Function : " concat_tt "  */
V PAS__CON_CHT_CHT(V Ret, V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (F_l1>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else Rv0=F_l1;
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
    Rv1++;
  }
  Rv2=((UB *)Ret)[0]-Rv0;
  if (Rv2>F_l2) Rv2=F_l2;
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3-1];
    Rv3++;
  }
  ((UB *)Ret)[1]=Rv0;
  return(Ret);
}


/* Procedure/Function : " substr "  */
V PAS__SUBSTR_STR(V Ret, V F_s, SL F_i, SL F_j){
  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (F_i<1) F_i=1;
  else {
    if (F_i>((UB *)F_s)[1]) {
      F_j=0;
      goto L_l_0;
    }
  }
  if (F_j<=0) F_j=(((UB *)F_s)[1]-F_i)+1;
  else {
    if ((F_j+F_i)-1>((UB *)F_s)[1]) F_j=(((UB *)F_s)[1]-F_i)+1;
  }
  if (F_j>((UB *)Ret)[0]) F_j=((UB *)Ret)[0];
  Rv0=1;
  for( Rf0=F_j;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv0+1]=((C *)F_s)[((Rv0+F_i)-1)+1];
    Rv0++;
  }
L_l_0:
  ((UB *)Ret)[1]=F_j;
  return(Ret);
}


/* Procedure/Function : " substr "  */
V PAS__SUBSTR_CHT(V Ret, V F_s, SL F_sz, SL F_i, SL F_j){
  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  if (F_i<1) F_i=1;
  else {
    if (F_i>F_sz) {
      F_j=0;
      goto L_l_0;
    }
  }
  if (F_j<=0) F_j=(F_sz-F_i)+1;
  else {
    if ((F_j+F_i)-1>F_sz) F_j=(F_sz-F_i)+1;
  }
  if (F_j>((UB *)Ret)[0]) F_j=((UB *)Ret)[0];
  Rv0=1;
  for( Rf0=F_j;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv0+1]=((C *)F_s)[((Rv0+F_i)-1)-1];
    Rv0++;
  }
L_l_0:
  ((UB *)Ret)[1]=F_j;
  return(Ret);
}


/* Procedure/Function : " index_cha "  */
SL PAS__INDEX_CHA(V F_s1, SL F_l1, C F_ch){
  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  Rv1=0;
  while (Rv0<F_l1&&!Rv1){
    Rv0=Rv0+1;
    Rv1=F_ch==((C *)F_s1)[Rv0-1];
  }
  if (!Rv1) Rv0=0;
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " index_str "  */
SL PAS__INDEX_STR(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  C Rv2;
  SL Rv3;
  SL Rv4;
  register SL Ret;

  /* Code of procedure/function */
  if (F_s1==F_s2) Rv0=1;
  else {
    Rv1=0;
    Rv0=0;
    if (F_l2>0&&F_l1>=F_l2) {
      Rv2=((C *)F_s2)[0];
      while (Rv0<=F_l1-F_l2&&!Rv1){
        Rv0=Rv0+1;
        if (Rv2==((C *)F_s1)[Rv0-1]) {
          Rv3=Rv0+1;
          Rv4=2;
          while (Rv4<=F_l2&&((C *)F_s1)[Rv3-1]==((C *)F_s2)[Rv4-1]){
            Rv4=Rv4+1;
            Rv3=Rv3+1;
          }
          Rv1=Rv4>F_l2;
        }
      }
    }
    if (!Rv1) Rv0=0;
  }
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " nindex_cha "  */
SL PAS__NINDEX_CHA(V F_s, SL F_l, C F_c, SL F_nb, SL F_ip, UB F_nc){
  /* Local variable stored in C variable */
  UB Rv0;
  C Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (F_nb==0) F_nb=1;
  if (!F_nc) F_c=PAS__MAJOR_CHAR(F_c);
  if (F_l>0) {
    if (F_nb>0) {
      if (F_ip<=0) F_ip=1;
      while (F_ip<=F_l&&!Rv0){
        if (F_nc) Rv1=((C *)F_s)[F_ip-1];
        else Rv1=PAS__MAJOR_CHAR(((C *)F_s)[F_ip-1]);
        if (F_c==Rv1) {
          F_nb=F_nb -1;
          Rv0=F_nb==0;
        }
        if (!Rv0) F_ip=F_ip+1;
      }
    }
    else {
      F_nb= -F_nb;
      if (F_ip<0||F_ip>F_l) F_ip=F_l;
      while (F_ip>1&&!Rv0){
        if (F_nc) Rv1=((C *)F_s)[F_ip-1];
        else Rv1=PAS__MAJOR_CHAR(((C *)F_s)[F_ip-1]);
        if (F_c==Rv1) {
          F_nb=F_nb -1;
          Rv0=F_nb==0;
        }
        if (!Rv0) F_ip=F_ip-1;
      }
    }
  }
  if (!Rv0) F_ip=0;
  Ret=F_ip;
  return(Ret);
}


/* Procedure/Function : " nindex_str "  */
SL PAS__NINDEX_STR(V F_s1, SL F_l1, V F_s2, SL F_l2, SL F_nb, SL F_ip, UB F_nc){
  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  C Rv2;
  C Rv3;
  SL Rv4;
  SL Rv5;
  register SL Ret;

  /* Code of procedure/function */
  Rv0=0;
  if (F_nb==0) F_nb=1;
  if (F_l2>0&&F_l1>=F_l2) {
    Rv1=(F_l1-F_l2)+1;
    if (F_nb>0) {
      if (F_ip<=0) F_ip=1;
      if (F_nc) Rv2=((C *)F_s2)[0];
      else Rv2=PAS__MAJOR_CHAR(((C *)F_s2)[0]);
      while (F_ip<=Rv1&&!Rv0){
        if (F_nc) Rv3=((C *)F_s1)[F_ip-1];
        else Rv3=PAS__MAJOR_CHAR(((C *)F_s1)[F_ip-1]);
        if (Rv2==Rv3) {
          Rv4=F_ip+1;
          Rv5=2;
          Rv0=1;
          while (Rv5<=F_l2&&Rv0){
            if (F_nc) Rv0=((C *)F_s1)[Rv4-1]==((C *)F_s2)[Rv5-1];
            else Rv0=PAS__MAJOR_CHAR(((C *)F_s1)[Rv4-1])==PAS__MAJOR_CHAR(((C *)
            F_s2)[Rv5-1]);
            Rv4=Rv4+1;
            Rv5=Rv5+1;
          }
          if (Rv0) {
            F_nb=F_nb -1;
            Rv0=F_nb==0;
          }
        }
        if (!Rv0) F_ip=F_ip+1;
      }
    }
    else {
      F_nb= -F_nb;
      if (F_ip<0||F_ip>Rv1) F_ip=Rv1;
      if (F_nc) Rv2=((C *)F_s2)[0];
      else Rv2=PAS__MAJOR_CHAR(((C *)F_s2)[0]);
      while (F_ip>0&&!Rv0){
        if (F_nc) Rv3=((C *)F_s1)[F_ip-1];
        else Rv3=PAS__MAJOR_CHAR(((C *)F_s1)[F_ip-1]);
        if (Rv2==Rv3) {
          Rv4=F_ip+1;
          Rv5=2;
          Rv0=1;
          while (Rv5<=F_l2&&Rv0){
            if (F_nc) Rv0=((C *)F_s1)[Rv4-1]==((C *)F_s2)[Rv5-1];
            else Rv0=PAS__MAJOR_CHAR(((C *)F_s1)[Rv4-1])==PAS__MAJOR_CHAR(((C *)
            F_s2)[Rv5-1]);
            Rv4=Rv4+1;
            Rv5=Rv5+1;
          }
          if (Rv0) {
            F_nb=F_nb -1;
            Rv0=F_nb==0;
          }
        }
        if (!Rv0) F_ip=F_ip-1;
      }
    }
  }
  if (!Rv0) F_ip=0;
  Ret=F_ip;
  return(Ret);
}


/* Procedure/Function : " str_len "  */
SL PAS__LENGTH_STR(V F_s){
  register SL Ret;

  /* Code of procedure/function */
  Ret=((UB *)F_s)[1];
  return(Ret);
}


/* Procedure/Function : " str_match "  */
SL PAS__MATCH_STR(V F_s1, V F_s2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  if (((UB *)F_s1)[1]<((UB *)F_s2)[1]) Rv0=((UB *)F_s1)[1];
  else Rv0=((UB *)F_s2)[1];
  Rv1=1;
  while (Rv1<=Rv0&&((C *)F_s1)[Rv1+1]==((C *)F_s2)[Rv1+1])
  Rv1=Rv1+1;
  if (Rv1>Rv0) Rv2=((UB *)F_s1)[1]-((UB *)F_s2)[1];
  else Rv2=(SL)((C *)F_s1)[Rv1+1]-(SL)((C *)F_s2)[Rv1+1];
  Ret=Rv2;
  return(Ret);
}


/* Procedure/Function : " cht_match "  */
SL PAS__MATCH_CHT(V F_s1, SL F_cap1, SL F_l1, V F_s2, SL F_cap2, SL F_l2){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  if (F_l1<=0) F_l1=F_cap1;
  if (F_l2<=0) F_l2=F_cap2;
  if (F_l1<F_l2) Rv0=11;
  else Rv0=F_l2;
  Rv1=1;
  while (Rv1<=Rv0&&((C *)F_s1)[Rv1-1]==((C *)F_s2)[Rv1-1])
  Rv1=Rv1+1;
  if (Rv1>Rv0) Rv2=F_l1-F_l2;
  else Rv2=(SL)((C *)F_s1)[Rv1-1]-(SL)((C *)F_s2)[Rv1-1];
  Ret=Rv2;
  return(Ret);
}


/* Procedure/Function : " string_locate_sep "  */
void PAS__STR_LSEP(V F_st, SL F_l, V F_sp, SL F_n, V F_tp, SL F_nsp, SL *F_ie){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  (*F_ie)=0;
  Rv0=1;
  for( Rf0=F_l;Rf0>0;Rf0-- ) {
    Rv1=1;
    while (Rv1<=F_n&&((C *)F_sp)[Rv1-1]!=((C *)F_st)[Rv0-1])
    Rv1=Rv1+1;
    if (Rv1<=F_n) {
      (*F_ie)=(*F_ie)+1;
      if ((*F_ie)>=F_nsp) {
        (*F_ie)= -((*F_ie) -1);
        goto L_l_0;
      }
      ((UB *)F_tp)[(*F_ie)-1]=Rv1;
      (*F_ie)=(*F_ie)+1;
      ((UB *)F_tp)[(*F_ie)-1]=Rv0;
    }
    Rv0++;
  }
L_l_0:
  ;
}


/* Procedure/Function : " str_lt "  */
UB PAS__LT_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)<0;
  return(Ret);
}


/* Procedure/Function : " str_le "  */
UB PAS__LE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)<=0;
  return(Ret);
}


/* Procedure/Function : " str_ge "  */
UB PAS__GE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)>=0;
  return(Ret);
}


/* Procedure/Function : " str_gt "  */
UB PAS__GT_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)>0;
  return(Ret);
}


/* Procedure/Function : " str_eq "  */
UB PAS__EQ_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)==0;
  return(Ret);
}


/* Procedure/Function : " str_ne "  */
UB PAS__NE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)!=0;
  return(Ret);
}


/* Procedure/Function : " str_le "  */
UB PAS__LE_STR(V F_s1, V F_s2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_STR(F_s1,F_s2)<=0;
  return(Ret);
}


/* Procedure/Function : " str_ge "  */
UB PAS__GE_STR(V F_s1, V F_s2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_STR(F_s1,F_s2)>=0;
  return(Ret);
}


/* Procedure/Function : " str_gt "  */
UB PAS__GT_STR(V F_s1, V F_s2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_STR(F_s1,F_s2)>0;
  return(Ret);
}


/* Procedure/Function : " str_eq "  */
UB PAS__EQ_STR(V F_s1, V F_s2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_STR(F_s1,F_s2)==0;
  return(Ret);
}


/* Procedure/Function : " str_ne "  */
UB PAS__NE_STR(V F_s1, V F_s2){
  register UB Ret;

  /* Code of procedure/function */
  Ret=PAS__MATCH_STR(F_s1,F_s2)!=0;
  return(Ret);
}
