{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                ---  OPEN/CLOSE/READ DIRECTORY  ---                    *
*               ---  Version  3.1-A -- 31/01/2015 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Louis Neel                                   *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

%pragma trace 0; { Always here: called by PAS__ERROR to don't loop }
module PAS__DIR;


%pragma code_option (c_interface, { To authorize the use of "standard" keyword }
    c_code '#define BASIC_IO   0',
    c_code '#include <dirent.h>',
    c_code '#define Dir_fnm Dir_ptr->d_name',
    c_code 'static struct dirent * Dir_ptr;'
  );

const
  system_unix   = BOOLEAN( sys_system = systyp_unix );
  system_mosx   = BOOLEAN( sys_system = systyp_mosx );
  system_cygw   = BOOLEAN( sys_system = systyp_cygw );
  system_wind   = BOOLEAN( sys_system = systyp_wind );


type
  dir_name = packed array[0..255] of char;

  dpt_name = ^dir_name;

var
  [standard 'Dir_ptr'] dpt:   $wild_pointer; { Pointer to the dirent structure }
  [standard 'Dir_fnm'] fname: dpt_name;      { Filaneme pointer }


  [global 'PAS__dspc'] curr_dspc: string;    { Current file specification }


%include 'PASSRC:cpas__ccdef.pas'{, list_on};

%include 'PASSRC:cpas__stddef.pas'{, list_on};


type
  { Define the Class of file Procedure array variable }
  file_chtab = array[1..28] of cc__int;   { File charac. table (for GET_FILE_INFO) }

var
  [external 'PAS__file_info'] tbfch: file_chtab; { Current File Characteristics }






function SET_FILESPC( var    trg: string;
                      in_var src: string;
                             imod: open_flags ): boolean;
external 'PAS__SET_FILESPC';



function FSPC_GET_INFO( in_var spc: string ): integer; external 'PAS__FSPC_GET_INFO';




[global 'PAS__MAKE_DIR']
procedure MAKE_DIR( in_var dspc: string; umsk: flags_file := []; iprot: integer := -1 );
begin
  if not SET_FILESPC( curr_dspc, dspc, umsk ) then
  begin
    iostatus := 121;
    if not (error_file in umsk) then PAS__ERROR( 121 )
  end
  else
  begin
    if CC__MKDIR( curr_dspc.body"address, iprot ) <> 0 then
    begin
      iostatus := CC__ERROR;
      if not (error_file in umsk) then PAS__ERROR( iostatus )
    end
  end
end MAKE_DIR;



[global 'PAS__REMOVE_DIR']
procedure REMOVE_DIR( in_var dspc: string; umsk: flags_file := [] );
begin
  if not SET_FILESPC( curr_dspc, dspc, umsk ) then
  begin
    iostatus := 121;
    if not (error_file in umsk) then PAS__ERROR( 121 )
  end
  else
  begin
    if CC__RMDIR( curr_dspc.body"address ) <> 0 then
    begin
      iostatus := CC__ERROR;
      if not (error_file in umsk) then PAS__ERROR( iostatus )
    end
  end
end REMOVE_DIR;



[global 'PAS__OPEN_DIR']
procedure OPEN_DIR(    var   df: $wild_pointer;
                    in_var dspc: string;
                           umsk: flags_file );
begin
  if not SET_FILESPC( curr_dspc, dspc, umsk ) then
  begin
    iostatus := 121;
    if not (error_file in umsk) then PAS__ERROR( 121 )
  end
  else
  begin
    df := CC__OPENDIR( curr_dspc.body"address );
    if df = nil then
    begin
      iostatus := CC__ERROR;
      if not (error_file in umsk) then PAS__ERROR( iostatus )
    end
    else iostatus := 0
  end
end OPEN_DIR;




[global 'PAS__CLOSE_DIR']
procedure CLOSE_DIR(   var df: $wild_pointer );
begin
  iostatus := CC__CLOSEDIR( df );
  if iostatus < 0 then PAS__ERROR( CC__ERROR )
end CLOSE_DIR;




[global 'PAS__READ_DIR']
procedure READ_DIR( df: $wild_pointer; var str: string; var ierr: integer );
var
  i: integer;
  c: char;

begin
  dpt := CC__READDIR( df );
  if dpt = nil then
    ierr := -1 { end of directory }
  else
  begin
    ierr := 0;
    i    := 0;
    loop
      c := fname^[i];     { Warning: The low bound is 0 here }
    exit if (ORD( c ) = 0) or (i >= str.capacity);
      i := i + 1;
      str.body[i] := c
    end;
    str.length := i;
    ierr := ORD( i >= str.capacity )
  end  
end READ_DIR;



end.
