/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 576 ) = {
 12,  12, 115, 116, 114,  95,  99, 111, 112, 121,  95, 108, 105, 109,  62,  62,
 47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  52,  47,  99,
112,  97, 115,  95,  98,  95,  95, 108, 115, 116,  46, 112,  97, 115,   8,   8,
108, 115, 116,  95, 105, 110, 105, 116,  12,  12, 108, 115, 116,  95,  97, 108,
108, 111,  99,  97, 116, 101,   8,   8, 108, 115, 116,  95, 102, 114, 101, 101,
  9,   9, 108, 115, 116,  95,  99, 108, 111, 115, 101,  18,  18, 108, 115, 116,
 95,  99, 104,  97, 110, 103, 101,  95, 104, 101,  97, 100, 105, 110, 103,   8,
  8,  82, 117, 110,  32, 116, 104, 101,  32,   4,   4,  32,  97, 116,  32,   2,
  2,  27,  92,   8,   8,  72,  69,  65,  68,  73,  78,  71,  32,   3,   3,  32,
 45,  32,   8,   8,  72,  69,  65,  68,  73,  78,  71,  32,  16,  16, 108, 115,
116,  95,  99, 104,  97, 110, 103, 101,  95, 116, 105, 116, 108, 101,   6,   6,
 84,  73,  84,  76,  69,  32,   7,   7,  84,  73,  84,  76,  69,  32,  48,  19,
 19, 108, 115, 116,  95,  99, 104,  97, 110, 103, 101,  95, 115, 117,  98, 116,
105, 116, 108, 101,   9,   9,  83,  85,  66,  84,  73,  84,  76,  69,  32,  10,
 10,  83,  85,  66,  84,  73,  84,  76,  69,  32,  48,   8,   8, 108, 115, 116,
 95, 111, 112, 101, 110,   0,   0,   0,   0,   0,   0,  11,  11, 108, 115, 116,
 95, 110, 101, 119, 108, 105, 110, 101,   5,   5,  80,  97, 103, 101,  32,   8,
  8, 108, 115, 116,  95, 101, 111, 108, 110,  15,  15, 108, 115, 116,  95,  98,
114, 101,  97, 107, 111, 117, 116, 112, 117, 116,   8,   8, 108, 115, 116,  95,
112,  97, 103, 101,  14,  14, 108, 115, 116,  95, 115, 101, 116,  95,  99, 111,
108, 117, 109, 110,  14,  14, 108, 115, 116,  95, 115, 101, 116,  95, 109,  97,
114, 103, 105, 110,  13,  13, 108, 115, 116,  95, 115, 107, 105, 112,  95, 108,
105, 110, 101,  10,  10,  92,  83,  75,  73,  80,  76,  73,  78,  69,  32,  17,
 17, 108, 115, 116,  95, 115, 101, 116,  95,  99, 104,  97, 114,  95,  97, 116,
116, 114,   3,   3,  78,  78,  78,   3,   3,  78,  78,  78,  11,  11,  92,  67,
 72,  65,  82,  95,  65,  84,  84,  82,  32,  13,  13, 108, 115, 116,  95, 116,
101, 115, 116,  95, 108, 105, 110, 101,  10,  10,  84,  69,  83,  84,  95,  76,
 73,  78,  69,  32,  12,  12, 108, 115, 116,  95, 112, 117, 116,  95,  99, 104,
 97, 114,  13,  13, 108, 115, 116,  95, 112, 117, 116,  95, 109,  99, 104,  97,
114,  14,  14, 108, 115, 116,  95, 112, 117, 116,  95, 115, 116, 114, 105, 110,
103,  11,  11, 108, 115, 116,  95, 112, 117, 116,  95, 105, 110, 116,  13,  13,
108, 115, 116,  95, 112, 117, 116,  95, 102, 108, 111,  97, 116,  13,  13, 108,
115, 116,  95, 112, 117, 116,  95, 102, 105, 120, 101, 100,  10,  10, 108, 115,
116,  95, 103,  95, 105, 110, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;

/* Declaration of global variables. */
V V_lst_current = NULL;
V V_lst_hde = NULL;
UL V_lst_spc_mode = 0;
Blk(V_lst_date, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_lst_time, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };

/* Function/procedure prototypes. */
void P_vls_nextstring();


/* Procedure/Function : " str_copy_lim "  */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=148; /* line # 148 */
  Rv0=((UB *)F_src)[1];
  Ra.sl[6]=149; /* line # 149 */
  if (F_lim==0) F_lim=Rv0;
  else {
    Ra.sl[6]=150; /* line # 150 */
    if (Rv0>F_lim) Rv0=F_lim;
  }
  Ra.sl[6]=151; /* line # 151 */
  if ((*F_trg)!=NULL) PAS__DISPOSE(F_trg);
  Ra.sl[6]=152; /* line # 152 */
  if (Rv0>0) {
    Ra.sl[6]=154; /* line # 154 */
    Rv1=Rv0;
    (*F_trg)=PAS__NEW((SL)Rv1+2);
    ((UB *)(*F_trg))[0]=Rv1;
    Ra.sl[6]=155; /* line # 155 */
    PAS__STR_TO_STR((*F_trg),F_src);
  }
  else {
    Ra.sl[6]=157; /* line # 157 */
    (*F_trg)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_init "  */
void P_lst_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+78;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=165; /* line # 165 */
  Rv0=F_p;
  Ra.sl[6]=168; /* line # 168 */
  ((V *)Rv0)[1]=NULL;
  Ra.sl[6]=169; /* line # 169 */
  ((V *)Rv0)[2]=NULL;
  Ra.sl[6]=170; /* line # 170 */
  ((V *)Rv0)[4]=NULL;
  Ra.sl[6]=171; /* line # 171 */
  ((V *)Rv0)[5]=NULL;
  Ra.sl[6]=172; /* line # 172 */
  ((SL *)Rv0)[12]=0;
  Ra.sl[6]=173; /* line # 173 */
  ((SL *)Rv0)[13]=0;
  Ra.sl[6]=174; /* line # 174 */
  ((SL *)Rv0)[14]=0;
  Ra.sl[6]=175; /* line # 175 */
  ((SL *)Rv0)[15]=0;
  Ra.sl[6]=176; /* line # 176 */
  ((SL *)Rv0)[16]=0;
  Ra.sl[6]=177; /* line # 177 */
  ((SL *)Rv0)[17]=0;
  Ra.sl[6]=178; /* line # 178 */
  ((UB *)Rv0)[72]=0;
  Ra.sl[6]=179; /* line # 179 */
  _FILE_CLEAR(((V *)Rv0)[10]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_allocate "  */
V P_lst_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+88;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=190; /* line # 190 */
  Rv0=PAS__NEW(88);
  Ra.sl[6]=191; /* line # 191 */
  ((V *)Rv0)[0]=V_lst_hde;
  V_lst_hde=Rv0;
  Ra.sl[6]=192; /* line # 192 */
  ((V *)Rv0)[3]=PAS__NEW(34);
  ((UB *)((V *)Rv0)[3])[0]=32;
  Ra.sl[6]=193; /* line # 193 */
  P_lst_init(Rv0);
  Ra.sl[6]=194; /* line # 194 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lst_free "  */
void P_lst_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+102;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=206; /* line # 206 */
  Rv0=NULL;
  Ra.sl[6]=207; /* line # 207 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=209; /* line # 209 */
    Rv1=V_lst_hde;
    Ra.sl[6]=210; /* line # 210 */
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[6]=212; /* line # 212 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else {
    Ra.sl[6]=214; /* line # 214 */
    Rv1=NULL;
  }
  Ra.sl[6]=215; /* line # 215 */
  if (Rv1!=NULL) {
    Ra.sl[6]=216; /* line # 216 */
    Rv2=(*F_p);
    Ra.sl[6]=218; /* line # 218 */
    if (((V *)Rv2)[1]!=NULL) PAS__DISPOSE(((V *)Rv2)+1);
    Ra.sl[6]=219; /* line # 219 */
    if (((V *)Rv2)[3]!=NULL) PAS__DISPOSE(((V *)Rv2)+3);
    Ra.sl[6]=220; /* line # 220 */
    if (((V *)Rv2)[2]!=NULL) PAS__DISPOSE(((V *)Rv2)+2);
    Ra.sl[6]=221; /* line # 221 */
    if (((V *)Rv2)[4]!=NULL) PAS__DISPOSE(((V *)Rv2)+4);
    Ra.sl[6]=222; /* line # 222 */
    if (((V *)Rv2)[5]!=NULL) PAS__DISPOSE(((V *)Rv2)+5);
    Ra.sl[6]=223; /* line # 223 */
    if (Rv0==NULL) V_lst_hde=((V *)Rv2)[0];
    else {
      Ra.sl[6]=224; /* line # 224 */
      ((V *)Rv0)[0]=((V *)Rv2)[0];
    }
    Ra.sl[6]=225; /* line # 225 */
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_close "  */
void P_lst_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+112;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=238; /* line # 238 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=240; /* line # 240 */
    Rv0=(*F_p);
    Ra.sl[6]=242; /* line # 242 */
    if (1&((UB *)Rv0)[72]) Rv1=1024;
    else {
      Ra.sl[6]=243; /* line # 243 */
      Rv1=0;
    }
    Ra.sl[6]=245; /* line # 245 */
    if ((68&((UB *)Rv0)[72])==0) PAS__CLOSE(((V *)Rv0)+10,Rv1);
    Ra.sl[6]=246; /* line # 246 */
    PAS__DISPOSE(((V *)Rv0)+1);
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=247; /* line # 247 */
    if (((V *)Rv0)[2]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+2);
      ((V *)Rv0)[2]=NULL;
    }
    Ra.sl[6]=248; /* line # 248 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+4);
      ((V *)Rv0)[4]=NULL;
    }
    Ra.sl[6]=249; /* line # 249 */
    if (((V *)Rv0)[5]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+5);
      ((V *)Rv0)[5]=NULL;
    }
    Ra.sl[6]=251; /* line # 251 */
    if (F_bfree) P_lst_free(F_p);
    else {
      Ra.sl[6]=252; /* line # 252 */
      P_lst_init((*F_p));
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_heading "  */
void P_lst_change_heading(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+123;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=264; /* line # 264 */
  Rv0=V_lst_current;
  Ra.sl[6]=266; /* line # 266 */
  Rv1=((((SL *)Rv0)[16]-32)-4)-12;
  Ra.sl[6]=269; /* line # 269 */
  if (Rv1<60) Rv1=60;
  Ra.sl[6]=270; /* line # 270 */
  P_str_copy_lim(((V *)Rv0)+2,F_str,Rv1);
  Ra.sl[6]=271; /* line # 271 */
  PAS__DATE_STR(V_lst_date.s);
  PAS__TIME_STR(V_lst_time.s);
  Ra.sl[6]=272; /* line # 272 */
  PAS__VWRITE_INIT(((V *)Rv0)[3],1);
  PAS__WRITE_STR(Rd.s+143,-1,-1,32);
  PAS__WRITE_STR(V_lst_date.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+153,-1,-1,32);
  PAS__WRITE_STR(V_lst_time.s,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=273; /* line # 273 */
  if (((SL *)Rv0)[17]<0) {
    Ra.sl[6]=275; /* line # 275 */
    if (((V *)Rv0)[2]!=NULL) {
      Ra.sl[6]=276; /* line # 276 */
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+163,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[2])[1]+((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
      PAS__WRITE_STR(Rd.s+173,-1,-1,32);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=279; /* line # 279 */
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+178,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=280; /* line # 280 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_title "  */
void P_lst_change_title(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+188;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=290; /* line # 290 */
  Rv0=V_lst_current;
  Ra.sl[6]=292; /* line # 292 */
  P_str_copy_lim(((V *)Rv0)+4,F_str,((SL *)Rv0)[16]-1);
  Ra.sl[6]=293; /* line # 293 */
  if (((SL *)Rv0)[17]<0) {
    Ra.sl[6]=295; /* line # 295 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+206,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[4])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=296; /* line # 296 */
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+214,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=297; /* line # 297 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_subtitle "  */
void P_lst_change_subtitle(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+223;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=307; /* line # 307 */
  Rv0=V_lst_current;
  Ra.sl[6]=309; /* line # 309 */
  P_str_copy_lim(((V *)Rv0)+5,F_str,((SL *)Rv0)[16]-1);
  Ra.sl[6]=310; /* line # 310 */
  if (((SL *)Rv0)[17]<0) {
    Ra.sl[6]=312; /* line # 312 */
    if (((V *)Rv0)[5]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+244,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[5])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=313; /* line # 313 */
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+255,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=314; /* line # 314 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_open "  */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 808 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  register UB Rv3;
  SL Rv4;
  UB Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  Ra.v[97]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+776;
  Ra.v[98]=Rd.s+267;
  Ra.v[99]=Rd.s+14;
  Ra.sl[200]=354; /* line # 354 */
  if (F_heading!=NULL) PAS__STR_TO_STR(Ra.s,F_heading);
  else PAS__STR_TO_STR(Ra.s,Rd.s+277);
  Ra.sl[200]=355; /* line # 355 */
  if (F_title!=NULL) PAS__STR_TO_STR(Ra.s+257,F_title);
  else PAS__STR_TO_STR(Ra.s+257,Rd.s+279);
  Ra.sl[200]=356; /* line # 356 */
  if (F_sbttl!=NULL) PAS__STR_TO_STR(Ra.s+514,F_sbttl);
  else PAS__STR_TO_STR(Ra.s+514,Rd.s+281);
  Ra.sl[200]=359; /* line # 359 */
  Rv0=(*F_p)!=NULL;
  Ra.sl[200]=360; /* line # 360 */
  if ((*F_p)==NULL) (*F_p)=P_lst_allocate();
  else {
    Ra.sl[200]=361; /* line # 361 */
    P_lst_close(F_p,0);
  }
  Ra.sl[200]=362; /* line # 362 */
  Rv1=(*F_p);
  Ra.sl[200]=364; /* line # 364 */
  if (((UB *)F_fspc)[1]==0) {
    Ra.sl[200]=366; /* line # 366 */
    _FILE_DUPLICATE(((V *)Rv1)[10],PAS__f_output);
    Ra.sl[200]=367; /* line # 367 */
    ((UB *)Rv1)[72]=4;
    Ra.sl[200]=368; /* line # 368 */
    PAS__iostatus=0;
  }
  else {
    Ra.sl[200]=372; /* line # 372 */
    Rv2=4098|V_lst_spc_mode;
    Ra.sl[200]=373; /* line # 373 */
    if (F_bprint) ((UB *)Rv1)[72]=1;
    Ra.sl[200]=374; /* line # 374 */
    if (F_bappend) Rv2=Rv2|4;
    Ra.sl[200]=375; /* line # 375 */
    if (F_bunknown) Rv2=Rv2|64;
    Ra.sl[200]=376; /* line # 376 */
    PAS__OPEN(((V *)Rv1)+10,0, F_fspc,Rv2,0,-1);
  }
  Ra.sl[200]=379; /* line # 379 */
  if (PAS__iostatus==0) {
    Ra.sl[200]=381; /* line # 381 */
    if (PAS__TTY_FILE(((V *)Rv1)[10])) {
      Ra.sl[200]=383; /* line # 383 */
      ((UB *)Rv1)[72]=((UB *)Rv1)[72]|2;
      Ra.sl[200]=384; /* line # 384 */
      ((UB *)Rv1)[72]=((UB *)Rv1)[72]&~1;
      Ra.sl[200]=385; /* line # 385 */
      if (F_lnsize<0) F_lnsize=80;
      Ra.sl[200]=386; /* line # 386 */
      if (F_pgsize<0) F_pgsize=0;
    }
    else {
      Ra.sl[200]=390; /* line # 390 */
      if (F_lnsize<0) F_lnsize=132;
      Ra.sl[200]=391; /* line # 391 */
      if (F_pgsize==0) F_pgsize=-1;
      else {
        Ra.sl[200]=392; /* line # 392 */
        if (F_pgsize<0) F_pgsize=60;
      }
    }
    Ra.sl[200]=395; /* line # 395 */
    Rv3=F_lnsize;
    ((V *)Rv1)[1]=PAS__NEW((SL)Rv3+2);
    ((UB *)((V *)Rv1)[1])[0]=Rv3;
    Ra.sl[200]=396; /* line # 396 */
    ((UB *)((V *)Rv1)[1])[1]=0;
    Ra.sl[200]=397; /* line # 397 */
    Rv4=F_lnsize-1;
    Ra.sl[200]=399; /* line # 399 */
    ((SL *)Rv1)[17]=F_pgsize;
    ((SL *)Rv1)[16]=F_lnsize;
    Ra.sl[200]=400; /* line # 400 */
    ((SL *)Rv1)[15]=((SL *)Rv1)[16];
    Ra.sl[200]=401; /* line # 401 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[17];
    Ra.sl[200]=403; /* line # 403 */
    Rv5=0;
    Ra.sl[200]=404; /* line # 404 */
    if (Ra.ub[1]>0) {
      Rv5=1;
      P_lst_change_heading(Ra.s,0);
    }
    Ra.sl[200]=405; /* line # 405 */
    if (Ra.ub[258]>0) {
      Rv5=1;
      P_lst_change_title(Ra.s+257,0);
    }
    Ra.sl[200]=406; /* line # 406 */
    if (Ra.ub[515]>0) {
      Rv5=1;
      P_lst_change_subtitle(Ra.s+514,1);
    }
    Ra.sl[200]=407; /* line # 407 */
    if (Rv5&&((SL *)Rv1)[17]<0) {
      PAS__SELECT_OUT(((V *)Rv1)[10]);
      PAS__WRITE_EOLN();
    }
    Ra.sl[200]=408; /* line # 408 */
    (*F_ierr)=0;
  }
  else {
    Ra.sl[200]=410; /* line # 410 */
    (*F_ierr)=2000+PAS__iostatus;
  }
  Ra.sl[200]=412; /* line # 412 */
  if ((*F_ierr)!=0) {
    Ra.sl[200]=413; /* line # 413 */
    if (!Rv0) P_lst_free(F_p);
  }
  PAS__curr_cntx=Ra.v[97];
}


/* Procedure/Function : " lst_newline "  */
void P_lst_newline(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+283;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=422; /* line # 422 */
  Rv0=V_lst_current;
  Ra.sl[6]=423; /* line # 423 */
  if (!(64&((UB *)Rv0)[72])) {
    Ra.sl[6]=424; /* line # 424 */
    if (((SL *)Rv0)[17]>=10) {
      Ra.sl[6]=426; /* line # 426 */
      ((SL *)Rv0)[12]=((SL *)Rv0)[12]+1;
      Ra.sl[6]=427; /* line # 427 */
      if (((SL *)Rv0)[12]>=((SL *)Rv0)[17]) {
        Ra.sl[6]=429; /* line # 429 */
        ((SL *)Rv0)[12]=0;
        Ra.sl[6]=430; /* line # 430 */
        ((SL *)Rv0)[13]=((SL *)Rv0)[13]+1;
        Ra.sl[6]=431; /* line # 431 */
        PAS__PAGE(((V *)Rv0)[10]);
        Ra.sl[6]=432; /* line # 432 */
        if (((V *)Rv0)[2]!=NULL) {
          Ra.sl[6]=434; /* line # 434 */
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
          Ra.sl[6]=435; /* line # 435 */
          if (((SL *)Rv0)[16]<110) {
            ((SL *)Rv0)[12]=1;
            PAS__SELECT_OUT(((V *)Rv0)[10]);
            PAS__WRITE_EOLN();
          }
          else {
            Ra.sl[6]=436; /* line # 436 */
            PAS__SELECT_OUT(((V *)Rv0)[10]);
            PAS__WRITE_STR(Rd.s+173,-1,-1,32);
          }
          Ra.sl[6]=437; /* line # 437 */
          PAS__DATE_STR(V_lst_date.s);
          PAS__TIME_STR(V_lst_time.s);
          Ra.sl[6]=438; /* line # 438 */
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
          PAS__WRITE_FCHAR(32,4,-1,1,32);
          PAS__WRITE_STR(Rd.s+296,-1,-1,32);
          PAS__WRITE_INT(((SL *)Rv0)[13],3,0);
          PAS__WRITE_EOLN();
        }
        Ra.sl[6]=440; /* line # 440 */
        if (((V *)Rv0)[4]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
        }
        Ra.sl[6]=441; /* line # 441 */
        PAS__SELECT_OUT(((V *)Rv0)[10]);
        PAS__WRITE_EOLN();
        Ra.sl[6]=442; /* line # 442 */
        if (((V *)Rv0)[5]!=NULL) {
          Ra.sl[6]=444; /* line # 444 */
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_EOLN();
          Ra.sl[6]=445; /* line # 445 */
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
          PAS__WRITE_EOLN();
          Ra.sl[6]=446; /* line # 446 */
          ((SL *)Rv0)[12]=((SL *)Rv0)[12]+2;
        }
        Ra.sl[6]=448; /* line # 448 */
        PAS__SELECT_OUT(((V *)Rv0)[10]);
        PAS__WRITE_EOLN();
        Ra.sl[6]=449; /* line # 449 */
        ((SL *)Rv0)[12]=((SL *)Rv0)[12]+3;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_eoln "  */
void P_lst_eoln(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+303;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=461; /* line # 461 */
  P_lst_newline();
  Ra.sl[6]=462; /* line # 462 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[6]=464; /* line # 464 */
  if (64&((UB *)Rv0)[72]) {
    Ra.sl[6]=466; /* line # 466 */
    P_vls_nextstring();
    Ra.sl[6]=467; /* line # 467 */
    ((UB *)Rv0)[72]=((UB *)Rv0)[72]&~8;
  }
  else {
    Ra.sl[6]=471; /* line # 471 */
    if (((UB *)Rv1)[1]>0) {
      Ra.sl[6]=473; /* line # 473 */
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      Ra.sl[6]=474; /* line # 474 */
      ((UB *)Rv1)[1]=0;
    }
    Ra.sl[6]=476; /* line # 476 */
    if (8&((UB *)Rv0)[72]) ((UB *)Rv0)[72]=((UB *)Rv0)[72]&~8;
    else {
      Ra.sl[6]=477; /* line # 477 */
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
  Ra.sl[6]=479; /* line # 479 */
  while (((UB *)Rv1)[1]<((SL *)Rv0)[14]){
    Ra.sl[6]=481; /* line # 481 */
    ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
    Ra.sl[6]=482; /* line # 482 */
    ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_breakoutput "  */
void P_lst_breakoutput(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+313;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=493; /* line # 493 */
  Rv0=V_lst_current;
  Ra.sl[6]=495; /* line # 495 */
  ((UB *)Rv0)[72]=((UB *)Rv0)[72]|8;
  Ra.sl[6]=496; /* line # 496 */
  P_lst_eoln();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_page "  */
void P_lst_page(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+330;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=505; /* line # 505 */
  P_lst_eoln();
  Ra.sl[6]=506; /* line # 506 */
  Rv0=V_lst_current;
  Ra.sl[6]=507; /* line # 507 */
  if (((SL *)Rv0)[17]>=10) ((SL *)Rv0)[12]=((SL *)Rv0)[17];
  else {
    Ra.sl[6]=509; /* line # 509 */
    if (!(64&((UB *)Rv0)[72])) PAS__PAGE(((V *)Rv0)[10]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_column "  */
void P_lst_set_column(SL F_col){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+340;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=517; /* line # 517 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[6]=518; /* line # 518 */
  if (F_col>((SL *)Rv0)[15]) {
    Ra.sl[6]=519; /* line # 519 */
    P_lst_eoln();
  }
  else {
    Ra.sl[6]=522; /* line # 522 */
    F_col=F_col-1;
    Ra.sl[6]=523; /* line # 523 */
    if (((UB *)Rv1)[1]>F_col) P_lst_eoln();
    Ra.sl[6]=524; /* line # 524 */
    while (((UB *)Rv1)[1]<F_col){
      Ra.sl[6]=526; /* line # 526 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      Ra.sl[6]=527; /* line # 527 */
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_margin "  */
void P_lst_set_margin(SL F_lm, SL F_rm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+356;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=540; /* line # 540 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[6]=541; /* line # 541 */
  if ((F_lm>=0&&F_rm>F_lm)&&F_rm<=((SL *)Rv0)[16]) {
    Ra.sl[6]=543; /* line # 543 */
    Rv2=((SL *)Rv0)[14];
    Ra.sl[6]=544; /* line # 544 */
    ((SL *)Rv0)[14]=F_lm;
    Ra.sl[6]=545; /* line # 545 */
    ((SL *)Rv0)[15]=F_rm;
    Ra.sl[6]=546; /* line # 546 */
    if (((UB *)Rv1)[1]>Rv2) {
      Ra.sl[6]=547; /* line # 547 */
      P_lst_eoln();
    }
    else {
      Ra.sl[6]=549; /* line # 549 */
      while (((UB *)Rv1)[1]<F_lm){
        Ra.sl[6]=551; /* line # 551 */
        ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
        Ra.sl[6]=552; /* line # 552 */
        ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_skip_line "  */
void P_lst_skip_line(SL F_nli){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+372;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=562; /* line # 562 */
  if (((SL *)V_lst_current)[17]<0) {
    Ra.sl[6]=563; /* line # 563 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+387,-1,-1,32);
    PAS__WRITE_INT(F_nli,0,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=565; /* line # 565 */
    while (F_nli>0){
      Ra.sl[6]=567; /* line # 567 */
      P_lst_eoln();
      F_nli=F_nli-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_char_attr "  */
void P_lst_set_char_attr(V F_sattr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+399;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=580; /* line # 580 */
  Rv0=V_lst_current;
  Ra.sl[6]=581; /* line # 581 */
  if (((SL *)Rv0)[17]<0) {
    Ra.sl[6]=583; /* line # 583 */
    Rv1=1;
    Ra.sl[6]=584; /* line # 584 */
    PAS__CHT_TO_CHT(Ra.s+28,3, Rd.s+420,3);
    Ra.sl[6]=585; /* line # 585 */
    Rv2=1;
    for( Rf0=((UB *)F_sattr)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=586; /* line # 586 */
      switch (((C *)F_sattr)[Rv2+1]) {
        case 43:Ra.sl[6]=587; /* line # 587 */
        Rv1=1;
        break;
        case 45:Ra.sl[6]=589; /* line # 589 */
        Rv1=0;
        break;
        case 66:
        case 71:
        case 98:
        case 103:Ra.sl[6]=592; /* line # 592 */
        if (Rv1) Ra.c[28]=66;
        else {
          Ra.sl[6]=593; /* line # 593 */
          Ra.c[28]=78;
        }
        break;
        case 73:
        case 105:Ra.sl[6]=595; /* line # 595 */
        if (Rv1) Ra.c[29]=73;
        else {
          Ra.sl[6]=596; /* line # 596 */
          Ra.c[29]=78;
        }
        break;
        case 83:
        case 85:
        case 115:
        case 117:Ra.sl[6]=599; /* line # 599 */
        if (Rv1) Ra.c[30]=83;
        else {
          Ra.sl[6]=600; /* line # 600 */
          Ra.c[30]=78;
        }
        break;
        case 78:
        case 110:Ra.sl[6]=602; /* line # 602 */
        Rv1=1;
        PAS__CHT_TO_CHT(Ra.s+28,3, Rd.s+425,3);
        break;
        default:break;
      }
      Rv2++;
    }
    Ra.sl[6]=606; /* line # 606 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+428,-1,-1,32);
    PAS__WRITE_STR(F_sattr,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_test_line "  */
void P_lst_test_line(SL F_iskip, SL F_tstli){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+441;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=615; /* line # 615 */
  Rv0=V_lst_current;
  Ra.sl[6]=616; /* line # 616 */
  if (((SL *)Rv0)[17]>10) {
    Ra.sl[6]=618; /* line # 618 */
    if (F_tstli>((SL *)Rv0)[17]/2) F_tstli=((SL *)Rv0)[17]/2;
    Ra.sl[6]=619; /* line # 619 */
    if (F_iskip>F_tstli) F_iskip=F_tstli;
    Ra.sl[6]=620; /* line # 620 */
    if (((SL *)Rv0)[17]-((SL *)Rv0)[12]>=F_tstli) P_lst_skip_line(F_iskip);
    else {
      Ra.sl[6]=621; /* line # 621 */
      ((SL *)Rv0)[12]=((SL *)Rv0)[17]+1;
    }
  }
  else {
    Ra.sl[6]=624; /* line # 624 */
    if (((SL *)Rv0)[17]<0) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+159,-1,-1,32);
      PAS__WRITE_STR(Rd.s+456,-1,-1,32);
      PAS__WRITE_INT(F_iskip,0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_tstli,0,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_char "  */
void P_lst_put_char(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+468;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=635; /* line # 635 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[6]=637; /* line # 637 */
  if (((UB *)Rv1)[1]>=((SL *)Rv0)[15]) P_lst_eoln();
  Ra.sl[6]=638; /* line # 638 */
  ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
  ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_mchar "  */
void P_lst_put_mchar(C F_ch, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+482;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=647; /* line # 647 */
  Rv0=V_lst_current;
  Ra.sl[6]=649; /* line # 649 */
  if (F_m>0) {
    Ra.sl[6]=650; /* line # 650 */
    while (F_m>0){
      Ra.sl[6]=652; /* line # 652 */
      P_lst_put_char(F_ch);
      Ra.sl[6]=653; /* line # 653 */
      F_m=F_m-1;
    }
  }
  else {
    Ra.sl[6]=656; /* line # 656 */
    Rv1=((V *)Rv0)[1];
    Ra.sl[6]=658; /* line # 658 */
    F_m= -F_m-1;
    Ra.sl[6]=659; /* line # 659 */
    if (F_m>=((UB *)Rv1)[0]) F_m=0;
    Ra.sl[6]=660; /* line # 660 */
    if (((UB *)Rv1)[1]>F_m) P_lst_eoln();
    Ra.sl[6]=661; /* line # 661 */
    while (((UB *)Rv1)[1]<F_m){
      Ra.sl[6]=663; /* line # 663 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      Ra.sl[6]=664; /* line # 664 */
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_string "  */
void P_lst_put_string(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+497;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=680; /* line # 680 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[6]=681; /* line # 681 */
  if (((UB *)F_str)[1]>0) {
    Ra.sl[6]=683; /* line # 683 */
    Rv2=((SL *)Rv0)[15]-((SL *)Rv0)[14];
    Ra.sl[6]=685; /* line # 685 */
    if (Rv2>=((UB *)F_str)[1]) {
      Ra.sl[6]=688; /* line # 688 */
      if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<((UB *)F_str)[1]) {
        Ra.sl[6]=689; /* line # 689 */
        P_lst_eoln();
      }
      Ra.sl[6]=690; /* line # 690 */
      Rv3=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[6]=691; /* line # 691 */
        P_lst_put_char(((C *)F_str)[Rv3+1]);
        Rv3++;
      }
    }
    else {
      Ra.sl[6]=694; /* line # 694 */
      Rv4=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[6]=695; /* line # 695 */
        P_lst_put_char(((C *)F_str)[Rv4+1]);
        Rv4++;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_int "  */
void P_lst_put_int(SL F_int, SL F_size, SL F_base){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=34;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+513;
  Ra.v[7]=Rd.s+14;
  Ra.sl[16]=707; /* line # 707 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[16]=709; /* line # 709 */
  if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<abs(F_size)) P_lst_eoln();
  Ra.sl[16]=710; /* line # 710 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_INT(F_int, F_size, F_base);
  PAS__WRITE_EOLN();
  Ra.sl[16]=711; /* line # 711 */
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[5];
}


/* Procedure/Function : " lst_put_float "  */
void P_lst_put_float(G F_dv, SL F_fs, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+526;
  Ra.v[7]=Rd.s+14;
  Ra.sl[16]=723; /* line # 723 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[16]=725; /* line # 725 */
  if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  Ra.sl[16]=726; /* line # 726 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_es);
  PAS__WRITE_EOLN();
  Ra.sl[16]=727; /* line # 727 */
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[5];
}


/* Procedure/Function : " lst_put_fixed "  */
void P_lst_put_fixed(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+541;
  Ra.v[7]=Rd.s+14;
  Ra.sl[16]=739; /* line # 739 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[16]=741; /* line # 741 */
  if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  Ra.sl[16]=742; /* line # 742 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_dcmin);
  PAS__WRITE_EOLN();
  Ra.sl[16]=743; /* line # 743 */
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[5];
}


/* Procedure/Function : " lst_g_init "  */
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+556;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=761; /* line # 761 */
  V_lst_hde=NULL;
  Ra.sl[6]=762; /* line # 762 */
  V_lst_current=NULL;
  Ra.sl[6]=764; /* line # 764 */
  P_lst_open(&V_lst_current, F_def_lst,F_def_heading,Rd.s+568,Rd.s+568,132,0,0,0,0,
  F_ierr);
  PAS__curr_cntx=Ra.v[0];
}
