/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 368 ) = {
128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   7,   7, 101, 114, 114,  95, 104, 100, 108,  54,  54,  47, 104, 111,
109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99,
112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,
 95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  51,  47, 101, 115,  49,  46,
112,  97, 115,  11,  11,  76,  39, 101, 114, 114, 101, 117, 114,  32,  35,  32,
 16,  16,  32,  97,  32, 101, 116, 101,  32, 100, 101, 116, 101,  99, 116, 101,
101,  46,  17,  17,  32,  84, 104, 101,  32,  82,  84,  76,  32, 109, 115, 103,
 32, 105, 115,  32,  34,   2,   2,  34,  46,   8,   8, 102, 105, 108, 108,  95,
116,  97,  98,  10,  10, 116, 101, 115, 116,  95, 114,  97, 110, 103, 101,   7,
  7,  32,  84,  97,  98, 108, 101,  91,   4,   4,  93,  32,  61,  32,   7,   7,
101, 115, 115,  97, 105,  95,  48,  31,  31,  32,  84, 101, 115, 116,  32,  82,
 97, 110, 103, 101,  32,  69, 114, 114, 111, 114,  32, 102, 111, 114,  32,  49,
 49,  32,  97, 110, 100,  32,  49,  50,  33,  33,  32,  84, 101, 115, 116,  32,
 82,  97, 110, 103, 101,  32,  69, 114, 114, 111, 114,  32, 102, 111, 114,  32,
 45,  52,  44,  32,  52,  32,  97, 110, 100,  32,  53,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 48 ) = {
  1,   0,   0,   0,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 32 );

/* Declaration of external variables. */
extern V PAS__f_error;
extern V PAS__f_output;


/* Function/procedure prototypes. */
void PAS__GET_RTL_MSG(SL F_n, V F_msg);


/* Procedure/Function : " err_hdl "  */
SL ESSAI_0_err_hdl(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 168 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=128;
  PAS__STR_TO_STR(Ra.s,Rd.s);
  Ra.v[17]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+136;
  Ra.v[18]=Rd.s+130;
  Ra.v[19]=Rd.s+139;
  Ra.sl[40]=21; /* line # 21 */
  PAS__SELECT_OUT(PAS__f_error);
  PAS__WRITE_STR(Rd.s+195,-1,-1,32);
  PAS__WRITE_INT(F_ierr,12,0);
  PAS__WRITE_STR(Rd.s+208,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__GET_RTL_MSG(F_ierr, Ra.s);
  if (Ra.ub[1]>0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+226,-1,-1,32);
    PAS__WRITE_STR(Ra.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+245,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ret=1;
  PAS__curr_cntx=Ra.v[17];
  return(Ret);
}


/* Procedure/Function : " fill_tab "  */
void ESSAI_0_fill_tab(V F_tb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+249;
  Ra.v[2]=Rd.s+139;
  Ra.sl[6]=37; /* line # 37 */
  Rv0=(((SL *)F_tb)[0]-((SL *)F_tb)[1])+1;
  Rv1=((SL *)F_tb)[0]+1;
  for( Rf0=(((SL *)F_tb)[1]+1)-(((SL *)F_tb)[0]+1);Rf0>0;Rf0-- ) {
    ((F *)F_tb)[(Rv1-((SL *)F_tb)[0])+2]=(float)(Rv1-((SL *)F_tb)[0])/(float)Rv0;
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " test_range "  */
void ESSAI_0_test_range(V F_tb, SL F_d, SL F_e){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+259;
  Ra.v[2]=Rd.s+139;
  Ra.sl[6]=44; /* line # 44 */
  if (F_d==-100) F_d=((SL *)F_tb)[0];
  if (F_e==-100) F_e=((SL *)F_tb)[1];
  Rv0=F_d;
  for( Rf0=(F_e+1)-F_d;Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+271,-1,-1,32);
    PAS__WRITE_INT(Rv0,-3,0);
    PAS__WRITE_STR(Rd.s+280,-1,-1,32);
    PAS__WRITE_SNGL(((F *)F_tb)[(Rv0-((SL *)F_tb)[0])+2],16,-6,0);
    PAS__WRITE_EOLN();
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " essai_0 "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  V Rv0;
  register SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+286;
  Rs.v[2]=Rd.s+139;
  Rs.sl[6]=54; /* line # 54 */
  ESSAI_0_fill_tab(Ri.s);
  Rv0=PAS__NEW(36);
  ((SL *)Rv0)[0]=-3;
  ((SL *)Rv0)[1]=3;
  Rv1=0;
  for( Rf0=7;Rf0>0;Rf0-- )
  Rv1++;
  ESSAI_0_fill_tab(Rv0);
  PAS__ESTABLISH(ESSAI_0_err_hdl);
  Rs.sl[6]=60; /* line # 60 */
  ESSAI_0_test_range(Ri.s,-100,-100);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+295,-1,-1,32);
  PAS__WRITE_EOLN();
  ESSAI_0_test_range(Ri.s,8,12);
  ESSAI_0_test_range(Rv0,-100,-100);
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+328,-1,-1,32);
  PAS__WRITE_EOLN();
  Rs.sl[6]=65; /* line # 65 */
  ESSAI_0_test_range(Rv0,-4,5);
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
