program BACK_CALL;
{ This example is a small libary to read a text file and print it on the console.

The Library provide  two routine to open the file, read each line, and close  on end of file.
The user must be used the two procedure:

RFDF_CREATE to open the file.
  The user must provide a call back procedure, the user file related address and buffer address (size <= 256 characters).

The file is read when the user call the procedure RDF_READ
For each line read, and also when EOF is reached, the user call-back procedure is called the parameters can be used
to distinguish between the various readden files (not is this example), and get th line, its length and the EOFflag.

On the EOF flag is set, the file is automaticaly closed.

}



{ ************************
  *                      *
  *  Library  Software   *
  *                      *
  ************************
}



type
  cbp_ptr   =   ^procedure( obj: $wild_pointer; len: integer; feof: boolean );

  buffer    =    array[1..256] of char; { Define the buffer type }

  buf_ptr   =                  ^buffer; { Pointer of the buffer }

  { This definition can be unknown of the library user }
  rdf_fil = record
    rec_cbp:                   cbp_ptr; { Pointer to the user call back routine }
    rec_dat:             $wild_pointer; { Pointer to the user object }
    rec_buf:                   buf_ptr; { Buffer for a line of text }
    rec_fil:                     text   { with specific internal field - (cpas files are special pointers) }
(*
    case boolean of
      false:(rec_intp:          ^real); { To allow the initial cleaning of the file }
      true: ( rec_fil:           text)  { with specific internal field - (cpas files are special pointers) }
*)
  end;



var
  rdf: rdf_fil;                 { The private library file descriptor. }

  cbp: cbp_ptr;

  
[global]
function  RDF_CREATE( in_var fnm: string;                       { File to read path name specification }
                      procedure CB_LINE( obj: $wild_pointer;    { Call back Arg1: User related object address }
                                         len:   integer;        { Call back Arg2: Number of character in the buffer }
                                         feof:  boolean         { Call back Arg3: Flag when eof is reached }
                                      );                        { Call back procedure to call when the end-of-file is reached }
                      uobj,                                     { User Object related with the read file }
                      buff:      $wild_pointer                  { Buffer where put the readden line }
                    ): integer;                                 { Open error return code }
var
  ierr:       integer; { Error return code }
  
begin { RDF_CREATE }
%ifdef SUPPL %then
  cbp := cbp_ptr[CB_LINE];
%endif
  with rdf do
  begin
    rec_cbp     :=            cbp_ptr[CB_LINE];                 { Set the call back routine pointer }
    rec_dat     :=                        uobj;                 { Pointer of the user buffer (array of char) to put readden line }
    rec_buf     :=                        buff;                 { Store the buffer address }
(*
    rec_intp    :=                         nil;                 { Clean the file - used with the actual cpas standard library }
 *)
    OPEN( rec_fil, fnm, [read_file,error_file] );               { Try to open the file }
    ierr := iostatus;
%ifdef SUPPL %then
    cbp^( rec_dat, 0, false );
%endif
    if ierr <> 0 then WRITELN( ' Open Error # ', iostatus:0 )
  end;
  RDF_CREATE := ierr
end RDF_CREATE;



[global]
procedure RDF_READ;
var
  st: string;

begin
  with rdf do
  begin
    while not EOF( rec_fil )do          { Until the end of file read each line (or each buffer if very long line }
    begin
      READLN( rec_fil, st );
      if st.length > 0 then
      begin                                                         { We copy the readden line to the user buffer }
        for ii := 1 to st.length do  rec_buf^[ii] := st[ii];
        rec_cbp^( rec_dat, st.length, EOF( rec_fil ) );             { ... and call the user back-back procedure }
      end;
    end;
    if EOF( rec_fil ) then CLOSE( rec_fil )                         { Automatic file closed on EOF }
  end
end RDF_READ;





{ *********************
  *                   *
  *  USER  Software   *
  *                   *
  *********************
}


type
  usr_rec = record
    line:         string(255);          { Our buffer }
    beof:             boolean           { The EOF flag }
  end;

  usr_ptr  = ^usr_rec;                  { Define the user structure pointer }

var
  ptr:         usr_ptr;
  str:          string;
  ie, nb:      integer;


procedure OUR_CB( purc: $wild_pointer; siz: integer; beof: boolean );
var
  p: usr_ptr;
  nl, sz: [static] integer := 0;

begin
  p := purc;
  with p^ do
  begin
    line.length := siz;                 { Take of the end of line }
    nl := nl + 1;
    WRITELN( ' ', nl:4, ' "', line, '"' );
    sz := sz + 1;                       { Add for eoln char (LN) }
    if ODD( sz ) then sz := sz + 1;
    sz := sz + siz                      { Get the size of the file (with the eoln char.) }
  end;
  if beof then
  begin
    WRITELN( "\n The filename length is ", sz:0, ' bytes.' );
    WRITELN( " Pascal Normal End.\n" );
    PASCAL_EXIT( 0 )
  end
end OUR_CB;





begin { BACK_CALL:  User Example }
  WRITE( ' Give a file Name > ' ); READLN( str );
  NEW( ptr );
  with ptr^ do
  begin
    line.length := 0;
    beof := false
  end;
  ie := RDF_CREATE( str, OUR_CB, ptr, ptr^.line.body"address );
  if ie <> 0 then PASCAl_EXIT( 1 );
  RDF_READ;
  WRITELN( ' Stop on error.' );
  PASCAL_EXIT( 1 )
end BACK_CALL.




