{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*         ---  TYPES DEFINITIONS PASCAL FILE MODULE   ---               *
*                                                                       *
*               ---  Version  3.1-B3 -- 30/09/2016 ---                  *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


}

{************     CPAS  version    *************}


{ [inherit( 'lib:cpas_b__src_env' ),

  environment( 'lib:pas_env')]

  module PAS_ENV;
}

{ We load the Source file environment }
%include 'passrc:cpas_b__src_env';


%include 'passrc:cpascal_path_env.pas';         { Include the pascal environment Path definitions }

const
  pi            = 4*ARCTAN( 1 );
  inrd          = pi/180.0;

  { Head page line message }
  pas_page_head = ' P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 ';

  { Default prompt message string }

  pas_prompt    = ' PAS>';
  def_title     = ' The Current Source File is "';
  def_sbttl     = ' The Current Compiled Module is "';

  { System dependant strings }

  { File specification and length }

  terminal       =                       'TT:'; { Terminal file specification }
  pas_deflst     =                          ''; { Default listing to standard output }
  pas_defstd     =          'CPAS_ENVIRONMENT'; { PAS standard definition file name }

  cpas_init_file =    'cpas_std_env.cpas_init';

const

  id_maxsize = 31;                              { Maximum size of an identifier }


  { Basic environment for identifier operation }

  max_lex  =  30;                               { Maximum of lexlevel }
  max_disp =  64;                               { Maximum of ident. display level (must be > max_lex) }
  max_stk  =  32;                               { Maximum stack size in record }
  max_case = 511;                               { Maximum size of a case table: 512 label values }
  max_seta = 256;                               { Maximum size of a set for compiler }
  max_setw =  32;                               { Maximum size for a standard set for compiler }

  { max_seta size in standard set }
  max_seti = (max_seta + max_setw - 1) div max_setw;

  unsmax = 2.0**32-1.0;                         { 32 bits unsigned maximum value }
  intmin = -2.0**31;                            { 32 bits integer minimum value }
  intmax = 2.0**31-1.0;                         { 32 bits integer maximum value }
  max_dblpow  = 307;                            { Maximum for exponent for double precision }
  max_fltpow  = 38;                             { Maximum for exponent for single precision }
  max_single  = 7;                              { Maximum of figure for a single precision number }
  max_dir_par = 8;                              { Maximum size of a direct parameter in bytes }
                                                { It is the largest object that fit with register use }


type

  ubyte = [BYTE] 0..255;                        { Unsigned byte }
  sbyte = [BYTE] -128..127;                     { Signed byte }
  uword = [WORD] 0..65535;                      { Unsigned 16 bits word }
  sword = [WORD] -32768..32767;                 { Signed 16 bits word }


  { *** Long Word Bits Definitions *** }

  longw_bits  = (  bi0,  bi1,  bi2,  bi3,  bi4,  bi5,  bi6,  bi7,
                   bi8,  bi9, bi10, bi11, bi12, bi13, bi14, bi15,
                  bi16, bi17, bi18, bi19, bi20, bi21, bi22, bi23,
                  bi24, bi25, bi26, bi27, bi28, bi29, bi30, bi31);

  wbti = set of longw_bits;


  nam_ptr = ^id_name;                           { Pointer of an identifier name }



         { *** Identifier Definitions *** }

  id_name = record { * Identifier Name Definition }
    l: [BYTE] 0..id_maxsize;                    { Length of the identifier }
    s: packed array[1..id_maxsize] of char      { Identifier string }
  end;




  { Identifier string name definitions  for internal symbol setting }

  int_preffix = packed array[1..4] of char;


  { Identifier Structure Definitions }

  ide_ptr = ^ide_rec;                           { Pointer of identifier definition }
  sta_ptr = ^sta_rec;                           { Pointer of an User_Statement_Bloc Definition }
  typ_ptr = ^typ_rec;                           { Pointer of type definition }
  val_ptr = ^val_rec;                           { Pointer for value record }
  all_ptr = ^all_rec;                           { Pointer for memory allocation record }
  pro_ptr = ^pro_rec;                           { Pointer of a procedure definition }
  gen_ptr = ^gen_rec;                           { Pointer of generic element }
  lgt_ptr = ^lgt_rec;                           { Logical tree pointer definition }
  tab_ptr = ^tab_rec;                           { Pointer to a case table }
  srf_ptr = ^srf_rec;                           { Pointer to a source file record }
  stk_ptr = ^stk_rec;                           { Pointer to a stack information }
  srv_ptr = ^srv_rec;                           { Pointer to a service function }
  svp_ptr = ^svp_rec;                           { Pointer to a type of formal for service functions }




                {**************************}
                { Lexical Type Information }
                {**************************}

         { Standart symbol type definition }

  symbol = (
        identsy,                                { Identifier }
        labelsy,                                { Label identifier or identifier with ":" }
        intconst,                               { Integer constante }
        singleconst,                            { Real simple precision constante }
        doubleconst,                            { Real double precision constante }
        stringconst,                            { String constante }

        {**** Operator Class Symbol Definitions ****}

        unaop,                                  { Unary classe operator }
        powop,                                  { Power class operator }
        mulop,                                  { Multiply class operator }
        addop,                                  { Addition class operator }
        relop,                                  { Relation class operator }
        notop,                                  { Not class operator }
        lgandop,                                { Logical and class operator }
        lgorop,                                 { Logical or class operator }


        {**** Separator Symbol Definitions ****}

        lparen, rparen,                         { ( and ) }
        lbrack, rbrack,                         { [ and ] }
        comma,                                  { , }
        semicolon,                              { ; }
        period,                                 { . }
        twodot,                                 { .. }
        colon,                                  { : }
        becomes,                                { := }

        indirsign,                              { ^ }
        attrsign,                               { " or ' just behind an identifier }
        implic,                                 { => }


        {**** Keywords Symbol Definition ****}

        insy,                                   { In operator }
        nilsy,                                  { Null pointer or list symbol }
        constsy,                                { Constant definition }
        typesy,                                 { Type definition }
        varsy,                                  { Variable definition }
        statementsy,                            { User statement definition }
        labeldclsy,                             { Label declaration }
        gotosy,                                 { Goto statement }
        valuesy,                                { Value formal parameter definition/initial value }
        invarsy,                                { Input formal parameter definition }
        outvarsy,                               { Output formal parameter definition }
        packedsy,                               { Packed keyword }
        pointersy,                              { Pointer definition }


        filesy,                                 { File definition }
        arraysy,                                { Array definition }
        recordsy,                               { Record definition }
        setsy,                                  { Set definition }
        privatesy,                              { Private definition }
        ifsy,                                   { If STATEMENT }
        thensy,                                 { Then keyword }
        elsesy,                                 { Else clause of a if STATEMENT }
        whilesy,                                { While STATEMENT }
        repeatsy,                               { Repeat STATEMENT }
        untilsy,                                { Until for repeat end }
        forsy,                                  { For STATEMENT }
        tosy,                                   { To keyword }
        downtosy,                               { Downto keyword }
        dosy,                                   { Do keyword }
        loopsy,                                 { Loop STATEMENT }
        exitsy,                                 { Exit STATEMENT }
        casesy,                                 { Case STATEMENT }
        withsy,                                 { With STATEMENT }
        newsy,                                  { New allocation directive }
        newhsy,                                 { New heap allocation directive }
        disposesy,                              { Free allocation directive (dispose function) }
        opensy,                                 { General Open File directive }
        resetsy,                                { Open in input  mode directive }
        rewritesy,                              { Open in output mode directive }
        appendsy,                               { Open in append mode directive }
        readsy,                                 { Read directive }
        readlnsy,                               { Readln directive }
        readvsy,                                { Readv directive }
        writesy,                                { Write directive }
        writelnsy,                              { Writeln directive }
        writevsy,                               { Writev directive }
        beginsy,                                { Begin of dynamic block }
        endsy,                                  { End of procedure/begin/if/loop/case/with }
        usesy,                                  { Use of package or size/alignement attribute }
        modulesy,                               { Package Module definition }
        programsy,                              { Main program with subroutine(s) }
        proceduresy,                            { Procedure definition }
        functionsy,                             { Function definition }
        returnsy,                               { Return value setting for function }
        forwardsy,                              { Forward procedure keyword }
        externalsy,                             { External procedure keyword }
        globalsy,                               { Global symbol }
        standardsy,                             { Standard procedure keyword }
        inlinesy,                               { Inline procedure }
        ofsy,                                   { Of keyword }
        othersy,                                { Otherwise keyword }
        staticsy,                               { Static allocation classe }

        {**** Micellious Symbol ****}

        eolnsy,                                 { End Of Line seen - for data mode only }
        eofsy,                                  { End Of Source }

        {**** Pre-processor STATEMENT Symbol ****}

        mdefinesy,                              { Macro %define keyword }
        mundefsy,                               { Macro %undefine keyword }
        mletsy,                                 { Macro %let keyword }
        mifsy,                                  { Macro %if keyword }
        mifdefsy,                               { Macro %ifdef keyword }
        mifundefsy,                             { Macro %ifundef keyword }
        mthensy,                                { Macro %then keyword }
        melsesy,                                { Macro %else keyword }
        mendifsy,                               { Macro %endif keyword }
        midentsy,                               { Macro symbol identifier }

        includesy,                              { %Include a source file }
        chainesy,                               { %Chaine a source file }
        pragmasy,                               { %Pragma to compiler option setting }
        peofsy,                                 { End Of File seen or %endfile symbol }

        nothing                                 { Null definition }
    );


  setsymb = set of symbol;                      { Set used for multiple symbol search }


  { Operator definitions }

  operator = (
        not_op,                                 { Classe: unary = unaop }
        befinc_op,  befdec_op,                  { Pre increment ++, pre decrement -- }
        aftinc_op,  aftdec_op,                  { Post increment ++, post decrement -- }
                                                { Classes: binary }
        pow_op,                                 { Power = powop }
        mul_op,     div_op,     idiv_op,        { Multiply = mulop }
        imod_op,    irem_op,
        add_op,     sub_op,     concat_op,      { Additional = addop }
        lt_op,      le_op,      ge_op,          { Relational = relop }
        gt_op,      ne_op,      eq_op,
        and_op,                                 { Logical-and = lgandop }
        or_op,                                  { Logical-or = lgorop }
        xor_op,                                 { Logical-xor = lgorop }
        in_op,                                  { in operator (included test) }
        aadd_op,    asub_op,                    { +=, -=, *=, /= operator }
        amul_op,    adiv_op,
        ass_op,                                 { Assignation operator }

        no_op                                   { To flag no operator syntax unit }
  );



  { Syntax unit definition for INSYMBOL Setting }

  sym_rec = record
    sy: symbol;
    op: operator
  end;

  { Keyword Structure Definitions }

  keyword_ptr = ^keyword;                       { Keyword pointer definition }



               {**********************}
               { Keyword Information: }
               {**********************}

  keyword = record
    name: id_name;                              { Address of identifier string }
    leftp, rightp: keyword_ptr;                 { Pointers to build binary tree }
    symb: sym_rec
  end;


               {******************************}
               {*  Macro symbol Definitions  *}
	       {******************************}

  macsymb_ptr = ^macsymb;                      { Macro symbol record pointer }

  mval_typs = ( mval_int,                      { Integer/logical macro value }
                mval_str,                      { String macro value }
                mval_und                       { Undefined }
              );

  mval_rec = record                            { * Macro value record * }
    mvl_typ:                        mval_typs; { Prefered type }
    mvl_int:                          integer; { Integer value }
    mvl_str:                          str_ptr  { String value pointer or nil }
  end;

  macsymb = record 
    name:                             id_name; { Address of Macro symbol identifier string }
    nextp, leftp, rightp:         macsymb_ptr; { Next, left and right symbols reference }
    macti:                            boolean; { Flag for active macro symbol }
    value:                           mval_rec  { Macro symbol value }
  end;


    



               {*****************************}
               {****  code P definitions ****}
               {*****************************}

  pcod_codes = (
        pcod_noop,                              { No op P code }

        { Statement code }

        pcod_store,                             { Variable storage operator }
        pcod_range,                             { Check range error statement }
        pcod_istore,                            { Integer/Literal storage }
        pcod_fstore,                            { Single floatting storage }
        pcod_gstore,                            { Double floatting storage }

        { Logical operators }

        pcod_not,
        pcod_and,
        pcod_or,
        pcod_xor,

        { Set Operators }

        pcod_com,
        pcod_band,
        pcod_bxor,
        pcod_bic,
        pcod_bis,
        pcod_bit,


        pcod_setgen,
        pcod_lsetgen,
        pcod_lsetaddel,
        pcod_setlt,
        pcod_setle,
        pcod_setge,
        pcod_setgt,
        pcod_seteq,
        pcod_setne,
        pcod_inset,

        { Relational Operators }

        pcod_eq, 
        pcod_ne,                                { Can be used as boolean xor }

        pcod_ult,
        pcod_ule,
        pcod_uge,
        pcod_ugt,

        pcod_ilt,
        pcod_ile,
        pcod_ige,
        pcod_igt,

        pcod__eq,                               { Block eq }
        pcod__ne,                               { Block ne }

        { Other basic literal operators }

        pcod_inc,
        pcod_dec,
        pcod_ash,                               { Arithmetic shift }
        pcod_lsh,                               { Logical shift }
        pcod_rot,                               { Bits rotation }
        pcod_succ,
        pcod_pred,
        pcod_iodd,

        { Integer operators }

        pcod_ineg,
        pcod_iabs,
        pcod_isqr,

        pcod_iadd,
        pcod_isub,
        pcod_imul,
        pcod_idiv,
        pcod_imod,
        pcod_irem,

        { Single float operators }

        pcod_flt,
        pcod_fle,
        pcod_fge,
        pcod_fgt,
        pcod_feq,
        pcod_fne,

        pcod_fneg,
        pcod_fabs,
        pcod_fsqr,

        pcod_cvif,
        pcod_cvfi,
        pcod_ftrunc,

        pcod_fadd,
        pcod_fsub,
        pcod_fmul,
        pcod_fdiv,

        { Double float operators }

        pcod_glt,
        pcod_gle,
        pcod_gge,
        pcod_ggt,
        pcod_geq,
        pcod_gne,

        pcod_gneg,
        pcod_gabs,
        pcod_gsqr,

        pcod_cvig,
        pcod_cvgi,
        pcod_gtrunc,

        pcod_cvfg,
        pcod_cvgf,

        pcod_gadd,
        pcod_gsub,
        pcod_gmul,
        pcod_gdiv,

        pcod_ipow,

        pcod_fpow,
        pcod_fipw,

        pcod_sqrt,

        pcod_sin,
        pcod_cos,
        pcod_tan,
        pcod_asin,
        pcod_acos,
        pcod_atan,
        pcod_phas,
        pcod_exp,
        pcod_log,
        pcod_sinh,
        pcod_cosh,
        pcod_tanh,
        pcod_asinh,
        pcod_acosh,
        pcod_atanh,

        pcod_gpow,
        pcod_gipw,

        pcod_gsqrt,

        pcod_gsin,
        pcod_gcos,
        pcod_gtan,
        pcod_gasin,
        pcod_gacos,
        pcod_gatan,
        pcod_gphas,
        pcod_gexp,
        pcod_glog,
        pcod_gsinh,
        pcod_gcosh,
        pcod_gtanh,
        pcod_gasinh,
        pcod_gacosh,
        pcod_gatanh,

        { Special operators }

        pcod__genstrl1,                         { String of One Character Generator }
        pcod__genprmtyp                         { Parametrised Type Generator }

    );



  class_types = (
        cla_separ,                              { Separator in parameter list }
        cla_type,                               { Type specifier class }
        cla_tparam,                             { Type parameter class }
        cla_label,                              { Label to name block class }
        cla_konst,                              { Constant class }
        cla_varbl,                              { Variable class }
        cla_field,                              { Record field class }
        cla_fentry,                             { Formal procedure/function (Entry) class }
        cla_genwfent,                           { Proc/funct with cla_fentry arg. }
        cla_generic,                            { Generic class }
        cla_statement,                          { User statement class }
        cla_expr,                               { Expression field class }
        cla_attr,                               { Attribute identifier class }
        cla_null,                               { No expression flag class }
        cla_null1                               { Special for formal push }
    );

  set_class_types = set of class_types;


  typ_forms = (
        form_char,                              { Character }
        form_lit,                               { Literal - the standard lit is boolean }
        form_int,                               { Integer }
        form_single,                            { Single float }
        form_double,                            { Double float }
        form_pointer,                           { Pointer of ... }
        form_fentry,                            { Entry Pointer }
        form_file,                              { File descriptor }
        form_array,                             { Array of ... }
        form_conf,                              { /conformant/ array of ... }
        form_record,                            { Record ... }
        form_set,                               { Set of ... card. <=  integer size }
        form_lset,                              { Set of ... card. > integer size }

        form_nil,                               { nil pointer or list }
        form_wlit,                              { Wild Literal Type }
        form_ennum,                             { Wild Type for Char, Int and Lit }
        form_wfile,                             { Wild File }
        form_wset,                              { Wild Simple Set }
        form_wlset,                             { Wild Large Set }
        form_wwset,                             { Wild Set }
        form_wrecord,                           { Wild Record (for with) }
        form_wild,                              { Wild Type }

        form_range,                             { Dynamic Range for ennumerated }
        form_variant,                           { Variant Part of a Record }

        form_organization,                      { User defined organization }
        form_constructor,                       { Constructor form to build structured object }

        form_private,                           { Private type (undefined) }

        form_generic,                           { Generic type }

        form_eqst,                              { The two types must be exactly same and without type descriptor (fixed size) }
        form_equv,                              { The two arguments and the two formal must have reciprocaly compatible types }
        form_eqse,                              { For set:, first arg. must be element of second arg (as for in operator) }

        form_null,                              { Undefined type form }
        form_string,                            { Internal compiler string }
        form_free                               { Free - used as val_rec compiler flag }
    );



                {********************}
                { Binary Definitions }
                {********************}


  align_byte = record case boolean of
    false:( int: ubyte );
    true: ( bits: set of bi0..bi7 )
  end;

  align_long = record case boolean of
    false:( int: integer );
    true: ( bits: wbti )
  end;


  var_kind = (
        var_tmp,                                { Temporary variable }
        var_decl,                               { Declared variable }
        var_static,                             { Static variable }
        var_global,                             { Global variable }
        var_external,                           { External variable }
        var_standard,                           { Standard variable }
        var_result,                             { Function result of small size (register loc.) }
        var_formal,                             { Formal variable - actual is referenced param. }
        var_vformal,                            { Formal by value }
        var_pformal,                            { Formal procedure/function = entry }
        var_refer,                              { Refer tree node mode or already value refer. }
        var_data,                               { Constant node allocation flag }
        var_imported,                           { Imported object }

        { The next flags are used to get a more selective entry selection
          for GENERIC_SEARCH process. This bits have the same function that
          the bits a_dir, a_sty and a_nil in the oparg_flags bits for the
          standard operators argument descriptors table.
        }
        var_dir,                                { Parent type cannot be used as effective argument }
        var_sty,                                { The effective type must be the same that for thz previous argument }
        var_nil                                 { the nil constante can be accepted as effective argument }
    );


  var_access_types = (
        var_used,                               { Used Variable }
        var_modified,                           { Variable was modified }
        var_intaccess,                          { Used by an internal procedure/function }
        var_initialized,                        { Flag the Initialized variable }
        var_inited,                             { Flag the Initiated Subtype variable }
        var_in,                                 { Input Access Allowed }
        var_out,                                { Output Access Allowed }
        var_register,                           { Value is in Register }
        var_image,                              { Image of Value for Set and Ennum Type }
        var_size,                               { Size to specify }
        var_card,                               { Formal with cardinality flag }
        var_named,                              { Formal with named flag }
        var_copied,                             { Formal as a copy in automatic space }
        var_optional,                           { Optional formal }
        var_hidden,                             { Hidden Object }
        var_iniindir                            { To set initial value as address of cte }
    );

  var_access = set of var_access_types;


  lab_flagsty = (                               { Flag for label }
        lab_decl,                               { Label is declared }
        lab_mark,                               { Label is set as str. mark (loop/for node) }
        lab_refer,                              { Label is referenced }
        lab_inref,                              { Label referenced by inner procedure/function }
        lab_defined,                            { Label is defined }
        lab_hidden                              { Label is now hidden }
    );


  lab_flags = set of lab_flagsty;




            {*******************************}
            { Constant Handling Definitions }
            {*******************************}

  set_value = record
    case boolean of
      false:( siv: integer );
      true: ( ssv: set of 0..max_setw-1 )       { Set basic element value }
  end;

  set_table = array[0..max_seti-1] of set_value;

  val_rec = record { * Constant value Record definition }
    val_next:                  val_ptr;         { Link to next value record }
    val_descr,                                  { Count of descriptor field }
    val_nuse:                  integer;         { Count of value record usage }
    val_acc:                var_access;         { Constant access flags }
    val_psect,                                  { Program section number or -1 }
    val_size,                                   { Size of object in kind adapted unit }
    val_lex:                   integer;         { Owner lex }
    val_typ:                   typ_ptr;         { Related data type pointer }
    val_all:                   all_ptr;         { Allocation pointer }
    case val_kind: typ_forms of
      form_char,
      form_lit,
      form_wlit,
      form_ennum,
      form_int,
      form_range:  (case boolean of
                      false:( val_uval: unsigned );     { Wild unsigned ennum cte. }
                      true: ( val_ival: integer ));     { Wild signed ennum cte. }
      form_single,
      form_double: (  val_rval:   double );     { Float cte. }

      form_string: (   val_str:  str_ptr );     { String constant }

      form_conf,
      form_array,
      form_record: (   val_lst:  val_ptr );     { List of constantes }

      form_set,
      form_wset,
      form_wwset:  (   val_set: set_value );    { Set list value }
      form_lset,
      form_wlset:  (   val_sar: ^set_table);    { List of word set value }

      form_fentry: (   val_pro:   pro_ptr );    { Entry value }

      form_wild:   (   val_tab:   tab_ptr );    { Case table pointer }

      form_nil,
      form_pointer:(   val_lnk:   val_ptr );    { Indirect link to an other constant }
      
      form_free,
      form_organization,
      form_private,
      form_eqse, form_eqst, form_equv, form_null: ( )
  end;


  tab_rec = record case integer of              { * Block of Memory Definition }
    0:( ch: packed array[0..65535] of char );
    1:( ub: packed array[0..65535] of 0..255 );
    2:( sb: packed array[0..65535] of -128..127 );
    3:( uw: packed array[0..32767] of 0..65535 );
    4:( sw: packed array[0..32767] of -32768..32767 );
    5:( lw: array[0..16383] of integer );
    6:( fl: array[0..16383] of single );
    7:( db: array[0..8192]  of double )
  end;


  tpa_kinds = (
      tpa_sub,                                  { Subtype tparam/ or formal link }
      tpa_eval,                                 { To evaluate the value of parameter (cte or formula) }
      tpa_dycte,                                { Dynamic or Cte. tparam actual,
                                                 Used by NEW_CALL evaluation or for dynamic
                                                  range definition as n..m }
      tpa_local                                 { Local value for type relation built time }
    );

  pro_kinds = (
      pro_builtin,                              { Builtin procedure handled as an operator }
      pro_standard,                             { Standard procedure handled by call }
      pro_external,                             { External procedure }
      pro_formal,                               { Formal procedure - given as procedure param. }
      pro_block,                                { Internal dynamic block }
      pro_main,                                 { Main program }
      pro_package,                              { Package/module }
      pro_forward,                              { Forward declared procedure }
      pro_global,                               { User declared global procedure }
      pro_decl,                                 { User declared procedure }
      pro_inline                                { User declared procedure to generate as a macro }
    );

  { Type/Variable Attribute name Definitions }
  attr_kinds = (
      attr_addr,                                { Address of a variable }
      attr_size,                                { Size of a variable in bytes }
      attr_first,                               { First value of an ennumerated type }
      attr_last,                                { Last value of an ennumerated type }
      attr_pred,                                { Previous value of an ennumerated type }
      attr_succ,                                { Next value of an ennumerated type }
      attr_image,                               { Image in character for a literal }
      attr_fobjsize,                            { File object size in bytes }
      attr_arrimin,                             { Array index minimum value }
      attr_arrimax,                             { Array index maximum value }
      attr_digits,                              { Number of valide decimal figures }
      attr_emax,                                { More larger exponante }
      attr_small,                               { Smallest number > 0 }
      attr_epsilon,                             { Smallest number > 1.0 - 1.0 }
      attr_large,                               { Largest float number }
      attr_mantissa,                            { Number of bits in the mantissa }
      attr_card,                                { Cardinality of a set }
      attr_name,                                { Name of the identifier as a cte. string }

      { Other Attribute name Definitions }
      atts_inherit,                             { Inherit attribut }
      atts_environment,                         { Environment attribut }
      atts_global,                              { Global class attribut }
      atts_external,                            { External class attribut }
      atts_static,                              { Static class attribut }
      atts_readonly,                            { Read only attribute }
      atts_optional,                            { Optional formal parameter }
      atts_hidden,                              { Hidden attribut }
      atts_volatil,                             { Volatil attribut }
      atts_byte,                                { Byte allocation }
      atts_word,                                { Word allocation }
      atts_long                                 { Long word allocation }
    );




          {**************************}
          { Logical Tree Definitions }
          {**************************}

  lgt_kinds = (                                 { Kinds of LoGical Tree record }
                lgt_ctlflow,                    { Control flow node }
                lgt_index,                      { Index node }
                lgt_indir,                      { Indir node }
                lgt_offset,                     { Offset node }
                lgt_address,                    { Address node }
                lgt_refer,                      { Formula reference node }
                lgt_codep,                      { Code P operator record }
                lgt_icall,                      { Use an indirect procedure reference (from the first form_fentry arg.) }
                lgt_call,                       { Use a direct entry reference }
                lgt_iproref,                    { Send the ref. of the pointed entry argument }
                lgt_eproref,                    { Send the form_fentry value from a specified generic or formal one }
                lgt_proref,                     { Send the ref. of lgt_proc generic (or formal generic) as formal entry }
                lgt_result,                     { Function return value setting }
                lgt_varbl,                      { Identifier reference }
                lgt_const,                      { Cte. reference (unamed const.) }
                lgt_agregat,                    { Dynamic agregat node }
                lgt_null,                       { Null node }
                lgt_empty,                      { Empty formal parameter or Empty statement node }
                lgt_vartmp,                     { Temporary variable reference }
                lgt_specific,                   { Lgt specific function for a target language }
                lgt_srvcall,                    { Service Function Call node }
                lgt_srvret,                     { Service Function Return node }
                lgt_srvref,                     { Refernce for local and formal in service routine }
                lgt_srcinfo,                    { Source information lgt node }
                lgt_dynall,                     { Dynamic Object Creator, for Preambule ref. }
                lgt_freerec                     { Free lgt record }
              );


  lgt_stms =  ( 
                stm_parallel,                   { Parallel list }
                stm_alternate,                  { Alternate list }
                stm_sequence,                   { Sequenced list }
                stm_case,                       { Case node operator }
                stm_loop,                       { Loop operator }
                stm_for,                        { For loop operator }
                stm_exit,                       { Exit operator }
                stm_return,                     { Return operator }
                stm_if,                         { If operator }
                stm_goto,                       { Local goto statement }
                stm_jump,                       { External goto (jump out of proc.) statement }
                stm_exception,                  { Exception validation operator }
                stm_raise,                      { Raise exception operator }
                stm_revert                      { Revert exception validation oper. }
              );

  lgt_state_flags = (
                lgt_in,                         { This object can be readden }
                lgt_out,                        { This object can be written }
                lgt_add,                        { This object as an address }
                lgt_wrt,                        { This object is written }
                lgt_reg,                        { A register is used }
                lgt_vae,                        { Modifiable variable array elem. ref. }
                lgt_lbl,                        { Set for labeled node }
                lgt_cas,                        { To specify a load variable with a call } 
                lgt_lrf,                        { Linked refered node }
                lgt_nwt,                        { Allocate Temporary ref. }
                lgt_frt,                        { Free Temporary ref. }

                lgt_spc,                        { Call Null Refer Flag for Secondary ref. }
                lgt_cdg_0,                      { Reserved flags for the code generator 0..3 }
                lgt_cdg_1,
                lgt_cdg_2,
                lgt_cdg_3
              );

  lgt_states = set of lgt_state_flags;          { Status Flags set }


  oparg_flagty =  ( { The flags * marked are equivalent ones in var_kind flags var_dir, var_sty and var_nil }
                a_inp,                          { Input argument }
                a_out,                          { Output argument }
                a_dir,                          { Direct type reference: no parent can be specified * }
                a_sty,                          { Same type of the next argument(accept a_nil as exception) * }
                a_nil,                          { Universal nil constant can be accepted (for a_in argument) * }
                a_res,                          { The argument is the operator result }
                a_nof,                          { Not a function operator (as :=) }                   
                a_cif,                          { Use conversion Integer -> Single  }
                a_cfi,                          { Use conversion Single  -> Integer }
                a_cig,                          { Use conversion Integer -> Double  }
                a_cgi,                          { Use conversion Double  -> Integer }
                a_cfg,                          { Use conversion Single  -> Double  }
                a_cgf                           { Use conversion Double  -> Single  }
             );

  oparg_flags = set of oparg_flagty;            { Standard operators flags set definition }



  lgt_rec = record { * Logical tree element def. }
    lgt_nxt,                                    { Link to next logical elem. }
    lgt_parmlst:               lgt_ptr;         { Parameter list }
    lgt_disp:                  integer;         { Displacement value or some other }
    lgt_status:             lgt_states;         { Current status }
    lgt_typ:                   typ_ptr;         { Current type }
    lgt_lide:                  ide_ptr;         { Pointer to the label identifier }

    case lgt_kind:           lgt_kinds  of      { Kind of record }
      lgt_dynall,
      lgt_freerec, lgt_null,
      lgt_index,   lgt_indir,
      lgt_offset,  lgt_refer,
      lgt_address:      { * Nodes for addressing/access to object }
        (
          lgt_typlnk:          typ_ptr          { For secondary type (array element) }
        );

      lgt_vartmp:       { * Temporary reference varbl. }
        (
          lgt_tmplnk:          lgt_ptr;         { Pointer to the last temporary ref. }
          lgt_tmpall:          all_ptr          { Allocation block pointer }
        );

      lgt_agregat:      { * Dynamic Agregat Builder }
        (
          lgt_isz: integer;
        );

      lgt_ctlflow:      { * Statement flow control }
        (
          lgt_stm:             lgt_stms;        { Statement node }
          lgt_lab:             ide_ptr          { Statement related label or identifier }
        );

      lgt_codep:        { * pcode operators }
        (
          lgt_pcode:           pcod_codes       { Specified operator }
        );

      lgt_srvcall:      { * System service function }
        (
          lgt_srvfunc:         srv_ptr;
        );

      lgt_srvret,
      lgt_srvref,
      lgt_empty,
      lgt_srcinfo,
      lgt_specific:     { * Special operators }
        (
          lgt_icode:           integer          { Specified integer operator }
        );

      lgt_icall,                                { Use an indirect procedure reference (from the first form_fentry arg.) }
      lgt_call,                                 { Use a direct entry reference }
      lgt_iproref,                              { Send the ref. of the pointed entry argument }
      lgt_eproref,                              { Send the form_fentry value from a specified generic or formal one }
      lgt_proref,                               { Send the ref. of lgt_proc generic (or formal generic) as formal entry }
      lgt_result:       { * Any procedure/function reference }
        (
          lgt_pro:             pro_ptr          { Procedure Descriptor block pointer }
        );

      lgt_varbl:        { * Variable reference }
        (
          lgt_ide:             ide_ptr;         { Pointer of the identifier }
          lgt_alloc:           all_ptr          { Allocation block pointer }
        );

      lgt_const:        { * Constant reference }
        (
          lgt_nct:             lgt_ptr;         { Link to build a list of constant }
          lgt_cte:             val_ptr          { Pointer to a cte. value }
        )
  end;


  stk_rec = record      { * Temporary Stack allocation record }
    stk_prev:                  stk_ptr;         { Previous stack allocation }
    stk_lgt:                   lgt_ptr;         { Link to the reference }
    stk_top,                                    { Top of stack use  with the current alloc. }
    stk_bott:                  integer          { Bottom of stack before current allocation }
  end;


  all_rec = record      { * Memory Allocation Record definition }
    all_nxt,                                    { Link to next record of the block }
    all_prd:                   all_ptr;         { Link to previous record'ones }
    all_align:              align_byte;         { Alignement specification }
    all_typ:                   typ_ptr;         { Form for granulometry }
    all_acc:                var_access;         { Kind of allowed access }
    all_kind:                 var_kind;         { Kind of variable }
    all_owner:                 pro_ptr;         { Owner procedure pointer }
    all_psect,                                  { Program section number for static or -1 }
    all_size,                                   { Size of this object in byte(s) }
    all_reg,                                    { Used register }
    all_lex,                                    { Lex to use }
    all_lexid,                                  { Lex index to use }
    all_disp:                  integer;         { Displacment to use }
    all_size_exp,                               { Size expression when defined }
    all_first_u,                                { First use pointer }
    all_last_u:                lgt_ptr;         { Last use pointer }
    all_ide:                   ide_ptr;         { Link to associated identifier }
    all_cte:                   val_ptr          { Initial cte value for this object }
  end;



  oparg_rec = record                            { * Define the standard operator argument record }
    oar_typ:           typ_ptr;                 { Formal argument type pointer }
    oar_prp:       oparg_flags                  { Formal argument properties }
  end;

  { Definition of standard operators argument descritors list }
  oparg_tab( narg: integer ) = array[1..narg] of oparg_rec;

  oparg_ptr = ^oparg_tab;                       { * Define the std operator argument list descriptors pointer }
  
  gen_rec1 = record      { * Generic entry record definition }
    gen_link:                  gen_ptr;         { Link to next generic element }
    case gen_blt:              boolean  of      { Flag for standard operator def. }
      false: (
        gen_proc:              pro_ptr;         { Procedure/Fontion=Entry descriptor pointer }
      );
      true: (
        gen_cod:               pcod_codes;      { Associated P code operator }
        gen_atb:               oparg_ptr        { Arguments table }
      )
  end;

  
  gen_rec = record      { * Generic entry record definition }
    gen_link:                  gen_ptr;         { Link to next generic element }
    case gen_blt:              boolean  of      { Flag for standard operator def. }
      false: (
        gen_proc:              pro_ptr;         { Procedure pointer }
      );
      true: (
        gen_result,                             { Result type }
        gen_p1,                                 { First parameter type }
        gen_p2:                typ_ptr;         { Second parameter type or nil }
        gen_pc_cv1,                             { First parameter conversion ptr or nil }
        gen_pc_cv2:            gen_ptr;         { Second parameter conversion ptr or nil }
        gen_pcode:          pcod_codes          { Associated P code operator }
      );
  end;


  { Generic operator definitions }

  ope_ptr = ^ope_rec;                          { Pointer of generic operator element }

  ope_rec = record { * Operator record Definition }
    ope_operator:             operator;         { Associated operator }
    ope_lex:                   integer;         { Lex of this definition }
    ope_nxt,                                    { Link to other generic ope def. (same lex) }
    ope_llnk:                  ope_ptr;         { Link to previous generic def. for the same ope. }
    ope_gfirst,                                 { Generic list head }
    ope_glast:                 gen_ptr          { Generic list end }
  end;


  { Statement Record Definitions }

  sta_rec = record { * Pointer of an User_Statement_Bloc Definition }
    sta_nxt:                   sta_ptr;         { Link to next suser_statement Block }
    sta_dfrs,                                   { Flag for the first use of object }
    sta_rcnt:                  boolean;         { Flag for Context Effective Parameter Repeat on each Call }
    sta_otyp:                  typ_ptr;         { Initial type specification }
    sta_dfcntx:                lgt_ptr;         { Identifier of Default context }
    sta_select,                                 { Generic identifier to use at init action time }
    sta_prstat,                                 { Generic identifier to use at object action time }
    sta_ndstat:                ide_ptr          { Generic identifier to use at end of action }
  end;


  { Identifier Definitions }

  ide_rec = record { * Identifier definition root }
    ide_name:                  nam_ptr;         { Pointer to name record of identifier }
    ide_left, ide_right,                        { Alphabetic left and rigth link pointers }
    ide_nxt:                   ide_ptr;         { Link to next identifier for special use }
    ide_typ:                   typ_ptr;         { Link to associated type }
    ide_lex:                   integer;         { Allocated const. lex }
    ide_owner:                 pro_ptr;         { Reverse owner pointer for allocation }
    case ide_class:        class_types  of      { Class information }
      cla_label:(      { * Label identifier }
        ide_labflg:          lab_flags;         { Set of label flags }
        ide_labnxt,                             { Link to next label of the procedure }
        ide_lablnk,                             { Previous label pointer stack pointer }
        ide_labsyn:            ide_ptr;         { Link between all synonym label }
        ide_lablgt:            lgt_ptr;         { Node associated to this label }
        ide_lablvl,                             { Label local scope level }
        ide_labadr:            integer          { Label address or number }
        );
      cla_statement:(  { * Statement class }
        ide_stafirst,
        ide_stalast:           sta_ptr;         { User_Statement Block List Header }
        );
      cla_fentry:(     { * Formal entry name }
        ide_defentry,                           { Default procedure to use }
        ide_entry:             pro_ptr;         { Pointer to the last used procedure }
        ide_f_all:             all_ptr          { Formal procedure all. pointer }
        );
      cla_genwfent,    { * Proc/funct with cla_formalproc parm. }
      cla_type,        { * Type identifier }
      cla_generic:(    { * Generic/procedure name }
        ide_forlnk:            ide_ptr;         { Forward link string }
        ide_gproc:             pro_ptr;         { Pointer to the current def. procedure }
        ide_gfirst,                             { Generic list head }
        ide_glast:             gen_ptr          { Generic list end }
        );
      cla_konst:(      { * Constant identifier }
        ide_value:             val_ptr;         { Constant value }
        ide_kall:              all_ptr;         { Allocation pointer when large object }
        ide_ckind:            var_kind;         { Allocation kind for constant }
        );
      cla_tparam:(     { * Type parameter identifier }
        ide_toffset:           integer;         { Parameter offset }
        ide_tkind:           tpa_kinds;         { Type parameter kind }
        ide_tlink,                              { Link 1 and 2 to user ... }
        ide_tlink2:            lgt_ptr;         { ... node }
        ide_cteval:            val_ptr          { Attached cte. value or null }
        );
      cla_varbl:(      { * Variable identifier }
        ide_psect:             integer;         { Related program section number }
        ide_vacc:           var_access;         { Allowed access }
        ide_vkind:            var_kind;         { Allocation type for variable }
        ide_inival:            val_ptr;         { Default or init value }
        ide_extnam:            nam_ptr;         { Pointer to the external name of identifier }
        ide_all:               all_ptr          { Allocation memory link }
        );
      cla_field:(                               { Record field identifier }
        ide_offset:            integer          { Offset of this field in the record }
        );
      cla_attr:(                                { Attribute identifier }
        ide_attr:           attr_kinds          { Nature of attribute }
        );
      cla_separ:(                               { Separator in parameter list }
        ide_sym:               sym_rec          { Symbol separator }
        )
  end;


  pro_flagstyp = ( prf_inline,                  { Procedure inline expansion flag }
                   prf_niline,                  { No default inline specification }
                   prf_synchr,                  { Synchronous specification }
                   prf_refer,                   { Procedure with forward/extern reference }
                   prf_stat,                    { Flag for statement }
                   prf_cte,                     { Flag for constant handler }
                   prf_proto,                   { Flag for prototype generation }
                   prf_tocomp,                  { Procedure to compile }
                   prf_callfw,                  { Procedure used before to be defined }
                   prf_define,                  { Procedure defined }
                   prf_intaccess,               { Procedure refered in internal access }

                   prf_cdg_00,                  { Code_generator flags 0 to 4 }
                   prf_cdg_01,
                   prf_cdg_02,
                   prf_cdg_03,
                   prf_cdg_04
                 );

  pro_flagset = set of pro_flagstyp;

  pro_rec = record { * Procedure record definition }
    pro_next,                                   { Link to next procedure to compile }
    pro_link:                  pro_ptr;         { Procedure definition link }
    pro_flags:             pro_flagset;         { Procedure/Function compilation flags }
    pro_stdname:               nam_ptr;         { Standard procedure name handled by call }
    pro_operator:             operator;         { Associated operator or no_op }
    pro_geneide,                                { Generic owner return pointer or nil }
    pro_idetree,                                { Copy of the argument(s) tree root (disp_tree) }
    pro_idelast,                                { Copy of argument list last identifier }
    pro_parmlst:               ide_ptr;         { Link to parameter identifiers }
    pro_lex,                                    { Procedure lex level }
    pro_parmsize,                               { Parameters area size }
    pro_nparm:                 integer;         { Number of parameters (-1 if variable) }
    pro_typ,                                    { Returned type for function }
    pro_prmtyls:               typ_ptr;         { List of the type record defined in parm. }
    case pro_pkind:          pro_kinds  of      { Procedure kind }
      pro_standard, pro_external:(
        );
      pro_formal:(
        pro_f_all:             all_ptr          { Link to allocated memory }
        );
      pro_block, pro_main, pro_package, pro_forward,
      pro_global, pro_decl, pro_inline:(
        pro_owner:             pro_ptr;         { Pointer to owner of procedure }
        pro_srcinfo,                            { First source info pointer }
        pro_lgt,                                { Logical tree pointer }
        pro_lst,                                { Pointer for a last statement (init) }
        pro_init_hde:          lgt_ptr;         { Pointer to first init statement (lgt) }
        pro_opelst:            ope_ptr;         { Generic operator list head }
        pro_labelhde,                           { List of defined label in the procedure }
        pro_reserved,                           { Reserved local identifier list }
        pro_cntxide,                            { Procedure context pointer }
        pro_loclst:            ide_ptr;         { Local identifier list head }
        pro_typlst:            typ_ptr;         { Local type list head }
        pro_fdyn_all,                           { Links to first and last ... }
        pro_ldyn_all,                           { ... local dynamic varbl allocator }
        pro_reglist:           all_ptr;         { Register to allocate pointer }
        pro_labelenv,                           { Global label environment count }
        pro_labelcnt,                           { Label count for this procedure }
        pro_envidx,                             { Lex Environment numeric identifier }
        pro_stk_size,                           { Temporary dynamic stack size }
        pro_dyn_size:          integer;         { Dynamic space size }
        pro_intacc:            boolean          { Internal access flag for local auto varbl. }
        )
  end;


  svp_rec = record
    svp_nxt:                   svp_ptr;         { link to the next type parameter definition }
    svp_typ:                   typ_ptr          { link to the formal type }
  end;


  srv_rec = record { * Service function record definition }
    srv_nxt:                   srv_ptr;         { Link to next definition }
    srv_ide:                   integer;         { Integer routine identifier }
    srv_typ:                   typ_ptr;         { Returned type }
    srv_cod:                   lgt_ptr;         { Body of the Routine function }
    srv_lva,                                    { List of local variable to allocate }
    srv_prm:                   svp_ptr;         { Formal parameter list }
  end;


             { Display kind'levels and kind'types definition }

  { Type definitions }

  typ_rec = record { * Type definition root }
    typ_parent,                                 { Link to parent type identifier }
    typ_attsub,                                 { Attached sub-type }
    typ_nxt:                   typ_ptr;         { Type use list link }
    typ_ide,                                    { Attached identifier pointer or nil }
    typ_parmlst:               ide_ptr;         { Type parameter list head/cte. list for ennum. }
    typ_descr_size,                             { Descriptor size of this type }
    typ_size:                  integer;         { Size to allocate in byte }
    typ_align:              align_byte;         { Alignement value in byte }
    typ_actual,                                 { Actual value for identifier }
    typ_sizesrv,                                { Related service routine to compute the size of this type }
    typ_comp_size:             lgt_ptr;         { Tree to comput the size }
    typ_inival:                val_ptr;         { Initial value or nil }
    typ_fxdrange,                               { Flag for fixed Interval }
    typ_subtype,                                { Flag for sub type }
    typ_hasidsc,                                { Flag for internal descriptor inside object }
    typ_simple:                boolean;         { Flag for simple type register compatible }
    case typ_form: typ_forms of                 { Definition for each type }
      form_free,                                { Never used }
      form_wlit,                                { Any literal type }
      form_ennum,                               { Any enumerable type (with char,int) }
      form_wild,                                { Any type except list }
      form_equv,                                { Type must be same }
      form_eqst,                                { Type fixed and exactly same }
      form_eqse:(                               { Any element type of a set }
        );
      form_char,form_lit,form_int:(             { Enumerable types }
        typ_idelist:           ide_ptr;         { Associated list head }
        typ_idetab:            lgt_ptr;         { Associated cte. table def. }
        case typ_unsigned: boolean of           { Flag for unsigned type }
          false:( typ_min, typ_max: integer );  { Mini..maxi values }
          true: ( typ_umin,typ_umax: unsigned ) { Unsigned min..maxi values }
        );
      form_single,form_double:(                 { Not enumerable scalar type }
        );
      form_organization,                        { User defined organization }
      form_private,                             { Undefined type - private }
      form_file,                                { File type }
      form_pointer,                             { Pointer types }
      form_nil:(                                { nil/wild pointer }
        typ_eltype:            typ_ptr          { Pointer to list element type }
        );
      form_fentry:(
        typ_return:            typ_ptr;         { Function Returned type or nil }
        typ_entry:             pro_ptr;         { Entry definition }
        );
      form_wwset,                               { Wild eset type }
      form_set,                                 { Integer set types }
      form_lset,                                { Large set types }
      form_wset,                                { Any integer set type }
      form_wlset:(                              { Any large set type }
        typ_cardinality:       integer;         { Related set cardinality }
        typ_seltype:           typ_ptr          { Pointer to element type }
        );
      form_conf,                                { Conformant type ... }
      form_array:(                              { Array types }
        typ_idim,                               { Number of dimension - for conformant }
        typ_el_size:           integer;         { Static array element size }
        typ_el_comp_size:      lgt_ptr;         { Dynamic array element size }
        typ_aeltype,                            { Pointer to array element type }
        typ_indtype:           typ_ptr          { Pointer to array index type }
        );
      form_variant,                             { Variant part of a record or }
      form_record: (                            { Record definition }
        typ_firstfield,                         { Pointer to first record field }
        typ_lastfield:         ide_ptr;         { Pointer to last record field }
        typ_recvar:            lgt_ptr          { First case spc. of the record }
        );
      form_range:(                              { Dynamic range definition }
        typ_nvalue,                             { Dynamic number of value }
        typ_low,                                { Dynamic lower bound def. ptr. }
        typ_high:              lgt_ptr          { Dynamic higher bound def. ptr. }
        );
      form_generic:(                            { Generic definition }
        )

  end;


             {*****************************}
             { Array Descriptor definition }
             {*****************************}

  array_desc( n: integer ) = record             { * Define the general array descriptor format }
    descr_obj:                 lgt_ptr;         { The related object pointer or nil }
    descr_typ:                 typ_ptr;         { The object type pointer }
    descr_tab: array[1..2*n] of lgt_ptr         { The table of each index bounds }
  end;

  arrdsc_ptr = ^array_desc;




             {***********************************************}
             { Display kind'levels and kind'types definition }
             {***********************************************}

  disp_kinds = ( dsp_stmflow,                   { Flow control structure display level }
                 dsp_record,                    { Record display level }
                 dsp_drecord,                   { Dynamic record display level }
                 dsp_vrecord,                   { Dynamic record with reference display level }
                 dsp_proc,                      { Procedure display level }
                 dsp_package,                   { Package display level }
                 dsp_null                       { Null display level (use for LEX_SEARCH) }
               );

  disp_rec = record { * Identifier Display definition }
    disp_owner:                pro_ptr;         { Procedure owner of the identifier tree }
    disp_tree:                 ide_ptr;         { Root of the identifier tree }
    disp_lgt:                  lgt_ptr;         { Link to with tree }
    disp_kind:              disp_kinds;         { Kind of display level }
    disp_ide_last:             ide_ptr;         { Pointer to the last created identifier }
    disp_typ_hde:              typ_ptr;         { List of defined type }
    disp_lex,                                   { Lex of display }
    disp_usage,                                 { Usage count of this disp }
    disp_data_size:            integer          { Size of the static/data space }
  end;

  srf_rec = record { * Source File Information Record Definition }
    srf_previous:              srf_ptr;         { Pointer to previous source file info }
    srf_value:                 val_ptr          { Associated String Constant value }
  end;



             {******************************}
             { Environment file list record }
             {******************************}

  env_ptr = ^env_rec;                           { Environment file pointer }

  env_rec = record { * Environment record Definition }
    env_nxt:                   env_ptr;         { Pointer to next }
    env_spc:                   str_ptr;         { Environment file specification }
    env_nam:                   nam_ptr;         { Module name }
    env_idx:                   integer          { Numeric identifier of the environment }
  end;



