function GEN_LIST_AGREGAT_SET( ty: typ_ptr; bcte: boolean ): lgt_ptr;
{ To generate a constant or Expression Set Construction }
const
  mdnam = 'SAGR';

var
  i, iv, jv, max, mmax:   integer;
  j:                      0..max_setw-1;
  tyel, tyse:             typ_ptr;
  lgtc, lgth, lgtl, lgtv: lgt_ptr;
  bconst, bfirst:         boolean;
  sval:                   set_table;

begin
  bfirst := true;
  INSYMBOL;                                     { Gobble up the "[" }
  with sy_sym do
  if sy = rbrack then
  begin                                         { Empty set }
    LGT_NEW( lgtv, typ_std[form_wwset], lgt_const, nil );
    if ty <> nil then lgtv^.lgt_typ := ty;
    VAL_NEW( lgtv^.lgt_cte, lgtv^.lgt_typ );
    with lgtv^.lgt_cte^ do
    begin
      val_size    := 0;
      val_set.ssv := []
    end
  end
  else
  begin                                         { Not empty set }
    lgtv   := nil;
    lgth   := nil;
    lgtl   := nil;
    bconst := false;                            { Assume no constant part until shown otherwise }
    mmax   := -1;                               { Assume empty set }
    for i := 0 to dst_seti - 1 do sval[i].ssv := [];
    tyse   :=  ty;
    tyel   := nil;
    if ty <> nil then
    with ty^ do
    begin
      tyel := typ_seltype;
      max  := typ_cardinality
    end;

    { Collect all SET expressions }
    repeat
      if bfirst then bfirst := false
                else INSYMBOL;                  { Gobble up the separator }
      { Get one expression }
      if tyel = nil then
      begin                                     { We must define a type for the set elements }
        { Get an enummerated expression }
        lgtc := EXPRESSION_TYPE( typ_std[form_ennum] );
        if lgtc^.lgt_kind = lgt_empty then
        begin
          SRC_ERROR( mdnam, 137, e_error );
          LGT_FREE( lgtc )
        end
        else
        begin
          tyel := lgtc^.lgt_typ;                { Define the Type of the Set Element }
          if tyel <> nil then
          begin
            max := -1;
            while (tyel <> nil) and (max < 0) do
              case tyel^.typ_form of
                form_char, form_lit, form_int: max := tyel^.typ_max;
                form_range: tyel := tyel^.typ_parent;
              otherwise
                SRC_ERROR( mdnam, 110, e_error );
              end;
           if max < 0 then SRC_ERROR( mdnam, 110, e_error )
           else
              { We limit the cardinality of any set at the dst_seta Value }
              if max >= dst_seta then max := dst_seta - 1
          end;
          if max < 0 then tyel := nil;

          { Build the SET related type if it is not already defined }
          if (ty = nil) and (tyel <> nil) then
          begin                                 { Used for the dynamic part when it is existing }
            if max < dst_setw then IDE_NEW_TYP( form_set, tyse )
                              else IDE_NEW_TYP( form_lset, tyse );
            with tyse^ do
            begin
              typ_seltype     := tyel;
              typ_cardinality := max + 1;
              if max < dst_setw then
                typ_align     := typ_std[form_wset]^.typ_align
              else
                typ_align     := typ_std[form_wlset]^.typ_align;
              { Get the set size in word set element }
              iv := (typ_cardinality + dst_setw - 1) div dst_setw;
              { Convert size in byte }
              typ_size := (iv*dst_setw + 7) div 8
            end
          end
        end
      end
      else                                      { Get the type element enummerated expression }
        lgtc := EXPRESSION_TYPE( tyel );

      if lgtc^.lgt_kind = lgt_const then
      begin                                     { Constant expression found }
        bconst := true;                         { Set as some constante part exist }
        iv := LGT_GET_ECONST( lgtc, -1 );
        LGT_FREE( lgtc );
        if sy = twodot then
        begin { Manage the range notation : iv is the minimum }
          INSYMBOL;
          lgtc := EXPRESSION_TYPE( tyel );      { Get the maximum value }
          if lgtc^.lgt_kind <> lgt_const then
          begin                                 { We must have a constant value }
            SRC_ERROR( mdnam, 53, e_error );
            jv := iv
          end
          else jv := LGT_GET_ECONST( lgtc, iv );
          LGT_FREE( lgtc )
        end else jv := iv;
        if (iv < 0) or (iv > max) or (jv < iv) or (jv > max) then
        begin
          SRC_ERROR( mdnam, 138, e_error );
          jv := iv - 1                          { To force skip the set setting }
        end;
        for ii := iv to jv do
        begin
          if ii > mmax then mmax := ii;
          i := ii div dst_setw;                 { Get the array table index }
          j := ii rem dst_setw;                 { Get the set element in array }
          if j in sval[i].ssv then SRC_ERROR( mdnam, 139, e_error )
                              else sval[i].ssv := sval[i].ssv + [j]
        end
      end
      else if lgtc^.lgt_kind <> lgt_empty then
      begin                                     { Expression value }
        if bcte then SRC_ERROR( mdnam, 140, e_severe );
        if tyse^.typ_simple then
        begin                                   { Simple set }
          lgtc := LGT_NEW_CODE( pcod_setgen, lgtc );
          lgtc^.lgt_typ := tyse;
          if lgtv <> nil then
          begin
            lgtv^.lgt_nxt := lgtc;
            lgtv := LGT_NEW_CODE( pcod_bis, lgtv );
            lgtv^.lgt_typ := tyse
          end
          else lgtv := lgtc
        end
        else
        begin
          lgtc := LGT_NEW_CALL( tyse, set_entry_proc, lgtc );
          CALL_SETTING( lgtc );
          if lgtv <> nil then
          begin
            lgtv^.lgt_nxt := lgtc;
            lgtv := EXP_GENOP( add_op, lgtv );
            lgtv^.lgt_typ := tyse
          end
          else lgtv := lgtc
        end
      end
      else
      begin                                     { Illegal null value }
        SRC_ERROR( mdnam, 141, e_error );
        LGT_FREE( lgtc )
      end
    until sy <> comma;                          { End of repeat on all SET values }

    if bconst then
    begin                                       { Some constante value(s) was specified }
      if (lgtv = nil) and (tyse <> nil) and (ty = nil) then
      with tyse^ do
      begin                                     { Constant Only : We can reduce the Allocation as Used }
        typ_cardinality := mmax + 1;
        max := mmax;
        if mmax >= dst_setw then
        begin
          typ_simple := false;                  { Confirm a Large Set type }
          typ_form   := form_lset;
          typ_size   := ((typ_cardinality + dst_setw - 1) div dst_setw)*
                        typ_std[form_wset]^.typ_size;
          typ_align.int := typ_std[form_wlset]^.typ_align.int
        end
        else
        begin
          typ_simple := true;                   { Force Small Set type }
          typ_form   := form_set;
          typ_size   := (typ_cardinality + 7) div 8;
          case typ_size of
            1: typ_align.int := 0;
            2: typ_align.int := 1;
          otherwise
            typ_size := 4;
            typ_align.int := typ_std[form_wset]^.typ_align.int
          end
        end;
      end;

      if max < dst_setw then                    { Constant part can be set in form_wset cte }
      begin
        lgtc := LGT_NEW_ECONST( tyse, sval[0].siv )
      end
      else
      begin                                     { Generate a large set constant }
        LGT_NEW( lgtc, tyse, lgt_const, nil );
        VAL_NEW( lgtc^.lgt_cte, tyse );
        with lgtc^.lgt_cte^ do
        begin
          NEW( val_sar );
          val_size := (mmax + dst_setw) div dst_setw;
          for i := 0 to val_size - 1 do
            val_sar^[i].siv := sval[i].siv
        end
      end
    end;

    if mmax >= 0 then                           { A constant value was specified }
      if lgtv = nil then                        { Constant Only }
        lgtv := lgtc
      else
      begin                                     { Constant part + variable part }
        lgtc^.lgt_nxt := lgtv;
        lgtv := EXP_GENOP( add_op, lgtc );
        lgtv^.lgt_typ := tyse
      end
  end;
  GEN_LIST_AGREGAT_SET := lgtv
end GEN_LIST_AGREGAT_SET;


