/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B2/cpas_defs.h"
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 728 ) = {
 12,  12, 108, 103, 116,  95, 109,  97, 107, 101,  95,  98, 105,  99,  59,  59,
 47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  50,  47, 112,
 99, 109, 112,  95, 108, 103, 116,  46, 112,  97, 115,  15,  15, 118,  97, 114,
105,  97, 110, 116,  95, 105, 110,  95, 101, 120, 101,  99,  11,  11, 108, 103,
116,  95, 115, 117,  98, 115,  99,  97, 110,   4,   4,  83,  69,  86,  76,  15,
 15,  32,  99, 116, 108, 102, 108, 111, 119,  32, 115, 116, 109,  32,  61,  32,
 13,   0,   0,   0,  13,   0,  12, 115, 116, 109,  95, 112,  97, 114,  97, 108,
108, 101, 108,   0,  13, 115, 116, 109,  95,  97, 108, 116, 101, 114, 110,  97,
116, 101,  12, 115, 116, 109,  95, 115, 101, 113, 117, 101, 110,  99, 101,   0,
  8, 115, 116, 109,  95,  99,  97, 115, 101,   0,   0,   0,   0,   0,   8, 115,
116, 109,  95, 108, 111, 111, 112,   0,   0,   0,   0,   0,   7, 115, 116, 109,
 95, 102, 111, 114,   0,   0,   0,   0,   0,   0,   8, 115, 116, 109,  95, 101,
120, 105, 116,   0,   0,   0,   0,   0,  10, 115, 116, 109,  95, 114, 101, 116,
117, 114, 110,   0,   0,   0,   6, 115, 116, 109,  95, 105, 102,   0,   0,   0,
  0,   0,   0,   0,   8, 115, 116, 109,  95, 103, 111, 116, 111,   0,   0,   0,
  0,   0,   8, 115, 116, 109,  95, 106, 117, 109, 112,   0,   0,   0,   0,   0,
 13, 115, 116, 109,  95, 101, 120,  99, 101, 112, 116, 105, 111, 110,   9, 115,
116, 109,  95, 114,  97, 105, 115, 101,   0,   0,   0,   0,  10, 115, 116, 109,
 95, 114, 101, 118, 101, 114, 116,   0,   0,   0,  13,  13, 108, 103, 116,  95,
116, 121, 112, 101,  95, 115,  99,  97, 110,  15,  15, 108, 103, 116,  95, 103,
101, 110,  95, 114, 111, 117, 116, 105, 110, 101,  13,  13, 108, 103, 116,  95,
116, 121, 112, 101,  95, 101, 118,  97, 108,  10,  10,  32,  45,  45,  45,  32,
 84,  82,  69,  69,  32,   9,   9,  32,  45,  45,  45,  32,  79,  66,  74,  32,
  4,   4,  69,  86,  65,  76,   4,   4,  32,  82,  69,  83,  16,  16, 108, 103,
116,  95, 116, 121, 112, 101,  95,  99, 111, 109, 112, 117, 116, 101,  12,  12,
108, 103, 116,  95,  99, 118,  97, 108,  95, 117, 110,  97,   4,   4,  67,  85,
 86,  76,  12,  12, 108, 103, 116,  95,  99, 118,  97, 108,  95,  98, 105, 110,
 13,  13, 108, 103, 116,  95, 100, 111,  95, 105, 110, 115, 101, 114, 116,  10,
 10, 108, 103, 116,  95, 105, 110, 115, 101, 114, 116,   8,   8, 108, 103, 116,
 95, 109,  99, 111, 112,  14,  14, 108, 103, 116,  95, 105, 110, 108, 105, 110,
101,  95, 101, 120, 112,  18,  18, 101, 120, 116, 114,  97,  99, 116,  95, 100,
 97, 116,  97,  95, 118,  97, 108, 117, 101,  15,  15, 108, 103, 116,  95, 101,
120, 116, 114,  97,  99, 116,  95,  99, 116, 101,  22,  22, 108, 103, 116,  95,
101, 120, 116, 114,  97,  99, 116,  95, 115, 105, 109, 112, 108, 101,  95,  99,
116, 101,  14,  14, 108, 103, 116,  95, 115,  99,  97, 110,  95,  98, 108, 111,
 99, 107,  13,  13, 108, 103, 116,  95, 115,  99,  97, 110,  95,  99,  97, 115,
101,  13,  13, 108, 103, 116,  95,  99, 104, 101,  99, 107,  95, 117, 110,  97,
 13,  13, 108, 103, 116,  95, 112,  97, 115, 115,  95, 108, 105, 110, 107,  12,
 12, 108, 103, 116,  95, 105, 115,  95,  99, 111, 110, 115, 116,  12,  12, 108,
103, 116,  95,  99, 116, 101,  95, 105, 110,  95,  50,   8,   8, 108, 103, 116,
 95, 115,  99,  97, 110,  13,  13, 108, 103, 116,  95,  97, 108, 108,  95, 102,
112,  97, 114, 109,  15,  15, 108, 103, 116,  95,  97, 108, 108,  95, 100, 121,
110,  97, 109, 105,  99,  17,  17, 108, 103, 116,  95, 112,  97, 115, 115,  49,
 95,  99, 111, 109, 112, 108, 101, 116
};

/* Define the local static section. */
static Blk( Rs, 48 );

/* Declaration of external variables. */
extern V V_comp_typ_ptr;
extern V V_int_typ;
extern UB V_tcas_flag;
extern UB V_cmp_cmpdbg;
extern V V_lst_current;
extern Blk(V_typ_std, 272 );
extern SL V_srv_count;
extern V V_srv_first;
extern V V_srv_last;
extern V V_lgt_inslst;
extern V V_lgt_inshde;
extern SL V_stri_descrsz;
extern SL V_stri_stroffset;
extern UB V_binline;
extern V V_all_fdata;
extern V V_all_ldata;
extern SL V_curr_lex;
extern V V_all_fextern;
extern V V_all_lextern;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_val_new(V *F_p, V F_ty);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
V P_lgt_new_econstr(V F_ty, G F_rv);
SL P_lgt_imaskp2(V F_lgt);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_lgt_scan(V F_head);
void P_lgt_write(SL F_icol, SL F_is, V F_p1);
V PAS_LGT_lgt_type_scan(V F_lgp, UB F_sb);


/* Procedure/Function : " lgt_make_bic "  */
SL PAS_LGT_lgt_make_bic(SL F_i1, SL F_i2){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=86; /* line # 86 */
  Ra.sl[7]=F_i1;
  Ra.sl[8]=F_i2;
  Ra.sl[6]=87; /* line # 87 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=88; /* line # 88 */
  Ret=Ra.sl[7];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " variant_in_exec "  */
V PAS_LGT_PRC_00000000(V F_lgtw, UB F_dyn){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+75;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=110; /* line # 110 */
  Rv0=F_lgtw;
  Ra.sl[6]=111; /* line # 111 */
  if (((V *)Rv0)[1]==NULL&&((UB *)Rv0)[40]==16) {
    Ra.sl[6]=113; /* line # 113 */
    V_comp_typ_ptr=((V *)Rv0)[3];
    Ra.sl[6]=114; /* line # 114 */
    if (((V *)Rv0)[3]!=NULL) {
      Ra.sl[6]=115; /* line # 115 */
      Rv1=((V *)Rv0)[3];
      Ra.sl[6]=116; /* line # 116 */
      if (((SL *)Rv1)[11]>0) Rv2=P_lgt_new_econst(V_int_typ,((SL *)Rv1)[11]);
      else {
        Ra.sl[6]=117; /* line # 117 */
        Rv2=PAS_LGT_lgt_type_scan(((V *)Rv1)[9],1);
      }
    }
    else {
      Ra.sl[6]=118; /* line # 118 */
      Rv2=P_lgt_new_econst(V_int_typ,0);
    }
  }
  else {
    Ra.sl[6]=122; /* line # 122 */
    Rv2=PAS_LGT_lgt_type_scan(F_lgtw,1);
    Ra.sl[6]=123; /* line # 123 */
    V_comp_typ_ptr=((V *)Rv2)[3];
  }
  Ra.sl[6]=126; /* line # 126 */
  if (F_dyn&&Rs.ub[0]) {
    Ra.sl[6]=127; /* line # 127 */
    Rv3=Rv2;
    Ra.sl[6]=128; /* line # 128 */
    if (((UB *)Rv3)[40]==22&&((SL *)Rv3)[11]==0) {
      Ra.sl[6]=129; /* line # 129 */
      ((UB *)Rv3)[40]=16;
      ((V *)Rv3)[3]=NULL;
    }
    else {
      Ra.sl[6]=132; /* line # 132 */
      P_lgt_new(&Rv4, V_int_typ,22,NULL);
      Ra.sl[6]=133; /* line # 133 */
      ((V *)Rv4)[0]=Rv2;
      Ra.sl[6]=134; /* line # 134 */
      P_lgt_new(&Rv2, V_int_typ,6, Rv4);
      Ra.sl[6]=135; /* line # 135 */
      ((UB *)Rv2)[41]=3;
    }
  }
  Ra.sl[6]=138; /* line # 138 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_subscan "  */
V PAS_LGT_PRC_00000001(V F_lgp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  UB Rv12;
  SL Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+92;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=165; /* line # 165 */
  Rv0=NULL;
  Rv1=0;
  Ra.sl[6]=166; /* line # 166 */
  if (F_lgp!=NULL) {
    Ra.sl[6]=167; /* line # 167 */
    Rv2=F_lgp;
    Ra.sl[6]=168; /* line # 168 */
    switch (((UB *)Rv2)[40]) {
      case 16:Ra.sl[6]=170; /* line # 170 */
      if (((V *)Rv2)[1]!=NULL) Rv0=PAS_LGT_PRC_00000001(((V *)Rv2)[1]);
      else {
        Ra.sl[6]=171; /* line # 171 */
        Rv0=F_lgp;
      }
      break;
      case 13:Ra.sl[6]=174; /* line # 174 */
      Rv3=((V *)Rv2)[6];
      Ra.sl[6]=175; /* line # 175 */
      if (((UB *)Rv3)[56]==2) {
        Ra.sl[6]=176; /* line # 176 */
        if (Rs.ub[0]) {
          Ra.sl[6]=178; /* line # 178 */
          P_lgt_new(&Rv0, V_int_typ,22,NULL);
          Ra.sl[6]=179; /* line # 179 */
          Rv1=-1;
          Ra.sl[6]=180; /* line # 180 */
          Rv4=Rs.v[1];
          Ra.sl[6]=181; /* line # 181 */
          while (Rv4!=NULL&&Rv4!=((V *)Rv2)[6]){
            Ra.sl[6]=182; /* line # 182 */
            Rv4=((V *)Rv4)[3];
            Rv1=Rv1-1;
          }
          Ra.sl[6]=183; /* line # 183 */
          if (Rv4!=NULL) ((SL *)Rv0)[11]=Rv1;
          else {
            Ra.sl[6]=184; /* line # 184 */
            ((SL *)Rv0)[11]=0;
          }
        }
        else {
          Ra.sl[6]=187; /* line # 187 */
          if (Rs.v[2]!=NULL) {
            Ra.sl[6]=189; /* line # 189 */
            P_lgt_copy_tree(Rs.v[2],&Rv0);
            Ra.sl[6]=190; /* line # 190 */
            if ((((UB *)Rv0)[40]==13||((UB *)Rv0)[40]==2)||((UB *)Rv0)[40]==3) {
              Ra.sl[6]=197; /* line # 197 */
              ((V *)Rv0)[3]=((V *)Rv2)[3];
            }
            else {
              Ra.sl[6]=199; /* line # 199 */
              P_lgt_new(&Rv0,((V *)Rv2)[3],3, Rv0);
            }
            Ra.sl[6]=200; /* line # 200 */
            Rv5=Rv0;
            Ra.sl[6]=202; /* line # 202 */
            ((SL *)Rv5)[4]=((SL *)Rv5)[4]+((SL *)Rv3)[15];
          }
          else {
            Ra.sl[6]=207; /* line # 207 */
            switch (((UB *)Rv3)[64]) {
              case 0:Ra.sl[6]=209; /* line # 209 */
              if (((V *)Rv3)[11]!=NULL) Rv1=((SL *)((V *)Rv3)[11])[13];
              else {
                Ra.sl[6]=210; /* line # 210 */
                Rv0=F_lgp;
              }
              break;
              case 1:Ra.sl[6]=212; /* line # 212 */
              Rv0=PAS_LGT_PRC_00000001(((V *)Rv3)[10]);
              break;
              case 2:Ra.sl[6]=215; /* line # 215 */
              if (((UB *)((V *)Rv3)[10])[40]==14) {
                Ra.sl[6]=216; /* line # 216 */
                Rv1=((SL *)((V *)((V *)Rv3)[10])[7])[13];
              }
              else {
                Ra.sl[6]=219; /* line # 219 */
                Rv0=P_lgt_link(((V *)Rv3)[10]);
                Ra.sl[6]=220; /* line # 220 */
                ((V *)Rv0)[3]=((V *)Rv3)[4];
              }
              break;
              default:break;
            }
          }
        }
      }
      else {
        Ra.sl[6]=225; /* line # 225 */
        if (((UB *)((V *)Rv2)[3])[92]<=2||((UB *)((V *)Rv2)[3])[92]==22) {
          Ra.sl[6]=226; /* line # 226 */
          P_lgt_new_copy(F_lgp, &Rv0);
        }
      }
      break;
      case 14:Ra.sl[6]=229; /* line # 229 */
      Rv6=((V *)Rv2)[7];
      Ra.sl[6]=230; /* line # 230 */
      if (((UB *)Rv6)[48]<=2) Rv1=((SL *)Rv6)[13];
      else {
        Ra.sl[6]=232; /* line # 232 */
        P_src_error(Rd.s+107,111,3);
      }
      break;
      case 20:Ra.sl[6]=236; /* line # 236 */
      Rv7=((V *)Rv2)[1];
      Ra.sl[6]=237; /* line # 237 */
      Rv8=NULL;
      Ra.sl[6]=238; /* line # 238 */
      while (Rv7!=NULL){
        Ra.sl[6]=240; /* line # 240 */
        Rv0=PAS_LGT_PRC_00000001(Rv7);
        Ra.sl[6]=241; /* line # 241 */
        if (Rv8==NULL) Rv8=Rv0;
        else {
          Ra.sl[6]=242; /* line # 242 */
          ((V *)Rv9)[0]=Rv0;
        }
        Ra.sl[6]=243; /* line # 243 */
        Rv9=Rv0;
        Ra.sl[6]=244; /* line # 244 */
        Rv7=((V *)Rv7)[0];
      }
      Ra.sl[6]=246; /* line # 246 */
      P_lgt_new_copy(F_lgp, &Rv0);
      Ra.sl[6]=247; /* line # 247 */
      ((V *)Rv0)[1]=Rv8;
      break;
      case 6:Ra.sl[6]=251; /* line # 251 */
      if (((V *)Rv2)[1]!=NULL) {
        Ra.sl[6]=253; /* line # 253 */
        Rv8=PAS_LGT_PRC_00000001(((V *)Rv2)[1]);
        Ra.sl[6]=254; /* line # 254 */
        Rv9=NULL;
        Rv10=NULL;
        Ra.sl[6]=255; /* line # 255 */
        Rv11=((V *)Rv2)[1];
        Ra.sl[6]=256; /* line # 256 */
        if (((V *)Rv11)[0]!=NULL) {
          Ra.sl[6]=258; /* line # 258 */
          Rv9=PAS_LGT_PRC_00000001(((V *)Rv11)[0]);
          Ra.sl[6]=259; /* line # 259 */
          if (((V *)((V *)Rv11)[0])[0]!=NULL) Rv10=PAS_LGT_PRC_00000001(((V *)((
          V *)Rv11)[0])[0]);
        }
        Ra.sl[6]=262; /* line # 262 */
        Rv12=1;
        Ra.sl[6]=263; /* line # 263 */
        if (((UB *)Rv8)[40]!=14) Rv12=0;
        else {
          Ra.sl[6]=265; /* line # 265 */
          if (Rv9!=NULL) {
            Ra.sl[6]=266; /* line # 266 */
            if (((UB *)Rv9)[40]!=14) Rv12=0;
            else {
              Ra.sl[6]=268; /* line # 268 */
              if (Rv10!=NULL) {
                Ra.sl[6]=269; /* line # 269 */
                if (((UB *)Rv10)[40]!=14) Rv12=0;
              }
            }
          }
        }
        Ra.sl[6]=271; /* line # 271 */
        if (Rv12) {
          Ra.sl[6]=273; /* line # 273 */
          Rv13=((SL *)((V *)Rv8)[7])[13];
          P_lgt_free(&Rv8);
          Ra.sl[6]=274; /* line # 274 */
          if (Rv9!=NULL) {
            Ra.sl[6]=276; /* line # 276 */
            Rv14=((SL *)((V *)Rv9)[7])[13];
            P_lgt_free(&Rv9);
            Ra.sl[6]=277; /* line # 277 */
            if (Rv10!=NULL) {
              Ra.sl[6]=279; /* line # 279 */
              Rv15=((SL *)((V *)Rv10)[7])[13];
              P_lgt_free(&Rv10);
            }
          }
          Ra.sl[6]=283; /* line # 283 */
          switch (((UB *)Rv2)[41]) {
            case 0:Ra.sl[6]=284; /* line # 284 */
            Rv1=Rv13;
            break;
            case 46:Ra.sl[6]=285; /* line # 285 */
            Rv1= -Rv13;
            break;
            case 38:
            case 43:Ra.sl[6]=288; /* line # 288 */
            Rv1=Rv13+1;
            break;
            case 39:
            case 44:Ra.sl[6]=290; /* line # 290 */
            Rv1=Rv13-1;
            break;
            case 6:Ra.sl[6]=292; /* line # 292 */
            Rv1=1-Rv13;
            break;
            case 45:Ra.sl[6]=293; /* line # 293 */
            Rv1=(SL)(Rv13&1);
            break;
            case 47:Ra.sl[6]=294; /* line # 294 */
            Rv1=abs(Rv13);
            break;
            case 48:Ra.sl[6]=295; /* line # 295 */
            Rv1=Rv13*Rv13;
            break;
            case 49:Ra.sl[6]=297; /* line # 297 */
            Rv1=Rv13+Rv14;
            break;
            case 50:Ra.sl[6]=298; /* line # 298 */
            Rv1=Rv13-Rv14;
            break;
            case 51:Ra.sl[6]=299; /* line # 299 */
            Rv1=Rv13*Rv14;
            break;
            case 52:Ra.sl[6]=300; /* line # 300 */
            if (Rv14!=0) Rv1=Rv13/Rv14;
            else {
              Ra.sl[6]=301; /* line # 301 */
              Rv1=2147483647;
            }
            break;
            case 53:Ra.sl[6]=303; /* line # 303 */
            if (Rv14!=0) Rv1=PAS__I_MOD(Rv13,Rv14);
            else {
              Ra.sl[6]=304; /* line # 304 */
              Rv1=0;
            }
            break;
            case 89:Ra.sl[6]=305; /* line # 305 */
            if (Rv13!=0) Rv1=PAS__IIPOWER(Rv13,Rv14);
            else {
              Ra.sl[6]=306; /* line # 306 */
              Rv1=0;
            }
            break;
            case 7:Ra.sl[6]=308; /* line # 308 */
            Rv1=(SL)(Rv13!=0&&Rv14!=0);
            break;
            case 8:Ra.sl[6]=309; /* line # 309 */
            Rv1=(SL)(Rv13!=0||Rv14!=0);
            break;
            case 9:Ra.sl[6]=310; /* line # 310 */
            Rv1=(SL)((Rv13!=0)!=(Rv14!=0));
            break;
            case 13:Ra.sl[6]=311; /* line # 311 */
            Rv1=PAS_LGT_lgt_make_bic(Rv13, Rv14);
            break;
            case 26:
            case 27:
            case 28:
            case 29:
            case 30:
            case 31:
            case 32:
            case 33:
            case 34:
            case 35:Ra.sl[6]=317; /* line # 317 */
            Rv13=Rv13-Rv14;
            Ra.sl[6]=318; /* line # 318 */
            switch (((UB *)Rv2)[41]) {
              case 28:
              case 32:Ra.sl[6]=319; /* line # 319 */
              Rv1=(SL)(Rv13<0);
              break;
              case 29:
              case 33:Ra.sl[6]=320; /* line # 320 */
              Rv1=(SL)(Rv13<=0);
              break;
              case 30:
              case 34:Ra.sl[6]=321; /* line # 321 */
              Rv1=(SL)(Rv13>=0);
              break;
              case 31:
              case 35:Ra.sl[6]=322; /* line # 322 */
              Rv1=(SL)(Rv13>0);
              break;
              case 27:Ra.sl[6]=323; /* line # 323 */
              Rv1=(SL)(Rv13!=0);
              break;
              case 26:Ra.sl[6]=324; /* line # 324 */
              Rv1=(SL)(Rv13==0);
              break;
            }
            break;
            case 2:Ra.sl[6]=330; /* line # 330 */
            Rv1=Rv13;
            Ra.sl[6]=331; /* line # 331 */
            if (Rv1<Rv14||Rv1>Rv15) P_src_error(Rd.s+107,112,3);
            break;
            default:break;
          }
        }
        else {
          Ra.sl[6]=339; /* line # 339 */
          if (Rv9!=NULL) {
            Ra.sl[6]=341; /* line # 341 */
            ((V *)Rv8)[0]=Rv9;
            Ra.sl[6]=342; /* line # 342 */
            if (Rv10!=NULL) ((V *)Rv9)[0]=Rv10;
          }
          Ra.sl[6]=344; /* line # 344 */
          P_lgt_new(&Rv0,((V *)Rv2)[3],6, Rv8);
          Ra.sl[6]=345; /* line # 345 */
          ((UB *)Rv0)[41]=((UB *)Rv2)[41];
        }
      }
      break;
      case 0:Ra.sl[6]=350; /* line # 350 */
      if (((UB *)Rv2)[41]==3) {
        Ra.sl[6]=352; /* line # 352 */
        V_tcas_flag=1;
        Ra.sl[6]=353; /* line # 353 */
        Rv8=((V *)Rv2)[1];
        Ra.sl[6]=354; /* line # 354 */
        Rv13=((SL *)Rv8)[4];
        Ra.sl[6]=355; /* line # 355 */
        Rv14=(((SL *)((V *)Rv8)[7])[6]+Rv13)-1;
        Ra.sl[6]=356; /* line # 356 */
        Rv16=((V *)((V *)Rv8)[7])[7];
        Ra.sl[6]=357; /* line # 357 */
        Rv8=((V *)Rv8)[0];
        Ra.sl[6]=358; /* line # 358 */
        Rv7=((V *)Rv8)[0];
        Ra.sl[6]=359; /* line # 359 */
        Rv9=PAS_LGT_PRC_00000001(Rv7);
        Ra.sl[6]=360; /* line # 360 */
        Rv7=((V *)Rv7)[0];
        Ra.sl[6]=361; /* line # 361 */
        if (((UB *)Rv9)[40]==14) {
          Ra.sl[6]=363; /* line # 363 */
          Rv1=((SL *)((V *)Rv9)[7])[13];
          Ra.sl[6]=364; /* line # 364 */
          P_lgt_free(&Rv9);
          Ra.sl[6]=365; /* line # 365 */
          if (Rv1<Rv13||Rv1>Rv14) Rv7=Rv8;
          else {
            Ra.sl[6]=368; /* line # 368 */
            Rv1=((SL *)Rv16)[(Rv1-Rv13)];
            Ra.sl[6]=369; /* line # 369 */
            if (Rv1<0) Lx[0].v[0]=Rv8;
            else {
              Ra.sl[6]=371; /* line # 371 */
              while (Rv1>0&&Rv7!=NULL){
                Ra.sl[6]=373; /* line # 373 */
                Rv7=((V *)Rv7)[0];
                Ra.sl[6]=374; /* line # 374 */
                Rv1=Rv1-1;
              }
              Ra.sl[6]=376; /* line # 376 */
              if (Rv7==NULL) Rv7=Rv8;
            }
          }
          Ra.sl[6]=379; /* line # 379 */
          Rv0=PAS_LGT_PRC_00000000(Rv7,0);
        }
        else {
          Ra.sl[6]=383; /* line # 383 */
          P_lgt_new_copy(F_lgp, &Rv0);
          Ra.sl[6]=384; /* line # 384 */
          P_lgt_new_copy(((V *)Rv2)[1],((V *)Rv0)+1);
          Ra.sl[6]=385; /* line # 385 */
          Rv8=((V *)Rv0)[1];
          Ra.sl[6]=386; /* line # 386 */
          P_val_copy(((V *)((V *)Rv2)[1])+7,((V *)Rv8)+7,0);
          Ra.sl[6]=387; /* line # 387 */
          Rv7=((V *)((V *)Rv2)[1])[0];
          Ra.sl[6]=388; /* line # 388 */
          ((V *)Rv8)[0]=PAS_LGT_PRC_00000000(Rv7,1);
          Ra.sl[6]=389; /* line # 389 */
          ((V *)((V *)Rv8)[0])[0]=Rv9;
          Ra.sl[6]=390; /* line # 390 */
          Rv7=((V *)((V *)Rv7)[0])[0];
          Ra.sl[6]=391; /* line # 391 */
          while (Rv7!=NULL){
            Ra.sl[6]=393; /* line # 393 */
            ((V *)Rv9)[0]=PAS_LGT_PRC_00000000(Rv7,1);
            Ra.sl[6]=394; /* line # 394 */
            Rv9=((V *)Rv9)[0];
            Rv7=((V *)Rv7)[0];
          }
          Ra.sl[6]=397; /* line # 397 */
          if (Rs.ub[0]) {
            Ra.sl[6]=399; /* line # 399 */
            Lx[0].v[1]=Rv0;
            Ra.sl[6]=400; /* line # 400 */
            P_lgt_new(&Rv0, V_int_typ,22,NULL);
            Ra.sl[6]=401; /* line # 401 */
            ((SL *)Rv0)[11]=0;
          }
        }
      }
      else {
        Ra.sl[6]=407; /* line # 407 */
        if (!(((UB *)Rv2)[41]==8)) {
          Ra.sl[6]=413; /* line # 413 */
          if (V_cmp_cmpdbg) {
            Ra.sl[6]=414; /* line # 414 */
            PAS__SELECT_OUT(((V *)V_lst_current)[10]);
            PAS__WRITE_STR(Rd.s+111,-1,-1,32);
            PAS__WRITE_ENM(((UB *)Rv2)[41],Rd.s+128,0,-1,32);
            PAS__WRITE_EOLN();
          }
          Ra.sl[6]=415; /* line # 415 */
          P_src_error(Rd.s+107,995,3);
        }
      }
      break;
      default:Ra.sl[6]=420; /* line # 420 */
      P_src_error(Rd.s+107,994,3);
      break;
    }
  }
  Ra.sl[6]=422; /* line # 422 */
  if (Rv0==NULL) Rv0=P_lgt_new_econst(V_int_typ, Rv1);
  Ra.sl[6]=423; /* line # 423 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_type_scan "  */
V PAS_LGT_lgt_type_scan(V F_lgp, UB F_sb){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+330;
  Ra.v[4]=Rd.s+14;
  Ra.sl[10]=429; /* line # 429 */
  Ra.v[1]=NULL;
  Ra.sl[10]=430; /* line # 430 */
  Rv0=PAS_LGT_PRC_00000001(F_lgp);
  Ra.sl[10]=431; /* line # 431 */
  if (Ra.v[1]!=NULL) {
    Ra.sl[10]=433; /* line # 433 */
    if (F_sb) {
      Ra.sl[10]=434; /* line # 434 */
      Rv1=Rv0;
      Ra.sl[10]=435; /* line # 435 */
      if (((UB *)Rv1)[40]==22&&((SL *)Rv1)[11]==0) {
        Ra.sl[10]=436; /* line # 436 */
        ((UB *)Rv1)[40]=16;
        ((V *)Rv1)[3]=NULL;
      }
      else {
        Ra.sl[10]=439; /* line # 439 */
        P_lgt_new(Ra.v,V_int_typ,22,NULL);
        Ra.sl[10]=440; /* line # 440 */
        ((V *)Ra.v[0])[0]=Rv0;
        Ra.sl[10]=441; /* line # 441 */
        P_lgt_new(&Rv0, V_int_typ,6, Ra.v[0]);
        Ra.sl[10]=442; /* line # 442 */
        ((UB *)Rv0)[41]=3;
      }
    }
    else {
      Ra.sl[10]=444; /* line # 444 */
      P_lgt_new(&Rv0, V_int_typ,21, Rv0);
    }
    Ra.sl[10]=446; /* line # 446 */
    ((V *)Ra.v[1])[0]=Rv0;
    Ra.sl[10]=447; /* line # 447 */
    P_lgt_new(&Rv0,NULL,0, Ra.v[1]);
    Ra.sl[10]=448; /* line # 448 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[10]=450; /* line # 450 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[2];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " lgt_gen_routine "  */
void P_lgt_gen_routine(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+345;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=464; /* line # 464 */
  Rs.ub[0]=1;
  Ra.sl[6]=465; /* line # 465 */
  Rs.v[2]=NULL;
  Ra.sl[6]=466; /* line # 466 */
  Rv0=F_ty;
  Ra.sl[6]=467; /* line # 467 */
  if (((V *)Rv0)[8]==NULL) {
    Ra.sl[6]=470; /* line # 470 */
    Rv1=NULL;
    Ra.sl[6]=471; /* line # 471 */
    Rs.v[1]=((V *)Rv0)[4];
    Ra.sl[6]=472; /* line # 472 */
    Rv2=Rs.v[1];
    Ra.sl[6]=473; /* line # 473 */
    Rv3=NULL;
    Ra.sl[6]=474; /* line # 474 */
    while (Rv2!=NULL){
      Ra.sl[6]=475; /* line # 475 */
      Rv4=Rv2;
      Ra.sl[6]=478; /* line # 478 */
      Rv5=PAS__NEW(16);
      Ra.sl[6]=479; /* line # 479 */
      Rv6=Rv5;
      Ra.sl[6]=480; /* line # 480 */
      ((V *)Rv6)[0]=NULL;
      ((V *)Rv6)[1]=((V *)Rv4)[4];
      Ra.sl[6]=481; /* line # 481 */
      if (Rv1==NULL) Rv1=Rv5;
      else {
        Ra.sl[6]=482; /* line # 482 */
        ((V *)Rv7)[0]=Rv5;
      }
      Ra.sl[6]=483; /* line # 483 */
      Rv7=Rv5;
      Ra.sl[6]=485; /* line # 485 */
      Rv8=P_lgt_link(((V *)Rv4)[9]);
      Ra.sl[6]=486; /* line # 486 */
      if (Rv3==NULL) Rv3=Rv8;
      else {
        Ra.sl[6]=487; /* line # 487 */
        ((V *)Rv9)[0]=Rv8;
      }
      Ra.sl[6]=488; /* line # 488 */
      Rv9=Rv8;
      Ra.sl[6]=489; /* line # 489 */
      Rv2=((V *)Rv4)[3];
    }
    Ra.sl[6]=492; /* line # 492 */
    Rs.v[3]=PAS__NEW(16);
    Ra.sl[6]=493; /* line # 493 */
    Rv10=Rs.v[3];
    Ra.sl[6]=495; /* line # 495 */
    ((V *)Rv10)[0]=NULL;
    ((V *)Rv10)[1]=V_typ_std.v[2];
    Ra.sl[6]=497; /* line # 497 */
    Rv8=PAS_LGT_lgt_type_scan(((V *)Rv0)[9],0);
    Ra.sl[6]=498; /* line # 498 */
    Rv11=PAS__NEW(48);
    Ra.sl[6]=499; /* line # 499 */
    Rv12=Rv11;
    Ra.sl[6]=501; /* line # 501 */
    ((V *)Rv12)[0]=NULL;
    Ra.sl[6]=502; /* line # 502 */
    ((V *)Rv12)[2]=V_int_typ;
    Ra.sl[6]=503; /* line # 503 */
    V_srv_count=V_srv_count+1;
    Ra.sl[6]=504; /* line # 504 */
    ((SL *)Rv12)[2]= -V_srv_count;
    Ra.sl[6]=505; /* line # 505 */
    ((V *)Rv12)[3]=Rv8;
    Ra.sl[6]=506; /* line # 506 */
    ((V *)Rv12)[4]=Rs.v[3];
    Ra.sl[6]=507; /* line # 507 */
    ((V *)Rv12)[5]=Rv1;
    Ra.sl[6]=510; /* line # 510 */
    if (V_srv_first==NULL) V_srv_first=Rv11;
    else {
      Ra.sl[6]=511; /* line # 511 */
      ((V *)V_srv_last)[0]=Rv11;
    }
    Ra.sl[6]=512; /* line # 512 */
    V_srv_last=Rv11;
    Ra.sl[6]=514; /* line # 514 */
    P_lgt_new(((V *)Rv0)+8,V_int_typ,20, Rv3);
    Ra.sl[6]=515; /* line # 515 */
    ((V *)((V *)Rv0)[8])[6]=Rv11;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_type_eval "  */
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  SL Rv5;
  UB Rv6;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+362;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=535; /* line # 535 */
  if (V_cmp_cmpdbg) {
    Ra.sl[6]=537; /* line # 537 */
    PAS__SELECT_OUT(((V *)V_lst_current)[10]);
    PAS__WRITE_STR(Rd.s+377,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=538; /* line # 538 */
    P_lgt_write(8,0, F_troot);
    Ra.sl[6]=539; /* line # 539 */
    PAS__SELECT_OUT(((V *)V_lst_current)[10]);
    PAS__WRITE_STR(Rd.s+389,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=540; /* line # 540 */
    if (F_prm_actual!=NULL) P_lgt_write(8,0, F_prm_actual);
  }
  Ra.sl[6]=542; /* line # 542 */
  Rs.sl[8]=0;
  Ra.sl[6]=543; /* line # 543 */
  Rs.ub[0]=0;
  Ra.sl[6]=544; /* line # 544 */
  Rs.v[2]=F_prm_actual;
  Ra.sl[6]=547; /* line # 547 */
  if (F_elm_arr&&Rs.v[2]!=NULL) {
    Ra.sl[6]=548; /* line # 548 */
    Rv0=Rs.v[2];
    Ra.sl[6]=549; /* line # 549 */
    if (((V *)Rv0)[3]!=NULL) {
      Ra.sl[6]=550; /* line # 550 */
      Rv1=((V *)Rv0)[3];
      Ra.sl[6]=551; /* line # 551 */
      if (((UB *)Rv1)[92]==8) Rs.sl[8]=((SL *)Rv1)[10];
    }
  }
  Ra.sl[6]=553; /* line # 553 */
  Rv2=PAS_LGT_lgt_type_scan(F_troot,0);
  Ra.sl[6]=555; /* line # 555 */
  if (F_ty!=NULL) {
    Ra.sl[6]=556; /* line # 556 */
    Rv3=F_ty;
    Rv4=Rv2;
    Ra.sl[6]=558; /* line # 558 */
    if (((UB *)Rv4)[40]==14&&((V *)Rv4)[3]==V_int_typ) {
      Ra.sl[6]=560; /* line # 560 */
      Rv5=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=561; /* line # 561 */
      if (((UB *)Rv3)[112]) Rv6=Rv5<((UL *)Rv3)[29]||Rv5>((UL *)Rv3)[30];
      else {
        Ra.sl[6]=562; /* line # 562 */
        Rv6=Rv5<((SL *)Rv3)[29]||Rv5>((SL *)Rv3)[30];
      }
      Ra.sl[6]=563; /* line # 563 */
      if (Rv6) P_src_error(Rd.s+402,112,3);
    }
  }
  Ra.sl[6]=571; /* line # 571 */
  if (V_cmp_cmpdbg) {
    Ra.sl[6]=573; /* line # 573 */
    PAS__SELECT_OUT(((V *)V_lst_current)[10]);
    PAS__WRITE_STR(Rd.s+406,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=574; /* line # 574 */
    P_lgt_write(8,0, Rv2);
  }
  Ra.sl[6]=577; /* line # 577 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_type_compute "  */
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+412;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=595; /* line # 595 */
  if (F_expe==NULL) {
    Ra.sl[6]=596; /* line # 596 */
    Rv0=P_lgt_new_econst(V_int_typ, F_dvl);
  }
  else {
    Ra.sl[6]=599; /* line # 599 */
    Rv0=P_lgt_type_eval(F_expe, F_obj,NULL,0);
    Ra.sl[6]=600; /* line # 600 */
    if (Rv0!=NULL&&F_expr!=NULL) {
      Ra.sl[6]=602; /* line # 602 */
      if (((UB *)Rv0)[40]!=14) {
        Ra.sl[6]=605; /* line # 605 */
        P_lgt_free_tree(&Rv0);
        Ra.sl[6]=607; /* line # 607 */
        Rv1=F_expr;
        Ra.sl[6]=608; /* line # 608 */
        if (((V *)Rv1)[6]!=NULL) {
          Ra.sl[6]=609; /* line # 609 */
          Rv2=((V *)Rv1)[6];
          Ra.sl[6]=610; /* line # 610 */
          if (((SL *)Rv2)[2]<0) ((SL *)Rv2)[2]=abs(((SL *)Rv2)[2]);
        }
        Ra.sl[6]=612; /* line # 612 */
        Rv0=P_lgt_type_eval(F_expr, F_obj,NULL,0);
      }
    }
  }
  Ra.sl[6]=615; /* line # 615 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_cval_una "  */
V PAS_LGT_lgt_cval_una(V F_lop, V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register int Rgi;
  register G Rgg;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+430;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=628; /* line # 628 */
  Rv0=F_pobj;
  Rv1=((V *)Rv0)[7];
  Ra.sl[6]=630; /* line # 630 */
  switch (((UB *)F_lop)[41]) {
    case 6:Ra.sl[6]=631; /* line # 631 */
    ((SL *)Rv1)[13]=(SL)(((SL *)Rv1)[13]<=0);
    break;
    case 45:Ra.sl[6]=633; /* line # 633 */
    ((SL *)Rv1)[13]=(SL)(((SL *)Rv1)[13]&1);
    break;
    case 43:Ra.sl[6]=635; /* line # 635 */
    ((SL *)Rv1)[13]=((SL *)Rv1)[13]+1;
    break;
    case 44:Ra.sl[6]=637; /* line # 637 */
    ((SL *)Rv1)[13]=((SL *)Rv1)[13]-1;
    break;
    case 10:Ra.sl[6]=639; /* line # 639 */
    ((SL *)Rv1)[13]=-1-((SL *)Rv1)[13];
    break;
    case 46:Ra.sl[6]=641; /* line # 641 */
    ((SL *)Rv1)[13]= -((SL *)Rv1)[13];
    break;
    case 61:
    case 77:Ra.sl[6]=644; /* line # 644 */
    ((G *)Rv1)[7]=-((G *)Rv1)[7];
    break;
    case 47:Ra.sl[6]=646; /* line # 646 */
    ((SL *)Rv1)[13]=abs(((SL *)Rv1)[13]);
    break;
    case 62:
    case 78:Ra.sl[6]=648; /* line # 648 */
    ((G *)Rv1)[7]=fabs(((G *)Rv1)[7]);
    break;
    case 48:Ra.sl[6]=650; /* line # 650 */
    ((SL *)Rv1)[13]=PAS__I_SQR(((SL *)Rv1)[13]);
    break;
    case 63:
    case 79:Ra.sl[6]=652; /* line # 652 */
    ((G *)Rv1)[7]=PAS__G_SQR(((G *)Rv1)[7]);
    break;
    case 64:
    case 80:Ra.sl[6]=655; /* line # 655 */
    ((G *)Rv1)[7]=(double)((SL *)Rv1)[13];
    break;
    case 65:
    case 81:Ra.sl[6]=658; /* line # 658 */
    ((SL *)Rv1)[13]=PAS__G_ROUND(((G *)Rv1)[7]);
    break;
    case 66:
    case 82:Ra.sl[6]=661; /* line # 661 */
    ((SL *)Rv1)[13]=(int)(((G *)Rv1)[7]);
    break;
    case 92:
    case 110:Ra.sl[6]=664; /* line # 664 */
    if (((G *)Rv1)[7]<0.000000000000000E-001) P_src_error(Rd.s+446,801,2);
    else {
      Ra.sl[6]=665; /* line # 665 */
      ((G *)Rv1)[7]=sqrt(((G *)Rv1)[7]);
    }
    break;
    case 93:
    case 111:Ra.sl[6]=668; /* line # 668 */
    ((G *)Rv1)[7]=sin(((G *)Rv1)[7]);
    break;
    case 94:
    case 112:Ra.sl[6]=670; /* line # 670 */
    ((G *)Rv1)[7]=cos(((G *)Rv1)[7]);
    break;
    case 95:
    case 113:Ra.sl[6]=672; /* line # 672 */
    ((G *)Rv1)[7]=tan(((G *)Rv1)[7]);
    break;
    case 96:
    case 114:Ra.sl[6]=676; /* line # 676 */
    if (fabs(((G *)Rv1)[7])>1.000000000000000E+000) P_src_error(Rd.s+446,802,2);
    else {
      Ra.sl[6]=677; /* line # 677 */
      ((G *)Rv1)[7]=asin(((G *)Rv1)[7]);
    }
    break;
    case 97:
    case 115:Ra.sl[6]=680; /* line # 680 */
    if (fabs(((G *)Rv1)[7])>1.000000000000000E+000) P_src_error(Rd.s+446,803,2);
    else {
      Ra.sl[6]=681; /* line # 681 */
      ((G *)Rv1)[7]=acos(((G *)Rv1)[7]);
    }
    break;
    case 98:
    case 116:Ra.sl[6]=683; /* line # 683 */
    ((G *)Rv1)[7]=atan(((G *)Rv1)[7]);
    break;
    case 100:
    case 118:Ra.sl[6]=686; /* line # 686 */
    ((G *)Rv1)[7]=exp(((G *)Rv1)[7]);
    break;
    case 101:
    case 119:Ra.sl[6]=689; /* line # 689 */
    if (((G *)Rv1)[7]<=0.000000000000000E-001) P_src_error(Rd.s+446,804,2);
    else {
      Ra.sl[6]=690; /* line # 690 */
      ((G *)Rv1)[7]=log(((G *)Rv1)[7]);
    }
    break;
    case 102:
    case 120:Ra.sl[6]=693; /* line # 693 */
    ((G *)Rv1)[7]=PAS__SHG(((G *)Rv1)[7]);
    break;
    case 103:
    case 121:Ra.sl[6]=695; /* line # 695 */
    ((G *)Rv1)[7]=PAS__CHG(((G *)Rv1)[7]);
    break;
    case 104:
    case 122:Ra.sl[6]=697; /* line # 697 */
    ((G *)Rv1)[7]=PAS__THG(((G *)Rv1)[7]);
    break;
    case 105:
    case 123:Ra.sl[6]=700; /* line # 700 */
    ((G *)Rv1)[7]=PAS__ASHG(((G *)Rv1)[7]);
    break;
    case 106:
    case 124:Ra.sl[6]=702; /* line # 702 */
    if (((G *)Rv1)[7]>1.000000000000000E+000) P_src_error(Rd.s+446,805,2);
    else {
      Ra.sl[6]=703; /* line # 703 */
      ((G *)Rv1)[7]=PAS__ACHG(((G *)Rv1)[7]);
    }
    break;
    case 107:
    case 125:Ra.sl[6]=706; /* line # 706 */
    if (fabs(((G *)Rv1)[7])>1.000000000000000E+000) P_src_error(Rd.s+446,806,2);
    else {
      Ra.sl[6]=707; /* line # 707 */
      ((G *)Rv1)[7]=PAS__ATHG(((G *)Rv1)[7]);
    }
    break;
    default:break;
  }
  Ra.sl[6]=712; /* line # 712 */
  ((V *)Rv0)[3]=((V *)F_lop)[3];
  ((SL *)Rv0)[4]=((SL *)F_lop)[4];
  Ra.sl[6]=713; /* line # 713 */
  ((UW *)Rv0)[10]=((UW *)F_lop)[10];
  Ra.sl[6]=715; /* line # 715 */
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_cval_bin "  */
V PAS_LGT_lgt_cval_bin(V F_lop, V F_ob1, V F_ob2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  G Rv3;
  register V Rv4;
  register int Rgi;
  register int Rgj;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+450;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=726; /* line # 726 */
  Rv0=((V *)F_ob1)[7];
  Rv1=F_ob2;
  Ra.sl[6]=727; /* line # 727 */
  switch (((UB *)F_lop)[41]) {
    case 89:Ra.sl[6]=729; /* line # 729 */
    ((SL *)Rv0)[13]=PAS__IIPOWER(((SL *)Rv0)[13],((SL *)((V *)Rv1)[7])[13]);
    break;
    case 90:
    case 108:Ra.sl[6]=732; /* line # 732 */
    ((G *)Rv0)[7]=pow  (((G *)Rv0)[7],((G *)((V *)Rv1)[7])[7]);
    break;
    case 91:
    case 109:Ra.sl[6]=735; /* line # 735 */
    ((G *)Rv0)[7]=PAS__IGPOWER(((G *)Rv0)[7],((SL *)((V *)Rv1)[7])[13]);
    break;
    case 49:Ra.sl[6]=737; /* line # 737 */
    ((SL *)Rv0)[13]=((SL *)Rv0)[13]+((SL *)((V *)Rv1)[7])[13];
    break;
    case 50:Ra.sl[6]=738; /* line # 738 */
    ((SL *)Rv0)[13]=((SL *)Rv0)[13]-((SL *)((V *)Rv1)[7])[13];
    break;
    case 51:Ra.sl[6]=739; /* line # 739 */
    ((SL *)Rv0)[13]=((SL *)Rv0)[13]*((SL *)((V *)Rv1)[7])[13];
    break;
    case 52:Ra.sl[6]=740; /* line # 740 */
    ((SL *)Rv0)[13]=((SL *)Rv0)[13]/((SL *)((V *)Rv1)[7])[13];
    break;
    case 53:Ra.sl[6]=741; /* line # 741 */
    ((SL *)Rv0)[13]=PAS__I_MOD(((SL *)Rv0)[13],((SL *)((V *)Rv1)[7])[13]);
    break;
    case 67:
    case 85:Ra.sl[6]=744; /* line # 744 */
    ((G *)Rv0)[7]=((G *)Rv0)[7]+((G *)((V *)Rv1)[7])[7];
    break;
    case 68:
    case 86:Ra.sl[6]=746; /* line # 746 */
    ((G *)Rv0)[7]=((G *)Rv0)[7]-((G *)((V *)Rv1)[7])[7];
    break;
    case 69:
    case 87:Ra.sl[6]=748; /* line # 748 */
    ((G *)Rv0)[7]=((G *)Rv0)[7]*((G *)((V *)Rv1)[7])[7];
    break;
    case 70:
    case 88:Ra.sl[6]=750; /* line # 750 */
    ((G *)Rv0)[7]=((G *)Rv0)[7]/((G *)((V *)Rv1)[7])[7];
    break;
    case 7:Ra.sl[6]=752; /* line # 752 */
    ((SL *)Rv0)[13]=(SL)(((SL *)Rv0)[13]>0&&((SL *)((V *)Rv1)[7])[13]>0);
    break;
    case 8:Ra.sl[6]=753; /* line # 753 */
    ((SL *)Rv0)[13]=(SL)(((SL *)Rv0)[13]>0||((SL *)((V *)Rv1)[7])[13]>0);
    break;
    case 9:Ra.sl[6]=754; /* line # 754 */
    ((SL *)Rv0)[13]=(SL)(((SL *)Rv0)[13]>0!=((SL *)((V *)Rv1)[7])[13]>0);
    break;
    case 11:Ra.sl[6]=757; /* line # 757 */
    ((UL *)Rv0)[13]=((UL *)Rv0)[13]&((UL *)((V *)Rv1)[7])[13];
    break;
    case 12:Ra.sl[6]=758; /* line # 758 */
    ((UL *)Rv0)[13]=(((UL *)Rv0)[13]|((UL *)((V *)Rv1)[7])[13])&~(((UL *)Rv0)[13]
    &((UL *)((V *)Rv1)[7])[13]);
    break;
    case 13:Ra.sl[6]=760; /* line # 760 */
    ((UL *)Rv0)[13]=((UL *)Rv0)[13]&~((UL *)((V *)Rv1)[7])[13];
    break;
    case 14:Ra.sl[6]=761; /* line # 761 */
    ((UL *)Rv0)[13]=((UL *)Rv0)[13]|((UL *)((V *)Rv1)[7])[13];
    break;
    case 15:Ra.sl[6]=762; /* line # 762 */
    ((SL *)Rv0)[13]=(SL)((((UL *)Rv0)[13]&((UL *)((V *)Rv1)[7])[13])!=0);
    break;
    case 16:break;
    case 17:break;
    case 18:break;
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:Ra.sl[6]=772; /* line # 772 */
    switch (((UB *)F_lop)[41]) {
      case 19:
      case 20:Ra.sl[6]=774; /* line # 774 */
      Rv2=(SL)PAS__SET_LE(((UL *)Rv0)[13],((UL *)((V *)Rv1)[7])[13]);
      break;
      case 21:
      case 22:Ra.sl[6]=776; /* line # 776 */
      Rv2=(SL)PAS__SET_LE(((UL *)((V *)Rv1)[7])[13],((UL *)Rv0)[13]);
      break;
      case 23:Ra.sl[6]=777; /* line # 777 */
      Rv2=(SL)(((UL *)Rv0)[13]!=((UL *)((V *)Rv1)[7])[13]);
      break;
      case 24:Ra.sl[6]=778; /* line # 778 */
      Rv2=(SL)(((UL *)Rv0)[13]==((UL *)((V *)Rv1)[7])[13]);
      break;
      default:break;
    }
    Ra.sl[6]=781; /* line # 781 */
    ((UB *)Rv0)[48]=1;
    Ra.sl[6]=782; /* line # 782 */
    ((SL *)Rv0)[6]=0;
    Ra.sl[6]=783; /* line # 783 */
    ((SL *)Rv0)[13]=Rv2;
    break;
    case 25:Ra.sl[6]=786; /* line # 786 */
    Rv2=(SL)((1<<((SL *)Rv0)[13]&((UL *)((V *)Rv1)[7])[13])!=0);
    break;
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:Ra.sl[6]=791; /* line # 791 */
    Rv2=((SL *)Rv0)[13]-((SL *)((V *)Rv1)[7])[13];
    Ra.sl[6]=792; /* line # 792 */
    switch (PAS__I_MOD((SL)((UB *)F_lop)[41]-28,6)) {
      case 0:Ra.sl[6]=793; /* line # 793 */
      ((SL *)Rv0)[13]=(SL)(Rv2<0);
      break;
      case 1:Ra.sl[6]=794; /* line # 794 */
      ((SL *)Rv0)[13]=(SL)(Rv2<=0);
      break;
      case 2:Ra.sl[6]=795; /* line # 795 */
      ((SL *)Rv0)[13]=(SL)(Rv2>=0);
      break;
      case 3:Ra.sl[6]=796; /* line # 796 */
      ((SL *)Rv0)[13]=(SL)(Rv2>0);
      break;
      case 4:Ra.sl[6]=797; /* line # 797 */
      ((SL *)Rv0)[13]=(SL)(Rv2!=0);
      break;
      case 5:Ra.sl[6]=798; /* line # 798 */
      ((SL *)Rv0)[13]=(SL)(Rv2==0);
      break;
    }
    break;
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:Ra.sl[6]=805; /* line # 805 */
    Rv3=((G *)Rv0)[7]-((G *)((V *)Rv1)[7])[7];
    Ra.sl[6]=806; /* line # 806 */
    switch (PAS__I_MOD((SL)((UB *)F_lop)[41]-55,6)) {
      case 0:Ra.sl[6]=807; /* line # 807 */
      ((SL *)Rv0)[13]=(SL)(Rv3<0.000000000000000E-001);
      break;
      case 1:Ra.sl[6]=808; /* line # 808 */
      ((SL *)Rv0)[13]=(SL)(Rv3<=0.000000000000000E-001);
      break;
      case 2:Ra.sl[6]=809; /* line # 809 */
      ((SL *)Rv0)[13]=(SL)(Rv3>=0.000000000000000E-001);
      break;
      case 3:Ra.sl[6]=810; /* line # 810 */
      ((SL *)Rv0)[13]=(SL)(Rv3>0.000000000000000E-001);
      break;
      case 4:Ra.sl[6]=811; /* line # 811 */
      ((SL *)Rv0)[13]=(SL)(Rv3!=0.000000000000000E-001);
      break;
      case 5:Ra.sl[6]=812; /* line # 812 */
      ((SL *)Rv0)[13]=(SL)(Rv3==0.000000000000000E-001);
      break;
    }
    break;
    case 36:
    case 37:break;
    case 99:
    case 117:Ra.sl[6]=822; /* line # 822 */
    ((G *)Rv0)[7]=atan2(((G *)Rv0)[7],((G *)((V *)Rv1)[7])[7]);
    break;
    default:break;
  }
  Ra.sl[6]=826; /* line # 826 */
  Rv4=F_ob1;
  Ra.sl[6]=828; /* line # 828 */
  ((V *)Rv4)[3]=((V *)F_lop)[3];
  ((SL *)Rv4)[4]=((SL *)F_lop)[4];
  Ra.sl[6]=829; /* line # 829 */
  ((UW *)Rv4)[10]=((UW *)F_lop)[10];
  Ra.sl[6]=831; /* line # 831 */
  Ret=F_ob1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_do_insert "  */
void PAS_LGT_lgt_do_insert(V F_lgt_head, UB F_bfirst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+464;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=839; /* line # 839 */
  Rv0=F_lgt_head;
  Ra.sl[6]=840; /* line # 840 */
  if (F_bfirst) {
    Ra.sl[6]=842; /* line # 842 */
    ((V *)V_lgt_inslst)[0]=((V *)Rv0)[1];
    Ra.sl[6]=843; /* line # 843 */
    ((V *)Rv0)[1]=V_lgt_inshde;
  }
  else {
    Ra.sl[6]=847; /* line # 847 */
    ((V *)V_lgt_inslst)[0]=((V *)Rv0)[0];
    Ra.sl[6]=848; /* line # 848 */
    ((V *)Rv0)[0]=V_lgt_inshde;
  }
  Ra.sl[6]=850; /* line # 850 */
  V_lgt_inslst=NULL;
  V_lgt_inshde=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_insert "  */
void PAS_LGT_lgt_insert(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+479;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=857; /* line # 857 */
  if (V_lgt_inslst==NULL) {
    Ra.sl[6]=858; /* line # 858 */
    V_lgt_inshde=F_lgt;
  }
  else {
    Ra.sl[6]=860; /* line # 860 */
    ((V *)V_lgt_inslst)[0]=F_lgt;
  }
  Ra.sl[6]=861; /* line # 861 */
  V_lgt_inslst=F_lgt;
  ((V *)F_lgt)[0]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_mcop "  */
V PAS_LGT_PRC_00000002(V F_troot){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  SL Rv16;
  SL Rv17;
  V Rv18;
  V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+491;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=888; /* line # 888 */
  Rv0=NULL;
  Rv1=0;
  Ra.sl[6]=889; /* line # 889 */
  if (F_troot!=NULL) {
    Ra.sl[6]=890; /* line # 890 */
    Rv2=F_troot;
    Ra.sl[6]=891; /* line # 891 */
    switch (((UB *)Rv2)[40]) {
      case 24:break;
      case 17:Ra.sl[6]=895; /* line # 895 */
      P_lgt_new_copy(F_troot, &Rv0);
      break;
      case 16:Ra.sl[6]=899; /* line # 899 */
      P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=900; /* line # 900 */
      ((V *)Rv0)[1]=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
      break;
      case 13:Ra.sl[6]=904; /* line # 904 */
      if (((V *)Rv2)[6]!=NULL) {
        Ra.sl[6]=905; /* line # 905 */
        Rv3=((V *)Rv2)[6];
        Ra.sl[6]=907; /* line # 907 */
        if (((V *)Rv3)[6]==Lx[1].v[0]) {
          Ra.sl[6]=909; /* line # 909 */
          switch (((UB *)Rv3)[66]) {
            case 1:Ra.sl[6]=914; /* line # 914 */
            P_lgt_new_copy(F_troot, &Rv0);
            Ra.sl[6]=915; /* line # 915 */
            Rv4=Rv0;
            Ra.sl[6]=916; /* line # 916 */
            if (((V *)Rv3)[11]==NULL) {
              Ra.sl[6]=918; /* line # 918 */
              P_all_new(((V *)Rv3)+11,((V *)Rv4)[3],NULL,1);
              Ra.sl[6]=919; /* line # 919 */
              ((UW *)((V *)Rv3)[11])[16]=((UW *)Rv3)[32];
              Ra.sl[6]=920; /* line # 920 */
              ((V *)Rv4)[7]=((V *)Rv3)[11];
              Ra.sl[6]=924; /* line # 924 */
              Rv5=((V *)Rv4)[7];
              Ra.sl[6]=927; /* line # 927 */
              if (!(4&((UW *)Rv3)[32])) {
                Ra.sl[6]=928; /* line # 928 */
                ((UW *)Rv5)[16]=((UW *)Rv5)[16]|1;
              }
              Ra.sl[6]=929; /* line # 929 */
              ((V *)Rv5)[10]=Rv0;
              ((V *)Rv5)[11]=Rv0;
            }
            else {
              Ra.sl[6]=934; /* line # 934 */
              ((V *)Rv0)[7]=((V *)Rv3)[11];
              Ra.sl[6]=935; /* line # 935 */
              ((V *)((V *)((V *)Rv3)[11])[11])[1]=Rv0;
              Ra.sl[6]=936; /* line # 936 */
              ((V *)((V *)Rv3)[11])[11]=Rv0;
            }
            break;
            case 7:
            case 8:
            case 10:Ra.sl[6]=942; /* line # 942 */
            Rv6=((V *)Rv3)[11];
            Ra.sl[6]=945; /* line # 945 */
            if (((V *)Rv2)[3]==((V *)((V *)Rv6)[10])[3]&&((SL *)Rv2)[4]==0) {
              Ra.sl[6]=948; /* line # 948 */
              Rv0=((V *)Rv6)[10];
            }
            else {
              Ra.sl[6]=952; /* line # 952 */
              if (((UB *)((V *)Rv6)[10])[40]==13) {
                Ra.sl[6]=954; /* line # 954 */
                Rv7=((V *)Rv6)[10];
                Ra.sl[6]=956; /* line # 956 */
                P_lgt_new_copy(F_troot, &Rv0);
                Ra.sl[6]=957; /* line # 957 */
                ((V *)Rv0)[6]=((V *)Rv7)[6];
                Ra.sl[6]=958; /* line # 958 */
                ((V *)Rv0)[7]=((V *)Rv7)[7];
                Ra.sl[6]=959; /* line # 959 */
                ((SL *)Rv0)[4]=((SL *)Rv0)[4]+((SL *)Rv7)[4];
                Ra.sl[6]=960; /* line # 960 */
                Rv8=((V *)Rv7)[7];
                Ra.sl[6]=962; /* line # 962 */
                if (((V *)Rv8)[10]==NULL) ((V *)Rv8)[10]=Rv0;
                Ra.sl[6]=963; /* line # 963 */
                if (((V *)Rv8)[11]!=NULL) ((V *)((V *)Rv8)[11])[1]=Rv0;
                Ra.sl[6]=964; /* line # 964 */
                ((V *)Rv8)[11]=Rv0;
              }
              else {
                Ra.sl[6]=969; /* line # 969 */
                P_lgt_new_copy(F_troot, &Rv0);
                Ra.sl[6]=970; /* line # 970 */
                ((UB *)Rv0)[40]=3;
                Ra.sl[6]=972; /* line # 972 */
                ((V *)Rv0)[1]=((V *)Rv6)[10];
              }
            }
            Ra.sl[6]=974; /* line # 974 */
            ((V *)Rv6)[11]=Rv0;
            break;
            case 6:Ra.sl[6]=979; /* line # 979 */
            if (((V *)Rv2)[3]==((V *)Lx[1].v[1])[3]&&((SL *)Rv2)[4]==0) {
              Ra.sl[6]=982; /* line # 982 */
              Rv0=Lx[1].v[1];
            }
            else {
              Ra.sl[6]=985; /* line # 985 */
              if (((UB *)Lx[1].v[1])[40]==13) {
                Ra.sl[6]=986; /* line # 986 */
                Rv9=Lx[1].v[1];
                Ra.sl[6]=988; /* line # 988 */
                P_lgt_new_copy(F_troot, &Rv0);
                Ra.sl[6]=989; /* line # 989 */
                ((V *)Rv0)[6]=((V *)Rv9)[6];
                Ra.sl[6]=990; /* line # 990 */
                ((V *)Rv0)[7]=((V *)Rv9)[7];
                Ra.sl[6]=991; /* line # 991 */
                ((SL *)Rv0)[4]=((SL *)Rv0)[4]+((SL *)Rv9)[4];
                Ra.sl[6]=992; /* line # 992 */
                Rv10=((V *)Rv9)[7];
                Ra.sl[6]=994; /* line # 994 */
                if (((V *)Rv10)[10]==NULL) ((V *)Rv10)[10]=Rv0;
                Ra.sl[6]=995; /* line # 995 */
                if (((V *)Rv10)[11]!=NULL) ((V *)((V *)Rv10)[11])[1]=Rv0;
                Ra.sl[6]=996; /* line # 996 */
                ((V *)Rv10)[11]=Rv0;
              }
              else {
                Ra.sl[6]=1001; /* line # 1001 */
                P_lgt_new_copy(Lx[1].v[1],&Rv0);
                Ra.sl[6]=1002; /* line # 1002 */
                Rv11=Rv0;
                Ra.sl[6]=1004; /* line # 1004 */
                ((V *)Rv11)[3]=((V *)F_troot)[3];
                Ra.sl[6]=1005; /* line # 1005 */
                ((SL *)Rv11)[4]=((SL *)Rv11)[4]+((SL *)F_troot)[4];
              }
            }
            break;
            default:Ra.sl[6]=1015; /* line # 1015 */
            P_lgt_new_copy(F_troot, &Rv0);
            break;
          }
        }
        else {
          Ra.sl[6]=1020; /* line # 1020 */
          P_lgt_new_copy(F_troot, &Rv0);
        }
      }
      else {
        Ra.sl[6]=1024; /* line # 1024 */
        P_lgt_new_copy(F_troot, &Rv0);
        Ra.sl[6]=1025; /* line # 1025 */
        P_all_new(((V *)Rv0)+7,((V *)Rv2)[3],NULL,0);
        Ra.sl[6]=1026; /* line # 1026 */
        Rv12=((V *)Rv0)[7];
        Ra.sl[6]=1028; /* line # 1028 */
        ((V *)Rv12)[10]=Rv0;
        ((V *)Rv12)[11]=Rv0;
      }
      break;
      case 8:Ra.sl[6]=1033; /* line # 1033 */
      Ra.sl[6]=1035; /* line # 1035 */
      P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=1036; /* line # 1036 */
      Rv13=((V *)Rv2)[1];
      Rv14=NULL;
      Ra.sl[6]=1037; /* line # 1037 */
      while (Rv13!=NULL){
        Ra.sl[6]=1039; /* line # 1039 */
        Rv15=PAS_LGT_PRC_00000002(Rv13);
        Rv13=((V *)Rv13)[0];
        Ra.sl[6]=1040; /* line # 1040 */
        if (Rv14==NULL) {
          Ra.sl[6]=1041; /* line # 1041 */
          ((V *)Rv0)[1]=Rv15;
        }
        else {
          Ra.sl[6]=1043; /* line # 1043 */
          ((V *)Rv14)[0]=Rv15;
        }
        Ra.sl[6]=1044; /* line # 1044 */
        Rv14=Rv15;
      }
      break;
      case 11:break;
      case 12:Ra.sl[6]=1052; /* line # 1052 */
      Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
      Ra.sl[6]=1053; /* line # 1053 */
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv14;
      break;
      case 14:Ra.sl[6]=1057; /* line # 1057 */
      P_lgt_new_copy(F_troot, &Rv0);
      break;
      case 2:
      case 3:
      case 4:
      case 5:Ra.sl[6]=1061; /* line # 1061 */
      P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=1062; /* line # 1062 */
      ((V *)Rv0)[1]=PAS_LGT_PRC_00000002(((V *)F_troot)[1]);
      break;
      case 1:Ra.sl[6]=1067; /* line # 1067 */
      P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=1068; /* line # 1068 */
      Rv14=Rv0;
      Rv15=((V *)F_troot)[1];
      Ra.sl[6]=1070; /* line # 1070 */
      ((V *)Rv14)[1]=PAS_LGT_PRC_00000002(Rv15);
      Ra.sl[6]=1071; /* line # 1071 */
      Rv14=((V *)Rv14)[1];
      Rv15=((V *)Rv15)[0];
      Ra.sl[6]=1073; /* line # 1073 */
      ((V *)Rv14)[0]=PAS_LGT_PRC_00000002(Rv15);
      Ra.sl[6]=1074; /* line # 1074 */
      Rv14=((V *)Rv14)[0];
      Rv15=((V *)Rv15)[0];
      Ra.sl[6]=1076; /* line # 1076 */
      ((V *)Rv14)[0]=PAS_LGT_PRC_00000002(Rv15);
      break;
      case 23:Ra.sl[6]=1082; /* line # 1082 */
      P_lgt_new_copy(F_troot, &Rv0);
      Ra.sl[6]=1083; /* line # 1083 */
      Rv13=((V *)Rv2)[1];
      Ra.sl[6]=1084; /* line # 1084 */
      Rv14=NULL;
      Ra.sl[6]=1085; /* line # 1085 */
      while (Rv13!=NULL){
        Ra.sl[6]=1087; /* line # 1087 */
        Rv15=PAS_LGT_PRC_00000002(Rv13);
        Ra.sl[6]=1088; /* line # 1088 */
        if (Rv14==NULL) ((V *)F_troot)[1]=Rv15;
        else {
          Ra.sl[6]=1089; /* line # 1089 */
          ((V *)Rv14)[0]=Rv15;
        }
        Ra.sl[6]=1090; /* line # 1090 */
        Rv14=Rv15;
        Ra.sl[6]=1091; /* line # 1091 */
        Rv13=((V *)Rv13)[0];
      }
      break;
      case 6:Ra.sl[6]=1097; /* line # 1097 */
      Rv1=0;
      Ra.sl[6]=1098; /* line # 1098 */
      Rv13=NULL;
      Ra.sl[6]=1099; /* line # 1099 */
      Rv0=((V *)Rv2)[1];
      Ra.sl[6]=1100; /* line # 1100 */
      while (Rv0!=NULL){
        Ra.sl[6]=1102; /* line # 1102 */
        Rv14=PAS_LGT_PRC_00000002(Rv0);
        Ra.sl[6]=1103; /* line # 1103 */
        if (Rv13==NULL) Rv13=Rv14;
        else {
          Ra.sl[6]=1104; /* line # 1104 */
          ((V *)Rv15)[0]=Rv14;
        }
        Ra.sl[6]=1105; /* line # 1105 */
        Rv15=Rv14;
        Ra.sl[6]=1106; /* line # 1106 */
        if (((UB *)Rv14)[40]==14&&Rv1>=0) Rv1=Rv1+1;
        else {
          Ra.sl[6]=1107; /* line # 1107 */
          Rv1=-1;
        }
        Ra.sl[6]=1108; /* line # 1108 */
        Rv0=((V *)Rv0)[0];
      }
      Ra.sl[6]=1110; /* line # 1110 */
      switch (Rv1) {
        case 1:Ra.sl[6]=1112; /* line # 1112 */
        Rv0=PAS_LGT_lgt_cval_una(F_troot, Rv13);
        break;
        case 2:Ra.sl[6]=1115; /* line # 1115 */
        Rv0=PAS_LGT_lgt_cval_bin(F_troot, Rv13, Rv15);
        break;
        default:Ra.sl[6]=1118; /* line # 1118 */
        P_lgt_new_copy(F_troot, &Rv0);
        Ra.sl[6]=1119; /* line # 1119 */
        ((V *)Rv0)[1]=Rv13;
        break;
      }
      break;
      case 0:Ra.sl[6]=1125; /* line # 1125 */
      switch (((UB *)Rv2)[41]) {
        case 3:Ra.sl[6]=1129; /* line # 1129 */
        Rv14=((V *)Rv2)[1];
        Ra.sl[6]=1130; /* line # 1130 */
        Rv16=((SL *)Rv14)[4];
        Ra.sl[6]=1132; /* line # 1132 */
        Rv17=(((SL *)((V *)Rv14)[7])[6]+Rv16)-1;
        Ra.sl[6]=1133; /* line # 1133 */
        Rv18=((V *)((V *)Rv14)[7])[7];
        Ra.sl[6]=1134; /* line # 1134 */
        Rv14=((V *)Rv14)[0];
        Ra.sl[6]=1135; /* line # 1135 */
        Rv13=((V *)Rv14)[0];
        Ra.sl[6]=1136; /* line # 1136 */
        Rv15=PAS_LGT_PRC_00000002(Rv13);
        Ra.sl[6]=1137; /* line # 1137 */
        Rv13=((V *)Rv13)[0];
        Ra.sl[6]=1138; /* line # 1138 */
        if (((UB *)Rv15)[40]==14) {
          Ra.sl[6]=1140; /* line # 1140 */
          Rv1=((SL *)((V *)Rv15)[7])[13];
          P_lgt_free(&Rv15);
          Ra.sl[6]=1141; /* line # 1141 */
          if (Rv1<Rv16||Rv1>Rv17) Rv13=Rv14;
          else {
            Ra.sl[6]=1144; /* line # 1144 */
            Rv1=((SL *)Rv18)[(Rv1-Rv16)];
            Ra.sl[6]=1145; /* line # 1145 */
            if (Rv1<0) Rv13=Rv14;
            else {
              Ra.sl[6]=1147; /* line # 1147 */
              while (Rv1>0&&Rv13!=NULL){
                Ra.sl[6]=1149; /* line # 1149 */
                Rv13=((V *)Rv13)[0];
                Ra.sl[6]=1150; /* line # 1150 */
                Rv1=Rv1-1;
              }
            }
          }
          Ra.sl[6]=1153; /* line # 1153 */
          Rv0=PAS_LGT_PRC_00000002(Rv13);
        }
        else {
          Ra.sl[6]=1157; /* line # 1157 */
          P_lgt_new_copy(F_troot, &Rv0);
          Ra.sl[6]=1158; /* line # 1158 */
          P_lgt_new_copy(((V *)Rv2)[1],((V *)Rv0)+1);
          Ra.sl[6]=1159; /* line # 1159 */
          Rv14=((V *)Rv0)[1];
          Ra.sl[6]=1160; /* line # 1160 */
          P_val_copy(((V *)((V *)Rv2)[1])+7,((V *)Rv14)+7,0);
          Ra.sl[6]=1161; /* line # 1161 */
          Rv13=((V *)((V *)Rv2)[1])[0];
          Ra.sl[6]=1162; /* line # 1162 */
          ((V *)Rv14)[0]=PAS_LGT_PRC_00000002(Rv13);
          Ra.sl[6]=1163; /* line # 1163 */
          ((V *)((V *)Rv14)[0])[0]=Rv15;
          Ra.sl[6]=1164; /* line # 1164 */
          Rv13=((V *)((V *)Rv13)[0])[0];
          Ra.sl[6]=1165; /* line # 1165 */
          while (Rv13!=NULL){
            Ra.sl[6]=1167; /* line # 1167 */
            ((V *)Rv15)[0]=PAS_LGT_PRC_00000002(Rv13);
            Ra.sl[6]=1168; /* line # 1168 */
            Rv15=((V *)Rv15)[0];
            Rv13=((V *)Rv13)[0];
          }
        }
        break;
        case 0:
        case 2:
        case 4:Ra.sl[6]=1175; /* line # 1175 */
        P_lgt_new_copy(F_troot, &Rv0);
        Ra.sl[6]=1176; /* line # 1176 */
        Rv19=((V *)Rv2)[0];
        ((V *)Rv2)[0]=Rv0;
        Ra.sl[6]=1177; /* line # 1177 */
        Rv13=((V *)Rv2)[1];
        Rv14=NULL;
        Ra.sl[6]=1178; /* line # 1178 */
        while (Rv13!=NULL){
          Ra.sl[6]=1180; /* line # 1180 */
          Rv15=PAS_LGT_PRC_00000002(Rv13);
          Rv13=((V *)Rv13)[0];
          Ra.sl[6]=1181; /* line # 1181 */
          if (Rv15!=NULL) {
            Ra.sl[6]=1183; /* line # 1183 */
            if (Rv14==NULL) {
              Ra.sl[6]=1184; /* line # 1184 */
              ((V *)Rv0)[1]=Rv15;
            }
            else {
              Ra.sl[6]=1186; /* line # 1186 */
              ((V *)Rv14)[0]=Rv15;
            }
            Ra.sl[6]=1187; /* line # 1187 */
            Rv14=Rv15;
          }
        }
        Ra.sl[6]=1190; /* line # 1190 */
        ((V *)Rv2)[0]=Rv19;
        break;
        case 7:Ra.sl[6]=1195; /* line # 1195 */
        Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
        Ra.sl[6]=1196; /* line # 1196 */
        if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv14;
        break;
        case 6:Ra.sl[6]=1202; /* line # 1202 */
        Rv15=PAS_LGT_PRC_00000002(((V *)((V *)Rv2)[1])[0]);
        Ra.sl[6]=1203; /* line # 1203 */
        Rv13=((V *)Rv2)[1];
        Ra.sl[6]=1204; /* line # 1204 */
        if (Rv15!=NULL) {
          Ra.sl[6]=1205; /* line # 1205 */
          Rv20=Rv15;
          Ra.sl[6]=1206; /* line # 1206 */
          if (((UB *)Rv20)[40]==14&&((SL *)((V *)Rv20)[7])[13]==0) {
            Ra.sl[6]=1207; /* line # 1207 */
            Rv13=NULL;
          }
        }
        Ra.sl[6]=1208; /* line # 1208 */
        if (Rv13!=NULL) {
          Ra.sl[6]=1210; /* line # 1210 */
          P_lgt_new_copy(F_troot, &Rv0);
          Ra.sl[6]=1211; /* line # 1211 */
          P_lgt_new_copy(Rv13, &Rv14);
          Ra.sl[6]=1212; /* line # 1212 */
          ((V *)Rv0)[1]=Rv14;
          ((V *)Rv14)[0]=Rv15;
          Ra.sl[6]=1213; /* line # 1213 */
          Rv21=Rv14;
          Ra.sl[6]=1214; /* line # 1214 */
          if (((UB *)Rv21)[40]==11) {
            Ra.sl[6]=1216; /* line # 1216 */
            if (((V *)Rv21)[6]==Lx[1].v[0]) {
              Ra.sl[6]=1218; /* line # 1218 */
              ((V *)Rv14)[1]=Lx[1].v[3];
              Lx[1].v[3]=Rv14;
            }
          }
          else {
            Ra.sl[6]=1224; /* line # 1224 */
            ((V *)Rv14)[1]=((V *)((V *)Rv13)[1])[0];
          }
        }
        break;
        case 5:Ra.sl[6]=1230; /* line # 1230 */
        Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
        Ra.sl[6]=1231; /* line # 1231 */
        Rv13=((V *)((V *)Rv2)[1])[0];
        Ra.sl[6]=1233; /* line # 1233 */
        if (Rv13!=NULL) {
          Ra.sl[6]=1235; /* line # 1235 */
          Rv22=Rv14;
          Ra.sl[6]=1236; /* line # 1236 */
          if (((UB *)Rv22)[40]==14) {
            Ra.sl[6]=1238; /* line # 1238 */
            Rv1=((SL *)((V *)Rv22)[7])[13];
            Ra.sl[6]=1239; /* line # 1239 */
            if (Rv1<1) {
              Ra.sl[6]=1241; /* line # 1241 */
              P_lgt_free(&Rv14);
              P_lgt_free_tree(&Rv13);
              Ra.sl[6]=1242; /* line # 1242 */
              Rv0=NULL;
            }
            else {
              Ra.sl[6]=1245; /* line # 1245 */
              if (Rv1==1) {
                Ra.sl[6]=1247; /* line # 1247 */
                P_lgt_free(&Rv14);
                Rv14=NULL;
                Ra.sl[6]=1248; /* line # 1248 */
                P_lgt_new(&Rv0,NULL,0,NULL);
                Ra.sl[6]=1249; /* line # 1249 */
                ((UB *)Rv0)[41]=2;
              }
              else {
                Ra.sl[6]=1253; /* line # 1253 */
                P_lgt_new(&Rv0,NULL,0, Rv14);
                Ra.sl[6]=1254; /* line # 1254 */
                ((UB *)Rv0)[41]=5;
              }
            }
          }
          else {
            Ra.sl[6]=1259; /* line # 1259 */
            P_lgt_new(&Rv0,NULL,0, Rv14);
            Ra.sl[6]=1260; /* line # 1260 */
            ((UB *)Rv0)[41]=5;
          }
          Ra.sl[6]=1263; /* line # 1263 */
          if (Rv0!=NULL) {
            Ra.sl[6]=1265; /* line # 1265 */
            Rv19=((V *)Rv2)[0];
            ((V *)Rv2)[0]=Rv0;
            Ra.sl[6]=1266; /* line # 1266 */
            while (Rv13!=NULL){
              Ra.sl[6]=1268; /* line # 1268 */
              Rv15=PAS_LGT_PRC_00000002(Rv13);
              Rv13=((V *)Rv13)[0];
              Ra.sl[6]=1269; /* line # 1269 */
              if (Rv15!=NULL) {
                Ra.sl[6]=1271; /* line # 1271 */
                if (Rv14==NULL) {
                  Ra.sl[6]=1272; /* line # 1272 */
                  ((V *)Rv0)[1]=Rv15;
                }
                else {
                  Ra.sl[6]=1274; /* line # 1274 */
                  ((V *)Rv14)[0]=Rv15;
                }
                Ra.sl[6]=1275; /* line # 1275 */
                Rv15=Rv14;
              }
            }
            Ra.sl[6]=1278; /* line # 1278 */
            ((V *)Rv2)[0]=Rv19;
          }
        }
        else {
          Ra.sl[6]=1282; /* line # 1282 */
          P_lgt_free_tree(&Rv14);
        }
        break;
        case 8:Ra.sl[6]=1287; /* line # 1287 */
        Rv14=PAS_LGT_PRC_00000002(((V *)Rv2)[1]);
        Ra.sl[6]=1288; /* line # 1288 */
        if (Rv14!=NULL) {
          Ra.sl[6]=1290; /* line # 1290 */
          Lx[1].v[4]=((V *)((V *)Rv2)[1])[0];
          Ra.sl[6]=1291; /* line # 1291 */
          if (((UB *)Rv14)[40]==14) {
            Ra.sl[6]=1293; /* line # 1293 */
            if (((SL *)((V *)Rv14)[7])[13]>0) {
              Ra.sl[6]=1294; /* line # 1294 */
              Rv0=PAS_LGT_PRC_00000002(((V *)Rv14)[0]);
            }
            else {
              Ra.sl[6]=1296; /* line # 1296 */
              Rv23=((V *)Rv14)[0];
              Ra.sl[6]=1297; /* line # 1297 */
              if (((V *)Rv23)[0]!=NULL) {
                Ra.sl[6]=1298; /* line # 1298 */
                Rv0=PAS_LGT_PRC_00000002(((V *)Rv23)[0]);
              }
            }
          }
          else {
            Ra.sl[6]=1302; /* line # 1302 */
            ((V *)Rv14)[1]=PAS_LGT_PRC_00000002(Lx[1].v[4]);
            Ra.sl[6]=1303; /* line # 1303 */
            if (((V *)Lx[1].v[4])[0]!=NULL) {
              Ra.sl[6]=1304; /* line # 1304 */
              ((V *)((V *)Rv14)[1])[0]=PAS_LGT_PRC_00000002(((V *)Lx[1].v[4])[0]
              );
            }
            Ra.sl[6]=1305; /* line # 1305 */
            P_lgt_new_copy(F_troot, &Rv0);
            Ra.sl[6]=1306; /* line # 1306 */
            ((V *)Rv0)[1]=Rv14;
          }
        }
        break;
        default:break;
      }
      break;
      default:break;
    }
  }
  Ra.sl[6]=1319; /* line # 1319 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_inline_exp "  */
void PAS_LGT_lgt_inline_exp(V F_callnode){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+501;
  Ra.v[7]=Rd.s+14;
  Ra.sl[16]=1325; /* line # 1325 */
  Ra.v[0]=((V *)F_callnode)[6];
  Ra.sl[16]=1326; /* line # 1326 */
  Ra.v[2]=NULL;
  Ra.sl[16]=1327; /* line # 1327 */
  Rv0=Ra.v[0];
  Ra.sl[16]=1329; /* line # 1329 */
  Ra.v[3]=NULL;
  Ra.sl[16]=1331; /* line # 1331 */
  Rv1=((V *)F_callnode)[1];
  Ra.sl[16]=1332; /* line # 1332 */
  Rv2=((V *)Rv0)[8];
  Ra.sl[16]=1333; /* line # 1333 */
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[16]=1334; /* line # 1334 */
    if (((V *)Rv0)[8]!=NULL) {
      Ra.sl[16]=1335; /* line # 1335 */
      if (((UB *)((V *)Rv0)[8])[66]==6) {
        Ra.sl[16]=1338; /* line # 1338 */
        P_lgt_scan(Rv1);
        Ra.sl[16]=1339; /* line # 1339 */
        Ra.v[2]=Rv1;
        Ra.sl[16]=1340; /* line # 1340 */
        Rv3=Rv1;
        Ra.sl[16]=1341; /* line # 1341 */
        if (((V *)Rv3)[6]==NULL) {
          Ra.sl[16]=1342; /* line # 1342 */
          Rv4=((V *)Rv3)[7];
          Ra.sl[16]=1343; /* line # 1343 */
          if (((V *)Rv4)[10]==((V *)Rv4)[11]) {
            Ra.sl[16]=1345; /* line # 1345 */
            ((V *)Rv4)[10]=NULL;
            ((V *)Rv4)[11]=NULL;
          }
        }
        Ra.sl[16]=1347; /* line # 1347 */
        Ra.v[1]=Rv1;
        Rv5=Rv1;
        Ra.sl[16]=1348; /* line # 1348 */
        Rv2=((V *)Rv2)[3];
        Rv1=((V *)Rv1)[0];
        Ra.sl[16]=1349; /* line # 1349 */
        ((V *)Rv5)[0]=NULL;
      }
    }
  }
  Ra.sl[16]=1353; /* line # 1353 */
  while (Rv1!=NULL){
    Ra.sl[16]=1355; /* line # 1355 */
    Rv6=Rv2;
    Rv7=((V *)Rv6)[11];
    Ra.sl[16]=1357; /* line # 1357 */
    P_lgt_scan(Rv1);
    Ra.sl[16]=1358; /* line # 1358 */
    ((V *)Rv7)[10]=Rv1;
    Ra.sl[16]=1359; /* line # 1359 */
    ((V *)Rv7)[11]=NULL;
    Ra.sl[16]=1361; /* line # 1361 */
    Rv5=Rv1;
    Ra.sl[16]=1362; /* line # 1362 */
    Rv2=((V *)Rv2)[3];
    Rv1=((V *)Rv1)[0];
    Ra.sl[16]=1363; /* line # 1363 */
    ((V *)Rv5)[0]=NULL;
  }
  Ra.sl[16]=1367; /* line # 1367 */
  Rv2=((V *)Rv0)[23];
  Ra.sl[16]=1368; /* line # 1368 */
  while (Rv2!=NULL){
    Ra.sl[16]=1370; /* line # 1370 */
    Rv8=Rv2;
    Ra.sl[16]=1371; /* line # 1371 */
    switch (((UB *)Rv8)[66]) {
      case 1:Ra.sl[16]=1373; /* line # 1373 */
      ((V *)Rv8)[11]=NULL;
      break;
      default:break;
    }
    Ra.sl[16]=1378; /* line # 1378 */
    Rv2=((V *)Rv2)[3];
  }
  Ra.sl[16]=1382; /* line # 1382 */
  Rv5=PAS_LGT_PRC_00000002(((V *)Rv0)[16]);
  Ra.sl[16]=1384; /* line # 1384 */
  if (Ra.v[3]!=NULL) while (1){
    Ra.sl[16]=1387; /* line # 1387 */
    Rv1=Ra.v[3];
    Ra.sl[16]=1388; /* line # 1388 */
    Ra.v[3]=((V *)Ra.v[3])[1];
    Ra.sl[16]=1389; /* line # 1389 */
    Rv9=Rv1;
    Ra.sl[16]=1391; /* line # 1391 */
    ((UB *)Rv9)[40]=16;
    Ra.sl[16]=1392; /* line # 1392 */
    ((V *)Rv9)[1]=Rv5;
    if (Ra.v[3]==NULL)  break;
  }
  Ra.sl[16]=1396; /* line # 1396 */
  Rv2=((V *)Ra.v[0])[8];
  Ra.sl[16]=1399; /* line # 1399 */
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[16]=1400; /* line # 1400 */
    if (Ra.v[2]!=NULL) {
      Ra.sl[16]=1401; /* line # 1401 */
      Rv10=Rv5;
      Ra.sl[16]=1403; /* line # 1403 */
      ((V *)Rv10)[3]=((V *)Rv0)[11];
      Ra.sl[16]=1404; /* line # 1404 */
      ((UW *)Rv10)[10]=19;
      Ra.sl[16]=1406; /* line # 1406 */
      P_lgt_new(((V *)Rv10),((V *)Rv10)[3],13,NULL);
      Ra.sl[16]=1407; /* line # 1407 */
      ((V *)((V *)Rv10)[0])[6]=NULL;
      Ra.sl[16]=1408; /* line # 1408 */
      ((V *)((V *)Rv10)[0])[7]=((V *)Ra.v[1])[7];
      Ra.sl[16]=1409; /* line # 1409 */
      ((V *)((V *)Ra.v[1])[7])[11]=((V *)Rv10)[0];
      Ra.sl[16]=1410; /* line # 1410 */
      ((V *)((V *)((V *)Rv0)[8])[11])[10]=NULL;
      Ra.sl[16]=1412; /* line # 1412 */
      Rv2=((V *)Rv2)[3];
    }
  }
  Ra.sl[16]=1420; /* line # 1420 */
  while (Rv2!=NULL){
    Ra.sl[16]=1422; /* line # 1422 */
    Rv11=((V *)Rv2)[11];
    Ra.sl[16]=1423; /* line # 1423 */
    if (!(((V *)Rv11)[11]!=NULL)) {
      Ra.sl[16]=1427; /* line # 1427 */
      P_lgt_free_tree(((V *)Rv11)+10);
    }
    Ra.sl[16]=1428; /* line # 1428 */
    Rv2=((V *)Rv2)[3];
  }
  Ra.sl[16]=1432; /* line # 1432 */
  Rv12=F_callnode;
  Ra.sl[16]=1434; /* line # 1434 */
  ((UB *)Rv12)[40]=0;
  Ra.sl[16]=1435; /* line # 1435 */
  ((UB *)Rv12)[41]=2;
  Ra.sl[16]=1436; /* line # 1436 */
  ((V *)Rv12)[1]=Rv5;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " extract_data_value "  */
void PAS_LGT_PRC_00000003(V *F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+517;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1459; /* line # 1459 */
  Lx[2].v[0]=NULL;
  Ra.sl[6]=1460; /* line # 1460 */
  if ((*F_pv)!=NULL) {
    Ra.sl[6]=1461; /* line # 1461 */
    Rv0=(*F_pv);
    Ra.sl[6]=1462; /* line # 1462 */
    if (((V *)Rv0)[4]!=NULL) {
      Ra.sl[6]=1463; /* line # 1463 */
      Rv1=((V *)Rv0)[4];
      Ra.sl[6]=1465; /* line # 1465 */
      Lx[2].sl[2]=P_ide_typ_align(Lx[2].sl[2],((V *)Rv0)[4]);
      Ra.sl[6]=1467; /* line # 1467 */
      if (((SL *)Rv1)[11]>0) Rv2=Lx[2].sl[2]+((SL *)Rv1)[11];
      else {
        Ra.sl[6]=1470; /* line # 1470 */
        Rv2=Lx[2].sl[2]+((SL *)Rv0)[6];
        Ra.sl[6]=1471; /* line # 1471 */
        if (((UB *)Rv0)[48]==32&&((UB *)Rv1)[92]==10) {
          Ra.sl[6]=1473; /* line # 1473 */
          Rv2=Rv2+((SL *)Rv1)[10];
        }
      }
      Ra.sl[6]=1476; /* line # 1476 */
      if (Lx[2].sl[3]>=Rv2) {
        Ra.sl[6]=1478; /* line # 1478 */
        Lx[2].sl[2]=Rv2;
        Ra.sl[6]=1479; /* line # 1479 */
        (*F_pv)=((V *)Rv0)[0];
        Ra.sl[6]=1480; /* line # 1480 */
        goto Ret_Label;
      }
      Ra.sl[6]=1485; /* line # 1485 */
      if (((((UB *)Rv0)[48]==32&&((UB *)Rv1)[92]==8)&&((V *)Rv1)[14]==V_typ_std.
      v[0])&&Lx[2].v[2]==V_typ_std.v[0]) {
        Ra.sl[6]=1488; /* line # 1488 */
        P_val_new(Lx[2].v,Lx[2].v[2]);
        Ra.sl[6]=1489; /* line # 1489 */
        ((SL *)Lx[2].v[0])[13]=(SL)((C *)((V *)Rv0)[7])[((Lx[2].sl[3]-Lx[2].sl[2]
        )+1)+1];
        Ra.sl[6]=1490; /* line # 1490 */
        goto Ret_Label;
      }
      Ra.sl[6]=1495; /* line # 1495 */
      switch (((UB *)Rv0)[48]) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 11:
        case 13:
        case 14:
        case 15:
        case 17:
        case 19:
        case 22:Ra.sl[6]=1500; /* line # 1500 */
        P_val_copy(F_pv,Lx[2].v,0);
        Ra.sl[6]=1501; /* line # 1501 */
        goto Ret_Label;
        break;
        case 32:Ra.sl[6]=1506; /* line # 1506 */
        Rv3=Lx[2].sl[3]-Lx[2].sl[2];
        Ra.sl[6]=1507; /* line # 1507 */
        P_val_new(Lx[2].v,Lx[2].v[2]);
        Ra.sl[6]=1508; /* line # 1508 */
        if (Rv3<V_stri_descrsz) {
          Ra.sl[6]=1509; /* line # 1509 */
          ((SL *)Lx[2].v[0])[13]=((UB *)((V *)Rv0)[7])[0];
        }
        else {
          Ra.sl[6]=1511; /* line # 1511 */
          if (Rv3<V_stri_stroffset) {
            Ra.sl[6]=1512; /* line # 1512 */
            ((SL *)Lx[2].v[0])[13]=((UB *)((V *)Rv0)[7])[1];
          }
          else {
            Ra.sl[6]=1514; /* line # 1514 */
            ((SL *)Lx[2].v[0])[13]=(SL)((C *)((V *)Rv0)[7])[(Rv3-(V_stri_stroffset-
1))+1];
          }
        }
        Ra.sl[6]=1515; /* line # 1515 */
        goto Ret_Label;
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=1520; /* line # 1520 */
        Rv4=((V *)Rv0)[7];
        Ra.sl[6]=1521; /* line # 1521 */
        Rv3=((SL *)Rv0)[2];
        Ra.sl[6]=1522; /* line # 1522 */
        while (Rv4!=NULL&&Lx[2].v[0]==NULL){
          Ra.sl[6]=1523; /* line # 1523 */
          Rv5=Rv4;
          Ra.sl[6]=1525; /* line # 1525 */
          if (Rv3==0&&((UB *)Rv5)[48]==8) {
            Ra.sl[6]=1526; /* line # 1526 */
            Lx[2].sl[2]=P_ide_typ_align(Lx[2].sl[2],((V *)Rv1)[14]);
          }
          Ra.sl[6]=1527; /* line # 1527 */
          PAS_LGT_PRC_00000003(&Rv4);
          Ra.sl[6]=1528; /* line # 1528 */
          if (Rv3>0) Rv3=Rv3-1;
        }
        break;
        default:break;
      }
    }
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_extract_cte "  */
void PAS_LGT_lgt_extract_cte(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+24;
  Ra.v[4]=Rd.s+537;
  Ra.v[5]=Rd.s+14;
  Ra.sl[12]=1540; /* line # 1540 */
  Rv0=F_lgt;
  Ra.sl[12]=1541; /* line # 1541 */
  if (((V *)Rv0)[7]!=NULL&&((V *)Rv0)[3]!=NULL) {
    Ra.sl[12]=1543; /* line # 1543 */
    Ra.sl[2]=0;
    Ra.sl[12]=1544; /* line # 1544 */
    Ra.sl[3]=((SL *)Rv0)[4];
    Ra.sl[12]=1545; /* line # 1545 */
    Ra.v[2]=((V *)Rv0)[3];
    Ra.sl[12]=1546; /* line # 1546 */
    Rv1=((V *)Rv0)[7];
    Ra.sl[12]=1547; /* line # 1547 */
    Ra.v[0]=NULL;
    Ra.sl[12]=1548; /* line # 1548 */
    PAS_LGT_PRC_00000003(&Rv1);
    Ra.sl[12]=1549; /* line # 1549 */
    if (Ra.v[0]!=NULL) ((V *)Rv0)[7]=Ra.v[0];
  }
  PAS__curr_cntx=Ra.v[3];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " lgt_extract_simple_cte "  */
void P_lgt_extract_simple_cte(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+554;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1558; /* line # 1558 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=1559; /* line # 1559 */
    Rv0=F_lgt;
    Ra.sl[6]=1560; /* line # 1560 */
    if ((((UB *)Rv0)[40]==14&&((V *)Rv0)[3]!=NULL)&&((V *)Rv0)[7]!=NULL) {
      Ra.sl[6]=1561; /* line # 1561 */
      if (((UB *)((V *)Rv0)[3])[91]&&((V *)((V *)Rv0)[7])[4]!=NULL) {
        Ra.sl[6]=1562; /* line # 1562 */
        if (!((UB *)((V *)((V *)Rv0)[7])[4])[91]) {
          Ra.sl[6]=1563; /* line # 1563 */
          PAS_LGT_lgt_extract_cte(F_lgt);
        }
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_scan_block "  */
void PAS_LGT_PRC_00000004(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+578;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1585; /* line # 1585 */
  Lx[3].v[0]=V_lgt_inshde;
  Lx[3].v[1]=V_lgt_inslst;
  Ra.sl[6]=1586; /* line # 1586 */
  V_lgt_inslst=NULL;
  V_lgt_inshde=NULL;
  Ra.sl[6]=1587; /* line # 1587 */
  P_lgt_scan(F_lgt);
  Ra.sl[6]=1588; /* line # 1588 */
  if (V_lgt_inslst!=NULL) {
    Ra.sl[6]=1589; /* line # 1589 */
    if (((UB *)F_lgt)[40]!=0||((UB *)F_lgt)[41]!=2) {
      Ra.sl[6]=1591; /* line # 1591 */
      P_lgt_new_copy(F_lgt, &Rv0);
      Ra.sl[6]=1592; /* line # 1592 */
      Rv1=F_lgt;
      Ra.sl[6]=1594; /* line # 1594 */
      ((UB *)Rv1)[40]=0;
      Ra.sl[6]=1595; /* line # 1595 */
      ((UB *)Rv1)[41]=2;
      Ra.sl[6]=1596; /* line # 1596 */
      ((V *)Rv1)[1]=V_lgt_inshde;
      Ra.sl[6]=1598; /* line # 1598 */
      ((V *)V_lgt_inslst)[0]=Rv0;
    }
    else {
      Ra.sl[6]=1601; /* line # 1601 */
      PAS_LGT_lgt_do_insert(F_lgt,1);
    }
  }
  Ra.sl[6]=1603; /* line # 1603 */
  V_lgt_inshde=Lx[3].v[0];
  V_lgt_inslst=Lx[3].v[1];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_scan_case "  */
void PAS_LGT_PRC_00000005(V F_lgt, SL F_ncase){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+594;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1615; /* line # 1615 */
  Rv0=F_lgt;
  Rv1=((V *)Rv0)[7];
  Ra.sl[6]=1617; /* line # 1617 */
  Rv2=((SL *)Rv0)[4];
  Rv3=((SL *)Rv1)[6];
  Ra.sl[6]=1618; /* line # 1618 */
  Rv4=((V *)Rv1)[7];
  Rv5=((V *)Rv0)[0];
  Ra.sl[6]=1620; /* line # 1620 */
  if (((UB *)Rv5)[40]!=16) {
    Ra.sl[6]=1621; /* line # 1621 */
    PAS_LGT_PRC_00000004(Rv5);
  }
  Ra.sl[6]=1622; /* line # 1622 */
  Rv6=((V *)Rv5)[0];
  Ra.sl[6]=1623; /* line # 1623 */
  P_lgt_scan(Rv6);
  Ra.sl[6]=1624; /* line # 1624 */
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1625; /* line # 1625 */
  while (Rv7!=NULL){
    Ra.sl[6]=1627; /* line # 1627 */
    PAS_LGT_PRC_00000004(Rv7);
    Ra.sl[6]=1628; /* line # 1628 */
    Rv7=((V *)Rv7)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_check_una "  */
UB PAS_LGT_PRC_00000006(V *F_lgt, UB F_pcd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  UB Rv3;
  UB Rv4;
  register V Rv5;
  register V Rv6;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+609;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1647; /* line # 1647 */
  Rv0=(*F_lgt);
  Ra.sl[6]=1648; /* line # 1648 */
  Rv1=(*F_lgt);
  Ra.sl[6]=1649; /* line # 1649 */
  Rv2=1;
  Ra.sl[6]=1650; /* line # 1650 */
  Rv3=0;
  Ra.sl[6]=1651; /* line # 1651 */
  Rv4=0;
  Ra.sl[6]=1652; /* line # 1652 */
  while (Rv2&&Rv0!=NULL){
    Ra.sl[6]=1653; /* line # 1653 */
    Rv5=Rv0;
    Ra.sl[6]=1655; /* line # 1655 */
    switch (((UB *)Rv5)[40]) {
      case 6:Ra.sl[6]=1658; /* line # 1658 */
      if (((UB *)Rv5)[41]==F_pcd) {
        Ra.sl[6]=1660; /* line # 1660 */
        Rv4=1;
        Ra.sl[6]=1661; /* line # 1661 */
        Rv3=!Rv3;
      }
      else {
        Ra.sl[6]=1664; /* line # 1664 */
        Rv2=0;
      }
      break;
      case 14:Ra.sl[6]=1668; /* line # 1668 */
      if (((V *)Rv5)[7]!=NULL) {
        Ra.sl[6]=1669; /* line # 1669 */
        Rv6=((V *)Rv5)[7];
        Ra.sl[6]=1671; /* line # 1671 */
        switch (F_pcd) {
          case 46:Ra.sl[6]=1672; /* line # 1672 */
          if (((SL *)Rv6)[13]<0) {
            Ra.sl[6]=1673; /* line # 1673 */
            ((SL *)Rv6)[13]= -((SL *)Rv6)[13];
            Rv3=!Rv3;
          }
          break;
          case 49:Ra.sl[6]=1674; /* line # 1674 */
          if (((SL *)Rv6)[13]<0) {
            Ra.sl[6]=1675; /* line # 1675 */
            ((SL *)Rv6)[13]= -((SL *)Rv6)[13];
            Rv3=!Rv3;
          }
          break;
          case 61:
          case 77:Ra.sl[6]=1677; /* line # 1677 */
          if (((G *)Rv6)[7]<0.000000000000000E-001) {
            Ra.sl[6]=1678; /* line # 1678 */
            ((G *)Rv6)[7]=-((G *)Rv6)[7];
            Rv3=!Rv3;
          }
          break;
          case 67:
          case 85:Ra.sl[6]=1680; /* line # 1680 */
          if (((G *)Rv6)[7]<0.000000000000000E-001) {
            Ra.sl[6]=1681; /* line # 1681 */
            ((G *)Rv6)[7]=-((G *)Rv6)[7];
            Rv3=!Rv3;
          }
          break;
          default:break;
        }
        Ra.sl[6]=1684; /* line # 1684 */
        Rv2=0;
      }
      break;
      case 16:break;
      default:Ra.sl[6]=1690; /* line # 1690 */
      Rv2=0;
      break;
    }
    Ra.sl[6]=1692; /* line # 1692 */
    if (Rv2) Rv0=((V *)Rv5)[1];
  }
  Ra.sl[6]=1694; /* line # 1694 */
  if (Rv4) {
    Ra.sl[6]=1696; /* line # 1696 */
    P_lgt_scan(Rv0);
    Ra.sl[6]=1697; /* line # 1697 */
    (*F_lgt)=P_lgt_link(Rv0);
    Ra.sl[6]=1698; /* line # 1698 */
    ((V *)Rv0)[0]=Rv1;
  }
  else {
    Ra.sl[6]=1700; /* line # 1700 */
    P_lgt_scan((*F_lgt));
  }
  Ra.sl[6]=1701; /* line # 1701 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_pass_link "  */
V PAS_LGT_PRC_00000007(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+624;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1708; /* line # 1708 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=1709; /* line # 1709 */
    Rv0=F_lgt;
    Ra.sl[6]=1710; /* line # 1710 */
    if (((UB *)Rv0)[40]==16) Ret=PAS_LGT_PRC_00000007(((V *)Rv0)[1]);
    else {
      Ra.sl[6]=1711; /* line # 1711 */
      Ret=F_lgt;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_is_const "  */
V PAS_LGT_PRC_00000008(V F_lgt, V *F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+639;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1721; /* line # 1721 */
  F_lgt=PAS_LGT_PRC_00000007(F_lgt);
  Ra.sl[6]=1722; /* line # 1722 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=1723; /* line # 1723 */
    Rv0=F_lgt;
    Ra.sl[6]=1724; /* line # 1724 */
    if (((UB *)Rv0)[40]==14) Ret=((V *)Rv0)[7];
    else {
      Ra.sl[6]=1725; /* line # 1725 */
      Ret=NULL;
    }
  }
  else {
    Ra.sl[6]=1726; /* line # 1726 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_cte_in_2 "  */
V PAS_LGT_PRC_00000009(V *F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+653;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=1737; /* line # 1737 */
  Rv0=((V *)(*F_lgt))[1];
  Ra.sl[6]=1738; /* line # 1738 */
  Rv1=PAS_LGT_PRC_00000008(Rv0, NULL);
  Ra.sl[6]=1739; /* line # 1739 */
  Rv2=((V *)(*F_lgt))[0];
  Ra.sl[6]=1740; /* line # 1740 */
  Rv3=PAS_LGT_PRC_00000008(Rv2, NULL);
  Ra.sl[6]=1741; /* line # 1741 */
  if (Rv1!=NULL) {
    Ra.sl[6]=1742; /* line # 1742 */
    Rv4=(*F_lgt);
    Ra.sl[6]=1743; /* line # 1743 */
    if (Rv3==NULL||((UB *)Rv2)[40]==16) {
      Ra.sl[6]=1745; /* line # 1745 */
      ((V *)Rv4)[1]=Rv2;
      ((V *)Rv2)[0]=Rv0;
      ((V *)Rv0)[0]=NULL;
      Ra.sl[6]=1746; /* line # 1746 */
      Ret=Rv1;
    }
    else {
      Ra.sl[6]=1750; /* line # 1750 */
      switch (((UB *)Rv4)[41]) {
        case 49:Ra.sl[6]=1752; /* line # 1752 */
        if (((UB *)((V *)Rv4)[3])[112]) {
          Ra.sl[6]=1753; /* line # 1753 */
          ((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)[3],((UL *)Rv1)[13]+((UL *)Rv3)
          [13]);
        }
        else {
          Ra.sl[6]=1755; /* line # 1755 */
          ((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)[3],((SL *)Rv1)[13]+((SL *)Rv3)
          [13]);
        }
        break;
        case 67:
        case 85:Ra.sl[6]=1758; /* line # 1758 */
        ((V *)Rv4)[1]=P_lgt_new_econstr(((V *)Rv4)[3],((G *)Rv1)[7]+((G *)Rv3)[7]
        );
        break;
        case 51:Ra.sl[6]=1760; /* line # 1760 */
        if (((UB *)((V *)Rv4)[3])[112]) {
          Ra.sl[6]=1761; /* line # 1761 */
          ((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)[3],((UL *)Rv1)[13]*((UL *)Rv3)
          [13]);
        }
        else {
          Ra.sl[6]=1763; /* line # 1763 */
          ((V *)Rv4)[1]=P_lgt_new_econst(((V *)Rv4)[3],((SL *)Rv1)[13]*((SL *)Rv3)
          [13]);
        }
        break;
        case 69:
        case 87:Ra.sl[6]=1766; /* line # 1766 */
        ((V *)Rv4)[1]=P_lgt_new_econstr(((V *)Rv4)[3],((G *)Rv1)[7]*((G *)Rv3)[7]
        );
        break;
        default:break;
      }
      Ra.sl[6]=1769; /* line # 1769 */
      P_lgt_free(&Rv0);
      P_lgt_free(&Rv2);
      Ra.sl[6]=1770; /* line # 1770 */
      Ret=NULL;
    }
  }
  else {
    Ra.sl[6]=1773; /* line # 1773 */
    Ret=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_scan "  */
void P_lgt_scan(V F_head){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  SL Rv8;
  V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+667;
  Ra.v[4]=Rd.s+14;
  Ra.sl[10]=1815; /* line # 1815 */
  if (F_head!=NULL) {
    Ra.sl[10]=1816; /* line # 1816 */
    Rv0=F_head;
    Ra.sl[10]=1818; /* line # 1818 */
    switch (((UB *)Rv0)[40]) {
      case 24:Ra.sl[10]=1821; /* line # 1821 */
      Rv1=((V *)Rv0)[1];
      Ra.sl[10]=1823; /* line # 1823 */
      while (Rv1!=NULL){
        Ra.sl[10]=1825; /* line # 1825 */
        P_lgt_scan(Rv1);
        Ra.sl[10]=1826; /* line # 1826 */
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 0:Ra.sl[10]=1832; /* line # 1832 */
      switch (((UB *)Rv0)[41]) {
        case 3:Ra.sl[10]=1834; /* line # 1834 */
        PAS_LGT_PRC_00000005(((V *)Rv0)[1],((SL *)Rv0)[4]);
        break;
        case 8:Ra.sl[10]=1837; /* line # 1837 */
        if (((V *)Rv0)[1]!=NULL) {
          Ra.sl[10]=1839; /* line # 1839 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1840; /* line # 1840 */
          Rv1=((V *)((V *)Rv0)[1])[0];
          Ra.sl[10]=1841; /* line # 1841 */
          while (Rv1!=NULL){
            Ra.sl[10]=1843; /* line # 1843 */
            if (((V *)Rv0)[3]==NULL) PAS_LGT_PRC_00000004(Rv1);
            else {
              Ra.sl[10]=1844; /* line # 1844 */
              P_lgt_scan(Rv1);
            }
            Ra.sl[10]=1845; /* line # 1845 */
            Rv1=((V *)Rv1)[0];
          }
        }
        break;
        case 9:break;
        case 0:
        case 2:
        case 4:
        case 5:Ra.sl[10]=1855; /* line # 1855 */
        Rv1=((V *)Rv0)[1];
        Rv2=NULL;
        Ra.sl[10]=1856; /* line # 1856 */
        if (((UB *)Rv0)[41]==5||((UB *)Rv0)[41]==4) {
          Ra.sl[10]=1858; /* line # 1858 */
          P_lgt_scan(Rv1);
          Ra.sl[10]=1859; /* line # 1859 */
          Rv2=Rv1;
          Rv1=((V *)Rv1)[0];
        }
        Ra.sl[10]=1862; /* line # 1862 */
        Ra.v[0]=V_lgt_inshde;
        Ra.v[1]=V_lgt_inslst;
        Ra.sl[10]=1863; /* line # 1863 */
        V_lgt_inslst=NULL;
        V_lgt_inshde=NULL;
        Ra.sl[10]=1864; /* line # 1864 */
        while (Rv1!=NULL){
          Ra.sl[10]=1866; /* line # 1866 */
          P_lgt_scan(Rv1);
          Ra.sl[10]=1867; /* line # 1867 */
          if (V_lgt_inslst!=NULL) {
            Ra.sl[10]=1868; /* line # 1868 */
            if (Rv2==NULL) PAS_LGT_lgt_do_insert(F_head,1);
            else {
              Ra.sl[10]=1869; /* line # 1869 */
              PAS_LGT_lgt_do_insert(Rv2,0);
            }
          }
          Ra.sl[10]=1870; /* line # 1870 */
          Rv2=Rv1;
          Rv1=((V *)Rv1)[0];
        }
        Ra.sl[10]=1873; /* line # 1873 */
        V_lgt_inshde=Ra.v[0];
        V_lgt_inslst=Ra.v[1];
        break;
        case 6:Ra.sl[10]=1878; /* line # 1878 */
        Rv1=((V *)Rv0)[1];
        Ra.sl[10]=1879; /* line # 1879 */
        Rv2=((V *)Rv1)[1];
        Ra.sl[10]=1880; /* line # 1880 */
        while (Rv2!=NULL){
          Ra.sl[10]=1881; /* line # 1881 */
          if (((UB *)Rv2)[40]==23) {
            Ra.sl[10]=1882; /* line # 1882 */
            Rv2=((V *)Rv2)[0];
          }
          else {
            Ra.sl[10]=1885; /* line # 1885 */
            ((V *)Rv1)[1]=Rv2;
            Rv2=NULL;
          }
        }
        Ra.sl[10]=1887; /* line # 1887 */
        P_lgt_scan(((V *)Rv1)[0]);
        break;
        case 7:Ra.sl[10]=1891; /* line # 1891 */
        P_lgt_scan(((V *)Rv0)[1]);
        break;
        default:break;
      }
      break;
      case 23:Ra.sl[10]=1899; /* line # 1899 */
      Rv1=((V *)Rv0)[1];
      Ra.sl[10]=1900; /* line # 1900 */
      while (Rv1!=NULL){
        Ra.sl[10]=1902; /* line # 1902 */
        P_lgt_scan(Rv1);
        Ra.sl[10]=1903; /* line # 1903 */
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 6:Ra.sl[10]=1908; /* line # 1908 */
      if (((V *)Rv0)[1]!=NULL) {
        Ra.sl[10]=1910; /* line # 1910 */
        switch (((UB *)Rv0)[41]) {
          case 49:Ra.sl[10]=1913; /* line # 1913 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1914; /* line # 1914 */
          if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),46)) {
            Ra.sl[10]=1915; /* line # 1915 */
            ((UB *)Rv0)[41]=50;
          }
          break;
          case 67:Ra.sl[10]=1919; /* line # 1919 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1920; /* line # 1920 */
          if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),61)) {
            Ra.sl[10]=1921; /* line # 1921 */
            ((UB *)Rv0)[41]=68;
          }
          break;
          case 85:Ra.sl[10]=1925; /* line # 1925 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1926; /* line # 1926 */
          if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),77)) {
            Ra.sl[10]=1927; /* line # 1927 */
            ((UB *)Rv0)[41]=86;
          }
          break;
          case 50:Ra.sl[10]=1932; /* line # 1932 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1933; /* line # 1933 */
          if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),46)) {
            Ra.sl[10]=1934; /* line # 1934 */
            ((UB *)Rv0)[41]=49;
          }
          break;
          case 68:Ra.sl[10]=1938; /* line # 1938 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1939; /* line # 1939 */
          if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),61)) {
            Ra.sl[10]=1940; /* line # 1940 */
            ((UB *)Rv0)[41]=67;
          }
          break;
          case 86:Ra.sl[10]=1944; /* line # 1944 */
          P_lgt_scan(((V *)Rv0)[1]);
          Ra.sl[10]=1945; /* line # 1945 */
          if (PAS_LGT_PRC_00000006(((V *)((V *)Rv0)[1]),77)) {
            Ra.sl[10]=1946; /* line # 1946 */
            ((UB *)Rv0)[41]=85;
          }
          break;
          case 46:Ra.sl[10]=1950; /* line # 1950 */
          if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,46)) {
            Ra.sl[10]=1951; /* line # 1951 */
            ((UB *)Rv0)[41]=0;
          }
          break;
          case 61:Ra.sl[10]=1953; /* line # 1953 */
          if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,61)) {
            Ra.sl[10]=1954; /* line # 1954 */
            ((UB *)Rv0)[41]=0;
          }
          break;
          case 77:Ra.sl[10]=1956; /* line # 1956 */
          if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,77)) {
            Ra.sl[10]=1957; /* line # 1957 */
            ((UB *)Rv0)[41]=0;
          }
          break;
          case 6:Ra.sl[10]=1960; /* line # 1960 */
          if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,6)) {
            Ra.sl[10]=1961; /* line # 1961 */
            ((UB *)Rv0)[41]=0;
          }
          break;
          case 10:Ra.sl[10]=1963; /* line # 1963 */
          if (PAS_LGT_PRC_00000006(((V *)Rv0)+1,10)) {
            Ra.sl[10]=1964; /* line # 1964 */
            ((UB *)Rv0)[41]=0;
          }
          break;
          case 53:Ra.sl[10]=1968; /* line # 1968 */
          Rv1=((V *)Rv0)[1];
          Ra.sl[10]=1969; /* line # 1969 */
          if (Rv1!=NULL) {
            Ra.sl[10]=1971; /* line # 1971 */
            P_lgt_scan(Rv1);
            Rv1=((V *)Rv1)[0];
            Ra.sl[10]=1972; /* line # 1972 */
            if (Rv1!=NULL) {
              Ra.sl[10]=1974; /* line # 1974 */
              P_lgt_scan(Rv1);
              Ra.sl[10]=1975; /* line # 1975 */
              if (P_lgt_imaskp2(Rv1)>=0) ((UB *)Rv0)[41]=11;
            }
          }
          break;
          default:Ra.sl[10]=1981; /* line # 1981 */
          Rv1=((V *)Rv0)[1];
          Ra.sl[10]=1982; /* line # 1982 */
          while (Rv1!=NULL){
            Ra.sl[10]=1984; /* line # 1984 */
            P_lgt_scan(Rv1);
            Rv1=((V *)Rv1)[0];
          }
          break;
        }
      }
      break;
      case 5:Ra.sl[10]=1991; /* line # 1991 */
      Rv1=((V *)Rv0)[1];
      Ra.sl[10]=1992; /* line # 1992 */
      if ((!V_binline&&Rv1!=NULL)&&((V *)Rv0)[3]!=NULL) {
        Ra.sl[10]=1993; /* line # 1993 */
        if (((UB *)Rv1)[40]==14) {
          Ra.sl[10]=1995; /* line # 1995 */
          ((V *)Rv0)[1]=NULL;
          Ra.sl[10]=1996; /* line # 1996 */
          ((UB *)Rv0)[40]=14;
          Ra.sl[10]=1997; /* line # 1997 */
          ((SL *)Rv0)[4]=((SL *)Rv0)[4]+((SL *)Rv1)[4];
          Ra.sl[10]=1998; /* line # 1998 */
          if (256&((UW *)Rv1)[10]) {
            Ra.sl[10]=2000; /* line # 2000 */
            ((V *)Rv0)[7]=NULL;
            Ra.sl[10]=2001; /* line # 2001 */
            P_val_copy(((V *)Rv1)+7,((V *)Rv0)+7,0);
          }
          else {
            Ra.sl[10]=2005; /* line # 2005 */
            ((V *)Rv0)[7]=((V *)Rv1)[7];
            Ra.sl[10]=2006; /* line # 2006 */
            P_val_new(((V *)Rv0)+7,((V *)Rv0)[3]);
            Ra.sl[10]=2007; /* line # 2007 */
            P_lgt_free(&Rv1);
          }
          Ra.sl[10]=2010; /* line # 2010 */
          if (((V *)Rv0)[7]!=NULL) {
            Ra.sl[10]=2011; /* line # 2011 */
            Rv3=((V *)Rv0)[7];
            Ra.sl[10]=2012; /* line # 2012 */
            if (((V *)Rv3)[5]==NULL) {
              Ra.sl[10]=2014; /* line # 2014 */
              P_all_new(((V *)Rv3)+5,((V *)Rv0)[3],((V *)Rv0)[4],11);
              Ra.sl[10]=2015; /* line # 2015 */
              if (V_all_fdata==NULL) V_all_fdata=((V *)Rv3)[5];
              else {
                Ra.sl[10]=2016; /* line # 2016 */
                ((V *)V_all_ldata)[0]=((V *)Rv3)[5];
              }
              Ra.sl[10]=2017; /* line # 2017 */
              ((V *)((V *)Rv3)[5])[1]=V_all_ldata;
              Ra.sl[10]=2018; /* line # 2018 */
              V_all_ldata=((V *)Rv3)[5];
              Ra.sl[10]=2019; /* line # 2019 */
              Rv4=((V *)Rv3)[5];
              Ra.sl[10]=2021; /* line # 2021 */
              ((V *)Rv4)[13]=((V *)Rv0)[7];
              Ra.sl[10]=2022; /* line # 2022 */
              Rv5=((V *)Rv4)[13];
              Ra.sl[10]=2023; /* line # 2023 */
              ((SL *)Rv5)[3]=((SL *)Rv5)[3]+1;
              Ra.sl[10]=2024; /* line # 2024 */
              ((V *)Rv4)[10]=F_head;
              ((V *)Rv4)[11]=F_head;
            }
            else {
              Ra.sl[10]=2028; /* line # 2028 */
              Rv6=((V *)Rv3)[5];
              Ra.sl[10]=2030; /* line # 2030 */
              if (((V *)Rv6)[10]==NULL) ((V *)Rv6)[10]=F_head;
              else {
                Ra.sl[10]=2031; /* line # 2031 */
                ((V *)((V *)Rv6)[11])[1]=F_head;
              }
              Ra.sl[10]=2032; /* line # 2032 */
              ((V *)Rv6)[11]=F_head;
            }
          }
        }
        else {
          Ra.sl[10]=2037; /* line # 2037 */
          P_lgt_scan(Rv1);
          Ra.sl[10]=2038; /* line # 2038 */
          ((SL *)Rv0)[4]=P_ide_typ_align(Rs.sl[9],((V *)Rv0)[3]);
          Ra.sl[10]=2039; /* line # 2039 */
          Rs.sl[9]=((SL *)Rv0)[4]+((SL *)((V *)Rv0)[3])[11];
          Ra.sl[10]=2040; /* line # 2040 */
          if (Rs.sl[10]<Rs.sl[9]) Rs.sl[10]=Rs.sl[9];
        }
      }
      break;
      case 1:
      case 2:
      case 3:
      case 4:
      case 9:
      case 20:Ra.sl[10]=2046; /* line # 2046 */
      Rv1=((V *)Rv0)[1];
      Ra.sl[10]=2054; /* line # 2054 */
      while (Rv1!=NULL){
        Ra.sl[10]=2056; /* line # 2056 */
        P_lgt_scan(Rv1);
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 17:break;
      case 16:break;
      case 7:
      case 8:Ra.sl[10]=2068; /* line # 2068 */
      Rv7=((V *)Rv0)[6];
      Ra.sl[10]=2069; /* line # 2069 */
      if (1&((UW *)Rv7)[8]) PAS_LGT_lgt_inline_exp(F_head);
      else {
        Ra.sl[10]=2072; /* line # 2072 */
        Rv8=Rs.sl[9];
        Ra.sl[10]=2073; /* line # 2073 */
        Rv9=((V *)Rv7)[8];
        Ra.sl[10]=2074; /* line # 2074 */
        Rv1=((V *)Rv0)[1];
        Ra.sl[10]=2075; /* line # 2075 */
        if (((UB *)Rv0)[40]==7) {
          Ra.sl[10]=2077; /* line # 2077 */
          P_lgt_scan(Rv1);
          Ra.sl[10]=2078; /* line # 2078 */
          Rv1=((V *)Rv1)[0];
        }
        else {
          Ra.sl[10]=2082; /* line # 2082 */
          ((UW *)Rv7)[8]=((UW *)Rv7)[8]|8;
          Ra.sl[10]=2083; /* line # 2083 */
          if ((((UW *)Rv7)[8]&768)==0) {
            Ra.sl[10]=2084; /* line # 2084 */
            ((UW *)Rv7)[8]=((UW *)Rv7)[8]|256;
          }
          Ra.sl[10]=2085; /* line # 2085 */
          if (((UB *)Rv7)[104]==3) {
            Ra.sl[10]=2086; /* line # 2086 */
            if (V_curr_lex!=((SL *)Rv7)[18]) {
              Ra.sl[10]=2087; /* line # 2087 */
              ((UW *)Rv7)[8]=((UW *)Rv7)[8]|1024;
            }
          }
        }
        Ra.sl[10]=2089; /* line # 2089 */
        while (Rv1!=NULL){
          Ra.sl[10]=2091; /* line # 2091 */
          P_lgt_scan(Rv1);
          Ra.sl[10]=2092; /* line # 2092 */
          if (((V *)Rv1)[3]!=NULL) {
            Ra.sl[10]=2094; /* line # 2094 */
            if (256&((UW *)Rv9)[32]) {
              Ra.sl[10]=2095; /* line # 2095 */
              Rv10=((V *)Rv1)[3];
              Ra.sl[10]=2097; /* line # 2097 */
              switch (((UB *)Rv10)[92]) {
                case 1:Ra.sl[10]=2099; /* line # 2099 */
                if (((V *)Rv10)[13]!=NULL) P_lgt_scan(((V *)Rv10)[13]);
                break;
                case 11:
                case 12:Ra.sl[10]=2101; /* line # 2101 */
                if (((V *)Rv10)[13]!=NULL) {
                  Ra.sl[10]=2102; /* line # 2102 */
                  Rv11=((V *)Rv10)[13];
                  Ra.sl[10]=2103; /* line # 2103 */
                  if (1<<((UB *)Rv11)[92]&7) {
                    Ra.sl[10]=2104; /* line # 2104 */
                    if (((V *)Rv11)[13]!=NULL) P_lgt_scan(((V *)Rv11)[13]);
                  }
                }
                break;
                default:break;
              }
            }
          }
          Ra.sl[10]=2108; /* line # 2108 */
          Rv9=((V *)Rv9)[3];
          Ra.sl[10]=2109; /* line # 2109 */
          Rv1=((V *)Rv1)[0];
        }
        Ra.sl[10]=2111; /* line # 2111 */
        Rs.sl[9]=Rv8;
      }
      break;
      case 11:Ra.sl[10]=2115; /* line # 2115 */
      Rv12=((V *)Rv0)[6];
      Ra.sl[10]=2117; /* line # 2117 */
      ((UW *)Rv12)[8]=((UW *)Rv12)[8]|8;
      Ra.sl[10]=2118; /* line # 2118 */
      if (!(512&((UW *)Rv12)[8])) {
        Ra.sl[10]=2119; /* line # 2119 */
        ((UW *)Rv12)[8]=((UW *)Rv12)[8]|256;
      }
      Ra.sl[10]=2120; /* line # 2120 */
      if (V_curr_lex!=((SL *)Rv12)[18]) {
        Ra.sl[10]=2121; /* line # 2121 */
        ((UW *)Rv12)[8]=((UW *)Rv12)[8]|1024;
      }
      break;
      case 12:
      case 21:Ra.sl[10]=2125; /* line # 2125 */
      P_lgt_scan(((V *)Rv0)[1]);
      break;
      case 13:Ra.sl[10]=2128; /* line # 2128 */
      if (!V_binline) {
        Ra.sl[10]=2130; /* line # 2130 */
        if (((V *)Rv0)[6]!=NULL) {
          Ra.sl[10]=2131; /* line # 2131 */
          Rv13=((V *)Rv0)[6];
          Ra.sl[10]=2135; /* line # 2135 */
          if (((V *)Rv13)[11]==NULL) {
            Ra.sl[10]=2142; /* line # 2142 */
            ((UW *)Rv13)[32]=((UW *)Rv13)[32]|1;
            Ra.sl[10]=2143; /* line # 2143 */
            if (V_curr_lex!=((SL *)Rv13)[10]) {
              Ra.sl[10]=2144; /* line # 2144 */
              ((UW *)Rv13)[32]=((UW *)Rv13)[32]|4;
            }
            Ra.sl[10]=2145; /* line # 2145 */
            P_all_new(((V *)Rv13)+11,((V *)Rv13)[4],((V *)Rv0)[6],((UB *)Rv13)[66]
            );
            Ra.sl[10]=2146; /* line # 2146 */
            if (4&((UW *)Rv13)[32]) {
              Ra.sl[10]=2147; /* line # 2147 */
              ((V *)((V *)Rv13)[11])[10]=NULL;
            }
            else {
              Ra.sl[10]=2149; /* line # 2149 */
              ((V *)((V *)Rv13)[11])[10]=F_head;
            }
            Ra.sl[10]=2150; /* line # 2150 */
            switch (((UB *)Rv13)[66]) {
              case 4:
              case 5:
              case 12:Ra.sl[10]=2155; /* line # 2155 */
              if (V_all_fextern==NULL) V_all_fextern=((V *)Rv13)[11];
              else {
                Ra.sl[10]=2156; /* line # 2156 */
                ((V *)V_all_lextern)[0]=((V *)Rv13)[11];
              }
              Ra.sl[10]=2157; /* line # 2157 */
              ((V *)((V *)Rv13)[11])[1]=V_all_lextern;
              Ra.sl[10]=2158; /* line # 2158 */
              V_all_lextern=((V *)Rv13)[11];
              break;
              case 3:Ra.sl[10]=2163; /* line # 2163 */
              ((V *)((V *)Rv13)[11])[13]=((V *)Rv13)[9];
              Ra.sl[10]=2164; /* line # 2164 */
              if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv13)[11];
              else {
                Ra.sl[10]=2165; /* line # 2165 */
                ((V *)V_all_lglobal)[0]=((V *)Rv13)[11];
              }
              Ra.sl[10]=2166; /* line # 2166 */
              ((V *)((V *)Rv13)[11])[1]=V_all_lglobal;
              Ra.sl[10]=2167; /* line # 2167 */
              V_all_lglobal=((V *)Rv13)[11];
              break;
              case 0:
              case 1:Ra.sl[10]=2172; /* line # 2172 */
              if (((SL *)Rv13)[10]<=1) {
                Ra.sl[10]=2174; /* line # 2174 */
                ((V *)((V *)Rv13)[11])[13]=((V *)Rv13)[9];
                Ra.sl[10]=2175; /* line # 2175 */
                if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv13)[11];
                else {
                  Ra.sl[10]=2176; /* line # 2176 */
                  ((V *)V_all_lstatic)[0]=((V *)Rv13)[11];
                }
                Ra.sl[10]=2177; /* line # 2177 */
                ((V *)((V *)Rv13)[11])[1]=V_all_lstatic;
                Ra.sl[10]=2178; /* line # 2178 */
                V_all_lstatic=((V *)Rv13)[11];
              }
              else {
                Ra.sl[10]=2181; /* line # 2181 */
                Rv14=((V *)Rv13)[6];
                Ra.sl[10]=2183; /* line # 2183 */
                if (((V *)Rv14)[25]==NULL) ((V *)Rv14)[25]=((V *)Rv13)[11];
                else {
                  Ra.sl[10]=2184; /* line # 2184 */
                  ((V *)((V *)Rv14)[26])[0]=((V *)Rv13)[11];
                }
                Ra.sl[10]=2185; /* line # 2185 */
                ((V *)((V *)Rv13)[11])[1]=((V *)Rv14)[26];
                Ra.sl[10]=2186; /* line # 2186 */
                ((V *)Rv14)[26]=((V *)Rv13)[11];
              }
              break;
              case 2:Ra.sl[10]=2191; /* line # 2191 */
              ((V *)((V *)Rv13)[11])[13]=((V *)Rv13)[9];
              Ra.sl[10]=2192; /* line # 2192 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv13)[11];
              else {
                Ra.sl[10]=2193; /* line # 2193 */
                ((V *)V_all_lstatic)[0]=((V *)Rv13)[11];
              }
              Ra.sl[10]=2194; /* line # 2194 */
              ((V *)((V *)Rv13)[11])[1]=V_all_lstatic;
              Ra.sl[10]=2195; /* line # 2195 */
              V_all_lstatic=((V *)Rv13)[11];
              break;
              default:break;
            }
          }
          else {
            Ra.sl[10]=2201; /* line # 2201 */
            Rv15=((V *)Rv13)[11];
            Ra.sl[10]=2202; /* line # 2202 */
            switch (((UB *)Rv13)[66]) {
              case 1:
              case 2:
              case 3:
              case 4:
              case 5:
              case 12:Ra.sl[10]=2205; /* line # 2205 */
              if (((V *)Rv15)[11]!=NULL&&((V *)Rv15)[11]!=F_head) {
                Ra.sl[10]=2206; /* line # 2206 */
                ((V *)((V *)Rv15)[11])[1]=F_head;
              }
              break;
              case 7:
              case 8:Ra.sl[10]=2210; /* line # 2210 */
              ((UW *)Rv13)[32]=((UW *)Rv13)[32]|1;
              Ra.sl[10]=2211; /* line # 2211 */
              if (V_curr_lex!=((SL *)Rv13)[10]) {
                Ra.sl[10]=2212; /* line # 2212 */
                ((UW *)Rv13)[32]=((UW *)Rv13)[32]|4;
              }
              Ra.sl[10]=2213; /* line # 2213 */
              ((UW *)Rv15)[16]=((UW *)Rv13)[32];
              break;
              default:break;
            }
          }
          Ra.sl[10]=2218; /* line # 2218 */
          ((V *)Rv0)[7]=((V *)Rv13)[11];
          Ra.sl[10]=2219; /* line # 2219 */
          ((V *)((V *)Rv13)[11])[11]=F_head;
        }
        else {
          Ra.sl[10]=2223; /* line # 2223 */
          if (((V *)Rv0)[7]==NULL) P_all_new(((V *)Rv0)+7,((V *)Rv0)[3],NULL,0);
          Ra.sl[10]=2224; /* line # 2224 */
          Rv16=((V *)Rv0)[7];
          Ra.sl[10]=2226; /* line # 2226 */
          if (((V *)Rv16)[10]==NULL) {
            Ra.sl[10]=2228; /* line # 2228 */
            if (((SL *)Rv16)[15]<=1) {
              Ra.sl[10]=2230; /* line # 2230 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv0)[7];
              else {
                Ra.sl[10]=2231; /* line # 2231 */
                ((V *)V_all_lstatic)[0]=((V *)Rv0)[7];
              }
              Ra.sl[10]=2232; /* line # 2232 */
              ((V *)((V *)Rv0)[7])[1]=V_all_lstatic;
              Ra.sl[10]=2233; /* line # 2233 */
              V_all_lstatic=((V *)Rv0)[7];
            }
            else {
              Ra.sl[10]=2236; /* line # 2236 */
              Rv17=((V *)Rv16)[5];
              Ra.sl[10]=2238; /* line # 2238 */
              if (((V *)Rv17)[25]==NULL) ((V *)Rv17)[25]=((V *)Rv0)[7];
              else {
                Ra.sl[10]=2239; /* line # 2239 */
                ((V *)((V *)Rv17)[26])[0]=((V *)Rv0)[7];
              }
              Ra.sl[10]=2240; /* line # 2240 */
              ((V *)((V *)Rv0)[7])[1]=((V *)Rv17)[26];
              Ra.sl[10]=2241; /* line # 2241 */
              ((V *)Rv17)[26]=((V *)Rv0)[7];
            }
            Ra.sl[10]=2243; /* line # 2243 */
            ((V *)Rv16)[10]=F_head;
            ((V *)Rv16)[11]=F_head;
            Ra.sl[10]=2246; /* line # 2246 */
            Rv18=((V *)Rv0)[3];
            Ra.sl[10]=2247; /* line # 2247 */
            if (((SL *)Rv18)[10]>0&&((V *)Rv18)[4]!=NULL) {
              Ra.sl[10]=2249; /* line # 2249 */
              Rv9=((V *)Rv18)[4];
              Ra.sl[10]=2250; /* line # 2250 */
              while (Rv9!=NULL){
                Ra.sl[10]=2253; /* line # 2253 */
                P_lgt_new_copy(F_head, &Rv2);
                Ra.sl[10]=2254; /* line # 2254 */
                ((V *)Rv2)[3]=((V *)Rv9)[4];
                Ra.sl[10]=2255; /* line # 2255 */
                ((SL *)Rv2)[4]=((SL *)Rv9)[15];
                Ra.sl[10]=2256; /* line # 2256 */
                ((V *)Rv2)[0]=P_lgt_new_econst(((V *)Rv9)[4],((SL *)((V *)Rv9)[11]
                )[13]);
                Ra.sl[10]=2258; /* line # 2258 */
                Rv1=P_lgt_new_code(3, Rv2);
                Ra.sl[10]=2259; /* line # 2259 */
                if (V_lgt_inshde==NULL) V_lgt_inshde=Rv1;
                else {
                  Ra.sl[10]=2260; /* line # 2260 */
                  ((V *)V_lgt_inslst)[0]=Rv1;
                }
                Ra.sl[10]=2261; /* line # 2261 */
                V_lgt_inslst=Rv1;
                Ra.sl[10]=2262; /* line # 2262 */
                Rv9=((V *)Rv9)[3];
              }
            }
          }
          else {
            Ra.sl[10]=2268; /* line # 2268 */
            if (((V *)Rv16)[10]==NULL) ((V *)Rv16)[10]=F_head;
            else {
              Ra.sl[10]=2269; /* line # 2269 */
              ((V *)((V *)Rv16)[11])[1]=F_head;
            }
            Ra.sl[10]=2270; /* line # 2270 */
            ((V *)Rv16)[11]=F_head;
          }
        }
      }
      break;
      case 15:Ra.sl[10]=2278; /* line # 2278 */
      Rv1=((V *)Rv0)[1];
      Ra.sl[10]=2279; /* line # 2279 */
      P_lgt_scan(Rv1);
      Ra.sl[10]=2280; /* line # 2280 */
      Rv1=((V *)Rv1)[0];
      Ra.sl[10]=2281; /* line # 2281 */
      if (Rv1!=NULL) Rv1=((V *)Rv1)[0];
      Ra.sl[10]=2282; /* line # 2282 */
      while (Rv1!=NULL){
        Ra.sl[10]=2284; /* line # 2284 */
        P_lgt_scan(Rv1);
        Rv1=((V *)Rv1)[0];
      }
      break;
      case 14:Ra.sl[10]=2289; /* line # 2289 */
      if (!V_binline) {
        Ra.sl[10]=2294; /* line # 2294 */
        if (((V *)Rv0)[7]!=NULL) {
          Ra.sl[10]=2295; /* line # 2295 */
          Rv19=((V *)Rv0)[7];
          Ra.sl[10]=2297; /* line # 2297 */
          if (((V *)Rv19)[4]!=NULL) {
            Ra.sl[10]=2298; /* line # 2298 */
            Rv20=((V *)Rv19)[4];
            Ra.sl[10]=2299; /* line # 2299 */
            if (!((UB *)Rv20)[91]) {
              Ra.sl[10]=2300; /* line # 2300 */
              if (((UB *)((V *)Rv0)[3])[91]) {
                Ra.sl[10]=2302; /* line # 2302 */
                PAS_LGT_lgt_extract_cte(F_head);
              }
              else {
                Ra.sl[10]=2305; /* line # 2305 */
                if (((V *)Rv19)[5]==NULL) {
                  Ra.sl[10]=2307; /* line # 2307 */
                  Rv21=((SL *)Rv20)[11];
                  Ra.sl[10]=2308; /* line # 2308 */
                  if (((SL *)Rv19)[6]>0) {
                    Ra.sl[10]=2309; /* line # 2309 */
                    if (((V *)Rv0)[3]==V_typ_std.v[10]) {
                      Ra.sl[10]=2310; /* line # 2310 */
                      ((SL *)Rv20)[11]=((SL *)Rv19)[6]+((SL *)Rv20)[10];
                    }
                    else {
                      Ra.sl[10]=2312; /* line # 2312 */
                      ((SL *)Rv20)[11]=((SL *)Rv19)[6];
                    }
                  }
                  Ra.sl[10]=2313; /* line # 2313 */
                  P_all_new(((V *)Rv19)+5,((V *)Rv0)[3],((V *)Rv0)[4],11);
                  Ra.sl[10]=2314; /* line # 2314 */
                  ((SL *)Rv20)[11]=Rv21;
                  Ra.sl[10]=2315; /* line # 2315 */
                  if (V_all_fdata==NULL) V_all_fdata=((V *)Rv19)[5];
                  else {
                    Ra.sl[10]=2316; /* line # 2316 */
                    ((V *)V_all_ldata)[0]=((V *)Rv19)[5];
                  }
                  Ra.sl[10]=2317; /* line # 2317 */
                  ((V *)((V *)Rv19)[5])[1]=V_all_ldata;
                  Ra.sl[10]=2318; /* line # 2318 */
                  V_all_ldata=((V *)Rv19)[5];
                  Ra.sl[10]=2319; /* line # 2319 */
                  Rv22=((V *)Rv19)[5];
                  Ra.sl[10]=2321; /* line # 2321 */
                  ((V *)Rv22)[13]=((V *)Rv0)[7];
                  Ra.sl[10]=2322; /* line # 2322 */
                  Rv23=((V *)Rv22)[13];
                  Ra.sl[10]=2323; /* line # 2323 */
                  ((SL *)Rv23)[3]=((SL *)Rv23)[3]+1;
                  Ra.sl[10]=2324; /* line # 2324 */
                  ((V *)Rv22)[10]=F_head;
                  ((V *)Rv22)[11]=F_head;
                }
              }
            }
          }
          Ra.sl[10]=2330; /* line # 2330 */
          if (!((UB *)((V *)Rv0)[3])[91]) {
            Ra.sl[10]=2331; /* line # 2331 */
            if (((UB *)Rv19)[48]!=21) {
              Ra.sl[10]=2332; /* line # 2332 */
              if (!(((V *)Rv19)[5]==NULL)) {
                Ra.sl[10]=2337; /* line # 2337 */
                Rv24=((V *)Rv19)[5];
                Ra.sl[10]=2339; /* line # 2339 */
                if (((V *)Rv24)[10]==NULL) ((V *)Rv24)[10]=F_head;
                else {
                  Ra.sl[10]=2340; /* line # 2340 */
                  ((V *)((V *)Rv24)[11])[1]=F_head;
                }
                Ra.sl[10]=2341; /* line # 2341 */
                ((V *)Rv24)[11]=F_head;
              }
            }
          }
        }
      }
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[2];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " lgt_all_fparm "  */
void P_lgt_all_fparm(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+677;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=2360; /* line # 2360 */
  Rv0=F_pr;
  Ra.sl[6]=2362; /* line # 2362 */
  Rv1=((V *)Rv0)[8];
  Ra.sl[6]=2363; /* line # 2363 */
  while (Rv1!=NULL){
    Ra.sl[6]=2365; /* line # 2365 */
    Rv2=Rv1;
    Ra.sl[6]=2366; /* line # 2366 */
    if (((UB *)Rv2)[56]==7) {
      Ra.sl[6]=2368; /* line # 2368 */
      P_all_new(((V *)Rv2)+10,V_typ_std.v[13],Rv1,9);
      Ra.sl[6]=2369; /* line # 2369 */
      ((V *)((V *)Rv2)[9])[14]=((V *)Rv2)[10];
    }
    else {
      Ra.sl[6]=2373; /* line # 2373 */
      P_all_new(((V *)Rv2)+11,V_typ_std.v[13],Rv1,((UB *)Rv2)[66]);
      Ra.sl[6]=2374; /* line # 2374 */
      if (((V *)Rv2)[4]!=NULL) {
        Ra.sl[6]=2375; /* line # 2375 */
        Rv3=((V *)Rv2)[4];
        Ra.sl[6]=2376; /* line # 2376 */
        if ((!((UB *)Rv3)[91]&&((UB *)Rv2)[66]==8)&&((SL *)Rv3)[11]<0) {
          Ra.sl[6]=2380; /* line # 2380 */
          Rv4=P_lgt_new_idref(Rv1,NULL);
          Ra.sl[6]=2381; /* line # 2381 */
          ((V *)((V *)Rv2)[11])[9]=P_lgt_type_eval(((V *)Rv3)[9],Rv4,NULL,0);
        }
      }
    }
    Ra.sl[6]=2384; /* line # 2384 */
    Rv1=((V *)Rv1)[3];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_all_dynamic "  */
void PAS_LGT_lgt_all_dynamic(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+692;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=2398; /* line # 2398 */
  Rv0=NULL;
  Ra.sl[6]=2399; /* line # 2399 */
  Rv1=F_pr;
  Ra.sl[6]=2401; /* line # 2401 */
  Rv2=((V *)Rv1)[8];
  Ra.sl[6]=2402; /* line # 2402 */
  while (Rv2!=NULL){
    Ra.sl[6]=2404; /* line # 2404 */
    Rv3=Rv2;
    Ra.sl[6]=2405; /* line # 2405 */
    if (((UB *)Rv3)[56]==5&&((V *)Rv3)[11]!=NULL) {
      Ra.sl[6]=2406; /* line # 2406 */
      Rv4=((V *)Rv3)[11];
      Ra.sl[6]=2407; /* line # 2407 */
      if (((V *)Rv4)[9]!=NULL) {
        Ra.sl[6]=2411; /* line # 2411 */
        Rv5=((V *)Rv4)[9];
        Ra.sl[6]=2412; /* line # 2412 */
        if (Rv0==NULL) Rv0=Rv5;
        else {
          Ra.sl[6]=2413; /* line # 2413 */
          ((V *)Rv6)[0]=Rv5;
        }
        Ra.sl[6]=2414; /* line # 2414 */
        Rv6=Rv5;
      }
    }
    Ra.sl[6]=2416; /* line # 2416 */
    Rv2=((V *)Rv2)[3];
  }
  Ra.sl[6]=2420; /* line # 2420 */
  if (Rv0!=NULL) {
    Ra.sl[6]=2422; /* line # 2422 */
    P_lgt_new(&Rv5,NULL,24, Rv0);
    Ra.sl[6]=2424; /* line # 2424 */
    if (((V *)Rv1)[16]==NULL) {
      Ra.sl[6]=2425; /* line # 2425 */
      ((V *)Rv1)[16]=Rv5;
    }
    else {
      Ra.sl[6]=2427; /* line # 2427 */
      Rv7=((V *)Rv1)[16];
      Ra.sl[6]=2428; /* line # 2428 */
      if (((UB *)Rv7)[40]==0&&((UB *)Rv7)[41]==2) {
        Ra.sl[6]=2430; /* line # 2430 */
        ((V *)Rv5)[0]=((V *)Rv7)[1];
        Ra.sl[6]=2431; /* line # 2431 */
        ((V *)Rv7)[1]=Rv5;
      }
      else {
        Ra.sl[6]=2435; /* line # 2435 */
        ((V *)Rv5)[0]=((V *)Rv1)[16];
        Ra.sl[6]=2436; /* line # 2436 */
        P_lgt_new(((V *)Rv1)+16,NULL,0, Rv5);
        Ra.sl[6]=2437; /* line # 2437 */
        ((UB *)((V *)Rv1)[16])[41]=2;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_pass1_complet "  */
void P_lgt_pass1_complet(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+709;
  Ra.v[2]=Rd.s+14;
  Ra.sl[6]=2448; /* line # 2448 */
  V_lgt_inshde=NULL;
  Ra.sl[6]=2449; /* line # 2449 */
  V_lgt_inslst=NULL;
  Ra.sl[6]=2450; /* line # 2450 */
  Rs.sl[10]=0;
  Ra.sl[6]=2451; /* line # 2451 */
  Rs.sl[9]=0;
  Ra.sl[6]=2453; /* line # 2453 */
  Rv0=F_pr;
  Ra.sl[6]=2455; /* line # 2455 */
  ((UW *)Rv0)[8]=((UW *)Rv0)[8]|512;
  Ra.sl[6]=2457; /* line # 2457 */
  V_binline=((UB *)Rv0)[104]==10;
  Ra.sl[6]=2458; /* line # 2458 */
  PAS_LGT_lgt_all_dynamic(F_pr);
  Ra.sl[6]=2459; /* line # 2459 */
  P_lgt_scan(((V *)Rv0)[16]);
  Ra.sl[6]=2460; /* line # 2460 */
  ((SL *)Rv0)[59]=Rs.sl[10];
  PAS__curr_cntx=Ra.v[0];
}
