function BUILD_ARG_LIST( pr: pro_ptr ): lgt_ptr;
{ Function to call a not generic entry (including any formal entry - function or procedure) }
const
  mdnam = 'BARG';

var
  found:               boolean;
  lgt0, lgt1, lgt2:    lgt_ptr;
  pg:                  gen_ptr;
  epr, fpr:            pro_ptr;
  ep, fp:              ide_ptr;

begin { BUILD_ARG_LIST }
  with sy_sym, pr^ do
  begin
    lgt0 := nil;
    fp := pro_parmlst;                                 { Head of formal parameter list }
    if pro_typ <> nil then                             { Function call: skip not simple type result arg. }
      if not pro_typ^.typ_simple then fp := fp^.ide_nxt;
    if fp <> nil then
    begin
      if sy <> lparen then SRC_ERROR( mdnam, 22, e_error)
                      else INSYMBOL                    { Gobble up "(" };
      while fp <> nil do                               { Scan on all parameter definitions }
      begin
        if fp^.ide_class = cla_fentry then
        begin { * Formal Entry ( = procedure or function) }
          found := false;
          fpr := fp^.ide_entry;                        { Get the formal entry definition }
          if sy = identsy then
          begin                                        { Look for specified effective procedure }
            ep := IDE_SEARCH( [cla_varbl,cla_fentry, cla_genwfent, cla_generic] );
            if ep <> ide_udptr[cla_varbl] then
            begin
              { Declared procedure/function or variable }
              with ep^ do

              if ide_class = cla_varbl then            { For effective pointed entry }
              begin
                epr := nil;
                if ide_typ <> nil then
                  with ide_typ^ do                     { Get the effective entry model reference }
                    if typ_form = form_fentry then epr := typ_entry;
                if epr <> nil then
                  { We verify that the parameter list compatibility }
                  if epr^.pro_parmlst <> fpr^.pro_parmlst then   { Not same arg. list }
                    if COMP_PROC_ARG( epr, fpr ) then found := true
                    (* if COMPARE_ENTRY( epr, fpr ) then found := true *)
                                                 else SRC_ERROR_S( mdnam, 120, e_severe, sy_ident )
              end
              else
              if ide_class = cla_fentry then           { For formal entry identifier }
              begin
                epr := ide_entry;                      { Get the effective entry model reference }
                { We verify that the parameter list compatibility }
                if epr^.pro_parmlst <> fpr^.pro_parmlst then   { Not same arg. list }
                  if COMP_PROC_ARG( epr, fpr ) then found := true
                  (* if COMPARE_ENTRY( epr, fpr ) then found := true *)
                                               else SRC_ERROR_S( mdnam, 121, e_severe, sy_ident )
              end
              else
              begin                                    { Generic name is given (cla_genwfent or cla_fentry) }
                pg := COMPARE_PROC_ARGID( ep^.ide_gfirst, ep^.ide_glast, fpr );
                (*
                if pg <> nil then epr := pg^.gen_proc
                             else SRC_ERROR( mdnam, 122, e_severe )
                *)
                pg := ep^.ide_gfirst;
                { We look for a procedure that match with the formal procedure/function parameter list }
                while (pg <> nil) and not found do
                with pg^ do
                begin
                  if not gen_blt then                  { Skip any builtin entry }
                  begin                                { Only the User Procedure can take as effective Procedure. }
                    epr := gen_proc;
                    found := COMP_PROC_ARG( epr, fpr )
                  end;
                  pg := gen_link
                end;
                if not found then SRC_ERROR_S( mdnam, 122, e_severe, sy_ident, fp^.ide_name^ )
              end;
            end;
            INSYMBOL                                   { Gobble up the effective entry name }
          end
          else
          begin                                        { Try default effective entry }
            epr := fp^.ide_defentry;                   { Default entry }
            if epr = nil then SRC_ERROR_S( mdnam, 148, e_severe, fp^.ide_name^ )
            else
              if fpr <> nil then found := COMP_PROC_ARG( epr, fpr )
                            else SRC_ERROR_S( mdnam, 123, e_severe, fp^.ide_name^ )    { Should be never }
          end;
          { Call is possible }
          if found then
          begin
            LGT_NEW( lgt2, epr^.pro_typ, lgt_proref, nil );
            lgt2^.lgt_pro := epr;
            if not COMP_TYPE( epr^.pro_typ, fpr^.pro_typ, false ) then
              SRC_ERROR_S( mdnam, 124, e_severe, ep^.ide_name^, fp^.ide_name^ )
          end
        end                                           { Formal function/procedure }
        else
        begin { Generate the parameter}               { Other formal: formal, rformal, wformal, vformal }
          lgt2 := EXPRESSION_TYPE( fp^.ide_typ, fp^.ide_vkind <> var_vformal );
          with lgt2^ do
            if lgt_kind = lgt_empty then              { No provided argument }
              if fp^.ide_inival = nil then
                { No default value specified for a not given eff. parameter }
                SRC_ERROR_S( mdnam, 854, e_severe, fp^.ide_name^ )
              else
              begin                                   { Set the initial value }
                lgt_kind := lgt_const;
                lgt_typ  := fp^.ide_typ;
                lgt_cte  := fp^.ide_inival;
                VAL_NEW( lgt_cte, nil {unused} );
                lgt_lide := nil
              end
        end;

        { We must link the parameter together }
        if lgt0 <> nil then lgt1^.lgt_nxt := lgt2
                       else lgt0 := lgt2;
        lgt1 := lgt2;

        fp := fp^.ide_nxt;                             { Skip to next formal argument }
        if sy = comma then INSYMBOL
      end                                              { While other defined argument(s) };
      if sy = rparen then INSYMBOL
      else SRC_ERROR( mdnam, 23, e_severe );           { Too many effective arguments }
    end                                                { if a parameter list must be present }
  end;
  BUILD_ARG_LIST := lgt0
end BUILD_ARG_LIST;



