(*
[inherit (   'LIB:BASIC_ENV_STR',	{ string manager }
             'LIB:BASIC_ENV_TXF',	{ text file manager }
             'LIB:BASIC_ENV_LST'),	{ list file manager }
 environment('LIB:BASIC_ENV_SRC')]	{ create the environment file }

module BASIC_ENV_SRC( input,output );	{ use input and output }
*)

{ basic environment for source input operation }

{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*              ---  Source Read  Manager Library  ---                   *
*              ---  Version  2.3-B -- 28/02/2013  ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Louis Neel                                   *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}



%include 'pasenv:cpas_b__lst_env';  { We use the Listing environment and ... }
%include 'pasenv:cpas_b__err_env';  { ... the Error message environment. }


const
  src_maxerrline = 8;               { maximum repported error by line }

type

  { source state mode flag definition }
  src_flagty = (src_blist,          { List on if present }
                src_bmacroex,       { Set for macro expantion listing memory }
                src_bphys,          { Set physical output if present }
                src_bterminal,      { Set if prompt is wanted }
                src_stdin,          { Flag for the console mode (the Pascal file is input) }
                src_becho,          { Set echo mode if present }
                src_echerr,         { Set error echo on control terminal }
                src_delete,         { Set if delete on close in required }
                src_toolong,        { Set if present line is too long }
                src_macro,          { Set if macro file }
                src_linemode,       { Set if data mode is wanted }
                src_listbyline,     { Set if line output on eoln reached }
                src_commentflg,     { Set if only spaces or comments ...
                                      ... found in line }
                src_eolcomment,     { Set for eoln => end of comment }
                src_eoln,           { Set if end of line seen in data mode }
                src_eofrc,          { Set if end of file reached
                                      (at end of last line) }
                src_eof,            { Eof seen if set,
                                      (but the last line can be no finished) }
                src_userflg1,       { User flag 1, 2, 3 and 4 }
                src_userflg2,
                src_userflg3,
                src_userflg4);

  src_comty = ( src_pascomment,     { Pascal comment handling }
                src_plicomment,     { PL/1 and C comment handling }
                src_adacomment,     { Ada comment handling }
                src_lispcomment,    { Lisp comment handling }
                src_nocomment);     { Comment support disable }

  src_flagw = set of src_flagty;    { Flag word for source }

  src_ptr = ^src_context;           { Source context pointer definition }

  src_context = record              { Source context definition }
    src_next,                       { Link to next source }
    src_previous:  src_ptr;     { Previous source in command sequence }
    src_wchpt,                  { Word pointer in src_cmdline }
    src_chidx,                  { Character pointer in src_cmdline }
    src_insnb,                  { Source instruction count }
    src_level,                  { Source level for listing }
    src_lstmxlev,               { Source listing level }
    src_errnb,                  { Number of error in the current line }
    src_linenbr,                { Line number in this file }
    src_frspos,                 { First valid column to use }
    src_lstpos:    integer;     { Last valid column to use }
    src_lastchar,               { Last valid character }
    src_fchcd,
    src_schcd:     char;        { First and second character code }
    src_coltb: array[1..src_maxerrline] of
		   error_entry; { Column table error entry }
    src_flags:     src_flagw;   { Source status flag set }
    src_commentty: src_comty;   { Mode for comment handling }
    src_cmdline,                { Commande line }
    src_prompt:    str_ptr;     { Prompt to use if terminal file }
    src_promptf,                { Prompt file if not output }
    src_file: text              { Text file to use, if not input }
  end;


var
  def_prompt:   [external] str_ptr; { default prompt }

  src_maxerror,                     { Maximum number of error before compiler stop }
  src_lstinsnb: [external] integer; { last instruction number }

  src_control,                      { current source file pointer }
  src_cont_base,                    { basis source file pointer }

  src_hde:     [external] src_ptr;  { used source list header }

  src_listing: [external] lst_ptr;  { listing and error source file pointer }




{**********************************************************}
{**********    SRC ENTRY POINTS DEFINITIONS     ***********}
{**********************************************************}


function  SRC_ALLOCATE: src_ptr;
external;


procedure SRC_FREE( p: src_ptr );
external;


procedure SRC_CLOSE( var p: src_ptr; bfree: boolean );
external;


procedure SRC_OPEN( var       p: src_ptr; in_var fspc: string;
                        bdelete: boolean;    var ierr: integer );
{ open a source file }
{ p is the pointer of source context, fspc is the file specification }
{ ierr is the return error code }
{ src_open allocate the source context if p = nil 
  and close a previously opened file }
{ if bdelete is true the file is set for delete on close time }
external;





{******************************************************}
{*********    error managment procedures  *************}
{******************************************************}


procedure SRC_ERROR(    modnam: error_mdnam;
                        number:     integer;
                      severity: error_sev );
{ to set an error in src processing }
{ must be called for all source errors }
external;


procedure SRC_OUT_MAC_ERROR( procedure OUT_MAC_LINE( var f: text; btt: boolean ) );
{ procedure to output all error messages }
{ For any macro error management }
external;






{******************************************************}
{*******   input line managment procedures  ***********}
{******************************************************}


procedure SRC_GET_INPUTLINE( var f: text; var pstr: str_ptr );
{ Get a line from the specified file }
external;


procedure SRC_PUT_PROMPT( pstr: str_ptr );
{ Generate a string output on the prompt file }
external;


procedure SRC_END_OF_LINE;
{ procedure to output a line with all appropriate  error messages }
{ to called by src_inchar }
external;


function SRC_INCHAR: char;
{ can be used for real (terminal or other device) file text }
{ to get one character from input }
external;


function SRC_NEXT_CHAR: char;
{ can be used to inspect the next character without change the current one }
external;


function SRC_SEARCH_CHAR: char;
{ can be used to look for a following no space character without
  change the current one, until the end of line }
external;



{*******************************************************}
{*********    common initialization routine    *********}
{*******************************************************}

procedure SRC_INIT( in_var def_prt, def_src: string );
{ common command source initialization routine }
{ must be called after lst_txf_st_init procedure(s).
  this call open the default listing file as current listing,
  here we assume that this current file is the output error message file.
}
external;



(*
end.
*)
