(*
[inherit (   'LIB:BASIC_ENV_STR',	{ string manager }
             'LIB:BASIC_ENV_TXF',	{ text file manager }
             'LIB:BASIC_ENV_LST'),	{ list file manager }
 environment('LIB:BASIC_ENV_SRC')]	{ create the environment file }

module BASIC_ENV_SRC( input,output );	{ use input and output }
*)

{ basic environment for source input operation }

{
    by :
	P. WOLFERS
	Laboratoire de cristallographie C.N.R.S.,
	B.P. 166 X 38042 GRENOBLE CEDEX
				 FRANCE


}

type

  { severity degrees definition }
  error_sev = ( e_success,
                e_warning,
                  e_error,
                 e_severe,
                  e_fatal
              );

  { severity error count definion }
  error_tbcnt = array[e_success..e_fatal] of integer;


  { module name definition }
  error_mdnam = packed array[1..4] of char;


  { source error entry definition }
  error_entry = record
    err_pos,                    { shift in char from the previous error
                                  on the same line }
    err_code: integer;          { error code }
    err_sv:   error_sev;        { error severity }
    err_mdn:  error_mdnam;      { compiler detector module name }
    err_msg:  ^string           { error message string address }
  end;



var

  usr_err_flg:      [external] boolean;     { user error file setting flag }

  usr_err_file_spc,                         { user error message file specif. }
  msg_err_file_spc: [external] string(128); { meaning error msg file specif. }

  error_result:     [external] error_sev;   { error severity final note }
  error_cnt:	    [external] error_tbcnt; { total error count }





{******************************************************}
{*********    error managment procedures  *************}
{******************************************************}


procedure ERR_PUT_SYMBOL( in_var symb: packed array[len:integer] of char );
{ To specify a symbol to insert in the error message }
external;


procedure ERR_CLR_SYMBTAB;
{ To Clear the message symbol table }
external;


procedure ERR_GETMSG( var erren: error_entry );
{ To get an informative line related to the error code <n> }
{ No effect if the error entry is not find or if open fails }
external;




procedure ERR_DISPLAY( var f: text; ie: integer; var erren: error_entry );
{ display one error message on the current listing file }
{ it is assumed that the message length is <= 80 characters }
external;



{*******************************************************}
{*********    common initialization routine    *********}
{*******************************************************}

procedure ERR_INIT( in_var errf_str: string );
{ common command source initialization routine }
{ must be called after lst_txf_st_init procedure(s).
  this call open the default listing file as current listing,
  here we assume that this current file is the output error message file.
}
external;



(*
end.
*)
