{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*             ---  Source Error Message Generator  ---                  *
*              ---  Version  2.2--A -- 31/06/2010 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Laboratoire de Cristallographie                       *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
[inherit ('LIB:BASIC_ENV_STR',		{ String manager def. }
          'LIB:BASIC_ENV_TXF',		{ Text file manager def. }
          'LIB:BASIC_ENV_LST',		{ List file manager def. }
          'LIB:BASIC_ENV_SRC')]		{ Source file manager def. }
*)

module BASIC_SRC( input,output );	{ Use input and output }


{ Basic environment for source input operation }

{
    by :
	P. WOLFERS
	Laboratoire de cristallographie C.N.R.S.,
	B.P. 166 X 38042 GRENOBLE CEDEX
				 FRANCE


}

const
  errsymb_max  =     4;                 { Maximum number of a symbol in an error message }
  errsymb_msz  =    32;                 { Maximum size of a symbol in an error message }

type

  { Severity degrees definition }
  error_sev = ( e_success,
                e_warning,
                  e_error,
                 e_severe,
                  e_fatal
              );

  { Severity error count definion }
  error_tbcnt = array[e_success..e_fatal] of integer;


  { Module name definition }
  error_mdnam = packed array[1..4] of char;


  { Source error entry definition }
  error_entry = record
    err_pos,                            { Shift in char from the previous error on the same line }
    err_code: integer;                  { Error code }
    err_sv:   error_sev;                { Error severity }
    err_mdn:  error_mdnam;              { Compiler detector module name }
    err_msg:  ^string                   { Error message string address }
  end;

var

  usr_err_flg:        [global] boolean;         { User error file setting flag }

  usr_err_file_spc,                             { User error message file specif. }
  msg_err_file_spc: [global] string(128);       { Meaning error message file specif. }

  error_result:     [global] error_sev;         { Error severity final note }
  error_cnt:	  [global] error_tbcnt;         { Total error count }

  { Symbol table for message edition definitions }
  errsymb_tab:  [global] array[1..errsymb_max,0..errsymb_msz] of char;
  errsymb_cnt: [global] 0..errsymb_max;





procedure PAS__ERROR_GETMSG(          n:            integer;
                             var msgstr:            string;
                             var msgfil: [readonly] string );
external 'PAS__ERROR_GETMSG';



{******************************************************}
{*********    Error managment procedures  *************}
{******************************************************}


[global]
procedure ERR_PUT_SYMBOL( in_var symb: packed array[len:integer] of char );
var
  length: integer;

begin
  if (errsymb_cnt < errsymb_max) and (len > 0) then
  begin
    errsymb_cnt := SUCC( errsymb_cnt );
    length := len;
    if length > errsymb_msz then length := errsymb_msz;
    errsymb_tab[errsymb_cnt,0] := CHR( length );
    for i := 1 to length do
      errsymb_tab[errsymb_cnt,i] := symb[i]
  end
end ERR_PUT_SYMBOL;



[global]
procedure ERR_CLR_SYMBTAB;
begin
  errsymb_cnt := 0
end ERR_CLR_SYMBTAB;



[global]
procedure ERR_GETMSG( var erren: error_entry );
{ To get an informative line related to the error code <n> }
{ no effect if the error entry is not find or if open fails }
const
  chflg = '`'; { Character to use for symbol insertion }

var
  buf0, buf1: string( 255 );
  n, i, j, k: integer;
  ch:         char;

begin { ERR_GETMSG }
  n := erren.err_code;         { Get error code }
  if errsymb_cnt > 0 then
  begin
    { Open the message error file }
    if usr_err_flg then PAS__ERROR_GETMSG( n, buf0, usr_err_file_spc )
                   else PAS__ERROR_GETMSG( n, buf0, msg_err_file_spc );

    { If a message is get }
    j := 0;
    if buf0.length > 0 then
    begin
      i := 0; k := 0;
      while (i < buf0.length) and (j < buf1.capacity) do
      begin
        i := SUCC( i ); ch := buf0[i];
        if ch = chflg then
        begin                  { We must insert a symbol }
          k := SUCC( k );
          if k <= errsymb_cnt then
            for l := 1 to ORD( errsymb_tab[k,0] ) do
              if j < buf1.capacity then
              begin
                j := SUCC( j ); buf1[j] := errsymb_tab[k,l]
              end
        end
        else
        begin
          j := SUCC( j ); buf1[j] := ch
        end
      end
    end;
    buf1.length := j;
    errsymb_cnt := 0
  end
  else
    { When no symbol to insert in the message }
    if usr_err_flg then PAS__ERROR_GETMSG( n, buf1, usr_err_file_spc )
                   else PAS__ERROR_GETMSG( n, buf1, msg_err_file_spc );

  { Prepare the final message by symbol include }
  if buf1.length > 0 then
  with erren do
  begin
    if err_msg <> nil then DISPOSE( err_msg );
    NEW( err_msg, buf1.length );
    err_msg^ := buf1
  end
end ERR_GETMSG;


[global]
procedure ERR_DISPLAY( var f: text; ie: integer; in_var erren: error_entry );
{ display one error message on the current listing file }
{ it is assumed that the message length is <= 80 characters }
var
  bmg: boolean := false;

begin { ERR_DISPLAY }
  with erren do
  begin
    WRITE( f, ' (', ie:1, ') - A' );
    case err_sv of
      e_success: ;
      e_warning: WRITE( f, ' warning' );
      e_error:   WRITE( f, 'n error' );
      e_severe:  WRITE( f, ' severe error' );
      e_fatal:   WRITE( f, ' fatal error' )
    end;
    WRITELN( f, ' # ', err_code:5, ' is detected by the ',
                       err_mdn, ' module.' );
    if err_msg <> nil then
      WRITELN( f, ' %*+*+* ', err_msg^ )
    else WRITELN( f )
  end
end ERR_DISPLAY;





{*******************************************************}
{*********     error initialization routine    *********}
{*******************************************************}


[global]
procedure ERR_INIT( in_var errf_str: string );
{ common command source initialization routine }
{ must be called after lst_init procedure.
  this call open the default listing file as current listing,
  here we assume that this current file is the output error message file.
}
begin { ERR_INIT }
  msg_err_file_spc := errf_str	{ Set meaning error message file specif. };
  usr_err_file_spc := '';
  usr_err_flg := false;         { No user error message }
  { Initialize error sub_system }
  errsymb_cnt := 0;
  for error_result := e_success to e_fatal do
    error_cnt[error_result] := 0;
  error_result := e_success
end ERR_INIT;

end.
