{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *              ---  Random Number Generator ---              *
     *  ---  from Numerical Recipes in C Chapter 7, page 280 ---  *
     *    ---  Second Edition - Cambridge University Press ---    *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Laboratoire de Cristallographie                    *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

%pragma trace 0;
module RANDOM_0;
{
  Extract from :


           NUMERICAL RECIPS in C

 William H. Press          Saul A. Teukolsky

 William T. Vetterling     Brain P. Flannery


           Second Edition

     Cambridge  University Press


 At page 280 :

  "Minimal" Random number generator of Park and Miller  with Bays-Durham shuffle
  and  added safeguards.  Returns a  uniform random deviate  in range [0.0,1.0[.
  Call with idum a negative integer to initialize; thereafter, do not alter idum
  between successive deviates in a sequence. rnmx should approximate the largest
  floating value thatn is less than 1.


  Translate in C-Pascal and includes inside the standard C-Pascal Library.
  by P. Wolfers, Institut Neel, CNRS, Grenoble, FRANCE.

  *** Last Revision of C-Pascal Version 31-Oct_2010 ***

     -- Define a global table of Random generator status to enable the user to
  save and/or restore the generator state.

}
const
  IA   =        16807;
  IM   =   2147483647;
  AM   =       1.0/IM;
  iQ   =       127773;
  IR   =         2836;
  NTAB =           32;
  NDIV =  1 + (IM - 1) div NTAB;
  EPS  =       1.2E-7;
  RNMX =    1.0 - eps;


var
  [global 'PAS__RanState'] iv: array[0..NTAB] of integer
                               := [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];



[global 'PAS__RANDOM']
function RANDOM_1( var idum: integer ): single;
var
  j, k:        integer;
  tmp:          single;

begin
  if (idum <= 0) or (iv[NTAB] = 0) then
  begin { Initialization }
    if idum > -1 then idum := 1         { Be sure to prevent id = 0 }
                 else idum := -idum;
    j := NTAB + 7;                      { Load the shuffle table (after 8 warm-ups) }
    repeat
      k  := idum div IQ;
      idum := IA*(idum - k*IQ) - IR*k;
      if idum < 0 then idum := idum + IM;
      if j < NTAB then iv[j] := idum;
      j := j - 1
    until j < 0;
    iv[NTAB] := iv[0]
  end;
  k  := idum div IQ;                    { Start here when not initializing }
  idum := IA*(idum - k*IQ) - IR*k;      { Compute idum = (IA*id) div IM without ... }
  if idum < 0 then idum := idum + IM;   { ... overflow by Schrage's method }
  j  := iv[NTAB] div NDIV;              { will be in the range 0..ntab-1. }
  iv[NTAB] := iv[j];                    { Output previously stored value and ... }
  iv[j] := idum;                        { ... refill the shuffle table. }
  tmp := AM*iv[NTAB];                   { And normalize in a floatting value. }
  if tmp > RNMX then RANDOM_1 := RNMX   { The user don't expect  endpoint value. }
                else RANDOM_1 := tmp
end RANDOM_1;



end.
