{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*                     ---  RUN-TIME KERNEL  ---                         *
*               ---  C Library Link Definitions  ---                    *
*               ---  Version  3.1-A - 30-11-2014 ---                    *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 C.N.R.S.                                              *
*                 Institut Neel                                         *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
%pragma trace 0; { Always here: called by PAS__ERROR to don't loop }
%pragma code_option c_code '#define BASIC_IO   0';
module CPAS__STD;
*)

%pragma code_option (c_interface, { To authorize the use of "standard" keyword }
    c_code '#include <sys/stat.h>',
    c_code '#define incr_ptr(p,inc) p += inc;',
    c_code '#define cc_wild_pointer( p ) ((V) p)',
    c_code '#define _Open(fn,fl,md) open((char *)(fn),fl,md)',
    c_code '#define _Openr(fn,fl,md) open((char *)(fn),fl,md,"rat=cr","rfm=var")',
    c_code '#define _Remove(fn) remove((char *)(fn))',
    c_code '#define _Getenv(lg) (C *)getenv((char *)(lg))',
    c_code '#define _Setenv(lg,vl,isp) setenv((char *)(lg),(char *)(vl),isp)',
    c_code '#define _UnSetenv(lg) unsetenv((char *)(lg))',
    c_code '#define _Putenv(lgl) putenv((char *)(lgl))',
    c_code '#define _Chdir(dir) chdir((char *)dir)',
    c_code '#define _Getdir(dir,sz) (C *)getcwd((char *)(dir),(size_t)(sz))',
    c_code '#define _Execv(f,p) execv((char *)(f),(char **)(p))',
    c_code '#define _Execvp(f,p) execvp((char *)(f),(char **)(p))',
    c_code '#define _Execve(f,p,e) execve((char *)(f),(char **)(p),(char **)(e))',
    c_code '#define _System(cm) system((char *)(cm))',
    c_code '#define _Pipe(chan) pipe((int *)(chan))',
    c_code '#define _Wait(proc) wait((int *)(proc))',
    c_code '#define _GetUid getuid',
    c_code '#define _GetGid getgid',
    c_code '#define _Access(f,acc) access((char *)(f),acc)',
    c_code '#define _Rename(o,n) rename((char *)(o),(char *)(n))',
    c_code '#define _Opendir( dn ) (void *) opendir( (char *)(dn))',
    c_code '#define _Closedir( df ) closedir( (DIR *) df )',
    c_code '#define _Readdir( df ) (void *) readdir( (DIR *)(df))',
    c_code '#define _ReadLink( l, t, s ) readlink( (char*) l, (char*) t, s )',
    c_code '#define _MakeDir( d, m ) mkdir( (char*) d, m )',
    c_code '#define _RemoveDir( d ) rmdir( (char*) d )',
    c_code '#define _Ttyname( df ) (C *)ttyname( df )'
  );

{******** I/O definitions for CPAS__STD.PAS **********}

const
  cc__int_size = cc__int"size*8;  { Size of the standard C int type in bits }


type
  cc__setty = set of 0..cc__int_size-1 use cc__int_size;

  cc__char_array    = packed array[1..4096] of char; { The specified dim. is not used }

  cc__char_ptr      = ^cc__char_array;

  cc__parprocess_tb = array[0..mxpar_process] of cc__char_ptr;


var
{
  [external 'CC__OPEN_FLAGS'] cc__open_fltab: array[cc_open_values] of cc__setty;
}

  [standard 'O_TEXT']   cc_wnt__text,          { Special for WNT system }
  [standard 'O_BINARY'] cc_wnt__binary,        { Special for WNT system }

  [standard 'F_OK']     cc__f_ok,              { File is existing }
  [standard 'X_OK']     cc__x_ok,              { File ok to execute }
  [standard 'W_OK']     cc__w_ok,              { File ok to write/delete/update }
  [standard 'R_OK']     cc__r_ok,              { File ok to read }

  [standard 'O_RDONLY'] cc__o_rdonly,
  [standard 'O_WRONLY'] cc__o_wronly,
  [standard 'O_RDWR']   cc__o_rdwr,
  [standard 'O_NDELAY'] cc__o_ndelay,          { IGNORED with PIPE }
  [standard 'O_APPEND'] cc__o_append,          { IGNORED with PIPE }
  [standard 'O_CREAT']  cc__o_creat,           { DO NOT USE with PIPE }
  [standard 'O_TRUNC']  cc__o_trunc,           { DO NOT USE with PIPE }
  [standard 'O_EXCL']   cc__o_excl: cc__setty; { DO NOT USE with PIPE }

  [standard 'SEEK_SET'] cc__seek_set,
  [standard 'SEEK_CUR'] cc__seek_cur,
  [standard 'SEEK_END'] cc__seek_end: cc__int;

  [standard '_P_OVERLAY'] wnt_overlay,
  [standard '_P_WAIT']    wnt_wait,
  [standard '_P_NOWAITO'] wnt_nowaito,
  [standard '_P_NOWAIT']  wnt_nowait: cc__int;



  { Define Routine/macro to get the File/device Category }

  function TEST_ISLNK( md: cc__int ): cc__int; standard 'S_ISLNK';
  function TEST_ISREG( md: cc__int ): cc__int; standard 'S_ISREG';
  function TEST_ISDIR( md: cc__int ): cc__int; standard 'S_ISDIR';
  function TEST_ISCHR( md: cc__int ): cc__int; standard 'S_ISCHR';
  function TEST_ISBLK( md: cc__int ): cc__int; standard 'S_ISBLK';

  function TEST_ISFIFO( md: cc__int ): cc__int; standard 'S_ISFIFO';
  function TEST_ISSOCK( md: cc__int ): cc__int; standard 'S_ISSOCK';


{ Define all our system and cpas__clib.c Entries }


procedure INCR_PTR( p: $wild_pointer; inc: integer ); standard 'incr_ptr';


function  MEM$$ALLOC( size: cc__int ): $wild_pointer; standard 'PAS__MEM_ALLOC';


procedure MEM$$FREE( p: $wild_pointer ); standard 'PAS__MEM_FREE';


function  POINTER_TO_W( p: $wild_pointer ): $wild_pointer; standard 'cc_wild_pointer';


function CC__ERROR: cc__int; external 'CC_ERROR';


function CC__OPEN( filespc: $wild_pointer;     { The filename specification }
                     flags: cc__setty;         { Open type flags }
                     modes: cc__int            { Protection modes }
                 ): cc__int;                   { Return FILE DESCRIPTOR NUMBER }
standard '_Open';


function CC__OPENR( filespc: $wild_pointer;    { The filename specification }
                      flags: cc__setty;        { Open type flags }
                      modes: cc__int           { Protection modes }
                 ): cc__int;                   { Return FILE DESCRIPTOR NUMBER }
standard '_Openr';


function CC__CLOSE( fil: cc__int ): cc__int;   { Return ERROR CODE }
standard 'close';


function CC_GET_FILE_INFO(       fs: $wild_pointer;
                            var tbi: array[sz: cc__int] of cc__int;
                           lnk, gmt: boolean ): cc__int;
external 'CC_Get_File_Info';


function CC_GET_FILE_SINF(       fs: $wild_pointer;
                            var tbi: array[sz: cc__int] of cc__int;
                           lnk, gmt: byte_unsigned ): cc__int;
external 'CC_Get_File_Info';


function CC_GET_DESCR_INFO(    descr: integer;
                             var tbi: array[sz: cc__int] of cc__int;
                            lnk, gmt: boolean ): cc__int;
external 'CC_Get_Descr_Info';


function CC__GET_UID: cc__int; standard '_GetUid';

function CC__GET_GID: cc__int; standard '_GetGid';

function CC__ACCESS( fs: $wild_pointer; acc: cc__setty {* File spc. and access to check *}
                  ): cc__int;
standard '_Access';

function CC__RENAME( oldf, newf: $wild_pointer {* The old and new file specifications *}
                  ): cc__int;
standard '_Rename';

function CC__REMOVE( filespc: $wild_pointer    {* The filename specification *}
                  ): cc__int;                  { Return ERROR CODE }
standard '_Remove';


function CC__GETENV( lognam: $wild_pointer ): $wild_pointer;
standard '_Getenv';


function CC__CHDIR( dirpath: $wild_pointer ): cc__int;
standard '_Chdir';


function CC__GETDIR( dirpath: $wild_pointer; sz: integer ): $wild_pointer;
standard '_Getdir';


function CC__SETENV( lognam,
                     logval: $wild_pointer;
                        isp: cc__int ): cc__int;
standard '_Setenv';


procedure CC__UNSETENV( lognam: $wild_pointer );
standard '_UnSetenv';


function CC__PUTENV( logrel: $wild_pointer ): cc__int;
standard '_Putenv';


function CC__READ( fil: cc__int;               { FILE DESCRIPTOR NUMBER }
                   buf: $wild_pointer;         { READ BUFFER ADDRESSE }
                    ns:  cc__int               { MAXIMUM NUMBER of BYTES READ }
                 ): cc__int;                   { Return REAL NUMBER of BYTES READ }
standard 'read';


function CC__WRITE( fil: cc__int;              { FILE DESCRIPTOR NUMBER }
                    buf: $wild_pointer;        { WRITE BUFFER ADDRESSE }
                     ns:  cc__int              { MAXIMUM NUMBER of BYTES WRITE }
                  ): cc__int;                  { Return REAL NUMBER of BYTES WRITE }
standard 'write';


function CC__WRITE( fil: cc__int;              { FILE DESCRIPTOR NUMBER }
             in_var str: packed array[ns: cc__int] of char     { WRITE a string }
                  ): cc__int;                  { Return REAL NUMBER of BYTES WRITE }
standard 'write';


function CC__SEEK( fil,
                   ofs,
                    nd: cc__int ): cc__int;
standard 'lseek';


function CC__ISATTY( fil: cc__int ): cc__int;
standard 'isatty';


function CC__TTYNAME( fil: cc__int ): $wild_pointer;
standard '_Ttyname';


procedure CC__EXIT( icd: cc__int := 1 );
standard 'exit';


function CC__FORK: cc__int;
standard '_Fork';


function CC__EXECV(        prg: $wild_pointer;
                    in_var pal: cc__parprocess_tb ): cc__int;
standard '_Execv';


function CC__EXECVP(       prg: $wild_pointer;
                    in_var pal: cc__parprocess_tb ): cc__int;
standard '_Execvp';


function CC__EXECVE(       prg: $wild_pointer;
                    in_var pal: cc__parprocess_tb;
                           pen: $wild_pointer ): cc__int;
standard '_Execve';


{  *** Windows NT Function  *** }
function CC__SPAWNV(         mode: cc__int;
                             prg: $wild_pointer;
                      in_var pal: cc__parprocess_tb ): cc__int;
standard '_spawnv';


{  *** Windows NT Function  *** }
function CC__SPAWNVE(       mode: cc__int;
                            prg: $wild_pointer;
                     in_var pal: cc__parprocess_tb;
                            pen: $wild_pointer ): cc__int;
standard '_spawnve';


function CC__WAIT( var p: cc__int ): cc__int;  { WAIT and CHECK status of CHILD }
standard '_Wait';


{  *** Windows NT Function  *** }
function CC__CWAIT( var p:   cc__int;          { WAIT and CHECK status of pid proc. }
                        pid: cc__int;
                        pac: cc__int ): cc__int;
standard '_cwait';


function CC__PIPE( p: $wild_pointer ): cc__int;        { Array of FILE DESCRIPTOR }
standard '_Pipe';


{  *** Windows NT Function  *** }
function CC__PIPE( pip: $wild_pointer;         { Pipe descriptor pointer }
                   psz:    cc__int;            { PIPE system Buffer size }
                   tmd: cc__setty ): cc__int;  { Array of FILE DESCRIPTOR }
standard '_pipe';


function CC__DUP2( desc1, desc2: cc__int       { FILE DESCRIPTOR being DUPLICATED }
                ): cc__int;                    { Return the NEW FILE DESCRIPTOR }
standard 'dup2';


function CC__DUP( fdescr: cc__int              { FILE DESCRIPTOR being DUPLICATED }
                ): cc__int;                    { Return the NEW FILE DESCRIPTOR }
standard 'dup';


function CC__OPENDIR( dispc: $wild_pointer     { The Directory name }
                    ): $wild_pointer;          { The returned dir. file pointer }
standard '_Opendir';


function CC__CLOSEDIR( pdir: $wild_pointer     { The Directory file pointer }
                     ): cc__int;               { The success code }
standard '_Closedir';


function  CC__READDIR( pdir: $wild_pointer     { The Directory file pointer }
                     ): $wild_pointer;         { The structure }
standard  '_Readdir';


function  CC__READLINK( lnk, trg: $wild_pointer; sz: cc__int ): cc__int;
standard  '_ReadLink';                         { To read a symbolic link }


function  CC__MKDIR( dspc: $wild_pointer;      { The Directory name }
                     modes: cc__int            { The protection mode }
                   ): cc__int;                 { The returned The success code }
standard '_MakeDir';


function  CC__RMDIR( dspc: $wild_pointer       { The Directory name }
                   ): cc__int;                 { The returned dir. file pointer }
standard '_RemoveDir';


function  CC__SYSTEM( prg: $wild_pointer ): cc__int;
standard '_System';


procedure CC__TRAP_INIT; external 'CC_TRAP_INIT';

%pragma code_option noc_interface;             { To disable usage of "standard" keyword }

