// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Environment of Service routines/object.
//


#ifndef SERVICE_UTIL_H
#define SERVICE_UTIL_H





#ifndef DIR_SEPAR
#   if defined(WIN32) || defined(__EMX__) && !defined(__CYGWIN__)
#       define DIR_SEPAR '\\'
#   else
#       define DIR_SEPAR '/'
#       define O_BINARY 0
#   endif
#endif

#if !(defined(WIN32) || defined(__EMX__) && !defined(__CYGWIN__))
# define O_BINARY 0
#endif


// Convention for path list (same for all O.S.) :

#define DEV_SEPAR ':'
#define PAT_SEPAR ','

//
// Define some common types.
//
typedef unsigned  char   UChar; // Our insigned character or unsigned 8 bits.
typedef unsigned short  UInt16; // Our Insigned 16 bits.
typedef unsigned   int  UInt32; // Our Insigned 32 bits.
typedef            char  SChar; // Our signed character or signed 8 bits.
typedef          short  SInt16; // Our Signed 16 bits.
typedef            int  SInt32; // Our Signed 32 bits.
typedef         void *  ObjPtr; // Define a pointer a undefined object.


extern const char    UserEnv[], // Path to DiaViewer setup file(s).
                     UserDir[], // Path directory of the user.
                  DiaEnvFile[]; // DiaViewer Setup main filename.


//
// **********************************************************************************
//



//
// class VarString to manage temporary string allocations/free.
//

class VarString {
    
private:

    int       use_, all_, cop_; // Used and allocated size.
    char                * str_; // String pointer.


public:

    VarString( int cp = 0 ) { use_ = all_ = 0; cop_ = cp; str_ = 0; }
    ~VarString() { if (str_) delete[] str_; }

    char * String() { return str_; }

    char * Size( int );
    int    Len() { return use_; }
    void   Len( int l ) { use_ = (l < all_)? use_ = l : use_ = all_; }

    void Clear() { if (str_) delete str_; use_ = 0; }

};




//
// **********************************************************************************
//



//
// Class FilePath to manage a dynamic file path.
//

class FilePath {

private:
    char   * path_;
    int    length_,
           allsiz_;
    int   * stack_;
    int   sl_, sp_;

    void BuiltIter( const char * );
 
public:
    FilePath() { path_ = 0; length_ = allsiz_ = sl_ = 0; sp_ = -1; stack_ = 0; }
    ~FilePath();

//  void         StackSize( int );
    int          Set( const char *, int = 0 );
    int          Rem();
    void         Clear();
    const char * Path() { return path_; }
    int          Length() { return length_; }
    int          PathSearch( const char *, const char * = 0 );
    
};


//
// **********************************************************************************
//




class ObjTable {
private:
    int           use_, // Used size.
                  all_; // Allocated size.
    ObjPtr      * tab_; // The table of object pointer.

public:
    void Clean() { if (tab_) delete[] tab_; use_ = all_ = 0; tab_ = NULL; }

    // Object table creator.
    ObjTable() { use_ = all_ = 0; tab_ = 0; }
    // Object table destructor.
    ~ObjTable() { Clean(); }

    ObjPtr GetObj( int i ) { return (((i>=0)&&(i<use_))? tab_[i] : 0); }

    // Routine to get a table access from the specified index.
    ObjPtr * GetObjs( int shf = 0 );

    int TabUse() {return use_;} // To get the current used table length.

    int       AddObj( ObjPtr ); // Append a new object at the table.

    void   Tamp( int idx = 0 ); // To tamp the object table with some null reference(s).

    void      RemObj( ObjPtr ); // Remove an object from the table.
    void         RemObj( int );

    int  Push( ObjPtr o ) { return AddObj( o ); }
    
    ObjPtr Pop() { ObjPtr p = 0; if (use_) { p = tab_[use_]; tab_[use_--] = 0; } return p; }

};




#endif

//
// end of <PW-Id>.
//
