//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Module to print an Image (with context data).
//
//


#include <stdio.h>
#include <string.h>
#include <math.h>

#include <FL/Fl.H>
#include <FL/Fl_Printer.H>
#include <FL/fl_draw.H>

#include "Service_PrImg.h"



int Smp_Printer::Print_Widget( Fl_Widget * w, float ww, float hh )
{
    // When specified hw and hh are the sizes of GL space to print.

    Smp_Printer * lpt = new Smp_Printer();
    int      pw,    ph;
    float   sw, sh, ss;
    int nw, nh, ox, oy;

    if (lpt->start_job( 1 )) return 0;
    lpt->start_page();
    lpt->printable_rect( &pw, &ph );
    if (ww > 0.0 && hh > 0.0) {
        // Make a special frame :
        sw = float( pw )/ww; sh = float( ph )/hh;
        ss = (sh < sw)? sh : sw;
        lpt->scale( ss );
        lpt->printable_rect( &nw, &nh );
        lpt->origin( (nw - w->w())/2, (nh - w->h())/2 );
        lpt->print_widget( w );
    } else {
        sw = float( pw )/w->w(); sh = float( ph )/w->h();
        ss = (sh < sw)? sh : sw;
        lpt->scale( ss );
        lpt->print_widget( w );
    }
    lpt->end_page();
    lpt->end_job();
    return -1;
} // Smp_Printer::WidgetPrint( Fl_Widget * w ).




//
// end of <PW-Id>.
//
