//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to manage the Image file for OpenGL.
//


#ifndef IMAGEMAN_MAP
#define IMAGEMAN_MAP


#ifdef LARGE_UNI_IDENT

# define L64IDENT
# define IDE_LENGTH 64

typedef long long unsigned IIde_t;

#else

# define L32IDENT
# define IDE_LENGTH 32

typedef unsigned IIde_t;

#endif



#include <GL/gl.h>      // To use the GL integer and float types.




static const GLint Max_Size = 0x40000000;



class Image_MAP {
    
public:
    
    static const int ERR_NO_RANGE    = -1;
    static const int ERR_FILE_ACCESS = -2;
    static const int ERR_FORMAT      = -3;
    static const int ERR_FILENAME    = -4;
    
private:
    IIde_t        ide_; // Unique Image identifier.
    GLint       w_, h_, // Sizes of image in pixels.
                p_, e_, // Pixel size(in byte) and Extra data for image.
                  all_; // Allocated size of the map.
    GLubyte     * map_; // GL compatible pixel map.


    void Get_BMP( const char* );

    void Get_PNG( const char* );
    void Get_PNG( const unsigned char*, int );
    void Load_PNG_( const char*, const uchar*, int );
    
    void Get_JPG( const char * );
    void Get_JPG_MEM( const uchar * );


    void Put_BMP( const char* );
    void Put_PNG( const unsigned char* );
    void Put_JPG( const char* );


public:

    // Very elementary creators.
    Image_MAP();
    

    // ALlocate or Reallocate a Pixel MAP.
    GLubyte * New_Map( GLint );

    // To Read and instal an image in a cache element.
    int  Read(  const char * );
    int  Load(  const uchar * );
    int  Write( const char *, int = 0 );

//
// Functions to read each image format.
//
    
    void Ide( IIde_t ide ) { ide_ = ide; }

    // Methodes to assign each Field.
    void W( GLint w ) { w_ = w; }
    void H( GLint h ) { h_ = h; }
    void P( GLint p ) { p_ = p; }
    void E( GLint e ) { e_ = e; }
    void Map( GLubyte *map ) { map_ = map; }

    IIde_t Ide() {return ide_;} // To give a value to the actuel Image Identifier.

    GLint W() { return w_; }    // To get each Image field.
    GLint H() { return h_; }
    GLint P() { return p_; }
    GLint E() { return e_; }
    GLubyte * Map() { return map_; }


//
// Functions to write each image format.
//

    void Write_BMP( const char *, int = 0 );
    void Write_PNG( const char *, int = 0 );
    void Write_JPG( const char *, int = 0 );


};




#endif

//
// end of <PW-Id>.
//
