//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Slide Volume Manager module.
//
//


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>

#include "Text_Display.h"

#include "DiaViewer_VRFL.h"
#define _DIAVIEWER_V_UI_ENV_
#include "DiaViewer_V_MN.h"


//
// External function (defined in the GL module) used to update ...
// ... a volume name display when it is changed.
//


void UpdateGLWinVName( VolRef * );




//
// Extern variables.
//

int             vltb_wid    =      600, // Volume List window ...
                vltb_hig    =      250, // ... sizes.
                vltb_tsz    =       16, // Volume List Title font size ...
                vltb_esz    =       14; // and table element Font size.

static int      Exec_Flag   =        0, // Flag no parallel exec (1:def, 2:Ren. 3:ren).
                Exec_Step   =        0, // Keep the excution step number.
                ierr        =        0; // Error state.


extern   VolRefList    VolList; // The Known slide Volume list (memory anduser env. file).

static    int         Vz    =        0; // Size of the sorted Volume list, ...
static VolRef      ** Vs    =     NULL, // ... this sorted reference list ...
                    * Vr    =     NULL; // ... and the current volume reference.

static char            VolumePath[256], // The root directory of a slide Volume.
                        VolumeName[32]; // The related Slide Volume name.

static Vol_UI_1 * WinDef    =     NULL; // Specific pointer of Volume Define UI.
static Vol_UI_2 * WinRen    =     NULL; // Specific pointer of Volume Define UI.

static Text_Display * DspVol  =   NULL; // Pointer to the show window Volume.


//
// Our routines.
//

static void PathError( int ie, const char *s1 = NULL, const char *s2 = NULL )
{
    char          buffer[1024];
    int                     nc;
    const char * msgtb[] = {
        "Cannot open the specified path with read and write access :",
        "The specified path is included or includes that of another\nknown volume.",
        0
    };
    nc = snprintf( buffer, 1023, "DiaViewer Define Slide Volume Error :\n\%s\n", msgtb[ie-1] );
    if (s1) nc += snprintf( buffer+nc, 1023-nc, "  %s\n", s1 );
    if (s2) nc += snprintf( buffer+nc, 1023-nc, "  %s\n", s2 );

    WinDef->vd_msg->text( buffer );
//  fl_alert( buffer );
} // static void PAthError().



static void BusyError()
{
    fl_alert( "DiaViewer : A slide Volume definition window is already active." );
} // static void BusyError().



void VolMan_PathCheck( const char * path )
{
    int len = strlen( path );

    ierr &= ~1; // Erase the Path error bit.
    strncpy( VolumePath, path, 254 );
    WinDef->vd_path->value( VolumePath );
    if (!access( path, F_OK|R_OK|W_OK|X_OK )) {
        if (!VolList.CheckPath( path )) {
            if (VolumePath[len - 1] != DIR_SEPAR) {
                VolumePath[len++] = DIR_SEPAR; VolumePath[len] = 0;
            }
            WinDef->vd_msg->text( "Correct Pathname definition" );
        } else {
            if (Exec_Step > 0)
                PathError( 2, path );
            else {
                Exec_Step = 1;
                WinDef->vd_msg->text( "You need to modify the proposed path of the volume." );
            }
            ierr |= 1; // Set the Path error bit.
        }
   } else {
        PathError( 1, path, strerror( errno ) );
        ierr |= 1; // Set the Path error bit.
    }
//printf( " path = \"%s\", %d\n", VolumePath, ierr );
    if (!ierr) WinDef->vd_valid->activate();
          else WinDef->vd_valid->deactivate();
} // static int  VolMan_PathCheck().



void VolMan_PathBrow()
{
    char        * fnam;
    const char  * path;

    path = FSvSel.Dir( "DiaViewer: Select Slide Directory", VolumePath  );
    if (!path) return;
    VolMan_PathCheck( path );
    WinDef->vd_path->value( VolumePath );
//printf( " path = \"%s\", ierr = %d\n", VolumePath, ierr );
} // void VolMan_PathBrow().



void VolMan_VName( const char * vname, Fl_Text_Buffer * vdt, Fl_Input * vdn )
{
    static int         fmd = 0;
    int  len = strlen( vname );

    if (!len) { ierr |= 2; return; }
    strncpy( VolumeName, vname, 31 );
    if (len > 31 ) {
        vdt->text( "This volume name is too long (31 character max.)." );
        ierr |= 2;
        return;
    }
    if (VolList.CheckName( VolumeName )) {
        if (!fmd) {
            vdt->append( "This volume name is already in use: If you don't change it,\n" );
            vdt->append( "it will be made unique by adding the numeric ID to it.\n" );
            vdt->append( "Use the Enter key to see the modified name." );
            ierr |=  2; // Set the Vname error bit.
            fmd   =  1;
        } else {
            VolList.MakeUnique( VolumeName, 31 );
            vdt->text( "Here is suggested new name" );
            vdn->value( VolumeName );
            ierr &= ~2; // Erase the Vname error bit.
            fmd   =  0;
        }
    } else {
        vdt->text( "This slide volume name is unique" );
        ierr &= ~2; // Nom name error.
    }
    if (Exec_Flag == 3)
        if (!ierr) WinRen->vd_valid->activate();
              else WinRen->vd_valid->deactivate();
    else
        if (!ierr) WinDef->vd_valid->activate();
              else WinDef->vd_valid->deactivate();
} // void VolMan_VName().



static void VolListExit_cb( void * cntx ) {
    vltb_wid = DspVol->DspW();
    vltb_hig = DspVol->DspH();
    DspVol = NULL;
    if (!(WinDef||WinRen)) Exec_Flag = 0;
}



void VolMan_DefSet()
{
    VolRef * ref;

    if (!ierr) { // When no error.
        if (!strlen( VolumeName )) VolList.MakeUnique( VolumeName, 62 );
        ref = VolList.Insert( VolumePath, VolumeName );
        LogF.Write( "Define the new Slide Volume %s : ID = %02d with the path\n\t\"%s\"",
                    ref->name, ref->iide, ref->path );
//      printf( "Define the new Slide Volume %s : ID = %02d with the path\n\t\"%s\"",
//              ref->name, ref->iide, ref->path );

        if (DspVol) DspVol->Exit();
        WinDef->Close();
        WinDef = NULL;
        Exec_Flag = 0;
    }
} // void VolMan_DefSet().



static void Remove();
static void Rename();


static void MouseCallBack( int bt, int row, int col, void * own )
{
    // Use only the raw.
    if (row >= 0 && row < Vz) {
        Vr = Vs[row];
        switch (Exec_Flag) {
            case 1:  { DspVol->ViewSelect( Vr->name ); break; }
            case 2:  { Remove(); DspVol->Exit(); break; }
            case 3:  { Rename(); DspVol->Exit(); break; }
            default: { Exec_Flag = -1; break; } // All VolMN_Ref.
        }
    }
} // static void CallBackMouse( int bt, int row, void * own ).



static
int  VolDisplay( const char * tit,              // Window label, buttons labels ...
                 const char * slb     =   NULL, // ... for Select, ...
                 const char * vlb     =   NULL, // ... for Valid, ...
                 TxtDsp_cb_t  cbv     =   NULL, // ... callBack functions for Valid ...
                 TxtDsp_Mouse_cb_t cbm =  NULL, // ... and mouse selection ...
                 VolMnf_t   opf = VolMnf_VList  // ... 0/1/2 for ref/Open/Open+Mem.
               )
{
    VolRef        * rf;
    int ii, jj, sn, sp, sz;
    const char * Msg;
    char ch;

    Vs = VolList.SortVList( Vz, sn, sp, opf );

    if (!Vz) {
        switch (opf) {
            case VolMnf_VList:  // List of all defined slide volumes ...
            case VolMnf_Rename: // ... or that can be renamed.
                break;
            case VolMnf_ToOpen: // List of all defined not open slide volumes (to open).
                Msg = "All known Slide Volumes are already open.";
                break;
            case VolMnf_Open:   // List of open slide volumes (except memory ones) (to close).
                Msg = "No Slide volume is open.";
               break;
            case VolMnf_SOpen:  // List of open slide volumes including memory ones (to select).
                Msg = "NO Slide Volume can be selected for display";
                break;
        }
        fl_message( "DiaViewer : %s\n\tWe have nothing to do!", Msg );
        return -1;         // Nolist to display and Nothing to do.
    }

    DspVol = Text_Display::Init( vltb_wid, vltb_hig,
                                 "DiaViewer Slide Volumes Display",
                                 "DiaViewer_Volume_list.txt", NULL );
    DspVol->SetTitleFont( FL_HELVETICA, vltb_tsz );
    DspVol->SetTitle( tit );
    DspVol->SetFont( FL_COURIER, vltb_esz );

    DspVol->SetCallBackExit( (TxtDsp_cb_t)VolListExit_cb );

    if (cbv) DspVol->SetValidMode( slb, vlb, cbv );
        else DspVol->SetValidMode();
    if (cbm) DspVol->SetCallBackMouse( cbm );

    DspVol->SetExitLabel( "&Quit" );

    if (opf != VolMnf_VList)
        DspVol->Append( "To select a volume click on the corresponding line.\n\%s\n\n",
                        "To give up, click on Quit." );

    if (sn < 12) sn = 12;
    DspVol->Append( "%*s  ID Open    Related path\n", sn, "Volume Names" );
    DspVol->SetOrigine();

    ii = 0;
    while (ii < Vz) {
        rf = Vs[ii++];
        if (rf->volm) {
            if (rf->volm->FlgTst(Context_RankOn))      ch = 'R';
            else if (rf->volm->FlgTst(Context_VRkMap)) ch = 'M';
                                                  else ch = 'O';
        } else ch = ' ';
        DspVol->Append( "%*s  %02d   %1c  : %s\n",
                        sn, rf->name, rf->iide, ch, rf->path );
    }
    DspVol->append( "\n" );
    if ((Vz==1)&&(opf!=VolMnf_VList))
        DspVol->Append( " ** Only one slide volume can be selected. **\n" );

    DspVol->Show();
    return Vz;
} // int  VolDisplay( consqt char tit, const char * slb, const char * vlb,
  //                  TxtDsp_cb_t cbv, TxtDsp_Mouse_cb_t cbm ).



VolRef * VolMN_Ref( const char * tit, VolMnf_t opf )
{
    int nc = 0;

    if (Exec_Flag) { BusyError(); return NULL; }

    Exec_Flag = 4;
    nc = VolDisplay( tit, NULL, NULL, NULL, (TxtDsp_Mouse_cb_t)MouseCallBack, opf );
    if (nc > 0 || opf == VolMnf_VList) {
        while (Exec_Flag >= 0) Fl::wait();
        DspVol->Exit();
    } else  Vr = NULL;

    Exec_Flag = 0;
    return Vr;
} // VolRef * VolMN_Ref( const char * tit ).



void VolMan_VList()
{
    VolDisplay("List of Kwown Slide Volumes"); // Button labels for Select and Valid,
} // void VolMan_VList().




void VolMan_DefQuit()
{
    if (DspVol) DspVol->Exit();
    WinDef->Close();
    WinDef = NULL;
    Exec_Flag = 0;
} // void VolMan_DefQuit().



void VolMN_Define( const char * pa, const char * nm )
{
    const char  * path;

    if (Exec_Flag) { BusyError(); return; }

    // OK to execute.
    Exec_Flag   =    1;
    ierr        =    3; // Set all error bits to force the change.;

    if (pa&&pa[0]) strcpy( VolumePath, pa );
    if (nm&&nm[0]) strcpy( VolumeName, nm );
    WinDef = new Vol_UI_1( 560, 350, "DiaViewer : Define a new Slide Volume" );
    path = (OpenVolPath&&OpenVolPath[0])? OpenVolPath : User_Dir;
    strncpy( VolumePath, path, 255 );
    WinDef->vd_path->value( VolumePath );
    WinDef->vd_valid->deactivate();
    WinDef->vd_msg->text( "When you modify the path, end it with the Enter Key." );
    WinDef->Show();
} // void VolMN_Define().



void VolMN_StartDef()
{
    const char  * path;

    if (Exec_Flag) { BusyError(); return; }

    // OK to execute.
    Exec_Flag   =    1;
    ierr        =    3; // Set all error bits to force the change.

    WinDef = new Vol_UI_1( 800, 400, "DiaViewer : Define your first Slide Volume" );

    path = (OpenVolPath&&OpenVolPath[0])? OpenVolPath : User_Dir;
    strcpy( VolumeName, "Slide_Volume_01" );
    strncpy( VolumePath, path, 255 );
    WinDef->vd_path->value( VolumePath );
    WinDef->vd_valid->deactivate();
    WinDef->vd_msg->text( "\tTo use DiaViewer, you must specify where are located yours slides (or photographs). To do this, enter\n" );
    WinDef->vd_msg->append( "the folder path where DiaViewer can find your pictures. This root folder can contain an indeterminate\n" );
    WinDef->vd_msg->append( "number of this of subfolders that contain your photos and thus form a tree structure. This tree structure\n" );
    WinDef->vd_msg->append( "forms a DiaViewer \"Slide Volume\". The tree structures of the different \"Slide Volumes\" of that you\n" );
    WinDef->vd_msg->append( "will have to define must not overlap and are associated with a name of their own.\n\n" );

    WinDef->vd_msg->append( "\tWhen you have entered the path of the root folder and the name of your first \"Slide Volume\", validate\n" );
    WinDef->vd_msg->append( "it, then it will be automatically opened.\n" );

    WinDef->Show();

    while (Exec_Flag > 0) Fl::wait();
} // void VolMN_StartDef().



static void Remove()
{
    if (Vr&&Vr->volm) {
        fl_alert( "DiaViewer : The slide volume %s is opened.\n\t%s \n",
                  Vr->name, "if that's really what you want, you have to close it first." );
    } else {
        if (!fl_choice( "please confirm deletion of %s\n\t%s %s\n\t%s %s\n\n", "&Yes", "&No", NULL,
                        "slide volume reference :", "path = ", Vr->path,
                        "name = ", Vr->name )) VolList.Remove( Vr );
    }
    ierr          =  0; // Clear all error bits.
} // static void Remove().


/*
void VolDisplay( const char * tit,                   // Window label, buttons labels ...
                 const char * slb, const char * vlb, // ... for Select and Valid, ...
                 TxtDsp_cb_t  cbv, int fcl )         // ... callBack functions for valid ...
*/
void VolMN_Remove()
{
    int nc = 0;

    if (Exec_Flag) { BusyError(); return; }

    Exec_Flag = 2;
    nc = VolDisplay( "Select the Volume to remove from this list",
                     NULL, NULL, NULL, (TxtDsp_Mouse_cb_t)MouseCallBack, VolMnf_ToOpen );
    if (nc > 0) {
        while (Exec_Flag >= 0) Fl::wait();
        DspVol->Exit();
    } else {
        Vr = NULL;
        Exec_Flag = 0;
    }
    return;

//  Vr = VolMN_Ref( "Select the Volume to remove from this list", VolMnf_ToOpen );

} // void VolMN_Remove().



void VolMan_RenQuit()
{
    if (DspVol) DspVol->Exit();
    WinRen->Close();
    Exec_Flag = 0;
    ierr = 0;
}




void VolMan_RenSet()
{
    if (ierr) { Exec_Flag = 0; return; }
    if (VolumeName[0]) {
        if (Vr->name) delete[] Vr->name;
        Vr->name = strdup( VolumeName );
        UpdateGLWinVName( Vr );
        VolList.Write();        // Update the Known Volume list (on disk).
    }
    if (DspVol) DspVol->Exit();
    WinRen->Close();
    Exec_Flag = 0;
}


static void Rename()
{
    char bf[292];

    if (Vr) {
        ierr = 0;
        strncpy( VolumeName, Vr->name, 31 );
        snprintf( bf, 291, "%s  (%02d) path = %s", Vr->name, Vr->iide, Vr->path );
        WinRen = new Vol_UI_2( 540, 220, "DiaViewer : Rename a Slide Volume" );
        WinRen->vd_onam->value( bf );
        WinRen->vd_nnam->value( VolumeName );
        WinRen->vd_msg->text( "When you enter a new volume name, end it with the Enter Key." );
        WinRen->vd_valid->deactivate();
        WinRen->Show();
    }
} //static void Rename().



void VolMN_Rename( VolRef * rf )
{
    int     nc;

    ierr        =    0; // Clear all error bits.
    if (Exec_Flag) { BusyError(); return; }

    // OK to execute.
    Exec_Flag = 3;

    if (rf)  {
        Vr = rf;
        Rename();
    } else {
        Vr = NULL;
        nc = VolDisplay( "Select slide Volume to rename ",
                         NULL, NULL, NULL, (TxtDsp_Mouse_cb_t)MouseCallBack, VolMnf_Rename );
        switch (nc) {
            case  1: Vr = Vs[0]; Rename(); break;
            case -1: Exec_Flag = 0; break;
            default: ;
        }
    }
} // void VolMN_Rename().




//
// end of <PW-Id>.
//
