//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Module for slide Preview environment.
//



#ifndef DiaViewer_PRV_h
#define DiaViewer_PRV_h

#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Multiline_Input.H>

#include "DiaViewer_GL.h"



class SliT_Display : public Fl_Multiline_Input {
private:
    int font, size;

    virtual void draw();

public:
    SliT_Display( int, int, int, int, const char * = 0 );

};

/*
class Image_Display: public Fl_Widget {
private:
    Fl_Image * w_img_;

public:
  Image_Display( int x, int y, int w, int h, const char * L = 0)
  : Fl_Widget( x, y, w, h, L ) { w_img_ = 0; }


};
*/


class Viewer : public Fl_Gl_Window {


protected:
    int handle( int );
    void draw();

};




class Prv_View {
public:

  typedef enum {
    Image_Up      =  1,
    Image_Left    =  2,
    Image_Center  =  4,

    Image_C_Up    = Image_Center|Image_Up,
    Image_C_Left  = Image_Center|Image_Up|Image_Left,
    Image_C_Down  = Image_Center|Image_Left,
    Image_C_Right = Image_Center
  } Image_Position;


private:
  Fl_Double_Window     * W_win; // The preview window.
  Fl_Group             * W_grp; // The Print widget group.
  Fl_Box               * W_img; // The Image display widget.
  SliT_Display         * W_txt; // The Related Text display.

  float               txt_prp_; // Minimum surface in fraction of device surface for text.
  int                  margin_, // Margin to reserve between image and text.
        g_w_, g_h_, p_w_, p_h_, // The final output device (as paper) sizes.
                    i_w_, i_h_, // The image sizes iriginal pixels.
        eix_, eiy_, eiw_, eih_, // The effective position and sizes of image on output device.
        tx1_, ty1_, tw1_, th1_, // The first zone of text and ...
        tx2_, ty2_, tw2_, th2_; // ... the second one (notused on Centred mode).

  VolEntry           * curvol_;
  SliEntry           * cursli_;
  Fl_RGB_Image       * curimg_;
  Image_Position       imgpos_;
  float                txtprp_;
  char               * curtxt_;
  int       nt_, ch_, fl_, sn_;

  int                  txtchg_;


  Fl_RGB_Image * BuildImage( Image_REF *, int, int, int, int );


  void Ini_Setup();
  void Load( DiaViewer_GL * );
  void LoadImage( Fl_RGB_Image * );
  void SliTextprc( float prc = 0.05 ) { txtprp_ = prc; }
  void SliTextMrg( int mrg ) { margin_ = mrg; }

  int  FitTextSpace();

  virtual void draw();

public:
  Prv_View( DiaViewer_GL * );
  void Geometry();

  void GiveUp();
  void ToPrint();
  void ChangeFont();

  void SliImagePos( Image_Position );

  static int Show_PreView( DiaViewer_GL * );

};

#endif



//
// end of <PW-Id>.
//
