//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage a slide collection
// DCM = DiaViewer Collection Management.
//

#include <clocale>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <string.h>

#include <setjmp.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>         // To manipulate utf8 strings.

#include "Service_DIR.h"
#include "SetUpMan.h"

#include "Service_Util.h"
#include "Service_IO.h"

#include "DiaViewer_GBL.h"
#include "DiaViewer_DIA.h"
// #include "DiaViewer_DCM.h"
#include "DiaViewer_PRG.h"
#include "DiaViewer_MVL.h"
#include "DiaViewer_VRFL.h"
#include "DiaViewer_V_MN.h"


#include "DiaViewer_DCM_NEW.h"



// Define the increment(step) to allocate (or extend) a dynamic table of item.
#define TABLE_ALLOC_STEP     16

// Define the limit table length to select the quick sort process.
#define QSORT_LIMIT           8


// Macro used to compare two item name (form sorting process).
#define ITM_NAME_CMP( id1, id2 ) fl_utf_strcasecmp( id1, id2 )



const char * FileExtList[] = {
  "cntxdat",    // Context file extension.
  "jpeg",       // Standard JPEG images.
  "jpg",        // Current shortest form for JPEG.
  "png",        // Standard PNG images.
  "bmp",        // Old Standard Bit Map format.
  0             // Mark the end extension list.
};



typedef struct {
  const char * name_;                   // The name of object (File or Directory);
  int   OwnDir;                         // Relative stack index of directory owner.
} ItmName;


static int CurrDirST = -1,              // Index of last Directory entry in the stack.
           DirCount  =  0,
           SliCount  =  0;

/*
ItmName     * DirSP,   * SliSP;         // Define the stack pointers for Slides and directories.


// Define the two (slides and directory) Stacks.
static Any_STK_L( ItmName, SliStk, SliSP );
static Any_STK_L( ItmName, DirStk, DirSP );     // ... and for the directories.
*/


//
// Simple functions used to perform the sslides and directory sorting.
//

static void ItemSimplSort( ItmName * tb, int min, int max )
{
  int       jj;
  ItmName   id;

  for(int ii=min+1; ii<=max; ii++) {
    id = tb[ii];
    jj = ii - 1;
    while ((jj >= min) && (ITM_NAME_CMP( tb[jj].name_, id.name_ ) >=0)) {
      tb[jj+1] = tb[jj];
      jj--;
    }
    tb[jj+1] = id;
  }
} // static void ItemSimplSort( ItmName *tb, int min, int max ).



static void ItemQuickSort( ItmName *tb, int min, int max )
// Perform a Quick sort.
{
  int        ic,    ip;
  ItmName    pi,    tm;

  if (min>=max) return;

  ip = (min + max)/2;   // Get the middle Sort table index ...
  pi =        tb[ip];   // ... as the pivot.

  tb[ip] = tb[min];     // Put the pivot item in first position.
  tb[min] = pi;         //

  ic = min;             //
  for(int ii = min; ii <= max; ii++) {
    // Loop on all entries.
    if (ITM_NAME_CMP( tb[ii].name_, pi.name_ ) < 0) {
      if (ii != ++ic) {
        // When the entry are differents, we exchange them.
        tm = tb[ii]; tb[ii] = tb[ic]; tb[ic] = tm;
      }
    }
  }
  // Put the middle entry to its right place.
  tm = tb[ic]; tb[ic] = tb[min]; tb[min] = tm;

  if (ic-min<QSORT_LIMIT) ItemSimplSort( tb, min, ic-1 );
  else ItemQuickSort( tb, min, ic-1 );
  if (max-ic<QSORT_LIMIT) ItemSimplSort( tb, ic+1, max );
  else ItemQuickSort( tb, ic+1, max );
} // static void ItemQuickSort( ItmName *tb, int min, int max ).



//
// Define the SliScan members to fill the stacks :
//

int SliScan::ErrMan( int nk, const char * msg ) {

    return 0;
} // int SliScan::ErrorMan( int nk, const char * msg ).



int  SliScan::StartDir( const char * nm ) {

    PushDir();
    if (tpstk_) {  tpstk_->dnm_ = strdup( nm ); tpstk_->nsl_ = 0; }
    else return -2;

    if (bldsc_) {

    }
    return 0;
} // int  SliScan::StartDir( const char * nm ).



int  SliScan::EndDir( int ndi, int nsl ) {
    char * dn;
    int    ns;

    if (dissp_ >= 0) {
        dn = tpstk_->dnm_;
        ns = tpstk_->nsl_;
        dissp_--; tpstk_--;
    } else return -2;


    if (bldsc_) {

    }



    totdi_ += ndi + 1;
    totsl_ += nsl;


    return 0;
} // int  SliScan::EndDir( int nsl, ndi ).



int  SliScan::SelFile( int nk, const char * nm ) {
    Item itm;

    itm.nam_ = strdup( nm );
    itm.row_ = nk;
    stk_.Push( itm );

    return 0;
} // int  SliScan::SelFile( int nk, const char * nm ).





SliScan::SliScan() {

//  Zero();                                     // Init the object.

//  SliScan.ErrHdl( NULL );                  // We use specific virtual function
//  SliScan.Setup( NULL, NULL, NULL );

    // We use the default filter on the file extensions.
    SetFltExt( (SrvDir::FTypLst)FileExtList );
    SetFlg( Dir_NCase );             // Character case indifferent for file extension.



//    Scan(  );

} // SliScan::SliScan() : SrvDir().



SliScan::~SliScan() {



//  TreeBldSrc.ErrHdl( NULL );                  // We use specific virtual function
//  Setup( NULL, NULL, NULL );

    // We use the default filetr on the file extensions.

} // SliScan::~DiaTree().





int  SliScan::AnalyseTree( const char * db )
{
    int ie = 0;

    Zero();



//  ie = LdPath.Scan( db );

    return ie;
} // void SliScan::AnalyseTree( const char *, int ).



//Any_STK_F( , DirStack, TreeStkTab, dit)


VolEntry * SliScan::BuildVolume( const char * dnam ) {

    // We use the default filetr on the file extensions.
//  TreeBldSrc.SetFltExt( (SrvDir::FTypLst)FileExtList );
//  TreeBldSrc.SetFlg( Dir_NCase );             // Character case indifferent for file extension.



//  TreeBldSrc.Scan( dnam );

    return 0;
} // VolEntry * SliScan::BuildVolume( const char * dnam ).





//
// Each diapositive/slide is identified by a unique IIde_t integer.
// This identifier include three part. The volume identifier number,
// the directory identifier number (in the volume) and the slide identifier
// unique in the volume. The three field in the IIde_t identifier can be 
// defined by a definition as :
// #define LARGE_UNI_IDENT
// to have a 64 bits identifier type (the default is 32 bits), and by
// #define UNIQUE_IDE_FIELDS {<sld>,<dir>}
// For example, for 32 bits identifiers:
// #define  UNIQUE_IDE_FIELDS {16,10}
// while by used to get a slide field of 16 bits and a directories field of 10 bits,
// that keep 6 bits (32 - 16 - 10 = 6) for the volume. With this, you can have a
// maximum of 2**16-1 = 65535 slides in each directory, 2**10-1 = 1023 directories
// in each volume and 2**(32-16-10)-1 = 64 volumes. The default 32 bits IIde Identifier
// is defined at the compilation time but the UNIQUE_IDE_FIELDS is keep in the user's
// local data context and can be changed when the DiaViewer software is restarted and
// it should be possible to change these field sizes by using the setup menu in some
// future versions.
// The default fields size values are :
//    #define UNIQUE_IDE_FIELDS {14,10} in 32 bits that allows
//           16,383 slides in each directory,
//             1023 directories in each volume and
//              255 opened volumes.
//
//    #define UNIQUE_IDE_FIELDS {32,16} in 64 bits that allows
//    4,294,967,297 slides in each directory,
//           65,535 directories in each volume and
//           65,535 opened volumes.
//
// The default DiaViewer software generation is with Unique Identifiers of 32 bits.
//
//




extern   VolRefList    VolList; // The Known slide Volume list (memory and user env. file).


static VarString         V1Str, // Variable Strings used as temporary strings.
                         V2Str;



//
// Volume List file input/output Read and Write.
//



static sigjmp_buf       JmpBuf; // Buffer for long jump on I/O context error.



//
// Our Task'Global Variables Definitions (public).
//
const char  DirSep  =   DIRSEP; // Separator to use between files and directories for our OS.


//
// Global variables.
//


VolEntry  * IniSelVolum = NULL; // Selected volume pointer.
SliEntry  * IniSelSlide = NULL; // Initial selected Slide pointer.


//
// Our module specific Variables Definitions (private).
//

static FilePath       CurrPath; // To keep the current path During the construction of volume tree.

/*
static int    max_nbdir =    0, // Maximul number of Sub-Directories in a Directory.
              max_nbsli =    0; // Maximum number of slides in a Directory.
*/

static int    curr_deep =    0, // Current directory deep from the base directory.
              curr_tsli =    0, // Current total numbers of slides and subdirectories.
              curr_tdir =    0,
              maxi_deep =    0, // Maximum directory deep.
              deep_error   = 0; // Slide Volume overlay error flag.

/// static char * CFilePath = NULL; // Config File Path (when found).

/// static FILE *             cfgf; // Configuration file.



#define PRT( f, v ) printf( f, v ); fflush( stdout )

//
// Entry type defined to directory entries.
//

typedef void * Entry;

typedef struct { // Define the table of table (for sorting).
    int    use,  // Used size.
           all;  // Allocated size.
    Entry *tab;  // The table of name.
} EntryTable;

static int DirFlg = 0; // for sorting directories/slides entries.



//
// Some routines.
//
/*
static void ErrorCatch( int ierr )
{
    siglongjmp( JmpBuf, ierr );
} // void ErrorCatch( int ierr ).

*/





//
// end of <PW-Id>.
//
