//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Module for a View (Image and or text) environment.
//


#ifndef VIEW_WIN_GL_H
#define VIEW_WIN_GL_H


#include <FL/Fl.H>
#include <FL/gl.h>
#include <GL/glu.h>
#include <FL/Fl_Box.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Gl_Window.H>

#include "ImageMan_REF.h"

#include "View_GL.h"

#include "View_GL_UI.h"



class View_Win;

class View_GL_UI;



class View_Win : public Fl_Gl_Window {
friend View_GL;

public:

typedef struct {
    const char  * name; // Format label.
    const float  y_s_x; // Format ratio.
} Format;


/*  typedef struct {
        const char  * Fnam;
        float    dy_div_dx;
    } PageFormats;
*/

    typedef enum {
        Img_Undef       =    0,
        Img_Valid       =    1,
        Img_Up          =    2,
        Img_Left        =    4,
        Img_Center      =    8,

        Img_UpLeft      = Img_Valid|Img_Up|Img_Left,    // Corner Up-Left
        Img_UpRight     = Img_Valid|Img_Up,             // Corner UP_Right or (Up and no Left)
        Img_DownRight   = Img_Valid,                    // Corner Down-Right or (no Up and no Left).
        Img_DownLeft    = Img_Valid|Img_Left,           // Corner Down-Left.

        Img_C_Left      = Img_Valid|Img_Center|Img_Up|Img_Left,
        Img_C_Up        = Img_Valid|Img_Center|Img_Up,
        Img_C_Right     = Img_Valid|Img_Center,
        Img_C_Down      = Img_Valid|Img_Center|Img_Left
    } ImgGeo;


    static constexpr const char * FormTab[3] = {
    };


    typedef void (View_Cb)(int);

private:
    View_GL_UI       * View_UI; // Link to the User Interface.


    Fl_Double_Window *   W_win; // Pointer to the main window of View.

    Format           * frmtab_; // List of available page formats.
    View_Cb          * evfunc_; // Call back function to return info.
    ImgGeo           geometry_; // The selev=cted Geometry.
    float             txt_img_; // Ratio for text display on the total surface.
    int                format_, // Format Number.
                       vfsize_; // Used font size.
    char             * vfname_, // Used font name.
                     * vtitle_, // Used image title.
                     * vitext_; // Image text.
    Fl_RGB_Image    * rgb_img_; // Image map.

    int         Win_Init  =  1; // Flag to init at the first call of draw().
//  int         Win_UInb  =  0, // Index of UI in the Viewer_UI table.
//              Win_UFnb  =  0, // Index of UI/GL of the father Viewer during new Viewer creation.
//              Win_Start =  0; // Flag for windows creation at DiaViewer start time.



    void MouseDown( int, int, int );
    void MouseDrag( int, int, int );
    void MouseUp(   int, int, int );
    void XYinImage(  int &, int & );

    void Viewer_Init();

    Fl_RGB_Image * BuildImage( Image_REF *, GLint, GLint, GLint, GLint hh );


public:
    View_Win( int, int, int, int, const char * = 0 );



    void Callback( View_Cb cb ) { evfunc_ = cb; }

    void Sizes( int, int );             // To set new Window sizes.

    int  w() { return w_winw; }         // To get current window sizes.
    int  h() { return w_winh; }
    void Font( const char *, int );     // To set the initial font choice.
    void Config( ImgGeo p ){ geometry_ = p; }             // To set initial display Geometry configuration.
    void Text( const char * t )
            { vitext_ = (t && t[0]) ? strdup( t ) : 0; }  // To set the Text/comment of image.
    void Title( const char * l )
            { vtitle_ = (l && l[0]) ? strdup( l ) : 0; }  // To set a new title (replace the Init label).

    ImgGeo Config() { return geometry_; }                 // To get the current display geometry.
    const char * Font() { return vfname_; }               // To get the used font.
    int FontSize() { return vfsize_; }                    // To get the font size.
    const char * Title() { return vtitle_; }              // To get the Title.
    const char * Text() { return vitext_; }               // To get the image related text.

    void PageFormat();
    void ChangeFont();

    const char * WinSizes( int &w, int &h )  {  w = w_winw; h = w_winh; } // To get the Main Window sizes.

    void Image( Image_REF *, GLint, GLint, GLint, GLint );  // To set the image to display (can be zoomed).

    void Set_Geometry();

    void Quit();
    void ToPrint();

    void Show( int, char ** );

protected:

    int  handle( int );

    void draw();

}; // class View_Win.



#endif


//
// end of <PW-Id>.
//
