
//
// To be include in View_GL.
//

#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Return_Button.H>

#include "View_GL.h"


View_GL::Formats flst[] = {
  //       name        h/w (in landscape).
    { "Printer  A",   0.7071 }, // As A5, A4, A3 ...
    { "Photos 2\\/3",   0.6666 }, // as photo paper 10 x 15 cm.
    { "Photos 3\\/4",   0.7500 }, // Warning: You cannot use the '/' character ...
    { "Screen 9\\/16",  0.5625 }, // ... that is used to create multiple menu item.
//  { "Your format",  0.0    },
    0
};



//typedef void (View_Cb)(int);        // Define the View callback function type.


static Fl_Double_Window  * vfw;
static Fl_Choice         * vfc;
static Fl_Round_Button   * vfl;
static Fl_Round_Button   * vfp;
static Fl_Return_Button  * vfr;

static int             idx = 1;

static View_GL::View_Cb  * rcb;


void vfw_cb( Fl_Widget * o, void * v ) { delete vfw; }
void vfc_cb( Fl_Widget * o, void * v ) {
    idx = (int)(fl_intptr_t)v;
    printf( "Sel %d\n", idx ); }
void vfl_cb( Fl_Widget * o, void * v ) { vfp->value( 1 - vfl->value() ); }
void vfp_cb( Fl_Widget * o, void * v ) { vfl->value( 1 - vfp->value() ); }
void vfr_cb( Fl_Widget * o, void * v ) { rcb( idx ); /* delete vfw; */ }



void ViewCBFormat( View_GL::View_Cb * f ) { rcb = f; }

void ViewSetFormat( View_GL::Formats * flst, int largc, char ** largv )
{
    char * n = 0;

    vfw = new Fl_Double_Window( 280, 95, "Format Selection" );
        vfc = new Fl_Choice( 5, 5, 160, 25 );
        while (flst&&flst->name) {
            vfc->add( (flst++)->name, 0, vfc_cb, (void*)(++n) );
//          printf( "name = \"%s\", v= %d\n", flst[-1].name, n );
        }
        vfc->value( idx - 1 );
        vfc->callback( vfc_cb );
        vfc->when( FL_RELEASE|FL_WHEN_CHANGED );
        vfl = new Fl_Round_Button( 175,  6, 95, 20, "Landscape" );
        vfl->down_box( FL_ROUND_DOWN_BOX );
        vfl->value( 1 );
        vfl->callback( vfl_cb );
        vfp = new Fl_Round_Button( 175, 25, 95, 20, "Portrait" );
        vfp->down_box( FL_ROUND_DOWN_BOX );
        vfp->value( 0 );
        vfp->callback( vfp_cb );
        vfr = new Fl_Return_Button( 180, 60, 92, 25, "Select" );
        vfr->labelfont( FL_HELVETICA_BOLD );
        vfr->labelsize( 18 );
        vfr->callback( vfr_cb );
    vfw->end();
    vfw->callback( vfw_cb );
    vfw->end();
    vfw->show( argc, argv );

} // ViewSetFormat( View_GL::Formats * flst ).




void OurCB( int idx ) { printf( " %d : %s is your choice.\n", idx, flst[idx-1].name ); }

int main( int argc, char ** argv )
{
    ViewCBFormat( OurCB );
    ViewSetFormat( flst, argc, argv );

    Fl::run();

    return 0;
}

