
#include <stdio.h>
#include <string.h>

#include <FL/Fl.H>

#include "View_GL.h"

#include "Get_Format.h"



View_GL::Formats flst[] = {
  //       name        h/w (in landscape).
    { "Printer  A",   0.7071 }, // As A5, A4, A3 ...
    { "Photos 2/3",   0.6666 }, // as photo paper 10 x 15 cm.
    { "Photos 3/4",   0.7500 },
    { "Screen 16/9",  0.5625 },
//  { "Your format",  0.0    },
    0
};



Get_Format * Frm;

float R;

void ChangeFormat_CB( int laf, int idf )
{
    printf( " Change format %d %d\n", laf, idf );
    if (idf >= 0) {
        float r =  flst[idf-1].ratio;
        if (r > 0.1) { R = laf ? r : 1.0/r; }

        printf( " Selected format %s : R = %F\n", R );
    } else delete Frm;
} // void ChangeFormat_CB( int laf, int idf ).





int main( int argc, char ** argv ){

    Frm = new Get_Format( flst );
    Frm->Show( argc, argv );

    Fl::run();

    return 0;

}
