//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to a sort a list of user defined record (struct or class).
// the string are always in UTF8.
// Service_Sort environment module.
//


#ifndef SERVICE_SORT_H
#define SERVICE_SORT_H

//
// Exemple d'usage :
//

/* Example :
 *      We have a class Word with a method Word::Name( Word * p ) to acceed to string of Words objects.
 *      WE use SrvSort to sort a Word list.
 *
 *      class Word {
 *      public:
 *          Word();
 *          ....
 *          const char * Name( Word * p );      // To get the name of word object pointer p.
 *          ...
 *          static Word * Read();               // We suppose two functions to read and write each word.
 *          static void Write( Word * p );
 *          ...
 *      };
 *
 *
 *      AnySort<Word>     wsort();              // To create the World sort object ...
 *      Word                  * p;              // ... and a pointer of World object;
 *
 *      while (p = World::Read()) {             // Loop to read all Words from a file until EOF.
 *          wsort.NewEntry( p );                // Put the Word object in the List to Sort.
 *      }
 *
 *      wsort.Sort();                           // Sort the Words list.
 *
 *      for( int i = 0; i < wsort.Size(), i++) {// Loop to write the sorted list of Words objects.
 *          World::Write( GetEntry( i ) );
 *      }
 *
 *  You can examine also the test programme at the end of source of Service_Sort.cxx module.
 *
 *
 *
 *   The special functions void Push() and int Pop() can be used to use the same SrvSort (or AnySort)
 *   to create new list of same nature in the same stack list of Entry :
 *
 * Example :
 *      AnySort  msort();
 *
 *          msort.NewEntry ( e_a01 );   // Fill the first list.
 *          ...
 *          msort.NewEntry ( e_a46 );
 *
 *      msort.Push();                   // Create a other list.
 *
 *          msort.NewEntry ( e_b01 );
 *          ...
 *          msort.NewEntry ( e_b76 );   // Here the msort.NewEntry returned value ( == to msort.Size() ) ...
 *                                      // ... is 76.
 *
 *          msort.Sort():
 *
 *          ...                         // Use GetEntry( i ) // GetEntry with 0 <= i < msort.Size()
 *
 *      msort.Pop();                    // Return to the first list and th msort.size() value ...
 *                                      // ... 46 (last entry was e_a46).
 *          msort.NewEntry( e_a_47 );   // We can complete the first list ...
 *
 *          msort();                    // .. and Sort it before use it.
 *
 *
 *      The function Clean() can be used to erase the top entry list. Aftre its call ...
 *      the sort list is exactly in the same state that before the first NewEntry() call ...
 *      or the after last Push() and then Size() will return 0. But the memory used is not free.
 *
 *      On the contrary, the call of function Zero() free all SrvSort stack table which will then
 *      be in the same state as just after its creation. The SrvSort/AnySort can then be reused.
 *
 *
 */


class SrvSort {
public:
    // Define the prototyp of callback to get the name (used for sorting) of an entry.
    typedef const char * (*enm_t) ( void * );
    typedef    void   * ent_t_; // Internal definition of an Entry.

private:
    enm_t                 enm_; // Function to call to get the entry name.

    int                   inc_, // Increment use for table extension.
                          all_, // Allocate size of the table
                          use_, // Used size of the table.
                          bas_, // Base of index ( == 0 before the first call of Push(). )
                          top_; // The top of partiel list - after the last PUsh.
    ent_t_              * tab_; // Pointer of the entries table.

    union { void * p;
            int    i;   } cpv_; // Used to set an integer value in the stack list tab_.

    int  CmpName( int, ent_t_ );
    void SimplSort( int, int );
    void QuickSort( int, int );

    inline int  Cpi( void * p ) { cpv_.p = p; return cpv_.i; }
    inline void * Cip( int i ) { cpv_.p = 0; cpv_.i = i; return cpv_.p; }

    void Fatal();

protected:
    virtual inline const char * EName( void * p ) { if (enm_) return enm_( p ); else Fatal(); }

public:
    SrvSort( int = 0, enm_t = 0 );

    ~SrvSort() { delete[] tab_; }

    int  Size() { return top_; }

    void Push() { NewEntry( Cip( bas_ ) ); bas_ = use_ ; top_ = 0; }
    int  Pop() { if (bas_) { use_ = --bas_; bas_ = Cpi( tab_[use_] ); top_ = use_ - bas_; } else return 0; }

    void Sort();

    int  NewEntry( ent_t_ );    // Function to append a new entry in the table.
    void * GetEntry( int i ) { return (i >= 0 && i < top_) ? tab_[i + bas_] : 0; }

    void Clean() { use_ -= top_; top_ = 0; }
    void Zero() { delete[] tab_; tab_ = 0; bas_ = top_ = use_ = all_ = 0; }


}; // class SrvSort.



template <typename T>
class AnySort : public SrvSort {
public:
    AnySort( int inc = 0 ) : SrvSort( inc ) { }

    inline const char * EName( ent_t_ p ) { return ((T *)p)->Name(); }
    inline int NewEntry( T *p ) { return SrvSort::NewEntry( (void*)p ); }
    inline T * GetEntry( int i ) { return (T*)SrvSort::GetEntry( i ); }

    inline T ** GetTable() { return (T **)(tab_ + bas_); }

    inline int  Size() { return SrvSort::Size(); }
    inline void Sort() { SrvSort::Sort(); }
}; // class AnySort.E



#endif





//
// end of <PW-Id>.
//
